/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v4.1.0/LICENSE.txt
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.maplibregl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var maplibregl = {};
var modules = {};
function define(moduleName, _dependencies, moduleFactory) {
    modules[moduleName] = moduleFactory;

    // to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
    if (moduleName !== 'index') {
        return;
    }

    // we assume that when an index module is initializing then other modules are loaded already
    var workerBundleString = 'var sharedModule = {}; (' + modules.shared + ')(sharedModule); (' + modules.worker + ')(sharedModule);'

    var sharedModule = {};
    // the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
    // to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
    // we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
    modules.shared(sharedModule);
    modules.index(maplibregl, sharedModule);

    if (typeof window !== 'undefined') {
        maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' })));
    }

    return maplibregl;
};



define("shared",["exports"],(function(t){"use strict";function e(t,e,r,n){return new(r||(r=Promise))((function(i,s){function a(t){try{l(n.next(t));}catch(t){s(t);}}function o(t){try{l(n.throw(t));}catch(t){s(t);}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e);}))).then(a,o);}l((n=n.apply(t,e||[])).next());}))}function r(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}"function"==typeof SuppressedError&&SuppressedError;var n=i;function i(t,e){this.x=t,this.y=e;}i.prototype={clone:function(){return new i(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},i.convert=function(t){return t instanceof i?t:Array.isArray(t)?new i(t[0],t[1]):t};var s=r(n),a=o;function o(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}o.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var l=r(a);let u,c;function h(){return null==u&&(u="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),u}function p(){if(null==c&&(c=!1,h())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1);}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){c=!0;break}}}return c||!1}function f(t,e,r,n){const i=new l(t,e,r,n);return function(t){return i.solve(t)}}const d=f(.25,.1,.25,1);function y(t,e,r){return Math.min(r,Math.max(e,t))}function m(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function g(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let x=1;function v(t,e,r){const n={};for(const i in t)n[i]=e.call(r||this,t[i],i,t);return n}function b(t,e,r){const n={};for(const i in t)e.call(r||this,t[i],i,t)&&(n[i]=t[i]);return n}function w(t){return Array.isArray(t)?t.map(w):"object"==typeof t&&t?v(t,w):t}const _={};function A(t){_[t]||("undefined"!=typeof console&&console.warn(t),_[t]=!0);}function S(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function k(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}function I(t){return "undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let z=null;function M(t){return "undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const B="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function C(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const a=null==e?void 0:e.format;if(!a||!a.startsWith("BGR")&&!a.startsWith("RGB"))throw new Error(`Unrecognized format ${a}`);const o=a.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(-e,0),a=(Math.max(0,r)-r)*n*4+s,o=4*n,l=Math.max(0,e),u=Math.max(0,r);return {rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:a,stride:o}]}}(t,r,n,i,s)),o)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e;}return l}finally{e.close();}}))}let P,V;const E="AbortError";function F(){return new Error(E)}const T={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function $(t){return T.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const D="global-dispatcher";class L extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n;}}const O=()=>I(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,R=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=$(t.url);if(e)return e(t,r);if(I(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"getResource",data:t,targetMapId:D},r)}if(!(/^file:/.test(n=t.url)||/^file:/.test(O())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,(function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:O(),signal:r.signal});"json"===t.type&&e.headers.set("Accept","application/json");const n=yield fetch(e);if(!n.ok){const e=yield n.blob();throw new L(n.status,n.statusText,t.url,e)}const i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text(),s=yield i;if(r.signal.aborted)throw F();return {data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(t,r);if(I(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"getResource",data:t,mustQueue:!0,targetMapId:D},r)}var n;return function(t,e){return new Promise(((r,n)=>{const i=new XMLHttpRequest;i.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(i.responseType="arraybuffer");for(const e in t.headers)i.setRequestHeader(e,t.headers[e]);"json"===t.type&&(i.responseType="text",i.setRequestHeader("Accept","application/json")),i.withCredentials="include"===t.credentials,i.onerror=()=>{n(new Error(i.statusText));},i.onload=()=>{if(!e.signal.aborted)if((i.status>=200&&i.status<300||0===i.status)&&null!==i.response){let e=i.response;if("json"===t.type)try{e=JSON.parse(i.response);}catch(t){return void n(t)}r({data:e,cacheControl:i.getResponseHeader("Cache-Control"),expires:i.getResponseHeader("Expires")});}else {const e=new Blob([i.response],{type:i.getResponseHeader("Content-Type")});n(new L(i.status,i.statusText,t.url,e));}},e.signal.addEventListener("abort",(()=>{i.abort(),n(F());})),i.send(t.body);}))}(t,r)};function U(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return !0;const e=new URL(t),r=window.location;return e.protocol===r.protocol&&e.host===r.host}function j(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function q(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class N{constructor(t,e={}){g(this,e),this.type=t;}}class Z extends N{constructor(t,e={}){super("error",g({error:t},e));}}class K{on(t,e){return this._listeners=this._listeners||{},j(t,e,this._listeners),this}off(t,e){return q(t,e,this._listeners),q(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},j(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new N(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)q(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(g(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof Z&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var G={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},sky:{type:"sky"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{},within:{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const J=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function X(t,e){const r={};for(const e in t)"ref"!==e&&(r[e]=t[e]);return J.forEach((t=>{t in e&&(r[t]=e[t]);})),r}function H(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!H(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!H(t[r],e[r]))return !1;return !0}return t===e}function Y(t,e){t.push(e);}function W(t,e,r){Y(r,{command:"addSource",args:[t,e[t]]});}function Q(t,e,r){Y(e,{command:"removeSource",args:[t]}),r[t]=!0;}function tt(t,e,r,n){Q(t,r,n),W(t,e,r);}function et(t,e,r){let n;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!H(t[r][n],e[r][n]))return !1;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!H(t[r][n],e[r][n]))return !1;return !0}function rt(t,e,r,n,i,s){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(H(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(H(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));}function nt(t){return t.id}function it(t,e){return t[e.id]=e,t}class st{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function at(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class ot extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class lt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new lt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const ut={kind:"null"},ct={kind:"number"},ht={kind:"string"},pt={kind:"boolean"},ft={kind:"color"},dt={kind:"object"},yt={kind:"value"},mt={kind:"collator"},gt={kind:"formatted"},xt={kind:"padding"},vt={kind:"resolvedImage"},bt={kind:"variableAnchorOffsetCollection"};function wt(t,e){return {kind:"array",itemType:t,N:e}}function _t(t){if("array"===t.kind){const e=_t(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const At=[ut,ct,ht,pt,ft,gt,dt,wt(yt),xt,vt,bt];function St(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!St(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of At)if(!St(t,e))return null}return `Expected ${_t(t)} but found ${_t(e)} instead.`}function kt(t,e){return e.some((e=>e.kind===t.kind))}function It(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function zt(t,e){return "array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const Mt=.96422,Bt=.82521,Ct=4/29,Pt=6/29,Vt=3*Pt*Pt,Et=Pt*Pt*Pt,Ft=Math.PI/180,Tt=180/Math.PI;function $t(t){return (t%=360)<0&&(t+=360),t}function Dt([t,e,r,n]){let i,s;const a=Ot((.2225045*(t=Lt(t))+.7168786*(e=Lt(e))+.0606169*(r=Lt(r)))/1);t===e&&e===r?i=s=a:(i=Ot((.4360747*t+.3850649*e+.1430804*r)/Mt),s=Ot((.0139322*t+.0971045*e+.7141733*r)/Bt));const o=116*a-16;return [o<0?0:o,500*(i-a),200*(a-s),n]}function Lt(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function Ot(t){return t>Et?Math.pow(t,1/3):t/Vt+Ct}function Rt([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,a=isNaN(r)?i:i-r/200;return i=1*jt(i),s=Mt*jt(s),a=Bt*jt(a),[Ut(3.1338561*s-1.6168667*i-.4906146*a),Ut(-.9787684*s+1.9161415*i+.033454*a),Ut(.0719453*s-.2289914*i+1.4052427*a),n]}function Ut(t){return (t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function jt(t){return t>Pt?t*t*t:Vt*(t-Ct)}function qt(t){return parseInt(t.padEnd(2,t),16)/255}function Nt(t,e){return Zt(e?t/100:t,0,1)}function Zt(t,e,r){return Math.min(Math.max(e,t),r)}function Kt(t){return !t.some(Number.isNaN)}const Gt={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};class Jt{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]));}static parse(t){if(t instanceof Jt)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return [0,0,0,0];const e=Gt[t];if(e){const[t,r,n]=e;return [t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return [qt(t.slice(r,r+=e)),qt(t.slice(r,r+=e)),qt(t.slice(r,r+=e)),qt(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,a,o,l,u,c,h,p]=e,f=[i||" ",o||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,a,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[Zt(+r/e,0,1),Zt(+s/e,0,1),Zt(+l/e,0,1),h?Nt(+h,p):1];if(Kt(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,a,o,l,u]=r,c=[n||" ",s||" ",o].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,Zt(+i,0,100),Zt(+a,0,100),l?Nt(+l,u):1];if(Kt(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=$t(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new Jt(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=Dt(t),s=Math.sqrt(r*r+n*n);return [Math.round(1e4*s)?$t(Math.atan2(n,r)*Tt):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",Dt(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return `rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}}Jt.black=new Jt(0,0,0,1),Jt.white=new Jt(1,1,1,1),Jt.transparent=new Jt(0,0,0,0),Jt.red=new Jt(1,0,0,1);class Xt{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class Ht{constructor(t,e,r,n,i){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i;}}class Yt{constructor(t){this.sections=t;}static fromString(t){return new Yt([new Ht(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Yt?t:Yt.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Wt{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Wt)return t;if("number"==typeof t)return new Wt([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new Wt(t)}}toString(){return JSON.stringify(this.values)}}const Qt=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class te{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof te)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!Qt.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new te(t)}}toString(){return JSON.stringify(this.values)}}class ee{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new ee({name:t,available:!1}):null}}function re(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function ne(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof Jt||t instanceof Xt||t instanceof Yt||t instanceof Wt||t instanceof te||t instanceof ee)return !0;if(Array.isArray(t)){for(const e of t)if(!ne(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!ne(t[e]))return !1;return !0}return !1}function ie(t){if(null===t)return ut;if("string"==typeof t)return ht;if("boolean"==typeof t)return pt;if("number"==typeof t)return ct;if(t instanceof Jt)return ft;if(t instanceof Xt)return mt;if(t instanceof Yt)return gt;if(t instanceof Wt)return xt;if(t instanceof te)return bt;if(t instanceof ee)return vt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=ie(e);if(r){if(r===t)continue;r=yt;break}r=t;}return wt(r||yt,e)}return dt}function se(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof Jt||t instanceof Yt||t instanceof Wt||t instanceof te||t instanceof ee?t.toString():JSON.stringify(t)}class ae{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!ne(t[1]))return e.error("invalid value");const r=t[1];let n=ie(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new ae(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}class oe{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const le={string:ht,number:ct,boolean:pt,object:dt};class ue{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in le)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=le[r],n++;}else i=yt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=wt(i,s);}else {if(!le[i])throw new Error(`Types doesn't contain name = ${i}`);r=le[i];}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,yt);if(!r)return null;s.push(r);}return new ue(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!St(this.type,ie(r)))return r;if(e===this.args.length-1)throw new oe(`Expected value to be of type ${_t(this.type)}, but found ${_t(ie(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const ce={"to-boolean":pt,"to-color":ft,"to-number":ct,"to-string":ht};class he{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!ce[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=ce[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,yt);if(!n)return null;i.push(n);}return new he(n,i)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof Jt)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:re(e[0],e[1],e[2],e[3]),!r))return new Jt(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new oe(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=Wt.parse(e);if(n)return n}throw new oe(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=te.parse(e);if(n)return n}throw new oe(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new oe(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Yt.fromString(se(this.args[0].evaluate(t)));case"resolvedImage":return ee.fromString(se(this.args[0].evaluate(t)));default:return se(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const pe=["Unknown","Point","LineString","Polygon"];class fe{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?pe[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=Jt.parse(t)),e}}class de{constructor(t,e,r=[],n,i=new lt,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new ue(e,[t]):"coerce"===r?new he(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind)if("padding"!==t.kind||"value"!==i.kind&&"number"!==i.kind&&"array"!==i.kind)if("variableAnchorOffsetCollection"!==t.kind||"value"!==i.kind&&"array"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof ae)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new fe;try{n=new ae(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new de(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new ot(r,t));}checkSubtype(t,e){const r=St(t,e);return r&&this.error(r),r}}class ye{constructor(t,e,r){this.type=mt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,pt);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,pt);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,ht),!s)?null:new ye(n,i,s)}evaluate(t){return new Xt(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}}const me=8192;function ge(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function xe(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function ve(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*me),Math.round(n*i*me)]}function be(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function we(t,e){let r=!1;for(let a=0,o=e.length;a<o;a++){const o=e[a];for(let e=0,a=o.length;e<a-1;e++){if(be(t,o[e],o[e+1]))return !1;(i=o[e])[1]>(n=t)[1]!=(s=o[e+1])[1]>n[1]&&n[0]<(s[0]-i[0])*(n[1]-i[1])/(s[1]-i[1])+i[0]&&(r=!r);}}var n,i,s;return r}function _e(t,e){for(let r=0;r<e.length;r++)if(we(t,e[r]))return !0;return !1}function Ae(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function Se(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(a=u[r+1])[0]-(s=u[r])[0],a[1]-s[1]])[0]*(l=[(i=e)[0]-(n=t)[0],i[1]-n[1]])[1]-o[1]*l[0]&&Ae(n,i,s,a)&&Ae(s,a,n,i))return !0;var n,i,s,a,o,l;return !1}function ke(t,e){for(let r=0;r<t.length;++r)if(!we(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Se(t[r],t[r+1],e))return !1;return !0}function Ie(t,e){for(let r=0;r<e.length;r++)if(ke(t,e[r]))return !0;return !1}function ze(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=ve(t[i][n],r);ge(e,a),s.push(a);}n.push(s);}return n}function Me(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=ze(t[i],e,r);n.push(s);}return n}function Be(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}ge(e,t);}function Ce(t,e,r,n){const i=Math.pow(2,n.z)*me,s=[n.x*me,n.y*me],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Be(n,e,r,i),a.push(n);}return a}function Pe(t,e,r,n){const i=Math.pow(2,n.z)*me,s=[n.x*me,n.y*me],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];ge(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Be(n,e,r,i);}var o;return a}class Ve{constructor(t,e){this.type=pt,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(ne(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n);}if(t.length)return new Ve(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Ve(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Ve(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=ze(e.coordinates,n,i),a=Ce(t.geometry(),r,n,i);if(!xe(r,n))return !1;for(const t of a)if(!we(t,s))return !1}if("MultiPolygon"===e.type){const s=Me(e.coordinates,n,i),a=Ce(t.geometry(),r,n,i);if(!xe(r,n))return !1;for(const t of a)if(!_e(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=ze(e.coordinates,n,i),a=Pe(t.geometry(),r,n,i);if(!xe(r,n))return !1;for(const t of a)if(!ke(t,s))return !1}if("MultiPolygon"===e.type){const s=Me(e.coordinates,n,i),a=Pe(t.geometry(),r,n,i);if(!xe(r,n))return !1;for(const t of a)if(!Ie(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}class Ee{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Ee(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}}class Fe{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}static parse(t,e){const r=t[0],n=Fe.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new de(e.registry,Te,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Fe(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(_t).join(", ")})`:`(${_t(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(_t(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){Fe.definitions=e;for(const r in e)t[r]=Fe;}}function Te(t){if(t instanceof Ee)return Te(t.boundExpression);if(t instanceof Fe&&"error"===t.name)return !1;if(t instanceof ye)return !1;if(t instanceof Ve)return !1;const e=t instanceof he||t instanceof ue;let r=!0;return t.eachChild((t=>{r=e?r&&Te(t):r&&t instanceof ae;})),!!r&&$e(t)&&Le(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function $e(t){if(t instanceof Fe){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Ve)return !1;let e=!0;return t.eachChild((t=>{e&&!$e(t)&&(e=!1);})),e}function De(t){if(t instanceof Fe&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!De(t)&&(e=!1);})),e}function Le(t,e){if(t instanceof Fe&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!Le(t,e)&&(r=!1);})),r}function Oe(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new oe("Input is not a number.");a=o-1;}return 0}class Re{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,ct);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new Re(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Oe(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Ue(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var je=qe;function qe(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}qe.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}};var Ne=Ue(je);function Ze(t,e,r){return t+r*(e-t)}function Ke(t,e,r){return t.map(((t,n)=>Ze(t,e[n],r)))}const Ge={number:Ze,color:function(t,e,r,n="rgb"){switch(n){case"rgb":{const[n,i,s,a]=Ke(t.rgb,e.rgb,r);return new Jt(n,i,s,a,!1)}case"hcl":{const[n,i,s,a]=t.hcl,[o,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(o))isNaN(n)?isNaN(o)?h=NaN:(h=o,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else {let t=o-n;o>n&&t>180?t-=360:o<n&&n-o>180&&(t+=360),h=n+r*t;}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*Ft,Rt([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:Ze(i,l,r),Ze(s,u,r),Ze(a,c,r)]);return new Jt(f,d,y,m,!1)}case"lab":{const[n,i,s,a]=Rt(Ke(t.lab,e.lab,r));return new Jt(n,i,s,a,!1)}}},array:Ke,padding:function(t,e,r){return new Wt(Ke(t.values,e.values,r))},variableAnchorOffsetCollection:function(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new oe(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new oe(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,a]=n[t+1],[o,l]=i[t+1];s.push([Ze(e,o,r),Ze(a,l,r)]);}return new te(s)}};class Je{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=Xe(e,t.base,r,n);else if("linear"===t.name)i=Xe(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new Ne(s[0],s[1],s[2],s[3]).solve(Xe(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,ct),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=ft:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return zt(o,ct)||zt(o,ft)||zt(o,xt)||zt(o,bt)||zt(o,wt(ct))?new Je(o,r,n,i,a):e.error(`Type ${_t(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=Oe(e,n),a=Je.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case"interpolate":return Ge[this.type.kind](o,l,a);case"interpolate-hcl":return Ge.color(o,l,a,"hcl");case"interpolate-lab":return Ge.color(o,l,a,"lab")}}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Xe(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}class He{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}if(!r)throw new Error("No output type");const s=n&&i.some((t=>St(n,t.type)));return new He(s?yt:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof ee&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}class Ye{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Ye(r,n):null}outputDefined(){return this.result.outputDefined()}}class We{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,ct),n=e.parse(t[2],2,wt(e.expectedType||yt));return r&&n?new We(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new oe(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new oe(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new oe(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}}class Qe{constructor(t,e){this.type=pt,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,yt),n=e.parse(t[2],2,yt);return r&&n?kt(r.type,[pt,ht,ct,ut,yt])?new Qe(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${_t(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!It(e,["boolean","string","number","null"]))throw new oe(`Expected first argument to be of type boolean, string, number or null, but found ${_t(ie(e))} instead.`);if(!It(r,["string","array"]))throw new oe(`Expected second argument to be of type array or string, but found ${_t(ie(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}}class tr{constructor(t,e,r){this.type=ct,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,yt),n=e.parse(t[2],2,yt);if(!r||!n)return null;if(!kt(r.type,[pt,ht,ct,ut,yt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${_t(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,ct);return i?new tr(r,n,i):null}return new tr(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!It(e,["boolean","string","number","null"]))throw new oe(`Expected first argument to be of type boolean, string, number or null, but found ${_t(ie(e))} instead.`);if(!It(r,["string","array"]))throw new oe(`Expected second argument to be of type array or string, but found ${_t(ie(r))} instead.`);if(this.fromIndex){const n=this.fromIndex.evaluate(t);return r.indexOf(e,n)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}}class er{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,ie(t)))return null}else r=ie(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,yt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new er(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (ie(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class rr{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,pt);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new rr(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class nr{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,yt),n=e.parse(t[2],2,ct);if(!r||!n)return null;if(!kt(r.type,[wt(yt),ht,yt]))return e.error(`Expected first argument to be of type array or string, but found ${_t(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,ct);return i?new nr(r.type,r,n,i):null}return new nr(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!It(e,["string","array"]))throw new oe(`Expected first argument to be of type array or string, but found ${_t(ie(e))} instead.`);if(this.endIndex){const n=this.endIndex.evaluate(t);return e.slice(r,n)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}}function ir(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function sr(t,e,r,n){return 0===n.compare(e,r)}function ar(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=pt,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,yt);if(!s)return null;if(!ir(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${_t(s.type)}'.`);let a=e.parse(t[2],2,yt);if(!a)return null;if(!ir(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${_t(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${_t(s.type)}' and '${_t(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new ue(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new ue(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,mt),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=ie(s),r=ie(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new oe(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=ie(s),r=ie(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}}}const or=ar("==",(function(t,e,r){return e===r}),sr),lr=ar("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !sr(0,e,r,n)})),ur=ar("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),cr=ar(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),hr=ar("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),pr=ar(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class fr{constructor(t,e,r,n,i){this.type=ht,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,ct);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,ht),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,ht),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,ct),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,ct),!o)?null:new fr(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}}class dr{constructor(t){this.type=gt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,ct),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,wt(ht)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,ft),!a))return null;const o=n[n.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,yt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null});}}return new dr(n)}evaluate(t){return new Yt(this.sections.map((e=>{const r=e.content.evaluate(t);return ie(r)===vt?new Ht("",r,null,null,null):new Ht(se(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}}class yr{constructor(t){this.type=vt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,ht);return r?new yr(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=ee.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}}class mr{constructor(t){this.type=ct,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${_t(r.type)} instead.`):new mr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new oe(`Expected value to be of type string or array, but found ${_t(ie(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}}const gr={"==":or,"!=":lr,">":cr,"<":ur,">=":pr,"<=":hr,array:ue,at:We,boolean:ue,case:rr,coalesce:He,collator:ye,format:dr,image:yr,in:Qe,"index-of":tr,interpolate:Je,"interpolate-hcl":Je,"interpolate-lab":Je,length:mr,let:Ye,literal:ae,match:er,number:ue,"number-format":fr,object:ue,slice:nr,step:Re,string:ue,"to-boolean":he,"to-color":he,"to-number":he,"to-string":he,var:Ee,within:Ve};function xr(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=re(e,r,n,s);if(a)throw new oe(a);return new Jt(e/255,r/255,n/255,s,!1)}function vr(t,e){return t in e}function br(t,e){const r=e[t];return void 0===r?null:r}function wr(t){return {type:t}}function _r(t){return {result:"success",value:t}}function Ar(t){return {result:"error",value:t}}function Sr(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function kr(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Ir(t){return !!t.expression&&t.expression.interpolated}function zr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Mr(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Br(t){return t}function Cr(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(Ir(e)?"exponential":"interval");if(r||"padding"===e.type){const n=r?Jt.parse:Wt.parse;(t=at({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],n(t[1])]))),t.default=n(t.default?t.default:e.default);}if(t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;let o,l,u;if("exponential"===s)o=Fr;else if("interval"===s)o=Er;else if("categorical"===s){o=Vr,l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);o=Tr;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Cr(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:Je.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>Fr({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Je.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,l,u)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Pr(t.default,e.default):o(t,e,i,l,u)}}}function Pr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Vr(t,e,r,n,i){return Pr(typeof r===i?n[r]:void 0,t.default,e.default)}function Er(t,e,r){if("number"!==zr(r))return Pr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Oe(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function Fr(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==zr(r))return Pr(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=Oe(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1],u=Ge[e.type]||Br;return "function"==typeof o.evaluate?{evaluate(...e){const r=o.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,a,t.colorSpace)}}:u(o,l,a,t.colorSpace)}function Tr(t,e,r){switch(e.type){case"color":r=Jt.parse(r);break;case"formatted":r=Yt.fromString(r.toString());break;case"resolvedImage":r=ee.fromString(r.toString());break;case"padding":r=Wt.parse(r);break;default:zr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return Pr(r,t.default,e.default)}Fe.register(gr,{error:[{kind:"error"},[ht],(t,[e])=>{throw new oe(e.evaluate(t))}],typeof:[ht,[yt],(t,[e])=>_t(ie(e.evaluate(t)))],"to-rgba":[wt(ct,4),[ft],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return [255*r,255*n,255*i,s]}],rgb:[ft,[ct,ct,ct],xr],rgba:[ft,[ct,ct,ct,ct],xr],has:{type:pt,overloads:[[[ht],(t,[e])=>vr(e.evaluate(t),t.properties())],[[ht,dt],(t,[e,r])=>vr(e.evaluate(t),r.evaluate(t))]]},get:{type:yt,overloads:[[[ht],(t,[e])=>br(e.evaluate(t),t.properties())],[[ht,dt],(t,[e,r])=>br(e.evaluate(t),r.evaluate(t))]]},"feature-state":[yt,[ht],(t,[e])=>br(e.evaluate(t),t.featureState||{})],properties:[dt,[],t=>t.properties()],"geometry-type":[ht,[],t=>t.geometryType()],id:[yt,[],t=>t.id()],zoom:[ct,[],t=>t.globals.zoom],"heatmap-density":[ct,[],t=>t.globals.heatmapDensity||0],"line-progress":[ct,[],t=>t.globals.lineProgress||0],accumulated:[yt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[ct,wr(ct),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[ct,wr(ct),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:ct,overloads:[[[ct,ct],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[ct],(t,[e])=>-e.evaluate(t)]]},"/":[ct,[ct,ct],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[ct,[ct,ct],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[ct,[],()=>Math.LN2],pi:[ct,[],()=>Math.PI],e:[ct,[],()=>Math.E],"^":[ct,[ct,ct],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[ct,[ct],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[ct,[ct],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[ct,[ct],(t,[e])=>Math.log(e.evaluate(t))],log2:[ct,[ct],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[ct,[ct],(t,[e])=>Math.sin(e.evaluate(t))],cos:[ct,[ct],(t,[e])=>Math.cos(e.evaluate(t))],tan:[ct,[ct],(t,[e])=>Math.tan(e.evaluate(t))],asin:[ct,[ct],(t,[e])=>Math.asin(e.evaluate(t))],acos:[ct,[ct],(t,[e])=>Math.acos(e.evaluate(t))],atan:[ct,[ct],(t,[e])=>Math.atan(e.evaluate(t))],min:[ct,wr(ct),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[ct,wr(ct),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[ct,[ct],(t,[e])=>Math.abs(e.evaluate(t))],round:[ct,[ct],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[ct,[ct],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[ct,[ct],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[pt,[ht,yt],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[pt,[yt],(t,[e])=>t.id()===e.value],"filter-type-==":[pt,[ht],(t,[e])=>t.geometryType()===e.value],"filter-<":[pt,[ht,yt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[pt,[yt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[pt,[ht,yt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[pt,[yt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[pt,[ht,yt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[pt,[yt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[pt,[ht,yt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[pt,[yt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[pt,[yt],(t,[e])=>e.value in t.properties()],"filter-has-id":[pt,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[pt,[wt(ht)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[pt,[wt(yt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[pt,[ht,wt(yt)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[pt,[ht,wt(yt)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:pt,overloads:[[[pt,pt],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[wr(pt),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:pt,overloads:[[[pt,pt],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[wr(pt),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[pt,[pt],(t,[e])=>!e.evaluate(t)],"is-supported-script":[pt,[ht],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[ht,[ht],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[ht,[ht],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[ht,wr(yt),(t,e)=>e.map((e=>se(e.evaluate(t)))).join("")],"resolved-locale":[ht,[mt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class $r{constructor(t,e){var r;this.expression=t,this._warningHistory={},this._evaluator=new fe,this._defaultValue=e?"color"===(r=e).type&&Mr(r.default)?new Jt(0,0,0,0):"color"===r.type?Jt.parse(r.default)||null:"padding"===r.type?Wt.parse(r.default)||null:"variableAnchorOffsetCollection"===r.type?te.parse(r.default)||null:void 0===r.default?null:r.default:null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new oe(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Dr(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in gr}function Lr(t,e){const r=new de(gr,Te,[],e?function(t){const e={color:ft,string:ht,number:ct,enum:ht,boolean:pt,formatted:gt,padding:xt,resolvedImage:vt,variableAnchorOffsetCollection:bt};return "array"===t.type?wt(e[t.value]||yt,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?_r(new $r(n,e)):Ar(r.errors)}class Or{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!De(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class Rr{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!De(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?Je.interpolationFactor(this.interpolationType,t,e,r):0}}function Ur(t,e){const r=Lr(t,e);if("error"===r.result)return r;const n=r.value.expression,i=$e(n);if(!i&&!Sr(e))return Ar([new ot("","data expressions not supported")]);const s=Le(n,["zoom"]);if(!s&&!kr(e))return Ar([new ot("","zoom expressions not supported")]);const a=qr(n);return a||s?a instanceof ot?Ar([a]):a instanceof Je&&!Ir(e)?Ar([new ot("",'"interpolate" expressions cannot be used with this property')]):_r(a?new Rr(i?"camera":"composite",r.value,a.labels,a instanceof Je?a.interpolation:void 0):new Or(i?"constant":"source",r.value)):Ar([new ot("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class jr{constructor(t,e){this._parameters=t,this._specification=e,at(this,Cr(this._parameters,this._specification));}static deserialize(t){return new jr(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function qr(t){let e=null;if(t instanceof Ye)e=qr(t.result);else if(t instanceof He){for(const r of t.args)if(e=qr(r),e)break}else (t instanceof Re||t instanceof Je)&&t.input instanceof Fe&&"zoom"===t.input.name&&(e=t);return e instanceof ot||t.eachChild((t=>{const r=qr(t);r instanceof ot?e=r:!e&&r?e=new ot("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new ot("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function Nr(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!Nr(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const Zr={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function Kr(t){if(null==t)return {filter:()=>!0,needGeometry:!1};Nr(t)||(t=Xr(t));const e=Lr(t,Zr);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:Jr(t)}}function Gr(t,e){return t<e?-1:t>e?1:0}function Jr(t){if(!Array.isArray(t))return !1;if("within"===t[0])return !0;for(let e=1;e<t.length;e++)if(Jr(t[e]))return !0;return !1}function Xr(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?Hr(t[1],t[2],"=="):"!="===e?Qr(Hr(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?Hr(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(Xr))):"all"===e?["all"].concat(t.slice(1).map(Xr)):"none"===e?["all"].concat(t.slice(1).map(Xr).map(Qr)):"in"===e?Yr(t[1],t.slice(2)):"!in"===e?Qr(Yr(t[1],t.slice(2))):"has"===e?Wr(t[1]):"!has"===e?Qr(Wr(t[1])):"within"!==e||t;var r;}function Hr(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function Yr(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Gr)]]:["filter-in-small",t,["literal",e]]}}function Wr(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function Qr(t){return ["!",t]}function tn(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${tn(r)},`;return `${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${tn(t[r[e]])},`;return `${n}}`}function en(t){let e="";for(const r of J)e+=`/${tn(t[r])}`;return e}function rn(t){const e=t.value;return e?[new st(t.key,e,"constants have been deprecated as of v8")]:[]}function nn(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function sn(t){if(Array.isArray(t))return t.map(sn);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=sn(t[r]);return e}return nn(t)}function an(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const u=zr(r);if("object"!==u)return [new st(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=n[u]||n["*"];let h;if(i[u])h=i[u];else if(n[u])h=o;else if(i["*"])h=i["*"];else {if(!n["*"]){l.push(new st(e,r[t],`unknown property "${t}"`));continue}h=o;}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:a,object:r,objectKey:t,validateSpec:o},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new st(e,r,`missing required property "${t}"`));return l}function on(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==zr(e))return [new st(s,e,`array expected, ${zr(e)} found`)];if(r.length&&e.length!==r.length)return [new st(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new st(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function),"object"===zr(r.value)&&(o=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:o,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function ln(t){const e=t.key,r=t.value,n=t.valueSpec;let i=zr(r);return "number"===i&&r!=r&&(i="NaN"),"number"!==i?[new st(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new st(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new st(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function un(t){const e=t.valueSpec,r=nn(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===zr(t.value.stops)&&"array"===zr(t.value.stops[0])&&"object"===zr(t.value.stops[0][0]),c=an({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new st(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(on({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===zr(n)&&0===n.length&&e.push(new st(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new st(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new st(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Ir(t.valueSpec)&&c.push(new st(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Sr(t.valueSpec)?c.push(new st(t.key,t.value,"property functions not supported")):o&&!kr(t.valueSpec)&&c.push(new st(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new st(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==zr(n))return [new st(o,n,`array expected, ${zr(n)} found`)];if(2!==n.length)return [new st(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==zr(n[0]))return [new st(o,n,`object expected, ${zr(n[0])} found`)];if(void 0===n[0].zoom)return [new st(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new st(o,n,"object stop key must have value")];if(s&&s>nn(n[0].zoom))return [new st(o,n[0].zoom,"stop zoom values must appear in ascending order")];nn(n[0].zoom)!==s&&(s=nn(n[0].zoom),i=void 0,a={}),r=r.concat(an({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:ln,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return Dr(sn(n[1]))?r.concat([new st(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${o}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=zr(t.value),l=nn(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new st(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new st(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return Sr(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new st(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new st(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new st(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new st(t.key,u,`integer expected, found ${l}`)]}}function cn(t){const e=("property"===t.expressionContext?Ur:Lr)(sn(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new st(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new st(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!De(r))return [new st(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!De(r))return [new st(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Le(r,["zoom","feature-state"]))return [new st(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!$e(r))return [new st(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function hn(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(nn(r))&&i.push(new st(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(nn(r))&&i.push(new st(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function pn(t){return Nr(sn(t.value))?cn(at({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):fn(t)}function fn(t){const e=t.value,r=t.key;if("array"!==zr(e))return [new st(r,e,`array expected, ${zr(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new st(r,e,"filter array must have at least 1 element")];switch(s=s.concat(hn({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),nn(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===nn(e[1])&&s.push(new st(r,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new st(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(i=zr(e[1]),"string"!==i&&s.push(new st(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=zr(e[a]),"$type"===nn(e[1])?s=s.concat(hn({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new st(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case"any":case"all":case"none":for(let n=1;n<e.length;n++)s=s.concat(fn({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":i=zr(e[1]),2!==e.length?s.push(new st(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new st(`${r}[1]`,e[1],`string expected, ${i} found`));break;case"within":i=zr(e[1]),2!==e.length?s.push(new st(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"object"!==i&&s.push(new st(`${r}[1]`,e[1],`object expected, ${i} found`));}return s}function dn(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,a=t.value,o=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return [];const u=o.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:a,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[o];if(!c)return [new st(r,a,`unknown property "${o}"`)];let h;if("string"===zr(a)&&Sr(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(a)))return [new st(r,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return "symbol"===t.layerType&&("text-field"===o&&i&&!i.glyphs&&p.push(new st(r,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===o&&Mr(sn(a))&&"identity"===nn(a.type)&&p.push(new st(r,a,'"text-font" does not support identity functions'))),p.concat(n({key:t.key,value:a,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:o}))}function yn(t){return dn(t,"paint")}function mn(t){return dn(t,"layout")}function gn(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;r.type||r.ref||e.push(new st(n,r,'either "type" or "ref" is required'));let a=nn(r.type);const o=nn(r.ref);if(r.id){const s=nn(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];nn(t.id)===s&&e.push(new st(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new st(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{nn(e.id)===o&&(t=e);})),t?t.ref?e.push(new st(n,r.ref,"ref cannot reference another ref layer")):a=nn(t.type):e.push(new st(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&nn(t.type);t?"vector"===s&&"raster"===a?e.push(new st(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a?e.push(new st(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?e.push(new st(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new st(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new st(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new st(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new st(n,r.source,`source "${r.source}" not found`));}else e.push(new st(n,r,'missing required property "source"'));return e=e.concat(an({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:pn,layout:t=>an({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>mn(at({layerType:a},t))}}),paint:t=>an({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>yn(at({layerType:a},t))}})}})),e}function xn(t){const e=t.value,r=t.key,n=zr(e);return "string"!==n?[new st(r,e,`string expected, ${n} found`)]:[]}const vn={promoteId:function({key:t,value:e}){if("string"===zr(e))return xn({key:t,value:e});{const r=[];for(const n in e)r.push(...xn({key:`${t}.${n}`,value:e[n]}));return r}}};function bn(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return [new st(r,e,'"type" is required')];const a=nn(e.type);let o;switch(a){case"vector":case"raster":return o=an({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:vn,validateSpec:s}),o;case"raster-dem":return o=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,a=t.style;let o=[];const l=zr(n);if(void 0===n)return o;if("object"!==l)return o.push(new st("source_raster_dem",n,`object expected, ${l} found`)),o;const u="custom"===nn(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?o.push(new st(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?o=o.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:a,styleSpec:i})):o.push(new st(e,n[e],`unknown property "${e}"`));return o}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),o;case"geojson":if(o=an({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:vn}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],a="string"==typeof n?[n,["accumulated"],["get",t]]:n;o.push(...cn({key:`${r}.${t}.map`,value:i,validateSpec:s,expressionContext:"cluster-map"})),o.push(...cn({key:`${r}.${t}.reduce`,value:a,validateSpec:s,expressionContext:"cluster-reduce"}));}return o;case"video":return an({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case"image":return an({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case"canvas":return [new st(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return hn({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:i,validateSpec:s,styleSpec:n})}}function wn(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=zr(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new st("light",e,`object expected, ${a} found`)]),s;for(const a in e){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new st(a,e[a],`unknown property "${a}"`)]);}return s}function _n(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=zr(e);if(void 0===e)return [];if("object"!==s)return [new st("sky",e,`object expected, ${s} found`)];let a=[];for(const t in e)a=a.concat(n[t]?In({key:t,value:e[t],valueSpec:n[t],style:i,styleSpec:r}):[new st(t,e[t],`unknown property "${t}"`)]);return a}function An(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const a=zr(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new st("terrain",e,`object expected, ${a} found`)]),s;for(const a in e)s=s.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new st(a,e[a],`unknown property "${a}"`)]);return s}function Sn(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const a in r)r[a].id&&i.includes(r[a].id)&&e.push(new st(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),i.push(r[a].id),r[a].url&&s.includes(r[a].url)&&e.push(new st(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),s.push(r[a].url),e=e.concat(an({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return xn({key:n,value:r})}const kn={"*":()=>[],array:on,boolean:function(t){const e=t.value,r=t.key,n=zr(e);return "boolean"!==n?[new st(r,e,`boolean expected, ${n} found`)]:[]},number:ln,color:function(t){const e=t.key,r=t.value,n=zr(r);return "string"!==n?[new st(e,r,`color expected, ${n} found`)]:Jt.parse(String(r))?[]:[new st(e,r,`color expected, "${r}" found`)]},constants:rn,enum:hn,filter:pn,function:un,layer:gn,object:an,source:bn,light:wn,sky:_n,terrain:An,string:xn,formatted:function(t){return 0===xn(t).length?[]:cn(t)},resolvedImage:function(t){return 0===xn(t).length?[]:cn(t)},padding:function(t){const e=t.key,r=t.value;if("array"===zr(r)){if(r.length<1||r.length>4)return [new st(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return ln({key:e,value:r,valueSpec:{}})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=zr(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return [new st(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(hn({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(on({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:Sn};function In(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=In,r.expression&&Mr(nn(e))?un(t):r.expression&&Dr(sn(e))?cn(t):r.type&&kn[r.type]?kn[r.type](t):an(at({},t,{valueSpec:r.type?n[r.type]:r}))}function zn(t){const e=t.value,r=t.key,n=xn(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new st(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new st(r,e,'"glyphs" url must include a "{range}" token'))),n}function Mn(t,e=G){let r=[];return r=r.concat(In({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:In,objectElementValidators:{glyphs:zn,"*":()=>[]}})),t.constants&&(r=r.concat(rn({key:"constants",value:t.constants,style:t,styleSpec:e,validateSpec:In}))),Cn(r)}function Bn(t){return function(e){return t({...e,validateSpec:In})}}function Cn(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function Pn(t){return function(...e){return Cn(t.apply(this,e))}}Mn.source=Pn(Bn(bn)),Mn.sprite=Pn(Bn(Sn)),Mn.glyphs=Pn(Bn(zn)),Mn.light=Pn(Bn(wn)),Mn.sky=Pn(Bn(_n)),Mn.terrain=Pn(Bn(An)),Mn.layer=Pn(Bn(gn)),Mn.filter=Pn(Bn(pn)),Mn.paintProperty=Pn(Bn(yn)),Mn.layoutProperty=Pn(Bn(mn));const Vn=Mn,En=Vn.light,Fn=Vn.paintProperty,Tn=Vn.layoutProperty;function $n(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new Z(new Error(n.message))),r=!0;return r}class Dn{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s);}query(t,e,r,n,i){const s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,a,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===a[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(a[h]=!0,s.push(i[h])):a[h]=!1;}}}}_forEachCell(t,e,r,n,i,s,a,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,a,o))return}}_convertFromCellCoord(t){return (t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length;}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new Dn(t.buffer)}}const Ln={};function On(t,e,r={}){if(Ln[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Ln[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}On("Object",Object),On("TransferableGridIndex",Dn),On("Color",Jt),On("Error",Error),On("AJAXError",L),On("ResolvedImage",ee),On("StylePropertyFunction",jr),On("StyleExpression",$r,{omit:["_evaluator"]}),On("ZoomDependentExpression",Rr),On("ZoomConstantExpression",Or),On("CompoundExpression",Fe,{omit:["_evaluate"]});for(const t in gr)gr[t]._classRegistryKey||On(`Expression_${t}`,gr[t]);function Rn(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Un(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error)return t;if(Rn(t))return e&&e.push(t),t;if(M(t))return e&&e.push(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.push(r.buffer),r}if(t instanceof ImageData)return e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(Un(n,e));return r}if("object"==typeof t){const r=t.constructor,n=r._classRegistryKey;if(!n)throw new Error(`can't serialize object of unregistered class ${r.name}`);if(!Ln[n])throw new Error(`${n} is not registered.`);const i=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const r in t){if(!t.hasOwnProperty(r))continue;if(Ln[n].omit.indexOf(r)>=0)continue;const s=t[r];i[r]=Ln[n].shallow.indexOf(r)>=0?s:Un(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==n&&(i.$name=n),i}throw new Error("can't serialize object of type "+typeof t)}function jn(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||Rn(t)||M(t)||ArrayBuffer.isView(t)||t instanceof ImageData)return t;if(Array.isArray(t))return t.map(jn);if("object"==typeof t){const e=t.$name||"Object";if(!Ln[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=Ln[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=Ln[e].shallow.indexOf(r)>=0?i:jn(i);}return n}throw new Error("can't deserialize object of type "+typeof t)}class qn{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const Nn={"Latin-1 Supplement":t=>t>=128&&t<=255,Arabic:t=>t>=1536&&t<=1791,"Arabic Supplement":t=>t>=1872&&t<=1919,"Arabic Extended-A":t=>t>=2208&&t<=2303,"Hangul Jamo":t=>t>=4352&&t<=4607,"Unified Canadian Aboriginal Syllabics":t=>t>=5120&&t<=5759,Khmer:t=>t>=6016&&t<=6143,"Unified Canadian Aboriginal Syllabics Extended":t=>t>=6320&&t<=6399,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"CJK Radicals Supplement":t=>t>=11904&&t<=12031,"Kangxi Radicals":t=>t>=12032&&t<=12255,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Bopomofo:t=>t>=12544&&t<=12591,"Hangul Compatibility Jamo":t=>t>=12592&&t<=12687,Kanbun:t=>t>=12688&&t<=12703,"Bopomofo Extended":t=>t>=12704&&t<=12735,"CJK Strokes":t=>t>=12736&&t<=12783,"Katakana Phonetic Extensions":t=>t>=12784&&t<=12799,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"CJK Unified Ideographs Extension A":t=>t>=13312&&t<=19903,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Yi Syllables":t=>t>=40960&&t<=42127,"Yi Radicals":t=>t>=42128&&t<=42191,"Hangul Jamo Extended-A":t=>t>=43360&&t<=43391,"Hangul Syllables":t=>t>=44032&&t<=55215,"Hangul Jamo Extended-B":t=>t>=55216&&t<=55295,"Private Use Area":t=>t>=57344&&t<=63743,"CJK Compatibility Ideographs":t=>t>=63744&&t<=64255,"Arabic Presentation Forms-A":t=>t>=64336&&t<=65023,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Arabic Presentation Forms-B":t=>t>=65136&&t<=65279,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function Zn(t){for(const e of t)if(Jn(e.charCodeAt(0)))return !0;return !1}function Kn(t){for(const e of t)if(!Gn(e.charCodeAt(0)))return !1;return !0}function Gn(t){return !(Nn.Arabic(t)||Nn["Arabic Supplement"](t)||Nn["Arabic Extended-A"](t)||Nn["Arabic Presentation Forms-A"](t)||Nn["Arabic Presentation Forms-B"](t))}function Jn(t){return !(746!==t&&747!==t&&(t<4352||!(Nn["Bopomofo Extended"](t)||Nn.Bopomofo(t)||Nn["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||Nn["CJK Compatibility Ideographs"](t)||Nn["CJK Compatibility"](t)||Nn["CJK Radicals Supplement"](t)||Nn["CJK Strokes"](t)||!(!Nn["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Nn["CJK Unified Ideographs Extension A"](t)||Nn["CJK Unified Ideographs"](t)||Nn["Enclosed CJK Letters and Months"](t)||Nn["Hangul Compatibility Jamo"](t)||Nn["Hangul Jamo Extended-A"](t)||Nn["Hangul Jamo Extended-B"](t)||Nn["Hangul Jamo"](t)||Nn["Hangul Syllables"](t)||Nn.Hiragana(t)||Nn["Ideographic Description Characters"](t)||Nn.Kanbun(t)||Nn["Kangxi Radicals"](t)||Nn["Katakana Phonetic Extensions"](t)||Nn.Katakana(t)&&12540!==t||!(!Nn["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Nn["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Nn["Unified Canadian Aboriginal Syllabics"](t)||Nn["Unified Canadian Aboriginal Syllabics Extended"](t)||Nn["Vertical Forms"](t)||Nn["Yijing Hexagram Symbols"](t)||Nn["Yi Syllables"](t)||Nn["Yi Radicals"](t))))}function Xn(t){return !(Jn(t)||function(t){return !!(Nn["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||Nn["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||Nn["Letterlike Symbols"](t)||Nn["Number Forms"](t)||Nn["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||Nn["Control Pictures"](t)&&9251!==t||Nn["Optical Character Recognition"](t)||Nn["Enclosed Alphanumerics"](t)||Nn["Geometric Shapes"](t)||Nn["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||Nn["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Nn["CJK Symbols and Punctuation"](t)||Nn.Katakana(t)||Nn["Private Use Area"](t)||Nn["CJK Compatibility Forms"](t)||Nn["Small Form Variants"](t)||Nn["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function Hn(t){return t>=1424&&t<=2303||Nn["Arabic Presentation Forms-A"](t)||Nn["Arabic Presentation Forms-B"](t)}function Yn(t,e){return !(!e&&Hn(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||Nn.Khmer(t))}function Wn(t){for(const e of t)if(Hn(e.charCodeAt(0)))return !0;return !1}const Qn=new class{constructor(){this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null;}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL;}setMethods(t){this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText;}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getPluginURL(){return this.pluginURL}getRTLTextPluginStatus(){return this.pluginStatus}};class ti{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new qn,this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!Yn(r.charCodeAt(0),e))return !1;return !0}(t,"loaded"===Qn.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class ei{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Mr(t))return new jr(t,e);if(Dr(t)){const r=Ur(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "color"===e.type&&"string"==typeof t?r=Jt.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)&&(r=te.parse(t)):r=Wt.parse(t),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class ri{constructor(t){this.property=t,this.value=new ei(t,void 0);}transitioned(t,e){return new ii(this.property,this.value,e,g({},t.transition,this.transition),t.now)}untransitioned(){return new ii(this.property,this.value,null,{},0)}}class ni{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return w(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ri(this._values[t].property)),this._values[t].value=new ei(this._values[t].property,null===e?void 0:w(e));}getTransition(t){return w(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ri(this._values[t].property)),this._values[t].transition=w(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new si(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new si(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class ii{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,function(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}(a))}}return i}}class si{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new li(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class ai{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}hasValue(t){return void 0!==this._values[t].value}getValue(t){return w(this._values[t].value)}setValue(t,e){this._values[t]=new ei(this._values[t].property,null===e?void 0:w(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new li(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class oi{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class li{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class ui{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=Ge[this.specification.type];return n?n(t,e,r):t}}class ci{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new oi(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new oi(this,{kind:"constant",value:void 0},t.parameters);const n=Ge[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new oi(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class hi extends ci{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new oi(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new oi(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new oi(this,{kind:"constant",value:r},e)}return new oi(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class pi{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new ti(Math.floor(e.zoom-1),e)),t.expression.evaluate(new ti(Math.floor(e.zoom),e)),t.expression.evaluate(new ti(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class fi{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class di{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new ei(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new ri(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}On("DataDrivenProperty",ci),On("DataConstantProperty",ui),On("CrossFadedDataDrivenProperty",hi),On("CrossFadedProperty",pi),On("ColorRampProperty",fi);const yi="-transition";class mi extends K{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new ai(e.layout)),e.paint)){this._transitionablePaint=new ni(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new li(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Tn,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return t.endsWith(yi)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Fn,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(t.endsWith(yi))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),b(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&$n(this,t.call(Vn,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:G,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof oi&&Sr(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const gi={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class xi{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class vi{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function bi(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=gi[t.type].BYTES_PER_ELEMENT,s=r=wi(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:wi(r,Math.max(n,e)),alignment:e}}function wi(t,e){return Math.ceil(t/e)*e}class _i extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}_i.prototype.bytesPerElement=4,On("StructArrayLayout2i4",_i);class Ai extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Ai.prototype.bytesPerElement=6,On("StructArrayLayout3i6",Ai);class Si extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}Si.prototype.bytesPerElement=8,On("StructArrayLayout4i8",Si);class ki extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}ki.prototype.bytesPerElement=12,On("StructArrayLayout2i4i12",ki);class Ii extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=a,t}}Ii.prototype.bytesPerElement=8,On("StructArrayLayout2i4ub8",Ii);class zi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}zi.prototype.bytesPerElement=8,On("StructArrayLayout2f8",zi);class Mi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}Mi.prototype.bytesPerElement=20,On("StructArrayLayout10ui20",Mi);class Bi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}Bi.prototype.bytesPerElement=24,On("StructArrayLayout4i4ui4i24",Bi);class Ci extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ci.prototype.bytesPerElement=12,On("StructArrayLayout3f12",Ci);class Pi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Pi.prototype.bytesPerElement=4,On("StructArrayLayout1ul4",Pi);class Vi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l)}emplace(t,e,r,n,i,s,a,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=a,this.uint32[h+3]=o,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}Vi.prototype.bytesPerElement=20,On("StructArrayLayout6i1ul2ui20",Vi);class Ei extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}Ei.prototype.bytesPerElement=12,On("StructArrayLayout2i2i2i12",Ei);class Fi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}Fi.prototype.bytesPerElement=16,On("StructArrayLayout2f1f2i16",Fi);class Ti extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=n,this.float32[a+2]=i,t}}Ti.prototype.bytesPerElement=12,On("StructArrayLayout2ub2f12",Ti);class $i extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}$i.prototype.bytesPerElement=6,On("StructArrayLayout3ui6",$i);class Di extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}Di.prototype.bytesPerElement=48,On("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Di);class Li extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,I,z){const M=this.length;return this.resize(M+1),this.emplace(M,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,I,z)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,A,S,k,I,z,M){const B=32*t,C=16*t;return this.int16[B+0]=e,this.int16[B+1]=r,this.int16[B+2]=n,this.int16[B+3]=i,this.int16[B+4]=s,this.int16[B+5]=a,this.int16[B+6]=o,this.int16[B+7]=l,this.uint16[B+8]=u,this.uint16[B+9]=c,this.uint16[B+10]=h,this.uint16[B+11]=p,this.uint16[B+12]=f,this.uint16[B+13]=d,this.uint16[B+14]=y,this.uint16[B+15]=m,this.uint16[B+16]=g,this.uint16[B+17]=x,this.uint16[B+18]=v,this.uint16[B+19]=b,this.uint16[B+20]=w,this.uint16[B+21]=_,this.uint16[B+22]=A,this.uint32[C+12]=S,this.float32[C+13]=k,this.float32[C+14]=I,this.uint16[B+30]=z,this.uint16[B+31]=M,t}}Li.prototype.bytesPerElement=64,On("StructArrayLayout8i15ui1ul2f2ui64",Li);class Oi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Oi.prototype.bytesPerElement=4,On("StructArrayLayout1f4",Oi);class Ri extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ri.prototype.bytesPerElement=12,On("StructArrayLayout1ui2f12",Ri);class Ui extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}Ui.prototype.bytesPerElement=8,On("StructArrayLayout1ul2ui8",Ui);class ji extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}ji.prototype.bytesPerElement=4,On("StructArrayLayout2ui4",ji);class qi extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}qi.prototype.bytesPerElement=2,On("StructArrayLayout1ui2",qi);class Ni extends vi{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}Ni.prototype.bytesPerElement=16,On("StructArrayLayout4f16",Ni);class Zi extends xi{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new s(this.anchorPointX,this.anchorPointY)}}Zi.prototype.size=20;class Ki extends Vi{get(t){return new Zi(this,t)}}On("CollisionBoxArray",Ki);class Gi extends xi{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Gi.prototype.size=48;class Ji extends Di{get(t){return new Gi(this,t)}}On("PlacedSymbolArray",Ji);class Xi extends xi{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Xi.prototype.size=64;class Hi extends Li{get(t){return new Xi(this,t)}}On("SymbolInstanceArray",Hi);class Yi extends Oi{getoffsetX(t){return this.float32[1*t+0]}}On("GlyphOffsetArray",Yi);class Wi extends Ai{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}On("SymbolLineVertexArray",Wi);class Qi extends xi{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}Qi.prototype.size=12;class ts extends Ri{get(t){return new Qi(this,t)}}On("TextAnchorOffsetArray",ts);class es extends xi{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}es.prototype.size=8;class rs extends Ui{get(t){return new es(this,t)}}On("FeatureIndexArray",rs);class ns extends _i{}class is extends _i{}class ss extends _i{}class as extends ki{}class os extends Ii{}class ls extends zi{}class us extends Mi{}class cs extends Bi{}class hs extends Ci{}class ps extends Pi{}class fs extends Ei{}class ds extends Ti{}class ys extends $i{}class ms extends ji{}const gs=bi([{name:"a_pos",components:2,type:"Int16"}],4),{members:xs}=gs;class vs{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,n){let i=this.segments[this.segments.length-1];return t>vs.MAX_VERTEX_ARRAY_LENGTH&&A(`Max vertices per segment is ${vs.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!i||i.vertexLength+t>vs.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n)&&(i={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==n&&(i.sortKey=n),this.segments.push(i)),i}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new vs([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function bs(t,e){return 256*(t=y(Math.floor(t),0,255))+y(Math.floor(e),0,255)}vs.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,On("SegmentVector",vs);const ws=bi([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var _s={exports:{}},As={exports:{}};As.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0};var Ss=As.exports,ks={exports:{}};ks.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0};var Is=Ss,zs=ks.exports;_s.exports=Is,_s.exports.murmur3=Is,_s.exports.murmur2=zs;var Ms=r(_s.exports);class Bs{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(Cs(t)),this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=Cs(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Ps(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new Bs;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Cs(t){const e=+t;return !isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:Ms(String(t))}function Ps(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;Vs(t,s,a),Vs(e,3*s,3*a),Vs(e,3*s+1,3*a+1),Vs(e,3*s+2,3*a+2);}a-r<n-a?(Ps(t,e,r,a),r=a+1):(Ps(t,e,a+1,n),n=a);}}function Vs(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}On("FeaturePositionMap",Bs);class Es{constructor(t,e){this.gl=t.gl,this.location=e;}}class Fs extends Es{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class Ts extends Es{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class $s extends Es{constructor(t,e){super(t,e),this.current=Jt.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const Ds=new Float32Array(16);function Ls(t){return [bs(255*t.r,255*t.g),bs(255*t.b,255*t.a)]}class Os{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new $s(t,e):new Fs(t,e)}}class Rs{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new Ts(t,e):new Fs(t,e)}}class Us{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i){const s=this.paintVertexArray.length,a=this.expression.evaluate(new ti(0),e,{},n,[],i);this.paintVertexArray.resize(t),this._setPaintValue(s,t,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,i);}_setPaintValue(t,e,r){if("color"===this.type){const n=Ls(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class js{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new ti(this.zoom),e,{},n,[],i),a=this.expression.evaluate(new ti(this.zoom+1),e,{},n,[],i),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,s,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:this.zoom},r,n),s=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,i,s);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Ls(r),s=Ls(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=y(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new Fs(t,e)}}class qs{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:a}=r,o=n[i],l=n[s],u=n[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,ws.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,ws.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class Ns{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof oi&&Sr(s.property.specification)))continue;const a=Ks(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new Rs(o.value,a):new Os(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=Gs(i,l,"source");this.binders[i]=h?new qs(o,l,u,e,r,t.id):new Us(o,a,l,r),n.push(`/a_${i}`);}else {const t=Gs(i,l,"composite");this.binders[i]=new js(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Us||e instanceof js?e.maxValue:0}populatePaintArrays(t,e,r,n,i){for(const s in this.binders){const a=this.binders[s];(a instanceof Us||a instanceof js||a instanceof qs)&&a.populatePaintArray(t,e,r,n,i);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Rs&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Us||l instanceof js||l instanceof qs)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Os||r instanceof Rs)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Us||r instanceof js)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof qs)for(let e=0;e<ws.members.length;e++)t.push(ws.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Os||r instanceof Rs||r instanceof js)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Os||i instanceof Rs||i instanceof js)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof qs){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof Us||r instanceof js)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Us||r instanceof js||r instanceof qs)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Us||e instanceof js||e instanceof qs)&&e.destroy();}}}class Zs{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new Ns(n,e,r);this.needsUpload=!1,this._featureMap=new Bs,this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function Ks(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function Gs(t,e,r){const n={color:{source:zi,composite:Ni},number:{source:Oi,composite:zi}},i=function(t){return {"line-pattern":{source:us,composite:us},"fill-pattern":{source:us,composite:us},"fill-extrusion-pattern":{source:us,composite:us}}[t]}(t);return i&&i[r]||n[e][r]}On("ConstantBinder",Os),On("CrossFadedConstantBinder",Rs),On("SourceExpressionBinder",Us),On("CrossFadedCompositeBinder",qs),On("CompositeExpressionBinder",js),On("ProgramConfiguration",Ns,{omit:["_buffers"]}),On("ProgramConfigurationSet",Zs);const Js=8192,Xs=Math.pow(2,14)-1,Hs=-Xs-1;function Ys(t){const e=Js/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=y(i,Hs,Xs),r.y=y(s,Hs,Xs),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&A("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function Ws(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?Ys(t):[]}}function Qs(t,e,r,n,i){t.emplaceBack(2*e+(n+1)/2,2*r+(i+1)/2);}class ta{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new is,this.indexArray=new ys,this.segments=new vs,this.programConfigurations=new Zs(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let s=null,a=!1;"circle"===n.type&&(s=n.layout.get("circle-sort-key"),a=!s.isConstant());for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ws(e,t);if(!this.layers[0]._featureFilter.filter(new ti(this.zoom),u,r))continue;const c=a?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Ys(e),patterns:{},sortKey:c};i.push(h);}a&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,xs),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n){for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=Js||n<0||n>=Js)continue;const i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),s=i.vertexLength;Qs(this.layoutVertexArray,r,n,-1,-1),Qs(this.layoutVertexArray,r,n,1,-1),Qs(this.layoutVertexArray,r,n,1,1),Qs(this.layoutVertexArray,r,n,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+3,s+2),i.vertexLength+=4,i.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n);}}function ea(t,e){for(let r=0;r<t.length;r++)if(ca(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(ca(t,e[r]))return !0;return !!sa(t,e)}function ra(t,e,r){return !!ca(t,e)||!!oa(e,t,r)}function na(t,e){if(1===t.length)return ua(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(ca(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(ua(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(sa(t,e[r]))return !0;return !1}function ia(t,e,r){if(t.length>1){if(sa(t,e))return !0;for(let n=0;n<e.length;n++)if(oa(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(oa(t[n],e,r))return !0;return !1}function sa(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(aa(n,i,e[t],e[t+1]))return !0}return !1}function aa(t,e,r,n){return S(t,r,n)!==S(e,r,n)&&S(t,e,r)!==S(t,e,n)}function oa(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(la(t,e[r-1],e[r])<n)return !0;return !1}function la(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function ua(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function ca(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function ha(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=S(t,e,r[0]);return s!==S(t,e,r[1])||s!==S(t,e,r[2])||s!==S(t,e,r[3])}function pa(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function fa(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function da(t,e,r,n,i){if(!e[0]&&!e[1])return t;const a=s.convert(e)._mult(i);"viewport"===r&&a._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}let ya,ma;On("CircleBucket",ta,{omit:["layers"]});var ga={get paint(){return ma=ma||new di({"circle-radius":new ci(G.paint_circle["circle-radius"]),"circle-color":new ci(G.paint_circle["circle-color"]),"circle-blur":new ci(G.paint_circle["circle-blur"]),"circle-opacity":new ci(G.paint_circle["circle-opacity"]),"circle-translate":new ui(G.paint_circle["circle-translate"]),"circle-translate-anchor":new ui(G.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new ui(G.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new ui(G.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new ci(G.paint_circle["circle-stroke-width"]),"circle-stroke-color":new ci(G.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new ci(G.paint_circle["circle-stroke-opacity"])})},get layout(){return ya=ya||new di({"circle-sort-key":new ci(G.layout_circle["circle-sort-key"])})}},xa=1e-6,va="undefined"!=typeof Float32Array?Float32Array:Array;function ba(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function wa(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var _a,Aa=wa;function Sa(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}_a=new va(4),va!=Float32Array&&(_a[0]=0,_a[1]=0,_a[2]=0,_a[3]=0);class ka extends mi{constructor(t){super(t,ga);}createBucket(t){return new ta(t)}queryRadius(t){const e=t;return pa("circle-radius",this,e)+pa("circle-stroke-width",this,e)+fa(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a,o){const l=da(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,a),u=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),c="map"===this.paint.get("circle-pitch-alignment"),h=c?l:function(t,e){return t.map((t=>Ia(t,e)))}(l,o),p=c?u*a:u;for(const t of n)for(const e of t){const t=c?e:Ia(e,o);let r=p;const n=Sa([],[e.x,e.y,0,1],o);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n[3]/s.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=s.cameraToCenterDistance/n[3]),ra(h,t,r))return !0}return !1}}function Ia(t,e){const r=Sa([],[t.x,t.y,0,1],e);return new s(r[0]/r[3],r[1]/r[3])}class za extends ta{}let Ma;On("HeatmapBucket",za,{omit:["layers"]});var Ba={get paint(){return Ma=Ma||new di({"heatmap-radius":new ci(G.paint_heatmap["heatmap-radius"]),"heatmap-weight":new ci(G.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new ui(G.paint_heatmap["heatmap-intensity"]),"heatmap-color":new fi(G.paint_heatmap["heatmap-color"]),"heatmap-opacity":new ui(G.paint_heatmap["heatmap-opacity"])})}};function Ca(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function Pa(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=Ca({},{width:e,height:r},n);Va(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function Va(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}class Ea{constructor(t,e){Ca(this,t,1,e);}resize(t){Pa(this,t,1);}clone(){return new Ea({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Va(t,e,r,n,i,1);}}class Fa{constructor(t,e){Ca(this,t,4,e);}resize(t){Pa(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Fa({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Va(t,e,r,n,i,4);}}function Ta(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Fa({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}On("AlphaImage",Ea),On("RGBAImage",Fa);class $a extends mi{createBucket(t){return new za(t)}constructor(t){super(t,Ba),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Ta({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Da;var La={get paint(){return Da=Da||new di({"hillshade-illumination-direction":new ui(G.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new ui(G.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new ui(G.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new ui(G.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new ui(G.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new ui(G.paint_hillshade["hillshade-accent-color"])})}};class Oa extends mi{constructor(t){super(t,La);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}const Ra=bi([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ua}=Ra;var ja={exports:{}};function qa(t,e,r){r=r||2;var n,i,s,a,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=Na(t,0,h,r,!0),f=[];if(!p||p.next===p.prev)return f;if(c&&(p=function(t,e,r,n){var i,s,a,o=[];for(i=0,s=e.length;i<s;i++)(a=Na(t,e[i]*n,i<s-1?e[i+1]*n:t.length,n,!1))===a.next&&(a.steiner=!0),o.push(eo(a));for(o.sort(Ya),i=0;i<o.length;i++)r=Wa(o[i],r);return r}(t,e,p,r)),t.length>80*r){n=s=t[0],i=a=t[1];for(var d=r;d<h;d+=r)(o=t[d])<n&&(n=o),(l=t[d+1])<i&&(i=l),o>s&&(s=o),l>a&&(a=l);u=0!==(u=Math.max(s-n,a-i))?32767/u:0;}return Ka(p,f,r,n,i,u,0),f}function Na(t,e,r,n,i){var s,a;if(i===yo(t,e,r,n)>0)for(s=e;s<r;s+=n)a=ho(s,t[s],t[s+1],a);else for(s=r-n;s>=e;s-=n)a=ho(s,t[s],t[s+1],a);return a&&so(a,a.next)&&(po(a),a=a.next),a}function Za(t,e){if(!t)return t;e||(e=t);var r,n=t;do{if(r=!1,n.steiner||!so(n,n.next)&&0!==io(n.prev,n,n.next))n=n.next;else {if(po(n),(n=e=n.prev)===n.next)break;r=!0;}}while(r||n!==e);return e}function Ka(t,e,r,n,i,s,a){if(t){!a&&s&&function(t,e,r,n){var i=t;do{0===i.z&&(i.z=to(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,r,n,i,s,a,o,l,u=1;do{for(r=t,t=null,s=null,a=0;r;){for(a++,n=r,o=0,e=0;e<u&&(o++,n=n.nextZ);e++);for(l=u;o>0||l>0&&n;)0!==o&&(0===l||!n||r.z<=n.z)?(i=r,r=r.nextZ,o--):(i=n,n=n.nextZ,l--),s?s.nextZ=i:t=i,i.prevZ=s,s=i;r=n;}s.nextZ=null,u*=2;}while(a>1)}(i);}(t,n,i,s);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,s?Ja(t,n,i,s):Ga(t))e.push(o.i/r|0),e.push(t.i/r|0),e.push(l.i/r|0),po(t),t=l.next,u=l.next;else if((t=l)===u){a?1===a?Ka(t=Xa(Za(t),e,r),e,r,n,i,s,2):2===a&&Ha(t,e,r,n,i,s):Ka(Za(t),e,r,n,i,s,1);break}}}function Ga(t){var e=t.prev,r=t,n=t.next;if(io(e,r,n)>=0)return !1;for(var i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=i<s?i<a?i:a:s<a?s:a,h=o<l?o<u?o:u:l<u?l:u,p=i>s?i>a?i:a:s>a?s:a,f=o>l?o>u?o:u:l>u?l:u,d=n.next;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&ro(i,o,s,l,a,u,d.x,d.y)&&io(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Ja(t,e,r,n){var i=t.prev,s=t,a=t.next;if(io(i,s,a)>=0)return !1;for(var o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=o<l?o<u?o:u:l<u?l:u,d=c<h?c<p?c:p:h<p?h:p,y=o>l?o>u?o:u:l>u?l:u,m=c>h?c>p?c:p:h>p?h:p,g=to(f,d,e,r,n),x=to(y,m,e,r,n),v=t.prevZ,b=t.nextZ;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&ro(o,c,l,h,u,p,v.x,v.y)&&io(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&ro(o,c,l,h,u,p,b.x,b.y)&&io(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&ro(o,c,l,h,u,p,v.x,v.y)&&io(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&ro(o,c,l,h,u,p,b.x,b.y)&&io(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Xa(t,e,r){var n=t;do{var i=n.prev,s=n.next.next;!so(i,s)&&ao(i,n,n.next,s)&&uo(i,s)&&uo(s,i)&&(e.push(i.i/r|0),e.push(n.i/r|0),e.push(s.i/r|0),po(n),po(n.next),n=t=s),n=n.next;}while(n!==t);return Za(n)}function Ha(t,e,r,n,i,s){var a=t;do{for(var o=a.next.next;o!==a.prev;){if(a.i!==o.i&&no(a,o)){var l=co(a,o);return a=Za(a,a.next),l=Za(l,l.next),Ka(a,e,r,n,i,s,0),void Ka(l,e,r,n,i,s,0)}o=o.next;}a=a.next;}while(a!==t)}function Ya(t,e){return t.x-e.x}function Wa(t,e){var r=function(t,e){var r,n=e,i=t.x,s=t.y,a=-1/0;do{if(s<=n.y&&s>=n.next.y&&n.next.y!==n.y){var o=n.x+(s-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(o<=i&&o>a&&(a=o,r=n.x<n.next.x?n:n.next,o===i))return r}n=n.next;}while(n!==e);if(!r)return null;var l,u=r,c=r.x,h=r.y,p=1/0;n=r;do{i>=n.x&&n.x>=c&&i!==n.x&&ro(s<h?i:a,s,c,h,s<h?a:i,s,n.x,n.y)&&(l=Math.abs(s-n.y)/(i-n.x),uo(n,t)&&(l<p||l===p&&(n.x>r.x||n.x===r.x&&Qa(r,n)))&&(r=n,p=l)),n=n.next;}while(n!==u);return r}(t,e);if(!r)return e;var n=co(r,t);return Za(n,n.next),Za(r,r.next)}function Qa(t,e){return io(t.prev,t,e.prev)<0&&io(e.next,t,t.next)<0}function to(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function eo(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function ro(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function no(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&ao(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(uo(t,e)&&uo(e,t)&&function(t,e){var r=t,n=!1,i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(io(t.prev,t,e.prev)||io(t,e.prev,e))||so(t,e)&&io(t.prev,t,t.next)>0&&io(e.prev,e,e.next)>0)}function io(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function so(t,e){return t.x===e.x&&t.y===e.y}function ao(t,e,r,n){var i=lo(io(t,e,r)),s=lo(io(t,e,n)),a=lo(io(r,n,t)),o=lo(io(r,n,e));return i!==s&&a!==o||!(0!==i||!oo(t,r,e))||!(0!==s||!oo(t,n,e))||!(0!==a||!oo(r,t,n))||!(0!==o||!oo(r,e,n))}function oo(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function lo(t){return t>0?1:t<0?-1:0}function uo(t,e){return io(t.prev,t,t.next)<0?io(t,e,t.next)>=0&&io(t,t.prev,e)>=0:io(t,e,t.prev)<0||io(t,t.next,e)<0}function co(t,e){var r=new fo(t.i,t.x,t.y),n=new fo(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function ho(t,e,r,n){var i=new fo(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function po(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function fo(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function yo(t,e,r,n){for(var i=0,s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}ja.exports=qa,ja.exports.default=qa,qa.deviation=function(t,e,r,n){var i=e&&e.length,s=Math.abs(yo(t,0,i?e[0]*r:t.length,r));if(i)for(var a=0,o=e.length;a<o;a++)s-=Math.abs(yo(t,e[a]*r,a<o-1?e[a+1]*r:t.length,r));var l=0;for(a=0;a<n.length;a+=3){var u=n[a]*r,c=n[a+1]*r,h=n[a+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===s&&0===l?0:Math.abs((l-s)/s)},qa.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},n=0,i=0;i<t.length;i++){for(var s=0;s<t[i].length;s++)for(var a=0;a<e;a++)r.vertices.push(t[i][s][a]);i>0&&r.holes.push(n+=t[i-1].length);}return r};var mo=r(ja.exports);function go(t,e,r,n,i){xo(t,e,r||0,n||t.length-1,i||bo);}function xo(t,e,r,n,i){for(;n>r;){if(n-r>600){var s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);xo(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}var c=t[e],h=r,p=n;for(vo(t,r,e),i(t[n],c)>0&&vo(t,r,n);h<p;){for(vo(t,h,p),h++,p--;i(t[h],c)<0;)h++;for(;i(t[p],c)>0;)p--;}0===i(t[r],c)?vo(t,r,p):vo(t,++p,n),p<=e&&(r=p+1),e<=p&&(n=p-1);}}function vo(t,e,r){var n=t[e];t[e]=t[r],t[r]=n;}function bo(t,e){return t<e?-1:t>e?1:0}function wo(t,e){const r=t.length;if(r<=1)return [t];const n=[];let i,s;for(let e=0;e<r;e++){const r=k(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(i&&n.push(i),i=[t[e]]):i.push(t[e]));}if(i&&n.push(i),e>1)for(let t=0;t<n.length;t++)n[t].length<=e||(go(n[t],e,1,n[t].length-1,_o),n[t]=n[t].slice(0,e));return n}function _o(t,e){return e.area-t.area}function Ao(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function So(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),o=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}class ko{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new ss,this.indexArray=new ys,this.indexArray2=new ms,this.programConfigurations=new Zs(t.layers,t.zoom),this.segments=new vs,this.segments2=new vs,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=Ao("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=Ws(a,t);if(!this.layers[0]._featureFilter.filter(new ti(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:Ys(a),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=So("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{});e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ua),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i){for(const t of wo(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),n=r.vertexLength,i=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(i.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),n=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(n+e.length-1,n),i.push(e[0].x),i.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(n+t-1,n+t),i.push(e[t].x),i.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=mo(i,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(n+a[t],n+a[t+1],n+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}let Io,zo;On("FillBucket",ko,{omit:["layers","patternFeatures"]});var Mo={get paint(){return zo=zo||new di({"fill-antialias":new ui(G.paint_fill["fill-antialias"]),"fill-opacity":new ci(G.paint_fill["fill-opacity"]),"fill-color":new ci(G.paint_fill["fill-color"]),"fill-outline-color":new ci(G.paint_fill["fill-outline-color"]),"fill-translate":new ui(G.paint_fill["fill-translate"]),"fill-translate-anchor":new ui(G.paint_fill["fill-translate-anchor"]),"fill-pattern":new hi(G.paint_fill["fill-pattern"])})},get layout(){return Io=Io||new di({"fill-sort-key":new ci(G.layout_fill["fill-sort-key"])})}};class Bo extends mi{constructor(t){super(t,Mo);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new ko(t)}queryRadius(){return fa(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,n,i,s,a){return na(da(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,a),n)}isTileClipped(){return !0}}const Co=bi([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Po=bi([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Vo}=Co;var Eo={},Fo=n,To=$o;function $o(t,e,r,n,i){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=i,t.readFields(Do,this,e);}function Do(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function Lo(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}$o.types=["Unknown","Point","LineString","Polygon"],$o.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,i=0,s=0,a=0,o=[];t.pos<r;){if(i<=0){var l=t.readVarint();n=7&l,i=l>>3;}if(i--,1===n||2===n)s+=t.readSVarint(),a+=t.readSVarint(),1===n&&(e&&o.push(e),e=[]),e.push(new Fo(s,a));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&o.push(e),o},$o.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},$o.prototype.toGeoJSON=function(t,e,r){var n,i,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=$o.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(n=0;n<l.length;n++)h[n]=l[n][0];c(l=h);break;case 2:for(n=0;n<l.length;n++)c(l[n]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,n,i=[],s=0;s<e;s++){var a=Lo(t[s]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(r&&i.push(r),r=[t[s]]):r.push(t[s]));}return r&&i.push(r),i}(l),n=0;n<l.length;n++)for(i=0;i<l[n].length;i++)c(l[n][i]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var Oo=To,Ro=Uo;function Uo(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(jo,this,e),this.length=this._features.length;}function jo(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}Uo.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new Oo(this._pbf,e,this.extent,this._keys,this._values)};var qo=Ro;function No(t,e,r){if(3===t){var n=new qo(r,r.readVarint()+r.pos);n.length&&(e[n.name]=n);}}Eo.VectorTile=function(t,e){this.layers=t.readFields(No,{},e);},Eo.VectorTileFeature=To,Eo.VectorTileLayer=Ro;const Zo=Eo.VectorTileFeature.types,Ko=Math.pow(2,13);function Go(t,e,r,n,i,s,a,o){t.emplaceBack(e,r,2*Math.floor(n*Ko)+a,i*Ko*2,s*Ko*2,Math.round(o));}class Jo{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new as,this.centroidVertexArray=new ns,this.indexArray=new ys,this.programConfigurations=new Zs(t.layers,t.zoom),this.segments=new vs,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.features=[],this.hasPattern=Ao("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=Ws(n,t);if(!this.layers[0]._featureFilter.filter(new ti(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:Ys(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(So("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{}),e.featureIndex.insert(n,l.geometry,s,a,this.index,!0);}}addFeatures(t,e,r){for(const t of this.features){const{geometry:n}=t;this.addFeature(t,n,t.index,e,r);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Vo),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Po.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i){const s={x:0,y:0,vertexCount:0};for(const r of wo(e,500)){let e=0;for(const t of r)e+=t.length;let n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);for(const t of r){if(0===t.length)continue;if(Ho(t))continue;let e=0;for(let r=0;r<t.length;r++){const i=t[r];if(r>=1){const a=t[r-1];if(!Xo(i,a)){n.vertexLength+4>vs.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=i.sub(a)._perp()._unit(),r=a.dist(i);e+r>32768&&(e=0),Go(this.layoutVertexArray,i.x,i.y,t.x,t.y,0,0,e),Go(this.layoutVertexArray,i.x,i.y,t.x,t.y,0,1,e),s.x+=2*i.x,s.y+=2*i.y,s.vertexCount+=2,e+=r,Go(this.layoutVertexArray,a.x,a.y,t.x,t.y,0,0,e),Go(this.layoutVertexArray,a.x,a.y,t.x,t.y,0,1,e),s.x+=2*a.x,s.y+=2*a.y,s.vertexCount+=2;const o=n.vertexLength;this.indexArray.emplaceBack(o,o+2,o+1),this.indexArray.emplaceBack(o+1,o+2,o+3),n.vertexLength+=4,n.primitiveLength+=2;}}}}if(n.vertexLength+e>vs.MAX_VERTEX_ARRAY_LENGTH&&(n=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray)),"Polygon"!==Zo[t.type])continue;const i=[],a=[],o=n.vertexLength;for(const t of r)if(0!==t.length){t!==r[0]&&a.push(i.length/2);for(let e=0;e<t.length;e++){const r=t[e];Go(this.layoutVertexArray,r.x,r.y,0,0,1,1,0),s.x+=r.x,s.y+=r.y,s.vertexCount+=1,i.push(r.x),i.push(r.y);}}const l=mo(i,a);for(let t=0;t<l.length;t+=3)this.indexArray.emplaceBack(o+l[t],o+l[t+2],o+l[t+1]);n.primitiveLength+=l.length/3,n.vertexLength+=e;}for(let t=0;t<s.vertexCount;t++)this.centroidVertexArray.emplaceBack(Math.floor(s.x/s.vertexCount),Math.floor(s.y/s.vertexCount));this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}function Xo(t,e){return t.x===e.x&&(t.x<0||t.x>Js)||t.y===e.y&&(t.y<0||t.y>Js)}function Ho(t){return t.every((t=>t.x<0))||t.every((t=>t.x>Js))||t.every((t=>t.y<0))||t.every((t=>t.y>Js))}let Yo;On("FillExtrusionBucket",Jo,{omit:["layers","features"]});var Wo={get paint(){return Yo=Yo||new di({"fill-extrusion-opacity":new ui(G["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new ci(G["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new ui(G["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new ui(G["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new hi(G["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new ci(G["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new ci(G["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new ui(G["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Qo extends mi{constructor(t){super(t,Wo);}createBucket(t){return new Jo(t)}queryRadius(){return fa(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature(t,e,r,n,i,a,o,l){const u=da(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,o),c=this.paint.get("fill-extrusion-height").evaluate(e,r),h=this.paint.get("fill-extrusion-base").evaluate(e,r),p=function(t,e,r,n){const i=[];for(const r of t){const t=[r.x,r.y,0,1];Sa(t,t,e),i.push(new s(t[0]/t[3],t[1]/t[3]));}return i}(u,l),f=function(t,e,r,n){const i=[],a=[],o=n[8]*e,l=n[9]*e,u=n[10]*e,c=n[11]*e,h=n[8]*r,p=n[9]*r,f=n[10]*r,d=n[11]*r;for(const e of t){const t=[],r=[];for(const i of e){const e=i.x,a=i.y,y=n[0]*e+n[4]*a+n[12],m=n[1]*e+n[5]*a+n[13],g=n[2]*e+n[6]*a+n[14],x=n[3]*e+n[7]*a+n[15],v=g+u,b=x+c,w=y+h,_=m+p,A=g+f,S=x+d,k=new s((y+o)/b,(m+l)/b);k.z=v/b,t.push(k);const I=new s(w/S,_/S);I.z=A/S,r.push(I);}i.push(t),a.push(r);}return [i,a]}(n,h,c,l);return function(t,e,r){let n=1/0;na(r,e)&&(n=el(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];ea(r,i)&&(n=Math.min(n,el(r,i)));}}return n!==1/0&&n}(f[0],f[1],p)}}function tl(t,e){return t.x*e.x+t.y*e.y}function el(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=tl(o,o),h=tl(o,l),p=tl(l,l),f=tl(u,o),d=tl(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const rl=bi([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:nl}=rl,il=bi([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:sl}=il,al=Eo.VectorTileFeature.types,ol=Math.cos(Math.PI/180*37.5),ll=Math.pow(2,14)/.5;class ul{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new os,this.layoutVertexArray2=new ls,this.indexArray=new ys,this.programConfigurations=new Zs(t.layers,t.zoom),this.segments=new vs,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=Ao("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=Ws(e,t);if(!this.layers[0]._featureFilter.filter(new ti(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:Ys(e),patterns:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=So("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{});e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,sl)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,nl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i){const s=this.layers[0].layout,a=s.get("line-join").evaluate(t,{}),o=s.get("line-cap"),l=s.get("line-miter-limit"),u=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,o,l,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}addLine(t,e,r,n,i,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===al[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(i=1.05);const u=this.overscaling<=16?15*Js/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p,f,d,y;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(f=e===o-1?a?t[l+1]:void 0:t[e+1],f&&t[e].equals(f))continue;y&&(d=y),h&&(p=h),h=t[e],y=f?f.sub(h)._unit()._perp():d,d=d||y;let m=d.add(y);0===m.x&&0===m.y||m._unit();const g=d.x*y.x+d.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<ol&&p&&f,_=d.x*y.y-d.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,d,0,0,c),p=e;}}const A=p&&f;let S=A?r:a?"butt":n;if(A&&"round"===S&&(v<s?S="miter":v<=2&&(S="fakeround")),"miter"===S&&v>i&&(S="bevel"),"bevel"===S&&(v>2&&(S="flipbevel"),v<i&&(S="miter")),p&&this.updateDistance(p,h),"miter"===S)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===S){if(v>100)m=y.mult(-1);else {const t=v*d.add(y).mag()/d.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===S||"fakeround"===S){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,d,e,r,c),"fakeround"===S){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const n=y.sub(d)._mult(r)._add(d)._unit()._mult(_?-1:1);this.addHalfVertex(h,n.x,n.y,!1,_,0,c);}}f&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===S)this.addCurrentVertex(h,m,0,0,c);else if("square"===S){const t=p?1:-1;this.addCurrentVertex(h,m,t,t,c);}else "round"===S&&(p&&(this.addCurrentVertex(h,d,0,0,c),this.addCurrentVertex(h,d,1,1,c,!0)),f&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(f);if(t>2*u){const e=h.add(f.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i),this.distance>ll/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s));}addHalfVertex({x:t,y:e},r,n,i,s,a,o){const l=.5*(this.lineClips?this.scaledDistance*(ll-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,u),o.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}let cl,hl;On("LineBucket",ul,{omit:["layers","patternFeatures"]});var pl={get paint(){return hl=hl||new di({"line-opacity":new ci(G.paint_line["line-opacity"]),"line-color":new ci(G.paint_line["line-color"]),"line-translate":new ui(G.paint_line["line-translate"]),"line-translate-anchor":new ui(G.paint_line["line-translate-anchor"]),"line-width":new ci(G.paint_line["line-width"]),"line-gap-width":new ci(G.paint_line["line-gap-width"]),"line-offset":new ci(G.paint_line["line-offset"]),"line-blur":new ci(G.paint_line["line-blur"]),"line-dasharray":new pi(G.paint_line["line-dasharray"]),"line-pattern":new hi(G.paint_line["line-pattern"]),"line-gradient":new fi(G.paint_line["line-gradient"])})},get layout(){return cl=cl||new di({"line-cap":new ui(G.layout_line["line-cap"]),"line-join":new ci(G.layout_line["line-join"]),"line-miter-limit":new ui(G.layout_line["line-miter-limit"]),"line-round-limit":new ui(G.layout_line["line-round-limit"]),"line-sort-key":new ci(G.layout_line["line-sort-key"])})}};class fl extends ci{possiblyEvaluate(t,e){return e=new ti(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=g({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let dl;class yl extends mi{constructor(t){super(t,pl),this.gradientVersion=0,dl||(dl=new fl(pl.paint.properties["line-width"].specification),dl.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof Re,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=dl.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new ul(t)}queryRadius(t){const e=t,r=ml(pa("line-width",this,e),pa("line-gap-width",this,e)),n=pa("line-offset",this,e);return r/2+Math.abs(n)+fa(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,i,a,o){const l=da(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,o),u=o/2*ml(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),c=this.paint.get("line-offset").evaluate(e,r);return c&&(n=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],a=[];for(let t=0;t<i.length;t++){const r=i[t-1],n=i[t],o=i[t+1],l=0===t?new s(0,0):n.sub(r)._unit()._perp(),u=t===i.length-1?new s(0,0):o.sub(n)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),a.push(c._mult(e)._add(n));}r.push(a);}return r}(n,c*o)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(ca(t,i[e]))return !0;if(ia(t,i,r))return !0}return !1}(l,n,u)}isTileClipped(){return !0}}function ml(t,e){return e>0?e+2*t:t}const gl=bi([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),xl=bi([{name:"a_projected_pos",components:3,type:"Float32"}],4);bi([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const vl=bi([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]);bi([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const bl=bi([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),wl=bi([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function _l(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),Qn.applyArabicShaping&&(t=Qn.applyArabicShaping(t)),t}(t.text,e,r);})),t}bi([{name:"triangle",components:3,type:"Uint16"}]),bi([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),bi([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),bi([{type:"Float32",name:"offsetX"}]),bi([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),bi([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const Al={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var Sl=24,kl=Ml,Il=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,n),s-=u;}return (f?-1:1)*a*Math.pow(2,s-n)},zl=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+f]=255&a,f+=d,a/=256,u-=8);t[r+f-d]|=128*y;};function Ml(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}Ml.Varint=0,Ml.Fixed64=1,Ml.Bytes=2,Ml.Fixed32=5;var Bl=4294967296,Cl=1/Bl,Pl="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function Vl(t){return t.type===Ml.Bytes?t.readVarint()+t.pos:t.pos+1}function El(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function Fl(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function Tl(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function $l(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function Dl(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function Ll(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function Ol(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function Rl(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function Ul(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function jl(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function ql(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function Nl(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function Zl(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Kl(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}Ml.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=Nl(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Kl(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=Nl(this.buf,this.pos)+Nl(this.buf,this.pos+4)*Bl;return this.pos+=8,t},readSFixed64:function(){var t=Nl(this.buf,this.pos)+Kl(this.buf,this.pos+4)*Bl;return this.pos+=8,t},readFloat:function(){var t=Il(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=Il(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return El(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return El(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return El(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return El(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return El(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return El(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&Pl?function(t,e,r){return Pl.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==Ml.Bytes)return t.push(this.readVarint(e));var r=Vl(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==Ml.Bytes)return t.push(this.readSVarint());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==Ml.Bytes)return t.push(this.readBoolean());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==Ml.Bytes)return t.push(this.readFloat());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==Ml.Bytes)return t.push(this.readDouble());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==Ml.Bytes)return t.push(this.readFixed32());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==Ml.Bytes)return t.push(this.readSFixed32());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==Ml.Bytes)return t.push(this.readFixed64());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==Ml.Bytes)return t.push(this.readSFixed64());var e=Vl(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===Ml.Varint)for(;this.buf[this.pos++]>127;);else if(e===Ml.Bytes)this.pos=this.readVarint()+this.pos;else if(e===Ml.Fixed32)this.pos+=4;else {if(e!==Ml.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),Zl(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),Zl(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),Zl(this.buf,-1&t,this.pos),Zl(this.buf,Math.floor(t*Cl),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),Zl(this.buf,-1&t,this.pos),Zl(this.buf,Math.floor(t*Cl),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&Fl(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),zl(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),zl(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&Fl(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,e,r){this.writeTag(t,Ml.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,Tl,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,$l,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,Ol,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,Dl,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,Ll,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,Rl,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,Ul,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,jl,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,ql,e);},writeBytesField:function(t,e){this.writeTag(t,Ml.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,Ml.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,Ml.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,Ml.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,Ml.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,Ml.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,Ml.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,Ml.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,Ml.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,Ml.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};var Gl=r(kl);const Jl=3;function Xl(t,e,r){1===t&&r.readMessage(Hl,e);}function Hl(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Yl,{});e.push({id:t,bitmap:new Ea({width:i+2*Jl,height:s+2*Jl},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function Yl(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const Wl=Jl;function Ql(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}const tu=1;class eu{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+tu,this.paddedRect.y+tu]}get br(){return [this.paddedRect.x+this.paddedRect.w-tu,this.paddedRect.y+this.paddedRect.h-tu]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2*tu)/this.pixelRatio,(this.paddedRect.h-2*tu)/this.pixelRatio]}}class ru{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=Ql(i),o=new Fa({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Fa.copy(n.data,o,{x:0,y:0},{x:i.x+tu,y:i.y+tu},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+tu,a=i.y+tu,l=r.data.width,u=r.data.height;Fa.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Fa.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Fa.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Fa.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Fa.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2*tu,h:i.data.height+2*tu};r.push(s),e[n]=new eu(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}var nu;On("ImagePosition",eu),On("ImageAtlas",ru),t.ah=void 0,(nu=t.ah||(t.ah={}))[nu.none=0]="none",nu[nu.horizontal=1]="horizontal",nu[nu.vertical=2]="vertical",nu[nu.horizontalOnly=3]="horizontalOnly";const iu=-17;class su{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new su;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new su;return e.imageName=t,e}}class au{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new au;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&Xn(n)&&!Al[t[r+1]]||i&&Xn(i)&&!Al[t[r-1]]||!Al[t[r]]?t[r]:Al[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&lu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&lu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new au;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(su.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void A("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(su.forImage(e)),this.sectionIndex.push(this.sections.length-1)):A("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function ou(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=au.fromFeature(e,s);let x;p===t.ah.vertical&&g.verticalizePunctuation();const{processBidirectionalText:v,processStyledBidirectionalText:b}=Qn;if(v&&1===g.sections.length){x=[];const t=v(g.toString(),yu(g,c,a,r,i,d,y));for(const e of t){const t=new au;t.text=e,t.sections=g.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);x.push(t);}}else if(b){x=[];const t=b(g.text,g.sectionIndex,yu(g,c,a,r,i,d,y));for(const e of t){const t=new au;t.text=e[0],t.sectionIndex=e[1],t.sections=g.sections,x.push(t);}}else x=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(g,yu(g,c,a,r,i,d,y));const w=[],_={positionedLines:w,text:g.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(e,r,n,i,s,a,o,l,u,c,h,p){let f=0,d=iu,y=0,m=0;const g="right"===l?1:"left"===l?0:.5;let x=0;for(const o of s){o.trim();const s=o.getMaxScale(),l=(s-1)*Sl,b={positionedGlyphs:[],lineOffset:0};e.positionedLines[x]=b;const w=b.positionedGlyphs;let _=0;if(!o.length()){d+=a,++x;continue}for(let a=0;a<o.length();a++){const y=o.getSection(a),m=o.getSectionIndex(a),g=o.getCharCode(a);let x=0,b=null,A=null,S=null,k=Sl;const I=!(u===t.ah.horizontal||!h&&!Jn(g)||h&&(lu[g]||(v=g,Nn.Arabic(v)||Nn["Arabic Supplement"](v)||Nn["Arabic Extended-A"](v)||Nn["Arabic Presentation Forms-A"](v)||Nn["Arabic Presentation Forms-B"](v))));if(y.imageName){const t=i[y.imageName];if(!t)continue;S=y.imageName,e.iconsInText=e.iconsInText||!0,A=t.paddedRect;const r=t.displaySize;y.scale=y.scale*Sl/p,b={width:r[0],height:r[1],left:tu,top:-Wl,advance:I?r[1]:r[0]},x=l+(Sl-r[1]*y.scale),k=b.advance;const n=I?r[0]*y.scale-Sl*s:r[1]*y.scale-Sl*s;n>0&&n>_&&(_=n);}else {const t=n[y.fontStack],e=t&&t[g];if(e&&e.rect)A=e.rect,b=e.metrics;else {const t=r[y.fontStack],e=t&&t[g];if(!e)continue;b=e.metrics;}x=(s-y.scale)*Sl;}I?(e.verticalizable=!0,w.push({glyph:g,imageName:S,x:f,y:d+x,vertical:I,scale:y.scale,fontStack:y.fontStack,sectionIndex:m,metrics:b,rect:A}),f+=k*y.scale+c):(w.push({glyph:g,imageName:S,x:f,y:d+x,vertical:I,scale:y.scale,fontStack:y.fontStack,sectionIndex:m,metrics:b,rect:A}),f+=b.advance*y.scale+c);}0!==w.length&&(y=Math.max(f-c,y),gu(w,0,w.length-1,g,_)),f=0;const A=a*s+_;b.lineOffset=Math.max(_,l),d+=A,m=Math.max(A,m),++x;}var v;const b=d-iu,{horizontalAlign:w,verticalAlign:_}=mu(o);((function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n-iu:(-n*l+.5)*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;}))(e.positionedLines,g,w,_,y,m,a,b,s.length),e.top+=-_*b,e.bottom=e.top+b,e.left+=-w*y,e.right=e.left+y;}(_,r,n,i,x,o,l,u,p,c,f,m),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(w)&&_}const lu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},uu={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function cu(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*Sl/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function hu(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function pu(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function fu(t,e,r,n,i,s){let a=null,o=hu(e,r,i,s);for(const t of n){const n=hu(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function du(t){return t?du(t.priorBreak).concat(t.index):[]}function yu(t,e,r,n,i,s,a){if("point"!==s)return [];if(!t)return [];const o=[],l=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=cu(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,a),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const s=t.getSection(r),p=t.getCharCode(r);if(lu[p]||(c+=cu(p,s,n,i,e,a)),r<t.length()-1){const e=!((h=p)<11904||!(Nn["Bopomofo Extended"](h)||Nn.Bopomofo(h)||Nn["CJK Compatibility Forms"](h)||Nn["CJK Compatibility Ideographs"](h)||Nn["CJK Compatibility"](h)||Nn["CJK Radicals Supplement"](h)||Nn["CJK Strokes"](h)||Nn["CJK Symbols and Punctuation"](h)||Nn["CJK Unified Ideographs Extension A"](h)||Nn["CJK Unified Ideographs"](h)||Nn["Enclosed CJK Letters and Months"](h)||Nn["Halfwidth and Fullwidth Forms"](h)||Nn.Hiragana(h)||Nn["Ideographic Description Characters"](h)||Nn["Kangxi Radicals"](h)||Nn["Katakana Phonetic Extensions"](h)||Nn.Katakana(h)||Nn["Vertical Forms"](h)||Nn["Yi Radicals"](h)||Nn["Yi Syllables"](h)));(uu[p]||e||s.imageName)&&o.push(fu(r+1,c,l,o,pu(p,t.getCharCode(r+1),e&&u),!1));}}var h;return du(fu(t.length(),c,l,o,0,!0))}function mu(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function gu(t,e,r,n,i){if(!n&&!i)return;const s=t[r],a=(t[r].x+s.metrics.advance*s.scale)*n;for(let n=e;n<=r;n++)t[n].x-=a,t[n].y+=i;}function xu(t,e,r){const{horizontalAlign:n,verticalAlign:i}=mu(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function vu(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o}}const bu=255,wu=128,_u=bu*wu;function Au(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new ti(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new ti(a)),maxSize:r.evaluate(new ti(o)),interpolationType:n}}}function Su(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const ku=Eo.VectorTileFeature.types,Iu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function zu(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(_u,Math.round(o[0])):0,d=o?Math.min(_u,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function Mu(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Bu(t){for(const e of t.sections)if(Wn(e.text))return !0;return !1}class Cu{constructor(t){this.layoutVertexArray=new cs,this.indexArray=new ys,this.programConfigurations=t,this.segments=new vs,this.dynamicLayoutVertexArray=new hs,this.opacityVertexArray=new ps,this.hasVisibleVertices=!1,this.placedSymbolArray=new Ji;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,gl.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,xl.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Iu,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}On("SymbolBuffers",Cu);class Pu{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new vs,this.collisionVertexArray=new ds;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,vl.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}On("CollisionBuffers",Pu);class Vu{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=ba([]),this.placementViewportMatrix=ba([]);const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Au(this.zoom,r["text-size"]),this.iconSizeData=Au(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==Su(n,"text-overlap","text-allow-overlap")||"never"!==Su(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((e=>t.ah[e]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID;}createArrays(){this.text=new Cu(new Zs(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new Cu(new Zs(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new Yi,this.lineVertexArray=new Wi,this.symbolInstances=new Hi,this.textAnchorOffsets=new ts;}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=Al[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof Yt&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new ti(this.zoom);for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=Ws(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=Ys(r)),u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=Yt.factory(t);Bu(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===Qn.getRTLTextPluginStatus()||this.hasRTLText&&Qn.isParsed())&&(x=_l(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof ee?t:ee.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:ku[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.ah.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else {const n=Zn(x.toString()),i=t.fontStack||e,s=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,r,n,i,s,a,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.ah.vertical?Math.PI/2:0,v=a.text&&a.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:s,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:A}=r[t],S=y.vertexLength,k=w[1];zu(d,l.x,l.y,i.x,k+i.y,c.x,c.y,n,_,h.x,h.y,g,b),zu(d,l.x,l.y,s.x,k+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),zu(d,l.x,l.y,o.x,k+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),zu(d,l.x,l.y,u.x,k+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),Mu(e.dynamicLayoutVertexArray,l,x),f.emplaceBack(S,S+1,S+2),f.emplaceBack(S+1,S+2,S+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),t!==r.length-1&&A===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,a,a.index,{},p,v&&v[A]);}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,r,n,i,a,o){const l=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),u=l.vertexLength,c=i.layoutVertexArray,h=i.collisionVertexArray,p=o.anchorX,f=o.anchorY;this._addCollisionDebugVertex(c,h,a,p,f,new s(t,e)),this._addCollisionDebugVertex(c,h,a,p,f,new s(r,e)),this._addCollisionDebugVertex(c,h,a,p,f,new s(r,n)),this._addCollisionDebugVertex(c,h,a,p,f,new s(t,n)),l.vertexLength+=4;const d=i.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Pu(fs,bl.members,ms),this.iconCollisionBox=new Pu(fs,bl.members,ms);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let Eu,Fu;On("SymbolBucket",Vu,{omit:["layers","collisionBoxArray","features","compareText"]}),Vu.MAX_GLYPHS=65535,Vu.addDynamicAttributes=Mu;var Tu={get paint(){return Fu=Fu||new di({"icon-opacity":new ci(G.paint_symbol["icon-opacity"]),"icon-color":new ci(G.paint_symbol["icon-color"]),"icon-halo-color":new ci(G.paint_symbol["icon-halo-color"]),"icon-halo-width":new ci(G.paint_symbol["icon-halo-width"]),"icon-halo-blur":new ci(G.paint_symbol["icon-halo-blur"]),"icon-translate":new ui(G.paint_symbol["icon-translate"]),"icon-translate-anchor":new ui(G.paint_symbol["icon-translate-anchor"]),"text-opacity":new ci(G.paint_symbol["text-opacity"]),"text-color":new ci(G.paint_symbol["text-color"],{runtimeType:ft,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new ci(G.paint_symbol["text-halo-color"]),"text-halo-width":new ci(G.paint_symbol["text-halo-width"]),"text-halo-blur":new ci(G.paint_symbol["text-halo-blur"]),"text-translate":new ui(G.paint_symbol["text-translate"]),"text-translate-anchor":new ui(G.paint_symbol["text-translate-anchor"])})},get layout(){return Eu=Eu||new di({"symbol-placement":new ui(G.layout_symbol["symbol-placement"]),"symbol-spacing":new ui(G.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new ui(G.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new ci(G.layout_symbol["symbol-sort-key"]),"symbol-z-order":new ui(G.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new ui(G.layout_symbol["icon-allow-overlap"]),"icon-overlap":new ui(G.layout_symbol["icon-overlap"]),"icon-ignore-placement":new ui(G.layout_symbol["icon-ignore-placement"]),"icon-optional":new ui(G.layout_symbol["icon-optional"]),"icon-rotation-alignment":new ui(G.layout_symbol["icon-rotation-alignment"]),"icon-size":new ci(G.layout_symbol["icon-size"]),"icon-text-fit":new ui(G.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new ui(G.layout_symbol["icon-text-fit-padding"]),"icon-image":new ci(G.layout_symbol["icon-image"]),"icon-rotate":new ci(G.layout_symbol["icon-rotate"]),"icon-padding":new ci(G.layout_symbol["icon-padding"]),"icon-keep-upright":new ui(G.layout_symbol["icon-keep-upright"]),"icon-offset":new ci(G.layout_symbol["icon-offset"]),"icon-anchor":new ci(G.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new ui(G.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new ui(G.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new ui(G.layout_symbol["text-rotation-alignment"]),"text-field":new ci(G.layout_symbol["text-field"]),"text-font":new ci(G.layout_symbol["text-font"]),"text-size":new ci(G.layout_symbol["text-size"]),"text-max-width":new ci(G.layout_symbol["text-max-width"]),"text-line-height":new ui(G.layout_symbol["text-line-height"]),"text-letter-spacing":new ci(G.layout_symbol["text-letter-spacing"]),"text-justify":new ci(G.layout_symbol["text-justify"]),"text-radial-offset":new ci(G.layout_symbol["text-radial-offset"]),"text-variable-anchor":new ui(G.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new ci(G.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new ci(G.layout_symbol["text-anchor"]),"text-max-angle":new ui(G.layout_symbol["text-max-angle"]),"text-writing-mode":new ui(G.layout_symbol["text-writing-mode"]),"text-rotate":new ci(G.layout_symbol["text-rotate"]),"text-padding":new ui(G.layout_symbol["text-padding"]),"text-keep-upright":new ui(G.layout_symbol["text-keep-upright"]),"text-transform":new ci(G.layout_symbol["text-transform"]),"text-offset":new ci(G.layout_symbol["text-offset"]),"text-allow-overlap":new ui(G.layout_symbol["text-allow-overlap"]),"text-overlap":new ui(G.layout_symbol["text-overlap"]),"text-ignore-placement":new ui(G.layout_symbol["text-ignore-placement"]),"text-optional":new ui(G.layout_symbol["text-optional"])})}};class $u{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:ut,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}On("FormatSectionOverride",$u,{omit:["defaultValue"]});class Du extends mi{constructor(t){super(t,Tu);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Dr(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new Vu(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of Tu.paint.overridableProperties){if(!Du.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new $u(e),n=new $r(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Or("source",n):new Rr("composite",n,e.value.zoomStops),this.paint._values[t]=new oi(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Du.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Tu.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Yt)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof ae&&ie(e.value)===gt?s(e.value.sections):e instanceof dr?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}}let Lu;var Ou={get paint(){return Lu=Lu||new di({"background-color":new ui(G.paint_background["background-color"]),"background-pattern":new pi(G.paint_background["background-pattern"]),"background-opacity":new ui(G.paint_background["background-opacity"])})}};class Ru extends mi{constructor(t){super(t,Ou);}}let Uu;var ju={get paint(){return Uu=Uu||new di({"raster-opacity":new ui(G.paint_raster["raster-opacity"]),"raster-hue-rotate":new ui(G.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new ui(G.paint_raster["raster-brightness-min"]),"raster-brightness-max":new ui(G.paint_raster["raster-brightness-max"]),"raster-saturation":new ui(G.paint_raster["raster-saturation"]),"raster-contrast":new ui(G.paint_raster["raster-contrast"]),"raster-resampling":new ui(G.paint_raster["raster-resampling"]),"raster-fade-duration":new ui(G.paint_raster["raster-fade-duration"])})}};class qu extends mi{constructor(t){super(t,ju);}}class Nu extends mi{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);},this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}class Zu{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle();}),0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const Ku=6371008.8;class Gu{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Gu(m(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return Ku*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof Gu)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Gu(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Gu(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Ju=2*Math.PI*Ku;function Xu(t){return Ju*Math.cos(t*Math.PI/180)}function Hu(t){return (180+t)/360}function Yu(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Wu(t,e){return t/Xu(e)}function Qu(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}class tc{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=Gu.convert(t);return new tc(Hu(r.lng),Yu(r.lat),Wu(e,r.lat))}toLngLat(){return new Gu(360*this.x-180,Qu(this.y))}toAltitude(){return this.z*Xu(Qu(this.y))}meterInMercatorCoordinateUnits(){return 1/Ju*(t=Qu(this.y),1/Math.cos(t*Math.PI/180));var t;}}function ec(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class rc{constructor(t,e,r){if(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=sc(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(s=this.y,a=this.z,o=ec(256*(i=this.x),256*(s=Math.pow(2,a)-s-1),a),l=ec(256*(i+1),256*(s+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var i,s,a,o,l;const u=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new s((t.x*e-this.x)*Js,(t.y*e-this.y)*Js)}toString(){return `${this.z}/${this.x}/${this.y}`}}class nc{constructor(t,e){this.wrap=t,this.canonical=e,this.key=sc(t,e.z,e.z,e.x,e.y);}}class ic{constructor(t,e,r,n,i){if(t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new rc(r,+n,+i),this.key=sc(e,t,r,n,i);}clone(){return new ic(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new ic(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new ic(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?sc(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):sc(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new ic(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new ic(e,this.wrap,e,r,n),new ic(e,this.wrap,e,r+1,n),new ic(e,this.wrap,e,r,n+1),new ic(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new ic(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new ic(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new nc(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new tc(t.x-this.wrap,t.y))}}function sc(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return (s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}On("CanonicalTileID",rc),On("OverscaledTileID",ic,{omit:["posMatrix"]});class ac{constructor(t,e,r,n=1,i=1,s=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void A(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return [this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}getPixels(){return new Fa({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:n=i-1;break;case 1:i=n+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}On("DEMData",ac);class oc{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class lc{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class uc{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new Dn(Js,16,0),this.grid3D=new Dn(Js,16,0),this.featureIndexArray=new rs,this.promoteId=e;}insert(t,e,r,n,i,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<Js&&n[1]<Js&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Eo.VectorTile(new Gl(this.rawTileData)).layers,this.sourceLayerCoder=new oc(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params||{},a=Js/t.tileSize/t.scale,o=Kr(i.filter),l=t.queryGeometry,u=t.queryPadding*a,c=hc(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=hc(t.cameraQueryGeometry),f=this.grid3D.query(p.minX-u,p.minY-u,p.maxX+u,p.maxY+u,((e,r,n,i)=>function(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const a=[new s(e,r),new s(e,i),new s(n,i),new s(n,r)];if(t.length>2)for(const e of a)if(ca(t,e))return !0;for(let e=0;e<t.length-1;e++)if(ha(t[e],t[e+1],a))return !0;return !1}(t.cameraQueryGeometry,e-u,r-u,n+u,i+u)));for(const t of f)h.push(t);h.sort(pc);const d={};let y;for(let s=0;s<h.length;s++){const u=h[s];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,o,i.layers,i.availableImages,e,r,n,((e,r,n)=>(p||(p=Ys(e)),r.queryIntersectsFeature(l,e,n,p,this.z,t.transform,a,t.pixelPosMatrix))));}return d}loadMatchingFeature(t,e,r,n,i,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(s,h))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=Ws(f,!0);if(!i.filter(new ti(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new ti(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&s.indexOf(r)<0)continue;const i=o[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",d));const y=g({},l[r]);y.paint=cc(y.paint,i.paint,f,p,a),y.layout=cc(y.layout,i.layout,f,p,a);const m=!c||c(f,i,p);if(!m)continue;const x=new lc(f,this.z,this.x,this.y,d);x.layer=y;let v=t[r];void 0===v&&(v=t[r]=[]),v.push({featureIndex:n,feature:x,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=Kr(i);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r))),r}}function cc(t,e,r,n,i){return v(t,((t,s)=>{const a=e instanceof li?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function hc(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {minX:e,minY:r,maxX:n,maxY:i}}function pc(t,e){return e-t}function fc(t,e,r,n,i){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new s(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new s(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<r&&c.y<r||(o.y<r?o=new s(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round():c.y<r&&(c=new s(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round()),o.x>=n&&c.x>=n||(o.x>=n?o=new s(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=n&&(c=new s(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=i&&c.y>=i||(o.y>=i?o=new s(o.x+(i-o.y)/(c.y-o.y)*(c.x-o.x),i)._round():c.y>=i&&(c=new s(o.x+(i-o.y)/(c.y-o.y)*(c.x-o.x),i)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}On("FeatureIndex",uc,{omit:["rawTileData","sourceLayerCoder"]});class dc extends s{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new dc(this.x,this.y,this.angle,this.segment)}}function yc(t,e,r,n,i){if(void 0===e.segment||0===r)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function mc(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function gc(t,e,r){return t?.6*e*r:0}function xc(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function vc(t,e,r,n,i,s){const a=gc(r,i,s),o=xc(r,n)*s;let l=0;const u=mc(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=Ge.number(n.x,i.x,c),p=Ge.number(n.y,i.y,c),f=new dc(h,p,i.angleTo(n),r);return f._round(),!a||yc(t,f,o,a,e)?f:void 0}l+=s;}}function bc(t,e,r,n,i,s,a,o,l){const u=gc(n,s,a),c=xc(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),wc(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function wc(t,e,r,n,i,s,a,o,l){const u=s/2,c=mc(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=Ge.number(a.x,o.x,m),x=Ge.number(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new dc(g,x,y,e);r._round(),n&&!yc(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=wc(t,h/2,r,n,i,s,a,!0,l)),f}On("Anchor",dc);const _c=tu;function Ac(t,e,r,n){const i=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2*_c,u=a.paddedRect.h-2*_c,c=t.right-t.left,h=t.bottom-t.top,p=a.stretchX||[[0,l]],f=a.stretchY||[[0,u]],d=(t,e)=>t+e[1]-e[0],y=p.reduce(d,0),m=f.reduce(d,0),g=l-y,x=u-m;let v=0,b=y,w=0,_=m,A=0,S=g,k=0,I=x;if(a.content&&n){const t=a.content;v=Sc(p,0,t[0]),w=Sc(f,0,t[1]),b=Sc(p,t[0],t[2]),_=Sc(f,t[1],t[3]),A=t[0]-v,k=t[1]-w,S=t[2]-t[0]-b,I=t[3]-t[1]-_;}const z=(n,i,l,u)=>{const p=Ic(n.stretch-v,b,c,t.left),f=zc(n.fixed-A,S,n.stretch,y),d=Ic(i.stretch-w,_,h,t.top),g=zc(i.fixed-k,I,i.stretch,m),x=Ic(l.stretch-v,b,c,t.left),z=zc(l.fixed-A,S,l.stretch,y),M=Ic(u.stretch-w,_,h,t.top),B=zc(u.fixed-k,I,u.stretch,m),C=new s(p,d),P=new s(x,d),V=new s(x,M),E=new s(p,M),F=new s(f/o,g/o),T=new s(z/o,B/o),$=e*Math.PI/180;if($){const t=Math.sin($),e=Math.cos($),r=[e,-t,t,e];C._matMult(r),P._matMult(r),E._matMult(r),V._matMult(r);}const D=n.stretch+n.fixed,L=i.stretch+i.fixed;return {tl:C,tr:P,bl:E,br:V,tex:{x:a.paddedRect.x+_c+D,y:a.paddedRect.y+_c+L,w:l.stretch+l.fixed-D,h:u.stretch+u.fixed-L},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:T,minFontScaleX:S/o/c,minFontScaleY:I/o/h,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=kc(p,g,y),e=kc(f,x,m);for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)i.push(z(n,e[t],s,e[t+1]));}}else i.push(z({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return i}function Sc(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function kc(t,e,r){const n=[{fixed:-_c,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+_c,stretch:r}),n}function Ic(t,e,r,n){return t/e*r+n}function zc(t,e,r,n){return t-e*r/n}class Mc{constructor(t,e,r,n,i,a,o,l,u,c){if(this.boxStartIndex=t.length,u){let t=a.top,e=a.bottom;const r=a.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else {let u=a.top*o-l[0],h=a.bottom*o+l[2],p=a.left*o-l[3],f=a.right*o+l[1];const d=a.collisionPadding;if(d&&(p-=d[0]*o,u-=d[1]*o,f+=d[2]*o,h+=d[3]*o),c){const t=new s(p,u),e=new s(f,u),r=new s(p,h),n=new s(f,h),i=c*Math.PI/180;t._rotate(i),e._rotate(i),r._rotate(i),n._rotate(i),p=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),u=Math.min(t.y,e.y,r.y,n.y),h=Math.max(t.y,e.y,r.y,n.y);}t.emplaceBack(e.x,e.y,p,u,f,h,r,n,i);}this.boxEndIndex=t.length;}}class Bc{constructor(t=[],e=Cc){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this.length++,this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1),s=e[n];const a=n+1;if(a<this.length&&r(e[a],s)<0&&(n=a,s=e[a]),r(s,i)>=0)break;e[t]=s,t=n;}e[t]=i;}}function Cc(t,e){return t<e?-1:t>e?1:0}function Pc(t,e=1,r=!1){let n=1/0,i=1/0,a=-1/0,o=-1/0;const l=t[0];for(let t=0;t<l.length;t++){const e=l[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>o)&&(o=e.y);}const u=Math.min(a-n,o-i);let c=u/2;const h=new Bc([],Vc);if(0===u)return new s(n,i);for(let e=n;e<a;e+=u)for(let r=i;r<o;r+=u)h.push(new Ec(e+c,r+c,c,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new Ec(r/e,n/e,0,t)}(t),f=h.length;for(;h.length;){const n=h.pop();(n.d>p.d||!p.d)&&(p=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,f)),n.max-p.d<=e||(c=n.h/2,h.push(new Ec(n.p.x-c,n.p.y-c,c,t)),h.push(new Ec(n.p.x+c,n.p.y-c,c,t)),h.push(new Ec(n.p.x-c,n.p.y+c,c,t)),h.push(new Ec(n.p.x+c,n.p.y+c,c,t)),f+=4);}return r&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function Vc(t,e){return e.max-t.max}function Ec(t,e,r,n){this.p=new s(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,la(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}var Fc;t.ap=void 0,(Fc=t.ap||(t.ap={}))[Fc.center=1]="center",Fc[Fc.left=2]="left",Fc[Fc.right=3]="right",Fc[Fc.top=4]="top",Fc[Fc.bottom=5]="bottom",Fc[Fc["top-left"]=6]="top-left",Fc[Fc["top-right"]=7]="top-right",Fc[Fc["bottom-left"]=8]="bottom-left",Fc[Fc["bottom-right"]=9]="bottom-right";const Tc=7,$c=Number.POSITIVE_INFINITY;function Dc(t,e){return e[1]!==$c?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":i=r-Tc;break;case"bottom-right":case"bottom-left":case"bottom":i=-r+Tc;}switch(t){case"top-right":case"bottom-right":case"right":n=-e;break;case"top-left":case"bottom-left":case"left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case"top-right":case"top-left":n=i-Tc;break;case"bottom-right":case"bottom-left":n=-i+Tc;break;case"bottom":n=-e+Tc;break;case"top":n=e-Tc;}switch(t){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=e;break;case"right":r=-e;}return [r,n]}(t,e[0])}function Lc(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*Sl));n.startsWith("top")?i[1]-=Tc:n.startsWith("bottom")&&(i[1]+=Tc),e[r+1]=i;}return new te(e)}const a=i.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*Sl,$c]:i.get("text-offset").evaluate(e,{},r).map((t=>t*Sl));const s=[];for(const t of a)s.push(t,Dc(t,n));return new te(s)}return null}function Oc(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function Rc(e,r,n,i,s,a,o,l,u,c,h){let p=a.textMaxSize.evaluate(r,{});void 0===p&&(p=o);const f=e.layers[0].layout,d=f.get("icon-offset").evaluate(r,{},h),y=jc(n.horizontal),m=o/24,g=e.tilePixelRatio*m,x=e.tilePixelRatio*p/24,v=e.tilePixelRatio*l,b=e.tilePixelRatio*f.get("symbol-spacing"),w=f.get("text-padding")*e.tilePixelRatio,_=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return [s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(f,r,h,e.tilePixelRatio),S=f.get("text-max-angle")/180*Math.PI,k="viewport"!==f.get("text-rotation-alignment")&&"point"!==f.get("symbol-placement"),I="map"===f.get("icon-rotation-alignment")&&"point"!==f.get("symbol-placement"),z=f.get("symbol-placement"),M=b/2,B=f.get("icon-text-fit");let C;i&&"none"!==B&&(e.allowVerticalPlacement&&n.vertical&&(C=vu(i,n.vertical,B,f.get("icon-text-fit-padding"),d,m)),y&&(i=vu(i,y,B,f.get("icon-text-fit-padding"),d,m)));const P=(l,p)=>{p.x<0||p.x>=Js||p.y<0||p.y>=Js||function(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,k,I){const z=e.addToLineVertexArray(r,n);let M,B,C,P,V=0,E=0,F=0,T=0,$=-1,D=-1;const L={};let O=Ms("");if(e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},k)+90;C=new Mc(u,r,c,h,p,i.vertical,f,d,y,t),o&&(P=new Mc(u,r,c,h,p,o,g,x,y,t));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),a=Ac(s,n,S,i),f=o?Ac(o,n,S,i):void 0;B=new Mc(u,r,c,h,p,s,g,x,!1,n),V=4*a.length;const d=e.iconSizeData;let y=null;"source"===d.kind?(y=[wu*l.layout.get("icon-size").evaluate(w,{})],y[0]>_u&&A(`${e.layerIds[0]}: Value for "icon-size" is >= ${bu}. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[wu*_.compositeIconSizes[0].evaluate(w,{},k),wu*_.compositeIconSizes[1].evaluate(w,{},k)],(y[0]>_u||y[1]>_u)&&A(`${e.layerIds[0]}: Value for "icon-size" is >= ${bu}. Reduce your "icon-size".`)),e.addSymbols(e.icon,a,y,b,v,w,t.ah.none,r,z.lineStartIndex,z.lineLength,-1,k),$=e.icon.placedSymbolArray.length-1,f&&(E=4*f.length,e.addSymbols(e.icon,f,y,b,v,w,t.ah.vertical,r,z.lineStartIndex,z.lineLength,-1,k),D=e.icon.placedSymbolArray.length-1);}const R=Object.keys(i.horizontal);for(const n of R){const s=i.horizontal[n];if(!M){O=Ms(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},k);M=new Mc(u,r,c,h,p,s,f,d,y,t);}const o=1===s.positionedLines.length;if(F+=Uc(e,r,s,a,l,y,w,m,z,i.vertical?t.ah.horizontal:t.ah.horizontalOnly,o?R:[n],L,$,_,k),o)break}i.vertical&&(T+=Uc(e,r,i.vertical,a,l,y,w,m,z,t.ah.vertical,["vertical"],L,D,_,k));const U=M?M.boxStartIndex:e.collisionBoxArray.length,j=M?M.boxEndIndex:e.collisionBoxArray.length,q=C?C.boxStartIndex:e.collisionBoxArray.length,N=C?C.boxEndIndex:e.collisionBoxArray.length,Z=B?B.boxStartIndex:e.collisionBoxArray.length,K=B?B.boxEndIndex:e.collisionBoxArray.length,G=P?P.boxStartIndex:e.collisionBoxArray.length,J=P?P.boxEndIndex:e.collisionBoxArray.length;let X=-1;const H=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;X=H(M,X),X=H(C,X),X=H(B,X),X=H(P,X);const Y=X>-1?1:0;Y&&(X*=I/Sl),e.glyphOffsetArray.length>=Vu.MAX_GLYPHS&&A("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const W=Lc(l,w,k),[Q,tt]=function(e,r){const n=e.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];e.emplaceBack(t.ap[i[r]],n[0],n[1]);}return [n,e.length]}(e.textAnchorOffsets,W);e.symbolInstances.emplaceBack(r.x,r.y,L.right>=0?L.right:-1,L.center>=0?L.center:-1,L.left>=0?L.left:-1,L.vertical||-1,$,D,O,U,j,q,N,Z,K,G,J,c,F,T,V,E,Y,0,f,X,Q,tt);}(e,p,l,n,i,s,C,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,g,[w,w,w,w],k,u,v,_,I,d,r,a,c,h,o);};if("line"===z)for(const t of fc(r.geometry,0,0,Js,Js)){const r=bc(t,b,S,n.vertical||y,i,24,x,e.overscaling,Js);for(const n of r)y&&qc(e,y.text,M,n)||P(t,n);}else if("line-center"===z){for(const t of r.geometry)if(t.length>1){const e=vc(t,S,n.vertical||y,i,24,x);e&&P(t,e);}}else if("Polygon"===r.type)for(const t of wo(r.geometry,0)){const e=Pc(t,16);P(t[0],new dc(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry)P(t,new dc(t[0].x,t[0].y,0));else if("Point"===r.type)for(const t of r.geometry)for(const e of t)P([e],new dc(e.x,e.y,0));}function Uc(t,e,r,n,i,a,o,l,u,c,h,p,f,d,y){const m=function(t,e,r,n,i,a,o,l){const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const a=n.rect||{};let h=Wl+1,p=!0,f=1,d=0;const y=(i||l)&&n.vertical,m=n.metrics.advance*n.scale/2;if(l&&e.verticalizable&&(d=t.lineOffset/2-(n.imageName?-(Sl-n.metrics.width*n.scale)/2:(n.scale-1)*Sl)),n.imageName){const t=o[n.imageName];p=t.sdf,f=t.pixelRatio,h=tu/f;}const g=i?[n.x+m,n.y]:[0,0];let x=i?[0,0]:[n.x+m+r[0],n.y+r[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=n.metrics.isDoubleResolution?2:1,w=(n.metrics.left-h)*n.scale-m+x[0],_=(-n.metrics.top-h)*n.scale+x[1],A=w+a.w/b*n.scale/f,S=_+a.h/b*n.scale/f,k=new s(w,_),I=new s(A,_),z=new s(w,S),M=new s(A,S);if(y){const t=new s(-m,m-iu),e=-Math.PI/2,r=Sl/2-m,i=new s(5-iu-r,-(n.imageName?r:0)),a=new s(...v);k._rotateAround(e,t)._add(i)._add(a),I._rotateAround(e,t)._add(i)._add(a),z._rotateAround(e,t)._add(i)._add(a),M._rotateAround(e,t)._add(i)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),I._matMult(r),z._matMult(r),M._matMult(r);}const B=new s(0,0),C=new s(0,0);c.push({tl:k,tr:I,bl:z,br:M,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:B,pixelOffsetBR:C,minFontScaleX:0,minFontScaleY:0});}return c}(0,r,l,i,a,o,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[wu*i.layout.get("text-size").evaluate(o,{})],x[0]>_u&&A(`${t.layerIds[0]}: Value for "text-size" is >= ${bu}. Reduce your "text-size".`)):"composite"===g.kind&&(x=[wu*d.compositeTextSizes[0].evaluate(o,{},y),wu*d.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>_u||x[1]>_u)&&A(`${t.layerIds[0]}: Value for "text-size" is >= ${bu}. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function jc(t){for(const e in t)return t[e];return null}function qc(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const Nc=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Zc{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Nc[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new Zc(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=Nc.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return Kc(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Hc(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Hc(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function Kc(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;Gc(t,e,a,n,i,s),Kc(t,e,r,n,a-1,1-s),Kc(t,e,r,a+1,i,1-s);}function Gc(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);Gc(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(Jc(t,e,n,r),e[2*i+s]>a&&Jc(t,e,n,i);o<l;){for(Jc(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?Jc(t,e,n,l):(l++,Jc(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function Jc(t,e,r,n){Xc(t,r,n),Xc(e,2*r,2*n),Xc(e,2*r+1,2*n+1);}function Xc(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Hc(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}var Yc;t.bc=void 0,(Yc=t.bc||(t.bc={})).create="create",Yc.load="load",Yc.fullLoad="fullLoad";let Wc=null,Qc=[];const th=1e3/60,eh="loadTime",rh="fullLoadTime",nh={mark(t){performance.mark(t);},frame(t){const e=t;null!=Wc&&Qc.push(e-Wc),Wc=e;},clearMetrics(){Wc=null,Qc=[],performance.clearMeasures(eh),performance.clearMeasures(rh);for(const e in t.bc)performance.clearMarks(t.bc[e]);},getPerformanceMetrics(){performance.measure(eh,t.bc.create,t.bc.load),performance.measure(rh,t.bc.create,t.bc.fullLoad);const e=performance.getEntriesByName(eh)[0].duration,r=performance.getEntriesByName(rh)[0].duration,n=Qc.length,i=1/(Qc.reduce(((t,e)=>t+e),0)/n/1e3),s=Qc.filter((t=>t>th)).reduce(((t,e)=>t+(e-th)/th),0);return {loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n}}};t.$=vs,t.A=va,t.B=function(t){if(null==z){const e=t.navigator?t.navigator.userAgent:null;z=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return z},t.C=class{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Zu((()=>this.process())),this.subscription=function(t,e,r,n){return t.addEventListener(e,r,!1),{unsubscribe:()=>{t.removeEventListener(e,r,!1);}}}(this.target,"message",(t=>this.receive(t))),this.globalScope=I(self)?t:window;}registerMessageHandler(t,e){this.messageHandlers[t]=e;}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10);this.resolveRejects[i]={resolve:r,reject:n},e&&e.signal.addEventListener("abort",(()=>{delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e);}),{once:!0});const s=[],a=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:Un(t.data,s)});this.target.postMessage(a,{transfer:s});}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(I(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e);}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e);}processTask(t,r){return e(this,void 0,void 0,(function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(jn(r.error)):e.resolve(jn(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=jn(r.data),n=new AbortController;this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i);}catch(e){this.completeTask(t,e);}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?Un(e):null,data:Un(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},t.D=ui,t.E=K,t.F=function(){var t=new va(16);return va!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.G=D,t.H=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t},t.I=eu,t.J=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.K=wa,t.L=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.M=Gu,t.N=Hu,t.O=Yu,t.P=s,t.Q=ic,t.R=Fa,t.S=h,t.T=ni,t.U=p,t.V=C,t.W=Js,t.X=bi,t.Y=tc,t.Z=class extends Si{},t._=e,t.a=T,t.a$=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]*e[3]},t.a0=rc,t.a1=st,t.a2=t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((r=>{e.onloadstart=()=>{r(e);};for(const r of t){const t=window.document.createElement("source");U(r)||(e.crossOrigin="Anonymous"),t.src=r,e.appendChild(t);}}))},t.a3=function(){return x++},t.a4=Ki,t.a5=Vu,t.a6=Kr,t.a7=Ws,t.a8=ti,t.a9=lc,t.aA=w,t.aB=function(t,e){if(!t)return [{command:"setStyle",args:[e]}];let r=[];try{if(!H(t.version,e.version))return [{command:"setStyle",args:[e]}];H(t.center,e.center)||r.push({command:"setCenter",args:[e.center]}),H(t.zoom,e.zoom)||r.push({command:"setZoom",args:[e.zoom]}),H(t.bearing,e.bearing)||r.push({command:"setBearing",args:[e.bearing]}),H(t.pitch,e.pitch)||r.push({command:"setPitch",args:[e.pitch]}),H(t.sprite,e.sprite)||r.push({command:"setSprite",args:[e.sprite]}),H(t.glyphs,e.glyphs)||r.push({command:"setGlyphs",args:[e.glyphs]}),H(t.transition,e.transition)||r.push({command:"setTransition",args:[e.transition]}),H(t.light,e.light)||r.push({command:"setLight",args:[e.light]}),H(t.terrain,e.terrain)||r.push({command:"setTerrain",args:[e.terrain]}),H(t.sky,e.sky)||r.push({command:"setSky",args:[e.sky]});const n={},i=[];!function(t,e,r,n){let i;for(i in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)||Q(i,r,n));for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)?H(t[i],e[i])||("geojson"===t[i].type&&"geojson"===e[i].type&&et(t,e,i)?Y(r,{command:"setGeoJSONSourceData",args:[i,e[i].data]}):tt(i,e,r,n)):W(i,e,r));}(t.sources,e.sources,i,n);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&n[t.source]?r.push({command:"removeLayer",args:[t.id]}):s.push(t);})),r=r.concat(i),function(t,e,r){e=e||[];const n=(t=t||[]).map(nt),i=e.map(nt),s=t.reduce(it,{}),a=e.reduce(it,{}),o=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let t=0,e=0;t<n.length;t++)u=n[t],Object.prototype.hasOwnProperty.call(a,u)?e++:(Y(r,{command:"removeLayer",args:[u]}),o.splice(o.indexOf(u,e),1));for(let t=0,e=0;t<i.length;t++)u=i[i.length-1-t],o[o.length-1-t]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(Y(r,{command:"removeLayer",args:[u]}),o.splice(o.lastIndexOf(u,o.length-e),1)):e++,p=o[o.length-t],Y(r,{command:"addLayer",args:[a[u],p]}),o.splice(o.length-t,0,u),l[u]=!0);for(let t=0;t<i.length;t++)if(u=i[t],c=s[u],h=a[u],!l[u]&&!H(c,h))if(H(c.source,h.source)&&H(c["source-layer"],h["source-layer"])&&H(c.type,h.type)){for(f in rt(c.layout,h.layout,r,u,null,"setLayoutProperty"),rt(c.paint,h.paint,r,u,null,"setPaintProperty"),H(c.filter,h.filter)||Y(r,{command:"setFilter",args:[u,h.filter]}),H(c.minzoom,h.minzoom)&&H(c.maxzoom,h.maxzoom)||Y(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?rt(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):H(c[f],h[f])||Y(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?rt(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):H(c[f],h[f])||Y(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else Y(r,{command:"removeLayer",args:[u]}),p=o[o.lastIndexOf(u)+1],Y(r,{command:"addLayer",args:[h,p]});}(s,e.layers,r);}catch(t){console.warn("Unable to compute style diff:",t),r=[{command:"setStyle",args:[e]}];}return r},t.aC=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.aD=function t(e,r){if(Array.isArray(e)){if(!Array.isArray(r)||e.length!==r.length)return !1;for(let n=0;n<e.length;n++)if(!t(e[n],r[n]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==r){if("object"!=typeof r)return !1;if(Object.keys(e).length!==Object.keys(r).length)return !1;for(const n in e)if(!t(e[n],r[n]))return !1;return !0}return e===r},t.aE=v,t.aF=b,t.aG=class extends Es{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.aH=Fs,t.aI=class extends Es{constructor(t,e){super(t,e),this.current=Ds;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.aJ=Ts,t.aK=class extends Es{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.aL=class extends Es{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.aM=$s,t.aN=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.aO=Jt,t.aP=Aa,t.aQ=class extends Fi{},t.aR=wl,t.aS=class extends $i{},t.aT=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.aU=Ta,t.aV=ns,t.aW=class extends qi{},t.aX=ys,t.aY=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],y=t[13],m=t[14],g=t[15],x=e[0],v=e[1],b=e[2],w=e[3],_=e[4],A=e[5],S=e[6],k=e[7],I=e[8],z=e[9],M=e[10],B=e[11],C=e[12],P=e[13],V=e[14],E=e[15];return Math.abs(r-x)<=xa*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(n-v)<=xa*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(i-b)<=xa*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(s-w)<=xa*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(a-_)<=xa*Math.max(1,Math.abs(a),Math.abs(_))&&Math.abs(o-A)<=xa*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-S)<=xa*Math.max(1,Math.abs(l),Math.abs(S))&&Math.abs(u-k)<=xa*Math.max(1,Math.abs(u),Math.abs(k))&&Math.abs(c-I)<=xa*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-z)<=xa*Math.max(1,Math.abs(h),Math.abs(z))&&Math.abs(p-M)<=xa*Math.max(1,Math.abs(p),Math.abs(M))&&Math.abs(f-B)<=xa*Math.max(1,Math.abs(f),Math.abs(B))&&Math.abs(d-C)<=xa*Math.max(1,Math.abs(d),Math.abs(C))&&Math.abs(y-P)<=xa*Math.max(1,Math.abs(y),Math.abs(P))&&Math.abs(m-V)<=xa*Math.max(1,Math.abs(m),Math.abs(V))&&Math.abs(g-E)<=xa*Math.max(1,Math.abs(g),Math.abs(E))},t.aZ=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.a_=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t},t.aa=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e},t.ab=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.ac=y,t.ad=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.ae=function(t){var e=new va(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.af=Sa,t.ag=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?y(Je.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=Ge.number(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}},t.ai=function(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/wu:"composite"===t.kind?Ge.number(n/wu,i/wu,r):e},t.aj=Mu,t.ak=function(t,e,r,n){const i=e.y-t.y,a=e.x-t.x,o=n.y-r.y,l=n.x-r.x,u=o*a-l*i;if(0===u)return null;const c=(l*(t.y-r.y)-o*(t.x-r.x))/u;return new s(t.x+c*a,t.y+c*i)},t.al=fc,t.am=ea,t.an=ba,t.ao=Sl,t.aq=Su,t.ar=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,A=i*u-s*l,S=c*y-h*d,k=c*m-p*d,I=c*g-f*d,z=h*m-p*y,M=h*g-f*y,B=p*g-f*m,C=x*B-v*M+b*z+w*I-_*k+A*S;return C?(t[0]=(o*B-l*M+u*z)*(C=1/C),t[1]=(i*M-n*B-s*z)*C,t[2]=(y*A-m*_+g*w)*C,t[3]=(p*_-h*A-f*w)*C,t[4]=(l*I-a*B-u*k)*C,t[5]=(r*B-i*I+s*k)*C,t[6]=(m*b-d*A-g*v)*C,t[7]=(c*A-p*b+f*v)*C,t[8]=(a*M-o*I+u*S)*C,t[9]=(n*I-r*M-s*S)*C,t[10]=(d*_-y*b+g*x)*C,t[11]=(h*b-c*_-f*x)*C,t[12]=(o*k-a*z-l*S)*C,t[13]=(r*z-n*k+i*S)*C,t[14]=(y*v-d*w-m*x)*C,t[15]=(c*w-h*v+p*x)*C,t):null},t.as=Oc,t.at=mu,t.au=Zc,t.av=function(){const t={},e=G.$version;for(const r in G.$root){const n=G.$root[r];if(n.required){let i=null;i="version"===r?e:"array"===n.type?[]:{},null!=i&&(t[r]=i);}}return t},t.aw=qn,t.ax=O,t.ay=function(t){t=t.slice();const e=Object.create(null);for(let r=0;r<t.length;r++)e[t[r].id]=t[r];for(let r=0;r<t.length;r++)"ref"in t[r]&&(t[r]=X(t[r],e[t[r].ref]));return t},t.az=function(t){if("custom"===t.type)return new Nu(t);switch(t.type){case"background":return new Ru(t);case"circle":return new ka(t);case"fill":return new Bo(t);case"fill-extrusion":return new Qo(t);case"heatmap":return new $a(t);case"hillshade":return new Oa(t);case"line":return new yl(t);case"raster":return new qu(t);case"symbol":return new Du(t)}},t.b=M,t.b0=m,t.b1=nc,t.b2=Wu,t.b3=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.b4=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},t.b5=f,t.b6=d,t.b7=function(t){return t*Math.PI/180},t.b8=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.b9=class extends Ai{},t.ba=Ku,t.bb=nh,t.bd=L,t.be=function(t,e){T.REGISTERED_PROTOCOLS[t]=e;},t.bf=function(t){delete T.REGISTERED_PROTOCOLS[t];},t.bg=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||en(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n]);}const n=[];for(const t in r)n.push(r[t]);return n},t.bh=On,t.bi=oc,t.bj=uc,t.bk=ru,t.bl=function(e){e.bucket.createArrays(),e.bucket.tilePixelRatio=Js/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new ti(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new ti(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new ti(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new ti(t),e.canonical),i["text-size"].possiblyEvaluate(new ti(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new ti(t),e.canonical),i["icon-size"].possiblyEvaluate(new ti(r),e.canonical)];}const a=n.get("text-line-height")*Sl,o="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*Sl,f=Kn(s)?u:0,m=n.get("text-anchor").evaluate(i,{},e.canonical),x=Lc(r,i,e.canonical);if(!x){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?Dc(m,[t*Sl,$c]):n.get("text-offset").evaluate(i,{},e.canonical).map((t=>t*Sl));}let v=o?"center":n.get("text-justify").evaluate(i,{},e.canonical);const b=n.get("symbol-placement"),w="point"===b?n.get("text-max-width").evaluate(i,{},e.canonical)*Sl:0,_=()=>{e.bucket.allowVerticalPlacement&&Zn(s)&&(d.vertical=ou(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,w,a,m,"left",f,g,t.ah.vertical,!0,b,p,h));};if(!o&&x){const r=new Set;if("auto"===v)for(let t=0;t<x.values.length;t+=2)r.add(Oc(x.values[t]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else {const r=ou(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,w,a,"center",i,f,g,t.ah.horizontal,!1,b,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}_();}else {"auto"===v&&(v=Oc(m));const r=ou(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,w,a,m,v,f,g,t.ah.horizontal,!1,b,p,h);r&&(d.horizontal[v]=r),_(),Zn(s)&&o&&l&&(d.vertical=ou(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,w,a,m,v,f,g,t.ah.vertical,!1,b,p,h));}}let x=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=xu(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),x=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&A("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=jc(d.horizontal)||d.vertical;e.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&Rc(e.bucket,i,d,m,e.imageMap,s,p,f,g,x,e.canonical);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();},t.bm=ul,t.bn=ko,t.bo=Jo,t.bp=Eo,t.bq=Gl,t.br=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}},t.bs=function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if(p())try{return yield C(t,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,a=t.height;P&&V||(P=new OffscreenCanvas(s,a),V=P.getContext("2d",{willReadFrequently:!0})),P.width=s,P.height=a,V.drawImage(t,0,0,s,a);const o=V.getImageData(e,r,n,i);return V.clearRect(0,0,s,a),o.data}(t,r,n,i,s)}))},t.bt=ac,t.bu=r,t.bv=n,t.bw=kl,t.bx=Lr,t.by=function(t){return t.message===E},t.bz=Qn,t.c=F,t.d=t=>e(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})),t.e=g,t.f=t=>new Promise(((e,r)=>{const n=new Image;n.onload=()=>{e(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame((()=>{n.src=B;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?URL.createObjectURL(i):B;})),t.g=$,t.h=(t,e)=>R(g(t,{type:"json"}),e),t.i=I,t.j=Z,t.k=N,t.l=(t,e)=>R(g(t,{type:"arrayBuffer"}),e),t.m=R,t.n=function(t){return new Gl(t).readFields(Xl,[])},t.o=Ea,t.p=Ql,t.q=di,t.r=En,t.s=U,t.t=$n,t.u=Nn,t.v=G,t.w=A,t.x=Vn,t.y=function([t,e,r]){return e+=90,e*=Math.PI/180,r*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)}},t.z=Ge;}));

define("worker",["./shared"],(function(e){"use strict";class t{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,r){for(const r of t){this._layerConfigs[r.id]=r;const t=this._layers[r.id]=e.az(r);t._featureFilter=e.a6(t.filter),this.keyCache[r.id]&&delete this.keyCache[r.id];}for(const e of r)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const i=e.bg(Object.values(this._layerConfigs),this.keyCache);for(const e of i){const t=e.map((e=>this._layers[e.id])),r=t[0];if("none"===r.visibility)continue;const i=r.source||"";let o=this.familiesBySource[i];o||(o=this.familiesBySource[i]={});const s=r.sourceLayer||"_geojsonTileLayer";let n=o[s];n||(n=o[s]=[]),n.push(t);}}}class r{constructor(t){const r={},i=[];for(const e in t){const o=t[e],s=r[e]={};for(const e in o){const t=o[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const r={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};i.push(r),s[e]={rect:r,metrics:t.metrics};}}const{w:o,h:s}=e.p(i),n=new e.o({width:o||1,height:s||1});for(const i in t){const o=t[i];for(const t in o){const s=o[+t];if(!s||0===s.bitmap.width||0===s.bitmap.height)continue;const a=r[i][t].rect;e.o.copy(s.bitmap,n,{x:0,y:0},{x:a.x+1,y:a.y+1},s.bitmap);}}this.image=n,this.positions=r;}}e.bh("GlyphAtlas",r);class i{constructor(t){this.tileID=new e.Q(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[];}parse(t,i,s,n){return e._(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.a4;const a=new e.bi(Object.keys(t.layers).sort()),l=new e.bj(this.tileID,this.promoteId);l.bucketLayerIDs=[];const h={},u={featureIndex:l,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:s},c=i.familiesBySource[this.source];for(const r in c){const i=t.layers[r];if(!i)continue;1===i.version&&e.w(`Vector tile source "${this.source}" layer "${r}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const n=a.encode(r),d=[];for(let e=0;e<i.length;e++){const t=i.feature(e),o=l.getId(t,r);d.push({feature:t,id:o,index:e,sourceLayerIndex:n});}for(const t of c[r]){const r=t[0];r.source!==this.source&&e.w(`layer.source = ${r.source} does not equal this.source = ${this.source}`),r.minzoom&&this.zoom<Math.floor(r.minzoom)||r.maxzoom&&this.zoom>=r.maxzoom||"none"!==r.visibility&&(o(t,this.zoom,s),(h[r.id]=r.createBucket({index:l.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:n,sourceID:this.source})).populate(d,u,this.tileID.canonical),l.bucketLayerIDs.push(t.map((e=>e.id))));}}const d=e.aE(u.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let f=Promise.resolve({});if(Object.keys(d).length){const e=new AbortController;this.inFlightDependencies.push(e),f=n.sendAsync({type:"getGlyphs",data:{stacks:d,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const p=Object.keys(u.iconDependencies);let g=Promise.resolve({});if(p.length){const e=new AbortController;this.inFlightDependencies.push(e),g=n.sendAsync({type:"getImages",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e);}const m=Object.keys(u.patternDependencies);let v=Promise.resolve({});if(m.length){const e=new AbortController;this.inFlightDependencies.push(e),v=n.sendAsync({type:"getImages",data:{icons:m,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const[y,w,x]=yield Promise.all([f,g,v]),b=new r(y),M=new e.bk(w,x);for(const t in h){const r=h[t];r instanceof e.a5?(o(r.layers,this.zoom,s),e.bl({bucket:r,glyphMap:y,glyphPositions:b.positions,imageMap:w,imagePositions:M.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical})):r.hasPattern&&(r instanceof e.bm||r instanceof e.bn||r instanceof e.bo)&&(o(r.layers,this.zoom,s),r.addFeatures(u,this.tileID.canonical,M.patternPositions));}return this.status="done",{buckets:Object.values(h).filter((e=>!e.isEmpty())),featureIndex:l,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:b.image,imageAtlas:M,glyphMap:this.returnDependencies?y:null,iconMap:this.returnDependencies?w:null,glyphPositions:this.returnDependencies?b.positions:null}}))}}function o(t,r,i){const o=new e.a8(r);for(const e of t)e.recalculate(o,i);}class s{constructor(e,t,r){this.actor=e,this.layerIndex=t,this.availableImages=r,this.fetching={},this.loading={},this.loaded={};}loadVectorTile(t,r){return e._(this,void 0,void 0,(function*(){const i=yield e.l(t.request,r);try{return {vectorTile:new e.bp.VectorTile(new e.bq(i.data)),rawData:i.data,cacheControl:i.cacheControl,expires:i.expires}}catch(e){const r=new Uint8Array(i.data);let o=`Unable to parse the tile at ${t.request.url}, `;throw o+=31===r[0]&&139===r[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.messge}`,new Error(o)}}))}loadTile(t){return e._(this,void 0,void 0,(function*(){const r=t.uid,o=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.br(t.request),s=new i(t);this.loading[r]=s;const n=new AbortController;s.abort=n;try{const i=yield this.loadVectorTile(t,n);if(delete this.loading[r],!i)return null;const a=i.rawData,l={};i.expires&&(l.expires=i.expires),i.cacheControl&&(l.cacheControl=i.cacheControl);const h={};if(o){const e=o.finish();e&&(h.resourceTiming=JSON.parse(JSON.stringify(e)));}s.vectorTile=i.vectorTile;const u=s.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor);this.loaded[r]=s,this.fetching[r]={rawTileData:a,cacheControl:l,resourceTiming:h};try{const t=yield u;return e.e({rawTileData:a.slice(0)},t,l,h)}finally{delete this.fetching[r];}}catch(e){throw delete this.loading[r],s.status="done",this.loaded[r]=s,e}}))}reloadTile(t){return e._(this,void 0,void 0,(function*(){const r=t.uid;if(!this.loaded||!this.loaded[r])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const i=this.loaded[r];if(i.showCollisionBoxes=t.showCollisionBoxes,"parsing"===i.status){const t=yield i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor);let o;if(this.fetching[r]){const{rawTileData:i,cacheControl:s,resourceTiming:n}=this.fetching[r];delete this.fetching[r],o=e.e({rawTileData:i.slice(0)},t,s,n);}else o=t;return o}if("done"===i.status&&i.vectorTile)return i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor)}))}abortTile(t){return e._(this,void 0,void 0,(function*(){const e=this.loading,r=t.uid;e&&e[r]&&e[r].abort&&(e[r].abort.abort(),delete e[r]);}))}removeTile(t){return e._(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];}))}}class n{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:r,encoding:i,rawImageData:o,redFactor:s,greenFactor:n,blueFactor:a,baseShift:l}=t,h=o.width+2,u=o.height+2,c=e.b(o)?new e.R({width:h,height:u},yield e.bs(o,-1,-1,h,u)):o,d=new e.bt(r,c,i,s,n,a,l);return this.loaded=this.loaded||{},this.loaded[r]=d,d}))}removeTile(e){const t=this.loaded,r=e.uid;t&&t[r]&&delete t[r];}}function a(e,t){if(0!==e.length){l(e[0],t);for(var r=1;r<e.length;r++)l(e[r],!t);}}function l(e,t){for(var r=0,i=0,o=0,s=e.length,n=s-1;o<s;n=o++){var a=(e[o][0]-e[n][0])*(e[n][1]+e[o][1]),l=r+a;i+=Math.abs(r)>=Math.abs(a)?r-l+a:a-l+r,r=l;}r+i>=0!=!!t&&e.reverse();}var h=e.bu((function e(t,r){var i,o=t&&t.type;if("FeatureCollection"===o)for(i=0;i<t.features.length;i++)e(t.features[i],r);else if("GeometryCollection"===o)for(i=0;i<t.geometries.length;i++)e(t.geometries[i],r);else if("Feature"===o)e(t.geometry,r);else if("Polygon"===o)a(t.coordinates,r);else if("MultiPolygon"===o)for(i=0;i<t.coordinates.length;i++)a(t.coordinates[i],r);return t}));const u=e.bp.VectorTileFeature.prototype.toGeoJSON;var c={exports:{}},d=e.bv,f=e.bp.VectorTileFeature,p=g;function g(e,t){this.options=t||{},this.features=e,this.length=e.length;}function m(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}g.prototype.feature=function(e){return new m(this.features[e],this.options.extent)},m.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var t=0;t<e.length;t++){for(var r=e[t],i=[],o=0;o<r.length;o++)i.push(new d(r[o][0],r[o][1]));this.geometry.push(i);}return this.geometry},m.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,r=-1/0,i=1/0,o=-1/0,s=0;s<e.length;s++)for(var n=e[s],a=0;a<n.length;a++){var l=n[a];t=Math.min(t,l.x),r=Math.max(r,l.x),i=Math.min(i,l.y),o=Math.max(o,l.y);}return [t,i,r,o]},m.prototype.toGeoJSON=f.prototype.toGeoJSON;var v=e.bw,y=p;function w(e){var t=new v;return function(e,t){for(var r in e.layers)t.writeMessage(3,x,e.layers[r]);}(e,t),t.finish()}function x(e,t){var r;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<e.length;r++)i.feature=e.feature(r),t.writeMessage(2,b,i);var o=i.keys;for(r=0;r<o.length;r++)t.writeStringField(3,o[r]);var s=i.values;for(r=0;r<s.length;r++)t.writeMessage(4,P,s[r]);}function b(e,t){var r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,M,e),t.writeVarintField(3,r.type),t.writeMessage(4,I,r);}function M(e,t){var r=e.feature,i=e.keys,o=e.values,s=e.keycache,n=e.valuecache;for(var a in r.properties){var l=r.properties[a],h=s[a];if(null!==l){void 0===h&&(i.push(a),s[a]=h=i.length-1),t.writeVarint(h);var u=typeof l;"string"!==u&&"boolean"!==u&&"number"!==u&&(l=JSON.stringify(l));var c=u+":"+l,d=n[c];void 0===d&&(o.push(l),n[c]=d=o.length-1),t.writeVarint(d);}}}function _(e,t){return (t<<3)+(7&e)}function S(e){return e<<1^e>>31}function I(e,t){for(var r=e.loadGeometry(),i=e.type,o=0,s=0,n=r.length,a=0;a<n;a++){var l=r[a],h=1;1===i&&(h=l.length),t.writeVarint(_(1,h));for(var u=3===i?l.length-1:l.length,c=0;c<u;c++){1===c&&1!==i&&t.writeVarint(_(2,u-1));var d=l[c].x-o,f=l[c].y-s;t.writeVarint(S(d)),t.writeVarint(S(f)),o+=d,s+=f;}3===i&&t.writeVarint(_(7,1));}}function P(e,t){var r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}c.exports=w,c.exports.fromVectorTileJs=w,c.exports.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var i in e)r[i]=new y(e[i].features,t),r[i].name=i,r[i].version=t.version,r[i].extent=t.extent;return w({layers:r})},c.exports.GeoJSONWrapper=y;var k=e.bu(c.exports);const T={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},D=Math.fround||(C=new Float32Array(1),e=>(C[0]=+e,C[0]));var C;const O=3,L=5,z=6;class F{constructor(e){this.options=Object.assign(Object.create(T),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:r,maxZoom:i}=this.options;t&&console.time("total time");const o=`prepare ${e.length} points`;t&&console.time(o),this.points=e;const s=[];for(let t=0;t<e.length;t++){const r=e[t];if(!r.geometry)continue;const[i,o]=r.geometry.coordinates,n=D(A(i)),a=D(Z(o));s.push(n,a,1/0,t,-1,1),this.options.reduce&&s.push(0);}let n=this.trees[i+1]=this._createTree(s);t&&console.timeEnd(o);for(let e=i;e>=r;e--){const r=+Date.now();n=this.trees[e]=this._createTree(this._cluster(n,e)),t&&console.log("z%d: %d clusters in %dms",e,n.numItems,+Date.now()-r);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const s=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,o=180;else if(r>o){const e=this.getClusters([r,i,180,s],t),n=this.getClusters([-180,i,o,s],t);return e.concat(n)}const n=this.trees[this._limitZoom(t)],a=n.range(A(r),Z(s),A(o),Z(i)),l=n.data,h=[];for(const e of a){const t=this.stride*e;h.push(l[t+L]>1?E(l,t,this.clusterProps):this.points[l[t+O]]);}return h}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),i="No cluster with the specified id.",o=this.trees[r];if(!o)throw new Error(i);const s=o.data;if(t*this.stride>=s.length)throw new Error(i);const n=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=o.within(s[t*this.stride],s[t*this.stride+1],n),l=[];for(const t of a){const r=t*this.stride;s[r+4]===e&&l.push(s[r+L]>1?E(s,r,this.clusterProps):this.points[s[r+O]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,r){const i=[];return this._appendLeaves(i,e,t=t||10,r=r||0,0),i}getTile(e,t,r){const i=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:s,radius:n}=this.options,a=n/s,l=(r-a)/o,h=(r+1+a)/o,u={features:[]};return this._addTileFeatures(i.range((t-a)/o,l,(t+1+a)/o,h),i.data,t,r,o,u),0===t&&this._addTileFeatures(i.range(1-a/o,l,1,h),i.data,o,r,o,u),t===o-1&&this._addTileFeatures(i.range(0,l,a/o,h),i.data,-1,r,o,u),u.features.length?u:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id;}return t}_appendLeaves(e,t,r,i,o){const s=this.getChildren(t);for(const t of s){const s=t.properties;if(s&&s.cluster?o+s.point_count<=i?o+=s.point_count:o=this._appendLeaves(e,s.cluster_id,r,i,o):o<i?o++:e.push(t),e.length===r)break}return o}_createTree(t){const r=new e.au(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)r.add(t[e],t[e+1]);return r.finish(),r.data=t,r}_addTileFeatures(e,t,r,i,o,s){for(const n of e){const e=n*this.stride,a=t[e+L]>1;let l,h,u;if(a)l=j(t,e,this.clusterProps),h=t[e],u=t[e+1];else {const r=this.points[t[e+O]];l=r.properties;const[i,o]=r.geometry.coordinates;h=A(i),u=Z(o);}const c={type:1,geometry:[[Math.round(this.options.extent*(h*o-r)),Math.round(this.options.extent*(u*o-i))]],tags:l};let d;d=a||this.options.generateId?t[e+O]:this.points[t[e+O]].id,void 0!==d&&(c.id=d),s.features.push(c);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:r,extent:i,reduce:o,minPoints:s}=this.options,n=r/(i*Math.pow(2,t)),a=e.data,l=[],h=this.stride;for(let r=0;r<a.length;r+=h){if(a[r+2]<=t)continue;a[r+2]=t;const i=a[r],u=a[r+1],c=e.within(a[r],a[r+1],n),d=a[r+L];let f=d;for(const e of c){const r=e*h;a[r+2]>t&&(f+=a[r+L]);}if(f>d&&f>=s){let e,s=i*d,n=u*d,p=-1;const g=((r/h|0)<<5)+(t+1)+this.points.length;for(const i of c){const l=i*h;if(a[l+2]<=t)continue;a[l+2]=t;const u=a[l+L];s+=a[l]*u,n+=a[l+1]*u,a[l+4]=g,o&&(e||(e=this._map(a,r,!0),p=this.clusterProps.length,this.clusterProps.push(e)),o(e,this._map(a,l)));}a[r+4]=g,l.push(s/f,n/f,1/0,g,-1,f),o&&l.push(p);}else {for(let e=0;e<h;e++)l.push(a[r+e]);if(f>1)for(const e of c){const r=e*h;if(!(a[r+2]<=t)){a[r+2]=t;for(let e=0;e<h;e++)l.push(a[r+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,r){if(e[t+L]>1){const i=this.clusterProps[e[t+z]];return r?Object.assign({},i):i}const i=this.points[e[t+O]].properties,o=this.options.map(i);return r&&o===i?Object.assign({},o):o}}function E(e,t,r){return {type:"Feature",id:e[t+O],properties:j(e,t,r),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),N(e[t+1])]}};var i;}function j(e,t,r){const i=e[t+L],o=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,s=e[t+z],n=-1===s?{}:Object.assign({},r[s]);return Object.assign(n,{cluster:!0,cluster_id:e[t+O],point_count:i,point_count_abbreviated:o})}function A(e){return e/360+.5}function Z(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function N(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function W(e,t,r,i){for(var o,s=i,n=r-t>>1,a=r-t,l=e[t],h=e[t+1],u=e[r],c=e[r+1],d=t+3;d<r;d+=3){var f=G(e[d],e[d+1],l,h,u,c);if(f>s)o=d,s=f;else if(f===s){var p=Math.abs(d-n);p<a&&(o=d,a=p);}}s>i&&(o-t>3&&W(e,t,o,i),e[o+2]=s,r-o>3&&W(e,o,r,i));}function G(e,t,r,i,o,s){var n=o-r,a=s-i;if(0!==n||0!==a){var l=((e-r)*n+(t-i)*a)/(n*n+a*a);l>1?(r=o,i=s):l>0&&(r+=n*l,i+=a*l);}return (n=e-r)*n+(a=t-i)*a}function J(e,t,r,i){var o={id:void 0===e?null:e,type:t,geometry:r,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,r=e.type;if("Point"===r||"MultiPoint"===r||"LineString"===r)R(e,t);else if("Polygon"===r||"MultiLineString"===r)for(var i=0;i<t.length;i++)R(e,t[i]);else if("MultiPolygon"===r)for(i=0;i<t.length;i++)for(var o=0;o<t[i].length;o++)R(e,t[i][o]);}(o),o}function R(e,t){for(var r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1]);}function Y(e,t,r,i){if(t.geometry){var o=t.geometry.coordinates,s=t.geometry.type,n=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2),a=[],l=t.id;if(r.promoteId?l=t.properties[r.promoteId]:r.generateId&&(l=i||0),"Point"===s)V(o,a);else if("MultiPoint"===s)for(var h=0;h<o.length;h++)V(o[h],a);else if("LineString"===s)q(o,a,n,!1);else if("MultiLineString"===s){if(r.lineMetrics){for(h=0;h<o.length;h++)q(o[h],a=[],n,!1),e.push(J(l,"LineString",a,t.properties));return}X(o,a,n,!1);}else if("Polygon"===s)X(o,a,n,!0);else {if("MultiPolygon"!==s){if("GeometryCollection"===s){for(h=0;h<t.geometry.geometries.length;h++)Y(e,{id:l,geometry:t.geometry.geometries[h],properties:t.properties},r,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(h=0;h<o.length;h++){var u=[];X(o[h],u,n,!0),a.push(u);}}e.push(J(l,s,a,t.properties));}}function V(e,t){t.push(H(e[0])),t.push(B(e[1])),t.push(0);}function q(e,t,r,i){for(var o,s,n=0,a=0;a<e.length;a++){var l=H(e[a][0]),h=B(e[a][1]);t.push(l),t.push(h),t.push(0),a>0&&(n+=i?(o*h-l*s)/2:Math.sqrt(Math.pow(l-o,2)+Math.pow(h-s,2))),o=l,s=h;}var u=t.length-3;t[2]=1,W(t,0,u,r),t[u+2]=1,t.size=Math.abs(n),t.start=0,t.end=t.size;}function X(e,t,r,i){for(var o=0;o<e.length;o++){var s=[];q(e[o],s,r,i),t.push(s);}}function H(e){return e/360+.5}function B(e){var t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function $(e,t,r,i,o,s,n,a){if(i/=t,s>=(r/=t)&&n<i)return e;if(n<r||s>=i)return null;for(var l=[],h=0;h<e.length;h++){var u=e[h],c=u.geometry,d=u.type,f=0===o?u.minX:u.minY,p=0===o?u.maxX:u.maxY;if(f>=r&&p<i)l.push(u);else if(!(p<r||f>=i)){var g=[];if("Point"===d||"MultiPoint"===d)U(c,g,r,i,o);else if("LineString"===d)Q(c,g,r,i,o,!1,a.lineMetrics);else if("MultiLineString"===d)ee(c,g,r,i,o,!1);else if("Polygon"===d)ee(c,g,r,i,o,!0);else if("MultiPolygon"===d)for(var m=0;m<c.length;m++){var v=[];ee(c[m],v,r,i,o,!0),v.length&&g.push(v);}if(g.length){if(a.lineMetrics&&"LineString"===d){for(m=0;m<g.length;m++)l.push(J(u.id,d,g[m],u.tags));continue}"LineString"!==d&&"MultiLineString"!==d||(1===g.length?(d="LineString",g=g[0]):d="MultiLineString"),"Point"!==d&&"MultiPoint"!==d||(d=3===g.length?"Point":"MultiPoint"),l.push(J(u.id,d,g,u.tags));}}}return l.length?l:null}function U(e,t,r,i,o){for(var s=0;s<e.length;s+=3){var n=e[s+o];n>=r&&n<=i&&(t.push(e[s]),t.push(e[s+1]),t.push(e[s+2]));}}function Q(e,t,r,i,o,s,n){for(var a,l,h=K(e),u=0===o?re:ie,c=e.start,d=0;d<e.length-3;d+=3){var f=e[d],p=e[d+1],g=e[d+2],m=e[d+3],v=e[d+4],y=0===o?f:p,w=0===o?m:v,x=!1;n&&(a=Math.sqrt(Math.pow(f-m,2)+Math.pow(p-v,2))),y<r?w>r&&(l=u(h,f,p,m,v,r),n&&(h.start=c+a*l)):y>i?w<i&&(l=u(h,f,p,m,v,i),n&&(h.start=c+a*l)):te(h,f,p,g),w<r&&y>=r&&(l=u(h,f,p,m,v,r),x=!0),w>i&&y<=i&&(l=u(h,f,p,m,v,i),x=!0),!s&&x&&(n&&(h.end=c+a*l),t.push(h),h=K(e)),n&&(c+=a);}var b=e.length-3;f=e[b],p=e[b+1],g=e[b+2],(y=0===o?f:p)>=r&&y<=i&&te(h,f,p,g),b=h.length-3,s&&b>=3&&(h[b]!==h[0]||h[b+1]!==h[1])&&te(h,h[0],h[1],h[2]),h.length&&t.push(h);}function K(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function ee(e,t,r,i,o,s){for(var n=0;n<e.length;n++)Q(e[n],t,r,i,o,s,!1);}function te(e,t,r,i){e.push(t),e.push(r),e.push(i);}function re(e,t,r,i,o,s){var n=(s-t)/(i-t);return e.push(s),e.push(r+(o-r)*n),e.push(1),n}function ie(e,t,r,i,o,s){var n=(s-r)/(o-r);return e.push(t+(i-t)*n),e.push(s),e.push(1),n}function oe(e,t){for(var r=[],i=0;i<e.length;i++){var o,s=e[i],n=s.type;if("Point"===n||"MultiPoint"===n||"LineString"===n)o=se(s.geometry,t);else if("MultiLineString"===n||"Polygon"===n){o=[];for(var a=0;a<s.geometry.length;a++)o.push(se(s.geometry[a],t));}else if("MultiPolygon"===n)for(o=[],a=0;a<s.geometry.length;a++){for(var l=[],h=0;h<s.geometry[a].length;h++)l.push(se(s.geometry[a][h],t));o.push(l);}r.push(J(s.id,n,o,s.tags));}return r}function se(e,t){var r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(var i=0;i<e.length;i+=3)r.push(e[i]+t,e[i+1],e[i+2]);return r}function ne(e,t){if(e.transformed)return e;var r,i,o,s=1<<e.z,n=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],h=l.geometry,u=l.type;if(l.geometry=[],1===u)for(i=0;i<h.length;i+=2)l.geometry.push(ae(h[i],h[i+1],t,s,n,a));else for(i=0;i<h.length;i++){var c=[];for(o=0;o<h[i].length;o+=2)c.push(ae(h[i][o],h[i][o+1],t,s,n,a));l.geometry.push(c);}}return e.transformed=!0,e}function ae(e,t,r,i,o,s){return [Math.round(r*(e*i-o)),Math.round(r*(t*i-s))]}function le(e,t,r,i,o){for(var s=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),n={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){n.numFeatures++,he(n,e[a],s,o);var l=e[a].minX,h=e[a].minY,u=e[a].maxX,c=e[a].maxY;l<n.minX&&(n.minX=l),h<n.minY&&(n.minY=h),u>n.maxX&&(n.maxX=u),c>n.maxY&&(n.maxY=c);}return n}function he(e,t,r,i){var o=t.geometry,s=t.type,n=[];if("Point"===s||"MultiPoint"===s)for(var a=0;a<o.length;a+=3)n.push(o[a]),n.push(o[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===s)ue(n,o,e,r,!1,!1);else if("MultiLineString"===s||"Polygon"===s)for(a=0;a<o.length;a++)ue(n,o[a],e,r,"Polygon"===s,0===a);else if("MultiPolygon"===s)for(var l=0;l<o.length;l++){var h=o[l];for(a=0;a<h.length;a++)ue(n,h[a],e,r,!0,0===a);}if(n.length){var u=t.tags||null;if("LineString"===s&&i.lineMetrics){for(var c in u={},t.tags)u[c]=t.tags[c];u.mapbox_clip_start=o.start/o.size,u.mapbox_clip_end=o.end/o.size;}var d={geometry:n,type:"Polygon"===s||"MultiPolygon"===s?3:"LineString"===s||"MultiLineString"===s?2:1,tags:u};null!==t.id&&(d.id=t.id),e.features.push(d);}}function ue(e,t,r,i,o,s){var n=i*i;if(i>0&&t.size<(o?n:i))r.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===i||t[l+2]>n)&&(r.numSimplified++,a.push(t[l]),a.push(t[l+1])),r.numPoints++;o&&function(e,t){for(var r=0,i=0,o=e.length,s=o-2;i<o;s=i,i+=2)r+=(e[i]-e[s])*(e[i+1]+e[s+1]);if(r>0===t)for(i=0,o=e.length;i<o/2;i+=2){var n=e[i],a=e[i+1];e[i]=e[o-2-i],e[i+1]=e[o-1-i],e[o-2-i]=n,e[o-1-i]=a;}}(a,s),e.push(a);}}function ce(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var i=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var i=0;i<e.features.length;i++)Y(r,e.features[i],t,i);else Y(r,"Feature"===e.type?e:{geometry:e},t);return r}(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){var r=t.buffer/t.extent,i=e,o=$(e,1,-1-r,r,0,-1,2,t),s=$(e,1,1-r,2+r,0,-1,2,t);return (o||s)&&(i=$(e,1,-r,1+r,0,-1,2,t)||[],o&&(i=oe(o,1).concat(i)),s&&(i=i.concat(oe(s,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),r&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function de(e,t,r){return 32*((1<<e)*r+t)+e}function fe(e,t){return t?e.properties[t]:e.id}function pe(e,t){if(null==e)return !0;if("Feature"===e.type)return null!=fe(e,t);if("FeatureCollection"===e.type){const r=new Set;for(const i of e.features){const e=fe(i,t);if(null==e)return !1;if(r.has(e))return !1;r.add(e);}return !0}return !1}function ge(e,t){const r=new Map;if(null==e);else if("Feature"===e.type)r.set(fe(e,t),e);else for(const i of e.features)r.set(fe(i,t),i);return r}ce.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},ce.prototype.splitTile=function(e,t,r,i,o,s,n){for(var a=[e,t,r,i],l=this.options,h=l.debug;a.length;){i=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var u=1<<t,c=de(t,r,i),d=this.tiles[c];if(!d&&(h>1&&console.time("creation"),d=this.tiles[c]=le(e,t,r,i,l),this.tileCoords.push({z:t,x:r,y:i}),h)){h>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));var f="z"+t;this.stats[f]=(this.stats[f]||0)+1,this.total++;}if(d.source=e,o){if(t===l.maxZoom||t===o)continue;var p=1<<o-t;if(r!==Math.floor(s/p)||i!==Math.floor(n/p))continue}else if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue;if(d.source=null,0!==e.length){h>1&&console.time("clipping");var g,m,v,y,w,x,b=.5*l.buffer/l.extent,M=.5-b,_=.5+b,S=1+b;g=m=v=y=null,w=$(e,u,r-b,r+_,0,d.minX,d.maxX,l),x=$(e,u,r+M,r+S,0,d.minX,d.maxX,l),e=null,w&&(g=$(w,u,i-b,i+_,1,d.minY,d.maxY,l),m=$(w,u,i+M,i+S,1,d.minY,d.maxY,l),w=null),x&&(v=$(x,u,i-b,i+_,1,d.minY,d.maxY,l),y=$(x,u,i+M,i+S,1,d.minY,d.maxY,l),x=null),h>1&&console.timeEnd("clipping"),a.push(g||[],t+1,2*r,2*i),a.push(m||[],t+1,2*r,2*i+1),a.push(v||[],t+1,2*r+1,2*i),a.push(y||[],t+1,2*r+1,2*i+1);}}},ce.prototype.getTile=function(e,t,r){var i=this.options,o=i.extent,s=i.debug;if(e<0||e>24)return null;var n=1<<e,a=de(e,t=(t%n+n)%n,r);if(this.tiles[a])return ne(this.tiles[a],o);s>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,h=e,u=t,c=r;!l&&h>0;)h--,u=Math.floor(u/2),c=Math.floor(c/2),l=this.tiles[de(h,u,c)];return l&&l.source?(s>1&&console.log("found parent tile z%d-%d-%d",h,u,c),s>1&&console.time("drilling down"),this.splitTile(l.source,h,u,c,e,t,r),s>1&&console.timeEnd("drilling down"),this.tiles[a]?ne(this.tiles[a],o):null):null};class me extends s{constructor(){super(...arguments),this._dataUpdateable=new Map;}loadVectorTile(t,r){return e._(this,void 0,void 0,(function*(){const r=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const i=this._geoJSONIndex.getTile(r.z,r.x,r.y);if(!i)return null;const o=new class{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.W,this.length=t.length,this._features=t;}feature(t){return new class{constructor(t){this._feature=t,this.extent=e.W,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const r of this._feature.geometry)t.push([new e.P(r[0],r[1])]);return t}{const t=[];for(const r of this._feature.geometry){const i=[];for(const t of r)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,r){return u.call(this,e,t,r)}}(this._features[t])}}(i.features);let s=k(o);return 0===s.byteOffset&&s.byteLength===s.buffer.byteLength||(s=new Uint8Array(s)),{vectorTile:o,rawData:s.buffer}}))}loadData(t){var r;return e._(this,void 0,void 0,(function*(){null===(r=this._pendingRequest)||void 0===r||r.abort();const i=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.br(t.request);this._pendingRequest=new AbortController;try{let r=yield this.loadGeoJSON(t,this._pendingRequest);if(delete this._pendingRequest,"object"!=typeof r)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(h(r,!0),t.filter){const i=e.bx(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===i.result)throw new Error(i.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const o=r.features.filter((e=>i.value.evaluate({zoom:0},e)));r={type:"FeatureCollection",features:o};}this._geoJSONIndex=t.cluster?new F(function({superclusterOptions:t,clusterProperties:r}){if(!r||!t)return t;const i={},o={},s={accumulated:null,zoom:0},n={properties:null},a=Object.keys(r);for(const t of a){const[s,n]=r[t],a=e.bx(n),l=e.bx("string"==typeof s?[s,["accumulated"],["get",t]]:s);i[t]=a.value,o[t]=l.value;}return t.map=e=>{n.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(s,n);return t},t.reduce=(e,t)=>{n.properties=t;for(const t of a)s.accumulated=e[t],e[t]=o[t].evaluate(s,n);},t}(t)).load(r.features):function(e,t){return new ce(e,t)}(r,t.geojsonVtOptions),this.loaded={};const o={};if(i){const e=i.finish();e&&(o.resourceTiming={},o.resourceTiming[t.source]=JSON.parse(JSON.stringify(e)));}return o}catch(t){if(delete this._pendingRequest,e.by(t))return {abandoned:!0};throw t}}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadGeoJSON(t,r){return e._(this,void 0,void 0,(function*(){const{promoteId:i}=t;if(t.request){const o=yield e.h(t.request,r);return this._dataUpdateable=pe(o.data,i)?ge(o.data,i):void 0,o.data}if("string"==typeof t.data)try{const e=JSON.parse(t.data);return this._dataUpdateable=pe(e,i)?ge(e,i):void 0,e}catch(e){throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`)}if(!t.dataDiff)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${t.source}`);return function(e,t,r){var i,o,s,n;if(t.removeAll&&e.clear(),t.remove)for(const r of t.remove)e.delete(r);if(t.add)for(const i of t.add){const t=fe(i,r);null!=t&&e.set(t,i);}if(t.update)for(const r of t.update){let t=e.get(r.id);if(null==t)continue;const a=!r.removeAllProperties&&((null===(i=r.removeProperties)||void 0===i?void 0:i.length)>0||(null===(o=r.addOrUpdateProperties)||void 0===o?void 0:o.length)>0);if((r.newGeometry||r.removeAllProperties||a)&&(t=Object.assign({},t),e.set(r.id,t),a&&(t.properties=Object.assign({},t.properties))),r.newGeometry&&(t.geometry=r.newGeometry),r.removeAllProperties)t.properties={};else if((null===(s=r.removeProperties)||void 0===s?void 0:s.length)>0)for(const e of r.removeProperties)Object.prototype.hasOwnProperty.call(t.properties,e)&&delete t.properties[e];if((null===(n=r.addOrUpdateProperties)||void 0===n?void 0:n.length)>0)for(const{key:e,value:i}of r.addOrUpdateProperties)t.properties[e]=i;}}(this._dataUpdateable,t.dataDiff,i),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(t){return e._(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort();}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}class ve{constructor(t){this.self=t,this.actor=new e.C(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.be,this.self.removeProtocol=e.bf,this.self.registerRTLTextPlugin=t=>{if(e.bz.isParsed())throw new Error("RTL text plugin already registered.");e.bz.setMethods(t);},this.actor.registerMessageHandler("loadDEMTile",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("removeDEMTile",((t,r)=>e._(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,r.source).removeTile(r);})))),this.actor.registerMessageHandler("getClusterExpansionZoom",((t,r)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,r.type,r.source).getClusterExpansionZoom(r)})))),this.actor.registerMessageHandler("getClusterChildren",((t,r)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,r.type,r.source).getClusterChildren(r)})))),this.actor.registerMessageHandler("getClusterLeaves",((t,r)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,r.type,r.source).getClusterLeaves(r)})))),this.actor.registerMessageHandler("loadData",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("loadTile",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("reloadTile",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("abortTile",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("removeTile",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("removeSource",((t,r)=>e._(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][r.type]||!this.workerSources[t][r.type][r.source])return;const e=this.workerSources[t][r.type][r.source];delete this.workerSources[t][r.type][r.source],void 0!==e.removeSource&&e.removeSource(r);})))),this.actor.registerMessageHandler("removeMap",(t=>e._(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t];})))),this.actor.registerMessageHandler("setReferrer",((t,r)=>e._(this,void 0,void 0,(function*(){this.referrer=r;})))),this.actor.registerMessageHandler("syncRTLPluginState",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("importScript",((t,r)=>e._(this,void 0,void 0,(function*(){this.self.importScripts(r);})))),this.actor.registerMessageHandler("setImages",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("updateLayers",((t,r)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(r.layers,r.removedIds);})))),this.actor.registerMessageHandler("setLayers",((t,r)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(r);}))));}_setImages(t,r){return e._(this,void 0,void 0,(function*(){this.availableImages[t]=r;for(const e in this.workerSources[t]){const i=this.workerSources[t][e];for(const e in i)i[e].availableImages=r;}}))}_syncRTLPluginState(t,r){return e._(this,void 0,void 0,(function*(){e.bz.setState(r);const t=e.bz.getPluginURL();if("loaded"===r.pluginStatus&&!e.bz.isParsed()&&null!=t){this.self.importScripts(t);const r=e.bz.isParsed();if(r)return r;throw new Error(`RTL Text Plugin failed to import scripts from ${t}`)}return !1}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let r=this.layerIndexes[e];return r||(r=this.layerIndexes[e]=new t),r}_getWorkerSource(e,t,r){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][r]){const i={sendAsync:(t,r)=>(t.targetMapId=e,this.actor.sendAsync(t,r))};switch(t){case"vector":this.workerSources[e][t][r]=new s(i,this._getLayerIndex(e),this._getAvailableImages(e));break;case"geojson":this.workerSources[e][t][r]=new me(i,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][r]=new this.externalWorkerSourceTypes[t](i,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][r]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new n),this.demWorkerSources[e][t]}}return e.i(self)&&(self.worker=new ve(self)),ve}));

define("index",["exports","./shared"],(function(t,e){"use strict";var i="4.1.0";let s,a;const o={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frameAsync:t=>new Promise(((i,s)=>{const a=requestAnimationFrame(i);t.signal.addEventListener("abort",(()=>{cancelAnimationFrame(a),s(e.c());}));})),getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>(s||(s=document.createElement("a")),s.href=t,s.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return !!matchMedia&&(null==a&&(a=matchMedia("(prefers-reduced-motion: reduce)")),a.matches)}};class r{static testProp(t){if(!r.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in r.docStyle)return t[e];return t[0]}static create(t,e,i){const s=window.document.createElement(t);return void 0!==e&&(s.className=e),i&&i.appendChild(s),s}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){r.docStyle&&r.selectProp&&(r.userSelect=r.docStyle[r.selectProp],r.docStyle[r.selectProp]="none");}static enableDrag(){r.docStyle&&r.selectProp&&(r.docStyle[r.selectProp]=r.userSelect);}static setTransform(t,e){t.style[r.transformProp]=e;}static addEventListener(t,e,i,s={}){t.addEventListener(e,i,"passive"in s?s:s.capture);}static removeEventListener(t,e,i,s={}){t.removeEventListener(e,i,"passive"in s?s:s.capture);}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",r.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",r.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",r.suppressClickInternal,!0);}),0);}static getScale(t){const e=t.getBoundingClientRect();return {x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,i,s){const a=i.boundingClientRect;return new e.P((s.clientX-a.left)/i.x-t.clientLeft,(s.clientY-a.top)/i.y-t.clientTop)}static mousePos(t,e){const i=r.getScale(t);return r.getPoint(t,i,e)}static touchPos(t,e){const i=[],s=r.getScale(t);for(let a=0;a<e.length;a++)i.push(r.getPoint(t,s,e[a]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t);}}r.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,r.selectProp=r.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),r.transformProp=r.testProp(["transform","WebkitTransform"]);const n={supported:!1,testSupport:function(t){!c&&h&&(u?d(t):l=t);}};let l,h,c=!1,u=!1;function d(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,h),t.isContextLost())return;n.supported=!0;}catch(t){}t.deleteTexture(e),c=!0;}var _,p;"undefined"!=typeof document&&(h=document.createElement("img"),h.onload=function(){l&&d(l),l=null,u=!0;},h.onerror=function(){c=!0,l=null;},h.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let i,s,a,o;t.resetRequestQueue=()=>{i=[],s=0,a=0,o={};},t.addThrottleControl=t=>{const e=a++;return o[e]=t,e},t.removeThrottleControl=t=>{delete o[t],l();},t.getImage=(t,s,a=!0)=>new Promise(((o,r)=>{n.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),e.e(t,{type:"image"}),i.push({abortController:s,requestParameters:t,supportImageRefresh:a,state:"queued",onError:t=>{r(t);},onSuccess:t=>{o(t);}}),l();}));const r=t=>e._(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:i,supportImageRefresh:a,onError:o,onSuccess:r,abortController:n}=t,c=!1===a&&!e.i(self)&&!e.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce(((t,e)=>t&&"accept"===e),!0));s++;const u=c?h(i,n):e.m(i,n);try{const i=yield u;delete t.abortController,t.state="completed",i.data instanceof HTMLImageElement||e.b(i.data)?r(i):i.data&&r({data:yield(d=i.data,"function"==typeof createImageBitmap?e.d(d):e.f(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(e){delete t.abortController,o(e);}finally{s--,l();}var d;})),l=()=>{const t=(()=>{for(const t of Object.keys(o))if(o[t]())return !0;return !1})()?e.a.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:e.a.MAX_PARALLEL_IMAGE_REQUESTS;for(let e=s;e<t&&i.length>0;e++){const t=i.shift();t.abortController.signal.aborted?e--:r(t);}},h=(t,i)=>new Promise(((s,a)=>{const o=new Image,r=t.url,n=t.credentials;n&&"include"===n?o.crossOrigin="use-credentials":(n&&"same-origin"===n||!e.s(r))&&(o.crossOrigin="anonymous"),i.signal.addEventListener("abort",(()=>{o.src="",a(e.c());})),o.fetchPriority="high",o.onload=()=>{o.onerror=o.onload=null,s({data:o});},o.onerror=()=>{o.onerror=o.onload=null,i.signal.aborted||a(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},o.src=r;}));}(_||(_={})),_.resetRequestQueue(),function(t){t.Glyphs="Glyphs",t.Image="Image",t.Source="Source",t.SpriteImage="SpriteImage",t.SpriteJSON="SpriteJSON",t.Style="Style",t.Tile="Tile",t.Unknown="Unknown";}(p||(p={}));class m{constructor(t){this._transformRequestFn=t;}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeSpriteURL(t,e,i){const s=function(t){const e=t.match(f);if(!e)throw new Error(`Unable to parse URL "${t}"`);return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}(t);return s.path+=`${e}${i}`,function(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}(s)}setTransformRequest(t){this._transformRequestFn=t;}}const f=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function g(t){var i=new e.A(3);return i[0]=t[0],i[1]=t[1],i[2]=t[2],i}var v,x=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t};v=new e.A(3),e.A!=Float32Array&&(v[0]=0,v[1]=0,v[2]=0);var y=function(t){var e=t[0],i=t[1];return e*e+i*i};function b(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:s,url:a}of t){const t=`${s}${a}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:s,url:a}));}}return e}!function(){var t=new e.A(2);e.A!=Float32Array&&(t[0]=0,t[1]=0);}();class w{constructor(t,e,i,s){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,s);}update(t,i,s){const{width:a,height:o}=t,r=!(this.size&&this.size[0]===a&&this.size[1]===o||s),{context:n}=this,{gl:l}=n;if(this.useMipmap=Boolean(i&&i.useMipmap),l.bindTexture(l.TEXTURE_2D,this.texture),n.pixelStoreUnpackFlipY.set(!1),n.pixelStoreUnpack.set(1),n.pixelStoreUnpackPremultiplyAlpha.set(this.format===l.RGBA&&(!i||!1!==i.premultiply)),r)this.size=[a,o],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||e.b(t)?l.texImage2D(l.TEXTURE_2D,0,this.format,this.format,l.UNSIGNED_BYTE,t):l.texImage2D(l.TEXTURE_2D,0,this.format,a,o,0,this.format,l.UNSIGNED_BYTE,t.data);else {const{x:i,y:r}=s||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||e.b(t)?l.texSubImage2D(l.TEXTURE_2D,0,i,r,l.RGBA,l.UNSIGNED_BYTE,t):l.texSubImage2D(l.TEXTURE_2D,0,i,r,a,o,l.RGBA,l.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&l.generateMipmap(l.TEXTURE_2D);}bind(t,e,i){const{context:s}=this,{gl:a}=s;a.bindTexture(a.TEXTURE_2D,this.texture),i!==a.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=a.LINEAR),t!==this.filter&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,t),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,e),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}function T(t){const{userImage:e}=t;return !!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class I extends e.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new e.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[];}}getImage(t){const i=this.images[t];if(i&&!i.data&&i.spriteData){const t=i.spriteData;i.data=new e.R({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),i.spriteData=null;}return i}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e);}_validate(t,i){let s=!0;const a=i.data||i.spriteData;return this._validateStretch(i.stretchX,a&&a.width)||(this.fire(new e.j(new Error(`Image "${t}" has invalid "stretchX" value`))),s=!1),this._validateStretch(i.stretchY,a&&a.height)||(this.fire(new e.j(new Error(`Image "${t}" has invalid "stretchY" value`))),s=!1),this._validateContent(i.content,i)||(this.fire(new e.j(new Error(`Image "${t}" has invalid "content" value`))),s=!1),s}_validateStretch(t,e){if(!t)return !0;let i=0;for(const s of t){if(s[0]<i||s[1]<s[0]||e<s[1])return !1;i=s[1];}return !0}_validateContent(t,e){if(!t)return !0;if(4!==t.length)return !1;const i=e.spriteData,s=i&&i.width||e.data.width,a=i&&i.height||e.data.height;return !(t[0]<0||s<t[0]||t[1]<0||a<t[1]||t[2]<0||s<t[2]||t[3]<0||a<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const s=this.getImage(t);if(i&&(s.data.width!==e.data.width||s.data.height!==e.data.height))throw new Error(`size mismatch between old image (${s.data.width}x${s.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=s.version+1,this.images[t]=e,this.updatedImages[t]=!0;}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let s=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(s=!1);this.isLoaded()||s?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e});}))}_getImagesForIds(t){const i={};for(const s of t){let t=this.getImage(s);t||(this.fire(new e.k("styleimagemissing",{id:s})),t=this.getImage(s)),t?i[s]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.w(`Image "${s}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i}getPixelSize(){const{width:t,height:e}=this.atlasImage;return {width:t,height:e}}getPattern(t){const i=this.patterns[t],s=this.getImage(t);if(!s)return null;if(i&&i.position.version===s.version)return i.position;if(i)i.position.version=s.version;else {const i={w:s.data.width+2,h:s.data.height+2,x:0,y:0},a=new e.I(i,s);this.patterns[t]={bin:i,position:a};}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new w(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE);}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:i,h:s}=e.p(t),a=this.atlasImage;a.resize({width:i||1,height:s||1});for(const t in this.patterns){const{bin:i}=this.patterns[t],s=i.x+1,o=i.y+1,r=this.getImage(t).data,n=r.width,l=r.height;e.R.copy(r,a,{x:0,y:0},{x:s,y:o},{width:n,height:l}),e.R.copy(r,a,{x:0,y:l-1},{x:s,y:o-1},{width:n,height:1}),e.R.copy(r,a,{x:0,y:0},{x:s,y:o+l},{width:n,height:1}),e.R.copy(r,a,{x:n-1,y:0},{x:s-1,y:o},{width:1,height:l}),e.R.copy(r,a,{x:0,y:0},{x:s+n,y:o},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(t){for(const i of t){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const t=this.getImage(i);t||e.w(`Image with ID: "${i}" was not found`),T(t)&&this.updateImage(i,t);}}}const E=1e20;function S(t,e,i,s,a,o,r,n,l){for(let h=e;h<e+s;h++)C(t,i*o+h,o,a,r,n,l);for(let h=i;h<i+a;h++)C(t,h*o+e,1,s,r,n,l);}function C(t,e,i,s,a,o,r){o[0]=0,r[0]=-E,r[1]=E,a[0]=t[e];for(let n=1,l=0,h=0;n<s;n++){a[n]=t[e+n*i];const s=n*n;do{const t=o[l];h=(a[n]-a[t]+s-t*t)/(n-t)/2;}while(h<=r[l]&&--l>-1);l++,o[l]=n,r[l]=h,r[l+1]=E;}for(let n=0,l=0;n<s;n++){for(;r[l+1]<n;)l++;const s=o[l],h=n-s;t[e+n*i]=a[s]+h*h;}}class P{constructor(t,e){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={};}setURL(t){this.url=t;}getGlyphs(t){return e._(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const s of t[i])e.push(this._getAndCacheGlyphsPromise(i,s));const i=yield Promise.all(e),s={};for(const{stack:t,id:e,glyph:a}of i)s[t]||(s[t]={}),s[t][e]=a&&{id:a.id,bitmap:a.bitmap.clone(),metrics:a.metrics};return s}))}_getAndCacheGlyphsPromise(t,i){return e._(this,void 0,void 0,(function*(){let e=this.entries[t];e||(e=this.entries[t]={glyphs:{},requests:{},ranges:{}});let s=e.glyphs[i];if(void 0!==s)return {stack:t,id:i,glyph:s};if(s=this._tinySDF(e,t,i),s)return e.glyphs[i]=s,{stack:t,id:i,glyph:s};const a=Math.floor(i/256);if(256*a>65535)throw new Error("glyphs > 65535 not supported");if(e.ranges[a])return {stack:t,id:i,glyph:s};if(!this.url)throw new Error("glyphsUrl is not set");if(!e.requests[a]){const i=P.loadGlyphRange(t,a,this.url,this.requestManager);e.requests[a]=i;}const o=yield e.requests[a];for(const t in o)this._doesCharSupportLocalGlyph(+t)||(e.glyphs[+t]=o[+t]);return e.ranges[a]=!0,{stack:t,id:i,glyph:o[i]||null}}))}_doesCharSupportLocalGlyph(t){return !!this.localIdeographFontFamily&&(e.u["CJK Unified Ideographs"](t)||e.u["Hangul Syllables"](t)||e.u.Hiragana(t)||e.u.Katakana(t))}_tinySDF(t,i,s){const a=this.localIdeographFontFamily;if(!a)return;if(!this._doesCharSupportLocalGlyph(s))return;let o=t.tinySDF;if(!o){let e="400";/bold/i.test(i)?e="900":/medium/i.test(i)?e="500":/light/i.test(i)&&(e="200"),o=t.tinySDF=new P.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:a,fontWeight:e});}const r=o.draw(String.fromCharCode(s));return {id:s,bitmap:new e.o({width:r.width||60,height:r.height||60},r.data),metrics:{width:r.glyphWidth/2||24,height:r.glyphHeight/2||24,left:r.glyphLeft/2+.5||0,top:r.glyphTop/2-27.5||-8,advance:r.glyphAdvance/2||24,isDoubleResolution:!0}}}}P.loadGlyphRange=function(t,i,s,a){return e._(this,void 0,void 0,(function*(){const o=256*i,r=o+255,n=a.transformRequest(s.replace("{fontstack}",t).replace("{range}",`${o}-${r}`),p.Glyphs),l=yield e.l(n,new AbortController);if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${o}-${r}`);const h={};for(const t of e.n(l.data))h[t.id]=t;return h}))},P.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:s=.25,fontFamily:a="sans-serif",fontWeight:o="normal",fontStyle:r="normal"}={}){this.buffer=e,this.cutoff=s,this.radius=i;const n=this.size=t+4*e,l=this._createCanvas(n),h=this.ctx=l.getContext("2d",{willReadFrequently:!0});h.font=`${r} ${o} ${t}px ${a}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(n*n),this.gridInner=new Float64Array(n*n),this.f=new Float64Array(n),this.z=new Float64Array(n+1),this.v=new Uint16Array(n);}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:s,actualBoundingBoxLeft:a,actualBoundingBoxRight:o}=this.ctx.measureText(t),r=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-a))),l=Math.min(this.size-this.buffer,r+Math.ceil(s)),h=n+2*this.buffer,c=l+2*this.buffer,u=Math.max(h*c,0),d=new Uint8ClampedArray(u),_={data:d,width:h,height:c,glyphWidth:n,glyphHeight:l,glyphTop:r,glyphLeft:0,glyphAdvance:e};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;p.clearRect(m,m,n,l),p.fillText(t,m,m+r);const v=p.getImageData(m,m,n,l);g.fill(E,0,u),f.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<n;e++){const i=v.data[4*(t*n+e)+3]/255;if(0===i)continue;const s=(t+m)*h+e+m;if(1===i)g[s]=0,f[s]=E;else {const t=.5-i;g[s]=t>0?t*t:0,f[s]=t<0?t*t:0;}}S(g,0,0,h,c,h,this.f,this.v,this.z),S(f,m,m,n,l,h,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(f[t]);d[t]=Math.round(255-255*(e/this.radius+this.cutoff));}return _}};class D{constructor(){this.specification=e.v.light.position;}possiblyEvaluate(t,i){return e.y(t.expression.evaluate(i))}interpolate(t,i,s){return {x:e.z.number(t.x,i.x,s),y:e.z.number(t.y,i.y,s),z:e.z.number(t.z,i.z,s)}}}let z;class M extends e.E{constructor(t){super(),z=z||new e.q({anchor:new e.D(e.v.light.anchor),position:new D,color:new e.D(e.v.light.color),intensity:new e.D(e.v.light.intensity)}),this._transitionable=new e.T(z),this.setLight(t),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(t,i={}){if(!this._validate(e.r,t,i))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i);}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t);}_validate(t,i,s){return (!s||!1!==s.validate)&&e.t(this,t.call(e.x,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.v}))}}class A{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const s=[];let a=t.length%2==1?-t[t.length-1]*i:0,o=t[0]*i,r=!0;s.push({left:a,right:o,isDash:r,zeroLength:0===t[0]});let n=t[0];for(let e=1;e<t.length;e++){r=!r;const l=t[e];a=n*i,n+=l,o=n*i,s.push({left:a,right:o,isDash:r,zeroLength:0===l});}return s}addRoundDash(t,e,i){const s=e/2;for(let e=-i;e<=i;e++){const a=this.width*(this.nextRow+i+e);let o=0,r=t[o];for(let n=0;n<this.width;n++){n/r.right>1&&(r=t[++o]);const l=Math.abs(n-r.left),h=Math.abs(n-r.right),c=Math.min(l,h);let u;const d=e/i*(s+1);if(r.isDash){const t=s-Math.abs(d);u=Math.sqrt(c*c+t*t);}else u=s-Math.sqrt(c*c+d*d);this.data[a+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],s=t[e+1];i.zeroLength?t.splice(e,1):s&&s.isDash===i.isDash&&(s.left=i.left,t.splice(e,1));}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const s=this.width*this.nextRow;let a=0,o=t[a];for(let e=0;e<this.width;e++){e/o.right>1&&(o=t[++a]);const i=Math.abs(e-o.left),r=Math.abs(e-o.right),n=Math.min(i,r);this.data[s+e]=Math.max(0,Math.min(255,(o.isDash?n:-n)+128));}}addDash(t,i){const s=i?7:0,a=2*s+1;if(this.nextRow+a>this.height)return e.w("LineAtlas out of space"),null;let o=0;for(let e=0;e<t.length;e++)o+=t[e];if(0!==o){const e=this.width/o,a=this.getDashRanges(t,this.width,e);i?this.addRoundDash(a,e,s):this.addRegularDash(a);}const r={y:(this.nextRow+s+.5)/this.height,height:2*s/this.height,width:o};return this.nextRow+=a,this.dirty=!0,r}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data));}}const R="maplibre_preloaded_worker_pool";class L{constructor(){this.active={};}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<L.workerCount;)this.workers.push(new Worker(e.a.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[R]}numActive(){return Object.keys(this.active).length}}const k=Math.floor(o.hardwareConcurrency/2);let F,B;function O(){return F||(F=new L),F}L.workerCount=e.B(globalThis)?Math.max(Math.min(k,3),1):1;class N{constructor(t,i){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=i;const s=this.workerPool.acquire(i);for(let t=0;t<s.length;t++){const a=new e.C(s[t],i);a.name=`Worker ${t}`,this.actors.push(a);}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const s of this.actors)i.push(s.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove();})),this.actors=[],t&&this.workerPool.release(this.id);}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e);}}function U(){return B||(B=new N(O(),e.G),B.registerMessageHandler("getResource",((t,i,s)=>e.m(i,s)))),B}function Z(t,i){const s=e.F();return e.H(s,s,[1,1,0]),e.J(s,s,[.5*t.width,.5*t.height,1]),e.K(s,s,t.calculatePosMatrix(i.toUnwrapped()))}function G(t,e,i,s,a,o){const r=function(t,e,i){if(t)for(const s of t){const t=e[s];if(t&&t.source===i&&"fill-extrusion"===t.type)return !0}else for(const t in e){const s=e[t];if(s.source===i&&"fill-extrusion"===s.type)return !0}return !1}(a&&a.layers,e,t.id),n=o.maxPitchScaleFactor(),l=t.tilesIn(s,n,r);l.sort(j);const h=[];for(const s of l)h.push({wrappedTileID:s.tileID.wrapped().key,queryResults:s.tile.queryRenderedFeatures(e,i,t._state,s.queryGeometry,s.cameraQueryGeometry,s.scale,a,o,n,Z(t.transform,s.tileID))});const c=function(t){const e={},i={};for(const s of t){const t=s.queryResults,a=s.wrappedTileID,o=i[a]=i[a]||{};for(const i in t){const s=t[i],a=o[i]=o[i]||{},r=e[i]=e[i]||[];for(const t of s)a[t.featureIndex]||(a[t.featureIndex]=!0,r.push(t));}}return e}(h);for(const e in c)c[e].forEach((e=>{const i=e.feature,s=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=s;}));return c}function j(t,e){const i=t.tileID,s=e.tileID;return i.overscaledZ-s.overscaledZ||i.canonical.y-s.canonical.y||i.wrap-s.wrap||i.canonical.x-s.canonical.x}function q(t,i,s){return e._(this,void 0,void 0,(function*(){let a=t;if(t.url?a=(yield e.h(i.transformRequest(t.url,p.Source),s)).data:yield o.frameAsync(s),!a)return null;const r=e.L(e.e(a,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return "vector_layers"in a&&a.vector_layers&&(r.vectorLayerIds=a.vector_layers.map((t=>t.id))),r}))}class V{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])));}setNorthEast(t){return this._ne=t instanceof e.M?new e.M(t.lng,t.lat):e.M.convert(t),this}setSouthWest(t){return this._sw=t instanceof e.M?new e.M(t.lng,t.lat):e.M.convert(t),this}extend(t){const i=this._sw,s=this._ne;let a,o;if(t instanceof e.M)a=t,o=t;else {if(!(t instanceof V))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(V.convert(t)):this.extend(e.M.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend(e.M.convert(t)):this;if(a=t._sw,o=t._ne,!a||!o)return this}return i||s?(i.lng=Math.min(a.lng,i.lng),i.lat=Math.min(a.lat,i.lat),s.lng=Math.max(o.lng,s.lng),s.lat=Math.max(o.lat,s.lat)):(this._sw=new e.M(a.lng,a.lat),this._ne=new e.M(o.lng,o.lat)),this}getCenter(){return new e.M((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new e.M(this.getWest(),this.getNorth())}getSouthEast(){return new e.M(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:i,lat:s}=e.M.convert(t);let a=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(a=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=s&&s<=this._ne.lat&&a}static convert(t){return t instanceof V?t:t?new V(t):t}static fromLngLat(t,i=0){const s=360*i/40075017,a=s/Math.cos(Math.PI/180*t.lat);return new V(new e.M(t.lng-a,t.lat-s),new e.M(t.lng+a,t.lat+s))}}class W{constructor(t,e,i){this.bounds=V.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24;}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),s=Math.floor(e.N(this.bounds.getWest())*i),a=Math.floor(e.O(this.bounds.getNorth())*i),o=Math.ceil(e.N(this.bounds.getEast())*i),r=Math.ceil(e.O(this.bounds.getSouth())*i);return t.x>=s&&t.x<o&&t.y>=a&&t.y<r}}class H extends e.E{constructor(t,i,s,a){if(super(),this.id=t,this.dispatcher=s,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.e(this,e.L(i,["url","scheme","tileSize","promoteId"])),this._options=e.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(a);}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new e.k("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield q(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),t&&(e.e(this,t),t.bounds&&(this.tileBounds=new W(t.bounds,this.minzoom,this.maxzoom)),this.fire(new e.k("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.k("data",{dataType:"source",sourceDataType:"content"})));}catch(t){this._tileJSONRequest=null,this.fire(new e.j(t));}}))}loaded(){return this._loaded}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load();}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load();}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t;})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return e.e({},this._options)}loadTile(t){return e._(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,p.Tile),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId};i.request.collectResourceTiming=this._collectResourceTiming;let s="reloadTile";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i};}))}else t.actor=this.dispatcher.getActor(),s="loadTile";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:s,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e);}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null);}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject);}}abortTile(t){return e._(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"abortTile",data:{uid:t.uid,type:this.type,source:this.id}}));}))}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"removeTile",data:{uid:t.uid,type:this.type,source:this.id}}));}))}hasTransition(){return !1}}class $ extends e.E{constructor(t,i,s,a){super(),this.id=t,this.dispatcher=s,this.setEventedParent(a),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.e({type:"raster"},i),e.e(this,e.L(i,["url","scheme","tileSize"]));}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new e.k("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield q(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,t&&(e.e(this,t),t.bounds&&(this.tileBounds=new W(t.bounds,this.minzoom,this.maxzoom)),this.fire(new e.k("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.k("data",{dataType:"source",sourceDataType:"content"})));}catch(t){this._tileJSONRequest=null,this.fire(new e.j(t));}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load();}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t;})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t;})),this}serialize(){return e.e({},this._options)}hasTile(t){return !this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return e._(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield _.getImage(this.map._requestManager.transformRequest(e,p.Tile),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,s=e.gl,a=i.data;t.texture=this.map.painter.getTileTexture(a.width),t.texture?t.texture.update(a,{useMipmap:!0}):(t.texture=new w(e,a,s.RGBA,{useMipmap:!0}),t.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE,s.LINEAR_MIPMAP_NEAREST),e.extTextureFilterAnisotropic&&s.texParameterf(s.TEXTURE_2D,e.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.extTextureFilterAnisotropicMax)),t.state="loaded";}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return e._(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController);}))}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture);}))}hasTransition(){return !1}}class X extends ${constructor(t,i,s,a){super(t,i,s,a),this.type="raster-dem",this.maxzoom=22,this._options=e.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(t){return e._(this,void 0,void 0,(function*(){const i=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),s=this.map._requestManager.transformRequest(i,p.Tile);t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const i=yield _.getImage(s,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){const s=i.data;this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const a=e.b(s)&&e.S()?s:yield this.readImageNow(s),o={type:this.type,uid:t.uid,source:this.id,rawImageData:a,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"loadDEMTile",data:o});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded";}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return e._(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&e.U()){const i=t.width+2,s=t.height+2;try{return new e.R({width:i,height:s},yield e.V(t,-1,-1,i,s))}catch(t){}}return o.getImageData(t,1)}))}_getNeighboringTiles(t){const i=t.canonical,s=Math.pow(2,i.z),a=(i.x-1+s)%s,o=0===i.x?t.wrap-1:t.wrap,r=(i.x+1+s)%s,n=i.x+1===s?t.wrap+1:t.wrap,l={};return l[new e.Q(t.overscaledZ,o,i.z,a,i.y).key]={backfilled:!1},l[new e.Q(t.overscaledZ,n,i.z,r,i.y).key]={backfilled:!1},i.y>0&&(l[new e.Q(t.overscaledZ,o,i.z,a,i.y-1).key]={backfilled:!1},l[new e.Q(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.Q(t.overscaledZ,n,i.z,r,i.y-1).key]={backfilled:!1}),i.y+1<s&&(l[new e.Q(t.overscaledZ,o,i.z,a,i.y+1).key]={backfilled:!1},l[new e.Q(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.Q(t.overscaledZ,n,i.z,r,i.y+1).key]={backfilled:!1}),l}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"removeDEMTile",data:{type:this.type,uid:t.uid,source:this.id}}));}))}}class K extends e.E{constructor(t,i,s,a){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._pendingLoads=0,this.actor=s.getActor(),this.setEventedParent(a),this._data=i.data,this._options=e.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const o=e.W/this.tileSize;this.workerOptions=e.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*o,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*o,extent:e.W,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.W,radius:(i.clusterRadius||50)*o,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}load(){return e._(this,void 0,void 0,(function*(){yield this._updateWorkerData();}))}onAdd(t){this.map=t,this.load();}setData(t){return this._data=t,this._updateWorkerData(),this}updateData(t){return this._updateWorkerData(t),this}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,t&&(void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=t.clusterRadius),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=t.clusterMaxZoom)),this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"getClusterExpansionZoom",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"getClusterChildren",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"getClusterLeaves",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(t){return e._(this,void 0,void 0,(function*(){const i=e.e({type:this.type},this.workerOptions);t?i.dataDiff=t:"string"==typeof this._data?(i.request=this.map._requestManager.transformRequest(o.resolveURL(this._data),p.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(this._data),this._pendingLoads++,this.fire(new e.k("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"loadData",data:i});if(this._pendingLoads--,this._removed||t.abandoned)return void this.fire(new e.k("dataabort",{dataType:"source"}));let s=null;t.resourceTiming&&t.resourceTiming[this.id]&&(s=t.resourceTiming[this.id].slice(0));const a={dataType:"source"};this._collectResourceTiming&&s&&s.length>0&&e.e(a,{resourceTiming:s}),this.fire(new e.k("data",Object.assign(Object.assign({},a),{sourceDataType:"metadata"}))),this.fire(new e.k("data",Object.assign(Object.assign({},a),{sourceDataType:"content"})));}catch(t){if(this._pendingLoads--,this._removed)return void this.fire(new e.k("dataabort",{dataType:"source"}));this.fire(new e.j(t));}}))}loaded(){return 0===this._pendingLoads}loadTile(t){return e._(this,void 0,void 0,(function*(){const e=t.actor?"reloadTile":"loadTile";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId};t.abortController=new AbortController;const s=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(s,this.map.painter,"reloadTile"===e);}))}abortTile(t){return e._(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0;}))}unloadTile(t){return e._(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"removeTile",data:{uid:t.uid,type:this.type,source:this.id}});}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"removeSource",data:{type:this.type,source:this.id}});}serialize(){return e.e({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}}var Y=e.X([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class J extends e.E{constructor(t,e,i,s){super(),this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(s),this.options=e;}load(t){return e._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new e.k("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield _.getImage(this.map._requestManager.transformRequest(this.url,p.Image),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading());}catch(t){this._request=null,this.fire(new e.j(t));}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new e.k("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(t){this.map=t,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(t){this.coordinates=t;const i=t.map(e.Y.fromLngLat);this.tileID=function(t){let i=1/0,s=1/0,a=-1/0,o=-1/0;for(const e of t)i=Math.min(i,e.x),s=Math.min(s,e.y),a=Math.max(a,e.x),o=Math.max(o,e.y);const r=Math.max(a-i,o-s),n=Math.max(0,Math.floor(-Math.log(r)/Math.LN2)),l=Math.pow(2,n);return new e.a0(n,Math.floor((i+a)/2*l),Math.floor((s+o)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z;const s=i.map((t=>this.tileID.getTilePoint(t)._round()));return this._boundsArray=new e.Z,this._boundsArray.emplaceBack(s[0].x,s[0].y,0,0),this._boundsArray.emplaceBack(s[1].x,s[1].y,e.W,0),this._boundsArray.emplaceBack(s[3].x,s[3].y,0,e.W),this._boundsArray.emplaceBack(s[2].x,s[2].y,e.W,e.W),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this.fire(new e.k("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,i=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,Y.members)),this.boundsSegments||(this.boundsSegments=e.$.simpleSegment(0,0,4,2)),this.texture||(this.texture=new w(t,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let s=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,s=!0);}s&&this.fire(new e.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(t){return e._(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored";}))}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}class Q extends J{constructor(t,e,i,s){super(t,e,i,s),this.roundZoom=!0,this.type="video",this.options=e;}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,p.Source).url);try{const t=yield e.a2(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading();}catch(t){this.fire(new e.j(t));}}))}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.j(new e.a1(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,Y.members)),this.boundsSegments||(this.boundsSegments=e.$.simpleSegment(0,0,4,2)),this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new w(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let s=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,s=!0);}s&&this.fire(new e.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class tt extends J{constructor(t,i,s,a){super(t,i,s,a),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new e.j(new e.a1(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.j(new e.a1(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.j(new e.a1(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new e.j(new e.a1(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.j(new e.a1(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return e._(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.j(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,s=i.gl;this.boundsBuffer||(this.boundsBuffer=i.createVertexBuffer(this._boundsArray,Y.members)),this.boundsSegments||(this.boundsSegments=e.$.simpleSegment(0,0,4,2)),this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new w(i,this.canvas,s.RGBA,{premultiply:!0});let a=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,a=!0);}a&&this.fire(new e.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of [this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return !0;return !1}}const et={},it=t=>{switch(t){case"geojson":return K;case"image":return J;case"raster":return $;case"raster-dem":return X;case"vector":return H;case"video":return Q;case"canvas":return tt}return et[t]};class st extends e.E{constructor(){super(...arguments),this.pluginStatus="unavailable",this.pluginURL=null,this.dispatcher=U(),this.queue=[];}_sendPluginStateToWorker(){return e._(this,void 0,void 0,(function*(){yield this.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}),this.fire(new e.k("pluginStateChange",{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}));}))}getRTLTextPluginStatus(){return this.pluginStatus}clearRTLTextPlugin(){this.pluginStatus="unavailable",this.pluginURL=null;}setRTLTextPlugin(t,i=!1){return e._(this,void 0,void 0,(function*(){if("deferred"===this.pluginStatus||"loading"===this.pluginStatus||"loaded"===this.pluginStatus)throw new Error("setRTLTextPlugin cannot be called multiple times.");this.pluginURL=o.resolveURL(t),this.pluginStatus="deferred",yield this._sendPluginStateToWorker(),i||(yield this._downloadRTLTextPlugin());}))}_downloadRTLTextPlugin(){return e._(this,void 0,void 0,(function*(){if("deferred"!==this.pluginStatus||!this.pluginURL)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");try{this.pluginStatus="loading",yield this._sendPluginStateToWorker(),yield e.l({url:this.pluginURL},new AbortController),this.pluginStatus="loaded";}catch(t){this.pluginStatus="error";}yield this._sendPluginStateToWorker();}))}lazyLoadRTLTextPlugin(){return e._(this,void 0,void 0,(function*(){"deferred"===this.pluginStatus&&(yield this._downloadRTLTextPlugin());}))}}let at=null;function ot(){return at||(at=new st),at}class rt{constructor(t,i){this.timeAdded=0,this.fadeEndTime=0,this.tileID=t,this.uid=e.a3(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(t){const e=t+this.timeAdded;e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(t,i,s){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const s of t){const t=s.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){s.layers=t,s.stateDependentLayerIds&&(s.stateDependentLayers=s.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=s;}}return i}(t.buckets,i.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.a5){if(this.hasSymbolBuckets=!0,!s)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const i=this.buckets[t];if(i instanceof e.a5&&i.hasRTLText){this.hasRTLText=!0,ot().lazyLoadRTLTextPlugin();break}}this.queryPadding=0;for(const t in this.buckets){const e=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(t).queryRadius(e));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage);}else this.collisionBoxArray=new e.a4;}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new w(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new w(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,i,s,a,o,r,n,l,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:s,cameraQueryGeometry:a,scale:o,tileSize:this.tileSize,pixelPosMatrix:h,transform:n,params:r,queryPadding:this.queryPadding*l},t,e,i):{}}querySourceFeatures(t,i){const s=this.latestFeatureIndex;if(!s||!s.rawTileData)return;const a=s.loadVTLayers(),o=i&&i.sourceLayer?i.sourceLayer:"",r=a._geojsonTileLayer||a[o];if(!r)return;const n=e.a6(i&&i.filter),{z:l,x:h,y:c}=this.tileID.canonical,u={z:l,x:h,y:c};for(let i=0;i<r.length;i++){const a=r.feature(i);if(n.needGeometry){const t=e.a7(a,!0);if(!n.filter(new e.a8(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!n.filter(new e.a8(this.tileID.overscaledZ),a))continue;const d=s.getId(a,o),_=new e.a9(a,l,h,c,d);_.tile=u,t.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const i=this.expirationTime;if(t.cacheControl){const i=e.aa(t.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let e=!1;if(this.expirationTime>t)e=!1;else if(i)if(this.expirationTime<i)e=!0;else {const s=this.expirationTime-i;s?this.expirationTime=t+Math.max(s,3e4):e=!0;}else e=!0;e?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const s in this.buckets){if(!e.style.hasLayer(s))continue;const a=this.buckets[s],o=a.layers[0].sourceLayer||"_geojsonTileLayer",r=i[o],n=t[o];if(!r||!n||0===Object.keys(n).length)continue;a.update(n,r,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(s);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(a)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<o.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=o.now()+t;}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i;}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return !0}return !1}}class nt{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const s=t.wrapped().key;void 0===this.data[s]&&(this.data[s]=[]);const a={value:e,timeout:void 0};if(void 0!==i&&(a.timeout=setTimeout((()=>{this.remove(t,a);}),i)),this.data[s].push(a),this.order.push(s),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,s=void 0===e?0:this.data[i].indexOf(e),a=this.data[i][s];return this.data[i].splice(s,1),a.timeout&&clearTimeout(a.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(a.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const i in this.data)for(const s of this.data[i])t(s.value)||e.push(s);for(const t of e)this.remove(t.value.tileID,t);}}class lt{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,i,s){const a=String(i);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][a]=this.stateChanges[t][a]||{},e.e(this.stateChanges[t][a],s),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==a&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][a]){this.deletedStates[t][a]={};for(const e in this.state[t][a])s[e]||(this.deletedStates[t][a][e]=null);}else for(const e in s)this.deletedStates[t]&&this.deletedStates[t][a]&&null===this.deletedStates[t][a][e]&&delete this.deletedStates[t][a][e];}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const s=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][s]&&(this.deletedStates[t][s]=this.deletedStates[t][s]||{},this.deletedStates[t][s][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][s])for(i in this.deletedStates[t][s]={},this.stateChanges[t][s])this.deletedStates[t][s][i]=null;else this.deletedStates[t][s]=null;else this.deletedStates[t]=null;}getState(t,i){const s=String(i),a=e.e({},(this.state[t]||{})[s],(this.stateChanges[t]||{})[s]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const e=this.deletedStates[t][i];if(null===e)return {};for(const t in e)delete a[t];}return a}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,i){const s={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const i={};for(const s in this.stateChanges[t])this.state[t][s]||(this.state[t][s]={}),e.e(this.state[t][s],this.stateChanges[t][s]),i[s]=this.state[t][s];s[t]=i;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const i={};if(null===this.deletedStates[t])for(const e in this.state[t])i[e]={},this.state[t][e]={};else for(const e in this.deletedStates[t]){if(null===this.deletedStates[t][e])this.state[t][e]={};else for(const i of Object.keys(this.deletedStates[t][e]))delete this.state[t][e][i];i[e]=this.state[t][e];}s[t]=s[t]||{},e.e(s[t],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(s).length)for(const e in t)t[e].setFeatureState(s,i);}}class ht extends e.E{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0);})),this.on("dataloading",(()=>{this._sourceErrored=!1;})),this.on("error",(()=>{this._sourceErrored=this._source.loaded();})),this._source=((t,e,i,s)=>{const a=new(it(e.type))(t,e,i,s);if(a.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${a.id}`);return a})(t,e,i,this),this._tiles={},this._cache=new nt(0,(t=>this._unloadTile(t))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new lt,this._didEmitContent=!1,this._updated=!1;}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t);}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t);}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return !0;if(!this._updated)return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain);}_loadTile(t,i,s){return e._(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,i,s);}catch(i){t.state="errored",404!==i.status?this._source.fire(new e.j(i,{tile:t})):this.update(this.transform,this.terrain);}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t);}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new e.k("dataabort",{tile:t,coord:t.tileID,dataType:"source"}));}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager);}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(ct).map((t=>t.key))}getRenderableIds(t){const i=[];for(const e in this._tiles)this._isIdRenderable(e,t)&&i.push(this._tiles[e]);return t?i.sort(((t,i)=>{const s=t.tileID,a=i.tileID,o=new e.P(s.canonical.x,s.canonical.y)._rotate(this.transform.angle),r=new e.P(a.canonical.x,a.canonical.y)._rotate(this.transform.angle);return s.overscaledZ-a.overscaledZ||r.y-o.y||r.x-o.x})).map((t=>t.tileID.key)):i.map((t=>t.tileID)).sort(ct).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(t,"reloading");}}_reloadTile(t,i){return e._(this,void 0,void 0,(function*(){const e=this._tiles[t];e&&("loading"!==e.state&&(e.state=i),yield this._loadTile(e,t,i));}))}_tileLoaded(t,i,s){t.timeAdded=o.now(),"expired"===s&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(i,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new e.k("data",{dataType:"source",tile:t,coord:t.tileID}));}_backfillDEM(t){const e=this.getRenderableIds();for(let s=0;s<e.length;s++){const a=e[s];if(t.neighboringTiles&&t.neighboringTiles[a]){const e=this.getTileByID(a);i(t,e),i(e,t);}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const s=e.tileID.canonical.y-t.tileID.canonical.y,a=Math.pow(2,t.tileID.canonical.z),o=e.tileID.key;0===i&&0===s||Math.abs(s)>1||(Math.abs(i)>1&&(1===Math.abs(i+a)?i+=a:1===Math.abs(i-a)&&(i-=a)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,s),t.neighboringTiles&&t.neighboringTiles[o]&&(t.neighboringTiles[o].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,i,s){for(const a in this._tiles){let o=this._tiles[a];if(s[a]||!o.hasData()||o.tileID.overscaledZ<=e||o.tileID.overscaledZ>i)continue;let r=o.tileID;for(;o&&o.tileID.overscaledZ>e+1;){const t=o.tileID.scaledTo(o.tileID.overscaledZ-1);o=this._tiles[t.key],o&&o.hasData()&&(r=t);}let n=r;for(;n.overscaledZ>e;)if(n=n.scaledTo(n.overscaledZ-1),t[n.key]){s[r.key]=r;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const i=this._loadedParentTiles[t.key];return i&&i.tileID.overscaledZ>=e?i:null}for(let i=t.overscaledZ-1;i>=e;i--){const e=t.scaledTo(i),s=this._getLoadedTile(e);if(s)return s}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(t.wrapped().key)}updateCacheSize(t){const i=Math.ceil(t.width/this._source.tileSize)+1,s=Math.ceil(t.height/this._source.tileSize)+1,a=Math.floor(i*s*(null===this._maxTileCacheZoomLevels?e.a.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),o="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,a):a;this._cache.setMaxSize(o);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const s=this._tiles[i];s.tileID=s.tileID.unwrapTo(s.tileID.wrap+e),t[s.tileID.key]=s;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t]);}}update(t,i){if(this.transform=t,this.terrain=i,!this._sourceLoaded||this._paused)return;let s;this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?s=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new e.Q(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(s=t.coveringTiles({tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:i}),this._source.hasTile&&(s=s.filter((t=>this._source.hasTile(t))))):s=[];const a=t.coveringZoomLevel(this._source),r=Math.max(a-ht.maxOverzooming,this._source.minzoom),n=Math.max(a+ht.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const t={};for(const e of s)if(e.canonical.z>this._source.minzoom){const i=e.scaledTo(e.canonical.z-1);t[i.key]=i;const s=e.scaledTo(Math.max(this._source.minzoom,Math.min(e.canonical.z,5)));t[s.key]=s;}s=s.concat(Object.values(t));}const l=0===s.length&&!this._updated&&this._didEmitContent;this._updated=!0,l&&this.fire(new e.k("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const h=this._updateRetainedTiles(s,a);if(ut(this._source.type)){const t={},e={},l=Object.keys(h),c=o.now();for(const i of l){const s=h[i],a=this._tiles[i];if(!a||0!==a.fadeEndTime&&a.fadeEndTime<=c)continue;const o=this.findLoadedParent(s,r);o&&(this._addTile(o.tileID),t[o.tileID.key]=o.tileID),e[i]=s;}this._retainLoadedChildren(e,a,n,h);for(const e in t)h[e]||(this._coveredTiles[e]=!0,h[e]=t[e]);if(i){const t={},e={};for(const i of s)this._tiles[i.key].hasData()?t[i.key]=i:e[i.key]=i;for(const i in e){const s=e[i].children(this._source.maxzoom);this._tiles[s[0].key]&&this._tiles[s[1].key]&&this._tiles[s[2].key]&&this._tiles[s[3].key]&&(t[s[0].key]=h[s[0].key]=s[0],t[s[1].key]=h[s[1].key]=s[1],t[s[2].key]=h[s[2].key]=s[2],t[s[3].key]=h[s[3].key]=s[3],delete e[i]);}for(const i in e){const s=this.findLoadedParent(e[i],this._source.minzoom);if(s){t[s.tileID.key]=h[s.tileID.key]=s.tileID;for(const e in t)t[e].isChildOf(s.tileID)&&delete t[e];}}for(const e in this._tiles)t[e]||(this._coveredTiles[e]=!0);}}for(const t in h)this._tiles[t].clearFadeHold();const c=e.ab(this._tiles,h);for(const t of c){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(t);}this._updateLoadedParentTileCache();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(t);}_updateRetainedTiles(t,e){const i={},s={},a=Math.max(e-ht.maxOverzooming,this._source.minzoom),o=Math.max(e+ht.maxUnderzooming,this._source.minzoom),r={};for(const s of t){const t=this._addTile(s);i[s.key]=s,t.hasData()||e<this._source.maxzoom&&(r[s.key]=s);}this._retainLoadedChildren(r,e,o,i);for(const o of t){let t=this._tiles[o.key];if(t.hasData())continue;if(e+1>this._source.maxzoom){const t=o.children(this._source.maxzoom)[0],e=this.getTile(t);if(e&&e.hasData()){i[t.key]=t;continue}}else {const t=o.children(this._source.maxzoom);if(i[t[0].key]&&i[t[1].key]&&i[t[2].key]&&i[t[3].key])continue}let r=t.wasRequested();for(let e=o.overscaledZ-1;e>=a;--e){const a=o.scaledTo(e);if(s[a.key])break;if(s[a.key]=!0,t=this.getTile(a),!t&&r&&(t=this._addTile(a)),t){const e=t.hasData();if((r||e)&&(i[a.key]=a),r=t.wasRequested(),e)break}}}return i}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let i,s=this._tiles[t].tileID;for(;s.overscaledZ>0;){if(s.key in this._loadedParentTiles){i=this._loadedParentTiles[s.key];break}e.push(s.key);const t=s.scaledTo(s.overscaledZ-1);if(i=this._getLoadedTile(t),i)break;s=t;}for(const t of e)this._loadedParentTiles[t]=i;}}_addTile(t){let i=this._tiles[t.key];if(i)return i;i=this._cache.getAndRemove(t),i&&(this._setTileReloadTimer(t.key,i),i.tileID=t,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,i)));const s=i;return i||(i=new rt(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(i,t.key,i.state)),i.uses++,this._tiles[t.key]=i,s||this._source.fire(new e.k("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t];}),i));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset();}tilesIn(t,i,s){const a=[],o=this.transform;if(!o)return a;const r=s?o.getCameraQueryGeometry(t):t,n=t.map((t=>o.pointCoordinate(t,this.terrain))),l=r.map((t=>o.pointCoordinate(t,this.terrain))),h=this.getIds();let c=1/0,u=1/0,d=-1/0,_=-1/0;for(const t of l)c=Math.min(c,t.x),u=Math.min(u,t.y),d=Math.max(d,t.x),_=Math.max(_,t.y);for(let t=0;t<h.length;t++){const s=this._tiles[h[t]];if(s.holdingForFade())continue;const r=s.tileID,p=Math.pow(2,o.zoom-s.tileID.overscaledZ),m=i*s.queryPadding*e.W/s.tileSize/p,f=[r.getTilePoint(new e.Y(c,u)),r.getTilePoint(new e.Y(d,_))];if(f[0].x-m<e.W&&f[0].y-m<e.W&&f[1].x+m>=0&&f[1].y+m>=0){const t=n.map((t=>r.getTilePoint(t))),e=l.map((t=>r.getTilePoint(t)));a.push({tile:s,tileID:r,queryGeometry:t,cameraQueryGeometry:e,scale:p});}}return a}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));for(const t of e)t.posMatrix=this.transform.calculatePosMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(ut(this._source.type)){const t=o.now();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return !0}return !1}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i);}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const s=this._tiles[t];s&&s.setDependencies(e,i);}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)));}}function ct(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),s=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||s-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function ut(t){return "raster"===t||"image"===t||"video"===t}ht.maxOverzooming=10,ht.maxUnderzooming=3;class dt{constructor(t,e){this.reset(t,e);}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.ac(t,0,1);let i=1,s=this._distances[i];const a=t*this.paddedLength+this.padding;for(;s<a&&i<this._distances.length;)s=this._distances[++i];const o=i-1,r=this._distances[o],n=s-r,l=n>0?(a-r)/n:0;return this.points[o].mult(1-l).add(this.points[i].mult(l))}}function _t(t,e){let i=!0;return "always"===t||"never"!==t&&"never"!==e||(i=!1),i}class pt{constructor(t,e,i){const s=this.boxCells=[],a=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)s.push([]),a.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,s,a){this._forEachCell(e,i,s,a,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(s),this.bboxes.push(a);}insertCircle(t,e,i,s){this._forEachCell(e-s,i-s,e+s,i+s,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(s);}_insertBoxCell(t,e,i,s,a,o){this.boxCells[a].push(o);}_insertCircleCell(t,e,i,s,a,o){this.circleCells[a].push(o);}_query(t,e,i,s,a,o,r){if(i<0||t>this.width||s<0||e>this.height)return [];const n=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=s){if(a)return [{key:null,x1:t,y1:e,x2:i,y2:s}];for(let t=0;t<this.boxKeys.length;t++)n.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],s=this.circles[3*t+2];n.push({key:this.circleKeys[t],x1:e-s,y1:i-s,x2:e+s,y2:i+s});}}else this._forEachCell(t,e,i,s,this._queryCell,n,{hitTest:a,overlapMode:o,seenUids:{box:{},circle:{}}},r);return n}query(t,e,i,s){return this._query(t,e,i,s,!1,null)}hitTest(t,e,i,s,a,o){return this._query(t,e,i,s,!0,a,o).length>0}hitTestCircle(t,e,i,s,a){const o=t-i,r=t+i,n=e-i,l=e+i;if(r<0||o>this.width||l<0||n>this.height)return !1;const h=[];return this._forEachCell(o,n,r,l,this._queryCellCircle,h,{hitTest:!0,overlapMode:s,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},a),h.length>0}_queryCell(t,e,i,s,a,o,r,n){const{seenUids:l,hitTest:h,overlapMode:c}=r,u=this.boxCells[a];if(null!==u){const a=this.bboxes;for(const r of u)if(!l.box[r]){l.box[r]=!0;const u=4*r,d=this.boxKeys[r];if(t<=a[u+2]&&e<=a[u+3]&&i>=a[u+0]&&s>=a[u+1]&&(!n||n(d))&&(!h||!_t(c,d.overlapMode))&&(o.push({key:d,x1:a[u],y1:a[u+1],x2:a[u+2],y2:a[u+3]}),h))return !0}}const d=this.circleCells[a];if(null!==d){const a=this.circles;for(const r of d)if(!l.circle[r]){l.circle[r]=!0;const u=3*r,d=this.circleKeys[r];if(this._circleAndRectCollide(a[u],a[u+1],a[u+2],t,e,i,s)&&(!n||n(d))&&(!h||!_t(c,d.overlapMode))){const t=a[u],e=a[u+1],i=a[u+2];if(o.push({key:d,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),h)return !0}}}return !1}_queryCellCircle(t,e,i,s,a,o,r,n){const{circle:l,seenUids:h,overlapMode:c}=r,u=this.boxCells[a];if(null!==u){const t=this.bboxes;for(const e of u)if(!h.box[e]){h.box[e]=!0;const i=4*e,s=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!n||n(s))&&!_t(c,s.overlapMode))return o.push(!0),!0}}const d=this.circleCells[a];if(null!==d){const t=this.circles;for(const e of d)if(!h.circle[e]){h.circle[e]=!0;const i=3*e,s=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!n||n(s))&&!_t(c,s.overlapMode))return o.push(!0),!0}}}_forEachCell(t,e,i,s,a,o,r,n){const l=this._convertToXCellCoord(t),h=this._convertToYCellCoord(e),c=this._convertToXCellCoord(i),u=this._convertToYCellCoord(s);for(let d=l;d<=c;d++)for(let l=h;l<=u;l++)if(a.call(this,t,e,i,s,this.xCellCount*l+d,o,r,n))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,s,a,o){const r=s-t,n=a-e,l=i+o;return l*l>r*r+n*n}_circleAndRectCollide(t,e,i,s,a,o,r){const n=(o-s)/2,l=Math.abs(t-(s+n));if(l>n+i)return !1;const h=(r-a)/2,c=Math.abs(e-(a+h));if(c>h+i)return !1;if(l<=n||c<=h)return !0;const u=l-n,d=c-h;return u*u+d*d<=i*i}}function mt(t,i,s,a,o){const r=e.F();return i?(e.J(r,r,[1/o,1/o,1]),s||e.ad(r,r,a.angle)):e.K(r,a.labelPlaneMatrix,t),r}function ft(t,i,s,a,o){if(i){const i=e.ae(t);return e.J(i,i,[o,o,1]),s||e.ad(i,i,-a.angle),i}return a.glCoordMatrix}function gt(t,i,s){let a;s?(a=[t.x,t.y,s(t.x,t.y),1],e.af(a,a,i)):(a=[t.x,t.y,0,1],Mt(a,a,i));const o=a[3];return {point:new e.P(a[0]/o,a[1]/o),signedDistanceFromCamera:o}}function vt(t,e){return .5+t/e*.5}function xt(t,e){const i=t[0]/t[3],s=t[1]/t[3];return i>=-e[0]&&i<=e[0]&&s>=-e[1]&&s<=e[1]}function yt(t,i,s,a,o,r,n,l,h,c){const u=a?t.textSizeData:t.iconSizeData,d=e.ag(u,s.transform.zoom),_=[256/s.width*2+1,256/s.height*2+1],p=a?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;p.clear();const m=t.lineVertexArray,f=a?t.text.placedSymbolArray:t.icon.placedSymbolArray,g=s.transform.width/s.transform.height;let v=!1;for(let a=0;a<f.length;a++){const x=f.get(a);if(x.hidden||x.writingMode===e.ah.vertical&&!v){zt(x.numGlyphs,p);continue}let y;if(v=!1,c?(y=[x.anchorX,x.anchorY,c(x.anchorX,x.anchorY),1],e.af(y,y,i)):(y=[x.anchorX,x.anchorY,0,1],Mt(y,y,i)),!xt(y,_)){zt(x.numGlyphs,p);continue}const b=vt(s.transform.cameraToCenterDistance,y[3]),w=e.ai(u,d,x),T=n?w/b:w*b,I=new e.P(x.anchorX,x.anchorY),E=gt(I,o,c).point,S={projections:{},offsets:{}},C=Tt(x,T,!1,l,i,o,r,t.glyphOffsetArray,m,p,E,I,S,g,h,c);v=C.useVertical,(C.notEnoughRoom||v||C.needsFlipping&&Tt(x,T,!0,l,i,o,r,t.glyphOffsetArray,m,p,E,I,S,g,h,c).notEnoughRoom)&&zt(x.numGlyphs,p);}a?t.text.dynamicLayoutVertexBuffer.updateData(p):t.icon.dynamicLayoutVertexBuffer.updateData(p);}function bt(t,e,i,s,a,o,r,n,l,h,c,u,d){const _=n.glyphStartIndex+n.numGlyphs,p=n.lineStartIndex,m=n.lineStartIndex+n.lineLength,f=e.getoffsetX(n.glyphStartIndex),g=e.getoffsetX(_-1),v=Pt(t*f,i,s,a,o,r,n.segment,p,m,l,h,c,u,d);if(!v)return null;const x=Pt(t*g,i,s,a,o,r,n.segment,p,m,l,h,c,u,d);return x?{first:v,last:x}:null}function wt(t,i,s,a){return t===e.ah.horizontal&&Math.abs(s.y-i.y)>Math.abs(s.x-i.x)*a?{useVertical:!0}:(t===e.ah.vertical?i.y<s.y:i.x>s.x)?{needsFlipping:!0}:null}function Tt(t,i,s,a,o,r,n,l,h,c,u,d,_,p,m,f){const g=i/24,v=t.lineOffsetX*g,x=t.lineOffsetY*g;let y;if(t.numGlyphs>1){const e=t.glyphStartIndex+t.numGlyphs,i=t.lineStartIndex,o=t.lineStartIndex+t.lineLength,c=bt(g,l,v,x,s,u,d,t,h,r,_,m,f);if(!c)return {notEnoughRoom:!0};const b=gt(c.first.point,n,f).point,w=gt(c.last.point,n,f).point;if(a&&!s){const e=wt(t.writingMode,b,w,p);if(e)return e}y=[c.first];for(let a=t.glyphStartIndex+1;a<e-1;a++)y.push(Pt(g*l.getoffsetX(a),v,x,s,u,d,t.segment,i,o,h,r,_,m,f));y.push(c.last);}else {if(a&&!s){const i=gt(d,o,f).point,s=t.lineStartIndex+t.segment+1,a=new e.P(h.getx(s),h.gety(s)),r=gt(a,o,f),n=r.signedDistanceFromCamera>0?r.point:It(d,a,i,1,o,f),l=wt(t.writingMode,i,n,p);if(l)return l}const i=Pt(g*l.getoffsetX(t.glyphStartIndex),v,x,s,u,d,t.segment,t.lineStartIndex,t.lineStartIndex+t.lineLength,h,r,_,m,f);if(!i)return {notEnoughRoom:!0};y=[i];}for(const t of y)e.aj(c,t.point,t.angle);return {}}function It(t,e,i,s,a,o){const r=gt(t.add(t.sub(e)._unit()),a,o).point,n=i.sub(r);return i.add(n._mult(s/n.mag()))}function Et(t,i){const{projectionCache:s,lineVertexArray:a,labelPlaneMatrix:o,tileAnchorPoint:r,distanceFromAnchor:n,getElevation:l,previousVertex:h,direction:c,absOffsetX:u}=i;if(s.projections[t])return s.projections[t];const d=new e.P(a.getx(t),a.gety(t)),_=gt(d,o,l);if(_.signedDistanceFromCamera>0)return s.projections[t]=_.point,_.point;const p=t-c;return It(0===n?r:new e.P(a.getx(p),a.gety(p)),d,h,u-n+1,o,l)}function St(t,e,i){return t._unit()._perp()._mult(e*i)}function Ct(t,i,s,a,o,r,n,l){const{projectionCache:h,direction:c}=l;if(h.offsets[t])return h.offsets[t];const u=s.add(i);if(t+c<a||t+c>=o)return h.offsets[t]=u,u;const d=Et(t+c,l),_=St(d.sub(s),n,c),p=s.add(_),m=d.add(_);return h.offsets[t]=e.ak(r,u,p,m)||u,h.offsets[t]}function Pt(t,e,i,s,a,o,r,n,l,h,c,u,d,_){const p=s?t-e:t+e;let m=p>0?1:-1,f=0;s&&(m*=-1,f=Math.PI),m<0&&(f+=Math.PI);let g,v,x=m>0?n+r:n+r+1,y=a,b=a,w=0,T=0;const I=Math.abs(p),E=[];let S;for(;w+T<=I;){if(x+=m,x<n||x>=l)return null;w+=T,b=y,v=g;const t={projectionCache:u,lineVertexArray:h,labelPlaneMatrix:c,tileAnchorPoint:o,distanceFromAnchor:w,getElevation:_,previousVertex:b,direction:m,absOffsetX:I};if(y=Et(x,t),0===i)E.push(b),S=y.sub(b);else {let e;const s=y.sub(b);e=0===s.mag()?St(Et(x+m,t).sub(y),i,m):St(s,i,m),v||(v=b.add(e)),g=Ct(x,e,y,n,l,v,i,t),E.push(v),S=g.sub(v);}T=S.mag();}const C=S._mult((I-w)/T)._add(v||b),P=f+Math.atan2(y.y-b.y,y.x-b.x);return E.push(C),{point:C,angle:d?P:0,path:E}}const Dt=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function zt(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(Dt,3*t);}}function Mt(t,e,i){const s=e[0],a=e[1];return t[0]=i[0]*s+i[4]*a+i[12],t[1]=i[1]*s+i[5]*a+i[13],t[3]=i[3]*s+i[7]*a+i[15],t}const At=100;class Rt{constructor(t,e=new pt(t.width+200,t.height+200,25),i=new pt(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchfactor=Math.cos(t._pitch)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+At,this.screenBottomBoundary=t.height+At,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6;}placeCollisionBox(t,e,i,s,a,o){const r=this.projectAndGetPerspectiveRatio(s,t.anchorPointX,t.anchorPointY,o),n=i*r.perspectiveRatio,l=t.x1*n+r.point.x,h=t.y1*n+r.point.y,c=t.x2*n+r.point.x,u=t.y2*n+r.point.y;return !this.isInsideGrid(l,h,c,u)||"always"!==e&&this.grid.hitTest(l,h,c,u,e,a)||r.perspectiveRatio<this.perspectiveRatioCutoff?{box:[],offscreen:!1}:{box:[l,h,c,u],offscreen:this.isOffscreen(l,h,c,u)}}placeCollisionCircles(t,i,s,a,o,r,n,l,h,c,u,d,_,p){const m=[],f=new e.P(i.anchorX,i.anchorY),g=gt(f,r,p),v=vt(this.transform.cameraToCenterDistance,g.signedDistanceFromCamera),x=(c?o/v:o*v)/e.ao,y=gt(f,n,p).point,b=bt(x,a,i.lineOffsetX*x,i.lineOffsetY*x,!1,y,f,i,s,n,{projections:{},offsets:{}},!1,p);let w=!1,T=!1,I=!0;if(b){const i=.5*d*v+_,s=new e.P(-100,-100),a=new e.P(this.screenRightBoundary,this.screenBottomBoundary),o=new dt,r=b.first,n=b.last;let c=[];for(let t=r.path.length-1;t>=1;t--)c.push(r.path[t]);for(let t=1;t<n.path.length;t++)c.push(n.path[t]);const f=2.5*i;if(l){const t=c.map((t=>gt(t,l,p)));c=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point));}let g=[];if(c.length>0){const t=c[0].clone(),i=c[0].clone();for(let e=1;e<c.length;e++)t.x=Math.min(t.x,c[e].x),t.y=Math.min(t.y,c[e].y),i.x=Math.max(i.x,c[e].x),i.y=Math.max(i.y,c[e].y);g=t.x>=s.x&&i.x<=a.x&&t.y>=s.y&&i.y<=a.y?[c]:i.x<s.x||t.x>a.x||i.y<s.y||t.y>a.y?[]:e.al([c],s.x,s.y,a.x,a.y);}for(const e of g){o.reset(e,.25*i);let s=0;s=o.length<=.5*i?1:Math.ceil(o.paddedLength/f)+1;for(let e=0;e<s;e++){const a=e/Math.max(s-1,1),r=o.lerp(a),n=r.x+At,l=r.y+At;m.push(n,l,i,0);const c=n-i,d=l-i,_=n+i,p=l+i;if(I=I&&this.isOffscreen(c,d,_,p),T=T||this.isInsideGrid(c,d,_,p),"always"!==t&&this.grid.hitTestCircle(n,l,i,t,u)&&(w=!0,!h))return {circles:[],offscreen:!1,collisionDetected:w}}}}return {circles:!h&&w||!T||v<this.perspectiveRatioCutoff?[]:m,offscreen:I,collisionDetected:w}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let s=1/0,a=1/0,o=-1/0,r=-1/0;for(const n of t){const t=new e.P(n.x+At,n.y+At);s=Math.min(s,t.x),a=Math.min(a,t.y),o=Math.max(o,t.x),r=Math.max(r,t.y),i.push(t);}const n=this.grid.query(s,a,o,r).concat(this.ignoredGrid.query(s,a,o,r)),l={},h={};for(const t of n){const s=t.key;if(void 0===l[s.bucketInstanceId]&&(l[s.bucketInstanceId]={}),l[s.bucketInstanceId][s.featureIndex])continue;const a=[new e.P(t.x1,t.y1),new e.P(t.x2,t.y1),new e.P(t.x2,t.y2),new e.P(t.x1,t.y2)];e.am(i,a)&&(l[s.bucketInstanceId][s.featureIndex]=!0,void 0===h[s.bucketInstanceId]&&(h[s.bucketInstanceId]=[]),h[s.bucketInstanceId].push(s.featureIndex));}return h}insertCollisionBox(t,e,i,s,a,o){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:s,featureIndex:a,collisionGroupID:o,overlapMode:e},t[0],t[1],t[2],t[3]);}insertCollisionCircles(t,e,i,s,a,o){const r=i?this.ignoredGrid:this.grid,n={bucketInstanceId:s,featureIndex:a,collisionGroupID:o,overlapMode:e};for(let e=0;e<t.length;e+=4)r.insertCircle(n,t[e],t[e+1],t[e+2]);}projectAndGetPerspectiveRatio(t,i,s,a){let o;return a?(o=[i,s,a(i,s),1],e.af(o,o,t)):(o=[i,s,0,1],Mt(o,o,t)),{point:new e.P((o[0]/o[3]+1)/2*this.transform.width+At,(-o[1]/o[3]+1)/2*this.transform.height+At),perspectiveRatio:.5+this.transform.cameraToCenterDistance/o[3]*.5}}isOffscreen(t,e,i,s){return i<At||t>=this.screenRightBoundary||s<At||e>this.screenBottomBoundary}isInsideGrid(t,e,i,s){return i>=0&&t<this.gridRightBoundary&&s>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=e.an([]);return e.H(t,t,[-100,-100,0]),t}}function Lt(t,i,s){return i*(e.W/(t.tileSize*Math.pow(2,s-t.tileID.overscaledZ)))}class kt{constructor(t,e,i,s){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):s&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class Ft{constructor(t,e,i,s,a){this.text=new kt(t?t.text:null,e,i,a),this.icon=new kt(t?t.icon:null,e,s,a);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Bt{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i;}}class Ot{constructor(){this.invProjMatrix=e.F(),this.viewportMatrix=e.F(),this.circles=[];}}class Nt{constructor(t,e,i,s,a){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=s,this.tileID=a;}}class Ut{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={};}get(t){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e};}return this.collisionGroups[t]}}function Zt(t,i,s,a,o){const{horizontalAlign:r,verticalAlign:n}=e.at(t);return new e.P(-(r-.5)*i+a[0]*o,-(n-.5)*s+a[1]*o)}function Gt(t,i,s,a,o,r){const{x1:n,x2:l,y1:h,y2:c,anchorPointX:u,anchorPointY:d}=t,_=new e.P(i,s);return a&&_._rotate(o?r:-r),{x1:n+_.x,y1:h+_.y,x2:l+_.x,y2:c+_.y,anchorPointX:u,anchorPointY:d}}class jt{constructor(t,e,i,s,a){this.transform=t.clone(),this.terrain=e,this.collisionIndex=new Rt(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new Ut(s),this.collisionCircleArrays={},this.prevPlacement=a,a&&(a.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,s,a){const o=s.getBucket(i),r=s.latestFeatureIndex;if(!o||!r||i.id!==o.layerIds[0])return;const n=s.collisionBoxArray,l=o.layers[0].layout,h=Math.pow(2,this.transform.zoom-s.tileID.overscaledZ),c=s.tileSize/e.W,u=this.transform.calculatePosMatrix(s.tileID.toUnwrapped()),d="map"===l.get("text-pitch-alignment"),_="map"===l.get("text-rotation-alignment"),p=Lt(s,1,this.transform.zoom),m=mt(u,d,_,this.transform,p);let f=null;if(d){const t=ft(u,d,_,this.transform,p);f=e.K([],this.transform.labelPlaneMatrix,t);}this.retainedQueryData[o.bucketInstanceId]=new Nt(o.bucketInstanceId,r,o.sourceLayerIndex,o.index,s.tileID);const g={bucket:o,layout:l,posMatrix:u,textLabelPlaneMatrix:m,labelToScreenMatrix:f,scale:h,textPixelRatio:c,holdingForFade:s.holdingForFade(),collisionBoxArray:n,partiallyEvaluatedTextSize:e.ag(o.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(o.sourceID)};if(a)for(const e of o.sortKeyRanges){const{sortKey:i,symbolInstanceStart:s,symbolInstanceEnd:a}=e;t.push({sortKey:i,symbolInstanceStart:s,symbolInstanceEnd:a,parameters:g});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:o.symbolInstances.length,parameters:g});}attemptAnchorPlacement(t,i,s,a,o,r,n,l,h,c,u,d,_,p,m,f){const g=e.ap[t.textAnchor],v=[t.textOffset0,t.textOffset1],x=Zt(g,s,a,v,o),y=this.collisionIndex.placeCollisionBox(Gt(i,x.x,x.y,r,n,this.transform.angle),u,l,h,c.predicate,f);if((!m||0!==this.collisionIndex.placeCollisionBox(Gt(m,x.x,x.y,r,n,this.transform.angle),u,l,h,c.predicate,f).box.length)&&y.box.length>0){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[d.crossTileID]&&this.prevPlacement.placements[d.crossTileID]&&this.prevPlacement.placements[d.crossTileID].text&&(t=this.prevPlacement.variableOffsets[d.crossTileID].anchor),0===d.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[d.crossTileID]={textOffset:v,width:s,height:a,anchor:g,textBoxScale:o,prevAnchor:t},this.markUsedJustification(_,g,d,p),_.allowVerticalPlacement&&(this.markUsedOrientation(_,p,d),this.placedOrientations[d.crossTileID]=p),{shift:x,placedGlyphBoxes:y}}}placeLayerBucketPart(t,i,s){const{bucket:a,layout:o,posMatrix:r,textLabelPlaneMatrix:n,labelToScreenMatrix:l,textPixelRatio:h,holdingForFade:c,collisionBoxArray:u,partiallyEvaluatedTextSize:d,collisionGroup:_}=t.parameters,p=o.get("text-optional"),m=o.get("icon-optional"),f=e.aq(o,"text-overlap","text-allow-overlap"),g="always"===f,v=e.aq(o,"icon-overlap","icon-allow-overlap"),x="always"===v,y="map"===o.get("text-rotation-alignment"),b="map"===o.get("text-pitch-alignment"),w="none"!==o.get("icon-text-fit"),T="viewport-y"===o.get("symbol-z-order"),I=g&&(x||!a.hasIconData()||m),E=x&&(g||!a.hasTextData()||p);!a.collisionArrays&&u&&a.deserializeCollisionBoxes(u);const S=this.retainedQueryData[a.bucketInstanceId].tileID,C=this.terrain?(t,e)=>this.terrain.getElevation(S,t,e):null,P=(t,u)=>{var x,T;if(i[t.crossTileID])return;if(c)return void(this.placements[t.crossTileID]=new Bt(!1,!1,!1));let S=!1,P=!1,D=!0,z=null,M={box:null,offscreen:null},A={box:null,offscreen:null},R=null,L=null,k=null,F=0,B=0,O=0;u.textFeatureIndex?F=u.textFeatureIndex:t.useRuntimeCollisionCircles&&(F=t.featureIndex),u.verticalTextFeatureIndex&&(B=u.verticalTextFeatureIndex);const N=u.textBox;if(N){const i=i=>{let s=e.ah.horizontal;if(a.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,s=e,this.markUsedOrientation(a,s,t));}return s},s=(i,s)=>{if(a.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&u.verticalTextBox){for(const t of a.writingModes)if(t===e.ah.vertical?(M=s(),A=M):M=i(),M&&M.box&&M.box.length)break}else M=i();},o=t.textAnchorOffsetStartIndex,n=t.textAnchorOffsetEndIndex;if(n===o){const o=(e,i)=>{const s=this.collisionIndex.placeCollisionBox(e,f,h,r,_.predicate,C);return s&&s.box&&s.box.length&&(this.markUsedOrientation(a,i,t),this.placedOrientations[t.crossTileID]=i),s};s((()=>o(N,e.ah.horizontal)),(()=>{const i=u.verticalTextBox;return a.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&i?o(i,e.ah.vertical):{box:null,offscreen:null}})),i(M&&M.box&&M.box.length);}else {let l=e.ap[null===(T=null===(x=this.prevPlacement)||void 0===x?void 0:x.variableOffsets[t.crossTileID])||void 0===T?void 0:T.anchor];const c=(e,i,s)=>{const c=e.x2-e.x1,u=e.y2-e.y1,d=t.textBoxScale,p=w&&"never"===v?i:null;let m={box:[],offscreen:!1},g="never"===f?1:2,x="never";l&&g++;for(let i=0;i<g;i++){for(let i=o;i<n;i++){const o=a.textAnchorOffsets.get(i);if(l&&o.textAnchor!==l)continue;const n=this.attemptAnchorPlacement(o,e,c,u,d,y,b,h,r,_,x,t,a,s,p,C);if(n&&(m=n.placedGlyphBoxes,m&&m.box&&m.box.length))return S=!0,z=n.shift,m}l?l=null:x=f;}return m};s((()=>c(N,u.iconBox,e.ah.horizontal)),(()=>{const i=u.verticalTextBox;return a.allowVerticalPlacement&&!(M&&M.box&&M.box.length)&&t.numVerticalGlyphVertices>0&&i?c(i,u.verticalIconBox,e.ah.vertical):{box:null,offscreen:null}})),M&&(S=M.box,D=M.offscreen);const d=i(M&&M.box);if(!S&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(a,e.anchor,t,d));}}}if(R=M,S=R&&R.box&&R.box.length>0,D=R&&R.offscreen,t.useRuntimeCollisionCircles){const i=a.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),h=e.ai(a.textSizeData,d,i),c=o.get("text-padding");L=this.collisionIndex.placeCollisionCircles(f,i,a.lineVertexArray,a.glyphOffsetArray,h,r,n,l,s,b,_.predicate,t.collisionCircleDiameter,c,C),L.circles.length&&L.collisionDetected&&!s&&e.w("Collisions detected, but collision boxes are not shown"),S=g||L.circles.length>0&&!L.collisionDetected,D=D&&L.offscreen;}if(u.iconFeatureIndex&&(O=u.iconFeatureIndex),u.iconBox){const t=t=>{const e=w&&z?Gt(t,z.x,z.y,y,b,this.transform.angle):t;return this.collisionIndex.placeCollisionBox(e,v,h,r,_.predicate,C)};A&&A.box&&A.box.length&&u.verticalIconBox?(k=t(u.verticalIconBox),P=k.box.length>0):(k=t(u.iconBox),P=k.box.length>0),D=D&&k.offscreen;}const U=p||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,Z=m||0===t.numIconVertices;if(U||Z?Z?U||(P=P&&S):S=P&&S:P=S=P&&S,S&&R&&R.box&&this.collisionIndex.insertCollisionBox(R.box,f,o.get("text-ignore-placement"),a.bucketInstanceId,A&&A.box&&B?B:F,_.ID),P&&k&&this.collisionIndex.insertCollisionBox(k.box,v,o.get("icon-ignore-placement"),a.bucketInstanceId,O,_.ID),L&&(S&&this.collisionIndex.insertCollisionCircles(L.circles,f,o.get("text-ignore-placement"),a.bucketInstanceId,F,_.ID),s)){const t=a.bucketInstanceId;let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=new Ot);for(let t=0;t<L.circles.length;t+=4)e.circles.push(L.circles[t+0]),e.circles.push(L.circles[t+1]),e.circles.push(L.circles[t+2]),e.circles.push(L.collisionDetected?1:0);}if(0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===a.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new Bt(S||I,P||E,D||a.justReloaded),i[t.crossTileID]=!0;};if(T){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=a.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];P(a.symbolInstances.get(i),a.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)P(a.symbolInstances.get(e),a.collisionArrays[e]);if(s&&a.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[a.bucketInstanceId];e.ar(t.invProjMatrix,r),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}a.justReloaded=!1;}markUsedJustification(t,i,s,a){let o;o=a===e.ah.vertical?s.verticalPlacedTextSymbolIndex:{left:s.leftJustifiedTextSymbolIndex,center:s.centerJustifiedTextSymbolIndex,right:s.rightJustifiedTextSymbolIndex}[e.as(i)];const r=[s.leftJustifiedTextSymbolIndex,s.centerJustifiedTextSymbolIndex,s.rightJustifiedTextSymbolIndex,s.verticalPlacedTextSymbolIndex];for(const e of r)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=o>=0&&e!==o?0:s.crossTileID);}markUsedOrientation(t,i,s){const a=i===e.ah.horizontal||i===e.ah.horizontalOnly?i:0,o=i===e.ah.vertical?i:0,r=[s.leftJustifiedTextSymbolIndex,s.centerJustifiedTextSymbolIndex,s.rightJustifiedTextSymbolIndex];for(const e of r)t.text.placedSymbolArray.get(e).placedOrientation=a;s.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(s.verticalPlacedTextSymbolIndex).placedOrientation=o);}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const s=e?e.symbolFadeChange(t):1,a=e?e.opacities:{},o=e?e.variableOffsets:{},r=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],o=a[t];o?(this.opacities[t]=new Ft(o,s,e.text,e.icon),i=i||e.text!==o.text.placed||e.icon!==o.icon.placed):(this.opacities[t]=new Ft(null,s,e.text,e.icon,e.skipFade),i=i||e.text||e.icon);}for(const t in a){const e=a[t];if(!this.opacities[t]){const a=new Ft(e,s,!1,!1);a.isHidden()||(this.opacities[t]=a,i=i||e.text.placed||e.icon.placed);}}for(const t in o)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=o[t]);for(const t in r)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=r[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t);}updateLayerOpacities(t,e){const i={};for(const s of e){const e=s.getBucket(t);e&&s.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,i,s.collisionBoxArray);}}updateBucketOpacities(t,i,s){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const a=t.layers[0],o=a.layout,r=new Ft(null,0,!1,!1,!0),n=o.get("text-allow-overlap"),l=o.get("icon-allow-overlap"),h=a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"),c="map"===o.get("text-rotation-alignment"),u="map"===o.get("text-pitch-alignment"),d="none"!==o.get("icon-text-fit"),_=new Ft(null,0,n&&(l||!t.hasIconData()||o.get("icon-optional")),l&&(n||!t.hasTextData()||o.get("text-optional")),!0);!t.collisionArrays&&s&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(s);const p=(t,e,i)=>{for(let s=0;s<e/4;s++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==Qt;};for(let s=0;s<t.symbolInstances.length;s++){const a=t.symbolInstances.get(s),{numHorizontalGlyphVertices:o,numVerticalGlyphVertices:n,crossTileID:l}=a;let m=this.opacities[l];i[l]?m=r:m||(m=_,this.opacities[l]=m),i[l]=!0;const f=a.numIconVertices>0,g=this.placedOrientations[a.crossTileID],v=g===e.ah.vertical,x=g===e.ah.horizontal||g===e.ah.horizontalOnly;if(o>0||n>0){const e=Jt(m.text);p(t.text,o,v?Qt:e),p(t.text,n,x?Qt:e);const i=m.text.isHidden();[a.rightJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||v?1:0);})),a.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(a.verticalPlacedTextSymbolIndex).hidden=i||x?1:0);const s=this.variableOffsets[a.crossTileID];s&&this.markUsedJustification(t,s.anchor,a,g);const r=this.placedOrientations[a.crossTileID];r&&(this.markUsedJustification(t,"left",a,r),this.markUsedOrientation(t,r,a));}if(f){const e=Jt(m.icon),i=!(d&&a.verticalPlacedIconSymbolIndex&&v);a.placedIconSymbolIndex>=0&&(p(t.icon,a.numIconVertices,i?e:Qt),t.icon.placedSymbolArray.get(a.placedIconSymbolIndex).hidden=m.icon.isHidden()),a.verticalPlacedIconSymbolIndex>=0&&(p(t.icon,a.numVerticalIconVertices,i?Qt:e),t.icon.placedSymbolArray.get(a.verticalPlacedIconSymbolIndex).hidden=m.icon.isHidden());}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[s];if(i){let s=new e.P(0,0);if(i.textBox||i.verticalTextBox){let e=!0;if(h){const t=this.variableOffsets[l];t?(s=Zt(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),c&&s._rotate(u?this.transform.angle:-this.transform.angle)):e=!1;}i.textBox&&qt(t.textCollisionBox.collisionVertexArray,m.text.placed,!e||v,s.x,s.y),i.verticalTextBox&&qt(t.textCollisionBox.collisionVertexArray,m.text.placed,!e||x,s.x,s.y);}const a=Boolean(!x&&i.verticalIconBox);i.iconBox&&qt(t.iconCollisionBox.collisionVertexArray,m.icon.placed,a,d?s.x:0,d?s.y:0),i.verticalIconBox&&qt(t.iconCollisionBox.collisionVertexArray,m.icon.placed,!a,d?s.x:0,d?s.y:0);}}}if(t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);if(t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0;}}function qt(t,e,i,s,a){t.emplaceBack(e?1:0,i?1:0,s||0,a||0),t.emplaceBack(e?1:0,i?1:0,s||0,a||0),t.emplaceBack(e?1:0,i?1:0,s||0,a||0),t.emplaceBack(e?1:0,i?1:0,s||0,a||0);}const Vt=Math.pow(2,25),Wt=Math.pow(2,24),Ht=Math.pow(2,17),$t=Math.pow(2,16),Xt=Math.pow(2,9),Kt=Math.pow(2,8),Yt=Math.pow(2,1);function Jt(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*Vt+e*Wt+i*Ht+e*$t+i*Xt+e*Kt+i*Yt+e}const Qt=0;class te{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(t,e,i,s,a){const o=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(o,s,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,a())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,o.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<o.length;)if(e.placeLayerBucketPart(o[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,a())return !0;return !1}}class ee{constructor(t,e,i,s,a,o,r,n){this.placement=new jt(t,e,o,r,n),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=s,this._showCollisionBoxes=a,this._done=!1;}isDone(){return this._done}continuePlacement(t,e,i){const s=o.now(),a=()=>!this._forceFullPlacement&&o.now()-s>2;for(;this._currentPlacementIndex>=0;){const s=e[t[this._currentPlacementIndex]],o=this.placement.collisionIndex.transform.zoom;if("symbol"===s.type&&(!s.minzoom||s.minzoom<=o)&&(!s.maxzoom||s.maxzoom>o)){if(this._inProgressLayer||(this._inProgressLayer=new te(s)),this._inProgressLayer.continuePlacement(i[s.source],this.placement,this._showCollisionBoxes,s,a))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(t){return this.placement.commit(t),this.placement}}const ie=512/e.W/2;class se{constructor(t,i,s){this.tileID=t,this.bucketInstanceId=s,this._symbolsByKey={};const a=new Map;for(let t=0;t<i.length;t++){const e=i.get(t),s=e.key,o=a.get(s);o?o.push(e):a.set(s,[e]);}for(const[t,i]of a){const s={positions:i.map((t=>({x:Math.floor(t.anchorX*ie),y:Math.floor(t.anchorY*ie)}))),crossTileIDs:i.map((t=>t.crossTileID))};if(s.positions.length>128){const t=new e.au(s.positions.length,16,Uint16Array);for(const{x:e,y:i}of s.positions)t.add(e,i);t.finish(),delete s.positions,s.index=t;}this._symbolsByKey[t]=s;}}getScaledCoordinates(t,i){const{x:s,y:a,z:o}=this.tileID.canonical,{x:r,y:n,z:l}=i.canonical,h=ie/Math.pow(2,l-o),c=(n*e.W+t.anchorY)*h,u=a*e.W*ie;return {x:Math.floor((r*e.W+t.anchorX)*h-s*e.W*ie),y:Math.floor(c-u)}}findMatches(t,e,i){const s=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let a=0;a<t.length;a++){const o=t.get(a);if(o.crossTileID)continue;const r=this._symbolsByKey[o.key];if(!r)continue;const n=this.getScaledCoordinates(o,e);if(r.index){const t=r.index.range(n.x-s,n.y-s,n.x+s,n.y+s).sort();for(const e of t){const t=r.crossTileIDs[e];if(!i[t]){i[t]=!0,o.crossTileID=t;break}}}else if(r.positions)for(let t=0;t<r.positions.length;t++){const e=r.positions[t],a=r.crossTileIDs[t];if(Math.abs(e.x-n.x)<=s&&Math.abs(e.y-n.y)<=s&&!i[a]){i[a]=!0,o.crossTileID=a;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class ae{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class oe{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],s={};for(const t in i){const a=i[t];a.tileID=a.tileID.unwrapTo(a.tileID.wrap+e),s[a.tileID.key]=a;}this.indexes[t]=s;}this.lng=t;}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key]);}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const s=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const a=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in a){const o=a[i];o.tileID.isChildOf(t)&&o.findMatches(e.symbolInstances,t,s);}else {const o=a[t.scaledTo(Number(i)).key];o&&o.findMatches(e.symbolInstances,t,s);}}for(let t=0;t<e.symbolInstances.length;t++){const a=e.symbolInstances.get(t);a.crossTileID||(a.crossTileID=i.generate(),s[a.crossTileID]=!0);}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new se(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e];}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const s=this.indexes[i];for(const a in s)t[s[a].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,s[a]),delete s[a],e=!0);}return e}}class re{constructor(){this.layerIndexes={},this.crossTileIDs=new ae,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(t,e,i){let s=this.layerIndexes[t.id];void 0===s&&(s=this.layerIndexes[t.id]=new oe);let a=!1;const o={};s.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),s.addBucket(i.tileID,e,this.crossTileIDs)&&(a=!0),o[e.bucketInstanceId]=!0);}return s.removeStaleBuckets(o)&&(a=!0),a}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0;}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t];}}const ne=(t,i)=>e.t(t,i&&i.filter((t=>"source.canvas"!==t.identifier))),le=e.av();class he extends e.E{constructor(t,i={}){super(),this._rtlTextPluginStateChange=()=>{for(const t in this.sourceCaches){const e=this.sourceCaches[t].getSource().type;"vector"!==e&&"geojson"!==e||this.sourceCaches[t].reload();}},this.map=t,this.dispatcher=new N(O(),t._getMapId()),this.dispatcher.registerMessageHandler("getGlyphs",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("getImages",((t,e)=>this.getImages(t,e))),this.imageManager=new I,this.imageManager.setEventedParent(this),this.glyphManager=new P(t._requestManager,i.localIdeographFontFamily),this.lineAtlas=new A(256,512),this.crossTileSymbolIndex=new re,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new e.aw,this._loaded=!1,this._availableImages=[],this._resetUpdates(),this.dispatcher.broadcast("setReferrer",e.ax()),ot().on("pluginStateChange",this._rtlTextPluginStateChange),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.sourceCaches[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e);}}));}loadURL(t,i={},s){this.fire(new e.k("dataloading",{dataType:"style"})),i.validate="boolean"!=typeof i.validate||i.validate;const a=this.map._requestManager.transformRequest(t,p.Style);this._loadStyleRequest=new AbortController,e.h(a,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,i,s);})).catch((t=>{this._loadStyleRequest=null,t&&this.fire(new e.j(t));}));}loadJSON(t,i={},s){this.fire(new e.k("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,o.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,i.validate=!1!==i.validate,this._load(t,i,s);})).catch((()=>{}));}loadEmpty(){this.fire(new e.k("dataloading",{dataType:"style"})),this._load(le,{validate:!1});}_load(t,i,s){var a;const o=i.transformStyle?i.transformStyle(s,t):t;if(!i.validate||!ne(this,e.x(o))){this._loaded=!0,this.stylesheet=o;for(const t in o.sources)this.addSource(t,o.sources[t],{validate:!1});o.sprite?this._loadSprite(o.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(o.glyphs),this._createLayers(),this.light=new M(this.stylesheet.light),this.map.setTerrain(null!==(a=this.stylesheet.terrain)&&void 0!==a?a:null),this.fire(new e.k("data",{dataType:"style"})),this.fire(new e.k("style.load"));}}_createLayers(){const t=e.ay(this.stylesheet.layers);this.dispatcher.broadcast("setLayers",t),this._order=t.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const i of t){const t=e.az(i);t.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=t;}}_loadSprite(t,i=!1,s=void 0){let a;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,i,s,a){return e._(this,void 0,void 0,(function*(){const r=b(t),n=s>1?"@2x":"",l={},h={};for(const{id:t,url:s}of r){const o=i.transformRequest(i.normalizeSpriteURL(s,n,".json"),p.SpriteJSON);l[t]=e.h(o,a);const r=i.transformRequest(i.normalizeSpriteURL(s,n,".png"),p.SpriteImage);h[t]=_.getImage(r,a);}return yield Promise.all([...Object.values(l),...Object.values(h)]),function(t,i){return e._(this,void 0,void 0,(function*(){const e={};for(const s in t){e[s]={};const a=o.getImageCanvasContext((yield i[s]).data),r=(yield t[s]).data;for(const t in r){const{width:i,height:o,x:n,y:l,sdf:h,pixelRatio:c,stretchX:u,stretchY:d,content:_}=r[t];e[s][t]={data:null,pixelRatio:c,sdf:h,stretchX:u,stretchY:d,content:_,spriteData:{width:i,height:o,x:n,y:l,context:a}};}}return e}))}(l,h)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const e in t){this._spritesImagesIds[e]=[];const s=this._spritesImagesIds[e]?this._spritesImagesIds[e].filter((e=>!(e in t))):[];for(const t of s)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const s in t[e]){const a="default"===e?s:`${e}:${s}`;this._spritesImagesIds[e].push(a),a in this.imageManager.images?this.imageManager.updateImage(a,t[e][s],!1):this.imageManager.addImage(a,t[e][s]),i&&(this._changedImages[a]=!0);}}})).catch((t=>{this._spriteRequest=null,a=t,this.fire(new e.j(a));})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),i&&(this._changed=!0),this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.k("data",{dataType:"style"})),s&&s(a);}));}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.k("data",{dataType:"style"}));}_validateLayer(t){const i=this.sourceCaches[t.source];if(!i)return;const s=t.sourceLayer;if(!s)return;const a=i.getSource();("geojson"===a.type||a.vectorLayerIds&&-1===a.vectorLayerIds.indexOf(s))&&this.fire(new e.j(new Error(`Source layer "${s}" does not exist on source "${a.id}" as specified by style layer "${t.id}".`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const t in this.sourceCaches)if(!this.sourceCaches[t].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeByIds(t){const e=this._serializedAllLayers();if(!t||0===t.length)return Object.values(e);const i=[];for(const s of t)e[s]&&i.push(e[s]);return i}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize());}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;for(const t in this.sourceCaches)if(this.sourceCaches[t].hasTransition())return !0;for(const t in this._layers)if(this._layers[t].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const i=this._changed;if(this._changed){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else {if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t);}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this._resetUpdates();}const s={};for(const t in this.sourceCaches){const e=this.sourceCaches[t];s[t]=e.used,e.used=!1;}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0);}for(const t in s){const i=this.sourceCaches[t];s[t]!==i.used&&i.fire(new e.k("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}));}this.light.recalculate(t),this.z=t.zoom,i&&this.fire(new e.k("data",{dataType:"style"}));}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={};}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1;}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("updateLayers",{layers:this._serializeByIds(t),removedIds:e});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1;}setState(t,i={}){var s;this._checkLoaded();const a=this.serialize();if(t=i.transformStyle?i.transformStyle(a,t):t,(null===(s=i.validate)||void 0===s||s)&&ne(this,e.x(t)))return !1;(t=e.aA(t)).layers=e.ay(t.layers);const o=e.aB(a,t),r=this._getOperationsToPerform(o);if(r.unimplemented.length>0)throw new Error(`Unimplemented: ${r.unimplemented.join(", ")}.`);if(0===r.operations.length)return !1;for(const t of r.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const s of t)switch(s.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,s.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,s.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,s.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,s.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,s.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,s.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,s.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,s.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,s.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,s.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,s.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,s.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,s.args)));break;case"setTransition":e.push((()=>{}));break;default:i.push(s.command);}return {operations:e,unimplemented:i}}addImage(t,i){if(this.getImage(t))return this.fire(new e.j(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,i),this._afterImageUpdated(t);}updateImage(t,e){this.imageManager.updateImage(t,e);}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new e.j(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t);}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.k("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,i,s={}){if(this._checkLoaded(),void 0!==this.sourceCaches[t])throw new Error(`Source "${t}" already exists.`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(e.x.source,`sources.${t}`,i,null,s))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const a=this.sourceCaches[t]=new ht(t,i,this.dispatcher);a.style=this,a.setEventedParent(this,(()=>({isSourceLoaded:a.loaded(),source:a.serialize(),sourceId:t}))),a.onAdd(this.map),this._changed=!0;}removeSource(t){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.j(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));const i=this.sourceCaches[t];delete this.sourceCaches[t],delete this._updatedSources[t],i.fire(new e.k("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),i.setEventedParent(null),i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error(`There is no source with this ID=${t}`);const i=this.sourceCaches[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0;}getSource(t){return this.sourceCaches[t]&&this.sourceCaches[t].getSource()}addLayer(t,i,s={}){this._checkLoaded();const a=t.id;if(this.getLayer(a))return void this.fire(new e.j(new Error(`Layer "${a}" already exists on this map.`)));let o;if("custom"===t.type){if(ne(this,e.aC(t)))return;o=e.az(t);}else {if("source"in t&&"object"==typeof t.source&&(this.addSource(a,t.source),t=e.aA(t),t=e.e(t,{source:a})),this._validate(e.x.layer,`layers.${a}`,t,{arrayIndex:-1},s))return;o=e.az(t),this._validateLayer(o),o.setEventedParent(this,{layer:{id:a}});}const r=i?this._order.indexOf(i):this._order.length;if(i&&-1===r)this.fire(new e.j(new Error(`Cannot add layer "${a}" before non-existing layer "${i}".`)));else {if(this._order.splice(r,0,a),this._layerOrderChanged=!0,this._layers[a]=o,this._removedLayers[a]&&o.source&&"custom"!==o.type){const t=this._removedLayers[a];delete this._removedLayers[a],t.type!==o.type?this._updatedSources[o.source]="clear":(this._updatedSources[o.source]="reload",this.sourceCaches[o.source].pause());}this._updateLayer(o),o.onAdd&&o.onAdd(this.map);}}moveLayer(t,i){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new e.j(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===i)return;const s=this._order.indexOf(t);this._order.splice(s,1);const a=i?this._order.indexOf(i):this._order.length;i&&-1===a?this.fire(new e.j(new Error(`Cannot move layer "${t}" before non-existing layer "${i}".`))):(this._order.splice(a,0,t),this._layerOrderChanged=!0);}removeLayer(t){this._checkLoaded();const i=this._layers[t];if(!i)return void this.fire(new e.j(new Error(`Cannot remove non-existing layer "${t}".`)));i.setEventedParent(null);const s=this._order.indexOf(t);this._order.splice(s,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=i,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],i.onRemove&&i.onRemove(this.map);}getLayer(t){return this._layers[t]}getLayersOrder(){return [...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,i,s){this._checkLoaded();const a=this.getLayer(t);a?a.minzoom===i&&a.maxzoom===s||(null!=i&&(a.minzoom=i),null!=s&&(a.maxzoom=s),this._updateLayer(a)):this.fire(new e.j(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)));}setFilter(t,i,s={}){this._checkLoaded();const a=this.getLayer(t);if(a){if(!e.aD(a.filter,i))return null==i?(a.filter=void 0,void this._updateLayer(a)):void(this._validate(e.x.filter,`layers.${a.id}.filter`,i,null,s)||(a.filter=e.aA(i),this._updateLayer(a)))}else this.fire(new e.j(new Error(`Cannot filter non-existing layer "${t}".`)));}getFilter(t){return e.aA(this.getLayer(t).filter)}setLayoutProperty(t,i,s,a={}){this._checkLoaded();const o=this.getLayer(t);o?e.aD(o.getLayoutProperty(i),s)||(o.setLayoutProperty(i,s,a),this._updateLayer(o)):this.fire(new e.j(new Error(`Cannot style non-existing layer "${t}".`)));}getLayoutProperty(t,i){const s=this.getLayer(t);if(s)return s.getLayoutProperty(i);this.fire(new e.j(new Error(`Cannot get style of non-existing layer "${t}".`)));}setPaintProperty(t,i,s,a={}){this._checkLoaded();const o=this.getLayer(t);o?e.aD(o.getPaintProperty(i),s)||(o.setPaintProperty(i,s,a)&&this._updateLayer(o),this._changed=!0,this._updatedPaintProps[t]=!0):this.fire(new e.j(new Error(`Cannot style non-existing layer "${t}".`)));}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,i){this._checkLoaded();const s=t.source,a=t.sourceLayer,o=this.sourceCaches[s];if(void 0===o)return void this.fire(new e.j(new Error(`The source '${s}' does not exist in the map's style.`)));const r=o.getSource().type;"geojson"===r&&a?this.fire(new e.j(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==r||a?(void 0===t.id&&this.fire(new e.j(new Error("The feature id parameter must be provided."))),o.setFeatureState(a,t.id,i)):this.fire(new e.j(new Error("The sourceLayer parameter must be provided for vector source types.")));}removeFeatureState(t,i){this._checkLoaded();const s=t.source,a=this.sourceCaches[s];if(void 0===a)return void this.fire(new e.j(new Error(`The source '${s}' does not exist in the map's style.`)));const o=a.getSource().type,r="vector"===o?t.sourceLayer:void 0;"vector"!==o||r?i&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new e.j(new Error("A feature id is required to remove its specific state property."))):a.removeFeatureState(r,t.id,i):this.fire(new e.j(new Error("The sourceLayer parameter must be provided for vector source types.")));}getFeatureState(t){this._checkLoaded();const i=t.source,s=t.sourceLayer,a=this.sourceCaches[i];if(void 0!==a)return "vector"!==a.getSource().type||s?(void 0===t.id&&this.fire(new e.j(new Error("The feature id parameter must be provided."))),a.getFeatureState(s,t.id)):void this.fire(new e.j(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new e.j(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return e.e({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=e.aE(this.sourceCaches,(t=>t.serialize())),i=this._serializeByIds(this._order),s=this.map.getTerrain()||void 0,a=this.stylesheet;return e.aF({version:a.version,name:a.name,metadata:a.metadata,light:a.light,center:a.center,zoom:a.zoom,bearing:a.bearing,pitch:a.pitch,sprite:a.sprite,glyphs:a.glyphs,transition:a.transition,sources:t,layers:i,terrain:s},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.sourceCaches[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.sourceCaches[t.source].pause()),this._serializedLayers=null,this._changed=!0;}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},s=[];for(let a=this._order.length-1;a>=0;a--){const o=this._order[a];if(e(o)){i[o]=a;for(const e of t){const t=e[o];if(t)for(const e of t)s.push(e);}}}s.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const a=[];for(let o=this._order.length-1;o>=0;o--){const r=this._order[o];if(e(r))for(let t=s.length-1;t>=0;t--){const e=s[t].feature;if(i[e.layer.id]<o)break;a.push(e),s.pop();}else for(const e of t){const t=e[r];if(t)for(const e of t)a.push(e.feature);}}return a}queryRenderedFeatures(t,i,s){i&&i.filter&&this._validate(e.x.filter,"queryRenderedFeatures.filter",i.filter,null,i);const a={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.j(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._layers[t];if(!i)return this.fire(new e.j(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];a[i.source]=!0;}}const o=[];i.availableImages=this._availableImages;const r=this._serializedAllLayers();for(const e in this.sourceCaches)i.layers&&!a[e]||o.push(G(this.sourceCaches[e],this._layers,r,t,i,s));return this.placement&&o.push(function(t,e,i,s,a,o,r){const n={},l=o.queryRenderedSymbols(s),h=[];for(const t of Object.keys(l).map(Number))h.push(r[t]);h.sort(j);for(const i of h){const s=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,a.filter,a.layers,a.availableImages,t);for(const t in s){const e=n[t]=n[t]||[],a=s[t];a.sort(((t,e)=>{const s=i.featureSortOrder;if(s){const i=s.indexOf(t.featureIndex);return s.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of a)e.push(t);}}for(const e in n)n[e].forEach((s=>{const a=s.feature,o=i[t[e].source].getFeatureState(a.layer["source-layer"],a.id);a.source=a.layer.source,a.layer["source-layer"]&&(a.sourceLayer=a.layer["source-layer"]),a.state=o;}));return n}(this._layers,r,this.sourceCaches,t,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(o)}querySourceFeatures(t,i){i&&i.filter&&this._validate(e.x.filter,"querySourceFeatures.filter",i.filter,null,i);const s=this.sourceCaches[t];return s?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),s=[],a={};for(let t=0;t<i.length;t++){const o=i[t],r=o.tileID.canonical.key;a[r]||(a[r]=!0,o.querySourceFeatures(s,e));}return s}(s,i):[]}getLight(){return this.light.getLight()}setLight(t,i={}){this._checkLoaded();const s=this.light.getLight();let a=!1;for(const i in t)if(!e.aD(t[i],s[i])){a=!0;break}if(!a)return;const r={now:o.now(),transition:e.e({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,i),this.light.updateTransitions(r);}_validate(t,i,s,a,o={}){return (!o||!1!==o.validate)&&ne(this,t.call(e.x,e.e({key:i,style:this.serialize(),value:s,styleSpec:e.v},a)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),ot().off("pluginStateChange",this._rtlTextPluginStateChange);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.sourceCaches){const e=this.sourceCaches[t];e.setEventedParent(null),e.onRemove(this.map);}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("removeMap",void 0),this.dispatcher.remove(t);}_clearSource(t){this.sourceCaches[t].clearTiles();}_reloadSource(t){this.sourceCaches[t].resume(),this.sourceCaches[t].reload();}_updateSources(t){for(const e in this.sourceCaches)this.sourceCaches[e].update(t,this.map.terrain);}_generateCollisionBoxes(){for(const t in this.sourceCaches)this._reloadSource(t);}_updatePlacement(t,e,i,s,a=!1){let r=!1,n=!1;const l={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!l[i.source]){const t=this.sourceCaches[i.source];l[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)));}const s=this.crossTileSymbolIndex.addLayer(i,l[i.source],t.center.lng);r=r||s;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((a=a||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(o.now(),t.zoom))&&(this.pauseablePlacement=new ee(t,this.map.terrain,this._order,a,e,i,s,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(o.now()),n=!0),r&&this.pauseablePlacement.placement.setStale()),n||r)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,l[e.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(o.now())}_releaseSymbolFadeTiles(){for(const t in this.sourceCaches)this.sourceCaches[t].releaseSymbolFadeTiles();}getImages(t,i){return e._(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(i.icons);this._updateTilesForChangedImages();const e=this.sourceCaches[i.source];return e&&e.setDependencies(i.tileID.key,i.type,i.icons),t}))}getGlyphs(t,i){return e._(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(i.stacks),e=this.sourceCaches[i.source];return e&&e.setDependencies(i.tileID.key,i.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,i={}){this._checkLoaded(),t&&this._validate(e.x.glyphs,"glyphs",t,null,i)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t));}addSprite(t,i,s={},a){this._checkLoaded();const o=[{id:t,url:i}],r=[...b(this.stylesheet.sprite),...o];this._validate(e.x.sprite,"sprite",r,null,s)||(this.stylesheet.sprite=r,this._loadSprite(o,!0,a));}removeSprite(t){this._checkLoaded();const i=b(this.stylesheet.sprite);if(i.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;i.splice(i.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=i.length>0?i:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.k("data",{dataType:"style"}));}else this.fire(new e.j(new Error(`Sprite "${t}" doesn't exists on this map.`)));}getSprite(){return b(this.stylesheet.sprite)}setSprite(t,i={},s){this._checkLoaded(),t&&this._validate(e.x.sprite,"sprite",t,null,i)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,s):(this._unloadSprite(),s&&s(null)));}}var ce=e.X([{name:"a_pos",type:"Int16",components:2}]),ue="attribute vec3 a_pos3d;uniform mat4 u_matrix;uniform float u_ele_delta;varying vec2 v_texture_pos;varying float v_depth;void main() {float extent=8192.0;float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/extent;gl_Position=u_matrix*vec4(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta,1.0);v_depth=gl_Position.z/gl_Position.w;}";const de={prelude:_e("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\n","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture2D(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture2D(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}"),background:_e("uniform vec4 u_color;uniform float u_opacity;void main() {gl_FragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),backgroundPattern:_e("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:_e("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));gl_FragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);float ele=get_elevation(circle_center);v_visibility=calculate_visibility(u_matrix*vec4(circle_center,ele,1.0));if (u_pitch_with_map) {vec2 corner_position=circle_center;if (u_scale_with_map) {corner_position+=extrude*(radius+stroke_width)*u_extrude_scale;} else {vec4 projected_center=u_matrix*vec4(circle_center,0,1);corner_position+=extrude*(radius+stroke_width)*u_extrude_scale*(projected_center.w/u_camera_to_center_distance);}gl_Position=u_matrix*vec4(corner_position,ele,1);} else {gl_Position=u_matrix*vec4(circle_center,ele,1);if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:_e("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:_e("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec4 pos=vec4(floor(a_pos*0.5)+extrude,0,1);gl_Position=u_matrix*pos;}"),heatmapTexture:_e("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:_e("varying float v_placed;varying float v_notUsed;void main() {float alpha=0.5;gl_FragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {gl_FragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {gl_FragColor*=.1;}}","attribute vec2 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_anchor_pos,0,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);gl_Position=u_matrix*vec4(a_pos,get_elevation(a_pos),1.0);gl_Position.xy+=(a_extrude+a_shift)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:_e("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:_e("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;varying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*u_overlay_scale,get_elevation(a_pos),1);}"),fill:_e("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_FragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);}"),fillOutline:_e("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=outline_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillOutlinePattern:_e("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),fillPattern:_e("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:_e("varying vec4 v_color;void main() {gl_FragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec2 a_pos;attribute vec4 a_normal_ed;\n#ifdef TERRAIN3D\nattribute vec2 a_centroid;\n#endif\nvarying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);gl_Position=u_matrix*vec4(a_pos,t > 0.0 ? height : base,1);float colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal/16384.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:_e("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);gl_FragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec2 a_pos;attribute vec4 a_normal_ed;\n#ifdef TERRAIN3D\nattribute vec2 a_centroid;\n#endif\nvarying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float z=t > 0.0 ? height : base;gl_Position=u_matrix*vec4(a_pos,z,1);vec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:_e("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(deriv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:_e("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;\n#define PI 3.141592653589793\nvoid main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;}"),line:_e("uniform lowp float u_device_pixel_ratio;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp float v_linesofar;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:_e("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture2D(u_image,v_uv);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_uv_x;attribute float a_split_index;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:_e("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);gl_FragColor=color*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:_e("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture2D(u_image,v_tex_a).a;float sdfdist_b=texture2D(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:_e("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);gl_FragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos0=(((a_texture_pos/8192.0)-0.5)/u_buffer_scale )+0.5;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:_e("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","const float PI=3.141592653589793;attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec4 projectedPoint=u_matrix*vec4(a_pos,ele,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),ele,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,ele,1.0);float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;gl_Position=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0),z,1.0);v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:_e("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","const float PI=3.141592653589793;attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec4 projectedPoint=u_matrix*vec4(a_pos,ele,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),ele,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,ele,1.0);float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;gl_Position=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset),z,1.0);float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:_e("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","const float PI=3.141592653589793;attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec4 projectedPoint=u_matrix*vec4(a_pos,ele,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),ele,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,ele,1.0);float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;gl_Position=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale),z,1.0);float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:_e("uniform sampler2D u_texture;varying vec2 v_texture_pos;void main() {gl_FragColor=texture2D(u_texture,v_texture_pos);}",ue),terrainDepth:_e("varying float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {gl_FragColor=pack(v_depth);}",ue),terrainCoords:_e("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;varying vec2 v_texture_pos;void main() {vec4 rgba=texture2D(u_texture,v_texture_pos);gl_FragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}",ue)};function _e(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,s=e.match(/attribute ([\w]+) ([\w]+)/g),a=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),r=o?o.concat(a):a,n={};return {fragmentSource:t=t.replace(i,((t,e,i,s,a)=>(n[a]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${a}\nvarying ${i} ${s} ${a};\n#else\nuniform ${i} ${s} u_${a};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${a}\n    ${i} ${s} ${a} = u_${a};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,s,a)=>{const o="float"===s?"vec2":"vec4",r=a.match(/color/)?"color":o;return n[a]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${a}\nuniform lowp float u_${a}_t;\nattribute ${i} ${o} a_${a};\nvarying ${i} ${s} ${a};\n#else\nuniform ${i} ${s} u_${a};\n#endif\n`:"vec4"===r?`\n#ifndef HAS_UNIFORM_u_${a}\n    ${a} = a_${a};\n#else\n    ${i} ${s} ${a} = u_${a};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${a}\n    ${a} = unpack_mix_${r}(a_${a}, u_${a}_t);\n#else\n    ${i} ${s} ${a} = u_${a};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${a}\nuniform lowp float u_${a}_t;\nattribute ${i} ${o} a_${a};\n#else\nuniform ${i} ${s} u_${a};\n#endif\n`:"vec4"===r?`\n#ifndef HAS_UNIFORM_u_${a}\n    ${i} ${s} ${a} = a_${a};\n#else\n    ${i} ${s} ${a} = u_${a};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${a}\n    ${i} ${s} ${a} = unpack_mix_${r}(a_${a}, u_${a}_t);\n#else\n    ${i} ${s} ${a} = u_${a};\n#endif\n`})),staticAttributes:s,staticUniforms:r}}class pe{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(t,e,i,s,a,o,r,n,l){this.context=t;let h=this.boundPaintVertexBuffers.length!==s.length;for(let t=0;!h&&t<s.length;t++)this.boundPaintVertexBuffers[t]!==s[t]&&(h=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||h||this.boundIndexBuffer!==a||this.boundVertexOffset!==o||this.boundDynamicVertexBuffer!==r||this.boundDynamicVertexBuffer2!==n||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,s,a,o,r,n,l):(t.bindVertexArray.set(this.vao),r&&r.bind(),a&&a.dynamicDraw&&a.bind(),n&&n.bind(),l&&l.bind());}freshBind(t,e,i,s,a,o,r,n){const l=t.numAttributes,h=this.context,c=h.gl;this.vao&&this.destroy(),this.vao=h.createVertexArray(),h.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=s,this.boundVertexOffset=a,this.boundDynamicVertexBuffer=o,this.boundDynamicVertexBuffer2=r,this.boundDynamicVertexBuffer3=n,e.enableAttributes(c,t);for(const e of i)e.enableAttributes(c,t);o&&o.enableAttributes(c,t),r&&r.enableAttributes(c,t),n&&n.enableAttributes(c,t),e.bind(),e.setVertexAttribPointers(c,t,a);for(const e of i)e.bind(),e.setVertexAttribPointers(c,t,a);o&&(o.bind(),o.setVertexAttribPointers(c,t,a)),s&&s.bind(),r&&(r.bind(),r.setVertexAttribPointers(c,t,a)),n&&(n.bind(),n.setVertexAttribPointers(c,t,a)),h.currentNumAttributes=l;}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null);}}function me(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const s=t[i].split(" ");e.push(s.pop());}return e}class fe{constructor(t,i,s,a,o,r){const n=t.gl;this.program=n.createProgram();const l=me(i.staticAttributes),h=s?s.getBinderAttributes():[],c=l.concat(h),u=de.prelude.staticUniforms?me(de.prelude.staticUniforms):[],d=i.staticUniforms?me(i.staticUniforms):[],_=s?s.getBinderUniforms():[],p=u.concat(d).concat(_),m=[];for(const t of p)m.indexOf(t)<0&&m.push(t);const f=s?s.defines():[];o&&f.push("#define OVERDRAW_INSPECTOR;"),r&&f.push("#define TERRAIN3D;");const g=f.concat(de.prelude.fragmentSource,i.fragmentSource).join("\n"),v=f.concat(de.prelude.vertexSource,i.vertexSource).join("\n"),x=n.createShader(n.FRAGMENT_SHADER);if(n.isContextLost())return void(this.failedToCreate=!0);if(n.shaderSource(x,g),n.compileShader(x),!n.getShaderParameter(x,n.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${n.getShaderInfoLog(x)}`);n.attachShader(this.program,x);const y=n.createShader(n.VERTEX_SHADER);if(n.isContextLost())return void(this.failedToCreate=!0);if(n.shaderSource(y,v),n.compileShader(y),!n.getShaderParameter(y,n.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${n.getShaderInfoLog(y)}`);n.attachShader(this.program,y),this.attributes={};const b={};this.numAttributes=c.length;for(let t=0;t<this.numAttributes;t++)c[t]&&(n.bindAttribLocation(this.program,t,c[t]),this.attributes[c[t]]=t);if(n.linkProgram(this.program),!n.getProgramParameter(this.program,n.LINK_STATUS))throw new Error(`Program failed to link: ${n.getProgramInfoLog(this.program)}`);n.deleteShader(y),n.deleteShader(x);for(let t=0;t<m.length;t++){const e=m[t];if(e&&!b[e]){const t=n.getUniformLocation(this.program,e);t&&(b[e]=t);}}this.fixedUniforms=a(t,b),this.terrainUniforms=((t,i)=>({u_depth:new e.aG(t,i.u_depth),u_terrain:new e.aG(t,i.u_terrain),u_terrain_dim:new e.aH(t,i.u_terrain_dim),u_terrain_matrix:new e.aI(t,i.u_terrain_matrix),u_terrain_unpack:new e.aJ(t,i.u_terrain_unpack),u_terrain_exaggeration:new e.aH(t,i.u_terrain_exaggeration)}))(t,b),this.binderUniforms=s?s.getUniforms(t,b):[];}draw(t,e,i,s,a,o,r,n,l,h,c,u,d,_,p,m,f,g){const v=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(s),t.setColorMode(a),t.setCullFace(o),n){t.activeTexture.set(v.TEXTURE2),v.bindTexture(v.TEXTURE_2D,n.depthTexture),t.activeTexture.set(v.TEXTURE3),v.bindTexture(v.TEXTURE_2D,n.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(n[t]);}for(const t in this.fixedUniforms)this.fixedUniforms[t].set(r[t]);p&&p.setUniforms(t,this.binderUniforms,d,{zoom:_});let x=0;switch(e){case v.LINES:x=2;break;case v.TRIANGLES:x=3;break;case v.LINE_STRIP:x=1;}for(const i of u.get()){const s=i.vaos||(i.vaos={});(s[l]||(s[l]=new pe)).bind(t,this,h,p?p.getPaintVertexBuffers():[],c,i.vertexOffset,m,f,g),v.drawElements(e,i.primitiveLength*x,v.UNSIGNED_SHORT,i.primitiveOffset*x*2);}}}function ge(t,e,i){const s=1/Lt(i,1,e.transform.tileZoom),a=Math.pow(2,i.tileID.overscaledZ),o=i.tileSize*Math.pow(2,e.transform.tileZoom)/a,r=o*(i.tileID.canonical.x+i.tileID.wrap*a),n=o*i.tileID.canonical.y;return {u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[s,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[r>>16,n>>16],u_pixel_coord_lower:[65535&r,65535&n]}}const ve=(t,i,s,a)=>{const o=i.style.light,r=o.properties.get("position"),n=[r.x,r.y,r.z],l=function(){var t=new e.A(9);return e.A!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}();"viewport"===o.properties.get("anchor")&&function(t,e){var i=Math.sin(e),s=Math.cos(e);t[0]=s,t[1]=i,t[2]=0,t[3]=-i,t[4]=s,t[5]=0,t[6]=0,t[7]=0,t[8]=1;}(l,-i.transform.angle),function(t,e,i){var s=e[0],a=e[1],o=e[2];t[0]=s*i[0]+a*i[3]+o*i[6],t[1]=s*i[1]+a*i[4]+o*i[7],t[2]=s*i[2]+a*i[5]+o*i[8];}(n,n,l);const h=o.properties.get("color");return {u_matrix:t,u_lightpos:n,u_lightintensity:o.properties.get("intensity"),u_lightcolor:[h.r,h.g,h.b],u_vertical_gradient:+s,u_opacity:a}},xe=(t,i,s,a,o,r,n)=>e.e(ve(t,i,s,a),ge(r,i,n),{u_height_factor:-Math.pow(2,o.overscaledZ)/n.tileSize/8}),ye=t=>({u_matrix:t}),be=(t,i,s,a)=>e.e(ye(t),ge(s,i,a)),we=(t,e)=>({u_matrix:t,u_world:e}),Te=(t,i,s,a,o)=>e.e(be(t,i,s,a),{u_world:o}),Ie=(t,e,i,s)=>{const a=t.transform;let o,r;if("map"===s.paint.get("circle-pitch-alignment")){const t=Lt(i,1,a.zoom);o=!0,r=[t,t];}else o=!1,r=a.pixelsToGLUnits;return {u_camera_to_center_distance:a.cameraToCenterDistance,u_scale_with_map:+("map"===s.paint.get("circle-pitch-scale")),u_matrix:t.translatePosMatrix(e.posMatrix,i,s.paint.get("circle-translate"),s.paint.get("circle-translate-anchor")),u_pitch_with_map:+o,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:r}},Ee=(t,e,i)=>{const s=Lt(i,1,e.zoom),a=Math.pow(2,e.zoom-i.tileID.overscaledZ),o=i.tileID.overscaleFactor();return {u_matrix:t,u_camera_to_center_distance:e.cameraToCenterDistance,u_pixels_to_tile_units:s,u_extrude_scale:[e.pixelsToGLUnits[0]/(s*a),e.pixelsToGLUnits[1]/(s*a)],u_overscale_factor:o}},Se=(t,e,i=1)=>({u_matrix:t,u_color:e,u_overlay:0,u_overlay_scale:i}),Ce=t=>({u_matrix:t}),Pe=(t,e,i,s)=>({u_matrix:t,u_extrude_scale:Lt(e,1,i),u_intensity:s});function De(t,i){const s=Math.pow(2,i.canonical.z),a=i.canonical.y;return [new e.Y(0,a/s).toLngLat().lat,new e.Y(0,(a+1)/s).toLngLat().lat]}const ze=(t,e,i,s)=>{const a=t.transform;return {u_matrix:ke(t,e,i,s),u_ratio:1/Lt(e,1,a.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]]}},Me=(t,i,s,a,o)=>e.e(ze(t,i,s,o),{u_image:0,u_image_height:a}),Ae=(t,e,i,s,a)=>{const o=t.transform,r=Le(e,o);return {u_matrix:ke(t,e,i,a),u_texsize:e.imageAtlasTexture.size,u_ratio:1/Lt(e,1,o.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[r,s.fromScale,s.toScale],u_fade:s.t,u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]]}},Re=(t,i,s,a,o,r)=>{const n=t.lineAtlas,l=Le(i,t.transform),h="round"===s.layout.get("line-cap"),c=n.getDash(a.from,h),u=n.getDash(a.to,h),d=c.width*o.fromScale,_=u.width*o.toScale;return e.e(ze(t,i,s,r),{u_patternscale_a:[l/d,-c.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:n.width/(256*Math.min(d,_)*t.pixelRatio)/2,u_image:0,u_tex_y_a:c.y,u_tex_y_b:u.y,u_mix:o.t})};function Le(t,e){return 1/Lt(t,1,e.tileZoom)}function ke(t,e,i,s){return t.translatePosMatrix(s?s.posMatrix:e.tileID.posMatrix,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const Fe=(t,e,i,s,a)=>{return {u_matrix:t,u_tl_parent:e,u_scale_parent:i,u_buffer_scale:1,u_fade_t:s.mix,u_opacity:s.opacity*a.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:a.paint.get("raster-brightness-min"),u_brightness_high:a.paint.get("raster-brightness-max"),u_saturation_factor:(r=a.paint.get("raster-saturation"),r>0?1-1/(1.001-r):-r),u_contrast_factor:(o=a.paint.get("raster-contrast"),o>0?1/(1-o):1+o),u_spin_weights:Be(a.paint.get("raster-hue-rotate"))};var o,r;};function Be(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return [(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const Oe=(t,e,i,s,a,o,r,n,l,h)=>{const c=a.transform;return {u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:c.cameraToCenterDistance,u_pitch:c.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:c.width/c.height,u_fade_change:a.options.fadeDuration?a.symbolFadeChange:1,u_matrix:o,u_label_plane_matrix:r,u_coord_matrix:n,u_is_text:+l,u_pitch_with_map:+s,u_texsize:h,u_texture:0}},Ne=(t,i,s,a,o,r,n,l,h,c,u)=>{const d=o.transform;return e.e(Oe(t,i,s,a,o,r,n,l,h,c),{u_gamma_scale:a?Math.cos(d._pitch)*d.cameraToCenterDistance:1,u_device_pixel_ratio:o.pixelRatio,u_is_halo:+u})},Ue=(t,i,s,a,o,r,n,l,h,c)=>e.e(Ne(t,i,s,a,o,r,n,l,!0,h,!0),{u_texsize_icon:c,u_texture_icon:1}),Ze=(t,e,i)=>({u_matrix:t,u_opacity:e,u_color:i}),Ge=(t,i,s,a,o,r)=>e.e(function(t,e,i,s){const a=i.imageManager.getPattern(t.from.toString()),o=i.imageManager.getPattern(t.to.toString()),{width:r,height:n}=i.imageManager.getPixelSize(),l=Math.pow(2,s.tileID.overscaledZ),h=s.tileSize*Math.pow(2,i.transform.tileZoom)/l,c=h*(s.tileID.canonical.x+s.tileID.wrap*l),u=h*s.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:a.tl,u_pattern_br_a:a.br,u_pattern_tl_b:o.tl,u_pattern_br_b:o.br,u_texsize:[r,n],u_mix:e.t,u_pattern_size_a:a.displaySize,u_pattern_size_b:o.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/Lt(s,1,i.transform.tileZoom),u_pixel_coord_upper:[c>>16,u>>16],u_pixel_coord_lower:[65535&c,65535&u]}}(a,r,s,o),{u_matrix:t,u_opacity:i}),je={fillExtrusion:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_lightpos:new e.aK(t,i.u_lightpos),u_lightintensity:new e.aH(t,i.u_lightintensity),u_lightcolor:new e.aK(t,i.u_lightcolor),u_vertical_gradient:new e.aH(t,i.u_vertical_gradient),u_opacity:new e.aH(t,i.u_opacity)}),fillExtrusionPattern:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_lightpos:new e.aK(t,i.u_lightpos),u_lightintensity:new e.aH(t,i.u_lightintensity),u_lightcolor:new e.aK(t,i.u_lightcolor),u_vertical_gradient:new e.aH(t,i.u_vertical_gradient),u_height_factor:new e.aH(t,i.u_height_factor),u_image:new e.aG(t,i.u_image),u_texsize:new e.aL(t,i.u_texsize),u_pixel_coord_upper:new e.aL(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aL(t,i.u_pixel_coord_lower),u_scale:new e.aK(t,i.u_scale),u_fade:new e.aH(t,i.u_fade),u_opacity:new e.aH(t,i.u_opacity)}),fill:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix)}),fillPattern:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_image:new e.aG(t,i.u_image),u_texsize:new e.aL(t,i.u_texsize),u_pixel_coord_upper:new e.aL(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aL(t,i.u_pixel_coord_lower),u_scale:new e.aK(t,i.u_scale),u_fade:new e.aH(t,i.u_fade)}),fillOutline:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_world:new e.aL(t,i.u_world)}),fillOutlinePattern:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_world:new e.aL(t,i.u_world),u_image:new e.aG(t,i.u_image),u_texsize:new e.aL(t,i.u_texsize),u_pixel_coord_upper:new e.aL(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aL(t,i.u_pixel_coord_lower),u_scale:new e.aK(t,i.u_scale),u_fade:new e.aH(t,i.u_fade)}),circle:(t,i)=>({u_camera_to_center_distance:new e.aH(t,i.u_camera_to_center_distance),u_scale_with_map:new e.aG(t,i.u_scale_with_map),u_pitch_with_map:new e.aG(t,i.u_pitch_with_map),u_extrude_scale:new e.aL(t,i.u_extrude_scale),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_matrix:new e.aI(t,i.u_matrix)}),collisionBox:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_camera_to_center_distance:new e.aH(t,i.u_camera_to_center_distance),u_pixels_to_tile_units:new e.aH(t,i.u_pixels_to_tile_units),u_extrude_scale:new e.aL(t,i.u_extrude_scale),u_overscale_factor:new e.aH(t,i.u_overscale_factor)}),collisionCircle:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_inv_matrix:new e.aI(t,i.u_inv_matrix),u_camera_to_center_distance:new e.aH(t,i.u_camera_to_center_distance),u_viewport_size:new e.aL(t,i.u_viewport_size)}),debug:(t,i)=>({u_color:new e.aM(t,i.u_color),u_matrix:new e.aI(t,i.u_matrix),u_overlay:new e.aG(t,i.u_overlay),u_overlay_scale:new e.aH(t,i.u_overlay_scale)}),clippingMask:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix)}),heatmap:(t,i)=>({u_extrude_scale:new e.aH(t,i.u_extrude_scale),u_intensity:new e.aH(t,i.u_intensity),u_matrix:new e.aI(t,i.u_matrix)}),heatmapTexture:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_world:new e.aL(t,i.u_world),u_image:new e.aG(t,i.u_image),u_color_ramp:new e.aG(t,i.u_color_ramp),u_opacity:new e.aH(t,i.u_opacity)}),hillshade:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_image:new e.aG(t,i.u_image),u_latrange:new e.aL(t,i.u_latrange),u_light:new e.aL(t,i.u_light),u_shadow:new e.aM(t,i.u_shadow),u_highlight:new e.aM(t,i.u_highlight),u_accent:new e.aM(t,i.u_accent)}),hillshadePrepare:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_image:new e.aG(t,i.u_image),u_dimension:new e.aL(t,i.u_dimension),u_zoom:new e.aH(t,i.u_zoom),u_unpack:new e.aJ(t,i.u_unpack)}),line:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_ratio:new e.aH(t,i.u_ratio),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.aL(t,i.u_units_to_pixels)}),lineGradient:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_ratio:new e.aH(t,i.u_ratio),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.aL(t,i.u_units_to_pixels),u_image:new e.aG(t,i.u_image),u_image_height:new e.aH(t,i.u_image_height)}),linePattern:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_texsize:new e.aL(t,i.u_texsize),u_ratio:new e.aH(t,i.u_ratio),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_image:new e.aG(t,i.u_image),u_units_to_pixels:new e.aL(t,i.u_units_to_pixels),u_scale:new e.aK(t,i.u_scale),u_fade:new e.aH(t,i.u_fade)}),lineSDF:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_ratio:new e.aH(t,i.u_ratio),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.aL(t,i.u_units_to_pixels),u_patternscale_a:new e.aL(t,i.u_patternscale_a),u_patternscale_b:new e.aL(t,i.u_patternscale_b),u_sdfgamma:new e.aH(t,i.u_sdfgamma),u_image:new e.aG(t,i.u_image),u_tex_y_a:new e.aH(t,i.u_tex_y_a),u_tex_y_b:new e.aH(t,i.u_tex_y_b),u_mix:new e.aH(t,i.u_mix)}),raster:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_tl_parent:new e.aL(t,i.u_tl_parent),u_scale_parent:new e.aH(t,i.u_scale_parent),u_buffer_scale:new e.aH(t,i.u_buffer_scale),u_fade_t:new e.aH(t,i.u_fade_t),u_opacity:new e.aH(t,i.u_opacity),u_image0:new e.aG(t,i.u_image0),u_image1:new e.aG(t,i.u_image1),u_brightness_low:new e.aH(t,i.u_brightness_low),u_brightness_high:new e.aH(t,i.u_brightness_high),u_saturation_factor:new e.aH(t,i.u_saturation_factor),u_contrast_factor:new e.aH(t,i.u_contrast_factor),u_spin_weights:new e.aK(t,i.u_spin_weights)}),symbolIcon:(t,i)=>({u_is_size_zoom_constant:new e.aG(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.aG(t,i.u_is_size_feature_constant),u_size_t:new e.aH(t,i.u_size_t),u_size:new e.aH(t,i.u_size),u_camera_to_center_distance:new e.aH(t,i.u_camera_to_center_distance),u_pitch:new e.aH(t,i.u_pitch),u_rotate_symbol:new e.aG(t,i.u_rotate_symbol),u_aspect_ratio:new e.aH(t,i.u_aspect_ratio),u_fade_change:new e.aH(t,i.u_fade_change),u_matrix:new e.aI(t,i.u_matrix),u_label_plane_matrix:new e.aI(t,i.u_label_plane_matrix),u_coord_matrix:new e.aI(t,i.u_coord_matrix),u_is_text:new e.aG(t,i.u_is_text),u_pitch_with_map:new e.aG(t,i.u_pitch_with_map),u_texsize:new e.aL(t,i.u_texsize),u_texture:new e.aG(t,i.u_texture)}),symbolSDF:(t,i)=>({u_is_size_zoom_constant:new e.aG(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.aG(t,i.u_is_size_feature_constant),u_size_t:new e.aH(t,i.u_size_t),u_size:new e.aH(t,i.u_size),u_camera_to_center_distance:new e.aH(t,i.u_camera_to_center_distance),u_pitch:new e.aH(t,i.u_pitch),u_rotate_symbol:new e.aG(t,i.u_rotate_symbol),u_aspect_ratio:new e.aH(t,i.u_aspect_ratio),u_fade_change:new e.aH(t,i.u_fade_change),u_matrix:new e.aI(t,i.u_matrix),u_label_plane_matrix:new e.aI(t,i.u_label_plane_matrix),u_coord_matrix:new e.aI(t,i.u_coord_matrix),u_is_text:new e.aG(t,i.u_is_text),u_pitch_with_map:new e.aG(t,i.u_pitch_with_map),u_texsize:new e.aL(t,i.u_texsize),u_texture:new e.aG(t,i.u_texture),u_gamma_scale:new e.aH(t,i.u_gamma_scale),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_is_halo:new e.aG(t,i.u_is_halo)}),symbolTextAndIcon:(t,i)=>({u_is_size_zoom_constant:new e.aG(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.aG(t,i.u_is_size_feature_constant),u_size_t:new e.aH(t,i.u_size_t),u_size:new e.aH(t,i.u_size),u_camera_to_center_distance:new e.aH(t,i.u_camera_to_center_distance),u_pitch:new e.aH(t,i.u_pitch),u_rotate_symbol:new e.aG(t,i.u_rotate_symbol),u_aspect_ratio:new e.aH(t,i.u_aspect_ratio),u_fade_change:new e.aH(t,i.u_fade_change),u_matrix:new e.aI(t,i.u_matrix),u_label_plane_matrix:new e.aI(t,i.u_label_plane_matrix),u_coord_matrix:new e.aI(t,i.u_coord_matrix),u_is_text:new e.aG(t,i.u_is_text),u_pitch_with_map:new e.aG(t,i.u_pitch_with_map),u_texsize:new e.aL(t,i.u_texsize),u_texsize_icon:new e.aL(t,i.u_texsize_icon),u_texture:new e.aG(t,i.u_texture),u_texture_icon:new e.aG(t,i.u_texture_icon),u_gamma_scale:new e.aH(t,i.u_gamma_scale),u_device_pixel_ratio:new e.aH(t,i.u_device_pixel_ratio),u_is_halo:new e.aG(t,i.u_is_halo)}),background:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_opacity:new e.aH(t,i.u_opacity),u_color:new e.aM(t,i.u_color)}),backgroundPattern:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_opacity:new e.aH(t,i.u_opacity),u_image:new e.aG(t,i.u_image),u_pattern_tl_a:new e.aL(t,i.u_pattern_tl_a),u_pattern_br_a:new e.aL(t,i.u_pattern_br_a),u_pattern_tl_b:new e.aL(t,i.u_pattern_tl_b),u_pattern_br_b:new e.aL(t,i.u_pattern_br_b),u_texsize:new e.aL(t,i.u_texsize),u_mix:new e.aH(t,i.u_mix),u_pattern_size_a:new e.aL(t,i.u_pattern_size_a),u_pattern_size_b:new e.aL(t,i.u_pattern_size_b),u_scale_a:new e.aH(t,i.u_scale_a),u_scale_b:new e.aH(t,i.u_scale_b),u_pixel_coord_upper:new e.aL(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.aL(t,i.u_pixel_coord_lower),u_tile_units_to_pixels:new e.aH(t,i.u_tile_units_to_pixels)}),terrain:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_texture:new e.aG(t,i.u_texture),u_ele_delta:new e.aH(t,i.u_ele_delta)}),terrainDepth:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_ele_delta:new e.aH(t,i.u_ele_delta)}),terrainCoords:(t,i)=>({u_matrix:new e.aI(t,i.u_matrix),u_texture:new e.aG(t,i.u_texture),u_terrain_coords_id:new e.aH(t,i.u_terrain_coords_id),u_ele_delta:new e.aH(t,i.u_ele_delta)})};class qe{constructor(t,e,i){this.context=t;const s=t.gl;this.buffer=s.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),s.bufferData(s.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?s.DYNAMIC_DRAW:s.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const Ve={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class We{constructor(t,e,i,s){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=s,this.context=t;const a=t.gl;this.buffer=a.createBuffer(),t.bindVertexBuffer.set(this.buffer),a.bufferData(a.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?a.DYNAMIC_DRAW:a.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer);}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const s=e.attributes[this.attributes[i].name];void 0!==s&&t.enableVertexAttribArray(s);}}setVertexAttribPointers(t,e,i){for(let s=0;s<this.attributes.length;s++){const a=this.attributes[s],o=e.attributes[a.name];void 0!==o&&t.vertexAttribPointer(o,a.components,t[Ve[a.type]],!1,this.itemSize,a.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const He=new WeakMap;function $e(t){var e;if(He.has(t))return He.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return He.set(t,i),i}}class Xe{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class Ke extends Xe{getDefault(){return e.aO.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class Ye extends Xe{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1);}}class Je extends Xe{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1);}}class Qe extends Xe{getDefault(){return [!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class ti extends Xe{getDefault(){return !0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1);}}class ei extends Xe{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1);}}class ii extends Xe{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1);}}class si extends Xe{getDefault(){const t=this.gl;return [t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1);}}class ai extends Xe{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1;}}class oi extends Xe{getDefault(){return [0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1);}}class ri extends Xe{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1;}}class ni extends Xe{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1);}}class li extends Xe{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1;}}class hi extends Xe{getDefault(){const t=this.gl;return [t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1);}}class ci extends Xe{getDefault(){return e.aO.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class ui extends Xe{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1);}}class di extends Xe{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1;}}class _i extends Xe{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1);}}class pi extends Xe{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1);}}class mi extends Xe{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1);}}class fi extends Xe{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1);}}class gi extends Xe{getDefault(){const t=this.gl;return [0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class vi extends Xe{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1;}}class xi extends Xe{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class yi extends Xe{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1;}}class bi extends Xe{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class wi extends Xe{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class Ti extends Xe{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;$e(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1;}}class Ii extends Xe{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1;}}class Ei extends Xe{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1;}}class Si extends Xe{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1;}}class Ci extends Xe{constructor(t,e){super(t),this.context=t,this.parent=e;}getDefault(){return null}}class Pi extends Ci{setDirty(){this.dirty=!0;}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1;}}class Di extends Ci{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class zi extends Ci{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class Mi{constructor(t,e,i,s,a){this.context=t,this.width=e,this.height=i;const o=t.gl,r=this.framebuffer=o.createFramebuffer();if(this.colorAttachment=new Pi(t,r),s)this.depthAttachment=a?new zi(t,r):new Di(t,r);else if(a)throw new Error("Stencil cannot be set without depth");if(o.checkFramebufferStatus(o.FRAMEBUFFER)!==o.FRAMEBUFFER_COMPLETE)throw new Error("Framebuffer is not complete")}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e);}t.deleteFramebuffer(this.framebuffer);}}class Ai{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i;}}Ai.Replace=[1,0],Ai.disabled=new Ai(Ai.Replace,e.aO.transparent,[!1,!1,!1,!1]),Ai.unblended=new Ai(Ai.Replace,e.aO.transparent,[!0,!0,!0,!0]),Ai.alphaBlended=new Ai([1,771],e.aO.transparent,[!0,!0,!0,!0]);class Ri{constructor(t){var e,i;if(this.gl=t,this.clearColor=new Ke(this),this.clearDepth=new Ye(this),this.clearStencil=new Je(this),this.colorMask=new Qe(this),this.depthMask=new ti(this),this.stencilMask=new ei(this),this.stencilFunc=new ii(this),this.stencilOp=new si(this),this.stencilTest=new ai(this),this.depthRange=new oi(this),this.depthTest=new ri(this),this.depthFunc=new ni(this),this.blend=new li(this),this.blendFunc=new hi(this),this.blendColor=new ci(this),this.blendEquation=new ui(this),this.cullFace=new di(this),this.cullFaceSide=new _i(this),this.frontFace=new pi(this),this.program=new mi(this),this.activeTexture=new fi(this),this.viewport=new gi(this),this.bindFramebuffer=new vi(this),this.bindRenderbuffer=new xi(this),this.bindTexture=new yi(this),this.bindVertexBuffer=new bi(this),this.bindElementBuffer=new wi(this),this.bindVertexArray=new Ti(this),this.pixelStoreUnpack=new Ii(this),this.pixelStoreUnpackPremultiplyAlpha=new Ei(this),this.pixelStoreUnpackFlipY=new Si(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),$e(t)){this.HALF_FLOAT=t.HALF_FLOAT;const s=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==s?void 0:s.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==s?void 0:s.RGB16F_EXT,t.getExtension("EXT_color_buffer_float");}else {t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES;}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(t,e){return new qe(this,t,e)}createVertexBuffer(t,e,i){return new We(this,t,e,i)}createRenderbuffer(t,e,i){const s=this.gl,a=s.createRenderbuffer();return this.bindRenderbuffer.set(a),s.renderbufferStorage(s.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),a}createFramebuffer(t,e,i,s){return new Mi(this,t,e,i,s)}clear({color:t,depth:e,stencil:i}){const s=this.gl;let a=0;t&&(a|=s.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(a|=s.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(a|=s.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),s.clear(a);}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace));}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1);}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1);}setColorMode(t){e.aD(t.blendFunction,Ai.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask);}createVertexArray(){var t;return $e(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return $e(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null);}}class Li{constructor(t,e,i){this.func=t,this.mask=e,this.range=i;}}Li.ReadOnly=!1,Li.ReadWrite=!0,Li.disabled=new Li(519,Li.ReadOnly,[0,1]);const ki=7680;class Fi{constructor(t,e,i,s,a,o){this.test=t,this.ref=e,this.mask=i,this.fail=s,this.depthFail=a,this.pass=o;}}Fi.disabled=new Fi({func:519,mask:0},0,0,ki,ki,ki);class Bi{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i;}}let Oi;function Ni(t,i,s,a,o,r,n){const l=t.context,h=l.gl,c=t.useProgram("collisionBox"),u=[];let d=0,_=0;for(let p=0;p<a.length;p++){const m=a[p],f=i.getTile(m),g=f.getBucket(s);if(!g)continue;let v=m.posMatrix;0===o[0]&&0===o[1]||(v=t.translatePosMatrix(m.posMatrix,f,o,r));const x=n?g.textCollisionBox:g.iconCollisionBox,y=g.collisionCircleArray;if(y.length>0){const i=e.F(),s=v;e.aP(i,g.placementInvProjMatrix,t.transform.glCoordMatrix),e.aP(i,i,g.placementViewportMatrix),u.push({circleArray:y,circleOffset:_,transform:s,invTransform:i,coord:m}),d+=y.length/4,_=d;}x&&c.draw(l,h.LINES,Li.disabled,Fi.disabled,t.colorModeForRenderPass(),Bi.disabled,Ee(v,t.transform,f),t.style.map.terrain&&t.style.map.terrain.getTerrainData(m),s.id,x.layoutVertexBuffer,x.indexBuffer,x.segments,null,t.transform.zoom,null,null,x.collisionVertexBuffer);}if(!n||!u.length)return;const p=t.useProgram("collisionCircle"),m=new e.aQ;m.resize(4*d),m._trim();let f=0;for(const t of u)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,s=t.circleArray[i+0],a=t.circleArray[i+1],o=t.circleArray[i+2],r=t.circleArray[i+3];m.emplace(f++,s,a,o,r,0),m.emplace(f++,s,a,o,r,1),m.emplace(f++,s,a,o,r,2),m.emplace(f++,s,a,o,r,3);}(!Oi||Oi.length<2*d)&&(Oi=function(t){const i=2*t,s=new e.aS;s.resize(i),s._trim();for(let t=0;t<i;t++){const e=6*t;s.uint16[e+0]=4*t+0,s.uint16[e+1]=4*t+1,s.uint16[e+2]=4*t+2,s.uint16[e+3]=4*t+2,s.uint16[e+4]=4*t+3,s.uint16[e+5]=4*t+0;}return s}(d));const g=l.createIndexBuffer(Oi,!0),v=l.createVertexBuffer(m,e.aR.members,!0);for(const i of u){const a={u_matrix:i.transform,u_inv_matrix:i.invTransform,u_camera_to_center_distance:(x=t.transform).cameraToCenterDistance,u_viewport_size:[x.width,x.height]};p.draw(l,h.TRIANGLES,Li.disabled,Fi.disabled,t.colorModeForRenderPass(),Bi.disabled,a,t.style.map.terrain&&t.style.map.terrain.getTerrainData(i.coord),s.id,v,g,e.$.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,t.transform.zoom,null,null,null);}var x;v.destroy(),g.destroy();}Bi.disabled=new Bi(!1,1029,2305),Bi.backCCW=new Bi(!0,1029,2305);const Ui=e.an(new Float32Array(16));function Zi(t,i,s,a,o,r){const{horizontalAlign:n,verticalAlign:l}=e.at(t);return new e.P((-(n-.5)*i/o+a[0])*r,(-(l-.5)*s/o+a[1])*r)}function Gi(t,i,s,a,o,r,n,l,h,c,u){const d=t.text.placedSymbolArray,_=t.text.dynamicLayoutVertexArray,p=t.icon.dynamicLayoutVertexArray,m={};_.clear();for(let p=0;p<d.length;p++){const f=d.get(p),g=f.hidden||!f.crossTileID||t.allowVerticalPlacement&&!f.placedOrientation?null:a[f.crossTileID];if(g){const a=new e.P(f.anchorX,f.anchorY),d=gt(a,s?n:r,u),p=vt(o.cameraToCenterDistance,d.signedDistanceFromCamera);let v=e.ai(t.textSizeData,h,f)*p/e.ao;s&&(v*=t.tilePixelRatio/l);const{width:x,height:y,anchor:b,textOffset:w,textBoxScale:T}=g,I=Zi(b,x,y,w,T,v),E=s?gt(a.add(I),r,u).point:d.point.add(i?I.rotate(-o.angle):I),S=t.allowVerticalPlacement&&f.placedOrientation===e.ah.vertical?Math.PI/2:0;for(let t=0;t<f.numGlyphs;t++)e.aj(_,E,S);c&&f.associatedIconIndex>=0&&(m[f.associatedIconIndex]={shiftedAnchor:E,angle:S});}else zt(f.numGlyphs,_);}if(c){p.clear();const i=t.icon.placedSymbolArray;for(let t=0;t<i.length;t++){const s=i.get(t);if(s.hidden)zt(s.numGlyphs,p);else {const i=m[t];if(i)for(let t=0;t<s.numGlyphs;t++)e.aj(p,i.shiftedAnchor,i.angle);else zt(s.numGlyphs,p);}}t.icon.dynamicLayoutVertexBuffer.updateData(p);}t.text.dynamicLayoutVertexBuffer.updateData(_);}function ji(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function qi(t,i,s,a,o,r,n,l,h,c,u,d){const _=t.context,p=_.gl,m=t.transform,f="map"===l,g="map"===h,v="viewport"!==l&&"point"!==s.layout.get("symbol-placement"),x=f&&!g&&!v,y=!s.layout.get("symbol-sort-key").isConstant();let b=!1;const w=t.depthModeForSublayer(0,Li.ReadOnly),T=s._unevaluatedLayout.hasValue("text-variable-anchor")||s._unevaluatedLayout.hasValue("text-variable-anchor-offset"),I=[];for(const l of a){const a=i.getTile(l),h=a.getBucket(s);if(!h)continue;const u=o?h.text:h.icon;if(!u||!u.segments.get().length||!u.hasVisibleVertices)continue;const d=u.programConfigurations.get(s.id),_=o||h.sdfIcons,w=o?h.textSizeData:h.iconSizeData,E=g||0!==m.pitch,S=t.useProgram(ji(_,o,h),d),C=e.ag(w,m.zoom),P=t.style.map.terrain&&t.style.map.terrain.getTerrainData(l);let D,z,M,A,R=[0,0],L=null;if(o)z=a.glyphAtlasTexture,M=p.LINEAR,D=a.glyphAtlasTexture.size,h.iconsInText&&(R=a.imageAtlasTexture.size,L=a.imageAtlasTexture,A=E||t.options.rotating||t.options.zooming||"composite"===w.kind||"camera"===w.kind?p.LINEAR:p.NEAREST);else {const e=1!==s.layout.get("icon-size").constantOr(0)||h.iconsNeedLinear;z=a.imageAtlasTexture,M=_||t.options.rotating||t.options.zooming||e||E?p.LINEAR:p.NEAREST,D=a.imageAtlasTexture.size;}const k=Lt(a,1,t.transform.zoom),F=mt(l.posMatrix,g,f,t.transform,k),B=ft(l.posMatrix,g,f,t.transform,k),O=T&&h.hasTextData(),N="none"!==s.layout.get("icon-text-fit")&&O&&h.hasIconData();if(v){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(l,e,i):null,i="map"===s.layout.get("text-rotation-alignment");yt(h,l.posMatrix,t,o,F,B,g,c,i,e);}const U=t.translatePosMatrix(l.posMatrix,a,r,n),Z=v||o&&T||N?Ui:F,G=t.translatePosMatrix(B,a,r,n,!0),j=_&&0!==s.paint.get(o?"text-halo-width":"icon-halo-width").constantOr(1);let q;q=_?h.iconsInText?Ue(w.kind,C,x,g,t,U,Z,G,D,R):Ne(w.kind,C,x,g,t,U,Z,G,o,D,!0):Oe(w.kind,C,x,g,t,U,Z,G,o,D);const V={program:S,buffers:u,uniformValues:q,atlasTexture:z,atlasTextureIcon:L,atlasInterpolation:M,atlasInterpolationIcon:A,isSDF:_,hasHalo:j};if(y&&h.canOverlap){b=!0;const t=u.segments.get();for(const i of t)I.push({segments:new e.$([i]),sortKey:i.sortKey,state:V,terrainData:P});}else I.push({segments:u.segments,sortKey:0,state:V,terrainData:P});}b&&I.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of I){const i=e.state;if(_.activeTexture.set(p.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,p.CLAMP_TO_EDGE),i.atlasTextureIcon&&(_.activeTexture.set(p.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,p.CLAMP_TO_EDGE)),i.isSDF){const a=i.uniformValues;i.hasHalo&&(a.u_is_halo=1,Vi(i.buffers,e.segments,s,t,i.program,w,u,d,a,e.terrainData)),a.u_is_halo=0;}Vi(i.buffers,e.segments,s,t,i.program,w,u,d,i.uniformValues,e.terrainData);}}function Vi(t,e,i,s,a,o,r,n,l,h){const c=s.context;a.draw(c,c.gl.TRIANGLES,o,r,n,Bi.disabled,l,h,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,s.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer);}function Wi(t,e,i,s,a){if(!i||!s||!s.imageAtlas)return;const o=s.imageAtlas.patternPositions;let r=o[i.to.toString()],n=o[i.from.toString()];if(!r&&n&&(r=n),!n&&r&&(n=r),!r||!n){const t=a.getPaintProperty(e);r=o[t],n=o[t];}r&&n&&t.setConstantPatternPositions(r,n);}function Hi(t,e,i,s,a,o,r){const n=t.context.gl,l="fill-pattern",h=i.paint.get(l),c=h&&h.constantOr(1),u=i.getCrossfadeParameters();let d,_,p,m,f;r?(_=c&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=n.LINES):(_=c?"fillPattern":"fill",d=n.TRIANGLES);const g=h.constantOr(null);for(const h of s){const s=e.getTile(h);if(c&&!s.patternsLoaded())continue;const v=s.getBucket(i);if(!v)continue;const x=v.programConfigurations.get(i.id),y=t.useProgram(_,x),b=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h);c&&(t.context.activeTexture.set(n.TEXTURE0),s.imageAtlasTexture.bind(n.LINEAR,n.CLAMP_TO_EDGE),x.updatePaintBuffers(u)),Wi(x,l,g,s,i);const w=b?h:null,T=t.translatePosMatrix(w?w.posMatrix:h.posMatrix,s,i.paint.get("fill-translate"),i.paint.get("fill-translate-anchor"));if(r){m=v.indexBuffer2,f=v.segments2;const e=[n.drawingBufferWidth,n.drawingBufferHeight];p="fillOutlinePattern"===_&&c?Te(T,t,u,s,e):we(T,e);}else m=v.indexBuffer,f=v.segments,p=c?be(T,t,u,s):ye(T);y.draw(t.context,d,a,t.stencilModeForClipping(h),o,Bi.disabled,p,b,i.id,v.layoutVertexBuffer,m,f,i.paint,t.transform.zoom,x);}}function $i(t,e,i,s,a,o,r){const n=t.context,l=n.gl,h="fill-extrusion-pattern",c=i.paint.get(h),u=c.constantOr(1),d=i.getCrossfadeParameters(),_=i.paint.get("fill-extrusion-opacity"),p=c.constantOr(null);for(const c of s){const s=e.getTile(c),m=s.getBucket(i);if(!m)continue;const f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(c),g=m.programConfigurations.get(i.id),v=t.useProgram(u?"fillExtrusionPattern":"fillExtrusion",g);u&&(t.context.activeTexture.set(l.TEXTURE0),s.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),g.updatePaintBuffers(d)),Wi(g,h,p,s,i);const x=t.translatePosMatrix(c.posMatrix,s,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),y=i.paint.get("fill-extrusion-vertical-gradient"),b=u?xe(x,t,y,_,c,d,s):ve(x,t,y,_);v.draw(n,n.gl.TRIANGLES,a,o,r,Bi.backCCW,b,f,i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,i.paint,t.transform.zoom,g,t.style.map.terrain&&m.centroidVertexBuffer);}}function Xi(t,e,i,s,a,o,r){const n=t.context,l=n.gl,h=i.fbo;if(!h)return;const c=t.useProgram("hillshade"),u=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e);n.activeTexture.set(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,h.colorAttachment.get()),c.draw(n,l.TRIANGLES,a,o,r,Bi.disabled,((t,e,i,s)=>{const a=i.paint.get("hillshade-shadow-color"),o=i.paint.get("hillshade-highlight-color"),r=i.paint.get("hillshade-accent-color");let n=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(n-=t.transform.angle);const l=!t.options.moving;return {u_matrix:s?s.posMatrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped(),l),u_image:0,u_latrange:De(0,e.tileID),u_light:[i.paint.get("hillshade-exaggeration"),n],u_shadow:a,u_highlight:o,u_accent:r}})(t,i,s,u?e:null),u,s.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments);}function Ki(t,i,s,a,o,r){const n=t.context,l=n.gl,h=i.dem;if(h&&h.data){const c=h.dim,u=h.stride,d=h.getPixels();if(n.activeTexture.set(l.TEXTURE1),n.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(u),i.demTexture){const t=i.demTexture;t.update(d,{premultiply:!1}),t.bind(l.NEAREST,l.CLAMP_TO_EDGE);}else i.demTexture=new w(n,d,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);n.activeTexture.set(l.TEXTURE0);let _=i.fbo;if(!_){const t=new w(n,{width:c,height:c,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),_=i.fbo=n.createFramebuffer(c,c,!0,!1),_.colorAttachment.set(t.texture);}n.bindFramebuffer.set(_.framebuffer),n.viewport.set([0,0,c,c]),t.useProgram("hillshadePrepare").draw(n,l.TRIANGLES,a,o,r,Bi.disabled,((t,i)=>{const s=i.stride,a=e.F();return e.aN(a,0,e.W,-e.W,0,0,1),e.H(a,a,[0,-e.W,0]),{u_matrix:a,u_image:1,u_dimension:[s,s],u_zoom:t.overscaledZ,u_unpack:i.getUnpackVector()}})(i.tileID,h),null,s.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1;}}function Yi(t,i,s,a,r,n){const l=a.paint.get("raster-fade-duration");if(!n&&l>0){const a=o.now(),n=(a-t.timeAdded)/l,h=i?(a-i.timeAdded)/l:-1,c=s.getSource(),u=r.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),d=!i||Math.abs(i.tileID.overscaledZ-u)>Math.abs(t.tileID.overscaledZ-u),_=d&&t.refreshedUponExpiration?1:e.ac(d?n:1-h,0,1);return t.refreshedUponExpiration&&n>=1&&(t.refreshedUponExpiration=!1),i?{opacity:1,mix:1-_}:{opacity:_,mix:0}}return {opacity:1,mix:0}}const Ji=new e.aO(1,0,0,1),Qi=new e.aO(0,1,0,1),ts=new e.aO(0,0,1,1),es=new e.aO(1,0,1,1),is=new e.aO(0,1,1,1);function ss(t,e,i,s){os(t,0,e+i/2,t.transform.width,i,s);}function as(t,e,i,s){os(t,e-i/2,0,i,t.transform.height,s);}function os(t,e,i,s,a,o){const r=t.context,n=r.gl;n.enable(n.SCISSOR_TEST),n.scissor(e*t.pixelRatio,i*t.pixelRatio,s*t.pixelRatio,a*t.pixelRatio),r.clear({color:o}),n.disable(n.SCISSOR_TEST);}function rs(t,i,s){const a=t.context,o=a.gl,r=s.posMatrix,n=t.useProgram("debug"),l=Li.disabled,h=Fi.disabled,c=t.colorModeForRenderPass(),u="$debug",d=t.style.map.terrain&&t.style.map.terrain.getTerrainData(s);a.activeTexture.set(o.TEXTURE0);const _=i.getTileByID(s.key).latestRawTileData,p=Math.floor((_&&_.byteLength||0)/1024),m=i.getTile(s).tileSize,f=512/Math.min(m,512)*(s.overscaledZ/t.transform.zoom)*.5;let g=s.canonical.toString();s.overscaledZ!==s.canonical.z&&(g+=` => ${s.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,s=t.context.gl,a=t.debugOverlayCanvas.getContext("2d");a.clearRect(0,0,i.width,i.height),a.shadowColor="white",a.shadowBlur=2,a.lineWidth=1.5,a.strokeStyle="white",a.textBaseline="top",a.font="bold 36px Open Sans, sans-serif",a.fillText(e,5,5),a.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(s.LINEAR,s.CLAMP_TO_EDGE);}(t,`${g} ${p}kB`),n.draw(a,o.TRIANGLES,l,h,Ai.alphaBlended,Bi.disabled,Se(r,e.aO.transparent,f),null,u,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),n.draw(a,o.LINE_STRIP,l,h,c,Bi.disabled,Se(r,e.aO.red),d,u,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments);}function ns(t,e,i){const s=t.context,a=s.gl,o=t.colorModeForRenderPass(),r=new Li(a.LEQUAL,Li.ReadWrite,t.depthRangeFor3D),n=t.useProgram("terrain"),l=e.getTerrainMesh();s.bindFramebuffer.set(null),s.viewport.set([0,0,t.width,t.height]);for(const h of i){const i=t.renderToTexture.getTexture(h),c=e.getTerrainData(h.tileID);s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,i.texture);const u={u_matrix:t.transform.calculatePosMatrix(h.tileID.toUnwrapped()),u_texture:0,u_ele_delta:e.getMeshFrameDelta(t.transform.zoom)};n.draw(s,a.TRIANGLES,r,Fi.disabled,o,Bi.backCCW,u,c,"terrain",l.vertexBuffer,l.indexBuffer,l.segments);}}class ls{constructor(t,i){this.context=new Ri(t),this.transform=i,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:e.F(),renderTime:0},this.setup(),this.numSublayers=ht.maxUnderzooming+ht.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new re;}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize();}setup(){const t=this.context,i=new e.aV;i.emplaceBack(0,0),i.emplaceBack(e.W,0),i.emplaceBack(0,e.W),i.emplaceBack(e.W,e.W),this.tileExtentBuffer=t.createVertexBuffer(i,ce.members),this.tileExtentSegments=e.$.simpleSegment(0,0,4,2);const s=new e.aV;s.emplaceBack(0,0),s.emplaceBack(e.W,0),s.emplaceBack(0,e.W),s.emplaceBack(e.W,e.W),this.debugBuffer=t.createVertexBuffer(s,ce.members),this.debugSegments=e.$.simpleSegment(0,0,4,5);const a=new e.Z;a.emplaceBack(0,0,0,0),a.emplaceBack(e.W,0,e.W,0),a.emplaceBack(0,e.W,0,e.W),a.emplaceBack(e.W,e.W,e.W,e.W),this.rasterBoundsBuffer=t.createVertexBuffer(a,Y.members),this.rasterBoundsSegments=e.$.simpleSegment(0,0,4,2);const o=new e.aV;o.emplaceBack(0,0),o.emplaceBack(1,0),o.emplaceBack(0,1),o.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(o,ce.members),this.viewportSegments=e.$.simpleSegment(0,0,4,2);const r=new e.aW;r.emplaceBack(0),r.emplaceBack(1),r.emplaceBack(3),r.emplaceBack(2),r.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(r);const n=new e.aX;n.emplaceBack(0,1,2),n.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(n);const l=this.context.gl;this.stencilClearMode=new Fi({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO);}clearStencil(){const t=this.context,i=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const s=e.F();e.aN(s,0,this.width,this.height,0,0,1),e.J(s,s,[i.drawingBufferWidth,i.drawingBufferHeight,0]),this.useProgram("clippingMask").draw(t,i.TRIANGLES,Li.disabled,this.stencilClearMode,Ai.disabled,Bi.disabled,Ce(s),null,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(t,e){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source;const i=this.context,s=i.gl;this.nextStencilID+e.length>256&&this.clearStencil(),i.setColorMode(Ai.disabled),i.setDepthMode(Li.disabled);const a=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const t of e){const e=this._tileClippingMaskIDs[t.key]=this.nextStencilID++,o=this.style.map.terrain&&this.style.map.terrain.getTerrainData(t);a.draw(i,s.TRIANGLES,Li.disabled,new Fi({func:s.ALWAYS,mask:0},e,255,s.KEEP,s.KEEP,s.REPLACE),Ai.disabled,Bi.disabled,Ce(t.posMatrix),o,"$clipping",this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new Fi({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new Fi({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}stencilConfigForOverlap(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),s=i[i.length-1].overscaledZ,a=i[0].overscaledZ-s+1;if(a>1){this.currentStencilSource=void 0,this.nextStencilID+a>256&&this.clearStencil();const t={};for(let i=0;i<a;i++)t[i+s]=new Fi({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=a,[t,i]}return [{[s]:Fi.disabled},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new Ai([t.CONSTANT_COLOR,t.ONE],new e.aO(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?Ai.unblended:Ai.alphaBlended}depthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return Li.disabled;const s=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new Li(i||this.context.gl.LEQUAL,e,[s,s])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,i){this.style=t,this.options=i,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(o.now()),this.imageManager.beginFrame();const s=this.style._order,a=this.style.sourceCaches,r={},n={},l={};for(const t in a){const e=a[t];e.used&&e.prepare(this.context),r[t]=e.getVisibleCoordinates(),n[t]=r[t].slice().reverse(),l[t]=e.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let t=0;t<s.length;t++)if(this.style._layers[s[t]].is3D()){this.opaquePassCutoff=t;break}if(this.renderToTexture){this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0;const t=this.style.map.terrain.sourceCache.tilesAfterTime(this.terrainFacilitator.renderTime);(this.terrainFacilitator.dirty||!e.aY(this.terrainFacilitator.matrix,this.transform.projMatrix)||t.length)&&(e.aZ(this.terrainFacilitator.matrix,this.transform.projMatrix),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,i){const s=t.context,a=s.gl,o=Ai.unblended,r=new Li(a.LEQUAL,Li.ReadWrite,[0,1]),n=i.getTerrainMesh(),l=i.sourceCache.getRenderableTiles(),h=t.useProgram("terrainDepth");s.bindFramebuffer.set(i.getFramebuffer("depth").framebuffer),s.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),s.clear({color:e.aO.transparent,depth:1});for(const e of l){const l=i.getTerrainData(e.tileID),c={u_matrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped()),u_ele_delta:i.getMeshFrameDelta(t.transform.zoom)};h.draw(s,a.TRIANGLES,r,Fi.disabled,o,Bi.backCCW,c,l,"terrain",n.vertexBuffer,n.indexBuffer,n.segments);}s.bindFramebuffer.set(null),s.viewport.set([0,0,t.width,t.height]);}(this,this.style.map.terrain),function(t,i){const s=t.context,a=s.gl,o=Ai.unblended,r=new Li(a.LEQUAL,Li.ReadWrite,[0,1]),n=i.getTerrainMesh(),l=i.getCoordsTexture(),h=i.sourceCache.getRenderableTiles(),c=t.useProgram("terrainCoords");s.bindFramebuffer.set(i.getFramebuffer("coords").framebuffer),s.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),s.clear({color:e.aO.transparent,depth:1}),i.coordsIndex=[];for(const e of h){const h=i.getTerrainData(e.tileID);s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,l.texture);const u={u_matrix:t.transform.calculatePosMatrix(e.tileID.toUnwrapped()),u_terrain_coords_id:(255-i.coordsIndex.length)/255,u_texture:0,u_ele_delta:i.getMeshFrameDelta(t.transform.zoom)};c.draw(s,a.TRIANGLES,r,Fi.disabled,o,Bi.backCCW,u,h,"terrain",n.vertexBuffer,n.indexBuffer,n.segments),i.coordsIndex.push(e.tileID.key);}s.bindFramebuffer.set(null),s.viewport.set([0,0,t.width,t.height]);}(this,this.style.map.terrain));}this.renderPass="offscreen";for(const t of s){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=n[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,a[e.source],e,i);}if(this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?e.aO.black:e.aO.transparent,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=s.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[s[this.currentLayer]],e=a[t.source],i=r[t.source];this._renderTileClippingMasks(t,i),this.renderLayer(this,e,t,i);}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<s.length;this.currentLayer++){const t=this.style._layers[s[this.currentLayer]],e=a[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t))continue;const i=("symbol"===t.type?l:n)[t.source];this._renderTileClippingMasks(t,r[t.source]),this.renderLayer(this,e,t,i);}if(this.options.showTileBoundaries){const t=function(t,e){let i=null;const s=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.sourceCaches[i.source]]:[])),a=s.filter((t=>"vector"===t.getSource().type)),o=s.filter((t=>"vector"!==t.getSource().type)),r=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t);};return a.forEach((t=>r(t))),i||o.forEach((t=>r(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let s=0;s<i.length;s++)rs(t,e,i[s]);}(this,t,t.getVisibleCoordinates());}this.options.showPadding&&function(t){const e=t.transform.padding;ss(t,t.transform.height-(e.top||0),3,Ji),ss(t,e.bottom||0,3,Qi),as(t,e.left||0,3,ts),as(t,t.transform.width-(e.right||0),3,es);const i=t.transform.centerPoint;!function(t,e,i,s){os(t,e-1,i-10,2,20,s),os(t,e-10,i-1,20,2,s);}(t,i.x,t.transform.height-i.y,is);}(this),this.context.setDefault();}renderLayer(t,i,s,a){if(!s.isHidden(this.transform.zoom)&&("background"===s.type||"custom"===s.type||(a||[]).length))switch(this.id=s.id,s.type){case"symbol":!function(t,i,s,a,o){if("translucent"!==t.renderPass)return;const r=Fi.disabled,n=t.colorModeForRenderPass();(s._unevaluatedLayout.hasValue("text-variable-anchor")||s._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,i,s,a,o,r,n){const l=i.transform,h="map"===o,c="map"===r;for(const o of t){const t=a.getTile(o),r=t.getBucket(s);if(!r||!r.text||!r.text.segments.get().length)continue;const u=e.ag(r.textSizeData,l.zoom),d=Lt(t,1,i.transform.zoom),_=mt(o.posMatrix,c,h,i.transform,d),p="none"!==s.layout.get("icon-text-fit")&&r.hasIconData();if(u){const e=Math.pow(2,l.zoom-t.tileID.overscaledZ);Gi(r,h,c,n,l,_,o.posMatrix,e,u,p,i.style.map.terrain?(t,e)=>i.style.map.terrain.getElevation(o,t,e):null);}}}(a,t,s,i,s.layout.get("text-rotation-alignment"),s.layout.get("text-pitch-alignment"),o),0!==s.paint.get("icon-opacity").constantOr(1)&&qi(t,i,s,a,!1,s.paint.get("icon-translate"),s.paint.get("icon-translate-anchor"),s.layout.get("icon-rotation-alignment"),s.layout.get("icon-pitch-alignment"),s.layout.get("icon-keep-upright"),r,n),0!==s.paint.get("text-opacity").constantOr(1)&&qi(t,i,s,a,!0,s.paint.get("text-translate"),s.paint.get("text-translate-anchor"),s.layout.get("text-rotation-alignment"),s.layout.get("text-pitch-alignment"),s.layout.get("text-keep-upright"),r,n),i.map.showCollisionBoxes&&(Ni(t,i,s,a,s.paint.get("text-translate"),s.paint.get("text-translate-anchor"),!0),Ni(t,i,s,a,s.paint.get("icon-translate"),s.paint.get("icon-translate-anchor"),!1));}(t,i,s,a,this.style.placement.variableOffsets);break;case"circle":!function(t,i,s,a){if("translucent"!==t.renderPass)return;const o=s.paint.get("circle-opacity"),r=s.paint.get("circle-stroke-width"),n=s.paint.get("circle-stroke-opacity"),l=!s.layout.get("circle-sort-key").isConstant();if(0===o.constantOr(1)&&(0===r.constantOr(1)||0===n.constantOr(1)))return;const h=t.context,c=h.gl,u=t.depthModeForSublayer(0,Li.ReadOnly),d=Fi.disabled,_=t.colorModeForRenderPass(),p=[];for(let o=0;o<a.length;o++){const r=a[o],n=i.getTile(r),h=n.getBucket(s);if(!h)continue;const c=h.programConfigurations.get(s.id),u=t.useProgram("circle",c),d=h.layoutVertexBuffer,_=h.indexBuffer,m=t.style.map.terrain&&t.style.map.terrain.getTerrainData(r),f={programConfiguration:c,program:u,layoutVertexBuffer:d,indexBuffer:_,uniformValues:Ie(t,r,n,s),terrainData:m};if(l){const t=h.segments.get();for(const i of t)p.push({segments:new e.$([i]),sortKey:i.sortKey,state:f});}else p.push({segments:h.segments,sortKey:0,state:f});}l&&p.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of p){const{programConfiguration:i,program:a,layoutVertexBuffer:o,indexBuffer:r,uniformValues:n,terrainData:l}=e.state;a.draw(h,c.TRIANGLES,u,d,_,Bi.disabled,n,l,s.id,o,r,e.segments,s.paint,t.transform.zoom,i);}}(t,i,s,a);break;case"heatmap":!function(t,i,s,a){if(0!==s.paint.get("heatmap-opacity"))if("offscreen"===t.renderPass){const o=t.context,r=o.gl,n=Fi.disabled,l=new Ai([r.ONE,r.ONE],e.aO.transparent,[!0,!0,!0,!0]);!function(t,e,i){const s=t.gl;t.activeTexture.set(s.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let a=i.heatmapFbo;if(a)s.bindTexture(s.TEXTURE_2D,a.colorAttachment.get()),t.bindFramebuffer.set(a.framebuffer);else {const o=s.createTexture();s.bindTexture(s.TEXTURE_2D,o),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR),a=i.heatmapFbo=t.createFramebuffer(e.width/4,e.height/4,!1,!1),function(t,e,i,s){var a,o;const r=t.gl,n=null!==(a=t.HALF_FLOAT)&&void 0!==a?a:r.UNSIGNED_BYTE,l=null!==(o=t.RGBA16F)&&void 0!==o?o:r.RGBA;r.texImage2D(r.TEXTURE_2D,0,l,e.width/4,e.height/4,0,r.RGBA,n,null),s.colorAttachment.set(i);}(t,e,o,a);}}(o,t,s),o.clear({color:e.aO.transparent});for(let e=0;e<a.length;e++){const h=a[e];if(i.hasRenderableParent(h))continue;const c=i.getTile(h),u=c.getBucket(s);if(!u)continue;const d=u.programConfigurations.get(s.id),_=t.useProgram("heatmap",d),{zoom:p}=t.transform;_.draw(o,r.TRIANGLES,Li.disabled,n,l,Bi.disabled,Pe(h.posMatrix,c,p,s.paint.get("heatmap-intensity")),null,s.id,u.layoutVertexBuffer,u.indexBuffer,u.segments,s.paint,t.transform.zoom,d);}o.viewport.set([0,0,t.width,t.height]);}else "translucent"===t.renderPass&&(t.context.setColorMode(t.colorModeForRenderPass()),function(t,i){const s=t.context,a=s.gl,o=i.heatmapFbo;if(!o)return;s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,o.colorAttachment.get()),s.activeTexture.set(a.TEXTURE1);let r=i.colorRampTexture;r||(r=i.colorRampTexture=new w(s,i.colorRamp,a.RGBA)),r.bind(a.LINEAR,a.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(s,a.TRIANGLES,Li.disabled,Fi.disabled,t.colorModeForRenderPass(),Bi.disabled,((t,i,s,a)=>{const o=e.F();e.aN(o,0,t.width,t.height,0,0,1);const r=t.context.gl;return {u_matrix:o,u_world:[r.drawingBufferWidth,r.drawingBufferHeight],u_image:0,u_color_ramp:1,u_opacity:i.paint.get("heatmap-opacity")}})(t,i),null,i.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,i.paint,t.transform.zoom);}(t,s));}(t,i,s,a);break;case"line":!function(t,i,s,a){if("translucent"!==t.renderPass)return;const o=s.paint.get("line-opacity"),r=s.paint.get("line-width");if(0===o.constantOr(1)||0===r.constantOr(1))return;const n=t.depthModeForSublayer(0,Li.ReadOnly),l=t.colorModeForRenderPass(),h=s.paint.get("line-dasharray"),c=s.paint.get("line-pattern"),u=c.constantOr(1),d=s.paint.get("line-gradient"),_=s.getCrossfadeParameters(),p=u?"linePattern":h?"lineSDF":d?"lineGradient":"line",m=t.context,f=m.gl;let g=!0;for(const o of a){const a=i.getTile(o);if(u&&!a.patternsLoaded())continue;const r=a.getBucket(s);if(!r)continue;const v=r.programConfigurations.get(s.id),x=t.context.program.get(),y=t.useProgram(p,v),b=g||y.program!==x,T=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o),I=c.constantOr(null);if(I&&a.imageAtlas){const t=a.imageAtlas,e=t.patternPositions[I.to.toString()],i=t.patternPositions[I.from.toString()];e&&i&&v.setConstantPatternPositions(e,i);}const E=T?o:null,S=u?Ae(t,a,s,_,E):h?Re(t,a,s,h,_,E):d?Me(t,a,s,r.lineClipsArray.length,E):ze(t,a,s,E);if(u)m.activeTexture.set(f.TEXTURE0),a.imageAtlasTexture.bind(f.LINEAR,f.CLAMP_TO_EDGE),v.updatePaintBuffers(_);else if(h&&(b||t.lineAtlas.dirty))m.activeTexture.set(f.TEXTURE0),t.lineAtlas.bind(m);else if(d){const a=r.gradients[s.id];let n=a.texture;if(s.gradientVersion!==a.version){let l=256;if(s.stepInterpolant){const s=i.getSource().maxzoom,a=o.canonical.z===s?Math.ceil(1<<t.transform.maxZoom-o.canonical.z):1;l=e.ac(e.aT(r.maxLineLength/e.W*1024*a),256,m.maxTextureSize);}a.gradient=e.aU({expression:s.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:a.gradient||void 0,clips:r.lineClipsArray}),a.texture?a.texture.update(a.gradient):a.texture=new w(m,a.gradient,f.RGBA),a.version=s.gradientVersion,n=a.texture;}m.activeTexture.set(f.TEXTURE0),n.bind(s.stepInterpolant?f.NEAREST:f.LINEAR,f.CLAMP_TO_EDGE);}y.draw(m,f.TRIANGLES,n,t.stencilModeForClipping(o),l,Bi.disabled,S,T,s.id,r.layoutVertexBuffer,r.indexBuffer,r.segments,s.paint,t.transform.zoom,v,r.layoutVertexBuffer2),g=!1;}}(t,i,s,a);break;case"fill":!function(t,i,s,a){const o=s.paint.get("fill-color"),r=s.paint.get("fill-opacity");if(0===r.constantOr(1))return;const n=t.colorModeForRenderPass(),l=s.paint.get("fill-pattern"),h=t.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===o.constantOr(e.aO.transparent).a&&1===r.constantOr(0)?"opaque":"translucent";if(t.renderPass===h){const e=t.depthModeForSublayer(1,"opaque"===t.renderPass?Li.ReadWrite:Li.ReadOnly);Hi(t,i,s,a,e,n,!1);}if("translucent"===t.renderPass&&s.paint.get("fill-antialias")){const e=t.depthModeForSublayer(s.getPaintProperty("fill-outline-color")?2:0,Li.ReadOnly);Hi(t,i,s,a,e,n,!0);}}(t,i,s,a);break;case"fill-extrusion":!function(t,e,i,s){const a=i.paint.get("fill-extrusion-opacity");if(0!==a&&"translucent"===t.renderPass){const o=new Li(t.context.gl.LEQUAL,Li.ReadWrite,t.depthRangeFor3D);if(1!==a||i.paint.get("fill-extrusion-pattern").constantOr(1))$i(t,e,i,s,o,Fi.disabled,Ai.disabled),$i(t,e,i,s,o,t.stencilModeFor3D(),t.colorModeForRenderPass());else {const a=t.colorModeForRenderPass();$i(t,e,i,s,o,Fi.disabled,a);}}}(t,i,s,a);break;case"hillshade":!function(t,e,i,s){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const a=t.context,o=t.depthModeForSublayer(0,Li.ReadOnly),r=t.colorModeForRenderPass(),[n,l]="translucent"===t.renderPass?t.stencilConfigForOverlap(s):[{},s];for(const s of l){const a=e.getTile(s);void 0!==a.needsHillshadePrepare&&a.needsHillshadePrepare&&"offscreen"===t.renderPass?Ki(t,a,i,o,Fi.disabled,r):"translucent"===t.renderPass&&Xi(t,s,a,i,o,n[s.overscaledZ],r);}a.viewport.set([0,0,t.width,t.height]);}(t,i,s,a);break;case"raster":!function(t,e,i,s){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!s.length)return;const a=t.context,o=a.gl,r=e.getSource(),n=t.useProgram("raster"),l=t.colorModeForRenderPass(),[h,c]=r instanceof J?[{},s]:t.stencilConfigForOverlap(s),u=c[c.length-1].overscaledZ,d=!t.options.moving;for(const s of c){const c=t.depthModeForSublayer(s.overscaledZ-u,1===i.paint.get("raster-opacity")?Li.ReadWrite:Li.ReadOnly,o.LESS),_=e.getTile(s);_.registerFadeDuration(i.paint.get("raster-fade-duration"));const p=e.findLoadedParent(s,0),m=Yi(_,p,e,i,t.transform,t.style.map.terrain);let f,g;const v="nearest"===i.paint.get("raster-resampling")?o.NEAREST:o.LINEAR;a.activeTexture.set(o.TEXTURE0),_.texture.bind(v,o.CLAMP_TO_EDGE,o.LINEAR_MIPMAP_NEAREST),a.activeTexture.set(o.TEXTURE1),p?(p.texture.bind(v,o.CLAMP_TO_EDGE,o.LINEAR_MIPMAP_NEAREST),f=Math.pow(2,p.tileID.overscaledZ-_.tileID.overscaledZ),g=[_.tileID.canonical.x*f%1,_.tileID.canonical.y*f%1]):_.texture.bind(v,o.CLAMP_TO_EDGE,o.LINEAR_MIPMAP_NEAREST);const x=t.style.map.terrain&&t.style.map.terrain.getTerrainData(s),y=x?s:null,b=y?y.posMatrix:t.transform.calculatePosMatrix(s.toUnwrapped(),d),w=Fe(b,g||[0,0],f||1,m,i);r instanceof J?n.draw(a,o.TRIANGLES,c,Fi.disabled,l,Bi.disabled,w,x,i.id,r.boundsBuffer,t.quadTriangleIndexBuffer,r.boundsSegments):n.draw(a,o.TRIANGLES,c,h[s.overscaledZ],l,Bi.disabled,w,x,i.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments);}}(t,i,s,a);break;case"background":!function(t,e,i,s){const a=i.paint.get("background-color"),o=i.paint.get("background-opacity");if(0===o)return;const r=t.context,n=r.gl,l=t.transform,h=l.tileSize,c=i.paint.get("background-pattern");if(t.isPatternMissing(c))return;const u=!c&&1===a.a&&1===o&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==u)return;const d=Fi.disabled,_=t.depthModeForSublayer(0,"opaque"===u?Li.ReadWrite:Li.ReadOnly),p=t.colorModeForRenderPass(),m=t.useProgram(c?"backgroundPattern":"background"),f=s||l.coveringTiles({tileSize:h,terrain:t.style.map.terrain});c&&(r.activeTexture.set(n.TEXTURE0),t.imageManager.bind(t.context));const g=i.getCrossfadeParameters();for(const e of f){const l=s?e.posMatrix:t.transform.calculatePosMatrix(e.toUnwrapped()),u=c?Ge(l,o,t,c,{tileID:e,tileSize:h},g):Ze(l,o,a),f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e);m.draw(r,n.TRIANGLES,_,d,p,Bi.disabled,u,f,i.id,t.tileExtentBuffer,t.quadTriangleIndexBuffer,t.tileExtentSegments);}}(t,0,s,a);break;case"custom":!function(t,e,i){const s=t.context,a=i.implementation;if("offscreen"===t.renderPass){const e=a.prerender;e&&(t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),e.call(a,s.gl,t.transform.customLayerMatrix()),s.setDirty(),t.setBaseState());}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),s.setStencilMode(Fi.disabled);const e="3d"===a.renderingMode?new Li(t.context.gl.LEQUAL,Li.ReadWrite,t.depthRangeFor3D):t.depthModeForSublayer(0,Li.ReadOnly);s.setDepthMode(e),a.render(s.gl,t.transform.customLayerMatrix()),s.setDirty(),t.setBaseState(),s.bindFramebuffer.set(null);}}(t,0,s);}}translatePosMatrix(t,i,s,a,o){if(!s[0]&&!s[1])return t;const r=o?"map"===a?this.transform.angle:0:"viewport"===a?-this.transform.angle:0;if(r){const t=Math.sin(r),e=Math.cos(r);s=[s[0]*e-s[1]*t,s[0]*t+s[1]*e];}const n=[o?s[0]:Lt(i,s[0],this.transform.zoom),o?s[1]:Lt(i,s[1],this.transform.zoom),0],l=new Float32Array(16);return e.H(l,t,n),l}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t];}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return !1;if(!t.from||!t.to)return !0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return !e||!i}useProgram(t,e){this.cache=this.cache||{};const i=t+(e?e.cacheKey:"")+(this._showOverdrawInspector?"/overdraw":"")+(this.style.map.terrain?"/terrain":"");return this.cache[i]||(this.cache[i]=new fe(this.context,de[t],e,je[t],this._showOverdrawInspector,this.style.map.terrain)),this.cache[i]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new w(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}class hs{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(t,i,s){const a=Math.pow(2,s),o=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((s=>{const o=1/(s=e.af([],s,t))[3]/i*a;return e.a_(s,s,[o,o,1/s[3],o])})),r=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=function(t,e){var i=e[0],s=e[1],a=e[2],o=i*i+s*s+a*a;return o>0&&(o=1/Math.sqrt(o)),t[0]=e[0]*o,t[1]=e[1]*o,t[2]=e[2]*o,t}([],function(t,e,i){var s=e[0],a=e[1],o=e[2],r=i[0],n=i[1],l=i[2];return t[0]=a*l-o*n,t[1]=o*r-s*l,t[2]=s*n-a*r,t}([],x([],o[t[0]],o[t[1]]),x([],o[t[2]],o[t[1]]))),i=-((s=e)[0]*(a=o[t[1]])[0]+s[1]*a[1]+s[2]*a[2]);var s,a;return e.concat(i)}));return new hs(o,r)}}class cs{constructor(t,e){this.min=t,this.max=e,this.center=function(t,e,i){return t[0]=.5*e[0],t[1]=.5*e[1],t[2]=.5*e[2],t}([],function(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}([],this.min,this.max));}quadrant(t){const e=[t%2==0,t<2],i=g(this.min),s=g(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],s[t]=e[t]?this.center[t]:this.max[t];return s[2]=this.max[2],new cs(i,s)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersects(t){const i=[[this.min[0],this.min[1],this.min[2],1],[this.max[0],this.min[1],this.min[2],1],[this.max[0],this.max[1],this.min[2],1],[this.min[0],this.max[1],this.min[2],1],[this.min[0],this.min[1],this.max[2],1],[this.max[0],this.min[1],this.max[2],1],[this.max[0],this.max[1],this.max[2],1],[this.min[0],this.max[1],this.max[2],1]];let s=!0;for(let a=0;a<t.planes.length;a++){const o=t.planes[a];let r=0;for(let t=0;t<i.length;t++)e.a$(o,i[t])>=0&&r++;if(0===r)return 0;r!==i.length&&(s=!1);}if(s)return 2;for(let e=0;e<3;e++){let i=Number.MAX_VALUE,s=-Number.MAX_VALUE;for(let a=0;a<t.points.length;a++){const o=t.points[a][e]-this.min[e];i=Math.min(i,o),s=Math.max(s,o);}if(s<0||i>this.max[e]-this.min[e])return 0}return 1}}class us{constructor(t=0,e=0,i=0,s=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(s)||s<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=s;}interpolate(t,i,s){return null!=i.top&&null!=t.top&&(this.top=e.z.number(t.top,i.top,s)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.z.number(t.bottom,i.bottom,s)),null!=i.left&&null!=t.left&&(this.left=e.z.number(t.left,i.left,s)),null!=i.right&&null!=t.right&&(this.right=e.z.number(t.right,i.right,s)),this}getCenter(t,i){const s=e.ac((this.left+t-this.right)/2,0,t),a=e.ac((this.top+i-this.bottom)/2,0,i);return new e.P(s,a)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new us(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}class ds{constructor(t,i,s,a,o){this.tileSize=512,this.maxValidLatitude=85.051129,this._renderWorldCopies=void 0===o||!!o,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=null==s?0:s,this._maxPitch=null==a?60:a,this.setMaxBounds(),this.width=0,this.height=0,this._center=new e.M(0,0),this._elevation=0,this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._unmodified=!0,this._edgeInsets=new us,this._posMatrixCache={},this._alignedPosMatrixCache={},this.minElevationForCurrentTile=0;}clone(){const t=new ds(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return t.apply(this),t}apply(t){this.tileSize=t.tileSize,this.latRange=t.latRange,this.width=t.width,this.height=t.height,this._center=t._center,this._elevation=t._elevation,this.minElevationForCurrentTile=t.minElevationForCurrentTile,this.zoom=t.zoom,this.angle=t.angle,this._fov=t._fov,this._pitch=t._pitch,this._unmodified=t._unmodified,this._edgeInsets=t._edgeInsets.clone(),this._calcMatrices();}get minZoom(){return this._minZoom}set minZoom(t){this._minZoom!==t&&(this._minZoom=t,this.zoom=Math.max(this.zoom,t));}get maxZoom(){return this._maxZoom}set maxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.zoom=Math.min(this.zoom,t));}get minPitch(){return this._minPitch}set minPitch(t){this._minPitch!==t&&(this._minPitch=t,this.pitch=Math.max(this.pitch,t));}get maxPitch(){return this._maxPitch}set maxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.pitch=Math.min(this.pitch,t));}get renderWorldCopies(){return this._renderWorldCopies}set renderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t;}get worldSize(){return this.tileSize*this.scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.P(this.width,this.height)}get bearing(){return -this.angle/Math.PI*180}set bearing(t){const i=-e.b0(t,-180,180)*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=function(){var t=new e.A(4);return e.A!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}(),function(t,e,i){var s=e[0],a=e[1],o=e[2],r=e[3],n=Math.sin(i),l=Math.cos(i);t[0]=s*l+o*n,t[1]=a*l+r*n,t[2]=s*-n+o*l,t[3]=a*-n+r*l;}(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.ac(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get fov(){return this._fov/Math.PI*180}set fov(t){t=Math.max(.01,Math.min(60,t)),this._fov!==t&&(this._unmodified=!1,this._fov=t/180*Math.PI,this._calcMatrices());}get zoom(){return this._zoom}set zoom(t){const e=Math.min(Math.max(t,this.minZoom),this.maxZoom);this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this.tileZoom=Math.max(0,Math.floor(e)),this.scale=this.zoomScale(e),this._constrain(),this._calcMatrices());}get center(){return this._center}set center(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._constrain(),this._calcMatrices());}get elevation(){return this._elevation}set elevation(t){t!==this._elevation&&(this._elevation=t,this._constrain(),this._calcMatrices());}get padding(){return this._edgeInsets.toJSON()}set padding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices());}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(t){const e=(t.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/t.tileSize));return Math.max(0,e)}getVisibleUnwrappedCoordinates(t){const i=[new e.b1(0,t)];if(this._renderWorldCopies){const s=this.pointCoordinate(new e.P(0,0)),a=this.pointCoordinate(new e.P(this.width,0)),o=this.pointCoordinate(new e.P(this.width,this.height)),r=this.pointCoordinate(new e.P(0,this.height)),n=Math.floor(Math.min(s.x,a.x,o.x,r.x)),l=Math.floor(Math.max(s.x,a.x,o.x,r.x)),h=1;for(let s=n-h;s<=l+h;s++)0!==s&&i.push(new e.b1(s,t));}return i}coveringTiles(t){var i,s;let a=this.coveringZoomLevel(t);const o=a;if(void 0!==t.minzoom&&a<t.minzoom)return [];void 0!==t.maxzoom&&a>t.maxzoom&&(a=t.maxzoom);const r=this.pointCoordinate(this.getCameraPoint()),n=e.Y.fromLngLat(this.center),l=Math.pow(2,a),h=[l*r.x,l*r.y,0],c=[l*n.x,l*n.y,0],u=hs.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,a);let d=t.minzoom||0;!t.terrain&&this.pitch<=60&&this._edgeInsets.top<.1&&(d=a);const _=t.terrain?2/Math.min(this.tileSize,t.tileSize)*this.tileSize:3,p=t=>({aabb:new cs([t*l,0,0],[(t+1)*l,l,0]),zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),m=[],f=[],g=a,v=t.reparseOverscaled?o:a;if(this._renderWorldCopies)for(let t=1;t<=3;t++)m.push(p(-t)),m.push(p(t));for(m.push(p(0));m.length>0;){const a=m.pop(),o=a.x,r=a.y;let n=a.fullyVisible;if(!n){const t=a.aabb.intersects(u);if(0===t)continue;n=2===t;}const l=t.terrain?h:c,p=a.aabb.distanceX(l),x=a.aabb.distanceY(l),b=Math.max(Math.abs(p),Math.abs(x));if(a.zoom===g||b>_+(1<<g-a.zoom)-2&&a.zoom>=d){const t=g-a.zoom,i=h[0]-.5-(o<<t),s=h[1]-.5-(r<<t);f.push({tileID:new e.Q(a.zoom===g?v:a.zoom,a.wrap,a.zoom,o,r),distanceSq:y([c[0]-.5-o,c[1]-.5-r]),tileDistanceToCamera:Math.sqrt(i*i+s*s)});}else for(let l=0;l<4;l++){const h=(o<<1)+l%2,c=(r<<1)+(l>>1),u=a.zoom+1;let d=a.aabb.quadrant(l);if(t.terrain){const o=new e.Q(u,a.wrap,u,h,c),r=t.terrain.getMinMaxElevation(o),n=null!==(i=r.minElevation)&&void 0!==i?i:this.elevation,l=null!==(s=r.maxElevation)&&void 0!==s?s:this.elevation;d=new cs([d.min[0],d.min[1],n],[d.max[0],d.max[1],l]);}m.push({aabb:d,zoom:u,x:h,y:c,wrap:a.wrap,fullyVisible:n});}}return f.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}resize(t,e){this.width=t,this.height=e,this.pixelsToGLUnits=[2/t,-2/e],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(t){return Math.pow(2,t)}scaleZoom(t){return Math.log(t)/Math.LN2}project(t){const i=e.ac(t.lat,-this.maxValidLatitude,this.maxValidLatitude);return new e.P(e.N(t.lng)*this.worldSize,e.O(i)*this.worldSize)}unproject(t){return new e.Y(t.x/this.worldSize,t.y/this.worldSize).toLngLat()}get point(){return this.project(this.center)}getCameraPosition(){return {lngLat:this.pointLocation(this.getCameraPoint()),altitude:Math.cos(this._pitch)*this.cameraToCenterDistance/this._pixelPerMeter+this.elevation}}recalculateZoom(t){const i=this.pointLocation(this.centerPoint,t),s=t.getElevationForLngLatZoom(i,this.tileZoom);if(!(this.elevation-s))return;const a=this.getCameraPosition(),o=e.Y.fromLngLat(a.lngLat,a.altitude),r=e.Y.fromLngLat(i,s),n=o.x-r.x,l=o.y-r.y,h=o.z-r.z,c=Math.sqrt(n*n+l*l+h*h),u=this.scaleZoom(this.cameraToCenterDistance/c/this.tileSize);this._elevation=s,this._center=i,this.zoom=u;}setLocationAtPoint(t,i){const s=this.pointCoordinate(i),a=this.pointCoordinate(this.centerPoint),o=this.locationCoordinate(t),r=new e.Y(o.x-(s.x-a.x),o.y-(s.y-a.y));this.center=this.coordinateLocation(r),this._renderWorldCopies&&(this.center=this.center.wrap());}locationPoint(t,e){return e?this.coordinatePoint(this.locationCoordinate(t),e.getElevationForLngLatZoom(t,this.tileZoom),this.pixelMatrix3D):this.coordinatePoint(this.locationCoordinate(t))}pointLocation(t,e){return this.coordinateLocation(this.pointCoordinate(t,e))}locationCoordinate(t){return e.Y.fromLngLat(t)}coordinateLocation(t){return t&&t.toLngLat()}pointCoordinate(t,i){if(i){const e=i.pointCoordinate(t);if(null!=e)return e}const s=[t.x,t.y,0,1],a=[t.x,t.y,1,1];e.af(s,s,this.pixelMatrixInverse),e.af(a,a,this.pixelMatrixInverse);const o=s[3],r=a[3],n=s[1]/o,l=a[1]/r,h=s[2]/o,c=a[2]/r,u=h===c?0:(0-h)/(c-h);return new e.Y(e.z.number(s[0]/o,a[0]/r,u)/this.worldSize,e.z.number(n,l,u)/this.worldSize)}coordinatePoint(t,i=0,s=this.pixelMatrix){const a=[t.x*this.worldSize,t.y*this.worldSize,i,1];return e.af(a,a,s),new e.P(a[0]/a[3],a[1]/a[3])}getBounds(){const t=Math.max(0,this.height/2-this.getHorizon());return (new V).extend(this.pointLocation(new e.P(0,t))).extend(this.pointLocation(new e.P(this.width,t))).extend(this.pointLocation(new e.P(this.width,this.height))).extend(this.pointLocation(new e.P(0,this.height)))}getMaxBounds(){return this.latRange&&2===this.latRange.length&&this.lngRange&&2===this.lngRange.length?new V([this.lngRange[0],this.latRange[0]],[this.lngRange[1],this.latRange[1]]):null}getHorizon(){return Math.tan(Math.PI/2-this._pitch)*this.cameraToCenterDistance*.85}setMaxBounds(t){t?(this.lngRange=[t.getWest(),t.getEast()],this.latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this.lngRange=null,this.latRange=[-this.maxValidLatitude,this.maxValidLatitude]);}calculatePosMatrix(t,i=!1){const s=t.key,a=i?this._alignedPosMatrixCache:this._posMatrixCache;if(a[s])return a[s];const o=t.canonical,r=this.worldSize/this.zoomScale(o.z),n=o.x+Math.pow(2,o.z)*t.wrap,l=e.an(new Float64Array(16));return e.H(l,l,[n*r,o.y*r,0]),e.J(l,l,[r/e.W,r/e.W,1]),e.K(l,i?this.alignedProjMatrix:this.projMatrix,l),a[s]=new Float32Array(l),a[s]}customLayerMatrix(){return this.mercatorMatrix.slice()}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;let t=this.lngRange;if(!this._renderWorldCopies&&null===t){const e=180-1e-10;t=[-e,e];}this._constraining=!0;let i,s,a,o,r=-90,n=90,l=-180,h=180;const c=this.size,u=this._unmodified;if(this.latRange){const t=this.latRange;r=e.O(t[1])*this.worldSize,n=e.O(t[0])*this.worldSize,i=n-r<c.y?c.y/(n-r):0;}t&&(l=e.b0(e.N(t[0])*this.worldSize,0,this.worldSize),h=e.b0(e.N(t[1])*this.worldSize,0,this.worldSize),h<l&&(h+=this.worldSize),s=h-l<c.x?c.x/(h-l):0);const d=this.point,_=Math.max(s||0,i||0);if(_)return this.center=this.unproject(new e.P(s?(h+l)/2:d.x,i?(n+r)/2:d.y)),this.zoom+=this.scaleZoom(_),this._unmodified=u,void(this._constraining=!1);if(this.latRange){const t=d.y,e=c.y/2;t-e<r&&(o=r+e),t+e>n&&(o=n-e);}if(t){const t=(l+h)/2;let i=d.x;this._renderWorldCopies&&(i=e.b0(d.x,t-this.worldSize/2,t+this.worldSize/2));const s=c.x/2;i-s<l&&(a=l+s),i+s>h&&(a=h-s);}void 0===a&&void 0===o||(this.center=this.unproject(new e.P(void 0!==a?a:d.x,void 0!==o?o:d.y)).wrap()),this._unmodified=u,this._constraining=!1;}_calcMatrices(){if(!this.height)return;const t=this.centerOffset,i=this.point.x,s=this.point.y;this.cameraToCenterDistance=.5/Math.tan(this._fov/2)*this.height,this._pixelPerMeter=e.b2(1,this.center.lat)*this.worldSize;let a=e.an(new Float64Array(16));e.J(a,a,[this.width/2,-this.height/2,1]),e.H(a,a,[1,-1,0]),this.labelPlaneMatrix=a,a=e.an(new Float64Array(16)),e.J(a,a,[1,-1,1]),e.H(a,a,[-1,-1,0]),e.J(a,a,[2/this.width,2/this.height,1]),this.glCoordMatrix=a;const o=this.cameraToCenterDistance+this._elevation*this._pixelPerMeter/Math.cos(this._pitch),r=Math.min(this.elevation,this.minElevationForCurrentTile),n=o-r*this._pixelPerMeter/Math.cos(this._pitch),l=r<0?n:o,h=Math.PI/2+this._pitch,c=this._fov*(.5+t.y/this.height),u=Math.sin(c)*l/Math.sin(e.ac(Math.PI-h-c,.01,Math.PI-.01)),d=this.getHorizon(),_=2*Math.atan(d/this.cameraToCenterDistance)*(.5+t.y/(2*d)),p=Math.sin(_)*l/Math.sin(e.ac(Math.PI-h-_,.01,Math.PI-.01)),m=Math.min(u,p),f=1.01*(Math.cos(Math.PI/2-this._pitch)*m+l),g=this.height/50;a=new Float64Array(16),e.b3(a,this._fov,this.width/this.height,g,f),a[8]=2*-t.x/this.width,a[9]=2*t.y/this.height,e.J(a,a,[1,-1,1]),e.H(a,a,[0,0,-this.cameraToCenterDistance]),e.b4(a,a,this._pitch),e.ad(a,a,this.angle),e.H(a,a,[-i,-s,0]),this.mercatorMatrix=e.J([],a,[this.worldSize,this.worldSize,this.worldSize]),e.J(a,a,[1,1,this._pixelPerMeter]),this.pixelMatrix=e.K(new Float64Array(16),this.labelPlaneMatrix,a),e.H(a,a,[0,0,-this.elevation]),this.projMatrix=a,this.invProjMatrix=e.ar([],a),this.pixelMatrix3D=e.K(new Float64Array(16),this.labelPlaneMatrix,a);const v=this.width%2/2,x=this.height%2/2,y=Math.cos(this.angle),b=Math.sin(this.angle),w=i-Math.round(i)+y*v+b*x,T=s-Math.round(s)+y*x+b*v,I=new Float64Array(a);if(e.H(I,I,[w>.5?w-1:w,T>.5?T-1:T,0]),this.alignedProjMatrix=I,a=e.ar(new Float64Array(16),this.pixelMatrix),!a)throw new Error("failed to invert matrix");this.pixelMatrixInverse=a,this._posMatrixCache={},this._alignedPosMatrixCache={};}maxPitchScaleFactor(){if(!this.pixelMatrixInverse)return 1;const t=this.pointCoordinate(new e.P(0,0)),i=[t.x*this.worldSize,t.y*this.worldSize,0,1];return e.af(i,i,this.pixelMatrix)[3]/this.cameraToCenterDistance}getCameraPoint(){const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.P(0,t))}getCameraQueryGeometry(t){const i=this.getCameraPoint();if(1===t.length)return [t[0],i];{let s=i.x,a=i.y,o=i.x,r=i.y;for(const e of t)s=Math.min(s,e.x),a=Math.min(a,e.y),o=Math.max(o,e.x),r=Math.max(r,e.y);return [new e.P(s,a),new e.P(o,a),new e.P(o,r),new e.P(s,r),new e.P(s,a)]}}lngLatToCameraDepth(t,i){const s=this.locationCoordinate(t),a=[s.x*this.worldSize,s.y*this.worldSize,i,1];return e.af(a,a,this.projMatrix),a[2]/a[3]}}function _s(t,e){let i,s=!1,a=null,o=null;const r=()=>{a=null,s&&(t.apply(o,i),a=setTimeout(r,e),s=!1);};return (...t)=>(s=!0,o=this,i=t,a||r(),a)}class ps{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t);})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(t.length>=3&&!t.some((t=>isNaN(t)))){const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0}return !1},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.+)?$/,this.getHashString());try{window.history.replaceState(window.history.state,null,t);}catch(t){}},this._updateHash=_s(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t);}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,s=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),a=Math.pow(10,s),o=Math.round(e.lng*a)/a,r=Math.round(e.lat*a)/a,n=this._map.getBearing(),l=this._map.getPitch();let h="";if(h+=t?`/${o}/${r}/${i}`:`${i}/${r}/${o}`,(n||l)&&(h+="/"+Math.round(10*n)/10),l&&(h+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const s=i.split("=")[0];return s===t?(e=!0,`${s}=${h}`):i})).filter((t=>t));return e||i.push(`${t}=${h}`),`#${i.join("&")}`}return `#${h}`}}const ms={linearity:.3,easing:e.b5(0,0,.3,1)},fs=e.e({deceleration:2500,maxSpeed:1400},ms),gs=e.e({deceleration:20,maxSpeed:1400},ms),vs=e.e({deceleration:1e3,maxSpeed:360},ms),xs=e.e({deceleration:1e3,maxSpeed:90},ms);class ys{constructor(t){this._map=t,this.clear();}clear(){this._inertiaBuffer=[];}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:o.now(),settings:t});}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=o.now();for(;t.length>0&&e-t[0].time>160;)t.shift();}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new e.P(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)i.zoom+=t.zoomDelta||0,i.bearing+=t.bearingDelta||0,i.pitch+=t.pitchDelta||0,t.panDelta&&i.pan._add(t.panDelta),t.around&&(i.around=t.around),t.pinchAround&&(i.pinchAround=t.pinchAround);const s=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,a={};if(i.pan.mag()){const o=ws(i.pan.mag(),s,e.e({},fs,t||{}));a.offset=i.pan.mult(o.amount/i.pan.mag()),a.center=this._map.transform.center,bs(a,o);}if(i.zoom){const t=ws(i.zoom,s,gs);a.zoom=this._map.transform.zoom+t.amount,bs(a,t);}if(i.bearing){const t=ws(i.bearing,s,vs);a.bearing=this._map.transform.bearing+e.ac(t.amount,-179,179),bs(a,t);}if(i.pitch){const t=ws(i.pitch,s,xs);a.pitch=this._map.transform.pitch+t.amount,bs(a,t);}if(a.zoom||a.bearing){const t=void 0===i.pinchAround?i.around:i.pinchAround;a.around=t?this._map.unproject(t):this._map.getCenter();}return this.clear(),e.e(a,{noMoveStart:!0})}}function bs(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing);}function ws(t,i,s){const{maxSpeed:a,linearity:o,deceleration:r}=s,n=e.ac(t*o/(i/1e3),-a,a),l=Math.abs(n)/(r*o);return {easing:s.easing,duration:1e3*l,amount:n*(l/2)}}class Ts extends e.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,s,a={}){const o=r.mousePos(i.getCanvas(),s),n=i.unproject(o);super(t,e.e({point:o,lngLat:n,originalEvent:s},a)),this._defaultPrevented=!1,this.target=i;}}class Is extends e.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,s){const a="touchend"===t?s.changedTouches:s.touches,o=r.touchPos(i.getCanvasContainer(),a),n=o.map((t=>i.unproject(t))),l=o.reduce(((t,e,i,s)=>t.add(e.div(s.length))),new e.P(0,0));super(t,{points:o,point:l,lngLats:n,lngLat:i.unproject(l),originalEvent:s}),this._defaultPrevented=!1;}}class Es extends e.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1;}}class Ss{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance;}reset(){delete this._mousedownPos;}wheel(t){return this._firePreventable(new Es(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new Ts(t.type,this._map,t))}mouseup(t){this._map.fire(new Ts(t.type,this._map,t));}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new Ts(t.type,this._map,t));}dblclick(t){return this._firePreventable(new Ts(t.type,this._map,t))}mouseover(t){this._map.fire(new Ts(t.type,this._map,t));}mouseout(t){this._map.fire(new Ts(t.type,this._map,t));}touchstart(t){return this._firePreventable(new Is(t.type,this._map,t))}touchmove(t){this._map.fire(new Is(t.type,this._map,t));}touchend(t){this._map.fire(new Is(t.type,this._map,t));}touchcancel(t){this._map.fire(new Is(t.type,this._map,t));}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Cs{constructor(t){this._map=t;}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent;}mousemove(t){this._map.fire(new Ts(t.type,this._map,t));}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Ts("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new Ts(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Ps{constructor(t){this._map=t;}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return {lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.pointLocation(e.P.convert(t),this._map.terrain)}}class Ds{constructor(t,e){this._map=t,this._tr=new Ps(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(r.disableDrag(),this._startPos=this._lastPos=e,this._active=!0);}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const s=this._startPos;this._lastPos=i,this._box||(this._box=r.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const a=Math.min(s.x,i.x),o=Math.max(s.x,i.x),n=Math.min(s.y,i.y),l=Math.max(s.y,i.y);r.setTransform(this._box,`translate(${a}px,${n}px)`),this._box.style.width=o-a+"px",this._box.style.height=l-n+"px";}mouseupWindow(t,i){if(!this._active)return;if(0!==t.button)return;const s=this._startPos,a=i;if(this.reset(),r.suppressClick(),s.x!==a.x||s.y!==a.y)return this._map.fire(new e.k("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(s,a,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t);}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t));}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(r.remove(this._box),this._box=null),r.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(t,i){return this._map.fire(new e.k(t,{originalEvent:i}))}}function zs(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let s=0;s<t.length;s++)i[t[s].identifier]=e[s];return i}class Ms{constructor(t){this.reset(),this.numTouches=t.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(t,i,s){(this.centroid||s.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),s.length===this.numTouches&&(this.centroid=function(t){const i=new e.P(0,0);for(const e of t)i._add(e);return i.div(t.length)}(i),this.touches=zs(s,i)));}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const s=zs(i,e);for(const t in this.touches){const e=s[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0);}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class As{constructor(t){this.singleTap=new Ms(t),this.numTaps=t.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(t,e,i){this.singleTap.touchstart(t,e,i);}touchmove(t,e,i){this.singleTap.touchmove(t,e,i);}touchend(t,e,i){const s=this.singleTap.touchend(t,e,i);if(s){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(s)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=s,this.count===this.numTaps)return this.reset(),s}}}class Rs{constructor(t){this._tr=new Ps(t),this._zoomIn=new As({numTouches:1,numTaps:2}),this._zoomOut=new As({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i);}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i);}touchend(t,e,i){const s=this._zoomIn.touchend(t,e,i),a=this._zoomOut.touchend(t,e,i),o=this._tr;return s?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:o.zoom+1,around:o.unproject(s)},{originalEvent:t})}):a?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:o.zoom-1,around:o.unproject(a)},{originalEvent:t})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Ls{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset();}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t);}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=e.length?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0));}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const s=e.length?e[0]:e;return !this._moved&&s.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=s,this._move(i,s))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&r.suppressClick(),this.reset(t));}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const ks={0:1,2:2};class Fs{constructor(t){this._correctEvent=t.checkCorrectEvent;}startMove(t){const e=r.mouseButton(t);this._eventButton=e;}endMove(t){delete this._eventButton;}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return !function(t,e){const i=ks[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return r.mouseButton(t)===this._eventButton}}class Bs{constructor(){this._firstTouch=void 0;}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier;}endMove(t){delete this._firstTouch;}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}const Os=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=function(t){t.preventDefault();};},Ns=({enable:t,clickTolerance:e,bearingDegreesPerPixelMoved:i=.8})=>{const s=new Fs({checkCorrectEvent:t=>0===r.mouseButton(t)&&t.ctrlKey||2===r.mouseButton(t)});return new Ls({clickTolerance:e,move:(t,e)=>({bearingDelta:(e.x-t.x)*i}),moveStateManager:s,enable:t,assignEvents:Os})},Us=({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5})=>{const s=new Fs({checkCorrectEvent:t=>0===r.mouseButton(t)&&t.ctrlKey||2===r.mouseButton(t)});return new Ls({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:s,enable:t,assignEvents:Os})};class Zs{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new e.P(0,0);}minTouchs(){return this._map.cooperativeGestures.isEnabled()?2:1}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active&&!(i.length<this.minTouchs()))return t.preventDefault(),this._calculateTransform(t,e,i)}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&i.length<this.minTouchs()&&this.reset();}touchcancel(){this.reset();}_calculateTransform(t,i,s){s.length>0&&(this._active=!0);const a=zs(s,i),o=new e.P(0,0),r=new e.P(0,0);let n=0;for(const t in a){const e=a[t],i=this._touches[t];i&&(o._add(e),r._add(e.sub(i)),n++,a[t]=e);}if(this._touches=a,n<this.minTouchs()||!r.mag())return;const l=r.div(n);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:o.div(n),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Gs{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]));}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[s,a]=this._firstTwoTouches,o=js(i,e,s),r=js(i,e,a);if(!o||!r)return;const n=this._aroundCenter?null:o.add(r).div(2);return this._move([o,r],n,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[s,a]=this._firstTwoTouches,o=js(i,e,s),n=js(i,e,a);o&&n||(this._active&&r.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}}function js(t,e,i){for(let s=0;s<t.length;s++)if(t[s].identifier===i)return e[s]}function qs(t,e){return Math.log(t/e)/Math.LN2}class Vs extends Gs{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(t){this._startDistance=this._distance=t[0].dist(t[1]);}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(qs(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:qs(this._distance,i),pinchAround:e}}}function Ws(t,e){return 180*t.angleWith(e)/Math.PI}class Hs extends Gs{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1]);}_move(t,e,i){const s=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:Ws(this._vector,s),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=Ws(t,this._startVector);return Math.abs(i)<e}}function $s(t){return Math.abs(t.y)>Math.abs(t.x)}class Xs extends Gs{constructor(t){super(),this._currentTouchCount=0,this._map=t;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length;}_start(t){this._lastPoints=t,$s(t[0].sub(t[1]))&&(this._valid=!1);}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const s=t[0].sub(this._lastPoints[0]),a=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(s,a,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(s.y+a.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const s=t.mag()>=2,a=e.mag()>=2;if(!s&&!a)return;if(!s||!a)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const o=t.y>0==e.y>0;return $s(t)&&$s(e)&&o}}const Ks={panStep:100,bearingStep:15,pitchStep:10};class Ys{constructor(t){this._tr=new Ps(t);const e=Ks;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,s=0,a=0,o=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),a=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),a=1);break;case 38:t.shiftKey?s=1:(t.preventDefault(),o=-1);break;case 40:t.shiftKey?s=-1:(t.preventDefault(),o=1);break;default:return}return this._rotationDisabled&&(i=0,s=0),{cameraAnimation:r=>{const n=this._tr;r.easeTo({duration:300,easeId:"keyboardHandler",easing:Js,zoom:e?Math.round(n.zoom)+e*(t.shiftKey?2:1):n.zoom,bearing:n.bearing+i*this._bearingStep,pitch:n.pitch+s*this._pitchStep,offset:[-a*this._panStep,-o*this._panStep],center:n.center},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Js(t){return t*(2-t)}const Qs=4.000244140625;class ta{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t);},this._map=t,this._tr=new Ps(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222;}setZoomRate(t){this._defaultZoomRate=t;}setWheelZoomRate(t){this._wheelZoomRate=t;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around);}disable(){this.isEnabled()&&(this._enabled=!1);}wheel(t){if(!this.isEnabled())return;if(this._map.cooperativeGestures.isEnabled()&&!t[this._map.cooperativeGestures._bypassKey])return;let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=o.now(),s=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%Qs==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":s>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(s*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault();}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const i=r.mousePos(this._map.getCanvas(),t),s=this._tr;this._around=i.y>s.transform.height/2-s.transform.getHorizon()?e.M.convert(this._aroundCenter?s.center:s.unproject(i)):e.M.convert(s.center),this._aroundPoint=s.transform.locationPoint(this._around),this._frameId||(this._frameId=!0,this._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>Qs?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const s="number"==typeof this._targetZoom?t.zoomScale(this._targetZoom):t.scale;this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,t.scaleZoom(s*i))),"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0;}const i="number"==typeof this._targetZoom?this._targetZoom:t.zoom,s=this._startZoom,a=this._easing;let r,n=!1;if("wheel"===this._type&&s&&a){const t=Math.min((o.now()-this._lastWheelEventTime)/200,1),l=a(t);r=e.z.number(s,i,l),t<1?this._frameId||(this._frameId=!0):n=!0;}else r=i,n=!0;return this._active=!0,n&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;}),200)),{noInertia:!0,needsRenderFrame:!n,zoomDelta:r-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let i=e.b6;if(this._prevEase){const t=this._prevEase,s=(o.now()-t.start)/t.duration,a=t.easing(s+.01)-t.easing(s),r=.27/Math.sqrt(a*a+1e-4)*.01,n=Math.sqrt(.0729-r*r);i=e.b5(r,n,.25,1);}return this._prevEase={start:o.now(),duration:t,easing:i},i}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);}}class ea{constructor(t,e){this._clickZoom=t,this._tapZoom=e;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class ia{constructor(t){this._tr=new Ps(t),this.reset();}reset(){this._active=!1;}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class sa{constructor(){this._tap=new As({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset();}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const s=e[0],a=t.timeStamp-this._tapTime<500,o=this._tapPoint.dist(s)<30;a&&o?i.length>0&&(this._swipePoint=s,this._swipeTouch=i[0].identifier):this.reset();}else this._tap.touchstart(t,e,i);}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const s=e[0],a=s.y-this._swipePoint.y;return this._swipePoint=s,t.preventDefault(),this._active=!0,{zoomDelta:a/128}}}else this._tap.touchmove(t,e,i);}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else {const s=this._tap.touchend(t,e,i);s&&(this._tapTime=t.timeStamp,this._tapPoint=s);}}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class aa{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i;}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class oa{constructor(t,e,i){this._pitchWithRotate=t.pitchWithRotate,this._mouseRotate=e,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class ra{constructor(t,e,i,s){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=s,this._rotationDisabled=!1,this._enabled=!0;}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}class na{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1;}isActive(){return !1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=r.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),s=document.createElement("div");s.className="maplibregl-desktop-message",s.textContent=e,this._container.appendChild(s);const a=document.createElement("div");a.className="maplibregl-mobile-message",a.textContent=i,this._container.appendChild(a),this._container.setAttribute("aria-hidden","true");}_destoryUI(){this._container&&(r.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container;}enable(){this._setupUI(),this._enabled=!0;}disable(){this._enabled=!1,this._destoryUI();}isEnabled(){return this._enabled}touchmove(t){this._onCooperativeGesture(1===t.touches.length);}wheel(t){this._map.scrollZoom.isEnabled()&&this._onCooperativeGesture(!t[this._bypassKey]);}_onCooperativeGesture(t){this._enabled&&t&&(this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show");}),100));}}const la=t=>t.zoom||t.drag||t.pitch||t.rotate;class ha extends e.k{}function ca(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta}class ua{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`);},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,s={needsRenderFrame:!1},a={},o={},n=t.touches,l=n?this._getMapTouches(n):void 0,h=l?r.touchPos(this._map.getCanvas(),l):r.mousePos(this._map.getCanvas(),t);for(const{handlerName:r,handler:n,allowed:c}of this._handlers){if(!n.isEnabled())continue;let u;this._blockedByActive(o,c,r)?n.reset():n[e||t.type]&&(u=n[e||t.type](t,h,l),this.mergeHandlerResult(s,a,u,r,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||n.isActive())&&(o[r]=n);}const c={};for(const t in this._previousActiveHandlers)o[t]||(c[t]=i);this._previousActiveHandlers=o,(Object.keys(c).length||ca(s))&&(this._changes.push([s,a,c]),this._triggerRenderFrame()),(Object.keys(o).length||ca(s))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:u}=s;u&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],u(this._map));},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new ys(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)r.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i);}destroy(){for(const[t,e,i]of this._listeners)r.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i);}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new Ss(e,t));const s=e.boxZoom=new Ds(e,t);this._add("boxZoom",s),t.interactive&&t.boxZoom&&s.enable();const a=e.cooperativeGestures=new na(e,t.cooperativeGestures);this._add("cooperativeGestures",a),t.cooperativeGestures&&a.enable();const o=new Rs(e),n=new ia(e);e.doubleClickZoom=new ea(n,o),this._add("tapZoom",o),this._add("clickZoom",n),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const l=new sa;this._add("tapDragZoom",l);const h=e.touchPitch=new Xs(e);this._add("touchPitch",h),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const c=Ns(t),u=Us(t);e.dragRotate=new oa(t,c,u),this._add("mouseRotate",c,["mousePitch"]),this._add("mousePitch",u,["mouseRotate"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const d=(({enable:t,clickTolerance:e})=>{const i=new Fs({checkCorrectEvent:t=>0===r.mouseButton(t)&&!t.ctrlKey});return new Ls({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:Os})})(t),_=new Zs(t,e);e.dragPan=new aa(i,d,_),this._add("mousePan",d),this._add("touchPan",_,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const p=new Hs,m=new Vs;e.touchZoomRotate=new ra(i,m,p,l),this._add("touchRotate",p,["touchPan","touchZoom"]),this._add("touchZoom",m,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate);const f=e.scrollZoom=new ta(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",f,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const g=e.keyboard=new Ys(e);this._add("keyboard",g),t.interactive&&t.keyboard&&e.keyboard.enable(),this._add("blockableMapEvent",new Cs(e));}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e;}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[];}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(la(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const s in t)if(s!==i&&(!e||e.indexOf(s)<0))return !0;return !1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,i,s,a,o){if(!s)return;e.e(t,s);const r={handlerName:a,originalEvent:s.originalEvent||o};void 0!==s.zoomDelta&&(i.zoom=r),void 0!==s.panDelta&&(i.drag=r),void 0!==s.pitchDelta&&(i.pitch=r),void 0!==s.bearingDelta&&(i.rotate=r);}_applyChanges(){const t={},i={},s={};for(const[a,o,r]of this._changes)a.panDelta&&(t.panDelta=(t.panDelta||new e.P(0,0))._add(a.panDelta)),a.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+a.zoomDelta),a.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+a.bearingDelta),a.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+a.pitchDelta),void 0!==a.around&&(t.around=a.around),void 0!==a.pinchAround&&(t.pinchAround=a.pinchAround),a.noInertia&&(t.noInertia=a.noInertia),e.e(i,o),e.e(s,r);this._updateMapTransform(t,i,s),this._changes=[];}_updateMapTransform(t,e,i){const s=this._map,a=s._getTransformForUpdate(),o=s.terrain;if(!(ca(t)||o&&this._terrainMovement))return this._fireEvents(e,i,!0);let{panDelta:r,zoomDelta:n,bearingDelta:l,pitchDelta:h,around:c,pinchAround:u}=t;void 0!==u&&(c=u),s._stop(!0),c=c||s.transform.centerPoint;const d=a.pointLocation(r?c.sub(r):c);l&&(a.bearing+=l),h&&(a.pitch+=h),n&&(a.zoom+=n),o?this._terrainMovement||!e.drag&&!e.zoom?e.drag&&this._terrainMovement?a.center=a.pointLocation(a.centerPoint.sub(r)):a.setLocationAtPoint(d,c):(this._terrainMovement=!0,this._map._elevationFreeze=!0,a.setLocationAtPoint(d,c),this._map.once("moveend",(()=>{this._map._elevationFreeze=!1,this._terrainMovement=!1,a.recalculateZoom(s.terrain);}))):a.setLocationAtPoint(d,c),s._applyUpdatedTransform(a),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0);}_fireEvents(t,i,s){const a=la(this._eventsInProgress),r=la(t),n={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(n[`${e}start`]=i),this._eventsInProgress[e]=t[e];}!a&&r&&this._fireEvent("movestart",r.originalEvent);for(const t in n)this._fireEvent(t,n[t]);r&&this._fireEvent("move",r.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i);}const l={};let h;for(const t in this._eventsInProgress){const{handlerName:e,originalEvent:s}=this._eventsInProgress[t];this._handlersById[e].isActive()||(delete this._eventsInProgress[t],h=i[e]||s,l[`${t}end`]=h);}for(const t in l)this._fireEvent(t,l[t]);const c=la(this._eventsInProgress);if(s&&(a||r)&&!c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&o.prefersReducedMotion?(this._map.fire(new e.k("moveend",{originalEvent:h})),i(this._map.getBearing())&&this._map.resetNorth()):(i(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:h})),this._updatingCamera=!1;}}_fireEvent(t,i){this._map.fire(new e.k(t,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new ha("renderFrame",{timeStamp:t})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class da extends e.E{constructor(t,e){super(),this._renderFrameCallback=()=>{const t=Math.min((o.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=e.bearingSnap,this.on("moveend",(()=>{delete this._requestedCameraState;}));}getCenter(){return new e.M(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}panBy(t,i,s){return t=e.P.convert(t).mult(-1),this.panTo(this.transform.center,e.e({offset:t},i),s)}panTo(t,i,s){return this.easeTo(e.e({center:t},i),s)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,i,s){return this.easeTo(e.e({zoom:t},i),s)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,i,s){return this.easeTo(e.e({bearing:t},i),s)}resetNorth(t,i){return this.rotateTo(0,e.e({duration:1e3},t),i),this}resetNorthPitch(t,i){return this.easeTo(e.e({bearing:0,pitch:0,duration:1e3},t),i),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}cameraForBounds(t,e){t=V.convert(t);const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,i,s,a){const o={top:0,bottom:0,right:0,left:0};if("number"==typeof(a=e.e({padding:o,offset:[0,0],maxZoom:this.transform.maxZoom},a)).padding){const t=a.padding;a.padding={top:t,bottom:t,right:t,left:t};}a.padding=e.e(o,a.padding);const r=this.transform,n=r.padding,l=new V(t,i),h=r.project(l.getNorthWest()),c=r.project(l.getNorthEast()),u=r.project(l.getSouthEast()),d=r.project(l.getSouthWest()),_=e.b7(-s),p=h.rotate(_),m=c.rotate(_),f=u.rotate(_),g=d.rotate(_),v=new e.P(Math.max(p.x,m.x,g.x,f.x),Math.max(p.y,m.y,g.y,f.y)),x=new e.P(Math.min(p.x,m.x,g.x,f.x),Math.min(p.y,m.y,g.y,f.y)),y=v.sub(x),b=(r.width-(n.left+n.right+a.padding.left+a.padding.right))/y.x,w=(r.height-(n.top+n.bottom+a.padding.top+a.padding.bottom))/y.y;if(w<0||b<0)return void e.w("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const T=Math.min(r.scaleZoom(r.scale*Math.min(b,w)),a.maxZoom),I=e.P.convert(a.offset),E=new e.P((a.padding.left-a.padding.right)/2,(a.padding.top-a.padding.bottom)/2).rotate(e.b7(s)),S=I.add(E).mult(r.scale/r.zoomScale(T));return {center:r.unproject(h.add(u).div(2).sub(S)),zoom:T,bearing:s}}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,i,s,a,o){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.pointLocation(e.P.convert(t)),this.transform.pointLocation(e.P.convert(i)),s,a),a,o)}_fitInternal(t,i,s){return t?(delete(i=e.e(t,i)).padding,i.linear?this.easeTo(i,s):this.flyTo(i,s)):this}jumpTo(t,i){this.stop();const s=this._getTransformForUpdate();let a=!1,o=!1,r=!1;return "zoom"in t&&s.zoom!==+t.zoom&&(a=!0,s.zoom=+t.zoom),void 0!==t.center&&(s.center=e.M.convert(t.center)),"bearing"in t&&s.bearing!==+t.bearing&&(o=!0,s.bearing=+t.bearing),"pitch"in t&&s.pitch!==+t.pitch&&(r=!0,s.pitch=+t.pitch),null==t.padding||s.isPaddingEqual(t.padding)||(s.padding=t.padding),this._applyUpdatedTransform(s),this.fire(new e.k("movestart",i)).fire(new e.k("move",i)),a&&this.fire(new e.k("zoomstart",i)).fire(new e.k("zoom",i)).fire(new e.k("zoomend",i)),o&&this.fire(new e.k("rotatestart",i)).fire(new e.k("rotate",i)).fire(new e.k("rotateend",i)),r&&this.fire(new e.k("pitchstart",i)).fire(new e.k("pitch",i)).fire(new e.k("pitchend",i)),this.fire(new e.k("moveend",i))}calculateCameraOptionsFromTo(t,i,s,a=0){const o=e.Y.fromLngLat(t,i),r=e.Y.fromLngLat(s,a),n=r.x-o.x,l=r.y-o.y,h=r.z-o.z,c=Math.hypot(n,l,h);if(0===c)throw new Error("Can't calculate camera options with same From and To");const u=Math.hypot(n,l),d=this.transform.scaleZoom(this.transform.cameraToCenterDistance/c/this.transform.tileSize),_=180*Math.atan2(n,-l)/Math.PI;let p=180*Math.acos(u/c)/Math.PI;return p=h<0?90-p:90+p,{center:r.toLngLat(),zoom:d,pitch:p,bearing:_}}easeTo(t,i){this._stop(!1,t.easeId),(!1===(t=e.e({offset:[0,0],duration:500,easing:e.b6},t)).animate||!t.essential&&o.prefersReducedMotion)&&(t.duration=0);const s=this._getTransformForUpdate(),a=this.getZoom(),r=this.getBearing(),n=this.getPitch(),l=this.getPadding(),h="zoom"in t?+t.zoom:a,c="bearing"in t?this._normalizeBearing(t.bearing,r):r,u="pitch"in t?+t.pitch:n,d="padding"in t?t.padding:s.padding,_=e.P.convert(t.offset);let p=s.centerPoint.add(_);const m=s.pointLocation(p),f=e.M.convert(t.center||m);this._normalizeCenter(f);const g=s.project(m),v=s.project(f).sub(g),x=s.zoomScale(h-a);let y,b;t.around&&(y=e.M.convert(t.around),b=s.locationPoint(y));const w={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=this._zooming||h!==a,this._rotating=this._rotating||r!==c,this._pitching=this._pitching||u!==n,this._padding=!s.isPaddingEqual(d),this._easeId=t.easeId,this._prepareEase(i,t.noMoveStart,w),this.terrain&&this._prepareElevation(f),this._ease((o=>{if(this._zooming&&(s.zoom=e.z.number(a,h,o)),this._rotating&&(s.bearing=e.z.number(r,c,o)),this._pitching&&(s.pitch=e.z.number(n,u,o)),this._padding&&(s.interpolatePadding(l,d,o),p=s.centerPoint.add(_)),this.terrain&&!t.freezeElevation&&this._updateElevation(o),y)s.setLocationAtPoint(y,b);else {const t=s.zoomScale(s.zoom-a),e=h>a?Math.min(2,x):Math.max(.5,x),i=Math.pow(e,1-o),r=s.unproject(g.add(v.mult(o*i)).mult(t));s.setLocationAtPoint(s.renderWorldCopies?r.wrap():r,p);}this._applyUpdatedTransform(s),this._fireMoveEvents(i);}),(t=>{this.terrain&&this._finalizeElevation(),this._afterEase(i,t);}),t),this}_prepareEase(t,i,s={}){this._moving=!0,i||s.moving||this.fire(new e.k("movestart",t)),this._zooming&&!s.zooming&&this.fire(new e.k("zoomstart",t)),this._rotating&&!s.rotating&&this.fire(new e.k("rotatestart",t)),this._pitching&&!s.pitching&&this.fire(new e.k("pitchstart",t));}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0;}_updateElevation(t){this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);const i=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&i!==this._elevationTarget){const e=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(e-(i-(e*t+this._elevationStart))/(1-t)),this._elevationTarget=i;}this.transform.elevation=e.z.number(this._elevationStart,this._elevationTarget,t);}_finalizeElevation(){this._elevationFreeze=!1,this.transform.recalculateZoom(this.terrain);}_getTransformForUpdate(){return this.transformCameraUpdate?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_applyUpdatedTransform(t){if(!this.transformCameraUpdate)return;const e=t.clone(),{center:i,zoom:s,pitch:a,bearing:o,elevation:r}=this.transformCameraUpdate(e);i&&(e.center=i),void 0!==s&&(e.zoom=s),void 0!==a&&(e.pitch=a),void 0!==o&&(e.bearing=o),void 0!==r&&(e.elevation=r),this.transform.apply(e);}_fireMoveEvents(t){this.fire(new e.k("move",t)),this._zooming&&this.fire(new e.k("zoom",t)),this._rotating&&this.fire(new e.k("rotate",t)),this._pitching&&this.fire(new e.k("pitch",t));}_afterEase(t,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId;const s=this._zooming,a=this._rotating,o=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,s&&this.fire(new e.k("zoomend",t)),a&&this.fire(new e.k("rotateend",t)),o&&this.fire(new e.k("pitchend",t)),this.fire(new e.k("moveend",t));}flyTo(t,i){if(!t.essential&&o.prefersReducedMotion){const s=e.L(t,["center","zoom","bearing","pitch","around"]);return this.jumpTo(s,i)}this.stop(),t=e.e({offset:[0,0],speed:1.2,curve:1.42,easing:e.b6},t);const s=this._getTransformForUpdate(),a=this.getZoom(),r=this.getBearing(),n=this.getPitch(),l=this.getPadding(),h="zoom"in t?e.ac(+t.zoom,s.minZoom,s.maxZoom):a,c="bearing"in t?this._normalizeBearing(t.bearing,r):r,u="pitch"in t?+t.pitch:n,d="padding"in t?t.padding:s.padding,_=s.zoomScale(h-a),p=e.P.convert(t.offset);let m=s.centerPoint.add(p);const f=s.pointLocation(m),g=e.M.convert(t.center||f);this._normalizeCenter(g);const v=s.project(f),x=s.project(g).sub(v);let y=t.curve;const b=Math.max(s.width,s.height),w=b/_,T=x.mag();if("minZoom"in t){const i=e.ac(Math.min(t.minZoom,a,h),s.minZoom,s.maxZoom),o=b/s.zoomScale(i-a);y=Math.sqrt(o/T*2);}const I=y*y;function E(t){const e=(w*w-b*b+(t?-1:1)*I*I*T*T)/(2*(t?w:b)*I*T);return Math.log(Math.sqrt(e*e+1)-e)}function S(t){return (Math.exp(t)-Math.exp(-t))/2}function C(t){return (Math.exp(t)+Math.exp(-t))/2}const P=E(!1);let D=function(t){return C(P)/C(P+y*t)},z=function(t){return b*((C(P)*(S(e=P+y*t)/C(e))-S(P))/I)/T;var e;},M=(E(!0)-P)/y;if(Math.abs(T)<1e-6||!isFinite(M)){if(Math.abs(b-w)<1e-6)return this.easeTo(t,i);const e=w<b?-1:1;M=Math.abs(Math.log(w/b))/y,z=function(){return 0},D=function(t){return Math.exp(e*y*t)};}return t.duration="duration"in t?+t.duration:1e3*M/("screenSpeed"in t?+t.screenSpeed/y:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=r!==c,this._pitching=u!==n,this._padding=!s.isPaddingEqual(d),this._prepareEase(i,!1),this.terrain&&this._prepareElevation(g),this._ease((o=>{const _=o*M,f=1/D(_);s.zoom=1===o?h:a+s.scaleZoom(f),this._rotating&&(s.bearing=e.z.number(r,c,o)),this._pitching&&(s.pitch=e.z.number(n,u,o)),this._padding&&(s.interpolatePadding(l,d,o),m=s.centerPoint.add(p)),this.terrain&&!t.freezeElevation&&this._updateElevation(o);const y=1===o?g:s.unproject(v.add(x.mult(z(_))).mult(f));s.setLocationAtPoint(s.renderWorldCopies?y.wrap():y,m),this._applyUpdatedTransform(s),this._fireMoveEvents(i);}),(()=>{this.terrain&&this._finalizeElevation(),this._afterEase(i);}),t),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(t,e){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e);}if(!t){const t=this.handlers;t&&t.stop(!1);}return this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=o.now(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_normalizeBearing(t,i){t=e.b0(t,-180,180);const s=Math.abs(t-i);return Math.abs(t-360-i)<s&&(t-=360),Math.abs(t+360-i)<s&&(t+=360),t}_normalizeCenter(t){const e=this.transform;if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom(e.M.convert(t),this.transform.tileZoom)-this.transform.elevation:null}}const _a={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class pa{constructor(t=_a){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")));},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions();},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"));},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show");},this.options=t;}getDefaultPosition(){return "bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=r.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=r.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=r.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){r.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0;}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i);}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id;}const e=this._map.style.sourceCaches;for(const i in e){const s=e[i];if(s.used||s.usedForTerrain){const e=s.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution);}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let s=i+1;s<t.length;s++)if(t[s].indexOf(e)>=0)return !1;return !0}));const i=t.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,t.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null);}}class ma{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact");}},this.options=t;}getDefaultPosition(){return "bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=r.create("div","maplibregl-ctrl");const e=r.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){r.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0;}}class fa{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}var ga=e.X([{name:"a_pos3d",type:"Int16",components:3}]);class va extends e.E{constructor(t){super(),this.sourceCache=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.deltaZoom=1,t.usedForTerrain=!0,t.tileSize=this.tileSize*2**this.deltaZoom;}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null;}update(t,i){this.sourceCache.update(t,i),this._renderableTilesKeys=[];const s={};for(const a of t.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:i}))s[a.key]=!0,this._renderableTilesKeys.push(a.key),this._tiles[a.key]||(a.posMatrix=new Float64Array(16),e.aN(a.posMatrix,0,e.W,0,e.W,0,1),this._tiles[a.key]=new rt(a,this.tileSize));for(const t in this._tiles)s[t]||delete this._tiles[t];}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[]);}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t){const i={};for(const s of this._renderableTilesKeys){const a=this._tiles[s].tileID;if(a.canonical.equals(t.canonical)){const a=t.clone();a.posMatrix=new Float64Array(16),e.aN(a.posMatrix,0,e.W,0,e.W,0,1),i[s]=a;}else if(a.canonical.isChildOf(t.canonical)){const o=t.clone();o.posMatrix=new Float64Array(16);const r=a.canonical.z-t.canonical.z,n=a.canonical.x-(a.canonical.x>>r<<r),l=a.canonical.y-(a.canonical.y>>r<<r),h=e.W>>r;e.aN(o.posMatrix,0,h,0,h,0,1),e.H(o.posMatrix,o.posMatrix,[-n*h,-l*h,0]),i[s]=o;}else if(t.canonical.isChildOf(a.canonical)){const o=t.clone();o.posMatrix=new Float64Array(16);const r=t.canonical.z-a.canonical.z,n=t.canonical.x-(t.canonical.x>>r<<r),l=t.canonical.y-(t.canonical.y>>r<<r),h=e.W>>r;e.aN(o.posMatrix,0,e.W,0,e.W,0,1),e.H(o.posMatrix,o.posMatrix,[n*h,l*h,0]),e.J(o.posMatrix,o.posMatrix,[1/2**r,1/2**r,0]),i[s]=o;}}return i}getSourceTile(t,e){const i=this.sourceCache._source;let s=t.overscaledZ-this.deltaZoom;if(s>i.maxzoom&&(s=i.maxzoom),s<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(s).key);let a=this.sourceCache.getTileByID(this._sourceTileCache[t.key]);if((!a||!a.dem)&&e)for(;s>=i.minzoom&&(!a||!a.dem);)a=this.sourceCache.getTileByID(t.scaledTo(s--).key);return a}tilesAfterTime(t=Date.now()){return Object.values(this._tiles).filter((e=>e.timeAdded>=t))}}class xa{constructor(t,e,i){this.painter=t,this.sourceCache=new va(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024;}getDEMElevation(t,i,s,a=e.W){var o;if(!(i>=0&&i<a&&s>=0&&s<a))return 0;const r=this.getTerrainData(t),n=null===(o=r.tile)||void 0===o?void 0:o.dem;if(!n)return 0;const l=function(t,e,i){var s=e[0],a=e[1];return t[0]=i[0]*s+i[4]*a+i[12],t[1]=i[1]*s+i[5]*a+i[13],t}([],[i/a*e.W,s/a*e.W],r.u_terrain_matrix),h=[l[0]*n.dim,l[1]*n.dim],c=Math.floor(h[0]),u=Math.floor(h[1]),d=h[0]-c,_=h[1]-u;return n.get(c,u)*(1-d)*(1-_)+n.get(c+1,u)*d*(1-_)+n.get(c,u+1)*(1-d)*_+n.get(c+1,u+1)*d*_}getElevationForLngLatZoom(t,i){const{tileID:s,mercatorX:a,mercatorY:o}=this._getOverscaledTileIDFromLngLatZoom(t,i);return this.getElevation(s,a%e.W,o%e.W,e.W)}getElevation(t,i,s,a=e.W){return this.getDEMElevation(t,i,s,a)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,i=new e.R({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new w(t,i,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new w(t,new e.R({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=e.an([]);}const i=this.sourceCache.getSourceTile(t,!0);if(i&&i.dem&&(!i.demTexture||i.needsTerrainPrepare)){const t=this.painter.context;i.demTexture=this.painter.getTileTexture(i.dem.stride),i.demTexture?i.demTexture.update(i.dem.getPixels(),{premultiply:!1}):i.demTexture=new w(t,i.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),i.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),i.needsTerrainPrepare=!1;}const s=i&&i+i.tileID.key+t.key;if(s&&!this._demMatrixCache[s]){const s=this.sourceCache.sourceCache._source.maxzoom;let a=t.canonical.z-i.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=s?a=t.canonical.z-s:e.w("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=t.canonical.x-(t.canonical.x>>a<<a),r=t.canonical.y-(t.canonical.y>>a<<a),n=e.b8(new Float64Array(16),[1/(e.W<<a),1/(e.W<<a),0]);e.H(n,n,[o*e.W,r*e.W,0]),this._demMatrixCache[t.key]={matrix:n,coord:t};}return {u_depth:2,u_terrain:3,u_terrain_dim:i&&i.dem&&i.dem.dim||1,u_terrain_matrix:s?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:i&&i.dem&&i.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(i&&i.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:i}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,s=e.height/devicePixelRatio;return !this._fbo||this._fbo.width===i&&this._fbo.height===s||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new w(e.context,{width:i,height:s,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new w(e.context,{width:i,height:s,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,s,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,s))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const i=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,e=0;t<this._coordsTextureSize;t++)for(let s=0;s<this._coordsTextureSize;s++,e+=4)i[e+0]=255&s,i[e+1]=255&t,i[e+2]=s>>8<<4|t>>8,i[e+3]=0;const s=new e.R({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(i.buffer)),a=new w(t,s,t.gl.RGBA,{premultiply:!1});return a.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=a,a}pointCoordinate(t){const i=new Uint8Array(4),s=this.painter.context,a=s.gl;s.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),a.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,a.RGBA,a.UNSIGNED_BYTE,i),s.bindFramebuffer.set(null);const o=i[0]+(i[2]>>4<<8),r=i[1]+((15&i[2])<<8),n=this.coordsIndex[255-i[3]],l=n&&this.sourceCache.getTileByID(n);if(!l)return null;const h=this._coordsTextureSize,c=(1<<l.tileID.canonical.z)*h;return new e.Y((l.tileID.canonical.x*h+o)/c+l.tileID.wrap,(l.tileID.canonical.y*h+r)/c,this.getElevation(l.tileID,o,r,h))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,s=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),s.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,s.RGBA,s.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(){if(this._mesh)return this._mesh;const t=this.painter.context,i=new e.b9,s=new e.aX,a=this.meshSize,o=e.W/a,r=a*a;for(let t=0;t<=a;t++)for(let e=0;e<=a;e++)i.emplaceBack(e*o,t*o,0);for(let t=0;t<r;t+=a+1)for(let e=0;e<a;e++)s.emplaceBack(e+t,a+e+t+1,a+e+t+2),s.emplaceBack(e+t,a+e+t+2,e+t+1);const n=i.length,l=n+2*(a+1);for(const t of [0,1])for(let s=0;s<=a;s++)for(const a of [0,1])i.emplaceBack(s*o,t*e.W,a);for(let t=0;t<2*a;t+=2)s.emplaceBack(l+t,l+t+1,l+t+3),s.emplaceBack(l+t,l+t+3,l+t+2),s.emplaceBack(n+t,n+t+3,n+t+1),s.emplaceBack(n+t,n+t+2,n+t+3);const h=i.length,c=h+2*(a+1);for(const t of [0,1])for(let s=0;s<=a;s++)for(const a of [0,1])i.emplaceBack(t*e.W,s*o,a);for(let t=0;t<2*a;t+=2)s.emplaceBack(h+t,h+t+1,h+t+3),s.emplaceBack(h+t,h+t+3,h+t+2),s.emplaceBack(c+t,c+t+3,c+t+1),s.emplaceBack(c+t,c+t+2,c+t+3);return this._mesh={indexBuffer:t.createIndexBuffer(s),vertexBuffer:t.createVertexBuffer(i,ga.members),segments:e.$.simpleSegment(0,0,i.length,s.length)},this._mesh}getMeshFrameDelta(t){return 2*Math.PI*e.ba/Math.pow(2,t)/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:s}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(s).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,i){const s=e.Y.fromLngLat(t.wrap()),a=(1<<i)*e.W,o=s.x*a,r=s.y*a,n=Math.floor(o/e.W),l=Math.floor(r/e.W);return {tileID:new e.Q(i,0,i,n,l),mercatorX:o,mercatorY:r}}}class ya{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0;}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy();}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new w(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id);}stampObject(t){t.stamp=++this._stamp;}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1;}freeAllObjects(){for(const t of this._objects)this.freeObject(t);}isFull(){return !(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const ba={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0};class wa{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new ya(t.context,30,e.sourceCache.tileSize*e.qualityFactor);}destruct(){this.pool.destruct();}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsDescendingInv={};for(const e in t.sourceCaches){this._coordsDescendingInv[e]={};const i=t.sourceCaches[e].getVisibleCoordinates();for(const t of i){const i=this.terrain.sourceCache.getTerrainCoords(t);for(const t in i)this._coordsDescendingInv[e][t]||(this._coordsDescendingInv[e][t]=[]),this._coordsDescendingInv[e][t].push(i[t]);}}this._coordsDescendingInvStr={};for(const e of t._order){const i=t._layers[e],s=i.source;if(ba[i.type]&&!this._coordsDescendingInvStr[s]){this._coordsDescendingInvStr[s]={};for(const t in this._coordsDescendingInv[s])this._coordsDescendingInvStr[s][t]=this._coordsDescendingInv[s][t].map((t=>t.key)).sort().join();}}for(const t of this._renderableTiles)for(const e in this._coordsDescendingInvStr){const i=this._coordsDescendingInvStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[]);}}renderLayer(t){if(t.isHidden(this.painter.transform.zoom))return !1;const i=t.type,s=this.painter,a=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(ba[i]&&(this._prevType&&ba[this._prevType]||this._stacks.push([]),this._prevType=i,this._stacks[this._stacks.length-1].push(t.id),!a))return !0;if(ba[this._prevType]||ba[i]&&a){this._prevType=i;const t=this._stacks.length-1,a=this._stacks[t]||[];for(const i of this._renderableTiles){if(this.pool.isFull()&&(ns(this.painter,this.terrain,this._rttTiles),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(i),i.rtt[t]){const e=this.pool.getObjectForId(i.rtt[t].id);if(e.stamp===i.rtt[t].stamp){this.pool.useObject(e);continue}}const o=this.pool.getOrCreateFreeObject();this.pool.useObject(o),this.pool.stampObject(o),i.rtt[t]={id:o.id,stamp:o.stamp},s.context.bindFramebuffer.set(o.fbo.framebuffer),s.context.clear({color:e.aO.transparent,stencil:0}),s.currentStencilSource=void 0;for(let t=0;t<a.length;t++){const e=s.style._layers[a[t]],r=e.source?this._coordsDescendingInv[e.source][i.tileID.key]:[i.tileID];s.context.viewport.set([0,0,o.fbo.width,o.fbo.height]),s._renderTileClippingMasks(e,r),s.renderLayer(s,s.style.sourceCaches[e.source],e,r),e.source&&(i.rttCoords[e.source]=this._coordsDescendingInvStr[e.source][i.tileID.key]);}}return ns(this.painter,this.terrain,this._rttTiles),this._rttTiles=[],this.pool.freeAllObjects(),ba[i]}return !1}}const Ta={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},Ia=i,Ea={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:_a,maplibreLogo:!1,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:e.a.MAX_TILE_CACHE_ZOOM_LEVELS,localIdeographFontFamily:"sans-serif",transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,validateStyle:!0,maxCanvasSize:[4096,4096]},Sa=t=>{t.touchstart=t.dragStart,t.touchmoveWindow=t.dragMove,t.touchend=t.dragEnd;},Ca={showCompass:!0,showZoom:!0,visualizePitch:!1};class Pa{constructor(t,i,s=!1){this.mousedown=t=>{this.startMouse(e.e({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),r.mousePos(this.element,t)),r.addEventListener(window,"mousemove",this.mousemove),r.addEventListener(window,"mouseup",this.mouseup);},this.mousemove=t=>{this.moveMouse(t,r.mousePos(this.element,t));},this.mouseup=t=>{this.mouseRotate.dragEnd(t),this.mousePitch&&this.mousePitch.dragEnd(t),this.offTemp();},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=r.touchPos(this.element,t.targetTouches)[0],this.startTouch(t,this._startPos),r.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),r.addEventListener(window,"touchend",this.touchend));},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=r.touchPos(this.element,t.targetTouches)[0],this.moveTouch(t,this._lastPos));},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp();},this.reset=()=>{this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),this.touchRotate.reset(),this.touchPitch&&this.touchPitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();},this._clickTolerance=10;const a=t.dragRotate._mouseRotate.getClickTolerance(),o=t.dragRotate._mousePitch.getClickTolerance();this.element=i,this.mouseRotate=Ns({clickTolerance:a,enable:!0}),this.touchRotate=(({enable:t,clickTolerance:e,bearingDegreesPerPixelMoved:i=.8})=>{const s=new Bs;return new Ls({clickTolerance:e,move:(t,e)=>({bearingDelta:(e.x-t.x)*i}),moveStateManager:s,enable:t,assignEvents:Sa})})({clickTolerance:a,enable:!0}),this.map=t,s&&(this.mousePitch=Us({clickTolerance:o,enable:!0}),this.touchPitch=(({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5})=>{const s=new Bs;return new Ls({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:s,enable:t,assignEvents:Sa})})({clickTolerance:o,enable:!0})),r.addEventListener(i,"mousedown",this.mousedown),r.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),r.addEventListener(i,"touchcancel",this.reset);}startMouse(t,e){this.mouseRotate.dragStart(t,e),this.mousePitch&&this.mousePitch.dragStart(t,e),r.disableDrag();}startTouch(t,e){this.touchRotate.dragStart(t,e),this.touchPitch&&this.touchPitch.dragStart(t,e),r.disableDrag();}moveMouse(t,e){const i=this.map,{bearingDelta:s}=this.mouseRotate.dragMove(t,e)||{};if(s&&i.setBearing(i.getBearing()+s),this.mousePitch){const{pitchDelta:s}=this.mousePitch.dragMove(t,e)||{};s&&i.setPitch(i.getPitch()+s);}}moveTouch(t,e){const i=this.map,{bearingDelta:s}=this.touchRotate.dragMove(t,e)||{};if(s&&i.setBearing(i.getBearing()+s),this.touchPitch){const{pitchDelta:s}=this.touchPitch.dragMove(t,e)||{};s&&i.setPitch(i.getPitch()+s);}}off(){const t=this.element;r.removeEventListener(t,"mousedown",this.mousedown),r.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),r.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),r.removeEventListener(window,"touchend",this.touchend),r.removeEventListener(t,"touchcancel",this.reset),this.offTemp();}offTemp(){r.enableDrag(),r.removeEventListener(window,"mousemove",this.mousemove),r.removeEventListener(window,"mouseup",this.mouseup),r.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),r.removeEventListener(window,"touchend",this.touchend);}}let Da;function za(t,i,s){const a=new e.M(t.lng,t.lat);if(t=new e.M(t.lng,t.lat),i){const a=new e.M(t.lng-360,t.lat),o=new e.M(t.lng+360,t.lat),r=s.locationPoint(t).distSqr(i);s.locationPoint(a).distSqr(i)<r?t=a:s.locationPoint(o).distSqr(i)<r&&(t=o);}for(;Math.abs(t.lng-s.center.lng)>180;){const e=s.locationPoint(t);if(e.x>=0&&e.y>=0&&e.x<=s.width&&e.y<=s.height)break;t.lng>s.center.lng?t.lng-=360:t.lng+=360;}return t.lng!==a.lng&&s.locationPoint(t).y>s.height/2-s.getHorizon()?t:a}const Ma={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Aa(t,e,i){const s=t.classList;for(const t in Ma)s.remove(`maplibregl-${i}-anchor-${t}`);s.add(`maplibregl-${i}-anchor-${e}`);}class Ra extends e.E{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup();},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup();},this._update=t=>{var e;if(!this._map)return;const i=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!i)&&this._map.once("render",this._update),this._lngLat=this._map.transform.renderWorldCopies?za(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationPoint(this._lngLat)._add(this._offset));let s="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?s=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(s=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let a="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?a="rotateX(0deg)":"map"===this._pitchAlignment&&(a=`rotateX(${this._map.getPitch()}deg)`),t&&"moveend"!==t.type||(this._pos=this._pos.round()),r.setTransform(this._element,`${Ma[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${a} ${s}`),o.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type);})).catch((()=>{}));},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e;}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new e.k("dragstart"))),this.fire(new e.k("drag")));},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new e.k("dragend")),this._state="inactive";},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(),this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=e.P.convert(t&&t.offset||[0,0]);else {this._defaultMarker=!0,this._element=r.create("div"),this._element.setAttribute("aria-label","Map marker");const i=r.createNS("http://www.w3.org/2000/svg","svg"),s=41,a=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${s}px`),i.setAttributeNS(null,"width",`${a}px`),i.setAttributeNS(null,"viewBox",`0 0 ${a} ${s}`);const o=r.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"stroke","none"),o.setAttributeNS(null,"stroke-width","1"),o.setAttributeNS(null,"fill","none"),o.setAttributeNS(null,"fill-rule","evenodd");const n=r.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"fill-rule","nonzero");const l=r.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const h=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of h){const e=r.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),l.appendChild(e);}const c=r.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const u=r.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(u);const d=r.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=r.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const p=r.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const m=r.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=r.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=r.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),m.appendChild(f),m.appendChild(g),n.appendChild(l),n.appendChild(c),n.appendChild(d),n.appendChild(p),n.appendChild(m),i.appendChild(n),i.setAttributeNS(null,"height",s*this._scale+"px"),i.setAttributeNS(null,"width",a*this._scale+"px"),this._element.appendChild(i),this._offset=e.P.convert(t&&t.offset||[0,-14]);}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault();})),this._element.addEventListener("mousedown",(t=>{t.preventDefault();})),Aa(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null;}addTo(t){return this.remove(),this._map=t,t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),r.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.M.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,s=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-e],"bottom-left":[s,-1*(e-i+s)],"bottom-right":[-s,-1*(e-i+s)],left:[i,-1*(e-i)],right:[-i,-1*(e-i)]}:this._offset;}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var i;if(!(null===(i=this._map)||void 0===i?void 0:i.terrain))return void(this._element.style.opacity!==this._opacity&&(this._element.style.opacity=this._opacity));if(t)this._opacityTimeout=null;else {if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null;}),100);}const s=this._map,a=s.terrain.depthAtPoint(this._pos),o=s.terrain.getElevationForLngLatZoom(this._lngLat,s.transform.tileZoom);if(s.transform.lngLatToCameraDepth(this._lngLat,o)-a<.006)return void(this._element.style.opacity=this._opacity);const r=-this._offset.y/s.transform._pixelPerMeter,n=Math.sin(s.getPitch()*Math.PI/180)*r,l=s.terrain.depthAtPoint(new e.P(this._pos.x,this._pos.y-this._offset.y)),h=s.transform.lngLatToCameraDepth(this._lngLat,o+n);this._element.style.opacity=h-l>.006?this._opacityWhenCovered:this._opacity;}getOffset(){return this._offset}setOffset(t){return this._offset=e.P.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t);}removeClassName(t){this._element.classList.remove(t);}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return void 0===t&&void 0===e&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const La={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let ka=0,Fa=!1;const Ba={maxWidth:100,unit:"metric"};function Oa(t,e,i){const s=i&&i.maxWidth||100,a=t._container.clientHeight/2,o=t.unproject([0,a]),r=t.unproject([s,a]),n=o.distanceTo(r);if(i&&"imperial"===i.unit){const i=3.2808*n;i>5280?Na(e,s,i/5280,t._getUIString("ScaleControl.Miles")):Na(e,s,i,t._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?Na(e,s,n/1852,t._getUIString("ScaleControl.NauticalMiles")):n>=1e3?Na(e,s,n/1e3,t._getUIString("ScaleControl.Kilometers")):Na(e,s,n,t._getUIString("ScaleControl.Meters"));}function Na(t,e,i,s){const a=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(a/i)+"px",t.innerHTML=`${a}&nbsp;${s}`;}const Ua={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1},Za=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Ga(t){if(t){if("number"==typeof t){const i=Math.round(Math.abs(t)/Math.SQRT2);return {center:new e.P(0,0),top:new e.P(0,t),"top-left":new e.P(i,i),"top-right":new e.P(-i,i),bottom:new e.P(0,-t),"bottom-left":new e.P(i,-i),"bottom-right":new e.P(-i,-i),left:new e.P(t,0),right:new e.P(-t,0)}}if(t instanceof e.P||Array.isArray(t)){const i=e.P.convert(t);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:e.P.convert(t.center||[0,0]),top:e.P.convert(t.top||[0,0]),"top-left":e.P.convert(t["top-left"]||[0,0]),"top-right":e.P.convert(t["top-right"]||[0,0]),bottom:e.P.convert(t.bottom||[0,0]),"bottom-left":e.P.convert(t["bottom-left"]||[0,0]),"bottom-right":e.P.convert(t["bottom-right"]||[0,0]),left:e.P.convert(t.left||[0,0]),right:e.P.convert(t.right||[0,0])}}return Ga(new e.P(0,0))}const ja=i;t.AJAXError=e.bd,t.Evented=e.E,t.LngLat=e.M,t.MercatorCoordinate=e.Y,t.Point=e.P,t.addProtocol=e.be,t.config=e.a,t.removeProtocol=e.bf,t.AttributionControl=pa,t.BoxZoomHandler=Ds,t.CanvasSource=tt,t.CooperativeGesturesHandler=na,t.DoubleClickZoomHandler=ea,t.DragPanHandler=aa,t.DragRotateHandler=oa,t.EdgeInsets=us,t.FullscreenControl=class extends e.E{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange();},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen();},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:e.w("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange");}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){r.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange);}_setupUI(){const t=this._fullscreenButton=r.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);r.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange);}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new e.k("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new e.k("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable());}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen();}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen();}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize();}},t.GeoJSONSource=K,t.GeolocateControl=class extends e.E{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new e.k("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new e.k("geolocate",t)),this._finish();}},this._updateCamera=t=>{const i=new e.M(t.coords.longitude,t.coords.latitude),s=t.coords.accuracy,a=this._map.getBearing(),o=e.e({bearing:a},this.options.fitBoundsOptions),r=V.fromLngLat(i,s);this._map.fitBounds(r,o,{geolocateSource:!0});},this._updateMarker=t=>{if(t){const i=new e.M(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();},this._onZoom=()=>{this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();},this._onError=t=>{if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===t.code&&Fa)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new e.k("error",t)),this._finish();}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;},this._setupUI=t=>{if(this._map){if(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=r.create("button","maplibregl-ctrl-geolocate",this._container),r.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",!1===t){e.w("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}else {const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=r.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new Ra({element:this._dotElement}),this._circleElement=r.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Ra({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new e.k("trackuserlocationend")));}));}},this.options=e.e({},La,t);}onAdd(t){return this._map=t,this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),function(t=!1){return e._(this,void 0,void 0,(function*(){if(void 0!==Da&&!t)return Da;if(void 0===window.navigator.permissions)return Da=!!window.navigator.geolocation,Da;try{const t=yield window.navigator.permissions.query({name:"geolocation"});Da="denied"!==t.state;}catch(t){Da=!!window.navigator.geolocation;}return Da}))}().then((t=>this._setupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),r.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,ka=0,Fa=!1;}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadius(){const t=this._map.getBounds(),e=t.getSouthEast(),i=t.getNorthEast(),s=e.distanceTo(i),a=Math.ceil(this._accuracy/(s/this._map._container.clientHeight)*2);this._circleElement.style.width=`${a}px`,this._circleElement.style.height=`${a}px`;}trigger(){if(!this._setup)return e.w("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new e.k("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":ka--,Fa=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new e.k("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new e.k("trackuserlocationstart"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),ka++,ka>1?(t={maximumAge:6e5,timeout:0},Fa=!0):(t=this.options.positionOptions,Fa=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t);}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},t.Hash=ps,t.ImageSource=J,t.KeyboardHandler=Ys,t.LngLatBounds=V,t.LogoControl=ma,t.Map=class extends da{constructor(t){if(e.bb.mark(e.bc.create),null!=(t=e.e({},Ea,t)).minZoom&&null!=t.maxZoom&&t.minZoom>t.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=t.minPitch&&null!=t.maxPitch&&t.minPitch>t.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=t.minPitch&&t.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=t.maxPitch&&t.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new ds(t.minZoom,t.maxZoom,t.minPitch,t.maxPitch,t.renderWorldCopies),{bearingSnap:t.bearingSnap}),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new e.k("webglcontextlost",{originalEvent:t}));},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new e.k("webglcontextrestored",{originalEvent:t}));},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update();},this._interactive=t.interactive,this._maxTileCacheSize=t.maxTileCacheSize,this._maxTileCacheZoomLevels=t.maxTileCacheZoomLevels,this._failIfMajorPerformanceCaveat=t.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=t.preserveDrawingBuffer,this._antialias=t.antialias,this._trackResize=t.trackResize,this._bearingSnap=t.bearingSnap,this._refreshExpiredTiles=t.refreshExpiredTiles,this._fadeDuration=t.fadeDuration,this._crossSourceCollisions=t.crossSourceCollisions,this._crossFadingFactor=1,this._collectResourceTiming=t.collectResourceTiming,this._renderTaskQueue=new fa,this._controls=[],this._mapId=e.a3(),this._locale=e.e({},Ta,t.locale),this._clickTolerance=t.clickTolerance,this._overridePixelRatio=t.pixelRatio,this._maxCanvasSize=t.maxCanvasSize,this.transformCameraUpdate=t.transformCameraUpdate,this._imageQueueHandle=_.addThrottleControl((()=>this.isMoving())),this._requestManager=new m(t.transformRequest),"string"==typeof t.container){if(this._container=document.getElementById(t.container),!this._container)throw new Error(`Container '${t.container}' not found.`)}else {if(!(t.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=t.container;}if(t.maxBounds&&this.setMaxBounds(t.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0);})),this.once("idle",(()=>{this._idleTriggered=!0;})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=_s((t=>{this._trackResize&&!this._removed&&this.resize(t)._update();}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0;})),this._resizeObserver.observe(this._container);}this.handlers=new ua(this,t),this._hash=t.hash&&new ps("string"==typeof t.hash&&t.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:t.center,zoom:t.zoom,bearing:t.bearing,pitch:t.pitch}),t.bounds&&(this.resize(),this.fitBounds(t.bounds,e.e({},t.fitBoundsOptions,{duration:0})))),this.resize(),this._localIdeographFontFamily=t.localIdeographFontFamily,this._validateStyle=t.validateStyle,t.style&&this.setStyle(t.style,{localIdeographFontFamily:t.localIdeographFontFamily}),t.attributionControl&&this.addControl(new pa("boolean"==typeof t.attributionControl?void 0:t.attributionControl)),t.maplibreLogo&&this.addControl(new ma,t.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new e.k(`${t.dataType}data`,t));})),this.on("dataloading",(t=>{this.fire(new e.k(`${t.dataType}dataloading`,t));})),this.on("dataabort",(t=>{this.fire(new e.k("sourcedataabort",t));}));}_getMapId(){return this._mapId}addControl(t,i){if(void 0===i&&(i=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new e.j(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const s=t.onAdd(this);this._controls.push(t);const a=this._controlPositions[i];return -1!==i.indexOf("bottom")?a.insertBefore(s,a.firstChild):a.appendChild(s),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new e.j(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(t);return i>-1&&this._controls.splice(i,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}calculateCameraOptionsFromTo(t,e,i,s){return null==s&&this.terrain&&(s=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,s)}resize(t){var i;const s=this._containerDimensions(),a=s[0],o=s[1],r=this._getClampedPixelRatio(a,o);if(this._resizeCanvas(a,o,r),this.painter.resize(a,o,r),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(a,o);this._resizeCanvas(a,o,e),this.painter.resize(a,o,e);}this.transform.resize(a,o),null===(i=this._requestedCameraState)||void 0===i||i.resize(a,o);const n=!this._moving;return n&&(this.stop(),this.fire(new e.k("movestart",t)).fire(new e.k("move",t))),this.fire(new e.k("resize",t)),n&&this.fire(new e.k("moveend",t)),this}_getClampedPixelRatio(t,e){const{0:i,1:s}=this._maxCanvasSize,a=this.getPixelRatio(),o=t*a,r=e*a;return Math.min(o>i?i/o:1,r>s?s/r:1)*a}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize();}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(V.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.minZoom=t,this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.maxZoom=t,this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.minPitch=t,this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>85)throw new Error("maxPitch must be less than or equal to 85");if(t>=this.transform.minPitch)return this.transform.maxPitch=t,this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.renderWorldCopies=t,this._update()}project(t){return this.transform.locationPoint(e.M.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.pointLocation(e.P.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let s=!1;const a=a=>{const o=this.getLayer(e)?this.queryRenderedFeatures(a.point,{layers:[e]}):[];o.length?s||(s=!0,i.call(this,new Ts(t,this,a.originalEvent,{features:o}))):s=!1;};return {layer:e,listener:i,delegates:{mousemove:a,mouseout:()=>{s=!1;}}}}if("mouseleave"===t||"mouseout"===t){let s=!1;const a=a=>{(this.getLayer(e)?this.queryRenderedFeatures(a.point,{layers:[e]}):[]).length?s=!0:s&&(s=!1,i.call(this,new Ts(t,this,a.originalEvent)));},o=e=>{s&&(s=!1,i.call(this,new Ts(t,this,e.originalEvent)));};return {layer:e,listener:i,delegates:{mousemove:a,mouseout:o}}}{const s=t=>{const s=this.getLayer(e)?this.queryRenderedFeatures(t.point,{layers:[e]}):[];s.length&&(t.features=s,i.call(this,t),delete t.features);};return {layer:e,listener:i,delegates:{[t]:s}}}}on(t,e,i){if(void 0===i)return super.on(t,e);const s=this._createDelegatedListener(t,e,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(s);for(const t in s.delegates)this.on(t,s.delegates[t]);return this}once(t,e,i){if(void 0===i)return super.once(t,e);const s=this._createDelegatedListener(t,e,i);for(const t in s.delegates)this.once(t,s.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._delegatedListeners&&this._delegatedListeners[t]&&(s=>{const a=this._delegatedListeners[t];for(let t=0;t<a.length;t++){const s=a[t];if(s.layer===e&&s.listener===i){for(const t in s.delegates)this.off(t,s.delegates[t]);return a.splice(t,1),this}}})(),this)}queryRenderedFeatures(t,i){if(!this.style)return [];let s;const a=t instanceof e.P||Array.isArray(t),o=a?t:[[0,0],[this.transform.width,this.transform.height]];if(i=i||(a?{}:t)||{},o instanceof e.P||"number"==typeof o[0])s=[e.P.convert(o)];else {const t=e.P.convert(o[0]),i=e.P.convert(o[1]);s=[t,new e.P(i.x,t.y),i,new e.P(t.x,i.y),t];}return this.style.queryRenderedFeatures(s,i,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,i){return !1!==(i=e.e({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(t,i))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const i=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new he(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,i):this.style.loadJSON(t,e,i),this):(delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new he(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(t,i){if("string"==typeof t){const s=this._requestManager.transformRequest(t,p.Style);e.h(s,new AbortController).then((t=>{this._updateDiff(t.data,i);})).catch((t=>{t&&this.fire(new e.j(t));}));}else "object"==typeof t&&this._updateDiff(t,i);}_updateDiff(t,i){try{this.style.setState(t,i)&&this._update(!0);}catch(s){e.w(`Unable to perform style diff: ${s.message||s.error||s}.  Rebuilding the style from scratch.`),this._updateStyle(t,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():e.w("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const i=this.style&&this.style.sourceCaches[t];if(void 0!==i)return i.loaded();this.fire(new e.j(new Error(`There is no source with ID '${t}'`)));}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const i=this.style.sourceCaches[t.source];if(!i)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&i.reload();for(const i in this.style._layers){const s=this.style._layers[i];"hillshade"===s.type&&s.source===t.source&&e.w("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.");}this.terrain=new xa(this.painter,i,t),this.painter.renderToTexture=new wa(this.painter,this.terrain),this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this._terrainDataCallback=e=>{"style"===e.dataType?this.terrain.sourceCache.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.terrain.sourceCache.freeRtt(e.tile.tileID));},this.style.on("data",this._terrainDataCallback);}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.minElevationForCurrentTile=0,this.transform.elevation=0;return this.fire(new e.k("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}}return !0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}addImage(t,i,s={}){const{pixelRatio:a=1,sdf:r=!1,stretchX:n,stretchY:l,content:h}=s;if(this._lazyInitEmptyStyle(),!(i instanceof HTMLImageElement||e.b(i))){if(void 0===i.width||void 0===i.height)return this.fire(new e.j(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:s,height:o,data:c}=i,u=i;return this.style.addImage(t,{data:new e.R({width:s,height:o},new Uint8Array(c)),pixelRatio:a,stretchX:n,stretchY:l,content:h,sdf:r,version:0,userImage:u}),u.onAdd&&u.onAdd(this,t),this}}{const{width:s,height:c,data:u}=o.getImageData(i);this.style.addImage(t,{data:new e.R({width:s,height:c},u),pixelRatio:a,stretchX:n,stretchY:l,content:h,sdf:r,version:0});}}updateImage(t,i){const s=this.style.getImage(t);if(!s)return this.fire(new e.j(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const a=i instanceof HTMLImageElement||e.b(i)?o.getImageData(i):i,{width:r,height:n,data:l}=a;if(void 0===r||void 0===n)return this.fire(new e.j(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(r!==s.data.width||n!==s.data.height)return this.fire(new e.j(new Error("The width and height of the updated image must be that same as the previous version of the image")));const h=!(i instanceof HTMLImageElement||e.b(i));return s.data.replace(l,h),this.style.updateImage(t,s),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new e.j(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t);}loadImage(t){return _.getImage(this._requestManager.transformRequest(t,p.Image),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,s={}){return this.style.setPaintProperty(t,e,i,s),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,s={}){return this.style.setLayoutProperty(t,e,i,s),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0);})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0);})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=r.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=r.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label","Map"),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),s=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],s);const a=this._controlContainer=r.create("div","maplibregl-control-container",t),o=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{o[t]=r.create("div",`maplibregl-ctrl-${t} `,a);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`;}_setupPainter(){const t={alpha:!0,stencil:!0,depth:!0,failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1};let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type);}),{once:!0});const i=this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t);if(!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new ls(i,this.transform),n.testSupport(i);}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t);}_render(t){const i=this._idleTriggered?this._fadeDuration:0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let s=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,a=o.now();this.style.zoomHistory.update(t,a);const r=new e.a8(t,{now:a,fadeDuration:i,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),n=r.crossFadingFactor();1===n&&n===this._crossFadingFactor||(s=!0,this._crossFadingFactor=n),this.style.update(r);}this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.minElevationForCurrentTile=this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom),this._elevationFreeze||(this.transform.elevation=this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.minElevationForCurrentTile=0,this.transform.elevation=0),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,i,this._crossSourceCollisions),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:i,showPadding:this.showPadding}),this.fire(new e.k("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,e.bb.mark(e.bc.load),this.fire(new e.k("load"))),this.style&&(this.style.hasTransitions()||s)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const a=this._sourcesDirty||this._styleDirty||this._placementDirty;return a||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new e.k("idle")),!this._loaded||this._fullyLoaded||a||(this._fullyLoaded=!0,e.bb.mark(e.bc.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),_.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const i=this.painter.context.gl.getExtension("WEBGL_lose_context");i&&i.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),r.remove(this._canvasContainer),r.remove(this._controlContainer),this._container.classList.remove("maplibregl-map"),e.bb.clearMetrics(),this._removed=!0,this.fire(new e.k("remove"));}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,o.frameAsync(this._frameRequest).then((t=>{e.bb.frame(t),this._frameRequest=null,this._render(t);})).catch((()=>{})));}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update());}get showPadding(){return !!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update());}get repaint(){return !!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(t){this._vertices=t,this._update();}get version(){return Ia}getCameraTargetElevation(){return this.transform.elevation}},t.MapMouseEvent=Ts,t.MapTouchEvent=Is,t.MapWheelEvent=Es,t.Marker=Ra,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());},this._rotateCompassArrow=()=>{const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._compassIcon.style.transform=t;},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i);},this.options=e.e({},Ca,t),this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),r.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),r.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t});})),this._compassIcon=r.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"));}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new Pa(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){r.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(t,e){const i=r.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Popup=class extends e.E{constructor(t){super(),this.remove=()=>(this._content&&r.remove(this._content),this._container&&(r.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map),this.fire(new e.k("close")),this),this._onMouseUp=t=>{this._update(t.point);},this._onMouseMove=t=>{this._update(t.point);},this._onDrag=t=>{this._update(t.point);},this._update=t=>{var e;if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=r.create("div","maplibregl-popup",this._map.getContainer()),this._tip=r.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer");}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=this._map.transform.renderWorldCopies&&!this._trackPointer?za(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._trackPointer&&!t)return;const i=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationPoint(this._lngLat));let s=this.options.anchor;const a=Ga(this.options.offset);if(!s){const t=this._container.offsetWidth,e=this._container.offsetHeight;let o;o=i.y+a.bottom.y<e?["top"]:i.y>this._map.transform.height-e?["bottom"]:[],i.x<t/2?o.push("left"):i.x>this._map.transform.width-t/2&&o.push("right"),s=0===o.length?"bottom":o.join("-");}let o=i.add(a[s]);this.options.subpixelPositioning||(o=o.round()),r.setTransform(this._container,`${Ma[s]} translate(${o.x}px,${o.y}px)`),Aa(this._container,s,"popup");},this._onClose=()=>{this.remove();},this.options=e.e(Object.create(Ua),t);}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new e.k("open")),this}isOpen(){return !!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.M.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let s;for(i.innerHTML=t;s=i.firstChild,s;)e.appendChild(s);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=r.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){this._container&&this._container.classList.add(t);}removeClassName(t){this._container&&this._container.classList.remove(t);}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t;}_createCloseButton(){this.options.closeButton&&(this._closeButton=r.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.setAttribute("aria-label","Close popup"),this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(Za);t&&t.focus();}},t.RasterDEMTileSource=X,t.RasterTileSource=$,t.ScaleControl=class{constructor(t){this._onMove=()=>{Oa(this._map,this._container,this.options);},this.setUnit=t=>{this.options.unit=t,Oa(this._map,this._container,this.options);},this.options=e.e({},Ba,t);}getDefaultPosition(){return "bottom-left"}onAdd(t){return this._map=t,this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){r.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}},t.ScrollZoomHandler=ta,t.Style=he,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon();},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"));},this.options=t;}onAdd(t){return this._map=t,this._container=r.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=r.create("button","maplibregl-ctrl-terrain",this._container),r.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){r.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0;}},t.TwoFingersTouchPitchHandler=Xs,t.TwoFingersTouchRotateHandler=Hs,t.TwoFingersTouchZoomHandler=Vs,t.TwoFingersTouchZoomRotateHandler=ra,t.VectorTileSource=H,t.VideoSource=Q,t.addSourceType=(t,i)=>e._(void 0,void 0,void 0,(function*(){if(it(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{et[t]=e;})(t,i);})),t.clearPrewarmedResources=function(){const t=F;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(R),F=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},t.getMaxParallelImageRequests=function(){return e.a.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return ot().getRTLTextPluginStatus()},t.getVersion=function(){return ja},t.getWorkerCount=function(){return L.workerCount},t.getWorkerUrl=function(){return e.a.WORKER_URL},t.importScriptInWorkers=function(t){return U().broadcast("importScript",t)},t.prewarm=function(){O().acquire(R);},t.setMaxParallelImageRequests=function(t){e.a.MAX_PARALLEL_IMAGE_REQUESTS=t;},t.setRTLTextPlugin=function(t,e){return ot().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){L.workerCount=t;},t.setWorkerUrl=function(t){e.a.WORKER_URL=t;};}));

//
// Our custom intro provides a specialized "define()" function, called by the
// AMD modules below, that sets up the worker blob URL and then executes the
// main module, storing its exported value as 'maplibregl'


var maplibregl$1 = maplibregl;

return maplibregl$1;

}));
//# sourceMappingURL=maplibre-gl.js.map
