/*! For license information please see maplibre-gl-measures.js.LICENSE.txt */
let lineIcon = '<svg  version="1.1" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g transform="translate(-45)"><g transform="translate(45 .202)" stroke="#ffffff" stroke-linecap="square" stroke-miterlimit="43.3"><ellipse cx="2.47" cy="21.3" rx="2.3" ry="2.3" fill-rule="evenodd" stroke-width=".339" style="paint-order:fill markers stroke"/><circle cx="21.5" cy="2.26" r="2.3" fill-rule="evenodd" stroke-width=".339" style="paint-order:fill markers stroke"/><path d="m2.63 21.3 18.9-18.9" fill="none" stroke-dasharray="1,3" stroke-width="1.5" style="paint-order:fill markers stroke"/></g></g></svg>';

let polygonIcon = '<svg version="1.1" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g transform="translate(-45)"> <g transform="translate(45 .202)" stroke="#fff" stroke-linecap="square" stroke-miterlimit="43.3">  <g fill-rule="evenodd">   <ellipse cx="2.47" cy="20.2" rx="2.3" ry="2.3" stroke-width=".339" style="paint-order:fill markers stroke"/>   <circle cx="21.5" cy="20.2" r="2.3" stroke-width=".339" style="paint-order:fill markers stroke"/>   <circle cx="12.1" cy="3.54" r="2.3" stroke-width=".339" style="paint-order:fill markers stroke"/>  </g>  <g fill="none" stroke-dasharray="1,3" stroke-width="1.5">   <path d="m2.36 20.3 9.8-16.7" style="paint-order:fill markers stroke"/> <path d="m21.5 20.2-9.56-16.8" style="paint-order:fill markers stroke"/>   <path d="m2.53 20.3 19-0.086" style="paint-order:fill markers stroke"/>  </g> </g></g></svg>';

let eraseIcon = '<svg version="1.1" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><g transform="translate(-135)"> <g transform="translate(45 .202)" fill-rule="evenodd" stroke="#fff" stroke-linecap="square" stroke-miterlimit="43.3" stroke-width="1.5">  <rect transform="rotate(45)" x="75.6" y="-58.9" width="9.81" height="4.51" ry="0" style="paint-order:fill markers stroke" fill="#fff"/>  <rect transform="rotate(45)" x="75.6" y="-73.2" width="9.7" height="14.2" ry="0" fill="#000" style="paint-order:fill markers stroke"/> </g></g></svg>'

var maplibreGLMeasures;(()=>{var t={1307:function(t,e,n){t.exports=function(){"use strict";var t=function(t,e){var n={drag:[],click:[],mousemove:[],mousedown:[],mouseup:[],mouseout:[],keydown:[],keyup:[],touchstart:[],touchmove:[],touchend:[],tap:[]},r={on:function(t,e,r){if(void 0===n[t])throw new Error("Invalid event type: "+t);n[t].push({selector:e,fn:r})},render:function(t){e.store.featureChanged(t)}},i=function(t,i){for(var o=n[t],s=o.length;s--;){var a=o[s];if(a.selector(i)){a.fn.call(r,i)||e.store.render(),e.ui.updateMapClasses();break}}};return t.start.call(r),{render:t.render,stop:function(){t.stop&&t.stop()},trash:function(){t.trash&&(t.trash(),e.store.render())},combineFeatures:function(){t.combineFeatures&&t.combineFeatures()},uncombineFeatures:function(){t.uncombineFeatures&&t.uncombineFeatures()},drag:function(t){i("drag",t)},click:function(t){i("click",t)},mousemove:function(t){i("mousemove",t)},mousedown:function(t){i("mousedown",t)},mouseup:function(t){i("mouseup",t)},mouseout:function(t){i("mouseout",t)},keydown:function(t){i("keydown",t)},keyup:function(t){i("keyup",t)},touchstart:function(t){i("touchstart",t)},touchmove:function(t){i("touchmove",t)},touchend:function(t){i("touchend",t)},tap:function(t){i("tap",t)}}},e=6378137;function r(t){var e=0;if(t&&t.length>0){e+=Math.abs(i(t[0]));for(var n=1;n<t.length;n++)e-=Math.abs(i(t[n]))}return e}function i(t){var n,r,i,s,a,u,l=0,c=t.length;if(c>2){for(u=0;u<c;u++)u===c-2?(i=c-2,s=c-1,a=0):u===c-1?(i=c-1,s=0,a=1):(i=u,s=u+1,a=u+2),n=t[i],r=t[s],l+=(o(t[a][0])-o(n[0]))*Math.sin(o(r[1]));l=l*e*e/2}return l}function o(t){return t*Math.PI/180}var s=function t(e){var n,i=0;switch(e.type){case"Polygon":return r(e.coordinates);case"MultiPolygon":for(n=0;n<e.coordinates.length;n++)i+=r(e.coordinates[n]);return i;case"Point":case"MultiPoint":case"LineString":case"MultiLineString":return 0;case"GeometryCollection":for(n=0;n<e.geometries.length;n++)i+=t(e.geometries[n]);return i}},a="active",u="mapbox-gl-draw-hot",l="mapbox-gl-draw-cold",c="add",h="move",p="pointer",f="none",g={POLYGON:"polygon",LINE:"line_string",POINT:"point"},d="Feature",y="Polygon",_="LineString",m="Point",v="FeatureCollection",x="Multi",b={DRAW_LINE_STRING:"draw_line_string",DRAW_POLYGON:"draw_polygon",DRAW_POINT:"draw_point",SIMPLE_SELECT:"simple_select",DIRECT_SELECT:"direct_select",STATIC:"static"},E="draw.create",I="draw.update",C="feature",S="midpoint",w="vertex",N="true",M="false",L=["scrollZoom","boxZoom","dragRotate","dragPan","keyboard","doubleClickZoom","touchZoomRotate"],P={Point:0,LineString:1,Polygon:2};function O(t,e){var n=P[t.geometry.type]-P[e.geometry.type];return 0===n&&t.geometry.type===y?t.area-e.area:n}function R(t){if(this._items={},this._nums={},this._length=t?t.length:0,t)for(var e=0,n=t.length;e<n;e++)this.add(t[e]),void 0!==t[e]&&("string"==typeof t[e]?this._items[t[e]]=e:this._nums[t[e]]=e)}R.prototype.add=function(t){return this.has(t)||(this._length++,"string"==typeof t?this._items[t]=this._length:this._nums[t]=this._length),this},R.prototype.delete=function(t){return!1===this.has(t)||(this._length--,delete this._items[t],delete this._nums[t]),this},R.prototype.has=function(t){return!("string"!=typeof t&&"number"!=typeof t||void 0===this._items[t]&&void 0===this._nums[t])},R.prototype.values=function(){var t=this,e=[];return Object.keys(this._items).forEach((function(n){e.push({k:n,v:t._items[n]})})),Object.keys(this._nums).forEach((function(n){e.push({k:JSON.parse(n),v:t._nums[n]})})),e.sort((function(t,e){return t.v-e.v})).map((function(t){return t.k}))},R.prototype.clear=function(){return this._length=0,this._items={},this._nums={},this};var T=[C,S,w],A={click:function(t,e,n){return D(t,e,n,n.options.clickBuffer)},touch:function(t,e,n){return D(t,e,n,n.options.touchBuffer)}};function D(t,e,n,r){if(null===n.map)return[];var i=t?function(t,e){return void 0===e&&(e=0),[[t.point.x-e,t.point.y-e],[t.point.x+e,t.point.y+e]]}(t,r):e,o={};n.options.styles&&(o.layers=n.options.styles.map((function(t){return t.id})));var a=n.map.queryRenderedFeatures(i,o).filter((function(t){return-1!==T.indexOf(t.properties.meta)})),u=new R,l=[];return a.forEach((function(t){var e=t.properties.id;u.has(e)||(u.add(e),l.push(t))})),function(t){return t.map((function(t){return t.geometry.type===y&&(t.area=s({type:d,property:{},geometry:t.geometry})),t})).sort(O).map((function(t){return delete t.area,t}))}(l)}function F(t,e){var n=A.click(t,null,e),r={mouse:f};return n[0]&&(r.mouse=n[0].properties.active===N?h:p,r.feature=n[0].properties.meta),-1!==e.events.currentModeName().indexOf("draw")&&(r.mouse=c),e.ui.queueMapClasses(r),e.ui.updateMapClasses(),n[0]}function k(t,e){var n=t.x-e.x,r=t.y-e.y;return Math.sqrt(n*n+r*r)}function G(t,e,n){void 0===n&&(n={});var r=null!=n.fineTolerance?n.fineTolerance:4,i=null!=n.grossTolerance?n.grossTolerance:12,o=null!=n.interval?n.interval:500;t.point=t.point||e.point,t.time=t.time||e.time;var s=k(t.point,e.point);return s<r||s<i&&e.time-t.time<o}function B(t,e,n){void 0===n&&(n={});var r=null!=n.tolerance?n.tolerance:25,i=null!=n.interval?n.interval:250;return t.point=t.point||e.point,t.time=t.time||e.time,k(t.point,e.point)<r&&e.time-t.time<i}function j(t,e){return t(e={exports:{}},e.exports),e.exports}var U=j((function(t){var e=t.exports=function(t,n){if(n||(n=16),void 0===t&&(t=128),t<=0)return"0";for(var r=Math.log(Math.pow(2,t))/Math.log(n),i=2;r===1/0;i*=2)r=Math.log(Math.pow(2,t/i))/Math.log(n)*i;var o=r-Math.floor(r),s="";for(i=0;i<Math.floor(r);i++)s=Math.floor(Math.random()*n).toString(n)+s;if(o){var a=Math.pow(n,o);s=Math.floor(Math.random()*a).toString(n)+s}var u=parseInt(s,n);return u!==1/0&&u>=Math.pow(2,t)?e(t,n):s};e.rack=function(t,n,r){var i=function(i){var s=0;do{if(s++>10){if(!r)throw new Error("too many ID collisions, use more bits");t+=r}var a=e(t,n)}while(Object.hasOwnProperty.call(o,a));return o[a]=i,a},o=i.hats={};return i.get=function(t){return i.hats[t]},i.set=function(t,e){return i.hats[t]=e,i},i.bits=t||128,i.base=n||16,i}})),q=function(t,e){this.ctx=t,this.properties=e.properties||{},this.coordinates=e.geometry.coordinates,this.id=e.id||U(),this.type=e.geometry.type};q.prototype.changed=function(){this.ctx.store.featureChanged(this.id)},q.prototype.incomingCoords=function(t){this.setCoordinates(t)},q.prototype.setCoordinates=function(t){this.coordinates=t,this.changed()},q.prototype.getCoordinates=function(){return JSON.parse(JSON.stringify(this.coordinates))},q.prototype.setProperty=function(t,e){this.properties[t]=e},q.prototype.toGeoJSON=function(){return JSON.parse(JSON.stringify({id:this.id,type:d,properties:this.properties,geometry:{coordinates:this.getCoordinates(),type:this.type}}))},q.prototype.internal=function(t){var e={id:this.id,meta:C,"meta:type":this.type,active:M,mode:t};if(this.ctx.options.userProperties)for(var n in this.properties)e["user_"+n]=this.properties[n];return{type:d,properties:e,geometry:{coordinates:this.getCoordinates(),type:this.type}}};var z=function(t,e){q.call(this,t,e)};(z.prototype=Object.create(q.prototype)).isValid=function(){return"number"==typeof this.coordinates[0]&&"number"==typeof this.coordinates[1]},z.prototype.updateCoordinate=function(t,e,n){this.coordinates=3===arguments.length?[e,n]:[t,e],this.changed()},z.prototype.getCoordinate=function(){return this.getCoordinates()};var V=function(t,e){q.call(this,t,e)};(V.prototype=Object.create(q.prototype)).isValid=function(){return this.coordinates.length>1},V.prototype.addCoordinate=function(t,e,n){this.changed();var r=parseInt(t,10);this.coordinates.splice(r,0,[e,n])},V.prototype.getCoordinate=function(t){var e=parseInt(t,10);return JSON.parse(JSON.stringify(this.coordinates[e]))},V.prototype.removeCoordinate=function(t){this.changed(),this.coordinates.splice(parseInt(t,10),1)},V.prototype.updateCoordinate=function(t,e,n){var r=parseInt(t,10);this.coordinates[r]=[e,n],this.changed()};var Y=function(t,e){q.call(this,t,e),this.coordinates=this.coordinates.map((function(t){return t.slice(0,-1)}))};(Y.prototype=Object.create(q.prototype)).isValid=function(){return 0!==this.coordinates.length&&this.coordinates.every((function(t){return t.length>2}))},Y.prototype.incomingCoords=function(t){this.coordinates=t.map((function(t){return t.slice(0,-1)})),this.changed()},Y.prototype.setCoordinates=function(t){this.coordinates=t,this.changed()},Y.prototype.addCoordinate=function(t,e,n){this.changed();var r=t.split(".").map((function(t){return parseInt(t,10)}));this.coordinates[r[0]].splice(r[1],0,[e,n])},Y.prototype.removeCoordinate=function(t){this.changed();var e=t.split(".").map((function(t){return parseInt(t,10)})),n=this.coordinates[e[0]];n&&(n.splice(e[1],1),n.length<3&&this.coordinates.splice(e[0],1))},Y.prototype.getCoordinate=function(t){var e=t.split(".").map((function(t){return parseInt(t,10)})),n=this.coordinates[e[0]];return JSON.parse(JSON.stringify(n[e[1]]))},Y.prototype.getCoordinates=function(){return this.coordinates.map((function(t){return t.concat([t[0]])}))},Y.prototype.updateCoordinate=function(t,e,n){this.changed();var r=t.split("."),i=parseInt(r[0],10),o=parseInt(r[1],10);void 0===this.coordinates[i]&&(this.coordinates[i]=[]),this.coordinates[i][o]=[e,n]};var X={MultiPoint:z,MultiLineString:V,MultiPolygon:Y},W=function(t,e,n,r,i){var o=n.split("."),s=parseInt(o[0],10),a=o[1]?o.slice(1).join("."):null;return t[s][e](a,r,i)},H=function(t,e){if(q.call(this,t,e),delete this.coordinates,this.model=X[e.geometry.type],void 0===this.model)throw new TypeError(e.geometry.type+" is not a valid type");this.features=this._coordinatesToFeatures(e.geometry.coordinates)};function K(t){this.map=t.map,this.drawConfig=JSON.parse(JSON.stringify(t.options||{})),this._ctx=t}(H.prototype=Object.create(q.prototype))._coordinatesToFeatures=function(t){var e=this,n=this.model.bind(this);return t.map((function(t){return new n(e.ctx,{id:U(),type:d,properties:{},geometry:{coordinates:t,type:e.type.replace("Multi","")}})}))},H.prototype.isValid=function(){return this.features.every((function(t){return t.isValid()}))},H.prototype.setCoordinates=function(t){this.features=this._coordinatesToFeatures(t),this.changed()},H.prototype.getCoordinate=function(t){return W(this.features,"getCoordinate",t)},H.prototype.getCoordinates=function(){return JSON.parse(JSON.stringify(this.features.map((function(t){return t.type===y?t.getCoordinates():t.coordinates}))))},H.prototype.updateCoordinate=function(t,e,n){W(this.features,"updateCoordinate",t,e,n),this.changed()},H.prototype.addCoordinate=function(t,e,n){W(this.features,"addCoordinate",t,e,n),this.changed()},H.prototype.removeCoordinate=function(t){W(this.features,"removeCoordinate",t),this.changed()},H.prototype.getFeatures=function(){return this.features},K.prototype.setSelected=function(t){return this._ctx.store.setSelected(t)},K.prototype.setSelectedCoordinates=function(t){var e=this;this._ctx.store.setSelectedCoordinates(t),t.reduce((function(t,n){return void 0===t[n.feature_id]&&(t[n.feature_id]=!0,e._ctx.store.get(n.feature_id).changed()),t}),{})},K.prototype.getSelected=function(){return this._ctx.store.getSelected()},K.prototype.getSelectedIds=function(){return this._ctx.store.getSelectedIds()},K.prototype.isSelected=function(t){return this._ctx.store.isSelected(t)},K.prototype.getFeature=function(t){return this._ctx.store.get(t)},K.prototype.select=function(t){return this._ctx.store.select(t)},K.prototype.deselect=function(t){return this._ctx.store.deselect(t)},K.prototype.deleteFeature=function(t,e){return void 0===e&&(e={}),this._ctx.store.delete(t,e)},K.prototype.addFeature=function(t){return this._ctx.store.add(t)},K.prototype.clearSelectedFeatures=function(){return this._ctx.store.clearSelected()},K.prototype.clearSelectedCoordinates=function(){return this._ctx.store.clearSelectedCoordinates()},K.prototype.setActionableState=function(t){void 0===t&&(t={});var e={trash:t.trash||!1,combineFeatures:t.combineFeatures||!1,uncombineFeatures:t.uncombineFeatures||!1};return this._ctx.events.actionable(e)},K.prototype.changeMode=function(t,e,n){return void 0===e&&(e={}),void 0===n&&(n={}),this._ctx.events.changeMode(t,e,n)},K.prototype.updateUIClasses=function(t){return this._ctx.ui.queueMapClasses(t)},K.prototype.activateUIButton=function(t){return this._ctx.ui.setActiveButton(t)},K.prototype.featuresAt=function(t,e,n){if(void 0===n&&(n="click"),"click"!==n&&"touch"!==n)throw new Error("invalid buffer type");return A[n](t,e,this._ctx)},K.prototype.newFeature=function(t){var e=t.geometry.type;return e===m?new z(this._ctx,t):e===_?new V(this._ctx,t):e===y?new Y(this._ctx,t):new H(this._ctx,t)},K.prototype.isInstanceOf=function(t,e){if(t===m)return e instanceof z;if(t===_)return e instanceof V;if(t===y)return e instanceof Y;if("MultiFeature"===t)return e instanceof H;throw new Error("Unknown feature class: "+t)},K.prototype.doRender=function(t){return this._ctx.store.featureChanged(t)},K.prototype.onSetup=function(){},K.prototype.onDrag=function(){},K.prototype.onClick=function(){},K.prototype.onMouseMove=function(){},K.prototype.onMouseDown=function(){},K.prototype.onMouseUp=function(){},K.prototype.onMouseOut=function(){},K.prototype.onKeyUp=function(){},K.prototype.onKeyDown=function(){},K.prototype.onTouchStart=function(){},K.prototype.onTouchMove=function(){},K.prototype.onTouchEnd=function(){},K.prototype.onTap=function(){},K.prototype.onStop=function(){},K.prototype.onTrash=function(){},K.prototype.onCombineFeature=function(){},K.prototype.onUncombineFeature=function(){},K.prototype.toDisplayFeatures=function(){throw new Error("You must overwrite toDisplayFeatures")};var J={drag:"onDrag",click:"onClick",mousemove:"onMouseMove",mousedown:"onMouseDown",mouseup:"onMouseUp",mouseout:"onMouseOut",keyup:"onKeyUp",keydown:"onKeyDown",touchstart:"onTouchStart",touchmove:"onTouchMove",touchend:"onTouchEnd",tap:"onTap"},Z=Object.keys(J);function $(t){return[].concat(t).filter((function(t){return void 0!==t}))}function Q(){var t=this;if(!t.ctx.map||void 0===t.ctx.map.getSource(u))return c();var e=t.ctx.events.currentModeName();t.ctx.ui.queueMapClasses({mode:e});var n=[],r=[];t.isDirty?r=t.getAllIds():(n=t.getChangedIds().filter((function(e){return void 0!==t.get(e)})),r=t.sources.hot.filter((function(e){return e.properties.id&&-1===n.indexOf(e.properties.id)&&void 0!==t.get(e.properties.id)})).map((function(t){return t.properties.id}))),t.sources.hot=[];var i=t.sources.cold.length;t.sources.cold=t.isDirty?[]:t.sources.cold.filter((function(t){var e=t.properties.id||t.properties.parent;return-1===n.indexOf(e)}));var o=i!==t.sources.cold.length||r.length>0;function s(n,r){var i=t.get(n).internal(e);t.ctx.events.currentModeRender(i,(function(e){t.sources[r].push(e)}))}if(n.forEach((function(t){return s(t,"hot")})),r.forEach((function(t){return s(t,"cold")})),o&&t.ctx.map.getSource(l).setData({type:v,features:t.sources.cold}),t.ctx.map.getSource(u).setData({type:v,features:t.sources.hot}),t._emitSelectionChange&&(t.ctx.map.fire("draw.selectionchange",{features:t.getSelected().map((function(t){return t.toGeoJSON()})),points:t.getSelectedCoordinates().map((function(t){return{type:d,properties:{},geometry:{type:m,coordinates:t.coordinates}}}))}),t._emitSelectionChange=!1),t._deletedFeaturesToEmit.length){var a=t._deletedFeaturesToEmit.map((function(t){return t.toGeoJSON()}));t._deletedFeaturesToEmit=[],t.ctx.map.fire("draw.delete",{features:a})}function c(){t.isDirty=!1,t.clearChangedIds()}c(),t.ctx.map.fire("draw.render",{})}function tt(t){var e,n=this;this._features={},this._featureIds=new R,this._selectedFeatureIds=new R,this._selectedCoordinates=[],this._changedFeatureIds=new R,this._deletedFeaturesToEmit=[],this._emitSelectionChange=!1,this._mapInitialConfig={},this.ctx=t,this.sources={hot:[],cold:[]},this.render=function(){e||(e=requestAnimationFrame((function(){e=null,Q.call(n)})))},this.isDirty=!1}function et(t,e){var n=t._selectedCoordinates.filter((function(e){return t._selectedFeatureIds.has(e.feature_id)}));t._selectedCoordinates.length===n.length||e.silent||(t._emitSelectionChange=!0),t._selectedCoordinates=n}tt.prototype.createRenderBatch=function(){var t=this,e=this.render,n=0;return this.render=function(){n++},function(){t.render=e,n>0&&t.render()}},tt.prototype.setDirty=function(){return this.isDirty=!0,this},tt.prototype.featureChanged=function(t){return this._changedFeatureIds.add(t),this},tt.prototype.getChangedIds=function(){return this._changedFeatureIds.values()},tt.prototype.clearChangedIds=function(){return this._changedFeatureIds.clear(),this},tt.prototype.getAllIds=function(){return this._featureIds.values()},tt.prototype.add=function(t){return this.featureChanged(t.id),this._features[t.id]=t,this._featureIds.add(t.id),this},tt.prototype.delete=function(t,e){var n=this;return void 0===e&&(e={}),$(t).forEach((function(t){n._featureIds.has(t)&&(n._featureIds.delete(t),n._selectedFeatureIds.delete(t),e.silent||-1===n._deletedFeaturesToEmit.indexOf(n._features[t])&&n._deletedFeaturesToEmit.push(n._features[t]),delete n._features[t],n.isDirty=!0)})),et(this,e),this},tt.prototype.get=function(t){return this._features[t]},tt.prototype.getAll=function(){var t=this;return Object.keys(this._features).map((function(e){return t._features[e]}))},tt.prototype.select=function(t,e){var n=this;return void 0===e&&(e={}),$(t).forEach((function(t){n._selectedFeatureIds.has(t)||(n._selectedFeatureIds.add(t),n._changedFeatureIds.add(t),e.silent||(n._emitSelectionChange=!0))})),this},tt.prototype.deselect=function(t,e){var n=this;return void 0===e&&(e={}),$(t).forEach((function(t){n._selectedFeatureIds.has(t)&&(n._selectedFeatureIds.delete(t),n._changedFeatureIds.add(t),e.silent||(n._emitSelectionChange=!0))})),et(this,e),this},tt.prototype.clearSelected=function(t){return void 0===t&&(t={}),this.deselect(this._selectedFeatureIds.values(),{silent:t.silent}),this},tt.prototype.setSelected=function(t,e){var n=this;return void 0===e&&(e={}),t=$(t),this.deselect(this._selectedFeatureIds.values().filter((function(e){return-1===t.indexOf(e)})),{silent:e.silent}),this.select(t.filter((function(t){return!n._selectedFeatureIds.has(t)})),{silent:e.silent}),this},tt.prototype.setSelectedCoordinates=function(t){return this._selectedCoordinates=t,this._emitSelectionChange=!0,this},tt.prototype.clearSelectedCoordinates=function(){return this._selectedCoordinates=[],this._emitSelectionChange=!0,this},tt.prototype.getSelectedIds=function(){return this._selectedFeatureIds.values()},tt.prototype.getSelected=function(){var t=this;return this._selectedFeatureIds.values().map((function(e){return t.get(e)}))},tt.prototype.getSelectedCoordinates=function(){var t=this;return this._selectedCoordinates.map((function(e){return{coordinates:t.get(e.feature_id).getCoordinate(e.coord_path)}}))},tt.prototype.isSelected=function(t){return this._selectedFeatureIds.has(t)},tt.prototype.setFeatureProperty=function(t,e,n){this.get(t).setProperty(e,n),this.featureChanged(t)},tt.prototype.storeMapConfig=function(){var t=this;L.forEach((function(e){t.ctx.map[e]&&(t._mapInitialConfig[e]=t.ctx.map[e].isEnabled())}))},tt.prototype.restoreMapConfig=function(){var t=this;Object.keys(this._mapInitialConfig).forEach((function(e){t._mapInitialConfig[e]?t.ctx.map[e].enable():t.ctx.map[e].disable()}))},tt.prototype.getInitialConfigValue=function(t){return void 0===this._mapInitialConfig[t]||this._mapInitialConfig[t]};var nt=function(){for(var t=arguments,e={},n=0;n<arguments.length;n++){var r=t[n];for(var i in r)rt.call(r,i)&&(e[i]=r[i])}return e},rt=Object.prototype.hasOwnProperty,it=["mode","feature","mouse"];function ot(e){var n=null,r=null,i={onRemove:function(){return e.map.off("load",i.connect),clearInterval(r),i.removeLayers(),e.store.restoreMapConfig(),e.ui.removeButtons(),e.events.removeEventListeners(),e.ui.clearMapClasses(),e.map=null,e.container=null,e.store=null,n&&n.parentNode&&n.parentNode.removeChild(n),n=null,this},connect:function(){e.map.off("load",i.connect),clearInterval(r),i.addLayers(),e.store.storeMapConfig(),e.events.addEventListeners()},onAdd:function(o){var s=o.fire;return o.fire=function(t,e){var n=arguments;return 1===s.length&&1!==arguments.length&&(n=[nt({},{type:t},e)]),s.apply(o,n)},e.map=o,e.events=function(e){var n=Object.keys(e.options.modes).reduce((function(t,n){return t[n]=function(t){var e=Object.keys(t);return function(n,r){void 0===r&&(r={});var i={},o=e.reduce((function(e,n){return e[n]=t[n],e}),new K(n));return{start:function(){var e=this;i=o.onSetup(r),Z.forEach((function(n){var r,s=J[n],a=function(){return!1};t[s]&&(a=function(){return!0}),e.on(n,a,(r=s,function(t){return o[r](i,t)}))}))},stop:function(){o.onStop(i)},trash:function(){o.onTrash(i)},combineFeatures:function(){o.onCombineFeatures(i)},uncombineFeatures:function(){o.onUncombineFeatures(i)},render:function(t,e){o.toDisplayFeatures(i,t,e)}}}}(e.options.modes[n]),t}),{}),r={},i={},o={},s=null,a=null;o.drag=function(t,n){n({point:t.point,time:(new Date).getTime()})?(e.ui.queueMapClasses({mouse:"drag"}),a.drag(t)):t.originalEvent.stopPropagation()},o.mousedrag=function(t){o.drag(t,(function(t){return!G(r,t)}))},o.touchdrag=function(t){o.drag(t,(function(t){return!B(i,t)}))},o.mousemove=function(t){if(1===(void 0!==t.originalEvent.buttons?t.originalEvent.buttons:t.originalEvent.which))return o.mousedrag(t);var n=F(t,e);t.featureTarget=n,a.mousemove(t)},o.mousedown=function(t){r={time:(new Date).getTime(),point:t.point};var n=F(t,e);t.featureTarget=n,a.mousedown(t)},o.mouseup=function(t){var n=F(t,e);t.featureTarget=n,G(r,{point:t.point,time:(new Date).getTime()})?a.click(t):a.mouseup(t)},o.mouseout=function(t){a.mouseout(t)},o.touchstart=function(t){if(t.originalEvent.preventDefault(),e.options.touchEnabled){i={time:(new Date).getTime(),point:t.point};var n=A.touch(t,null,e)[0];t.featureTarget=n,a.touchstart(t)}},o.touchmove=function(t){if(t.originalEvent.preventDefault(),e.options.touchEnabled)return a.touchmove(t),o.touchdrag(t)},o.touchend=function(t){if(t.originalEvent.preventDefault(),e.options.touchEnabled){var n=A.touch(t,null,e)[0];t.featureTarget=n,B(i,{time:(new Date).getTime(),point:t.point})?a.tap(t):a.touchend(t)}};var u=function(t){return!(8===t||46===t||t>=48&&t<=57)};function l(r,i,o){void 0===o&&(o={}),a.stop();var u=n[r];if(void 0===u)throw new Error(r+" is not valid");s=r;var l=u(e,i);a=t(l,e),o.silent||e.map.fire("draw.modechange",{mode:r}),e.store.setDirty(),e.store.render()}o.keydown=function(t){"mapboxgl-canvas"===(t.srcElement||t.target).classList[0]&&(8!==t.keyCode&&46!==t.keyCode||!e.options.controls.trash?u(t.keyCode)?a.keydown(t):49===t.keyCode&&e.options.controls.point?l(b.DRAW_POINT):50===t.keyCode&&e.options.controls.line_string?l(b.DRAW_LINE_STRING):51===t.keyCode&&e.options.controls.polygon&&l(b.DRAW_POLYGON):(t.preventDefault(),a.trash()))},o.keyup=function(t){u(t.keyCode)&&a.keyup(t)},o.zoomend=function(){e.store.changeZoom()},o.data=function(t){if("style"===t.dataType){var n=e.setup,r=e.map,i=e.options,o=e.store;i.styles.some((function(t){return r.getLayer(t.id)}))||(n.addLayers(),o.setDirty(),o.render())}};var c={trash:!1,combineFeatures:!1,uncombineFeatures:!1};return{start:function(){s=e.options.defaultMode,a=t(n[s](e),e)},changeMode:l,actionable:function(t){var n=!1;Object.keys(t).forEach((function(e){if(void 0===c[e])throw new Error("Invalid action type");c[e]!==t[e]&&(n=!0),c[e]=t[e]})),n&&e.map.fire("draw.actionable",{actions:c})},currentModeName:function(){return s},currentModeRender:function(t,e){return a.render(t,e)},fire:function(t,e){o[t]&&o[t](e)},addEventListeners:function(){e.map.on("mousemove",o.mousemove),e.map.on("mousedown",o.mousedown),e.map.on("mouseup",o.mouseup),e.map.on("data",o.data),e.map.on("touchmove",o.touchmove),e.map.on("touchstart",o.touchstart),e.map.on("touchend",o.touchend),e.container.addEventListener("mouseout",o.mouseout),e.options.keybindings&&(e.container.addEventListener("keydown",o.keydown),e.container.addEventListener("keyup",o.keyup))},removeEventListeners:function(){e.map.off("mousemove",o.mousemove),e.map.off("mousedown",o.mousedown),e.map.off("mouseup",o.mouseup),e.map.off("data",o.data),e.map.off("touchmove",o.touchmove),e.map.off("touchstart",o.touchstart),e.map.off("touchend",o.touchend),e.container.removeEventListener("mouseout",o.mouseout),e.options.keybindings&&(e.container.removeEventListener("keydown",o.keydown),e.container.removeEventListener("keyup",o.keyup))},trash:function(t){a.trash(t)},combineFeatures:function(){a.combineFeatures()},uncombineFeatures:function(){a.uncombineFeatures()},getMode:function(){return s}}}(e),e.ui=function(t){var e={},n=null,r={mode:null,feature:null,mouse:null},i={mode:null,feature:null,mouse:null};function o(t){i=nt(i,t)}function s(){var e,n;if(t.container){var o=[],s=[];it.forEach((function(t){i[t]!==r[t]&&(o.push(t+"-"+r[t]),null!==i[t]&&s.push(t+"-"+i[t]))})),o.length>0&&(e=t.container.classList).remove.apply(e,o),s.length>0&&(n=t.container.classList).add.apply(n,s),r=nt(r,i)}}function u(t,e){void 0===e&&(e={});var r=document.createElement("button");return r.className="mapbox-gl-draw_ctrl-draw-btn "+e.className,r.setAttribute("title",e.title),e.container.appendChild(r),r.addEventListener("click",(function(r){if(r.preventDefault(),r.stopPropagation(),r.target===n)return l(),void e.onDeactivate();c(t),e.onActivate()}),!0),r}function l(){n&&(n.classList.remove(a),n=null)}function c(t){l();var r=e[t];r&&r&&"trash"!==t&&(r.classList.add(a),n=r)}return{setActiveButton:c,queueMapClasses:o,updateMapClasses:s,clearMapClasses:function(){o({mode:null,feature:null,mouse:null}),s()},addButtons:function(){var n=t.options.controls,r=document.createElement("div");return r.className="mapboxgl-ctrl-group mapboxgl-ctrl",n?(n[g.LINE]&&(e[g.LINE]=u(g.LINE,{container:r,className:"mapbox-gl-draw_line",title:"LineString tool "+(t.options.keybindings?"(l)":""),onActivate:function(){return t.events.changeMode(b.DRAW_LINE_STRING)},onDeactivate:function(){return t.events.trash()}})),n[g.POLYGON]&&(e[g.POLYGON]=u(g.POLYGON,{container:r,className:"mapbox-gl-draw_polygon",title:"Polygon tool "+(t.options.keybindings?"(p)":""),onActivate:function(){return t.events.changeMode(b.DRAW_POLYGON)},onDeactivate:function(){return t.events.trash()}})),n[g.POINT]&&(e[g.POINT]=u(g.POINT,{container:r,className:"mapbox-gl-draw_point",title:"Marker tool "+(t.options.keybindings?"(m)":""),onActivate:function(){return t.events.changeMode(b.DRAW_POINT)},onDeactivate:function(){return t.events.trash()}})),n.trash&&(e.trash=u("trash",{container:r,className:"mapbox-gl-draw_trash",title:"Delete",onActivate:function(){t.events.trash()}})),n.combine_features&&(e.combine_features=u("combineFeatures",{container:r,className:"mapbox-gl-draw_combine",title:"Combine",onActivate:function(){t.events.combineFeatures()}})),n.uncombine_features&&(e.uncombine_features=u("uncombineFeatures",{container:r,className:"mapbox-gl-draw_uncombine",title:"Uncombine",onActivate:function(){t.events.uncombineFeatures()}})),r):r},removeButtons:function(){Object.keys(e).forEach((function(t){var n=e[t];n.parentNode&&n.parentNode.removeChild(n),delete e[t]}))}}}(e),e.container=o.getContainer(),e.store=new tt(e),n=e.ui.addButtons(),e.options.boxSelect&&(o.boxZoom.disable(),o.dragPan.disable(),o.dragPan.enable()),o.loaded()?i.connect():(o.on("load",i.connect),r=setInterval((function(){o.loaded()&&i.connect()}),16)),e.events.start(),n},addLayers:function(){e.map.addSource(l,{data:{type:v,features:[]},type:"geojson"}),e.map.addSource(u,{data:{type:v,features:[]},type:"geojson"}),e.options.styles.forEach((function(t){e.map.addLayer(t)})),e.store.setDirty(!0),e.store.render()},removeLayers:function(){e.options.styles.forEach((function(t){e.map.getLayer(t.id)&&e.map.removeLayer(t.id)})),e.map.getSource(l)&&e.map.removeSource(l),e.map.getSource(u)&&e.map.removeSource(u)}};return e.setup=i,i}function st(t){return function(e){var n=e.featureTarget;return!!n&&!!n.properties&&n.properties.meta===t}}function at(t){return!!t.featureTarget&&!!t.featureTarget.properties&&t.featureTarget.properties.active===N&&t.featureTarget.properties.meta===C}function ut(t){return!!t.featureTarget&&!!t.featureTarget.properties&&t.featureTarget.properties.active===M&&t.featureTarget.properties.meta===C}function lt(t){return void 0===t.featureTarget}function ct(t){var e=t.featureTarget;return!!e&&!!e.properties&&e.properties.meta===w}function ht(t){return!!t.originalEvent&&!0===t.originalEvent.shiftKey}function pt(t){return 27===t.keyCode}function ft(t){return 13===t.keyCode}var gt=dt;function dt(t,e){this.x=t,this.y=e}function yt(t,e){var n=e.getBoundingClientRect();return new gt(t.clientX-n.left-(e.clientLeft||0),t.clientY-n.top-(e.clientTop||0))}function _t(t,e,n,r){return{type:d,properties:{meta:w,parent:t,coord_path:n,active:r?N:M},geometry:{type:m,coordinates:e}}}function mt(t,e,n){void 0===e&&(e={}),void 0===n&&(n=null);var r,i=t.geometry,o=i.type,s=i.coordinates,a=t.properties&&t.properties.id,u=[];function l(t,n){var r="",i=null;t.forEach((function(t,o){var s=null!=n?n+"."+o:String(o),l=_t(a,t,s,c(s));if(e.midpoints&&i){var h=function(t,e,n){var r=e.geometry.coordinates,i=n.geometry.coordinates;if(r[1]>85||r[1]<-85||i[1]>85||i[1]<-85)return null;var o={lng:(r[0]+i[0])/2,lat:(r[1]+i[1])/2};return{type:d,properties:{meta:S,parent:t,lng:o.lng,lat:o.lat,coord_path:n.properties.coord_path},geometry:{type:m,coordinates:[o.lng,o.lat]}}}(a,i,l);h&&u.push(h)}i=l;var p=JSON.stringify(t);r!==p&&u.push(l),0===o&&(r=p)}))}function c(t){return!!e.selectedPaths&&-1!==e.selectedPaths.indexOf(t)}return o===m?u.push(_t(a,s,n,c(n))):o===y?s.forEach((function(t,e){l(t,null!==n?n+"."+e:String(e))})):o===_?l(s,n):0===o.indexOf(x)&&(r=o.replace(x,""),s.forEach((function(n,i){var o={type:d,properties:t.properties,geometry:{type:r,coordinates:n}};u=u.concat(mt(o,e,i))}))),u}dt.prototype={clone:function(){return new dt(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,n=t.y-this.y;return e*e+n*n},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[0]*this.x+t[1]*this.y,n=t[2]*this.x+t[3]*this.y;return this.x=e,this.y=n,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),n=Math.sin(t),r=e*this.x-n*this.y,i=n*this.x+e*this.y;return this.x=r,this.y=i,this},_rotateAround:function(t,e){var n=Math.cos(t),r=Math.sin(t),i=e.x+n*(this.x-e.x)-r*(this.y-e.y),o=e.y+r*(this.x-e.x)+n*(this.y-e.y);return this.x=i,this.y=o,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},dt.convert=function(t){return t instanceof dt?t:Array.isArray(t)?new dt(t[0],t[1]):t};var vt=function(t){setTimeout((function(){t.map&&t.map.doubleClickZoom&&t._ctx&&t._ctx.store&&t._ctx.store.getInitialConfigValue&&t._ctx.store.getInitialConfigValue("doubleClickZoom")&&t.map.doubleClickZoom.enable()}),0)},xt=function(t){setTimeout((function(){t.map&&t.map.doubleClickZoom&&t.map.doubleClickZoom.disable()}),0)},bt=function(t){if(!t||!t.type)return null;var e=Et[t.type];return e?"geometry"===e?{type:"FeatureCollection",features:[{type:"Feature",properties:{},geometry:t}]}:"feature"===e?{type:"FeatureCollection",features:[t]}:"featurecollection"===e?t:void 0:null},Et={Point:"geometry",MultiPoint:"geometry",LineString:"geometry",MultiLineString:"geometry",Polygon:"geometry",MultiPolygon:"geometry",GeometryCollection:"geometry",Feature:"feature",FeatureCollection:"featurecollection"};function It(t){switch(t&&t.type||null){case"FeatureCollection":return t.features=t.features.reduce((function(t,e){return t.concat(It(e))}),[]),t;case"Feature":return t.geometry?It(t.geometry).map((function(e){var n={type:"Feature",properties:JSON.parse(JSON.stringify(t.properties)),geometry:e};return void 0!==t.id&&(n.id=t.id),n})):[t];case"MultiPoint":return t.coordinates.map((function(t){return{type:"Point",coordinates:t}}));case"MultiPolygon":return t.coordinates.map((function(t){return{type:"Polygon",coordinates:t}}));case"MultiLineString":return t.coordinates.map((function(t){return{type:"LineString",coordinates:t}}));case"GeometryCollection":return t.geometries.map(It).reduce((function(t,e){return t.concat(e)}),[]);case"Point":case"Polygon":case"LineString":return[t]}}var Ct=j((function(t){var e=t.exports=function(t){return new n(t)};function n(t){this.value=t}function r(t,e,n){var r=[],s=[],c=!0;return function t(h){var p=n?i(h):h,f={},g=!0,d={node:p,node_:h,path:[].concat(r),parent:s[s.length-1],parents:s,key:r.slice(-1)[0],isRoot:0===r.length,level:r.length,circular:null,update:function(t,e){d.isRoot||(d.parent.node[d.key]=t),d.node=t,e&&(g=!1)},delete:function(t){delete d.parent.node[d.key],t&&(g=!1)},remove:function(t){a(d.parent.node)?d.parent.node.splice(d.key,1):delete d.parent.node[d.key],t&&(g=!1)},keys:null,before:function(t){f.before=t},after:function(t){f.after=t},pre:function(t){f.pre=t},post:function(t){f.post=t},stop:function(){c=!1},block:function(){g=!1}};if(!c)return d;function y(){if("object"==typeof d.node&&null!==d.node){d.keys&&d.node_===d.node||(d.keys=o(d.node)),d.isLeaf=0==d.keys.length;for(var t=0;t<s.length;t++)if(s[t].node_===h){d.circular=s[t];break}}else d.isLeaf=!0,d.keys=null;d.notLeaf=!d.isLeaf,d.notRoot=!d.isRoot}y();var _=e.call(d,d.node);return void 0!==_&&d.update&&d.update(_),f.before&&f.before.call(d,d.node),g?("object"!=typeof d.node||null===d.node||d.circular||(s.push(d),y(),u(d.keys,(function(e,i){r.push(e),f.pre&&f.pre.call(d,d.node[e],e);var o=t(d.node[e]);n&&l.call(d.node,e)&&(d.node[e]=o.node),o.isLast=i==d.keys.length-1,o.isFirst=0==i,f.post&&f.post.call(d,o),r.pop()})),s.pop()),f.after&&f.after.call(d,d.node),d):d}(t).node}function i(t){if("object"==typeof t&&null!==t){var e;if(a(t))e=[];else if("[object Date]"===s(t))e=new Date(t.getTime?t.getTime():t);else if(function(t){return"[object RegExp]"===s(t)}(t))e=new RegExp(t);else if(function(t){return"[object Error]"===s(t)}(t))e={message:t.message};else if(function(t){return"[object Boolean]"===s(t)}(t))e=new Boolean(t);else if(function(t){return"[object Number]"===s(t)}(t))e=new Number(t);else if(function(t){return"[object String]"===s(t)}(t))e=new String(t);else if(Object.create&&Object.getPrototypeOf)e=Object.create(Object.getPrototypeOf(t));else if(t.constructor===Object)e={};else{var n=t.constructor&&t.constructor.prototype||t.__proto__||{},r=function(){};r.prototype=n,e=new r}return u(o(t),(function(n){e[n]=t[n]})),e}return t}n.prototype.get=function(t){for(var e=this.value,n=0;n<t.length;n++){var r=t[n];if(!e||!l.call(e,r)){e=void 0;break}e=e[r]}return e},n.prototype.has=function(t){for(var e=this.value,n=0;n<t.length;n++){var r=t[n];if(!e||!l.call(e,r))return!1;e=e[r]}return!0},n.prototype.set=function(t,e){for(var n=this.value,r=0;r<t.length-1;r++){var i=t[r];l.call(n,i)||(n[i]={}),n=n[i]}return n[t[r]]=e,e},n.prototype.map=function(t){return r(this.value,t,!0)},n.prototype.forEach=function(t){return this.value=r(this.value,t,!1),this.value},n.prototype.reduce=function(t,e){var n=1===arguments.length,r=n?this.value:e;return this.forEach((function(e){this.isRoot&&n||(r=t.call(this,r,e))})),r},n.prototype.paths=function(){var t=[];return this.forEach((function(e){t.push(this.path)})),t},n.prototype.nodes=function(){var t=[];return this.forEach((function(e){t.push(this.node)})),t},n.prototype.clone=function(){var t=[],e=[];return function n(r){for(var s=0;s<t.length;s++)if(t[s]===r)return e[s];if("object"==typeof r&&null!==r){var a=i(r);return t.push(r),e.push(a),u(o(r),(function(t){a[t]=n(r[t])})),t.pop(),e.pop(),a}return r}(this.value)};var o=Object.keys||function(t){var e=[];for(var n in t)e.push(n);return e};function s(t){return Object.prototype.toString.call(t)}var a=Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)},u=function(t,e){if(t.forEach)return t.forEach(e);for(var n=0;n<t.length;n++)e(t[n],n,t)};u(o(n.prototype),(function(t){e[t]=function(e){var r=[].slice.call(arguments,1),i=new n(e);return i[t].apply(i,r)}}));var l=Object.hasOwnProperty||function(t,e){return e in t}})),St=wt;function wt(t){if(!(this instanceof wt))return new wt(t);this._bbox=t||[1/0,1/0,-1/0,-1/0],this._valid=!!t}wt.prototype.include=function(t){return this._valid=!0,this._bbox[0]=Math.min(this._bbox[0],t[0]),this._bbox[1]=Math.min(this._bbox[1],t[1]),this._bbox[2]=Math.max(this._bbox[2],t[0]),this._bbox[3]=Math.max(this._bbox[3],t[1]),this},wt.prototype.equals=function(t){var e;return e=t instanceof wt?t.bbox():t,this._bbox[0]==e[0]&&this._bbox[1]==e[1]&&this._bbox[2]==e[2]&&this._bbox[3]==e[3]},wt.prototype.center=function(t){return this._valid?[(this._bbox[0]+this._bbox[2])/2,(this._bbox[1]+this._bbox[3])/2]:null},wt.prototype.union=function(t){var e;return this._valid=!0,e=t instanceof wt?t.bbox():t,this._bbox[0]=Math.min(this._bbox[0],e[0]),this._bbox[1]=Math.min(this._bbox[1],e[1]),this._bbox[2]=Math.max(this._bbox[2],e[2]),this._bbox[3]=Math.max(this._bbox[3],e[3]),this},wt.prototype.bbox=function(){return this._valid?this._bbox:null},wt.prototype.contains=function(t){if(!t)return this._fastContains();if(!this._valid)return null;var e=t[0],n=t[1];return this._bbox[0]<=e&&this._bbox[1]<=n&&this._bbox[2]>=e&&this._bbox[3]>=n},wt.prototype.intersect=function(t){return this._valid?(e=t instanceof wt?t.bbox():t,!(this._bbox[0]>e[2]||this._bbox[2]<e[0]||this._bbox[3]<e[1]||this._bbox[1]>e[3])):null;var e},wt.prototype._fastContains=function(){if(!this._valid)return new Function("return null;");var t="return "+this._bbox[0]+"<= ll[0] &&"+this._bbox[1]+"<= ll[1] &&"+this._bbox[2]+">= ll[0] &&"+this._bbox[3]+">= ll[1]";return new Function("ll",t)},wt.prototype.polygon=function(){return this._valid?{type:"Polygon",coordinates:[[[this._bbox[0],this._bbox[1]],[this._bbox[2],this._bbox[1]],[this._bbox[2],this._bbox[3]],[this._bbox[0],this._bbox[3]],[this._bbox[0],this._bbox[1]]]]}:null};var Nt={features:["FeatureCollection"],coordinates:["Point","MultiPoint","LineString","MultiLineString","Polygon","MultiPolygon"],geometry:["Feature"],geometries:["GeometryCollection"]},Mt=Object.keys(Nt),Lt=function(t){return Pt(t).bbox()};function Pt(t){for(var e=St(),n=function(t){if(!t)return[];var e=It(bt(t)),n=[];return e.features.forEach((function(t){t.geometry&&(n=n.concat(function t(e){return Array.isArray(e)&&e.length&&"number"==typeof e[0]?[e]:e.reduce((function(e,n){return Array.isArray(n)&&Array.isArray(n[0])?e.concat(t(n)):(e.push(n),e)}),[])}(t.geometry.coordinates)))})),n}(t),r=0;r<n.length;r++)e.include(n[r]);return e}function Ot(t,e){var n=-90,r=90,i=-90,o=90,s=270,a=-270;t.forEach((function(t){var e=Lt(t),u=e[1],l=e[3],c=e[0],h=e[2];u>n&&(n=u),l<r&&(r=l),l>i&&(i=l),u<o&&(o=u),c<s&&(s=c),h>a&&(a=h)}));var u=e;return n+u.lat>85&&(u.lat=85-n),i+u.lat>90&&(u.lat=90-i),r+u.lat<-85&&(u.lat=-85-r),o+u.lat<-90&&(u.lat=-90-o),s+u.lng<=-270&&(u.lng+=360*Math.ceil(Math.abs(u.lng)/360)),a+u.lng>=270&&(u.lng-=360*Math.ceil(Math.abs(u.lng)/360)),u}function Rt(t,e){var n=Ot(t.map((function(t){return t.toGeoJSON()})),e);t.forEach((function(t){var e,r=t.getCoordinates(),i=function(t){var e={lng:t[0]+n.lng,lat:t[1]+n.lat};return[e.lng,e.lat]},o=function(t){return t.map((function(t){return i(t)}))};t.type===m?e=i(r):t.type===_||"MultiPoint"===t.type?e=r.map(i):t.type===y||"MultiLineString"===t.type?e=r.map(o):"MultiPolygon"===t.type&&(e=r.map((function(t){return t.map((function(t){return o(t)}))}))),t.incomingCoords(e)}))}Lt.polygon=function(t){return Pt(t).polygon()},Lt.bboxify=function(t){return Ct(t).map((function(t){t&&Mt.some((function(e){return!!t[e]&&-1!==Nt[e].indexOf(t.type)}))&&(t.bbox=Pt(t).bbox(),this.update(t))}))};var Tt={onSetup:function(t){var e=this,n={dragMoveLocation:null,boxSelectStartLocation:null,boxSelectElement:void 0,boxSelecting:!1,canBoxSelect:!1,dragMoving:!1,canDragMove:!1,initiallySelectedFeatureIds:t.featureIds||[]};return this.setSelected(n.initiallySelectedFeatureIds.filter((function(t){return void 0!==e.getFeature(t)}))),this.fireActionable(),this.setActionableState({combineFeatures:!0,uncombineFeatures:!0,trash:!0}),n},fireUpdate:function(){this.map.fire(I,{action:"move",features:this.getSelected().map((function(t){return t.toGeoJSON()}))})},fireActionable:function(){var t=this,e=this.getSelected(),n=e.filter((function(e){return t.isInstanceOf("MultiFeature",e)})),r=!1;if(e.length>1){r=!0;var i=e[0].type.replace("Multi","");e.forEach((function(t){t.type.replace("Multi","")!==i&&(r=!1)}))}var o=n.length>0,s=e.length>0;this.setActionableState({combineFeatures:r,uncombineFeatures:o,trash:s})},getUniqueIds:function(t){return t.length?t.map((function(t){return t.properties.id})).filter((function(t){return void 0!==t})).reduce((function(t,e){return t.add(e),t}),new R).values():[]},stopExtendedInteractions:function(t){t.boxSelectElement&&(t.boxSelectElement.parentNode&&t.boxSelectElement.parentNode.removeChild(t.boxSelectElement),t.boxSelectElement=null),this.map.dragPan.enable(),t.boxSelecting=!1,t.canBoxSelect=!1,t.dragMoving=!1,t.canDragMove=!1},onStop:function(){vt(this)},onMouseMove:function(t){return this.stopExtendedInteractions(t),!0},onMouseOut:function(t){return!t.dragMoving||this.fireUpdate()}};Tt.onTap=Tt.onClick=function(t,e){return lt(e)?this.clickAnywhere(t,e):st(w)(e)?this.clickOnVertex(t,e):function(t){return!!t.featureTarget&&!!t.featureTarget.properties&&t.featureTarget.properties.meta===C}(e)?this.clickOnFeature(t,e):void 0},Tt.clickAnywhere=function(t){var e=this,n=this.getSelectedIds();n.length&&(this.clearSelectedFeatures(),n.forEach((function(t){return e.doRender(t)}))),vt(this),this.stopExtendedInteractions(t)},Tt.clickOnVertex=function(t,e){this.changeMode(b.DIRECT_SELECT,{featureId:e.featureTarget.properties.parent,coordPath:e.featureTarget.properties.coord_path,startPos:e.lngLat}),this.updateUIClasses({mouse:h})},Tt.startOnActiveFeature=function(t,e){this.stopExtendedInteractions(t),this.map.dragPan.disable(),this.doRender(e.featureTarget.properties.id),t.canDragMove=!0,t.dragMoveLocation=e.lngLat},Tt.clickOnFeature=function(t,e){var n=this;xt(this),this.stopExtendedInteractions(t);var r=ht(e),i=this.getSelectedIds(),o=e.featureTarget.properties.id,s=this.isSelected(o);if(!r&&s&&this.getFeature(o).type!==m)return this.changeMode(b.DIRECT_SELECT,{featureId:o});s&&r?(this.deselect(o),this.updateUIClasses({mouse:p}),1===i.length&&vt(this)):!s&&r?(this.select(o),this.updateUIClasses({mouse:h})):s||r||(i.forEach((function(t){return n.doRender(t)})),this.setSelected(o),this.updateUIClasses({mouse:h})),this.doRender(o)},Tt.onMouseDown=function(t,e){return at(e)?this.startOnActiveFeature(t,e):this.drawConfig.boxSelect&&function(t){return!!t.originalEvent&&!!t.originalEvent.shiftKey&&0===t.originalEvent.button}(e)?this.startBoxSelect(t,e):void 0},Tt.startBoxSelect=function(t,e){this.stopExtendedInteractions(t),this.map.dragPan.disable(),t.boxSelectStartLocation=yt(e.originalEvent,this.map.getContainer()),t.canBoxSelect=!0},Tt.onTouchStart=function(t,e){if(at(e))return this.startOnActiveFeature(t,e)},Tt.onDrag=function(t,e){return t.canDragMove?this.dragMove(t,e):this.drawConfig.boxSelect&&t.canBoxSelect?this.whileBoxSelect(t,e):void 0},Tt.whileBoxSelect=function(t,e){t.boxSelecting=!0,this.updateUIClasses({mouse:c}),t.boxSelectElement||(t.boxSelectElement=document.createElement("div"),t.boxSelectElement.classList.add("mapbox-gl-draw_boxselect"),this.map.getContainer().appendChild(t.boxSelectElement));var n=yt(e.originalEvent,this.map.getContainer()),r=Math.min(t.boxSelectStartLocation.x,n.x),i=Math.max(t.boxSelectStartLocation.x,n.x),o=Math.min(t.boxSelectStartLocation.y,n.y),s=Math.max(t.boxSelectStartLocation.y,n.y),a="translate("+r+"px, "+o+"px)";t.boxSelectElement.style.transform=a,t.boxSelectElement.style.WebkitTransform=a,t.boxSelectElement.style.width=i-r+"px",t.boxSelectElement.style.height=s-o+"px"},Tt.dragMove=function(t,e){t.dragMoving=!0,e.originalEvent.stopPropagation();var n={lng:e.lngLat.lng-t.dragMoveLocation.lng,lat:e.lngLat.lat-t.dragMoveLocation.lat};Rt(this.getSelected(),n),t.dragMoveLocation=e.lngLat},Tt.onMouseUp=function(t,e){var n=this;if(t.dragMoving)this.fireUpdate();else if(t.boxSelecting){var r=[t.boxSelectStartLocation,yt(e.originalEvent,this.map.getContainer())],i=this.featuresAt(null,r,"click"),o=this.getUniqueIds(i).filter((function(t){return!n.isSelected(t)}));o.length&&(this.select(o),o.forEach((function(t){return n.doRender(t)})),this.updateUIClasses({mouse:h}))}this.stopExtendedInteractions(t)},Tt.toDisplayFeatures=function(t,e,n){e.properties.active=this.isSelected(e.properties.id)?N:M,n(e),this.fireActionable(),e.properties.active===N&&e.geometry.type!==m&&mt(e).forEach(n)},Tt.onTrash=function(){this.deleteFeature(this.getSelectedIds()),this.fireActionable()},Tt.onCombineFeatures=function(){var t=this.getSelected();if(!(0===t.length||t.length<2)){for(var e=[],n=[],r=t[0].type.replace("Multi",""),i=0;i<t.length;i++){var o=t[i];if(o.type.replace("Multi","")!==r)return;o.type.includes("Multi")?o.getCoordinates().forEach((function(t){e.push(t)})):e.push(o.getCoordinates()),n.push(o.toGeoJSON())}if(n.length>1){var s=this.newFeature({type:d,properties:n[0].properties,geometry:{type:"Multi"+r,coordinates:e}});this.addFeature(s),this.deleteFeature(this.getSelectedIds(),{silent:!0}),this.setSelected([s.id]),this.map.fire("draw.combine",{createdFeatures:[s.toGeoJSON()],deletedFeatures:n})}this.fireActionable()}},Tt.onUncombineFeatures=function(){var t=this,e=this.getSelected();if(0!==e.length){for(var n=[],r=[],i=function(i){var o=e[i];t.isInstanceOf("MultiFeature",o)&&(o.getFeatures().forEach((function(e){t.addFeature(e),e.properties=o.properties,n.push(e.toGeoJSON()),t.select([e.id])})),t.deleteFeature(o.id,{silent:!0}),r.push(o.toGeoJSON()))},o=0;o<e.length;o++)i(o);n.length>1&&this.map.fire("draw.uncombine",{createdFeatures:n,deletedFeatures:r}),this.fireActionable()}};var At=st(w),Dt=st(S),Ft={fireUpdate:function(){this.map.fire(I,{action:"change_coordinates",features:this.getSelected().map((function(t){return t.toGeoJSON()}))})},fireActionable:function(t){this.setActionableState({combineFeatures:!1,uncombineFeatures:!1,trash:t.selectedCoordPaths.length>0})},startDragging:function(t,e){this.map.dragPan.disable(),t.canDragMove=!0,t.dragMoveLocation=e.lngLat},stopDragging:function(t){this.map.dragPan.enable(),t.dragMoving=!1,t.canDragMove=!1,t.dragMoveLocation=null},onVertex:function(t,e){this.startDragging(t,e);var n=e.featureTarget.properties,r=t.selectedCoordPaths.indexOf(n.coord_path);ht(e)||-1!==r?ht(e)&&-1===r&&t.selectedCoordPaths.push(n.coord_path):t.selectedCoordPaths=[n.coord_path];var i=this.pathsToCoordinates(t.featureId,t.selectedCoordPaths);this.setSelectedCoordinates(i)},onMidpoint:function(t,e){this.startDragging(t,e);var n=e.featureTarget.properties;t.feature.addCoordinate(n.coord_path,n.lng,n.lat),this.fireUpdate(),t.selectedCoordPaths=[n.coord_path]},pathsToCoordinates:function(t,e){return e.map((function(e){return{feature_id:t,coord_path:e}}))},onFeature:function(t,e){0===t.selectedCoordPaths.length?this.startDragging(t,e):this.stopDragging(t)},dragFeature:function(t,e,n){Rt(this.getSelected(),n),t.dragMoveLocation=e.lngLat},dragVertex:function(t,e,n){for(var r=t.selectedCoordPaths.map((function(e){return t.feature.getCoordinate(e)})),i=Ot(r.map((function(t){return{type:d,properties:{},geometry:{type:m,coordinates:t}}})),n),o=0;o<r.length;o++){var s=r[o];t.feature.updateCoordinate(t.selectedCoordPaths[o],s[0]+i.lng,s[1]+i.lat)}},clickNoTarget:function(){this.changeMode(b.SIMPLE_SELECT)},clickInactive:function(){this.changeMode(b.SIMPLE_SELECT)},clickActiveFeature:function(t){t.selectedCoordPaths=[],this.clearSelectedCoordinates(),t.feature.changed()},onSetup:function(t){var e=t.featureId,n=this.getFeature(e);if(!n)throw new Error("You must provide a featureId to enter direct_select mode");if(n.type===m)throw new TypeError("direct_select mode doesn't handle point features");var r={featureId:e,feature:n,dragMoveLocation:t.startPos||null,dragMoving:!1,canDragMove:!1,selectedCoordPaths:t.coordPath?[t.coordPath]:[]};return this.setSelectedCoordinates(this.pathsToCoordinates(e,r.selectedCoordPaths)),this.setSelected(e),xt(this),this.setActionableState({trash:!0}),r},onStop:function(){vt(this),this.clearSelectedCoordinates()},toDisplayFeatures:function(t,e,n){t.featureId===e.properties.id?(e.properties.active=N,n(e),mt(e,{map:this.map,midpoints:!0,selectedPaths:t.selectedCoordPaths}).forEach(n)):(e.properties.active=M,n(e)),this.fireActionable(t)},onTrash:function(t){t.selectedCoordPaths.sort((function(t,e){return e.localeCompare(t,"en",{numeric:!0})})).forEach((function(e){return t.feature.removeCoordinate(e)})),this.fireUpdate(),t.selectedCoordPaths=[],this.clearSelectedCoordinates(),this.fireActionable(t),!1===t.feature.isValid()&&(this.deleteFeature([t.featureId]),this.changeMode(b.SIMPLE_SELECT,{}))},onMouseMove:function(t,e){var n=at(e),r=At(e),i=0===t.selectedCoordPaths.length;return n&&i||r&&!i?this.updateUIClasses({mouse:h}):this.updateUIClasses({mouse:f}),this.stopDragging(t),!0},onMouseOut:function(t){return t.dragMoving&&this.fireUpdate(),!0}};Ft.onTouchStart=Ft.onMouseDown=function(t,e){return At(e)?this.onVertex(t,e):at(e)?this.onFeature(t,e):Dt(e)?this.onMidpoint(t,e):void 0},Ft.onDrag=function(t,e){if(!0===t.canDragMove){t.dragMoving=!0,e.originalEvent.stopPropagation();var n={lng:e.lngLat.lng-t.dragMoveLocation.lng,lat:e.lngLat.lat-t.dragMoveLocation.lat};t.selectedCoordPaths.length>0?this.dragVertex(t,e,n):this.dragFeature(t,e,n),t.dragMoveLocation=e.lngLat}},Ft.onClick=function(t,e){return lt(e)?this.clickNoTarget(t,e):at(e)?this.clickActiveFeature(t,e):ut(e)?this.clickInactive(t,e):void this.stopDragging(t)},Ft.onTap=function(t,e){return lt(e)?this.clickNoTarget(t,e):at(e)?this.clickActiveFeature(t,e):ut(e)?this.clickInactive(t,e):void 0},Ft.onTouchEnd=Ft.onMouseUp=function(t){t.dragMoving&&this.fireUpdate(),this.stopDragging(t)};var kt={};function Gt(t,e){return!!t.lngLat&&t.lngLat.lng===e[0]&&t.lngLat.lat===e[1]}kt.onSetup=function(){var t=this.newFeature({type:d,properties:{},geometry:{type:m,coordinates:[]}});return this.addFeature(t),this.clearSelectedFeatures(),this.updateUIClasses({mouse:c}),this.activateUIButton(g.POINT),this.setActionableState({trash:!0}),{point:t}},kt.stopDrawingAndRemove=function(t){this.deleteFeature([t.point.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT)},kt.onTap=kt.onClick=function(t,e){this.updateUIClasses({mouse:h}),t.point.updateCoordinate("",e.lngLat.lng,e.lngLat.lat),this.map.fire(E,{features:[t.point.toGeoJSON()]}),this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.point.id]})},kt.onStop=function(t){this.activateUIButton(),t.point.getCoordinate().length||this.deleteFeature([t.point.id],{silent:!0})},kt.toDisplayFeatures=function(t,e,n){var r=e.properties.id===t.point.id;if(e.properties.active=r?N:M,!r)return n(e)},kt.onTrash=kt.stopDrawingAndRemove,kt.onKeyUp=function(t,e){if(pt(e)||ft(e))return this.stopDrawingAndRemove(t,e)};var Bt={onSetup:function(){var t=this.newFeature({type:d,properties:{},geometry:{type:y,coordinates:[[]]}});return this.addFeature(t),this.clearSelectedFeatures(),xt(this),this.updateUIClasses({mouse:c}),this.activateUIButton(g.POLYGON),this.setActionableState({trash:!0}),{polygon:t,currentVertexPosition:0}},clickAnywhere:function(t,e){if(t.currentVertexPosition>0&&Gt(e,t.polygon.coordinates[0][t.currentVertexPosition-1]))return this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.polygon.id]});this.updateUIClasses({mouse:c}),t.polygon.updateCoordinate("0."+t.currentVertexPosition,e.lngLat.lng,e.lngLat.lat),t.currentVertexPosition++,t.polygon.updateCoordinate("0."+t.currentVertexPosition,e.lngLat.lng,e.lngLat.lat)},clickOnVertex:function(t){return this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.polygon.id]})},onMouseMove:function(t,e){t.polygon.updateCoordinate("0."+t.currentVertexPosition,e.lngLat.lng,e.lngLat.lat),ct(e)&&this.updateUIClasses({mouse:p})}};Bt.onTap=Bt.onClick=function(t,e){return ct(e)?this.clickOnVertex(t,e):this.clickAnywhere(t,e)},Bt.onKeyUp=function(t,e){pt(e)?(this.deleteFeature([t.polygon.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT)):ft(e)&&this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.polygon.id]})},Bt.onStop=function(t){this.updateUIClasses({mouse:f}),vt(this),this.activateUIButton(),void 0!==this.getFeature(t.polygon.id)&&(t.polygon.removeCoordinate("0."+t.currentVertexPosition),t.polygon.isValid()?this.map.fire(E,{features:[t.polygon.toGeoJSON()]}):(this.deleteFeature([t.polygon.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT,{},{silent:!0})))},Bt.toDisplayFeatures=function(t,e,n){var r=e.properties.id===t.polygon.id;if(e.properties.active=r?N:M,!r)return n(e);if(0!==e.geometry.coordinates.length){var i=e.geometry.coordinates[0].length;if(!(i<3)){if(e.properties.meta=C,n(_t(t.polygon.id,e.geometry.coordinates[0][0],"0.0",!1)),i>3){var o=e.geometry.coordinates[0].length-3;n(_t(t.polygon.id,e.geometry.coordinates[0][o],"0."+o,!1))}if(i<=4){var s=[[e.geometry.coordinates[0][0][0],e.geometry.coordinates[0][0][1]],[e.geometry.coordinates[0][1][0],e.geometry.coordinates[0][1][1]]];if(n({type:d,properties:e.properties,geometry:{coordinates:s,type:_}}),3===i)return}return n(e)}}},Bt.onTrash=function(t){this.deleteFeature([t.polygon.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT)};var jt={onSetup:function(t){var e,n,r=(t=t||{}).featureId,i="forward";if(r){if(!(e=this.getFeature(r)))throw new Error("Could not find a feature with the provided featureId");var o=t.from;if(o&&"Feature"===o.type&&o.geometry&&"Point"===o.geometry.type&&(o=o.geometry),o&&"Point"===o.type&&o.coordinates&&2===o.coordinates.length&&(o=o.coordinates),!o||!Array.isArray(o))throw new Error("Please use the `from` property to indicate which point to continue the line from");var s=e.coordinates.length-1;if(e.coordinates[s][0]===o[0]&&e.coordinates[s][1]===o[1])n=s+1,e.addCoordinate.apply(e,[n].concat(e.coordinates[s]));else{if(e.coordinates[0][0]!==o[0]||e.coordinates[0][1]!==o[1])throw new Error("`from` should match the point at either the start or the end of the provided LineString");i="backwards",n=0,e.addCoordinate.apply(e,[n].concat(e.coordinates[0]))}}else e=this.newFeature({type:d,properties:{},geometry:{type:_,coordinates:[]}}),n=0,this.addFeature(e);return this.clearSelectedFeatures(),xt(this),this.updateUIClasses({mouse:c}),this.activateUIButton(g.LINE),this.setActionableState({trash:!0}),{line:e,currentVertexPosition:n,direction:i}},clickAnywhere:function(t,e){if(t.currentVertexPosition>0&&Gt(e,t.line.coordinates[t.currentVertexPosition-1])||"backwards"===t.direction&&Gt(e,t.line.coordinates[t.currentVertexPosition+1]))return this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.line.id]});this.updateUIClasses({mouse:c}),t.line.updateCoordinate(t.currentVertexPosition,e.lngLat.lng,e.lngLat.lat),"forward"===t.direction?(t.currentVertexPosition++,t.line.updateCoordinate(t.currentVertexPosition,e.lngLat.lng,e.lngLat.lat)):t.line.addCoordinate(0,e.lngLat.lng,e.lngLat.lat)},clickOnVertex:function(t){return this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.line.id]})},onMouseMove:function(t,e){t.line.updateCoordinate(t.currentVertexPosition,e.lngLat.lng,e.lngLat.lat),ct(e)&&this.updateUIClasses({mouse:p})}};jt.onTap=jt.onClick=function(t,e){if(ct(e))return this.clickOnVertex(t,e);this.clickAnywhere(t,e)},jt.onKeyUp=function(t,e){ft(e)?this.changeMode(b.SIMPLE_SELECT,{featureIds:[t.line.id]}):pt(e)&&(this.deleteFeature([t.line.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT))},jt.onStop=function(t){vt(this),this.activateUIButton(),void 0!==this.getFeature(t.line.id)&&(t.line.removeCoordinate(""+t.currentVertexPosition),t.line.isValid()?this.map.fire(E,{features:[t.line.toGeoJSON()]}):(this.deleteFeature([t.line.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT,{},{silent:!0})))},jt.onTrash=function(t){this.deleteFeature([t.line.id],{silent:!0}),this.changeMode(b.SIMPLE_SELECT)},jt.toDisplayFeatures=function(t,e,n){var r=e.properties.id===t.line.id;if(e.properties.active=r?N:M,!r)return n(e);e.geometry.coordinates.length<2||(e.properties.meta=C,n(_t(t.line.id,e.geometry.coordinates["forward"===t.direction?e.geometry.coordinates.length-2:1],""+("forward"===t.direction?e.geometry.coordinates.length-2:1),!1)),n(e))};var Ut={simple_select:Tt,direct_select:Ft,draw_point:kt,draw_polygon:Bt,draw_line_string:jt},qt={defaultMode:b.SIMPLE_SELECT,keybindings:!0,touchEnabled:!0,clickBuffer:2,touchBuffer:25,boxSelect:!0,displayControlsDefault:!0,styles:[{id:"gl-draw-polygon-fill-inactive",type:"fill",filter:["all",["==","active","false"],["==","$type","Polygon"],["!=","mode","static"]],paint:{"fill-color":"#3bb2d0","fill-outline-color":"#3bb2d0","fill-opacity":.1}},{id:"gl-draw-polygon-fill-active",type:"fill",filter:["all",["==","active","true"],["==","$type","Polygon"]],paint:{"fill-color":"#fbb03b","fill-outline-color":"#fbb03b","fill-opacity":.1}},{id:"gl-draw-polygon-midpoint",type:"circle",filter:["all",["==","$type","Point"],["==","meta","midpoint"]],paint:{"circle-radius":4,"circle-color":"#000"}},{id:"gl-draw-polygon-stroke-inactive",type:"line",filter:["all",["==","active","false"],["==","$type","Polygon"],["!=","mode","static"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":"#3bb2d0","line-width":2}},{id:"gl-draw-polygon-stroke-active",type:"line",filter:["all",["==","active","true"],["==","$type","Polygon"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":"#fbb03b","line-dasharray":[.2,2],"line-width":2}},{id:"gl-draw-line-inactive",type:"line",filter:["all",["==","active","false"],["==","$type","LineString"],["!=","mode","static"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":"#3bb2d0","line-width":2}},{id:"gl-draw-line-active",type:"line",filter:["all",["==","$type","LineString"],["==","active","true"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":"#fbb03b","line-dasharray":[.2,2],"line-width":2}},{id:"gl-draw-polygon-and-line-vertex-stroke-inactive",type:"circle",filter:["all",["==","meta","vertex"],["==","$type","Point"],["!=","mode","static"]],paint:{"circle-radius":5,"circle-color":"#000"}},{id:"gl-draw-polygon-and-line-vertex-inactive",type:"circle",filter:["all",["==","meta","vertex"],["==","$type","Point"],["!=","mode","static"]],paint:{"circle-radius":4,"circle-color":"#000"}},{id:"gl-draw-point-point-stroke-inactive",type:"circle",filter:["all",["==","active","false"],["==","$type","Point"],["==","meta","feature"],["!=","mode","static"]],paint:{"circle-radius":5,"circle-opacity":1,"circle-color":"#000"}},{id:"gl-draw-point-inactive",type:"circle",filter:["all",["==","active","false"],["==","$type","Point"],["==","meta","feature"],["!=","mode","static"]],paint:{"circle-radius":4,"circle-color":"#000"}},{id:"gl-draw-point-stroke-active",type:"circle",filter:["all",["==","$type","Point"],["==","active","true"],["!=","meta","midpoint"]],paint:{"circle-radius":7,"circle-color":"#000"}},{id:"gl-draw-point-active",type:"circle",filter:["all",["==","$type","Point"],["!=","meta","midpoint"],["==","active","true"]],paint:{"circle-radius":5,"circle-color":"#000"}},{id:"gl-draw-polygon-fill-static",type:"fill",filter:["all",["==","mode","static"],["==","$type","Polygon"]],paint:{"fill-color":"#404040","fill-outline-color":"#404040","fill-opacity":.1}},{id:"gl-draw-polygon-stroke-static",type:"line",filter:["all",["==","mode","static"],["==","$type","Polygon"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":"#404040","line-width":2}},{id:"gl-draw-line-static",type:"line",filter:["all",["==","mode","static"],["==","$type","LineString"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":"#404040","line-width":2}},{id:"gl-draw-point-static",type:"circle",filter:["all",["==","mode","static"],["==","$type","Point"]],paint:{"circle-radius":5,"circle-color":"#000"}}],modes:Ut,controls:{},userProperties:!1},zt={point:!0,line_string:!0,polygon:!0,trash:!0,combine_features:!0,uncombine_features:!0},Vt={point:!1,line_string:!1,polygon:!1,trash:!1,combine_features:!1,uncombine_features:!1};function Yt(t,e){return t.map((function(t){return t.source?t:nt(t,{id:t.id+"."+e,source:"hot"===e?u:l})}))}var Xt=j((function(t,e){var r="[object Arguments]",i="[object Map]",o="[object Object]",s="[object Set]",a=/^\[object .+?Constructor\]$/,u=/^(?:0|[1-9]\d*)$/,l={};l["[object Float32Array]"]=l["[object Float64Array]"]=l["[object Int8Array]"]=l["[object Int16Array]"]=l["[object Int32Array]"]=l["[object Uint8Array]"]=l["[object Uint8ClampedArray]"]=l["[object Uint16Array]"]=l["[object Uint32Array]"]=!0,l[r]=l["[object Array]"]=l["[object ArrayBuffer]"]=l["[object Boolean]"]=l["[object DataView]"]=l["[object Date]"]=l["[object Error]"]=l["[object Function]"]=l[i]=l["[object Number]"]=l[o]=l["[object RegExp]"]=l[s]=l["[object String]"]=l["[object WeakMap]"]=!1;var c="object"==typeof n.g&&n.g&&n.g.Object===Object&&n.g,h="object"==typeof self&&self&&self.Object===Object&&self,p=c||h||Function("return this")(),f=e&&!e.nodeType&&e,g=f&&t&&!t.nodeType&&t,d=g&&g.exports===f,y=d&&c.process,_=function(){try{return y&&y.binding&&y.binding("util")}catch(t){}}(),m=_&&_.isTypedArray;function v(t,e){for(var n=-1,r=null==t?0:t.length;++n<r;)if(e(t[n],n,t))return!0;return!1}function x(t){var e=-1,n=Array(t.size);return t.forEach((function(t,r){n[++e]=[r,t]})),n}function b(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=t})),n}var E,I,C,S=Array.prototype,w=Function.prototype,N=Object.prototype,M=p["__core-js_shared__"],L=w.toString,P=N.hasOwnProperty,O=(E=/[^.]+$/.exec(M&&M.keys&&M.keys.IE_PROTO||""))?"Symbol(src)_1."+E:"",R=N.toString,T=RegExp("^"+L.call(P).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),A=d?p.Buffer:void 0,D=p.Symbol,F=p.Uint8Array,k=N.propertyIsEnumerable,G=S.splice,B=D?D.toStringTag:void 0,j=Object.getOwnPropertySymbols,U=A?A.isBuffer:void 0,q=(I=Object.keys,C=Object,function(t){return I(C(t))}),z=gt(p,"DataView"),V=gt(p,"Map"),Y=gt(p,"Promise"),X=gt(p,"Set"),W=gt(p,"WeakMap"),H=gt(Object,"create"),K=mt(z),J=mt(V),Z=mt(Y),$=mt(X),Q=mt(W),tt=D?D.prototype:void 0,et=tt?tt.valueOf:void 0;function nt(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var r=t[e];this.set(r[0],r[1])}}function rt(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var r=t[e];this.set(r[0],r[1])}}function it(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var r=t[e];this.set(r[0],r[1])}}function ot(t){var e=-1,n=null==t?0:t.length;for(this.__data__=new it;++e<n;)this.add(t[e])}function st(t){var e=this.__data__=new rt(t);this.size=e.size}function at(t,e){for(var n=t.length;n--;)if(vt(t[n][0],e))return n;return-1}function ut(t){return null==t?void 0===t?"[object Undefined]":"[object Null]":B&&B in Object(t)?function(t){var e=P.call(t,B),n=t[B];try{t[B]=void 0;var r=!0}catch(t){}var i=R.call(t);return r&&(e?t[B]=n:delete t[B]),i}(t):function(t){return R.call(t)}(t)}function lt(t){return wt(t)&&ut(t)==r}function ct(t,e,n,a,u){return t===e||(null==t||null==e||!wt(t)&&!wt(e)?t!=t&&e!=e:function(t,e,n,a,u,l){var c=bt(t),h=bt(e),p=c?"[object Array]":yt(t),f=h?"[object Array]":yt(e),g=(p=p==r?o:p)==o,d=(f=f==r?o:f)==o,y=p==f;if(y&&Et(t)){if(!Et(e))return!1;c=!0,g=!1}if(y&&!g)return l||(l=new st),c||Nt(t)?ht(t,e,n,a,u,l):function(t,e,n,r,o,a,u){switch(n){case"[object DataView]":if(t.byteLength!=e.byteLength||t.byteOffset!=e.byteOffset)return!1;t=t.buffer,e=e.buffer;case"[object ArrayBuffer]":return!(t.byteLength!=e.byteLength||!a(new F(t),new F(e)));case"[object Boolean]":case"[object Date]":case"[object Number]":return vt(+t,+e);case"[object Error]":return t.name==e.name&&t.message==e.message;case"[object RegExp]":case"[object String]":return t==e+"";case i:var l=x;case s:var c=1&r;if(l||(l=b),t.size!=e.size&&!c)return!1;var h=u.get(t);if(h)return h==e;r|=2,u.set(t,e);var p=ht(l(t),l(e),r,o,a,u);return u.delete(t),p;case"[object Symbol]":if(et)return et.call(t)==et.call(e)}return!1}(t,e,p,n,a,u,l);if(!(1&n)){var _=g&&P.call(t,"__wrapped__"),m=d&&P.call(e,"__wrapped__");if(_||m){var v=_?t.value():t,E=m?e.value():e;return l||(l=new st),u(v,E,n,a,l)}}return!!y&&(l||(l=new st),function(t,e,n,r,i,o){var s=1&n,a=pt(t),u=a.length;if(u!=pt(e).length&&!s)return!1;for(var l=u;l--;){var c=a[l];if(!(s?c in e:P.call(e,c)))return!1}var h=o.get(t);if(h&&o.get(e))return h==e;var p=!0;o.set(t,e),o.set(e,t);for(var f=s;++l<u;){var g=t[c=a[l]],d=e[c];if(r)var y=s?r(d,g,c,e,t,o):r(g,d,c,t,e,o);if(!(void 0===y?g===d||i(g,d,n,r,o):y)){p=!1;break}f||(f="constructor"==c)}if(p&&!f){var _=t.constructor,m=e.constructor;_==m||!("constructor"in t)||!("constructor"in e)||"function"==typeof _&&_ instanceof _&&"function"==typeof m&&m instanceof m||(p=!1)}return o.delete(t),o.delete(e),p}(t,e,n,a,u,l))}(t,e,n,a,ct,u))}function ht(t,e,n,r,i,o){var s=1&n,a=t.length,u=e.length;if(a!=u&&!(s&&u>a))return!1;var l=o.get(t);if(l&&o.get(e))return l==e;var c=-1,h=!0,p=2&n?new ot:void 0;for(o.set(t,e),o.set(e,t);++c<a;){var f=t[c],g=e[c];if(r)var d=s?r(g,f,c,e,t,o):r(f,g,c,t,e,o);if(void 0!==d){if(d)continue;h=!1;break}if(p){if(!v(e,(function(t,e){if(s=e,!p.has(s)&&(f===t||i(f,t,n,r,o)))return p.push(e);var s}))){h=!1;break}}else if(f!==g&&!i(f,g,n,r,o)){h=!1;break}}return o.delete(t),o.delete(e),h}function pt(t){return function(t,e,n){var r=e(t);return bt(t)?r:function(t,e){for(var n=-1,r=e.length,i=t.length;++n<r;)t[i+n]=e[n];return t}(r,n(t))}(t,Mt,dt)}function ft(t,e){var n,r,i=t.__data__;return("string"==(r=typeof(n=e))||"number"==r||"symbol"==r||"boolean"==r?"__proto__"!==n:null===n)?i["string"==typeof e?"string":"hash"]:i.map}function gt(t,e){var n=function(t,e){return null==t?void 0:t[e]}(t,e);return function(t){return!(!St(t)||function(t){return!!O&&O in t}(t))&&(It(t)?T:a).test(mt(t))}(n)?n:void 0}nt.prototype.clear=function(){this.__data__=H?H(null):{},this.size=0},nt.prototype.delete=function(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e},nt.prototype.get=function(t){var e=this.__data__;if(H){var n=e[t];return"__lodash_hash_undefined__"===n?void 0:n}return P.call(e,t)?e[t]:void 0},nt.prototype.has=function(t){var e=this.__data__;return H?void 0!==e[t]:P.call(e,t)},nt.prototype.set=function(t,e){var n=this.__data__;return this.size+=this.has(t)?0:1,n[t]=H&&void 0===e?"__lodash_hash_undefined__":e,this},rt.prototype.clear=function(){this.__data__=[],this.size=0},rt.prototype.delete=function(t){var e=this.__data__,n=at(e,t);return!(n<0||(n==e.length-1?e.pop():G.call(e,n,1),--this.size,0))},rt.prototype.get=function(t){var e=this.__data__,n=at(e,t);return n<0?void 0:e[n][1]},rt.prototype.has=function(t){return at(this.__data__,t)>-1},rt.prototype.set=function(t,e){var n=this.__data__,r=at(n,t);return r<0?(++this.size,n.push([t,e])):n[r][1]=e,this},it.prototype.clear=function(){this.size=0,this.__data__={hash:new nt,map:new(V||rt),string:new nt}},it.prototype.delete=function(t){var e=ft(this,t).delete(t);return this.size-=e?1:0,e},it.prototype.get=function(t){return ft(this,t).get(t)},it.prototype.has=function(t){return ft(this,t).has(t)},it.prototype.set=function(t,e){var n=ft(this,t),r=n.size;return n.set(t,e),this.size+=n.size==r?0:1,this},ot.prototype.add=ot.prototype.push=function(t){return this.__data__.set(t,"__lodash_hash_undefined__"),this},ot.prototype.has=function(t){return this.__data__.has(t)},st.prototype.clear=function(){this.__data__=new rt,this.size=0},st.prototype.delete=function(t){var e=this.__data__,n=e.delete(t);return this.size=e.size,n},st.prototype.get=function(t){return this.__data__.get(t)},st.prototype.has=function(t){return this.__data__.has(t)},st.prototype.set=function(t,e){var n=this.__data__;if(n instanceof rt){var r=n.__data__;if(!V||r.length<199)return r.push([t,e]),this.size=++n.size,this;n=this.__data__=new it(r)}return n.set(t,e),this.size=n.size,this};var dt=j?function(t){return null==t?[]:(t=Object(t),function(t,e){for(var n=-1,r=null==t?0:t.length,i=0,o=[];++n<r;){var s=t[n];e(s)&&(o[i++]=s)}return o}(j(t),(function(e){return k.call(t,e)})))}:function(){return[]},yt=ut;function _t(t,e){return!!(e=null==e?9007199254740991:e)&&("number"==typeof t||u.test(t))&&t>-1&&t%1==0&&t<e}function mt(t){if(null!=t){try{return L.call(t)}catch(t){}try{return t+""}catch(t){}}return""}function vt(t,e){return t===e||t!=t&&e!=e}(z&&"[object DataView]"!=yt(new z(new ArrayBuffer(1)))||V&&yt(new V)!=i||Y&&"[object Promise]"!=yt(Y.resolve())||X&&yt(new X)!=s||W&&"[object WeakMap]"!=yt(new W))&&(yt=function(t){var e=ut(t),n=e==o?t.constructor:void 0,r=n?mt(n):"";if(r)switch(r){case K:return"[object DataView]";case J:return i;case Z:return"[object Promise]";case $:return s;case Q:return"[object WeakMap]"}return e});var xt=lt(function(){return arguments}())?lt:function(t){return wt(t)&&P.call(t,"callee")&&!k.call(t,"callee")},bt=Array.isArray,Et=U||function(){return!1};function It(t){if(!St(t))return!1;var e=ut(t);return"[object Function]"==e||"[object GeneratorFunction]"==e||"[object AsyncFunction]"==e||"[object Proxy]"==e}function Ct(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=9007199254740991}function St(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}function wt(t){return null!=t&&"object"==typeof t}var Nt=m?function(t){return function(e){return t(e)}}(m):function(t){return wt(t)&&Ct(t.length)&&!!l[ut(t)]};function Mt(t){return null!=(e=t)&&Ct(e.length)&&!It(e)?function(t,e){var n=bt(t),r=!n&&xt(t),i=!n&&!r&&Et(t),o=!n&&!r&&!i&&Nt(t),s=n||r||i||o,a=s?function(t,e){for(var n=-1,r=Array(t);++n<t;)r[n]=e(n);return r}(t.length,String):[],u=a.length;for(var l in t)!e&&!P.call(t,l)||s&&("length"==l||i&&("offset"==l||"parent"==l)||o&&("buffer"==l||"byteLength"==l||"byteOffset"==l)||_t(l,u))||a.push(l);return a}(t):function(t){if(n=(e=t)&&e.constructor,e!==("function"==typeof n&&n.prototype||N))return q(t);var e,n,r=[];for(var i in Object(t))P.call(t,i)&&"constructor"!=i&&r.push(i);return r}(t);var e}t.exports=function(t,e){return ct(t,e)}})),Wt={Polygon:Y,LineString:V,Point:z,MultiPolygon:H,MultiLineString:H,MultiPoint:H};var Ht=function(t,e){var n={options:t=function(t){void 0===t&&(t={});var e=nt(t);return t.controls||(e.controls={}),!1===t.displayControlsDefault?e.controls=nt(Vt,t.controls):e.controls=nt(zt,t.controls),(e=nt(qt,e)).styles=Yt(e.styles,"cold").concat(Yt(e.styles,"hot")),e}(t)};e=function(t,e){return e.modes=b,e.getFeatureIdsAt=function(e){return A.click({point:e},null,t).map((function(t){return t.properties.id}))},e.getSelectedIds=function(){return t.store.getSelectedIds()},e.getSelected=function(){return{type:v,features:t.store.getSelectedIds().map((function(e){return t.store.get(e)})).map((function(t){return t.toGeoJSON()}))}},e.getSelectedPoints=function(){return{type:v,features:t.store.getSelectedCoordinates().map((function(t){return{type:d,properties:{},geometry:{type:m,coordinates:t.coordinates}}}))}},e.set=function(n){if(void 0===n.type||n.type!==v||!Array.isArray(n.features))throw new Error("Invalid FeatureCollection");var r=t.store.createRenderBatch(),i=t.store.getAllIds().slice(),o=e.add(n),s=new R(o);return(i=i.filter((function(t){return!s.has(t)}))).length&&e.delete(i),r(),o},e.add=function(e){var n=JSON.parse(JSON.stringify(bt(e))).features.map((function(e){if(e.id=e.id||U(),null===e.geometry)throw new Error("Invalid geometry: null");if(void 0===t.store.get(e.id)||t.store.get(e.id).type!==e.geometry.type){var n=Wt[e.geometry.type];if(void 0===n)throw new Error("Invalid geometry type: "+e.geometry.type+".");var r=new n(t,e);t.store.add(r)}else{var i=t.store.get(e.id);i.properties=e.properties,Xt(i.getCoordinates(),e.geometry.coordinates)||i.incomingCoords(e.geometry.coordinates)}return e.id}));return t.store.render(),n},e.get=function(e){var n=t.store.get(e);if(n)return n.toGeoJSON()},e.getAll=function(){return{type:v,features:t.store.getAll().map((function(t){return t.toGeoJSON()}))}},e.delete=function(n){return t.store.delete(n,{silent:!0}),e.getMode()!==b.DIRECT_SELECT||t.store.getSelectedIds().length?t.store.render():t.events.changeMode(b.SIMPLE_SELECT,void 0,{silent:!0}),e},e.deleteAll=function(){return t.store.delete(t.store.getAllIds(),{silent:!0}),e.getMode()===b.DIRECT_SELECT?t.events.changeMode(b.SIMPLE_SELECT,void 0,{silent:!0}):t.store.render(),e},e.changeMode=function(n,r){return void 0===r&&(r={}),n===b.SIMPLE_SELECT&&e.getMode()===b.SIMPLE_SELECT?(i=r.featureIds||[],o=t.store.getSelectedIds(),i.length===o.length&&JSON.stringify(i.map((function(t){return t})).sort())===JSON.stringify(o.map((function(t){return t})).sort())||(t.store.setSelected(r.featureIds,{silent:!0}),t.store.render()),e):(n===b.DIRECT_SELECT&&e.getMode()===b.DIRECT_SELECT&&r.featureId===t.store.getSelectedIds()[0]||t.events.changeMode(n,r,{silent:!0}),e);var i,o},e.getMode=function(){return t.events.getMode()},e.trash=function(){return t.events.trash({silent:!0}),e},e.combineFeatures=function(){return t.events.combineFeatures({silent:!0}),e},e.uncombineFeatures=function(){return t.events.uncombineFeatures({silent:!0}),e},e.setFeatureProperty=function(n,r,i){return t.store.setFeatureProperty(n,r,i),e},e}(n,e),n.api=e;var r=ot(n);return e.onAdd=r.onAdd,e.onRemove=r.onRemove,e.types=g,e.options=t,e};function Kt(t){Ht(t,this)}return Kt.modes=Ut,Kt}()},9705:(t,e,n)=>{"use strict";var r=n(1540);function i(t){var e=[1/0,1/0,-1/0,-1/0];return r.coordEach(t,(function(t){e[0]>t[0]&&(e[0]=t[0]),e[1]>t[1]&&(e[1]=t[1]),e[2]<t[0]&&(e[2]=t[0]),e[3]<t[1]&&(e[3]=t[1])})),e}i.default=i,e.Z=i},4102:(t,e)=>{"use strict";function n(t,e,n){void 0===n&&(n={});var r={type:"Feature"};return(0===n.id||n.id)&&(r.id=n.id),n.bbox&&(r.bbox=n.bbox),r.properties=e||{},r.geometry=t,r}function r(t,e,r){if(void 0===r&&(r={}),!t)throw new Error("coordinates is required");if(!Array.isArray(t))throw new Error("coordinates must be an Array");if(t.length<2)throw new Error("coordinates must be at least 2 numbers long");if(!f(t[0])||!f(t[1]))throw new Error("coordinates must contain numbers");return n({type:"Point",coordinates:t},e,r)}function i(t,e,r){void 0===r&&(r={});for(var i=0,o=t;i<o.length;i++){var s=o[i];if(s.length<4)throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");for(var a=0;a<s[s.length-1].length;a++)if(s[s.length-1][a]!==s[0][a])throw new Error("First and last Position are not equivalent.")}return n({type:"Polygon",coordinates:t},e,r)}function o(t,e,r){if(void 0===r&&(r={}),t.length<2)throw new Error("coordinates must be an array of two or more positions");return n({type:"LineString",coordinates:t},e,r)}function s(t,e){void 0===e&&(e={});var n={type:"FeatureCollection"};return e.id&&(n.id=e.id),e.bbox&&(n.bbox=e.bbox),n.features=t,n}function a(t,e,r){return void 0===r&&(r={}),n({type:"MultiLineString",coordinates:t},e,r)}function u(t,e,r){return void 0===r&&(r={}),n({type:"MultiPoint",coordinates:t},e,r)}function l(t,e,r){return void 0===r&&(r={}),n({type:"MultiPolygon",coordinates:t},e,r)}function c(t,n){void 0===n&&(n="kilometers");var r=e.factors[n];if(!r)throw new Error(n+" units is invalid");return t*r}function h(t,n){void 0===n&&(n="kilometers");var r=e.factors[n];if(!r)throw new Error(n+" units is invalid");return t/r}function p(t){return t%(2*Math.PI)*180/Math.PI}function f(t){return!isNaN(t)&&null!==t&&!Array.isArray(t)}Object.defineProperty(e,"__esModule",{value:!0}),e.earthRadius=6371008.8,e.factors={centimeters:100*e.earthRadius,centimetres:100*e.earthRadius,degrees:e.earthRadius/111325,feet:3.28084*e.earthRadius,inches:39.37*e.earthRadius,kilometers:e.earthRadius/1e3,kilometres:e.earthRadius/1e3,meters:e.earthRadius,metres:e.earthRadius,miles:e.earthRadius/1609.344,millimeters:1e3*e.earthRadius,millimetres:1e3*e.earthRadius,nauticalmiles:e.earthRadius/1852,radians:1,yards:1.0936*e.earthRadius},e.unitsFactors={centimeters:100,centimetres:100,degrees:1/111325,feet:3.28084,inches:39.37,kilometers:.001,kilometres:.001,meters:1,metres:1,miles:1/1609.344,millimeters:1e3,millimetres:1e3,nauticalmiles:1/1852,radians:1/e.earthRadius,yards:1.0936133},e.areaFactors={acres:247105e-9,centimeters:1e4,centimetres:1e4,feet:10.763910417,hectares:1e-4,inches:1550.003100006,kilometers:1e-6,kilometres:1e-6,meters:1,metres:1,miles:386e-9,millimeters:1e6,millimetres:1e6,yards:1.195990046},e.feature=n,e.geometry=function(t,e,n){switch(void 0===n&&(n={}),t){case"Point":return r(e).geometry;case"LineString":return o(e).geometry;case"Polygon":return i(e).geometry;case"MultiPoint":return u(e).geometry;case"MultiLineString":return a(e).geometry;case"MultiPolygon":return l(e).geometry;default:throw new Error(t+" is invalid")}},e.point=r,e.points=function(t,e,n){return void 0===n&&(n={}),s(t.map((function(t){return r(t,e)})),n)},e.polygon=i,e.polygons=function(t,e,n){return void 0===n&&(n={}),s(t.map((function(t){return i(t,e)})),n)},e.lineString=o,e.lineStrings=function(t,e,n){return void 0===n&&(n={}),s(t.map((function(t){return o(t,e)})),n)},e.featureCollection=s,e.multiLineString=a,e.multiPoint=u,e.multiPolygon=l,e.geometryCollection=function(t,e,r){return void 0===r&&(r={}),n({type:"GeometryCollection",geometries:t},e,r)},e.round=function(t,e){if(void 0===e&&(e=0),e&&!(e>=0))throw new Error("precision must be a positive number");var n=Math.pow(10,e||0);return Math.round(t*n)/n},e.radiansToLength=c,e.lengthToRadians=h,e.lengthToDegrees=function(t,e){return p(h(t,e))},e.bearingToAzimuth=function(t){var e=t%360;return e<0&&(e+=360),e},e.radiansToDegrees=p,e.degreesToRadians=function(t){return t%360*Math.PI/180},e.convertLength=function(t,e,n){if(void 0===e&&(e="kilometers"),void 0===n&&(n="kilometers"),!(t>=0))throw new Error("length must be a positive number");return c(h(t,e),n)},e.convertArea=function(t,n,r){if(void 0===n&&(n="meters"),void 0===r&&(r="kilometers"),!(t>=0))throw new Error("area must be a positive number");var i=e.areaFactors[n];if(!i)throw new Error("invalid original units");var o=e.areaFactors[r];if(!o)throw new Error("invalid final units");return t/i*o},e.isNumber=f,e.isObject=function(t){return!!t&&t.constructor===Object},e.validateBBox=function(t){if(!t)throw new Error("bbox is required");if(!Array.isArray(t))throw new Error("bbox must be an Array");if(4!==t.length&&6!==t.length)throw new Error("bbox must be an Array of 4 or 6 numbers");t.forEach((function(t){if(!f(t))throw new Error("bbox must only contain numbers")}))},e.validateId=function(t){if(!t)throw new Error("id is required");if(-1===["string","number"].indexOf(typeof t))throw new Error("id must be a number or a string")}},1540:(t,e,n)=>{"use strict";Object.defineProperty(e,"__esModule",{value:!0});var r=n(4102);function i(t,e,n){if(null!==t)for(var r,o,s,a,u,l,c,h,p=0,f=0,g=t.type,d="FeatureCollection"===g,y="Feature"===g,_=d?t.features.length:1,m=0;m<_;m++){u=(h=!!(c=d?t.features[m].geometry:y?t.geometry:t)&&"GeometryCollection"===c.type)?c.geometries.length:1;for(var v=0;v<u;v++){var x=0,b=0;if(null!==(a=h?c.geometries[v]:c)){l=a.coordinates;var E=a.type;switch(p=!n||"Polygon"!==E&&"MultiPolygon"!==E?0:1,E){case null:break;case"Point":if(!1===e(l,f,m,x,b))return!1;f++,x++;break;case"LineString":case"MultiPoint":for(r=0;r<l.length;r++){if(!1===e(l[r],f,m,x,b))return!1;f++,"MultiPoint"===E&&x++}"LineString"===E&&x++;break;case"Polygon":case"MultiLineString":for(r=0;r<l.length;r++){for(o=0;o<l[r].length-p;o++){if(!1===e(l[r][o],f,m,x,b))return!1;f++}"MultiLineString"===E&&x++,"Polygon"===E&&b++}"Polygon"===E&&x++;break;case"MultiPolygon":for(r=0;r<l.length;r++){for(b=0,o=0;o<l[r].length;o++){for(s=0;s<l[r][o].length-p;s++){if(!1===e(l[r][o][s],f,m,x,b))return!1;f++}b++}x++}break;case"GeometryCollection":for(r=0;r<a.geometries.length;r++)if(!1===i(a.geometries[r],e,n))return!1;break;default:throw new Error("Unknown Geometry Type")}}}}}function o(t,e){var n;switch(t.type){case"FeatureCollection":for(n=0;n<t.features.length&&!1!==e(t.features[n].properties,n);n++);break;case"Feature":e(t.properties,0)}}function s(t,e){if("Feature"===t.type)e(t,0);else if("FeatureCollection"===t.type)for(var n=0;n<t.features.length&&!1!==e(t.features[n],n);n++);}function a(t,e){var n,r,i,o,s,a,u,l,c,h,p=0,f="FeatureCollection"===t.type,g="Feature"===t.type,d=f?t.features.length:1;for(n=0;n<d;n++){for(a=f?t.features[n].geometry:g?t.geometry:t,l=f?t.features[n].properties:g?t.properties:{},c=f?t.features[n].bbox:g?t.bbox:void 0,h=f?t.features[n].id:g?t.id:void 0,s=(u=!!a&&"GeometryCollection"===a.type)?a.geometries.length:1,i=0;i<s;i++)if(null!==(o=u?a.geometries[i]:a))switch(o.type){case"Point":case"LineString":case"MultiPoint":case"Polygon":case"MultiLineString":case"MultiPolygon":if(!1===e(o,p,l,c,h))return!1;break;case"GeometryCollection":for(r=0;r<o.geometries.length;r++)if(!1===e(o.geometries[r],p,l,c,h))return!1;break;default:throw new Error("Unknown Geometry Type")}else if(!1===e(null,p,l,c,h))return!1;p++}}function u(t,e){a(t,(function(t,n,i,o,s){var a,u=null===t?null:t.type;switch(u){case null:case"Point":case"LineString":case"Polygon":return!1!==e(r.feature(t,i,{bbox:o,id:s}),n,0)&&void 0}switch(u){case"MultiPoint":a="Point";break;case"MultiLineString":a="LineString";break;case"MultiPolygon":a="Polygon"}for(var l=0;l<t.coordinates.length;l++){var c={type:a,coordinates:t.coordinates[l]};if(!1===e(r.feature(c,i),n,l))return!1}}))}function l(t,e){u(t,(function(t,n,o){var s=0;if(t.geometry){var a=t.geometry.type;if("Point"!==a&&"MultiPoint"!==a){var u,l=0,c=0,h=0;return!1!==i(t,(function(i,a,p,f,g){if(void 0===u||n>l||f>c||g>h)return u=i,l=n,c=f,h=g,void(s=0);var d=r.lineString([u,i],t.properties);if(!1===e(d,n,o,g,s))return!1;s++,u=i}))&&void 0}}}))}function c(t,e){if(!t)throw new Error("geojson is required");u(t,(function(t,n,i){if(null!==t.geometry){var o=t.geometry.type,s=t.geometry.coordinates;switch(o){case"LineString":if(!1===e(t,n,i,0,0))return!1;break;case"Polygon":for(var a=0;a<s.length;a++)if(!1===e(r.lineString(s[a],t.properties),n,i,a))return!1}}}))}e.coordAll=function(t){var e=[];return i(t,(function(t){e.push(t)})),e},e.coordEach=i,e.coordReduce=function(t,e,n,r){var o=n;return i(t,(function(t,r,i,s,a){o=0===r&&void 0===n?t:e(o,t,r,i,s,a)}),r),o},e.featureEach=s,e.featureReduce=function(t,e,n){var r=n;return s(t,(function(t,i){r=0===i&&void 0===n?t:e(r,t,i)})),r},e.findPoint=function(t,e){if(e=e||{},!r.isObject(e))throw new Error("options is invalid");var n,i=e.featureIndex||0,o=e.multiFeatureIndex||0,s=e.geometryIndex||0,a=e.coordIndex||0,u=e.properties;switch(t.type){case"FeatureCollection":i<0&&(i=t.features.length+i),u=u||t.features[i].properties,n=t.features[i].geometry;break;case"Feature":u=u||t.properties,n=t.geometry;break;case"Point":case"MultiPoint":return null;case"LineString":case"Polygon":case"MultiLineString":case"MultiPolygon":n=t;break;default:throw new Error("geojson is invalid")}if(null===n)return null;var l=n.coordinates;switch(n.type){case"Point":return r.point(l,u,e);case"MultiPoint":return o<0&&(o=l.length+o),r.point(l[o],u,e);case"LineString":return a<0&&(a=l.length+a),r.point(l[a],u,e);case"Polygon":return s<0&&(s=l.length+s),a<0&&(a=l[s].length+a),r.point(l[s][a],u,e);case"MultiLineString":return o<0&&(o=l.length+o),a<0&&(a=l[o].length+a),r.point(l[o][a],u,e);case"MultiPolygon":return o<0&&(o=l.length+o),s<0&&(s=l[o].length+s),a<0&&(a=l[o][s].length-a),r.point(l[o][s][a],u,e)}throw new Error("geojson is invalid")},e.findSegment=function(t,e){if(e=e||{},!r.isObject(e))throw new Error("options is invalid");var n,i=e.featureIndex||0,o=e.multiFeatureIndex||0,s=e.geometryIndex||0,a=e.segmentIndex||0,u=e.properties;switch(t.type){case"FeatureCollection":i<0&&(i=t.features.length+i),u=u||t.features[i].properties,n=t.features[i].geometry;break;case"Feature":u=u||t.properties,n=t.geometry;break;case"Point":case"MultiPoint":return null;case"LineString":case"Polygon":case"MultiLineString":case"MultiPolygon":n=t;break;default:throw new Error("geojson is invalid")}if(null===n)return null;var l=n.coordinates;switch(n.type){case"Point":case"MultiPoint":return null;case"LineString":return a<0&&(a=l.length+a-1),r.lineString([l[a],l[a+1]],u,e);case"Polygon":return s<0&&(s=l.length+s),a<0&&(a=l[s].length+a-1),r.lineString([l[s][a],l[s][a+1]],u,e);case"MultiLineString":return o<0&&(o=l.length+o),a<0&&(a=l[o].length+a-1),r.lineString([l[o][a],l[o][a+1]],u,e);case"MultiPolygon":return o<0&&(o=l.length+o),s<0&&(s=l[o].length+s),a<0&&(a=l[o][s].length-a-1),r.lineString([l[o][s][a],l[o][s][a+1]],u,e)}throw new Error("geojson is invalid")},e.flattenEach=u,e.flattenReduce=function(t,e,n){var r=n;return u(t,(function(t,i,o){r=0===i&&0===o&&void 0===n?t:e(r,t,i,o)})),r},e.geomEach=a,e.geomReduce=function(t,e,n){var r=n;return a(t,(function(t,i,o,s,a){r=0===i&&void 0===n?t:e(r,t,i,o,s,a)})),r},e.lineEach=c,e.lineReduce=function(t,e,n){var r=n;return c(t,(function(t,i,o,s){r=0===i&&void 0===n?t:e(r,t,i,o,s)})),r},e.propEach=o,e.propReduce=function(t,e,n){var r=n;return o(t,(function(t,i){r=0===i&&void 0===n?t:e(r,t,i)})),r},e.segmentEach=l,e.segmentReduce=function(t,e,n){var r=n,i=!1;return l(t,(function(t,o,s,a,u){r=!1===i&&void 0===n?t:e(r,t,o,s,a,u),i=!0})),r}},1924:(t,e,n)=>{"use strict";var r=n(210),i=n(5559),o=i(r("String.prototype.indexOf"));t.exports=function(t,e){var n=r(t,!!e);return"function"==typeof n&&o(t,".prototype.")>-1?i(n):n}},5559:(t,e,n)=>{"use strict";var r=n(8612),i=n(210),o=i("%Function.prototype.apply%"),s=i("%Function.prototype.call%"),a=i("%Reflect.apply%",!0)||r.call(s,o),u=i("%Object.getOwnPropertyDescriptor%",!0),l=i("%Object.defineProperty%",!0),c=i("%Math.max%");if(l)try{l({},"a",{value:1})}catch(t){l=null}t.exports=function(t){var e=a(r,s,arguments);if(u&&l){var n=u(e,"length");n.configurable&&l(e,"length",{value:1+c(0,t.length-(arguments.length-1))})}return e};var h=function(){return a(r,o,arguments)};l?l(t.exports,"apply",{value:h}):t.exports.apply=h},2273:(t,e,n)=>{"use strict";var r=n(1662),i=n(3842),o=n(6960),s=n(8639).orient2d;function a(t,e,n){e=Math.max(0,void 0===e?2:e),n=n||0;var i=function(t){for(var e=t[0],n=t[0],r=t[0],i=t[0],s=0;s<t.length;s++){var a=t[s];a[0]<e[0]&&(e=a),a[0]>r[0]&&(r=a),a[1]<n[1]&&(n=a),a[1]>i[1]&&(i=a)}var u=[e,n,r,i],l=u.slice();for(s=0;s<t.length;s++)o(t[s],u)||l.push(t[s]);return function(t){t.sort(v);for(var e=[],n=0;n<t.length;n++){for(;e.length>=2&&f(e[e.length-2],e[e.length-1],t[n])<=0;)e.pop();e.push(t[n])}for(var r=[],i=t.length-1;i>=0;i--){for(;r.length>=2&&f(r[r.length-2],r[r.length-1],t[i])<=0;)r.pop();r.push(t[i])}return r.pop(),e.pop(),e.concat(r)}(l)}(t),s=new r(16);s.toBBox=function(t){return{minX:t[0],minY:t[1],maxX:t[0],maxY:t[1]}},s.compareMinX=function(t,e){return t[0]-e[0]},s.compareMinY=function(t,e){return t[1]-e[1]},s.load(t);for(var a,l=[],c=0;c<i.length;c++){var h=i[c];s.remove(h),a=d(h,a),l.push(a)}var p=new r(16);for(c=0;c<l.length;c++)p.insert(g(l[c]));for(var _=e*e,m=n*n;l.length;){var x=l.shift(),b=x.p,E=x.next.p,I=y(b,E);if(!(I<m)){var C=I/_;(h=u(s,x.prev.p,b,E,x.next.next.p,C,p))&&Math.min(y(h,b),y(h,E))<=C&&(l.push(x),l.push(d(h,x)),s.remove(h),p.remove(x),p.insert(g(x)),p.insert(g(x.next)))}}x=a;var S=[];do{S.push(x.p),x=x.next}while(x!==a);return S.push(x.p),S}function u(t,e,n,r,o,s,a){for(var u=new i([],l),h=t.data;h;){for(var f=0;f<h.children.length;f++){var g=h.children[f],d=h.leaf?_(g,n,r):c(n,r,g);d>s||u.push({node:g,dist:d})}for(;u.length&&!u.peek().node.children;){var y=u.pop(),m=y.node,v=_(m,e,n),x=_(m,r,o);if(y.dist<v&&y.dist<x&&p(n,m,a)&&p(r,m,a))return m}(h=u.pop())&&(h=h.node)}return null}function l(t,e){return t.dist-e.dist}function c(t,e,n){if(h(t,n)||h(e,n))return 0;var r=m(t[0],t[1],e[0],e[1],n.minX,n.minY,n.maxX,n.minY);if(0===r)return 0;var i=m(t[0],t[1],e[0],e[1],n.minX,n.minY,n.minX,n.maxY);if(0===i)return 0;var o=m(t[0],t[1],e[0],e[1],n.maxX,n.minY,n.maxX,n.maxY);if(0===o)return 0;var s=m(t[0],t[1],e[0],e[1],n.minX,n.maxY,n.maxX,n.maxY);return 0===s?0:Math.min(r,i,o,s)}function h(t,e){return t[0]>=e.minX&&t[0]<=e.maxX&&t[1]>=e.minY&&t[1]<=e.maxY}function p(t,e,n){for(var r,i,o,s,a=Math.min(t[0],e[0]),u=Math.min(t[1],e[1]),l=Math.max(t[0],e[0]),c=Math.max(t[1],e[1]),h=n.search({minX:a,minY:u,maxX:l,maxY:c}),p=0;p<h.length;p++)if(r=h[p].p,i=h[p].next.p,o=t,r!==(s=e)&&i!==o&&f(r,i,o)>0!=f(r,i,s)>0&&f(o,s,r)>0!=f(o,s,i)>0)return!1;return!0}function f(t,e,n){return s(t[0],t[1],e[0],e[1],n[0],n[1])}function g(t){var e=t.p,n=t.next.p;return t.minX=Math.min(e[0],n[0]),t.minY=Math.min(e[1],n[1]),t.maxX=Math.max(e[0],n[0]),t.maxY=Math.max(e[1],n[1]),t}function d(t,e){var n={p:t,prev:null,next:null,minX:0,minY:0,maxX:0,maxY:0};return e?(n.next=e.next,n.prev=e,e.next.prev=n,e.next=n):(n.prev=n,n.next=n),n}function y(t,e){var n=t[0]-e[0],r=t[1]-e[1];return n*n+r*r}function _(t,e,n){var r=e[0],i=e[1],o=n[0]-r,s=n[1]-i;if(0!==o||0!==s){var a=((t[0]-r)*o+(t[1]-i)*s)/(o*o+s*s);a>1?(r=n[0],i=n[1]):a>0&&(r+=o*a,i+=s*a)}return(o=t[0]-r)*o+(s=t[1]-i)*s}function m(t,e,n,r,i,o,s,a){var u,l,c,h,p=n-t,f=r-e,g=s-i,d=a-o,y=t-i,_=e-o,m=p*p+f*f,v=p*g+f*d,x=g*g+d*d,b=p*y+f*_,E=g*y+d*_,I=m*x-v*v,C=I,S=I;0===I?(l=0,C=1,h=E,S=x):(h=m*E-v*b,(l=v*E-x*b)<0?(l=0,h=E,S=x):l>C&&(l=C,h=E+v,S=x)),h<0?(h=0,-b<0?l=0:-b>m?l=C:(l=-b,C=m)):h>S&&(h=S,-b+v<0?l=0:-b+v>m?l=C:(l=-b+v,C=m));var w=(1-(c=0===h?0:h/S))*i+c*s-((1-(u=0===l?0:l/C))*t+u*n),N=(1-c)*o+c*a-((1-u)*e+u*r);return w*w+N*N}function v(t,e){return t[0]===e[0]?t[1]-e[1]:t[0]-e[0]}i.default&&(i=i.default),t.exports=a,t.exports.default=a},1662:function(t){t.exports=function(){"use strict";function t(t,r,i,o,s){!function t(n,r,i,o,s){for(;o>i;){if(o-i>600){var a=o-i+1,u=r-i+1,l=Math.log(a),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(a-c)/a)*(u-a/2<0?-1:1);t(n,r,Math.max(i,Math.floor(r-u*c/a+h)),Math.min(o,Math.floor(r+(a-u)*c/a+h)),s)}var p=n[r],f=i,g=o;for(e(n,i,r),s(n[o],p)>0&&e(n,i,o);f<g;){for(e(n,f,g),f++,g--;s(n[f],p)<0;)f++;for(;s(n[g],p)>0;)g--}0===s(n[i],p)?e(n,i,g):e(n,++g,o),g<=r&&(i=g+1),r<=g&&(o=g-1)}}(t,r,i||0,o||t.length-1,s||n)}function e(t,e,n){var r=t[e];t[e]=t[n],t[n]=r}function n(t,e){return t<e?-1:t>e?1:0}var r=function(t){void 0===t&&(t=9),this._maxEntries=Math.max(4,t),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()};function i(t,e,n){if(!n)return e.indexOf(t);for(var r=0;r<e.length;r++)if(n(t,e[r]))return r;return-1}function o(t,e){s(t,0,t.children.length,e,t)}function s(t,e,n,r,i){i||(i=g(null)),i.minX=1/0,i.minY=1/0,i.maxX=-1/0,i.maxY=-1/0;for(var o=e;o<n;o++){var s=t.children[o];a(i,t.leaf?r(s):s)}return i}function a(t,e){return t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),t}function u(t,e){return t.minX-e.minX}function l(t,e){return t.minY-e.minY}function c(t){return(t.maxX-t.minX)*(t.maxY-t.minY)}function h(t){return t.maxX-t.minX+(t.maxY-t.minY)}function p(t,e){return t.minX<=e.minX&&t.minY<=e.minY&&e.maxX<=t.maxX&&e.maxY<=t.maxY}function f(t,e){return e.minX<=t.maxX&&e.minY<=t.maxY&&e.maxX>=t.minX&&e.maxY>=t.minY}function g(t){return{children:t,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function d(e,n,r,i,o){for(var s=[n,r];s.length;)if(!((r=s.pop())-(n=s.pop())<=i)){var a=n+Math.ceil((r-n)/i/2)*i;t(e,a,n,r,o),s.push(n,a,a,r)}}return r.prototype.all=function(){return this._all(this.data,[])},r.prototype.search=function(t){var e=this.data,n=[];if(!f(t,e))return n;for(var r=this.toBBox,i=[];e;){for(var o=0;o<e.children.length;o++){var s=e.children[o],a=e.leaf?r(s):s;f(t,a)&&(e.leaf?n.push(s):p(t,a)?this._all(s,n):i.push(s))}e=i.pop()}return n},r.prototype.collides=function(t){var e=this.data;if(!f(t,e))return!1;for(var n=[];e;){for(var r=0;r<e.children.length;r++){var i=e.children[r],o=e.leaf?this.toBBox(i):i;if(f(t,o)){if(e.leaf||p(t,o))return!0;n.push(i)}}e=n.pop()}return!1},r.prototype.load=function(t){if(!t||!t.length)return this;if(t.length<this._minEntries){for(var e=0;e<t.length;e++)this.insert(t[e]);return this}var n=this._build(t.slice(),0,t.length-1,0);if(this.data.children.length)if(this.data.height===n.height)this._splitRoot(this.data,n);else{if(this.data.height<n.height){var r=this.data;this.data=n,n=r}this._insert(n,this.data.height-n.height-1,!0)}else this.data=n;return this},r.prototype.insert=function(t){return t&&this._insert(t,this.data.height-1),this},r.prototype.clear=function(){return this.data=g([]),this},r.prototype.remove=function(t,e){if(!t)return this;for(var n,r,o,s=this.data,a=this.toBBox(t),u=[],l=[];s||u.length;){if(s||(s=u.pop(),r=u[u.length-1],n=l.pop(),o=!0),s.leaf){var c=i(t,s.children,e);if(-1!==c)return s.children.splice(c,1),u.push(s),this._condense(u),this}o||s.leaf||!p(s,a)?r?(n++,s=r.children[n],o=!1):s=null:(u.push(s),l.push(n),n=0,r=s,s=s.children[0])}return this},r.prototype.toBBox=function(t){return t},r.prototype.compareMinX=function(t,e){return t.minX-e.minX},r.prototype.compareMinY=function(t,e){return t.minY-e.minY},r.prototype.toJSON=function(){return this.data},r.prototype.fromJSON=function(t){return this.data=t,this},r.prototype._all=function(t,e){for(var n=[];t;)t.leaf?e.push.apply(e,t.children):n.push.apply(n,t.children),t=n.pop();return e},r.prototype._build=function(t,e,n,r){var i,s=n-e+1,a=this._maxEntries;if(s<=a)return o(i=g(t.slice(e,n+1)),this.toBBox),i;r||(r=Math.ceil(Math.log(s)/Math.log(a)),a=Math.ceil(s/Math.pow(a,r-1))),(i=g([])).leaf=!1,i.height=r;var u=Math.ceil(s/a),l=u*Math.ceil(Math.sqrt(a));d(t,e,n,l,this.compareMinX);for(var c=e;c<=n;c+=l){var h=Math.min(c+l-1,n);d(t,c,h,u,this.compareMinY);for(var p=c;p<=h;p+=u){var f=Math.min(p+u-1,h);i.children.push(this._build(t,p,f,r-1))}}return o(i,this.toBBox),i},r.prototype._chooseSubtree=function(t,e,n,r){for(;r.push(e),!e.leaf&&r.length-1!==n;){for(var i=1/0,o=1/0,s=void 0,a=0;a<e.children.length;a++){var u=e.children[a],l=c(u),h=(p=t,f=u,(Math.max(f.maxX,p.maxX)-Math.min(f.minX,p.minX))*(Math.max(f.maxY,p.maxY)-Math.min(f.minY,p.minY))-l);h<o?(o=h,i=l<i?l:i,s=u):h===o&&l<i&&(i=l,s=u)}e=s||e.children[0]}var p,f;return e},r.prototype._insert=function(t,e,n){var r=n?t:this.toBBox(t),i=[],o=this._chooseSubtree(r,this.data,e,i);for(o.children.push(t),a(o,r);e>=0&&i[e].children.length>this._maxEntries;)this._split(i,e),e--;this._adjustParentBBoxes(r,i,e)},r.prototype._split=function(t,e){var n=t[e],r=n.children.length,i=this._minEntries;this._chooseSplitAxis(n,i,r);var s=this._chooseSplitIndex(n,i,r),a=g(n.children.splice(s,n.children.length-s));a.height=n.height,a.leaf=n.leaf,o(n,this.toBBox),o(a,this.toBBox),e?t[e-1].children.push(a):this._splitRoot(n,a)},r.prototype._splitRoot=function(t,e){this.data=g([t,e]),this.data.height=t.height+1,this.data.leaf=!1,o(this.data,this.toBBox)},r.prototype._chooseSplitIndex=function(t,e,n){for(var r,i,o,a,u,l,h,p=1/0,f=1/0,g=e;g<=n-e;g++){var d=s(t,0,g,this.toBBox),y=s(t,g,n,this.toBBox),_=(i=d,o=y,void 0,void 0,void 0,void 0,a=Math.max(i.minX,o.minX),u=Math.max(i.minY,o.minY),l=Math.min(i.maxX,o.maxX),h=Math.min(i.maxY,o.maxY),Math.max(0,l-a)*Math.max(0,h-u)),m=c(d)+c(y);_<p?(p=_,r=g,f=m<f?m:f):_===p&&m<f&&(f=m,r=g)}return r||n-e},r.prototype._chooseSplitAxis=function(t,e,n){var r=t.leaf?this.compareMinX:u,i=t.leaf?this.compareMinY:l;this._allDistMargin(t,e,n,r)<this._allDistMargin(t,e,n,i)&&t.children.sort(r)},r.prototype._allDistMargin=function(t,e,n,r){t.children.sort(r);for(var i=this.toBBox,o=s(t,0,e,i),u=s(t,n-e,n,i),l=h(o)+h(u),c=e;c<n-e;c++){var p=t.children[c];a(o,t.leaf?i(p):p),l+=h(o)}for(var f=n-e-1;f>=e;f--){var g=t.children[f];a(u,t.leaf?i(g):g),l+=h(u)}return l},r.prototype._adjustParentBBoxes=function(t,e,n){for(var r=n;r>=0;r--)a(e[r],t)},r.prototype._condense=function(t){for(var e=t.length-1,n=void 0;e>=0;e--)0===t[e].children.length?e>0?(n=t[e-1].children).splice(n.indexOf(t[e]),1):this.clear():o(t[e],this.toBBox)},r}()},6251:t=>{var e;e={rad:{name:{singular:"radian",plural:"radians"},to_anchor:180/Math.PI},deg:{name:{singular:"degree",plural:"degrees"},to_anchor:1},grad:{name:{singular:"gradian",plural:"gradians"},to_anchor:.9},arcmin:{name:{singular:"arcminute",plural:"arcminutes"},to_anchor:1/60},arcsec:{name:{singular:"arcsecond",plural:"arcseconds"},to_anchor:1/3600}},t.exports={metric:e,_anchors:{metric:{unit:"deg",ratio:1}}}},7704:t=>{var e;e={VA:{name:{singular:"Volt-Ampere",plural:"Volt-Amperes"},to_anchor:1},mVA:{name:{singular:"Millivolt-Ampere",plural:"Millivolt-Amperes"},to_anchor:.001},kVA:{name:{singular:"Kilovolt-Ampere",plural:"Kilovolt-Amperes"},to_anchor:1e3},MVA:{name:{singular:"Megavolt-Ampere",plural:"Megavolt-Amperes"},to_anchor:1e6},GVA:{name:{singular:"Gigavolt-Ampere",plural:"Gigavolt-Amperes"},to_anchor:1e9}},t.exports={metric:e,_anchors:{metric:{unit:"VA",ratio:1}}}},1328:t=>{var e,n;e={mm2:{name:{singular:"Square Millimeter",plural:"Square Millimeters"},to_anchor:1e-6},cm2:{name:{singular:"Centimeter",plural:"Centimeters"},to_anchor:1e-4},m2:{name:{singular:"Square Meter",plural:"Square Meters"},to_anchor:1},ha:{name:{singular:"Hectare",plural:"Hectares"},to_anchor:1e4},km2:{name:{singular:"Square Kilometer",plural:"Square Kilometers"},to_anchor:1e6}},n={in2:{name:{singular:"Square Inch",plural:"Square Inches"},to_anchor:1/144},yd2:{name:{singular:"Square Yard",plural:"Square Yards"},to_anchor:9},ft2:{name:{singular:"Square Foot",plural:"Square Feet"},to_anchor:1},ac:{name:{singular:"Acre",plural:"Acres"},to_anchor:43560},mi2:{name:{singular:"Square Mile",plural:"Square Miles"},to_anchor:27878400}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"m2",ratio:10.7639},imperial:{unit:"ft2",ratio:1/10.7639}}}},7489:t=>{var e;e={A:{name:{singular:"Ampere",plural:"Amperes"},to_anchor:1},mA:{name:{singular:"Milliampere",plural:"Milliamperes"},to_anchor:.001},kA:{name:{singular:"Kiloampere",plural:"Kiloamperes"},to_anchor:1e3}},t.exports={metric:e,_anchors:{metric:{unit:"A",ratio:1}}}},4097:t=>{var e,n;e={b:{name:{singular:"Bit",plural:"Bits"},to_anchor:1},Kb:{name:{singular:"Kilobit",plural:"Kilobits"},to_anchor:1024},Mb:{name:{singular:"Megabit",plural:"Megabits"},to_anchor:1048576},Gb:{name:{singular:"Gigabit",plural:"Gigabits"},to_anchor:1073741824},Tb:{name:{singular:"Terabit",plural:"Terabits"},to_anchor:1099511627776}},n={B:{name:{singular:"Byte",plural:"Bytes"},to_anchor:1},KB:{name:{singular:"Kilobyte",plural:"Kilobytes"},to_anchor:1024},MB:{name:{singular:"Megabyte",plural:"Megabytes"},to_anchor:1048576},GB:{name:{singular:"Gigabyte",plural:"Gigabytes"},to_anchor:1073741824},TB:{name:{singular:"Terabyte",plural:"Terabytes"},to_anchor:1099511627776}},t.exports={bits:e,bytes:n,_anchors:{bits:{unit:"b",ratio:1/8},bytes:{unit:"B",ratio:8}}}},4638:t=>{var e;e={ea:{name:{singular:"Each",plural:"Each"},to_anchor:1},dz:{name:{singular:"Dozen",plural:"Dozens"},to_anchor:12}},t.exports={metric:e,imperial:{},_anchors:{metric:{unit:"ea",ratio:1}}}},8188:t=>{var e;e={Wh:{name:{singular:"Watt-hour",plural:"Watt-hours"},to_anchor:3600},mWh:{name:{singular:"Milliwatt-hour",plural:"Milliwatt-hours"},to_anchor:3.6},kWh:{name:{singular:"Kilowatt-hour",plural:"Kilowatt-hours"},to_anchor:36e5},MWh:{name:{singular:"Megawatt-hour",plural:"Megawatt-hours"},to_anchor:36e8},GWh:{name:{singular:"Gigawatt-hour",plural:"Gigawatt-hours"},to_anchor:36e11},J:{name:{singular:"Joule",plural:"Joules"},to_anchor:1},kJ:{name:{singular:"Kilojoule",plural:"Kilojoules"},to_anchor:1e3}},t.exports={metric:e,_anchors:{metric:{unit:"J",ratio:1}}}},8826:t=>{var e;e={mHz:{name:{singular:"millihertz",plural:"millihertz"},to_anchor:.001},Hz:{name:{singular:"hertz",plural:"hertz"},to_anchor:1},kHz:{name:{singular:"kilohertz",plural:"kilohertz"},to_anchor:1e3},MHz:{name:{singular:"megahertz",plural:"megahertz"},to_anchor:1e6},GHz:{name:{singular:"gigahertz",plural:"gigahertz"},to_anchor:1e9},THz:{name:{singular:"terahertz",plural:"terahertz"},to_anchor:1e12},rpm:{name:{singular:"rotation per minute",plural:"rotations per minute"},to_anchor:1/60},"deg/s":{name:{singular:"degree per second",plural:"degrees per second"},to_anchor:1/360},"rad/s":{name:{singular:"radian per second",plural:"radians per second"},to_anchor:1/(2*Math.PI)}},t.exports={metric:e,_anchors:{frequency:{unit:"hz",ratio:1}}}},2731:t=>{var e,n;e={lx:{name:{singular:"Lux",plural:"Lux"},to_anchor:1}},n={"ft-cd":{name:{singular:"Foot-candle",plural:"Foot-candles"},to_anchor:1}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"lx",ratio:1/10.76391},imperial:{unit:"ft-cd",ratio:10.76391}}}},2651:t=>{var e,n;e={mm:{name:{singular:"Millimeter",plural:"Millimeters"},to_anchor:.001},cm:{name:{singular:"Centimeter",plural:"Centimeters"},to_anchor:.01},m:{name:{singular:"Meter",plural:"Meters"},to_anchor:1},km:{name:{singular:"Kilometer",plural:"Kilometers"},to_anchor:1e3}},n={in:{name:{singular:"Inch",plural:"Inches"},to_anchor:1/12},yd:{name:{singular:"Yard",plural:"Yards"},to_anchor:3},"ft-us":{name:{singular:"US Survey Foot",plural:"US Survey Feet"},to_anchor:1.000002},ft:{name:{singular:"Foot",plural:"Feet"},to_anchor:1},mi:{name:{singular:"Mile",plural:"Miles"},to_anchor:5280}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"m",ratio:3.28084},imperial:{unit:"ft",ratio:1/3.28084}}}},8619:t=>{var e,n;e={mcg:{name:{singular:"Microgram",plural:"Micrograms"},to_anchor:1e-6},mg:{name:{singular:"Milligram",plural:"Milligrams"},to_anchor:.001},g:{name:{singular:"Gram",plural:"Grams"},to_anchor:1},kg:{name:{singular:"Kilogram",plural:"Kilograms"},to_anchor:1e3},mt:{name:{singular:"Metric Tonne",plural:"Metric Tonnes"},to_anchor:1e6}},n={oz:{name:{singular:"Ounce",plural:"Ounces"},to_anchor:1/16},lb:{name:{singular:"Pound",plural:"Pounds"},to_anchor:1},t:{name:{singular:"Ton",plural:"Tons"},to_anchor:2e3}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"g",ratio:1/453.592},imperial:{unit:"lb",ratio:453.592}}}},8836:t=>{var e,n;e={"min/km":{name:{singular:"Minute per kilometre",plural:"Minutes per kilometre"},to_anchor:.06},"s/m":{name:{singular:"Second per metre",plural:"Seconds per metre"},to_anchor:1}},n={"min/mi":{name:{singular:"Minute per mile",plural:"Minutes per mile"},to_anchor:.0113636},"s/ft":{name:{singular:"Second per foot",plural:"Seconds per foot"},to_anchor:1}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"s/m",ratio:.3048},imperial:{unit:"s/ft",ratio:1/.3048}}}},9319:t=>{var e;e={ppm:{name:{singular:"Part-per Million",plural:"Parts-per Million"},to_anchor:1},ppb:{name:{singular:"Part-per Billion",plural:"Parts-per Billion"},to_anchor:.001},ppt:{name:{singular:"Part-per Trillion",plural:"Parts-per Trillion"},to_anchor:1e-6},ppq:{name:{singular:"Part-per Quadrillion",plural:"Parts-per Quadrillion"},to_anchor:1e-9}},t.exports={metric:e,imperial:{},_anchors:{metric:{unit:"ppm",ratio:1e-6}}}},6354:t=>{var e;e={W:{name:{singular:"Watt",plural:"Watts"},to_anchor:1},mW:{name:{singular:"Milliwatt",plural:"Milliwatts"},to_anchor:.001},kW:{name:{singular:"Kilowatt",plural:"Kilowatts"},to_anchor:1e3},MW:{name:{singular:"Megawatt",plural:"Megawatts"},to_anchor:1e6},GW:{name:{singular:"Gigawatt",plural:"Gigawatts"},to_anchor:1e9}},t.exports={metric:e,_anchors:{metric:{unit:"W",ratio:1}}}},1553:t=>{var e,n;e={Pa:{name:{singular:"pascal",plural:"pascals"},to_anchor:.001},kPa:{name:{singular:"kilopascal",plural:"kilopascals"},to_anchor:1},MPa:{name:{singular:"megapascal",plural:"megapascals"},to_anchor:1e3},hPa:{name:{singular:"hectopascal",plural:"hectopascals"},to_anchor:.1},bar:{name:{singular:"bar",plural:"bar"},to_anchor:100},torr:{name:{singular:"torr",plural:"torr"},to_anchor:101325/76e4}},n={psi:{name:{singular:"pound per square inch",plural:"pounds per square inch"},to_anchor:.001},ksi:{name:{singular:"kilopound per square inch",plural:"kilopound per square inch"},to_anchor:1}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"kPa",ratio:.00014503768078},imperial:{unit:"psi",ratio:6894.76000045014}}}},6289:t=>{var e;e={VARh:{name:{singular:"Volt-Ampere Reactive Hour",plural:"Volt-Amperes Reactive Hour"},to_anchor:1},mVARh:{name:{singular:"Millivolt-Ampere Reactive Hour",plural:"Millivolt-Amperes Reactive Hour"},to_anchor:.001},kVARh:{name:{singular:"Kilovolt-Ampere Reactive Hour",plural:"Kilovolt-Amperes Reactive Hour"},to_anchor:1e3},MVARh:{name:{singular:"Megavolt-Ampere Reactive Hour",plural:"Megavolt-Amperes Reactive Hour"},to_anchor:1e6},GVARh:{name:{singular:"Gigavolt-Ampere Reactive Hour",plural:"Gigavolt-Amperes Reactive Hour"},to_anchor:1e9}},t.exports={metric:e,_anchors:{metric:{unit:"VARh",ratio:1}}}},3628:t=>{var e;e={VAR:{name:{singular:"Volt-Ampere Reactive",plural:"Volt-Amperes Reactive"},to_anchor:1},mVAR:{name:{singular:"Millivolt-Ampere Reactive",plural:"Millivolt-Amperes Reactive"},to_anchor:.001},kVAR:{name:{singular:"Kilovolt-Ampere Reactive",plural:"Kilovolt-Amperes Reactive"},to_anchor:1e3},MVAR:{name:{singular:"Megavolt-Ampere Reactive",plural:"Megavolt-Amperes Reactive"},to_anchor:1e6},GVAR:{name:{singular:"Gigavolt-Ampere Reactive",plural:"Gigavolt-Amperes Reactive"},to_anchor:1e9}},t.exports={metric:e,_anchors:{metric:{unit:"VAR",ratio:1}}}},1650:t=>{var e,n;e={"m/s":{name:{singular:"Metre per second",plural:"Metres per second"},to_anchor:3.6},"km/h":{name:{singular:"Kilometre per hour",plural:"Kilometres per hour"},to_anchor:1}},n={"m/h":{name:{singular:"Mile per hour",plural:"Miles per hour"},to_anchor:1},knot:{name:{singular:"Knot",plural:"Knots"},to_anchor:1.150779},"ft/s":{name:{singular:"Foot per second",plural:"Feet per second"},to_anchor:.681818}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"km/h",ratio:1/1.609344},imperial:{unit:"m/h",ratio:1.609344}}}},6496:t=>{var e,n;e={C:{name:{singular:"degree Celsius",plural:"degrees Celsius"},to_anchor:1,anchor_shift:0},K:{name:{singular:"degree Kelvin",plural:"degrees Kelvin"},to_anchor:1,anchor_shift:273.15}},n={F:{name:{singular:"degree Fahrenheit",plural:"degrees Fahrenheit"},to_anchor:1},R:{name:{singular:"degree Rankine",plural:"degrees Rankine"},to_anchor:1,anchor_shift:459.67}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"C",transform:function(t){return t/(5/9)+32}},imperial:{unit:"F",transform:function(t){return 5/9*(t-32)}}}}},7963:t=>{var e;e={ns:{name:{singular:"Nanosecond",plural:"Nanoseconds"},to_anchor:1e-9},mu:{name:{singular:"Microsecond",plural:"Microseconds"},to_anchor:1e-6},ms:{name:{singular:"Millisecond",plural:"Milliseconds"},to_anchor:.001},s:{name:{singular:"Second",plural:"Seconds"},to_anchor:1},min:{name:{singular:"Minute",plural:"Minutes"},to_anchor:60},h:{name:{singular:"Hour",plural:"Hours"},to_anchor:3600},d:{name:{singular:"Day",plural:"Days"},to_anchor:86400},week:{name:{singular:"Week",plural:"Weeks"},to_anchor:604800},month:{name:{singular:"Month",plural:"Months"},to_anchor:2629800},year:{name:{singular:"Year",plural:"Years"},to_anchor:31557600}},t.exports={metric:e,_anchors:{metric:{unit:"s",ratio:1}}}},2684:t=>{var e;e={V:{name:{singular:"Volt",plural:"Volts"},to_anchor:1},mV:{name:{singular:"Millivolt",plural:"Millivolts"},to_anchor:.001},kV:{name:{singular:"Kilovolt",plural:"Kilovolts"},to_anchor:1e3}},t.exports={metric:e,_anchors:{metric:{unit:"V",ratio:1}}}},7977:t=>{var e,n;e={mm3:{name:{singular:"Cubic Millimeter",plural:"Cubic Millimeters"},to_anchor:1e-6},cm3:{name:{singular:"Cubic Centimeter",plural:"Cubic Centimeters"},to_anchor:.001},ml:{name:{singular:"Millilitre",plural:"Millilitres"},to_anchor:.001},cl:{name:{singular:"Centilitre",plural:"Centilitres"},to_anchor:.01},dl:{name:{singular:"Decilitre",plural:"Decilitres"},to_anchor:.1},l:{name:{singular:"Litre",plural:"Litres"},to_anchor:1},kl:{name:{singular:"Kilolitre",plural:"Kilolitres"},to_anchor:1e3},m3:{name:{singular:"Cubic meter",plural:"Cubic meters"},to_anchor:1e3},km3:{name:{singular:"Cubic kilometer",plural:"Cubic kilometers"},to_anchor:1e12},krm:{name:{singular:"Matsked",plural:"Matskedar"},to_anchor:.001},tsk:{name:{singular:"Tesked",plural:"Teskedar"},to_anchor:.005},msk:{name:{singular:"Matsked",plural:"Matskedar"},to_anchor:.015},kkp:{name:{singular:"Kaffekopp",plural:"Kaffekoppar"},to_anchor:.15},glas:{name:{singular:"Glas",plural:"Glas"},to_anchor:.2},kanna:{name:{singular:"Kanna",plural:"Kannor"},to_anchor:2.617}},n={tsp:{name:{singular:"Teaspoon",plural:"Teaspoons"},to_anchor:1/6},Tbs:{name:{singular:"Tablespoon",plural:"Tablespoons"},to_anchor:.5},in3:{name:{singular:"Cubic inch",plural:"Cubic inches"},to_anchor:.55411},"fl-oz":{name:{singular:"Fluid Ounce",plural:"Fluid Ounces"},to_anchor:1},cup:{name:{singular:"Cup",plural:"Cups"},to_anchor:8},pnt:{name:{singular:"Pint",plural:"Pints"},to_anchor:16},qt:{name:{singular:"Quart",plural:"Quarts"},to_anchor:32},gal:{name:{singular:"Gallon",plural:"Gallons"},to_anchor:128},ft3:{name:{singular:"Cubic foot",plural:"Cubic feet"},to_anchor:957.506},yd3:{name:{singular:"Cubic yard",plural:"Cubic yards"},to_anchor:25852.7}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"l",ratio:33.8140226},imperial:{unit:"fl-oz",ratio:1/33.8140226}}}},3457:t=>{var e,n;e={"mm3/s":{name:{singular:"Cubic Millimeter per second",plural:"Cubic Millimeters per second"},to_anchor:1e-6},"cm3/s":{name:{singular:"Cubic Centimeter per second",plural:"Cubic Centimeters per second"},to_anchor:.001},"ml/s":{name:{singular:"Millilitre per second",plural:"Millilitres per second"},to_anchor:.001},"cl/s":{name:{singular:"Centilitre per second",plural:"Centilitres per second"},to_anchor:.01},"dl/s":{name:{singular:"Decilitre per second",plural:"Decilitres per second"},to_anchor:.1},"l/s":{name:{singular:"Litre per second",plural:"Litres per second"},to_anchor:1},"l/min":{name:{singular:"Litre per minute",plural:"Litres per minute"},to_anchor:1/60},"l/h":{name:{singular:"Litre per hour",plural:"Litres per hour"},to_anchor:1/3600},"kl/s":{name:{singular:"Kilolitre per second",plural:"Kilolitres per second"},to_anchor:1e3},"kl/min":{name:{singular:"Kilolitre per minute",plural:"Kilolitres per minute"},to_anchor:50/3},"kl/h":{name:{singular:"Kilolitre per hour",plural:"Kilolitres per hour"},to_anchor:5/18},"m3/s":{name:{singular:"Cubic meter per second",plural:"Cubic meters per second"},to_anchor:1e3},"m3/min":{name:{singular:"Cubic meter per minute",plural:"Cubic meters per minute"},to_anchor:50/3},"m3/h":{name:{singular:"Cubic meter per hour",plural:"Cubic meters per hour"},to_anchor:5/18},"km3/s":{name:{singular:"Cubic kilometer per second",plural:"Cubic kilometers per second"},to_anchor:1e12}},n={"tsp/s":{name:{singular:"Teaspoon per second",plural:"Teaspoons per second"},to_anchor:1/6},"Tbs/s":{name:{singular:"Tablespoon per second",plural:"Tablespoons per second"},to_anchor:.5},"in3/s":{name:{singular:"Cubic inch per second",plural:"Cubic inches per second"},to_anchor:.55411},"in3/min":{name:{singular:"Cubic inch per minute",plural:"Cubic inches per minute"},to_anchor:.55411/60},"in3/h":{name:{singular:"Cubic inch per hour",plural:"Cubic inches per hour"},to_anchor:.55411/3600},"fl-oz/s":{name:{singular:"Fluid Ounce per second",plural:"Fluid Ounces per second"},to_anchor:1},"fl-oz/min":{name:{singular:"Fluid Ounce per minute",plural:"Fluid Ounces per minute"},to_anchor:1/60},"fl-oz/h":{name:{singular:"Fluid Ounce per hour",plural:"Fluid Ounces per hour"},to_anchor:1/3600},"cup/s":{name:{singular:"Cup per second",plural:"Cups per second"},to_anchor:8},"pnt/s":{name:{singular:"Pint per second",plural:"Pints per second"},to_anchor:16},"pnt/min":{name:{singular:"Pint per minute",plural:"Pints per minute"},to_anchor:4/15},"pnt/h":{name:{singular:"Pint per hour",plural:"Pints per hour"},to_anchor:1/225},"qt/s":{name:{singular:"Quart per second",plural:"Quarts per second"},to_anchor:32},"gal/s":{name:{singular:"Gallon per second",plural:"Gallons per second"},to_anchor:128},"gal/min":{name:{singular:"Gallon per minute",plural:"Gallons per minute"},to_anchor:32/15},"gal/h":{name:{singular:"Gallon per hour",plural:"Gallons per hour"},to_anchor:8/225},"ft3/s":{name:{singular:"Cubic foot per second",plural:"Cubic feet per second"},to_anchor:957.506},"ft3/min":{name:{singular:"Cubic foot per minute",plural:"Cubic feet per minute"},to_anchor:957.506/60},"ft3/h":{name:{singular:"Cubic foot per hour",plural:"Cubic feet per hour"},to_anchor:957.506/3600},"yd3/s":{name:{singular:"Cubic yard per second",plural:"Cubic yards per second"},to_anchor:25852.7},"yd3/min":{name:{singular:"Cubic yard per minute",plural:"Cubic yards per minute"},to_anchor:25852.7/60},"yd3/h":{name:{singular:"Cubic yard per hour",plural:"Cubic yards per hour"},to_anchor:25852.7/3600}},t.exports={metric:e,imperial:n,_anchors:{metric:{unit:"l/s",ratio:33.8140227},imperial:{unit:"fl-oz/s",ratio:1/33.8140227}}}},3381:(t,e,n)=>{var r,i,o=n(4799),s=n(3590),a={length:n(2651),area:n(1328),mass:n(8619),volume:n(7977),each:n(4638),temperature:n(6496),time:n(7963),digital:n(4097),partsPer:n(9319),speed:n(1650),pace:n(8836),pressure:n(1553),current:n(7489),voltage:n(2684),power:n(6354),reactivePower:n(3628),apparentPower:n(7704),energy:n(8188),reactiveEnergy:n(6289),volumeFlowRate:n(3457),illuminance:n(2731),frequency:n(8826),angle:n(6251)};(i=function(t,e){this.val=e?t/e:t}).prototype.from=function(t){if(this.destination)throw new Error(".from must be called before .to");return this.origin=this.getUnit(t),this.origin||this.throwUnsupportedUnitError(t),this},i.prototype.to=function(t){if(!this.origin)throw new Error(".to must be called after .from");var e,n;if(this.destination=this.getUnit(t),this.destination||this.throwUnsupportedUnitError(t),this.origin.abbr===this.destination.abbr)return this.val;if(this.destination.measure!=this.origin.measure)throw new Error("Cannot convert incompatible measures of "+this.destination.measure+" and "+this.origin.measure);return e=this.val*this.origin.unit.to_anchor,this.origin.unit.anchor_shift&&(e-=this.origin.unit.anchor_shift),this.origin.system!=this.destination.system&&("function"==typeof(n=a[this.origin.measure]._anchors[this.origin.system].transform)?e=n(e):e*=a[this.origin.measure]._anchors[this.origin.system].ratio),this.destination.unit.anchor_shift&&(e+=this.destination.unit.anchor_shift),e/this.destination.unit.to_anchor},i.prototype.toBest=function(t){if(!this.origin)throw new Error(".toBest must be called after .from");var e;return t=Object.assign({exclude:[],cutOffNumber:1},t),s(this.possibilities(),function(n){var r=this.describe(n);if(-1===t.exclude.indexOf(n)&&r.system===this.origin.system){var i=this.to(n);(!e||i>=t.cutOffNumber&&i<e.val)&&(e={val:i,unit:n,singular:r.singular,plural:r.plural})}}.bind(this)),e},i.prototype.getUnit=function(t){var e;return s(a,(function(n,r){if(s(n,(function(n,i){return"_anchors"!=i&&(s(n,(function(n,o){if(o==t)return e={abbr:t,measure:r,system:i,unit:n},!1})),!e&&void 0)})),e)return!1})),e};var u=function(t){return{abbr:t.abbr,measure:t.measure,system:t.system,singular:t.unit.name.singular,plural:t.unit.name.plural}};i.prototype.describe=function(t){var e=i.prototype.getUnit(t),n=null;try{n=u(e)}catch(e){this.throwUnsupportedUnitError(t)}return n},i.prototype.list=function(t){var e=[];return s(a,(function(n,r){t&&t!==r||s(n,(function(t,n){if("_anchors"==n)return!1;s(t,(function(t,i){e=e.concat(u({abbr:i,measure:r,system:n,unit:t}))}))}))})),e},i.prototype.throwUnsupportedUnitError=function(t){var e=[];throw s(a,(function(t,n){s(t,(function(t,n){if("_anchors"==n)return!1;e=e.concat(o(t))}))})),new Error("Unsupported unit "+t+", use one of: "+e.join(", "))},i.prototype.possibilities=function(t){var e=[];return this.origin||t?(t=t||this.origin.measure,s(a[t],(function(t,n){if("_anchors"==n)return!1;e=e.concat(o(t))}))):s(o(a),(function(t){s(a[t],(function(t,n){if("_anchors"==n)return!1;e=e.concat(o(t))}))})),e},i.prototype.measures=function(){return o(a)},r=function(t){return new i(t)},t.exports=r},251:(t,e,n)=>{var r=n(2215),i=n(2584),o=n(609),s=n(8420),a=n(2847),u=n(8923),l=Date.prototype.getTime;function c(t){return null==t}function h(t){return!(!t||"object"!=typeof t||"number"!=typeof t.length||"function"!=typeof t.copy||"function"!=typeof t.slice||t.length>0&&"number"!=typeof t[0])}t.exports=function t(e,n,p){var f=p||{};return!!(f.strict?o(e,n):e===n)||(!e||!n||"object"!=typeof e&&"object"!=typeof n?f.strict?o(e,n):e==n:function(e,n,o){var p,f;if(typeof e!=typeof n)return!1;if(c(e)||c(n))return!1;if(e.prototype!==n.prototype)return!1;if(i(e)!==i(n))return!1;var g=s(e),d=s(n);if(g!==d)return!1;if(g||d)return e.source===n.source&&a(e)===a(n);if(u(e)&&u(n))return l.call(e)===l.call(n);var y=h(e),_=h(n);if(y!==_)return!1;if(y||_){if(e.length!==n.length)return!1;for(p=0;p<e.length;p++)if(e[p]!==n[p])return!1;return!0}if(typeof e!=typeof n)return!1;try{var m=r(e),v=r(n)}catch(t){return!1}if(m.length!==v.length)return!1;for(m.sort(),v.sort(),p=m.length-1;p>=0;p--)if(m[p]!=v[p])return!1;for(p=m.length-1;p>=0;p--)if(!t(e[f=m[p]],n[f],o))return!1;return!0}(e,n,f))}},4289:(t,e,n)=>{"use strict";var r=n(2215),i="function"==typeof Symbol&&"symbol"==typeof Symbol("foo"),o=Object.prototype.toString,s=Array.prototype.concat,a=Object.defineProperty,u=n(1044)(),l=a&&u,c=function(t,e,n,r){var i;(!(e in t)||"function"==typeof(i=r)&&"[object Function]"===o.call(i)&&r())&&(l?a(t,e,{configurable:!0,enumerable:!1,value:n,writable:!0}):t[e]=n)},h=function(t,e){var n=arguments.length>2?arguments[2]:{},o=r(e);i&&(o=s.call(o,Object.getOwnPropertySymbols(e)));for(var a=0;a<o.length;a+=1)c(t,o[a],e[o[a]],n[o[a]])};h.supportsDescriptors=!!l,t.exports=h},8317:t=>{function e(t,e,n,r){this.dataset=[],this.epsilon=1,this.minPts=2,this.distance=this._euclideanDistance,this.clusters=[],this.noise=[],this._visited=[],this._assigned=[],this._datasetLength=0,this._init(t,e,n,r)}e.prototype.run=function(t,e,n,r){this._init(t,e,n,r);for(var i=0;i<this._datasetLength;i++)if(1!==this._visited[i]){this._visited[i]=1;var o=this._regionQuery(i);if(o.length<this.minPts)this.noise.push(i);else{var s=this.clusters.length;this.clusters.push([]),this._addToCluster(i,s),this._expandCluster(s,o)}}return this.clusters},e.prototype._init=function(t,e,n,r){if(t){if(!(t instanceof Array))throw Error("Dataset must be of type array, "+typeof t+" given");this.dataset=t,this.clusters=[],this.noise=[],this._datasetLength=t.length,this._visited=new Array(this._datasetLength),this._assigned=new Array(this._datasetLength)}e&&(this.epsilon=e),n&&(this.minPts=n),r&&(this.distance=r)},e.prototype._expandCluster=function(t,e){for(var n=0;n<e.length;n++){var r=e[n];if(1!==this._visited[r]){this._visited[r]=1;var i=this._regionQuery(r);i.length>=this.minPts&&(e=this._mergeArrays(e,i))}1!==this._assigned[r]&&this._addToCluster(r,t)}},e.prototype._addToCluster=function(t,e){this.clusters[e].push(t),this._assigned[t]=1},e.prototype._regionQuery=function(t){for(var e=[],n=0;n<this._datasetLength;n++)this.distance(this.dataset[t],this.dataset[n])<this.epsilon&&e.push(n);return e},e.prototype._mergeArrays=function(t,e){for(var n=e.length,r=0;r<n;r++){var i=e[r];t.indexOf(i)<0&&t.push(i)}return t},e.prototype._euclideanDistance=function(t,e){for(var n=0,r=Math.min(t.length,e.length);r--;)n+=(t[r]-e[r])*(t[r]-e[r]);return Math.sqrt(n)},t.exports&&(t.exports=e)},3781:t=>{function e(t,e,n){this.k=3,this.dataset=[],this.assignments=[],this.centroids=[],this.init(t,e,n)}e.prototype.init=function(t,e,n){this.assignments=[],this.centroids=[],void 0!==t&&(this.dataset=t),void 0!==e&&(this.k=e),void 0!==n&&(this.distance=n)},e.prototype.run=function(t,e){this.init(t,e);for(var n=this.dataset.length,r=0;r<this.k;r++)this.centroids[r]=this.randomCentroid();for(var i=!0;i;){i=this.assign();for(var o=0;o<this.k;o++){for(var s=new Array(c),a=0,u=0;u<c;u++)s[u]=0;for(var l=0;l<n;l++){var c=this.dataset[l].length;if(o===this.assignments[l]){for(u=0;u<c;u++)s[u]+=this.dataset[l][u];a++}}if(a>0){for(u=0;u<c;u++)s[u]/=a;this.centroids[o]=s}else this.centroids[o]=this.randomCentroid(),i=!0}}return this.getClusters()},e.prototype.randomCentroid=function(){var t,e,n=this.dataset.length-1;do{e=Math.round(Math.random()*n),t=this.dataset[e]}while(this.centroids.indexOf(t)>=0);return t},e.prototype.assign=function(){for(var t,e=!1,n=this.dataset.length,r=0;r<n;r++)(t=this.argmin(this.dataset[r],this.centroids,this.distance))!=this.assignments[r]&&(this.assignments[r]=t,e=!0);return e},e.prototype.getClusters=function(){for(var t,e=new Array(this.k),n=0;n<this.assignments.length;n++)void 0===e[t=this.assignments[n]]&&(e[t]=[]),e[t].push(n);return e},e.prototype.argmin=function(t,e,n){for(var r,i=Number.MAX_VALUE,o=0,s=e.length,a=0;a<s;a++)(r=n(t,e[a]))<i&&(i=r,o=a);return o},e.prototype.distance=function(t,e){for(var n=0,r=Math.min(t.length,e.length);r--;){var i=t[r]-e[r];n+=i*i}return Math.sqrt(n)},t.exports&&(t.exports=e)},3763:(t,e,n)=>{if(t.exports)var r=n(7985);function i(t,e,n,r){this.epsilon=1,this.minPts=1,this.distance=this._euclideanDistance,this._reachability=[],this._processed=[],this._coreDistance=0,this._orderedList=[],this._init(t,e,n,r)}i.prototype.run=function(t,e,n,i){this._init(t,e,n,i);for(var o=0,s=this.dataset.length;o<s;o++)if(1!==this._processed[o]){this._processed[o]=1,this.clusters.push([o]);var a=this.clusters.length-1;this._orderedList.push(o);var u=new r(null,null,"asc"),l=this._regionQuery(o);void 0!==this._distanceToCore(o)&&(this._updateQueue(o,l,u),this._expandCluster(a,u))}return this.clusters},i.prototype.getReachabilityPlot=function(){for(var t=[],e=0,n=this._orderedList.length;e<n;e++){var r=this._orderedList[e],i=this._reachability[r];t.push([r,i])}return t},i.prototype._init=function(t,e,n,r){if(t){if(!(t instanceof Array))throw Error("Dataset must be of type array, "+typeof t+" given");this.dataset=t,this.clusters=[],this._reachability=new Array(this.dataset.length),this._processed=new Array(this.dataset.length),this._coreDistance=0,this._orderedList=[]}e&&(this.epsilon=e),n&&(this.minPts=n),r&&(this.distance=r)},i.prototype._updateQueue=function(t,e,n){var r=this;this._coreDistance=this._distanceToCore(t),e.forEach((function(e){if(void 0===r._processed[e]){var i=r.distance(r.dataset[t],r.dataset[e]),o=Math.max(r._coreDistance,i);void 0===r._reachability[e]?(r._reachability[e]=o,n.insert(e,o)):o<r._reachability[e]&&(r._reachability[e]=o,n.remove(e),n.insert(e,o))}}))},i.prototype._expandCluster=function(t,e){for(var n=e.getElements(),r=0,i=n.length;r<i;r++){var o=n[r];if(void 0===this._processed[o]){var s=this._regionQuery(o);this._processed[o]=1,this.clusters[t].push(o),this._orderedList.push(o),void 0!==this._distanceToCore(o)&&(this._updateQueue(o,s,e),this._expandCluster(t,e))}}},i.prototype._distanceToCore=function(t){for(var e=this.epsilon,n=0;n<e;n++)if(this._regionQuery(t,n).length>=this.minPts)return n},i.prototype._regionQuery=function(t,e){e=e||this.epsilon;for(var n=[],r=0,i=this.dataset.length;r<i;r++)this.distance(this.dataset[t],this.dataset[r])<e&&n.push(r);return n},i.prototype._euclideanDistance=function(t,e){for(var n=0,r=Math.min(t.length,e.length);r--;)n+=(t[r]-e[r])*(t[r]-e[r]);return Math.sqrt(n)},t.exports&&(t.exports=i)},7985:t=>{function e(t,e,n){this._queue=[],this._priorities=[],this._sorting="desc",this._init(t,e,n)}e.prototype.insert=function(t,e){for(var n=this._queue.length,r=n;r--;){var i=this._priorities[r];"desc"===this._sorting?e>i&&(n=r):e<i&&(n=r)}this._insertAt(t,e,n)},e.prototype.remove=function(t){for(var e=this._queue.length;e--;)if(t===this._queue[e]){this._queue.splice(e,1),this._priorities.splice(e,1);break}},e.prototype.forEach=function(t){this._queue.forEach(t)},e.prototype.getElements=function(){return this._queue},e.prototype.getElementPriority=function(t){return this._priorities[t]},e.prototype.getPriorities=function(){return this._priorities},e.prototype.getElementsWithPriorities=function(){for(var t=[],e=0,n=this._queue.length;e<n;e++)t.push([this._queue[e],this._priorities[e]]);return t},e.prototype._init=function(t,e,n){if(t&&e){if(this._queue=[],this._priorities=[],t.length!==e.length)throw new Error("Arrays must have the same length");for(var r=0;r<t.length;r++)this.insert(t[r],e[r])}n&&(this._sorting=n)},e.prototype._insertAt=function(t,e,n){this._queue.length===n?(this._queue.push(t),this._priorities.push(e)):(this._queue.splice(n,0,t),this._priorities.splice(n,0,e))},t.exports&&(t.exports=e)},2606:(t,e,n)=>{t.exports&&(t.exports={DBSCAN:n(8317),KMEANS:n(3781),OPTICS:n(3763),PriorityQueue:n(7985)})},9187:t=>{"use strict";function e(t,e,r){r=r||2;var o,s,a,u,h,p,g,d=e&&e.length,y=d?e[0]*r:t.length,_=n(t,0,y,r,!0),m=[];if(!_||_.next===_.prev)return m;if(d&&(_=function(t,e,r,i){var o,s,a,u=[];for(o=0,s=e.length;o<s;o++)(a=n(t,e[o]*i,o<s-1?e[o+1]*i:t.length,i,!1))===a.next&&(a.steiner=!0),u.push(f(a));for(u.sort(l),o=0;o<u.length;o++)r=c(u[o],r);return r}(t,e,_,r)),t.length>80*r){o=a=t[0],s=u=t[1];for(var v=r;v<y;v+=r)(h=t[v])<o&&(o=h),(p=t[v+1])<s&&(s=p),h>a&&(a=h),p>u&&(u=p);g=0!==(g=Math.max(a-o,u-s))?32767/g:0}return i(_,m,r,o,s,g,0),m}function n(t,e,n,r,i){var o,s;if(i===w(t,e,n,r)>0)for(o=e;o<n;o+=r)s=I(o,t[o],t[o+1],s);else for(o=n-r;o>=e;o-=r)s=I(o,t[o],t[o+1],s);return s&&_(s,s.next)&&(C(s),s=s.next),s}function r(t,e){if(!t)return t;e||(e=t);var n,r=t;do{if(n=!1,r.steiner||!_(r,r.next)&&0!==y(r.prev,r,r.next))r=r.next;else{if(C(r),(r=e=r.prev)===r.next)break;n=!0}}while(n||r!==e);return e}function i(t,e,n,l,c,h,f){if(t){!f&&h&&function(t,e,n,r){var i=t;do{0===i.z&&(i.z=p(i.x,i.y,e,n,r)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){var e,n,r,i,o,s,a,u,l=1;do{for(n=t,t=null,o=null,s=0;n;){for(s++,r=n,a=0,e=0;e<l&&(a++,r=r.nextZ);e++);for(u=l;a>0||u>0&&r;)0!==a&&(0===u||!r||n.z<=r.z)?(i=n,n=n.nextZ,a--):(i=r,r=r.nextZ,u--),o?o.nextZ=i:t=i,i.prevZ=o,o=i;n=r}o.nextZ=null,l*=2}while(s>1)}(i)}(t,l,c,h);for(var g,d,y=t;t.prev!==t.next;)if(g=t.prev,d=t.next,h?s(t,l,c,h):o(t))e.push(g.i/n|0),e.push(t.i/n|0),e.push(d.i/n|0),C(t),t=d.next,y=d.next;else if((t=d)===y){f?1===f?i(t=a(r(t),e,n),e,n,l,c,h,2):2===f&&u(t,e,n,l,c,h):i(r(t),e,n,l,c,h,1);break}}}function o(t){var e=t.prev,n=t,r=t.next;if(y(e,n,r)>=0)return!1;for(var i=e.x,o=n.x,s=r.x,a=e.y,u=n.y,l=r.y,c=i<o?i<s?i:s:o<s?o:s,h=a<u?a<l?a:l:u<l?u:l,p=i>o?i>s?i:s:o>s?o:s,f=a>u?a>l?a:l:u>l?u:l,d=r.next;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&g(i,a,o,u,s,l,d.x,d.y)&&y(d.prev,d,d.next)>=0)return!1;d=d.next}return!0}function s(t,e,n,r){var i=t.prev,o=t,s=t.next;if(y(i,o,s)>=0)return!1;for(var a=i.x,u=o.x,l=s.x,c=i.y,h=o.y,f=s.y,d=a<u?a<l?a:l:u<l?u:l,_=c<h?c<f?c:f:h<f?h:f,m=a>u?a>l?a:l:u>l?u:l,v=c>h?c>f?c:f:h>f?h:f,x=p(d,_,e,n,r),b=p(m,v,e,n,r),E=t.prevZ,I=t.nextZ;E&&E.z>=x&&I&&I.z<=b;){if(E.x>=d&&E.x<=m&&E.y>=_&&E.y<=v&&E!==i&&E!==s&&g(a,c,u,h,l,f,E.x,E.y)&&y(E.prev,E,E.next)>=0)return!1;if(E=E.prevZ,I.x>=d&&I.x<=m&&I.y>=_&&I.y<=v&&I!==i&&I!==s&&g(a,c,u,h,l,f,I.x,I.y)&&y(I.prev,I,I.next)>=0)return!1;I=I.nextZ}for(;E&&E.z>=x;){if(E.x>=d&&E.x<=m&&E.y>=_&&E.y<=v&&E!==i&&E!==s&&g(a,c,u,h,l,f,E.x,E.y)&&y(E.prev,E,E.next)>=0)return!1;E=E.prevZ}for(;I&&I.z<=b;){if(I.x>=d&&I.x<=m&&I.y>=_&&I.y<=v&&I!==i&&I!==s&&g(a,c,u,h,l,f,I.x,I.y)&&y(I.prev,I,I.next)>=0)return!1;I=I.nextZ}return!0}function a(t,e,n){var i=t;do{var o=i.prev,s=i.next.next;!_(o,s)&&m(o,i,i.next,s)&&b(o,s)&&b(s,o)&&(e.push(o.i/n|0),e.push(i.i/n|0),e.push(s.i/n|0),C(i),C(i.next),i=t=s),i=i.next}while(i!==t);return r(i)}function u(t,e,n,o,s,a){var u=t;do{for(var l=u.next.next;l!==u.prev;){if(u.i!==l.i&&d(u,l)){var c=E(u,l);return u=r(u,u.next),c=r(c,c.next),i(u,e,n,o,s,a,0),void i(c,e,n,o,s,a,0)}l=l.next}u=u.next}while(u!==t)}function l(t,e){return t.x-e.x}function c(t,e){var n=function(t,e){var n,r=e,i=t.x,o=t.y,s=-1/0;do{if(o<=r.y&&o>=r.next.y&&r.next.y!==r.y){var a=r.x+(o-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(a<=i&&a>s&&(s=a,n=r.x<r.next.x?r:r.next,a===i))return n}r=r.next}while(r!==e);if(!n)return null;var u,l=n,c=n.x,p=n.y,f=1/0;r=n;do{i>=r.x&&r.x>=c&&i!==r.x&&g(o<p?i:s,o,c,p,o<p?s:i,o,r.x,r.y)&&(u=Math.abs(o-r.y)/(i-r.x),b(r,t)&&(u<f||u===f&&(r.x>n.x||r.x===n.x&&h(n,r)))&&(n=r,f=u)),r=r.next}while(r!==l);return n}(t,e);if(!n)return e;var i=E(n,t);return r(i,i.next),r(n,n.next)}function h(t,e){return y(t.prev,t,e.prev)<0&&y(e.next,t,t.next)<0}function p(t,e,n,r,i){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-n)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function f(t){var e=t,n=t;do{(e.x<n.x||e.x===n.x&&e.y<n.y)&&(n=e),e=e.next}while(e!==t);return n}function g(t,e,n,r,i,o,s,a){return(i-s)*(e-a)>=(t-s)*(o-a)&&(t-s)*(r-a)>=(n-s)*(e-a)&&(n-s)*(o-a)>=(i-s)*(r-a)}function d(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var n=t;do{if(n.i!==t.i&&n.next.i!==t.i&&n.i!==e.i&&n.next.i!==e.i&&m(n,n.next,t,e))return!0;n=n.next}while(n!==t);return!1}(t,e)&&(b(t,e)&&b(e,t)&&function(t,e){var n=t,r=!1,i=(t.x+e.x)/2,o=(t.y+e.y)/2;do{n.y>o!=n.next.y>o&&n.next.y!==n.y&&i<(n.next.x-n.x)*(o-n.y)/(n.next.y-n.y)+n.x&&(r=!r),n=n.next}while(n!==t);return r}(t,e)&&(y(t.prev,t,e.prev)||y(t,e.prev,e))||_(t,e)&&y(t.prev,t,t.next)>0&&y(e.prev,e,e.next)>0)}function y(t,e,n){return(e.y-t.y)*(n.x-e.x)-(e.x-t.x)*(n.y-e.y)}function _(t,e){return t.x===e.x&&t.y===e.y}function m(t,e,n,r){var i=x(y(t,e,n)),o=x(y(t,e,r)),s=x(y(n,r,t)),a=x(y(n,r,e));return i!==o&&s!==a||!(0!==i||!v(t,n,e))||!(0!==o||!v(t,r,e))||!(0!==s||!v(n,t,r))||!(0!==a||!v(n,e,r))}function v(t,e,n){return e.x<=Math.max(t.x,n.x)&&e.x>=Math.min(t.x,n.x)&&e.y<=Math.max(t.y,n.y)&&e.y>=Math.min(t.y,n.y)}function x(t){return t>0?1:t<0?-1:0}function b(t,e){return y(t.prev,t,t.next)<0?y(t,e,t.next)>=0&&y(t,t.prev,e)>=0:y(t,e,t.prev)<0||y(t,t.next,e)<0}function E(t,e){var n=new S(t.i,t.x,t.y),r=new S(e.i,e.x,e.y),i=t.next,o=e.prev;return t.next=e,e.prev=t,n.next=i,i.prev=n,r.next=n,n.prev=r,o.next=r,r.prev=o,r}function I(t,e,n,r){var i=new S(t,e,n);return r?(i.next=r.next,i.prev=r,r.next.prev=i,r.next=i):(i.prev=i,i.next=i),i}function C(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function S(t,e,n){this.i=t,this.x=e,this.y=n,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1}function w(t,e,n,r){for(var i=0,o=e,s=n-r;o<n;o+=r)i+=(t[s]-t[o])*(t[o+1]+t[s+1]),s=o;return i}t.exports=e,t.exports.default=e,e.deviation=function(t,e,n,r){var i=e&&e.length,o=i?e[0]*n:t.length,s=Math.abs(w(t,0,o,n));if(i)for(var a=0,u=e.length;a<u;a++){var l=e[a]*n,c=a<u-1?e[a+1]*n:t.length;s-=Math.abs(w(t,l,c,n))}var h=0;for(a=0;a<r.length;a+=3){var p=r[a]*n,f=r[a+1]*n,g=r[a+2]*n;h+=Math.abs((t[p]-t[g])*(t[f+1]-t[p+1])-(t[p]-t[f])*(t[g+1]-t[p+1]))}return 0===s&&0===h?0:Math.abs((h-s)/s)},e.flatten=function(t){for(var e=t[0][0].length,n={vertices:[],holes:[],dimensions:e},r=0,i=0;i<t.length;i++){for(var o=0;o<t[i].length;o++)for(var s=0;s<e;s++)n.vertices.push(t[i][o][s]);i>0&&(r+=t[i-1].length,n.holes.push(r))}return n}},7648:t=>{"use strict";var e="Function.prototype.bind called on incompatible ",n=Array.prototype.slice,r=Object.prototype.toString,i="[object Function]";t.exports=function(t){var o=this;if("function"!=typeof o||r.call(o)!==i)throw new TypeError(e+o);for(var s,a=n.call(arguments,1),u=function(){if(this instanceof s){var e=o.apply(this,a.concat(n.call(arguments)));return Object(e)===e?e:this}return o.apply(t,a.concat(n.call(arguments)))},l=Math.max(0,o.length-a.length),c=[],h=0;h<l;h++)c.push("$"+h);if(s=Function("binder","return function ("+c.join(",")+"){ return binder.apply(this,arguments); }")(u),o.prototype){var p=function(){};p.prototype=o.prototype,s.prototype=new p,p.prototype=null}return s}},8612:(t,e,n)=>{"use strict";var r=n(7648);t.exports=Function.prototype.bind||r},5972:t=>{"use strict";var e=function(){return"string"==typeof function(){}.name},n=Object.getOwnPropertyDescriptor;if(n)try{n([],"length")}catch(t){n=null}e.functionsHaveConfigurableNames=function(){if(!e()||!n)return!1;var t=n((function(){}),"name");return!!t&&!!t.configurable};var r=Function.prototype.bind;e.boundFunctionsHaveNames=function(){return e()&&"function"==typeof r&&""!==function(){}.bind().name},t.exports=e},9657:(t,e,n)=>{var r=n(251),i=function(t){this.precision=t&&t.precision?t.precision:17,this.direction=!(!t||!t.direction)&&t.direction,this.pseudoNode=!(!t||!t.pseudoNode)&&t.pseudoNode,this.objectComparator=t&&t.objectComparator?t.objectComparator:a};function o(t){return t.coordinates.map((function(e){return{type:t.type.replace("Multi",""),coordinates:e}}))}function s(t,e){return t.hasOwnProperty("coordinates")?t.coordinates.length===e.coordinates.length:t.length===e.length}function a(t,e){return r(t,e,{strict:!0})}i.prototype.compare=function(t,e){if(t.type!==e.type||!s(t,e))return!1;switch(t.type){case"Point":return this.compareCoord(t.coordinates,e.coordinates);case"LineString":return this.compareLine(t.coordinates,e.coordinates,0,!1);case"Polygon":return this.comparePolygon(t,e);case"Feature":return this.compareFeature(t,e);default:if(0===t.type.indexOf("Multi")){var n=this,r=o(t),i=o(e);return r.every((function(t){return this.some((function(e){return n.compare(t,e)}))}),i)}}return!1},i.prototype.compareCoord=function(t,e){if(t.length!==e.length)return!1;for(var n=0;n<t.length;n++)if(t[n].toFixed(this.precision)!==e[n].toFixed(this.precision))return!1;return!0},i.prototype.compareLine=function(t,e,n,r){if(!s(t,e))return!1;var i=this.pseudoNode?t:this.removePseudo(t),o=this.pseudoNode?e:this.removePseudo(e);if(!r||this.compareCoord(i[0],o[0])||(o=this.fixStartIndex(o,i))){var a=this.compareCoord(i[n],o[n]);return this.direction||a?this.comparePath(i,o):!!this.compareCoord(i[n],o[o.length-(1+n)])&&this.comparePath(i.slice().reverse(),o)}},i.prototype.fixStartIndex=function(t,e){for(var n,r=-1,i=0;i<t.length;i++)if(this.compareCoord(t[i],e[0])){r=i;break}return r>=0&&(n=[].concat(t.slice(r,t.length),t.slice(1,r+1))),n},i.prototype.comparePath=function(t,e){var n=this;return t.every((function(t,e){return n.compareCoord(t,this[e])}),e)},i.prototype.comparePolygon=function(t,e){if(this.compareLine(t.coordinates[0],e.coordinates[0],1,!0)){var n=t.coordinates.slice(1,t.coordinates.length),r=e.coordinates.slice(1,e.coordinates.length),i=this;return n.every((function(t){return this.some((function(e){return i.compareLine(t,e,1,!0)}))}),r)}return!1},i.prototype.compareFeature=function(t,e){return!(t.id!==e.id||!this.objectComparator(t.properties,e.properties)||!this.compareBBox(t,e))&&this.compare(t.geometry,e.geometry)},i.prototype.compareBBox=function(t,e){return!!(!t.bbox&&!e.bbox||t.bbox&&e.bbox&&this.compareCoord(t.bbox,e.bbox))},i.prototype.removePseudo=function(t){return t},t.exports=i},1787:(t,e,n)=>{var r=n(4056),i=n(4102),o=n(1540),s=n(9705).Z,a=o.featureEach,u=(o.coordEach,i.polygon,i.featureCollection);function l(t){var e=new r(t);return e.insert=function(t){if("Feature"!==t.type)throw new Error("invalid feature");return t.bbox=t.bbox?t.bbox:s(t),r.prototype.insert.call(this,t)},e.load=function(t){var e=[];return Array.isArray(t)?t.forEach((function(t){if("Feature"!==t.type)throw new Error("invalid features");t.bbox=t.bbox?t.bbox:s(t),e.push(t)})):a(t,(function(t){if("Feature"!==t.type)throw new Error("invalid features");t.bbox=t.bbox?t.bbox:s(t),e.push(t)})),r.prototype.load.call(this,e)},e.remove=function(t,e){if("Feature"!==t.type)throw new Error("invalid feature");return t.bbox=t.bbox?t.bbox:s(t),r.prototype.remove.call(this,t,e)},e.clear=function(){return r.prototype.clear.call(this)},e.search=function(t){var e=r.prototype.search.call(this,this.toBBox(t));return u(e)},e.collides=function(t){return r.prototype.collides.call(this,this.toBBox(t))},e.all=function(){var t=r.prototype.all.call(this);return u(t)},e.toJSON=function(){return r.prototype.toJSON.call(this)},e.fromJSON=function(t){return r.prototype.fromJSON.call(this,t)},e.toBBox=function(t){var e;if(t.bbox)e=t.bbox;else if(Array.isArray(t)&&4===t.length)e=t;else if(Array.isArray(t)&&6===t.length)e=[t[0],t[1],t[3],t[4]];else if("Feature"===t.type)e=s(t);else{if("FeatureCollection"!==t.type)throw new Error("invalid geojson");e=s(t)}return{minX:e[0],minY:e[1],maxX:e[2],maxY:e[3]}},e}t.exports=l,t.exports.default=l},4056:function(t){t.exports=function(){"use strict";function t(t,r,i,o,s){!function t(n,r,i,o,s){for(;o>i;){if(o-i>600){var a=o-i+1,u=r-i+1,l=Math.log(a),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(a-c)/a)*(u-a/2<0?-1:1);t(n,r,Math.max(i,Math.floor(r-u*c/a+h)),Math.min(o,Math.floor(r+(a-u)*c/a+h)),s)}var p=n[r],f=i,g=o;for(e(n,i,r),s(n[o],p)>0&&e(n,i,o);f<g;){for(e(n,f,g),f++,g--;s(n[f],p)<0;)f++;for(;s(n[g],p)>0;)g--}0===s(n[i],p)?e(n,i,g):e(n,++g,o),g<=r&&(i=g+1),r<=g&&(o=g-1)}}(t,r,i||0,o||t.length-1,s||n)}function e(t,e,n){var r=t[e];t[e]=t[n],t[n]=r}function n(t,e){return t<e?-1:t>e?1:0}var r=function(t){void 0===t&&(t=9),this._maxEntries=Math.max(4,t),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),this.clear()};function i(t,e,n){if(!n)return e.indexOf(t);for(var r=0;r<e.length;r++)if(n(t,e[r]))return r;return-1}function o(t,e){s(t,0,t.children.length,e,t)}function s(t,e,n,r,i){i||(i=g(null)),i.minX=1/0,i.minY=1/0,i.maxX=-1/0,i.maxY=-1/0;for(var o=e;o<n;o++){var s=t.children[o];a(i,t.leaf?r(s):s)}return i}function a(t,e){return t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),t}function u(t,e){return t.minX-e.minX}function l(t,e){return t.minY-e.minY}function c(t){return(t.maxX-t.minX)*(t.maxY-t.minY)}function h(t){return t.maxX-t.minX+(t.maxY-t.minY)}function p(t,e){return t.minX<=e.minX&&t.minY<=e.minY&&e.maxX<=t.maxX&&e.maxY<=t.maxY}function f(t,e){return e.minX<=t.maxX&&e.minY<=t.maxY&&e.maxX>=t.minX&&e.maxY>=t.minY}function g(t){return{children:t,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function d(e,n,r,i,o){for(var s=[n,r];s.length;)if(!((r=s.pop())-(n=s.pop())<=i)){var a=n+Math.ceil((r-n)/i/2)*i;t(e,a,n,r,o),s.push(n,a,a,r)}}return r.prototype.all=function(){return this._all(this.data,[])},r.prototype.search=function(t){var e=this.data,n=[];if(!f(t,e))return n;for(var r=this.toBBox,i=[];e;){for(var o=0;o<e.children.length;o++){var s=e.children[o],a=e.leaf?r(s):s;f(t,a)&&(e.leaf?n.push(s):p(t,a)?this._all(s,n):i.push(s))}e=i.pop()}return n},r.prototype.collides=function(t){var e=this.data;if(!f(t,e))return!1;for(var n=[];e;){for(var r=0;r<e.children.length;r++){var i=e.children[r],o=e.leaf?this.toBBox(i):i;if(f(t,o)){if(e.leaf||p(t,o))return!0;n.push(i)}}e=n.pop()}return!1},r.prototype.load=function(t){if(!t||!t.length)return this;if(t.length<this._minEntries){for(var e=0;e<t.length;e++)this.insert(t[e]);return this}var n=this._build(t.slice(),0,t.length-1,0);if(this.data.children.length)if(this.data.height===n.height)this._splitRoot(this.data,n);else{if(this.data.height<n.height){var r=this.data;this.data=n,n=r}this._insert(n,this.data.height-n.height-1,!0)}else this.data=n;return this},r.prototype.insert=function(t){return t&&this._insert(t,this.data.height-1),this},r.prototype.clear=function(){return this.data=g([]),this},r.prototype.remove=function(t,e){if(!t)return this;for(var n,r,o,s=this.data,a=this.toBBox(t),u=[],l=[];s||u.length;){if(s||(s=u.pop(),r=u[u.length-1],n=l.pop(),o=!0),s.leaf){var c=i(t,s.children,e);if(-1!==c)return s.children.splice(c,1),u.push(s),this._condense(u),this}o||s.leaf||!p(s,a)?r?(n++,s=r.children[n],o=!1):s=null:(u.push(s),l.push(n),n=0,r=s,s=s.children[0])}return this},r.prototype.toBBox=function(t){return t},r.prototype.compareMinX=function(t,e){return t.minX-e.minX},r.prototype.compareMinY=function(t,e){return t.minY-e.minY},r.prototype.toJSON=function(){return this.data},r.prototype.fromJSON=function(t){return this.data=t,this},r.prototype._all=function(t,e){for(var n=[];t;)t.leaf?e.push.apply(e,t.children):n.push.apply(n,t.children),t=n.pop();return e},r.prototype._build=function(t,e,n,r){var i,s=n-e+1,a=this._maxEntries;if(s<=a)return o(i=g(t.slice(e,n+1)),this.toBBox),i;r||(r=Math.ceil(Math.log(s)/Math.log(a)),a=Math.ceil(s/Math.pow(a,r-1))),(i=g([])).leaf=!1,i.height=r;var u=Math.ceil(s/a),l=u*Math.ceil(Math.sqrt(a));d(t,e,n,l,this.compareMinX);for(var c=e;c<=n;c+=l){var h=Math.min(c+l-1,n);d(t,c,h,u,this.compareMinY);for(var p=c;p<=h;p+=u){var f=Math.min(p+u-1,h);i.children.push(this._build(t,p,f,r-1))}}return o(i,this.toBBox),i},r.prototype._chooseSubtree=function(t,e,n,r){for(;r.push(e),!e.leaf&&r.length-1!==n;){for(var i=1/0,o=1/0,s=void 0,a=0;a<e.children.length;a++){var u=e.children[a],l=c(u),h=(p=t,f=u,(Math.max(f.maxX,p.maxX)-Math.min(f.minX,p.minX))*(Math.max(f.maxY,p.maxY)-Math.min(f.minY,p.minY))-l);h<o?(o=h,i=l<i?l:i,s=u):h===o&&l<i&&(i=l,s=u)}e=s||e.children[0]}var p,f;return e},r.prototype._insert=function(t,e,n){var r=n?t:this.toBBox(t),i=[],o=this._chooseSubtree(r,this.data,e,i);for(o.children.push(t),a(o,r);e>=0&&i[e].children.length>this._maxEntries;)this._split(i,e),e--;this._adjustParentBBoxes(r,i,e)},r.prototype._split=function(t,e){var n=t[e],r=n.children.length,i=this._minEntries;this._chooseSplitAxis(n,i,r);var s=this._chooseSplitIndex(n,i,r),a=g(n.children.splice(s,n.children.length-s));a.height=n.height,a.leaf=n.leaf,o(n,this.toBBox),o(a,this.toBBox),e?t[e-1].children.push(a):this._splitRoot(n,a)},r.prototype._splitRoot=function(t,e){this.data=g([t,e]),this.data.height=t.height+1,this.data.leaf=!1,o(this.data,this.toBBox)},r.prototype._chooseSplitIndex=function(t,e,n){for(var r,i,o,a,u,l,h,p=1/0,f=1/0,g=e;g<=n-e;g++){var d=s(t,0,g,this.toBBox),y=s(t,g,n,this.toBBox),_=(i=d,o=y,void 0,void 0,void 0,void 0,a=Math.max(i.minX,o.minX),u=Math.max(i.minY,o.minY),l=Math.min(i.maxX,o.maxX),h=Math.min(i.maxY,o.maxY),Math.max(0,l-a)*Math.max(0,h-u)),m=c(d)+c(y);_<p?(p=_,r=g,f=m<f?m:f):_===p&&m<f&&(f=m,r=g)}return r||n-e},r.prototype._chooseSplitAxis=function(t,e,n){var r=t.leaf?this.compareMinX:u,i=t.leaf?this.compareMinY:l;this._allDistMargin(t,e,n,r)<this._allDistMargin(t,e,n,i)&&t.children.sort(r)},r.prototype._allDistMargin=function(t,e,n,r){t.children.sort(r);for(var i=this.toBBox,o=s(t,0,e,i),u=s(t,n-e,n,i),l=h(o)+h(u),c=e;c<n-e;c++){var p=t.children[c];a(o,t.leaf?i(p):p),l+=h(o)}for(var f=n-e-1;f>=e;f--){var g=t.children[f];a(u,t.leaf?i(g):g),l+=h(u)}return l},r.prototype._adjustParentBBoxes=function(t,e,n){for(var r=n;r>=0;r--)a(e[r],t)},r.prototype._condense=function(t){for(var e=t.length-1,n=void 0;e>=0;e--)0===t[e].children.length?e>0?(n=t[e-1].children).splice(n.indexOf(t[e]),1):this.clear():o(t[e],this.toBBox)},r}()},210:(t,e,n)=>{"use strict";var r,i=SyntaxError,o=Function,s=TypeError,a=function(t){try{return o('"use strict"; return ('+t+").constructor;")()}catch(t){}},u=Object.getOwnPropertyDescriptor;if(u)try{u({},"")}catch(t){u=null}var l=function(){throw new s},c=u?function(){try{return l}catch(t){try{return u(arguments,"callee").get}catch(t){return l}}}():l,h=n(1405)(),p=Object.getPrototypeOf||function(t){return t.__proto__},f={},g="undefined"==typeof Uint8Array?r:p(Uint8Array),d={"%AggregateError%":"undefined"==typeof AggregateError?r:AggregateError,"%Array%":Array,"%ArrayBuffer%":"undefined"==typeof ArrayBuffer?r:ArrayBuffer,"%ArrayIteratorPrototype%":h?p([][Symbol.iterator]()):r,"%AsyncFromSyncIteratorPrototype%":r,"%AsyncFunction%":f,"%AsyncGenerator%":f,"%AsyncGeneratorFunction%":f,"%AsyncIteratorPrototype%":f,"%Atomics%":"undefined"==typeof Atomics?r:Atomics,"%BigInt%":"undefined"==typeof BigInt?r:BigInt,"%Boolean%":Boolean,"%DataView%":"undefined"==typeof DataView?r:DataView,"%Date%":Date,"%decodeURI%":decodeURI,"%decodeURIComponent%":decodeURIComponent,"%encodeURI%":encodeURI,"%encodeURIComponent%":encodeURIComponent,"%Error%":Error,"%eval%":eval,"%EvalError%":EvalError,"%Float32Array%":"undefined"==typeof Float32Array?r:Float32Array,"%Float64Array%":"undefined"==typeof Float64Array?r:Float64Array,"%FinalizationRegistry%":"undefined"==typeof FinalizationRegistry?r:FinalizationRegistry,"%Function%":o,"%GeneratorFunction%":f,"%Int8Array%":"undefined"==typeof Int8Array?r:Int8Array,"%Int16Array%":"undefined"==typeof Int16Array?r:Int16Array,"%Int32Array%":"undefined"==typeof Int32Array?r:Int32Array,"%isFinite%":isFinite,"%isNaN%":isNaN,"%IteratorPrototype%":h?p(p([][Symbol.iterator]())):r,"%JSON%":"object"==typeof JSON?JSON:r,"%Map%":"undefined"==typeof Map?r:Map,"%MapIteratorPrototype%":"undefined"!=typeof Map&&h?p((new Map)[Symbol.iterator]()):r,"%Math%":Math,"%Number%":Number,"%Object%":Object,"%parseFloat%":parseFloat,"%parseInt%":parseInt,"%Promise%":"undefined"==typeof Promise?r:Promise,"%Proxy%":"undefined"==typeof Proxy?r:Proxy,"%RangeError%":RangeError,"%ReferenceError%":ReferenceError,"%Reflect%":"undefined"==typeof Reflect?r:Reflect,"%RegExp%":RegExp,"%Set%":"undefined"==typeof Set?r:Set,"%SetIteratorPrototype%":"undefined"!=typeof Set&&h?p((new Set)[Symbol.iterator]()):r,"%SharedArrayBuffer%":"undefined"==typeof SharedArrayBuffer?r:SharedArrayBuffer,"%String%":String,"%StringIteratorPrototype%":h?p(""[Symbol.iterator]()):r,"%Symbol%":h?Symbol:r,"%SyntaxError%":i,"%ThrowTypeError%":c,"%TypedArray%":g,"%TypeError%":s,"%Uint8Array%":"undefined"==typeof Uint8Array?r:Uint8Array,"%Uint8ClampedArray%":"undefined"==typeof Uint8ClampedArray?r:Uint8ClampedArray,"%Uint16Array%":"undefined"==typeof Uint16Array?r:Uint16Array,"%Uint32Array%":"undefined"==typeof Uint32Array?r:Uint32Array,"%URIError%":URIError,"%WeakMap%":"undefined"==typeof WeakMap?r:WeakMap,"%WeakRef%":"undefined"==typeof WeakRef?r:WeakRef,"%WeakSet%":"undefined"==typeof WeakSet?r:WeakSet},y=function t(e){var n;if("%AsyncFunction%"===e)n=a("async function () {}");else if("%GeneratorFunction%"===e)n=a("function* () {}");else if("%AsyncGeneratorFunction%"===e)n=a("async function* () {}");else if("%AsyncGenerator%"===e){var r=t("%AsyncGeneratorFunction%");r&&(n=r.prototype)}else if("%AsyncIteratorPrototype%"===e){var i=t("%AsyncGenerator%");i&&(n=p(i.prototype))}return d[e]=n,n},_={"%ArrayBufferPrototype%":["ArrayBuffer","prototype"],"%ArrayPrototype%":["Array","prototype"],"%ArrayProto_entries%":["Array","prototype","entries"],"%ArrayProto_forEach%":["Array","prototype","forEach"],"%ArrayProto_keys%":["Array","prototype","keys"],"%ArrayProto_values%":["Array","prototype","values"],"%AsyncFunctionPrototype%":["AsyncFunction","prototype"],"%AsyncGenerator%":["AsyncGeneratorFunction","prototype"],"%AsyncGeneratorPrototype%":["AsyncGeneratorFunction","prototype","prototype"],"%BooleanPrototype%":["Boolean","prototype"],"%DataViewPrototype%":["DataView","prototype"],"%DatePrototype%":["Date","prototype"],"%ErrorPrototype%":["Error","prototype"],"%EvalErrorPrototype%":["EvalError","prototype"],"%Float32ArrayPrototype%":["Float32Array","prototype"],"%Float64ArrayPrototype%":["Float64Array","prototype"],"%FunctionPrototype%":["Function","prototype"],"%Generator%":["GeneratorFunction","prototype"],"%GeneratorPrototype%":["GeneratorFunction","prototype","prototype"],"%Int8ArrayPrototype%":["Int8Array","prototype"],"%Int16ArrayPrototype%":["Int16Array","prototype"],"%Int32ArrayPrototype%":["Int32Array","prototype"],"%JSONParse%":["JSON","parse"],"%JSONStringify%":["JSON","stringify"],"%MapPrototype%":["Map","prototype"],"%NumberPrototype%":["Number","prototype"],"%ObjectPrototype%":["Object","prototype"],"%ObjProto_toString%":["Object","prototype","toString"],"%ObjProto_valueOf%":["Object","prototype","valueOf"],"%PromisePrototype%":["Promise","prototype"],"%PromiseProto_then%":["Promise","prototype","then"],"%Promise_all%":["Promise","all"],"%Promise_reject%":["Promise","reject"],"%Promise_resolve%":["Promise","resolve"],"%RangeErrorPrototype%":["RangeError","prototype"],"%ReferenceErrorPrototype%":["ReferenceError","prototype"],"%RegExpPrototype%":["RegExp","prototype"],"%SetPrototype%":["Set","prototype"],"%SharedArrayBufferPrototype%":["SharedArrayBuffer","prototype"],"%StringPrototype%":["String","prototype"],"%SymbolPrototype%":["Symbol","prototype"],"%SyntaxErrorPrototype%":["SyntaxError","prototype"],"%TypedArrayPrototype%":["TypedArray","prototype"],"%TypeErrorPrototype%":["TypeError","prototype"],"%Uint8ArrayPrototype%":["Uint8Array","prototype"],"%Uint8ClampedArrayPrototype%":["Uint8ClampedArray","prototype"],"%Uint16ArrayPrototype%":["Uint16Array","prototype"],"%Uint32ArrayPrototype%":["Uint32Array","prototype"],"%URIErrorPrototype%":["URIError","prototype"],"%WeakMapPrototype%":["WeakMap","prototype"],"%WeakSetPrototype%":["WeakSet","prototype"]},m=n(8612),v=n(7642),x=m.call(Function.call,Array.prototype.concat),b=m.call(Function.apply,Array.prototype.splice),E=m.call(Function.call,String.prototype.replace),I=m.call(Function.call,String.prototype.slice),C=m.call(Function.call,RegExp.prototype.exec),S=/[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g,w=/\\(\\)?/g,N=function(t){var e=I(t,0,1),n=I(t,-1);if("%"===e&&"%"!==n)throw new i("invalid intrinsic syntax, expected closing `%`");if("%"===n&&"%"!==e)throw new i("invalid intrinsic syntax, expected opening `%`");var r=[];return E(t,S,(function(t,e,n,i){r[r.length]=n?E(i,w,"$1"):e||t})),r},M=function(t,e){var n,r=t;if(v(_,r)&&(r="%"+(n=_[r])[0]+"%"),v(d,r)){var o=d[r];if(o===f&&(o=y(r)),void 0===o&&!e)throw new s("intrinsic "+t+" exists, but is not available. Please file an issue!");return{alias:n,name:r,value:o}}throw new i("intrinsic "+t+" does not exist!")};t.exports=function(t,e){if("string"!=typeof t||0===t.length)throw new s("intrinsic name must be a non-empty string");if(arguments.length>1&&"boolean"!=typeof e)throw new s('"allowMissing" argument must be a boolean');if(null===C(/^%?[^%]*%?$/,t))throw new i("`%` may not be present anywhere but at the beginning and end of the intrinsic name");var n=N(t),r=n.length>0?n[0]:"",o=M("%"+r+"%",e),a=o.name,l=o.value,c=!1,h=o.alias;h&&(r=h[0],b(n,x([0,1],h)));for(var p=1,f=!0;p<n.length;p+=1){var g=n[p],y=I(g,0,1),_=I(g,-1);if(('"'===y||"'"===y||"`"===y||'"'===_||"'"===_||"`"===_)&&y!==_)throw new i("property names with quotes must have matching quotes");if("constructor"!==g&&f||(c=!0),v(d,a="%"+(r+="."+g)+"%"))l=d[a];else if(null!=l){if(!(g in l)){if(!e)throw new s("base intrinsic for "+t+" exists, but the property is not available.");return}if(u&&p+1>=n.length){var m=u(l,g);l=(f=!!m)&&"get"in m&&!("originalValue"in m.get)?m.get:l[g]}else f=v(l,g),l=l[g];f&&!c&&(d[a]=l)}}return l}},1044:(t,e,n)=>{"use strict";var r=n(210)("%Object.defineProperty%",!0),i=function(){if(r)try{return r({},"a",{value:1}),!0}catch(t){return!1}return!1};i.hasArrayLengthDefineBug=function(){if(!i())return null;try{return 1!==r([],"length",{value:1}).length}catch(t){return!0}},t.exports=i},1405:(t,e,n)=>{"use strict";var r="undefined"!=typeof Symbol&&Symbol,i=n(5419);t.exports=function(){return"function"==typeof r&&"function"==typeof Symbol&&"symbol"==typeof r("foo")&&"symbol"==typeof Symbol("bar")&&i()}},5419:t=>{"use strict";t.exports=function(){if("function"!=typeof Symbol||"function"!=typeof Object.getOwnPropertySymbols)return!1;if("symbol"==typeof Symbol.iterator)return!0;var t={},e=Symbol("test"),n=Object(e);if("string"==typeof e)return!1;if("[object Symbol]"!==Object.prototype.toString.call(e))return!1;if("[object Symbol]"!==Object.prototype.toString.call(n))return!1;for(e in t[e]=42,t)return!1;if("function"==typeof Object.keys&&0!==Object.keys(t).length)return!1;if("function"==typeof Object.getOwnPropertyNames&&0!==Object.getOwnPropertyNames(t).length)return!1;var r=Object.getOwnPropertySymbols(t);if(1!==r.length||r[0]!==e)return!1;if(!Object.prototype.propertyIsEnumerable.call(t,e))return!1;if("function"==typeof Object.getOwnPropertyDescriptor){var i=Object.getOwnPropertyDescriptor(t,e);if(42!==i.value||!0!==i.enumerable)return!1}return!0}},6410:(t,e,n)=>{"use strict";var r=n(5419);t.exports=function(){return r()&&!!Symbol.toStringTag}},7642:(t,e,n)=>{"use strict";var r=n(8612);t.exports=r.call(Function.call,Object.prototype.hasOwnProperty)},2584:(t,e,n)=>{"use strict";var r=n(6410)(),i=n(1924)("Object.prototype.toString"),o=function(t){return!(r&&t&&"object"==typeof t&&Symbol.toStringTag in t)&&"[object Arguments]"===i(t)},s=function(t){return!!o(t)||null!==t&&"object"==typeof t&&"number"==typeof t.length&&t.length>=0&&"[object Array]"!==i(t)&&"[object Function]"===i(t.callee)},a=function(){return o(arguments)}();o.isLegacyArguments=s,t.exports=a?o:s},8923:(t,e,n)=>{"use strict";var r=Date.prototype.getDay,i=Object.prototype.toString,o=n(6410)();t.exports=function(t){return"object"==typeof t&&null!==t&&(o?function(t){try{return r.call(t),!0}catch(t){return!1}}(t):"[object Date]"===i.call(t))}},8420:(t,e,n)=>{"use strict";var r,i,o,s,a=n(1924),u=n(6410)();if(u){r=a("Object.prototype.hasOwnProperty"),i=a("RegExp.prototype.exec"),o={};var l=function(){throw o};s={toString:l,valueOf:l},"symbol"==typeof Symbol.toPrimitive&&(s[Symbol.toPrimitive]=l)}var c=a("Object.prototype.toString"),h=Object.getOwnPropertyDescriptor;t.exports=u?function(t){if(!t||"object"!=typeof t)return!1;var e=h(t,"lastIndex");if(!e||!r(e,"value"))return!1;try{i(t,s)}catch(t){return t===o}}:function(t){return!(!t||"object"!=typeof t&&"function"!=typeof t)&&"[object RegExp]"===c(t)}},9487:(t,e,n)=>{var r=n(9299),i=n(9803),o=n(3114),s=[].push;t.exports=function(t){var e=t[0],n=t[2],a=t[4];function u(){if(n){var t=n.slice();s.apply(t,arguments)}if(this instanceof u){var o=r(e.prototype),l=e.apply(o,t||arguments);return i(l)?l:o}return e.apply(a,t||arguments)}return o(u,t),u}},9299:(t,e,n)=>{var r=n(9803),i=(n(4798),n(7248).test(i=Object.create)&&i);function o(t,e){return r(t)?i(t):{}}i||(o=function(){function t(){}return function(e){if(r(e)){t.prototype=e;var i=new t;t.prototype=null}return i||n.g.Object()}}()),t.exports=o},9805:(t,e,n)=>{var r=n(4067),i=n(6924),o=n(3114),s=n(3644),a=/^\s*function[ \n\r\t]+\w/,u=/\bthis\b/,l=Function.prototype.toString;t.exports=function(t,e,n){if("function"!=typeof t)return i;if(void 0===e||!("prototype"in t))return t;var c=t.__bindData__;if(void 0===c&&(s.funcNames&&(c=!t.name),!(c=c||!s.funcDecomp))){var h=l.call(t);s.funcNames||(c=!a.test(h)),c||(c=u.test(h),o(t,c))}if(!1===c||!0!==c&&1&c[1])return t;switch(n){case 1:return function(n){return t.call(e,n)};case 2:return function(n,r){return t.call(e,n,r)};case 3:return function(n,r,i){return t.call(e,n,r,i)};case 4:return function(n,r,i,o){return t.call(e,n,r,i,o)}}return r(t,e)}},8262:(t,e,n)=>{var r=n(9299),i=n(9803),o=n(3114),s=n(8683),a=[].push;t.exports=function t(e){var n=e[0],u=e[1],l=e[2],c=e[3],h=e[4],p=e[5],f=1&u,g=2&u,d=4&u,y=8&u,_=n;function m(){var e=f?h:this;if(l){var o=l.slice();a.apply(o,arguments)}if((c||d)&&(o||(o=s(arguments)),c&&a.apply(o,c),d&&o.length<p))return u|=16,t([n,y?u:-4&u,o,null,h,p]);if(o||(o=arguments),g&&(n=e[_]),this instanceof m){e=r(n.prototype);var v=n.apply(e,o);return i(v)?v:e}return n.apply(e,o)}return o(m,e),m}},9521:(t,e,n)=>{var r=n(9487),i=n(8262),o=n(8423),s=[].push;t.exports=function t(e,n,a,u,l,c){var h=1&n,p=4&n,f=16&n,g=32&n;if(!(2&n||o(e)))throw new TypeError;f&&!a.length&&(n&=-17,f=a=!1),g&&!u.length&&(n&=-33,g=u=!1);var d=e&&e.__bindData__;return d&&!0!==d?(d=d.slice(),!h||1&d[1]||(d[4]=l),!h&&1&d[1]&&(n|=8),!p||4&d[1]||(d[5]=c),f&&s.apply(d[2]||(d[2]=[]),a),g&&s.apply(d[3]||(d[3]=[]),u),d[1]|=n,t.apply(null,d)):(1==n||17===n?r:i)([e,n,a,u,l,c])}},4549:t=>{t.exports={boolean:!1,function:!0,object:!0,number:!1,string:!1,undefined:!1}},7248:t=>{var e=Object.prototype.toString,n=RegExp("^"+String(e).replace(/[.*+?^${}()|[\]\\]/g,"\\$&").replace(/toString| for [^\]]+/g,".*?")+"$");t.exports=n},3114:(t,e,n)=>{var r=n(4798),i=n(7248),o={configurable:!1,enumerable:!1,value:null,writable:!1},s=function(){try{var t={},e=i.test(e=Object.defineProperty)&&e,n=e(t,t,t)&&e}catch(t){}return n}(),a=s?function(t,e){o.value=e,s(t,"__bindData__",o)}:r;t.exports=a},329:(t,e,n)=>{var r=n(4549),i=Object.prototype.hasOwnProperty;t.exports=function(t){var e,n=t,o=[];if(!n)return o;if(!r[typeof t])return o;for(e in n)i.call(n,e)&&o.push(e);return o}},8683:t=>{t.exports=function(t,e,n){e||(e=0),void 0===n&&(n=t?t.length:0);for(var r=-1,i=n-e||0,o=Array(i<0?0:i);++r<i;)o[r]=t[e+r];return o}},4067:(t,e,n)=>{var r=n(9521),i=(n(7248),n(8683));t.exports=function(t,e){return arguments.length>2?r(t,17,i(arguments,2),null,e):r(t,1,null,null,e)}},3590:(t,e,n)=>{var r=n(9805),i=n(3520);t.exports=function(t,e,n){var o=-1,s=t?t.length:0;if(e=e&&void 0===n?e:r(e,n,3),"number"==typeof s)for(;++o<s&&!1!==e(t[o],o,t););else i(t,e);return t}},3520:(t,e,n)=>{var r=n(9805),i=n(4799),o=n(4549);t.exports=function(t,e,n){var s,a=t,u=a;if(!a)return u;if(!o[typeof a])return u;e=e&&void 0===n?e:r(e,n,3);for(var l=-1,c=o[typeof a]&&i(a),h=c?c.length:0;++l<h;)if(!1===e(a[s=c[l]],s,t))return u;return u}},6924:t=>{t.exports=function(t){return t}},8423:t=>{t.exports=function(t){return"function"==typeof t}},9803:(t,e,n)=>{var r=n(4549);t.exports=function(t){return!(!t||!r[typeof t])}},4799:(t,e,n)=>{var r=n(9803),i=n(7248),o=n(329),s=i.test(s=Object.keys)&&s,a=s?function(t){return r(t)?s(t):[]}:o;t.exports=a},4798:t=>{t.exports=function(){}},3644:(t,e,n)=>{var r=n(7248),i={};i.funcDecomp=!r.test(n.g.WinRTError)&&/\bthis\b/.test((function(){return this})),i.funcNames="string"==typeof Function.name,t.exports=i},7418:t=>{"use strict";var e=Object.getOwnPropertySymbols,n=Object.prototype.hasOwnProperty,r=Object.prototype.propertyIsEnumerable;function i(t){if(null==t)throw new TypeError("Object.assign cannot be called with null or undefined");return Object(t)}t.exports=function(){try{if(!Object.assign)return!1;var t=new String("abc");if(t[5]="de","5"===Object.getOwnPropertyNames(t)[0])return!1;for(var e={},n=0;n<10;n++)e["_"+String.fromCharCode(n)]=n;if("0123456789"!==Object.getOwnPropertyNames(e).map((function(t){return e[t]})).join(""))return!1;var r={};return"abcdefghijklmnopqrst".split("").forEach((function(t){r[t]=t})),"abcdefghijklmnopqrst"===Object.keys(Object.assign({},r)).join("")}catch(t){return!1}}()?Object.assign:function(t,o){for(var s,a,u=i(t),l=1;l<arguments.length;l++){for(var c in s=Object(arguments[l]))n.call(s,c)&&(u[c]=s[c]);if(e){a=e(s);for(var h=0;h<a.length;h++)r.call(s,a[h])&&(u[a[h]]=s[a[h]])}}return u}},4244:t=>{"use strict";var e=function(t){return t!=t};t.exports=function(t,n){return 0===t&&0===n?1/t==1/n:t===n||!(!e(t)||!e(n))}},609:(t,e,n)=>{"use strict";var r=n(4289),i=n(5559),o=n(4244),s=n(5624),a=n(2281),u=i(s(),Object);r(u,{getPolyfill:s,implementation:o,shim:a}),t.exports=u},5624:(t,e,n)=>{"use strict";var r=n(4244);t.exports=function(){return"function"==typeof Object.is?Object.is:r}},2281:(t,e,n)=>{"use strict";var r=n(5624),i=n(4289);t.exports=function(){var t=r();return i(Object,{is:t},{is:function(){return Object.is!==t}}),t}},8987:(t,e,n)=>{"use strict";var r;if(!Object.keys){var i=Object.prototype.hasOwnProperty,o=Object.prototype.toString,s=n(1414),a=Object.prototype.propertyIsEnumerable,u=!a.call({toString:null},"toString"),l=a.call((function(){}),"prototype"),c=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],h=function(t){var e=t.constructor;return e&&e.prototype===t},p={$applicationCache:!0,$console:!0,$external:!0,$frame:!0,$frameElement:!0,$frames:!0,$innerHeight:!0,$innerWidth:!0,$onmozfullscreenchange:!0,$onmozfullscreenerror:!0,$outerHeight:!0,$outerWidth:!0,$pageXOffset:!0,$pageYOffset:!0,$parent:!0,$scrollLeft:!0,$scrollTop:!0,$scrollX:!0,$scrollY:!0,$self:!0,$webkitIndexedDB:!0,$webkitStorageInfo:!0,$window:!0},f=function(){if("undefined"==typeof window)return!1;for(var t in window)try{if(!p["$"+t]&&i.call(window,t)&&null!==window[t]&&"object"==typeof window[t])try{h(window[t])}catch(t){return!0}}catch(t){return!0}return!1}();r=function(t){var e=null!==t&&"object"==typeof t,n="[object Function]"===o.call(t),r=s(t),a=e&&"[object String]"===o.call(t),p=[];if(!e&&!n&&!r)throw new TypeError("Object.keys called on a non-object");var g=l&&n;if(a&&t.length>0&&!i.call(t,0))for(var d=0;d<t.length;++d)p.push(String(d));if(r&&t.length>0)for(var y=0;y<t.length;++y)p.push(String(y));else for(var _ in t)g&&"prototype"===_||!i.call(t,_)||p.push(String(_));if(u)for(var m=function(t){if("undefined"==typeof window||!f)return h(t);try{return h(t)}catch(t){return!1}}(t),v=0;v<c.length;++v)m&&"constructor"===c[v]||!i.call(t,c[v])||p.push(c[v]);return p}}t.exports=r},2215:(t,e,n)=>{"use strict";var r=Array.prototype.slice,i=n(1414),o=Object.keys,s=o?function(t){return o(t)}:n(8987),a=Object.keys;s.shim=function(){if(Object.keys){var t=function(){var t=Object.keys(arguments);return t&&t.length===arguments.length}(1,2);t||(Object.keys=function(t){return i(t)?a(r.call(t)):a(t)})}else Object.keys=s;return Object.keys||s},t.exports=s},1414:t=>{"use strict";var e=Object.prototype.toString;t.exports=function(t){var n=e.call(t),r="[object Arguments]"===n;return r||(r="[object Array]"!==n&&null!==t&&"object"==typeof t&&"number"==typeof t.length&&t.length>=0&&"[object Function]"===e.call(t.callee)),r}},1895:t=>{t.exports=function(t,e,n,r){var i=t[0],o=t[1],s=!1;void 0===n&&(n=0),void 0===r&&(r=e.length);for(var a=(r-n)/2,u=0,l=a-1;u<a;l=u++){var c=e[n+2*u+0],h=e[n+2*u+1],p=e[n+2*l+0],f=e[n+2*l+1];h>o!=f>o&&i<(p-c)*(o-h)/(f-h)+c&&(s=!s)}return s}},6960:(t,e,n)=>{var r=n(1895),i=n(8139);t.exports=function(t,e,n,o){return e.length>0&&Array.isArray(e[0])?i(t,e,n,o):r(t,e,n,o)},t.exports.nested=i,t.exports.flat=r},8139:t=>{t.exports=function(t,e,n,r){var i=t[0],o=t[1],s=!1;void 0===n&&(n=0),void 0===r&&(r=e.length);for(var a=r-n,u=0,l=a-1;u<a;l=u++){var c=e[u+n][0],h=e[u+n][1],p=e[l+n][0],f=e[l+n][1];h>o!=f>o&&i<(p-c)*(o-h)/(f-h)+c&&(s=!s)}return s}},2676:function(t){t.exports=function(){"use strict";function t(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function e(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}function n(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}var r=function(t,e){this.next=null,this.key=t,this.data=e,this.left=null,this.right=null};function i(t,e){return t>e?1:t<e?-1:0}function o(t,e,n){for(var i=new r(null,null),o=i,s=i;;){var a=n(t,e.key);if(a<0){if(null===e.left)break;if(n(t,e.left.key)<0){var u=e.left;if(e.left=u.right,u.right=e,null===(e=u).left)break}s.left=e,s=e,e=e.left}else{if(!(a>0))break;if(null===e.right)break;if(n(t,e.right.key)>0&&(u=e.right,e.right=u.left,u.left=e,null===(e=u).right))break;o.right=e,o=e,e=e.right}}return o.right=e.left,s.left=e.right,e.left=i.right,e.right=i.left,e}function s(t,e,n,i){var s=new r(t,e);if(null===n)return s.left=s.right=null,s;var a=i(t,(n=o(t,n,i)).key);return a<0?(s.left=n.left,s.right=n,n.left=null):a>=0&&(s.right=n.right,s.left=n,n.right=null),s}function a(t,e,n){var r=null,i=null;if(e){var s=n((e=o(t,e,n)).key,t);0===s?(r=e.left,i=e.right):s<0?(i=e.right,e.right=null,r=e):(r=e.left,e.left=null,i=e)}return{left:r,right:i}}function u(t,e,n,r,i){if(t){r(e+(n?"└── ":"├── ")+i(t)+"\n");var o=e+(n?"    ":"│   ");t.left&&u(t.left,o,!1,r,i),t.right&&u(t.right,o,!0,r,i)}}var l=function(){function t(t){void 0===t&&(t=i),this._root=null,this._size=0,this._comparator=t}return t.prototype.insert=function(t,e){return this._size++,this._root=s(t,e,this._root,this._comparator)},t.prototype.add=function(t,e){var n=new r(t,e);null===this._root&&(n.left=n.right=null,this._size++,this._root=n);var i=this._comparator,s=o(t,this._root,i),a=i(t,s.key);return 0===a?this._root=s:(a<0?(n.left=s.left,n.right=s,s.left=null):a>0&&(n.right=s.right,n.left=s,s.right=null),this._size++,this._root=n),this._root},t.prototype.remove=function(t){this._root=this._remove(t,this._root,this._comparator)},t.prototype._remove=function(t,e,n){var r;return null===e?null:0===n(t,(e=o(t,e,n)).key)?(null===e.left?r=e.right:(r=o(t,e.left,n)).right=e.right,this._size--,r):e},t.prototype.pop=function(){var t=this._root;if(t){for(;t.left;)t=t.left;return this._root=o(t.key,this._root,this._comparator),this._root=this._remove(t.key,this._root,this._comparator),{key:t.key,data:t.data}}return null},t.prototype.findStatic=function(t){for(var e=this._root,n=this._comparator;e;){var r=n(t,e.key);if(0===r)return e;e=r<0?e.left:e.right}return null},t.prototype.find=function(t){return this._root&&(this._root=o(t,this._root,this._comparator),0!==this._comparator(t,this._root.key))?null:this._root},t.prototype.contains=function(t){for(var e=this._root,n=this._comparator;e;){var r=n(t,e.key);if(0===r)return!0;e=r<0?e.left:e.right}return!1},t.prototype.forEach=function(t,e){for(var n=this._root,r=[],i=!1;!i;)null!==n?(r.push(n),n=n.left):0!==r.length?(n=r.pop(),t.call(e,n),n=n.right):i=!0;return this},t.prototype.range=function(t,e,n,r){for(var i=[],o=this._comparator,s=this._root;0!==i.length||s;)if(s)i.push(s),s=s.left;else{if(o((s=i.pop()).key,e)>0)break;if(o(s.key,t)>=0&&n.call(r,s))return this;s=s.right}return this},t.prototype.keys=function(){var t=[];return this.forEach((function(e){var n=e.key;return t.push(n)})),t},t.prototype.values=function(){var t=[];return this.forEach((function(e){var n=e.data;return t.push(n)})),t},t.prototype.min=function(){return this._root?this.minNode(this._root).key:null},t.prototype.max=function(){return this._root?this.maxNode(this._root).key:null},t.prototype.minNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.left;)t=t.left;return t},t.prototype.maxNode=function(t){if(void 0===t&&(t=this._root),t)for(;t.right;)t=t.right;return t},t.prototype.at=function(t){for(var e=this._root,n=!1,r=0,i=[];!n;)if(e)i.push(e),e=e.left;else if(i.length>0){if(e=i.pop(),r===t)return e;r++,e=e.right}else n=!0;return null},t.prototype.next=function(t){var e=this._root,n=null;if(t.right){for(n=t.right;n.left;)n=n.left;return n}for(var r=this._comparator;e;){var i=r(t.key,e.key);if(0===i)break;i<0?(n=e,e=e.left):e=e.right}return n},t.prototype.prev=function(t){var e=this._root,n=null;if(null!==t.left){for(n=t.left;n.right;)n=n.right;return n}for(var r=this._comparator;e;){var i=r(t.key,e.key);if(0===i)break;i<0?e=e.left:(n=e,e=e.right)}return n},t.prototype.clear=function(){return this._root=null,this._size=0,this},t.prototype.toList=function(){return function(t){for(var e=t,n=[],i=!1,o=new r(null,null),s=o;!i;)e?(n.push(e),e=e.left):n.length>0?e=(e=s=s.next=n.pop()).right:i=!0;return s.next=null,o.next}(this._root)},t.prototype.load=function(t,e,n){void 0===e&&(e=[]),void 0===n&&(n=!1);var i=t.length,o=this._comparator;if(n&&p(t,e,0,i-1,o),null===this._root)this._root=c(t,e,0,i),this._size=i;else{var s=function(t,e,n){for(var i=new r(null,null),o=i,s=t,a=e;null!==s&&null!==a;)n(s.key,a.key)<0?(o.next=s,s=s.next):(o.next=a,a=a.next),o=o.next;return null!==s?o.next=s:null!==a&&(o.next=a),i.next}(this.toList(),function(t,e){for(var n=new r(null,null),i=n,o=0;o<t.length;o++)i=i.next=new r(t[o],e[o]);return i.next=null,n.next}(t,e),o);i=this._size+i,this._root=h({head:s},0,i)}return this},t.prototype.isEmpty=function(){return null===this._root},Object.defineProperty(t.prototype,"size",{get:function(){return this._size},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"root",{get:function(){return this._root},enumerable:!0,configurable:!0}),t.prototype.toString=function(t){void 0===t&&(t=function(t){return String(t.key)});var e=[];return u(this._root,"",!0,(function(t){return e.push(t)}),t),e.join("")},t.prototype.update=function(t,e,n){var r=this._comparator,i=a(t,this._root,r),u=i.left,l=i.right;r(t,e)<0?l=s(e,n,l,r):u=s(e,n,u,r),this._root=function(t,e,n){return null===e?t:(null===t||((e=o(t.key,e,n)).left=t),e)}(u,l,r)},t.prototype.split=function(t){return a(t,this._root,this._comparator)},t}();function c(t,e,n,i){var o=i-n;if(o>0){var s=n+Math.floor(o/2),a=t[s],u=e[s],l=new r(a,u);return l.left=c(t,e,n,s),l.right=c(t,e,s+1,i),l}return null}function h(t,e,n){var r=n-e;if(r>0){var i=e+Math.floor(r/2),o=h(t,e,i),s=t.head;return s.left=o,t.head=t.head.next,s.right=h(t,i+1,n),s}return null}function p(t,e,n,r,i){if(!(n>=r)){for(var o=t[n+r>>1],s=n-1,a=r+1;;){do{s++}while(i(t[s],o)<0);do{a--}while(i(t[a],o)>0);if(s>=a)break;var u=t[s];t[s]=t[a],t[a]=u,u=e[s],e[s]=e[a],e[a]=u}p(t,e,n,a,i),p(t,e,a+1,r,i)}}var f=function(t,e){return t.ll.x<=e.x&&e.x<=t.ur.x&&t.ll.y<=e.y&&e.y<=t.ur.y},g=function(t,e){if(e.ur.x<t.ll.x||t.ur.x<e.ll.x||e.ur.y<t.ll.y||t.ur.y<e.ll.y)return null;var n=t.ll.x<e.ll.x?e.ll.x:t.ll.x,r=t.ur.x<e.ur.x?t.ur.x:e.ur.x;return{ll:{x:n,y:t.ll.y<e.ll.y?e.ll.y:t.ll.y},ur:{x:r,y:t.ur.y<e.ur.y?t.ur.y:e.ur.y}}},d=Number.EPSILON;void 0===d&&(d=Math.pow(2,-52));var y=d*d,_=function(t,e){if(-d<t&&t<d&&-d<e&&e<d)return 0;var n=t-e;return n*n<y*t*e?0:t<e?-1:1},m=function(){function e(){t(this,e),this.reset()}return n(e,[{key:"reset",value:function(){this.xRounder=new v,this.yRounder=new v}},{key:"round",value:function(t,e){return{x:this.xRounder.round(t),y:this.yRounder.round(e)}}}]),e}(),v=function(){function e(){t(this,e),this.tree=new l,this.round(0)}return n(e,[{key:"round",value:function(t){var e=this.tree.add(t),n=this.tree.prev(e);if(null!==n&&0===_(e.key,n.key))return this.tree.remove(t),n.key;var r=this.tree.next(e);return null!==r&&0===_(e.key,r.key)?(this.tree.remove(t),r.key):t}}]),e}(),x=new m,b=function(t,e){return t.x*e.y-t.y*e.x},E=function(t,e){return t.x*e.x+t.y*e.y},I=function(t,e,n){var r={x:e.x-t.x,y:e.y-t.y},i={x:n.x-t.x,y:n.y-t.y},o=b(r,i);return _(o,0)},C=function(t){return Math.sqrt(E(t,t))},S=function(t,e,n){var r={x:e.x-t.x,y:e.y-t.y},i={x:n.x-t.x,y:n.y-t.y};return E(i,r)/C(i)/C(r)},w=function(t,e,n){return 0===e.y?null:{x:t.x+e.x/e.y*(n-t.y),y:n}},N=function(t,e,n){return 0===e.x?null:{x:n,y:t.y+e.y/e.x*(n-t.x)}},M=function(){function e(n,r){t(this,e),void 0===n.events?n.events=[this]:n.events.push(this),this.point=n,this.isLeft=r}return n(e,null,[{key:"compare",value:function(t,n){var r=e.comparePoints(t.point,n.point);return 0!==r?r:(t.point!==n.point&&t.link(n),t.isLeft!==n.isLeft?t.isLeft?1:-1:P.compare(t.segment,n.segment))}},{key:"comparePoints",value:function(t,e){return t.x<e.x?-1:t.x>e.x?1:t.y<e.y?-1:t.y>e.y?1:0}}]),n(e,[{key:"link",value:function(t){if(t.point===this.point)throw new Error("Tried to link already linked events");for(var e=t.point.events,n=0,r=e.length;n<r;n++){var i=e[n];this.point.events.push(i),i.point=this.point}this.checkForConsuming()}},{key:"checkForConsuming",value:function(){for(var t=this.point.events.length,e=0;e<t;e++){var n=this.point.events[e];if(void 0===n.segment.consumedBy)for(var r=e+1;r<t;r++){var i=this.point.events[r];void 0===i.consumedBy&&n.otherSE.point.events===i.otherSE.point.events&&n.segment.consume(i.segment)}}}},{key:"getAvailableLinkedEvents",value:function(){for(var t=[],e=0,n=this.point.events.length;e<n;e++){var r=this.point.events[e];r!==this&&!r.segment.ringOut&&r.segment.isInResult()&&t.push(r)}return t}},{key:"getLeftmostComparator",value:function(t){var e=this,n=new Map,r=function(r){var i,o,s,a,u,l=r.otherSE;n.set(r,{sine:(i=e.point,o=t.point,s=l.point,a={x:o.x-i.x,y:o.y-i.y},u={x:s.x-i.x,y:s.y-i.y},b(u,a)/C(u)/C(a)),cosine:S(e.point,t.point,l.point)})};return function(t,e){n.has(t)||r(t),n.has(e)||r(e);var i=n.get(t),o=i.sine,s=i.cosine,a=n.get(e),u=a.sine,l=a.cosine;return o>=0&&u>=0?s<l?1:s>l?-1:0:o<0&&u<0?s<l?-1:s>l?1:0:u<o?-1:u>o?1:0}}}]),e}(),L=0,P=function(){function e(n,r,i,o){t(this,e),this.id=++L,this.leftSE=n,n.segment=this,n.otherSE=r,this.rightSE=r,r.segment=this,r.otherSE=n,this.rings=i,this.windings=o}return n(e,null,[{key:"compare",value:function(t,e){var n=t.leftSE.point.x,r=e.leftSE.point.x,i=t.rightSE.point.x,o=e.rightSE.point.x;if(o<n)return 1;if(i<r)return-1;var s=t.leftSE.point.y,a=e.leftSE.point.y,u=t.rightSE.point.y,l=e.rightSE.point.y;if(n<r){if(a<s&&a<u)return 1;if(a>s&&a>u)return-1;var c=t.comparePoint(e.leftSE.point);if(c<0)return 1;if(c>0)return-1;var h=e.comparePoint(t.rightSE.point);return 0!==h?h:-1}if(n>r){if(s<a&&s<l)return-1;if(s>a&&s>l)return 1;var p=e.comparePoint(t.leftSE.point);if(0!==p)return p;var f=t.comparePoint(e.rightSE.point);return f<0?1:f>0?-1:1}if(s<a)return-1;if(s>a)return 1;if(i<o){var g=e.comparePoint(t.rightSE.point);if(0!==g)return g}if(i>o){var d=t.comparePoint(e.rightSE.point);if(d<0)return 1;if(d>0)return-1}if(i!==o){var y=u-s,_=i-n,m=l-a,v=o-r;if(y>_&&m<v)return 1;if(y<_&&m>v)return-1}return i>o?1:i<o||u<l?-1:u>l?1:t.id<e.id?-1:t.id>e.id?1:0}}]),n(e,[{key:"replaceRightSE",value:function(t){this.rightSE=t,this.rightSE.segment=this,this.rightSE.otherSE=this.leftSE,this.leftSE.otherSE=this.rightSE}},{key:"bbox",value:function(){var t=this.leftSE.point.y,e=this.rightSE.point.y;return{ll:{x:this.leftSE.point.x,y:t<e?t:e},ur:{x:this.rightSE.point.x,y:t>e?t:e}}}},{key:"vector",value:function(){return{x:this.rightSE.point.x-this.leftSE.point.x,y:this.rightSE.point.y-this.leftSE.point.y}}},{key:"isAnEndpoint",value:function(t){return t.x===this.leftSE.point.x&&t.y===this.leftSE.point.y||t.x===this.rightSE.point.x&&t.y===this.rightSE.point.y}},{key:"comparePoint",value:function(t){if(this.isAnEndpoint(t))return 0;var e=this.leftSE.point,n=this.rightSE.point,r=this.vector();if(e.x===n.x)return t.x===e.x?0:t.x<e.x?1:-1;var i=(t.y-e.y)/r.y,o=e.x+i*r.x;if(t.x===o)return 0;var s=(t.x-e.x)/r.x,a=e.y+s*r.y;return t.y===a?0:t.y<a?-1:1}},{key:"getIntersection",value:function(t){var e=this.bbox(),n=t.bbox(),r=g(e,n);if(null===r)return null;var i=this.leftSE.point,o=this.rightSE.point,s=t.leftSE.point,a=t.rightSE.point,u=f(e,s)&&0===this.comparePoint(s),l=f(n,i)&&0===t.comparePoint(i),c=f(e,a)&&0===this.comparePoint(a),h=f(n,o)&&0===t.comparePoint(o);if(l&&u)return h&&!c?o:!h&&c?a:null;if(l)return c&&i.x===a.x&&i.y===a.y?null:i;if(u)return h&&o.x===s.x&&o.y===s.y?null:s;if(h&&c)return null;if(h)return o;if(c)return a;var p=function(t,e,n,r){if(0===e.x)return N(n,r,t.x);if(0===r.x)return N(t,e,n.x);if(0===e.y)return w(n,r,t.y);if(0===r.y)return w(t,e,n.y);var i=b(e,r);if(0==i)return null;var o={x:n.x-t.x,y:n.y-t.y},s=b(o,e)/i,a=b(o,r)/i;return{x:(t.x+a*e.x+(n.x+s*r.x))/2,y:(t.y+a*e.y+(n.y+s*r.y))/2}}(i,this.vector(),s,t.vector());return null===p?null:f(r,p)?x.round(p.x,p.y):null}},{key:"split",value:function(t){var n=[],r=void 0!==t.events,i=new M(t,!0),o=new M(t,!1),s=this.rightSE;this.replaceRightSE(o),n.push(o),n.push(i);var a=new e(i,s,this.rings.slice(),this.windings.slice());return M.comparePoints(a.leftSE.point,a.rightSE.point)>0&&a.swapEvents(),M.comparePoints(this.leftSE.point,this.rightSE.point)>0&&this.swapEvents(),r&&(i.checkForConsuming(),o.checkForConsuming()),n}},{key:"swapEvents",value:function(){var t=this.rightSE;this.rightSE=this.leftSE,this.leftSE=t,this.leftSE.isLeft=!0,this.rightSE.isLeft=!1;for(var e=0,n=this.windings.length;e<n;e++)this.windings[e]*=-1}},{key:"consume",value:function(t){for(var n=this,r=t;n.consumedBy;)n=n.consumedBy;for(;r.consumedBy;)r=r.consumedBy;var i=e.compare(n,r);if(0!==i){if(i>0){var o=n;n=r,r=o}if(n.prev===r){var s=n;n=r,r=s}for(var a=0,u=r.rings.length;a<u;a++){var l=r.rings[a],c=r.windings[a],h=n.rings.indexOf(l);-1===h?(n.rings.push(l),n.windings.push(c)):n.windings[h]+=c}r.rings=null,r.windings=null,r.consumedBy=n,r.leftSE.consumedBy=n.leftSE,r.rightSE.consumedBy=n.rightSE}}},{key:"prevInResult",value:function(){return void 0!==this._prevInResult||(this.prev?this.prev.isInResult()?this._prevInResult=this.prev:this._prevInResult=this.prev.prevInResult():this._prevInResult=null),this._prevInResult}},{key:"beforeState",value:function(){if(void 0!==this._beforeState)return this._beforeState;if(this.prev){var t=this.prev.consumedBy||this.prev;this._beforeState=t.afterState()}else this._beforeState={rings:[],windings:[],multiPolys:[]};return this._beforeState}},{key:"afterState",value:function(){if(void 0!==this._afterState)return this._afterState;var t=this.beforeState();this._afterState={rings:t.rings.slice(0),windings:t.windings.slice(0),multiPolys:[]};for(var e=this._afterState.rings,n=this._afterState.windings,r=this._afterState.multiPolys,i=0,o=this.rings.length;i<o;i++){var s=this.rings[i],a=this.windings[i],u=e.indexOf(s);-1===u?(e.push(s),n.push(a)):n[u]+=a}for(var l=[],c=[],h=0,p=e.length;h<p;h++)if(0!==n[h]){var f=e[h],g=f.poly;if(-1===c.indexOf(g))if(f.isExterior)l.push(g);else{-1===c.indexOf(g)&&c.push(g);var d=l.indexOf(f.poly);-1!==d&&l.splice(d,1)}}for(var y=0,_=l.length;y<_;y++){var m=l[y].multiPoly;-1===r.indexOf(m)&&r.push(m)}return this._afterState}},{key:"isInResult",value:function(){if(this.consumedBy)return!1;if(void 0!==this._isInResult)return this._isInResult;var t=this.beforeState().multiPolys,e=this.afterState().multiPolys;switch(j.type){case"union":var n=0===t.length,r=0===e.length;this._isInResult=n!==r;break;case"intersection":var i,o;t.length<e.length?(i=t.length,o=e.length):(i=e.length,o=t.length),this._isInResult=o===j.numMultiPolys&&i<o;break;case"xor":var s=Math.abs(t.length-e.length);this._isInResult=s%2==1;break;case"difference":var a=function(t){return 1===t.length&&t[0].isSubject};this._isInResult=a(t)!==a(e);break;default:throw new Error("Unrecognized operation type found ".concat(j.type))}return this._isInResult}}],[{key:"fromRing",value:function(t,n,r){var i,o,s,a=M.comparePoints(t,n);if(a<0)i=t,o=n,s=1;else{if(!(a>0))throw new Error("Tried to create degenerate segment at [".concat(t.x,", ").concat(t.y,"]"));i=n,o=t,s=-1}return new e(new M(i,!0),new M(o,!1),[r],[s])}}]),e}(),O=function(){function e(n,r,i){if(t(this,e),!Array.isArray(n)||0===n.length)throw new Error("Input geometry is not a valid Polygon or MultiPolygon");if(this.poly=r,this.isExterior=i,this.segments=[],"number"!=typeof n[0][0]||"number"!=typeof n[0][1])throw new Error("Input geometry is not a valid Polygon or MultiPolygon");var o=x.round(n[0][0],n[0][1]);this.bbox={ll:{x:o.x,y:o.y},ur:{x:o.x,y:o.y}};for(var s=o,a=1,u=n.length;a<u;a++){if("number"!=typeof n[a][0]||"number"!=typeof n[a][1])throw new Error("Input geometry is not a valid Polygon or MultiPolygon");var l=x.round(n[a][0],n[a][1]);l.x===s.x&&l.y===s.y||(this.segments.push(P.fromRing(s,l,this)),l.x<this.bbox.ll.x&&(this.bbox.ll.x=l.x),l.y<this.bbox.ll.y&&(this.bbox.ll.y=l.y),l.x>this.bbox.ur.x&&(this.bbox.ur.x=l.x),l.y>this.bbox.ur.y&&(this.bbox.ur.y=l.y),s=l)}o.x===s.x&&o.y===s.y||this.segments.push(P.fromRing(s,o,this))}return n(e,[{key:"getSweepEvents",value:function(){for(var t=[],e=0,n=this.segments.length;e<n;e++){var r=this.segments[e];t.push(r.leftSE),t.push(r.rightSE)}return t}}]),e}(),R=function(){function e(n,r){if(t(this,e),!Array.isArray(n))throw new Error("Input geometry is not a valid Polygon or MultiPolygon");this.exteriorRing=new O(n[0],this,!0),this.bbox={ll:{x:this.exteriorRing.bbox.ll.x,y:this.exteriorRing.bbox.ll.y},ur:{x:this.exteriorRing.bbox.ur.x,y:this.exteriorRing.bbox.ur.y}},this.interiorRings=[];for(var i=1,o=n.length;i<o;i++){var s=new O(n[i],this,!1);s.bbox.ll.x<this.bbox.ll.x&&(this.bbox.ll.x=s.bbox.ll.x),s.bbox.ll.y<this.bbox.ll.y&&(this.bbox.ll.y=s.bbox.ll.y),s.bbox.ur.x>this.bbox.ur.x&&(this.bbox.ur.x=s.bbox.ur.x),s.bbox.ur.y>this.bbox.ur.y&&(this.bbox.ur.y=s.bbox.ur.y),this.interiorRings.push(s)}this.multiPoly=r}return n(e,[{key:"getSweepEvents",value:function(){for(var t=this.exteriorRing.getSweepEvents(),e=0,n=this.interiorRings.length;e<n;e++)for(var r=this.interiorRings[e].getSweepEvents(),i=0,o=r.length;i<o;i++)t.push(r[i]);return t}}]),e}(),T=function(){function e(n,r){if(t(this,e),!Array.isArray(n))throw new Error("Input geometry is not a valid Polygon or MultiPolygon");try{"number"==typeof n[0][0][0]&&(n=[n])}catch(t){}this.polys=[],this.bbox={ll:{x:Number.POSITIVE_INFINITY,y:Number.POSITIVE_INFINITY},ur:{x:Number.NEGATIVE_INFINITY,y:Number.NEGATIVE_INFINITY}};for(var i=0,o=n.length;i<o;i++){var s=new R(n[i],this);s.bbox.ll.x<this.bbox.ll.x&&(this.bbox.ll.x=s.bbox.ll.x),s.bbox.ll.y<this.bbox.ll.y&&(this.bbox.ll.y=s.bbox.ll.y),s.bbox.ur.x>this.bbox.ur.x&&(this.bbox.ur.x=s.bbox.ur.x),s.bbox.ur.y>this.bbox.ur.y&&(this.bbox.ur.y=s.bbox.ur.y),this.polys.push(s)}this.isSubject=r}return n(e,[{key:"getSweepEvents",value:function(){for(var t=[],e=0,n=this.polys.length;e<n;e++)for(var r=this.polys[e].getSweepEvents(),i=0,o=r.length;i<o;i++)t.push(r[i]);return t}}]),e}(),A=function(){function e(n){t(this,e),this.events=n;for(var r=0,i=n.length;r<i;r++)n[r].segment.ringOut=this;this.poly=null}return n(e,null,[{key:"factory",value:function(t){for(var n=[],r=0,i=t.length;r<i;r++){var o=t[r];if(o.isInResult()&&!o.ringOut){for(var s=null,a=o.leftSE,u=o.rightSE,l=[a],c=a.point,h=[];s=a,a=u,l.push(a),a.point!==c;)for(;;){var p=a.getAvailableLinkedEvents();if(0===p.length){var f=l[0].point,g=l[l.length-1].point;throw new Error("Unable to complete output ring starting at [".concat(f.x,",")+" ".concat(f.y,"]. Last matching segment found ends at")+" [".concat(g.x,", ").concat(g.y,"]."))}if(1===p.length){u=p[0].otherSE;break}for(var d=null,y=0,_=h.length;y<_;y++)if(h[y].point===a.point){d=y;break}if(null===d){h.push({index:l.length,point:a.point});var m=a.getLeftmostComparator(s);u=p.sort(m)[0].otherSE;break}var v=h.splice(d)[0],x=l.splice(v.index);x.unshift(x[0].otherSE),n.push(new e(x.reverse()))}n.push(new e(l))}}return n}}]),n(e,[{key:"getGeom",value:function(){for(var t=this.events[0].point,e=[t],n=1,r=this.events.length-1;n<r;n++){var i=this.events[n].point,o=this.events[n+1].point;0!==I(i,t,o)&&(e.push(i),t=i)}if(1===e.length)return null;var s=e[0],a=e[1];0===I(s,t,a)&&e.shift(),e.push(e[0]);for(var u=this.isExteriorRing()?1:-1,l=this.isExteriorRing()?0:e.length-1,c=this.isExteriorRing()?e.length:-1,h=[],p=l;p!=c;p+=u)h.push([e[p].x,e[p].y]);return h}},{key:"isExteriorRing",value:function(){if(void 0===this._isExteriorRing){var t=this.enclosingRing();this._isExteriorRing=!t||!t.isExteriorRing()}return this._isExteriorRing}},{key:"enclosingRing",value:function(){return void 0===this._enclosingRing&&(this._enclosingRing=this._calcEnclosingRing()),this._enclosingRing}},{key:"_calcEnclosingRing",value:function(){for(var t=this.events[0],e=1,n=this.events.length;e<n;e++){var r=this.events[e];M.compare(t,r)>0&&(t=r)}for(var i=t.segment.prevInResult(),o=i?i.prevInResult():null;;){if(!i)return null;if(!o)return i.ringOut;if(o.ringOut!==i.ringOut)return o.ringOut.enclosingRing()!==i.ringOut?i.ringOut:i.ringOut.enclosingRing();i=o.prevInResult(),o=i?i.prevInResult():null}}}]),e}(),D=function(){function e(n){t(this,e),this.exteriorRing=n,n.poly=this,this.interiorRings=[]}return n(e,[{key:"addInterior",value:function(t){this.interiorRings.push(t),t.poly=this}},{key:"getGeom",value:function(){var t=[this.exteriorRing.getGeom()];if(null===t[0])return null;for(var e=0,n=this.interiorRings.length;e<n;e++){var r=this.interiorRings[e].getGeom();null!==r&&t.push(r)}return t}}]),e}(),F=function(){function e(n){t(this,e),this.rings=n,this.polys=this._composePolys(n)}return n(e,[{key:"getGeom",value:function(){for(var t=[],e=0,n=this.polys.length;e<n;e++){var r=this.polys[e].getGeom();null!==r&&t.push(r)}return t}},{key:"_composePolys",value:function(t){for(var e=[],n=0,r=t.length;n<r;n++){var i=t[n];if(!i.poly)if(i.isExteriorRing())e.push(new D(i));else{var o=i.enclosingRing();o.poly||e.push(new D(o)),o.poly.addInterior(i)}}return e}}]),e}(),k=function(){function e(n){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:P.compare;t(this,e),this.queue=n,this.tree=new l(r),this.segments=[]}return n(e,[{key:"process",value:function(t){var e=t.segment,n=[];if(t.consumedBy)return t.isLeft?this.queue.remove(t.otherSE):this.tree.remove(e),n;var r=t.isLeft?this.tree.insert(e):this.tree.find(e);if(!r)throw new Error("Unable to find segment #".concat(e.id," ")+"[".concat(e.leftSE.point.x,", ").concat(e.leftSE.point.y,"] -> ")+"[".concat(e.rightSE.point.x,", ").concat(e.rightSE.point.y,"] ")+"in SweepLine tree. Please submit a bug report.");for(var i=r,o=r,s=void 0,a=void 0;void 0===s;)null===(i=this.tree.prev(i))?s=null:void 0===i.key.consumedBy&&(s=i.key);for(;void 0===a;)null===(o=this.tree.next(o))?a=null:void 0===o.key.consumedBy&&(a=o.key);if(t.isLeft){var u=null;if(s){var l=s.getIntersection(e);if(null!==l&&(e.isAnEndpoint(l)||(u=l),!s.isAnEndpoint(l)))for(var c=this._splitSafely(s,l),h=0,p=c.length;h<p;h++)n.push(c[h])}var f=null;if(a){var g=a.getIntersection(e);if(null!==g&&(e.isAnEndpoint(g)||(f=g),!a.isAnEndpoint(g)))for(var d=this._splitSafely(a,g),y=0,_=d.length;y<_;y++)n.push(d[y])}if(null!==u||null!==f){var m;m=null===u?f:null===f||M.comparePoints(u,f)<=0?u:f,this.queue.remove(e.rightSE),n.push(e.rightSE);for(var v=e.split(m),x=0,b=v.length;x<b;x++)n.push(v[x])}n.length>0?(this.tree.remove(e),n.push(t)):(this.segments.push(e),e.prev=s)}else{if(s&&a){var E=s.getIntersection(a);if(null!==E){if(!s.isAnEndpoint(E))for(var I=this._splitSafely(s,E),C=0,S=I.length;C<S;C++)n.push(I[C]);if(!a.isAnEndpoint(E))for(var w=this._splitSafely(a,E),N=0,L=w.length;N<L;N++)n.push(w[N])}}this.tree.remove(e)}return n}},{key:"_splitSafely",value:function(t,e){this.tree.remove(t);var n=t.rightSE;this.queue.remove(n);var r=t.split(e);return r.push(n),void 0===t.consumedBy&&this.tree.insert(t),r}}]),e}(),G="undefined"!=typeof process&&process.env.POLYGON_CLIPPING_MAX_QUEUE_SIZE||1e6,B="undefined"!=typeof process&&process.env.POLYGON_CLIPPING_MAX_SWEEPLINE_SEGMENTS||1e6,j=new(function(){function e(){t(this,e)}return n(e,[{key:"run",value:function(t,e,n){j.type=t,x.reset();for(var r=[new T(e,!0)],i=0,o=n.length;i<o;i++)r.push(new T(n[i],!1));if(j.numMultiPolys=r.length,"difference"===j.type)for(var s=r[0],a=1;a<r.length;)null!==g(r[a].bbox,s.bbox)?a++:r.splice(a,1);if("intersection"===j.type)for(var u=0,c=r.length;u<c;u++)for(var h=r[u],p=u+1,f=r.length;p<f;p++)if(null===g(h.bbox,r[p].bbox))return[];for(var d=new l(M.compare),y=0,_=r.length;y<_;y++)for(var m=r[y].getSweepEvents(),v=0,b=m.length;v<b;v++)if(d.insert(m[v]),d.size>G)throw new Error("Infinite loop when putting segment endpoints in a priority queue (queue size too big). Please file a bug report.");for(var E=new k(d),I=d.size,C=d.pop();C;){var S=C.key;if(d.size===I){var w=S.segment;throw new Error("Unable to pop() ".concat(S.isLeft?"left":"right"," SweepEvent ")+"[".concat(S.point.x,", ").concat(S.point.y,"] from segment #").concat(w.id," ")+"[".concat(w.leftSE.point.x,", ").concat(w.leftSE.point.y,"] -> ")+"[".concat(w.rightSE.point.x,", ").concat(w.rightSE.point.y,"] from queue. ")+"Please file a bug report.")}if(d.size>G)throw new Error("Infinite loop when passing sweep line over endpoints (queue size too big). Please file a bug report.");if(E.segments.length>B)throw new Error("Infinite loop when passing sweep line over endpoints (too many sweep line segments). Please file a bug report.");for(var N=E.process(S),L=0,P=N.length;L<P;L++){var O=N[L];void 0===O.consumedBy&&d.insert(O)}I=d.size,C=d.pop()}x.reset();var R=A.factory(E.segments);return new F(R).getGeom()}}]),e}());return{union:function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];return j.run("union",t,n)},intersection:function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];return j.run("intersection",t,n)},xor:function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];return j.run("xor",t,n)},difference:function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),r=1;r<e;r++)n[r-1]=arguments[r];return j.run("difference",t,n)}}}()},5510:(t,e,n)=>{"use strict";t.exports=i,t.exports.default=i;var r=n(4291);function i(t,e){if(!(this instanceof i))return new i(t,e);this._maxEntries=Math.max(4,t||9),this._minEntries=Math.max(2,Math.ceil(.4*this._maxEntries)),e&&this._initFormat(e),this.clear()}function o(t,e,n){if(!n)return e.indexOf(t);for(var r=0;r<e.length;r++)if(n(t,e[r]))return r;return-1}function s(t,e){a(t,0,t.children.length,e,t)}function a(t,e,n,r,i){i||(i=d(null)),i.minX=1/0,i.minY=1/0,i.maxX=-1/0,i.maxY=-1/0;for(var o,s=e;s<n;s++)o=t.children[s],u(i,t.leaf?r(o):o);return i}function u(t,e){return t.minX=Math.min(t.minX,e.minX),t.minY=Math.min(t.minY,e.minY),t.maxX=Math.max(t.maxX,e.maxX),t.maxY=Math.max(t.maxY,e.maxY),t}function l(t,e){return t.minX-e.minX}function c(t,e){return t.minY-e.minY}function h(t){return(t.maxX-t.minX)*(t.maxY-t.minY)}function p(t){return t.maxX-t.minX+(t.maxY-t.minY)}function f(t,e){return t.minX<=e.minX&&t.minY<=e.minY&&e.maxX<=t.maxX&&e.maxY<=t.maxY}function g(t,e){return e.minX<=t.maxX&&e.minY<=t.maxY&&e.maxX>=t.minX&&e.maxY>=t.minY}function d(t){return{children:t,height:1,leaf:!0,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0}}function y(t,e,n,i,o){for(var s,a=[e,n];a.length;)(n=a.pop())-(e=a.pop())<=i||(s=e+Math.ceil((n-e)/i/2)*i,r(t,s,e,n,o),a.push(e,s,s,n))}i.prototype={all:function(){return this._all(this.data,[])},search:function(t){var e=this.data,n=[],r=this.toBBox;if(!g(t,e))return n;for(var i,o,s,a,u=[];e;){for(i=0,o=e.children.length;i<o;i++)s=e.children[i],g(t,a=e.leaf?r(s):s)&&(e.leaf?n.push(s):f(t,a)?this._all(s,n):u.push(s));e=u.pop()}return n},collides:function(t){var e=this.data,n=this.toBBox;if(!g(t,e))return!1;for(var r,i,o,s,a=[];e;){for(r=0,i=e.children.length;r<i;r++)if(o=e.children[r],g(t,s=e.leaf?n(o):o)){if(e.leaf||f(t,s))return!0;a.push(o)}e=a.pop()}return!1},load:function(t){if(!t||!t.length)return this;if(t.length<this._minEntries){for(var e=0,n=t.length;e<n;e++)this.insert(t[e]);return this}var r=this._build(t.slice(),0,t.length-1,0);if(this.data.children.length)if(this.data.height===r.height)this._splitRoot(this.data,r);else{if(this.data.height<r.height){var i=this.data;this.data=r,r=i}this._insert(r,this.data.height-r.height-1,!0)}else this.data=r;return this},insert:function(t){return t&&this._insert(t,this.data.height-1),this},clear:function(){return this.data=d([]),this},remove:function(t,e){if(!t)return this;for(var n,r,i,s,a=this.data,u=this.toBBox(t),l=[],c=[];a||l.length;){if(a||(a=l.pop(),r=l[l.length-1],n=c.pop(),s=!0),a.leaf&&-1!==(i=o(t,a.children,e)))return a.children.splice(i,1),l.push(a),this._condense(l),this;s||a.leaf||!f(a,u)?r?(n++,a=r.children[n],s=!1):a=null:(l.push(a),c.push(n),n=0,r=a,a=a.children[0])}return this},toBBox:function(t){return t},compareMinX:l,compareMinY:c,toJSON:function(){return this.data},fromJSON:function(t){return this.data=t,this},_all:function(t,e){for(var n=[];t;)t.leaf?e.push.apply(e,t.children):n.push.apply(n,t.children),t=n.pop();return e},_build:function(t,e,n,r){var i,o=n-e+1,a=this._maxEntries;if(o<=a)return s(i=d(t.slice(e,n+1)),this.toBBox),i;r||(r=Math.ceil(Math.log(o)/Math.log(a)),a=Math.ceil(o/Math.pow(a,r-1))),(i=d([])).leaf=!1,i.height=r;var u,l,c,h,p=Math.ceil(o/a),f=p*Math.ceil(Math.sqrt(a));for(y(t,e,n,f,this.compareMinX),u=e;u<=n;u+=f)for(y(t,u,c=Math.min(u+f-1,n),p,this.compareMinY),l=u;l<=c;l+=p)h=Math.min(l+p-1,c),i.children.push(this._build(t,l,h,r-1));return s(i,this.toBBox),i},_chooseSubtree:function(t,e,n,r){for(var i,o,s,a,u,l,c,p,f,g;r.push(e),!e.leaf&&r.length-1!==n;){for(c=p=1/0,i=0,o=e.children.length;i<o;i++)u=h(s=e.children[i]),f=t,g=s,(l=(Math.max(g.maxX,f.maxX)-Math.min(g.minX,f.minX))*(Math.max(g.maxY,f.maxY)-Math.min(g.minY,f.minY))-u)<p?(p=l,c=u<c?u:c,a=s):l===p&&u<c&&(c=u,a=s);e=a||e.children[0]}return e},_insert:function(t,e,n){var r=this.toBBox,i=n?t:r(t),o=[],s=this._chooseSubtree(i,this.data,e,o);for(s.children.push(t),u(s,i);e>=0&&o[e].children.length>this._maxEntries;)this._split(o,e),e--;this._adjustParentBBoxes(i,o,e)},_split:function(t,e){var n=t[e],r=n.children.length,i=this._minEntries;this._chooseSplitAxis(n,i,r);var o=this._chooseSplitIndex(n,i,r),a=d(n.children.splice(o,n.children.length-o));a.height=n.height,a.leaf=n.leaf,s(n,this.toBBox),s(a,this.toBBox),e?t[e-1].children.push(a):this._splitRoot(n,a)},_splitRoot:function(t,e){this.data=d([t,e]),this.data.height=t.height+1,this.data.leaf=!1,s(this.data,this.toBBox)},_chooseSplitIndex:function(t,e,n){var r,i,o,s,u,l,c,p,f,g,d,y,_,m;for(l=c=1/0,r=e;r<=n-e;r++)f=i=a(t,0,r,this.toBBox),g=o=a(t,r,n,this.toBBox),void 0,void 0,void 0,void 0,d=Math.max(f.minX,g.minX),y=Math.max(f.minY,g.minY),_=Math.min(f.maxX,g.maxX),m=Math.min(f.maxY,g.maxY),s=Math.max(0,_-d)*Math.max(0,m-y),u=h(i)+h(o),s<l?(l=s,p=r,c=u<c?u:c):s===l&&u<c&&(c=u,p=r);return p},_chooseSplitAxis:function(t,e,n){var r=t.leaf?this.compareMinX:l,i=t.leaf?this.compareMinY:c;this._allDistMargin(t,e,n,r)<this._allDistMargin(t,e,n,i)&&t.children.sort(r)},_allDistMargin:function(t,e,n,r){t.children.sort(r);var i,o,s=this.toBBox,l=a(t,0,e,s),c=a(t,n-e,n,s),h=p(l)+p(c);for(i=e;i<n-e;i++)o=t.children[i],u(l,t.leaf?s(o):o),h+=p(l);for(i=n-e-1;i>=e;i--)o=t.children[i],u(c,t.leaf?s(o):o),h+=p(c);return h},_adjustParentBBoxes:function(t,e,n){for(var r=n;r>=0;r--)u(e[r],t)},_condense:function(t){for(var e,n=t.length-1;n>=0;n--)0===t[n].children.length?n>0?(e=t[n-1].children).splice(e.indexOf(t[n]),1):this.clear():s(t[n],this.toBBox)},_initFormat:function(t){var e=["return a"," - b",";"];this.compareMinX=new Function("a","b",e.join(t[0])),this.compareMinY=new Function("a","b",e.join(t[1])),this.toBBox=new Function("a","return {minX: a"+t[0]+", minY: a"+t[1]+", maxX: a"+t[2]+", maxY: a"+t[3]+"};")}}},4291:function(t){t.exports=function(){"use strict";function t(n,r,i,o,s){for(;o>i;){if(o-i>600){var a=o-i+1,u=r-i+1,l=Math.log(a),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(a-c)/a)*(u-a/2<0?-1:1);t(n,r,Math.max(i,Math.floor(r-u*c/a+h)),Math.min(o,Math.floor(r+(a-u)*c/a+h)),s)}var p=n[r],f=i,g=o;for(e(n,i,r),s(n[o],p)>0&&e(n,i,o);f<g;){for(e(n,f,g),f++,g--;s(n[f],p)<0;)f++;for(;s(n[g],p)>0;)g--}0===s(n[i],p)?e(n,i,g):e(n,++g,o),g<=r&&(i=g+1),r<=g&&(o=g-1)}}function e(t,e,n){var r=t[e];t[e]=t[n],t[n]=r}function n(t,e){return t<e?-1:t>e?1:0}return function(e,r,i,o,s){t(e,r,i||0,o||e.length-1,s||n)}}()},3697:(t,e,n)=>{"use strict";var r=n(5972).functionsHaveConfigurableNames(),i=Object,o=TypeError;t.exports=function(){if(null!=this&&this!==i(this))throw new o("RegExp.prototype.flags getter called on non-object");var t="";return this.hasIndices&&(t+="d"),this.global&&(t+="g"),this.ignoreCase&&(t+="i"),this.multiline&&(t+="m"),this.dotAll&&(t+="s"),this.unicode&&(t+="u"),this.sticky&&(t+="y"),t},r&&Object.defineProperty&&Object.defineProperty(t.exports,"name",{value:"get flags"})},2847:(t,e,n)=>{"use strict";var r=n(4289),i=n(5559),o=n(3697),s=n(1721),a=n(2753),u=i(s());r(u,{getPolyfill:s,implementation:o,shim:a}),t.exports=u},1721:(t,e,n)=>{"use strict";var r=n(3697),i=n(4289).supportsDescriptors,o=Object.getOwnPropertyDescriptor;t.exports=function(){if(i&&"gim"===/a/gim.flags){var t=o(RegExp.prototype,"flags");if(t&&"function"==typeof t.get&&"boolean"==typeof RegExp.prototype.dotAll&&"boolean"==typeof RegExp.prototype.hasIndices){var e="",n={};if(Object.defineProperty(n,"hasIndices",{get:function(){e+="d"}}),Object.defineProperty(n,"sticky",{get:function(){e+="y"}}),"dy"===e)return t.get}}return r}},2753:(t,e,n)=>{"use strict";var r=n(4289).supportsDescriptors,i=n(1721),o=Object.getOwnPropertyDescriptor,s=Object.defineProperty,a=TypeError,u=Object.getPrototypeOf,l=/a/;t.exports=function(){if(!r||!u)throw new a("RegExp.prototype.flags requires a true ES5 environment that supports property descriptors");var t=i(),e=u(l),n=o(e,"flags");return n&&n.get===t||s(e,"flags",{configurable:!0,enumerable:!1,get:t}),t}},8639:function(t,e){!function(t){"use strict";const e=134217729;function n(t,e,n,r,i){let o,s,a,u,l=e[0],c=r[0],h=0,p=0;c>l==c>-l?(o=l,l=e[++h]):(o=c,c=r[++p]);let f=0;if(h<t&&p<n)for(c>l==c>-l?(a=o-((s=l+o)-l),l=e[++h]):(a=o-((s=c+o)-c),c=r[++p]),o=s,0!==a&&(i[f++]=a);h<t&&p<n;)c>l==c>-l?(a=o-((s=o+l)-(u=s-o))+(l-u),l=e[++h]):(a=o-((s=o+c)-(u=s-o))+(c-u),c=r[++p]),o=s,0!==a&&(i[f++]=a);for(;h<t;)a=o-((s=o+l)-(u=s-o))+(l-u),l=e[++h],o=s,0!==a&&(i[f++]=a);for(;p<n;)a=o-((s=o+c)-(u=s-o))+(c-u),c=r[++p],o=s,0!==a&&(i[f++]=a);return 0===o&&0!==f||(i[f++]=o),f}function r(t){return new Float64Array(t)}const i=r(4),o=r(8),s=r(12),a=r(16),u=r(4);t.orient2d=function(t,r,l,c,h,p){const f=(r-p)*(l-h),g=(t-h)*(c-p),d=f-g;if(0===f||0===g||f>0!=g>0)return d;const y=Math.abs(f+g);return Math.abs(d)>=33306690738754716e-32*y?d:-function(t,r,l,c,h,p,f){let g,d,y,_,m,v,x,b,E,I,C,S,w,N,M,L,P,O;const R=t-h,T=l-h,A=r-p,D=c-p;m=(M=(b=R-(x=(v=e*R)-(v-R)))*(I=D-(E=(v=e*D)-(v-D)))-((N=R*D)-x*E-b*E-x*I))-(C=M-(P=(b=A-(x=(v=e*A)-(v-A)))*(I=T-(E=(v=e*T)-(v-T)))-((L=A*T)-x*E-b*E-x*I))),i[0]=M-(C+m)+(m-P),m=(w=N-((S=N+C)-(m=S-N))+(C-m))-(C=w-L),i[1]=w-(C+m)+(m-L),m=(O=S+C)-S,i[2]=S-(O-m)+(C-m),i[3]=O;let F=function(t,e){let n=e[0];for(let t=1;t<4;t++)n+=e[t];return n}(0,i),k=22204460492503146e-32*f;if(F>=k||-F>=k)return F;if(g=t-(R+(m=t-R))+(m-h),y=l-(T+(m=l-T))+(m-h),d=r-(A+(m=r-A))+(m-p),_=c-(D+(m=c-D))+(m-p),0===g&&0===d&&0===y&&0===_)return F;if(k=11093356479670487e-47*f+33306690738754706e-32*Math.abs(F),(F+=R*_+D*g-(A*y+T*d))>=k||-F>=k)return F;m=(M=(b=g-(x=(v=e*g)-(v-g)))*(I=D-(E=(v=e*D)-(v-D)))-((N=g*D)-x*E-b*E-x*I))-(C=M-(P=(b=d-(x=(v=e*d)-(v-d)))*(I=T-(E=(v=e*T)-(v-T)))-((L=d*T)-x*E-b*E-x*I))),u[0]=M-(C+m)+(m-P),m=(w=N-((S=N+C)-(m=S-N))+(C-m))-(C=w-L),u[1]=w-(C+m)+(m-L),m=(O=S+C)-S,u[2]=S-(O-m)+(C-m),u[3]=O;const G=n(4,i,4,u,o);m=(M=(b=R-(x=(v=e*R)-(v-R)))*(I=_-(E=(v=e*_)-(v-_)))-((N=R*_)-x*E-b*E-x*I))-(C=M-(P=(b=A-(x=(v=e*A)-(v-A)))*(I=y-(E=(v=e*y)-(v-y)))-((L=A*y)-x*E-b*E-x*I))),u[0]=M-(C+m)+(m-P),m=(w=N-((S=N+C)-(m=S-N))+(C-m))-(C=w-L),u[1]=w-(C+m)+(m-L),m=(O=S+C)-S,u[2]=S-(O-m)+(C-m),u[3]=O;const B=n(G,o,4,u,s);m=(M=(b=g-(x=(v=e*g)-(v-g)))*(I=_-(E=(v=e*_)-(v-_)))-((N=g*_)-x*E-b*E-x*I))-(C=M-(P=(b=d-(x=(v=e*d)-(v-d)))*(I=y-(E=(v=e*y)-(v-y)))-((L=d*y)-x*E-b*E-x*I))),u[0]=M-(C+m)+(m-P),m=(w=N-((S=N+C)-(m=S-N))+(C-m))-(C=w-L),u[1]=w-(C+m)+(m-L),m=(O=S+C)-S,u[2]=S-(O-m)+(C-m),u[3]=O;const j=n(B,s,4,u,a);return a[j-1]}(t,r,l,c,h,p,y)},t.orient2dfast=function(t,e,n,r,i,o){return(e-o)*(n-i)-(t-i)*(r-o)},Object.defineProperty(t,"__esModule",{value:!0})}(e)},5697:t=>{"use strict";t.exports={eudist:function(t,e,n){for(var r=t.length,i=0,o=0;o<r;o++){var s=(t[o]||0)-(e[o]||0);i+=s*s}return n?Math.sqrt(i):i},mandist:function(t,e,n){for(var r=t.length,i=0,o=0;o<r;o++)i+=Math.abs((t[o]||0)-(e[o]||0));return n?Math.sqrt(i):i},dist:function(t,e,n){var r=Math.abs(t-e);return n?r:r*r}}},7035:(t,e,n)=>{"use strict";var r=n(5697),i=r.eudist,o=r.dist;t.exports={kmrand:function(t,e){for(var n={},r=[],i=e<<2,o=t.length,s=t[0].length>0;r.length<e&&i-- >0;){var a=t[Math.floor(Math.random()*o)],u=s?a.join("_"):""+a;n[u]||(n[u]=!0,r.push(a))}if(r.length<e)throw new Error("Error initializating clusters");return r},kmpp:function(t,e){var n=t[0].length?i:o,r=[],s=t.length,a=t[0].length>0,u=t[Math.floor(Math.random()*s)];for(a&&u.join("_"),r.push(u);r.length<e;){for(var l=[],c=r.length,h=0,p=[],f=0;f<s;f++){for(var g=1/0,d=0;d<c;d++){var y=n(t[f],r[d]);y<=g&&(g=y)}l[f]=g}for(var _=0;_<s;_++)h+=l[_];for(var m=0;m<s;m++)p[m]={i:m,v:t[m],pr:l[m]/h,cs:0};p.sort((function(t,e){return t.pr-e.pr})),p[0].cs=p[0].pr;for(var v=1;v<s;v++)p[v].cs=p[v-1].cs+p[v].pr;for(var x=Math.random(),b=0;b<s-1&&p[b++].cs<x;);r.push(p[b-1].v)}return r}}},1160:(t,e,n)=>{"use strict";var r=n(5697),i=n(7035),o=r.eudist,s=(r.mandist,r.dist,i.kmrand),a=i.kmpp;function u(t,e,n){n=n||[];for(var r=0;r<t;r++)n[r]=e;return n}t.exports=function(t,e,n,r){var i=[],l=[],c=[],h=[],p=!1,f=r||1e4,g=t.length,d=t[0].length,y=d>0,_=[];if(n)i="kmrand"==n?s(t,e):"kmpp"==n?a(t,e):n;else for(var m={};i.length<e;){var v=Math.floor(Math.random()*g);m[v]||(m[v]=!0,i.push(t[v]))}do{u(e,0,_);for(var x=0;x<g;x++){for(var b=1/0,E=0,I=0;I<e;I++)(h=y?o(t[x],i[I]):Math.abs(t[x]-i[I]))<=b&&(b=h,E=I);c[x]=E,_[E]++}for(var C=[],S=(l=[],0);S<e;S++)C[S]=y?u(d,0,C[S]):0,l[S]=i[S];if(y){for(var w=0;w<e;w++)i[w]=[];for(var N=0;N<g;N++)for(var M=C[c[N]],L=t[N],P=0;P<d;P++)M[P]+=L[P];p=!0;for(var O=0;O<e;O++){for(var R=i[O],T=C[O],A=l[O],D=_[O],F=0;F<d;F++)R[F]=T[F]/D||0;if(p)for(var k=0;k<d;k++)if(A[k]!=R[k]){p=!1;break}}}else{for(var G=0;G<g;G++)C[c[G]]+=t[G];for(var B=0;B<e;B++)i[B]=C[B]/_[B]||0;p=!0;for(var j=0;j<e;j++)if(l[j]!=i[j]){p=!1;break}}p=p||--f<=0}while(!p);return{it:1e4-f,k:e,idxs:c,centroids:i}}},3842:(t,e,n)=>{"use strict";n.r(e),n.d(e,{default:()=>r});class r{constructor(t=[],e=i){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this.length++,this._up(this.length-1)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:n}=this,r=e[t];for(;t>0;){const i=t-1>>1,o=e[i];if(n(r,o)>=0)break;e[t]=o,t=i}e[t]=r}_down(t){const{data:e,compare:n}=this,r=this.length>>1,i=e[t];for(;t<r;){let r=1+(t<<1),o=e[r];const s=r+1;if(s<this.length&&n(e[s],o)<0&&(r=s,o=e[s]),n(o,i)>=0)break;e[t]=o,t=r}e[t]=i}}function i(t,e){return t<e?-1:t>e?1:0}},675:function(t,e){!function(t){"use strict";function e(){}function n(t){this.message=t||""}function r(t){this.message=t||""}function i(t){this.message=t||""}function o(){}function s(t){return null===t?At:t.color}function a(t){return null===t?null:t.parent}function u(t,e){null!==t&&(t.color=e)}function l(t){return null===t?null:t.left}function c(t){return null===t?null:t.right}function h(){this.root_=null,this.size_=0}function p(){}function f(){this.array_=[],arguments[0]instanceof xt&&this.addAll(arguments[0])}function g(){}function d(t){this.message=t||""}function y(){this.array_=[]}"fill"in Array.prototype||Object.defineProperty(Array.prototype,"fill",{configurable:!0,value:function(t){if(null==this)throw new TypeError(this+" is not an object");var e=Object(this),n=Math.max(Math.min(e.length,9007199254740991),0)||0,r=1 in arguments&&parseInt(Number(arguments[1]),10)||0;r=r<0?Math.max(n+r,0):Math.min(r,n);var i=2 in arguments&&void 0!==arguments[2]?parseInt(Number(arguments[2]),10)||0:n;for(i=i<0?Math.max(n+arguments[2],0):Math.min(i,n);r<i;)e[r]=t,++r;return e},writable:!0}),Number.isFinite=Number.isFinite||function(t){return"number"==typeof t&&isFinite(t)},Number.isInteger=Number.isInteger||function(t){return"number"==typeof t&&isFinite(t)&&Math.floor(t)===t},Number.parseFloat=Number.parseFloat||parseFloat,Number.isNaN=Number.isNaN||function(t){return t!=t},Math.trunc=Math.trunc||function(t){return t<0?Math.ceil(t):Math.floor(t)};var _=function(){};_.prototype.interfaces_=function(){return[]},_.prototype.getClass=function(){return _},_.prototype.equalsWithTolerance=function(t,e,n){return Math.abs(t-e)<=n};var m=function(t){function e(e){t.call(this,e),this.name="IllegalArgumentException",this.message=e,this.stack=(new t).stack}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Error),v=function(){},x={MAX_VALUE:{configurable:!0}};v.isNaN=function(t){return Number.isNaN(t)},v.doubleToLongBits=function(t){return t},v.longBitsToDouble=function(t){return t},v.isInfinite=function(t){return!Number.isFinite(t)},x.MAX_VALUE.get=function(){return Number.MAX_VALUE},Object.defineProperties(v,x);var b=function(){},E=function(){},I=function(){},C=function t(){if(this.x=null,this.y=null,this.z=null,0===arguments.length)this.x=0,this.y=0,this.z=t.NULL_ORDINATE;else if(1===arguments.length){var e=arguments[0];this.x=e.x,this.y=e.y,this.z=e.z}else 2===arguments.length?(this.x=arguments[0],this.y=arguments[1],this.z=t.NULL_ORDINATE):3===arguments.length&&(this.x=arguments[0],this.y=arguments[1],this.z=arguments[2])},S={DimensionalComparator:{configurable:!0},serialVersionUID:{configurable:!0},NULL_ORDINATE:{configurable:!0},X:{configurable:!0},Y:{configurable:!0},Z:{configurable:!0}};C.prototype.setOrdinate=function(t,e){switch(t){case C.X:this.x=e;break;case C.Y:this.y=e;break;case C.Z:this.z=e;break;default:throw new m("Invalid ordinate index: "+t)}},C.prototype.equals2D=function(){if(1===arguments.length){var t=arguments[0];return this.x===t.x&&this.y===t.y}if(2===arguments.length){var e=arguments[0],n=arguments[1];return!!_.equalsWithTolerance(this.x,e.x,n)&&!!_.equalsWithTolerance(this.y,e.y,n)}},C.prototype.getOrdinate=function(t){switch(t){case C.X:return this.x;case C.Y:return this.y;case C.Z:return this.z}throw new m("Invalid ordinate index: "+t)},C.prototype.equals3D=function(t){return this.x===t.x&&this.y===t.y&&(this.z===t.z||v.isNaN(this.z))&&v.isNaN(t.z)},C.prototype.equals=function(t){return t instanceof C&&this.equals2D(t)},C.prototype.equalInZ=function(t,e){return _.equalsWithTolerance(this.z,t.z,e)},C.prototype.compareTo=function(t){var e=t;return this.x<e.x?-1:this.x>e.x?1:this.y<e.y?-1:this.y>e.y?1:0},C.prototype.clone=function(){},C.prototype.copy=function(){return new C(this)},C.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"},C.prototype.distance3D=function(t){var e=this.x-t.x,n=this.y-t.y,r=this.z-t.z;return Math.sqrt(e*e+n*n+r*r)},C.prototype.distance=function(t){var e=this.x-t.x,n=this.y-t.y;return Math.sqrt(e*e+n*n)},C.prototype.hashCode=function(){var t=17;return 37*(t=37*t+C.hashCode(this.x))+C.hashCode(this.y)},C.prototype.setCoordinate=function(t){this.x=t.x,this.y=t.y,this.z=t.z},C.prototype.interfaces_=function(){return[b,E,e]},C.prototype.getClass=function(){return C},C.hashCode=function(){if(1===arguments.length){var t=arguments[0],e=v.doubleToLongBits(t);return Math.trunc((e^e)>>>32)}},S.DimensionalComparator.get=function(){return w},S.serialVersionUID.get=function(){return 0x5cbf2c235c7e5800},S.NULL_ORDINATE.get=function(){return v.NaN},S.X.get=function(){return 0},S.Y.get=function(){return 1},S.Z.get=function(){return 2},Object.defineProperties(C,S);var w=function(t){if(this._dimensionsToTest=2,0===arguments.length);else if(1===arguments.length){var e=arguments[0];if(2!==e&&3!==e)throw new m("only 2 or 3 dimensions may be specified");this._dimensionsToTest=e}};w.prototype.compare=function(t,e){var n=t,r=e,i=w.compare(n.x,r.x);if(0!==i)return i;var o=w.compare(n.y,r.y);return 0!==o?o:this._dimensionsToTest<=2?0:w.compare(n.z,r.z)},w.prototype.interfaces_=function(){return[I]},w.prototype.getClass=function(){return w},w.compare=function(t,e){return t<e?-1:t>e?1:v.isNaN(t)?v.isNaN(e)?0:-1:v.isNaN(e)?1:0};var N=function(){};N.prototype.create=function(){},N.prototype.interfaces_=function(){return[]},N.prototype.getClass=function(){return N};var M=function(){},L={INTERIOR:{configurable:!0},BOUNDARY:{configurable:!0},EXTERIOR:{configurable:!0},NONE:{configurable:!0}};M.prototype.interfaces_=function(){return[]},M.prototype.getClass=function(){return M},M.toLocationSymbol=function(t){switch(t){case M.EXTERIOR:return"e";case M.BOUNDARY:return"b";case M.INTERIOR:return"i";case M.NONE:return"-"}throw new m("Unknown location value: "+t)},L.INTERIOR.get=function(){return 0},L.BOUNDARY.get=function(){return 1},L.EXTERIOR.get=function(){return 2},L.NONE.get=function(){return-1},Object.defineProperties(M,L);var P=function(t,e){return t.interfaces_&&t.interfaces_().indexOf(e)>-1},O=function(){},R={LOG_10:{configurable:!0}};O.prototype.interfaces_=function(){return[]},O.prototype.getClass=function(){return O},O.log10=function(t){var e=Math.log(t);return v.isInfinite(e)||v.isNaN(e)?e:e/O.LOG_10},O.min=function(t,e,n,r){var i=t;return e<i&&(i=e),n<i&&(i=n),r<i&&(i=r),i},O.clamp=function(){if("number"==typeof arguments[2]&&"number"==typeof arguments[0]&&"number"==typeof arguments[1]){var t=arguments[0],e=arguments[1],n=arguments[2];return t<e?e:t>n?n:t}if(Number.isInteger(arguments[2])&&Number.isInteger(arguments[0])&&Number.isInteger(arguments[1])){var r=arguments[0],i=arguments[1],o=arguments[2];return r<i?i:r>o?o:r}},O.wrap=function(t,e){return t<0?e- -t%e:t%e},O.max=function(){if(3===arguments.length){var t=arguments[1],e=arguments[2],n=arguments[0];return t>n&&(n=t),e>n&&(n=e),n}if(4===arguments.length){var r=arguments[1],i=arguments[2],o=arguments[3],s=arguments[0];return r>s&&(s=r),i>s&&(s=i),o>s&&(s=o),s}},O.average=function(t,e){return(t+e)/2},R.LOG_10.get=function(){return Math.log(10)},Object.defineProperties(O,R);var T=function(t){this.str=t};T.prototype.append=function(t){this.str+=t},T.prototype.setCharAt=function(t,e){this.str=this.str.substr(0,t)+e+this.str.substr(t+1)},T.prototype.toString=function(t){return this.str};var A=function(t){this.value=t};A.prototype.intValue=function(){return this.value},A.prototype.compareTo=function(t){return this.value<t?-1:this.value>t?1:0},A.isNaN=function(t){return Number.isNaN(t)};var D=function(){};D.isWhitespace=function(t){return t<=32&&t>=0||127===t},D.toUpperCase=function(t){return t.toUpperCase()};var F=function t(){if(this._hi=0,this._lo=0,0===arguments.length)this.init(0);else if(1===arguments.length)if("number"==typeof arguments[0]){var e=arguments[0];this.init(e)}else if(arguments[0]instanceof t){var n=arguments[0];this.init(n)}else"string"==typeof arguments[0]&&t.call(this,t.parse(arguments[0]));else if(2===arguments.length){var r=arguments[0],i=arguments[1];this.init(r,i)}},k={PI:{configurable:!0},TWO_PI:{configurable:!0},PI_2:{configurable:!0},E:{configurable:!0},NaN:{configurable:!0},EPS:{configurable:!0},SPLIT:{configurable:!0},MAX_PRINT_DIGITS:{configurable:!0},TEN:{configurable:!0},ONE:{configurable:!0},SCI_NOT_EXPONENT_CHAR:{configurable:!0},SCI_NOT_ZERO:{configurable:!0}};F.prototype.le=function(t){return(this._hi<t._hi||this._hi===t._hi)&&this._lo<=t._lo},F.prototype.extractSignificantDigits=function(t,e){var n=this.abs(),r=F.magnitude(n._hi),i=F.TEN.pow(r);(n=n.divide(i)).gt(F.TEN)?(n=n.divide(F.TEN),r+=1):n.lt(F.ONE)&&(n=n.multiply(F.TEN),r-=1);for(var o=r+1,s=new T,a=F.MAX_PRINT_DIGITS-1,u=0;u<=a;u++){t&&u===o&&s.append(".");var l=Math.trunc(n._hi);if(l<0)break;var c=!1,h=0;l>9?(c=!0,h="9"):h="0"+l,s.append(h),n=n.subtract(F.valueOf(l)).multiply(F.TEN),c&&n.selfAdd(F.TEN);var p=!0,f=F.magnitude(n._hi);if(f<0&&Math.abs(f)>=a-u&&(p=!1),!p)break}return e[0]=r,s.toString()},F.prototype.sqr=function(){return this.multiply(this)},F.prototype.doubleValue=function(){return this._hi+this._lo},F.prototype.subtract=function(){if(arguments[0]instanceof F){var t=arguments[0];return this.add(t.negate())}if("number"==typeof arguments[0]){var e=arguments[0];return this.add(-e)}},F.prototype.equals=function(){if(1===arguments.length){var t=arguments[0];return this._hi===t._hi&&this._lo===t._lo}},F.prototype.isZero=function(){return 0===this._hi&&0===this._lo},F.prototype.selfSubtract=function(){if(arguments[0]instanceof F){var t=arguments[0];return this.isNaN()?this:this.selfAdd(-t._hi,-t._lo)}if("number"==typeof arguments[0]){var e=arguments[0];return this.isNaN()?this:this.selfAdd(-e,0)}},F.prototype.getSpecialNumberString=function(){return this.isZero()?"0.0":this.isNaN()?"NaN ":null},F.prototype.min=function(t){return this.le(t)?this:t},F.prototype.selfDivide=function(){if(1===arguments.length){if(arguments[0]instanceof F){var t=arguments[0];return this.selfDivide(t._hi,t._lo)}if("number"==typeof arguments[0]){var e=arguments[0];return this.selfDivide(e,0)}}else if(2===arguments.length){var n=arguments[0],r=arguments[1],i=null,o=null,s=null,a=null,u=null,l=null,c=null,h=null;return u=this._hi/n,h=(i=(l=F.SPLIT*u)-(i=l-u))*(s=(h=F.SPLIT*n)-(s=h-n))-(c=u*n)+i*(a=n-s)+(o=u-i)*s+o*a,h=u+(l=(this._hi-c-h+this._lo-u*r)/n),this._hi=h,this._lo=u-h+l,this}},F.prototype.dump=function(){return"DD<"+this._hi+", "+this._lo+">"},F.prototype.divide=function(){if(arguments[0]instanceof F){var t=arguments[0],e=null,n=null,r=null,i=null,o=null,s=null,a=null,u=null;return n=(o=this._hi/t._hi)-(e=(s=F.SPLIT*o)-(e=s-o)),u=e*(r=(u=F.SPLIT*t._hi)-(r=u-t._hi))-(a=o*t._hi)+e*(i=t._hi-r)+n*r+n*i,s=(this._hi-a-u+this._lo-o*t._lo)/t._hi,new F(u=o+s,o-u+s)}if("number"==typeof arguments[0]){var l=arguments[0];return v.isNaN(l)?F.createNaN():F.copy(this).selfDivide(l,0)}},F.prototype.ge=function(t){return(this._hi>t._hi||this._hi===t._hi)&&this._lo>=t._lo},F.prototype.pow=function(t){if(0===t)return F.valueOf(1);var e=new F(this),n=F.valueOf(1),r=Math.abs(t);if(r>1)for(;r>0;)r%2==1&&n.selfMultiply(e),(r/=2)>0&&(e=e.sqr());else n=e;return t<0?n.reciprocal():n},F.prototype.ceil=function(){if(this.isNaN())return F.NaN;var t=Math.ceil(this._hi),e=0;return t===this._hi&&(e=Math.ceil(this._lo)),new F(t,e)},F.prototype.compareTo=function(t){var e=t;return this._hi<e._hi?-1:this._hi>e._hi?1:this._lo<e._lo?-1:this._lo>e._lo?1:0},F.prototype.rint=function(){return this.isNaN()?this:this.add(.5).floor()},F.prototype.setValue=function(){if(arguments[0]instanceof F){var t=arguments[0];return this.init(t),this}if("number"==typeof arguments[0]){var e=arguments[0];return this.init(e),this}},F.prototype.max=function(t){return this.ge(t)?this:t},F.prototype.sqrt=function(){if(this.isZero())return F.valueOf(0);if(this.isNegative())return F.NaN;var t=1/Math.sqrt(this._hi),e=this._hi*t,n=F.valueOf(e),r=this.subtract(n.sqr())._hi*(.5*t);return n.add(r)},F.prototype.selfAdd=function(){if(1===arguments.length){if(arguments[0]instanceof F){var t=arguments[0];return this.selfAdd(t._hi,t._lo)}if("number"==typeof arguments[0]){var e=arguments[0],n=null,r=null,i=null,o=null,s=null,a=null;return o=(i=this._hi+e)-(s=i-this._hi),r=(a=(o=e-s+(this._hi-o))+this._lo)+(i-(n=i+a)),this._hi=n+r,this._lo=r+(n-this._hi),this}}else if(2===arguments.length){var u=arguments[0],l=arguments[1],c=null,h=null,p=null,f=null,g=null,d=null,y=null;f=this._hi+u,h=this._lo+l,g=f-(d=f-this._hi),p=h-(y=h-this._lo);var _=(c=f+(d=(g=u-d+(this._hi-g))+h))+(d=(p=l-y+(this._lo-p))+(d+(f-c))),m=d+(c-_);return this._hi=_,this._lo=m,this}},F.prototype.selfMultiply=function(){if(1===arguments.length){if(arguments[0]instanceof F){var t=arguments[0];return this.selfMultiply(t._hi,t._lo)}if("number"==typeof arguments[0]){var e=arguments[0];return this.selfMultiply(e,0)}}else if(2===arguments.length){var n=arguments[0],r=arguments[1],i=null,o=null,s=null,a=null,u=null,l=null;i=(u=F.SPLIT*this._hi)-this._hi,l=F.SPLIT*n,i=u-i,o=this._hi-i,s=l-n;var c=(u=this._hi*n)+(l=i*(s=l-s)-u+i*(a=n-s)+o*s+o*a+(this._hi*r+this._lo*n)),h=l+(i=u-c);return this._hi=c,this._lo=h,this}},F.prototype.selfSqr=function(){return this.selfMultiply(this)},F.prototype.floor=function(){if(this.isNaN())return F.NaN;var t=Math.floor(this._hi),e=0;return t===this._hi&&(e=Math.floor(this._lo)),new F(t,e)},F.prototype.negate=function(){return this.isNaN()?this:new F(-this._hi,-this._lo)},F.prototype.clone=function(){},F.prototype.multiply=function(){if(arguments[0]instanceof F){var t=arguments[0];return t.isNaN()?F.createNaN():F.copy(this).selfMultiply(t)}if("number"==typeof arguments[0]){var e=arguments[0];return v.isNaN(e)?F.createNaN():F.copy(this).selfMultiply(e,0)}},F.prototype.isNaN=function(){return v.isNaN(this._hi)},F.prototype.intValue=function(){return Math.trunc(this._hi)},F.prototype.toString=function(){var t=F.magnitude(this._hi);return t>=-3&&t<=20?this.toStandardNotation():this.toSciNotation()},F.prototype.toStandardNotation=function(){var t=this.getSpecialNumberString();if(null!==t)return t;var e=new Array(1).fill(null),n=this.extractSignificantDigits(!0,e),r=e[0]+1,i=n;if("."===n.charAt(0))i="0"+n;else if(r<0)i="0."+F.stringOfChar("0",-r)+n;else if(-1===n.indexOf(".")){var o=r-n.length;i=n+F.stringOfChar("0",o)+".0"}return this.isNegative()?"-"+i:i},F.prototype.reciprocal=function(){var t,e,n,r,i=null,o=null,s=null,a=null;t=(n=1/this._hi)-(i=(s=F.SPLIT*n)-(i=s-n)),o=(a=F.SPLIT*this._hi)-this._hi;var u=n+(s=(1-(r=n*this._hi)-(a=i*(o=a-o)-r+i*(e=this._hi-o)+t*o+t*e)-n*this._lo)/this._hi);return new F(u,n-u+s)},F.prototype.toSciNotation=function(){if(this.isZero())return F.SCI_NOT_ZERO;var t=this.getSpecialNumberString();if(null!==t)return t;var e=new Array(1).fill(null),n=this.extractSignificantDigits(!1,e),r=F.SCI_NOT_EXPONENT_CHAR+e[0];if("0"===n.charAt(0))throw new Error("Found leading zero: "+n);var i="";n.length>1&&(i=n.substring(1));var o=n.charAt(0)+"."+i;return this.isNegative()?"-"+o+r:o+r},F.prototype.abs=function(){return this.isNaN()?F.NaN:this.isNegative()?this.negate():new F(this)},F.prototype.isPositive=function(){return(this._hi>0||0===this._hi)&&this._lo>0},F.prototype.lt=function(t){return(this._hi<t._hi||this._hi===t._hi)&&this._lo<t._lo},F.prototype.add=function(){if(arguments[0]instanceof F){var t=arguments[0];return F.copy(this).selfAdd(t)}if("number"==typeof arguments[0]){var e=arguments[0];return F.copy(this).selfAdd(e)}},F.prototype.init=function(){if(1===arguments.length){if("number"==typeof arguments[0]){var t=arguments[0];this._hi=t,this._lo=0}else if(arguments[0]instanceof F){var e=arguments[0];this._hi=e._hi,this._lo=e._lo}}else if(2===arguments.length){var n=arguments[0],r=arguments[1];this._hi=n,this._lo=r}},F.prototype.gt=function(t){return(this._hi>t._hi||this._hi===t._hi)&&this._lo>t._lo},F.prototype.isNegative=function(){return(this._hi<0||0===this._hi)&&this._lo<0},F.prototype.trunc=function(){return this.isNaN()?F.NaN:this.isPositive()?this.floor():this.ceil()},F.prototype.signum=function(){return this._hi>0?1:this._hi<0?-1:this._lo>0?1:this._lo<0?-1:0},F.prototype.interfaces_=function(){return[e,b,E]},F.prototype.getClass=function(){return F},F.sqr=function(t){return F.valueOf(t).selfMultiply(t)},F.valueOf=function(){if("string"==typeof arguments[0]){var t=arguments[0];return F.parse(t)}if("number"==typeof arguments[0])return new F(arguments[0])},F.sqrt=function(t){return F.valueOf(t).sqrt()},F.parse=function(t){for(var e=0,n=t.length;D.isWhitespace(t.charAt(e));)e++;var r=!1;if(e<n){var i=t.charAt(e);"-"!==i&&"+"!==i||(e++,"-"===i&&(r=!0))}for(var o=new F,s=0,a=0,u=0;!(e>=n);){var l=t.charAt(e);if(e++,D.isDigit(l)){var c=l-"0";o.selfMultiply(F.TEN),o.selfAdd(c),s++}else{if("."!==l){if("e"===l||"E"===l){var h=t.substring(e);try{u=A.parseInt(h)}catch(e){throw e instanceof Error?new Error("Invalid exponent "+h+" in string "+t):e}break}throw new Error("Unexpected character '"+l+"' at position "+e+" in string "+t)}a=s}}var p=o,f=s-a-u;if(0===f)p=o;else if(f>0){var g=F.TEN.pow(f);p=o.divide(g)}else if(f<0){var d=F.TEN.pow(-f);p=o.multiply(d)}return r?p.negate():p},F.createNaN=function(){return new F(v.NaN,v.NaN)},F.copy=function(t){return new F(t)},F.magnitude=function(t){var e=Math.abs(t),n=Math.log(e)/Math.log(10),r=Math.trunc(Math.floor(n));return 10*Math.pow(10,r)<=e&&(r+=1),r},F.stringOfChar=function(t,e){for(var n=new T,r=0;r<e;r++)n.append(t);return n.toString()},k.PI.get=function(){return new F(3.141592653589793,12246467991473532e-32)},k.TWO_PI.get=function(){return new F(6.283185307179586,24492935982947064e-32)},k.PI_2.get=function(){return new F(1.5707963267948966,6123233995736766e-32)},k.E.get=function(){return new F(2.718281828459045,14456468917292502e-32)},k.NaN.get=function(){return new F(v.NaN,v.NaN)},k.EPS.get=function(){return 123259516440783e-46},k.SPLIT.get=function(){return 134217729},k.MAX_PRINT_DIGITS.get=function(){return 32},k.TEN.get=function(){return F.valueOf(10)},k.ONE.get=function(){return F.valueOf(1)},k.SCI_NOT_EXPONENT_CHAR.get=function(){return"E"},k.SCI_NOT_ZERO.get=function(){return"0.0E0"},Object.defineProperties(F,k);var G=function(){},B={DP_SAFE_EPSILON:{configurable:!0}};G.prototype.interfaces_=function(){return[]},G.prototype.getClass=function(){return G},G.orientationIndex=function(t,e,n){var r=G.orientationIndexFilter(t,e,n);if(r<=1)return r;var i=F.valueOf(e.x).selfAdd(-t.x),o=F.valueOf(e.y).selfAdd(-t.y),s=F.valueOf(n.x).selfAdd(-e.x),a=F.valueOf(n.y).selfAdd(-e.y);return i.selfMultiply(a).selfSubtract(o.selfMultiply(s)).signum()},G.signOfDet2x2=function(t,e,n,r){return t.multiply(r).selfSubtract(e.multiply(n)).signum()},G.intersection=function(t,e,n,r){var i=F.valueOf(r.y).selfSubtract(n.y).selfMultiply(F.valueOf(e.x).selfSubtract(t.x)),o=F.valueOf(r.x).selfSubtract(n.x).selfMultiply(F.valueOf(e.y).selfSubtract(t.y)),s=i.subtract(o),a=F.valueOf(r.x).selfSubtract(n.x).selfMultiply(F.valueOf(t.y).selfSubtract(n.y)),u=F.valueOf(r.y).selfSubtract(n.y).selfMultiply(F.valueOf(t.x).selfSubtract(n.x)),l=a.subtract(u).selfDivide(s).doubleValue(),c=F.valueOf(t.x).selfAdd(F.valueOf(e.x).selfSubtract(t.x).selfMultiply(l)).doubleValue(),h=F.valueOf(e.x).selfSubtract(t.x).selfMultiply(F.valueOf(t.y).selfSubtract(n.y)),p=F.valueOf(e.y).selfSubtract(t.y).selfMultiply(F.valueOf(t.x).selfSubtract(n.x)),f=h.subtract(p).selfDivide(s).doubleValue(),g=F.valueOf(n.y).selfAdd(F.valueOf(r.y).selfSubtract(n.y).selfMultiply(f)).doubleValue();return new C(c,g)},G.orientationIndexFilter=function(t,e,n){var r=null,i=(t.x-n.x)*(e.y-n.y),o=(t.y-n.y)*(e.x-n.x),s=i-o;if(i>0){if(o<=0)return G.signum(s);r=i+o}else{if(!(i<0))return G.signum(s);if(o>=0)return G.signum(s);r=-i-o}var a=G.DP_SAFE_EPSILON*r;return s>=a||-s>=a?G.signum(s):2},G.signum=function(t){return t>0?1:t<0?-1:0},B.DP_SAFE_EPSILON.get=function(){return 1e-15},Object.defineProperties(G,B);var j=function(){},U={X:{configurable:!0},Y:{configurable:!0},Z:{configurable:!0},M:{configurable:!0}};U.X.get=function(){return 0},U.Y.get=function(){return 1},U.Z.get=function(){return 2},U.M.get=function(){return 3},j.prototype.setOrdinate=function(t,e,n){},j.prototype.size=function(){},j.prototype.getOrdinate=function(t,e){},j.prototype.getCoordinate=function(){},j.prototype.getCoordinateCopy=function(t){},j.prototype.getDimension=function(){},j.prototype.getX=function(t){},j.prototype.clone=function(){},j.prototype.expandEnvelope=function(t){},j.prototype.copy=function(){},j.prototype.getY=function(t){},j.prototype.toCoordinateArray=function(){},j.prototype.interfaces_=function(){return[E]},j.prototype.getClass=function(){return j},Object.defineProperties(j,U);var q=function(){},z=function(t){function e(){t.call(this,"Projective point not representable on the Cartesian plane.")}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(q),V=function(){};V.arraycopy=function(t,e,n,r,i){for(var o=0,s=e;s<e+i;s++)n[r+o]=t[s],o++},V.getProperty=function(t){return{"line.separator":"\n"}[t]};var Y=function t(){if(this.x=null,this.y=null,this.w=null,0===arguments.length)this.x=0,this.y=0,this.w=1;else if(1===arguments.length){var e=arguments[0];this.x=e.x,this.y=e.y,this.w=1}else if(2===arguments.length){if("number"==typeof arguments[0]&&"number"==typeof arguments[1]){var n=arguments[0],r=arguments[1];this.x=n,this.y=r,this.w=1}else if(arguments[0]instanceof t&&arguments[1]instanceof t){var i=arguments[0],o=arguments[1];this.x=i.y*o.w-o.y*i.w,this.y=o.x*i.w-i.x*o.w,this.w=i.x*o.y-o.x*i.y}else if(arguments[0]instanceof C&&arguments[1]instanceof C){var s=arguments[0],a=arguments[1];this.x=s.y-a.y,this.y=a.x-s.x,this.w=s.x*a.y-a.x*s.y}}else if(3===arguments.length){var u=arguments[0],l=arguments[1],c=arguments[2];this.x=u,this.y=l,this.w=c}else if(4===arguments.length){var h=arguments[0],p=arguments[1],f=arguments[2],g=arguments[3],d=h.y-p.y,y=p.x-h.x,_=h.x*p.y-p.x*h.y,m=f.y-g.y,v=g.x-f.x,x=f.x*g.y-g.x*f.y;this.x=y*x-v*_,this.y=m*_-d*x,this.w=d*v-m*y}};Y.prototype.getY=function(){var t=this.y/this.w;if(v.isNaN(t)||v.isInfinite(t))throw new z;return t},Y.prototype.getX=function(){var t=this.x/this.w;if(v.isNaN(t)||v.isInfinite(t))throw new z;return t},Y.prototype.getCoordinate=function(){var t=new C;return t.x=this.getX(),t.y=this.getY(),t},Y.prototype.interfaces_=function(){return[]},Y.prototype.getClass=function(){return Y},Y.intersection=function(t,e,n,r){var i=t.y-e.y,o=e.x-t.x,s=t.x*e.y-e.x*t.y,a=n.y-r.y,u=r.x-n.x,l=n.x*r.y-r.x*n.y,c=i*u-a*o,h=(o*l-u*s)/c,p=(a*s-i*l)/c;if(v.isNaN(h)||v.isInfinite(h)||v.isNaN(p)||v.isInfinite(p))throw new z;return new C(h,p)};var X=function t(){if(this._minx=null,this._maxx=null,this._miny=null,this._maxy=null,0===arguments.length)this.init();else if(1===arguments.length){if(arguments[0]instanceof C){var e=arguments[0];this.init(e.x,e.x,e.y,e.y)}else if(arguments[0]instanceof t){var n=arguments[0];this.init(n)}}else if(2===arguments.length){var r=arguments[0],i=arguments[1];this.init(r.x,i.x,r.y,i.y)}else if(4===arguments.length){var o=arguments[0],s=arguments[1],a=arguments[2],u=arguments[3];this.init(o,s,a,u)}},W={serialVersionUID:{configurable:!0}};X.prototype.getArea=function(){return this.getWidth()*this.getHeight()},X.prototype.equals=function(t){if(!(t instanceof X))return!1;var e=t;return this.isNull()?e.isNull():this._maxx===e.getMaxX()&&this._maxy===e.getMaxY()&&this._minx===e.getMinX()&&this._miny===e.getMinY()},X.prototype.intersection=function(t){if(this.isNull()||t.isNull()||!this.intersects(t))return new X;var e=this._minx>t._minx?this._minx:t._minx,n=this._miny>t._miny?this._miny:t._miny,r=this._maxx<t._maxx?this._maxx:t._maxx,i=this._maxy<t._maxy?this._maxy:t._maxy;return new X(e,r,n,i)},X.prototype.isNull=function(){return this._maxx<this._minx},X.prototype.getMaxX=function(){return this._maxx},X.prototype.covers=function(){if(1===arguments.length){if(arguments[0]instanceof C){var t=arguments[0];return this.covers(t.x,t.y)}if(arguments[0]instanceof X){var e=arguments[0];return!this.isNull()&&!e.isNull()&&e.getMinX()>=this._minx&&e.getMaxX()<=this._maxx&&e.getMinY()>=this._miny&&e.getMaxY()<=this._maxy}}else if(2===arguments.length){var n=arguments[0],r=arguments[1];return!this.isNull()&&n>=this._minx&&n<=this._maxx&&r>=this._miny&&r<=this._maxy}},X.prototype.intersects=function(){if(1===arguments.length){if(arguments[0]instanceof X){var t=arguments[0];return!this.isNull()&&!t.isNull()&&!(t._minx>this._maxx||t._maxx<this._minx||t._miny>this._maxy||t._maxy<this._miny)}if(arguments[0]instanceof C){var e=arguments[0];return this.intersects(e.x,e.y)}}else if(2===arguments.length){var n=arguments[0],r=arguments[1];return!this.isNull()&&!(n>this._maxx||n<this._minx||r>this._maxy||r<this._miny)}},X.prototype.getMinY=function(){return this._miny},X.prototype.getMinX=function(){return this._minx},X.prototype.expandToInclude=function(){if(1===arguments.length){if(arguments[0]instanceof C){var t=arguments[0];this.expandToInclude(t.x,t.y)}else if(arguments[0]instanceof X){var e=arguments[0];if(e.isNull())return null;this.isNull()?(this._minx=e.getMinX(),this._maxx=e.getMaxX(),this._miny=e.getMinY(),this._maxy=e.getMaxY()):(e._minx<this._minx&&(this._minx=e._minx),e._maxx>this._maxx&&(this._maxx=e._maxx),e._miny<this._miny&&(this._miny=e._miny),e._maxy>this._maxy&&(this._maxy=e._maxy))}}else if(2===arguments.length){var n=arguments[0],r=arguments[1];this.isNull()?(this._minx=n,this._maxx=n,this._miny=r,this._maxy=r):(n<this._minx&&(this._minx=n),n>this._maxx&&(this._maxx=n),r<this._miny&&(this._miny=r),r>this._maxy&&(this._maxy=r))}},X.prototype.minExtent=function(){if(this.isNull())return 0;var t=this.getWidth(),e=this.getHeight();return t<e?t:e},X.prototype.getWidth=function(){return this.isNull()?0:this._maxx-this._minx},X.prototype.compareTo=function(t){var e=t;return this.isNull()?e.isNull()?0:-1:e.isNull()?1:this._minx<e._minx?-1:this._minx>e._minx?1:this._miny<e._miny?-1:this._miny>e._miny?1:this._maxx<e._maxx?-1:this._maxx>e._maxx?1:this._maxy<e._maxy?-1:this._maxy>e._maxy?1:0},X.prototype.translate=function(t,e){if(this.isNull())return null;this.init(this.getMinX()+t,this.getMaxX()+t,this.getMinY()+e,this.getMaxY()+e)},X.prototype.toString=function(){return"Env["+this._minx+" : "+this._maxx+", "+this._miny+" : "+this._maxy+"]"},X.prototype.setToNull=function(){this._minx=0,this._maxx=-1,this._miny=0,this._maxy=-1},X.prototype.getHeight=function(){return this.isNull()?0:this._maxy-this._miny},X.prototype.maxExtent=function(){if(this.isNull())return 0;var t=this.getWidth(),e=this.getHeight();return t>e?t:e},X.prototype.expandBy=function(){if(1===arguments.length){var t=arguments[0];this.expandBy(t,t)}else if(2===arguments.length){var e=arguments[0],n=arguments[1];if(this.isNull())return null;this._minx-=e,this._maxx+=e,this._miny-=n,this._maxy+=n,(this._minx>this._maxx||this._miny>this._maxy)&&this.setToNull()}},X.prototype.contains=function(){if(1===arguments.length){if(arguments[0]instanceof X){var t=arguments[0];return this.covers(t)}if(arguments[0]instanceof C){var e=arguments[0];return this.covers(e)}}else if(2===arguments.length){var n=arguments[0],r=arguments[1];return this.covers(n,r)}},X.prototype.centre=function(){return this.isNull()?null:new C((this.getMinX()+this.getMaxX())/2,(this.getMinY()+this.getMaxY())/2)},X.prototype.init=function(){if(0===arguments.length)this.setToNull();else if(1===arguments.length){if(arguments[0]instanceof C){var t=arguments[0];this.init(t.x,t.x,t.y,t.y)}else if(arguments[0]instanceof X){var e=arguments[0];this._minx=e._minx,this._maxx=e._maxx,this._miny=e._miny,this._maxy=e._maxy}}else if(2===arguments.length){var n=arguments[0],r=arguments[1];this.init(n.x,r.x,n.y,r.y)}else if(4===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2],a=arguments[3];i<o?(this._minx=i,this._maxx=o):(this._minx=o,this._maxx=i),s<a?(this._miny=s,this._maxy=a):(this._miny=a,this._maxy=s)}},X.prototype.getMaxY=function(){return this._maxy},X.prototype.distance=function(t){if(this.intersects(t))return 0;var e=0;this._maxx<t._minx?e=t._minx-this._maxx:this._minx>t._maxx&&(e=this._minx-t._maxx);var n=0;return this._maxy<t._miny?n=t._miny-this._maxy:this._miny>t._maxy&&(n=this._miny-t._maxy),0===e?n:0===n?e:Math.sqrt(e*e+n*n)},X.prototype.hashCode=function(){var t=17;return 37*(t=37*(t=37*(t=37*t+C.hashCode(this._minx))+C.hashCode(this._maxx))+C.hashCode(this._miny))+C.hashCode(this._maxy)},X.prototype.interfaces_=function(){return[b,e]},X.prototype.getClass=function(){return X},X.intersects=function(){if(3===arguments.length){var t=arguments[0],e=arguments[1],n=arguments[2];return n.x>=(t.x<e.x?t.x:e.x)&&n.x<=(t.x>e.x?t.x:e.x)&&n.y>=(t.y<e.y?t.y:e.y)&&n.y<=(t.y>e.y?t.y:e.y)}if(4===arguments.length){var r=arguments[0],i=arguments[1],o=arguments[2],s=arguments[3],a=Math.min(o.x,s.x),u=Math.max(o.x,s.x),l=Math.min(r.x,i.x),c=Math.max(r.x,i.x);return!(l>u||c<a||(a=Math.min(o.y,s.y),u=Math.max(o.y,s.y),l=Math.min(r.y,i.y),c=Math.max(r.y,i.y),l>u||c<a))}},W.serialVersionUID.get=function(){return 0x51845cd552189800},Object.defineProperties(X,W);var H={typeStr:/^\s*(\w+)\s*\(\s*(.*)\s*\)\s*$/,emptyTypeStr:/^\s*(\w+)\s*EMPTY\s*$/,spaces:/\s+/,parenComma:/\)\s*,\s*\(/,doubleParenComma:/\)\s*\)\s*,\s*\(\s*\(/,trimParens:/^\s*\(?(.*?)\)?\s*$/},K=function(t){this.geometryFactory=t||new _e};K.prototype.read=function(t){var e,n,r;t=t.replace(/[\n\r]/g," ");var i=H.typeStr.exec(t);if(-1!==t.search("EMPTY")&&((i=H.emptyTypeStr.exec(t))[2]=void 0),i&&(n=i[1].toLowerCase(),r=i[2],Z[n]&&(e=Z[n].apply(this,[r]))),void 0===e)throw new Error("Could not parse WKT "+t);return e},K.prototype.write=function(t){return this.extractGeometry(t)},K.prototype.extractGeometry=function(t){var e=t.getGeometryType().toLowerCase();if(!J[e])return null;var n=e.toUpperCase();return t.isEmpty()?n+" EMPTY":n+"("+J[e].apply(this,[t])+")"};var J={coordinate:function(t){return t.x+" "+t.y},point:function(t){return J.coordinate.call(this,t._coordinates._coordinates[0])},multipoint:function(t){for(var e=[],n=0,r=t._geometries.length;n<r;++n)e.push("("+J.point.apply(this,[t._geometries[n]])+")");return e.join(",")},linestring:function(t){for(var e=[],n=0,r=t._points._coordinates.length;n<r;++n)e.push(J.coordinate.apply(this,[t._points._coordinates[n]]));return e.join(",")},linearring:function(t){for(var e=[],n=0,r=t._points._coordinates.length;n<r;++n)e.push(J.coordinate.apply(this,[t._points._coordinates[n]]));return e.join(",")},multilinestring:function(t){for(var e=[],n=0,r=t._geometries.length;n<r;++n)e.push("("+J.linestring.apply(this,[t._geometries[n]])+")");return e.join(",")},polygon:function(t){var e=[];e.push("("+J.linestring.apply(this,[t._shell])+")");for(var n=0,r=t._holes.length;n<r;++n)e.push("("+J.linestring.apply(this,[t._holes[n]])+")");return e.join(",")},multipolygon:function(t){for(var e=[],n=0,r=t._geometries.length;n<r;++n)e.push("("+J.polygon.apply(this,[t._geometries[n]])+")");return e.join(",")},geometrycollection:function(t){for(var e=[],n=0,r=t._geometries.length;n<r;++n)e.push(this.extractGeometry(t._geometries[n]));return e.join(",")}},Z={point:function(t){if(void 0===t)return this.geometryFactory.createPoint();var e=t.trim().split(H.spaces);return this.geometryFactory.createPoint(new C(Number.parseFloat(e[0]),Number.parseFloat(e[1])))},multipoint:function(t){if(void 0===t)return this.geometryFactory.createMultiPoint();for(var e,n=t.trim().split(","),r=[],i=0,o=n.length;i<o;++i)e=n[i].replace(H.trimParens,"$1"),r.push(Z.point.apply(this,[e]));return this.geometryFactory.createMultiPoint(r)},linestring:function(t){if(void 0===t)return this.geometryFactory.createLineString();for(var e,n=t.trim().split(","),r=[],i=0,o=n.length;i<o;++i)e=n[i].trim().split(H.spaces),r.push(new C(Number.parseFloat(e[0]),Number.parseFloat(e[1])));return this.geometryFactory.createLineString(r)},linearring:function(t){if(void 0===t)return this.geometryFactory.createLinearRing();for(var e,n=t.trim().split(","),r=[],i=0,o=n.length;i<o;++i)e=n[i].trim().split(H.spaces),r.push(new C(Number.parseFloat(e[0]),Number.parseFloat(e[1])));return this.geometryFactory.createLinearRing(r)},multilinestring:function(t){if(void 0===t)return this.geometryFactory.createMultiLineString();for(var e,n=t.trim().split(H.parenComma),r=[],i=0,o=n.length;i<o;++i)e=n[i].replace(H.trimParens,"$1"),r.push(Z.linestring.apply(this,[e]));return this.geometryFactory.createMultiLineString(r)},polygon:function(t){if(void 0===t)return this.geometryFactory.createPolygon();for(var e,n,r,i,o=t.trim().split(H.parenComma),s=[],a=0,u=o.length;a<u;++a)e=o[a].replace(H.trimParens,"$1"),n=Z.linestring.apply(this,[e]),r=this.geometryFactory.createLinearRing(n._points),0===a?i=r:s.push(r);return this.geometryFactory.createPolygon(i,s)},multipolygon:function(t){if(void 0===t)return this.geometryFactory.createMultiPolygon();for(var e,n=t.trim().split(H.doubleParenComma),r=[],i=0,o=n.length;i<o;++i)e=n[i].replace(H.trimParens,"$1"),r.push(Z.polygon.apply(this,[e]));return this.geometryFactory.createMultiPolygon(r)},geometrycollection:function(t){if(void 0===t)return this.geometryFactory.createGeometryCollection();for(var e=(t=t.replace(/,\s*([A-Za-z])/g,"|$1")).trim().split("|"),n=[],r=0,i=e.length;r<i;++r)n.push(this.read(e[r]));return this.geometryFactory.createGeometryCollection(n)}},$=function(t){this.parser=new K(t)};$.prototype.write=function(t){return this.parser.write(t)},$.toLineString=function(t,e){if(2!==arguments.length)throw new Error("Not implemented");return"LINESTRING ( "+t.x+" "+t.y+", "+e.x+" "+e.y+" )"};var Q=function(t){function e(e){t.call(this,e),this.name="RuntimeException",this.message=e,this.stack=(new t).stack}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Error),tt=function(t){function e(){if(t.call(this),0===arguments.length)t.call(this);else if(1===arguments.length){var e=arguments[0];t.call(this,e)}}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Q),et=function(){};et.prototype.interfaces_=function(){return[]},et.prototype.getClass=function(){return et},et.shouldNeverReachHere=function(){if(0===arguments.length)et.shouldNeverReachHere(null);else if(1===arguments.length){var t=arguments[0];throw new tt("Should never reach here"+(null!==t?": "+t:""))}},et.isTrue=function(){var t;if(1===arguments.length)et.isTrue(arguments[0],null);else if(2===arguments.length&&(t=arguments[1],!arguments[0]))throw null===t?new tt:new tt(t)},et.equals=function(){var t,e,n;if(2===arguments.length)et.equals(t=arguments[0],e=arguments[1],null);else if(3===arguments.length&&(t=arguments[0],n=arguments[2],!(e=arguments[1]).equals(t)))throw new tt("Expected "+t+" but encountered "+e+(null!==n?": "+n:""))};var nt=function(){this._result=null,this._inputLines=Array(2).fill().map((function(){return Array(2)})),this._intPt=new Array(2).fill(null),this._intLineIndex=null,this._isProper=null,this._pa=null,this._pb=null,this._precisionModel=null,this._intPt[0]=new C,this._intPt[1]=new C,this._pa=this._intPt[0],this._pb=this._intPt[1],this._result=0},rt={DONT_INTERSECT:{configurable:!0},DO_INTERSECT:{configurable:!0},COLLINEAR:{configurable:!0},NO_INTERSECTION:{configurable:!0},POINT_INTERSECTION:{configurable:!0},COLLINEAR_INTERSECTION:{configurable:!0}};nt.prototype.getIndexAlongSegment=function(t,e){return this.computeIntLineIndex(),this._intLineIndex[t][e]},nt.prototype.getTopologySummary=function(){var t=new T;return this.isEndPoint()&&t.append(" endpoint"),this._isProper&&t.append(" proper"),this.isCollinear()&&t.append(" collinear"),t.toString()},nt.prototype.computeIntersection=function(t,e,n,r){this._inputLines[0][0]=t,this._inputLines[0][1]=e,this._inputLines[1][0]=n,this._inputLines[1][1]=r,this._result=this.computeIntersect(t,e,n,r)},nt.prototype.getIntersectionNum=function(){return this._result},nt.prototype.computeIntLineIndex=function(){if(0===arguments.length)null===this._intLineIndex&&(this._intLineIndex=Array(2).fill().map((function(){return Array(2)})),this.computeIntLineIndex(0),this.computeIntLineIndex(1));else if(1===arguments.length){var t=arguments[0];this.getEdgeDistance(t,0)>this.getEdgeDistance(t,1)?(this._intLineIndex[t][0]=0,this._intLineIndex[t][1]=1):(this._intLineIndex[t][0]=1,this._intLineIndex[t][1]=0)}},nt.prototype.isProper=function(){return this.hasIntersection()&&this._isProper},nt.prototype.setPrecisionModel=function(t){this._precisionModel=t},nt.prototype.isInteriorIntersection=function(){if(0===arguments.length)return!!this.isInteriorIntersection(0)||!!this.isInteriorIntersection(1);if(1===arguments.length){for(var t=arguments[0],e=0;e<this._result;e++)if(!this._intPt[e].equals2D(this._inputLines[t][0])&&!this._intPt[e].equals2D(this._inputLines[t][1]))return!0;return!1}},nt.prototype.getIntersection=function(t){return this._intPt[t]},nt.prototype.isEndPoint=function(){return this.hasIntersection()&&!this._isProper},nt.prototype.hasIntersection=function(){return this._result!==nt.NO_INTERSECTION},nt.prototype.getEdgeDistance=function(t,e){return nt.computeEdgeDistance(this._intPt[e],this._inputLines[t][0],this._inputLines[t][1])},nt.prototype.isCollinear=function(){return this._result===nt.COLLINEAR_INTERSECTION},nt.prototype.toString=function(){return $.toLineString(this._inputLines[0][0],this._inputLines[0][1])+" - "+$.toLineString(this._inputLines[1][0],this._inputLines[1][1])+this.getTopologySummary()},nt.prototype.getEndpoint=function(t,e){return this._inputLines[t][e]},nt.prototype.isIntersection=function(t){for(var e=0;e<this._result;e++)if(this._intPt[e].equals2D(t))return!0;return!1},nt.prototype.getIntersectionAlongSegment=function(t,e){return this.computeIntLineIndex(),this._intPt[this._intLineIndex[t][e]]},nt.prototype.interfaces_=function(){return[]},nt.prototype.getClass=function(){return nt},nt.computeEdgeDistance=function(t,e,n){var r=Math.abs(n.x-e.x),i=Math.abs(n.y-e.y),o=-1;if(t.equals(e))o=0;else if(t.equals(n))o=r>i?r:i;else{var s=Math.abs(t.x-e.x),a=Math.abs(t.y-e.y);0!==(o=r>i?s:a)||t.equals(e)||(o=Math.max(s,a))}return et.isTrue(!(0===o&&!t.equals(e)),"Bad distance calculation"),o},nt.nonRobustComputeEdgeDistance=function(t,e,n){var r=t.x-e.x,i=t.y-e.y,o=Math.sqrt(r*r+i*i);return et.isTrue(!(0===o&&!t.equals(e)),"Invalid distance calculation"),o},rt.DONT_INTERSECT.get=function(){return 0},rt.DO_INTERSECT.get=function(){return 1},rt.COLLINEAR.get=function(){return 2},rt.NO_INTERSECTION.get=function(){return 0},rt.POINT_INTERSECTION.get=function(){return 1},rt.COLLINEAR_INTERSECTION.get=function(){return 2},Object.defineProperties(nt,rt);var it=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.isInSegmentEnvelopes=function(t){var e=new X(this._inputLines[0][0],this._inputLines[0][1]),n=new X(this._inputLines[1][0],this._inputLines[1][1]);return e.contains(t)&&n.contains(t)},e.prototype.computeIntersection=function(){if(3!==arguments.length)return t.prototype.computeIntersection.apply(this,arguments);var e=arguments[0],n=arguments[1],r=arguments[2];if(this._isProper=!1,X.intersects(n,r,e)&&0===at.orientationIndex(n,r,e)&&0===at.orientationIndex(r,n,e))return this._isProper=!0,(e.equals(n)||e.equals(r))&&(this._isProper=!1),this._result=t.POINT_INTERSECTION,null;this._result=t.NO_INTERSECTION},e.prototype.normalizeToMinimum=function(t,e,n,r,i){i.x=this.smallestInAbsValue(t.x,e.x,n.x,r.x),i.y=this.smallestInAbsValue(t.y,e.y,n.y,r.y),t.x-=i.x,t.y-=i.y,e.x-=i.x,e.y-=i.y,n.x-=i.x,n.y-=i.y,r.x-=i.x,r.y-=i.y},e.prototype.safeHCoordinateIntersection=function(t,n,r,i){var o=null;try{o=Y.intersection(t,n,r,i)}catch(s){if(!(s instanceof z))throw s;o=e.nearestEndpoint(t,n,r,i)}return o},e.prototype.intersection=function(t,n,r,i){var o=this.intersectionWithNormalization(t,n,r,i);return this.isInSegmentEnvelopes(o)||(o=new C(e.nearestEndpoint(t,n,r,i))),null!==this._precisionModel&&this._precisionModel.makePrecise(o),o},e.prototype.smallestInAbsValue=function(t,e,n,r){var i=t,o=Math.abs(i);return Math.abs(e)<o&&(i=e,o=Math.abs(e)),Math.abs(n)<o&&(i=n,o=Math.abs(n)),Math.abs(r)<o&&(i=r),i},e.prototype.checkDD=function(t,e,n,r,i){var o=G.intersection(t,e,n,r),s=this.isInSegmentEnvelopes(o);V.out.println("DD in env = "+s+"  --------------------- "+o),i.distance(o)>1e-4&&V.out.println("Distance = "+i.distance(o))},e.prototype.intersectionWithNormalization=function(t,e,n,r){var i=new C(t),o=new C(e),s=new C(n),a=new C(r),u=new C;this.normalizeToEnvCentre(i,o,s,a,u);var l=this.safeHCoordinateIntersection(i,o,s,a);return l.x+=u.x,l.y+=u.y,l},e.prototype.computeCollinearIntersection=function(e,n,r,i){var o=X.intersects(e,n,r),s=X.intersects(e,n,i),a=X.intersects(r,i,e),u=X.intersects(r,i,n);return o&&s?(this._intPt[0]=r,this._intPt[1]=i,t.COLLINEAR_INTERSECTION):a&&u?(this._intPt[0]=e,this._intPt[1]=n,t.COLLINEAR_INTERSECTION):o&&a?(this._intPt[0]=r,this._intPt[1]=e,!r.equals(e)||s||u?t.COLLINEAR_INTERSECTION:t.POINT_INTERSECTION):o&&u?(this._intPt[0]=r,this._intPt[1]=n,!r.equals(n)||s||a?t.COLLINEAR_INTERSECTION:t.POINT_INTERSECTION):s&&a?(this._intPt[0]=i,this._intPt[1]=e,!i.equals(e)||o||u?t.COLLINEAR_INTERSECTION:t.POINT_INTERSECTION):s&&u?(this._intPt[0]=i,this._intPt[1]=n,!i.equals(n)||o||a?t.COLLINEAR_INTERSECTION:t.POINT_INTERSECTION):t.NO_INTERSECTION},e.prototype.normalizeToEnvCentre=function(t,e,n,r,i){var o=t.x<e.x?t.x:e.x,s=t.y<e.y?t.y:e.y,a=t.x>e.x?t.x:e.x,u=t.y>e.y?t.y:e.y,l=n.x<r.x?n.x:r.x,c=n.y<r.y?n.y:r.y,h=n.x>r.x?n.x:r.x,p=n.y>r.y?n.y:r.y,f=((o>l?o:l)+(a<h?a:h))/2,g=((s>c?s:c)+(u<p?u:p))/2;i.x=f,i.y=g,t.x-=i.x,t.y-=i.y,e.x-=i.x,e.y-=i.y,n.x-=i.x,n.y-=i.y,r.x-=i.x,r.y-=i.y},e.prototype.computeIntersect=function(e,n,r,i){if(this._isProper=!1,!X.intersects(e,n,r,i))return t.NO_INTERSECTION;var o=at.orientationIndex(e,n,r),s=at.orientationIndex(e,n,i);if(o>0&&s>0||o<0&&s<0)return t.NO_INTERSECTION;var a=at.orientationIndex(r,i,e),u=at.orientationIndex(r,i,n);return a>0&&u>0||a<0&&u<0?t.NO_INTERSECTION:0===o&&0===s&&0===a&&0===u?this.computeCollinearIntersection(e,n,r,i):(0===o||0===s||0===a||0===u?(this._isProper=!1,e.equals2D(r)||e.equals2D(i)?this._intPt[0]=e:n.equals2D(r)||n.equals2D(i)?this._intPt[0]=n:0===o?this._intPt[0]=new C(r):0===s?this._intPt[0]=new C(i):0===a?this._intPt[0]=new C(e):0===u&&(this._intPt[0]=new C(n))):(this._isProper=!0,this._intPt[0]=this.intersection(e,n,r,i)),t.POINT_INTERSECTION)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e.nearestEndpoint=function(t,e,n,r){var i=t,o=at.distancePointLine(t,n,r),s=at.distancePointLine(e,n,r);return s<o&&(o=s,i=e),(s=at.distancePointLine(n,t,e))<o&&(o=s,i=n),(s=at.distancePointLine(r,t,e))<o&&(o=s,i=r),i},e}(nt),ot=function(){};ot.prototype.interfaces_=function(){return[]},ot.prototype.getClass=function(){return ot},ot.orientationIndex=function(t,e,n){var r=e.x-t.x,i=e.y-t.y,o=n.x-e.x,s=n.y-e.y;return ot.signOfDet2x2(r,i,o,s)},ot.signOfDet2x2=function(t,e,n,r){var i=null,o=null,s=null;if(i=1,0===t||0===r)return 0===e||0===n?0:e>0?n>0?-i:i:n>0?i:-i;if(0===e||0===n)return r>0?t>0?i:-i:t>0?-i:i;if(e>0?r>0?e<=r||(i=-i,o=t,t=n,n=o,o=e,e=r,r=o):e<=-r?(i=-i,n=-n,r=-r):(o=t,t=-n,n=o,o=e,e=-r,r=o):r>0?-e<=r?(i=-i,t=-t,e=-e):(o=-t,t=n,n=o,o=-e,e=r,r=o):e>=r?(t=-t,e=-e,n=-n,r=-r):(i=-i,o=-t,t=-n,n=o,o=-e,e=-r,r=o),t>0){if(!(n>0))return i;if(!(t<=n))return i}else{if(n>0)return-i;if(!(t>=n))return-i;i=-i,t=-t,n=-n}for(;;){if((r-=(s=Math.floor(n/t))*e)<0)return-i;if(r>e)return i;if(t>(n-=s*t)+n){if(e<r+r)return i}else{if(e>r+r)return-i;n=t-n,r=e-r,i=-i}if(0===r)return 0===n?0:-i;if(0===n)return i;if((e-=(s=Math.floor(t/n))*r)<0)return i;if(e>r)return-i;if(n>(t-=s*n)+t){if(r<e+e)return-i}else{if(r>e+e)return i;t=n-t,e=r-e,i=-i}if(0===e)return 0===t?0:i;if(0===t)return-i}};var st=function(){this._p=null,this._crossingCount=0,this._isPointOnSegment=!1;var t=arguments[0];this._p=t};st.prototype.countSegment=function(t,e){if(t.x<this._p.x&&e.x<this._p.x)return null;if(this._p.x===e.x&&this._p.y===e.y)return this._isPointOnSegment=!0,null;if(t.y===this._p.y&&e.y===this._p.y){var n=t.x,r=e.x;return n>r&&(n=e.x,r=t.x),this._p.x>=n&&this._p.x<=r&&(this._isPointOnSegment=!0),null}if(t.y>this._p.y&&e.y<=this._p.y||e.y>this._p.y&&t.y<=this._p.y){var i=t.x-this._p.x,o=t.y-this._p.y,s=e.x-this._p.x,a=e.y-this._p.y,u=ot.signOfDet2x2(i,o,s,a);if(0===u)return this._isPointOnSegment=!0,null;a<o&&(u=-u),u>0&&this._crossingCount++}},st.prototype.isPointInPolygon=function(){return this.getLocation()!==M.EXTERIOR},st.prototype.getLocation=function(){return this._isPointOnSegment?M.BOUNDARY:this._crossingCount%2==1?M.INTERIOR:M.EXTERIOR},st.prototype.isOnSegment=function(){return this._isPointOnSegment},st.prototype.interfaces_=function(){return[]},st.prototype.getClass=function(){return st},st.locatePointInRing=function(){if(arguments[0]instanceof C&&P(arguments[1],j)){for(var t=arguments[1],e=new st(arguments[0]),n=new C,r=new C,i=1;i<t.size();i++)if(t.getCoordinate(i,n),t.getCoordinate(i-1,r),e.countSegment(n,r),e.isOnSegment())return e.getLocation();return e.getLocation()}if(arguments[0]instanceof C&&arguments[1]instanceof Array){for(var o=arguments[1],s=new st(arguments[0]),a=1;a<o.length;a++){var u=o[a],l=o[a-1];if(s.countSegment(u,l),s.isOnSegment())return s.getLocation()}return s.getLocation()}};var at=function(){},ut={CLOCKWISE:{configurable:!0},RIGHT:{configurable:!0},COUNTERCLOCKWISE:{configurable:!0},LEFT:{configurable:!0},COLLINEAR:{configurable:!0},STRAIGHT:{configurable:!0}};at.prototype.interfaces_=function(){return[]},at.prototype.getClass=function(){return at},at.orientationIndex=function(t,e,n){return G.orientationIndex(t,e,n)},at.signedArea=function(){if(arguments[0]instanceof Array){var t=arguments[0];if(t.length<3)return 0;for(var e=0,n=t[0].x,r=1;r<t.length-1;r++){var i=t[r].x-n,o=t[r+1].y;e+=i*(t[r-1].y-o)}return e/2}if(P(arguments[0],j)){var s=arguments[0],a=s.size();if(a<3)return 0;var u=new C,l=new C,c=new C;s.getCoordinate(0,l),s.getCoordinate(1,c);var h=l.x;c.x-=h;for(var p=0,f=1;f<a-1;f++)u.y=l.y,l.x=c.x,l.y=c.y,s.getCoordinate(f+1,c),c.x-=h,p+=l.x*(u.y-c.y);return p/2}},at.distanceLineLine=function(t,e,n,r){if(t.equals(e))return at.distancePointLine(t,n,r);if(n.equals(r))return at.distancePointLine(r,t,e);var i=!1;if(X.intersects(t,e,n,r)){var o=(e.x-t.x)*(r.y-n.y)-(e.y-t.y)*(r.x-n.x);if(0===o)i=!0;else{var s=(t.y-n.y)*(r.x-n.x)-(t.x-n.x)*(r.y-n.y),a=((t.y-n.y)*(e.x-t.x)-(t.x-n.x)*(e.y-t.y))/o,u=s/o;(u<0||u>1||a<0||a>1)&&(i=!0)}}else i=!0;return i?O.min(at.distancePointLine(t,n,r),at.distancePointLine(e,n,r),at.distancePointLine(n,t,e),at.distancePointLine(r,t,e)):0},at.isPointInRing=function(t,e){return at.locatePointInRing(t,e)!==M.EXTERIOR},at.computeLength=function(t){var e=t.size();if(e<=1)return 0;var n=0,r=new C;t.getCoordinate(0,r);for(var i=r.x,o=r.y,s=1;s<e;s++){t.getCoordinate(s,r);var a=r.x,u=r.y,l=a-i,c=u-o;n+=Math.sqrt(l*l+c*c),i=a,o=u}return n},at.isCCW=function(t){var e=t.length-1;if(e<3)throw new m("Ring has fewer than 4 points, so orientation cannot be determined");for(var n=t[0],r=0,i=1;i<=e;i++){var o=t[i];o.y>n.y&&(n=o,r=i)}var s=r;do{(s-=1)<0&&(s=e)}while(t[s].equals2D(n)&&s!==r);var a=r;do{a=(a+1)%e}while(t[a].equals2D(n)&&a!==r);var u=t[s],l=t[a];if(u.equals2D(n)||l.equals2D(n)||u.equals2D(l))return!1;var c=at.computeOrientation(u,n,l);return 0===c?u.x>l.x:c>0},at.locatePointInRing=function(t,e){return st.locatePointInRing(t,e)},at.distancePointLinePerpendicular=function(t,e,n){var r=(n.x-e.x)*(n.x-e.x)+(n.y-e.y)*(n.y-e.y),i=((e.y-t.y)*(n.x-e.x)-(e.x-t.x)*(n.y-e.y))/r;return Math.abs(i)*Math.sqrt(r)},at.computeOrientation=function(t,e,n){return at.orientationIndex(t,e,n)},at.distancePointLine=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1];if(0===e.length)throw new m("Line array must contain at least one vertex");for(var n=t.distance(e[0]),r=0;r<e.length-1;r++){var i=at.distancePointLine(t,e[r],e[r+1]);i<n&&(n=i)}return n}if(3===arguments.length){var o=arguments[0],s=arguments[1],a=arguments[2];if(s.x===a.x&&s.y===a.y)return o.distance(s);var u=(a.x-s.x)*(a.x-s.x)+(a.y-s.y)*(a.y-s.y),l=((o.x-s.x)*(a.x-s.x)+(o.y-s.y)*(a.y-s.y))/u;if(l<=0)return o.distance(s);if(l>=1)return o.distance(a);var c=((s.y-o.y)*(a.x-s.x)-(s.x-o.x)*(a.y-s.y))/u;return Math.abs(c)*Math.sqrt(u)}},at.isOnLine=function(t,e){for(var n=new it,r=1;r<e.length;r++){var i=e[r-1],o=e[r];if(n.computeIntersection(t,i,o),n.hasIntersection())return!0}return!1},ut.CLOCKWISE.get=function(){return-1},ut.RIGHT.get=function(){return at.CLOCKWISE},ut.COUNTERCLOCKWISE.get=function(){return 1},ut.LEFT.get=function(){return at.COUNTERCLOCKWISE},ut.COLLINEAR.get=function(){return 0},ut.STRAIGHT.get=function(){return at.COLLINEAR},Object.defineProperties(at,ut);var lt=function(){};lt.prototype.filter=function(t){},lt.prototype.interfaces_=function(){return[]},lt.prototype.getClass=function(){return lt};var ct=function(){var t=arguments[0];this._envelope=null,this._factory=null,this._SRID=null,this._userData=null,this._factory=t,this._SRID=t.getSRID()},ht={serialVersionUID:{configurable:!0},SORTINDEX_POINT:{configurable:!0},SORTINDEX_MULTIPOINT:{configurable:!0},SORTINDEX_LINESTRING:{configurable:!0},SORTINDEX_LINEARRING:{configurable:!0},SORTINDEX_MULTILINESTRING:{configurable:!0},SORTINDEX_POLYGON:{configurable:!0},SORTINDEX_MULTIPOLYGON:{configurable:!0},SORTINDEX_GEOMETRYCOLLECTION:{configurable:!0},geometryChangedFilter:{configurable:!0}};ct.prototype.isGeometryCollection=function(){return this.getSortIndex()===ct.SORTINDEX_GEOMETRYCOLLECTION},ct.prototype.getFactory=function(){return this._factory},ct.prototype.getGeometryN=function(t){return this},ct.prototype.getArea=function(){return 0},ct.prototype.isRectangle=function(){return!1},ct.prototype.equals=function(){if(arguments[0]instanceof ct){var t=arguments[0];return null!==t&&this.equalsTopo(t)}if(arguments[0]instanceof Object){var e=arguments[0];if(!(e instanceof ct))return!1;var n=e;return this.equalsExact(n)}},ct.prototype.equalsExact=function(t){return this===t||this.equalsExact(t,0)},ct.prototype.geometryChanged=function(){this.apply(ct.geometryChangedFilter)},ct.prototype.geometryChangedAction=function(){this._envelope=null},ct.prototype.equalsNorm=function(t){return null!==t&&this.norm().equalsExact(t.norm())},ct.prototype.getLength=function(){return 0},ct.prototype.getNumGeometries=function(){return 1},ct.prototype.compareTo=function(){if(1===arguments.length){var t=arguments[0],e=t;return this.getSortIndex()!==e.getSortIndex()?this.getSortIndex()-e.getSortIndex():this.isEmpty()&&e.isEmpty()?0:this.isEmpty()?-1:e.isEmpty()?1:this.compareToSameClass(t)}if(2===arguments.length){var n=arguments[0],r=arguments[1];return this.getSortIndex()!==n.getSortIndex()?this.getSortIndex()-n.getSortIndex():this.isEmpty()&&n.isEmpty()?0:this.isEmpty()?-1:n.isEmpty()?1:this.compareToSameClass(n,r)}},ct.prototype.getUserData=function(){return this._userData},ct.prototype.getSRID=function(){return this._SRID},ct.prototype.getEnvelope=function(){return this.getFactory().toGeometry(this.getEnvelopeInternal())},ct.prototype.checkNotGeometryCollection=function(t){if(t.getSortIndex()===ct.SORTINDEX_GEOMETRYCOLLECTION)throw new m("This method does not support GeometryCollection arguments")},ct.prototype.equal=function(t,e,n){return 0===n?t.equals(e):t.distance(e)<=n},ct.prototype.norm=function(){var t=this.copy();return t.normalize(),t},ct.prototype.getPrecisionModel=function(){return this._factory.getPrecisionModel()},ct.prototype.getEnvelopeInternal=function(){return null===this._envelope&&(this._envelope=this.computeEnvelopeInternal()),new X(this._envelope)},ct.prototype.setSRID=function(t){this._SRID=t},ct.prototype.setUserData=function(t){this._userData=t},ct.prototype.compare=function(t,e){for(var n=t.iterator(),r=e.iterator();n.hasNext()&&r.hasNext();){var i=n.next(),o=r.next(),s=i.compareTo(o);if(0!==s)return s}return n.hasNext()?1:r.hasNext()?-1:0},ct.prototype.hashCode=function(){return this.getEnvelopeInternal().hashCode()},ct.prototype.isGeometryCollectionOrDerived=function(){return this.getSortIndex()===ct.SORTINDEX_GEOMETRYCOLLECTION||this.getSortIndex()===ct.SORTINDEX_MULTIPOINT||this.getSortIndex()===ct.SORTINDEX_MULTILINESTRING||this.getSortIndex()===ct.SORTINDEX_MULTIPOLYGON},ct.prototype.interfaces_=function(){return[E,b,e]},ct.prototype.getClass=function(){return ct},ct.hasNonEmptyElements=function(t){for(var e=0;e<t.length;e++)if(!t[e].isEmpty())return!0;return!1},ct.hasNullElements=function(t){for(var e=0;e<t.length;e++)if(null===t[e])return!0;return!1},ht.serialVersionUID.get=function(){return 0x799ea46522854c00},ht.SORTINDEX_POINT.get=function(){return 0},ht.SORTINDEX_MULTIPOINT.get=function(){return 1},ht.SORTINDEX_LINESTRING.get=function(){return 2},ht.SORTINDEX_LINEARRING.get=function(){return 3},ht.SORTINDEX_MULTILINESTRING.get=function(){return 4},ht.SORTINDEX_POLYGON.get=function(){return 5},ht.SORTINDEX_MULTIPOLYGON.get=function(){return 6},ht.SORTINDEX_GEOMETRYCOLLECTION.get=function(){return 7},ht.geometryChangedFilter.get=function(){return pt},Object.defineProperties(ct,ht);var pt=function(){};pt.interfaces_=function(){return[lt]},pt.filter=function(t){t.geometryChangedAction()};var ft=function(){};ft.prototype.filter=function(t){},ft.prototype.interfaces_=function(){return[]},ft.prototype.getClass=function(){return ft};var gt=function(){},dt={Mod2BoundaryNodeRule:{configurable:!0},EndPointBoundaryNodeRule:{configurable:!0},MultiValentEndPointBoundaryNodeRule:{configurable:!0},MonoValentEndPointBoundaryNodeRule:{configurable:!0},MOD2_BOUNDARY_RULE:{configurable:!0},ENDPOINT_BOUNDARY_RULE:{configurable:!0},MULTIVALENT_ENDPOINT_BOUNDARY_RULE:{configurable:!0},MONOVALENT_ENDPOINT_BOUNDARY_RULE:{configurable:!0},OGC_SFS_BOUNDARY_RULE:{configurable:!0}};gt.prototype.isInBoundary=function(t){},gt.prototype.interfaces_=function(){return[]},gt.prototype.getClass=function(){return gt},dt.Mod2BoundaryNodeRule.get=function(){return yt},dt.EndPointBoundaryNodeRule.get=function(){return _t},dt.MultiValentEndPointBoundaryNodeRule.get=function(){return mt},dt.MonoValentEndPointBoundaryNodeRule.get=function(){return vt},dt.MOD2_BOUNDARY_RULE.get=function(){return new yt},dt.ENDPOINT_BOUNDARY_RULE.get=function(){return new _t},dt.MULTIVALENT_ENDPOINT_BOUNDARY_RULE.get=function(){return new mt},dt.MONOVALENT_ENDPOINT_BOUNDARY_RULE.get=function(){return new vt},dt.OGC_SFS_BOUNDARY_RULE.get=function(){return gt.MOD2_BOUNDARY_RULE},Object.defineProperties(gt,dt);var yt=function(){};yt.prototype.isInBoundary=function(t){return t%2==1},yt.prototype.interfaces_=function(){return[gt]},yt.prototype.getClass=function(){return yt};var _t=function(){};_t.prototype.isInBoundary=function(t){return t>0},_t.prototype.interfaces_=function(){return[gt]},_t.prototype.getClass=function(){return _t};var mt=function(){};mt.prototype.isInBoundary=function(t){return t>1},mt.prototype.interfaces_=function(){return[gt]},mt.prototype.getClass=function(){return mt};var vt=function(){};vt.prototype.isInBoundary=function(t){return 1===t},vt.prototype.interfaces_=function(){return[gt]},vt.prototype.getClass=function(){return vt};var xt=function(){};xt.prototype.add=function(){},xt.prototype.addAll=function(){},xt.prototype.isEmpty=function(){},xt.prototype.iterator=function(){},xt.prototype.size=function(){},xt.prototype.toArray=function(){},xt.prototype.remove=function(){},(n.prototype=new Error).name="IndexOutOfBoundsException";var bt=function(){};bt.prototype.hasNext=function(){},bt.prototype.next=function(){},bt.prototype.remove=function(){};var Et=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.get=function(){},e.prototype.set=function(){},e.prototype.isEmpty=function(){},e}(xt);(r.prototype=new Error).name="NoSuchElementException";var It=function(t){function e(){t.call(this),this.array_=[],arguments[0]instanceof xt&&this.addAll(arguments[0])}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.ensureCapacity=function(){},e.prototype.interfaces_=function(){return[t,xt]},e.prototype.add=function(t){return 1===arguments.length?this.array_.push(t):this.array_.splice(arguments[0],arguments[1]),!0},e.prototype.clear=function(){this.array_=[]},e.prototype.addAll=function(t){for(var e=t.iterator();e.hasNext();)this.add(e.next());return!0},e.prototype.set=function(t,e){var n=this.array_[t];return this.array_[t]=e,n},e.prototype.iterator=function(){return new Ct(this)},e.prototype.get=function(t){if(t<0||t>=this.size())throw new n;return this.array_[t]},e.prototype.isEmpty=function(){return 0===this.array_.length},e.prototype.size=function(){return this.array_.length},e.prototype.toArray=function(){for(var t=[],e=0,n=this.array_.length;e<n;e++)t.push(this.array_[e]);return t},e.prototype.remove=function(t){for(var e=!1,n=0,r=this.array_.length;n<r;n++)if(this.array_[n]===t){this.array_.splice(n,1),e=!0;break}return e},e}(Et),Ct=function(t){function e(e){t.call(this),this.arrayList_=e,this.position_=0}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.next=function(){if(this.position_===this.arrayList_.size())throw new r;return this.arrayList_.get(this.position_++)},e.prototype.hasNext=function(){return this.position_<this.arrayList_.size()},e.prototype.set=function(t){return this.arrayList_.set(this.position_-1,t)},e.prototype.remove=function(){this.arrayList_.remove(this.arrayList_.get(this.position_))},e}(bt),St=function(t){function e(){if(t.call(this),0===arguments.length);else if(1===arguments.length){var e=arguments[0];this.ensureCapacity(e.length),this.add(e,!0)}else if(2===arguments.length){var n=arguments[0],r=arguments[1];this.ensureCapacity(n.length),this.add(n,r)}}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={coordArrayType:{configurable:!0}};return n.coordArrayType.get=function(){return new Array(0).fill(null)},e.prototype.getCoordinate=function(t){return this.get(t)},e.prototype.addAll=function(){if(2===arguments.length){for(var e=arguments[1],n=!1,r=arguments[0].iterator();r.hasNext();)this.add(r.next(),e),n=!0;return n}return t.prototype.addAll.apply(this,arguments)},e.prototype.clone=function(){for(var e=t.prototype.clone.call(this),n=0;n<this.size();n++)e.add(n,this.get(n).copy());return e},e.prototype.toCoordinateArray=function(){return this.toArray(e.coordArrayType)},e.prototype.add=function(){if(1===arguments.length){var e=arguments[0];t.prototype.add.call(this,e)}else if(2===arguments.length){if(arguments[0]instanceof Array&&"boolean"==typeof arguments[1]){var n=arguments[0],r=arguments[1];return this.add(n,r,!0),!0}if(arguments[0]instanceof C&&"boolean"==typeof arguments[1]){var i=arguments[0];if(!arguments[1]&&this.size()>=1&&this.get(this.size()-1).equals2D(i))return null;t.prototype.add.call(this,i)}else if(arguments[0]instanceof Object&&"boolean"==typeof arguments[1]){var o=arguments[0],s=arguments[1];return this.add(o,s),!0}}else if(3===arguments.length){if("boolean"==typeof arguments[2]&&arguments[0]instanceof Array&&"boolean"==typeof arguments[1]){var a=arguments[0],u=arguments[1];if(arguments[2])for(var l=0;l<a.length;l++)this.add(a[l],u);else for(var c=a.length-1;c>=0;c--)this.add(a[c],u);return!0}if("boolean"==typeof arguments[2]&&Number.isInteger(arguments[0])&&arguments[1]instanceof C){var h=arguments[0],p=arguments[1];if(!arguments[2]){var f=this.size();if(f>0){if(h>0&&this.get(h-1).equals2D(p))return null;if(h<f&&this.get(h).equals2D(p))return null}}t.prototype.add.call(this,h,p)}}else if(4===arguments.length){var g=arguments[0],d=arguments[1],y=arguments[2],_=arguments[3],m=1;y>_&&(m=-1);for(var v=y;v!==_;v+=m)this.add(g[v],d);return!0}},e.prototype.closeRing=function(){this.size()>0&&this.add(new C(this.get(0)),!1)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},Object.defineProperties(e,n),e}(It),wt=function(){},Nt={ForwardComparator:{configurable:!0},BidirectionalComparator:{configurable:!0},coordArrayType:{configurable:!0}};Nt.ForwardComparator.get=function(){return Mt},Nt.BidirectionalComparator.get=function(){return Lt},Nt.coordArrayType.get=function(){return new Array(0).fill(null)},wt.prototype.interfaces_=function(){return[]},wt.prototype.getClass=function(){return wt},wt.isRing=function(t){return!(t.length<4||!t[0].equals2D(t[t.length-1]))},wt.ptNotInList=function(t,e){for(var n=0;n<t.length;n++){var r=t[n];if(wt.indexOf(r,e)<0)return r}return null},wt.scroll=function(t,e){var n=wt.indexOf(e,t);if(n<0)return null;var r=new Array(t.length).fill(null);V.arraycopy(t,n,r,0,t.length-n),V.arraycopy(t,0,r,t.length-n,n),V.arraycopy(r,0,t,0,t.length)},wt.equals=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1];if(t===e)return!0;if(null===t||null===e)return!1;if(t.length!==e.length)return!1;for(var n=0;n<t.length;n++)if(!t[n].equals(e[n]))return!1;return!0}if(3===arguments.length){var r=arguments[0],i=arguments[1],o=arguments[2];if(r===i)return!0;if(null===r||null===i)return!1;if(r.length!==i.length)return!1;for(var s=0;s<r.length;s++)if(0!==o.compare(r[s],i[s]))return!1;return!0}},wt.intersection=function(t,e){for(var n=new St,r=0;r<t.length;r++)e.intersects(t[r])&&n.add(t[r],!0);return n.toCoordinateArray()},wt.hasRepeatedPoints=function(t){for(var e=1;e<t.length;e++)if(t[e-1].equals(t[e]))return!0;return!1},wt.removeRepeatedPoints=function(t){return wt.hasRepeatedPoints(t)?new St(t,!1).toCoordinateArray():t},wt.reverse=function(t){for(var e=t.length-1,n=Math.trunc(e/2),r=0;r<=n;r++){var i=t[r];t[r]=t[e-r],t[e-r]=i}},wt.removeNull=function(t){for(var e=0,n=0;n<t.length;n++)null!==t[n]&&e++;var r=new Array(e).fill(null);if(0===e)return r;for(var i=0,o=0;o<t.length;o++)null!==t[o]&&(r[i++]=t[o]);return r},wt.copyDeep=function(){if(1===arguments.length){for(var t=arguments[0],e=new Array(t.length).fill(null),n=0;n<t.length;n++)e[n]=new C(t[n]);return e}if(5===arguments.length)for(var r=arguments[0],i=arguments[1],o=arguments[2],s=arguments[3],a=arguments[4],u=0;u<a;u++)o[s+u]=new C(r[i+u])},wt.isEqualReversed=function(t,e){for(var n=0;n<t.length;n++){var r=t[n],i=e[t.length-n-1];if(0!==r.compareTo(i))return!1}return!0},wt.envelope=function(t){for(var e=new X,n=0;n<t.length;n++)e.expandToInclude(t[n]);return e},wt.toCoordinateArray=function(t){return t.toArray(wt.coordArrayType)},wt.atLeastNCoordinatesOrNothing=function(t,e){return e.length>=t?e:[]},wt.indexOf=function(t,e){for(var n=0;n<e.length;n++)if(t.equals(e[n]))return n;return-1},wt.increasingDirection=function(t){for(var e=0;e<Math.trunc(t.length/2);e++){var n=t.length-1-e,r=t[e].compareTo(t[n]);if(0!==r)return r}return 1},wt.compare=function(t,e){for(var n=0;n<t.length&&n<e.length;){var r=t[n].compareTo(e[n]);if(0!==r)return r;n++}return n<e.length?-1:n<t.length?1:0},wt.minCoordinate=function(t){for(var e=null,n=0;n<t.length;n++)(null===e||e.compareTo(t[n])>0)&&(e=t[n]);return e},wt.extract=function(t,e,n){e=O.clamp(e,0,t.length);var r=(n=O.clamp(n,-1,t.length))-e+1;n<0&&(r=0),e>=t.length&&(r=0),n<e&&(r=0);var i=new Array(r).fill(null);if(0===r)return i;for(var o=0,s=e;s<=n;s++)i[o++]=t[s];return i},Object.defineProperties(wt,Nt);var Mt=function(){};Mt.prototype.compare=function(t,e){return wt.compare(t,e)},Mt.prototype.interfaces_=function(){return[I]},Mt.prototype.getClass=function(){return Mt};var Lt=function(){};Lt.prototype.compare=function(t,e){var n=t,r=e;if(n.length<r.length)return-1;if(n.length>r.length)return 1;if(0===n.length)return 0;var i=wt.compare(n,r);return wt.isEqualReversed(n,r)?0:i},Lt.prototype.OLDcompare=function(t,e){var n=t,r=e;if(n.length<r.length)return-1;if(n.length>r.length)return 1;if(0===n.length)return 0;for(var i=wt.increasingDirection(n),o=wt.increasingDirection(r),s=i>0?0:n.length-1,a=o>0?0:n.length-1,u=0;u<n.length;u++){var l=n[s].compareTo(r[a]);if(0!==l)return l;s+=i,a+=o}return 0},Lt.prototype.interfaces_=function(){return[I]},Lt.prototype.getClass=function(){return Lt};var Pt=function(){};Pt.prototype.get=function(){},Pt.prototype.put=function(){},Pt.prototype.size=function(){},Pt.prototype.values=function(){},Pt.prototype.entrySet=function(){};var Ot=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e}(Pt);(i.prototype=new Error).name="OperationNotSupported",(o.prototype=new xt).contains=function(){};var Rt=function(t){function e(){t.call(this),this.array_=[],arguments[0]instanceof xt&&this.addAll(arguments[0])}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.contains=function(t){for(var e=0,n=this.array_.length;e<n;e++)if(this.array_[e]===t)return!0;return!1},e.prototype.add=function(t){return!this.contains(t)&&(this.array_.push(t),!0)},e.prototype.addAll=function(t){for(var e=t.iterator();e.hasNext();)this.add(e.next());return!0},e.prototype.remove=function(t){throw new Error},e.prototype.size=function(){return this.array_.length},e.prototype.isEmpty=function(){return 0===this.array_.length},e.prototype.toArray=function(){for(var t=[],e=0,n=this.array_.length;e<n;e++)t.push(this.array_[e]);return t},e.prototype.iterator=function(){return new Tt(this)},e}(o),Tt=function(t){function e(e){t.call(this),this.hashSet_=e,this.position_=0}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.next=function(){if(this.position_===this.hashSet_.size())throw new r;return this.hashSet_.array_[this.position_++]},e.prototype.hasNext=function(){return this.position_<this.hashSet_.size()},e.prototype.remove=function(){throw new i},e}(bt),At=0;(h.prototype=new Ot).get=function(t){for(var e=this.root_;null!==e;){var n=t.compareTo(e.key);if(n<0)e=e.left;else{if(!(n>0))return e.value;e=e.right}}return null},h.prototype.put=function(t,e){if(null===this.root_)return this.root_={key:t,value:e,left:null,right:null,parent:null,color:At,getValue:function(){return this.value},getKey:function(){return this.key}},this.size_=1,null;var n,r,i=this.root_;do{if(n=i,(r=t.compareTo(i.key))<0)i=i.left;else{if(!(r>0)){var o=i.value;return i.value=e,o}i=i.right}}while(null!==i);var s={key:t,left:null,right:null,value:e,parent:n,color:At,getValue:function(){return this.value},getKey:function(){return this.key}};return r<0?n.left=s:n.right=s,this.fixAfterInsertion(s),this.size_++,null},h.prototype.fixAfterInsertion=function(t){for(t.color=1;null!=t&&t!==this.root_&&1===t.parent.color;)if(a(t)===l(a(a(t)))){var e=c(a(a(t)));1===s(e)?(u(a(t),At),u(e,At),u(a(a(t)),1),t=a(a(t))):(t===c(a(t))&&(t=a(t),this.rotateLeft(t)),u(a(t),At),u(a(a(t)),1),this.rotateRight(a(a(t))))}else{var n=l(a(a(t)));1===s(n)?(u(a(t),At),u(n,At),u(a(a(t)),1),t=a(a(t))):(t===l(a(t))&&(t=a(t),this.rotateRight(t)),u(a(t),At),u(a(a(t)),1),this.rotateLeft(a(a(t))))}this.root_.color=At},h.prototype.values=function(){var t=new It,e=this.getFirstEntry();if(null!==e)for(t.add(e.value);null!==(e=h.successor(e));)t.add(e.value);return t},h.prototype.entrySet=function(){var t=new Rt,e=this.getFirstEntry();if(null!==e)for(t.add(e);null!==(e=h.successor(e));)t.add(e);return t},h.prototype.rotateLeft=function(t){if(null!=t){var e=t.right;t.right=e.left,null!=e.left&&(e.left.parent=t),e.parent=t.parent,null===t.parent?this.root_=e:t.parent.left===t?t.parent.left=e:t.parent.right=e,e.left=t,t.parent=e}},h.prototype.rotateRight=function(t){if(null!=t){var e=t.left;t.left=e.right,null!=e.right&&(e.right.parent=t),e.parent=t.parent,null===t.parent?this.root_=e:t.parent.right===t?t.parent.right=e:t.parent.left=e,e.right=t,t.parent=e}},h.prototype.getFirstEntry=function(){var t=this.root_;if(null!=t)for(;null!=t.left;)t=t.left;return t},h.successor=function(t){if(null===t)return null;if(null!==t.right){for(var e=t.right;null!==e.left;)e=e.left;return e}for(var n=t.parent,r=t;null!==n&&r===n.right;)r=n,n=n.parent;return n},h.prototype.size=function(){return this.size_};var Dt=function(){};Dt.prototype.interfaces_=function(){return[]},Dt.prototype.getClass=function(){return Dt},p.prototype=new o,(f.prototype=new p).contains=function(t){for(var e=0,n=this.array_.length;e<n;e++)if(0===this.array_[e].compareTo(t))return!0;return!1},f.prototype.add=function(t){if(this.contains(t))return!1;for(var e=0,n=this.array_.length;e<n;e++)if(1===this.array_[e].compareTo(t))return this.array_.splice(e,0,t),!0;return this.array_.push(t),!0},f.prototype.addAll=function(t){for(var e=t.iterator();e.hasNext();)this.add(e.next());return!0},f.prototype.remove=function(t){throw new i},f.prototype.size=function(){return this.array_.length},f.prototype.isEmpty=function(){return 0===this.array_.length},f.prototype.toArray=function(){for(var t=[],e=0,n=this.array_.length;e<n;e++)t.push(this.array_[e]);return t},f.prototype.iterator=function(){return new Ft(this)};var Ft=function(t){this.treeSet_=t,this.position_=0};Ft.prototype.next=function(){if(this.position_===this.treeSet_.size())throw new r;return this.treeSet_.array_[this.position_++]},Ft.prototype.hasNext=function(){return this.position_<this.treeSet_.size()},Ft.prototype.remove=function(){throw new i};var kt=function(){};kt.sort=function(){var t,e,n,r,i=arguments[0];if(1===arguments.length)r=function(t,e){return t.compareTo(e)},i.sort(r);else if(2===arguments.length)n=arguments[1],r=function(t,e){return n.compare(t,e)},i.sort(r);else if(3===arguments.length){(e=i.slice(arguments[1],arguments[2])).sort();var o=i.slice(0,arguments[1]).concat(e,i.slice(arguments[2],i.length));for(i.splice(0,i.length),t=0;t<o.length;t++)i.push(o[t])}else if(4===arguments.length)for(e=i.slice(arguments[1],arguments[2]),n=arguments[3],r=function(t,e){return n.compare(t,e)},e.sort(r),o=i.slice(0,arguments[1]).concat(e,i.slice(arguments[2],i.length)),i.splice(0,i.length),t=0;t<o.length;t++)i.push(o[t])},kt.asList=function(t){for(var e=new It,n=0,r=t.length;n<r;n++)e.add(t[n]);return e};var Gt=function(){},Bt={P:{configurable:!0},L:{configurable:!0},A:{configurable:!0},FALSE:{configurable:!0},TRUE:{configurable:!0},DONTCARE:{configurable:!0},SYM_FALSE:{configurable:!0},SYM_TRUE:{configurable:!0},SYM_DONTCARE:{configurable:!0},SYM_P:{configurable:!0},SYM_L:{configurable:!0},SYM_A:{configurable:!0}};Bt.P.get=function(){return 0},Bt.L.get=function(){return 1},Bt.A.get=function(){return 2},Bt.FALSE.get=function(){return-1},Bt.TRUE.get=function(){return-2},Bt.DONTCARE.get=function(){return-3},Bt.SYM_FALSE.get=function(){return"F"},Bt.SYM_TRUE.get=function(){return"T"},Bt.SYM_DONTCARE.get=function(){return"*"},Bt.SYM_P.get=function(){return"0"},Bt.SYM_L.get=function(){return"1"},Bt.SYM_A.get=function(){return"2"},Gt.prototype.interfaces_=function(){return[]},Gt.prototype.getClass=function(){return Gt},Gt.toDimensionSymbol=function(t){switch(t){case Gt.FALSE:return Gt.SYM_FALSE;case Gt.TRUE:return Gt.SYM_TRUE;case Gt.DONTCARE:return Gt.SYM_DONTCARE;case Gt.P:return Gt.SYM_P;case Gt.L:return Gt.SYM_L;case Gt.A:return Gt.SYM_A}throw new m("Unknown dimension value: "+t)},Gt.toDimensionValue=function(t){switch(D.toUpperCase(t)){case Gt.SYM_FALSE:return Gt.FALSE;case Gt.SYM_TRUE:return Gt.TRUE;case Gt.SYM_DONTCARE:return Gt.DONTCARE;case Gt.SYM_P:return Gt.P;case Gt.SYM_L:return Gt.L;case Gt.SYM_A:return Gt.A}throw new m("Unknown dimension symbol: "+t)},Object.defineProperties(Gt,Bt);var jt=function(){};jt.prototype.filter=function(t){},jt.prototype.interfaces_=function(){return[]},jt.prototype.getClass=function(){return jt};var Ut=function(){};Ut.prototype.filter=function(t,e){},Ut.prototype.isDone=function(){},Ut.prototype.isGeometryChanged=function(){},Ut.prototype.interfaces_=function(){return[]},Ut.prototype.getClass=function(){return Ut};var qt=function(t){function e(e,n){if(t.call(this,n),this._geometries=e||[],t.hasNullElements(this._geometries))throw new m("geometries must not contain null elements")}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.computeEnvelopeInternal=function(){for(var t=new X,e=0;e<this._geometries.length;e++)t.expandToInclude(this._geometries[e].getEnvelopeInternal());return t},e.prototype.getGeometryN=function(t){return this._geometries[t]},e.prototype.getSortIndex=function(){return t.SORTINDEX_GEOMETRYCOLLECTION},e.prototype.getCoordinates=function(){for(var t=new Array(this.getNumPoints()).fill(null),e=-1,n=0;n<this._geometries.length;n++)for(var r=this._geometries[n].getCoordinates(),i=0;i<r.length;i++)t[++e]=r[i];return t},e.prototype.getArea=function(){for(var t=0,e=0;e<this._geometries.length;e++)t+=this._geometries[e].getArea();return t},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];if(!this.isEquivalentClass(e))return!1;var r=e;if(this._geometries.length!==r._geometries.length)return!1;for(var i=0;i<this._geometries.length;i++)if(!this._geometries[i].equalsExact(r._geometries[i],n))return!1;return!0}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.normalize=function(){for(var t=0;t<this._geometries.length;t++)this._geometries[t].normalize();kt.sort(this._geometries)},e.prototype.getCoordinate=function(){return this.isEmpty()?null:this._geometries[0].getCoordinate()},e.prototype.getBoundaryDimension=function(){for(var t=Gt.FALSE,e=0;e<this._geometries.length;e++)t=Math.max(t,this._geometries[e].getBoundaryDimension());return t},e.prototype.getDimension=function(){for(var t=Gt.FALSE,e=0;e<this._geometries.length;e++)t=Math.max(t,this._geometries[e].getDimension());return t},e.prototype.getLength=function(){for(var t=0,e=0;e<this._geometries.length;e++)t+=this._geometries[e].getLength();return t},e.prototype.getNumPoints=function(){for(var t=0,e=0;e<this._geometries.length;e++)t+=this._geometries[e].getNumPoints();return t},e.prototype.getNumGeometries=function(){return this._geometries.length},e.prototype.reverse=function(){for(var t=this._geometries.length,e=new Array(t).fill(null),n=0;n<this._geometries.length;n++)e[n]=this._geometries[n].reverse();return this.getFactory().createGeometryCollection(e)},e.prototype.compareToSameClass=function(){if(1===arguments.length){var t=arguments[0],e=new f(kt.asList(this._geometries)),n=new f(kt.asList(t._geometries));return this.compare(e,n)}if(2===arguments.length){for(var r=arguments[1],i=arguments[0],o=this.getNumGeometries(),s=i.getNumGeometries(),a=0;a<o&&a<s;){var u=this.getGeometryN(a),l=i.getGeometryN(a),c=u.compareToSameClass(l,r);if(0!==c)return c;a++}return a<o?1:a<s?-1:0}},e.prototype.apply=function(){if(P(arguments[0],ft))for(var t=arguments[0],e=0;e<this._geometries.length;e++)this._geometries[e].apply(t);else if(P(arguments[0],Ut)){var n=arguments[0];if(0===this._geometries.length)return null;for(var r=0;r<this._geometries.length&&(this._geometries[r].apply(n),!n.isDone());r++);n.isGeometryChanged()&&this.geometryChanged()}else if(P(arguments[0],jt)){var i=arguments[0];i.filter(this);for(var o=0;o<this._geometries.length;o++)this._geometries[o].apply(i)}else if(P(arguments[0],lt)){var s=arguments[0];s.filter(this);for(var a=0;a<this._geometries.length;a++)this._geometries[a].apply(s)}},e.prototype.getBoundary=function(){return this.checkNotGeometryCollection(this),et.shouldNeverReachHere(),null},e.prototype.clone=function(){var e=t.prototype.clone.call(this);e._geometries=new Array(this._geometries.length).fill(null);for(var n=0;n<this._geometries.length;n++)e._geometries[n]=this._geometries[n].clone();return e},e.prototype.getGeometryType=function(){return"GeometryCollection"},e.prototype.copy=function(){for(var t=new Array(this._geometries.length).fill(null),n=0;n<t.length;n++)t[n]=this._geometries[n].copy();return new e(t,this._factory)},e.prototype.isEmpty=function(){for(var t=0;t<this._geometries.length;t++)if(!this._geometries[t].isEmpty())return!1;return!0},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return-0x4f07bcb1f857d800},Object.defineProperties(e,n),e}(ct),zt=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.getSortIndex=function(){return ct.SORTINDEX_MULTILINESTRING},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];return!!this.isEquivalentClass(e)&&t.prototype.equalsExact.call(this,e,n)}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.getBoundaryDimension=function(){return this.isClosed()?Gt.FALSE:0},e.prototype.isClosed=function(){if(this.isEmpty())return!1;for(var t=0;t<this._geometries.length;t++)if(!this._geometries[t].isClosed())return!1;return!0},e.prototype.getDimension=function(){return 1},e.prototype.reverse=function(){for(var t=this._geometries.length,e=new Array(t).fill(null),n=0;n<this._geometries.length;n++)e[t-1-n]=this._geometries[n].reverse();return this.getFactory().createMultiLineString(e)},e.prototype.getBoundary=function(){return new Vt(this).getBoundary()},e.prototype.getGeometryType=function(){return"MultiLineString"},e.prototype.copy=function(){for(var t=new Array(this._geometries.length).fill(null),n=0;n<t.length;n++)t[n]=this._geometries[n].copy();return new e(t,this._factory)},e.prototype.interfaces_=function(){return[Dt]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return 0x7155d2ab4afa8000},Object.defineProperties(e,n),e}(qt),Vt=function(){if(this._geom=null,this._geomFact=null,this._bnRule=null,this._endpointMap=null,1===arguments.length){var t=arguments[0],e=gt.MOD2_BOUNDARY_RULE;this._geom=t,this._geomFact=t.getFactory(),this._bnRule=e}else if(2===arguments.length){var n=arguments[0],r=arguments[1];this._geom=n,this._geomFact=n.getFactory(),this._bnRule=r}};Vt.prototype.boundaryMultiLineString=function(t){if(this._geom.isEmpty())return this.getEmptyMultiPoint();var e=this.computeBoundaryCoordinates(t);return 1===e.length?this._geomFact.createPoint(e[0]):this._geomFact.createMultiPointFromCoords(e)},Vt.prototype.getBoundary=function(){return this._geom instanceof Kt?this.boundaryLineString(this._geom):this._geom instanceof zt?this.boundaryMultiLineString(this._geom):this._geom.getBoundary()},Vt.prototype.boundaryLineString=function(t){return this._geom.isEmpty()?this.getEmptyMultiPoint():t.isClosed()?this._bnRule.isInBoundary(2)?t.getStartPoint():this._geomFact.createMultiPoint():this._geomFact.createMultiPoint([t.getStartPoint(),t.getEndPoint()])},Vt.prototype.getEmptyMultiPoint=function(){return this._geomFact.createMultiPoint()},Vt.prototype.computeBoundaryCoordinates=function(t){var e=new It;this._endpointMap=new h;for(var n=0;n<t.getNumGeometries();n++){var r=t.getGeometryN(n);0!==r.getNumPoints()&&(this.addEndpoint(r.getCoordinateN(0)),this.addEndpoint(r.getCoordinateN(r.getNumPoints()-1)))}for(var i=this._endpointMap.entrySet().iterator();i.hasNext();){var o=i.next(),s=o.getValue().count;this._bnRule.isInBoundary(s)&&e.add(o.getKey())}return wt.toCoordinateArray(e)},Vt.prototype.addEndpoint=function(t){var e=this._endpointMap.get(t);null===e&&(e=new Yt,this._endpointMap.put(t,e)),e.count++},Vt.prototype.interfaces_=function(){return[]},Vt.prototype.getClass=function(){return Vt},Vt.getBoundary=function(){return 1===arguments.length?new Vt(arguments[0]).getBoundary():2===arguments.length?new Vt(arguments[0],arguments[1]).getBoundary():void 0};var Yt=function(){this.count=null};Yt.prototype.interfaces_=function(){return[]},Yt.prototype.getClass=function(){return Yt};var Xt=function(){},Wt={NEWLINE:{configurable:!0},SIMPLE_ORDINATE_FORMAT:{configurable:!0}};Xt.prototype.interfaces_=function(){return[]},Xt.prototype.getClass=function(){return Xt},Xt.chars=function(t,e){for(var n=new Array(e).fill(null),r=0;r<e;r++)n[r]=t;return String(n)},Xt.getStackTrace=function(){if(1===arguments.length){var t=arguments[0],e=new function(){},n=new function(){}(e);return t.printStackTrace(n),e.toString()}if(2===arguments.length){for(var r=arguments[0],i=arguments[1],o="",s=new function(){}(new function(){}(Xt.getStackTrace(r))),a=0;a<i;a++)try{o+=s.readLine()+Xt.NEWLINE}catch(t){if(!(t instanceof g))throw t;et.shouldNeverReachHere()}return o}},Xt.split=function(t,e){for(var n=e.length,r=new It,i=""+t,o=i.indexOf(e);o>=0;){var s=i.substring(0,o);r.add(s),o=(i=i.substring(o+n)).indexOf(e)}i.length>0&&r.add(i);for(var a=new Array(r.size()).fill(null),u=0;u<a.length;u++)a[u]=r.get(u);return a},Xt.toString=function(){if(1===arguments.length){var t=arguments[0];return Xt.SIMPLE_ORDINATE_FORMAT.format(t)}},Xt.spaces=function(t){return Xt.chars(" ",t)},Wt.NEWLINE.get=function(){return V.getProperty("line.separator")},Wt.SIMPLE_ORDINATE_FORMAT.get=function(){return new function(){}("0.#")},Object.defineProperties(Xt,Wt);var Ht=function(){};Ht.prototype.interfaces_=function(){return[]},Ht.prototype.getClass=function(){return Ht},Ht.copyCoord=function(t,e,n,r){for(var i=Math.min(t.getDimension(),n.getDimension()),o=0;o<i;o++)n.setOrdinate(r,o,t.getOrdinate(e,o))},Ht.isRing=function(t){var e=t.size();return 0===e||!(e<=3)&&t.getOrdinate(0,j.X)===t.getOrdinate(e-1,j.X)&&t.getOrdinate(0,j.Y)===t.getOrdinate(e-1,j.Y)},Ht.isEqual=function(t,e){var n=t.size();if(n!==e.size())return!1;for(var r=Math.min(t.getDimension(),e.getDimension()),i=0;i<n;i++)for(var o=0;o<r;o++){var s=t.getOrdinate(i,o),a=e.getOrdinate(i,o);if(!(t.getOrdinate(i,o)===e.getOrdinate(i,o)||v.isNaN(s)&&v.isNaN(a)))return!1}return!0},Ht.extend=function(t,e,n){var r=t.create(n,e.getDimension()),i=e.size();if(Ht.copy(e,0,r,0,i),i>0)for(var o=i;o<n;o++)Ht.copy(e,i-1,r,o,1);return r},Ht.reverse=function(t){for(var e=t.size()-1,n=Math.trunc(e/2),r=0;r<=n;r++)Ht.swap(t,r,e-r)},Ht.swap=function(t,e,n){if(e===n)return null;for(var r=0;r<t.getDimension();r++){var i=t.getOrdinate(e,r);t.setOrdinate(e,r,t.getOrdinate(n,r)),t.setOrdinate(n,r,i)}},Ht.copy=function(t,e,n,r,i){for(var o=0;o<i;o++)Ht.copyCoord(t,e+o,n,r+o)},Ht.toString=function(){if(1===arguments.length){var t=arguments[0],e=t.size();if(0===e)return"()";var n=t.getDimension(),r=new T;r.append("(");for(var i=0;i<e;i++){i>0&&r.append(" ");for(var o=0;o<n;o++)o>0&&r.append(","),r.append(Xt.toString(t.getOrdinate(i,o)))}return r.append(")"),r.toString()}},Ht.ensureValidRing=function(t,e){var n=e.size();return 0===n?e:n<=3?Ht.createClosedRing(t,e,4):e.getOrdinate(0,j.X)===e.getOrdinate(n-1,j.X)&&e.getOrdinate(0,j.Y)===e.getOrdinate(n-1,j.Y)?e:Ht.createClosedRing(t,e,n+1)},Ht.createClosedRing=function(t,e,n){var r=t.create(n,e.getDimension()),i=e.size();Ht.copy(e,0,r,0,i);for(var o=i;o<n;o++)Ht.copy(e,0,r,o,1);return r};var Kt=function(t){function e(e,n){t.call(this,n),this._points=null,this.init(e)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.computeEnvelopeInternal=function(){return this.isEmpty()?new X:this._points.expandEnvelope(new X)},e.prototype.isRing=function(){return this.isClosed()&&this.isSimple()},e.prototype.getSortIndex=function(){return t.SORTINDEX_LINESTRING},e.prototype.getCoordinates=function(){return this._points.toCoordinateArray()},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];if(!this.isEquivalentClass(e))return!1;var r=e;if(this._points.size()!==r._points.size())return!1;for(var i=0;i<this._points.size();i++)if(!this.equal(this._points.getCoordinate(i),r._points.getCoordinate(i),n))return!1;return!0}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.normalize=function(){for(var t=0;t<Math.trunc(this._points.size()/2);t++){var e=this._points.size()-1-t;if(!this._points.getCoordinate(t).equals(this._points.getCoordinate(e)))return this._points.getCoordinate(t).compareTo(this._points.getCoordinate(e))>0&&Ht.reverse(this._points),null}},e.prototype.getCoordinate=function(){return this.isEmpty()?null:this._points.getCoordinate(0)},e.prototype.getBoundaryDimension=function(){return this.isClosed()?Gt.FALSE:0},e.prototype.isClosed=function(){return!this.isEmpty()&&this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints()-1))},e.prototype.getEndPoint=function(){return this.isEmpty()?null:this.getPointN(this.getNumPoints()-1)},e.prototype.getDimension=function(){return 1},e.prototype.getLength=function(){return at.computeLength(this._points)},e.prototype.getNumPoints=function(){return this._points.size()},e.prototype.reverse=function(){var t=this._points.copy();return Ht.reverse(t),this.getFactory().createLineString(t)},e.prototype.compareToSameClass=function(){if(1===arguments.length){for(var t=arguments[0],e=0,n=0;e<this._points.size()&&n<t._points.size();){var r=this._points.getCoordinate(e).compareTo(t._points.getCoordinate(n));if(0!==r)return r;e++,n++}return e<this._points.size()?1:n<t._points.size()?-1:0}if(2===arguments.length){var i=arguments[0];return arguments[1].compare(this._points,i._points)}},e.prototype.apply=function(){if(P(arguments[0],ft))for(var t=arguments[0],e=0;e<this._points.size();e++)t.filter(this._points.getCoordinate(e));else if(P(arguments[0],Ut)){var n=arguments[0];if(0===this._points.size())return null;for(var r=0;r<this._points.size()&&(n.filter(this._points,r),!n.isDone());r++);n.isGeometryChanged()&&this.geometryChanged()}else(P(arguments[0],jt)||P(arguments[0],lt))&&arguments[0].filter(this)},e.prototype.getBoundary=function(){return new Vt(this).getBoundary()},e.prototype.isEquivalentClass=function(t){return t instanceof e},e.prototype.clone=function(){var e=t.prototype.clone.call(this);return e._points=this._points.clone(),e},e.prototype.getCoordinateN=function(t){return this._points.getCoordinate(t)},e.prototype.getGeometryType=function(){return"LineString"},e.prototype.copy=function(){return new e(this._points.copy(),this._factory)},e.prototype.getCoordinateSequence=function(){return this._points},e.prototype.isEmpty=function(){return 0===this._points.size()},e.prototype.init=function(t){if(null===t&&(t=this.getFactory().getCoordinateSequenceFactory().create([])),1===t.size())throw new m("Invalid number of points in LineString (found "+t.size()+" - must be 0 or >= 2)");this._points=t},e.prototype.isCoordinate=function(t){for(var e=0;e<this._points.size();e++)if(this._points.getCoordinate(e).equals(t))return!0;return!1},e.prototype.getStartPoint=function(){return this.isEmpty()?null:this.getPointN(0)},e.prototype.getPointN=function(t){return this.getFactory().createPoint(this._points.getCoordinate(t))},e.prototype.interfaces_=function(){return[Dt]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return 0x2b2b51ba435c8e00},Object.defineProperties(e,n),e}(ct),Jt=function(){};Jt.prototype.interfaces_=function(){return[]},Jt.prototype.getClass=function(){return Jt};var Zt=function(t){function e(e,n){t.call(this,n),this._coordinates=e||null,this.init(this._coordinates)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.computeEnvelopeInternal=function(){if(this.isEmpty())return new X;var t=new X;return t.expandToInclude(this._coordinates.getX(0),this._coordinates.getY(0)),t},e.prototype.getSortIndex=function(){return t.SORTINDEX_POINT},e.prototype.getCoordinates=function(){return this.isEmpty()?[]:[this.getCoordinate()]},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];return!!this.isEquivalentClass(e)&&(!(!this.isEmpty()||!e.isEmpty())||this.isEmpty()===e.isEmpty()&&this.equal(e.getCoordinate(),this.getCoordinate(),n))}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.normalize=function(){},e.prototype.getCoordinate=function(){return 0!==this._coordinates.size()?this._coordinates.getCoordinate(0):null},e.prototype.getBoundaryDimension=function(){return Gt.FALSE},e.prototype.getDimension=function(){return 0},e.prototype.getNumPoints=function(){return this.isEmpty()?0:1},e.prototype.reverse=function(){return this.copy()},e.prototype.getX=function(){if(null===this.getCoordinate())throw new Error("getX called on empty Point");return this.getCoordinate().x},e.prototype.compareToSameClass=function(){if(1===arguments.length){var t=arguments[0];return this.getCoordinate().compareTo(t.getCoordinate())}if(2===arguments.length){var e=arguments[0];return arguments[1].compare(this._coordinates,e._coordinates)}},e.prototype.apply=function(){if(P(arguments[0],ft)){var t=arguments[0];if(this.isEmpty())return null;t.filter(this.getCoordinate())}else if(P(arguments[0],Ut)){var e=arguments[0];if(this.isEmpty())return null;e.filter(this._coordinates,0),e.isGeometryChanged()&&this.geometryChanged()}else(P(arguments[0],jt)||P(arguments[0],lt))&&arguments[0].filter(this)},e.prototype.getBoundary=function(){return this.getFactory().createGeometryCollection(null)},e.prototype.clone=function(){var e=t.prototype.clone.call(this);return e._coordinates=this._coordinates.clone(),e},e.prototype.getGeometryType=function(){return"Point"},e.prototype.copy=function(){return new e(this._coordinates.copy(),this._factory)},e.prototype.getCoordinateSequence=function(){return this._coordinates},e.prototype.getY=function(){if(null===this.getCoordinate())throw new Error("getY called on empty Point");return this.getCoordinate().y},e.prototype.isEmpty=function(){return 0===this._coordinates.size()},e.prototype.init=function(t){null===t&&(t=this.getFactory().getCoordinateSequenceFactory().create([])),et.isTrue(t.size()<=1),this._coordinates=t},e.prototype.isSimple=function(){return!0},e.prototype.interfaces_=function(){return[Jt]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return 0x44077bad161cbc00},Object.defineProperties(e,n),e}(ct),$t=function(){};$t.prototype.interfaces_=function(){return[]},$t.prototype.getClass=function(){return $t};var Qt=function(t){function e(e,n,r){if(t.call(this,r),this._shell=null,this._holes=null,null===e&&(e=this.getFactory().createLinearRing()),null===n&&(n=[]),t.hasNullElements(n))throw new m("holes must not contain null elements");if(e.isEmpty()&&t.hasNonEmptyElements(n))throw new m("shell is empty but holes are not");this._shell=e,this._holes=n}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.computeEnvelopeInternal=function(){return this._shell.getEnvelopeInternal()},e.prototype.getSortIndex=function(){return t.SORTINDEX_POLYGON},e.prototype.getCoordinates=function(){if(this.isEmpty())return[];for(var t=new Array(this.getNumPoints()).fill(null),e=-1,n=this._shell.getCoordinates(),r=0;r<n.length;r++)t[++e]=n[r];for(var i=0;i<this._holes.length;i++)for(var o=this._holes[i].getCoordinates(),s=0;s<o.length;s++)t[++e]=o[s];return t},e.prototype.getArea=function(){var t=0;t+=Math.abs(at.signedArea(this._shell.getCoordinateSequence()));for(var e=0;e<this._holes.length;e++)t-=Math.abs(at.signedArea(this._holes[e].getCoordinateSequence()));return t},e.prototype.isRectangle=function(){if(0!==this.getNumInteriorRing())return!1;if(null===this._shell)return!1;if(5!==this._shell.getNumPoints())return!1;for(var t=this._shell.getCoordinateSequence(),e=this.getEnvelopeInternal(),n=0;n<5;n++){var r=t.getX(n);if(r!==e.getMinX()&&r!==e.getMaxX())return!1;var i=t.getY(n);if(i!==e.getMinY()&&i!==e.getMaxY())return!1}for(var o=t.getX(0),s=t.getY(0),a=1;a<=4;a++){var u=t.getX(a),l=t.getY(a);if(u!==o==(l!==s))return!1;o=u,s=l}return!0},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];if(!this.isEquivalentClass(e))return!1;var r=e,i=this._shell,o=r._shell;if(!i.equalsExact(o,n))return!1;if(this._holes.length!==r._holes.length)return!1;for(var s=0;s<this._holes.length;s++)if(!this._holes[s].equalsExact(r._holes[s],n))return!1;return!0}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.normalize=function(){if(0===arguments.length){this.normalize(this._shell,!0);for(var t=0;t<this._holes.length;t++)this.normalize(this._holes[t],!1);kt.sort(this._holes)}else if(2===arguments.length){var e=arguments[0],n=arguments[1];if(e.isEmpty())return null;var r=new Array(e.getCoordinates().length-1).fill(null);V.arraycopy(e.getCoordinates(),0,r,0,r.length);var i=wt.minCoordinate(e.getCoordinates());wt.scroll(r,i),V.arraycopy(r,0,e.getCoordinates(),0,r.length),e.getCoordinates()[r.length]=r[0],at.isCCW(e.getCoordinates())===n&&wt.reverse(e.getCoordinates())}},e.prototype.getCoordinate=function(){return this._shell.getCoordinate()},e.prototype.getNumInteriorRing=function(){return this._holes.length},e.prototype.getBoundaryDimension=function(){return 1},e.prototype.getDimension=function(){return 2},e.prototype.getLength=function(){var t=0;t+=this._shell.getLength();for(var e=0;e<this._holes.length;e++)t+=this._holes[e].getLength();return t},e.prototype.getNumPoints=function(){for(var t=this._shell.getNumPoints(),e=0;e<this._holes.length;e++)t+=this._holes[e].getNumPoints();return t},e.prototype.reverse=function(){var t=this.copy();t._shell=this._shell.copy().reverse(),t._holes=new Array(this._holes.length).fill(null);for(var e=0;e<this._holes.length;e++)t._holes[e]=this._holes[e].copy().reverse();return t},e.prototype.convexHull=function(){return this.getExteriorRing().convexHull()},e.prototype.compareToSameClass=function(){if(1===arguments.length){var t=arguments[0],e=this._shell,n=t._shell;return e.compareToSameClass(n)}if(2===arguments.length){var r=arguments[1],i=arguments[0],o=this._shell,s=i._shell,a=o.compareToSameClass(s,r);if(0!==a)return a;for(var u=this.getNumInteriorRing(),l=i.getNumInteriorRing(),c=0;c<u&&c<l;){var h=this.getInteriorRingN(c),p=i.getInteriorRingN(c),f=h.compareToSameClass(p,r);if(0!==f)return f;c++}return c<u?1:c<l?-1:0}},e.prototype.apply=function(t){if(P(t,ft)){this._shell.apply(t);for(var e=0;e<this._holes.length;e++)this._holes[e].apply(t)}else if(P(t,Ut)){if(this._shell.apply(t),!t.isDone())for(var n=0;n<this._holes.length&&(this._holes[n].apply(t),!t.isDone());n++);t.isGeometryChanged()&&this.geometryChanged()}else if(P(t,jt))t.filter(this);else if(P(t,lt)){t.filter(this),this._shell.apply(t);for(var r=0;r<this._holes.length;r++)this._holes[r].apply(t)}},e.prototype.getBoundary=function(){if(this.isEmpty())return this.getFactory().createMultiLineString();var t=new Array(this._holes.length+1).fill(null);t[0]=this._shell;for(var e=0;e<this._holes.length;e++)t[e+1]=this._holes[e];return t.length<=1?this.getFactory().createLinearRing(t[0].getCoordinateSequence()):this.getFactory().createMultiLineString(t)},e.prototype.clone=function(){var e=t.prototype.clone.call(this);e._shell=this._shell.clone(),e._holes=new Array(this._holes.length).fill(null);for(var n=0;n<this._holes.length;n++)e._holes[n]=this._holes[n].clone();return e},e.prototype.getGeometryType=function(){return"Polygon"},e.prototype.copy=function(){for(var t=this._shell.copy(),n=new Array(this._holes.length).fill(null),r=0;r<n.length;r++)n[r]=this._holes[r].copy();return new e(t,n,this._factory)},e.prototype.getExteriorRing=function(){return this._shell},e.prototype.isEmpty=function(){return this._shell.isEmpty()},e.prototype.getInteriorRingN=function(t){return this._holes[t]},e.prototype.interfaces_=function(){return[$t]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return-0x307ffefd8dc97200},Object.defineProperties(e,n),e}(ct),te=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.getSortIndex=function(){return ct.SORTINDEX_MULTIPOINT},e.prototype.isValid=function(){return!0},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];return!!this.isEquivalentClass(e)&&t.prototype.equalsExact.call(this,e,n)}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.getCoordinate=function(){if(1===arguments.length){var e=arguments[0];return this._geometries[e].getCoordinate()}return t.prototype.getCoordinate.apply(this,arguments)},e.prototype.getBoundaryDimension=function(){return Gt.FALSE},e.prototype.getDimension=function(){return 0},e.prototype.getBoundary=function(){return this.getFactory().createGeometryCollection(null)},e.prototype.getGeometryType=function(){return"MultiPoint"},e.prototype.copy=function(){for(var t=new Array(this._geometries.length).fill(null),n=0;n<t.length;n++)t[n]=this._geometries[n].copy();return new e(t,this._factory)},e.prototype.interfaces_=function(){return[Jt]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return-0x6fb1ed4162e0fc00},Object.defineProperties(e,n),e}(qt),ee=function(t){function e(e,n){e instanceof C&&n instanceof _e&&(e=n.getCoordinateSequenceFactory().create(e)),t.call(this,e,n),this.validateConstruction()}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={MINIMUM_VALID_SIZE:{configurable:!0},serialVersionUID:{configurable:!0}};return e.prototype.getSortIndex=function(){return ct.SORTINDEX_LINEARRING},e.prototype.getBoundaryDimension=function(){return Gt.FALSE},e.prototype.isClosed=function(){return!!this.isEmpty()||t.prototype.isClosed.call(this)},e.prototype.reverse=function(){var t=this._points.copy();return Ht.reverse(t),this.getFactory().createLinearRing(t)},e.prototype.validateConstruction=function(){if(!this.isEmpty()&&!t.prototype.isClosed.call(this))throw new m("Points of LinearRing do not form a closed linestring");if(this.getCoordinateSequence().size()>=1&&this.getCoordinateSequence().size()<e.MINIMUM_VALID_SIZE)throw new m("Invalid number of points in LinearRing (found "+this.getCoordinateSequence().size()+" - must be 0 or >= 4)")},e.prototype.getGeometryType=function(){return"LinearRing"},e.prototype.copy=function(){return new e(this._points.copy(),this._factory)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},n.MINIMUM_VALID_SIZE.get=function(){return 4},n.serialVersionUID.get=function(){return-0x3b229e262367a600},Object.defineProperties(e,n),e}(Kt),ne=function(t){function e(){t.apply(this,arguments)}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={serialVersionUID:{configurable:!0}};return e.prototype.getSortIndex=function(){return ct.SORTINDEX_MULTIPOLYGON},e.prototype.equalsExact=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];return!!this.isEquivalentClass(e)&&t.prototype.equalsExact.call(this,e,n)}return t.prototype.equalsExact.apply(this,arguments)},e.prototype.getBoundaryDimension=function(){return 1},e.prototype.getDimension=function(){return 2},e.prototype.reverse=function(){for(var t=this._geometries.length,e=new Array(t).fill(null),n=0;n<this._geometries.length;n++)e[n]=this._geometries[n].reverse();return this.getFactory().createMultiPolygon(e)},e.prototype.getBoundary=function(){if(this.isEmpty())return this.getFactory().createMultiLineString();for(var t=new It,e=0;e<this._geometries.length;e++)for(var n=this._geometries[e].getBoundary(),r=0;r<n.getNumGeometries();r++)t.add(n.getGeometryN(r));var i=new Array(t.size()).fill(null);return this.getFactory().createMultiLineString(t.toArray(i))},e.prototype.getGeometryType=function(){return"MultiPolygon"},e.prototype.copy=function(){for(var t=new Array(this._geometries.length).fill(null),n=0;n<t.length;n++)t[n]=this._geometries[n].copy();return new e(t,this._factory)},e.prototype.interfaces_=function(){return[$t]},e.prototype.getClass=function(){return e},n.serialVersionUID.get=function(){return-0x7a5aa1369171980},Object.defineProperties(e,n),e}(qt),re=function(t){this._factory=t||null,this._isUserDataCopied=!1},ie={NoOpGeometryOperation:{configurable:!0},CoordinateOperation:{configurable:!0},CoordinateSequenceOperation:{configurable:!0}};re.prototype.setCopyUserData=function(t){this._isUserDataCopied=t},re.prototype.edit=function(t,e){if(null===t)return null;var n=this.editInternal(t,e);return this._isUserDataCopied&&n.setUserData(t.getUserData()),n},re.prototype.editInternal=function(t,e){return null===this._factory&&(this._factory=t.getFactory()),t instanceof qt?this.editGeometryCollection(t,e):t instanceof Qt?this.editPolygon(t,e):t instanceof Zt||t instanceof Kt?e.edit(t,this._factory):(et.shouldNeverReachHere("Unsupported Geometry class: "+t.getClass().getName()),null)},re.prototype.editGeometryCollection=function(t,e){for(var n=e.edit(t,this._factory),r=new It,i=0;i<n.getNumGeometries();i++){var o=this.edit(n.getGeometryN(i),e);null===o||o.isEmpty()||r.add(o)}return n.getClass()===te?this._factory.createMultiPoint(r.toArray([])):n.getClass()===zt?this._factory.createMultiLineString(r.toArray([])):n.getClass()===ne?this._factory.createMultiPolygon(r.toArray([])):this._factory.createGeometryCollection(r.toArray([]))},re.prototype.editPolygon=function(t,e){var n=e.edit(t,this._factory);if(null===n&&(n=this._factory.createPolygon(null)),n.isEmpty())return n;var r=this.edit(n.getExteriorRing(),e);if(null===r||r.isEmpty())return this._factory.createPolygon();for(var i=new It,o=0;o<n.getNumInteriorRing();o++){var s=this.edit(n.getInteriorRingN(o),e);null===s||s.isEmpty()||i.add(s)}return this._factory.createPolygon(r,i.toArray([]))},re.prototype.interfaces_=function(){return[]},re.prototype.getClass=function(){return re},re.GeometryEditorOperation=function(){},ie.NoOpGeometryOperation.get=function(){return oe},ie.CoordinateOperation.get=function(){return se},ie.CoordinateSequenceOperation.get=function(){return ae},Object.defineProperties(re,ie);var oe=function(){};oe.prototype.edit=function(t,e){return t},oe.prototype.interfaces_=function(){return[re.GeometryEditorOperation]},oe.prototype.getClass=function(){return oe};var se=function(){};se.prototype.edit=function(t,e){var n=this.editCoordinates(t.getCoordinates(),t);return null===n?t:t instanceof ee?e.createLinearRing(n):t instanceof Kt?e.createLineString(n):t instanceof Zt?n.length>0?e.createPoint(n[0]):e.createPoint():t},se.prototype.interfaces_=function(){return[re.GeometryEditorOperation]},se.prototype.getClass=function(){return se};var ae=function(){};ae.prototype.edit=function(t,e){return t instanceof ee?e.createLinearRing(this.edit(t.getCoordinateSequence(),t)):t instanceof Kt?e.createLineString(this.edit(t.getCoordinateSequence(),t)):t instanceof Zt?e.createPoint(this.edit(t.getCoordinateSequence(),t)):t},ae.prototype.interfaces_=function(){return[re.GeometryEditorOperation]},ae.prototype.getClass=function(){return ae};var ue=function(){if(this._dimension=3,this._coordinates=null,1===arguments.length){if(arguments[0]instanceof Array)this._coordinates=arguments[0],this._dimension=3;else if(Number.isInteger(arguments[0])){var t=arguments[0];this._coordinates=new Array(t).fill(null);for(var e=0;e<t;e++)this._coordinates[e]=new C}else if(P(arguments[0],j)){var n=arguments[0];if(null===n)return this._coordinates=new Array(0).fill(null),null;this._dimension=n.getDimension(),this._coordinates=new Array(n.size()).fill(null);for(var r=0;r<this._coordinates.length;r++)this._coordinates[r]=n.getCoordinateCopy(r)}}else if(2===arguments.length)if(arguments[0]instanceof Array&&Number.isInteger(arguments[1])){var i=arguments[0],o=arguments[1];this._coordinates=i,this._dimension=o,null===i&&(this._coordinates=new Array(0).fill(null))}else if(Number.isInteger(arguments[0])&&Number.isInteger(arguments[1])){var s=arguments[0],a=arguments[1];this._coordinates=new Array(s).fill(null),this._dimension=a;for(var u=0;u<s;u++)this._coordinates[u]=new C}},le={serialVersionUID:{configurable:!0}};ue.prototype.setOrdinate=function(t,e,n){switch(e){case j.X:this._coordinates[t].x=n;break;case j.Y:this._coordinates[t].y=n;break;case j.Z:this._coordinates[t].z=n;break;default:throw new m("invalid ordinateIndex")}},ue.prototype.size=function(){return this._coordinates.length},ue.prototype.getOrdinate=function(t,e){switch(e){case j.X:return this._coordinates[t].x;case j.Y:return this._coordinates[t].y;case j.Z:return this._coordinates[t].z}return v.NaN},ue.prototype.getCoordinate=function(){if(1===arguments.length){var t=arguments[0];return this._coordinates[t]}if(2===arguments.length){var e=arguments[0],n=arguments[1];n.x=this._coordinates[e].x,n.y=this._coordinates[e].y,n.z=this._coordinates[e].z}},ue.prototype.getCoordinateCopy=function(t){return new C(this._coordinates[t])},ue.prototype.getDimension=function(){return this._dimension},ue.prototype.getX=function(t){return this._coordinates[t].x},ue.prototype.clone=function(){for(var t=new Array(this.size()).fill(null),e=0;e<this._coordinates.length;e++)t[e]=this._coordinates[e].clone();return new ue(t,this._dimension)},ue.prototype.expandEnvelope=function(t){for(var e=0;e<this._coordinates.length;e++)t.expandToInclude(this._coordinates[e]);return t},ue.prototype.copy=function(){for(var t=new Array(this.size()).fill(null),e=0;e<this._coordinates.length;e++)t[e]=this._coordinates[e].copy();return new ue(t,this._dimension)},ue.prototype.toString=function(){if(this._coordinates.length>0){var t=new T(17*this._coordinates.length);t.append("("),t.append(this._coordinates[0]);for(var e=1;e<this._coordinates.length;e++)t.append(", "),t.append(this._coordinates[e]);return t.append(")"),t.toString()}return"()"},ue.prototype.getY=function(t){return this._coordinates[t].y},ue.prototype.toCoordinateArray=function(){return this._coordinates},ue.prototype.interfaces_=function(){return[j,e]},ue.prototype.getClass=function(){return ue},le.serialVersionUID.get=function(){return-0xcb44a778db18e00},Object.defineProperties(ue,le);var ce=function(){},he={serialVersionUID:{configurable:!0},instanceObject:{configurable:!0}};ce.prototype.readResolve=function(){return ce.instance()},ce.prototype.create=function(){if(1===arguments.length){if(arguments[0]instanceof Array)return new ue(arguments[0]);if(P(arguments[0],j))return new ue(arguments[0])}else if(2===arguments.length){var t=arguments[0],e=arguments[1];return e>3&&(e=3),e<2?new ue(t):new ue(t,e)}},ce.prototype.interfaces_=function(){return[N,e]},ce.prototype.getClass=function(){return ce},ce.instance=function(){return ce.instanceObject},he.serialVersionUID.get=function(){return-0x38e49fa6cf6f2e00},he.instanceObject.get=function(){return new ce},Object.defineProperties(ce,he);var pe=function(t){function e(){t.call(this),this.map_=new Map}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.get=function(t){return this.map_.get(t)||null},e.prototype.put=function(t,e){return this.map_.set(t,e),e},e.prototype.values=function(){for(var t=new It,e=this.map_.values(),n=e.next();!n.done;)t.add(n.value),n=e.next();return t},e.prototype.entrySet=function(){var t=new Rt;return this.map_.entries().forEach((function(e){return t.add(e)})),t},e.prototype.size=function(){return this.map_.size()},e}(Pt),fe=function t(){if(this._modelType=null,this._scale=null,0===arguments.length)this._modelType=t.FLOATING;else if(1===arguments.length)if(arguments[0]instanceof de){var e=arguments[0];this._modelType=e,e===t.FIXED&&this.setScale(1)}else if("number"==typeof arguments[0]){var n=arguments[0];this._modelType=t.FIXED,this.setScale(n)}else if(arguments[0]instanceof t){var r=arguments[0];this._modelType=r._modelType,this._scale=r._scale}},ge={serialVersionUID:{configurable:!0},maximumPreciseValue:{configurable:!0}};fe.prototype.equals=function(t){if(!(t instanceof fe))return!1;var e=t;return this._modelType===e._modelType&&this._scale===e._scale},fe.prototype.compareTo=function(t){var e=t,n=this.getMaximumSignificantDigits(),r=e.getMaximumSignificantDigits();return new A(n).compareTo(new A(r))},fe.prototype.getScale=function(){return this._scale},fe.prototype.isFloating=function(){return this._modelType===fe.FLOATING||this._modelType===fe.FLOATING_SINGLE},fe.prototype.getType=function(){return this._modelType},fe.prototype.toString=function(){var t="UNKNOWN";return this._modelType===fe.FLOATING?t="Floating":this._modelType===fe.FLOATING_SINGLE?t="Floating-Single":this._modelType===fe.FIXED&&(t="Fixed (Scale="+this.getScale()+")"),t},fe.prototype.makePrecise=function(){if("number"==typeof arguments[0]){var t=arguments[0];return v.isNaN(t)||this._modelType===fe.FLOATING_SINGLE?t:this._modelType===fe.FIXED?Math.round(t*this._scale)/this._scale:t}if(arguments[0]instanceof C){var e=arguments[0];if(this._modelType===fe.FLOATING)return null;e.x=this.makePrecise(e.x),e.y=this.makePrecise(e.y)}},fe.prototype.getMaximumSignificantDigits=function(){var t=16;return this._modelType===fe.FLOATING?t=16:this._modelType===fe.FLOATING_SINGLE?t=6:this._modelType===fe.FIXED&&(t=1+Math.trunc(Math.ceil(Math.log(this.getScale())/Math.log(10)))),t},fe.prototype.setScale=function(t){this._scale=Math.abs(t)},fe.prototype.interfaces_=function(){return[e,b]},fe.prototype.getClass=function(){return fe},fe.mostPrecise=function(t,e){return t.compareTo(e)>=0?t:e},ge.serialVersionUID.get=function(){return 0x6bee6404e9a25c00},ge.maximumPreciseValue.get=function(){return 9007199254740992},Object.defineProperties(fe,ge);var de=function t(e){this._name=e||null,t.nameToTypeMap.put(e,this)},ye={serialVersionUID:{configurable:!0},nameToTypeMap:{configurable:!0}};de.prototype.readResolve=function(){return de.nameToTypeMap.get(this._name)},de.prototype.toString=function(){return this._name},de.prototype.interfaces_=function(){return[e]},de.prototype.getClass=function(){return de},ye.serialVersionUID.get=function(){return-552860263173159e4},ye.nameToTypeMap.get=function(){return new pe},Object.defineProperties(de,ye),fe.Type=de,fe.FIXED=new de("FIXED"),fe.FLOATING=new de("FLOATING"),fe.FLOATING_SINGLE=new de("FLOATING SINGLE");var _e=function t(){this._precisionModel=new fe,this._SRID=0,this._coordinateSequenceFactory=t.getDefaultCoordinateSequenceFactory(),0===arguments.length||(1===arguments.length?P(arguments[0],N)?this._coordinateSequenceFactory=arguments[0]:arguments[0]instanceof fe&&(this._precisionModel=arguments[0]):2===arguments.length?(this._precisionModel=arguments[0],this._SRID=arguments[1]):3===arguments.length&&(this._precisionModel=arguments[0],this._SRID=arguments[1],this._coordinateSequenceFactory=arguments[2]))},me={serialVersionUID:{configurable:!0}};_e.prototype.toGeometry=function(t){return t.isNull()?this.createPoint(null):t.getMinX()===t.getMaxX()&&t.getMinY()===t.getMaxY()?this.createPoint(new C(t.getMinX(),t.getMinY())):t.getMinX()===t.getMaxX()||t.getMinY()===t.getMaxY()?this.createLineString([new C(t.getMinX(),t.getMinY()),new C(t.getMaxX(),t.getMaxY())]):this.createPolygon(this.createLinearRing([new C(t.getMinX(),t.getMinY()),new C(t.getMinX(),t.getMaxY()),new C(t.getMaxX(),t.getMaxY()),new C(t.getMaxX(),t.getMinY()),new C(t.getMinX(),t.getMinY())]),null)},_e.prototype.createLineString=function(t){return t?t instanceof Array?new Kt(this.getCoordinateSequenceFactory().create(t),this):P(t,j)?new Kt(t,this):void 0:new Kt(this.getCoordinateSequenceFactory().create([]),this)},_e.prototype.createMultiLineString=function(){return 0===arguments.length?new zt(null,this):1===arguments.length?new zt(arguments[0],this):void 0},_e.prototype.buildGeometry=function(t){for(var e=null,n=!1,r=!1,i=t.iterator();i.hasNext();){var o=i.next(),s=o.getClass();null===e&&(e=s),s!==e&&(n=!0),o.isGeometryCollectionOrDerived()&&(r=!0)}if(null===e)return this.createGeometryCollection();if(n||r)return this.createGeometryCollection(_e.toGeometryArray(t));var a=t.iterator().next();if(t.size()>1){if(a instanceof Qt)return this.createMultiPolygon(_e.toPolygonArray(t));if(a instanceof Kt)return this.createMultiLineString(_e.toLineStringArray(t));if(a instanceof Zt)return this.createMultiPoint(_e.toPointArray(t));et.shouldNeverReachHere("Unhandled class: "+a.getClass().getName())}return a},_e.prototype.createMultiPointFromCoords=function(t){return this.createMultiPoint(null!==t?this.getCoordinateSequenceFactory().create(t):null)},_e.prototype.createPoint=function(){if(0===arguments.length)return this.createPoint(this.getCoordinateSequenceFactory().create([]));if(1===arguments.length){if(arguments[0]instanceof C){var t=arguments[0];return this.createPoint(null!==t?this.getCoordinateSequenceFactory().create([t]):null)}if(P(arguments[0],j))return new Zt(arguments[0],this)}},_e.prototype.getCoordinateSequenceFactory=function(){return this._coordinateSequenceFactory},_e.prototype.createPolygon=function(){if(0===arguments.length)return new Qt(null,null,this);if(1===arguments.length){if(P(arguments[0],j)){var t=arguments[0];return this.createPolygon(this.createLinearRing(t))}if(arguments[0]instanceof Array){var e=arguments[0];return this.createPolygon(this.createLinearRing(e))}if(arguments[0]instanceof ee){var n=arguments[0];return this.createPolygon(n,null)}}else if(2===arguments.length)return new Qt(arguments[0],arguments[1],this)},_e.prototype.getSRID=function(){return this._SRID},_e.prototype.createGeometryCollection=function(){return 0===arguments.length?new qt(null,this):1===arguments.length?new qt(arguments[0],this):void 0},_e.prototype.createGeometry=function(t){return new re(this).edit(t,{edit:function(){if(2===arguments.length){var t=arguments[0];return this._coordinateSequenceFactory.create(t)}}})},_e.prototype.getPrecisionModel=function(){return this._precisionModel},_e.prototype.createLinearRing=function(){if(0===arguments.length)return this.createLinearRing(this.getCoordinateSequenceFactory().create([]));if(1===arguments.length){if(arguments[0]instanceof Array){var t=arguments[0];return this.createLinearRing(null!==t?this.getCoordinateSequenceFactory().create(t):null)}if(P(arguments[0],j))return new ee(arguments[0],this)}},_e.prototype.createMultiPolygon=function(){return 0===arguments.length?new ne(null,this):1===arguments.length?new ne(arguments[0],this):void 0},_e.prototype.createMultiPoint=function(){if(0===arguments.length)return new te(null,this);if(1===arguments.length){if(arguments[0]instanceof Array)return new te(arguments[0],this);if(arguments[0]instanceof Array){var t=arguments[0];return this.createMultiPoint(null!==t?this.getCoordinateSequenceFactory().create(t):null)}if(P(arguments[0],j)){var e=arguments[0];if(null===e)return this.createMultiPoint(new Array(0).fill(null));for(var n=new Array(e.size()).fill(null),r=0;r<e.size();r++){var i=this.getCoordinateSequenceFactory().create(1,e.getDimension());Ht.copy(e,r,i,0,1),n[r]=this.createPoint(i)}return this.createMultiPoint(n)}}},_e.prototype.interfaces_=function(){return[e]},_e.prototype.getClass=function(){return _e},_e.toMultiPolygonArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.toGeometryArray=function(t){if(null===t)return null;var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.getDefaultCoordinateSequenceFactory=function(){return ce.instance()},_e.toMultiLineStringArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.toLineStringArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.toMultiPointArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.toLinearRingArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.toPointArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.toPolygonArray=function(t){var e=new Array(t.size()).fill(null);return t.toArray(e)},_e.createPointFromInternalCoord=function(t,e){return e.getPrecisionModel().makePrecise(t),e.getFactory().createPoint(t)},me.serialVersionUID.get=function(){return-0x5ea75f2051eeb400},Object.defineProperties(_e,me);var ve=["Point","MultiPoint","LineString","MultiLineString","Polygon","MultiPolygon"],xe=function(t){this.geometryFactory=t||new _e};xe.prototype.read=function(t){var e,n=(e="string"==typeof t?JSON.parse(t):t).type;if(!be[n])throw new Error("Unknown GeoJSON type: "+e.type);return-1!==ve.indexOf(n)?be[n].apply(this,[e.coordinates]):"GeometryCollection"===n?be[n].apply(this,[e.geometries]):be[n].apply(this,[e])},xe.prototype.write=function(t){var e=t.getGeometryType();if(!Ee[e])throw new Error("Geometry is not supported");return Ee[e].apply(this,[t])};var be={Feature:function(t){var e={};for(var n in t)e[n]=t[n];if(t.geometry){var r=t.geometry.type;if(!be[r])throw new Error("Unknown GeoJSON type: "+t.type);e.geometry=this.read(t.geometry)}return t.bbox&&(e.bbox=be.bbox.apply(this,[t.bbox])),e},FeatureCollection:function(t){var e={};if(t.features){e.features=[];for(var n=0;n<t.features.length;++n)e.features.push(this.read(t.features[n]))}return t.bbox&&(e.bbox=this.parse.bbox.apply(this,[t.bbox])),e},coordinates:function(t){for(var e=[],n=0;n<t.length;++n){var r=t[n];e.push(new C(r[0],r[1]))}return e},bbox:function(t){return this.geometryFactory.createLinearRing([new C(t[0],t[1]),new C(t[2],t[1]),new C(t[2],t[3]),new C(t[0],t[3]),new C(t[0],t[1])])},Point:function(t){var e=new C(t[0],t[1]);return this.geometryFactory.createPoint(e)},MultiPoint:function(t){for(var e=[],n=0;n<t.length;++n)e.push(be.Point.apply(this,[t[n]]));return this.geometryFactory.createMultiPoint(e)},LineString:function(t){var e=be.coordinates.apply(this,[t]);return this.geometryFactory.createLineString(e)},MultiLineString:function(t){for(var e=[],n=0;n<t.length;++n)e.push(be.LineString.apply(this,[t[n]]));return this.geometryFactory.createMultiLineString(e)},Polygon:function(t){for(var e=be.coordinates.apply(this,[t[0]]),n=this.geometryFactory.createLinearRing(e),r=[],i=1;i<t.length;++i){var o=t[i],s=be.coordinates.apply(this,[o]),a=this.geometryFactory.createLinearRing(s);r.push(a)}return this.geometryFactory.createPolygon(n,r)},MultiPolygon:function(t){for(var e=[],n=0;n<t.length;++n){var r=t[n];e.push(be.Polygon.apply(this,[r]))}return this.geometryFactory.createMultiPolygon(e)},GeometryCollection:function(t){for(var e=[],n=0;n<t.length;++n){var r=t[n];e.push(this.read(r))}return this.geometryFactory.createGeometryCollection(e)}},Ee={coordinate:function(t){return[t.x,t.y]},Point:function(t){return{type:"Point",coordinates:Ee.coordinate.apply(this,[t.getCoordinate()])}},MultiPoint:function(t){for(var e=[],n=0;n<t._geometries.length;++n){var r=t._geometries[n],i=Ee.Point.apply(this,[r]);e.push(i.coordinates)}return{type:"MultiPoint",coordinates:e}},LineString:function(t){for(var e=[],n=t.getCoordinates(),r=0;r<n.length;++r){var i=n[r];e.push(Ee.coordinate.apply(this,[i]))}return{type:"LineString",coordinates:e}},MultiLineString:function(t){for(var e=[],n=0;n<t._geometries.length;++n){var r=t._geometries[n],i=Ee.LineString.apply(this,[r]);e.push(i.coordinates)}return{type:"MultiLineString",coordinates:e}},Polygon:function(t){var e=[],n=Ee.LineString.apply(this,[t._shell]);e.push(n.coordinates);for(var r=0;r<t._holes.length;++r){var i=t._holes[r],o=Ee.LineString.apply(this,[i]);e.push(o.coordinates)}return{type:"Polygon",coordinates:e}},MultiPolygon:function(t){for(var e=[],n=0;n<t._geometries.length;++n){var r=t._geometries[n],i=Ee.Polygon.apply(this,[r]);e.push(i.coordinates)}return{type:"MultiPolygon",coordinates:e}},GeometryCollection:function(t){for(var e=[],n=0;n<t._geometries.length;++n){var r=t._geometries[n],i=r.getGeometryType();e.push(Ee[i].apply(this,[r]))}return{type:"GeometryCollection",geometries:e}}},Ie=function(t){this.geometryFactory=t||new _e,this.precisionModel=this.geometryFactory.getPrecisionModel(),this.parser=new xe(this.geometryFactory)};Ie.prototype.read=function(t){var e=this.parser.read(t);return this.precisionModel.getType()===fe.FIXED&&this.reducePrecision(e),e},Ie.prototype.reducePrecision=function(t){var e,n;if(t.coordinate)this.precisionModel.makePrecise(t.coordinate);else if(t.points)for(e=0,n=t.points.length;e<n;e++)this.precisionModel.makePrecise(t.points[e]);else if(t.geometries)for(e=0,n=t.geometries.length;e<n;e++)this.reducePrecision(t.geometries[e])};var Ce=function(){this.parser=new xe(this.geometryFactory)};Ce.prototype.write=function(t){return this.parser.write(t)};var Se=function(){},we={ON:{configurable:!0},LEFT:{configurable:!0},RIGHT:{configurable:!0}};Se.prototype.interfaces_=function(){return[]},Se.prototype.getClass=function(){return Se},Se.opposite=function(t){return t===Se.LEFT?Se.RIGHT:t===Se.RIGHT?Se.LEFT:t},we.ON.get=function(){return 0},we.LEFT.get=function(){return 1},we.RIGHT.get=function(){return 2},Object.defineProperties(Se,we),(d.prototype=new Error).name="EmptyStackException",(y.prototype=new Et).add=function(t){return this.array_.push(t),!0},y.prototype.get=function(t){if(t<0||t>=this.size())throw new Error;return this.array_[t]},y.prototype.push=function(t){return this.array_.push(t),t},y.prototype.pop=function(t){if(0===this.array_.length)throw new d;return this.array_.pop()},y.prototype.peek=function(){if(0===this.array_.length)throw new d;return this.array_[this.array_.length-1]},y.prototype.empty=function(){return 0===this.array_.length},y.prototype.isEmpty=function(){return this.empty()},y.prototype.search=function(t){return this.array_.indexOf(t)},y.prototype.size=function(){return this.array_.length},y.prototype.toArray=function(){for(var t=[],e=0,n=this.array_.length;e<n;e++)t.push(this.array_[e]);return t};var Ne=function(){this._minIndex=-1,this._minCoord=null,this._minDe=null,this._orientedDe=null};Ne.prototype.getCoordinate=function(){return this._minCoord},Ne.prototype.getRightmostSide=function(t,e){var n=this.getRightmostSideOfSegment(t,e);return n<0&&(n=this.getRightmostSideOfSegment(t,e-1)),n<0&&(this._minCoord=null,this.checkForRightmostCoordinate(t)),n},Ne.prototype.findRightmostEdgeAtVertex=function(){var t=this._minDe.getEdge().getCoordinates();et.isTrue(this._minIndex>0&&this._minIndex<t.length,"rightmost point expected to be interior vertex of edge");var e=t[this._minIndex-1],n=t[this._minIndex+1],r=at.computeOrientation(this._minCoord,n,e),i=!1;(e.y<this._minCoord.y&&n.y<this._minCoord.y&&r===at.COUNTERCLOCKWISE||e.y>this._minCoord.y&&n.y>this._minCoord.y&&r===at.CLOCKWISE)&&(i=!0),i&&(this._minIndex=this._minIndex-1)},Ne.prototype.getRightmostSideOfSegment=function(t,e){var n=t.getEdge().getCoordinates();if(e<0||e+1>=n.length)return-1;if(n[e].y===n[e+1].y)return-1;var r=Se.LEFT;return n[e].y<n[e+1].y&&(r=Se.RIGHT),r},Ne.prototype.getEdge=function(){return this._orientedDe},Ne.prototype.checkForRightmostCoordinate=function(t){for(var e=t.getEdge().getCoordinates(),n=0;n<e.length-1;n++)(null===this._minCoord||e[n].x>this._minCoord.x)&&(this._minDe=t,this._minIndex=n,this._minCoord=e[n])},Ne.prototype.findRightmostEdgeAtNode=function(){var t=this._minDe.getNode().getEdges();this._minDe=t.getRightmostEdge(),this._minDe.isForward()||(this._minDe=this._minDe.getSym(),this._minIndex=this._minDe.getEdge().getCoordinates().length-1)},Ne.prototype.findEdge=function(t){for(var e=t.iterator();e.hasNext();){var n=e.next();n.isForward()&&this.checkForRightmostCoordinate(n)}et.isTrue(0!==this._minIndex||this._minCoord.equals(this._minDe.getCoordinate()),"inconsistency in rightmost processing"),0===this._minIndex?this.findRightmostEdgeAtNode():this.findRightmostEdgeAtVertex(),this._orientedDe=this._minDe,this.getRightmostSide(this._minDe,this._minIndex)===Se.LEFT&&(this._orientedDe=this._minDe.getSym())},Ne.prototype.interfaces_=function(){return[]},Ne.prototype.getClass=function(){return Ne};var Me=function(t){function e(n,r){t.call(this,e.msgWithCoord(n,r)),this.pt=r?new C(r):null,this.name="TopologyException"}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.getCoordinate=function(){return this.pt},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e.msgWithCoord=function(t,e){return e?t:t+" [ "+e+" ]"},e}(Q),Le=function(){this.array_=[]};Le.prototype.addLast=function(t){this.array_.push(t)},Le.prototype.removeFirst=function(){return this.array_.shift()},Le.prototype.isEmpty=function(){return 0===this.array_.length};var Pe=function(){this._finder=null,this._dirEdgeList=new It,this._nodes=new It,this._rightMostCoord=null,this._env=null,this._finder=new Ne};Pe.prototype.clearVisitedEdges=function(){for(var t=this._dirEdgeList.iterator();t.hasNext();)t.next().setVisited(!1)},Pe.prototype.getRightmostCoordinate=function(){return this._rightMostCoord},Pe.prototype.computeNodeDepth=function(t){for(var e=null,n=t.getEdges().iterator();n.hasNext();){var r=n.next();if(r.isVisited()||r.getSym().isVisited()){e=r;break}}if(null===e)throw new Me("unable to find edge to compute depths at "+t.getCoordinate());t.getEdges().computeDepths(e);for(var i=t.getEdges().iterator();i.hasNext();){var o=i.next();o.setVisited(!0),this.copySymDepths(o)}},Pe.prototype.computeDepth=function(t){this.clearVisitedEdges();var e=this._finder.getEdge();e.setEdgeDepths(Se.RIGHT,t),this.copySymDepths(e),this.computeDepths(e)},Pe.prototype.create=function(t){this.addReachable(t),this._finder.findEdge(this._dirEdgeList),this._rightMostCoord=this._finder.getCoordinate()},Pe.prototype.findResultEdges=function(){for(var t=this._dirEdgeList.iterator();t.hasNext();){var e=t.next();e.getDepth(Se.RIGHT)>=1&&e.getDepth(Se.LEFT)<=0&&!e.isInteriorAreaEdge()&&e.setInResult(!0)}},Pe.prototype.computeDepths=function(t){var e=new Rt,n=new Le,r=t.getNode();for(n.addLast(r),e.add(r),t.setVisited(!0);!n.isEmpty();){var i=n.removeFirst();e.add(i),this.computeNodeDepth(i);for(var o=i.getEdges().iterator();o.hasNext();){var s=o.next().getSym();if(!s.isVisited()){var a=s.getNode();e.contains(a)||(n.addLast(a),e.add(a))}}}},Pe.prototype.compareTo=function(t){var e=t;return this._rightMostCoord.x<e._rightMostCoord.x?-1:this._rightMostCoord.x>e._rightMostCoord.x?1:0},Pe.prototype.getEnvelope=function(){if(null===this._env){for(var t=new X,e=this._dirEdgeList.iterator();e.hasNext();)for(var n=e.next().getEdge().getCoordinates(),r=0;r<n.length-1;r++)t.expandToInclude(n[r]);this._env=t}return this._env},Pe.prototype.addReachable=function(t){var e=new y;for(e.add(t);!e.empty();){var n=e.pop();this.add(n,e)}},Pe.prototype.copySymDepths=function(t){var e=t.getSym();e.setDepth(Se.LEFT,t.getDepth(Se.RIGHT)),e.setDepth(Se.RIGHT,t.getDepth(Se.LEFT))},Pe.prototype.add=function(t,e){t.setVisited(!0),this._nodes.add(t);for(var n=t.getEdges().iterator();n.hasNext();){var r=n.next();this._dirEdgeList.add(r);var i=r.getSym().getNode();i.isVisited()||e.push(i)}},Pe.prototype.getNodes=function(){return this._nodes},Pe.prototype.getDirectedEdges=function(){return this._dirEdgeList},Pe.prototype.interfaces_=function(){return[b]},Pe.prototype.getClass=function(){return Pe};var Oe=function t(){if(this.location=null,1===arguments.length){if(arguments[0]instanceof Array){var e=arguments[0];this.init(e.length)}else if(Number.isInteger(arguments[0])){var n=arguments[0];this.init(1),this.location[Se.ON]=n}else if(arguments[0]instanceof t){var r=arguments[0];if(this.init(r.location.length),null!==r)for(var i=0;i<this.location.length;i++)this.location[i]=r.location[i]}}else if(3===arguments.length){var o=arguments[0],s=arguments[1],a=arguments[2];this.init(3),this.location[Se.ON]=o,this.location[Se.LEFT]=s,this.location[Se.RIGHT]=a}};Oe.prototype.setAllLocations=function(t){for(var e=0;e<this.location.length;e++)this.location[e]=t},Oe.prototype.isNull=function(){for(var t=0;t<this.location.length;t++)if(this.location[t]!==M.NONE)return!1;return!0},Oe.prototype.setAllLocationsIfNull=function(t){for(var e=0;e<this.location.length;e++)this.location[e]===M.NONE&&(this.location[e]=t)},Oe.prototype.isLine=function(){return 1===this.location.length},Oe.prototype.merge=function(t){if(t.location.length>this.location.length){var e=new Array(3).fill(null);e[Se.ON]=this.location[Se.ON],e[Se.LEFT]=M.NONE,e[Se.RIGHT]=M.NONE,this.location=e}for(var n=0;n<this.location.length;n++)this.location[n]===M.NONE&&n<t.location.length&&(this.location[n]=t.location[n])},Oe.prototype.getLocations=function(){return this.location},Oe.prototype.flip=function(){if(this.location.length<=1)return null;var t=this.location[Se.LEFT];this.location[Se.LEFT]=this.location[Se.RIGHT],this.location[Se.RIGHT]=t},Oe.prototype.toString=function(){var t=new T;return this.location.length>1&&t.append(M.toLocationSymbol(this.location[Se.LEFT])),t.append(M.toLocationSymbol(this.location[Se.ON])),this.location.length>1&&t.append(M.toLocationSymbol(this.location[Se.RIGHT])),t.toString()},Oe.prototype.setLocations=function(t,e,n){this.location[Se.ON]=t,this.location[Se.LEFT]=e,this.location[Se.RIGHT]=n},Oe.prototype.get=function(t){return t<this.location.length?this.location[t]:M.NONE},Oe.prototype.isArea=function(){return this.location.length>1},Oe.prototype.isAnyNull=function(){for(var t=0;t<this.location.length;t++)if(this.location[t]===M.NONE)return!0;return!1},Oe.prototype.setLocation=function(){if(1===arguments.length){var t=arguments[0];this.setLocation(Se.ON,t)}else if(2===arguments.length){var e=arguments[0],n=arguments[1];this.location[e]=n}},Oe.prototype.init=function(t){this.location=new Array(t).fill(null),this.setAllLocations(M.NONE)},Oe.prototype.isEqualOnSide=function(t,e){return this.location[e]===t.location[e]},Oe.prototype.allPositionsEqual=function(t){for(var e=0;e<this.location.length;e++)if(this.location[e]!==t)return!1;return!0},Oe.prototype.interfaces_=function(){return[]},Oe.prototype.getClass=function(){return Oe};var Re=function t(){if(this.elt=new Array(2).fill(null),1===arguments.length){if(Number.isInteger(arguments[0])){var e=arguments[0];this.elt[0]=new Oe(e),this.elt[1]=new Oe(e)}else if(arguments[0]instanceof t){var n=arguments[0];this.elt[0]=new Oe(n.elt[0]),this.elt[1]=new Oe(n.elt[1])}}else if(2===arguments.length){var r=arguments[0],i=arguments[1];this.elt[0]=new Oe(M.NONE),this.elt[1]=new Oe(M.NONE),this.elt[r].setLocation(i)}else if(3===arguments.length){var o=arguments[0],s=arguments[1],a=arguments[2];this.elt[0]=new Oe(o,s,a),this.elt[1]=new Oe(o,s,a)}else if(4===arguments.length){var u=arguments[0],l=arguments[1],c=arguments[2],h=arguments[3];this.elt[0]=new Oe(M.NONE,M.NONE,M.NONE),this.elt[1]=new Oe(M.NONE,M.NONE,M.NONE),this.elt[u].setLocations(l,c,h)}};Re.prototype.getGeometryCount=function(){var t=0;return this.elt[0].isNull()||t++,this.elt[1].isNull()||t++,t},Re.prototype.setAllLocations=function(t,e){this.elt[t].setAllLocations(e)},Re.prototype.isNull=function(t){return this.elt[t].isNull()},Re.prototype.setAllLocationsIfNull=function(){if(1===arguments.length){var t=arguments[0];this.setAllLocationsIfNull(0,t),this.setAllLocationsIfNull(1,t)}else if(2===arguments.length){var e=arguments[0],n=arguments[1];this.elt[e].setAllLocationsIfNull(n)}},Re.prototype.isLine=function(t){return this.elt[t].isLine()},Re.prototype.merge=function(t){for(var e=0;e<2;e++)null===this.elt[e]&&null!==t.elt[e]?this.elt[e]=new Oe(t.elt[e]):this.elt[e].merge(t.elt[e])},Re.prototype.flip=function(){this.elt[0].flip(),this.elt[1].flip()},Re.prototype.getLocation=function(){if(1===arguments.length){var t=arguments[0];return this.elt[t].get(Se.ON)}if(2===arguments.length){var e=arguments[0],n=arguments[1];return this.elt[e].get(n)}},Re.prototype.toString=function(){var t=new T;return null!==this.elt[0]&&(t.append("A:"),t.append(this.elt[0].toString())),null!==this.elt[1]&&(t.append(" B:"),t.append(this.elt[1].toString())),t.toString()},Re.prototype.isArea=function(){if(0===arguments.length)return this.elt[0].isArea()||this.elt[1].isArea();if(1===arguments.length){var t=arguments[0];return this.elt[t].isArea()}},Re.prototype.isAnyNull=function(t){return this.elt[t].isAnyNull()},Re.prototype.setLocation=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1];this.elt[t].setLocation(Se.ON,e)}else if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2];this.elt[n].setLocation(r,i)}},Re.prototype.isEqualOnSide=function(t,e){return this.elt[0].isEqualOnSide(t.elt[0],e)&&this.elt[1].isEqualOnSide(t.elt[1],e)},Re.prototype.allPositionsEqual=function(t,e){return this.elt[t].allPositionsEqual(e)},Re.prototype.toLine=function(t){this.elt[t].isArea()&&(this.elt[t]=new Oe(this.elt[t].location[0]))},Re.prototype.interfaces_=function(){return[]},Re.prototype.getClass=function(){return Re},Re.toLineLabel=function(t){for(var e=new Re(M.NONE),n=0;n<2;n++)e.setLocation(n,t.getLocation(n));return e};var Te=function(){this._startDe=null,this._maxNodeDegree=-1,this._edges=new It,this._pts=new It,this._label=new Re(M.NONE),this._ring=null,this._isHole=null,this._shell=null,this._holes=new It,this._geometryFactory=null;var t=arguments[0],e=arguments[1];this._geometryFactory=e,this.computePoints(t),this.computeRing()};Te.prototype.computeRing=function(){if(null!==this._ring)return null;for(var t=new Array(this._pts.size()).fill(null),e=0;e<this._pts.size();e++)t[e]=this._pts.get(e);this._ring=this._geometryFactory.createLinearRing(t),this._isHole=at.isCCW(this._ring.getCoordinates())},Te.prototype.isIsolated=function(){return 1===this._label.getGeometryCount()},Te.prototype.computePoints=function(t){this._startDe=t;var e=t,n=!0;do{if(null===e)throw new Me("Found null DirectedEdge");if(e.getEdgeRing()===this)throw new Me("Directed Edge visited twice during ring-building at "+e.getCoordinate());this._edges.add(e);var r=e.getLabel();et.isTrue(r.isArea()),this.mergeLabel(r),this.addPoints(e.getEdge(),e.isForward(),n),n=!1,this.setEdgeRing(e,this),e=this.getNext(e)}while(e!==this._startDe)},Te.prototype.getLinearRing=function(){return this._ring},Te.prototype.getCoordinate=function(t){return this._pts.get(t)},Te.prototype.computeMaxNodeDegree=function(){this._maxNodeDegree=0;var t=this._startDe;do{var e=t.getNode().getEdges().getOutgoingDegree(this);e>this._maxNodeDegree&&(this._maxNodeDegree=e),t=this.getNext(t)}while(t!==this._startDe);this._maxNodeDegree*=2},Te.prototype.addPoints=function(t,e,n){var r=t.getCoordinates();if(e){var i=1;n&&(i=0);for(var o=i;o<r.length;o++)this._pts.add(r[o])}else{var s=r.length-2;n&&(s=r.length-1);for(var a=s;a>=0;a--)this._pts.add(r[a])}},Te.prototype.isHole=function(){return this._isHole},Te.prototype.setInResult=function(){var t=this._startDe;do{t.getEdge().setInResult(!0),t=t.getNext()}while(t!==this._startDe)},Te.prototype.containsPoint=function(t){var e=this.getLinearRing();if(!e.getEnvelopeInternal().contains(t))return!1;if(!at.isPointInRing(t,e.getCoordinates()))return!1;for(var n=this._holes.iterator();n.hasNext();)if(n.next().containsPoint(t))return!1;return!0},Te.prototype.addHole=function(t){this._holes.add(t)},Te.prototype.isShell=function(){return null===this._shell},Te.prototype.getLabel=function(){return this._label},Te.prototype.getEdges=function(){return this._edges},Te.prototype.getMaxNodeDegree=function(){return this._maxNodeDegree<0&&this.computeMaxNodeDegree(),this._maxNodeDegree},Te.prototype.getShell=function(){return this._shell},Te.prototype.mergeLabel=function(){if(1===arguments.length){var t=arguments[0];this.mergeLabel(t,0),this.mergeLabel(t,1)}else if(2===arguments.length){var e=arguments[1],n=arguments[0].getLocation(e,Se.RIGHT);if(n===M.NONE)return null;if(this._label.getLocation(e)===M.NONE)return this._label.setLocation(e,n),null}},Te.prototype.setShell=function(t){this._shell=t,null!==t&&t.addHole(this)},Te.prototype.toPolygon=function(t){for(var e=new Array(this._holes.size()).fill(null),n=0;n<this._holes.size();n++)e[n]=this._holes.get(n).getLinearRing();return t.createPolygon(this.getLinearRing(),e)},Te.prototype.interfaces_=function(){return[]},Te.prototype.getClass=function(){return Te};var Ae=function(t){function e(){var e=arguments[0],n=arguments[1];t.call(this,e,n)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.setEdgeRing=function(t,e){t.setMinEdgeRing(e)},e.prototype.getNext=function(t){return t.getNextMin()},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Te),De=function(t){function e(){var e=arguments[0],n=arguments[1];t.call(this,e,n)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.buildMinimalRings=function(){var t=new It,e=this._startDe;do{if(null===e.getMinEdgeRing()){var n=new Ae(e,this._geometryFactory);t.add(n)}e=e.getNext()}while(e!==this._startDe);return t},e.prototype.setEdgeRing=function(t,e){t.setEdgeRing(e)},e.prototype.linkDirectedEdgesForMinimalEdgeRings=function(){var t=this._startDe;do{t.getNode().getEdges().linkMinimalDirectedEdges(this),t=t.getNext()}while(t!==this._startDe)},e.prototype.getNext=function(t){return t.getNext()},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Te),Fe=function(){if(this._label=null,this._isInResult=!1,this._isCovered=!1,this._isCoveredSet=!1,this._isVisited=!1,0===arguments.length);else if(1===arguments.length){var t=arguments[0];this._label=t}};Fe.prototype.setVisited=function(t){this._isVisited=t},Fe.prototype.setInResult=function(t){this._isInResult=t},Fe.prototype.isCovered=function(){return this._isCovered},Fe.prototype.isCoveredSet=function(){return this._isCoveredSet},Fe.prototype.setLabel=function(t){this._label=t},Fe.prototype.getLabel=function(){return this._label},Fe.prototype.setCovered=function(t){this._isCovered=t,this._isCoveredSet=!0},Fe.prototype.updateIM=function(t){et.isTrue(this._label.getGeometryCount()>=2,"found partial label"),this.computeIM(t)},Fe.prototype.isInResult=function(){return this._isInResult},Fe.prototype.isVisited=function(){return this._isVisited},Fe.prototype.interfaces_=function(){return[]},Fe.prototype.getClass=function(){return Fe};var ke=function(t){function e(){t.call(this),this._coord=null,this._edges=null;var e=arguments[0],n=arguments[1];this._coord=e,this._edges=n,this._label=new Re(0,M.NONE)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.isIncidentEdgeInResult=function(){for(var t=this.getEdges().getEdges().iterator();t.hasNext();)if(t.next().getEdge().isInResult())return!0;return!1},e.prototype.isIsolated=function(){return 1===this._label.getGeometryCount()},e.prototype.getCoordinate=function(){return this._coord},e.prototype.print=function(t){t.println("node "+this._coord+" lbl: "+this._label)},e.prototype.computeIM=function(t){},e.prototype.computeMergedLocation=function(t,e){var n=M.NONE;if(n=this._label.getLocation(e),!t.isNull(e)){var r=t.getLocation(e);n!==M.BOUNDARY&&(n=r)}return n},e.prototype.setLabel=function(){if(2!==arguments.length)return t.prototype.setLabel.apply(this,arguments);var e=arguments[0],n=arguments[1];null===this._label?this._label=new Re(e,n):this._label.setLocation(e,n)},e.prototype.getEdges=function(){return this._edges},e.prototype.mergeLabel=function(){if(arguments[0]instanceof e){var t=arguments[0];this.mergeLabel(t._label)}else if(arguments[0]instanceof Re)for(var n=arguments[0],r=0;r<2;r++){var i=this.computeMergedLocation(n,r);this._label.getLocation(r)===M.NONE&&this._label.setLocation(r,i)}},e.prototype.add=function(t){this._edges.insert(t),t.setNode(this)},e.prototype.setLabelBoundary=function(t){if(null===this._label)return null;var e=M.NONE;null!==this._label&&(e=this._label.getLocation(t));var n=null;if(e===M.BOUNDARY)n=M.INTERIOR;else n=M.BOUNDARY;this._label.setLocation(t,n)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Fe),Ge=function(){this.nodeMap=new h,this.nodeFact=null;var t=arguments[0];this.nodeFact=t};Ge.prototype.find=function(t){return this.nodeMap.get(t)},Ge.prototype.addNode=function(){if(arguments[0]instanceof C){var t=arguments[0],e=this.nodeMap.get(t);return null===e&&(e=this.nodeFact.createNode(t),this.nodeMap.put(t,e)),e}if(arguments[0]instanceof ke){var n=arguments[0],r=this.nodeMap.get(n.getCoordinate());return null===r?(this.nodeMap.put(n.getCoordinate(),n),n):(r.mergeLabel(n),r)}},Ge.prototype.print=function(t){for(var e=this.iterator();e.hasNext();)e.next().print(t)},Ge.prototype.iterator=function(){return this.nodeMap.values().iterator()},Ge.prototype.values=function(){return this.nodeMap.values()},Ge.prototype.getBoundaryNodes=function(t){for(var e=new It,n=this.iterator();n.hasNext();){var r=n.next();r.getLabel().getLocation(t)===M.BOUNDARY&&e.add(r)}return e},Ge.prototype.add=function(t){var e=t.getCoordinate();this.addNode(e).add(t)},Ge.prototype.interfaces_=function(){return[]},Ge.prototype.getClass=function(){return Ge};var Be=function(){},je={NE:{configurable:!0},NW:{configurable:!0},SW:{configurable:!0},SE:{configurable:!0}};Be.prototype.interfaces_=function(){return[]},Be.prototype.getClass=function(){return Be},Be.isNorthern=function(t){return t===Be.NE||t===Be.NW},Be.isOpposite=function(t,e){return t!==e&&2==(t-e+4)%4},Be.commonHalfPlane=function(t,e){if(t===e)return t;if(2==(t-e+4)%4)return-1;var n=t<e?t:e;return 0===n&&3===(t>e?t:e)?3:n},Be.isInHalfPlane=function(t,e){return e===Be.SE?t===Be.SE||t===Be.SW:t===e||t===e+1},Be.quadrant=function(){if("number"==typeof arguments[0]&&"number"==typeof arguments[1]){var t=arguments[0],e=arguments[1];if(0===t&&0===e)throw new m("Cannot compute the quadrant for point ( "+t+", "+e+" )");return t>=0?e>=0?Be.NE:Be.SE:e>=0?Be.NW:Be.SW}if(arguments[0]instanceof C&&arguments[1]instanceof C){var n=arguments[0],r=arguments[1];if(r.x===n.x&&r.y===n.y)throw new m("Cannot compute the quadrant for two identical points "+n);return r.x>=n.x?r.y>=n.y?Be.NE:Be.SE:r.y>=n.y?Be.NW:Be.SW}},je.NE.get=function(){return 0},je.NW.get=function(){return 1},je.SW.get=function(){return 2},je.SE.get=function(){return 3},Object.defineProperties(Be,je);var Ue=function(){if(this._edge=null,this._label=null,this._node=null,this._p0=null,this._p1=null,this._dx=null,this._dy=null,this._quadrant=null,1===arguments.length){var t=arguments[0];this._edge=t}else if(3===arguments.length){var e=arguments[0],n=arguments[1],r=arguments[2];this._edge=e,this.init(n,r),this._label=null}else if(4===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2],a=arguments[3];this._edge=i,this.init(o,s),this._label=a}};Ue.prototype.compareDirection=function(t){return this._dx===t._dx&&this._dy===t._dy?0:this._quadrant>t._quadrant?1:this._quadrant<t._quadrant?-1:at.computeOrientation(t._p0,t._p1,this._p1)},Ue.prototype.getDy=function(){return this._dy},Ue.prototype.getCoordinate=function(){return this._p0},Ue.prototype.setNode=function(t){this._node=t},Ue.prototype.print=function(t){var e=Math.atan2(this._dy,this._dx),n=this.getClass().getName(),r=n.lastIndexOf("."),i=n.substring(r+1);t.print("  "+i+": "+this._p0+" - "+this._p1+" "+this._quadrant+":"+e+"   "+this._label)},Ue.prototype.compareTo=function(t){var e=t;return this.compareDirection(e)},Ue.prototype.getDirectedCoordinate=function(){return this._p1},Ue.prototype.getDx=function(){return this._dx},Ue.prototype.getLabel=function(){return this._label},Ue.prototype.getEdge=function(){return this._edge},Ue.prototype.getQuadrant=function(){return this._quadrant},Ue.prototype.getNode=function(){return this._node},Ue.prototype.toString=function(){var t=Math.atan2(this._dy,this._dx),e=this.getClass().getName(),n=e.lastIndexOf(".");return"  "+e.substring(n+1)+": "+this._p0+" - "+this._p1+" "+this._quadrant+":"+t+"   "+this._label},Ue.prototype.computeLabel=function(t){},Ue.prototype.init=function(t,e){this._p0=t,this._p1=e,this._dx=e.x-t.x,this._dy=e.y-t.y,this._quadrant=Be.quadrant(this._dx,this._dy),et.isTrue(!(0===this._dx&&0===this._dy),"EdgeEnd with identical endpoints found")},Ue.prototype.interfaces_=function(){return[b]},Ue.prototype.getClass=function(){return Ue};var qe=function(t){function e(){var e=arguments[0],n=arguments[1];if(t.call(this,e),this._isForward=null,this._isInResult=!1,this._isVisited=!1,this._sym=null,this._next=null,this._nextMin=null,this._edgeRing=null,this._minEdgeRing=null,this._depth=[0,-999,-999],this._isForward=n,n)this.init(e.getCoordinate(0),e.getCoordinate(1));else{var r=e.getNumPoints()-1;this.init(e.getCoordinate(r),e.getCoordinate(r-1))}this.computeDirectedLabel()}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.getNextMin=function(){return this._nextMin},e.prototype.getDepth=function(t){return this._depth[t]},e.prototype.setVisited=function(t){this._isVisited=t},e.prototype.computeDirectedLabel=function(){this._label=new Re(this._edge.getLabel()),this._isForward||this._label.flip()},e.prototype.getNext=function(){return this._next},e.prototype.setDepth=function(t,e){if(-999!==this._depth[t]&&this._depth[t]!==e)throw new Me("assigned depths do not match",this.getCoordinate());this._depth[t]=e},e.prototype.isInteriorAreaEdge=function(){for(var t=!0,e=0;e<2;e++)this._label.isArea(e)&&this._label.getLocation(e,Se.LEFT)===M.INTERIOR&&this._label.getLocation(e,Se.RIGHT)===M.INTERIOR||(t=!1);return t},e.prototype.setNextMin=function(t){this._nextMin=t},e.prototype.print=function(e){t.prototype.print.call(this,e),e.print(" "+this._depth[Se.LEFT]+"/"+this._depth[Se.RIGHT]),e.print(" ("+this.getDepthDelta()+")"),this._isInResult&&e.print(" inResult")},e.prototype.setMinEdgeRing=function(t){this._minEdgeRing=t},e.prototype.isLineEdge=function(){var t=this._label.isLine(0)||this._label.isLine(1),e=!this._label.isArea(0)||this._label.allPositionsEqual(0,M.EXTERIOR),n=!this._label.isArea(1)||this._label.allPositionsEqual(1,M.EXTERIOR);return t&&e&&n},e.prototype.setEdgeRing=function(t){this._edgeRing=t},e.prototype.getMinEdgeRing=function(){return this._minEdgeRing},e.prototype.getDepthDelta=function(){var t=this._edge.getDepthDelta();return this._isForward||(t=-t),t},e.prototype.setInResult=function(t){this._isInResult=t},e.prototype.getSym=function(){return this._sym},e.prototype.isForward=function(){return this._isForward},e.prototype.getEdge=function(){return this._edge},e.prototype.printEdge=function(t){this.print(t),t.print(" "),this._isForward?this._edge.print(t):this._edge.printReverse(t)},e.prototype.setSym=function(t){this._sym=t},e.prototype.setVisitedEdge=function(t){this.setVisited(t),this._sym.setVisited(t)},e.prototype.setEdgeDepths=function(t,e){var n=this.getEdge().getDepthDelta();this._isForward||(n=-n);var r=1;t===Se.LEFT&&(r=-1);var i=Se.opposite(t),o=e+n*r;this.setDepth(t,e),this.setDepth(i,o)},e.prototype.getEdgeRing=function(){return this._edgeRing},e.prototype.isInResult=function(){return this._isInResult},e.prototype.setNext=function(t){this._next=t},e.prototype.isVisited=function(){return this._isVisited},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e.depthFactor=function(t,e){return t===M.EXTERIOR&&e===M.INTERIOR?1:t===M.INTERIOR&&e===M.EXTERIOR?-1:0},e}(Ue),ze=function(){};ze.prototype.createNode=function(t){return new ke(t,null)},ze.prototype.interfaces_=function(){return[]},ze.prototype.getClass=function(){return ze};var Ve=function(){if(this._edges=new It,this._nodes=null,this._edgeEndList=new It,0===arguments.length)this._nodes=new Ge(new ze);else if(1===arguments.length){var t=arguments[0];this._nodes=new Ge(t)}};Ve.prototype.printEdges=function(t){t.println("Edges:");for(var e=0;e<this._edges.size();e++){t.println("edge "+e+":");var n=this._edges.get(e);n.print(t),n.eiList.print(t)}},Ve.prototype.find=function(t){return this._nodes.find(t)},Ve.prototype.addNode=function(){if(arguments[0]instanceof ke){var t=arguments[0];return this._nodes.addNode(t)}if(arguments[0]instanceof C){var e=arguments[0];return this._nodes.addNode(e)}},Ve.prototype.getNodeIterator=function(){return this._nodes.iterator()},Ve.prototype.linkResultDirectedEdges=function(){for(var t=this._nodes.iterator();t.hasNext();)t.next().getEdges().linkResultDirectedEdges()},Ve.prototype.debugPrintln=function(t){V.out.println(t)},Ve.prototype.isBoundaryNode=function(t,e){var n=this._nodes.find(e);if(null===n)return!1;var r=n.getLabel();return null!==r&&r.getLocation(t)===M.BOUNDARY},Ve.prototype.linkAllDirectedEdges=function(){for(var t=this._nodes.iterator();t.hasNext();)t.next().getEdges().linkAllDirectedEdges()},Ve.prototype.matchInSameDirection=function(t,e,n,r){return!!t.equals(n)&&at.computeOrientation(t,e,r)===at.COLLINEAR&&Be.quadrant(t,e)===Be.quadrant(n,r)},Ve.prototype.getEdgeEnds=function(){return this._edgeEndList},Ve.prototype.debugPrint=function(t){V.out.print(t)},Ve.prototype.getEdgeIterator=function(){return this._edges.iterator()},Ve.prototype.findEdgeInSameDirection=function(t,e){for(var n=0;n<this._edges.size();n++){var r=this._edges.get(n),i=r.getCoordinates();if(this.matchInSameDirection(t,e,i[0],i[1]))return r;if(this.matchInSameDirection(t,e,i[i.length-1],i[i.length-2]))return r}return null},Ve.prototype.insertEdge=function(t){this._edges.add(t)},Ve.prototype.findEdgeEnd=function(t){for(var e=this.getEdgeEnds().iterator();e.hasNext();){var n=e.next();if(n.getEdge()===t)return n}return null},Ve.prototype.addEdges=function(t){for(var e=t.iterator();e.hasNext();){var n=e.next();this._edges.add(n);var r=new qe(n,!0),i=new qe(n,!1);r.setSym(i),i.setSym(r),this.add(r),this.add(i)}},Ve.prototype.add=function(t){this._nodes.add(t),this._edgeEndList.add(t)},Ve.prototype.getNodes=function(){return this._nodes.values()},Ve.prototype.findEdge=function(t,e){for(var n=0;n<this._edges.size();n++){var r=this._edges.get(n),i=r.getCoordinates();if(t.equals(i[0])&&e.equals(i[1]))return r}return null},Ve.prototype.interfaces_=function(){return[]},Ve.prototype.getClass=function(){return Ve},Ve.linkResultDirectedEdges=function(t){for(var e=t.iterator();e.hasNext();)e.next().getEdges().linkResultDirectedEdges()};var Ye=function(){this._geometryFactory=null,this._shellList=new It;var t=arguments[0];this._geometryFactory=t};Ye.prototype.sortShellsAndHoles=function(t,e,n){for(var r=t.iterator();r.hasNext();){var i=r.next();i.isHole()?n.add(i):e.add(i)}},Ye.prototype.computePolygons=function(t){for(var e=new It,n=t.iterator();n.hasNext();){var r=n.next().toPolygon(this._geometryFactory);e.add(r)}return e},Ye.prototype.placeFreeHoles=function(t,e){for(var n=e.iterator();n.hasNext();){var r=n.next();if(null===r.getShell()){var i=this.findEdgeRingContaining(r,t);if(null===i)throw new Me("unable to assign hole to a shell",r.getCoordinate(0));r.setShell(i)}}},Ye.prototype.buildMinimalEdgeRings=function(t,e,n){for(var r=new It,i=t.iterator();i.hasNext();){var o=i.next();if(o.getMaxNodeDegree()>2){o.linkDirectedEdgesForMinimalEdgeRings();var s=o.buildMinimalRings(),a=this.findShell(s);null!==a?(this.placePolygonHoles(a,s),e.add(a)):n.addAll(s)}else r.add(o)}return r},Ye.prototype.containsPoint=function(t){for(var e=this._shellList.iterator();e.hasNext();)if(e.next().containsPoint(t))return!0;return!1},Ye.prototype.buildMaximalEdgeRings=function(t){for(var e=new It,n=t.iterator();n.hasNext();){var r=n.next();if(r.isInResult()&&r.getLabel().isArea()&&null===r.getEdgeRing()){var i=new De(r,this._geometryFactory);e.add(i),i.setInResult()}}return e},Ye.prototype.placePolygonHoles=function(t,e){for(var n=e.iterator();n.hasNext();){var r=n.next();r.isHole()&&r.setShell(t)}},Ye.prototype.getPolygons=function(){return this.computePolygons(this._shellList)},Ye.prototype.findEdgeRingContaining=function(t,e){for(var n=t.getLinearRing(),r=n.getEnvelopeInternal(),i=n.getCoordinateN(0),o=null,s=null,a=e.iterator();a.hasNext();){var u=a.next(),l=u.getLinearRing(),c=l.getEnvelopeInternal();null!==o&&(s=o.getLinearRing().getEnvelopeInternal());var h=!1;c.contains(r)&&at.isPointInRing(i,l.getCoordinates())&&(h=!0),h&&(null===o||s.contains(c))&&(o=u)}return o},Ye.prototype.findShell=function(t){for(var e=0,n=null,r=t.iterator();r.hasNext();){var i=r.next();i.isHole()||(n=i,e++)}return et.isTrue(e<=1,"found two shells in MinimalEdgeRing list"),n},Ye.prototype.add=function(){if(1===arguments.length){var t=arguments[0];this.add(t.getEdgeEnds(),t.getNodes())}else if(2===arguments.length){var e=arguments[0],n=arguments[1];Ve.linkResultDirectedEdges(n);var r=this.buildMaximalEdgeRings(e),i=new It,o=this.buildMinimalEdgeRings(r,this._shellList,i);this.sortShellsAndHoles(o,this._shellList,i),this.placeFreeHoles(this._shellList,i)}},Ye.prototype.interfaces_=function(){return[]},Ye.prototype.getClass=function(){return Ye};var Xe=function(){};Xe.prototype.getBounds=function(){},Xe.prototype.interfaces_=function(){return[]},Xe.prototype.getClass=function(){return Xe};var We=function(){this._bounds=null,this._item=null;var t=arguments[0],e=arguments[1];this._bounds=t,this._item=e};We.prototype.getItem=function(){return this._item},We.prototype.getBounds=function(){return this._bounds},We.prototype.interfaces_=function(){return[Xe,e]},We.prototype.getClass=function(){return We};var He=function(){this._size=null,this._items=null,this._size=0,this._items=new It,this._items.add(null)};He.prototype.poll=function(){if(this.isEmpty())return null;var t=this._items.get(1);return this._items.set(1,this._items.get(this._size)),this._size-=1,this.reorder(1),t},He.prototype.size=function(){return this._size},He.prototype.reorder=function(t){for(var e=null,n=this._items.get(t);2*t<=this._size&&((e=2*t)!==this._size&&this._items.get(e+1).compareTo(this._items.get(e))<0&&e++,this._items.get(e).compareTo(n)<0);t=e)this._items.set(t,this._items.get(e));this._items.set(t,n)},He.prototype.clear=function(){this._size=0,this._items.clear()},He.prototype.isEmpty=function(){return 0===this._size},He.prototype.add=function(t){this._items.add(null),this._size+=1;var e=this._size;for(this._items.set(0,t);t.compareTo(this._items.get(Math.trunc(e/2)))<0;e/=2)this._items.set(e,this._items.get(Math.trunc(e/2)));this._items.set(e,t)},He.prototype.interfaces_=function(){return[]},He.prototype.getClass=function(){return He};var Ke=function(){};Ke.prototype.visitItem=function(t){},Ke.prototype.interfaces_=function(){return[]},Ke.prototype.getClass=function(){return Ke};var Je=function(){};Je.prototype.insert=function(t,e){},Je.prototype.remove=function(t,e){},Je.prototype.query=function(){},Je.prototype.interfaces_=function(){return[]},Je.prototype.getClass=function(){return Je};var Ze=function(){if(this._childBoundables=new It,this._bounds=null,this._level=null,0===arguments.length);else if(1===arguments.length){var t=arguments[0];this._level=t}},$e={serialVersionUID:{configurable:!0}};Ze.prototype.getLevel=function(){return this._level},Ze.prototype.size=function(){return this._childBoundables.size()},Ze.prototype.getChildBoundables=function(){return this._childBoundables},Ze.prototype.addChildBoundable=function(t){et.isTrue(null===this._bounds),this._childBoundables.add(t)},Ze.prototype.isEmpty=function(){return this._childBoundables.isEmpty()},Ze.prototype.getBounds=function(){return null===this._bounds&&(this._bounds=this.computeBounds()),this._bounds},Ze.prototype.interfaces_=function(){return[Xe,e]},Ze.prototype.getClass=function(){return Ze},$e.serialVersionUID.get=function(){return 0x5a1e55ec41369800},Object.defineProperties(Ze,$e);var Qe=function(){};Qe.reverseOrder=function(){return{compare:function(t,e){return e.compareTo(t)}}},Qe.min=function(t){return Qe.sort(t),t.get(0)},Qe.sort=function(t,e){var n=t.toArray();e?kt.sort(n,e):kt.sort(n);for(var r=t.iterator(),i=0,o=n.length;i<o;i++)r.next(),r.set(n[i])},Qe.singletonList=function(t){var e=new It;return e.add(t),e};var tn=function(){this._boundable1=null,this._boundable2=null,this._distance=null,this._itemDistance=null;var t=arguments[0],e=arguments[1],n=arguments[2];this._boundable1=t,this._boundable2=e,this._itemDistance=n,this._distance=this.distance()};tn.prototype.expandToQueue=function(t,e){var n=tn.isComposite(this._boundable1),r=tn.isComposite(this._boundable2);if(n&&r)return tn.area(this._boundable1)>tn.area(this._boundable2)?(this.expand(this._boundable1,this._boundable2,t,e),null):(this.expand(this._boundable2,this._boundable1,t,e),null);if(n)return this.expand(this._boundable1,this._boundable2,t,e),null;if(r)return this.expand(this._boundable2,this._boundable1,t,e),null;throw new m("neither boundable is composite")},tn.prototype.isLeaves=function(){return!(tn.isComposite(this._boundable1)||tn.isComposite(this._boundable2))},tn.prototype.compareTo=function(t){var e=t;return this._distance<e._distance?-1:this._distance>e._distance?1:0},tn.prototype.expand=function(t,e,n,r){for(var i=t.getChildBoundables().iterator();i.hasNext();){var o=i.next(),s=new tn(o,e,this._itemDistance);s.getDistance()<r&&n.add(s)}},tn.prototype.getBoundable=function(t){return 0===t?this._boundable1:this._boundable2},tn.prototype.getDistance=function(){return this._distance},tn.prototype.distance=function(){return this.isLeaves()?this._itemDistance.distance(this._boundable1,this._boundable2):this._boundable1.getBounds().distance(this._boundable2.getBounds())},tn.prototype.interfaces_=function(){return[b]},tn.prototype.getClass=function(){return tn},tn.area=function(t){return t.getBounds().getArea()},tn.isComposite=function(t){return t instanceof Ze};var en=function t(){if(this._root=null,this._built=!1,this._itemBoundables=new It,this._nodeCapacity=null,0===arguments.length){var e=t.DEFAULT_NODE_CAPACITY;this._nodeCapacity=e}else if(1===arguments.length){var n=arguments[0];et.isTrue(n>1,"Node capacity must be greater than 1"),this._nodeCapacity=n}},nn={IntersectsOp:{configurable:!0},serialVersionUID:{configurable:!0},DEFAULT_NODE_CAPACITY:{configurable:!0}};en.prototype.getNodeCapacity=function(){return this._nodeCapacity},en.prototype.lastNode=function(t){return t.get(t.size()-1)},en.prototype.size=function(){if(0===arguments.length)return this.isEmpty()?0:(this.build(),this.size(this._root));if(1===arguments.length){for(var t=0,e=arguments[0].getChildBoundables().iterator();e.hasNext();){var n=e.next();n instanceof Ze?t+=this.size(n):n instanceof We&&(t+=1)}return t}},en.prototype.removeItem=function(t,e){for(var n=null,r=t.getChildBoundables().iterator();r.hasNext();){var i=r.next();i instanceof We&&i.getItem()===e&&(n=i)}return null!==n&&(t.getChildBoundables().remove(n),!0)},en.prototype.itemsTree=function(){if(0===arguments.length){this.build();var t=this.itemsTree(this._root);return null===t?new It:t}if(1===arguments.length){for(var e=arguments[0],n=new It,r=e.getChildBoundables().iterator();r.hasNext();){var i=r.next();if(i instanceof Ze){var o=this.itemsTree(i);null!==o&&n.add(o)}else i instanceof We?n.add(i.getItem()):et.shouldNeverReachHere()}return n.size()<=0?null:n}},en.prototype.insert=function(t,e){et.isTrue(!this._built,"Cannot insert items into an STR packed R-tree after it has been built."),this._itemBoundables.add(new We(t,e))},en.prototype.boundablesAtLevel=function(){if(1===arguments.length){var t=arguments[0],e=new It;return this.boundablesAtLevel(t,this._root,e),e}if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2];if(et.isTrue(n>-2),r.getLevel()===n)return i.add(r),null;for(var o=r.getChildBoundables().iterator();o.hasNext();){var s=o.next();s instanceof Ze?this.boundablesAtLevel(n,s,i):(et.isTrue(s instanceof We),-1===n&&i.add(s))}return null}},en.prototype.query=function(){if(1===arguments.length){var t=arguments[0];this.build();var e=new It;return this.isEmpty()||this.getIntersectsOp().intersects(this._root.getBounds(),t)&&this.query(t,this._root,e),e}if(2===arguments.length){var n=arguments[0],r=arguments[1];if(this.build(),this.isEmpty())return null;this.getIntersectsOp().intersects(this._root.getBounds(),n)&&this.query(n,this._root,r)}else if(3===arguments.length)if(P(arguments[2],Ke)&&arguments[0]instanceof Object&&arguments[1]instanceof Ze)for(var i=arguments[0],o=arguments[2],s=arguments[1].getChildBoundables(),a=0;a<s.size();a++){var u=s.get(a);this.getIntersectsOp().intersects(u.getBounds(),i)&&(u instanceof Ze?this.query(i,u,o):u instanceof We?o.visitItem(u.getItem()):et.shouldNeverReachHere())}else if(P(arguments[2],Et)&&arguments[0]instanceof Object&&arguments[1]instanceof Ze)for(var l=arguments[0],c=arguments[2],h=arguments[1].getChildBoundables(),p=0;p<h.size();p++){var f=h.get(p);this.getIntersectsOp().intersects(f.getBounds(),l)&&(f instanceof Ze?this.query(l,f,c):f instanceof We?c.add(f.getItem()):et.shouldNeverReachHere())}},en.prototype.build=function(){if(this._built)return null;this._root=this._itemBoundables.isEmpty()?this.createNode(0):this.createHigherLevels(this._itemBoundables,-1),this._itemBoundables=null,this._built=!0},en.prototype.getRoot=function(){return this.build(),this._root},en.prototype.remove=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1];return this.build(),!!this.getIntersectsOp().intersects(this._root.getBounds(),t)&&this.remove(t,this._root,e)}if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2],o=this.removeItem(r,i);if(o)return!0;for(var s=null,a=r.getChildBoundables().iterator();a.hasNext();){var u=a.next();if(this.getIntersectsOp().intersects(u.getBounds(),n)&&u instanceof Ze&&(o=this.remove(n,u,i))){s=u;break}}return null!==s&&s.getChildBoundables().isEmpty()&&r.getChildBoundables().remove(s),o}},en.prototype.createHigherLevels=function(t,e){et.isTrue(!t.isEmpty());var n=this.createParentBoundables(t,e+1);return 1===n.size()?n.get(0):this.createHigherLevels(n,e+1)},en.prototype.depth=function(){if(0===arguments.length)return this.isEmpty()?0:(this.build(),this.depth(this._root));if(1===arguments.length){for(var t=0,e=arguments[0].getChildBoundables().iterator();e.hasNext();){var n=e.next();if(n instanceof Ze){var r=this.depth(n);r>t&&(t=r)}}return t+1}},en.prototype.createParentBoundables=function(t,e){et.isTrue(!t.isEmpty());var n=new It;n.add(this.createNode(e));var r=new It(t);Qe.sort(r,this.getComparator());for(var i=r.iterator();i.hasNext();){var o=i.next();this.lastNode(n).getChildBoundables().size()===this.getNodeCapacity()&&n.add(this.createNode(e)),this.lastNode(n).addChildBoundable(o)}return n},en.prototype.isEmpty=function(){return this._built?this._root.isEmpty():this._itemBoundables.isEmpty()},en.prototype.interfaces_=function(){return[e]},en.prototype.getClass=function(){return en},en.compareDoubles=function(t,e){return t>e?1:t<e?-1:0},nn.IntersectsOp.get=function(){return rn},nn.serialVersionUID.get=function(){return-0x35ef64c82d4c5400},nn.DEFAULT_NODE_CAPACITY.get=function(){return 10},Object.defineProperties(en,nn);var rn=function(){},on=function(){};on.prototype.distance=function(t,e){},on.prototype.interfaces_=function(){return[]},on.prototype.getClass=function(){return on};var sn=function(t){function n(e){e=e||n.DEFAULT_NODE_CAPACITY,t.call(this,e)}t&&(n.__proto__=t),(n.prototype=Object.create(t&&t.prototype)).constructor=n;var r={STRtreeNode:{configurable:!0},serialVersionUID:{configurable:!0},xComparator:{configurable:!0},yComparator:{configurable:!0},intersectsOp:{configurable:!0},DEFAULT_NODE_CAPACITY:{configurable:!0}};return n.prototype.createParentBoundablesFromVerticalSlices=function(t,e){et.isTrue(t.length>0);for(var n=new It,r=0;r<t.length;r++)n.addAll(this.createParentBoundablesFromVerticalSlice(t[r],e));return n},n.prototype.createNode=function(t){return new an(t)},n.prototype.size=function(){return 0===arguments.length?t.prototype.size.call(this):t.prototype.size.apply(this,arguments)},n.prototype.insert=function(){if(2!==arguments.length)return t.prototype.insert.apply(this,arguments);var e=arguments[0],n=arguments[1];if(e.isNull())return null;t.prototype.insert.call(this,e,n)},n.prototype.getIntersectsOp=function(){return n.intersectsOp},n.prototype.verticalSlices=function(t,e){for(var n=Math.trunc(Math.ceil(t.size()/e)),r=new Array(e).fill(null),i=t.iterator(),o=0;o<e;o++){r[o]=new It;for(var s=0;i.hasNext()&&s<n;){var a=i.next();r[o].add(a),s++}}return r},n.prototype.query=function(){if(1===arguments.length){var e=arguments[0];return t.prototype.query.call(this,e)}if(2===arguments.length){var n=arguments[0],r=arguments[1];t.prototype.query.call(this,n,r)}else if(3===arguments.length)if(P(arguments[2],Ke)&&arguments[0]instanceof Object&&arguments[1]instanceof Ze){var i=arguments[0],o=arguments[1],s=arguments[2];t.prototype.query.call(this,i,o,s)}else if(P(arguments[2],Et)&&arguments[0]instanceof Object&&arguments[1]instanceof Ze){var a=arguments[0],u=arguments[1],l=arguments[2];t.prototype.query.call(this,a,u,l)}},n.prototype.getComparator=function(){return n.yComparator},n.prototype.createParentBoundablesFromVerticalSlice=function(e,n){return t.prototype.createParentBoundables.call(this,e,n)},n.prototype.remove=function(){if(2===arguments.length){var e=arguments[0],n=arguments[1];return t.prototype.remove.call(this,e,n)}return t.prototype.remove.apply(this,arguments)},n.prototype.depth=function(){return 0===arguments.length?t.prototype.depth.call(this):t.prototype.depth.apply(this,arguments)},n.prototype.createParentBoundables=function(t,e){et.isTrue(!t.isEmpty());var r=Math.trunc(Math.ceil(t.size()/this.getNodeCapacity())),i=new It(t);Qe.sort(i,n.xComparator);var o=this.verticalSlices(i,Math.trunc(Math.ceil(Math.sqrt(r))));return this.createParentBoundablesFromVerticalSlices(o,e)},n.prototype.nearestNeighbour=function(){if(1===arguments.length){if(P(arguments[0],on)){var t=arguments[0],e=new tn(this.getRoot(),this.getRoot(),t);return this.nearestNeighbour(e)}if(arguments[0]instanceof tn){var r=arguments[0];return this.nearestNeighbour(r,v.POSITIVE_INFINITY)}}else if(2===arguments.length){if(arguments[0]instanceof n&&P(arguments[1],on)){var i=arguments[0],o=arguments[1],s=new tn(this.getRoot(),i.getRoot(),o);return this.nearestNeighbour(s)}if(arguments[0]instanceof tn&&"number"==typeof arguments[1]){var a=arguments[0],u=arguments[1],l=null,c=new He;for(c.add(a);!c.isEmpty()&&u>0;){var h=c.poll(),p=h.getDistance();if(p>=u)break;h.isLeaves()?(u=p,l=h):h.expandToQueue(c,u)}return[l.getBoundable(0).getItem(),l.getBoundable(1).getItem()]}}else if(3===arguments.length){var f=arguments[2],g=new We(arguments[0],arguments[1]),d=new tn(this.getRoot(),g,f);return this.nearestNeighbour(d)[0]}},n.prototype.interfaces_=function(){return[Je,e]},n.prototype.getClass=function(){return n},n.centreX=function(t){return n.avg(t.getMinX(),t.getMaxX())},n.avg=function(t,e){return(t+e)/2},n.centreY=function(t){return n.avg(t.getMinY(),t.getMaxY())},r.STRtreeNode.get=function(){return an},r.serialVersionUID.get=function(){return 0x39920f7d5f261e0},r.xComparator.get=function(){return{interfaces_:function(){return[I]},compare:function(e,r){return t.compareDoubles(n.centreX(e.getBounds()),n.centreX(r.getBounds()))}}},r.yComparator.get=function(){return{interfaces_:function(){return[I]},compare:function(e,r){return t.compareDoubles(n.centreY(e.getBounds()),n.centreY(r.getBounds()))}}},r.intersectsOp.get=function(){return{interfaces_:function(){return[t.IntersectsOp]},intersects:function(t,e){return t.intersects(e)}}},r.DEFAULT_NODE_CAPACITY.get=function(){return 10},Object.defineProperties(n,r),n}(en),an=function(t){function e(){var e=arguments[0];t.call(this,e)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.computeBounds=function(){for(var t=null,e=this.getChildBoundables().iterator();e.hasNext();){var n=e.next();null===t?t=new X(n.getBounds()):t.expandToInclude(n.getBounds())}return t},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Ze),un=function(){};un.prototype.interfaces_=function(){return[]},un.prototype.getClass=function(){return un},un.relativeSign=function(t,e){return t<e?-1:t>e?1:0},un.compare=function(t,e,n){if(e.equals2D(n))return 0;var r=un.relativeSign(e.x,n.x),i=un.relativeSign(e.y,n.y);switch(t){case 0:return un.compareValue(r,i);case 1:return un.compareValue(i,r);case 2:return un.compareValue(i,-r);case 3:return un.compareValue(-r,i);case 4:return un.compareValue(-r,-i);case 5:return un.compareValue(-i,-r);case 6:return un.compareValue(-i,r);case 7:return un.compareValue(r,-i)}return et.shouldNeverReachHere("invalid octant value"),0},un.compareValue=function(t,e){return t<0?-1:t>0?1:e<0?-1:e>0?1:0};var ln=function(){this._segString=null,this.coord=null,this.segmentIndex=null,this._segmentOctant=null,this._isInterior=null;var t=arguments[0],e=arguments[1],n=arguments[2],r=arguments[3];this._segString=t,this.coord=new C(e),this.segmentIndex=n,this._segmentOctant=r,this._isInterior=!e.equals2D(t.getCoordinate(n))};ln.prototype.getCoordinate=function(){return this.coord},ln.prototype.print=function(t){t.print(this.coord),t.print(" seg # = "+this.segmentIndex)},ln.prototype.compareTo=function(t){var e=t;return this.segmentIndex<e.segmentIndex?-1:this.segmentIndex>e.segmentIndex?1:this.coord.equals2D(e.coord)?0:un.compare(this._segmentOctant,this.coord,e.coord)},ln.prototype.isEndPoint=function(t){return 0===this.segmentIndex&&!this._isInterior||this.segmentIndex===t},ln.prototype.isInterior=function(){return this._isInterior},ln.prototype.interfaces_=function(){return[b]},ln.prototype.getClass=function(){return ln};var cn=function(){this._nodeMap=new h,this._edge=null;var t=arguments[0];this._edge=t};cn.prototype.getSplitCoordinates=function(){var t=new St;this.addEndpoints();for(var e=this.iterator(),n=e.next();e.hasNext();){var r=e.next();this.addEdgeCoordinates(n,r,t),n=r}return t.toCoordinateArray()},cn.prototype.addCollapsedNodes=function(){var t=new It;this.findCollapsesFromInsertedNodes(t),this.findCollapsesFromExistingVertices(t);for(var e=t.iterator();e.hasNext();){var n=e.next().intValue();this.add(this._edge.getCoordinate(n),n)}},cn.prototype.print=function(t){t.println("Intersections:");for(var e=this.iterator();e.hasNext();)e.next().print(t)},cn.prototype.findCollapsesFromExistingVertices=function(t){for(var e=0;e<this._edge.size()-2;e++){var n=this._edge.getCoordinate(e),r=this._edge.getCoordinate(e+2);n.equals2D(r)&&t.add(new A(e+1))}},cn.prototype.addEdgeCoordinates=function(t,e,n){var r=this._edge.getCoordinate(e.segmentIndex),i=e.isInterior()||!e.coord.equals2D(r);n.add(new C(t.coord),!1);for(var o=t.segmentIndex+1;o<=e.segmentIndex;o++)n.add(this._edge.getCoordinate(o));i&&n.add(new C(e.coord))},cn.prototype.iterator=function(){return this._nodeMap.values().iterator()},cn.prototype.addSplitEdges=function(t){this.addEndpoints(),this.addCollapsedNodes();for(var e=this.iterator(),n=e.next();e.hasNext();){var r=e.next(),i=this.createSplitEdge(n,r);t.add(i),n=r}},cn.prototype.findCollapseIndex=function(t,e,n){if(!t.coord.equals2D(e.coord))return!1;var r=e.segmentIndex-t.segmentIndex;return e.isInterior()||r--,1===r&&(n[0]=t.segmentIndex+1,!0)},cn.prototype.findCollapsesFromInsertedNodes=function(t){for(var e=new Array(1).fill(null),n=this.iterator(),r=n.next();n.hasNext();){var i=n.next();this.findCollapseIndex(r,i,e)&&t.add(new A(e[0])),r=i}},cn.prototype.getEdge=function(){return this._edge},cn.prototype.addEndpoints=function(){var t=this._edge.size()-1;this.add(this._edge.getCoordinate(0),0),this.add(this._edge.getCoordinate(t),t)},cn.prototype.createSplitEdge=function(t,e){var n=e.segmentIndex-t.segmentIndex+2,r=this._edge.getCoordinate(e.segmentIndex),i=e.isInterior()||!e.coord.equals2D(r);i||n--;var o=new Array(n).fill(null),s=0;o[s++]=new C(t.coord);for(var a=t.segmentIndex+1;a<=e.segmentIndex;a++)o[s++]=this._edge.getCoordinate(a);return i&&(o[s]=new C(e.coord)),new gn(o,this._edge.getData())},cn.prototype.add=function(t,e){var n=new ln(this._edge,t,e,this._edge.getSegmentOctant(e)),r=this._nodeMap.get(n);return null!==r?(et.isTrue(r.coord.equals2D(t),"Found equal nodes with different coordinates"),r):(this._nodeMap.put(n,n),n)},cn.prototype.checkSplitEdgesCorrectness=function(t){var e=this._edge.getCoordinates(),n=t.get(0).getCoordinate(0);if(!n.equals2D(e[0]))throw new Q("bad split edge start point at "+n);var r=t.get(t.size()-1).getCoordinates(),i=r[r.length-1];if(!i.equals2D(e[e.length-1]))throw new Q("bad split edge end point at "+i)},cn.prototype.interfaces_=function(){return[]},cn.prototype.getClass=function(){return cn};var hn=function(){};hn.prototype.interfaces_=function(){return[]},hn.prototype.getClass=function(){return hn},hn.octant=function(){if("number"==typeof arguments[0]&&"number"==typeof arguments[1]){var t=arguments[0],e=arguments[1];if(0===t&&0===e)throw new m("Cannot compute the octant for point ( "+t+", "+e+" )");var n=Math.abs(t),r=Math.abs(e);return t>=0?e>=0?n>=r?0:1:n>=r?7:6:e>=0?n>=r?3:2:n>=r?4:5}if(arguments[0]instanceof C&&arguments[1]instanceof C){var i=arguments[0],o=arguments[1],s=o.x-i.x,a=o.y-i.y;if(0===s&&0===a)throw new m("Cannot compute the octant for two identical points "+i);return hn.octant(s,a)}};var pn=function(){};pn.prototype.getCoordinates=function(){},pn.prototype.size=function(){},pn.prototype.getCoordinate=function(t){},pn.prototype.isClosed=function(){},pn.prototype.setData=function(t){},pn.prototype.getData=function(){},pn.prototype.interfaces_=function(){return[]},pn.prototype.getClass=function(){return pn};var fn=function(){};fn.prototype.addIntersection=function(t,e){},fn.prototype.interfaces_=function(){return[pn]},fn.prototype.getClass=function(){return fn};var gn=function(){this._nodeList=new cn(this),this._pts=null,this._data=null;var t=arguments[0],e=arguments[1];this._pts=t,this._data=e};gn.prototype.getCoordinates=function(){return this._pts},gn.prototype.size=function(){return this._pts.length},gn.prototype.getCoordinate=function(t){return this._pts[t]},gn.prototype.isClosed=function(){return this._pts[0].equals(this._pts[this._pts.length-1])},gn.prototype.getSegmentOctant=function(t){return t===this._pts.length-1?-1:this.safeOctant(this.getCoordinate(t),this.getCoordinate(t+1))},gn.prototype.setData=function(t){this._data=t},gn.prototype.safeOctant=function(t,e){return t.equals2D(e)?0:hn.octant(t,e)},gn.prototype.getData=function(){return this._data},gn.prototype.addIntersection=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1];this.addIntersectionNode(t,e)}else if(4===arguments.length){var n=arguments[1],r=arguments[3],i=new C(arguments[0].getIntersection(r));this.addIntersection(i,n)}},gn.prototype.toString=function(){return $.toLineString(new ue(this._pts))},gn.prototype.getNodeList=function(){return this._nodeList},gn.prototype.addIntersectionNode=function(t,e){var n=e,r=n+1;if(r<this._pts.length){var i=this._pts[r];t.equals2D(i)&&(n=r)}return this._nodeList.add(t,n)},gn.prototype.addIntersections=function(t,e,n){for(var r=0;r<t.getIntersectionNum();r++)this.addIntersection(t,e,n,r)},gn.prototype.interfaces_=function(){return[fn]},gn.prototype.getClass=function(){return gn},gn.getNodedSubstrings=function(){if(1===arguments.length){var t=arguments[0],e=new It;return gn.getNodedSubstrings(t,e),e}if(2===arguments.length)for(var n=arguments[1],r=arguments[0].iterator();r.hasNext();)r.next().getNodeList().addSplitEdges(n)};var dn=function(){if(this.p0=null,this.p1=null,0===arguments.length)this.p0=new C,this.p1=new C;else if(1===arguments.length){var t=arguments[0];this.p0=new C(t.p0),this.p1=new C(t.p1)}else if(2===arguments.length)this.p0=arguments[0],this.p1=arguments[1];else if(4===arguments.length){var e=arguments[0],n=arguments[1],r=arguments[2],i=arguments[3];this.p0=new C(e,n),this.p1=new C(r,i)}},yn={serialVersionUID:{configurable:!0}};dn.prototype.minX=function(){return Math.min(this.p0.x,this.p1.x)},dn.prototype.orientationIndex=function(){if(arguments[0]instanceof dn){var t=arguments[0],e=at.orientationIndex(this.p0,this.p1,t.p0),n=at.orientationIndex(this.p0,this.p1,t.p1);return e>=0&&n>=0||e<=0&&n<=0?Math.max(e,n):0}if(arguments[0]instanceof C){var r=arguments[0];return at.orientationIndex(this.p0,this.p1,r)}},dn.prototype.toGeometry=function(t){return t.createLineString([this.p0,this.p1])},dn.prototype.isVertical=function(){return this.p0.x===this.p1.x},dn.prototype.equals=function(t){if(!(t instanceof dn))return!1;var e=t;return this.p0.equals(e.p0)&&this.p1.equals(e.p1)},dn.prototype.intersection=function(t){var e=new it;return e.computeIntersection(this.p0,this.p1,t.p0,t.p1),e.hasIntersection()?e.getIntersection(0):null},dn.prototype.project=function(){if(arguments[0]instanceof C){var t=arguments[0];if(t.equals(this.p0)||t.equals(this.p1))return new C(t);var e=this.projectionFactor(t),n=new C;return n.x=this.p0.x+e*(this.p1.x-this.p0.x),n.y=this.p0.y+e*(this.p1.y-this.p0.y),n}if(arguments[0]instanceof dn){var r=arguments[0],i=this.projectionFactor(r.p0),o=this.projectionFactor(r.p1);if(i>=1&&o>=1)return null;if(i<=0&&o<=0)return null;var s=this.project(r.p0);i<0&&(s=this.p0),i>1&&(s=this.p1);var a=this.project(r.p1);return o<0&&(a=this.p0),o>1&&(a=this.p1),new dn(s,a)}},dn.prototype.normalize=function(){this.p1.compareTo(this.p0)<0&&this.reverse()},dn.prototype.angle=function(){return Math.atan2(this.p1.y-this.p0.y,this.p1.x-this.p0.x)},dn.prototype.getCoordinate=function(t){return 0===t?this.p0:this.p1},dn.prototype.distancePerpendicular=function(t){return at.distancePointLinePerpendicular(t,this.p0,this.p1)},dn.prototype.minY=function(){return Math.min(this.p0.y,this.p1.y)},dn.prototype.midPoint=function(){return dn.midPoint(this.p0,this.p1)},dn.prototype.projectionFactor=function(t){if(t.equals(this.p0))return 0;if(t.equals(this.p1))return 1;var e=this.p1.x-this.p0.x,n=this.p1.y-this.p0.y,r=e*e+n*n;return r<=0?v.NaN:((t.x-this.p0.x)*e+(t.y-this.p0.y)*n)/r},dn.prototype.closestPoints=function(t){var e=this.intersection(t);if(null!==e)return[e,e];var n=new Array(2).fill(null),r=v.MAX_VALUE,i=null,o=this.closestPoint(t.p0);r=o.distance(t.p0),n[0]=o,n[1]=t.p0;var s=this.closestPoint(t.p1);(i=s.distance(t.p1))<r&&(r=i,n[0]=s,n[1]=t.p1);var a=t.closestPoint(this.p0);(i=a.distance(this.p0))<r&&(r=i,n[0]=this.p0,n[1]=a);var u=t.closestPoint(this.p1);return(i=u.distance(this.p1))<r&&(r=i,n[0]=this.p1,n[1]=u),n},dn.prototype.closestPoint=function(t){var e=this.projectionFactor(t);return e>0&&e<1?this.project(t):this.p0.distance(t)<this.p1.distance(t)?this.p0:this.p1},dn.prototype.maxX=function(){return Math.max(this.p0.x,this.p1.x)},dn.prototype.getLength=function(){return this.p0.distance(this.p1)},dn.prototype.compareTo=function(t){var e=t,n=this.p0.compareTo(e.p0);return 0!==n?n:this.p1.compareTo(e.p1)},dn.prototype.reverse=function(){var t=this.p0;this.p0=this.p1,this.p1=t},dn.prototype.equalsTopo=function(t){return this.p0.equals(t.p0)&&(this.p1.equals(t.p1)||this.p0.equals(t.p1))&&this.p1.equals(t.p0)},dn.prototype.lineIntersection=function(t){try{return Y.intersection(this.p0,this.p1,t.p0,t.p1)}catch(t){if(!(t instanceof z))throw t}return null},dn.prototype.maxY=function(){return Math.max(this.p0.y,this.p1.y)},dn.prototype.pointAlongOffset=function(t,e){var n=this.p0.x+t*(this.p1.x-this.p0.x),r=this.p0.y+t*(this.p1.y-this.p0.y),i=this.p1.x-this.p0.x,o=this.p1.y-this.p0.y,s=Math.sqrt(i*i+o*o),a=0,u=0;if(0!==e){if(s<=0)throw new Error("Cannot compute offset from zero-length line segment");a=e*i/s,u=e*o/s}return new C(n-u,r+a)},dn.prototype.setCoordinates=function(){if(1===arguments.length){var t=arguments[0];this.setCoordinates(t.p0,t.p1)}else if(2===arguments.length){var e=arguments[0],n=arguments[1];this.p0.x=e.x,this.p0.y=e.y,this.p1.x=n.x,this.p1.y=n.y}},dn.prototype.segmentFraction=function(t){var e=this.projectionFactor(t);return e<0?e=0:(e>1||v.isNaN(e))&&(e=1),e},dn.prototype.toString=function(){return"LINESTRING( "+this.p0.x+" "+this.p0.y+", "+this.p1.x+" "+this.p1.y+")"},dn.prototype.isHorizontal=function(){return this.p0.y===this.p1.y},dn.prototype.distance=function(){if(arguments[0]instanceof dn){var t=arguments[0];return at.distanceLineLine(this.p0,this.p1,t.p0,t.p1)}if(arguments[0]instanceof C){var e=arguments[0];return at.distancePointLine(e,this.p0,this.p1)}},dn.prototype.pointAlong=function(t){var e=new C;return e.x=this.p0.x+t*(this.p1.x-this.p0.x),e.y=this.p0.y+t*(this.p1.y-this.p0.y),e},dn.prototype.hashCode=function(){var t=v.doubleToLongBits(this.p0.x);t^=31*v.doubleToLongBits(this.p0.y);var e=Math.trunc(t)^Math.trunc(t>>32),n=v.doubleToLongBits(this.p1.x);return n^=31*v.doubleToLongBits(this.p1.y),e^Math.trunc(n)^Math.trunc(n>>32)},dn.prototype.interfaces_=function(){return[b,e]},dn.prototype.getClass=function(){return dn},dn.midPoint=function(t,e){return new C((t.x+e.x)/2,(t.y+e.y)/2)},yn.serialVersionUID.get=function(){return 0x2d2172135f411c00},Object.defineProperties(dn,yn);var _n=function(){this.tempEnv1=new X,this.tempEnv2=new X,this._overlapSeg1=new dn,this._overlapSeg2=new dn};_n.prototype.overlap=function(){if(2===arguments.length);else if(4===arguments.length){var t=arguments[1],e=arguments[2],n=arguments[3];arguments[0].getLineSegment(t,this._overlapSeg1),e.getLineSegment(n,this._overlapSeg2),this.overlap(this._overlapSeg1,this._overlapSeg2)}},_n.prototype.interfaces_=function(){return[]},_n.prototype.getClass=function(){return _n};var mn=function(){this._pts=null,this._start=null,this._end=null,this._env=null,this._context=null,this._id=null;var t=arguments[0],e=arguments[1],n=arguments[2],r=arguments[3];this._pts=t,this._start=e,this._end=n,this._context=r};mn.prototype.getLineSegment=function(t,e){e.p0=this._pts[t],e.p1=this._pts[t+1]},mn.prototype.computeSelect=function(t,e,n,r){var i=this._pts[e],o=this._pts[n];if(r.tempEnv1.init(i,o),n-e==1)return r.select(this,e),null;if(!t.intersects(r.tempEnv1))return null;var s=Math.trunc((e+n)/2);e<s&&this.computeSelect(t,e,s,r),s<n&&this.computeSelect(t,s,n,r)},mn.prototype.getCoordinates=function(){for(var t=new Array(this._end-this._start+1).fill(null),e=0,n=this._start;n<=this._end;n++)t[e++]=this._pts[n];return t},mn.prototype.computeOverlaps=function(t,e){this.computeOverlapsInternal(this._start,this._end,t,t._start,t._end,e)},mn.prototype.setId=function(t){this._id=t},mn.prototype.select=function(t,e){this.computeSelect(t,this._start,this._end,e)},mn.prototype.getEnvelope=function(){if(null===this._env){var t=this._pts[this._start],e=this._pts[this._end];this._env=new X(t,e)}return this._env},mn.prototype.getEndIndex=function(){return this._end},mn.prototype.getStartIndex=function(){return this._start},mn.prototype.getContext=function(){return this._context},mn.prototype.getId=function(){return this._id},mn.prototype.computeOverlapsInternal=function(t,e,n,r,i,o){var s=this._pts[t],a=this._pts[e],u=n._pts[r],l=n._pts[i];if(e-t==1&&i-r==1)return o.overlap(this,t,n,r),null;if(o.tempEnv1.init(s,a),o.tempEnv2.init(u,l),!o.tempEnv1.intersects(o.tempEnv2))return null;var c=Math.trunc((t+e)/2),h=Math.trunc((r+i)/2);t<c&&(r<h&&this.computeOverlapsInternal(t,c,n,r,h,o),h<i&&this.computeOverlapsInternal(t,c,n,h,i,o)),c<e&&(r<h&&this.computeOverlapsInternal(c,e,n,r,h,o),h<i&&this.computeOverlapsInternal(c,e,n,h,i,o))},mn.prototype.interfaces_=function(){return[]},mn.prototype.getClass=function(){return mn};var vn=function(){};vn.prototype.interfaces_=function(){return[]},vn.prototype.getClass=function(){return vn},vn.getChainStartIndices=function(t){var e=0,n=new It;n.add(new A(e));do{var r=vn.findChainEnd(t,e);n.add(new A(r)),e=r}while(e<t.length-1);return vn.toIntArray(n)},vn.findChainEnd=function(t,e){for(var n=e;n<t.length-1&&t[n].equals2D(t[n+1]);)n++;if(n>=t.length-1)return t.length-1;for(var r=Be.quadrant(t[n],t[n+1]),i=e+1;i<t.length&&(t[i-1].equals2D(t[i])||Be.quadrant(t[i-1],t[i])===r);)i++;return i-1},vn.getChains=function(){if(1===arguments.length){var t=arguments[0];return vn.getChains(t,null)}if(2===arguments.length){for(var e=arguments[0],n=arguments[1],r=new It,i=vn.getChainStartIndices(e),o=0;o<i.length-1;o++){var s=new mn(e,i[o],i[o+1],n);r.add(s)}return r}},vn.toIntArray=function(t){for(var e=new Array(t.size()).fill(null),n=0;n<e.length;n++)e[n]=t.get(n).intValue();return e};var xn=function(){};xn.prototype.computeNodes=function(t){},xn.prototype.getNodedSubstrings=function(){},xn.prototype.interfaces_=function(){return[]},xn.prototype.getClass=function(){return xn};var bn=function(){if(this._segInt=null,0===arguments.length);else if(1===arguments.length){var t=arguments[0];this.setSegmentIntersector(t)}};bn.prototype.setSegmentIntersector=function(t){this._segInt=t},bn.prototype.interfaces_=function(){return[xn]},bn.prototype.getClass=function(){return bn};var En=function(t){function e(e){e?t.call(this,e):t.call(this),this._monoChains=new It,this._index=new sn,this._idCounter=0,this._nodedSegStrings=null,this._nOverlaps=0}t&&(e.__proto__=t),(e.prototype=Object.create(t&&t.prototype)).constructor=e;var n={SegmentOverlapAction:{configurable:!0}};return e.prototype.getMonotoneChains=function(){return this._monoChains},e.prototype.getNodedSubstrings=function(){return gn.getNodedSubstrings(this._nodedSegStrings)},e.prototype.getIndex=function(){return this._index},e.prototype.add=function(t){for(var e=vn.getChains(t.getCoordinates(),t).iterator();e.hasNext();){var n=e.next();n.setId(this._idCounter++),this._index.insert(n.getEnvelope(),n),this._monoChains.add(n)}},e.prototype.computeNodes=function(t){this._nodedSegStrings=t;for(var e=t.iterator();e.hasNext();)this.add(e.next());this.intersectChains()},e.prototype.intersectChains=function(){for(var t=new In(this._segInt),e=this._monoChains.iterator();e.hasNext();)for(var n=e.next(),r=this._index.query(n.getEnvelope()).iterator();r.hasNext();){var i=r.next();if(i.getId()>n.getId()&&(n.computeOverlaps(i,t),this._nOverlaps++),this._segInt.isDone())return null}},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},n.SegmentOverlapAction.get=function(){return In},Object.defineProperties(e,n),e}(bn),In=function(t){function e(){t.call(this),this._si=null;var e=arguments[0];this._si=e}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.overlap=function(){if(4!==arguments.length)return t.prototype.overlap.apply(this,arguments);var e=arguments[1],n=arguments[2],r=arguments[3],i=arguments[0].getContext(),o=n.getContext();this._si.processIntersections(i,e,o,r)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(_n),Cn=function t(){if(this._quadrantSegments=t.DEFAULT_QUADRANT_SEGMENTS,this._endCapStyle=t.CAP_ROUND,this._joinStyle=t.JOIN_ROUND,this._mitreLimit=t.DEFAULT_MITRE_LIMIT,this._isSingleSided=!1,this._simplifyFactor=t.DEFAULT_SIMPLIFY_FACTOR,0===arguments.length);else if(1===arguments.length){var e=arguments[0];this.setQuadrantSegments(e)}else if(2===arguments.length){var n=arguments[0],r=arguments[1];this.setQuadrantSegments(n),this.setEndCapStyle(r)}else if(4===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2],a=arguments[3];this.setQuadrantSegments(i),this.setEndCapStyle(o),this.setJoinStyle(s),this.setMitreLimit(a)}},Sn={CAP_ROUND:{configurable:!0},CAP_FLAT:{configurable:!0},CAP_SQUARE:{configurable:!0},JOIN_ROUND:{configurable:!0},JOIN_MITRE:{configurable:!0},JOIN_BEVEL:{configurable:!0},DEFAULT_QUADRANT_SEGMENTS:{configurable:!0},DEFAULT_MITRE_LIMIT:{configurable:!0},DEFAULT_SIMPLIFY_FACTOR:{configurable:!0}};Cn.prototype.getEndCapStyle=function(){return this._endCapStyle},Cn.prototype.isSingleSided=function(){return this._isSingleSided},Cn.prototype.setQuadrantSegments=function(t){this._quadrantSegments=t,0===this._quadrantSegments&&(this._joinStyle=Cn.JOIN_BEVEL),this._quadrantSegments<0&&(this._joinStyle=Cn.JOIN_MITRE,this._mitreLimit=Math.abs(this._quadrantSegments)),t<=0&&(this._quadrantSegments=1),this._joinStyle!==Cn.JOIN_ROUND&&(this._quadrantSegments=Cn.DEFAULT_QUADRANT_SEGMENTS)},Cn.prototype.getJoinStyle=function(){return this._joinStyle},Cn.prototype.setJoinStyle=function(t){this._joinStyle=t},Cn.prototype.setSimplifyFactor=function(t){this._simplifyFactor=t<0?0:t},Cn.prototype.getSimplifyFactor=function(){return this._simplifyFactor},Cn.prototype.getQuadrantSegments=function(){return this._quadrantSegments},Cn.prototype.setEndCapStyle=function(t){this._endCapStyle=t},Cn.prototype.getMitreLimit=function(){return this._mitreLimit},Cn.prototype.setMitreLimit=function(t){this._mitreLimit=t},Cn.prototype.setSingleSided=function(t){this._isSingleSided=t},Cn.prototype.interfaces_=function(){return[]},Cn.prototype.getClass=function(){return Cn},Cn.bufferDistanceError=function(t){var e=Math.PI/2/t;return 1-Math.cos(e/2)},Sn.CAP_ROUND.get=function(){return 1},Sn.CAP_FLAT.get=function(){return 2},Sn.CAP_SQUARE.get=function(){return 3},Sn.JOIN_ROUND.get=function(){return 1},Sn.JOIN_MITRE.get=function(){return 2},Sn.JOIN_BEVEL.get=function(){return 3},Sn.DEFAULT_QUADRANT_SEGMENTS.get=function(){return 8},Sn.DEFAULT_MITRE_LIMIT.get=function(){return 5},Sn.DEFAULT_SIMPLIFY_FACTOR.get=function(){return.01},Object.defineProperties(Cn,Sn);var wn=function(t){this._distanceTol=null,this._isDeleted=null,this._angleOrientation=at.COUNTERCLOCKWISE,this._inputLine=t||null},Nn={INIT:{configurable:!0},DELETE:{configurable:!0},KEEP:{configurable:!0},NUM_PTS_TO_CHECK:{configurable:!0}};wn.prototype.isDeletable=function(t,e,n,r){var i=this._inputLine[t],o=this._inputLine[e],s=this._inputLine[n];return!!this.isConcave(i,o,s)&&!!this.isShallow(i,o,s,r)&&this.isShallowSampled(i,o,t,n,r)},wn.prototype.deleteShallowConcavities=function(){for(var t=1,e=this.findNextNonDeletedIndex(t),n=this.findNextNonDeletedIndex(e),r=!1;n<this._inputLine.length;){var i=!1;this.isDeletable(t,e,n,this._distanceTol)&&(this._isDeleted[e]=wn.DELETE,i=!0,r=!0),t=i?n:e,e=this.findNextNonDeletedIndex(t),n=this.findNextNonDeletedIndex(e)}return r},wn.prototype.isShallowConcavity=function(t,e,n,r){return at.computeOrientation(t,e,n)===this._angleOrientation&&at.distancePointLine(e,t,n)<r},wn.prototype.isShallowSampled=function(t,e,n,r,i){var o=Math.trunc((r-n)/wn.NUM_PTS_TO_CHECK);o<=0&&(o=1);for(var s=n;s<r;s+=o)if(!this.isShallow(t,e,this._inputLine[s],i))return!1;return!0},wn.prototype.isConcave=function(t,e,n){return at.computeOrientation(t,e,n)===this._angleOrientation},wn.prototype.simplify=function(t){this._distanceTol=Math.abs(t),t<0&&(this._angleOrientation=at.CLOCKWISE),this._isDeleted=new Array(this._inputLine.length).fill(null);var e=!1;do{e=this.deleteShallowConcavities()}while(e);return this.collapseLine()},wn.prototype.findNextNonDeletedIndex=function(t){for(var e=t+1;e<this._inputLine.length&&this._isDeleted[e]===wn.DELETE;)e++;return e},wn.prototype.isShallow=function(t,e,n,r){return at.distancePointLine(e,t,n)<r},wn.prototype.collapseLine=function(){for(var t=new St,e=0;e<this._inputLine.length;e++)this._isDeleted[e]!==wn.DELETE&&t.add(this._inputLine[e]);return t.toCoordinateArray()},wn.prototype.interfaces_=function(){return[]},wn.prototype.getClass=function(){return wn},wn.simplify=function(t,e){return new wn(t).simplify(e)},Nn.INIT.get=function(){return 0},Nn.DELETE.get=function(){return 1},Nn.KEEP.get=function(){return 1},Nn.NUM_PTS_TO_CHECK.get=function(){return 10},Object.defineProperties(wn,Nn);var Mn=function(){this._ptList=null,this._precisionModel=null,this._minimimVertexDistance=0,this._ptList=new It},Ln={COORDINATE_ARRAY_TYPE:{configurable:!0}};Mn.prototype.getCoordinates=function(){return this._ptList.toArray(Mn.COORDINATE_ARRAY_TYPE)},Mn.prototype.setPrecisionModel=function(t){this._precisionModel=t},Mn.prototype.addPt=function(t){var e=new C(t);if(this._precisionModel.makePrecise(e),this.isRedundant(e))return null;this._ptList.add(e)},Mn.prototype.revere=function(){},Mn.prototype.addPts=function(t,e){if(e)for(var n=0;n<t.length;n++)this.addPt(t[n]);else for(var r=t.length-1;r>=0;r--)this.addPt(t[r])},Mn.prototype.isRedundant=function(t){if(this._ptList.size()<1)return!1;var e=this._ptList.get(this._ptList.size()-1);return t.distance(e)<this._minimimVertexDistance},Mn.prototype.toString=function(){return(new _e).createLineString(this.getCoordinates()).toString()},Mn.prototype.closeRing=function(){if(this._ptList.size()<1)return null;var t=new C(this._ptList.get(0)),e=this._ptList.get(this._ptList.size()-1);if(t.equals(e))return null;this._ptList.add(t)},Mn.prototype.setMinimumVertexDistance=function(t){this._minimimVertexDistance=t},Mn.prototype.interfaces_=function(){return[]},Mn.prototype.getClass=function(){return Mn},Ln.COORDINATE_ARRAY_TYPE.get=function(){return new Array(0).fill(null)},Object.defineProperties(Mn,Ln);var Pn=function(){},On={PI_TIMES_2:{configurable:!0},PI_OVER_2:{configurable:!0},PI_OVER_4:{configurable:!0},COUNTERCLOCKWISE:{configurable:!0},CLOCKWISE:{configurable:!0},NONE:{configurable:!0}};Pn.prototype.interfaces_=function(){return[]},Pn.prototype.getClass=function(){return Pn},Pn.toDegrees=function(t){return 180*t/Math.PI},Pn.normalize=function(t){for(;t>Math.PI;)t-=Pn.PI_TIMES_2;for(;t<=-Math.PI;)t+=Pn.PI_TIMES_2;return t},Pn.angle=function(){if(1===arguments.length){var t=arguments[0];return Math.atan2(t.y,t.x)}if(2===arguments.length){var e=arguments[0],n=arguments[1],r=n.x-e.x,i=n.y-e.y;return Math.atan2(i,r)}},Pn.isAcute=function(t,e,n){var r=t.x-e.x,i=t.y-e.y;return r*(n.x-e.x)+i*(n.y-e.y)>0},Pn.isObtuse=function(t,e,n){var r=t.x-e.x,i=t.y-e.y;return r*(n.x-e.x)+i*(n.y-e.y)<0},Pn.interiorAngle=function(t,e,n){var r=Pn.angle(e,t),i=Pn.angle(e,n);return Math.abs(i-r)},Pn.normalizePositive=function(t){if(t<0){for(;t<0;)t+=Pn.PI_TIMES_2;t>=Pn.PI_TIMES_2&&(t=0)}else{for(;t>=Pn.PI_TIMES_2;)t-=Pn.PI_TIMES_2;t<0&&(t=0)}return t},Pn.angleBetween=function(t,e,n){var r=Pn.angle(e,t),i=Pn.angle(e,n);return Pn.diff(r,i)},Pn.diff=function(t,e){var n=null;return(n=t<e?e-t:t-e)>Math.PI&&(n=2*Math.PI-n),n},Pn.toRadians=function(t){return t*Math.PI/180},Pn.getTurn=function(t,e){var n=Math.sin(e-t);return n>0?Pn.COUNTERCLOCKWISE:n<0?Pn.CLOCKWISE:Pn.NONE},Pn.angleBetweenOriented=function(t,e,n){var r=Pn.angle(e,t),i=Pn.angle(e,n)-r;return i<=-Math.PI?i+Pn.PI_TIMES_2:i>Math.PI?i-Pn.PI_TIMES_2:i},On.PI_TIMES_2.get=function(){return 2*Math.PI},On.PI_OVER_2.get=function(){return Math.PI/2},On.PI_OVER_4.get=function(){return Math.PI/4},On.COUNTERCLOCKWISE.get=function(){return at.COUNTERCLOCKWISE},On.CLOCKWISE.get=function(){return at.CLOCKWISE},On.NONE.get=function(){return at.COLLINEAR},Object.defineProperties(Pn,On);var Rn=function t(){this._maxCurveSegmentError=0,this._filletAngleQuantum=null,this._closingSegLengthFactor=1,this._segList=null,this._distance=0,this._precisionModel=null,this._bufParams=null,this._li=null,this._s0=null,this._s1=null,this._s2=null,this._seg0=new dn,this._seg1=new dn,this._offset0=new dn,this._offset1=new dn,this._side=0,this._hasNarrowConcaveAngle=!1;var e=arguments[0],n=arguments[1],r=arguments[2];this._precisionModel=e,this._bufParams=n,this._li=new it,this._filletAngleQuantum=Math.PI/2/n.getQuadrantSegments(),n.getQuadrantSegments()>=8&&n.getJoinStyle()===Cn.JOIN_ROUND&&(this._closingSegLengthFactor=t.MAX_CLOSING_SEG_LEN_FACTOR),this.init(r)},Tn={OFFSET_SEGMENT_SEPARATION_FACTOR:{configurable:!0},INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR:{configurable:!0},CURVE_VERTEX_SNAP_DISTANCE_FACTOR:{configurable:!0},MAX_CLOSING_SEG_LEN_FACTOR:{configurable:!0}};Rn.prototype.addNextSegment=function(t,e){if(this._s0=this._s1,this._s1=this._s2,this._s2=t,this._seg0.setCoordinates(this._s0,this._s1),this.computeOffsetSegment(this._seg0,this._side,this._distance,this._offset0),this._seg1.setCoordinates(this._s1,this._s2),this.computeOffsetSegment(this._seg1,this._side,this._distance,this._offset1),this._s1.equals(this._s2))return null;var n=at.computeOrientation(this._s0,this._s1,this._s2),r=n===at.CLOCKWISE&&this._side===Se.LEFT||n===at.COUNTERCLOCKWISE&&this._side===Se.RIGHT;0===n?this.addCollinear(e):r?this.addOutsideTurn(n,e):this.addInsideTurn(n,e)},Rn.prototype.addLineEndCap=function(t,e){var n=new dn(t,e),r=new dn;this.computeOffsetSegment(n,Se.LEFT,this._distance,r);var i=new dn;this.computeOffsetSegment(n,Se.RIGHT,this._distance,i);var o=e.x-t.x,s=e.y-t.y,a=Math.atan2(s,o);switch(this._bufParams.getEndCapStyle()){case Cn.CAP_ROUND:this._segList.addPt(r.p1),this.addFilletArc(e,a+Math.PI/2,a-Math.PI/2,at.CLOCKWISE,this._distance),this._segList.addPt(i.p1);break;case Cn.CAP_FLAT:this._segList.addPt(r.p1),this._segList.addPt(i.p1);break;case Cn.CAP_SQUARE:var u=new C;u.x=Math.abs(this._distance)*Math.cos(a),u.y=Math.abs(this._distance)*Math.sin(a);var l=new C(r.p1.x+u.x,r.p1.y+u.y),c=new C(i.p1.x+u.x,i.p1.y+u.y);this._segList.addPt(l),this._segList.addPt(c)}},Rn.prototype.getCoordinates=function(){return this._segList.getCoordinates()},Rn.prototype.addMitreJoin=function(t,e,n,r){var i=!0,o=null;try{o=Y.intersection(e.p0,e.p1,n.p0,n.p1),(r<=0?1:o.distance(t)/Math.abs(r))>this._bufParams.getMitreLimit()&&(i=!1)}catch(t){if(!(t instanceof z))throw t;o=new C(0,0),i=!1}i?this._segList.addPt(o):this.addLimitedMitreJoin(e,n,r,this._bufParams.getMitreLimit())},Rn.prototype.addFilletCorner=function(t,e,n,r,i){var o=e.x-t.x,s=e.y-t.y,a=Math.atan2(s,o),u=n.x-t.x,l=n.y-t.y,c=Math.atan2(l,u);r===at.CLOCKWISE?a<=c&&(a+=2*Math.PI):a>=c&&(a-=2*Math.PI),this._segList.addPt(e),this.addFilletArc(t,a,c,r,i),this._segList.addPt(n)},Rn.prototype.addOutsideTurn=function(t,e){if(this._offset0.p1.distance(this._offset1.p0)<this._distance*Rn.OFFSET_SEGMENT_SEPARATION_FACTOR)return this._segList.addPt(this._offset0.p1),null;this._bufParams.getJoinStyle()===Cn.JOIN_MITRE?this.addMitreJoin(this._s1,this._offset0,this._offset1,this._distance):this._bufParams.getJoinStyle()===Cn.JOIN_BEVEL?this.addBevelJoin(this._offset0,this._offset1):(e&&this._segList.addPt(this._offset0.p1),this.addFilletCorner(this._s1,this._offset0.p1,this._offset1.p0,t,this._distance),this._segList.addPt(this._offset1.p0))},Rn.prototype.createSquare=function(t){this._segList.addPt(new C(t.x+this._distance,t.y+this._distance)),this._segList.addPt(new C(t.x+this._distance,t.y-this._distance)),this._segList.addPt(new C(t.x-this._distance,t.y-this._distance)),this._segList.addPt(new C(t.x-this._distance,t.y+this._distance)),this._segList.closeRing()},Rn.prototype.addSegments=function(t,e){this._segList.addPts(t,e)},Rn.prototype.addFirstSegment=function(){this._segList.addPt(this._offset1.p0)},Rn.prototype.addLastSegment=function(){this._segList.addPt(this._offset1.p1)},Rn.prototype.initSideSegments=function(t,e,n){this._s1=t,this._s2=e,this._side=n,this._seg1.setCoordinates(t,e),this.computeOffsetSegment(this._seg1,n,this._distance,this._offset1)},Rn.prototype.addLimitedMitreJoin=function(t,e,n,r){var i=this._seg0.p1,o=Pn.angle(i,this._seg0.p0),s=Pn.angleBetweenOriented(this._seg0.p0,i,this._seg1.p1)/2,a=Pn.normalize(o+s),u=Pn.normalize(a+Math.PI),l=r*n,c=n-l*Math.abs(Math.sin(s)),h=i.x+l*Math.cos(u),p=i.y+l*Math.sin(u),f=new C(h,p),g=new dn(i,f),d=g.pointAlongOffset(1,c),y=g.pointAlongOffset(1,-c);this._side===Se.LEFT?(this._segList.addPt(d),this._segList.addPt(y)):(this._segList.addPt(y),this._segList.addPt(d))},Rn.prototype.computeOffsetSegment=function(t,e,n,r){var i=e===Se.LEFT?1:-1,o=t.p1.x-t.p0.x,s=t.p1.y-t.p0.y,a=Math.sqrt(o*o+s*s),u=i*n*o/a,l=i*n*s/a;r.p0.x=t.p0.x-l,r.p0.y=t.p0.y+u,r.p1.x=t.p1.x-l,r.p1.y=t.p1.y+u},Rn.prototype.addFilletArc=function(t,e,n,r,i){var o=r===at.CLOCKWISE?-1:1,s=Math.abs(e-n),a=Math.trunc(s/this._filletAngleQuantum+.5);if(a<1)return null;for(var u=s/a,l=0,c=new C;l<s;){var h=e+o*l;c.x=t.x+i*Math.cos(h),c.y=t.y+i*Math.sin(h),this._segList.addPt(c),l+=u}},Rn.prototype.addInsideTurn=function(t,e){if(this._li.computeIntersection(this._offset0.p0,this._offset0.p1,this._offset1.p0,this._offset1.p1),this._li.hasIntersection())this._segList.addPt(this._li.getIntersection(0));else if(this._hasNarrowConcaveAngle=!0,this._offset0.p1.distance(this._offset1.p0)<this._distance*Rn.INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR)this._segList.addPt(this._offset0.p1);else{if(this._segList.addPt(this._offset0.p1),this._closingSegLengthFactor>0){var n=new C((this._closingSegLengthFactor*this._offset0.p1.x+this._s1.x)/(this._closingSegLengthFactor+1),(this._closingSegLengthFactor*this._offset0.p1.y+this._s1.y)/(this._closingSegLengthFactor+1));this._segList.addPt(n);var r=new C((this._closingSegLengthFactor*this._offset1.p0.x+this._s1.x)/(this._closingSegLengthFactor+1),(this._closingSegLengthFactor*this._offset1.p0.y+this._s1.y)/(this._closingSegLengthFactor+1));this._segList.addPt(r)}else this._segList.addPt(this._s1);this._segList.addPt(this._offset1.p0)}},Rn.prototype.createCircle=function(t){var e=new C(t.x+this._distance,t.y);this._segList.addPt(e),this.addFilletArc(t,0,2*Math.PI,-1,this._distance),this._segList.closeRing()},Rn.prototype.addBevelJoin=function(t,e){this._segList.addPt(t.p1),this._segList.addPt(e.p0)},Rn.prototype.init=function(t){this._distance=t,this._maxCurveSegmentError=t*(1-Math.cos(this._filletAngleQuantum/2)),this._segList=new Mn,this._segList.setPrecisionModel(this._precisionModel),this._segList.setMinimumVertexDistance(t*Rn.CURVE_VERTEX_SNAP_DISTANCE_FACTOR)},Rn.prototype.addCollinear=function(t){this._li.computeIntersection(this._s0,this._s1,this._s1,this._s2),this._li.getIntersectionNum()>=2&&(this._bufParams.getJoinStyle()===Cn.JOIN_BEVEL||this._bufParams.getJoinStyle()===Cn.JOIN_MITRE?(t&&this._segList.addPt(this._offset0.p1),this._segList.addPt(this._offset1.p0)):this.addFilletCorner(this._s1,this._offset0.p1,this._offset1.p0,at.CLOCKWISE,this._distance))},Rn.prototype.closeRing=function(){this._segList.closeRing()},Rn.prototype.hasNarrowConcaveAngle=function(){return this._hasNarrowConcaveAngle},Rn.prototype.interfaces_=function(){return[]},Rn.prototype.getClass=function(){return Rn},Tn.OFFSET_SEGMENT_SEPARATION_FACTOR.get=function(){return.001},Tn.INSIDE_TURN_VERTEX_SNAP_DISTANCE_FACTOR.get=function(){return.001},Tn.CURVE_VERTEX_SNAP_DISTANCE_FACTOR.get=function(){return 1e-6},Tn.MAX_CLOSING_SEG_LEN_FACTOR.get=function(){return 80},Object.defineProperties(Rn,Tn);var An=function(){this._distance=0,this._precisionModel=null,this._bufParams=null;var t=arguments[0],e=arguments[1];this._precisionModel=t,this._bufParams=e};An.prototype.getOffsetCurve=function(t,e){if(this._distance=e,0===e)return null;var n=e<0,r=Math.abs(e),i=this.getSegGen(r);t.length<=1?this.computePointCurve(t[0],i):this.computeOffsetCurve(t,n,i);var o=i.getCoordinates();return n&&wt.reverse(o),o},An.prototype.computeSingleSidedBufferCurve=function(t,e,n){var r=this.simplifyTolerance(this._distance);if(e){n.addSegments(t,!0);var i=wn.simplify(t,-r),o=i.length-1;n.initSideSegments(i[o],i[o-1],Se.LEFT),n.addFirstSegment();for(var s=o-2;s>=0;s--)n.addNextSegment(i[s],!0)}else{n.addSegments(t,!1);var a=wn.simplify(t,r),u=a.length-1;n.initSideSegments(a[0],a[1],Se.LEFT),n.addFirstSegment();for(var l=2;l<=u;l++)n.addNextSegment(a[l],!0)}n.addLastSegment(),n.closeRing()},An.prototype.computeRingBufferCurve=function(t,e,n){var r=this.simplifyTolerance(this._distance);e===Se.RIGHT&&(r=-r);var i=wn.simplify(t,r),o=i.length-1;n.initSideSegments(i[o-1],i[0],e);for(var s=1;s<=o;s++){var a=1!==s;n.addNextSegment(i[s],a)}n.closeRing()},An.prototype.computeLineBufferCurve=function(t,e){var n=this.simplifyTolerance(this._distance),r=wn.simplify(t,n),i=r.length-1;e.initSideSegments(r[0],r[1],Se.LEFT);for(var o=2;o<=i;o++)e.addNextSegment(r[o],!0);e.addLastSegment(),e.addLineEndCap(r[i-1],r[i]);var s=wn.simplify(t,-n),a=s.length-1;e.initSideSegments(s[a],s[a-1],Se.LEFT);for(var u=a-2;u>=0;u--)e.addNextSegment(s[u],!0);e.addLastSegment(),e.addLineEndCap(s[1],s[0]),e.closeRing()},An.prototype.computePointCurve=function(t,e){switch(this._bufParams.getEndCapStyle()){case Cn.CAP_ROUND:e.createCircle(t);break;case Cn.CAP_SQUARE:e.createSquare(t)}},An.prototype.getLineCurve=function(t,e){if(this._distance=e,e<0&&!this._bufParams.isSingleSided())return null;if(0===e)return null;var n=Math.abs(e),r=this.getSegGen(n);if(t.length<=1)this.computePointCurve(t[0],r);else if(this._bufParams.isSingleSided()){var i=e<0;this.computeSingleSidedBufferCurve(t,i,r)}else this.computeLineBufferCurve(t,r);return r.getCoordinates()},An.prototype.getBufferParameters=function(){return this._bufParams},An.prototype.simplifyTolerance=function(t){return t*this._bufParams.getSimplifyFactor()},An.prototype.getRingCurve=function(t,e,n){if(this._distance=n,t.length<=2)return this.getLineCurve(t,n);if(0===n)return An.copyCoordinates(t);var r=this.getSegGen(n);return this.computeRingBufferCurve(t,e,r),r.getCoordinates()},An.prototype.computeOffsetCurve=function(t,e,n){var r=this.simplifyTolerance(this._distance);if(e){var i=wn.simplify(t,-r),o=i.length-1;n.initSideSegments(i[o],i[o-1],Se.LEFT),n.addFirstSegment();for(var s=o-2;s>=0;s--)n.addNextSegment(i[s],!0)}else{var a=wn.simplify(t,r),u=a.length-1;n.initSideSegments(a[0],a[1],Se.LEFT),n.addFirstSegment();for(var l=2;l<=u;l++)n.addNextSegment(a[l],!0)}n.addLastSegment()},An.prototype.getSegGen=function(t){return new Rn(this._precisionModel,this._bufParams,t)},An.prototype.interfaces_=function(){return[]},An.prototype.getClass=function(){return An},An.copyCoordinates=function(t){for(var e=new Array(t.length).fill(null),n=0;n<e.length;n++)e[n]=new C(t[n]);return e};var Dn=function(){this._subgraphs=null,this._seg=new dn,this._cga=new at;var t=arguments[0];this._subgraphs=t},Fn={DepthSegment:{configurable:!0}};Dn.prototype.findStabbedSegments=function(){if(1===arguments.length){for(var t=arguments[0],e=new It,n=this._subgraphs.iterator();n.hasNext();){var r=n.next(),i=r.getEnvelope();t.y<i.getMinY()||t.y>i.getMaxY()||this.findStabbedSegments(t,r.getDirectedEdges(),e)}return e}if(3===arguments.length)if(P(arguments[2],Et)&&arguments[0]instanceof C&&arguments[1]instanceof qe){for(var o=arguments[0],s=arguments[1],a=arguments[2],u=s.getEdge().getCoordinates(),l=0;l<u.length-1;l++)if(this._seg.p0=u[l],this._seg.p1=u[l+1],this._seg.p0.y>this._seg.p1.y&&this._seg.reverse(),!(Math.max(this._seg.p0.x,this._seg.p1.x)<o.x||this._seg.isHorizontal()||o.y<this._seg.p0.y||o.y>this._seg.p1.y||at.computeOrientation(this._seg.p0,this._seg.p1,o)===at.RIGHT)){var c=s.getDepth(Se.LEFT);this._seg.p0.equals(u[l])||(c=s.getDepth(Se.RIGHT));var h=new kn(this._seg,c);a.add(h)}}else if(P(arguments[2],Et)&&arguments[0]instanceof C&&P(arguments[1],Et))for(var p=arguments[0],f=arguments[2],g=arguments[1].iterator();g.hasNext();){var d=g.next();d.isForward()&&this.findStabbedSegments(p,d,f)}},Dn.prototype.getDepth=function(t){var e=this.findStabbedSegments(t);return 0===e.size()?0:Qe.min(e)._leftDepth},Dn.prototype.interfaces_=function(){return[]},Dn.prototype.getClass=function(){return Dn},Fn.DepthSegment.get=function(){return kn},Object.defineProperties(Dn,Fn);var kn=function(){this._upwardSeg=null,this._leftDepth=null;var t=arguments[0],e=arguments[1];this._upwardSeg=new dn(t),this._leftDepth=e};kn.prototype.compareTo=function(t){var e=t;if(this._upwardSeg.minX()>=e._upwardSeg.maxX())return 1;if(this._upwardSeg.maxX()<=e._upwardSeg.minX())return-1;var n=this._upwardSeg.orientationIndex(e._upwardSeg);return 0!==n||0!=(n=-1*e._upwardSeg.orientationIndex(this._upwardSeg))?n:this._upwardSeg.compareTo(e._upwardSeg)},kn.prototype.compareX=function(t,e){var n=t.p0.compareTo(e.p0);return 0!==n?n:t.p1.compareTo(e.p1)},kn.prototype.toString=function(){return this._upwardSeg.toString()},kn.prototype.interfaces_=function(){return[b]},kn.prototype.getClass=function(){return kn};var Gn=function(t,e,n){this.p0=t||null,this.p1=e||null,this.p2=n||null};Gn.prototype.area=function(){return Gn.area(this.p0,this.p1,this.p2)},Gn.prototype.signedArea=function(){return Gn.signedArea(this.p0,this.p1,this.p2)},Gn.prototype.interpolateZ=function(t){if(null===t)throw new m("Supplied point is null.");return Gn.interpolateZ(t,this.p0,this.p1,this.p2)},Gn.prototype.longestSideLength=function(){return Gn.longestSideLength(this.p0,this.p1,this.p2)},Gn.prototype.isAcute=function(){return Gn.isAcute(this.p0,this.p1,this.p2)},Gn.prototype.circumcentre=function(){return Gn.circumcentre(this.p0,this.p1,this.p2)},Gn.prototype.area3D=function(){return Gn.area3D(this.p0,this.p1,this.p2)},Gn.prototype.centroid=function(){return Gn.centroid(this.p0,this.p1,this.p2)},Gn.prototype.inCentre=function(){return Gn.inCentre(this.p0,this.p1,this.p2)},Gn.prototype.interfaces_=function(){return[]},Gn.prototype.getClass=function(){return Gn},Gn.area=function(t,e,n){return Math.abs(((n.x-t.x)*(e.y-t.y)-(e.x-t.x)*(n.y-t.y))/2)},Gn.signedArea=function(t,e,n){return((n.x-t.x)*(e.y-t.y)-(e.x-t.x)*(n.y-t.y))/2},Gn.det=function(t,e,n,r){return t*r-e*n},Gn.interpolateZ=function(t,e,n,r){var i=e.x,o=e.y,s=n.x-i,a=r.x-i,u=n.y-o,l=r.y-o,c=s*l-a*u,h=t.x-i,p=t.y-o,f=(l*h-a*p)/c,g=(-u*h+s*p)/c;return e.z+f*(n.z-e.z)+g*(r.z-e.z)},Gn.longestSideLength=function(t,e,n){var r=t.distance(e),i=e.distance(n),o=n.distance(t),s=r;return i>s&&(s=i),o>s&&(s=o),s},Gn.isAcute=function(t,e,n){return!!Pn.isAcute(t,e,n)&&!!Pn.isAcute(e,n,t)&&!!Pn.isAcute(n,t,e)},Gn.circumcentre=function(t,e,n){var r=n.x,i=n.y,o=t.x-r,s=t.y-i,a=e.x-r,u=e.y-i,l=2*Gn.det(o,s,a,u),c=Gn.det(s,o*o+s*s,u,a*a+u*u),h=Gn.det(o,o*o+s*s,a,a*a+u*u);return new C(r-c/l,i+h/l)},Gn.perpendicularBisector=function(t,e){var n=e.x-t.x,r=e.y-t.y,i=new Y(t.x+n/2,t.y+r/2,1),o=new Y(t.x-r+n/2,t.y+n+r/2,1);return new Y(i,o)},Gn.angleBisector=function(t,e,n){var r=e.distance(t),i=r/(r+e.distance(n)),o=n.x-t.x,s=n.y-t.y;return new C(t.x+i*o,t.y+i*s)},Gn.area3D=function(t,e,n){var r=e.x-t.x,i=e.y-t.y,o=e.z-t.z,s=n.x-t.x,a=n.y-t.y,u=n.z-t.z,l=i*u-o*a,c=o*s-r*u,h=r*a-i*s,p=l*l+c*c+h*h;return Math.sqrt(p)/2},Gn.centroid=function(t,e,n){var r=(t.x+e.x+n.x)/3,i=(t.y+e.y+n.y)/3;return new C(r,i)},Gn.inCentre=function(t,e,n){var r=e.distance(n),i=t.distance(n),o=t.distance(e),s=r+i+o,a=(r*t.x+i*e.x+o*n.x)/s,u=(r*t.y+i*e.y+o*n.y)/s;return new C(a,u)};var Bn=function(){this._inputGeom=null,this._distance=null,this._curveBuilder=null,this._curveList=new It;var t=arguments[0],e=arguments[1],n=arguments[2];this._inputGeom=t,this._distance=e,this._curveBuilder=n};Bn.prototype.addPoint=function(t){if(this._distance<=0)return null;var e=t.getCoordinates(),n=this._curveBuilder.getLineCurve(e,this._distance);this.addCurve(n,M.EXTERIOR,M.INTERIOR)},Bn.prototype.addPolygon=function(t){var e=this._distance,n=Se.LEFT;this._distance<0&&(e=-this._distance,n=Se.RIGHT);var r=t.getExteriorRing(),i=wt.removeRepeatedPoints(r.getCoordinates());if(this._distance<0&&this.isErodedCompletely(r,this._distance))return null;if(this._distance<=0&&i.length<3)return null;this.addPolygonRing(i,e,n,M.EXTERIOR,M.INTERIOR);for(var o=0;o<t.getNumInteriorRing();o++){var s=t.getInteriorRingN(o),a=wt.removeRepeatedPoints(s.getCoordinates());this._distance>0&&this.isErodedCompletely(s,-this._distance)||this.addPolygonRing(a,e,Se.opposite(n),M.INTERIOR,M.EXTERIOR)}},Bn.prototype.isTriangleErodedCompletely=function(t,e){var n=new Gn(t[0],t[1],t[2]),r=n.inCentre();return at.distancePointLine(r,n.p0,n.p1)<Math.abs(e)},Bn.prototype.addLineString=function(t){if(this._distance<=0&&!this._curveBuilder.getBufferParameters().isSingleSided())return null;var e=wt.removeRepeatedPoints(t.getCoordinates()),n=this._curveBuilder.getLineCurve(e,this._distance);this.addCurve(n,M.EXTERIOR,M.INTERIOR)},Bn.prototype.addCurve=function(t,e,n){if(null===t||t.length<2)return null;var r=new gn(t,new Re(0,M.BOUNDARY,e,n));this._curveList.add(r)},Bn.prototype.getCurves=function(){return this.add(this._inputGeom),this._curveList},Bn.prototype.addPolygonRing=function(t,e,n,r,i){if(0===e&&t.length<ee.MINIMUM_VALID_SIZE)return null;var o=r,s=i;t.length>=ee.MINIMUM_VALID_SIZE&&at.isCCW(t)&&(o=i,s=r,n=Se.opposite(n));var a=this._curveBuilder.getRingCurve(t,n,e);this.addCurve(a,o,s)},Bn.prototype.add=function(t){if(t.isEmpty())return null;t instanceof Qt?this.addPolygon(t):t instanceof Kt?this.addLineString(t):t instanceof Zt?this.addPoint(t):(t instanceof te||t instanceof zt||t instanceof ne||t instanceof qt)&&this.addCollection(t)},Bn.prototype.isErodedCompletely=function(t,e){var n=t.getCoordinates();if(n.length<4)return e<0;if(4===n.length)return this.isTriangleErodedCompletely(n,e);var r=t.getEnvelopeInternal(),i=Math.min(r.getHeight(),r.getWidth());return e<0&&2*Math.abs(e)>i},Bn.prototype.addCollection=function(t){for(var e=0;e<t.getNumGeometries();e++){var n=t.getGeometryN(e);this.add(n)}},Bn.prototype.interfaces_=function(){return[]},Bn.prototype.getClass=function(){return Bn};var jn=function(){};jn.prototype.locate=function(t){},jn.prototype.interfaces_=function(){return[]},jn.prototype.getClass=function(){return jn};var Un=function(){this._parent=null,this._atStart=null,this._max=null,this._index=null,this._subcollectionIterator=null;var t=arguments[0];this._parent=t,this._atStart=!0,this._index=0,this._max=t.getNumGeometries()};Un.prototype.next=function(){if(this._atStart)return this._atStart=!1,Un.isAtomic(this._parent)&&this._index++,this._parent;if(null!==this._subcollectionIterator){if(this._subcollectionIterator.hasNext())return this._subcollectionIterator.next();this._subcollectionIterator=null}if(this._index>=this._max)throw new r;var t=this._parent.getGeometryN(this._index++);return t instanceof qt?(this._subcollectionIterator=new Un(t),this._subcollectionIterator.next()):t},Un.prototype.remove=function(){throw new Error(this.getClass().getName())},Un.prototype.hasNext=function(){if(this._atStart)return!0;if(null!==this._subcollectionIterator){if(this._subcollectionIterator.hasNext())return!0;this._subcollectionIterator=null}return!(this._index>=this._max)},Un.prototype.interfaces_=function(){return[bt]},Un.prototype.getClass=function(){return Un},Un.isAtomic=function(t){return!(t instanceof qt)};var qn=function(){this._geom=null;var t=arguments[0];this._geom=t};qn.prototype.locate=function(t){return qn.locate(t,this._geom)},qn.prototype.interfaces_=function(){return[jn]},qn.prototype.getClass=function(){return qn},qn.isPointInRing=function(t,e){return!!e.getEnvelopeInternal().intersects(t)&&at.isPointInRing(t,e.getCoordinates())},qn.containsPointInPolygon=function(t,e){if(e.isEmpty())return!1;var n=e.getExteriorRing();if(!qn.isPointInRing(t,n))return!1;for(var r=0;r<e.getNumInteriorRing();r++){var i=e.getInteriorRingN(r);if(qn.isPointInRing(t,i))return!1}return!0},qn.containsPoint=function(t,e){if(e instanceof Qt)return qn.containsPointInPolygon(t,e);if(e instanceof qt)for(var n=new Un(e);n.hasNext();){var r=n.next();if(r!==e&&qn.containsPoint(t,r))return!0}return!1},qn.locate=function(t,e){return e.isEmpty()?M.EXTERIOR:qn.containsPoint(t,e)?M.INTERIOR:M.EXTERIOR};var zn=function(){this._edgeMap=new h,this._edgeList=null,this._ptInAreaLocation=[M.NONE,M.NONE]};zn.prototype.getNextCW=function(t){this.getEdges();var e=this._edgeList.indexOf(t),n=e-1;return 0===e&&(n=this._edgeList.size()-1),this._edgeList.get(n)},zn.prototype.propagateSideLabels=function(t){for(var e=M.NONE,n=this.iterator();n.hasNext();){var r=n.next().getLabel();r.isArea(t)&&r.getLocation(t,Se.LEFT)!==M.NONE&&(e=r.getLocation(t,Se.LEFT))}if(e===M.NONE)return null;for(var i=e,o=this.iterator();o.hasNext();){var s=o.next(),a=s.getLabel();if(a.getLocation(t,Se.ON)===M.NONE&&a.setLocation(t,Se.ON,i),a.isArea(t)){var u=a.getLocation(t,Se.LEFT),l=a.getLocation(t,Se.RIGHT);if(l!==M.NONE){if(l!==i)throw new Me("side location conflict",s.getCoordinate());u===M.NONE&&et.shouldNeverReachHere("found single null side (at "+s.getCoordinate()+")"),i=u}else et.isTrue(a.getLocation(t,Se.LEFT)===M.NONE,"found single null side"),a.setLocation(t,Se.RIGHT,i),a.setLocation(t,Se.LEFT,i)}}},zn.prototype.getCoordinate=function(){var t=this.iterator();return t.hasNext()?t.next().getCoordinate():null},zn.prototype.print=function(t){V.out.println("EdgeEndStar:   "+this.getCoordinate());for(var e=this.iterator();e.hasNext();)e.next().print(t)},zn.prototype.isAreaLabelsConsistent=function(t){return this.computeEdgeEndLabels(t.getBoundaryNodeRule()),this.checkAreaLabelsConsistent(0)},zn.prototype.checkAreaLabelsConsistent=function(t){var e=this.getEdges();if(e.size()<=0)return!0;var n=e.size()-1,r=e.get(n).getLabel().getLocation(t,Se.LEFT);et.isTrue(r!==M.NONE,"Found unlabelled area edge");for(var i=r,o=this.iterator();o.hasNext();){var s=o.next().getLabel();et.isTrue(s.isArea(t),"Found non-area edge");var a=s.getLocation(t,Se.LEFT),u=s.getLocation(t,Se.RIGHT);if(a===u)return!1;if(u!==i)return!1;i=a}return!0},zn.prototype.findIndex=function(t){this.iterator();for(var e=0;e<this._edgeList.size();e++)if(this._edgeList.get(e)===t)return e;return-1},zn.prototype.iterator=function(){return this.getEdges().iterator()},zn.prototype.getEdges=function(){return null===this._edgeList&&(this._edgeList=new It(this._edgeMap.values())),this._edgeList},zn.prototype.getLocation=function(t,e,n){return this._ptInAreaLocation[t]===M.NONE&&(this._ptInAreaLocation[t]=qn.locate(e,n[t].getGeometry())),this._ptInAreaLocation[t]},zn.prototype.toString=function(){var t=new T;t.append("EdgeEndStar:   "+this.getCoordinate()),t.append("\n");for(var e=this.iterator();e.hasNext();){var n=e.next();t.append(n),t.append("\n")}return t.toString()},zn.prototype.computeEdgeEndLabels=function(t){for(var e=this.iterator();e.hasNext();)e.next().computeLabel(t)},zn.prototype.computeLabelling=function(t){this.computeEdgeEndLabels(t[0].getBoundaryNodeRule()),this.propagateSideLabels(0),this.propagateSideLabels(1);for(var e=[!1,!1],n=this.iterator();n.hasNext();)for(var r=n.next().getLabel(),i=0;i<2;i++)r.isLine(i)&&r.getLocation(i)===M.BOUNDARY&&(e[i]=!0);for(var o=this.iterator();o.hasNext();)for(var s=o.next(),a=s.getLabel(),u=0;u<2;u++)if(a.isAnyNull(u)){var l=M.NONE;if(e[u])l=M.EXTERIOR;else{var c=s.getCoordinate();l=this.getLocation(u,c,t)}a.setAllLocationsIfNull(u,l)}},zn.prototype.getDegree=function(){return this._edgeMap.size()},zn.prototype.insertEdgeEnd=function(t,e){this._edgeMap.put(t,e),this._edgeList=null},zn.prototype.interfaces_=function(){return[]},zn.prototype.getClass=function(){return zn};var Vn=function(t){function e(){t.call(this),this._resultAreaEdgeList=null,this._label=null,this._SCANNING_FOR_INCOMING=1,this._LINKING_TO_OUTGOING=2}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.linkResultDirectedEdges=function(){this.getResultAreaEdges();for(var t=null,e=null,n=this._SCANNING_FOR_INCOMING,r=0;r<this._resultAreaEdgeList.size();r++){var i=this._resultAreaEdgeList.get(r),o=i.getSym();if(i.getLabel().isArea())switch(null===t&&i.isInResult()&&(t=i),n){case this._SCANNING_FOR_INCOMING:if(!o.isInResult())continue;e=o,n=this._LINKING_TO_OUTGOING;break;case this._LINKING_TO_OUTGOING:if(!i.isInResult())continue;e.setNext(i),n=this._SCANNING_FOR_INCOMING}}if(n===this._LINKING_TO_OUTGOING){if(null===t)throw new Me("no outgoing dirEdge found",this.getCoordinate());et.isTrue(t.isInResult(),"unable to link last incoming dirEdge"),e.setNext(t)}},e.prototype.insert=function(t){var e=t;this.insertEdgeEnd(e,e)},e.prototype.getRightmostEdge=function(){var t=this.getEdges(),e=t.size();if(e<1)return null;var n=t.get(0);if(1===e)return n;var r=t.get(e-1),i=n.getQuadrant(),o=r.getQuadrant();return Be.isNorthern(i)&&Be.isNorthern(o)?n:Be.isNorthern(i)||Be.isNorthern(o)?0!==n.getDy()?n:0!==r.getDy()?r:(et.shouldNeverReachHere("found two horizontal edges incident on node"),null):r},e.prototype.print=function(t){V.out.println("DirectedEdgeStar: "+this.getCoordinate());for(var e=this.iterator();e.hasNext();){var n=e.next();t.print("out "),n.print(t),t.println(),t.print("in "),n.getSym().print(t),t.println()}},e.prototype.getResultAreaEdges=function(){if(null!==this._resultAreaEdgeList)return this._resultAreaEdgeList;this._resultAreaEdgeList=new It;for(var t=this.iterator();t.hasNext();){var e=t.next();(e.isInResult()||e.getSym().isInResult())&&this._resultAreaEdgeList.add(e)}return this._resultAreaEdgeList},e.prototype.updateLabelling=function(t){for(var e=this.iterator();e.hasNext();){var n=e.next().getLabel();n.setAllLocationsIfNull(0,t.getLocation(0)),n.setAllLocationsIfNull(1,t.getLocation(1))}},e.prototype.linkAllDirectedEdges=function(){this.getEdges();for(var t=null,e=null,n=this._edgeList.size()-1;n>=0;n--){var r=this._edgeList.get(n),i=r.getSym();null===e&&(e=i),null!==t&&i.setNext(t),t=r}e.setNext(t)},e.prototype.computeDepths=function(){if(1===arguments.length){var t=arguments[0],e=this.findIndex(t),n=t.getDepth(Se.LEFT),r=t.getDepth(Se.RIGHT),i=this.computeDepths(e+1,this._edgeList.size(),n);if(this.computeDepths(0,e,i)!==r)throw new Me("depth mismatch at "+t.getCoordinate())}else if(3===arguments.length){for(var o=arguments[1],s=arguments[2],a=arguments[0];a<o;a++){var u=this._edgeList.get(a);u.setEdgeDepths(Se.RIGHT,s),s=u.getDepth(Se.LEFT)}return s}},e.prototype.mergeSymLabels=function(){for(var t=this.iterator();t.hasNext();){var e=t.next();e.getLabel().merge(e.getSym().getLabel())}},e.prototype.linkMinimalDirectedEdges=function(t){for(var e=null,n=null,r=this._SCANNING_FOR_INCOMING,i=this._resultAreaEdgeList.size()-1;i>=0;i--){var o=this._resultAreaEdgeList.get(i),s=o.getSym();switch(null===e&&o.getEdgeRing()===t&&(e=o),r){case this._SCANNING_FOR_INCOMING:if(s.getEdgeRing()!==t)continue;n=s,r=this._LINKING_TO_OUTGOING;break;case this._LINKING_TO_OUTGOING:if(o.getEdgeRing()!==t)continue;n.setNextMin(o),r=this._SCANNING_FOR_INCOMING}}r===this._LINKING_TO_OUTGOING&&(et.isTrue(null!==e,"found null for first outgoing dirEdge"),et.isTrue(e.getEdgeRing()===t,"unable to link last incoming dirEdge"),n.setNextMin(e))},e.prototype.getOutgoingDegree=function(){if(0===arguments.length){for(var t=0,e=this.iterator();e.hasNext();)e.next().isInResult()&&t++;return t}if(1===arguments.length){for(var n=arguments[0],r=0,i=this.iterator();i.hasNext();)i.next().getEdgeRing()===n&&r++;return r}},e.prototype.getLabel=function(){return this._label},e.prototype.findCoveredLineEdges=function(){for(var t=M.NONE,e=this.iterator();e.hasNext();){var n=e.next(),r=n.getSym();if(!n.isLineEdge()){if(n.isInResult()){t=M.INTERIOR;break}if(r.isInResult()){t=M.EXTERIOR;break}}}if(t===M.NONE)return null;for(var i=t,o=this.iterator();o.hasNext();){var s=o.next(),a=s.getSym();s.isLineEdge()?s.getEdge().setCovered(i===M.INTERIOR):(s.isInResult()&&(i=M.EXTERIOR),a.isInResult()&&(i=M.INTERIOR))}},e.prototype.computeLabelling=function(e){t.prototype.computeLabelling.call(this,e),this._label=new Re(M.NONE);for(var n=this.iterator();n.hasNext();)for(var r=n.next().getEdge().getLabel(),i=0;i<2;i++){var o=r.getLocation(i);o!==M.INTERIOR&&o!==M.BOUNDARY||this._label.setLocation(i,M.INTERIOR)}},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(zn),Yn=function(t){function e(){t.apply(this,arguments)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.createNode=function(t){return new ke(t,new Vn)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(ze),Xn=function t(){this._pts=null,this._orientation=null;var e=arguments[0];this._pts=e,this._orientation=t.orientation(e)};Xn.prototype.compareTo=function(t){var e=t;return Xn.compareOriented(this._pts,this._orientation,e._pts,e._orientation)},Xn.prototype.interfaces_=function(){return[b]},Xn.prototype.getClass=function(){return Xn},Xn.orientation=function(t){return 1===wt.increasingDirection(t)},Xn.compareOriented=function(t,e,n,r){for(var i=e?1:-1,o=r?1:-1,s=e?t.length:-1,a=r?n.length:-1,u=e?0:t.length-1,l=r?0:n.length-1;;){var c=t[u].compareTo(n[l]);if(0!==c)return c;var h=(u+=i)===s,p=(l+=o)===a;if(h&&!p)return-1;if(!h&&p)return 1;if(h&&p)return 0}};var Wn=function(){this._edges=new It,this._ocaMap=new h};Wn.prototype.print=function(t){t.print("MULTILINESTRING ( ");for(var e=0;e<this._edges.size();e++){var n=this._edges.get(e);e>0&&t.print(","),t.print("(");for(var r=n.getCoordinates(),i=0;i<r.length;i++)i>0&&t.print(","),t.print(r[i].x+" "+r[i].y);t.println(")")}t.print(")  ")},Wn.prototype.addAll=function(t){for(var e=t.iterator();e.hasNext();)this.add(e.next())},Wn.prototype.findEdgeIndex=function(t){for(var e=0;e<this._edges.size();e++)if(this._edges.get(e).equals(t))return e;return-1},Wn.prototype.iterator=function(){return this._edges.iterator()},Wn.prototype.getEdges=function(){return this._edges},Wn.prototype.get=function(t){return this._edges.get(t)},Wn.prototype.findEqualEdge=function(t){var e=new Xn(t.getCoordinates());return this._ocaMap.get(e)},Wn.prototype.add=function(t){this._edges.add(t);var e=new Xn(t.getCoordinates());this._ocaMap.put(e,t)},Wn.prototype.interfaces_=function(){return[]},Wn.prototype.getClass=function(){return Wn};var Hn=function(){};Hn.prototype.processIntersections=function(t,e,n,r){},Hn.prototype.isDone=function(){},Hn.prototype.interfaces_=function(){return[]},Hn.prototype.getClass=function(){return Hn};var Kn=function(){this._hasIntersection=!1,this._hasProper=!1,this._hasProperInterior=!1,this._hasInterior=!1,this._properIntersectionPoint=null,this._li=null,this._isSelfIntersection=null,this.numIntersections=0,this.numInteriorIntersections=0,this.numProperIntersections=0,this.numTests=0;var t=arguments[0];this._li=t};Kn.prototype.isTrivialIntersection=function(t,e,n,r){if(t===n&&1===this._li.getIntersectionNum()){if(Kn.isAdjacentSegments(e,r))return!0;if(t.isClosed()){var i=t.size()-1;if(0===e&&r===i||0===r&&e===i)return!0}}return!1},Kn.prototype.getProperIntersectionPoint=function(){return this._properIntersectionPoint},Kn.prototype.hasProperInteriorIntersection=function(){return this._hasProperInterior},Kn.prototype.getLineIntersector=function(){return this._li},Kn.prototype.hasProperIntersection=function(){return this._hasProper},Kn.prototype.processIntersections=function(t,e,n,r){if(t===n&&e===r)return null;this.numTests++;var i=t.getCoordinates()[e],o=t.getCoordinates()[e+1],s=n.getCoordinates()[r],a=n.getCoordinates()[r+1];this._li.computeIntersection(i,o,s,a),this._li.hasIntersection()&&(this.numIntersections++,this._li.isInteriorIntersection()&&(this.numInteriorIntersections++,this._hasInterior=!0),this.isTrivialIntersection(t,e,n,r)||(this._hasIntersection=!0,t.addIntersections(this._li,e,0),n.addIntersections(this._li,r,1),this._li.isProper()&&(this.numProperIntersections++,this._hasProper=!0,this._hasProperInterior=!0)))},Kn.prototype.hasIntersection=function(){return this._hasIntersection},Kn.prototype.isDone=function(){return!1},Kn.prototype.hasInteriorIntersection=function(){return this._hasInterior},Kn.prototype.interfaces_=function(){return[Hn]},Kn.prototype.getClass=function(){return Kn},Kn.isAdjacentSegments=function(t,e){return 1===Math.abs(t-e)};var Jn=function(){this.coord=null,this.segmentIndex=null,this.dist=null;var t=arguments[0],e=arguments[1],n=arguments[2];this.coord=new C(t),this.segmentIndex=e,this.dist=n};Jn.prototype.getSegmentIndex=function(){return this.segmentIndex},Jn.prototype.getCoordinate=function(){return this.coord},Jn.prototype.print=function(t){t.print(this.coord),t.print(" seg # = "+this.segmentIndex),t.println(" dist = "+this.dist)},Jn.prototype.compareTo=function(t){var e=t;return this.compare(e.segmentIndex,e.dist)},Jn.prototype.isEndPoint=function(t){return 0===this.segmentIndex&&0===this.dist||this.segmentIndex===t},Jn.prototype.toString=function(){return this.coord+" seg # = "+this.segmentIndex+" dist = "+this.dist},Jn.prototype.getDistance=function(){return this.dist},Jn.prototype.compare=function(t,e){return this.segmentIndex<t?-1:this.segmentIndex>t?1:this.dist<e?-1:this.dist>e?1:0},Jn.prototype.interfaces_=function(){return[b]},Jn.prototype.getClass=function(){return Jn};var Zn=function(){this._nodeMap=new h,this.edge=null;var t=arguments[0];this.edge=t};Zn.prototype.print=function(t){t.println("Intersections:");for(var e=this.iterator();e.hasNext();)e.next().print(t)},Zn.prototype.iterator=function(){return this._nodeMap.values().iterator()},Zn.prototype.addSplitEdges=function(t){this.addEndpoints();for(var e=this.iterator(),n=e.next();e.hasNext();){var r=e.next(),i=this.createSplitEdge(n,r);t.add(i),n=r}},Zn.prototype.addEndpoints=function(){var t=this.edge.pts.length-1;this.add(this.edge.pts[0],0,0),this.add(this.edge.pts[t],t,0)},Zn.prototype.createSplitEdge=function(t,e){var n=e.segmentIndex-t.segmentIndex+2,r=this.edge.pts[e.segmentIndex],i=e.dist>0||!e.coord.equals2D(r);i||n--;var o=new Array(n).fill(null),s=0;o[s++]=new C(t.coord);for(var a=t.segmentIndex+1;a<=e.segmentIndex;a++)o[s++]=this.edge.pts[a];return i&&(o[s]=e.coord),new nr(o,new Re(this.edge._label))},Zn.prototype.add=function(t,e,n){var r=new Jn(t,e,n),i=this._nodeMap.get(r);return null!==i?i:(this._nodeMap.put(r,r),r)},Zn.prototype.isIntersection=function(t){for(var e=this.iterator();e.hasNext();)if(e.next().coord.equals(t))return!0;return!1},Zn.prototype.interfaces_=function(){return[]},Zn.prototype.getClass=function(){return Zn};var $n=function(){};$n.prototype.getChainStartIndices=function(t){var e=0,n=new It;n.add(new A(e));do{var r=this.findChainEnd(t,e);n.add(new A(r)),e=r}while(e<t.length-1);return $n.toIntArray(n)},$n.prototype.findChainEnd=function(t,e){for(var n=Be.quadrant(t[e],t[e+1]),r=e+1;r<t.length&&Be.quadrant(t[r-1],t[r])===n;)r++;return r-1},$n.prototype.interfaces_=function(){return[]},$n.prototype.getClass=function(){return $n},$n.toIntArray=function(t){for(var e=new Array(t.size()).fill(null),n=0;n<e.length;n++)e[n]=t.get(n).intValue();return e};var Qn=function(){this.e=null,this.pts=null,this.startIndex=null,this.env1=new X,this.env2=new X;var t=arguments[0];this.e=t,this.pts=t.getCoordinates();var e=new $n;this.startIndex=e.getChainStartIndices(this.pts)};Qn.prototype.getCoordinates=function(){return this.pts},Qn.prototype.getMaxX=function(t){var e=this.pts[this.startIndex[t]].x,n=this.pts[this.startIndex[t+1]].x;return e>n?e:n},Qn.prototype.getMinX=function(t){var e=this.pts[this.startIndex[t]].x,n=this.pts[this.startIndex[t+1]].x;return e<n?e:n},Qn.prototype.computeIntersectsForChain=function(){if(4===arguments.length){var t=arguments[0],e=arguments[1],n=arguments[2],r=arguments[3];this.computeIntersectsForChain(this.startIndex[t],this.startIndex[t+1],e,e.startIndex[n],e.startIndex[n+1],r)}else if(6===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2],a=arguments[3],u=arguments[4],l=arguments[5],c=this.pts[i],h=this.pts[o],p=s.pts[a],f=s.pts[u];if(o-i==1&&u-a==1)return l.addIntersections(this.e,i,s.e,a),null;if(this.env1.init(c,h),this.env2.init(p,f),!this.env1.intersects(this.env2))return null;var g=Math.trunc((i+o)/2),d=Math.trunc((a+u)/2);i<g&&(a<d&&this.computeIntersectsForChain(i,g,s,a,d,l),d<u&&this.computeIntersectsForChain(i,g,s,d,u,l)),g<o&&(a<d&&this.computeIntersectsForChain(g,o,s,a,d,l),d<u&&this.computeIntersectsForChain(g,o,s,d,u,l))}},Qn.prototype.getStartIndexes=function(){return this.startIndex},Qn.prototype.computeIntersects=function(t,e){for(var n=0;n<this.startIndex.length-1;n++)for(var r=0;r<t.startIndex.length-1;r++)this.computeIntersectsForChain(n,t,r,e)},Qn.prototype.interfaces_=function(){return[]},Qn.prototype.getClass=function(){return Qn};var tr=function t(){this._depth=Array(2).fill().map((function(){return Array(3)}));for(var e=0;e<2;e++)for(var n=0;n<3;n++)this._depth[e][n]=t.NULL_VALUE},er={NULL_VALUE:{configurable:!0}};tr.prototype.getDepth=function(t,e){return this._depth[t][e]},tr.prototype.setDepth=function(t,e,n){this._depth[t][e]=n},tr.prototype.isNull=function(){if(0===arguments.length){for(var t=0;t<2;t++)for(var e=0;e<3;e++)if(this._depth[t][e]!==tr.NULL_VALUE)return!1;return!0}if(1===arguments.length){var n=arguments[0];return this._depth[n][1]===tr.NULL_VALUE}if(2===arguments.length){var r=arguments[0],i=arguments[1];return this._depth[r][i]===tr.NULL_VALUE}},tr.prototype.normalize=function(){for(var t=0;t<2;t++)if(!this.isNull(t)){var e=this._depth[t][1];this._depth[t][2]<e&&(e=this._depth[t][2]),e<0&&(e=0);for(var n=1;n<3;n++){var r=0;this._depth[t][n]>e&&(r=1),this._depth[t][n]=r}}},tr.prototype.getDelta=function(t){return this._depth[t][Se.RIGHT]-this._depth[t][Se.LEFT]},tr.prototype.getLocation=function(t,e){return this._depth[t][e]<=0?M.EXTERIOR:M.INTERIOR},tr.prototype.toString=function(){return"A: "+this._depth[0][1]+","+this._depth[0][2]+" B: "+this._depth[1][1]+","+this._depth[1][2]},tr.prototype.add=function(){if(1===arguments.length)for(var t=arguments[0],e=0;e<2;e++)for(var n=1;n<3;n++){var r=t.getLocation(e,n);r!==M.EXTERIOR&&r!==M.INTERIOR||(this.isNull(e,n)?this._depth[e][n]=tr.depthAtLocation(r):this._depth[e][n]+=tr.depthAtLocation(r))}else if(3===arguments.length){var i=arguments[0],o=arguments[1];arguments[2]===M.INTERIOR&&this._depth[i][o]++}},tr.prototype.interfaces_=function(){return[]},tr.prototype.getClass=function(){return tr},tr.depthAtLocation=function(t){return t===M.EXTERIOR?0:t===M.INTERIOR?1:tr.NULL_VALUE},er.NULL_VALUE.get=function(){return-1},Object.defineProperties(tr,er);var nr=function(t){function e(){if(t.call(this),this.pts=null,this._env=null,this.eiList=new Zn(this),this._name=null,this._mce=null,this._isIsolated=!0,this._depth=new tr,this._depthDelta=0,1===arguments.length){var n=arguments[0];e.call(this,n,null)}else if(2===arguments.length){var r=arguments[0],i=arguments[1];this.pts=r,this._label=i}}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.getDepth=function(){return this._depth},e.prototype.getCollapsedEdge=function(){var t=new Array(2).fill(null);return t[0]=this.pts[0],t[1]=this.pts[1],new e(t,Re.toLineLabel(this._label))},e.prototype.isIsolated=function(){return this._isIsolated},e.prototype.getCoordinates=function(){return this.pts},e.prototype.setIsolated=function(t){this._isIsolated=t},e.prototype.setName=function(t){this._name=t},e.prototype.equals=function(t){if(!(t instanceof e))return!1;var n=t;if(this.pts.length!==n.pts.length)return!1;for(var r=!0,i=!0,o=this.pts.length,s=0;s<this.pts.length;s++)if(this.pts[s].equals2D(n.pts[s])||(r=!1),this.pts[s].equals2D(n.pts[--o])||(i=!1),!r&&!i)return!1;return!0},e.prototype.getCoordinate=function(){if(0===arguments.length)return this.pts.length>0?this.pts[0]:null;if(1===arguments.length){var t=arguments[0];return this.pts[t]}},e.prototype.print=function(t){t.print("edge "+this._name+": "),t.print("LINESTRING (");for(var e=0;e<this.pts.length;e++)e>0&&t.print(","),t.print(this.pts[e].x+" "+this.pts[e].y);t.print(")  "+this._label+" "+this._depthDelta)},e.prototype.computeIM=function(t){e.updateIM(this._label,t)},e.prototype.isCollapsed=function(){return!!this._label.isArea()&&3===this.pts.length&&!!this.pts[0].equals(this.pts[2])},e.prototype.isClosed=function(){return this.pts[0].equals(this.pts[this.pts.length-1])},e.prototype.getMaximumSegmentIndex=function(){return this.pts.length-1},e.prototype.getDepthDelta=function(){return this._depthDelta},e.prototype.getNumPoints=function(){return this.pts.length},e.prototype.printReverse=function(t){t.print("edge "+this._name+": ");for(var e=this.pts.length-1;e>=0;e--)t.print(this.pts[e]+" ");t.println("")},e.prototype.getMonotoneChainEdge=function(){return null===this._mce&&(this._mce=new Qn(this)),this._mce},e.prototype.getEnvelope=function(){if(null===this._env){this._env=new X;for(var t=0;t<this.pts.length;t++)this._env.expandToInclude(this.pts[t])}return this._env},e.prototype.addIntersection=function(t,e,n,r){var i=new C(t.getIntersection(r)),o=e,s=t.getEdgeDistance(n,r),a=o+1;if(a<this.pts.length){var u=this.pts[a];i.equals2D(u)&&(o=a,s=0)}this.eiList.add(i,o,s)},e.prototype.toString=function(){var t=new T;t.append("edge "+this._name+": "),t.append("LINESTRING (");for(var e=0;e<this.pts.length;e++)e>0&&t.append(","),t.append(this.pts[e].x+" "+this.pts[e].y);return t.append(")  "+this._label+" "+this._depthDelta),t.toString()},e.prototype.isPointwiseEqual=function(t){if(this.pts.length!==t.pts.length)return!1;for(var e=0;e<this.pts.length;e++)if(!this.pts[e].equals2D(t.pts[e]))return!1;return!0},e.prototype.setDepthDelta=function(t){this._depthDelta=t},e.prototype.getEdgeIntersectionList=function(){return this.eiList},e.prototype.addIntersections=function(t,e,n){for(var r=0;r<t.getIntersectionNum();r++)this.addIntersection(t,e,n,r)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e.updateIM=function(){if(2!==arguments.length)return t.prototype.updateIM.apply(this,arguments);var e=arguments[0],n=arguments[1];n.setAtLeastIfValid(e.getLocation(0,Se.ON),e.getLocation(1,Se.ON),1),e.isArea()&&(n.setAtLeastIfValid(e.getLocation(0,Se.LEFT),e.getLocation(1,Se.LEFT),2),n.setAtLeastIfValid(e.getLocation(0,Se.RIGHT),e.getLocation(1,Se.RIGHT),2))},e}(Fe),rr=function(t){this._workingPrecisionModel=null,this._workingNoder=null,this._geomFact=null,this._graph=null,this._edgeList=new Wn,this._bufParams=t||null};rr.prototype.setWorkingPrecisionModel=function(t){this._workingPrecisionModel=t},rr.prototype.insertUniqueEdge=function(t){var e=this._edgeList.findEqualEdge(t);if(null!==e){var n=e.getLabel(),r=t.getLabel();e.isPointwiseEqual(t)||(r=new Re(t.getLabel())).flip(),n.merge(r);var i=rr.depthDelta(r),o=e.getDepthDelta()+i;e.setDepthDelta(o)}else this._edgeList.add(t),t.setDepthDelta(rr.depthDelta(t.getLabel()))},rr.prototype.buildSubgraphs=function(t,e){for(var n=new It,r=t.iterator();r.hasNext();){var i=r.next(),o=i.getRightmostCoordinate(),s=new Dn(n).getDepth(o);i.computeDepth(s),i.findResultEdges(),n.add(i),e.add(i.getDirectedEdges(),i.getNodes())}},rr.prototype.createSubgraphs=function(t){for(var e=new It,n=t.getNodes().iterator();n.hasNext();){var r=n.next();if(!r.isVisited()){var i=new Pe;i.create(r),e.add(i)}}return Qe.sort(e,Qe.reverseOrder()),e},rr.prototype.createEmptyResultGeometry=function(){return this._geomFact.createPolygon()},rr.prototype.getNoder=function(t){if(null!==this._workingNoder)return this._workingNoder;var e=new En,n=new it;return n.setPrecisionModel(t),e.setSegmentIntersector(new Kn(n)),e},rr.prototype.buffer=function(t,e){var n=this._workingPrecisionModel;null===n&&(n=t.getPrecisionModel()),this._geomFact=t.getFactory();var r=new An(n,this._bufParams),i=new Bn(t,e,r).getCurves();if(i.size()<=0)return this.createEmptyResultGeometry();this.computeNodedEdges(i,n),this._graph=new Ve(new Yn),this._graph.addEdges(this._edgeList.getEdges());var o=this.createSubgraphs(this._graph),s=new Ye(this._geomFact);this.buildSubgraphs(o,s);var a=s.getPolygons();return a.size()<=0?this.createEmptyResultGeometry():this._geomFact.buildGeometry(a)},rr.prototype.computeNodedEdges=function(t,e){var n=this.getNoder(e);n.computeNodes(t);for(var r=n.getNodedSubstrings().iterator();r.hasNext();){var i=r.next(),o=i.getCoordinates();if(2!==o.length||!o[0].equals2D(o[1])){var s=i.getData(),a=new nr(i.getCoordinates(),new Re(s));this.insertUniqueEdge(a)}}},rr.prototype.setNoder=function(t){this._workingNoder=t},rr.prototype.interfaces_=function(){return[]},rr.prototype.getClass=function(){return rr},rr.depthDelta=function(t){var e=t.getLocation(0,Se.LEFT),n=t.getLocation(0,Se.RIGHT);return e===M.INTERIOR&&n===M.EXTERIOR?1:e===M.EXTERIOR&&n===M.INTERIOR?-1:0},rr.convertSegStrings=function(t){for(var e=new _e,n=new It;t.hasNext();){var r=t.next(),i=e.createLineString(r.getCoordinates());n.add(i)}return e.buildGeometry(n)};var ir=function(){if(this._noder=null,this._scaleFactor=null,this._offsetX=null,this._offsetY=null,this._isScaled=!1,2===arguments.length){var t=arguments[0],e=arguments[1];this._noder=t,this._scaleFactor=e,this._offsetX=0,this._offsetY=0,this._isScaled=!this.isIntegerPrecision()}else if(4===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2],o=arguments[3];this._noder=n,this._scaleFactor=r,this._offsetX=i,this._offsetY=o,this._isScaled=!this.isIntegerPrecision()}};ir.prototype.rescale=function(){if(P(arguments[0],xt))for(var t=arguments[0].iterator();t.hasNext();){var e=t.next();this.rescale(e.getCoordinates())}else if(arguments[0]instanceof Array){for(var n=arguments[0],r=0;r<n.length;r++)n[r].x=n[r].x/this._scaleFactor+this._offsetX,n[r].y=n[r].y/this._scaleFactor+this._offsetY;2===n.length&&n[0].equals2D(n[1])&&V.out.println(n)}},ir.prototype.scale=function(){if(P(arguments[0],xt)){for(var t=arguments[0],e=new It,n=t.iterator();n.hasNext();){var r=n.next();e.add(new gn(this.scale(r.getCoordinates()),r.getData()))}return e}if(arguments[0]instanceof Array){for(var i=arguments[0],o=new Array(i.length).fill(null),s=0;s<i.length;s++)o[s]=new C(Math.round((i[s].x-this._offsetX)*this._scaleFactor),Math.round((i[s].y-this._offsetY)*this._scaleFactor),i[s].z);return wt.removeRepeatedPoints(o)}},ir.prototype.isIntegerPrecision=function(){return 1===this._scaleFactor},ir.prototype.getNodedSubstrings=function(){var t=this._noder.getNodedSubstrings();return this._isScaled&&this.rescale(t),t},ir.prototype.computeNodes=function(t){var e=t;this._isScaled&&(e=this.scale(t)),this._noder.computeNodes(e)},ir.prototype.interfaces_=function(){return[xn]},ir.prototype.getClass=function(){return ir};var or=function(){this._li=new it,this._segStrings=null;var t=arguments[0];this._segStrings=t},sr={fact:{configurable:!0}};or.prototype.checkEndPtVertexIntersections=function(){if(0===arguments.length)for(var t=this._segStrings.iterator();t.hasNext();){var e=t.next().getCoordinates();this.checkEndPtVertexIntersections(e[0],this._segStrings),this.checkEndPtVertexIntersections(e[e.length-1],this._segStrings)}else if(2===arguments.length)for(var n=arguments[0],r=arguments[1].iterator();r.hasNext();)for(var i=r.next().getCoordinates(),o=1;o<i.length-1;o++)if(i[o].equals(n))throw new Q("found endpt/interior pt intersection at index "+o+" :pt "+n)},or.prototype.checkInteriorIntersections=function(){if(0===arguments.length)for(var t=this._segStrings.iterator();t.hasNext();)for(var e=t.next(),n=this._segStrings.iterator();n.hasNext();){var r=n.next();this.checkInteriorIntersections(e,r)}else if(2===arguments.length)for(var i=arguments[0],o=arguments[1],s=i.getCoordinates(),a=o.getCoordinates(),u=0;u<s.length-1;u++)for(var l=0;l<a.length-1;l++)this.checkInteriorIntersections(i,u,o,l);else if(4===arguments.length){var c=arguments[0],h=arguments[1],p=arguments[2],f=arguments[3];if(c===p&&h===f)return null;var g=c.getCoordinates()[h],d=c.getCoordinates()[h+1],y=p.getCoordinates()[f],_=p.getCoordinates()[f+1];if(this._li.computeIntersection(g,d,y,_),this._li.hasIntersection()&&(this._li.isProper()||this.hasInteriorIntersection(this._li,g,d)||this.hasInteriorIntersection(this._li,y,_)))throw new Q("found non-noded intersection at "+g+"-"+d+" and "+y+"-"+_)}},or.prototype.checkValid=function(){this.checkEndPtVertexIntersections(),this.checkInteriorIntersections(),this.checkCollapses()},or.prototype.checkCollapses=function(){if(0===arguments.length)for(var t=this._segStrings.iterator();t.hasNext();){var e=t.next();this.checkCollapses(e)}else if(1===arguments.length)for(var n=arguments[0].getCoordinates(),r=0;r<n.length-2;r++)this.checkCollapse(n[r],n[r+1],n[r+2])},or.prototype.hasInteriorIntersection=function(t,e,n){for(var r=0;r<t.getIntersectionNum();r++){var i=t.getIntersection(r);if(!i.equals(e)&&!i.equals(n))return!0}return!1},or.prototype.checkCollapse=function(t,e,n){if(t.equals(n))throw new Q("found non-noded collapse at "+or.fact.createLineString([t,e,n]))},or.prototype.interfaces_=function(){return[]},or.prototype.getClass=function(){return or},sr.fact.get=function(){return new _e},Object.defineProperties(or,sr);var ar=function(){this._li=null,this._pt=null,this._originalPt=null,this._ptScaled=null,this._p0Scaled=null,this._p1Scaled=null,this._scaleFactor=null,this._minx=null,this._maxx=null,this._miny=null,this._maxy=null,this._corner=new Array(4).fill(null),this._safeEnv=null;var t=arguments[0],e=arguments[1],n=arguments[2];if(this._originalPt=t,this._pt=t,this._scaleFactor=e,this._li=n,e<=0)throw new m("Scale factor must be non-zero");1!==e&&(this._pt=new C(this.scale(t.x),this.scale(t.y)),this._p0Scaled=new C,this._p1Scaled=new C),this.initCorners(this._pt)},ur={SAFE_ENV_EXPANSION_FACTOR:{configurable:!0}};ar.prototype.intersectsScaled=function(t,e){var n=Math.min(t.x,e.x),r=Math.max(t.x,e.x),i=Math.min(t.y,e.y),o=Math.max(t.y,e.y),s=this._maxx<n||this._minx>r||this._maxy<i||this._miny>o;if(s)return!1;var a=this.intersectsToleranceSquare(t,e);return et.isTrue(!(s&&a),"Found bad envelope test"),a},ar.prototype.initCorners=function(t){this._minx=t.x-.5,this._maxx=t.x+.5,this._miny=t.y-.5,this._maxy=t.y+.5,this._corner[0]=new C(this._maxx,this._maxy),this._corner[1]=new C(this._minx,this._maxy),this._corner[2]=new C(this._minx,this._miny),this._corner[3]=new C(this._maxx,this._miny)},ar.prototype.intersects=function(t,e){return 1===this._scaleFactor?this.intersectsScaled(t,e):(this.copyScaled(t,this._p0Scaled),this.copyScaled(e,this._p1Scaled),this.intersectsScaled(this._p0Scaled,this._p1Scaled))},ar.prototype.scale=function(t){return Math.round(t*this._scaleFactor)},ar.prototype.getCoordinate=function(){return this._originalPt},ar.prototype.copyScaled=function(t,e){e.x=this.scale(t.x),e.y=this.scale(t.y)},ar.prototype.getSafeEnvelope=function(){if(null===this._safeEnv){var t=ar.SAFE_ENV_EXPANSION_FACTOR/this._scaleFactor;this._safeEnv=new X(this._originalPt.x-t,this._originalPt.x+t,this._originalPt.y-t,this._originalPt.y+t)}return this._safeEnv},ar.prototype.intersectsPixelClosure=function(t,e){return this._li.computeIntersection(t,e,this._corner[0],this._corner[1]),!!(this._li.hasIntersection()||(this._li.computeIntersection(t,e,this._corner[1],this._corner[2]),this._li.hasIntersection()||(this._li.computeIntersection(t,e,this._corner[2],this._corner[3]),this._li.hasIntersection()||(this._li.computeIntersection(t,e,this._corner[3],this._corner[0]),this._li.hasIntersection()))))},ar.prototype.intersectsToleranceSquare=function(t,e){var n=!1,r=!1;return this._li.computeIntersection(t,e,this._corner[0],this._corner[1]),!!(this._li.isProper()||(this._li.computeIntersection(t,e,this._corner[1],this._corner[2]),this._li.isProper()||(this._li.hasIntersection()&&(n=!0),this._li.computeIntersection(t,e,this._corner[2],this._corner[3]),this._li.isProper()||(this._li.hasIntersection()&&(r=!0),this._li.computeIntersection(t,e,this._corner[3],this._corner[0]),this._li.isProper()||n&&r||t.equals(this._pt)||e.equals(this._pt)))))},ar.prototype.addSnappedNode=function(t,e){var n=t.getCoordinate(e),r=t.getCoordinate(e+1);return!!this.intersects(n,r)&&(t.addIntersection(this.getCoordinate(),e),!0)},ar.prototype.interfaces_=function(){return[]},ar.prototype.getClass=function(){return ar},ur.SAFE_ENV_EXPANSION_FACTOR.get=function(){return.75},Object.defineProperties(ar,ur);var lr=function(){this.tempEnv1=new X,this.selectedSegment=new dn};lr.prototype.select=function(){if(1===arguments.length);else if(2===arguments.length){var t=arguments[1];arguments[0].getLineSegment(t,this.selectedSegment),this.select(this.selectedSegment)}},lr.prototype.interfaces_=function(){return[]},lr.prototype.getClass=function(){return lr};var cr=function(){this._index=null;var t=arguments[0];this._index=t},hr={HotPixelSnapAction:{configurable:!0}};cr.prototype.snap=function(){if(1===arguments.length){var t=arguments[0];return this.snap(t,null,-1)}if(3===arguments.length){var e=arguments[0],n=arguments[1],r=arguments[2],i=e.getSafeEnvelope(),o=new pr(e,n,r);return this._index.query(i,{interfaces_:function(){return[Ke]},visitItem:function(t){t.select(i,o)}}),o.isNodeAdded()}},cr.prototype.interfaces_=function(){return[]},cr.prototype.getClass=function(){return cr},hr.HotPixelSnapAction.get=function(){return pr},Object.defineProperties(cr,hr);var pr=function(t){function e(){t.call(this),this._hotPixel=null,this._parentEdge=null,this._hotPixelVertexIndex=null,this._isNodeAdded=!1;var e=arguments[0],n=arguments[1],r=arguments[2];this._hotPixel=e,this._parentEdge=n,this._hotPixelVertexIndex=r}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.isNodeAdded=function(){return this._isNodeAdded},e.prototype.select=function(){if(2!==arguments.length)return t.prototype.select.apply(this,arguments);var e=arguments[1],n=arguments[0].getContext();if(null!==this._parentEdge&&n===this._parentEdge&&e===this._hotPixelVertexIndex)return null;this._isNodeAdded=this._hotPixel.addSnappedNode(n,e)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(lr),fr=function(){this._li=null,this._interiorIntersections=null;var t=arguments[0];this._li=t,this._interiorIntersections=new It};fr.prototype.processIntersections=function(t,e,n,r){if(t===n&&e===r)return null;var i=t.getCoordinates()[e],o=t.getCoordinates()[e+1],s=n.getCoordinates()[r],a=n.getCoordinates()[r+1];if(this._li.computeIntersection(i,o,s,a),this._li.hasIntersection()&&this._li.isInteriorIntersection()){for(var u=0;u<this._li.getIntersectionNum();u++)this._interiorIntersections.add(this._li.getIntersection(u));t.addIntersections(this._li,e,0),n.addIntersections(this._li,r,1)}},fr.prototype.isDone=function(){return!1},fr.prototype.getInteriorIntersections=function(){return this._interiorIntersections},fr.prototype.interfaces_=function(){return[Hn]},fr.prototype.getClass=function(){return fr};var gr=function(){this._pm=null,this._li=null,this._scaleFactor=null,this._noder=null,this._pointSnapper=null,this._nodedSegStrings=null;var t=arguments[0];this._pm=t,this._li=new it,this._li.setPrecisionModel(t),this._scaleFactor=t.getScale()};gr.prototype.checkCorrectness=function(t){var e=gn.getNodedSubstrings(t),n=new or(e);try{n.checkValid()}catch(t){if(!(t instanceof q))throw t;t.printStackTrace()}},gr.prototype.getNodedSubstrings=function(){return gn.getNodedSubstrings(this._nodedSegStrings)},gr.prototype.snapRound=function(t,e){var n=this.findInteriorIntersections(t,e);this.computeIntersectionSnaps(n),this.computeVertexSnaps(t)},gr.prototype.findInteriorIntersections=function(t,e){var n=new fr(e);return this._noder.setSegmentIntersector(n),this._noder.computeNodes(t),n.getInteriorIntersections()},gr.prototype.computeVertexSnaps=function(){if(P(arguments[0],xt))for(var t=arguments[0].iterator();t.hasNext();){var e=t.next();this.computeVertexSnaps(e)}else if(arguments[0]instanceof gn)for(var n=arguments[0],r=n.getCoordinates(),i=0;i<r.length;i++){var o=new ar(r[i],this._scaleFactor,this._li);this._pointSnapper.snap(o,n,i)&&n.addIntersection(r[i],i)}},gr.prototype.computeNodes=function(t){this._nodedSegStrings=t,this._noder=new En,this._pointSnapper=new cr(this._noder.getIndex()),this.snapRound(t,this._li)},gr.prototype.computeIntersectionSnaps=function(t){for(var e=t.iterator();e.hasNext();){var n=e.next(),r=new ar(n,this._scaleFactor,this._li);this._pointSnapper.snap(r)}},gr.prototype.interfaces_=function(){return[xn]},gr.prototype.getClass=function(){return gr};var dr=function(){if(this._argGeom=null,this._distance=null,this._bufParams=new Cn,this._resultGeometry=null,this._saveException=null,1===arguments.length){var t=arguments[0];this._argGeom=t}else if(2===arguments.length){var e=arguments[0],n=arguments[1];this._argGeom=e,this._bufParams=n}},yr={CAP_ROUND:{configurable:!0},CAP_BUTT:{configurable:!0},CAP_FLAT:{configurable:!0},CAP_SQUARE:{configurable:!0},MAX_PRECISION_DIGITS:{configurable:!0}};dr.prototype.bufferFixedPrecision=function(t){var e=new ir(new gr(new fe(1)),t.getScale()),n=new rr(this._bufParams);n.setWorkingPrecisionModel(t),n.setNoder(e),this._resultGeometry=n.buffer(this._argGeom,this._distance)},dr.prototype.bufferReducedPrecision=function(){var t=this;if(0===arguments.length){for(var e=dr.MAX_PRECISION_DIGITS;e>=0;e--){try{t.bufferReducedPrecision(e)}catch(e){if(!(e instanceof Me))throw e;t._saveException=e}if(null!==t._resultGeometry)return null}throw this._saveException}if(1===arguments.length){var n=arguments[0],r=dr.precisionScaleFactor(this._argGeom,this._distance,n),i=new fe(r);this.bufferFixedPrecision(i)}},dr.prototype.computeGeometry=function(){if(this.bufferOriginalPrecision(),null!==this._resultGeometry)return null;var t=this._argGeom.getFactory().getPrecisionModel();t.getType()===fe.FIXED?this.bufferFixedPrecision(t):this.bufferReducedPrecision()},dr.prototype.setQuadrantSegments=function(t){this._bufParams.setQuadrantSegments(t)},dr.prototype.bufferOriginalPrecision=function(){try{var t=new rr(this._bufParams);this._resultGeometry=t.buffer(this._argGeom,this._distance)}catch(t){if(!(t instanceof Q))throw t;this._saveException=t}},dr.prototype.getResultGeometry=function(t){return this._distance=t,this.computeGeometry(),this._resultGeometry},dr.prototype.setEndCapStyle=function(t){this._bufParams.setEndCapStyle(t)},dr.prototype.interfaces_=function(){return[]},dr.prototype.getClass=function(){return dr},dr.bufferOp=function(){if(2===arguments.length){var t=arguments[1];return new dr(arguments[0]).getResultGeometry(t)}if(3===arguments.length){if(Number.isInteger(arguments[2])&&arguments[0]instanceof ct&&"number"==typeof arguments[1]){var e=arguments[1],n=arguments[2],r=new dr(arguments[0]);return r.setQuadrantSegments(n),r.getResultGeometry(e)}if(arguments[2]instanceof Cn&&arguments[0]instanceof ct&&"number"==typeof arguments[1]){var i=arguments[1];return new dr(arguments[0],arguments[2]).getResultGeometry(i)}}else if(4===arguments.length){var o=arguments[1],s=arguments[2],a=arguments[3],u=new dr(arguments[0]);return u.setQuadrantSegments(s),u.setEndCapStyle(a),u.getResultGeometry(o)}},dr.precisionScaleFactor=function(t,e,n){var r=t.getEnvelopeInternal(),i=O.max(Math.abs(r.getMaxX()),Math.abs(r.getMaxY()),Math.abs(r.getMinX()),Math.abs(r.getMinY()))+2*(e>0?e:0),o=n-Math.trunc(Math.log(i)/Math.log(10)+1);return Math.pow(10,o)},yr.CAP_ROUND.get=function(){return Cn.CAP_ROUND},yr.CAP_BUTT.get=function(){return Cn.CAP_FLAT},yr.CAP_FLAT.get=function(){return Cn.CAP_FLAT},yr.CAP_SQUARE.get=function(){return Cn.CAP_SQUARE},yr.MAX_PRECISION_DIGITS.get=function(){return 12},Object.defineProperties(dr,yr);var _r=function(){this._pt=[new C,new C],this._distance=v.NaN,this._isNull=!0};_r.prototype.getCoordinates=function(){return this._pt},_r.prototype.getCoordinate=function(t){return this._pt[t]},_r.prototype.setMinimum=function(){if(1===arguments.length){var t=arguments[0];this.setMinimum(t._pt[0],t._pt[1])}else if(2===arguments.length){var e=arguments[0],n=arguments[1];if(this._isNull)return this.initialize(e,n),null;var r=e.distance(n);r<this._distance&&this.initialize(e,n,r)}},_r.prototype.initialize=function(){if(0===arguments.length)this._isNull=!0;else if(2===arguments.length){var t=arguments[0],e=arguments[1];this._pt[0].setCoordinate(t),this._pt[1].setCoordinate(e),this._distance=t.distance(e),this._isNull=!1}else if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2];this._pt[0].setCoordinate(n),this._pt[1].setCoordinate(r),this._distance=i,this._isNull=!1}},_r.prototype.getDistance=function(){return this._distance},_r.prototype.setMaximum=function(){if(1===arguments.length){var t=arguments[0];this.setMaximum(t._pt[0],t._pt[1])}else if(2===arguments.length){var e=arguments[0],n=arguments[1];if(this._isNull)return this.initialize(e,n),null;var r=e.distance(n);r>this._distance&&this.initialize(e,n,r)}},_r.prototype.interfaces_=function(){return[]},_r.prototype.getClass=function(){return _r};var mr=function(){};mr.prototype.interfaces_=function(){return[]},mr.prototype.getClass=function(){return mr},mr.computeDistance=function(){if(arguments[2]instanceof _r&&arguments[0]instanceof Kt&&arguments[1]instanceof C)for(var t=arguments[1],e=arguments[2],n=arguments[0].getCoordinates(),r=new dn,i=0;i<n.length-1;i++){r.setCoordinates(n[i],n[i+1]);var o=r.closestPoint(t);e.setMinimum(o,t)}else if(arguments[2]instanceof _r&&arguments[0]instanceof Qt&&arguments[1]instanceof C){var s=arguments[0],a=arguments[1],u=arguments[2];mr.computeDistance(s.getExteriorRing(),a,u);for(var l=0;l<s.getNumInteriorRing();l++)mr.computeDistance(s.getInteriorRingN(l),a,u)}else if(arguments[2]instanceof _r&&arguments[0]instanceof ct&&arguments[1]instanceof C){var c=arguments[0],h=arguments[1],p=arguments[2];if(c instanceof Kt)mr.computeDistance(c,h,p);else if(c instanceof Qt)mr.computeDistance(c,h,p);else if(c instanceof qt)for(var f=c,g=0;g<f.getNumGeometries();g++){var d=f.getGeometryN(g);mr.computeDistance(d,h,p)}else p.setMinimum(c.getCoordinate(),h)}else if(arguments[2]instanceof _r&&arguments[0]instanceof dn&&arguments[1]instanceof C){var y=arguments[1],_=arguments[2],m=arguments[0].closestPoint(y);_.setMinimum(m,y)}};var vr=function(t){this._maxPtDist=new _r,this._inputGeom=t||null},xr={MaxPointDistanceFilter:{configurable:!0},MaxMidpointDistanceFilter:{configurable:!0}};vr.prototype.computeMaxMidpointDistance=function(t){var e=new Er(this._inputGeom);t.apply(e),this._maxPtDist.setMaximum(e.getMaxPointDistance())},vr.prototype.computeMaxVertexDistance=function(t){var e=new br(this._inputGeom);t.apply(e),this._maxPtDist.setMaximum(e.getMaxPointDistance())},vr.prototype.findDistance=function(t){return this.computeMaxVertexDistance(t),this.computeMaxMidpointDistance(t),this._maxPtDist.getDistance()},vr.prototype.getDistancePoints=function(){return this._maxPtDist},vr.prototype.interfaces_=function(){return[]},vr.prototype.getClass=function(){return vr},xr.MaxPointDistanceFilter.get=function(){return br},xr.MaxMidpointDistanceFilter.get=function(){return Er},Object.defineProperties(vr,xr);var br=function(t){this._maxPtDist=new _r,this._minPtDist=new _r,this._geom=t||null};br.prototype.filter=function(t){this._minPtDist.initialize(),mr.computeDistance(this._geom,t,this._minPtDist),this._maxPtDist.setMaximum(this._minPtDist)},br.prototype.getMaxPointDistance=function(){return this._maxPtDist},br.prototype.interfaces_=function(){return[ft]},br.prototype.getClass=function(){return br};var Er=function(t){this._maxPtDist=new _r,this._minPtDist=new _r,this._geom=t||null};Er.prototype.filter=function(t,e){if(0===e)return null;var n=t.getCoordinate(e-1),r=t.getCoordinate(e),i=new C((n.x+r.x)/2,(n.y+r.y)/2);this._minPtDist.initialize(),mr.computeDistance(this._geom,i,this._minPtDist),this._maxPtDist.setMaximum(this._minPtDist)},Er.prototype.isDone=function(){return!1},Er.prototype.isGeometryChanged=function(){return!1},Er.prototype.getMaxPointDistance=function(){return this._maxPtDist},Er.prototype.interfaces_=function(){return[Ut]},Er.prototype.getClass=function(){return Er};var Ir=function(t){this._comps=t||null};Ir.prototype.filter=function(t){t instanceof Qt&&this._comps.add(t)},Ir.prototype.interfaces_=function(){return[jt]},Ir.prototype.getClass=function(){return Ir},Ir.getPolygons=function(){if(1===arguments.length){var t=arguments[0];return Ir.getPolygons(t,new It)}if(2===arguments.length){var e=arguments[0],n=arguments[1];return e instanceof Qt?n.add(e):e instanceof qt&&e.apply(new Ir(n)),n}};var Cr=function(){if(this._lines=null,this._isForcedToLineString=!1,1===arguments.length){var t=arguments[0];this._lines=t}else if(2===arguments.length){var e=arguments[0],n=arguments[1];this._lines=e,this._isForcedToLineString=n}};Cr.prototype.filter=function(t){if(this._isForcedToLineString&&t instanceof ee){var e=t.getFactory().createLineString(t.getCoordinateSequence());return this._lines.add(e),null}t instanceof Kt&&this._lines.add(t)},Cr.prototype.setForceToLineString=function(t){this._isForcedToLineString=t},Cr.prototype.interfaces_=function(){return[lt]},Cr.prototype.getClass=function(){return Cr},Cr.getGeometry=function(){if(1===arguments.length){var t=arguments[0];return t.getFactory().buildGeometry(Cr.getLines(t))}if(2===arguments.length){var e=arguments[0],n=arguments[1];return e.getFactory().buildGeometry(Cr.getLines(e,n))}},Cr.getLines=function(){if(1===arguments.length){var t=arguments[0];return Cr.getLines(t,!1)}if(2===arguments.length){if(P(arguments[0],xt)&&P(arguments[1],xt)){for(var e=arguments[1],n=arguments[0].iterator();n.hasNext();){var r=n.next();Cr.getLines(r,e)}return e}if(arguments[0]instanceof ct&&"boolean"==typeof arguments[1]){var i=arguments[0],o=arguments[1],s=new It;return i.apply(new Cr(s,o)),s}if(arguments[0]instanceof ct&&P(arguments[1],xt)){var a=arguments[0],u=arguments[1];return a instanceof Kt?u.add(a):a.apply(new Cr(u)),u}}else if(3===arguments.length){if("boolean"==typeof arguments[2]&&P(arguments[0],xt)&&P(arguments[1],xt)){for(var l=arguments[1],c=arguments[2],h=arguments[0].iterator();h.hasNext();){var p=h.next();Cr.getLines(p,l,c)}return l}if("boolean"==typeof arguments[2]&&arguments[0]instanceof ct&&P(arguments[1],xt)){var f=arguments[1],g=arguments[2];return arguments[0].apply(new Cr(f,g)),f}}};var Sr=function(){if(this._boundaryRule=gt.OGC_SFS_BOUNDARY_RULE,this._isIn=null,this._numBoundaries=null,0===arguments.length);else if(1===arguments.length){var t=arguments[0];if(null===t)throw new m("Rule must be non-null");this._boundaryRule=t}};Sr.prototype.locateInternal=function(){if(arguments[0]instanceof C&&arguments[1]instanceof Qt){var t=arguments[0],e=arguments[1];if(e.isEmpty())return M.EXTERIOR;var n=e.getExteriorRing(),r=this.locateInPolygonRing(t,n);if(r===M.EXTERIOR)return M.EXTERIOR;if(r===M.BOUNDARY)return M.BOUNDARY;for(var i=0;i<e.getNumInteriorRing();i++){var o=e.getInteriorRingN(i),s=this.locateInPolygonRing(t,o);if(s===M.INTERIOR)return M.EXTERIOR;if(s===M.BOUNDARY)return M.BOUNDARY}return M.INTERIOR}if(arguments[0]instanceof C&&arguments[1]instanceof Kt){var a=arguments[0],u=arguments[1];if(!u.getEnvelopeInternal().intersects(a))return M.EXTERIOR;var l=u.getCoordinates();return u.isClosed()||!a.equals(l[0])&&!a.equals(l[l.length-1])?at.isOnLine(a,l)?M.INTERIOR:M.EXTERIOR:M.BOUNDARY}if(arguments[0]instanceof C&&arguments[1]instanceof Zt){var c=arguments[0];return arguments[1].getCoordinate().equals2D(c)?M.INTERIOR:M.EXTERIOR}},Sr.prototype.locateInPolygonRing=function(t,e){return e.getEnvelopeInternal().intersects(t)?at.locatePointInRing(t,e.getCoordinates()):M.EXTERIOR},Sr.prototype.intersects=function(t,e){return this.locate(t,e)!==M.EXTERIOR},Sr.prototype.updateLocationInfo=function(t){t===M.INTERIOR&&(this._isIn=!0),t===M.BOUNDARY&&this._numBoundaries++},Sr.prototype.computeLocation=function(t,e){if(e instanceof Zt&&this.updateLocationInfo(this.locateInternal(t,e)),e instanceof Kt)this.updateLocationInfo(this.locateInternal(t,e));else if(e instanceof Qt)this.updateLocationInfo(this.locateInternal(t,e));else if(e instanceof zt)for(var n=e,r=0;r<n.getNumGeometries();r++){var i=n.getGeometryN(r);this.updateLocationInfo(this.locateInternal(t,i))}else if(e instanceof ne)for(var o=e,s=0;s<o.getNumGeometries();s++){var a=o.getGeometryN(s);this.updateLocationInfo(this.locateInternal(t,a))}else if(e instanceof qt)for(var u=new Un(e);u.hasNext();){var l=u.next();l!==e&&this.computeLocation(t,l)}},Sr.prototype.locate=function(t,e){return e.isEmpty()?M.EXTERIOR:e instanceof Kt||e instanceof Qt?this.locateInternal(t,e):(this._isIn=!1,this._numBoundaries=0,this.computeLocation(t,e),this._boundaryRule.isInBoundary(this._numBoundaries)?M.BOUNDARY:this._numBoundaries>0||this._isIn?M.INTERIOR:M.EXTERIOR)},Sr.prototype.interfaces_=function(){return[]},Sr.prototype.getClass=function(){return Sr};var wr=function t(){if(this._component=null,this._segIndex=null,this._pt=null,2===arguments.length)t.call(this,arguments[0],t.INSIDE_AREA,arguments[1]);else if(3===arguments.length){var e=arguments[0],n=arguments[1],r=arguments[2];this._component=e,this._segIndex=n,this._pt=r}},Nr={INSIDE_AREA:{configurable:!0}};wr.prototype.isInsideArea=function(){return this._segIndex===wr.INSIDE_AREA},wr.prototype.getCoordinate=function(){return this._pt},wr.prototype.getGeometryComponent=function(){return this._component},wr.prototype.getSegmentIndex=function(){return this._segIndex},wr.prototype.interfaces_=function(){return[]},wr.prototype.getClass=function(){return wr},Nr.INSIDE_AREA.get=function(){return-1},Object.defineProperties(wr,Nr);var Mr=function(t){this._pts=t||null};Mr.prototype.filter=function(t){t instanceof Zt&&this._pts.add(t)},Mr.prototype.interfaces_=function(){return[jt]},Mr.prototype.getClass=function(){return Mr},Mr.getPoints=function(){if(1===arguments.length){var t=arguments[0];return t instanceof Zt?Qe.singletonList(t):Mr.getPoints(t,new It)}if(2===arguments.length){var e=arguments[0],n=arguments[1];return e instanceof Zt?n.add(e):e instanceof qt&&e.apply(new Mr(n)),n}};var Lr=function(){this._locations=null;var t=arguments[0];this._locations=t};Lr.prototype.filter=function(t){(t instanceof Zt||t instanceof Kt||t instanceof Qt)&&this._locations.add(new wr(t,0,t.getCoordinate()))},Lr.prototype.interfaces_=function(){return[jt]},Lr.prototype.getClass=function(){return Lr},Lr.getLocations=function(t){var e=new It;return t.apply(new Lr(e)),e};var Pr=function(){if(this._geom=null,this._terminateDistance=0,this._ptLocator=new Sr,this._minDistanceLocation=null,this._minDistance=v.MAX_VALUE,2===arguments.length){var t=arguments[0],e=arguments[1];this._geom=[t,e],this._terminateDistance=0}else if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2];this._geom=new Array(2).fill(null),this._geom[0]=n,this._geom[1]=r,this._terminateDistance=i}};Pr.prototype.computeContainmentDistance=function(){if(0===arguments.length){var t=new Array(2).fill(null);if(this.computeContainmentDistance(0,t),this._minDistance<=this._terminateDistance)return null;this.computeContainmentDistance(1,t)}else if(2===arguments.length){var e=arguments[0],n=arguments[1],r=1-e,i=Ir.getPolygons(this._geom[e]);if(i.size()>0){var o=Lr.getLocations(this._geom[r]);if(this.computeContainmentDistance(o,i,n),this._minDistance<=this._terminateDistance)return this._minDistanceLocation[r]=n[0],this._minDistanceLocation[e]=n[1],null}}else if(3===arguments.length)if(arguments[2]instanceof Array&&P(arguments[0],Et)&&P(arguments[1],Et)){for(var s=arguments[0],a=arguments[1],u=arguments[2],l=0;l<s.size();l++)for(var c=s.get(l),h=0;h<a.size();h++)if(this.computeContainmentDistance(c,a.get(h),u),this._minDistance<=this._terminateDistance)return null}else if(arguments[2]instanceof Array&&arguments[0]instanceof wr&&arguments[1]instanceof Qt){var p=arguments[0],f=arguments[1],g=arguments[2],d=p.getCoordinate();if(M.EXTERIOR!==this._ptLocator.locate(d,f))return this._minDistance=0,g[0]=p,g[1]=new wr(f,d),null}},Pr.prototype.computeMinDistanceLinesPoints=function(t,e,n){for(var r=0;r<t.size();r++)for(var i=t.get(r),o=0;o<e.size();o++){var s=e.get(o);if(this.computeMinDistance(i,s,n),this._minDistance<=this._terminateDistance)return null}},Pr.prototype.computeFacetDistance=function(){var t=new Array(2).fill(null),e=Cr.getLines(this._geom[0]),n=Cr.getLines(this._geom[1]),r=Mr.getPoints(this._geom[0]),i=Mr.getPoints(this._geom[1]);return this.computeMinDistanceLines(e,n,t),this.updateMinDistance(t,!1),this._minDistance<=this._terminateDistance?null:(t[0]=null,t[1]=null,this.computeMinDistanceLinesPoints(e,i,t),this.updateMinDistance(t,!1),this._minDistance<=this._terminateDistance?null:(t[0]=null,t[1]=null,this.computeMinDistanceLinesPoints(n,r,t),this.updateMinDistance(t,!0),this._minDistance<=this._terminateDistance?null:(t[0]=null,t[1]=null,this.computeMinDistancePoints(r,i,t),void this.updateMinDistance(t,!1))))},Pr.prototype.nearestLocations=function(){return this.computeMinDistance(),this._minDistanceLocation},Pr.prototype.updateMinDistance=function(t,e){if(null===t[0])return null;e?(this._minDistanceLocation[0]=t[1],this._minDistanceLocation[1]=t[0]):(this._minDistanceLocation[0]=t[0],this._minDistanceLocation[1]=t[1])},Pr.prototype.nearestPoints=function(){return this.computeMinDistance(),[this._minDistanceLocation[0].getCoordinate(),this._minDistanceLocation[1].getCoordinate()]},Pr.prototype.computeMinDistance=function(){if(0===arguments.length){if(null!==this._minDistanceLocation)return null;if(this._minDistanceLocation=new Array(2).fill(null),this.computeContainmentDistance(),this._minDistance<=this._terminateDistance)return null;this.computeFacetDistance()}else if(3===arguments.length)if(arguments[2]instanceof Array&&arguments[0]instanceof Kt&&arguments[1]instanceof Zt){var t=arguments[0],e=arguments[1],n=arguments[2];if(t.getEnvelopeInternal().distance(e.getEnvelopeInternal())>this._minDistance)return null;for(var r=t.getCoordinates(),i=e.getCoordinate(),o=0;o<r.length-1;o++){var s=at.distancePointLine(i,r[o],r[o+1]);if(s<this._minDistance){this._minDistance=s;var a=new dn(r[o],r[o+1]).closestPoint(i);n[0]=new wr(t,o,a),n[1]=new wr(e,0,i)}if(this._minDistance<=this._terminateDistance)return null}}else if(arguments[2]instanceof Array&&arguments[0]instanceof Kt&&arguments[1]instanceof Kt){var u=arguments[0],l=arguments[1],c=arguments[2];if(u.getEnvelopeInternal().distance(l.getEnvelopeInternal())>this._minDistance)return null;for(var h=u.getCoordinates(),p=l.getCoordinates(),f=0;f<h.length-1;f++)for(var g=0;g<p.length-1;g++){var d=at.distanceLineLine(h[f],h[f+1],p[g],p[g+1]);if(d<this._minDistance){this._minDistance=d;var y=new dn(h[f],h[f+1]),_=new dn(p[g],p[g+1]),m=y.closestPoints(_);c[0]=new wr(u,f,m[0]),c[1]=new wr(l,g,m[1])}if(this._minDistance<=this._terminateDistance)return null}}},Pr.prototype.computeMinDistancePoints=function(t,e,n){for(var r=0;r<t.size();r++)for(var i=t.get(r),o=0;o<e.size();o++){var s=e.get(o),a=i.getCoordinate().distance(s.getCoordinate());if(a<this._minDistance&&(this._minDistance=a,n[0]=new wr(i,0,i.getCoordinate()),n[1]=new wr(s,0,s.getCoordinate())),this._minDistance<=this._terminateDistance)return null}},Pr.prototype.distance=function(){if(null===this._geom[0]||null===this._geom[1])throw new m("null geometries are not supported");return this._geom[0].isEmpty()||this._geom[1].isEmpty()?0:(this.computeMinDistance(),this._minDistance)},Pr.prototype.computeMinDistanceLines=function(t,e,n){for(var r=0;r<t.size();r++)for(var i=t.get(r),o=0;o<e.size();o++){var s=e.get(o);if(this.computeMinDistance(i,s,n),this._minDistance<=this._terminateDistance)return null}},Pr.prototype.interfaces_=function(){return[]},Pr.prototype.getClass=function(){return Pr},Pr.distance=function(t,e){return new Pr(t,e).distance()},Pr.isWithinDistance=function(t,e,n){return new Pr(t,e,n).distance()<=n},Pr.nearestPoints=function(t,e){return new Pr(t,e).nearestPoints()};var Or=function(){this._pt=[new C,new C],this._distance=v.NaN,this._isNull=!0};Or.prototype.getCoordinates=function(){return this._pt},Or.prototype.getCoordinate=function(t){return this._pt[t]},Or.prototype.setMinimum=function(){if(1===arguments.length){var t=arguments[0];this.setMinimum(t._pt[0],t._pt[1])}else if(2===arguments.length){var e=arguments[0],n=arguments[1];if(this._isNull)return this.initialize(e,n),null;var r=e.distance(n);r<this._distance&&this.initialize(e,n,r)}},Or.prototype.initialize=function(){if(0===arguments.length)this._isNull=!0;else if(2===arguments.length){var t=arguments[0],e=arguments[1];this._pt[0].setCoordinate(t),this._pt[1].setCoordinate(e),this._distance=t.distance(e),this._isNull=!1}else if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2];this._pt[0].setCoordinate(n),this._pt[1].setCoordinate(r),this._distance=i,this._isNull=!1}},Or.prototype.toString=function(){return $.toLineString(this._pt[0],this._pt[1])},Or.prototype.getDistance=function(){return this._distance},Or.prototype.setMaximum=function(){if(1===arguments.length){var t=arguments[0];this.setMaximum(t._pt[0],t._pt[1])}else if(2===arguments.length){var e=arguments[0],n=arguments[1];if(this._isNull)return this.initialize(e,n),null;var r=e.distance(n);r>this._distance&&this.initialize(e,n,r)}},Or.prototype.interfaces_=function(){return[]},Or.prototype.getClass=function(){return Or};var Rr=function(){};Rr.prototype.interfaces_=function(){return[]},Rr.prototype.getClass=function(){return Rr},Rr.computeDistance=function(){if(arguments[2]instanceof Or&&arguments[0]instanceof Kt&&arguments[1]instanceof C)for(var t=arguments[0],e=arguments[1],n=arguments[2],r=new dn,i=t.getCoordinates(),o=0;o<i.length-1;o++){r.setCoordinates(i[o],i[o+1]);var s=r.closestPoint(e);n.setMinimum(s,e)}else if(arguments[2]instanceof Or&&arguments[0]instanceof Qt&&arguments[1]instanceof C){var a=arguments[0],u=arguments[1],l=arguments[2];Rr.computeDistance(a.getExteriorRing(),u,l);for(var c=0;c<a.getNumInteriorRing();c++)Rr.computeDistance(a.getInteriorRingN(c),u,l)}else if(arguments[2]instanceof Or&&arguments[0]instanceof ct&&arguments[1]instanceof C){var h=arguments[0],p=arguments[1],f=arguments[2];if(h instanceof Kt)Rr.computeDistance(h,p,f);else if(h instanceof Qt)Rr.computeDistance(h,p,f);else if(h instanceof qt)for(var g=h,d=0;d<g.getNumGeometries();d++){var y=g.getGeometryN(d);Rr.computeDistance(y,p,f)}else f.setMinimum(h.getCoordinate(),p)}else if(arguments[2]instanceof Or&&arguments[0]instanceof dn&&arguments[1]instanceof C){var _=arguments[1],m=arguments[2],v=arguments[0].closestPoint(_);m.setMinimum(v,_)}};var Tr=function(){this._g0=null,this._g1=null,this._ptDist=new Or,this._densifyFrac=0;var t=arguments[0],e=arguments[1];this._g0=t,this._g1=e},Ar={MaxPointDistanceFilter:{configurable:!0},MaxDensifiedByFractionDistanceFilter:{configurable:!0}};Tr.prototype.getCoordinates=function(){return this._ptDist.getCoordinates()},Tr.prototype.setDensifyFraction=function(t){if(t>1||t<=0)throw new m("Fraction is not in range (0.0 - 1.0]");this._densifyFrac=t},Tr.prototype.compute=function(t,e){this.computeOrientedDistance(t,e,this._ptDist),this.computeOrientedDistance(e,t,this._ptDist)},Tr.prototype.distance=function(){return this.compute(this._g0,this._g1),this._ptDist.getDistance()},Tr.prototype.computeOrientedDistance=function(t,e,n){var r=new Dr(e);if(t.apply(r),n.setMaximum(r.getMaxPointDistance()),this._densifyFrac>0){var i=new Fr(e,this._densifyFrac);t.apply(i),n.setMaximum(i.getMaxPointDistance())}},Tr.prototype.orientedDistance=function(){return this.computeOrientedDistance(this._g0,this._g1,this._ptDist),this._ptDist.getDistance()},Tr.prototype.interfaces_=function(){return[]},Tr.prototype.getClass=function(){return Tr},Tr.distance=function(){if(2===arguments.length)return new Tr(arguments[0],arguments[1]).distance();if(3===arguments.length){var t=arguments[2],e=new Tr(arguments[0],arguments[1]);return e.setDensifyFraction(t),e.distance()}},Ar.MaxPointDistanceFilter.get=function(){return Dr},Ar.MaxDensifiedByFractionDistanceFilter.get=function(){return Fr},Object.defineProperties(Tr,Ar);var Dr=function(){this._maxPtDist=new Or,this._minPtDist=new Or,this._euclideanDist=new Rr,this._geom=null;var t=arguments[0];this._geom=t};Dr.prototype.filter=function(t){this._minPtDist.initialize(),Rr.computeDistance(this._geom,t,this._minPtDist),this._maxPtDist.setMaximum(this._minPtDist)},Dr.prototype.getMaxPointDistance=function(){return this._maxPtDist},Dr.prototype.interfaces_=function(){return[ft]},Dr.prototype.getClass=function(){return Dr};var Fr=function(){this._maxPtDist=new Or,this._minPtDist=new Or,this._geom=null,this._numSubSegs=0;var t=arguments[0],e=arguments[1];this._geom=t,this._numSubSegs=Math.trunc(Math.round(1/e))};Fr.prototype.filter=function(t,e){if(0===e)return null;for(var n=t.getCoordinate(e-1),r=t.getCoordinate(e),i=(r.x-n.x)/this._numSubSegs,o=(r.y-n.y)/this._numSubSegs,s=0;s<this._numSubSegs;s++){var a=n.x+s*i,u=n.y+s*o,l=new C(a,u);this._minPtDist.initialize(),Rr.computeDistance(this._geom,l,this._minPtDist),this._maxPtDist.setMaximum(this._minPtDist)}},Fr.prototype.isDone=function(){return!1},Fr.prototype.isGeometryChanged=function(){return!1},Fr.prototype.getMaxPointDistance=function(){return this._maxPtDist},Fr.prototype.interfaces_=function(){return[Ut]},Fr.prototype.getClass=function(){return Fr};var kr=function(t,e,n){this._minValidDistance=null,this._maxValidDistance=null,this._minDistanceFound=null,this._maxDistanceFound=null,this._isValid=!0,this._errMsg=null,this._errorLocation=null,this._errorIndicator=null,this._input=t||null,this._bufDistance=e||null,this._result=n||null},Gr={VERBOSE:{configurable:!0},MAX_DISTANCE_DIFF_FRAC:{configurable:!0}};kr.prototype.checkMaximumDistance=function(t,e,n){var r=new Tr(e,t);if(r.setDensifyFraction(.25),this._maxDistanceFound=r.orientedDistance(),this._maxDistanceFound>n){this._isValid=!1;var i=r.getCoordinates();this._errorLocation=i[1],this._errorIndicator=t.getFactory().createLineString(i),this._errMsg="Distance between buffer curve and input is too large ("+this._maxDistanceFound+" at "+$.toLineString(i[0],i[1])+")"}},kr.prototype.isValid=function(){var t=Math.abs(this._bufDistance),e=kr.MAX_DISTANCE_DIFF_FRAC*t;return this._minValidDistance=t-e,this._maxValidDistance=t+e,!(!this._input.isEmpty()&&!this._result.isEmpty())||(this._bufDistance>0?this.checkPositiveValid():this.checkNegativeValid(),kr.VERBOSE&&V.out.println("Min Dist= "+this._minDistanceFound+"  err= "+(1-this._minDistanceFound/this._bufDistance)+"  Max Dist= "+this._maxDistanceFound+"  err= "+(this._maxDistanceFound/this._bufDistance-1)),this._isValid)},kr.prototype.checkNegativeValid=function(){if(!(this._input instanceof Qt||this._input instanceof ne||this._input instanceof qt))return null;var t=this.getPolygonLines(this._input);if(this.checkMinimumDistance(t,this._result,this._minValidDistance),!this._isValid)return null;this.checkMaximumDistance(t,this._result,this._maxValidDistance)},kr.prototype.getErrorIndicator=function(){return this._errorIndicator},kr.prototype.checkMinimumDistance=function(t,e,n){var r=new Pr(t,e,n);if(this._minDistanceFound=r.distance(),this._minDistanceFound<n){this._isValid=!1;var i=r.nearestPoints();this._errorLocation=r.nearestPoints()[1],this._errorIndicator=t.getFactory().createLineString(i),this._errMsg="Distance between buffer curve and input is too small ("+this._minDistanceFound+" at "+$.toLineString(i[0],i[1])+" )"}},kr.prototype.checkPositiveValid=function(){var t=this._result.getBoundary();if(this.checkMinimumDistance(this._input,t,this._minValidDistance),!this._isValid)return null;this.checkMaximumDistance(this._input,t,this._maxValidDistance)},kr.prototype.getErrorLocation=function(){return this._errorLocation},kr.prototype.getPolygonLines=function(t){for(var e=new It,n=new Cr(e),r=Ir.getPolygons(t).iterator();r.hasNext();)r.next().apply(n);return t.getFactory().buildGeometry(e)},kr.prototype.getErrorMessage=function(){return this._errMsg},kr.prototype.interfaces_=function(){return[]},kr.prototype.getClass=function(){return kr},Gr.VERBOSE.get=function(){return!1},Gr.MAX_DISTANCE_DIFF_FRAC.get=function(){return.012},Object.defineProperties(kr,Gr);var Br=function(t,e,n){this._isValid=!0,this._errorMsg=null,this._errorLocation=null,this._errorIndicator=null,this._input=t||null,this._distance=e||null,this._result=n||null},jr={VERBOSE:{configurable:!0},MAX_ENV_DIFF_FRAC:{configurable:!0}};Br.prototype.isValid=function(){return this.checkPolygonal(),this._isValid?(this.checkExpectedEmpty(),this._isValid?(this.checkEnvelope(),this._isValid?(this.checkArea(),this._isValid?(this.checkDistance(),this._isValid):this._isValid):this._isValid):this._isValid):this._isValid},Br.prototype.checkEnvelope=function(){if(this._distance<0)return null;var t=this._distance*Br.MAX_ENV_DIFF_FRAC;0===t&&(t=.001);var e=new X(this._input.getEnvelopeInternal());e.expandBy(this._distance);var n=new X(this._result.getEnvelopeInternal());n.expandBy(t),n.contains(e)||(this._isValid=!1,this._errorMsg="Buffer envelope is incorrect",this._errorIndicator=this._input.getFactory().toGeometry(n)),this.report("Envelope")},Br.prototype.checkDistance=function(){var t=new kr(this._input,this._distance,this._result);t.isValid()||(this._isValid=!1,this._errorMsg=t.getErrorMessage(),this._errorLocation=t.getErrorLocation(),this._errorIndicator=t.getErrorIndicator()),this.report("Distance")},Br.prototype.checkArea=function(){var t=this._input.getArea(),e=this._result.getArea();this._distance>0&&t>e&&(this._isValid=!1,this._errorMsg="Area of positive buffer is smaller than input",this._errorIndicator=this._result),this._distance<0&&t<e&&(this._isValid=!1,this._errorMsg="Area of negative buffer is larger than input",this._errorIndicator=this._result),this.report("Area")},Br.prototype.checkPolygonal=function(){this._result instanceof Qt||this._result instanceof ne||(this._isValid=!1),this._errorMsg="Result is not polygonal",this._errorIndicator=this._result,this.report("Polygonal")},Br.prototype.getErrorIndicator=function(){return this._errorIndicator},Br.prototype.getErrorLocation=function(){return this._errorLocation},Br.prototype.checkExpectedEmpty=function(){return this._input.getDimension()>=2||this._distance>0?null:(this._result.isEmpty()||(this._isValid=!1,this._errorMsg="Result is non-empty",this._errorIndicator=this._result),void this.report("ExpectedEmpty"))},Br.prototype.report=function(t){if(!Br.VERBOSE)return null;V.out.println("Check "+t+": "+(this._isValid?"passed":"FAILED"))},Br.prototype.getErrorMessage=function(){return this._errorMsg},Br.prototype.interfaces_=function(){return[]},Br.prototype.getClass=function(){return Br},Br.isValidMsg=function(t,e,n){var r=new Br(t,e,n);return r.isValid()?null:r.getErrorMessage()},Br.isValid=function(t,e,n){return!!new Br(t,e,n).isValid()},jr.VERBOSE.get=function(){return!1},jr.MAX_ENV_DIFF_FRAC.get=function(){return.012},Object.defineProperties(Br,jr);var Ur=function(){this._pts=null,this._data=null;var t=arguments[0],e=arguments[1];this._pts=t,this._data=e};Ur.prototype.getCoordinates=function(){return this._pts},Ur.prototype.size=function(){return this._pts.length},Ur.prototype.getCoordinate=function(t){return this._pts[t]},Ur.prototype.isClosed=function(){return this._pts[0].equals(this._pts[this._pts.length-1])},Ur.prototype.getSegmentOctant=function(t){return t===this._pts.length-1?-1:hn.octant(this.getCoordinate(t),this.getCoordinate(t+1))},Ur.prototype.setData=function(t){this._data=t},Ur.prototype.getData=function(){return this._data},Ur.prototype.toString=function(){return $.toLineString(new ue(this._pts))},Ur.prototype.interfaces_=function(){return[pn]},Ur.prototype.getClass=function(){return Ur};var qr=function(){this._findAllIntersections=!1,this._isCheckEndSegmentsOnly=!1,this._li=null,this._interiorIntersection=null,this._intSegments=null,this._intersections=new It,this._intersectionCount=0,this._keepIntersections=!0;var t=arguments[0];this._li=t,this._interiorIntersection=null};qr.prototype.getInteriorIntersection=function(){return this._interiorIntersection},qr.prototype.setCheckEndSegmentsOnly=function(t){this._isCheckEndSegmentsOnly=t},qr.prototype.getIntersectionSegments=function(){return this._intSegments},qr.prototype.count=function(){return this._intersectionCount},qr.prototype.getIntersections=function(){return this._intersections},qr.prototype.setFindAllIntersections=function(t){this._findAllIntersections=t},qr.prototype.setKeepIntersections=function(t){this._keepIntersections=t},qr.prototype.processIntersections=function(t,e,n,r){if(!this._findAllIntersections&&this.hasIntersection())return null;if(t===n&&e===r)return null;if(this._isCheckEndSegmentsOnly&&!this.isEndSegment(t,e)&&!this.isEndSegment(n,r))return null;var i=t.getCoordinates()[e],o=t.getCoordinates()[e+1],s=n.getCoordinates()[r],a=n.getCoordinates()[r+1];this._li.computeIntersection(i,o,s,a),this._li.hasIntersection()&&this._li.isInteriorIntersection()&&(this._intSegments=new Array(4).fill(null),this._intSegments[0]=i,this._intSegments[1]=o,this._intSegments[2]=s,this._intSegments[3]=a,this._interiorIntersection=this._li.getIntersection(0),this._keepIntersections&&this._intersections.add(this._interiorIntersection),this._intersectionCount++)},qr.prototype.isEndSegment=function(t,e){return 0===e||e>=t.size()-2},qr.prototype.hasIntersection=function(){return null!==this._interiorIntersection},qr.prototype.isDone=function(){return!this._findAllIntersections&&null!==this._interiorIntersection},qr.prototype.interfaces_=function(){return[Hn]},qr.prototype.getClass=function(){return qr},qr.createAllIntersectionsFinder=function(t){var e=new qr(t);return e.setFindAllIntersections(!0),e},qr.createAnyIntersectionFinder=function(t){return new qr(t)},qr.createIntersectionCounter=function(t){var e=new qr(t);return e.setFindAllIntersections(!0),e.setKeepIntersections(!1),e};var zr=function(){this._li=new it,this._segStrings=null,this._findAllIntersections=!1,this._segInt=null,this._isValid=!0;var t=arguments[0];this._segStrings=t};zr.prototype.execute=function(){if(null!==this._segInt)return null;this.checkInteriorIntersections()},zr.prototype.getIntersections=function(){return this._segInt.getIntersections()},zr.prototype.isValid=function(){return this.execute(),this._isValid},zr.prototype.setFindAllIntersections=function(t){this._findAllIntersections=t},zr.prototype.checkInteriorIntersections=function(){this._isValid=!0,this._segInt=new qr(this._li),this._segInt.setFindAllIntersections(this._findAllIntersections);var t=new En;if(t.setSegmentIntersector(this._segInt),t.computeNodes(this._segStrings),this._segInt.hasIntersection())return this._isValid=!1,null},zr.prototype.checkValid=function(){if(this.execute(),!this._isValid)throw new Me(this.getErrorMessage(),this._segInt.getInteriorIntersection())},zr.prototype.getErrorMessage=function(){if(this._isValid)return"no intersections found";var t=this._segInt.getIntersectionSegments();return"found non-noded intersection between "+$.toLineString(t[0],t[1])+" and "+$.toLineString(t[2],t[3])},zr.prototype.interfaces_=function(){return[]},zr.prototype.getClass=function(){return zr},zr.computeIntersections=function(t){var e=new zr(t);return e.setFindAllIntersections(!0),e.isValid(),e.getIntersections()};var Vr=function t(){this._nv=null;var e=arguments[0];this._nv=new zr(t.toSegmentStrings(e))};Vr.prototype.checkValid=function(){this._nv.checkValid()},Vr.prototype.interfaces_=function(){return[]},Vr.prototype.getClass=function(){return Vr},Vr.toSegmentStrings=function(t){for(var e=new It,n=t.iterator();n.hasNext();){var r=n.next();e.add(new Ur(r.getCoordinates(),r))}return e},Vr.checkValid=function(t){new Vr(t).checkValid()};var Yr=function(t){this._mapOp=t};Yr.prototype.map=function(t){for(var e=new It,n=0;n<t.getNumGeometries();n++){var r=this._mapOp.map(t.getGeometryN(n));r.isEmpty()||e.add(r)}return t.getFactory().createGeometryCollection(_e.toGeometryArray(e))},Yr.prototype.interfaces_=function(){return[]},Yr.prototype.getClass=function(){return Yr},Yr.map=function(t,e){return new Yr(e).map(t)};var Xr=function(){this._op=null,this._geometryFactory=null,this._ptLocator=null,this._lineEdgesList=new It,this._resultLineList=new It;var t=arguments[0],e=arguments[1],n=arguments[2];this._op=t,this._geometryFactory=e,this._ptLocator=n};Xr.prototype.collectLines=function(t){for(var e=this._op.getGraph().getEdgeEnds().iterator();e.hasNext();){var n=e.next();this.collectLineEdge(n,t,this._lineEdgesList),this.collectBoundaryTouchEdge(n,t,this._lineEdgesList)}},Xr.prototype.labelIsolatedLine=function(t,e){var n=this._ptLocator.locate(t.getCoordinate(),this._op.getArgGeometry(e));t.getLabel().setLocation(e,n)},Xr.prototype.build=function(t){return this.findCoveredLineEdges(),this.collectLines(t),this.buildLines(t),this._resultLineList},Xr.prototype.collectLineEdge=function(t,e,n){var r=t.getLabel(),i=t.getEdge();t.isLineEdge()&&(t.isVisited()||!wi.isResultOfOp(r,e)||i.isCovered()||(n.add(i),t.setVisitedEdge(!0)))},Xr.prototype.findCoveredLineEdges=function(){for(var t=this._op.getGraph().getNodes().iterator();t.hasNext();)t.next().getEdges().findCoveredLineEdges();for(var e=this._op.getGraph().getEdgeEnds().iterator();e.hasNext();){var n=e.next(),r=n.getEdge();if(n.isLineEdge()&&!r.isCoveredSet()){var i=this._op.isCoveredByA(n.getCoordinate());r.setCovered(i)}}},Xr.prototype.labelIsolatedLines=function(t){for(var e=t.iterator();e.hasNext();){var n=e.next(),r=n.getLabel();n.isIsolated()&&(r.isNull(0)?this.labelIsolatedLine(n,0):this.labelIsolatedLine(n,1))}},Xr.prototype.buildLines=function(t){for(var e=this._lineEdgesList.iterator();e.hasNext();){var n=e.next(),r=this._geometryFactory.createLineString(n.getCoordinates());this._resultLineList.add(r),n.setInResult(!0)}},Xr.prototype.collectBoundaryTouchEdge=function(t,e,n){var r=t.getLabel();return t.isLineEdge()||t.isVisited()||t.isInteriorAreaEdge()||t.getEdge().isInResult()?null:(et.isTrue(!(t.isInResult()||t.getSym().isInResult())||!t.getEdge().isInResult()),void(wi.isResultOfOp(r,e)&&e===wi.INTERSECTION&&(n.add(t.getEdge()),t.setVisitedEdge(!0))))},Xr.prototype.interfaces_=function(){return[]},Xr.prototype.getClass=function(){return Xr};var Wr=function(){this._op=null,this._geometryFactory=null,this._resultPointList=new It;var t=arguments[0],e=arguments[1];this._op=t,this._geometryFactory=e};Wr.prototype.filterCoveredNodeToPoint=function(t){var e=t.getCoordinate();if(!this._op.isCoveredByLA(e)){var n=this._geometryFactory.createPoint(e);this._resultPointList.add(n)}},Wr.prototype.extractNonCoveredResultNodes=function(t){for(var e=this._op.getGraph().getNodes().iterator();e.hasNext();){var n=e.next();if(!(n.isInResult()||n.isIncidentEdgeInResult()||0!==n.getEdges().getDegree()&&t!==wi.INTERSECTION)){var r=n.getLabel();wi.isResultOfOp(r,t)&&this.filterCoveredNodeToPoint(n)}}},Wr.prototype.build=function(t){return this.extractNonCoveredResultNodes(t),this._resultPointList},Wr.prototype.interfaces_=function(){return[]},Wr.prototype.getClass=function(){return Wr};var Hr=function(){this._inputGeom=null,this._factory=null,this._pruneEmptyGeometry=!0,this._preserveGeometryCollectionType=!0,this._preserveCollections=!1,this._preserveType=!1};Hr.prototype.transformPoint=function(t,e){return this._factory.createPoint(this.transformCoordinates(t.getCoordinateSequence(),t))},Hr.prototype.transformPolygon=function(t,e){var n=!0,r=this.transformLinearRing(t.getExteriorRing(),t);null!==r&&r instanceof ee&&!r.isEmpty()||(n=!1);for(var i=new It,o=0;o<t.getNumInteriorRing();o++){var s=this.transformLinearRing(t.getInteriorRingN(o),t);null===s||s.isEmpty()||(s instanceof ee||(n=!1),i.add(s))}if(n)return this._factory.createPolygon(r,i.toArray([]));var a=new It;return null!==r&&a.add(r),a.addAll(i),this._factory.buildGeometry(a)},Hr.prototype.createCoordinateSequence=function(t){return this._factory.getCoordinateSequenceFactory().create(t)},Hr.prototype.getInputGeometry=function(){return this._inputGeom},Hr.prototype.transformMultiLineString=function(t,e){for(var n=new It,r=0;r<t.getNumGeometries();r++){var i=this.transformLineString(t.getGeometryN(r),t);null!==i&&(i.isEmpty()||n.add(i))}return this._factory.buildGeometry(n)},Hr.prototype.transformCoordinates=function(t,e){return this.copy(t)},Hr.prototype.transformLineString=function(t,e){return this._factory.createLineString(this.transformCoordinates(t.getCoordinateSequence(),t))},Hr.prototype.transformMultiPoint=function(t,e){for(var n=new It,r=0;r<t.getNumGeometries();r++){var i=this.transformPoint(t.getGeometryN(r),t);null!==i&&(i.isEmpty()||n.add(i))}return this._factory.buildGeometry(n)},Hr.prototype.transformMultiPolygon=function(t,e){for(var n=new It,r=0;r<t.getNumGeometries();r++){var i=this.transformPolygon(t.getGeometryN(r),t);null!==i&&(i.isEmpty()||n.add(i))}return this._factory.buildGeometry(n)},Hr.prototype.copy=function(t){return t.copy()},Hr.prototype.transformGeometryCollection=function(t,e){for(var n=new It,r=0;r<t.getNumGeometries();r++){var i=this.transform(t.getGeometryN(r));null!==i&&(this._pruneEmptyGeometry&&i.isEmpty()||n.add(i))}return this._preserveGeometryCollectionType?this._factory.createGeometryCollection(_e.toGeometryArray(n)):this._factory.buildGeometry(n)},Hr.prototype.transform=function(t){if(this._inputGeom=t,this._factory=t.getFactory(),t instanceof Zt)return this.transformPoint(t,null);if(t instanceof te)return this.transformMultiPoint(t,null);if(t instanceof ee)return this.transformLinearRing(t,null);if(t instanceof Kt)return this.transformLineString(t,null);if(t instanceof zt)return this.transformMultiLineString(t,null);if(t instanceof Qt)return this.transformPolygon(t,null);if(t instanceof ne)return this.transformMultiPolygon(t,null);if(t instanceof qt)return this.transformGeometryCollection(t,null);throw new m("Unknown Geometry subtype: "+t.getClass().getName())},Hr.prototype.transformLinearRing=function(t,e){var n=this.transformCoordinates(t.getCoordinateSequence(),t);if(null===n)return this._factory.createLinearRing(null);var r=n.size();return r>0&&r<4&&!this._preserveType?this._factory.createLineString(n):this._factory.createLinearRing(n)},Hr.prototype.interfaces_=function(){return[]},Hr.prototype.getClass=function(){return Hr};var Kr=function t(){if(this._snapTolerance=0,this._srcPts=null,this._seg=new dn,this._allowSnappingToSourceVertices=!1,this._isClosed=!1,arguments[0]instanceof Kt&&"number"==typeof arguments[1]){var e=arguments[1];t.call(this,arguments[0].getCoordinates(),e)}else if(arguments[0]instanceof Array&&"number"==typeof arguments[1]){var n=arguments[0],r=arguments[1];this._srcPts=n,this._isClosed=t.isClosed(n),this._snapTolerance=r}};Kr.prototype.snapVertices=function(t,e){for(var n=this._isClosed?t.size()-1:t.size(),r=0;r<n;r++){var i=t.get(r),o=this.findSnapForVertex(i,e);null!==o&&(t.set(r,new C(o)),0===r&&this._isClosed&&t.set(t.size()-1,new C(o)))}},Kr.prototype.findSnapForVertex=function(t,e){for(var n=0;n<e.length;n++){if(t.equals2D(e[n]))return null;if(t.distance(e[n])<this._snapTolerance)return e[n]}return null},Kr.prototype.snapTo=function(t){var e=new St(this._srcPts);return this.snapVertices(e,t),this.snapSegments(e,t),e.toCoordinateArray()},Kr.prototype.snapSegments=function(t,e){if(0===e.length)return null;var n=e.length;e[0].equals2D(e[e.length-1])&&(n=e.length-1);for(var r=0;r<n;r++){var i=e[r],o=this.findSegmentIndexToSnap(i,t);o>=0&&t.add(o+1,new C(i),!1)}},Kr.prototype.findSegmentIndexToSnap=function(t,e){for(var n=v.MAX_VALUE,r=-1,i=0;i<e.size()-1;i++){if(this._seg.p0=e.get(i),this._seg.p1=e.get(i+1),this._seg.p0.equals2D(t)||this._seg.p1.equals2D(t)){if(this._allowSnappingToSourceVertices)continue;return-1}var o=this._seg.distance(t);o<this._snapTolerance&&o<n&&(n=o,r=i)}return r},Kr.prototype.setAllowSnappingToSourceVertices=function(t){this._allowSnappingToSourceVertices=t},Kr.prototype.interfaces_=function(){return[]},Kr.prototype.getClass=function(){return Kr},Kr.isClosed=function(t){return!(t.length<=1)&&t[0].equals2D(t[t.length-1])};var Jr=function(t){this._srcGeom=t||null},Zr={SNAP_PRECISION_FACTOR:{configurable:!0}};Jr.prototype.snapTo=function(t,e){var n=this.extractTargetCoordinates(t);return new $r(e,n).transform(this._srcGeom)},Jr.prototype.snapToSelf=function(t,e){var n=this.extractTargetCoordinates(this._srcGeom),r=new $r(t,n,!0).transform(this._srcGeom),i=r;return e&&P(i,$t)&&(i=r.buffer(0)),i},Jr.prototype.computeSnapTolerance=function(t){return this.computeMinimumSegmentLength(t)/10},Jr.prototype.extractTargetCoordinates=function(t){for(var e=new f,n=t.getCoordinates(),r=0;r<n.length;r++)e.add(n[r]);return e.toArray(new Array(0).fill(null))},Jr.prototype.computeMinimumSegmentLength=function(t){for(var e=v.MAX_VALUE,n=0;n<t.length-1;n++){var r=t[n].distance(t[n+1]);r<e&&(e=r)}return e},Jr.prototype.interfaces_=function(){return[]},Jr.prototype.getClass=function(){return Jr},Jr.snap=function(t,e,n){var r=new Array(2).fill(null),i=new Jr(t);r[0]=i.snapTo(e,n);var o=new Jr(e);return r[1]=o.snapTo(r[0],n),r},Jr.computeOverlaySnapTolerance=function(){if(1===arguments.length){var t=arguments[0],e=Jr.computeSizeBasedSnapTolerance(t),n=t.getPrecisionModel();if(n.getType()===fe.FIXED){var r=1/n.getScale()*2/1.415;r>e&&(e=r)}return e}if(2===arguments.length){var i=arguments[0],o=arguments[1];return Math.min(Jr.computeOverlaySnapTolerance(i),Jr.computeOverlaySnapTolerance(o))}},Jr.computeSizeBasedSnapTolerance=function(t){var e=t.getEnvelopeInternal();return Math.min(e.getHeight(),e.getWidth())*Jr.SNAP_PRECISION_FACTOR},Jr.snapToSelf=function(t,e,n){return new Jr(t).snapToSelf(e,n)},Zr.SNAP_PRECISION_FACTOR.get=function(){return 1e-9},Object.defineProperties(Jr,Zr);var $r=function(t){function e(e,n,r){t.call(this),this._snapTolerance=e||null,this._snapPts=n||null,this._isSelfSnap=void 0!==r&&r}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.snapLine=function(t,e){var n=new Kr(t,this._snapTolerance);return n.setAllowSnappingToSourceVertices(this._isSelfSnap),n.snapTo(e)},e.prototype.transformCoordinates=function(t,e){var n=t.toCoordinateArray(),r=this.snapLine(n,this._snapPts);return this._factory.getCoordinateSequenceFactory().create(r)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Hr),Qr=function(){this._isFirst=!0,this._commonMantissaBitsCount=53,this._commonBits=0,this._commonSignExp=null};Qr.prototype.getCommon=function(){return v.longBitsToDouble(this._commonBits)},Qr.prototype.add=function(t){var e=v.doubleToLongBits(t);return this._isFirst?(this._commonBits=e,this._commonSignExp=Qr.signExpBits(this._commonBits),this._isFirst=!1,null):Qr.signExpBits(e)!==this._commonSignExp?(this._commonBits=0,null):(this._commonMantissaBitsCount=Qr.numCommonMostSigMantissaBits(this._commonBits,e),void(this._commonBits=Qr.zeroLowerBits(this._commonBits,64-(12+this._commonMantissaBitsCount))))},Qr.prototype.toString=function(){if(1===arguments.length){var t=arguments[0],e=v.longBitsToDouble(t),n="0000000000000000000000000000000000000000000000000000000000000000"+v.toBinaryString(t),r=n.substring(n.length-64);return r.substring(0,1)+"  "+r.substring(1,12)+"(exp) "+r.substring(12)+" [ "+e+" ]"}},Qr.prototype.interfaces_=function(){return[]},Qr.prototype.getClass=function(){return Qr},Qr.getBit=function(t,e){return 0!=(t&1<<e)?1:0},Qr.signExpBits=function(t){return t>>52},Qr.zeroLowerBits=function(t,e){return t&~((1<<e)-1)},Qr.numCommonMostSigMantissaBits=function(t,e){for(var n=0,r=52;r>=0;r--){if(Qr.getBit(t,r)!==Qr.getBit(e,r))return n;n++}return 52};var ti=function(){this._commonCoord=null,this._ccFilter=new ni},ei={CommonCoordinateFilter:{configurable:!0},Translater:{configurable:!0}};ti.prototype.addCommonBits=function(t){var e=new ri(this._commonCoord);t.apply(e),t.geometryChanged()},ti.prototype.removeCommonBits=function(t){if(0===this._commonCoord.x&&0===this._commonCoord.y)return t;var e=new C(this._commonCoord);e.x=-e.x,e.y=-e.y;var n=new ri(e);return t.apply(n),t.geometryChanged(),t},ti.prototype.getCommonCoordinate=function(){return this._commonCoord},ti.prototype.add=function(t){t.apply(this._ccFilter),this._commonCoord=this._ccFilter.getCommonCoordinate()},ti.prototype.interfaces_=function(){return[]},ti.prototype.getClass=function(){return ti},ei.CommonCoordinateFilter.get=function(){return ni},ei.Translater.get=function(){return ri},Object.defineProperties(ti,ei);var ni=function(){this._commonBitsX=new Qr,this._commonBitsY=new Qr};ni.prototype.filter=function(t){this._commonBitsX.add(t.x),this._commonBitsY.add(t.y)},ni.prototype.getCommonCoordinate=function(){return new C(this._commonBitsX.getCommon(),this._commonBitsY.getCommon())},ni.prototype.interfaces_=function(){return[ft]},ni.prototype.getClass=function(){return ni};var ri=function(){this.trans=null;var t=arguments[0];this.trans=t};ri.prototype.filter=function(t,e){var n=t.getOrdinate(e,0)+this.trans.x,r=t.getOrdinate(e,1)+this.trans.y;t.setOrdinate(e,0,n),t.setOrdinate(e,1,r)},ri.prototype.isDone=function(){return!1},ri.prototype.isGeometryChanged=function(){return!0},ri.prototype.interfaces_=function(){return[Ut]},ri.prototype.getClass=function(){return ri};var ii=function(t,e){this._geom=new Array(2).fill(null),this._snapTolerance=null,this._cbr=null,this._geom[0]=t,this._geom[1]=e,this.computeSnapTolerance()};ii.prototype.selfSnap=function(t){return new Jr(t).snapTo(t,this._snapTolerance)},ii.prototype.removeCommonBits=function(t){this._cbr=new ti,this._cbr.add(t[0]),this._cbr.add(t[1]);var e=new Array(2).fill(null);return e[0]=this._cbr.removeCommonBits(t[0].copy()),e[1]=this._cbr.removeCommonBits(t[1].copy()),e},ii.prototype.prepareResult=function(t){return this._cbr.addCommonBits(t),t},ii.prototype.getResultGeometry=function(t){var e=this.snap(this._geom),n=wi.overlayOp(e[0],e[1],t);return this.prepareResult(n)},ii.prototype.checkValid=function(t){t.isValid()||V.out.println("Snapped geometry is invalid")},ii.prototype.computeSnapTolerance=function(){this._snapTolerance=Jr.computeOverlaySnapTolerance(this._geom[0],this._geom[1])},ii.prototype.snap=function(t){var e=this.removeCommonBits(t);return Jr.snap(e[0],e[1],this._snapTolerance)},ii.prototype.interfaces_=function(){return[]},ii.prototype.getClass=function(){return ii},ii.overlayOp=function(t,e,n){return new ii(t,e).getResultGeometry(n)},ii.union=function(t,e){return ii.overlayOp(t,e,wi.UNION)},ii.intersection=function(t,e){return ii.overlayOp(t,e,wi.INTERSECTION)},ii.symDifference=function(t,e){return ii.overlayOp(t,e,wi.SYMDIFFERENCE)},ii.difference=function(t,e){return ii.overlayOp(t,e,wi.DIFFERENCE)};var oi=function(t,e){this._geom=new Array(2).fill(null),this._geom[0]=t,this._geom[1]=e};oi.prototype.getResultGeometry=function(t){var e=null,n=!1,r=null;try{e=wi.overlayOp(this._geom[0],this._geom[1],t),n=!0}catch(t){if(!(t instanceof Q))throw t;r=t}if(!n)try{e=ii.overlayOp(this._geom[0],this._geom[1],t)}catch(t){throw t instanceof Q?r:t}return e},oi.prototype.interfaces_=function(){return[]},oi.prototype.getClass=function(){return oi},oi.overlayOp=function(t,e,n){return new oi(t,e).getResultGeometry(n)},oi.union=function(t,e){return oi.overlayOp(t,e,wi.UNION)},oi.intersection=function(t,e){return oi.overlayOp(t,e,wi.INTERSECTION)},oi.symDifference=function(t,e){return oi.overlayOp(t,e,wi.SYMDIFFERENCE)},oi.difference=function(t,e){return oi.overlayOp(t,e,wi.DIFFERENCE)};var si=function(){this.mce=null,this.chainIndex=null;var t=arguments[0],e=arguments[1];this.mce=t,this.chainIndex=e};si.prototype.computeIntersections=function(t,e){this.mce.computeIntersectsForChain(this.chainIndex,t.mce,t.chainIndex,e)},si.prototype.interfaces_=function(){return[]},si.prototype.getClass=function(){return si};var ai=function t(){if(this._label=null,this._xValue=null,this._eventType=null,this._insertEvent=null,this._deleteEventIndex=null,this._obj=null,2===arguments.length){var e=arguments[0],n=arguments[1];this._eventType=t.DELETE,this._xValue=e,this._insertEvent=n}else if(3===arguments.length){var r=arguments[0],i=arguments[1],o=arguments[2];this._eventType=t.INSERT,this._label=r,this._xValue=i,this._obj=o}},ui={INSERT:{configurable:!0},DELETE:{configurable:!0}};ai.prototype.isDelete=function(){return this._eventType===ai.DELETE},ai.prototype.setDeleteEventIndex=function(t){this._deleteEventIndex=t},ai.prototype.getObject=function(){return this._obj},ai.prototype.compareTo=function(t){var e=t;return this._xValue<e._xValue?-1:this._xValue>e._xValue?1:this._eventType<e._eventType?-1:this._eventType>e._eventType?1:0},ai.prototype.getInsertEvent=function(){return this._insertEvent},ai.prototype.isInsert=function(){return this._eventType===ai.INSERT},ai.prototype.isSameLabel=function(t){return null!==this._label&&this._label===t._label},ai.prototype.getDeleteEventIndex=function(){return this._deleteEventIndex},ai.prototype.interfaces_=function(){return[b]},ai.prototype.getClass=function(){return ai},ui.INSERT.get=function(){return 1},ui.DELETE.get=function(){return 2},Object.defineProperties(ai,ui);var li=function(){};li.prototype.interfaces_=function(){return[]},li.prototype.getClass=function(){return li};var ci=function(){this._hasIntersection=!1,this._hasProper=!1,this._hasProperInterior=!1,this._properIntersectionPoint=null,this._li=null,this._includeProper=null,this._recordIsolated=null,this._isSelfIntersection=null,this._numIntersections=0,this.numTests=0,this._bdyNodes=null,this._isDone=!1,this._isDoneWhenProperInt=!1;var t=arguments[0],e=arguments[1],n=arguments[2];this._li=t,this._includeProper=e,this._recordIsolated=n};ci.prototype.isTrivialIntersection=function(t,e,n,r){if(t===n&&1===this._li.getIntersectionNum()){if(ci.isAdjacentSegments(e,r))return!0;if(t.isClosed()){var i=t.getNumPoints()-1;if(0===e&&r===i||0===r&&e===i)return!0}}return!1},ci.prototype.getProperIntersectionPoint=function(){return this._properIntersectionPoint},ci.prototype.setIsDoneIfProperInt=function(t){this._isDoneWhenProperInt=t},ci.prototype.hasProperInteriorIntersection=function(){return this._hasProperInterior},ci.prototype.isBoundaryPointInternal=function(t,e){for(var n=e.iterator();n.hasNext();){var r=n.next().getCoordinate();if(t.isIntersection(r))return!0}return!1},ci.prototype.hasProperIntersection=function(){return this._hasProper},ci.prototype.hasIntersection=function(){return this._hasIntersection},ci.prototype.isDone=function(){return this._isDone},ci.prototype.isBoundaryPoint=function(t,e){return!(null===e||!this.isBoundaryPointInternal(t,e[0])&&!this.isBoundaryPointInternal(t,e[1]))},ci.prototype.setBoundaryNodes=function(t,e){this._bdyNodes=new Array(2).fill(null),this._bdyNodes[0]=t,this._bdyNodes[1]=e},ci.prototype.addIntersections=function(t,e,n,r){if(t===n&&e===r)return null;this.numTests++;var i=t.getCoordinates()[e],o=t.getCoordinates()[e+1],s=n.getCoordinates()[r],a=n.getCoordinates()[r+1];this._li.computeIntersection(i,o,s,a),this._li.hasIntersection()&&(this._recordIsolated&&(t.setIsolated(!1),n.setIsolated(!1)),this._numIntersections++,this.isTrivialIntersection(t,e,n,r)||(this._hasIntersection=!0,!this._includeProper&&this._li.isProper()||(t.addIntersections(this._li,e,0),n.addIntersections(this._li,r,1)),this._li.isProper()&&(this._properIntersectionPoint=this._li.getIntersection(0).copy(),this._hasProper=!0,this._isDoneWhenProperInt&&(this._isDone=!0),this.isBoundaryPoint(this._li,this._bdyNodes)||(this._hasProperInterior=!0))))},ci.prototype.interfaces_=function(){return[]},ci.prototype.getClass=function(){return ci},ci.isAdjacentSegments=function(t,e){return 1===Math.abs(t-e)};var hi=function(t){function e(){t.call(this),this.events=new It,this.nOverlaps=null}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.prepareEvents=function(){Qe.sort(this.events);for(var t=0;t<this.events.size();t++){var e=this.events.get(t);e.isDelete()&&e.getInsertEvent().setDeleteEventIndex(t)}},e.prototype.computeIntersections=function(){if(1===arguments.length){var t=arguments[0];this.nOverlaps=0,this.prepareEvents();for(var e=0;e<this.events.size();e++){var n=this.events.get(e);if(n.isInsert()&&this.processOverlaps(e,n.getDeleteEventIndex(),n,t),t.isDone())break}}else if(3===arguments.length)if(arguments[2]instanceof ci&&P(arguments[0],Et)&&P(arguments[1],Et)){var r=arguments[0],i=arguments[1],o=arguments[2];this.addEdges(r,r),this.addEdges(i,i),this.computeIntersections(o)}else if("boolean"==typeof arguments[2]&&P(arguments[0],Et)&&arguments[1]instanceof ci){var s=arguments[0],a=arguments[1];arguments[2]?this.addEdges(s,null):this.addEdges(s),this.computeIntersections(a)}},e.prototype.addEdge=function(t,e){for(var n=t.getMonotoneChainEdge(),r=n.getStartIndexes(),i=0;i<r.length-1;i++){var o=new si(n,i),s=new ai(e,n.getMinX(i),o);this.events.add(s),this.events.add(new ai(n.getMaxX(i),s))}},e.prototype.processOverlaps=function(t,e,n,r){for(var i=n.getObject(),o=t;o<e;o++){var s=this.events.get(o);if(s.isInsert()){var a=s.getObject();n.isSameLabel(s)||(i.computeIntersections(a,r),this.nOverlaps++)}}},e.prototype.addEdges=function(){if(1===arguments.length)for(var t=arguments[0].iterator();t.hasNext();){var e=t.next();this.addEdge(e,e)}else if(2===arguments.length)for(var n=arguments[1],r=arguments[0].iterator();r.hasNext();){var i=r.next();this.addEdge(i,n)}},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(li),pi=function(){this._min=v.POSITIVE_INFINITY,this._max=v.NEGATIVE_INFINITY},fi={NodeComparator:{configurable:!0}};pi.prototype.getMin=function(){return this._min},pi.prototype.intersects=function(t,e){return!(this._min>e||this._max<t)},pi.prototype.getMax=function(){return this._max},pi.prototype.toString=function(){return $.toLineString(new C(this._min,0),new C(this._max,0))},pi.prototype.interfaces_=function(){return[]},pi.prototype.getClass=function(){return pi},fi.NodeComparator.get=function(){return gi},Object.defineProperties(pi,fi);var gi=function(){};gi.prototype.compare=function(t,e){var n=t,r=e,i=(n._min+n._max)/2,o=(r._min+r._max)/2;return i<o?-1:i>o?1:0},gi.prototype.interfaces_=function(){return[I]},gi.prototype.getClass=function(){return gi};var di=function(t){function e(){t.call(this),this._item=null;var e=arguments[0],n=arguments[1],r=arguments[2];this._min=e,this._max=n,this._item=r}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.query=function(t,e,n){if(!this.intersects(t,e))return null;n.visitItem(this._item)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(pi),yi=function(t){function e(){t.call(this),this._node1=null,this._node2=null;var e=arguments[0],n=arguments[1];this._node1=e,this._node2=n,this.buildExtent(this._node1,this._node2)}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.buildExtent=function(t,e){this._min=Math.min(t._min,e._min),this._max=Math.max(t._max,e._max)},e.prototype.query=function(t,e,n){if(!this.intersects(t,e))return null;null!==this._node1&&this._node1.query(t,e,n),null!==this._node2&&this._node2.query(t,e,n)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(pi),_i=function(){this._leaves=new It,this._root=null,this._level=0};_i.prototype.buildTree=function(){Qe.sort(this._leaves,new pi.NodeComparator);for(var t=this._leaves,e=null,n=new It;;){if(this.buildLevel(t,n),1===n.size())return n.get(0);e=t,t=n,n=e}},_i.prototype.insert=function(t,e,n){if(null!==this._root)throw new Error("Index cannot be added to once it has been queried");this._leaves.add(new di(t,e,n))},_i.prototype.query=function(t,e,n){this.init(),this._root.query(t,e,n)},_i.prototype.buildRoot=function(){if(null!==this._root)return null;this._root=this.buildTree()},_i.prototype.printNode=function(t){V.out.println($.toLineString(new C(t._min,this._level),new C(t._max,this._level)))},_i.prototype.init=function(){if(null!==this._root)return null;this.buildRoot()},_i.prototype.buildLevel=function(t,e){this._level++,e.clear();for(var n=0;n<t.size();n+=2){var r=t.get(n);if(null===(n+1<t.size()?t.get(n):null))e.add(r);else{var i=new yi(t.get(n),t.get(n+1));e.add(i)}}},_i.prototype.interfaces_=function(){return[]},_i.prototype.getClass=function(){return _i};var mi=function(){this._items=new It};mi.prototype.visitItem=function(t){this._items.add(t)},mi.prototype.getItems=function(){return this._items},mi.prototype.interfaces_=function(){return[Ke]},mi.prototype.getClass=function(){return mi};var vi=function(){this._index=null;var t=arguments[0];if(!P(t,$t))throw new m("Argument must be Polygonal");this._index=new Ei(t)},xi={SegmentVisitor:{configurable:!0},IntervalIndexedGeometry:{configurable:!0}};vi.prototype.locate=function(t){var e=new st(t),n=new bi(e);return this._index.query(t.y,t.y,n),e.getLocation()},vi.prototype.interfaces_=function(){return[jn]},vi.prototype.getClass=function(){return vi},xi.SegmentVisitor.get=function(){return bi},xi.IntervalIndexedGeometry.get=function(){return Ei},Object.defineProperties(vi,xi);var bi=function(){this._counter=null;var t=arguments[0];this._counter=t};bi.prototype.visitItem=function(t){var e=t;this._counter.countSegment(e.getCoordinate(0),e.getCoordinate(1))},bi.prototype.interfaces_=function(){return[Ke]},bi.prototype.getClass=function(){return bi};var Ei=function(){this._index=new _i;var t=arguments[0];this.init(t)};Ei.prototype.init=function(t){for(var e=Cr.getLines(t).iterator();e.hasNext();){var n=e.next().getCoordinates();this.addLine(n)}},Ei.prototype.addLine=function(t){for(var e=1;e<t.length;e++){var n=new dn(t[e-1],t[e]),r=Math.min(n.p0.y,n.p1.y),i=Math.max(n.p0.y,n.p1.y);this._index.insert(r,i,n)}},Ei.prototype.query=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1],n=new mi;return this._index.query(t,e,n),n.getItems()}if(3===arguments.length){var r=arguments[0],i=arguments[1],o=arguments[2];this._index.query(r,i,o)}},Ei.prototype.interfaces_=function(){return[]},Ei.prototype.getClass=function(){return Ei};var Ii=function(t){function e(){if(t.call(this),this._parentGeom=null,this._lineEdgeMap=new pe,this._boundaryNodeRule=null,this._useBoundaryDeterminationRule=!0,this._argIndex=null,this._boundaryNodes=null,this._hasTooFewPoints=!1,this._invalidPoint=null,this._areaPtLocator=null,this._ptLocator=new Sr,2===arguments.length){var e=arguments[0],n=arguments[1],r=gt.OGC_SFS_BOUNDARY_RULE;this._argIndex=e,this._parentGeom=n,this._boundaryNodeRule=r,null!==n&&this.add(n)}else if(3===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2];this._argIndex=i,this._parentGeom=o,this._boundaryNodeRule=s,null!==o&&this.add(o)}}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.insertBoundaryPoint=function(t,n){var r=this._nodes.addNode(n).getLabel(),i=1;r.getLocation(t,Se.ON)===M.BOUNDARY&&i++;var o=e.determineBoundary(this._boundaryNodeRule,i);r.setLocation(t,o)},e.prototype.computeSelfNodes=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1];return this.computeSelfNodes(t,e,!1)}if(3===arguments.length){var n=arguments[1],r=arguments[2],i=new ci(arguments[0],!0,!1);i.setIsDoneIfProperInt(r);var o=this.createEdgeSetIntersector(),s=this._parentGeom instanceof ee||this._parentGeom instanceof Qt||this._parentGeom instanceof ne,a=n||!s;return o.computeIntersections(this._edges,i,a),this.addSelfIntersectionNodes(this._argIndex),i}},e.prototype.computeSplitEdges=function(t){for(var e=this._edges.iterator();e.hasNext();)e.next().eiList.addSplitEdges(t)},e.prototype.computeEdgeIntersections=function(t,e,n){var r=new ci(e,n,!0);return r.setBoundaryNodes(this.getBoundaryNodes(),t.getBoundaryNodes()),this.createEdgeSetIntersector().computeIntersections(this._edges,t._edges,r),r},e.prototype.getGeometry=function(){return this._parentGeom},e.prototype.getBoundaryNodeRule=function(){return this._boundaryNodeRule},e.prototype.hasTooFewPoints=function(){return this._hasTooFewPoints},e.prototype.addPoint=function(){if(arguments[0]instanceof Zt){var t=arguments[0].getCoordinate();this.insertPoint(this._argIndex,t,M.INTERIOR)}else if(arguments[0]instanceof C){var e=arguments[0];this.insertPoint(this._argIndex,e,M.INTERIOR)}},e.prototype.addPolygon=function(t){this.addPolygonRing(t.getExteriorRing(),M.EXTERIOR,M.INTERIOR);for(var e=0;e<t.getNumInteriorRing();e++){var n=t.getInteriorRingN(e);this.addPolygonRing(n,M.INTERIOR,M.EXTERIOR)}},e.prototype.addEdge=function(t){this.insertEdge(t);var e=t.getCoordinates();this.insertPoint(this._argIndex,e[0],M.BOUNDARY),this.insertPoint(this._argIndex,e[e.length-1],M.BOUNDARY)},e.prototype.addLineString=function(t){var e=wt.removeRepeatedPoints(t.getCoordinates());if(e.length<2)return this._hasTooFewPoints=!0,this._invalidPoint=e[0],null;var n=new nr(e,new Re(this._argIndex,M.INTERIOR));this._lineEdgeMap.put(t,n),this.insertEdge(n),et.isTrue(e.length>=2,"found LineString with single point"),this.insertBoundaryPoint(this._argIndex,e[0]),this.insertBoundaryPoint(this._argIndex,e[e.length-1])},e.prototype.getInvalidPoint=function(){return this._invalidPoint},e.prototype.getBoundaryPoints=function(){for(var t=this.getBoundaryNodes(),e=new Array(t.size()).fill(null),n=0,r=t.iterator();r.hasNext();){var i=r.next();e[n++]=i.getCoordinate().copy()}return e},e.prototype.getBoundaryNodes=function(){return null===this._boundaryNodes&&(this._boundaryNodes=this._nodes.getBoundaryNodes(this._argIndex)),this._boundaryNodes},e.prototype.addSelfIntersectionNode=function(t,e,n){if(this.isBoundaryNode(t,e))return null;n===M.BOUNDARY&&this._useBoundaryDeterminationRule?this.insertBoundaryPoint(t,e):this.insertPoint(t,e,n)},e.prototype.addPolygonRing=function(t,e,n){if(t.isEmpty())return null;var r=wt.removeRepeatedPoints(t.getCoordinates());if(r.length<4)return this._hasTooFewPoints=!0,this._invalidPoint=r[0],null;var i=e,o=n;at.isCCW(r)&&(i=n,o=e);var s=new nr(r,new Re(this._argIndex,M.BOUNDARY,i,o));this._lineEdgeMap.put(t,s),this.insertEdge(s),this.insertPoint(this._argIndex,r[0],M.BOUNDARY)},e.prototype.insertPoint=function(t,e,n){var r=this._nodes.addNode(e),i=r.getLabel();null===i?r._label=new Re(t,n):i.setLocation(t,n)},e.prototype.createEdgeSetIntersector=function(){return new hi},e.prototype.addSelfIntersectionNodes=function(t){for(var e=this._edges.iterator();e.hasNext();)for(var n=e.next(),r=n.getLabel().getLocation(t),i=n.eiList.iterator();i.hasNext();){var o=i.next();this.addSelfIntersectionNode(t,o.coord,r)}},e.prototype.add=function(){if(1!==arguments.length)return t.prototype.add.apply(this,arguments);var e=arguments[0];if(e.isEmpty())return null;if(e instanceof ne&&(this._useBoundaryDeterminationRule=!1),e instanceof Qt)this.addPolygon(e);else if(e instanceof Kt)this.addLineString(e);else if(e instanceof Zt)this.addPoint(e);else if(e instanceof te)this.addCollection(e);else if(e instanceof zt)this.addCollection(e);else if(e instanceof ne)this.addCollection(e);else{if(!(e instanceof qt))throw new Error(e.getClass().getName());this.addCollection(e)}},e.prototype.addCollection=function(t){for(var e=0;e<t.getNumGeometries();e++){var n=t.getGeometryN(e);this.add(n)}},e.prototype.locate=function(t){return P(this._parentGeom,$t)&&this._parentGeom.getNumGeometries()>50?(null===this._areaPtLocator&&(this._areaPtLocator=new vi(this._parentGeom)),this._areaPtLocator.locate(t)):this._ptLocator.locate(t,this._parentGeom)},e.prototype.findEdge=function(){if(1===arguments.length){var e=arguments[0];return this._lineEdgeMap.get(e)}return t.prototype.findEdge.apply(this,arguments)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e.determineBoundary=function(t,e){return t.isInBoundary(e)?M.BOUNDARY:M.INTERIOR},e}(Ve),Ci=function(){if(this._li=new it,this._resultPrecisionModel=null,this._arg=null,1===arguments.length){var t=arguments[0];this.setComputationPrecision(t.getPrecisionModel()),this._arg=new Array(1).fill(null),this._arg[0]=new Ii(0,t)}else if(2===arguments.length){var e=arguments[0],n=arguments[1],r=gt.OGC_SFS_BOUNDARY_RULE;e.getPrecisionModel().compareTo(n.getPrecisionModel())>=0?this.setComputationPrecision(e.getPrecisionModel()):this.setComputationPrecision(n.getPrecisionModel()),this._arg=new Array(2).fill(null),this._arg[0]=new Ii(0,e,r),this._arg[1]=new Ii(1,n,r)}else if(3===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2];i.getPrecisionModel().compareTo(o.getPrecisionModel())>=0?this.setComputationPrecision(i.getPrecisionModel()):this.setComputationPrecision(o.getPrecisionModel()),this._arg=new Array(2).fill(null),this._arg[0]=new Ii(0,i,s),this._arg[1]=new Ii(1,o,s)}};Ci.prototype.getArgGeometry=function(t){return this._arg[t].getGeometry()},Ci.prototype.setComputationPrecision=function(t){this._resultPrecisionModel=t,this._li.setPrecisionModel(this._resultPrecisionModel)},Ci.prototype.interfaces_=function(){return[]},Ci.prototype.getClass=function(){return Ci};var Si=function(){};Si.prototype.interfaces_=function(){return[]},Si.prototype.getClass=function(){return Si},Si.map=function(){if(arguments[0]instanceof ct&&P(arguments[1],Si.MapOp)){for(var t=arguments[0],e=arguments[1],n=new It,r=0;r<t.getNumGeometries();r++){var i=e.map(t.getGeometryN(r));null!==i&&n.add(i)}return t.getFactory().buildGeometry(n)}if(P(arguments[0],xt)&&P(arguments[1],Si.MapOp)){for(var o=arguments[0],s=arguments[1],a=new It,u=o.iterator();u.hasNext();){var l=u.next(),c=s.map(l);null!==c&&a.add(c)}return a}},Si.MapOp=function(){};var wi=function(t){function e(){var e=arguments[0],n=arguments[1];t.call(this,e,n),this._ptLocator=new Sr,this._geomFact=null,this._resultGeom=null,this._graph=null,this._edgeList=new Wn,this._resultPolyList=new It,this._resultLineList=new It,this._resultPointList=new It,this._graph=new Ve(new Yn),this._geomFact=e.getFactory()}return t&&(e.__proto__=t),e.prototype=Object.create(t&&t.prototype),e.prototype.constructor=e,e.prototype.insertUniqueEdge=function(t){var e=this._edgeList.findEqualEdge(t);if(null!==e){var n=e.getLabel(),r=t.getLabel();e.isPointwiseEqual(t)||(r=new Re(t.getLabel())).flip();var i=e.getDepth();i.isNull()&&i.add(n),i.add(r),n.merge(r)}else this._edgeList.add(t)},e.prototype.getGraph=function(){return this._graph},e.prototype.cancelDuplicateResultEdges=function(){for(var t=this._graph.getEdgeEnds().iterator();t.hasNext();){var e=t.next(),n=e.getSym();e.isInResult()&&n.isInResult()&&(e.setInResult(!1),n.setInResult(!1))}},e.prototype.isCoveredByLA=function(t){return!!this.isCovered(t,this._resultLineList)||!!this.isCovered(t,this._resultPolyList)},e.prototype.computeGeometry=function(t,n,r,i){var o=new It;return o.addAll(t),o.addAll(n),o.addAll(r),o.isEmpty()?e.createEmptyResult(i,this._arg[0].getGeometry(),this._arg[1].getGeometry(),this._geomFact):this._geomFact.buildGeometry(o)},e.prototype.mergeSymLabels=function(){for(var t=this._graph.getNodes().iterator();t.hasNext();)t.next().getEdges().mergeSymLabels()},e.prototype.isCovered=function(t,e){for(var n=e.iterator();n.hasNext();){var r=n.next();if(this._ptLocator.locate(t,r)!==M.EXTERIOR)return!0}return!1},e.prototype.replaceCollapsedEdges=function(){for(var t=new It,e=this._edgeList.iterator();e.hasNext();){var n=e.next();n.isCollapsed()&&(e.remove(),t.add(n.getCollapsedEdge()))}this._edgeList.addAll(t)},e.prototype.updateNodeLabelling=function(){for(var t=this._graph.getNodes().iterator();t.hasNext();){var e=t.next(),n=e.getEdges().getLabel();e.getLabel().merge(n)}},e.prototype.getResultGeometry=function(t){return this.computeOverlay(t),this._resultGeom},e.prototype.insertUniqueEdges=function(t){for(var e=t.iterator();e.hasNext();){var n=e.next();this.insertUniqueEdge(n)}},e.prototype.computeOverlay=function(t){this.copyPoints(0),this.copyPoints(1),this._arg[0].computeSelfNodes(this._li,!1),this._arg[1].computeSelfNodes(this._li,!1),this._arg[0].computeEdgeIntersections(this._arg[1],this._li,!0);var e=new It;this._arg[0].computeSplitEdges(e),this._arg[1].computeSplitEdges(e),this.insertUniqueEdges(e),this.computeLabelsFromDepths(),this.replaceCollapsedEdges(),Vr.checkValid(this._edgeList.getEdges()),this._graph.addEdges(this._edgeList.getEdges()),this.computeLabelling(),this.labelIncompleteNodes(),this.findResultAreaEdges(t),this.cancelDuplicateResultEdges();var n=new Ye(this._geomFact);n.add(this._graph),this._resultPolyList=n.getPolygons();var r=new Xr(this,this._geomFact,this._ptLocator);this._resultLineList=r.build(t);var i=new Wr(this,this._geomFact,this._ptLocator);this._resultPointList=i.build(t),this._resultGeom=this.computeGeometry(this._resultPointList,this._resultLineList,this._resultPolyList,t)},e.prototype.labelIncompleteNode=function(t,e){var n=this._ptLocator.locate(t.getCoordinate(),this._arg[e].getGeometry());t.getLabel().setLocation(e,n)},e.prototype.copyPoints=function(t){for(var e=this._arg[t].getNodeIterator();e.hasNext();){var n=e.next();this._graph.addNode(n.getCoordinate()).setLabel(t,n.getLabel().getLocation(t))}},e.prototype.findResultAreaEdges=function(t){for(var n=this._graph.getEdgeEnds().iterator();n.hasNext();){var r=n.next(),i=r.getLabel();i.isArea()&&!r.isInteriorAreaEdge()&&e.isResultOfOp(i.getLocation(0,Se.RIGHT),i.getLocation(1,Se.RIGHT),t)&&r.setInResult(!0)}},e.prototype.computeLabelsFromDepths=function(){for(var t=this._edgeList.iterator();t.hasNext();){var e=t.next(),n=e.getLabel(),r=e.getDepth();if(!r.isNull()){r.normalize();for(var i=0;i<2;i++)n.isNull(i)||!n.isArea()||r.isNull(i)||(0===r.getDelta(i)?n.toLine(i):(et.isTrue(!r.isNull(i,Se.LEFT),"depth of LEFT side has not been initialized"),n.setLocation(i,Se.LEFT,r.getLocation(i,Se.LEFT)),et.isTrue(!r.isNull(i,Se.RIGHT),"depth of RIGHT side has not been initialized"),n.setLocation(i,Se.RIGHT,r.getLocation(i,Se.RIGHT))))}}},e.prototype.computeLabelling=function(){for(var t=this._graph.getNodes().iterator();t.hasNext();)t.next().getEdges().computeLabelling(this._arg);this.mergeSymLabels(),this.updateNodeLabelling()},e.prototype.labelIncompleteNodes=function(){for(var t=this._graph.getNodes().iterator();t.hasNext();){var e=t.next(),n=e.getLabel();e.isIsolated()&&(n.isNull(0)?this.labelIncompleteNode(e,0):this.labelIncompleteNode(e,1)),e.getEdges().updateLabelling(n)}},e.prototype.isCoveredByA=function(t){return!!this.isCovered(t,this._resultPolyList)},e.prototype.interfaces_=function(){return[]},e.prototype.getClass=function(){return e},e}(Ci);wi.overlayOp=function(t,e,n){return new wi(t,e).getResultGeometry(n)},wi.intersection=function(t,e){if(t.isEmpty()||e.isEmpty())return wi.createEmptyResult(wi.INTERSECTION,t,e,t.getFactory());if(t.isGeometryCollection()){var n=e;return Yr.map(t,{interfaces_:function(){return[Si.MapOp]},map:function(t){return t.intersection(n)}})}return t.checkNotGeometryCollection(t),t.checkNotGeometryCollection(e),oi.overlayOp(t,e,wi.INTERSECTION)},wi.symDifference=function(t,e){if(t.isEmpty()||e.isEmpty()){if(t.isEmpty()&&e.isEmpty())return wi.createEmptyResult(wi.SYMDIFFERENCE,t,e,t.getFactory());if(t.isEmpty())return e.copy();if(e.isEmpty())return t.copy()}return t.checkNotGeometryCollection(t),t.checkNotGeometryCollection(e),oi.overlayOp(t,e,wi.SYMDIFFERENCE)},wi.resultDimension=function(t,e,n){var r=e.getDimension(),i=n.getDimension(),o=-1;switch(t){case wi.INTERSECTION:o=Math.min(r,i);break;case wi.UNION:o=Math.max(r,i);break;case wi.DIFFERENCE:o=r;break;case wi.SYMDIFFERENCE:o=Math.max(r,i)}return o},wi.createEmptyResult=function(t,e,n,r){var i=null;switch(wi.resultDimension(t,e,n)){case-1:i=r.createGeometryCollection(new Array(0).fill(null));break;case 0:i=r.createPoint();break;case 1:i=r.createLineString();break;case 2:i=r.createPolygon()}return i},wi.difference=function(t,e){return t.isEmpty()?wi.createEmptyResult(wi.DIFFERENCE,t,e,t.getFactory()):e.isEmpty()?t.copy():(t.checkNotGeometryCollection(t),t.checkNotGeometryCollection(e),oi.overlayOp(t,e,wi.DIFFERENCE))},wi.isResultOfOp=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1],n=t.getLocation(0),r=t.getLocation(1);return wi.isResultOfOp(n,r,e)}if(3===arguments.length){var i=arguments[0],o=arguments[1],s=arguments[2];switch(i===M.BOUNDARY&&(i=M.INTERIOR),o===M.BOUNDARY&&(o=M.INTERIOR),s){case wi.INTERSECTION:return i===M.INTERIOR&&o===M.INTERIOR;case wi.UNION:return i===M.INTERIOR||o===M.INTERIOR;case wi.DIFFERENCE:return i===M.INTERIOR&&o!==M.INTERIOR;case wi.SYMDIFFERENCE:return i===M.INTERIOR&&o!==M.INTERIOR||i!==M.INTERIOR&&o===M.INTERIOR}return!1}},wi.INTERSECTION=1,wi.UNION=2,wi.DIFFERENCE=3,wi.SYMDIFFERENCE=4;var Ni=function(){this._g=null,this._boundaryDistanceTolerance=null,this._linework=null,this._ptLocator=new Sr,this._seg=new dn;var t=arguments[0],e=arguments[1];this._g=t,this._boundaryDistanceTolerance=e,this._linework=this.extractLinework(t)};Ni.prototype.isWithinToleranceOfBoundary=function(t){for(var e=0;e<this._linework.getNumGeometries();e++)for(var n=this._linework.getGeometryN(e).getCoordinateSequence(),r=0;r<n.size()-1;r++)if(n.getCoordinate(r,this._seg.p0),n.getCoordinate(r+1,this._seg.p1),this._seg.distance(t)<=this._boundaryDistanceTolerance)return!0;return!1},Ni.prototype.getLocation=function(t){return this.isWithinToleranceOfBoundary(t)?M.BOUNDARY:this._ptLocator.locate(t,this._g)},Ni.prototype.extractLinework=function(t){var e=new Mi;t.apply(e);var n=e.getLinework(),r=_e.toLineStringArray(n);return t.getFactory().createMultiLineString(r)},Ni.prototype.interfaces_=function(){return[]},Ni.prototype.getClass=function(){return Ni};var Mi=function(){this._linework=null,this._linework=new It};Mi.prototype.getLinework=function(){return this._linework},Mi.prototype.filter=function(t){if(t instanceof Qt){var e=t;this._linework.add(e.getExteriorRing());for(var n=0;n<e.getNumInteriorRing();n++)this._linework.add(e.getInteriorRingN(n))}},Mi.prototype.interfaces_=function(){return[jt]},Mi.prototype.getClass=function(){return Mi};var Li=function(){this._g=null,this._doLeft=!0,this._doRight=!0;var t=arguments[0];this._g=t};Li.prototype.extractPoints=function(t,e,n){for(var r=t.getCoordinates(),i=0;i<r.length-1;i++)this.computeOffsetPoints(r[i],r[i+1],e,n)},Li.prototype.setSidesToGenerate=function(t,e){this._doLeft=t,this._doRight=e},Li.prototype.getPoints=function(t){for(var e=new It,n=Cr.getLines(this._g).iterator();n.hasNext();){var r=n.next();this.extractPoints(r,t,e)}return e},Li.prototype.computeOffsetPoints=function(t,e,n,r){var i=e.x-t.x,o=e.y-t.y,s=Math.sqrt(i*i+o*o),a=n*i/s,u=n*o/s,l=(e.x+t.x)/2,c=(e.y+t.y)/2;if(this._doLeft){var h=new C(l-u,c+a);r.add(h)}if(this._doRight){var p=new C(l+u,c-a);r.add(p)}},Li.prototype.interfaces_=function(){return[]},Li.prototype.getClass=function(){return Li};var Pi=function t(){this._geom=null,this._locFinder=null,this._location=new Array(3).fill(null),this._invalidLocation=null,this._boundaryDistanceTolerance=t.TOLERANCE,this._testCoords=new It;var e=arguments[0],n=arguments[1],r=arguments[2];this._boundaryDistanceTolerance=t.computeBoundaryDistanceTolerance(e,n),this._geom=[e,n,r],this._locFinder=[new Ni(this._geom[0],this._boundaryDistanceTolerance),new Ni(this._geom[1],this._boundaryDistanceTolerance),new Ni(this._geom[2],this._boundaryDistanceTolerance)]},Oi={TOLERANCE:{configurable:!0}};Pi.prototype.reportResult=function(t,e,n){V.out.println("Overlay result invalid - A:"+M.toLocationSymbol(e[0])+" B:"+M.toLocationSymbol(e[1])+" expected:"+(n?"i":"e")+" actual:"+M.toLocationSymbol(e[2]))},Pi.prototype.isValid=function(t){return this.addTestPts(this._geom[0]),this.addTestPts(this._geom[1]),this.checkValid(t)},Pi.prototype.checkValid=function(){if(1===arguments.length){for(var t=arguments[0],e=0;e<this._testCoords.size();e++){var n=this._testCoords.get(e);if(!this.checkValid(t,n))return this._invalidLocation=n,!1}return!0}if(2===arguments.length){var r=arguments[0],i=arguments[1];return this._location[0]=this._locFinder[0].getLocation(i),this._location[1]=this._locFinder[1].getLocation(i),this._location[2]=this._locFinder[2].getLocation(i),!!Pi.hasLocation(this._location,M.BOUNDARY)||this.isValidResult(r,this._location)}},Pi.prototype.addTestPts=function(t){var e=new Li(t);this._testCoords.addAll(e.getPoints(5*this._boundaryDistanceTolerance))},Pi.prototype.isValidResult=function(t,e){var n=wi.isResultOfOp(e[0],e[1],t),r=!(n^e[2]===M.INTERIOR);return r||this.reportResult(t,e,n),r},Pi.prototype.getInvalidLocation=function(){return this._invalidLocation},Pi.prototype.interfaces_=function(){return[]},Pi.prototype.getClass=function(){return Pi},Pi.hasLocation=function(t,e){for(var n=0;n<3;n++)if(t[n]===e)return!0;return!1},Pi.computeBoundaryDistanceTolerance=function(t,e){return Math.min(Jr.computeSizeBasedSnapTolerance(t),Jr.computeSizeBasedSnapTolerance(e))},Pi.isValid=function(t,e,n,r){return new Pi(t,e,r).isValid(n)},Oi.TOLERANCE.get=function(){return 1e-6},Object.defineProperties(Pi,Oi);var Ri=function t(e){this._geomFactory=null,this._skipEmpty=!1,this._inputGeoms=null,this._geomFactory=t.extractFactory(e),this._inputGeoms=e};Ri.prototype.extractElements=function(t,e){if(null===t)return null;for(var n=0;n<t.getNumGeometries();n++){var r=t.getGeometryN(n);this._skipEmpty&&r.isEmpty()||e.add(r)}},Ri.prototype.combine=function(){for(var t=new It,e=this._inputGeoms.iterator();e.hasNext();){var n=e.next();this.extractElements(n,t)}return 0===t.size()?null!==this._geomFactory?this._geomFactory.createGeometryCollection(null):null:this._geomFactory.buildGeometry(t)},Ri.prototype.interfaces_=function(){return[]},Ri.prototype.getClass=function(){return Ri},Ri.combine=function(){if(1===arguments.length)return new Ri(arguments[0]).combine();if(2===arguments.length){var t=arguments[0],e=arguments[1];return new Ri(Ri.createList(t,e)).combine()}if(3===arguments.length){var n=arguments[0],r=arguments[1],i=arguments[2];return new Ri(Ri.createList(n,r,i)).combine()}},Ri.extractFactory=function(t){return t.isEmpty()?null:t.iterator().next().getFactory()},Ri.createList=function(){if(2===arguments.length){var t=arguments[0],e=arguments[1],n=new It;return n.add(t),n.add(e),n}if(3===arguments.length){var r=arguments[0],i=arguments[1],o=arguments[2],s=new It;return s.add(r),s.add(i),s.add(o),s}};var Ti=function(){this._inputPolys=null,this._geomFactory=null;var t=arguments[0];this._inputPolys=t,null===this._inputPolys&&(this._inputPolys=new It)},Ai={STRTREE_NODE_CAPACITY:{configurable:!0}};Ti.prototype.reduceToGeometries=function(t){for(var e=new It,n=t.iterator();n.hasNext();){var r=n.next(),i=null;P(r,Et)?i=this.unionTree(r):r instanceof ct&&(i=r),e.add(i)}return e},Ti.prototype.extractByEnvelope=function(t,e,n){for(var r=new It,i=0;i<e.getNumGeometries();i++){var o=e.getGeometryN(i);o.getEnvelopeInternal().intersects(t)?r.add(o):n.add(o)}return this._geomFactory.buildGeometry(r)},Ti.prototype.unionOptimized=function(t,e){var n=t.getEnvelopeInternal(),r=e.getEnvelopeInternal();if(!n.intersects(r))return Ri.combine(t,e);if(t.getNumGeometries()<=1&&e.getNumGeometries()<=1)return this.unionActual(t,e);var i=n.intersection(r);return this.unionUsingEnvelopeIntersection(t,e,i)},Ti.prototype.union=function(){if(null===this._inputPolys)throw new Error("union() method cannot be called twice");if(this._inputPolys.isEmpty())return null;this._geomFactory=this._inputPolys.iterator().next().getFactory();for(var t=new sn(Ti.STRTREE_NODE_CAPACITY),e=this._inputPolys.iterator();e.hasNext();){var n=e.next();t.insert(n.getEnvelopeInternal(),n)}this._inputPolys=null;var r=t.itemsTree();return this.unionTree(r)},Ti.prototype.binaryUnion=function(){if(1===arguments.length){var t=arguments[0];return this.binaryUnion(t,0,t.size())}if(3===arguments.length){var e=arguments[0],n=arguments[1],r=arguments[2];if(r-n<=1){var i=Ti.getGeometry(e,n);return this.unionSafe(i,null)}if(r-n==2)return this.unionSafe(Ti.getGeometry(e,n),Ti.getGeometry(e,n+1));var o=Math.trunc((r+n)/2),s=this.binaryUnion(e,n,o),a=this.binaryUnion(e,o,r);return this.unionSafe(s,a)}},Ti.prototype.repeatedUnion=function(t){for(var e=null,n=t.iterator();n.hasNext();){var r=n.next();e=null===e?r.copy():e.union(r)}return e},Ti.prototype.unionSafe=function(t,e){return null===t&&null===e?null:null===t?e.copy():null===e?t.copy():this.unionOptimized(t,e)},Ti.prototype.unionActual=function(t,e){return Ti.restrictToPolygons(t.union(e))},Ti.prototype.unionTree=function(t){var e=this.reduceToGeometries(t);return this.binaryUnion(e)},Ti.prototype.unionUsingEnvelopeIntersection=function(t,e,n){var r=new It,i=this.extractByEnvelope(n,t,r),o=this.extractByEnvelope(n,e,r),s=this.unionActual(i,o);return r.add(s),Ri.combine(r)},Ti.prototype.bufferUnion=function(){if(1===arguments.length){var t=arguments[0];return t.get(0).getFactory().buildGeometry(t).buffer(0)}if(2===arguments.length){var e=arguments[0],n=arguments[1];return e.getFactory().createGeometryCollection([e,n]).buffer(0)}},Ti.prototype.interfaces_=function(){return[]},Ti.prototype.getClass=function(){return Ti},Ti.restrictToPolygons=function(t){if(P(t,$t))return t;var e=Ir.getPolygons(t);return 1===e.size()?e.get(0):t.getFactory().createMultiPolygon(_e.toPolygonArray(e))},Ti.getGeometry=function(t,e){return e>=t.size()?null:t.get(e)},Ti.union=function(t){return new Ti(t).union()},Ai.STRTREE_NODE_CAPACITY.get=function(){return 4},Object.defineProperties(Ti,Ai);var Di=function(){};Di.prototype.interfaces_=function(){return[]},Di.prototype.getClass=function(){return Di},Di.union=function(t,e){if(t.isEmpty()||e.isEmpty()){if(t.isEmpty()&&e.isEmpty())return wi.createEmptyResult(wi.UNION,t,e,t.getFactory());if(t.isEmpty())return e.copy();if(e.isEmpty())return t.copy()}return t.checkNotGeometryCollection(t),t.checkNotGeometryCollection(e),oi.overlayOp(t,e,wi.UNION)},t.GeoJSONReader=Ie,t.GeoJSONWriter=Ce,t.OverlayOp=wi,t.UnionOp=Di,t.BufferOp=dr,Object.defineProperty(t,"__esModule",{value:!0})}(e)}},e={};function n(r){var i=e[r];if(void 0!==i)return i.exports;var o=e[r]={exports:{}};return t[r].call(o.exports,o,o.exports,n),o.exports}n.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return n.d(e,{a:e}),e},n.d=(t,e)=>{for(var r in e)n.o(e,r)&&!n.o(t,r)&&Object.defineProperty(t,r,{enumerable:!0,get:e[r]})},n.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),n.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),n.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})};var r={};(()=>{"use strict";n.r(r),n.d(r,{default:()=>Ue});var t=n(1307),e=n.n(t),i=6371008.8,o={centimeters:637100880,centimetres:637100880,degrees:57.22891354143274,feet:20902260.511392,inches:250826616.45599997,kilometers:6371.0088,kilometres:6371.0088,meters:i,metres:i,miles:3958.761333810546,millimeters:6371008800,millimetres:6371008800,nauticalmiles:3440.069546436285,radians:1,yards:6967335.223679999};function s(t,e,n){void 0===n&&(n={});var r={type:"Feature"};return(0===n.id||n.id)&&(r.id=n.id),n.bbox&&(r.bbox=n.bbox),r.properties=e||{},r.geometry=t,r}function a(t,e,n){if(void 0===n&&(n={}),!t)throw new Error("coordinates is required");if(!Array.isArray(t))throw new Error("coordinates must be an Array");if(t.length<2)throw new Error("coordinates must be at least 2 numbers long");if(!h(t[0])||!h(t[1]))throw new Error("coordinates must contain numbers");return s({type:"Point",coordinates:t},e,n)}function u(t,e,n){void 0===n&&(n={});for(var r=0,i=t;r<i.length;r++){var o=i[r];if(o.length<4)throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");for(var a=0;a<o[o.length-1].length;a++)if(o[o.length-1][a]!==o[0][a])throw new Error("First and last Position are not equivalent.")}return s({type:"Polygon",coordinates:t},e,n)}function l(t,e,n){if(void 0===n&&(n={}),t.length<2)throw new Error("coordinates must be an array of two or more positions");return s({type:"LineString",coordinates:t},e,n)}function c(t){return t%360*Math.PI/180}function h(t){return!isNaN(t)&&null!==t&&!Array.isArray(t)}function p(t,e,n){if(null!==t)for(var r,i,o,s,a,u,l,c,h=0,f=0,g=t.type,d="FeatureCollection"===g,y="Feature"===g,_=d?t.features.length:1,m=0;m<_;m++){a=(c=!!(l=d?t.features[m].geometry:y?t.geometry:t)&&"GeometryCollection"===l.type)?l.geometries.length:1;for(var v=0;v<a;v++){var x=0,b=0;if(null!==(s=c?l.geometries[v]:l)){u=s.coordinates;var E=s.type;switch(h=!n||"Polygon"!==E&&"MultiPolygon"!==E?0:1,E){case null:break;case"Point":if(!1===e(u,f,m,x,b))return!1;f++,x++;break;case"LineString":case"MultiPoint":for(r=0;r<u.length;r++){if(!1===e(u[r],f,m,x,b))return!1;f++,"MultiPoint"===E&&x++}"LineString"===E&&x++;break;case"Polygon":case"MultiLineString":for(r=0;r<u.length;r++){for(i=0;i<u[r].length-h;i++){if(!1===e(u[r][i],f,m,x,b))return!1;f++}"MultiLineString"===E&&x++,"Polygon"===E&&b++}"Polygon"===E&&x++;break;case"MultiPolygon":for(r=0;r<u.length;r++){for(b=0,i=0;i<u[r].length;i++){for(o=0;o<u[r][i].length-h;o++){if(!1===e(u[r][i][o],f,m,x,b))return!1;f++}b++}x++}break;case"GeometryCollection":for(r=0;r<s.geometries.length;r++)if(!1===p(s.geometries[r],e,n))return!1;break;default:throw new Error("Unknown Geometry Type")}}}}}function f(t,e){var n,r,i,o,s,a,u,l,c,h,p=0,f="FeatureCollection"===t.type,g="Feature"===t.type,d=f?t.features.length:1;for(n=0;n<d;n++){for(a=f?t.features[n].geometry:g?t.geometry:t,l=f?t.features[n].properties:g?t.properties:{},c=f?t.features[n].bbox:g?t.bbox:void 0,h=f?t.features[n].id:g?t.id:void 0,s=(u=!!a&&"GeometryCollection"===a.type)?a.geometries.length:1,i=0;i<s;i++)if(null!==(o=u?a.geometries[i]:a))switch(o.type){case"Point":case"LineString":case"MultiPoint":case"Polygon":case"MultiLineString":case"MultiPolygon":if(!1===e(o,p,l,c,h))return!1;break;case"GeometryCollection":for(r=0;r<o.geometries.length;r++)if(!1===e(o.geometries[r],p,l,c,h))return!1;break;default:throw new Error("Unknown Geometry Type")}else if(!1===e(null,p,l,c,h))return!1;p++}}function g(t,e){f(t,(function(t,n,r,i,o){var a,u=null===t?null:t.type;switch(u){case null:case"Point":case"LineString":case"Polygon":return!1!==e(s(t,r,{bbox:i,id:o}),n,0)&&void 0}switch(u){case"MultiPoint":a="Point";break;case"MultiLineString":a="LineString";break;case"MultiPolygon":a="Polygon"}for(var l=0;l<t.coordinates.length;l++){var c=t.coordinates[l];if(!1===e(s({type:a,coordinates:c},r),n,l))return!1}}))}function d(t){var e=[1/0,1/0,-1/0,-1/0];return p(t,(function(t){e[0]>t[0]&&(e[0]=t[0]),e[1]>t[1]&&(e[1]=t[1]),e[2]<t[0]&&(e[2]=t[0]),e[3]<t[1]&&(e[3]=t[1])})),e}d.default=d;const y=d;function _(t){if(!t)throw new Error("coord is required");if(!Array.isArray(t)){if("Feature"===t.type&&null!==t.geometry&&"Point"===t.geometry.type)return t.geometry.coordinates;if("Point"===t.type)return t.coordinates}if(Array.isArray(t)&&t.length>=2&&!Array.isArray(t[0])&&!Array.isArray(t[1]))return t;throw new Error("coord must be GeoJSON Point or an Array of numbers")}function m(t){if(Array.isArray(t))return t;if("Feature"===t.type){if(null!==t.geometry)return t.geometry.coordinates}else if(t.coordinates)return t.coordinates;throw new Error("coords must be GeoJSON Feature, Geometry Object or an Array")}function v(t,e,n){if(void 0===n&&(n={}),!t)throw new Error("point is required");if(!e)throw new Error("polygon is required");var r,i=_(t),o="Feature"===(r=e).type?r.geometry:r,s=o.type,a=e.bbox,u=o.coordinates;if(a&&!1===function(t,e){return e[0]<=t[0]&&e[1]<=t[1]&&e[2]>=t[0]&&e[3]>=t[1]}(i,a))return!1;"Polygon"===s&&(u=[u]);for(var l=!1,c=0;c<u.length&&!l;c++)if(x(i,u[c][0],n.ignoreBoundary)){for(var h=!1,p=1;p<u[c].length&&!h;)x(i,u[c][p],!n.ignoreBoundary)&&(h=!0),p++;h||(l=!0)}return l}function x(t,e,n){var r=!1;e[0][0]===e[e.length-1][0]&&e[0][1]===e[e.length-1][1]&&(e=e.slice(0,e.length-1));for(var i=0,o=e.length-1;i<e.length;o=i++){var s=e[i][0],a=e[i][1],u=e[o][0],l=e[o][1];if(t[1]*(s-u)+a*(u-t[0])+l*(t[0]-s)==0&&(s-t[0])*(u-t[0])<=0&&(a-t[1])*(l-t[1])<=0)return!n;a>t[1]!=l>t[1]&&t[0]<(u-s)*(t[1]-a)/(l-a)+s&&(r=!r)}return r}n(7418),n(2273);const b=function(t,e,n){void 0===n&&(n={});var r=_(t),i=_(e),s=c(i[1]-r[1]),a=c(i[0]-r[0]),u=c(r[1]),l=c(i[1]),h=Math.pow(Math.sin(s/2),2)+Math.pow(Math.sin(a/2),2)*Math.cos(u)*Math.cos(l);return function(t,e){void 0===e&&(e="kilometers");var n=o[e];if(!n)throw new Error(e+" units is invalid");return t*n}(2*Math.atan2(Math.sqrt(h),Math.sqrt(1-h)),n.units)};Object.prototype.hasOwnProperty;var E=new ArrayBuffer(16);new Float64Array(E),new Uint32Array(E),n(5510),function(){function t(t){this.points=t.points||[],this.duration=t.duration||1e4,this.sharpness=t.sharpness||.85,this.centers=[],this.controls=[],this.stepLength=t.stepLength||60,this.length=this.points.length,this.delay=0;for(var e=0;e<this.length;e++)this.points[e].z=this.points[e].z||0;for(e=0;e<this.length-1;e++){var n=this.points[e],r=this.points[e+1];this.centers.push({x:(n.x+r.x)/2,y:(n.y+r.y)/2,z:(n.z+r.z)/2})}for(this.controls.push([this.points[0],this.points[0]]),e=0;e<this.centers.length-1;e++){var i=this.points[e+1].x-(this.centers[e].x+this.centers[e+1].x)/2,o=this.points[e+1].y-(this.centers[e].y+this.centers[e+1].y)/2,s=this.points[e+1].z-(this.centers[e].y+this.centers[e+1].z)/2;this.controls.push([{x:(1-this.sharpness)*this.points[e+1].x+this.sharpness*(this.centers[e].x+i),y:(1-this.sharpness)*this.points[e+1].y+this.sharpness*(this.centers[e].y+o),z:(1-this.sharpness)*this.points[e+1].z+this.sharpness*(this.centers[e].z+s)},{x:(1-this.sharpness)*this.points[e+1].x+this.sharpness*(this.centers[e+1].x+i),y:(1-this.sharpness)*this.points[e+1].y+this.sharpness*(this.centers[e+1].y+o),z:(1-this.sharpness)*this.points[e+1].z+this.sharpness*(this.centers[e+1].z+s)}])}return this.controls.push([this.points[this.length-1],this.points[this.length-1]]),this.steps=this.cacheSteps(this.stepLength),this}t.prototype.cacheSteps=function(t){var e=[],n=this.pos(0);e.push(0);for(var r=0;r<this.duration;r+=10){var i=this.pos(r);Math.sqrt((i.x-n.x)*(i.x-n.x)+(i.y-n.y)*(i.y-n.y)+(i.z-n.z)*(i.z-n.z))>t&&(e.push(r),n=i)}return e},t.prototype.vector=function(t){var e=this.pos(t+10),n=this.pos(t-10);return{angle:180*Math.atan2(e.y-n.y,e.x-n.x)/3.14,speed:Math.sqrt((n.x-e.x)*(n.x-e.x)+(n.y-e.y)*(n.y-e.y)+(n.z-e.z)*(n.z-e.z))}},t.prototype.pos=function(t){var e=t-this.delay;e<0&&(e=0),e>this.duration&&(e=this.duration-1);var n=e/this.duration;if(n>=1)return this.points[this.length-1];var r=Math.floor((this.points.length-1)*n);return function(t,e,n,r,i){var o=function(t){var e=t*t;return[e*t,3*e*(1-t),3*t*(1-t)*(1-t),(1-t)*(1-t)*(1-t)]}(t);return{x:i.x*o[0]+r.x*o[1]+n.x*o[2]+e.x*o[3],y:i.y*o[0]+r.y*o[1]+n.y*o[2]+e.y*o[3],z:i.z*o[0]+r.z*o[1]+n.z*o[2]+e.z*o[3]}}((this.length-1)*n-r,this.points[r],this.controls[r][1],this.controls[r+1][0],this.points[r+1])}}();const I=function(t,e){void 0===e&&(e={});var n=0,r=0,i=0;return p(t,(function(t){n+=t[0],r+=t[1],i++}),!0),a([n/i,r/i],e.properties)};n(9187);n(1787);var C=6378137;function S(t){return function(t,e,n){var r=0;return f(t,(function(t,e,n,i,o){r=r+function(t){var e,n=0;switch(t.type){case"Polygon":return w(t.coordinates);case"MultiPolygon":for(e=0;e<t.coordinates.length;e++)n+=w(t.coordinates[e]);return n;case"Point":case"MultiPoint":case"LineString":case"MultiLineString":return 0}return 0}(t)})),r}(t)}function w(t){var e=0;if(t&&t.length>0){e+=Math.abs(N(t[0]));for(var n=1;n<t.length;n++)e-=Math.abs(N(t[n]))}return e}function N(t){var e,n,r,i,o,s,a=0,u=t.length;if(u>2){for(s=0;s<u;s++)s===u-2?(r=u-2,i=u-1,o=0):s===u-1?(r=u-1,i=0,o=1):(r=s,i=s+1,o=s+2),e=t[r],n=t[i],a+=(M(t[o][0])-M(e[0]))*Math.sin(M(n[1]));a=a*C*C/2}return a}function M(t){return t*Math.PI/180}var L=Math.PI/180,P=180/Math.PI,O=function(t,e){this.lon=t,this.lat=e,this.x=L*t,this.y=L*e};O.prototype.view=function(){return String(this.lon).slice(0,4)+","+String(this.lat).slice(0,4)},O.prototype.antipode=function(){var t=-1*this.lat,e=this.lon<0?180+this.lon:-1*(180-this.lon);return new O(e,t)};var R=function(){this.coords=[],this.length=0};R.prototype.move_to=function(t){this.length++,this.coords.push(t)};var T=function(t){this.properties=t||{},this.geometries=[]};T.prototype.json=function(){if(this.geometries.length<=0)return{geometry:{type:"LineString",coordinates:null},type:"Feature",properties:this.properties};if(1===this.geometries.length)return{geometry:{type:"LineString",coordinates:this.geometries[0].coords},type:"Feature",properties:this.properties};for(var t=[],e=0;e<this.geometries.length;e++)t.push(this.geometries[e].coords);return{geometry:{type:"MultiLineString",coordinates:t},type:"Feature",properties:this.properties}},T.prototype.wkt=function(){for(var t="",e="LINESTRING(",n=function(t){e+=t[0]+" "+t[1]+","},r=0;r<this.geometries.length;r++){if(0===this.geometries[r].coords.length)return"LINESTRING(empty)";this.geometries[r].coords.forEach(n),t+=e.substring(0,e.length-1)+")"}return t};var A=function(t,e,n){if(!t||void 0===t.x||void 0===t.y)throw new Error("GreatCircle constructor expects two args: start and end objects with x and y properties");if(!e||void 0===e.x||void 0===e.y)throw new Error("GreatCircle constructor expects two args: start and end objects with x and y properties");this.start=new O(t.x,t.y),this.end=new O(e.x,e.y),this.properties=n||{};var r=this.start.x-this.end.x,i=this.start.y-this.end.y,o=Math.pow(Math.sin(i/2),2)+Math.cos(this.start.y)*Math.cos(this.end.y)*Math.pow(Math.sin(r/2),2);if(this.g=2*Math.asin(Math.sqrt(o)),this.g===Math.PI)throw new Error("it appears "+t.view()+" and "+e.view()+" are 'antipodal', e.g diametrically opposite, thus there is no single route but rather infinite");if(isNaN(this.g))throw new Error("could not calculate great circle between "+t+" and "+e)};A.prototype.interpolate=function(t){var e=Math.sin((1-t)*this.g)/Math.sin(this.g),n=Math.sin(t*this.g)/Math.sin(this.g),r=e*Math.cos(this.start.y)*Math.cos(this.start.x)+n*Math.cos(this.end.y)*Math.cos(this.end.x),i=e*Math.cos(this.start.y)*Math.sin(this.start.x)+n*Math.cos(this.end.y)*Math.sin(this.end.x),o=e*Math.sin(this.start.y)+n*Math.sin(this.end.y),s=P*Math.atan2(o,Math.sqrt(Math.pow(r,2)+Math.pow(i,2)));return[P*Math.atan2(i,r),s]},A.prototype.Arc=function(t,e){var n=[];if(!t||t<=2)n.push([this.start.lon,this.start.lat]),n.push([this.end.lon,this.end.lat]);else for(var r=1/(t-1),i=0;i<t;++i){var o=r*i,s=this.interpolate(o);n.push(s)}for(var a=!1,u=0,l=e&&e.offset?e.offset:10,c=180-l,h=-180+l,p=360-l,f=1;f<n.length;++f){var g=n[f-1][0],d=n[f][0],y=Math.abs(d-g);y>p&&(d>c&&g<h||g>c&&d<h)?a=!0:y>u&&(u=y)}var _=[];if(a&&u<l){var m=[];_.push(m);for(var v=0;v<n.length;++v){var x=parseFloat(n[v][0]);if(v>0&&Math.abs(x-n[v-1][0])>p){var b=parseFloat(n[v-1][0]),E=parseFloat(n[v-1][1]),I=parseFloat(n[v][0]),C=parseFloat(n[v][1]);if(b>-180&&b<h&&180===I&&v+1<n.length&&n[v-1][0]>-180&&n[v-1][0]<h){m.push([-180,n[v][1]]),v++,m.push([n[v][0],n[v][1]]);continue}if(b>c&&b<180&&-180===I&&v+1<n.length&&n[v-1][0]>c&&n[v-1][0]<180){m.push([180,n[v][1]]),v++,m.push([n[v][0],n[v][1]]);continue}if(b<h&&I>c){var S=b;b=I,I=S;var w=E;E=C,C=w}if(b>c&&I<h&&(I+=360),b<=180&&I>=180&&b<I){var N=(180-b)/(I-b),M=N*C+(1-N)*E;m.push([n[v-1][0]>c?180:-180,M]),(m=[]).push([n[v-1][0]>c?-180:180,M]),_.push(m)}else m=[],_.push(m);m.push([x,n[v][1]])}else m.push([n[v][0],n[v][1]])}}else{var L=[];_.push(L);for(var P=0;P<n.length;++P)L.push([n[P][0],n[P][1]])}for(var O=new T(this.properties),A=0;A<_.length;++A){var D=new R;O.geometries.push(D);for(var F=_[A],k=0;k<F.length;++k)D.move_to(F[k])}return O},n(251);var D=[],F=[],k=[],G=[],B=[],j=[],U=[],q=[],z=[],V=[],Y=[],X=[],W=[],H=[],K=[],J=[],Z=[],$=[],Q=[],tt=[],et=[],nt=[],rt=[],it=[];U[85]=V[85]=-1,q[85]=Y[85]=0,z[85]=X[85]=1,Q[85]=nt[85]=1,tt[85]=rt[85]=0,et[85]=it[85]=1,D[85]=G[85]=0,F[85]=B[85]=-1,k[85]=K[85]=0,J[85]=W[85]=0,Z[85]=H[85]=1,j[85]=$[85]=1,nt[1]=nt[169]=0,rt[1]=rt[169]=-1,it[1]=it[169]=0,W[1]=W[169]=-1,H[1]=H[169]=0,K[1]=K[169]=0,V[4]=V[166]=0,Y[4]=Y[166]=-1,X[4]=X[166]=1,J[4]=J[166]=1,Z[4]=Z[166]=0,$[4]=$[166]=0,U[16]=U[154]=0,q[16]=q[154]=1,z[16]=z[154]=1,G[16]=G[154]=1,B[16]=B[154]=0,j[16]=j[154]=1,Q[64]=Q[106]=0,tt[64]=tt[106]=1,et[64]=et[106]=0,D[64]=D[106]=-1,F[64]=F[106]=0,k[64]=k[106]=1,Q[2]=Q[168]=0,tt[2]=tt[168]=-1,et[2]=et[168]=1,nt[2]=nt[168]=0,rt[2]=rt[168]=-1,it[2]=it[168]=0,W[2]=W[168]=-1,H[2]=H[168]=0,K[2]=K[168]=0,J[2]=J[168]=-1,Z[2]=Z[168]=0,$[2]=$[168]=1,U[8]=U[162]=0,q[8]=q[162]=-1,z[8]=z[162]=0,V[8]=V[162]=0,Y[8]=Y[162]=-1,X[8]=X[162]=1,W[8]=W[162]=1,H[8]=H[162]=0,K[8]=K[162]=1,J[8]=J[162]=1,Z[8]=Z[162]=0,$[8]=$[162]=0,U[32]=U[138]=0,q[32]=q[138]=1,z[32]=z[138]=1,V[32]=V[138]=0,Y[32]=Y[138]=1,X[32]=X[138]=0,D[32]=D[138]=1,F[32]=F[138]=0,k[32]=k[138]=0,G[32]=G[138]=1,B[32]=B[138]=0,j[32]=j[138]=1,nt[128]=nt[42]=0,rt[128]=rt[42]=1,it[128]=it[42]=1,Q[128]=Q[42]=0,tt[128]=tt[42]=1,et[128]=et[42]=0,D[128]=D[42]=-1,F[128]=F[42]=0,k[128]=k[42]=1,G[128]=G[42]=-1,B[128]=B[42]=0,j[128]=j[42]=0,V[5]=V[165]=-1,Y[5]=Y[165]=0,X[5]=X[165]=0,nt[5]=nt[165]=1,rt[5]=rt[165]=0,it[5]=it[165]=0,J[20]=J[150]=0,Z[20]=Z[150]=1,$[20]=$[150]=1,G[20]=G[150]=0,B[20]=B[150]=-1,j[20]=j[150]=1,U[80]=U[90]=-1,q[80]=q[90]=0,z[80]=z[90]=1,Q[80]=Q[90]=1,tt[80]=tt[90]=0,et[80]=et[90]=1,W[65]=W[105]=0,H[65]=H[105]=1,K[65]=K[105]=0,D[65]=D[105]=0,F[65]=F[105]=-1,k[65]=k[105]=0,U[160]=U[10]=-1,q[160]=q[10]=0,z[160]=z[10]=1,V[160]=V[10]=-1,Y[160]=Y[10]=0,X[160]=X[10]=0,nt[160]=nt[10]=1,rt[160]=rt[10]=0,it[160]=it[10]=0,Q[160]=Q[10]=1,tt[160]=tt[10]=0,et[160]=et[10]=1,J[130]=J[40]=0,Z[130]=Z[40]=1,$[130]=$[40]=1,W[130]=W[40]=0,H[130]=H[40]=1,K[130]=K[40]=0,D[130]=D[40]=0,F[130]=F[40]=-1,k[130]=k[40]=0,G[130]=G[40]=0,B[130]=B[40]=-1,j[130]=j[40]=1,V[37]=V[133]=0,Y[37]=Y[133]=1,X[37]=X[133]=1,nt[37]=nt[133]=0,rt[37]=rt[133]=1,it[37]=it[133]=0,D[37]=D[133]=-1,F[37]=F[133]=0,k[37]=k[133]=0,G[37]=G[133]=1,B[37]=B[133]=0,j[37]=j[133]=0,J[148]=J[22]=-1,Z[148]=Z[22]=0,$[148]=$[22]=0,nt[148]=nt[22]=0,rt[148]=rt[22]=-1,it[148]=it[22]=1,Q[148]=Q[22]=0,tt[148]=tt[22]=1,et[148]=et[22]=1,G[148]=G[22]=-1,B[148]=B[22]=0,j[148]=j[22]=1,U[82]=U[88]=0,q[82]=q[88]=-1,z[82]=z[88]=1,J[82]=J[88]=1,Z[82]=Z[88]=0,$[82]=$[88]=1,W[82]=W[88]=-1,H[82]=H[88]=0,K[82]=K[88]=1,Q[82]=Q[88]=0,tt[82]=tt[88]=-1,et[82]=et[88]=0,U[73]=U[97]=0,q[73]=q[97]=1,z[73]=z[97]=0,V[73]=V[97]=0,Y[73]=Y[97]=-1,X[73]=X[97]=0,W[73]=W[97]=1,H[73]=H[97]=0,K[73]=K[97]=0,D[73]=D[97]=1,F[73]=F[97]=0,k[73]=k[97]=1,U[145]=U[25]=0,q[145]=q[25]=-1,z[145]=z[25]=0,W[145]=W[25]=1,H[145]=H[25]=0,K[145]=K[25]=1,nt[145]=nt[25]=0,rt[145]=rt[25]=1,it[145]=it[25]=1,G[145]=G[25]=-1,B[145]=B[25]=0,j[145]=j[25]=0,V[70]=V[100]=0,Y[70]=Y[100]=1,X[70]=X[100]=0,J[70]=J[100]=-1,Z[70]=Z[100]=0,$[70]=$[100]=1,Q[70]=Q[100]=0,tt[70]=tt[100]=-1,et[70]=et[100]=1,D[70]=D[100]=1,F[70]=F[100]=0,k[70]=k[100]=0,V[101]=V[69]=0,Y[101]=Y[69]=1,X[101]=X[69]=0,D[101]=D[69]=1,F[101]=F[69]=0,k[101]=k[69]=0,nt[149]=nt[21]=0,rt[149]=rt[21]=1,it[149]=it[21]=1,G[149]=G[21]=-1,B[149]=B[21]=0,j[149]=j[21]=0,J[86]=J[84]=-1,Z[86]=Z[84]=0,$[86]=$[84]=1,Q[86]=Q[84]=0,tt[86]=tt[84]=-1,et[86]=et[84]=1,U[89]=U[81]=0,q[89]=q[81]=-1,z[89]=z[81]=0,W[89]=W[81]=1,H[89]=H[81]=0,K[89]=K[81]=1,U[96]=U[74]=0,q[96]=q[74]=1,z[96]=z[74]=0,V[96]=V[74]=-1,Y[96]=Y[74]=0,X[96]=X[74]=1,Q[96]=Q[74]=1,tt[96]=tt[74]=0,et[96]=et[74]=0,D[96]=D[74]=1,F[96]=F[74]=0,k[96]=k[74]=1,U[24]=U[146]=0,q[24]=q[146]=-1,z[24]=z[146]=1,J[24]=J[146]=1,Z[24]=Z[146]=0,$[24]=$[146]=1,W[24]=W[146]=0,H[24]=H[146]=1,K[24]=K[146]=1,G[24]=G[146]=0,B[24]=B[146]=-1,j[24]=j[146]=0,V[6]=V[164]=-1,Y[6]=Y[164]=0,X[6]=X[164]=1,J[6]=J[164]=-1,Z[6]=Z[164]=0,$[6]=$[164]=0,nt[6]=nt[164]=0,rt[6]=rt[164]=-1,it[6]=it[164]=1,Q[6]=Q[164]=1,tt[6]=tt[164]=0,et[6]=et[164]=0,W[129]=W[41]=0,H[129]=H[41]=1,K[129]=K[41]=1,nt[129]=nt[41]=0,rt[129]=rt[41]=1,it[129]=it[41]=0,D[129]=D[41]=-1,F[129]=F[41]=0,k[129]=k[41]=0,G[129]=G[41]=0,B[129]=B[41]=-1,j[129]=j[41]=0,J[66]=J[104]=0,Z[66]=Z[104]=1,$[66]=$[104]=0,W[66]=W[104]=-1,H[66]=H[104]=0,K[66]=K[104]=1,Q[66]=Q[104]=0,tt[66]=tt[104]=-1,et[66]=et[104]=0,D[66]=D[104]=0,F[66]=F[104]=-1,k[66]=k[104]=1,U[144]=U[26]=-1,q[144]=q[26]=0,z[144]=z[26]=0,nt[144]=nt[26]=1,rt[144]=rt[26]=0,it[144]=it[26]=1,Q[144]=Q[26]=0,tt[144]=tt[26]=1,et[144]=et[26]=1,G[144]=G[26]=-1,B[144]=B[26]=0,j[144]=j[26]=1,V[36]=V[134]=0,Y[36]=Y[134]=1,X[36]=X[134]=1,J[36]=J[134]=0,Z[36]=Z[134]=1,$[36]=$[134]=0,D[36]=D[134]=0,F[36]=F[134]=-1,k[36]=k[134]=1,G[36]=G[134]=1,B[36]=B[134]=0,j[36]=j[134]=0,U[9]=U[161]=-1,q[9]=q[161]=0,z[9]=z[161]=0,V[9]=V[161]=0,Y[9]=Y[161]=-1,X[9]=X[161]=0,W[9]=W[161]=1,H[9]=H[161]=0,K[9]=K[161]=0,nt[9]=nt[161]=1,rt[9]=rt[161]=0,it[9]=it[161]=1,U[136]=0,q[136]=1,z[136]=1,V[136]=0,Y[136]=1,X[136]=0,J[136]=-1,Z[136]=0,$[136]=1,W[136]=-1,H[136]=0,K[136]=0,nt[136]=0,rt[136]=-1,it[136]=0,Q[136]=0,tt[136]=-1,et[136]=1,D[136]=1,F[136]=0,k[136]=0,G[136]=1,B[136]=0,j[136]=1,U[34]=0,q[34]=-1,z[34]=0,V[34]=0,Y[34]=-1,X[34]=1,J[34]=1,Z[34]=0,$[34]=0,W[34]=1,H[34]=0,K[34]=1,nt[34]=0,rt[34]=1,it[34]=1,Q[34]=0,tt[34]=1,et[34]=0,D[34]=-1,F[34]=0,k[34]=1,G[34]=-1,B[34]=0,j[34]=0,U[35]=0,q[35]=1,z[35]=1,V[35]=0,Y[35]=-1,X[35]=1,J[35]=1,Z[35]=0,$[35]=0,W[35]=-1,H[35]=0,K[35]=0,nt[35]=0,rt[35]=-1,it[35]=0,Q[35]=0,tt[35]=1,et[35]=0,D[35]=-1,F[35]=0,k[35]=1,G[35]=1,B[35]=0,j[35]=1,U[153]=0,q[153]=1,z[153]=1,W[153]=-1,H[153]=0,K[153]=0,nt[153]=0,rt[153]=-1,it[153]=0,G[153]=1,B[153]=0,j[153]=1,V[102]=0,Y[102]=-1,X[102]=1,J[102]=1,Z[102]=0,$[102]=0,Q[102]=0,tt[102]=1,et[102]=0,D[102]=-1,F[102]=0,k[102]=1,U[155]=0,q[155]=-1,z[155]=0,W[155]=1,H[155]=0,K[155]=1,nt[155]=0,rt[155]=1,it[155]=1,G[155]=-1,B[155]=0,j[155]=0,V[103]=0,Y[103]=1,X[103]=0,J[103]=-1,Z[103]=0,$[103]=1,Q[103]=0,tt[103]=-1,et[103]=1,D[103]=1,F[103]=0,k[103]=0,U[152]=0,q[152]=1,z[152]=1,J[152]=-1,Z[152]=0,$[152]=1,W[152]=-1,H[152]=0,K[152]=0,nt[152]=0,rt[152]=-1,it[152]=0,Q[152]=0,tt[152]=-1,et[152]=1,G[152]=1,B[152]=0,j[152]=1,U[156]=0,q[156]=-1,z[156]=1,J[156]=1,Z[156]=0,$[156]=1,W[156]=-1,H[156]=0,K[156]=0,nt[156]=0,rt[156]=-1,it[156]=0,Q[156]=0,tt[156]=1,et[156]=1,G[156]=-1,B[156]=0,j[156]=1,U[137]=0,q[137]=1,z[137]=1,V[137]=0,Y[137]=1,X[137]=0,W[137]=-1,H[137]=0,K[137]=0,nt[137]=0,rt[137]=-1,it[137]=0,D[137]=1,F[137]=0,k[137]=0,G[137]=1,B[137]=0,j[137]=1,U[139]=0,q[139]=1,z[139]=1,V[139]=0,Y[139]=-1,X[139]=0,W[139]=1,H[139]=0,K[139]=0,nt[139]=0,rt[139]=1,it[139]=0,D[139]=-1,F[139]=0,k[139]=0,G[139]=1,B[139]=0,j[139]=1,U[98]=0,q[98]=-1,z[98]=0,V[98]=0,Y[98]=-1,X[98]=1,J[98]=1,Z[98]=0,$[98]=0,W[98]=1,H[98]=0,K[98]=1,Q[98]=0,tt[98]=1,et[98]=0,D[98]=-1,F[98]=0,k[98]=1,U[99]=0,q[99]=1,z[99]=0,V[99]=0,Y[99]=-1,X[99]=1,J[99]=1,Z[99]=0,$[99]=0,W[99]=-1,H[99]=0,K[99]=1,Q[99]=0,tt[99]=-1,et[99]=0,D[99]=1,F[99]=0,k[99]=1,V[38]=0,Y[38]=-1,X[38]=1,J[38]=1,Z[38]=0,$[38]=0,nt[38]=0,rt[38]=1,it[38]=1,Q[38]=0,tt[38]=1,et[38]=0,D[38]=-1,F[38]=0,k[38]=1,G[38]=-1,B[38]=0,j[38]=0,V[39]=0,Y[39]=1,X[39]=1,J[39]=-1,Z[39]=0,$[39]=0,nt[39]=0,rt[39]=-1,it[39]=1,Q[39]=0,tt[39]=1,et[39]=0,D[39]=-1,F[39]=0,k[39]=1,G[39]=1,B[39]=0,j[39]=0;var ot=function(t){return[[t.bottomleft,0],[0,0],[0,t.leftbottom]]},st=function(t){return[[1,t.rightbottom],[1,0],[t.bottomright,0]]},at=function(t){return[[t.topright,1],[1,1],[1,t.righttop]]},ut=function(t){return[[0,t.lefttop],[0,1],[t.topleft,1]]},lt=function(t){return[[t.bottomright,0],[t.bottomleft,0],[0,t.leftbottom],[0,t.lefttop]]},ct=function(t){return[[t.bottomright,0],[t.bottomleft,0],[1,t.righttop],[1,t.rightbottom]]},ht=function(t){return[[1,t.righttop],[1,t.rightbottom],[t.topleft,1],[t.topright,1]]},pt=function(t){return[[0,t.leftbottom],[0,t.lefttop],[t.topleft,1],[t.topright,1]]},ft=[],gt=[],dt=[],yt=[],_t=[],mt=[],vt=[],xt=[];yt[1]=_t[1]=18,yt[169]=_t[169]=18,dt[4]=gt[4]=12,dt[166]=gt[166]=12,ft[16]=xt[16]=4,ft[154]=xt[154]=4,mt[64]=vt[64]=22,mt[106]=vt[106]=22,dt[2]=mt[2]=17,yt[2]=_t[2]=18,dt[168]=mt[168]=17,yt[168]=_t[168]=18,ft[8]=yt[8]=9,gt[8]=dt[8]=12,ft[162]=yt[162]=9,gt[162]=dt[162]=12,ft[32]=xt[32]=4,gt[32]=vt[32]=1,ft[138]=xt[138]=4,gt[138]=vt[138]=1,_t[128]=xt[128]=21,mt[128]=vt[128]=22,_t[42]=xt[42]=21,mt[42]=vt[42]=22,gt[5]=_t[5]=14,gt[165]=_t[165]=14,dt[20]=xt[20]=6,dt[150]=xt[150]=6,ft[80]=mt[80]=11,ft[90]=mt[90]=11,yt[65]=vt[65]=3,yt[105]=vt[105]=3,ft[160]=mt[160]=11,gt[160]=_t[160]=14,ft[10]=mt[10]=11,gt[10]=_t[10]=14,dt[130]=xt[130]=6,yt[130]=vt[130]=3,dt[40]=xt[40]=6,yt[40]=vt[40]=3,gt[101]=vt[101]=1,gt[69]=vt[69]=1,_t[149]=xt[149]=21,_t[21]=xt[21]=21,dt[86]=mt[86]=17,dt[84]=mt[84]=17,ft[89]=yt[89]=9,ft[81]=yt[81]=9,ft[96]=vt[96]=0,gt[96]=mt[96]=15,ft[74]=vt[74]=0,gt[74]=mt[74]=15,ft[24]=dt[24]=8,yt[24]=xt[24]=7,ft[146]=dt[146]=8,yt[146]=xt[146]=7,gt[6]=mt[6]=15,dt[6]=_t[6]=16,gt[164]=mt[164]=15,dt[164]=_t[164]=16,yt[129]=xt[129]=7,_t[129]=vt[129]=20,yt[41]=xt[41]=7,_t[41]=vt[41]=20,dt[66]=vt[66]=2,yt[66]=mt[66]=19,dt[104]=vt[104]=2,yt[104]=mt[104]=19,ft[144]=_t[144]=10,mt[144]=xt[144]=23,ft[26]=_t[26]=10,mt[26]=xt[26]=23,gt[36]=xt[36]=5,dt[36]=vt[36]=2,gt[134]=xt[134]=5,dt[134]=vt[134]=2,ft[9]=_t[9]=10,gt[9]=yt[9]=13,ft[161]=_t[161]=10,gt[161]=yt[161]=13,gt[37]=xt[37]=5,_t[37]=vt[37]=20,gt[133]=xt[133]=5,_t[133]=vt[133]=20,dt[148]=_t[148]=16,mt[148]=xt[148]=23,dt[22]=_t[22]=16,mt[22]=xt[22]=23,ft[82]=dt[82]=8,yt[82]=mt[82]=19,ft[88]=dt[88]=8,yt[88]=mt[88]=19,ft[73]=vt[73]=0,gt[73]=yt[73]=13,ft[97]=vt[97]=0,gt[97]=yt[97]=13,ft[145]=yt[145]=9,_t[145]=xt[145]=21,ft[25]=yt[25]=9,_t[25]=xt[25]=21,gt[70]=vt[70]=1,dt[70]=mt[70]=17,gt[100]=vt[100]=1,dt[100]=mt[100]=17,ft[34]=yt[34]=9,gt[34]=dt[34]=12,_t[34]=xt[34]=21,mt[34]=vt[34]=22,ft[136]=xt[136]=4,gt[136]=vt[136]=1,dt[136]=mt[136]=17,yt[136]=_t[136]=18,ft[35]=xt[35]=4,gt[35]=dt[35]=12,yt[35]=_t[35]=18,mt[35]=vt[35]=22,ft[153]=xt[153]=4,yt[153]=_t[153]=18,gt[102]=dt[102]=12,mt[102]=vt[102]=22,ft[155]=yt[155]=9,_t[155]=xt[155]=23,gt[103]=vt[103]=1,dt[103]=mt[103]=17,ft[152]=xt[152]=4,dt[152]=mt[152]=17,yt[152]=_t[152]=18,ft[156]=dt[156]=8,yt[156]=_t[156]=18,mt[156]=xt[156]=23,ft[137]=xt[137]=4,gt[137]=vt[137]=1,yt[137]=_t[137]=18,ft[139]=xt[139]=4,gt[139]=yt[139]=13,_t[139]=vt[139]=20,ft[98]=yt[98]=9,gt[98]=dt[98]=12,mt[98]=vt[98]=22,ft[99]=vt[99]=0,gt[99]=dt[99]=12,yt[99]=mt[99]=19,gt[38]=dt[38]=12,_t[38]=xt[38]=21,mt[38]=vt[38]=22,gt[39]=xt[39]=5,dt[39]=_t[39]=16,mt[39]=vt[39]=22;var bt=[];function Et(t,e,n){var r,i=e[0]-t[0],o=e[1]-t[1],s=n[0]-e[0];return((r=i*(n[1]-e[1])-s*o)>0)-(r<0)||+r}function It(t,e){return e.geometry.coordinates[0].every((function(e){return v(a(e),t)}))}bt[1]=bt[169]=ot,bt[4]=bt[166]=st,bt[16]=bt[154]=at,bt[64]=bt[106]=ut,bt[168]=bt[2]=lt,bt[162]=bt[8]=ct,bt[138]=bt[32]=ht,bt[42]=bt[128]=pt,bt[5]=bt[165]=function(t){return[[0,0],[0,t.leftbottom],[1,t.rightbottom],[1,0]]},bt[20]=bt[150]=function(t){return[[1,0],[t.bottomright,0],[t.topright,1],[1,1]]},bt[80]=bt[90]=function(t){return[[1,1],[1,t.righttop],[0,t.lefttop],[0,1]]},bt[65]=bt[105]=function(t){return[[t.bottomleft,0],[0,0],[0,1],[t.topleft,1]]},bt[160]=bt[10]=function(t){return[[1,t.righttop],[1,t.rightbottom],[0,t.leftbottom],[0,t.lefttop]]},bt[130]=bt[40]=function(t){return[[t.topleft,1],[t.topright,1],[t.bottomright,0],[t.bottomleft,0]]},bt[85]=function(){return[[0,0],[0,1],[1,1],[1,0]]},bt[101]=bt[69]=function(t){return[[1,t.rightbottom],[1,0],[0,0],[0,1],[t.topleft,1]]},bt[149]=bt[21]=function(t){return[[t.topright,1],[1,1],[1,0],[0,0],[0,t.leftbottom]]},bt[86]=bt[84]=function(t){return[[1,0],[t.bottomright,0],[0,t.lefttop],[0,1],[1,1]]},bt[89]=bt[81]=function(t){return[[1,1],[1,t.righttop],[t.bottomleft,0],[0,0],[0,1]]},bt[96]=bt[74]=function(t){return[[1,t.righttop],[1,t.rightbottom],[0,t.lefttop],[0,1],[t.topleft,1]]},bt[24]=bt[146]=function(t){return[[1,1],[1,t.righttop],[t.bottomright,0],[t.bottomleft,0],[t.topright,1]]},bt[6]=bt[164]=function(t){return[[1,t.rightbottom],[1,0],[t.bottomright,0],[0,t.leftbottom],[0,t.lefttop]]},bt[129]=bt[41]=function(t){return[[t.topright,1],[t.bottomleft,0],[0,0],[0,t.leftbottom],[t.topleft,1]]},bt[66]=bt[104]=function(t){return[[t.bottomright,0],[t.bottomleft,0],[0,t.lefttop],[0,1],[t.topleft,1]]},bt[144]=bt[26]=function(t){return[[1,1],[1,t.righttop],[0,t.leftbottom],[0,t.lefttop],[t.topright,1]]},bt[36]=bt[134]=function(t){return[[1,t.rightbottom],[1,0],[t.bottomright,0],[t.topleft,1],[t.topright,1]]},bt[9]=bt[161]=function(t){return[[1,t.righttop],[1,t.rightbottom],[t.bottomleft,0],[0,0],[0,t.leftbottom]]},bt[37]=bt[133]=function(t){return[[1,t.rightbottom],[1,0],[0,0],[0,t.leftbottom],[t.topleft,1],[t.topright,1]]},bt[148]=bt[22]=function(t){return[[1,1],[1,0],[t.bottomright,0],[0,t.leftbottom],[0,t.lefttop],[t.topright,1]]},bt[82]=bt[88]=function(t){return[[1,1],[1,t.righttop],[t.bottomright,0],[t.bottomleft,0],[0,t.lefttop],[0,1]]},bt[73]=bt[97]=function(t){return[[1,t.righttop],[1,t.rightbottom],[t.bottomleft,0],[0,0],[0,1],[t.topleft,1]]},bt[145]=bt[25]=function(t){return[[1,1],[1,t.righttop],[t.bottomleft,0],[0,0],[0,t.leftbottom],[t.topright,1]]},bt[70]=bt[100]=function(t){return[[1,t.rightbottom],[1,0],[t.bottomright,0],[0,t.lefttop],[0,1],[t.topleft,1]]},bt[34]=function(t){return[pt(t),ct(t)]},bt[35]=function(t){return[[1,t.righttop],[1,t.rightbottom],[t.bottomright,0],[t.bottomleft,0],[0,t.leftbottom],[0,t.lefttop],[t.topleft,1],[t.topright,1]]},bt[136]=function(t){return[ht(t),lt(t)]},bt[153]=function(t){return[at(t),ot(t)]},bt[102]=function(t){return[st(t),ut(t)]},bt[155]=function(t){return[[1,1],[1,t.righttop],[t.bottomleft,0],[0,0],[0,t.leftbottom],[t.topright,1]]},bt[103]=function(t){return[[1,t.rightbottom],[1,0],[t.bottomright,0],[0,t.lefttop],[0,1],[t.topleft,1]]},bt[152]=function(t){return[at(t),lt(t)]},bt[156]=function(t){return[[1,1],[1,t.righttop],[t.bottomright,0],[t.bottomleft,0],[0,t.leftbottom],[0,t.lefttop],[t.topright,1]]},bt[137]=function(t){return[ht(t),ot(t)]},bt[139]=function(t){return[[1,t.righttop],[1,t.rightbottom],[t.bottomleft,0],[0,0],[0,t.leftbottom],[t.topleft,1],[t.topright,1]]},bt[98]=function(t){return[ct(t),ut(t)]},bt[99]=function(t){return[[1,t.righttop],[1,t.rightbottom],[t.bottomright,0],[t.bottomleft,0],[0,t.lefttop],[0,1],[t.topleft,1]]},bt[38]=function(t){return[st(t),pt(t)]},bt[39]=function(t){return[[1,t.rightbottom],[1,0],[t.bottomright,0],[0,t.leftbottom],[0,t.lefttop],[t.topleft,1],[t.topright,1]]};const Ct=function(){function t(e){this.id=t.buildId(e),this.coordinates=e,this.innerEdges=[],this.outerEdges=[],this.outerEdgesSorted=!1}return t.buildId=function(t){return t.join(",")},t.prototype.removeInnerEdge=function(t){this.innerEdges=this.innerEdges.filter((function(e){return e.from.id!==t.from.id}))},t.prototype.removeOuterEdge=function(t){this.outerEdges=this.outerEdges.filter((function(e){return e.to.id!==t.to.id}))},t.prototype.addOuterEdge=function(t){this.outerEdges.push(t),this.outerEdgesSorted=!1},t.prototype.sortOuterEdges=function(){var t=this;this.outerEdgesSorted||(this.outerEdges.sort((function(e,n){var r=e.to,i=n.to;if(r.coordinates[0]-t.coordinates[0]>=0&&i.coordinates[0]-t.coordinates[0]<0)return 1;if(r.coordinates[0]-t.coordinates[0]<0&&i.coordinates[0]-t.coordinates[0]>=0)return-1;if(r.coordinates[0]-t.coordinates[0]==0&&i.coordinates[0]-t.coordinates[0]==0)return r.coordinates[1]-t.coordinates[1]>=0||i.coordinates[1]-t.coordinates[1]>=0?r.coordinates[1]-i.coordinates[1]:i.coordinates[1]-r.coordinates[1];var o=Et(t.coordinates,r.coordinates,i.coordinates);return o<0?1:o>0?-1:Math.pow(r.coordinates[0]-t.coordinates[0],2)+Math.pow(r.coordinates[1]-t.coordinates[1],2)-(Math.pow(i.coordinates[0]-t.coordinates[0],2)+Math.pow(i.coordinates[1]-t.coordinates[1],2))})),this.outerEdgesSorted=!0)},t.prototype.getOuterEdges=function(){return this.sortOuterEdges(),this.outerEdges},t.prototype.getOuterEdge=function(t){return this.sortOuterEdges(),this.outerEdges[t]},t.prototype.addInnerEdge=function(t){this.innerEdges.push(t)},t}(),St=function(){function t(t,e){this.from=t,this.to=e,this.next=void 0,this.label=void 0,this.symetric=void 0,this.ring=void 0,this.from.addOuterEdge(this),this.to.addInnerEdge(this)}return t.prototype.getSymetric=function(){return this.symetric||(this.symetric=new t(this.to,this.from),this.symetric.symetric=this),this.symetric},t.prototype.deleteEdge=function(){this.from.removeOuterEdge(this),this.to.removeInnerEdge(this)},t.prototype.isEqual=function(t){return this.from.id===t.from.id&&this.to.id===t.to.id},t.prototype.toString=function(){return"Edge { "+this.from.id+" -> "+this.to.id+" }"},t.prototype.toLineString=function(){return l([this.from.coordinates,this.to.coordinates])},t.prototype.compareTo=function(t){return Et(t.from.coordinates,t.to.coordinates,this.to.coordinates)},t}();var wt=function(){function t(){this.edges=[],this.polygon=void 0,this.envelope=void 0}return t.prototype.push=function(t){this.edges.push(t),this.polygon=this.envelope=void 0},t.prototype.get=function(t){return this.edges[t]},Object.defineProperty(t.prototype,"length",{get:function(){return this.edges.length},enumerable:!0,configurable:!0}),t.prototype.forEach=function(t){this.edges.forEach(t)},t.prototype.map=function(t){return this.edges.map(t)},t.prototype.some=function(t){return this.edges.some(t)},t.prototype.isValid=function(){return!0},t.prototype.isHole=function(){var t=this,e=this.edges.reduce((function(e,n,r){return n.from.coordinates[1]>t.edges[e].from.coordinates[1]&&(e=r),e}),0),n=(0===e?this.length:e)-1,r=(e+1)%this.length,i=Et(this.edges[n].from.coordinates,this.edges[e].from.coordinates,this.edges[r].from.coordinates);return 0===i?this.edges[n].from.coordinates[0]>this.edges[r].from.coordinates[0]:i>0},t.prototype.toMultiPoint=function(){return t=this.edges.map((function(t){return t.from.coordinates})),void 0===n&&(n={}),s({type:"MultiPoint",coordinates:t},e,n);var t,e,n},t.prototype.toPolygon=function(){if(this.polygon)return this.polygon;var t=this.edges.map((function(t){return t.from.coordinates}));return t.push(this.edges[0].from.coordinates),this.polygon=u([t])},t.prototype.getEnvelope=function(){return this.envelope?this.envelope:this.envelope=(t=this.toPolygon(),function(t,e){void 0===e&&(e={});var n=Number(t[0]),r=Number(t[1]),i=Number(t[2]),o=Number(t[3]);if(6===t.length)throw new Error("@turf/bbox-polygon does not support BBox with 6 positions");var s=[n,r];return u([[s,[i,r],[i,o],[n,o],s]],e.properties,{bbox:t,id:e.id})}(y(t)));var t},t.findEdgeRingContaining=function(t,e){var n,r,i=t.getEnvelope();return e.forEach((function(e){var o,s,u,l,c,h,p=e.getEnvelope();if(r&&(n=r.getEnvelope()),s=i,u=(o=p).geometry.coordinates[0].map((function(t){return t[0]})),l=o.geometry.coordinates[0].map((function(t){return t[1]})),c=s.geometry.coordinates[0].map((function(t){return t[0]})),h=s.geometry.coordinates[0].map((function(t){return t[1]})),(Math.max.apply(null,u)!==Math.max.apply(null,c)||Math.max.apply(null,l)!==Math.max.apply(null,h)||Math.min.apply(null,u)!==Math.min.apply(null,c)||Math.min.apply(null,l)!==Math.min.apply(null,h))&&It(p,i)){for(var f=t.map((function(t){return t.from.coordinates})),g=void 0,d=function(t){e.some((function(e){return n=t,r=e.from.coordinates,n[0]===r[0]&&n[1]===r[1];var n,r}))||(g=t)},y=0,_=f;y<_.length;y++)d(_[y]);g&&e.inside(a(g))&&(r&&!It(n,p)||(r=e))}})),r},t.prototype.inside=function(t){return v(t,this.toPolygon())},t}();const Nt=wt;function Mt(t){for(var e=t,n=[];e.parent;)n.unshift(e),e=e.parent;return n}!function(){function t(){this.edges=[],this.nodes={}}t.fromGeoJson=function(e){!function(t){if(!t)throw new Error("No geojson passed");if("FeatureCollection"!==t.type&&"GeometryCollection"!==t.type&&"MultiLineString"!==t.type&&"LineString"!==t.type&&"Feature"!==t.type)throw new Error("Invalid input type '"+t.type+"'. Geojson must be FeatureCollection, GeometryCollection, LineString, MultiLineString or Feature")}(e);var n=new t;return g(e,(function(t){var e,r,i;!function(t,e,n){if(!t)throw new Error("No feature passed");if(!t||"Feature"!==t.type||!t.geometry)throw new Error("Invalid input to "+n+", Feature with geometry required");if(!t.geometry||t.geometry.type!==e)throw new Error("Invalid input to "+n+": must be a "+e+", given "+t.geometry.type)}(t,"LineString","Graph::fromGeoJson"),e=function(t,e){if(t){var r=n.getNode(t),i=n.getNode(e);n.addEdge(r,i)}return e},i=r,p(t,(function(t,n,r,o,s){i=0===n?t:e(i,t)}),undefined)})),n},t.prototype.getNode=function(t){var e=Ct.buildId(t),n=this.nodes[e];return n||(n=this.nodes[e]=new Ct(t)),n},t.prototype.addEdge=function(t,e){var n=new St(t,e),r=n.getSymetric();this.edges.push(n),this.edges.push(r)},t.prototype.deleteDangles=function(){var t=this;Object.keys(this.nodes).map((function(e){return t.nodes[e]})).forEach((function(e){return t._removeIfDangle(e)}))},t.prototype._removeIfDangle=function(t){var e=this;if(t.innerEdges.length<=1){var n=t.getOuterEdges().map((function(t){return t.to}));this.removeNode(t),n.forEach((function(t){return e._removeIfDangle(t)}))}},t.prototype.deleteCutEdges=function(){var t=this;this._computeNextCWEdges(),this._findLabeledEdgeRings(),this.edges.forEach((function(e){e.label===e.symetric.label&&(t.removeEdge(e.symetric),t.removeEdge(e))}))},t.prototype._computeNextCWEdges=function(t){var e=this;void 0===t?Object.keys(this.nodes).forEach((function(t){return e._computeNextCWEdges(e.nodes[t])})):t.getOuterEdges().forEach((function(e,n){t.getOuterEdge((0===n?t.getOuterEdges().length:n)-1).symetric.next=e}))},t.prototype._computeNextCCWEdges=function(t,e){for(var n,r,i=t.getOuterEdges(),o=i.length-1;o>=0;--o){var s=i[o],a=s.symetric,u=void 0,l=void 0;s.label===e&&(u=s),a.label===e&&(l=a),u&&l&&(l&&(r=l),u&&(r&&(r.next=u,r=void 0),n||(n=u)))}r&&(r.next=n)},t.prototype._findLabeledEdgeRings=function(){var t=[],e=0;return this.edges.forEach((function(n){if(!(n.label>=0)){t.push(n);var r=n;do{r.label=e,r=r.next}while(!n.isEqual(r));e++}})),t},t.prototype.getEdgeRings=function(){var t=this;this._computeNextCWEdges(),this.edges.forEach((function(t){t.label=void 0})),this._findLabeledEdgeRings().forEach((function(e){t._findIntersectionNodes(e).forEach((function(n){t._computeNextCCWEdges(n,e.label)}))}));var e=[];return this.edges.forEach((function(n){n.ring||e.push(t._findEdgeRing(n))})),e},t.prototype._findIntersectionNodes=function(t){var e=[],n=t,r=function(){var r=0;n.from.getOuterEdges().forEach((function(e){e.label===t.label&&++r})),r>1&&e.push(n.from),n=n.next};do{r()}while(!t.isEqual(n));return e},t.prototype._findEdgeRing=function(t){var e=t,n=new Nt;do{n.push(e),e.ring=n,e=e.next}while(!t.isEqual(e));return n},t.prototype.removeNode=function(t){var e=this;t.getOuterEdges().forEach((function(t){return e.removeEdge(t)})),t.innerEdges.forEach((function(t){return e.removeEdge(t)})),delete this.nodes[t.id]},t.prototype.removeEdge=function(t){this.edges=this.edges.filter((function(e){return!e.isEqual(t)})),t.deleteEdge()}}(),n(9657),n(2606),n(1160);var Lt={search:function(t,e,n,r){t.cleanDirty();var i=(r=r||{}).heuristic||Lt.heuristics.manhattan,o=r.closest||!1,s=new Rt((function(t){return t.f})),a=e;for(e.h=i(e,n),s.push(e);s.size()>0;){var u=s.pop();if(u===n)return Mt(u);u.closed=!0;for(var l=t.neighbors(u),c=0,h=l.length;c<h;++c){var p=l[c];if(!p.closed&&!p.isWall()){var f=u.g+p.getCost(u),g=p.visited;(!g||f<p.g)&&(p.visited=!0,p.parent=u,p.h=p.h||i(p,n),p.g=f,p.f=p.g+p.h,t.markDirty(p),o&&(p.h<a.h||p.h===a.h&&p.g<a.g)&&(a=p),g?s.rescoreElement(p):s.push(p))}}}return o?Mt(a):[]},heuristics:{manhattan:function(t,e){return Math.abs(e.x-t.x)+Math.abs(e.y-t.y)},diagonal:function(t,e){var n=Math.sqrt(2),r=Math.abs(e.x-t.x),i=Math.abs(e.y-t.y);return 1*(r+i)+(n-2)*Math.min(r,i)}},cleanNode:function(t){t.f=0,t.g=0,t.h=0,t.visited=!1,t.closed=!1,t.parent=null}};function Pt(t,e){e=e||{},this.nodes=[],this.diagonal=!!e.diagonal,this.grid=[];for(var n=0;n<t.length;n++){this.grid[n]=[];for(var r=0,i=t[n];r<i.length;r++){var o=new Ot(n,r,i[r]);this.grid[n][r]=o,this.nodes.push(o)}}this.init()}function Ot(t,e,n){this.x=t,this.y=e,this.weight=n}function Rt(t){this.content=[],this.scoreFunction=t}function Tt(){this._=null}function At(t){t.U=t.C=t.L=t.R=t.P=t.N=null}function Dt(t,e){var n=e,r=e.R,i=n.U;i?i.L===n?i.L=r:i.R=r:t._=r,r.U=i,n.U=r,n.R=r.L,n.R&&(n.R.U=n),r.L=n}function Ft(t,e){var n=e,r=e.L,i=n.U;i?i.L===n?i.L=r:i.R=r:t._=r,r.U=i,n.U=r,n.L=r.R,n.L&&(n.L.U=n),r.R=n}function kt(t){for(;t.L;)t=t.L;return t}Pt.prototype.init=function(){this.dirtyNodes=[];for(var t=0;t<this.nodes.length;t++)Lt.cleanNode(this.nodes[t])},Pt.prototype.cleanDirty=function(){for(var t=0;t<this.dirtyNodes.length;t++)Lt.cleanNode(this.dirtyNodes[t]);this.dirtyNodes=[]},Pt.prototype.markDirty=function(t){this.dirtyNodes.push(t)},Pt.prototype.neighbors=function(t){var e=[],n=t.x,r=t.y,i=this.grid;return i[n-1]&&i[n-1][r]&&e.push(i[n-1][r]),i[n+1]&&i[n+1][r]&&e.push(i[n+1][r]),i[n]&&i[n][r-1]&&e.push(i[n][r-1]),i[n]&&i[n][r+1]&&e.push(i[n][r+1]),this.diagonal&&(i[n-1]&&i[n-1][r-1]&&e.push(i[n-1][r-1]),i[n+1]&&i[n+1][r-1]&&e.push(i[n+1][r-1]),i[n-1]&&i[n-1][r+1]&&e.push(i[n-1][r+1]),i[n+1]&&i[n+1][r+1]&&e.push(i[n+1][r+1])),e},Pt.prototype.toString=function(){for(var t,e,n,r,i=[],o=this.grid,s=0,a=o.length;s<a;s++){for(t=[],n=0,r=(e=o[s]).length;n<r;n++)t.push(e[n].weight);i.push(t.join(" "))}return i.join("\n")},Ot.prototype.toString=function(){return"["+this.x+" "+this.y+"]"},Ot.prototype.getCost=function(t){return t&&t.x!==this.x&&t.y!==this.y?1.41421*this.weight:this.weight},Ot.prototype.isWall=function(){return 0===this.weight},Rt.prototype={push:function(t){this.content.push(t),this.sinkDown(this.content.length-1)},pop:function(){var t=this.content[0],e=this.content.pop();return this.content.length>0&&(this.content[0]=e,this.bubbleUp(0)),t},remove:function(t){var e=this.content.indexOf(t),n=this.content.pop();e!==this.content.length-1&&(this.content[e]=n,this.scoreFunction(n)<this.scoreFunction(t)?this.sinkDown(e):this.bubbleUp(e))},size:function(){return this.content.length},rescoreElement:function(t){this.sinkDown(this.content.indexOf(t))},sinkDown:function(t){for(var e=this.content[t];t>0;){var n=(t+1>>1)-1,r=this.content[n];if(!(this.scoreFunction(e)<this.scoreFunction(r)))break;this.content[n]=e,this.content[t]=r,t=n}},bubbleUp:function(t){for(var e=this.content.length,n=this.content[t],r=this.scoreFunction(n);;){var i,o=t+1<<1,s=o-1,a=null;if(s<e){var u=this.content[s];(i=this.scoreFunction(u))<r&&(a=s)}if(o<e){var l=this.content[o];this.scoreFunction(l)<(null===a?r:i)&&(a=o)}if(null===a)break;this.content[t]=this.content[a],this.content[a]=n,t=a}}},Tt.prototype={constructor:Tt,insert:function(t,e){var n,r,i;if(t){if(e.P=t,e.N=t.N,t.N&&(t.N.P=e),t.N=e,t.R){for(t=t.R;t.L;)t=t.L;t.L=e}else t.R=e;n=t}else this._?(t=kt(this._),e.P=null,e.N=t,t.P=t.L=e,n=t):(e.P=e.N=null,this._=e,n=null);for(e.L=e.R=null,e.U=n,e.C=!0,t=e;n&&n.C;)n===(r=n.U).L?(i=r.R)&&i.C?(n.C=i.C=!1,r.C=!0,t=r):(t===n.R&&(Dt(this,n),n=(t=n).U),n.C=!1,r.C=!0,Ft(this,r)):(i=r.L)&&i.C?(n.C=i.C=!1,r.C=!0,t=r):(t===n.L&&(Ft(this,n),n=(t=n).U),n.C=!1,r.C=!0,Dt(this,r)),n=t.U;this._.C=!1},remove:function(t){t.N&&(t.N.P=t.P),t.P&&(t.P.N=t.N),t.N=t.P=null;var e,n,r,i=t.U,o=t.L,s=t.R;if(n=o?s?kt(s):o:s,i?i.L===t?i.L=n:i.R=n:this._=n,o&&s?(r=n.C,n.C=t.C,n.L=o,o.U=n,n!==s?(i=n.U,n.U=t.U,t=n.R,i.L=t,n.R=s,s.U=n):(n.U=i,i=n,t=n.R)):(r=t.C,t=n),t&&(t.U=i),!r)if(t&&t.C)t.C=!1;else{do{if(t===this._)break;if(t===i.L){if((e=i.R).C&&(e.C=!1,i.C=!0,Dt(this,i),e=i.R),e.L&&e.L.C||e.R&&e.R.C){e.R&&e.R.C||(e.L.C=!1,e.C=!0,Ft(this,e),e=i.R),e.C=i.C,i.C=e.R.C=!1,Dt(this,i),t=this._;break}}else if((e=i.L).C&&(e.C=!1,i.C=!0,Ft(this,i),e=i.L),e.L&&e.L.C||e.R&&e.R.C){e.L&&e.L.C||(e.R.C=!1,e.C=!0,Dt(this,e),e=i.L),e.C=i.C,i.C=e.L.C=!1,Ft(this,i),t=this._;break}e.C=!0,t=i,i=i.U}while(!t.C);t&&(t.C=!1)}}};const Gt=Tt;function Bt(t,e,n,r){var i=[null,null],o=le.push(i)-1;return i.left=t,i.right=e,n&&Ut(i,t,e,n),r&&Ut(i,e,t,r),ae[t.index].halfedges.push(o),ae[e.index].halfedges.push(o),i}function jt(t,e,n){var r=[e,n];return r.left=t,r}function Ut(t,e,n,r){t[0]||t[1]?t.left===n?t[1]=r:t[0]=r:(t[0]=r,t.left=e,t.right=n)}function qt(t,e,n,r,i){var o,s=t[0],a=t[1],u=s[0],l=s[1],c=0,h=1,p=a[0]-u,f=a[1]-l;if(o=e-u,p||!(o>0)){if(o/=p,p<0){if(o<c)return;o<h&&(h=o)}else if(p>0){if(o>h)return;o>c&&(c=o)}if(o=r-u,p||!(o<0)){if(o/=p,p<0){if(o>h)return;o>c&&(c=o)}else if(p>0){if(o<c)return;o<h&&(h=o)}if(o=n-l,f||!(o>0)){if(o/=f,f<0){if(o<c)return;o<h&&(h=o)}else if(f>0){if(o>h)return;o>c&&(c=o)}if(o=i-l,f||!(o<0)){if(o/=f,f<0){if(o>h)return;o>c&&(c=o)}else if(f>0){if(o<c)return;o<h&&(h=o)}return!(c>0||h<1)||(c>0&&(t[0]=[u+c*p,l+c*f]),h<1&&(t[1]=[u+h*p,l+h*f]),!0)}}}}}function zt(t,e,n,r,i){var o=t[1];if(o)return!0;var s,a,u=t[0],l=t.left,c=t.right,h=l[0],p=l[1],f=c[0],g=c[1],d=(h+f)/2,y=(p+g)/2;if(g===p){if(d<e||d>=r)return;if(h>f){if(u){if(u[1]>=i)return}else u=[d,n];o=[d,i]}else{if(u){if(u[1]<n)return}else u=[d,i];o=[d,n]}}else if(a=y-(s=(h-f)/(g-p))*d,s<-1||s>1)if(h>f){if(u){if(u[1]>=i)return}else u=[(n-a)/s,n];o=[(i-a)/s,i]}else{if(u){if(u[1]<n)return}else u=[(i-a)/s,i];o=[(n-a)/s,n]}else if(p<g){if(u){if(u[0]>=r)return}else u=[e,s*e+a];o=[r,s*r+a]}else{if(u){if(u[0]<e)return}else u=[r,s*r+a];o=[e,s*e+a]}return t[0]=u,t[1]=o,!0}function Vt(t,e){var n=t.site,r=e.left,i=e.right;return n===i&&(i=r,r=n),i?Math.atan2(i[1]-r[1],i[0]-r[0]):(n===r?(r=e[1],i=e[0]):(r=e[0],i=e[1]),Math.atan2(r[0]-i[0],i[1]-r[1]))}function Yt(t,e){return e[+(e.left!==t.site)]}function Xt(t,e){return e[+(e.left===t.site)]}var Wt,Ht=[];function Kt(){At(this),this.x=this.y=this.arc=this.site=this.cy=null}function Jt(t){var e=t.P,n=t.N;if(e&&n){var r=e.site,i=t.site,o=n.site;if(r!==o){var s=i[0],a=i[1],u=r[0]-s,l=r[1]-a,c=o[0]-s,h=o[1]-a,p=2*(u*h-l*c);if(!(p>=-he)){var f=u*u+l*l,g=c*c+h*h,d=(h*f-l*g)/p,y=(u*g-c*f)/p,_=Ht.pop()||new Kt;_.arc=t,_.site=i,_.x=d+s,_.y=(_.cy=y+a)+Math.sqrt(d*d+y*y),t.circle=_;for(var m=null,v=ue._;v;)if(_.y<v.y||_.y===v.y&&_.x<=v.x){if(!v.L){m=v.P;break}v=v.L}else{if(!v.R){m=v;break}v=v.R}ue.insert(m,_),m||(Wt=_)}}}}function Zt(t){var e=t.circle;e&&(e.P||(Wt=e.N),ue.remove(e),Ht.push(e),At(e),t.circle=null)}var $t=[];function Qt(){At(this),this.edge=this.site=this.circle=null}function te(t){var e=$t.pop()||new Qt;return e.site=t,e}function ee(t){Zt(t),se.remove(t),$t.push(t),At(t)}function ne(t){var e=t.circle,n=e.x,r=e.cy,i=[n,r],o=t.P,s=t.N,a=[t];ee(t);for(var u=o;u.circle&&Math.abs(n-u.circle.x)<ce&&Math.abs(r-u.circle.cy)<ce;)o=u.P,a.unshift(u),ee(u),u=o;a.unshift(u),Zt(u);for(var l=s;l.circle&&Math.abs(n-l.circle.x)<ce&&Math.abs(r-l.circle.cy)<ce;)s=l.N,a.push(l),ee(l),l=s;a.push(l),Zt(l);var c,h=a.length;for(c=1;c<h;++c)l=a[c],u=a[c-1],Ut(l.edge,u.site,l.site,i);u=a[0],(l=a[h-1]).edge=Bt(u.site,l.site,null,i),Jt(u),Jt(l)}function re(t){for(var e,n,r,i,o=t[0],s=t[1],a=se._;a;)if((r=ie(a,s)-o)>ce)a=a.L;else{if(!((i=o-oe(a,s))>ce)){r>-ce?(e=a.P,n=a):i>-ce?(e=a,n=a.N):e=n=a;break}if(!a.R){e=a;break}a=a.R}!function(t){ae[t.index]={site:t,halfedges:[]}}(t);var u=te(t);if(se.insert(e,u),e||n){if(e===n)return Zt(e),n=te(e.site),se.insert(u,n),u.edge=n.edge=Bt(e.site,u.site),Jt(e),void Jt(n);if(n){Zt(e),Zt(n);var l=e.site,c=l[0],h=l[1],p=t[0]-c,f=t[1]-h,g=n.site,d=g[0]-c,y=g[1]-h,_=2*(p*y-f*d),m=p*p+f*f,v=d*d+y*y,x=[(y*m-f*v)/_+c,(p*v-d*m)/_+h];Ut(n.edge,l,g,x),u.edge=Bt(l,t,null,x),n.edge=Bt(t,g,null,x),Jt(e),Jt(n)}else u.edge=Bt(e.site,u.site)}}function ie(t,e){var n=t.site,r=n[0],i=n[1],o=i-e;if(!o)return r;var s=t.P;if(!s)return-1/0;var a=(n=s.site)[0],u=n[1],l=u-e;if(!l)return a;var c=a-r,h=1/o-1/l,p=c/l;return h?(-p+Math.sqrt(p*p-2*h*(c*c/(-2*l)-u+l/2+i-o/2)))/h+r:(r+a)/2}function oe(t,e){var n=t.N;if(n)return ie(n,e);var r=t.site;return r[1]===e?r[0]:1/0}var se,ae,ue,le,ce=1e-6,he=1e-12;function pe(t,e){return e[1]-t[1]||e[0]-t[0]}function fe(t,e){var n,r,i,o=t.sort(pe).pop();for(le=[],ae=new Array(t.length),se=new Gt,ue=new Gt;;)if(i=Wt,o&&(!i||o[1]<i.y||o[1]===i.y&&o[0]<i.x))o[0]===n&&o[1]===r||(re(o),n=o[0],r=o[1]),o=t.pop();else{if(!i)break;ne(i.arc)}if(function(){for(var t,e,n,r,i=0,o=ae.length;i<o;++i)if((t=ae[i])&&(r=(e=t.halfedges).length)){var s=new Array(r),a=new Array(r);for(n=0;n<r;++n)s[n]=n,a[n]=Vt(t,le[e[n]]);for(s.sort((function(t,e){return a[e]-a[t]})),n=0;n<r;++n)a[n]=e[s[n]];for(n=0;n<r;++n)e[n]=a[n]}}(),e){var s=+e[0][0],a=+e[0][1],u=+e[1][0],l=+e[1][1];!function(t,e,n,r){for(var i,o=le.length;o--;)zt(i=le[o],t,e,n,r)&&qt(i,t,e,n,r)&&(Math.abs(i[0][0]-i[1][0])>ce||Math.abs(i[0][1]-i[1][1])>ce)||delete le[o]}(s,a,u,l),function(t,e,n,r){var i,o,s,a,u,l,c,h,p,f,g,d,y=ae.length,_=!0;for(i=0;i<y;++i)if(o=ae[i]){for(s=o.site,a=(u=o.halfedges).length;a--;)le[u[a]]||u.splice(a,1);for(a=0,l=u.length;a<l;)g=(f=Xt(o,le[u[a]]))[0],d=f[1],h=(c=Yt(o,le[u[++a%l]]))[0],p=c[1],(Math.abs(g-h)>ce||Math.abs(d-p)>ce)&&(u.splice(a,0,le.push(jt(s,f,Math.abs(g-t)<ce&&r-d>ce?[t,Math.abs(h-t)<ce?p:r]:Math.abs(d-r)<ce&&n-g>ce?[Math.abs(p-r)<ce?h:n,r]:Math.abs(g-n)<ce&&d-e>ce?[n,Math.abs(h-n)<ce?p:e]:Math.abs(d-e)<ce&&g-t>ce?[Math.abs(p-e)<ce?h:t,e]:null))-1),++l);l&&(_=!1)}if(_){var m,v,x,b=1/0;for(i=0,_=null;i<y;++i)(o=ae[i])&&(x=(m=(s=o.site)[0]-t)*m+(v=s[1]-e)*v)<b&&(b=x,_=o);if(_){var E=[t,e],I=[t,r],C=[n,r],S=[n,e];_.halfedges.push(le.push(jt(s=_.site,E,I))-1,le.push(jt(s,I,C))-1,le.push(jt(s,C,S))-1,le.push(jt(s,S,E))-1)}}for(i=0;i<y;++i)(o=ae[i])&&(o.halfedges.length||delete ae[i])}(s,a,u,l)}this.edges=le,this.cells=ae,se=ue=le=ae=null}function ge(){return new de}function de(){this.reset()}fe.prototype={constructor:fe,polygons:function(){var t=this.edges;return this.cells.map((function(e){var n=e.halfedges.map((function(n){return Yt(e,t[n])}));return n.data=e.site.data,n}))},triangles:function(){var t=[],e=this.edges;return this.cells.forEach((function(n,r){if(o=(i=n.halfedges).length)for(var i,o,s,a,u,l,c=n.site,h=-1,p=e[i[o-1]],f=p.left===c?p.right:p.left;++h<o;)s=f,f=(p=e[i[h]]).left===c?p.right:p.left,s&&f&&r<s.index&&r<f.index&&(u=s,l=f,((a=c)[0]-l[0])*(u[1]-a[1])-(a[0]-u[0])*(l[1]-a[1])<0)&&t.push([c.data,s.data,f.data])})),t},links:function(){return this.edges.filter((function(t){return t.right})).map((function(t){return{source:t.left.data,target:t.right.data}}))},find:function(t,e,n){for(var r,i,o=this,s=o._found||0,a=o.cells.length;!(i=o.cells[s]);)if(++s>=a)return null;var u=t-i.site[0],l=e-i.site[1],c=u*u+l*l;do{i=o.cells[r=s],s=null,i.halfedges.forEach((function(n){var r=o.edges[n],a=r.left;if(a!==i.site&&a||(a=r.right)){var u=t-a[0],l=e-a[1],h=u*u+l*l;h<c&&(c=h,s=a.index)}}))}while(null!==s);return o._found=r,null==n||c<=n*n?i.site:null}},n(2676),n(675),de.prototype={constructor:de,reset:function(){this.s=this.t=0},add:function(t){_e(ye,t,this.t),_e(this,ye.s,this.s),this.s?this.t+=ye.t:this.s=ye.t},valueOf:function(){return this.s}};var ye=new de;function _e(t,e,n){var r=t.s=e+n,i=r-e,o=r-i;t.t=e-o+(n-i)}var me,ve,xe=Math.PI,be=xe/2,Ee=2*xe,Ie=xe/180,Ce=(Math.abs,Math.atan),Se=Math.atan2,we=Math.cos,Ne=(Math.ceil,Math.exp,Math.floor,Math.log,Math.pow,Math.sin),Me=(Math.sign,Math.sqrt);Math.tan;function Le(t){return t>1?be:t<-1?-be:Math.asin(t)}function Pe(t,e){return[t>xe?t-Ee:t<-xe?t+Ee:t,e]}function Oe(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}ge(),ge(),ge(),Pe.invert=Pe,1===(me=Oe).length&&(ve=me,me=function(t,e){return Oe(ve(t),e)});var Re=Array.prototype;Re.slice,Re.map,Math.sqrt(50),Math.sqrt(10),Math.sqrt(2);ge();function Te(){}function Ae(t){return function(e,n){var r=we(e),i=we(n),o=t(r*i);return[o*i*Ne(e),o*Ne(n)]}}function De(t){return function(e,n){var r=Me(e*e+n*n),i=t(r),o=Ne(i),s=we(i);return[Se(e*o,r*s),Le(r&&n*o/r)]}}function Fe(t,e){return[t,e]}ge(),ge(),ge(),ge(),Te.prototype={constructor:Te,point:function(t,e){this.stream.point(t,e)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}},we(30*Ie),Ae((function(t){return Me(2/(1+t))})).invert=De((function(t){return 2*Le(t/2)})),Ae((function(t){return(t=(e=t)>1?0:e<-1?xe:Math.acos(e))&&t/Ne(t);var e})).invert=De((function(t){return t})),Fe.invert=Fe,De(Ce),De(Le),De((function(t){return 2*Ce(t)}));var ke=n(3381);const Ge="source-draw-labels",Be="layer-draw-labels",je={type:"FeatureCollection",features:[]};class Ue{constructor(t){this.options=t,this._measureConverter=ke(),this._drawCtrl=new(e())({displayControlsDefault:!1,styles:[{id:"gl-draw-line",type:"line",filter:["all",["==","$type","LineString"],["!=","mode","static"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":this.options?.style?.lengthMeasurement?.lineColor??"#D20C0C","line-dasharray":[.2,2],"line-width":this.options?.style?.lengthMeasurement?.lineWidth??2}},{id:"gl-draw-polygon-fill",type:"fill",filter:["all",["==","$type","Polygon"],["!=","mode","static"]],paint:{"fill-color":this.options?.style?.areaMeasurement?.fillColor??"#D20C0C","fill-outline-color":this.options?.style?.areaMeasurement?.fillOutlineColor??"#D20C0C","fill-opacity":this.options?.style?.areaMeasurement?.fillOpacity??.1}},{id:"gl-draw-polygon-midpoint",type:"circle",filter:["all",["==","$type","Point"],["==","meta","midpoint"]],paint:{"circle-radius":this.options?.style?.common?.midPointRadius??3,"circle-color":this.options?.style?.common?.midPointColor??"#fbb03b"}},{id:"gl-draw-polygon-stroke-active",type:"line",filter:["all",["==","$type","Polygon"],["!=","mode","static"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":this.options?.style?.areaMeasurement?.fillOutlineColor??"#D20C0C","line-dasharray":[.2,2],"line-width":this.options?.style?.areaMeasurement?.lineWidth??2}},{id:"gl-draw-polygon-and-line-vertex-halo-active",type:"circle",filter:["all",["==","meta","vertex"],["==","$type","Point"],["!=","mode","static"]],paint:{"circle-radius":this.options?.style?.common?.midPointHaloRadius??3,"circle-color":this.options?.style?.common?.midPointHaloColor??"#FFF"}},{id:"gl-draw-polygon-and-line-vertex-active",type:"circle",filter:["all",["==","meta","vertex"],["==","$type","Point"],["!=","mode","static"]],paint:{"circle-radius":this.options?.style?.common?.midPointRadius??3,"circle-color":this.options?.style?.common?.midPointColor??"#fbb03b"}},{id:"gl-draw-line-static",type:"line",filter:["all",["==","$type","LineString"],["==","mode","static"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":this.options?.style?.lengthMeasurement?.lineColor??"#D20C0C","line-width":this.options?.style?.lengthMeasurement?.lineWidth??3}},{id:"gl-draw-polygon-fill-static",type:"fill",filter:["all",["==","$type","Polygon"],["==","mode","static"]],paint:{"fill-color":this.options?.style?.areaMeasurement?.fillColor??"#000","fill-outline-color":this.options?.style?.areaMeasurement?.fillOutlineColor??"#000","fill-opacity":this.options?.style?.areaMeasurement?.fillOpacity??.1}},{id:"gl-draw-polygon-stroke-static",type:"line",filter:["all",["==","$type","Polygon"],["==","mode","static"]],layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":this.options?.style?.areaMeasurement?.fillOutlineColor??"#000","line-width":this.options?.style?.areaMeasurement?.lineWidth??2}}]})}onAdd(t){return this._map=t,this._map.addControl(this._drawCtrl,"top-left"),this._initControl(),this._registerEvents(),this._container}_initControl(){this._container=document.createElement("div"),this._container.className="maplibregl-ctrl mapboxgl-ctrl maplibregl-measures maplibregl-ctrl-group mapboxgl-ctrl-group",this.initDrawBtn(this._drawCtrl.modes.DRAW_LINE_STRING),this.initDrawBtn(this._drawCtrl.modes.DRAW_POLYGON),this.initClearBtn()}_formatMeasure(t,e=!1){return"imperial"==this.options?.units?e?this._formatAreaToImperialSystem(t):this._formatToImperialSystem(t):e?this._formatAreaToMetricSystem(t):this._formatToMetricSystem(t)}_formatAreaToMetricSystem(t){let e=ke(t).from("m2").toBest({system:"metric"}),n=e.unit.replaceAll("2","²");return`${e.val.toFixed(2)} ${n}`}_formatAreaToImperialSystem(t){let e=ke(t).from("m2").to("mi2");e=ke(e).from("mi2").toBest({system:"imperial"});let n=e.unit.replaceAll("2","²");return`${e.val.toFixed(2)} ${n}`}_formatToMetricSystem(t){let e=ke(t).from("m").toBest({system:"metric"});return`${e.val.toFixed(2)} ${e.unit}`}_formatToImperialSystem(t){let e=ke(t).from("m").to("mi");return e=ke(e).from("mi").toBest({system:"imperial"}),`${e.val.toFixed(2)} ${e.unit}`}initDrawBtn(t){let e=document.createElement("button");switch(e.type="button",t){case this._drawCtrl.modes.DRAW_LINE_STRING:e.title=this.options?.lang?.lengthMeasurementButtonTitle??"",e.innerHTML=lineIcon;break;case this._drawCtrl.modes.DRAW_POLYGON:e.title=this.options?.lang?.areaMeasurementButtonTitle??"",e.innerHTML=polygonIcon}e.addEventListener("click",(()=>{this._drawCtrl.changeMode(t)})),this._container.appendChild(e)}initClearBtn(){let t=document.createElement("button");t.type="button",t.title=this.options?.lang?.clearMeasurementsButtonTitle??"",t.innerHTML=eraseIcon,t.addEventListener("click",(()=>{this._drawCtrl.deleteAll(),this._updateLabels()})),this._container.appendChild(t)}_registerEvents(){this._map&&(this._map.on("load",(()=>{this._map.addSource(Ge,{type:"geojson",data:je}),this._map.addLayer({id:Be,type:"symbol",source:Ge,layout:{"text-font":["Open Sans Semibold"],"text-field":["get","measurement"],"text-variable-anchor":["top","bottom","left","right"],"text-radial-offset":this.options?.style?.text?.radialOffset??.5,"text-justify":"auto","text-letter-spacing":this.options?.style?.text?.letterSpacing??.05,"text-size":["interpolate",["linear"],["zoom"],5,0,10,10,13,12,14,14,18,16]},paint:{"text-color":this.options?.style?.text?.color??"#D20C0C","text-halo-color":this.options?.style?.text?.haloColor??"#fff","text-halo-width":this.options?.style?.text?.haloWidth??10}})})),this._map.on("draw.create",this._updateLabels.bind(this)),this._map.on("draw.update",this._updateLabels.bind(this)),this._map.on("draw.delete",this._updateLabels.bind(this)),this._map.on("draw.render",this._updateLabels.bind(this)))}_updateLabels(){let t=this._map.getSource(Ge),e=[];this._drawCtrl.getAll().features.forEach((t=>{try{if("Polygon"==t.geometry.type){let n=this._formatMeasure(S(t),!0),r=I(t),i=`${n}`;r.properties={measurement:i},e.push(r)}else"LineString"==t.geometry.type&&function(t){if(!t)throw new Error("geojson is required");var e=[];return g(t,(function(t){!function(t,e){var n=[],r=t.geometry;if(null!==r){switch(r.type){case"Polygon":n=m(r);break;case"LineString":n=[m(r)]}n.forEach((function(n){var r=function(t,e){var n=[];return t.reduce((function(t,r){var i,o,s,a,u,c,h=l([t,r],e);return h.bbox=(o=r,s=(i=t)[0],a=i[1],[s<(u=o[0])?s:u,a<(c=o[1])?a:c,s>u?s:u,a>c?a:c]),n.push(h),r})),n}(n,t.properties);r.forEach((function(t){t.id=e.length,e.push(t)}))}))}}(t,e)})),function(t,e){void 0===e&&(e={});var n={type:"FeatureCollection"};return e.id&&(n.id=e.id),e.bbox&&(n.bbox=e.bbox),n.features=t,n}(e)}(t).features.forEach((t=>{let n=I(t),r=this._formatMeasure(1e3*(void 0===u&&(u={}),i=function(t,e){var n=e.geometry.coordinates;return t+b(n[0],n[1],u)},s=o=0,a=!1,function(t,e){g(t,(function(t,n,r){var i=0;if(t.geometry){var o=t.geometry.type;if("Point"!==o&&"MultiPoint"!==o){var s,a=0,u=0,c=0;return!1!==p(t,(function(o,h,p,f,g){if(void 0===s||n>a||f>u||g>c)return s=o,a=n,u=f,c=g,void(i=0);var d=l([s,o],t.properties);if(!1===e(d,n,r,g,i))return!1;i++,s=o}))&&void 0}}}))}(t,(function(t,e,n,r,u){s=!1===a&&void 0===o?t:i(s,t,e,n,r,u),a=!0})),s));var i,o,s,a,u;let c=`${r}`;n.properties={measurement:c},e.push(n)}))}catch(t){}}));let n={type:"FeatureCollection",features:e};t.setData(n)}onRemove(){this._container.parentNode.removeChild(this._container),this._map.removeLayer(Be),this._map=void 0}}})(),maplibreGLMeasures=r})();
//# sourceMappingURL=maplibre-gl-measures.js.map