<img src="readme_imgs/logo2.svg" alt="drawing" width="100"/>

# QuickWebViewer

demo:
- 🔗 [Portail cartographique d’urbanisme du Grand Conakry](http://urba-conakry.quickwebviewer.org/)   
    
    
## A QGIS plugin to easily publish your maps online

An easy sollution if you want to publish easily and with a low complexity infraestructure your QGIS maps.

QuickWebViewer is a plugin that enables the online publication of maps created in QGIS through a simple three step process.
        
   [Installation](#Installation)

   [Fast instructions](#fast)

   [Export your maps](#export)

   [Server requirements](#server)

   [Good tips for styling](#styling)

   [Customize your viewer](#custom)

   [Future developments](#future)

    
# Installation <a name="Installation"></a>
    
The QuickWebViewer plugin can be downloaded and installed via the .zip folder, accessible at the following link:

- 🔗 [QuickWebViewer](http://www.quickwebviewer.org/)   



# Fast instructions <a name="fast"></a>


### Why you need it?
    
- If you are not capable to install amn manage Qgis Server 
- If you don't want to maintain complex servers
- If the awesome plugin [qgis2web](https://plugins.qgis.org/plugins/qgis2web/) don't fit your needs
- QuickWebViewer is good for average cartographic projects, not infographic or supercomplex stylings
    
    
### How it works?

QuickWebViewer transform your qgis themes in three steps:

#### ![Step 1](readme_imgs/icon_1.svg) Step 1 : Export mapset, export your qgis files (selecting your predefined themes)

#### ![Step 2](readme_imgs/icon_2.svg) Step 2 : Export viewer, pack all your previous exports in a viewer

#### ![Step 3](readme_imgs/icon_3.svg) Step 3 : Publish viewer, upload to your own server


### Before to publish

- you will need to adapt a little bit your drawings to the graphical restrictions of MapLibre
- you will need to own a very low cost server (only with php and pdo_sqlite)


# Export your maps <a name="export"></a>
    
## ![Step 1](readme_imgs/icon_1.svg) Step 1 : Export mapset

<img align="center" width="500"  src="readme_imgs/rm_1.png"> 

#### Details:

1. Name: Enter the mapset name.

2. Export folders: Specify the reference path to the previously created folder (e.g., "projectname_export") where the mapset folder will be generated.

3. Description: Add a description related to the mapset.

4. Backgrounds: Select background maps for overlaying cartographic data. Adjust visibility after viewer publication.

5. Attached files: Attach PDF documents with reference names, downloadable in the final viewer.

6. Extent: Specify the export area using either:
   - Use Current Map Canvas Extent
   - Use Project Extent

#### Select views to export:

7. View: Choose a theme from various views created in the QGIS file.

8. Name: Customize the name of each view.
    
9. Description: Add a brief description for each view.
    
10. Layers: Modify individual layers within the view. Click "Edit" to customize layer settings.

<img align="center" width="500"  src="readme_imgs/rm_2.png"> 

10b. click ---> Edit ---> customize each layer:

- Layer: Name of the layer.
- Name: Editable layer name.
- Description: Short specific description.
- Legend: Enable or disable visibility in the legend.

11. Zoom min: Set minimum display zoom.

12. Zoom max: Set maximum display zoom.

13. It is recommended but not mandatory to enable it when exporting multiple views. 
    It is not necessary when exporting a single view. 


   
## ![Step 2](readme_imgs/icon_2.svg)  Step 2 : Export viewer
    
<img align="center" width="500"  src="readme_imgs/rm_3.png">


#### Mapset:

1. Select Folder: Choose the folder generated in STEP 1.
    
2. Select Mapsets: Choose one or more mapset sets for conversion based on your needs.

#### Viewer:
    
3. Title: Define the title in the viewer.

4. Subtitle: Add a supporting subtitle in the viewer.

5. Description: Insert a brief description in the viewer.

6. Full description: Provide a more detailed and complete descriptive text.

7. Attribution : Insert a text referring to the attribution of the project and in terms of a disclaimer. 

8. Output folder: Indicate the viewer's save direction referring to the reference folder (e.g."projectname_export") where mapset and viewer were generated in Step 1.

#### Logos:
    
9. 
- Image file: Define the logo image path.
- Name: Add the logo name for display.
- URL link: Include a URL link for a clickable logo directing to a website.

#### Attached files:
    
10. 
- File: Define the document location path.
- Name: Add a specific name for documents in the viewer.
    
     
## ![Step 3](readme_imgs/icon_3.svg)  Step 3 : Publish viewer 
    
<img align="center" width="500"  src="readme_imgs/rm_4.png"> 

1. If you have FTP access:
   - Simply use the 3D plugin button.

2. If you are using SFTP access:
   - Utilize FileZilla for seamless file transfer.


#### Project:

1. Folder: Select the path where the "viewer" was exported in STEP 2. 

- Note: The structure and organisation of folders are crucial for the functionality of plugins.

#### Server:

2. Protocol: FTP - File Transfer Protocol (port 21) 
    
3. Host:

4. Path: Optional; assign a name for different versions (e.g., v1, v2, v3).

5. User: Define a username.

6. Password: Set a reference password for your user.

Due to stricter security standards, this step might not work on some computers. 

In such cases, an alternative using FileZilla is available: 🔗 [FileZilla](https://filezilla-project.org/)
    
    

     
# Server requirements <a name="server"></a>
    
    
#### Prerequisites:

- A managed server with PHP and PDO_SQLite support.
   This includes managed servers such as:
    - 🔗 [Ionos](https://www.ionos.es/)
    - 🔗 [OVH](https://www.ovhcloud.com/es-es/)


#### Installation steps:



#### Note:

- In case your connection is slow or experiences interruptions:
  - It is recommended to use FileZilla for a smoother experience.    

    
      
#### How upload with the plugin
    

<img align="center" width="500"  src="readme_imgs/step3_readme_edit.png"> 
    
    
1. Project : select the export path in the "viewer" folder

It is essential to note that the backup structure and the organisation of the folders are of fundamental importance to the correct operation of the extension.

2. Server : 
    
Protocol: FTP - SSH File Transfer Protocol (port 21) 
    
Host: define Host
    
Path: this does not have to be defined, you can assign a name to create different versions (such as v1, v2, v3 for example)
    
User: define User 
    
Password: set a reference password for your user.
    
    
#### ❓ How to upload with filezilla 
    
🔗 [FileZilla](https://filezilla-project.org/) 
    
<img align="center" width="500" src="readme_imgs/readme_fz_edit.png"> 
    
    
    
1. toolbar
    
2. quickconnect bar
    
3. message log : displays messages related to the transfer and connection, below which you will find the file listing
    
4. displays the local files and directories, i.e. the objects on the PC that are being used in FileZilla
    
5. displays the files and directories found on the server to which you are connected
    
6. transfer queue : which lists the files that will start to be transferred or have already been transferred


# Good tips for styling <a name="styling"></a>


✅ Use "Meters at Scale" insetad of "Map Units".
    
✅ The plugin can export vector layers
    
❌ The plugin cannot export raster layers

❌ You cannot use blend modes for features and layers (waiting form MapLibre improvements)

❌ You cannot aasign alpha by layer, only by feature (waiting form MapLibre improvements)


#### Use concat expression to add (concatenate) strings

✅ concat("A", "B")

❌ "A" + "B"   

In the case where we want to combine two columns for example column "type" and column "status"

✅  concat("type", "status")

❌ "type" + "status"   


#### labels 
    
✅ The unit of measurement to be used in the definition of labels is millimetres.

✅ single labels are accepted
    
✅ ruled-based labeling are accepted

❌ formatting space letter is not yet implemented
        
✅ buffer is accepted
    
✅ color background forn label is accepted

❌ text style "italic"  is not yet implemented


#### symbology
    
✅ single symbol
    
✅ categorized
    
✅ graduated
    
✅ ruled-based
    
✅ symbol layer type : simple fill, outline : simple line 
    
❌ heatmap style 
    
✅ svg qgis marker symbology

✅ dot-line 

✅ geometry type layer : polygon, line, point 
    
✅ always use 'no brush' and insert colour in simple fill is a necessary condition if you only want to display the polygon outline
    
✅ accept in fill style : solid, no brush

❌ no accept in fill style : horizontal, vertical, cross, diagonal, dense
    
✅ set as symbol layer type : "outline : simple line" to represent the dot outline of a polygon (geometry type) without filling. 

 
## QGIS Expressions accepted for styling

| Function    | Description                            |
|-------------|:--------------------------------------:|
| `acos`      | Arc cosine function                    |
| `asin`      | Arc sine function                      |
| `atan`      | Arc tangent function                   |
| `atan2`     | Arc tangent of two variables           |
| `ceil`      | Ceiling function (round up)            |
| `concat`    | Concatenate strings                    |
| `cos`       | Cosine function                        |
| `degrees`   | Convert radians to degrees             |
| `floor`     | Floor function (round down)            |
| `if`        | Conditional statement                  |
| `lower`     | Convert string to lowercase            |
| `ln`        | Natural logarithm                      |
| `max`       | Maximum value of two numbers           |
| `min`       | Minimum value of two numbers           |
| `radians`   | Convert degrees to radians             |
| `replace`   | Replace substring in a string          |
| `sin`       | Sine function                          |
| `substr`    | Extract a substring                    |
| `tan`       | Tangent function                       |
| `title`     | Convert string to title case           |
| `to_int`    | Convert to integer                     |
| `to_float`  | Convert to floating-point number       |
| `to_string` | Convert to string                      |
    
# Customize your viewer <a name="custom"></a>

In the folder where is placed the viewer you will find this files to customize some properties. 

- app/customviewer.js
- app/customcolors.css

# Future developments <a name="future"></a>

The current version of this tool has been developed to face the publication of two cartographic projects.

In the near future we will include:
   - raster exporting (including COGs)
   - php and sqlite free server (using PMTiles)
   - marker symbology improved (with custom symbols and not only qgis symbols)
   - some hatch fills (the very basic will be included)
   - major context layers complexity (stamen, osm..., )
   - better tile compression (throught layer simplification by zoom level)
   - add more variables for the customization of the viewer

