# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Contents
                                 A QGIS plugin
 The plugin to convert DEM to GeoTiff and Terrain RGB (Tiff).
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-05-31
        git sha              : $Format:%H$
        copyright            : (C) 2021 by MIERUNE Inc.
        email                : info@mierune.co.jp
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import webbrowser

from qgis.core import QgsProject, QgsRasterLayer
from qgis.PyQt.QtWidgets import QMessageBox

from .convert_fgd_dem.src.convert_fgd_dem.converter import Converter


class Contents:
    def __init__(self, iface):
        self.iface = iface
        self.import_path = ""

    def convert(self, output_path, filename, rgbify):
        converter = Converter(
            import_path=self.import_path,
            output_path=output_path,
            output_epsg=self.output_epsg,
            file_name=filename,
            rgbify=rgbify,
        )

        converter.run()

    def add_layer(self, output_path, tiff_name, layer_name):
        layer = QgsRasterLayer(os.path.join(output_path, tiff_name), layer_name)
        QgsProject.instance().addMapLayer(layer)

    def convert_DEM(self):
        if not self.import_path:
            QMessageBox.information(
                None,
                "Error",
                "Input DEM path is not defined.",
            )
            return

        if not self.process_interrupted:
            QMessageBox.information(
                None,
                "Completed",
                "Process completed.",
            )

        return True

    def on_download_page_clicked(self):
        webbrowser.open("https://service.gsi.go.jp/kiban/app/map/?search=dem")
        return

    def set_interrupted(self):
        self.process_interrupted = True
