from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.utils import *
import pdb

import resources
from QBEform import QBEform
from QBEhelp import QBEhelp

class QueryByExample:

    def __init__(self, iface):
        self.iface = iface
#        self.user_plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins"
#        self.dir = self.user_plugin_dir + "/QueryByExample/"

    def initGui(self):
        self.action = QAction(QIcon(":/plugins/QueryByExample/icon.png"),
                              "Query By Example",
                              self.iface.mainWindow());
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&QBE", self.action)
    
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&QBE", self.action)
        self.iface.removeToolBarIcon(self.action)
        
    def run(self):
        self.mapInstance = QgsMapLayerRegistry.instance()
        self.mapLayers = self.mapInstance.mapLayers()
        if (len(self.mapLayers) < 2):
            QMessageBox.information(self.iface.mainWindow(),
                                    "Error",
                                    "Need at least two layers")
            return
        
        self.dlg = QBEform()
        self.targetLyrIds = []
        self.refLyrIds = []
        self.layerInfo = {}
        self.operations = {}
        self.opNames = []
        self.bufferEnabled = False

        for (name, layer) in self.mapLayers.iteritems():
            if layer.type() == QgsMapLayer.VectorLayer:
                self.layerInfo[layer.id()] = layer.name()

        self.setTargetLayers()
        self.setRefLayers()
        self.setOperations()
        self.setUnit()
        self.connectAll()
        self.dlg.show()
        
    def showHelp(self):
        self.help = QBEhelp()
        self.help.show()
        
    def enableBuffer(self):
        self.bufferEnabled = not self.bufferEnabled

    def setTargetLayers(self):
        self.dlg.ui.comboBoxWhere.clear()
        self.targetLyrIds = []
        for ids in self.layerInfo:
            self.targetLyrIds.append(ids)
            self.dlg.ui.comboBoxWhere.addItem(self.layerInfo[ids])
        
    def getTargetLayerId(self):
        return self.targetLyrIds[self.dlg.ui.comboBoxWhere.currentIndex()]

    def setRefLayers(self):
        self.dlg.ui.comboBoxTo.clear()
        self.refLyrIds = []
        targetId = self.getTargetLayerId()
        for ids in self.layerInfo:
            if ids != targetId:
                self.refLyrIds.append(ids)
                self.dlg.ui.comboBoxTo.addItem(self.layerInfo[ids])

    def getRefLayerId(self):
        return self.refLyrIds[self.dlg.ui.comboBoxTo.currentIndex()]

    def setOperations(self):
        targetLayer = self.mapInstance.mapLayer(self.getTargetLayerId())
        refLayer = self.mapInstance.mapLayer(self.getRefLayerId())

        self.operations, self.opNames = self.getOps(targetLayer.geometryType(),
                                                    refLayer.geometryType())

        self.dlg.ui.comboBoxRelation.clear()
        for name in self.opNames:
            self.dlg.ui.comboBoxRelation.addItem(name)

    def setUnit(self):
        toLayer = self.mapInstance.mapLayer(self.getRefLayerId())
        toProvider = toLayer.dataProvider()
        unit = toProvider.crs().mapUnits()
        str = 'Unit: '
        if unit == 0:
            str += 'meter'
        elif unit == 1:
            str += 'feet'
        elif unit == 2:
            str += 'decimal degree'
        elif unit == 3:
            str += 'Unknown'
        elif unit == 4:
            str += 'degree minute second'
        elif unit == 5:
            str += 'degree decimal minute'
        self.dlg.ui.labelUnit.setText(str)

    def querybe(self):
        if (self.bufferEnabled):
            try:
                self.bufferSize = float(self.dlg.ui.lineEdit.text())
            except:
                QMessageBox.information(self.iface.mainWindow(),
                                        "Error",
                                        "Please input number only.")
                return
            
        whereLayer = QgsVectorLayer
        toLayer = QgsVectorLayer

        try:
            whereLayer = self.mapInstance.mapLayer(self.getTargetLayerId())
            toLayer = self.mapInstance.mapLayer(self.getRefLayerId())

        except:
            QMessageBox.information(self.iface.mainWindow(),
                                    "Error",
                                    "Target layer is not a valid vector layer")
            return

        whereProvider = whereLayer.dataProvider()
        toProvider = toLayer.dataProvider()
        self.dlg.ui.progressBar.reset()
        self.totalFeatureCount = whereProvider.featureCount()
        self.currentFeatureCount = 0


        relationIndex = self.dlg.ui.comboBoxRelation.currentIndex()
        relationOps = self.operations[relationIndex]
        selection = relationOps[0](whereProvider, toProvider, relationOps[1])

        whereLayer.setSelectedFeatures(selection)

        self.dlg.ui.labelInfo.setText(str(len(selection)) +
                                      "  feature(s) in selection")
        self.dlg.ui.progressBar.reset()

        
    def existsOne(self, whereProvider, toProvider, relationOp):
        whereProvider.select(whereProvider.attributeIndexes() )
        whereProvider.rewind()

        whereFeature = QgsFeature()
        toFeature = QgsFeature()
        selection = []        

        while (whereProvider.nextFeature(whereFeature)):
            whereGeom = whereFeature.geometry()
            toProvider.select(toProvider.attributeIndexes() )
            toProvider.rewind()

            while(toProvider.nextFeature(toFeature)):
                toGeom = toFeature.geometry()
                if self.bufferEnabled:
                    toGeom = toGeom.buffer(self.bufferSize, 5)
                
                if (relationOp(whereGeom, toGeom) ):
                    selection.append(whereFeature.id())
                    break

            self.currentFeatureCount += 1
            self.dlg.ui.progressBar.setValue(int (float(self.currentFeatureCount) /
                                                  self.totalFeatureCount * 100))
        return selection

    def everyNot(self, whereProvider, toProvider, relationOp):
        whereProvider.select(whereProvider.attributeIndexes() )
        whereProvider.rewind()

        whereFeature = QgsFeature()
        toFeature = QgsFeature()
        selection = []        

        while (whereProvider.nextFeature(whereFeature)):
            whereGeom = whereFeature.geometry()
            toProvider.select(toProvider.attributeIndexes() )
            toProvider.rewind()

            exception = False
            while(toProvider.nextFeature(toFeature)):
                toGeom = toFeature.geometry()

                if self.bufferEnabled:
                    toGeom = toGeom.buffer(self.bufferSize, 5)

                exception = False
                if (relationOp(whereGeom, toGeom) ):
                    pass
                else:
                    exception = True
                    break
            if (not exception):
                selection.append(whereFeature.id())

            self.currentFeatureCount += 1
            self.dlg.ui.progressBar.setValue(int (float(self.currentFeatureCount) /
                                                  self.totalFeatureCount * 100))
        return selection

    def judgeIntersects(self, where, to):
        return where.intersects(to)
    def judgeContains(self, where, to):
        return where.contains(to)
    def judgeDisjoint(self, where, to):
        return where.disjoint(to)
    def judgeEquals(self, where, to):
        return where.equals(to)
    def judgeTouches(self, where, to):
        return where.touches(to)
    def judgeOverlaps(self, where, to):
        return where.overlaps(to)
    def judgeWithin(self, where, to):
        return where.within(to)
    def judgeCrosses(self, where, to):
        return where.crosses(to)

    # get idea from offical source code of the plugin \
    # spatial queryversion 1.7.2 'Wroclaw' 
    def getOps(self, dimTarget, dimReference):
        ops = {}
        opNames = []

        index = 0
        ops[index] = [self.existsOne, self.judgeIntersects]
        opNames.append("intersects")
        index += 1
        ops[index] = [self.everyNot, self.judgeDisjoint]
        opNames.append("disjoint")
        index += 1
        
        if (dimTarget < dimReference):
            ops[index] = [self.existsOne, self.judgeTouches]
            opNames.append("touches")
            index += 1

            ops[index] = [self.existsOne, self.judgeCrosses]
            opNames.append("crosses")
            index += 1

            ops[index] = [self.existsOne, self.judgeWithin]
            opNames.append("Within")
            index += 1
        elif (dimTarget > dimReference):

            ops[index] = [self.existsOne, self.judgeContains]
            opNames.append("contains")
            index += 1
        else:                   # dimTarget == dimReference
            ops[index] = [self.existsOne, self.judgeEquals]
            opNames.append("equals")
            index += 1

            ops[index] = [self.existsOne, self.judgeOverlaps]
            opNames.append("overlaps")
            index += 1

            if (dimTarget == 1):
                ops[index] = [self.existsOne, self.judgeTouches]
                opNames.append("touches")
                index += 1

                ops[index] = [self.existsOne, self.judgeCrosses]
                opNames.append("crosses")
                index += 1
            elif (dimTarget == 2):
                ops[index] = [self.existsOne, self.judgeTouches]
                opNames.append("touches")
                index += 1

                ops[index] = [self.existsOne, self.judgeWithin]
                opNames.append("Within")
                index += 1

                ops[index] = [self.existsOne, self.judgeContains]
                opNames.append("contains")
                index += 1

        return ops, opNames

    def connectAll(self):
        QObject.connect(self.dlg.ui.pushButtonApply,
                        SIGNAL("clicked()"),
                        self.querybe)
        QObject.connect(self.dlg.ui.pushButtonHelp,
                        SIGNAL("clicked()"),
                        self.showHelp)
        QObject.connect(self.dlg.ui.checkBoxBuffer,
                        SIGNAL("toggled(bool)"),
                        self.enableBuffer)
        QObject.connect(self.dlg.ui.comboBoxWhere,
                        SIGNAL("currentIndexChanged(int)"),
                        self.setRefLayers)
        QObject.connect(self.dlg.ui.comboBoxTo,
                        SIGNAL("currentIndexChanged(int)"),
                        self.setOperations)
        QObject.connect(self.dlg.ui.comboBoxTo,
                        SIGNAL("currentIndexChanged(int)"),
                        self.setUnit)
