from ui_importTxt import Ui_ImportTxt #import GUI
from ..Utility_functions import * # import common functions
from PyQt4 import QtCore, QtGui
import os.path
from qgis.core import *
import locale

class ImportTxt(QtGui.QDialog):
	"""Import TXT/CSV Layers into SpatiaLite DataBase"""
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self)
	# Set up the user interface from Designer.
		self.ui = Ui_ImportTxt()
		self.ui.setupUi(self)
	#Set app variables
		self.parent=parent
	#prepare listbox for CSV/TXT import
		self.ui.custom_col.setEnabled(False)
		decimal=['point (.)','comma (,)']
		self.decimals={'point (.)':'POINT','comma (,)':'COMMA'}
		self.ui.decimal.clear()
		self.ui.decimal.insertItems(0,decimal)
		textseparator=['double quote"','single quote\'']
		self.textseparator={'double quote"':'DOUBLEQUOTE','single quote\'':'SINGLEQUOTE'}
		self.ui.text.insertItems(0,textseparator)
		columnseparator=['Tab','Space','Comma ,','Colon :','Semicolon ;','Other']
		self.columnseparator={'Tab':"TAB",'Space':"' '",'Comma ,':"','",'Colon :':"':'",'Semicolon ;':"';'",'Other':""}
		self.ui.column.insertItems(0,columnseparator)
		self.charset= [locale.getdefaultlocale()[1],'ISO-8859-15','ISO-8859-1', 'ISO-8859-2', 'UTF-8', 'CP1250']
		self.ui.charsetList_CSV.insertItems(0, self.charset)
		
	# signals and slots:
		QtCore.QObject.connect(self.ui.column, 
				                QtCore.SIGNAL("currentIndexChanged(const QString&)"), 
				                self.toggle_csv_custom_col)
		QtCore.QObject.connect(self.ui.searchCSV, 
				          QtCore.SIGNAL("clicked(bool)"), 
				          self.browseFileCSV)
		QtCore.QObject.connect(self.ui.uploadCSV, 
				                QtCore.SIGNAL("clicked(bool)"), 
				                self.uploadCSV)
	
	#functions
	def toggle_csv_custom_col(self):
		if self.ui.column.currentText()=='Other':
			self.ui.custom_col.setEnabled(True)
		else:
			self.ui.custom_col.setText('')
			self.ui.custom_col.setEnabled(False)
			
	def uploadCSV(self):
		#detect parameters
		try:
			filename=unicode(self.ui.csv_path.text())
			name=unicode(self.ui.name_csv.text())
			vname=name+"_virt"
			first_col=0 
			if self.ui.first_col.isChecked()==True:
				first_col=1
			charset=unicode(self.ui.charsetList_CSV.currentText())
			decimal_sep=self.decimals[unicode(self.ui.decimal.currentText())]
			text_sep=self.textseparator[unicode(self.ui.text.currentText())]
			if unicode(self.ui.column.currentText())=="Other":
				column_sep="'"+unicode(self.ui.custom_col.text())+"'"
			else:
				column_sep=self.columnseparator[unicode(self.ui.column.currentText())]
		except:
			pop_up_error("No accents/special characters please",self)
			return False
		
		if (filename=='') or (name=='') or(charset=='')or(decimal_sep=='')or(column_sep=="''"):
			pop_up_error("All the fields are necessary",self)
			return False
		#verify if table already exists in DB
		for table in [table.name for table in self.parent.db.tables]:
			if table in (name,vname):
				pop_up_error("Table name already exists: %s"%table,self)
				return False
			cursor = self.parent.db.connectionObject.cursor()
		#create virtual table
		try:
			vtsql="""CREATE VIRTUAL TABLE "%s" USING VirtualText("%s",%s,%s,%s,%s,%s)""" %(vname, filename, charset, first_col, decimal_sep, text_sep, column_sep)
			cursor.execute(vtsql)
		except self.parent.db.connectionObject.OperationalError, errorMsg:
			pop_up_error("VirtualText Loading failed.\n\n%s" %
		                     errorMsg,self)
			self.parent.db.connectionObject.rollback()
			cursor.close()
			return False

		#create new table from virtual Table
		try:
			vtsql=("""CREATE TABLE "%s" AS SELECT * FROM "%s" """ %(name, vname))
			cursor.execute(vtsql)
		except self.parent.db.connectionObject.OperationalError, errorMsg:
			pop_up_error("New Empty Table creation failed.\n\n%s" %
		                     errorMsg,self)
			self.parent.db.connectionObject.rollback()
			cursor.close()
			return False

		#drop virtual table
		try:
			vtsql=("""DROP TABLE "%s" """ %(vname))
			cursor.execute(vtsql)
		except self.parent.db.connectionObject.OperationalError, errorMsg:
			pop_up_error("DROP VirtualTable failed.\n\n%s" %
		                     errorMsg,self)
			self.parent.db.connectionObject.rollback()
			cursor.close()

		#everything is okay
		self.parent.db.connectionObject.commit()
		cursor.close()
		pop_up_info("TXT/CSV Layer has been uploaded",self)
		self.parent.drawTreeView()
	
	def browseFileCSV(self):
		filename = QtGui.QFileDialog.getOpenFileName(self, "Open CSV/TXT","", "TXT (*.txt);; CSV (*.csv)")
		if filename.strip()=="":
			return
		self.ui.csv_path.setText(filename)
		return True


