from ui_exportOgr import Ui_exportOgrLayers #import GUI
from ..Utility_functions import * # import common functions
from ..Classes.dialogSRS import GdalToolsSRSDialog as srsdialog
from PyQt4 import QtCore, QtGui
from qgis.core import *
import locale

class ExportOgrLayers(QtGui.QDialog):
	"""Export SpatiaLite Spatial tables to OGR Layers (spatial argument), or export non spatial table to CSV format"""
	def __init__(self, parent=None,spatial=True):
		QtGui.QDialog.__init__(self)
	# Set up the user interface from Designer.
		self.ui = Ui_exportOgrLayers()
		self.ui.setupUi(self)
	#Set app variables
		self.spatial=spatial
		self.parent=parent
		self.srsdialog=srsdialog
		self.charset= [locale.getdefaultlocale()[1],'ISO-8859-15','ISO-8859-1', 'ISO-8859-2', 'UTF-8', 'CP1250']
		self.ui.charsetExport.insertItems(0,self.charset)
		self.formats=self.getFormat(spatial=self.spatial)
		self.ui.outForm.insertItems(0,self.formats)
		self.tables=self.getTables(spatial=self.spatial)
		self.model=QtGui.QStandardItemModel(0,1)
		if self.spatial:
			self.model.setHorizontalHeaderItem(0,QtGui.QStandardItem('Spatial Tables'))
		else:
			self.model.setHorizontalHeaderItem(0,QtGui.QStandardItem('SpatiaLite Tables'))
		for table in self.tables:
			item=QtGui.QStandardItem(table.name)
			item.setData(table,32) #Data 32: Qt.UserRole
			self.model.appendRow(item)
		self.ui.geomTables.setModel(self.model)
		#self.ui.geomTables.show()
		
		
	#Qt Signal and slots
		#Select SRID
		QtCore.QObject.connect(self.ui.sridExportChoose,QtCore.SIGNAL("clicked(bool)"),self.browseSRID)
		#Browse Folder
		QtCore.QObject.connect(self.ui.folderExportChoose,QtCore.SIGNAL("clicked(bool)"),self.browseFolder)
		#Validate operation
		QtCore.QObject.connect(self.ui.buttonBox,QtCore.SIGNAL("accepted()"),self.validate)
		
	def browseSRID(self):
		"""Open SRS Dialog and retreive SRID"""
		dialog = self.srsdialog( "Select desired SRID" )
		if dialog.exec_():
			self.ui.sridExport.setText(dialog.getProjection())
			
	def browseFolder(self):
		"""Browse existing folder"""
		filename = QtGui.QFileDialog.getExistingDirectory(self, "Open Directory","", QtGui.QFileDialog.ShowDirsOnly|QtGui.QFileDialog.DontResolveSymlinks)
		if filename.strip()=="":
			return
		self.ui.folderExport.setText(filename)	
	
	def getFormat(self,spatial):
		"""Return formats available to save spatial or non spatial tables"""
		if spatial is True:
			return QgsVectorFileWriter.ogrDriverList().values()[1:]
		else:
			return [u'CSV',u'SQLite',u'DBF']

	def getTables(self,spatial):
		"""List spatial or non spatial tables from current DataBase"""
		if spatial is True:
			return [table for table in self.parent.db.tables if table.geo is not False]
		else:
			#disable SRID field
			self.ui.sridExport.setEnabled(False)
			self.ui.sridExportChoose.setEnabled(False)
			return self.parent.db.tables # all tables can be exported to txt format
			
	def validate(self):
		"""Export selected tables to OGR"""
		#list selected tables
		tables=[item.data(32) for item in self.ui.geomTables.selectedIndexes()] #get selected items
		if len(tables)<=0:
			return
		#user just want to load layers in QGIS
		if self.ui.justQgis.isChecked():
			for table in tables:
				table.loadToQgis()
			pop_up_info("Operation Done",self)
			return
		format=unicode(self.ui.outForm.currentText()) #get Format
		folder=unicode(self.ui.folderExport.text()).strip()
		charset=unicode(self.ui.charsetExport.currentText()).strip()
		if format=='' or folder=='' or charset=='':
			pop_up_error("All fields except SRID are mandatory",self)
			return
		srid=unicode(self.ui.sridExport.text()).strip()
		if srid=='':
			srid=None
		else:
			try:
				srid=int(srid)
			except:
				pop_up_error('srid must be integer',self)
				return
		QtGui.QApplication.setOverrideCursor(QtCore.Qt.WaitCursor)
		for table in tables:
			if not table.exportToOgr(folder,charset,format,srid):
				pop_up_error("Impossible to export table '%s'"%table.name,self)
		QtGui.QApplication.restoreOverrideCursor()
		pop_up_info("Operation Done",self)
		return
