"""
/***************************************************************************
 QspatiaLite
 A QGIS plugin inspired by "CustomDBquery" and "SpatiaLite_manager" plugins
 SpatiaLite GUI for SpatiaLite
                              -------------------
        begin                : 2011-03-15
        copyright            : (C) 2011 by riviere
        email                : romain.riviere.974@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from QspatiaLiteApp import QspatiaLiteApp

class QspatiaLite:

    def __init__(self, iface):
        # Save reference to the QGIS interface
		self.iface = iface
		self.mlr = QgsMapLayerRegistry.instance()

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/qspatialite/icon.png"), \
            "QspatiaLite", self.iface.mainWindow())
	
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        #self.iface.addPluginToMenu("&QspatiaLite", self.action)
	#add to Database menu
	if hasattr(self.iface, "addPluginToDatabaseMenu"):
	    self.iface.addPluginToDatabaseMenu("&SpatiaLite", self.action)
	else:
	    self.iface.addPluginToMenu("&SpatiaLite", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        #self.iface.removePluginMenu("&QspatiaLite",self.action)
	#remove from Database menu
	if hasattr(self.iface, "removePluginDatabaseMenu"):
	    self.iface.removePluginDatabaseMenu("&SpatiaLite", self.action)
	else:
	    self.iface.removePluginMenu("&SpatiaLite", self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):
        # create and show the dialog
        dlg = QspatiaLiteApp(self.iface)
        dlg.setWindowFlags( Qt.Window )
        # show the dialog
        dlg.show()
        result = dlg.exec_()

