from PyQt4 import QtCore, QtGui
from pyspatialite import dbapi2 as sqlite
from Table import *
from Column import *
from Trigger import *
from ..browser.browser import browser
from ..Utility_functions import *
from qgis.core import *
from types import StringType, NoneType, IntType, BooleanType
import csv


class TreeMenu(QtGui.QMenu):
	"""Right Clic Menu for Tree View"""
	def __init__(self,parent,item,parentItem):
		QtGui.QMenu.__init__(self)
		#Define default values
		self.parent=parent
		self.item=item
		self.parentItem=parentItem


		#Right clic menu actions:
			#refresh tree
		self.refreshAction=QtGui.QAction("Refresh Tree",self)
		QtCore.QObject.connect(self.refreshAction, QtCore.SIGNAL('triggered()'), self.parent.drawTreeView)
			#Load table in QGIS
		self.toQGISAction=QtGui.QAction("Load in QGIS",self)
		QtCore.QObject.connect(self.toQGISAction, QtCore.SIGNAL('triggered()'), self.loadToQgis)
			#Show columns informations
		self.showColsAction=QtGui.QAction("Show columns",self)
		QtCore.QObject.connect(self.showColsAction, QtCore.SIGNAL('triggered()'), self.showColsInfos)
			#drop table
		self.dropTableAction=QtGui.QAction("Drop Table",self)
		QtCore.QObject.connect(self.dropTableAction, QtCore.SIGNAL('triggered()'), self.dropTable)
			#new table/view
		self.newTableAction=QtGui.QAction("New Table",self)
		QtCore.QObject.connect(self.newTableAction, QtCore.SIGNAL('triggered()'), self.newTable)
		self.newViewAction=QtGui.QAction("New View",self)
		QtCore.QObject.connect(self.newViewAction, QtCore.SIGNAL('triggered()'), self.newView)
			#showSample/showAll
		self.showSampleAction=QtGui.QAction("Show Sample",self)
		QtCore.QObject.connect(self.showSampleAction, QtCore.SIGNAL('triggered()'), self.showSample)
		self.showAllAction=QtGui.QAction("Show All",self)
		QtCore.QObject.connect(self.showAllAction, QtCore.SIGNAL('triggered()'), self.showAll)
			#Rename Table
		self.renameTAction=QtGui.QAction("Rename",self)
		QtCore.QObject.connect(self.renameTAction, QtCore.SIGNAL('triggered()'), self.renameTable)
			#Add column to table 
		self.addColAction=QtGui.QAction("New Column",self)
		QtCore.QObject.connect(self.addColAction, QtCore.SIGNAL('triggered()'), self.addColumn)
			#Add index to table 
		self.newIndexAction=QtGui.QAction("New Index",self)
		QtCore.QObject.connect(self.newIndexAction, QtCore.SIGNAL('triggered()'), self.newIndex)
		#Show metadata 
		self.showMetaAction=QtGui.QAction("Show Metadata",self)
		QtCore.QObject.connect(self.showMetaAction, QtCore.SIGNAL('triggered()'), self.showMetaData)
			#New Trigger
		self.newTriggerAction=QtGui.QAction("New Trigger",self)
		QtCore.QObject.connect(self.newTriggerAction, QtCore.SIGNAL('triggered()'), self.newTrigger)
			#remove spatial index
		self.removeSpIdxAction=QtGui.QAction("Remove Spatial Index",self)
		QtCore.QObject.connect(self.removeSpIdxAction, QtCore.SIGNAL('triggered()'), self.removeSpIdx)
			#create spatial index
		self.createSpIdxAction=QtGui.QAction("Create Spatial Index",self)
		QtCore.QObject.connect(self.createSpIdxAction, QtCore.SIGNAL('triggered()'), self.createSpIdx)
			#Update column
		self.updateColAction=QtGui.QAction("Update Column",self)
		QtCore.QObject.connect(self.updateColAction, QtCore.SIGNAL('triggered()'), self.updateCol)
			#col values
		self.colValuesAction=QtGui.QAction("Unique Values",self)
		QtCore.QObject.connect(self.colValuesAction, QtCore.SIGNAL('triggered()'), self.colValues)
			#Check geometry
		self.checkGeomAction=QtGui.QAction("Check Geometry",self)
		QtCore.QObject.connect(self.checkGeomAction, QtCore.SIGNAL('triggered()'), self.checkGeom)
			#RecoverGeometry column
		self.recoverGeoColAction=QtGui.QAction("Recover Geometry Column",self)
		QtCore.QObject.connect(self.recoverGeoColAction, QtCore.SIGNAL('triggered()'), self.recoverGeoCol)
			#view trigger
		self.viewTriggerAction=QtGui.QAction("Show SQL",self)
		QtCore.QObject.connect(self.viewTriggerAction, QtCore.SIGNAL('triggered()'), self.viewTrigger)
		#Create and draw menu
		self.createMenu()


	def createMenu(self):
		"""Add actions to menu"""
		#Refresh Tree
		self.addAction(self.refreshAction)
		self.addSeparator()
		if isinstance(self.item,Table):
		#Add newTable
			self.addAction(self.newTableAction)
			self.addAction(self.newViewAction)
			self.addSeparator()
		#Show metadatas
			if self.item.geo!=False:
				self.addAction(self.showMetaAction)
			if self.item.name not in self.parent.db.systables:
		#Rename Table
				if self.item.type=='table' and self.item.geo==False:
					self.addAction(self.renameTAction)
		#DropTable
				self.addAction(self.dropTableAction)
			self.addSeparator()
		#LoadToQgis
			self.addAction(self.toQGISAction)
			self.addSeparator()
		#Show Sample/all
			self.addAction(self.showSampleAction)
			self.addAction(self.showAllAction)
			self.addSeparator()
		#Show Columns
			self.addAction(self.showColsAction)
			if self.item.name not in self.parent.db.systables:
				if self.item.type=='table':
		#Add New Columns
					self.addAction(self.newIndexAction)
					self.addAction(self.addColAction)
				self.addAction(self.newTriggerAction)
				self.addSeparator()
		# add / rmv spatial index
				if self.item.geo!=False and self.item.type=='table':
					if True in [col.spIdx for col in self.item.columns if col.spIdx==True]:
						self.addAction(self.removeSpIdxAction)
					else:
						self.addAction(self.createSpIdxAction)
					
		elif isinstance(self.item,Column):
		#Update values
			self.addAction(self.updateColAction)
			self.addAction(self.colValuesAction)
			if self.item.geo==True:
				self.addAction(self.checkGeomAction)
			else:
				self.addAction(self.recoverGeoColAction)
		elif isinstance(self.item,Trigger):
			self.addAction(self.viewTriggerAction)
		else:
			pass
		#Draw menu
		self.exec_(QtGui.QCursor.pos())
		
	def loadToQgis(self):
		self.item.loadToQgis()
	def dropTable(self):
		table=self.item
		#Avoid to delete system tables
		if table.name in self.parent.db.systables:
			pop_up_error("System table, you'd better not to remove it",self.parent)
			return
		#Ask for user confirmation
		reponse=QtGui.QMessageBox.question(self.parent, "DROP %s"%table.type.upper(),"Do you really want to DROP %s: %s ?"%(table.type,table.name), QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
		if reponse==QtGui.QMessageBox.No:
			return
		if table.type=='table':
			if table.geo: #geotable case
				self.parent.db.executeQuery("DELETE FROM geometry_columns WHERE f_table_name = ? AND f_geometry_column = ? ",(table.name,table.geo[0]))
			if True in [col.spIdx for col in table.columns]: #spatial index
				self.parent.db.executeQuery("SELECT disableSpatialIndex(?,?) ",(table.name,table.geo[0]))
				self.parent.db.executeQuery("""DROP TABLE IF EXISTS "idx_%s_%s" """ %(table.name,table.geo[0]))
				self.parent.db.executeQuery("""DROP TABLE IF EXISTS "cache_%s_%s" """ %(table.name,table.geo[0]))
		else: #view case
			if table.geo:
				self.parent.db.executeQuery("DELETE FROM views_geometry_columns WHERE view_name = ? AND view_geometry = ? ",(table.name,table.geo[0]))
		self.parent.db.executeQuery("""DROP %s "%s" """%(table.type,table.name))
		#draw treeView
		self.parent.drawTreeView()
		if table not in self.parent.db.tables:
			#Action done
			pop_up_info("Table %s dropped"%table.name,self.parent)
	def newTable(self):
		from ..newtable.newtable import newtable
		self.createtable = newtable(self.parent)
		self.createtable.setModal(False)
		self.createtable.show()	
	def newView(self):
		query = 'CREATE VIEW ...name... AS \nSELECT ...sql-select-statement..'
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.tabWidget.setCurrentWidget(self.parent.SQLeditor)
	def showSample(self):
		#show query in editor and make sure there is no option already selected
		self.parent.ui.SQLeditor.setPlainText("""SELECT * FROM "%s" LIMIT 10 """ %self.item.name)
		self.parent.ui.option.setCurrentIndex(0)
		#Run query as if it was from user
		self.parent.runQuery()
	def showAll(self):
		#show query in editor and make sure there is no option already selected
		self.parent.ui.SQLeditor.setPlainText("""SELECT * FROM "%s" """ %self.item.name)
		self.parent.ui.option.setCurrentIndex(0)
		#Run query as if it was from user
		self.parent.runQuery()
	def showColsInfos(self):
		#show query in editor and make sure there is no option already selected
		self.parent.ui.SQLeditor.setPlainText("""PRAGMA table_info("%s")""" %self.item.name)
		self.parent.ui.option.setCurrentIndex(0)
		#Run query as if it was from user
		self.parent.runQuery()
	def renameTable(self):
		(name, ok) = QtGui.QInputDialog.getText (self.parent, 
                        "Enter New Table Name", 
                        "Name:")
		if (not ok) or name=='':
			return
		query = """ALTER Table "%s" RENAME TO "%s" """ %(self.item.name,name.replace('"'," "))
		#show query in editor and make sure there is no option already selected
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.option.setCurrentIndex(0)
		#Run query as if it was from user
		self.parent.runQuery()
	def addColumn(self):
		#show query in editor and make sure there is no option already selected
		self.parent.ui.SQLeditor.setPlainText('ALTER TABLE "%s" \nADD COLUMN ...col-name col-type...'%self.item.name)
		self.parent.ui.tabWidget.setCurrentWidget(self.parent.SQLeditor)
	def showMetaData(self):
		query="""SELECT * FROM geom_cols_ref_sys WHERE f_table_name = "%s" AND f_geometry_column = "%s" """%(self.item.name,self.item.geo[0],)
		#show query in editor and make sure there is no option already selected
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.option.setCurrentIndex(0)
		#Run query as if it was from user
		self.parent.runQuery()
	def newIndex(self):
		query = 'CREATE [ UNIQUE ] INDEX ...indexname....\n ON "%s" \n(\n ...col1, col2, colN...\n)'%self.item.name
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.tabWidget.setCurrentWidget(self.parent.SQLeditor)
	def newTrigger(self):
		query = 'CREATE TRIGGER ...name...\n [BEFORE | AFTER ] \n [INSERT | UPDATE | DELETE ]\nON "%s" \n ...sql-statement...'%self.item.name
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.tabWidget.setCurrentWidget(self.parent.SQLeditor)
	def removeSpIdx(self):
		reponse=QtGui.QMessageBox.question(self, "DROP Spatial Index","Do you really want to DROP Spatial Index on table %s ?"%self.item.name, QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
		if reponse!=QtGui.QMessageBox.Yes: #user hasn't confirmed action
			return
		header,data=self.parent.db.executeQuery("SELECT DisableSpatialIndex(?,?)",(self.item.name,self.item.geo[0]),commit=True)
		if data[0][0]!=1:
			pop_up_error("Can't disable Spatial Index: idx_%s_%s"%(self.item.name,self.item.geo[0],),self.parent)
			return
		self.parent.db.executeQuery(""" DROP TABLE IF EXISTS "idx_%s_%s" """%(self.item.name,self.item.geo[0]),commit=True)
		self.parent.drawTreeView()
		pop_up_info("Spatial Index idx_%s_%s removed"%(self.item.name,self.item.geo[0]),self.parent)
	def createSpIdx(self):
		header,data=self.parent.db.executeQuery("SELECT CreateSpatialIndex(?,?)",(self.item.name,self.item.geo[0],),commit=True)
		if data[0][0]!=1:
			pop_up_error("Can't Create Spatial Index",self.parent)
			return
		self.parent.drawTreeView()
		pop_up_info("New Spatial Index created for table '%s' , on column '%s'"%(self.item.name,self.item.geo[0],),self.parent)
	def updateCol(self):
		query="""UPDATE "%s" SET '%s'= ... \nWHERE ...conditions..."""%(self.parentItem.name,self.item.name)
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.tabWidget.setCurrentWidget(self.parent.SQLeditor)
	def colValues(self):
		query="""SELECT "%s"."%s" FROM "%s" GROUP BY 1"""%(self.parentItem.name,self.item.name,self.parentItem.name)
		header,data=self.parent.db.executeQuery(query)
		self.parent.browser=browser(self.parent)
		txt="<p>Unique Values for column <b>%s</b> (table: <b>%s</b>):</p><p>(Select value, then Drag and drop it to SQL editor)</p>"%(self.item.name,self.parentItem.name)
		for val in data:
			try:
				txt+="<p>%s</p>"%val
			except:
				txt+="<p>GeomObject</p>"
		self.parent.browser.ui.textBrowser.setHtml(txt)
		self.parent.browser.setModal(False)
		self.parent.browser.show()
	def checkGeom(self):
		tableName = self.parentItem.name
		geocol=self.item.name
		query = """SELECT rowid FROM "%s" \n WHERE isValid("%s"."%s")<>1 """ % (tableName,tableName,geocol)
		self.parent.ui.SQLeditor.setPlainText(query)
		self.parent.ui.option.setCurrentIndex(0)
		self.parent.runQuery()
		if len(self.parent.resultset.arraydata)<=0: 
			pop_up_info("Geometry is valid",self.parent)
			return
		elif self.parentItem.type=='view':
			pop_up_error('Incorrect geometry detected, but can\'t be repaired because this is a VIEW table',self.parent)
			return
		else: #invalid geom detected
			reponse=QtGui.QMessageBox.question(self.parent, "Invalid geometry detected","Your table contains at least 				one incorrect geometry (see resultSet).\n\nTry to sanitize invalid geometries ?", 				QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
			if reponse==QtGui.QMessageBox.Yes:
				query = """UPDATE "%s" \nSET "%s"=sanitizegeometry("%s"."%s")\nWHERE isValid("%s"."%s")<>1"""%(tableName,geocol,tableName,geocol,tableName,geocol)
				self.parent.ui.SQLeditor.setPlainText(query)
				self.parent.ui.option.setCurrentIndex(0)
				self.parent.runQuery()
				pop_up_info("Operation Done\nPlease note: current implementation only affects:\n- repeated vertices suppression\n- Ring's closure enforcement",self.parent)
	def recoverGeoCol(self):
		from ..recovergeometry.recovergeometry import recovergeometry
		self.georecovery = recovergeometry(self.parentItem,self.item,self.parent)
		self.georecovery.setModal(False)
		self.georecovery.show()	
	def viewTrigger(self):
		self.parent.ui.SQLeditor.setPlainText(self.item.sql)
		self.parent.ui.option.setCurrentIndex(0)
		self.parent.ui.tabWidget.setCurrentWidget(self.parent.SQLeditor)
		
#class tree menu pour resultset view
class TreeMenuResult(QtGui.QMenu):
	"""Right Clic Menu for ResultSet"""
	def __init__(self,parent,rows):
		QtGui.QMenu.__init__(self)
		#Define default values
		self.parent=parent
		#get selected data
		self.data=[]
		for row in rows:
			self.data.append(list(self.parent.resultset.arraydata[row]))  # get data from selected rows into a array of array
		self.header=self.parent.resultset.headerdata # get columns names
		self.types=[] # column types
		self.geometryColumn=-1 # last geom col index
		self.geomType=None # geom type 
		for idx,val in enumerate(self.data[0]):
			valtype=type(val)
			self.types.append(valtype) # data type based on 1st line
			if isinstance(val,buffer):
				self.geometryColumn=idx # geocol index
				# get geometry type
				head,res=self.parent.db.executeQuery("SELECT GeometryType(?)",(sqlite.Binary(val),))
				self.geomType=res[0][0]
		
		#define slots
		self.action_saveToCSV=QtGui.QAction("Save to TXT",self)
		QtCore.QObject.connect(self.action_saveToCSV, QtCore.SIGNAL('triggered()'), self.saveToCSV)
		self.action_ViewInQgis=QtGui.QAction("Load in QGIS",self)
		QtCore.QObject.connect(self.action_ViewInQgis, QtCore.SIGNAL('triggered()'), self.ViewInQgis)
		
		#Actions
		self.addAction(self.action_saveToCSV)
		if self.geomType is not None: #can be displayed in QGIS
			self.addAction(self.action_ViewInQgis)

		#show menu
		self.exec_(QtGui.QCursor.pos())
		
		#define methods
		
	def saveToCSV(self):
		filename = QtGui.QFileDialog.getSaveFileName(self, "Save File","resultSet.txt","TXT file (*.txt)")
		if filename.isEmpty():
			return
		# WKT transormation if needed
		if self.geometryColumn>-1:
			for idx,row in enumerate(self.data):
				geomVal=row[self.geometryColumn] # get geometry value
				head,res=self.parent.db.executeQuery("""SELECT asText(?)""",(sqlite.Binary(geomVal),))
				self.data[idx][self.geometryColumn]=res[0][0] # store WKT instead of BLOB in data
		#write CSV
		try:
			myfile=open(filename,'wb')
			linewriter=csv.writer(myfile, delimiter='\t')
		except:
			self.pop_up_error("Error while creating TXT/CSV empty File: '%s'"%filename)
			return
		# write columns to csv file
		try:
			linewriter.writerow(self.header)
		except:
	#accent or special char found in col names:-----------------------------
			colc=[] #corrected header
			for val in self.header:
				if isinstance(val,int) or isinstance(val,long)or isinstance(val,float)or isinstance(val,complex):#numbers
					colc.append(str(val))
				elif isinstance(val,buffer):  #geometry object
					colc.append("GeomObject")
				elif (val is None):
					colc.append("")
				else: #strings, date, ....
					colc.append(str(val.encode("utf-8")))
			linewriter.writerow(colc)
	#-----------------------------------------------------------
	#Write rows
		for row in self.data:
			try:
				linewriter.writerow(row)
			except:
	#accent or special char found in col names:-------------------------
				rowc=[]
				for val in row:
					if isinstance(val,int) or isinstance(val,long)or isinstance(val,float)or isinstance(val,complex):#numbers
						rowc.append(str(val))
					elif isinstance(val,buffer):  #geometry object
						rowc.append("GeomObject")
					elif (val is None):
						rowc.append("")
					else: #strings, date, ....
						rowc.append(str(val.encode("utf-8")))
				linewriter.writerow(rowc)
	#--------------------------------------------------------------------------------------------end
		myfile.close()
		pop_up_info("File created",self)
	
	def ViewInQgis(self):
		for idx,row in enumerate(self.data):
			geomVal=row[self.geometryColumn] # get geometry value
			head,res=self.parent.db.executeQuery("""SELECT asBinary(?)""",(sqlite.Binary(geomVal),))
			self.data[idx][self.geometryColumn]=res[0][0] # store WKB instead of BLOB in data

		# A layer with the same name already exist?
		name="ResultSetView"
		while name in [layer.name() for layer in getQgisVectorLayers()]:
			name+="_2"
		#Format geometry: ( avoid unix bug )
		geometry=self.geomType.lower()
		if geometry=="point":
			geometry='Point'
		elif geometry=='polygon':
			geometry='Polygon'
		elif geometry=='linestring':
			geometry='LineString'
		elif geometry=='multipoint':
			geometry='MultiPoint'
		elif geometry=='multilinestring':
			geometry='MultiLineString'
		elif geometry=='multipolygon':
			geometry='MultiPolygon'
		else:
			pop_up_error('Incorrect geometry type: %s'%geometry,self)
			return
		# create temporary layer
		vl = QgsVectorLayer(geometry, name, "memory")
		if not vl.isValid():
			#raise IOError, 'Impossible to create a memory layer in QGIS'
			pop_up_error('Impossible to create a memory layer in QGIS',self)
			return
		pr = vl.dataProvider()

		# add fields
		attrs=[]
		for i,val in enumerate(self.header):
			if self.types[i] in (StringType,NoneType):
				attr=QgsField(val, QtCore.QVariant.String)
			elif self.types[i] in (IntType,BooleanType):
				attr=QgsField(val, QtCore.QVariant.Int)
			else:
				attr=QgsField(val, QtCore.QVariant.Double)
			attrs.append(attr)

		pr.addAttributes( attrs )
		try:
			vl.updateFieldMap()
		except:
			print 'Old QGIS API version' 
		features=[]
		for i,row in enumerate(self.data):
			# add a feature
			fet = QgsFeature()
			fet.setGeometryAndOwnership(row[self.geometryColumn],len(row[self.geometryColumn])) #set geometry from wkb
			attr_map=dict() #attribute map dictionnary
			rowattr=[val for idx,val in enumerate(row) if idx!=self.geometryColumn]
			for j,val in enumerate(self.header): # create attribute map for current geometry
				if j!=self.geometryColumn:
					attr_map[j]=QtCore.QVariant(val)
			fet.setAttributeMap( attr_map )
			features.append(fet)
		pr.addFeatures( features )
		# update layer's extent when new features have been added
		# because change of extent in provider is not propagated to the layer
		vl.updateExtents()


		# add layer to the registry
		QgsMapLayerRegistry.instance().addMapLayer(vl)
