# -*- coding: iso-8859-15 -*-
"""
/***************************************************************************
 QspatiaLiteDialog
                                 A QGIS plugin
 SpatiaLite GUI for SpatiaLite
                             -------------------
        begin                : 2011-03-15
        copyright            : (C) 2011 by riviere
        email                : romain.riviere.974@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import *
from PyQt4 import QtCore, QtGui
import time
from Utility_functions import * # import common functions
#import all defined classes
from Classes.Database import *
#from Classes.SqlTable import *
from Classes.ResultModel import *
from Classes.TreeMenu import *
from importQgis.importQgis import *
from importOgr.importOgr import *
from exportOgr.exportOgr import *
import highlighter#syntax highlighter for QtextEdit
from ui_qspatialite import Ui_QspatiaLite #import GUI
import resources #initialize qt resource from ressource.py

class QspatiaLiteApp(QtGui.QDialog):
	"""QSpatiaLite Application Class"""	
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self)
	# Set up the user interface from Designer.
		self.ui = Ui_QspatiaLite()
		self.ui.setupUi(self)
		#Gui Syntax highlighter
		SQLhighlighter = highlighter.MyHighlighter( self.ui.SQLeditor, "Classic" )
	# Configure user interface
		#resultset viewer config: select entire rows
		self.ui.tableView.setSelectionBehavior(QtGui.QAbstractItemView.SelectRows);
		self.ui.tableView.setDragEnabled(True)
		#Advance query editor query historic
		self.last_query=None
		#Gui TABS:
		self.SQLeditor = self.ui.tabWidget.widget(0)
		self.result = self.ui.tabWidget.widget(1)
		#GUI SQL options:
		self.sqlOptions=['','Load in QGIS as Spatial Layer','Create Table & Load in QGIS','Create Spatial Table & Load in QGIS','Create View & Load in QGIS','Create Spatial View & Load in QGIS']
		self.ui.option.insertItems(0,self.sqlOptions)
		#GUI tablename and geomfield
		self.ui.tablename.setEnabled(False)
		self.ui.geomfield.setEnabled(False)
	#Application variables
		self.db=None #active DB object
		self.resultset=ResultModel([],[])
		self.historic=dict() #Query historic
		self.historic['queries']=[]
		self.historic['capacity']=10
		self.historic['position']=-1
	#Application configuration
		# 1) List available DB
		self.connections=listConnexions()
		if len(self.connections['path'])<=0: # pas de connexion
			self.newDB() #create new one
		else: 
			self.ui.db.insertItems(0,self.connections['name'])
			if self.connections['idx']!=-1:
				self.ui.db.setCurrentIndex(self.connections['idx'])
			# 2) Connect to default DB (or first one or no one if no connection) and draw treeview
			self.changeDb(max(0,self.connections['idx']))
		
	# SIGNAL/SLOT connections:
		#Option selection
		QtCore.QObject.connect(self.ui.option,QtCore.SIGNAL("currentIndexChanged(int)"),self.selectOption)
		#Change DataBase
		QtCore.QObject.connect(self.ui.db,QtCore.SIGNAL("currentIndexChanged(int)"),self.changeDb)
		#Vacuum db
		QtCore.QObject.connect(self.ui.vacuum,QtCore.SIGNAL("clicked(bool)"),self.db.vacuum)
		#Open/create new db
		QtCore.QObject.connect(self.ui.addDb,QtCore.SIGNAL("clicked(bool)"),self.newDB)
		#removedb db
		QtCore.QObject.connect(self.ui.delDb,QtCore.SIGNAL("clicked(bool)"),self.removeDB)
		#Execute Query
		QtCore.QObject.connect(self.ui.runSQL,QtCore.SIGNAL("clicked(bool)"),self.runQuery)
		#Load query Builder
		QtCore.QObject.connect(self.ui.sqleditor,QtCore.SIGNAL("clicked(bool)"),self.loadQueryBuilder)
		#Import Qgis Layer
		QtCore.QObject.connect(self.ui.qgis,QtCore.SIGNAL("clicked(bool)"),self.importQgis)
		#Import Ogr Layer
		QtCore.QObject.connect(self.ui.importogr,QtCore.SIGNAL("clicked(bool)"),self.importOgr)
		#Export Ogr Layer
		QtCore.QObject.connect(self.ui.exportogr,QtCore.SIGNAL("clicked(bool)"),self.exportOgr)
		#Export Txt Layer
		QtCore.QObject.connect(self.ui.exporttxt,QtCore.SIGNAL("clicked(bool)"),self.exportTxt)
		#Choose Next/previous query in historic
		QtCore.QObject.connect(self.ui.previous,QtCore.SIGNAL("clicked(bool)"),self.previousQuery)
		QtCore.QObject.connect(self.ui.next,QtCore.SIGNAL("clicked(bool)"),self.nextQuery)
	#Double click on treeview
		QtCore.QObject.connect(self.ui.treeView,QtCore.SIGNAL("doubleClicked(const QModelIndex &)"),self.treeDoubleClick)
	#right clic menu for tree
		self.ui.treeView.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
		QtCore.QObject.connect(self.ui.treeView,QtCore.SIGNAL("customContextMenuRequested(const QPoint &)"),self.treeRightClic)
	#right clic menu for resultview
		self.ui.tableView.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
		QtCore.QObject.connect(self.ui.tableView,QtCore.SIGNAL("customContextMenuRequested(const QPoint &)"),self.resultRightClic)
		
	def selectOption(self,index):
		"""Activate/Desactivate tablename and geomfield fields depending on user option choice"""
		if index == 0: # no option
			self.ui.geomfield.setEnabled(False)
			self.ui.tablename.setEnabled(False)
		elif index in (2,4): #table,view
			self.ui.geomfield.setEnabled(False)
			self.ui.tablename.setEnabled(True)
		else: #spatial table,view
			self.ui.geomfield.setEnabled(True)
			self.ui.tablename.setEnabled(True)
			#Special SQL syntax for Spatial View
			if index==5 and str(self.ui.SQLeditor.toPlainText())=='':
				sql="SELECT ROWID as ROWID, Geometry as Geometry\n"
				sql=sql+" "+unicode(self.ui.SQLeditor.toPlainText())
				self.ui.SQLeditor.setPlainText(sql)
		
	def changeDb(self,index):
		"""Set selected DataBase (index from ui 'db' combobox signal) as current DataBase and reload treeView Model"""
#		if index==1:
#			return
		# 1) Connect to selected DataBase
		self.db=Database(self.connections['path'][index])
		# 2) Set current DB as default in Qgis settings
		settings=QtCore.QSettings()
		settings.setValue('/SpatiaLite/connections/selected',self.db.name+'@'+self.db.path)
		# 3) Draw treeview for current DataBase
		self.drawTreeView()
		return True
		
	def drawTreeView(self):
		"Draw treeView to see DB change"
		model=self.db.createTreeModel()
		self.ui.treeView.setModel(model)
		self.ui.treeView.setExpanded(model.index(0, 0),True)
		return True
	
	def runQuery(self):
		"""Execute query from SQLeditor with the given option (default= no option if SQL doesn't begins with SELECT) """
		# 1) Retrieve SQL query from SQLeditor
		query=unicode(self.ui.SQLeditor.toPlainText()).strip()
		# 2) Query pre-treatment: ignore null and remove last ; eventually
		if query=='':
			return False
		QtGui.QApplication.setOverrideCursor(QtCore.Qt.WaitCursor) #wait cursor
		if query[-1]==';':
			query=query[:-1]
		# 3) save in historic and Execute query with the chosen option
		option=self.ui.option.currentIndex()
		tablename=unicode(self.ui.tablename.text()).strip()
		geomfield=unicode(self.ui.geomfield.text()).strip()
		self.ui.option.setCurrentIndex(0)
		self.addQueryToHistoric(query)
			#execute query:
		if option == 0 or query[:6].upper()!='SELECT':
			#Simple query execution and draw results in tableView
				#Execute Query
					# start clock:
				start=time.clock()
				header,data=self.db.executeQuery(query)
				stop=time.clock()
				elapsed_time=int(round(stop-start,3)*1000)
				self.ui.time.setText("Elapsed Time: %s ms" %elapsed_time)
				#Create model to display resultset
				self.resultset=ResultModel(data,header)
				nbRows=self.resultset.rowCount()
				#Focus on result tab widget and Load resultSet
				self.ui.tabWidget.setCurrentWidget(self.result)
				self.ui.tableView.setModel(self.resultset)
				self.ui.rows.setText('%s rows'%nbRows)
				#Redraw treeview in case of DB change
				self.drawTreeView()
				QtGui.QApplication.restoreOverrideCursor()
				return True
		elif option == 1:
			#Load in QGIS as a geometric layer
			loadInQGIS_spatial(self,self.db,query,geomfield,tablename)
			QtGui.QApplication.restoreOverrideCursor()
			return
		elif option in (2,3,4,5):
			#Create table and Load in QGIS
			if option == 3:
				#spatial table
				tablename=createTable(self,self.db,query,tablename,geomfield)
			elif option == 2:
				tablename=createTable(self,self.db,query,tablename)
			#Create view and Load in QGIS
			elif option==5:
				#spatial view
				tablename=createView(self, self.db,query,tablename,geomfield)
			else:
				tablename=createView(self,self.db,query,tablename)
			if not tablename:
				QtGui.QApplication.restoreOverrideCursor()
				return
			#Redraw treeview to see new DB
			self.drawTreeView()
			#Load table object into QGIS
			table=[table for table in self.db.tables if table.name.upper()==tablename.upper()]
			if len(table)!=1:
				pop_up_error("Can't find table '%s'"%tablename,self)
				return
			table[0].loadToQgis()
			QtGui.QApplication.restoreOverrideCursor()
			return
			
	def addQueryToHistoric(self, query):
		"""Save query into historic list"""
		if query in self.historic['queries']:
			return
		self.historic['queries'].append(query)
		nbQueries=len(self.historic['queries'])
		if nbQueries>self.historic['capacity']:
			self.historic['queries']=self.historic['queries'][1:]
		self.historic['position']=nbQueries-1
	def nextQuery(self):
		"""Show next query if possible"""
		nbQueries=len(self.historic['queries'])
		if nbQueries<1:
			return #No historic
		self.historic['position']=min(self.historic['position']+1,nbQueries-1)
		self.ui.SQLeditor.setPlainText(self.historic['queries'][self.historic['position']])
		self.ui.tabWidget.setCurrentWidget(self.SQLeditor)
	def previousQuery(self):
		"""Show next query if possible"""
		nbQueries=len(self.historic['queries'])
		if nbQueries<1:
			return #No historic
		self.historic['position']=max(self.historic['position']-1,0)
		self.ui.SQLeditor.setPlainText(self.historic['queries'][self.historic['position']])
		self.ui.tabWidget.setCurrentWidget(self.SQLeditor)

	def treeRightClic(self,position):
		"""Right Clic menu for treeView widget"""
		#retrieve item behind right clic
		item=self.ui.treeView.indexAt(position).data(32).toPyObject()
		parentItem=self.ui.treeView.indexAt(position).parent().data(32).toPyObject()
		#Load contextual menu for tree view
		self.Tmenu=TreeMenu(self,item,parentItem)

	def resultRightClic(self,position):
		"""Right Clic menu for resultset tableview"""
		#retrieve selected rows
		selection=self.ui.tableView.selectionModel()  # selection Model (QItemSelectionModel)
		if not selection:
			return False
		indexes = selection.selectedRows() # QModelIndexList -> liste des lignes selectionnées, 1ere colonne
		rows = [index.row() for index in indexes]  # liste des lignes selectionnées (integer)
		#Load contextual menu for tree view
		self.Tmenu=TreeMenuResult(self,rows)

	def treeDoubleClick(self,obj):
		"""Double click on treeview load item in sql window"""
		#retrieve item behind right clic
		item=obj.data(32).toPyObject()
		parentItem=obj.parent().data(32).toPyObject()
		if not (isinstance(item, Table) or isinstance(item, Column)):
			return #only for tables and columns
		#Add txt into sql window
		self.ui.tabWidget.setCurrentWidget(self.SQLeditor) #Focus on sql window
		if isinstance(item,Table):
			self.ui.SQLeditor.insertPlainText(' "%s" '%item.name) #Add Table name
		else:
			self.ui.SQLeditor.insertPlainText(''' "%s".'%s' '''%(parentItem.name, item.name))
		return
		
		
	def loadTableToQgis(self):
		"""Load selected table from menu right clic to QGIS"""
		self.TmenuItem.loadToQgis()
		
	def loadQueryBuilder(self):
		"""Load Advance SQL Query Editor"""
		from querybuilder.querybuilder import querybuilder
		self.querybuilder = querybuilder(self)
		self.querybuilder.setModal(True)
		self.querybuilder.show()

	def newDB(self):
		"""Open a new DataBase (create an empty one if file doesn't exists) and set as default DB"""
		#path and name of new db
		path = QtGui.QFileDialog.getSaveFileName(self, "New DB","myDB.sqlite","Spatialite (*.sqlite)")
		if path.isEmpty():
			return
		#create Spatialite database
		try:
			db=Database(unicode(path))
			self.db=db
		except:
			pop_up_error("Impossible to connect to selected DataBase",self)
			return
		#initialise spatial db:
		self.db.executeQuery("SELECT initspatialmetadata()")
		#create SpatiaLite Connexion in QGIS QSettings
		settings=QtCore.QSettings()
		settings.beginGroup('/SpatiaLite/connections')
		settings.setValue(u'%s/sqlitepath'%db.name,'%s'%db.path)
		settings.endGroup()
		#reload connexion combobox
		self.connections=listConnexions()
		self.ui.db.clear()
		self.ui.db.insertItems(0,self.connections['name'])
		#Get index of new DB and make DB combobox point to this index
		idx=[index for index,name in enumerate(self.connections['name']) if name==db.name]
		idx=idx[0]
		self.ui.db.setCurrentIndex(idx)
		self.drawTreeView()

	def removeDB(self):
		"""Remove current DataBase link from QGIS Qsetting"""
		if len(self.connections['name'])<=1: #avoid to remove all DBs
			pop_up_info('You must have at least a DB connexion to get QSpatiaLite work. You should not remove this link before opening/creating a new DB',self)
			return
		reponse=QtGui.QMessageBox.question(self, "Remove DB link","Do you really want to remove the link to this DataBase: %s ? \n(This will not REMOVE your DataBase from your computer, just from QGIS/QSpatiaLite)"%self.db.name, QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
		if reponse==QtGui.QMessageBox.No:
			return
		#remove currentDB from Qsetting
		settings=QtCore.QSettings()
		settings.remove('/SpatiaLite/connections/%s'%self.db.name)
		settings.endGroup()
		#List available DB
		self.ui.db.clear()
		self.connections=listConnexions()
		self.ui.db.insertItems(0,self.connections['name'])
		#Connect to first db
		self.changeDb(0)
		
	def importQgis(self):
		"""Call Import QGIS Layers Dialog"""
		self.app=ImportQgisLayers(self)
		self.app.show()
		
	def importOgr(self):
		"""Call Import OGR Layers Dialog"""
		self.app=ImportOgrLayers(self)
		self.app.show()
		
	def exportOgr(self):
		"""Call Export to Ogr Layers Dialog"""
		self.app=ExportOgrLayers(self)
		self.app.show()
		
	def exportTxt(self):
		"""Call Export to TXT Layers Dialog"""
		self.app=ExportOgrLayers(self,spatial=False)
		self.app.show()

