from ui_importQgis import Ui_importQgisLayers #import GUI
from ..Utility_functions import * # import common functions
from ..Classes.dialogSRS import GdalToolsSRSDialog as srsdialog
from PyQt4 import QtCore, QtGui
from qgis.core import *

class ImportQgisLayers(QtGui.QDialog):
	"""Import QGIS Layers into SpatiaLite DataBase"""	
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self)
	# Set up the user interface from Designer.
		self.ui = Ui_importQgisLayers()
		self.ui.setupUi(self)
	#Set app variables
		self.srsdialog=srsdialog
		self.parent=parent
		self.layerlist=getQgisVectorLayers()
	#Draw Layer List
		for layer in self.layerlist:
			self.ui.listView.addItem(layer.name())

		
		QtCore.QObject.connect(self.ui.upload,QtCore.SIGNAL("accepted()"),self.run)
		QtCore.QObject.connect(self.ui.chooseSRID,QtCore.SIGNAL("clicked(bool)"),self.browseSRID)
		
	def browseSRID(self):
		dialog = self.srsdialog( "Select desired SRID" )
		if dialog.exec_():
			self.ui.SRID.setText(dialog.getProjection())

	def run(self):
		'''Import selected layer into current DB'''
		#get selected layers
		self.layers=[data.text() for data in self.ui.listView.selectedItems()]
		self.layers=[layer for layer in self.layerlist if layer.name() in self.layers]
		if len(self.layers)==0:
			pop_up_info('No Layers Selected',self)
			return
		#Get destination SRID if specified by user
		if self.ui.setSRID.isChecked() and unicode(self.ui.SRID.text()).strip()!='':
			try:
				self.srid=int(self.ui.SRID.text())
				Qsrid = QgsCoordinateReferenceSystem()
				Qsrid.createFromEpsg(self.srid)
				if not Qsrid.isValid(): #check if crs is ok
					pop_up_error("Destination SRID isn't valid",self)
					return False
			except:
				pop_up_error("SRID must be Integer",self)
				return
		else:
			self.srid=None
		QtGui.QApplication.setOverrideCursor(QtCore.Qt.WaitCursor)
		#Only upload selected values ?
		self.selected=self.ui.importSelected.isChecked()
		#User want to use a prefix ?
		prefix=unicode(self.ui.prefix.text()).strip()
		if self.ui.setPrefix.isChecked() and prefix!='':
			self.tablenames=['%s_%s'%(prefix,layer.name()) for layer in self.layers]
		else:
			self.tablenames=[layer.name()for layer in self.layers]
		#Import selected layers
		for i,layer in enumerate(self.layers):
			if not self.parent.db.uploadQgisVectorLayer(layer, tableName=self.tablenames[i], srid=self.srid, selected=self.selected):
				pop_up_error("Impossible to import Layer: %s"%layer.name(),self)
		self.parent.drawTreeView()
		QtGui.QApplication.restoreOverrideCursor()
		pop_up_info("Import Done",self)
