class Column():
	"""Column object: created from parameters (array: id, column name, data type, whether or not the column can be NULL, the default value for the column, primary key"""
	def __init__(self, params, parent):
		self.parent=parent
		self.name=params[1]
		self.type=params[2]
		self.pk=params[5]
		#used by Table
		self.geo=False
		self.spIdx=False
		
	def getIcon(self):
		"""Get icon path for current column"""
		if self.geo and self.spIdx:
			return ":/plugins/QspatiaLite/icons/spatialidx.xpm"
		elif self.geo and not self.spIdx:
			return ":/plugins/QspatiaLite/icons/geometry.xpm"
		elif self.pk==1:
			return ":/plugins/QspatiaLite/icons/pkey.xpm"
		return ":/plugins/QspatiaLite/icons/column.xpm"		
