from PyQt4 import QtCore, QtGui
from qgis.core import *

def pop_up_error(msg='',parent=None):
	"""Display an error message via Qt box"""
	QtGui.QMessageBox.warning(parent, 'error', '%s' % (msg))
	
def pop_up_info(msg='',parent=None,):
	"""Display an info message via Qt box"""
	QtGui.QMessageBox.information(parent, 'Information', '%s' % (msg))
	
def getQgisVectorLayers():
	"""Return list of all valid QgsVectorLayer in QgsMapLayerRegistry"""
	layermap = QgsMapLayerRegistry.instance().mapLayers()
	layerlist = []
	for name, layer in layermap.iteritems():
		if layer.isValid() and layer.type() == QgsMapLayer.VectorLayer:
				layerlist.append( layer )
	return layerlist
	
def listConnexions():
	"""List SpatiaLite connexion stored in QGIS settings, and return dict with keys: path (list),name(list) and index (int) of last used DB (index) (-1 by default)"""
	res=dict()
	res['idx']=-1
	settings=QtCore.QSettings()
	settings.beginGroup('/SpatiaLite/connections')
	res['name'] = [unicode(item) for item in settings.childGroups()]
	res['path'] = [unicode(settings.value(u'%s/sqlitepath'%unicode(item)).toString()) for item in settings.childGroups()]
	settings.endGroup()
	#case: no connection available
	if len(res['name'])==0:
		pop_up_info("You apparently haven't defined any database connections yet.\n\n With SpatiaLite, you can create a new spatial database and/or connecting to an existing one by clicking on 'New DB' button.\n\n (To connect to an existing DB, ignore the replace warning: your DB will not be replaced by a new empty one)")
	else:
		#case: connetions available
		#try to select directly last opened dataBase ()
		try:
			lastDB=settings.value(u'/SpatiaLite/connections/selected').toString()
			lastDB=lastDB.split('@',1)[1]
			#get last connexion index
			res['idx'] = res['path'].index(lastDB)
		except:
			pass
	return res

def createView(parent, db,query,tablename='',geomfield=''):
	"""Create view (optionally spatial view) from a query and return tablename"""
	if tablename=='':
		tablename='SQLquery'
	#create view
	db.executeQuery('CREATE VIEW %s AS %s'%(tablename,query))
	if geomfield=='':
		return tablename
	#Create Spatial view if geomfield is provided
	#Update Db information: get new table info
	db.getTables()
	view=[table for table in db.tables if table.name.upper()==tablename.upper() and table.type=='view']
	#Test if new table really exists
	if len(view)!=1:
		pop_up_error('Unable to read table: %s\nOperation cancelled'%tablename)
		return False
	#Check if geomfield really is a field from this view
	view_geocol=[column.name for column in view[0].columns if column.name.upper()==geomfield.upper()]
	if len(view_geocol)!=1:
		db.executeQuery("""DROP VIEW IF EXISTS "%s" """%tablename)
		pop_up_error('"%s" field doesn\'t exist in your query. Please try with other field name'%geomfield,parent)
		return False
	#Get real field (case sensitive):
	geomfield=view_geocol[0]
	#ask infos concerning source geometry column
		#List all valid spatial fields: table.field
	srcList=["%s.%s"%(table.name,table.geo[0]) for table in db.tables if table.geo!=False and table.type=='table']
		#Let user select source geometry field
	(refTable, ok) = QtGui.QInputDialog.getItem (parent, 
		        "Source geometry Table and Field:", 
		        "Name:",srcList)
	if (not ok) or refTable=='':
		db.executeQuery("""DROP VIEW IF EXISTS "%s" """%tablename)
		pop_up_error('Impossible to create a spatial view if user doesn\'t provide source geometry field',parent)
		return False
	refField=unicode(refTable.split(".")[1])
	refTable=unicode(refTable.split(".")[0])
	#recover geometry column			
	db.executeQuery( "INSERT INTO views_geometry_columns (view_name, view_geometry, view_rowid, f_table_name, f_geometry_column) VALUES (?, ?, 'ROWID', ?, ?)",(tablename,geomfield,refTable,refField),commit=True)
	return tablename
	
	
def createTable(parent,db,query,tablename='',geomfield=''):
	"""Create table in database from a query and return tablename -automatically replace/create PKUID field and optionnaly recover geometry column"""
	if tablename=='':
		tablename='SQLquery'
	tmpTablename="%s_tmp"%tablename
	#create table tmp
	db.executeQuery('CREATE TABLE %s AS %s'%(tmpTablename,query))
	#get new temp table columns
	db.getTables()
	tmpTable=[table for table in db.tables if table.name.upper()==tmpTablename.upper()]
	if len(tmpTable)!=1:
		pop_up_error('Unable to read temp table: %s\nOperation cancelled'%tmpTablename,parent)
		return False
	cols=[column.name for column in tmpTable[0].columns]
	#remove PKUID if column already exists
	for idx,col in enumerate(cols):
		if col.upper()=='PKUID':
			del cols[idx]
	#Field creation query for new table
	fieldsCreation="""PKUID integer primary key autoincrement,"%s" """%'","'.join(cols)
	#Create new Table with PKUID primary key
	db.executeQuery("""CREATE TABLE "%s" (%s)"""%(tablename,fieldsCreation))
	#Populate new table
	db.executeQuery("""INSERT INTO "%s" ("%s") SELECT %s FROM "%s" """%(tablename,'","'.join(cols),','.join(['"%s"."%s"'%(tmpTablename,col) for col in cols]),tmpTablename),commit=True)
	if geomfield!='':
		# check if geomField really belongs to tableFields and get real name (case sensitive)
		ok=False
		for col in cols:
			if col.upper()==geomfield.upper():
				geomField=col
				ok=True
				break # geomfield really exists and name is now correct
		if not ok:
			pop_up_error('"%s" field doesn\'t exist in your query. Please try with other field name'%geomfield,parent)
			#Delete table before exiting
			db.executeQuery("""DROP TABLE IF EXISTS "%s" """%tablename,commit=True)
			db.executeQuery("""DROP TABLE IF EXISTS "%s" """%tmpTablename,commit=True)
			return
		#get table srid and geometry type
		header,data=db.executeQuery('''
		    SELECT DISTINCT srid, geomType 
		    FROM (
		        SELECT SRID(a."%s") AS srid, GeometryType(a."%s") AS geomType 
		        FROM "%s" as a
		    )
		    ''' % (geomfield, geomfield, tmpTablename) )
		if len(data)!=1:
			pop_up_error("'%s' Doesn't correspond to a geometry field, try with another field name'",parent)
			#Delete table before exiting
			db.executeQuery("""DROP TABLE IF EXISTS "%s" """%tablename,commit=True)
			db.executeQuery("""DROP TABLE IF EXISTS "%s" """%tmpTablename,commit=True)
			return
		srid=data[0][0]
		geomType=data[0][1]
		header,data=db.executeQuery('SELECT RecoverGeometryColumn(?, ?, ?, ?, 2)',(tablename, geomfield, srid, geomType,))
		if data[0][0]!=1:
			pop_up_info('Unable to transform "%s" into a valid geometry column'%geomfield,parent)
	#Drop temp table
	db.executeQuery("""DROP TABLE IF EXISTS "%s" """%tmpTablename,commit=True)
	return tablename

def loadInQGIS_spatial(parent,db, query,geocol,tablename=''):
	"""Load query to QGIS Canvas (spatial layers)"""
	if tablename == '':
		tablename = 'SQLresult'
	#Prepare URI()
	uri = QgsDataSourceURI()
	uri.setDatabase(db.path)
	uri.setDataSource('', "(%s)" %query, "%s"%geocol, '',"ROWID")
	layer=QgsVectorLayer(uri.uri(), tablename, 'spatialite')
	#Test layer validity
	if not layer.isValid():
		pop_up_error("The result can't be Loaded into QGIS. Remember to alias your columns according to the name asked in the 'Geometry field'",parent)
		return False
	QgsMapLayerRegistry.instance().addMapLayer(layer)
	return True
