from ui_importOgr import Ui_importOgrLayers #import GUI
from ..Utility_functions import * # import common functions
from ..Classes.dialogSRS import GdalToolsSRSDialog as srsdialog
from PyQt4 import QtCore, QtGui
import os.path
from qgis.core import *
import locale

class ImportOgrLayers(QtGui.QDialog):
	"""Import OGR Layers into SpatiaLite DataBase"""
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self)
	# Set up the user interface from Designer.
		self.ui = Ui_importOgrLayers()
		self.ui.setupUi(self)
	#Set app variables
		self.charset= [locale.getdefaultlocale()[1],'ISO-8859-15','ISO-8859-1', 'ISO-8859-2', 'UTF-8', 'CP1250']
		self.ui.charset.insertItems(0,self.charset)
		self.ui.charset2.insertItems(0,self.charset)
		self.srsdialog=srsdialog
		self.parent=parent
		self.ogrFilter="DBF [OGR] (*.dbf *.DBF);;"+QgsProviderRegistry.instance().fileVectorFilters()
		self.model=MyTableModel([],['File','Name','SRID','Charset'])
		self.ui.filelist.setModel(self.model)
		
	#Qt Slot and signals
		#Browse Files
		QtCore.QObject.connect(self.ui.browseFile,QtCore.SIGNAL("clicked(bool)"),self.browseFile)
		QtCore.QObject.connect(self.ui.browseFiles,QtCore.SIGNAL("clicked(bool)"),self.browseFiles)
		#Select SRID
		QtCore.QObject.connect(self.ui.browseSRID,QtCore.SIGNAL("clicked(bool)"),self.browseSRID)
		QtCore.QObject.connect(self.ui.browseSRID2,QtCore.SIGNAL("clicked(bool)"),self.browseSRID2)
		#addFile
		QtCore.QObject.connect(self.ui.add,QtCore.SIGNAL("clicked(bool)"),self.addFile)
		QtCore.QObject.connect(self.ui.addmulti,QtCore.SIGNAL("clicked(bool)"),self.addFiles)
		#remove files
		QtCore.QObject.connect(self.ui.clearSelection,QtCore.SIGNAL("clicked(bool)"),self.clearSelected)
		QtCore.QObject.connect(self.ui.reset,QtCore.SIGNAL("clicked(bool)"),self.clear)
		#Validate operation
		QtCore.QObject.connect(self.ui.upload,QtCore.SIGNAL("accepted()"),self.validate)
		
	def browseSRID(self):
		"""Open SRS Dialog and retreive SRID"""
		dialog = self.srsdialog( "Select desired SRID" )
		if dialog.exec_():
			self.ui.SRID.setText(dialog.getProjection())
	def browseSRID2(self):
		"""Open SRS Dialog and retreive SRID"""
		dialog = self.srsdialog( "Select desired SRID" )
		if dialog.exec_():
			self.ui.SRID2.setText(dialog.getProjection())
			
	def browseFile(self):
		"""Browse single ogr file"""
		self.ui.singleFile.setText('')
		filename = QtGui.QFileDialog.getOpenFileName(self, "Select OGR Layer","",self.ogrFilter)
		if filename.isEmpty():
			return
		self.ui.singleFile.setText(filename)
		name=os.path.splitext(os.path.basename(unicode(filename)))[0]
		self.ui.name.setText(name)

	def browseFiles(self): 
		"""Browse several ogr files"""
		self.ui.multifiles.setText('')
		fileNames = QtGui.QFileDialog.getOpenFileNames(self, \
			QtCore.QString.fromLocal8Bit("Select layers:"),"", self.ogrFilter )
		if fileNames.count()<=0:
			return
		fileNames=[unicode(name) for name in fileNames]
		self.ui.multifiles.setText(','.join(fileNames))
		
	def addFile(self):
		"""Add single file to selection"""
		path=unicode(self.ui.singleFile.text()).strip()
		name=unicode(self.ui.name.text()).strip()
		charset=unicode(self.ui.charset.currentText())
		if '' in (path,name,unicode(self.ui.SRID.text()).strip()):
			pop_up_info('All fields are necessary\nIn order to import non spatial layers, enter SRID=0',self)
			return
		try:
			SRID=int(self.ui.SRID.text())
		except:
			pop_up_error('SRID must be integer\nIn order to import non spatial layers, enter SRID=0',self)
			return
		#Update Model with new Data
		header=self.model.headerdata
		data=self.model.arraydata
		if '%s'%name in [name for path,name,srid,charset in data]:
			pop_up_info('Table with name "%s" is already listed'%name,self)
			return
		data.append(['%s'%path,'%s'%name,'%s'%SRID,'%s'%charset])
		self.model=MyTableModel(data,header)
		self.ui.filelist.setModel(self.model)
		
	def addFiles(self):
		"""Add several files to selection"""
		charset=unicode(self.ui.charset2.currentText())
		paths=unicode(self.ui.multifiles.text()).strip().split(',')
		if len(paths)<=0 or unicode(self.ui.SRID2.text()).strip()=='':
			pop_up_info('All fields are necessary\nIn order to import non spatial layers, enter SRID=0',self)
			return
		try:
			SRID=int(self.ui.SRID2.text())
		except:
			pop_up_error('SRID must be integer\nIn order to import non spatial layers, enter SRID=0',self)
			return
		#Add prefix to names eventually
		prefix=unicode(self.ui.prefix.text()).strip()
		if self.ui.setPrefix.isChecked() and prefix!='':
			names=["%s_%s"%(prefix,os.path.splitext(os.path.basename(path))[0]) for path in paths]
		else:
			names=[os.path.splitext(os.path.basename(path))[0] for path in paths]
		#Update Model with new Data
		header=self.model.headerdata
		data=self.model.arraydata
		for idx,tabname in enumerate(names):
			if tabname in [name for path,name,srid, charset in data]:
				pop_up_info('Table with name "%s" is already listed'%name,self)
				return
			data.append(['%s'%paths[idx],'%s'%tabname,'%s'%SRID,'%s'%charset])
		self.model=MyTableModel(data,header)
		self.ui.filelist.setModel(self.model)
		
	def clear(self):
		"""clean model"""
		self.model=MyTableModel([],self.model.headerdata)
		self.ui.filelist.setModel(self.model)
		
	def clearSelected(self):
		"""Clean Selected Rows"""
		indexes=self.ui.filelist.selectionModel().selection().indexes()
		selectedRows=[] #rownumber
		for i in range(len(indexes)):
			index = indexes[i]
			selectedRows.append(index.row())
		data=[val for idx,val in enumerate(self.model.arraydata) if idx not in selectedRows]
		self.model=MyTableModel(data,self.model.headerdata)
		self.ui.filelist.setModel(self.model)
		
	def validate(self):
		"""Import Layers to Spatial DB"""
		if len(self.model.arraydata)<=0:
			return
		for item in self.model.arraydata:
			if not self.parent.db.importGisFile( item[0], item[1], int(item[2]),item[3]):
				pop_up_error("Unable to Import Table: '%s'"%item[0],self)
		pop_up_info('Import Done',self)
		self.parent.drawTreeView()
		return True

class MyTableModel(QtCore.QAbstractTableModel): 
	def __init__(self, datain, headerdata, parent=None, *args): 
		""" datain: a list of lists
		headerdata: a list of strings
		"""
		QtCore.QAbstractTableModel.__init__(self, parent, *args) 
		self.arraydata = datain
		self.headerdata = headerdata
		self.parent=parent
 
	def rowCount(self, parent): 
		return len(self.arraydata) 
 
	def columnCount(self, parent): 
		if len(self.arraydata)==0:
			return 0
		return len(self.arraydata[0]) 
 
	def data(self, index, role): 
		if not index.isValid(): 
			return QtCore.QVariant() 
		elif role != QtCore.Qt.DisplayRole:
			return QtCore.QVariant() 
		val=self.arraydata[index.row()][index.column()]
		return QtCore.QVariant(QtCore.QString.fromUtf8(val))

	def headerData(self, section, orientation, role):
		if role != QtCore.Qt.DisplayRole:
			return QtCore.QVariant() 
		if orientation == QtCore.Qt.Vertical:
			# header for a row
			return QtCore.QVariant(section+1)
		else:
			# header for a column
			return QtCore.QVariant(QtCore.QString.fromUtf8(self.headerdata[section]))
