from Column import *
from Trigger import *
import os
from qgis.core import *
from ..Utility_functions import * # import common functions

class Table():
	"""Table object: created from parameters (array: name (0), type (1), geometry_column (2),
		geometry_column_type (3), geometry_dimension (4), srid (5), spatial_index_enabled (6), 			view_geometry_column (7) )"""
	def __init__(self,params,parent):
		self.parent=parent
		self.name=unicode(params[0])
		self.type=unicode(params[1])
		self.triggers=[]
		self.getTriggers()
		self.columns=[]
		self.getColumns()
		self.geo=False
		#Initialise geometry informations
		for column in self.columns:
			if self.type=="table" and column.name==params[2]:
					self.geo=[params[2],params[3],params[4], params[5]] # [name,type,dimension,srid]
					column.geo=True
					column.spIdx=params[6]
			elif self.type=="view" and column.name==params[7]:
					self.geo=[params[7],None,None,None] # [name,type,dimension,srid]
					column.geo=True
	def getTriggers(self):
		"""List all triggers attached to the current table"""
		header,data=self.parent.executeQuery("""SELECT name,sql FROM sqlite_master WHERE type = 'trigger' AND tbl_name = "%s" ORDER BY name"""%self.name)
		if len(data)<=0:
			return
		for trigger in data:
			item=Trigger(self,trigger[0],trigger[1])
			self.triggers.append(item)
		return
		
	def getColumns(self):
		"List columns for the current Table and Create the columns objects"
		query = 'PRAGMA table_info("%s")' % self.name
		header,data=self.parent.executeQuery(query)
		if not data:
			return
		for column in data:
			self.columns.append(Column(column,self))
			
	def getIcon(self):
		"""Get icon path for current Table"""
		if self.name in self.parent.systables:
			return ":/plugins/QspatiaLite/icons/systable.xpm"
		elif self.type=='table':
			if self.geo:
				if self.geo[1].upper() in ('POINT','MULTIPOINT'):
					return ":/plugins/QspatiaLite/icons/layer_point.png"
				elif self.geo[1].upper() in ('LINESTRING','MULTILINESTRING'):
					return ":/plugins/QspatiaLite/icons/layer_line.png"
				elif self.geo[1].upper() in ("POLYGON","MULTIPOLYGON","GEOMETRYCOLLECTION"):
					return ":/plugins/QspatiaLite/icons/layer_polygon.png"
		elif self.type=='view':
			if self.geo:
				return ":/plugins/QspatiaLite/icons/spatialview.png"
			else:
				return ":/plugins/QspatiaLite/icons/view.png"
				
		return ":/plugins/QspatiaLite/icons/table.png"
		
	def loadToQgis(self):
		"""Load table (spatial or non-spatial)in QGIS"""
		if self.geo==False:
			vlayer = QgsVectorLayer('dbname="%s" table="%s"'%(self.parent.path,self.name), '%s'%self.name, 'spatialite')
		else:
			uri = QgsDataSourceURI()
			uri.setDatabase(self.parent.path)
			uri.setDataSource('', "%s" %self.name, "%s"%self.geo[0], '',"ROWID")
			vlayer=QgsVectorLayer(uri.uri(), '%s'%self.name, 'spatialite')
			print uri.uri()
		if vlayer.isValid():
			QgsMapLayerRegistry.instance().addMapLayer(vlayer)
		else:
			pop_up_error("""Impossible to Load table '%s' into QGIS"""%self.name)
			return False
		
	def exportToOgr(self,folder,charset,format=u'ESRI Shapefile',srid=None,mapinfoCompatibility=True):
		"""Export Table to Ogr Format, with mapinfo date auto-conversion"""
		if self.geo==False:
			layer = QgsVectorLayer('dbname="%s" table="%s"'%(self.parent.path,self.name), '%s'%self.name, 'spatialite')
			Qsrid=None
		else:
			uri = QgsDataSourceURI()
			uri.setDatabase(self.parent.path)
			uri.setDataSource('', "%s" %self.name, "%s"%self.geo[0], '',"ROWID")
			layer=QgsVectorLayer(uri.uri(), '%s'%self.name, 'spatialite')
			#test srid:
			if srid is None:
				srid=self.geo[3]
			try:
				pop_up_info(srid)
				srid=int(srid)
			except:
				pop_up_error("Layer '%s': SRID must be integer"%self.name)
				return False
			Qsrid =QgsCoordinateReferenceSystem()
			Qsrid.createFromEpsg(srid)
			if not Qsrid.isValid():
				pop_up_error('SRID (%s) is not valid for table %s'%(srid,self.name))
				return False
		if not layer.isValid():
			pop_up_error("""Impossible to Load table '%s' into QGIS"""%self.name)
			return False
			
		#Set length for text fields
		provider=layer.dataProvider()
		fields=provider.fields()
		dateFieldNames=[] #mapinfo date fields
		for field in fields:
			fldname=unicode(fields[field].typeName()).upper()
			if format.lower()==u'mapinfo file' and fldname=='DATE' and mapinfoCompatibility==True: #MAPINFO Date Compatibility: export in TEXT(10)
				dateFieldNames.append(fields[field].name()) # store field name for further attribute transformation
				fields[field].setLength(10)

			elif fldname[0:5]=='TEXT(': #special for TXT: retrieve field length #mapinfo compatibility
				size=fldname.split('(')[1][:-1] #TEXT(size) -> size) -> size
				try:
					size=int(size)
					fields[field].setLength(size)
				except:
					pass #Field length not recognized
				

		#Write vector File
		os.chdir(r'%s'%folder)
            	writer= QgsVectorFileWriter(self.name, charset, fields, layer.wkbType(), Qsrid, format)
		if writer.hasError():
			pop_up_error("Can't save layer '%s' to hdd"%self.name)
			return False
		#MAPINFO COMPATIBILITY: converts DATE fields from 2010-02-11 to 11/02/2010
		idx_date_fields=[]
		for name in dateFieldNames:
			idx_date_fields.append(provider.fieldNameIndex(name)) 	
		#Copy Each feature to new Layer
		feat = QgsFeature()
		allAttrs = provider.attributeIndexes()
		provider.select(allAttrs)
		while provider.nextFeature(feat):
			#MApinfo compatibility: change date attribute from 2010-02-11 to 11/02/2010
			for id in idx_date_fields:
				attr=feat.attributeMap()
				date=unicode(attr[id].toString()) #get date as 2010-02-11
				newdate='%s/%s/%s'%(date[8:10],date[5:7],date[0:4])
				feat.changeAttribute(id,newdate)
			writer.addFeature(feat)
		del writer
		return True
