#Model for result widget: #http://www.saltycrane.com/blog/2007/12/pyqt-43-qtableview-qabstracttablemodel/
from PyQt4 import QtCore
from types import StringType, NoneType
import datetime
import operator
class ResultModel(QtCore.QAbstractTableModel): 
	def __init__(self, datain, headerdata, parent=None, *args): 
		""" datain: a list of lists
			headerdata: a list of strings
		"""
		QtCore.QAbstractTableModel.__init__(self, parent, *args) 
		self.arraydata = datain
		self.headerdata = headerdata
		self.geoCol=-1 # geometry column index, -1 in case of non geometric objects
		self.parent=parent
 
	def rowCount(self, parent): 
		return len(self.arraydata) 
 
	def columnCount(self, parent): 
		if len(self.arraydata)==0:
			return 0
		return len(self.arraydata[0]) 

	def data(self, index, role):
		if not index.isValid():
			return QtCore.QVariant()
		elif role != QtCore.Qt.DisplayRole:
			return QtCore.QVariant()
		val=self.arraydata[index.row()][index.column()]
		if type(val) == StringType:
			return QtCore.QVariant(QtCore.QString.fromUtf8(val))
		elif type(val) == NoneType:
			return QtCore.QVariant("NULL")
		elif isinstance(val, buffer):
			if self.geoCol==-1:
				self.geoCol=index.column() # Table is probably geometric
			return QtCore.QVariant('GeomObject')
		elif isinstance(val, datetime.datetime):
			return QtCore.QVariant(str(val))
		else:
			return QtCore.QVariant(val) 

	def headerData(self, section, orientation, role):
		if role != QtCore.Qt.DisplayRole:
			return QtCore.QVariant() 
		if orientation == QtCore.Qt.Vertical:
			# header for a row
			return QtCore.QVariant(section+1)
		else:
			# header for a column
			return QtCore.QVariant(QtCore.QString.fromUtf8(self.headerdata[section]))

	def sort(self, Ncol, order):
		"""Sort table by given column number.
		"""
		self.emit(SIGNAL("layoutAboutToBeChanged()"))
		self.arraydata = sorted(self.arraydata, key=operator.itemgetter(Ncol))        
		if order == QtCore.Qt.DescendingOrder:
		    self.arraydata.reverse()
		self.emit(SIGNAL("layoutChanged()"))

