from ..Utility_functions import * # import common functions
from qgis.core import *

class SqlTable():
	"""SqlTable class: table object used to display non geometric results in QGIS"""
	def __init__(self,db,query,tablename='SQLresult'):
		#Default QGIS layerName in case of no name
		if tablename=='':
			self.tablename='SQLresult'
		else:
			self.tablename=tablename
		self.db=db
		self.name=self.db.systables[0] #'__SqlResult' default name for the temporary dataBase
		self.query="CREATE TABLE '%s' AS %s"%(self.name,unicode(query))
		#drop temp table if already exists and commit
		self.db.executeQuery("DROP TABLE IF EXISTS %s"%self.name,commit=True)
		#Create temp table from sql and save Layer
		self.db.executeQuery(self.query,commit=True)
		#Check if temp table really exists:
		header,data=self.db.executeQuery("SELECT name FROM sqlite_master WHERE type='table' AND name=?",(self.name,))
		#Load result in QGIS
		if len(data)>0:
			self.loadToQgis()
		#Drop temp 
		self.db.executeQuery("DROP TABLE IF EXISTS '%s'"%self.name,commit=True)
		
	def loadToQgis(self):
		"""Load table in QGIS or display error msg"""
		#get table header (columns)
		header,data=self.db.executeQuery("SELECT * FROM %s LIMIT 1"%self.name)
		#create layer
		layer = QgsVectorLayer('dbname="%s" table="%s"'%(self.db.path,self.name), self.tablename, 'spatialite')
		#Test layer validity
		if not layer.isValid():
			pop_up_error("The result can't be Loaded into QGIS")
			return False
		#Add layer to QGIS canvas
		QgsMapLayerRegistry.instance().addMapLayer(layer)
		return True
