from pyspatialite import dbapi2 as sqlite #Load PySpatiaLite
from PyQt4 import QtCore, QtGui
from qgis.core import *
from ..Utility_functions import * # import common functions
import os.path
from Table import *

class Database():
	"""Database class: spatialite database object"""
	def __init__(self,path,provider="spatialite"):
		self.systables=["geom_cols_ref_sys","geometry_columns" ,"geometry_columns_auth" ,"spatial_ref_sys", "sqlite_sequence" ,"views_geometry_columns" ,"virts_geometry_columns","layer_params","layer_statistics",
"layer_sub_classes","layer_table_layout","pattern_bitmaps","symbol_bitmaps","project_defs","raster_pyramids",
"tableprefix_metadata","tableprefix_rasters" ,"sqlite_stat1","sqlite_stat2","spatialite_history"]
		self.path=unicode(path)
		self.name=os.path.basename(path)
		self.provider=unicode(provider)
		self.tables=[] #store table content (table, view, ...)
		self.connection()
		#self.getTables()
		
	def __str__(self):
		"""Return DB name when converted to String"""
		return self.name
		
	def connection(self):
		""" Create connexion if not yet connected and Return connexion object for the current DB"""
		try:
			return self.connectionObject
		except:
			try:
				self.connectionObject=sqlite.connect(self.path)
				return self.connectionObject
			except sqlite.OperationalError, Msg:
				pop_up_error("Can't connect to DataBase: %s\nError %s"%(self.path,Msg))
			 
			
	def executeQuery(self,query,params=(),commit=False):
		"""Execute query (string) with given parameters (tuple) (optionnaly perform commit to save Db) and return resultset [header,data] or [flase,False] if error"""
		query=unicode(query)
		self.queryPb=False
		header=[]
		data=[]
		cursor=self.connectionObject.cursor()
		try:
			cursor.execute(query,params)
			if (cursor.description is not None):
				header = [item[0] for item in cursor.description]
			data = [row for row in cursor]
			if commit:
				self.connectionObject.commit()
		except sqlite.OperationalError, Msg:
			self.connectionObject.rollback()
			#print "An error occured while executing query :\n",query,"\nError:\n",Msg
			pop_up_error("The SQL query seems to be invalid.\n\n%s" %Msg)
			self.queryPb=True #Indicates pb with current query
			
		return header,data
		
			
	def getTables(self):
		"""List tables and views from the current DB, and create one table object for each 				element """	
		self.tables=[]
		#select all tables and views from DB	
		query = """
		SELECT m.name, m.type, g.f_geometry_column, g.type, g.coord_dimension, g.srid, 			g.spatial_index_enabled, v.view_geometry
		FROM sqlite_master AS m 
		LEFT JOIN geometry_columns AS g ON m.name = g.f_table_name
		LEFT JOIN views_geometry_columns AS v ON m.name = v.view_name
		WHERE m.type in ('table', 'view') 
		ORDER BY m.name, g.f_geometry_column"""
		header,data=self.executeQuery(query)
		
		
		#if DB is not valid SpatiaLite table, help user to convert it
		if header==[] or data==[]: #Apparently BDD is not a valid SpatiaLite Table, transform it !
			reponse=QtGui.QMessageBox.question(None, "Transform DataBase into SpatiaLite","This DataBase seems to be a valid SQLite DataBase but not a valid SpatiaLite One\nWould you like QSpatiaLite to automatically transform it to SpatiaLite (information won't be lost) ?", QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
			if reponse==QtGui.QMessageBox.Yes:
				h,d=self.executeQuery("Select initspatialmetadata()",commit=True)
				if d[0][0]==1:
					pop_up_info("The DataBase was succesfully converted to SpatiaLite\nWill now try to load tables")
					self.getTables()
					return
				else:
					pop_up_error("Unable to convert Database to SpatiaLite")
					return
					
		# For each table and view, a new object will be created
		#info per table (array): name (0), type (1), geometry_column (2),
		#geometry_column_type (3), geometry_dimension (4), srid (5), spatial_index_enabled (6), 		#view_geometry_column (7) 
		self.tables=[]
		for table in data:
				self.tables.append(Table(table,self))
			
		
	def createTreeModel(self):
		"""Create and return a QStandardItemModel for treeview widget"""
		#Load tables
		self.getTables()
		#create model model
		model = QtGui.QStandardItemModel(0,1)
		model.setHorizontalHeaderItem(0,QtGui.QStandardItem('Tables'))
		user_item=QtGui.QStandardItem("My Tables")
		user_item.setData(None,32) #Data 32: Qt.UserRole
		index_item=QtGui.QStandardItem("Spatial Index")
		index_item.setData(None,32)
		system_item=QtGui.QStandardItem("Sys. Table")
		system_item.setData(None,32)
		model.appendRow(user_item)
		model.appendRow(index_item)
		model.appendRow(system_item)
		for table in self.tables:
			item=QtGui.QStandardItem(QtGui.QIcon(table.getIcon()),table.name)
			item.setData(table,32)
			for column in table.columns:
				colItem=QtGui.QStandardItem(QtGui.QIcon(column.getIcon()),column.name)
				colItem.setData(column,32)
				item.appendRow(colItem)
			if len(table.triggers)>0: #Add triggers for current table if exist
				triggers=QtGui.QStandardItem("Triggers")
				for trigger in table.triggers:
					trigItem=QtGui.QStandardItem(QtGui.QIcon(trigger.iconPath),trigger.name)
					trigItem.setData(trigger,32)
					triggers.appendRow(trigItem)
				item.appendRow(triggers)
			if table.name in self.systables:
				system_item.appendRow(item)
			elif table.name.upper()[:4]=="IDX_":
				index_item.appendRow(item)
			else:
				user_item.appendRow(item)
		return model
			
	def uploadQgisVectorLayer(self, layer, srid=None, tableName=None,selected=False, mapinfo=True):
		"""Upload layer (QgsMapLayer) (optionnaly only selected values ) into current DB, in tableName (string) with desired SRID (default layer srid if None) - user can desactivate mapinfo compatibility Date importation. Return True if operation succesfull or false in all other cases"""
		selected_ids=[]
		if selected==True :
			if layer.selectedFeatureCount()==0:
				pop_up_info("No selected item in Qgis layer: %s)"%layer.name())
				return False
			select_ids=vlayer.selectedFeaturesIds()
		#Create name for table if not provided by user
		if tableName in (None,''):
			tableName=layer.name()
		#Verify if tableName already exists in DB
		ExistingNames=[table.name for table in self.tables]
			#Propose user to automatically rename DB
		while tableName in ExistingNames:
			reponse=QtGui.QMessageBox.question(None, "Table name confusion",'''Table '%s' already exists in the current DataBase,\nwould you like to import layer '%s' as '%s_2' '''%(tableName,tableName,tableName), QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
			if reponse==QtGui.QMessageBox.Yes:
				tableName='%s_2'%tableName
			else:
				return False
		#Get data charset
		provider=layer.dataProvider()
		#charset=provider.encoding()
	
		#Get fields with corresponding types
		fields=[]
		fieldsNames=[]
		mapinfoDAte=[]
		for id,name in provider.fields().iteritems():
			fldName=unicode(name.name()).replace("'"," ").replace('"'," ")
			#Avoid two cols with same name:
			while fldName.upper() in fieldsNames:
				fldName='%s_2'%fldName
			fldType=name.type()
			fldTypeName=unicode(name.typeName()).upper()
			if fldTypeName=='DATE' and unicode(provider.storageType()).lower()==u'mapinfo file'and mapinfo==True: # Mapinfo DATE compatibility
				fldType='DATE'
				mapinfoDAte.append([id,fldName]) #stock id and name of DATE field for MAPINFO layers
			elif fldType in (QtCore.QVariant.Char,QtCore.QVariant.String): # field type is TEXT
				fldLength=name.length()
				fldType='TEXT(%s)'%fldLength  #Add field Length Information
			elif fldType in (QtCore.QVariant.Bool,QtCore.QVariant.Int,QtCore.QVariant.LongLong,QtCore.QVariant.UInt,QtCore.QVariant.ULongLong): # field type is INTEGER
				fldType='INTEGER'
			elif fldType==QtCore.QVariant.Double: # field type is DOUBLE
				fldType='REAL'
			else: # field type is not recognized by SQLITE
				fldType=fldTypeName
			fields.append(""" "%s" %s """%(fldName,fldType))
			fieldsNames.append(fldName.upper())

		# is it a geometric table ?
		geometry=False
		if layer.hasGeometryType():
			#Get geometry type
			geom=['MULTIPOINT','MULTILINESTRING','MULTIPOLYGON','UnknownGeometry']
			geometry=geom[layer.geometryType()]
			#Project to new SRID if specified by user:
			if srid==None:
				srid=layer.crs().postgisSrid()
			else:
				Qsrid = QgsCoordinateReferenceSystem()
				Qsrid.createFromEpsg(srid)
				if not Qsrid.isValid(): #check if crs is ok
					pop_up_error("Destination SRID isn't valid for table %s"%layer.name())
					return False
				layer.setCrs(Qsrid)
		
		#select attributes to import (remove Pkuid if already exists):
		allAttrs = provider.attributeIndexes()
		fldDesc = provider.fieldNameIndex("pkuid")
		if fldDesc != -1:
			print "Pkuid already exists and will be replaced!"
			del allAttrs[fldDesc] #remove pkuid Field
			del fields[fldDesc] #remove pkuid Field
		provider.select(allAttrs)
	
		if geometry:
			fields.insert(0,"Geometry %s"%geometry)
		
		#Create new table in BD
		fields=','.join(fields)
		if len(fields)>0:
			fields=', %s'%fields
		header,data=self.executeQuery("""CREATE TABLE "%s" ( PKUID INTEGER PRIMARY KEY AUTOINCREMENT %s )"""%(tableName, fields))
		if self.queryPb:
			return
	
		#Recover Geometry Column:
		if geometry:
			header,data=self.executeQuery("""SELECT RecoverGeometryColumn("%s",'Geometry',%s,'%s',2)"""%(tableName,srid,geometry,),commit=True)
		
		# Retreive every feature
		feat = QgsFeature()
		while provider.nextFeature(feat):
			# selected features:
			if selected and feat.id()not in select_ids:
				continue 
		
			#PKUID and Geometry		
			values_auto=['NULL'] #PKUID value
			if geometry:
				geom = feat.geometry()
				#WKB=geom.asWkb()
				WKT=geom.exportToWkt()
				values_auto.append('CastToMulti(GeomFromText("%s",%s))'%(WKT,srid))
		
			#Other attributes
			attrs = feat.attributeMap()
			# attrs is a dictionary: key = field index, value = QgsFeatureAttribute
			# show all attributes and their values
			values_perso=[]
			for (k,attr) in attrs.iteritems():
				values_perso.append(attr.toString())
			
			#Create line in DB table
			if len(fields)>0:
				header,data=self.executeQuery("""INSERT INTO "%s" VALUES (%s,%s)"""%(tableName,','.join([unicode(value).encode('utf-8') for value in values_auto]),','.join('?'*len(values_perso))),tuple([unicode(value) for value in values_perso]),commit=True)
			else: #no attribute Datas
				header,data=self.executeQuery("""INSERT INTO "%s" VALUES (%s)"""%(table_name,','.join([unicode(value).encode('utf-8') for value in values_auto])),commit=True)

		for date in mapinfoDAte: #mapinfo compatibility: convert date in SQLITE format (2010/02/11 -> 2010-02-11 ) or rollback if any error
			header,data=self.executeQuery("""UPDATE OR ROLLBACK "%s" set '%s'=replace( "%s", '/' , '-' )  """%(tableName,date[1],date[1]),commit=True)
	
		#Commit DB connection:
		self.connectionObject.commit()
		# reload tables
		self.getTables()
		return True
	
	def importGisFile(self, fileName, tableName, srid, charset):
		"""Import OGR format file into current DB or return false"""
		#Load File in QGIS
		layer = QgsVectorLayer(fileName, tableName, "ogr") #Load layer in qgis
		if not layer.isValid():
			pop_up_error("Impossible to Load File in QGis:\n%s"%(filename))
			return False
		#Set Layer Encoding
		layer.setProviderEncoding(charset)
		return self.uploadQgisVectorLayer(layer, srid, tableName=tableName)

	def vacuum(self):
		reponse=QtGui.QMessageBox.question(None, "PERFORM VACUUM DB","Do you really want to VACUUM DataBase ?", QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
		if reponse==QtGui.QMessageBox.Yes:
			try:
				self.executeQuery("VACUUM",commit=True)
				pop_up_info("VACUUM performed")
			except:
				pop_up_error("Unable to perfom VACUUM on the current Database")
			
			
			
