# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MeetingDialog
                                 A QGIS plugin
 Collaborative analysis with QGIS.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-08-30
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Sebastian Mikolka-Flöry / TU Wien
        email                : sebastian.floery@geo.tuwien.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt import QtCore

from collections import OrderedDict

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'qollabeo_dialog_meeting.ui'))

class MeetingDialog(QtWidgets.QDialog, FORM_CLASS):
    
    #added to send custon closed signal when X button in dialog pressed
    closed = QtCore.pyqtSignal()
    qtsig_local_feat_added = QtCore.pyqtSignal(object)

    def __init__(self, parent=None):
        """Constructor."""
        super(MeetingDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.rid = None
    
    def add_user(self, name=None, sid=None):
        item = QtWidgets.QListWidgetItem(name)
        item.setSizeHint(QtCore.QSize(10,30))
        item.value = sid
        self.list_user.addItem(item)

    def remove_user(self, data):
        sid = data["sid"]
        all_sids = list(self.get_all_users().keys())
        sid_ix = all_sids.index(sid)
        self.list_user.takeItem(sid_ix)
    
    def add_user_from_list(self, user_list):
        
        old_users = [self.list_user.item(i).value for i in range(self.list_user.count())]
        pot_users = user_list.keys()
        
        new_users = (set(pot_users) - set(old_users))
    
        for sid in new_users:
            self.add_user(name=user_list[sid], sid=sid)
        
    def get_all_users(self):
        user_list = OrderedDict()
        for i in range(self.list_user.count()):
            list_item = self.list_user.item(i)
            user_list[list_item.value] = list_item.text()
        return user_list
    
    #overriding dialogs close event to catch the signal in the plugin itself;
    def closeEvent(self, event):
        super(MeetingDialog, self).closeEvent(event)
        self.closed.emit()