"""
/***************************************************************************
 QMarxanDialog
                                 A QGIS plugin
 Create grid, measure input layers, create Marxan input layers, import results
                             -------------------
        begin                : 2011-10-11
        copyright            : (C) 2011 by Apropos Information Systems Inc.
        email                : tsw@aproposinfosystems.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui
from qgis.core import *
from ui_qm_calc import Ui_qm_calc

# create the dialog for zoom to point
class qmCalc(QtGui.QDialog):
    def __init__(self, iface):
        self.iface = iface

        # Import required plugins and if missing show the plugin's name
        import sys
        ftPath = QtCore.QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + '/python/plugins/fTools'
        if not ftPath in sys.path:
            sys.path.append(ftPath)
        req_plugin = "ftools 0.5.10"
        try:
            import ftools_utils
        except:
            QtGui.QMessageBox.information(self, self.tr("Missing Plugins"), 
                    self.tr("Missing plugin: %s" % req_plugin))

        QtGui.QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.ui = Ui_qm_calc()
        self.ui.setupUi(self)
        self.setFixedSize(510,590)
        #
        self.setWindowTitle(self.tr("Calculate Planning Grid Conservation Factor Values"))
        # add input layers to select planning grid
        layers = ftools_utils.getLayerNames([QGis.Polygon])
        self.ui.cbxPlanningGrid.addItems(layers)
        self.setMeasurePoints()
        self.setMeasureFields(self.ui.cbxPlanningGrid.currentText())
        self.setOutputField()
        self.ui.buttonOk = self.ui.buttonBox.button( QtGui.QDialogButtonBox.Ok )
        self.ui.rdoSum.setChecked(True)
        self.ui.rdoMeasure.setChecked(True)
        
        # connect methods to button interactions
        # selecting type of layer to measure
        QtCore.QObject.connect(self.ui.rdoPoints, QtCore.SIGNAL("clicked()"), self.setMeasurePoints)
        QtCore.QObject.connect(self.ui.rdoLines, QtCore.SIGNAL("clicked()"), self.setMeasureLines)
        QtCore.QObject.connect(self.ui.rdoAreas, QtCore.SIGNAL("clicked()"), self.setMeasurePolygons)
        # selecting measure layer
        QtCore.QObject.connect(self.ui.cbxPlanningGrid, QtCore.SIGNAL("currentIndexChanged(QString)"), self.setMeasureFields)
        # selecting measure or calculation
        QtCore.QObject.connect(self.ui.rdoMeasure, QtCore.SIGNAL("clicked()"), self.setMeasure)
        QtCore.QObject.connect(self.ui.rdoCalculate, QtCore.SIGNAL("clicked()"), self.setCalculate)
        QtCore.QObject.connect(self.ui.rdoPresence, QtCore.SIGNAL("clicked()"), self.setPresence)
        QtCore.QObject.connect(self.ui.cbxMeasureLayer, QtCore.SIGNAL("currentIndexChanged(QString)"), self.setCalcFields)
        # selecting field name
        QtCore.QObject.connect(self.ui.cbxSelectField, QtCore.SIGNAL("currentIndexChanged(QString)"), self.setOutputField)

    def setMeasure(self):
        self.ui.lblCalcField.setDisabled(True)
        self.ui.cbxCalcField.setDisabled(True)
        if not self.ui.lblMultipleAction.isEnabled():
            self.ui.lblMultipleAction.setEnabled(True)
            self.ui.rdoSum.setEnabled(True)
            self.ui.rdoMean.setEnabled(True)
            self.ui.rdoMax.setEnabled(True)
            self.ui.rdoMin.setEnabled(True)
            self.ui.rdoCount.setEnabled(True)

    def setCalculate(self):
        self.ui.lblCalcField.setEnabled(True)
        self.ui.cbxCalcField.setEnabled(True)
        if not self.ui.lblMultipleAction.isEnabled():
            self.ui.lblMultipleAction.setEnabled(True)
            self.ui.rdoSum.setEnabled(True)
            self.ui.rdoMean.setEnabled(True)
            self.ui.rdoMax.setEnabled(True)
            self.ui.rdoMin.setEnabled(True)
            self.ui.rdoCount.setEnabled(True)
    
    def setPresence(self):
        self.ui.lblCalcField.setDisabled(True)
        self.ui.cbxCalcField.setDisabled(True)
        if self.ui.lblMultipleAction.isEnabled():
            self.ui.lblMultipleAction.setDisabled(True)
            self.ui.rdoSum.setDisabled(True)
            self.ui.rdoMean.setDisabled(True)
            self.ui.rdoMax.setDisabled(True)
            self.ui.rdoMin.setDisabled(True)
            self.ui.rdoCount.setDisabled(True)

    def updateMeasureLayer(self, layers):
        self.ui.cbxMeasureLayer.clear()
        self.ui.cbxMeasureLayer.addItems(layers)
        self.setCalcFields()

    def setCalcFields(self):
        import ftools_utils
        self.ui.cbxCalcField.clear()
        calcLayer = self.ui.cbxMeasureLayer.currentText()
        selectedLayer = ftools_utils.getVectorLayerByName(unicode(calcLayer))
        if selectedLayer != None:
            fields = ftools_utils.getFieldList(selectedLayer)
            for i in fields:
                if fields[i].type() == QtCore.QVariant.Int or \
                fields[i].type() == QtCore.QVariant.Double:
                    self.ui.cbxCalcField.addItem(unicode(fields[i].name()))
    
    def setMeasurePoints(self):
        import ftools_utils
        layers = ftools_utils.getLayerNames([QGis.Point])
        self.updateMeasureLayer(layers)
        
    def setMeasureLines(self):
        import ftools_utils
        layers = ftools_utils.getLayerNames([QGis.Line])
        self.updateMeasureLayer(layers)
        
    def setMeasurePolygons(self):
        import ftools_utils
        layers = ftools_utils.getLayerNames([QGis.Polygon])
        self.updateMeasureLayer(layers)
    
    def setMeasureFields(self, planningGrid):
        import ftools_utils
        self.ui.cbxSelectField.clear()
        selectedLayer = ftools_utils.getVectorLayerByName(unicode(planningGrid))
        if selectedLayer != None:
            self.ui.cbxSelectField.addItem(unicode("--Create New--"))
            fields = ftools_utils.getFieldList(selectedLayer)
            for i in fields:
                if fields[i].type() == QtCore.QVariant.Int or \
                fields[i].type() == QtCore.QVariant.Double:
                    self.ui.cbxSelectField.addItem(unicode(fields[i].name()))
    
    def setOutputField(self):
        if self.ui.cbxSelectField.currentIndex() == 0:
            self.ui.lblNewField.setEnabled(True)
            self.ui.leNewField.setEnabled(True)
        else:
            self.ui.lblNewField.setDisabled(True)
            self.ui.leNewField.setDisabled(True)
          
    def accept(self):            
        import ftools_utils
        self.ui.buttonOk.setEnabled(False)
        puFile = self.ui.cbxPlanningGrid.currentText()
        mFile = self.ui.cbxMeasureLayer.currentText()
        if self.ui.chkSelectedOnly.isChecked():
            useSelected = True
        else:
            useSelected = False
        proceed = True
        if self.ui.cbxSelectField.currentIndex() == 0:
            if self.ui.leNewField.text() != "":
                fName = self.ui.leNewField.text()
                proceed = True
            else:
                proceed = False
        else:
            fName = self.ui.cbxSelectField.currentText()
        if proceed:
            self.do_calculation(puFile, mFile, fName, useSelected)

        # reset progress bar
        self.ui.progressBar.setValue(0)
        # reset system
        self.ui.buttonOk.setEnabled(True)
            
    #
    # Derived from fTools point in polygon function
    #
        
    def do_calculation(self, planningUnitFile, measureFile, fieldName, useSelected):
        import ftools_utils
        polygonLayer = ftools_utils.getVectorLayerByName(planningUnitFile)
        measureLayer = ftools_utils.getVectorLayerByName(measureFile)
        success, message = self.countFeaturesInPolygon(polygonLayer, measureLayer, fieldName, useSelected)
        if success:
            self.ui.progressBar.setValue(100)
            self.ui.progressBar.repaint()
            QtGui.QMessageBox.information(self, self.tr("Planning Unit Calculation"), 
                        self.tr(message))
        else:
            QtGui.QMessageBox.warning(self, self.tr("Planning Unit Calculation"), 
                        self.tr(message))

#
# TSW 2011-11-15
# The following function slightly modified from
# a script posted by Carson Farmer. New field name
# selection has been added. Als returns of error messages
# has been added to allow for use in GUI.
#

#-----------------------------------------------------------
#
# This file is part of fTools
# Copyright (C) 2011  Carson Farmer
# EMAIL: carson.farmer (at) gmail.com
# WEB  : http://www.ftools.ca/fTools.html
#
# A collection of data management and analysis tools for vector data
#
#-----------------------------------------------------------
#
# licensed under the terms of GNU GPL 2
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
#---------------------------------------------------------------------

    def countFeaturesInPolygon(self, polygonLayer, inputLayer, newFieldName = "", onlySelected=False):
        import ftools_utils
        message = "Calculation Complete!"
        feature = QgsFeature()
        selectedIds = inputLayer.selectedFeaturesIds()
        fields = ftools_utils.getFieldList(inputLayer)
        cfn = self.ui.cbxCalcField.currentText()
        # determine actions
        # default for value is measure
        calcindex = -1
        # default for multiple intersection is sum
        multiAction = 'presence'
        if not self.ui.rdoMeasure.isChecked():
            for i in fields:
                if fields[i].name() == cfn:
                    calcindex = i
        if self.ui.rdoMean.isEnabled():
            if self.ui.rdoMean.isChecked():
                multiAction = 'mean'
            elif self.ui.rdoMax.isChecked():
                multiAction = 'max'
            elif self.ui.rdoMin.isChecked():
                multiAction = 'min'
            elif self.ui.rdoCount.isChecked():
                multiAction = 'count'
            else:
                multiAction = 'sum'
        if inputLayer.geometryType() == QGis.Point:
            if newFieldName == "":
                fieldName = QtCore.QString("pntcnt")
            else:
                fieldName = newFieldName
        elif inputLayer.geometryType() == QGis.Line:
            if newFieldName == "":
                fieldName = QtCore.QString("length")
            else:
                fieldName = newFieldName
        elif inputLayer.geometryType() == QGis.Polygon:
            if newFieldName == "":
                fieldName = QtCore.QString("area")
            else:
                fieldName = newFieldName
        else:
            message = "Invalid input layer type: Should be point,line, or polygon layer"
            return (False, message)
        polygonLayer.blockSignals(True)
        wasEditing = polygonLayer.isEditable() # if it is editable, then we must be in edit mode
        if not wasEditing:
            polygonLayer.startEditing()
            if not polygonLayer.isEditable():
                message = "Unable to edit input polygon layer: Please choose a layer with edit capabilities."
                return (False, message)
        if not inputLayer.crs() == polygonLayer.crs():
            message = "Input layers have non-matching CRS. Can not continue."
            return (False, message)
        fieldMap = polygonLayer.pendingFields()
        fieldMap = dict([(field.name(), index) for index, field in fieldMap.iteritems()])
        attributeId = -1
        if fieldName.toUpper() in fieldMap: # update existing uppercase field
            attributeId = fieldMap[fieldName.toUpper()]
        elif fieldName in fieldMap: # update existing lowercase field
            attributeId = fieldMap[fieldName]
        else: # create new field
            if not polygonLayer.dataProvider().capabilities() > 7: # can't add attributes
                message = "Data provider does not support adding attributes: " + \
                    "Cannot add required field."
                if not wasEditing:
                    polygonLayer.rollBack()
                return (False, message)
            #
            # NOTE: TSW 2011-11-15 - tested on QGIS 1.4 and Master (1.8?)
            # Result: Failed to create integer fields in shp files but worked
            # with postgis after changing from double to real
            # Changed everything to float and works in both environments
            # Bug Cause: unknown
            #
#             if inputLayer.geometryType() == QGis.Point:
#                 newField = QgsField(fieldName, QtCore.QVariant.Int, "integer")
#             else: # if it's not a point, then it must be line otherwise we shouldn't be here
#                 newField = QgsField(fieldName, QtCore.QVariant.Double, "real", 10, 5)
            # modified to 20, 5 - maximum size and detail shown in user interface
            newField = QgsField(fieldName, QtCore.QVariant.Double, "Real", 19, 10)
            polygonLayer.beginEditCommand("Attribute added")
            if not polygonLayer.addAttribute(newField):
                message = "Could not add the new field to the polygon layer."
                polygonLayer.destroyEditCommand()
                if not wasEditing:
                    polygonLayer.rollBack()
                return (False, message)
            polygonLayer.endEditCommand()
            # get index of the new field
            fieldMap = polygonLayer.pendingFields()
            fieldMap = dict([(field.name(), index) for index, field in fieldMap.iteritems()])
            if not fieldName in fieldMap:
                message =  "Could not find the newly created field."
                if not wasEditing:
                    polygonLayer.rollBack()
                return (False, message)
            attributeId = fieldMap[fieldName]
        if attributeId == -1:
            message= "Error writing to the new attribute."
            if not wasEditing:
                polygonLayer.rollBack()
            return (False, message)
        # create spatial index input layer for faster querying later
        try:
            index = QgsSpatialIndex()
            inputLayer.select([], QgsRectangle(), True, False)
            while inputLayer.nextFeature(feature):
                index.insertFeature(feature)
        except:
            return(False,'Could not build index, possible topology errors')
        polygonLayer.select(polygonLayer.pendingAllAttributesList(), QgsRectangle(), True, False)
        polygonLayer.beginEditCommand("Count field updated")
        inputFeature = QgsFeature()
        measure = QgsDistanceArea()
        geom = QgsGeometry()
        fCount = polygonLayer.dataProvider().featureCount()
        x = 0
        try:
            while polygonLayer.nextFeature(feature):
                self.ui.progressBar.setValue((x*100)/fCount)
                self.ui.progressBar.repaint()
                # get geometry from current feature in polygon layer
                geom = QgsGeometry(feature.geometry())
                # get list of features in input layer that might intersect
                features = index.intersects(geom.boundingBox())
                value = 0.0
                valMax = None
                valMin = None
                valCount = 0.0
                # check each of the intersecting features for containment
                # or intersection
                if calcindex < 0:
                    # direct measure or presence
                    for id in features:
                        if onlySelected: # should we only use the selected ones?
                            if not id in selectedIds:
                                continue # skip this one...
                        # get an input layer feature
                        inputLayer.featureAtId(id, inputFeature, True)
                        # get the input layer feature's geometry
                        inputGeom = QgsGeometry(inputFeature.geometry())
                        if inputLayer.geometryType() == QGis.Point:
                            if geom.contains(inputGeom.asPoint()):
                                value += 1.0
                                valCount += 1.0
                                valMax = 1.0
                                valMin = 1.0
                        else:
                            try:
                                inputGeom = QgsGeometry(geom.intersection(inputGeom))
                            except:
                                    return(False,'Measure layer has invalid topology. Correct before continuing.')
                            if not inputGeom.isGeosValid() or inputGeom.isGeosEmpty():
                                continue
                            value += measure.measure(inputGeom)
                            valCount += 1.0
                            if valMax is None or measure.measure(inputGeom) > valMax:
                                valMax = measure.measure(inputGeom)
                            if valMin is None or measure.measure(inputGeom) < valMin:
                                valMin = measure.measure(inputGeom)
                else:
                    # measure * field
                    for id in features:
                        if onlySelected: # should we only use the selected ones?
                            if not id in selectedIds:
                                continue # skip this one...
                        # get an input layer feature
                        inputLayer.featureAtId(id, inputFeature, True)
                        # get the input layer feature's geometry
                        inputGeom = QgsGeometry(inputFeature.geometry())
                        if inputLayer.geometryType() == QGis.Point:
                            if geom.contains(inputGeom.asPoint()):
                                attMap = inputFeature.attributeMap()
                                value += float(attMap[calcindex].toString())
                                valCount += 1.0
                                if valMax is None or float(attMap[calcindex].toString()) > valMax:
                                    valMax = float(attMap[calcindex].toString())
                                if valMin is None or float(attMap[calcindex].toString()) < valMin:
                                    valMin = float(attMap[calcindex].toString())
                        else:
                            try:
                                inputGeom = QgsGeometry(geom.intersection(inputGeom))
                            except:
                                    return(False,'Measure layer has invalid topology. Correct before continuing.')
                            if not inputGeom.isGeosValid() or inputGeom.isGeosEmpty():
                                continue
                            attMap = inputFeature.attributeMap()
                            value += float(attMap[calcindex].toString()) * measure.measure(inputGeom)
                            valCount += 1.0
                            if valMax is None or float(attMap[calcindex].toString()) * measure.measure(inputGeom) > valMax:
                                valMax = float(attMap[calcindex].toString()) * measure.measure(inputGeom)
                            if valMin is None or float(attMap[calcindex].toString()) * measure.measure(inputGeom) < valMin:
                                valMin = float(attMap[calcindex].toString()) * measure.measure(inputGeom)
                if multiAction == 'sum':
                    featureVal = value
                elif multiAction == 'mean':
                    if value > 0:
                        featureVal = value / valCount
                    else:
                        featureVal = value 
                elif multiAction == 'max':
                    featureVal = valMax
                elif multiAction == 'min':
                    featureVal = valMin
                elif multiAction == 'count':
                    featureVal = valCount
                elif multiAction == 'presence':
                    if valCount > 0.0:
                        featureVal = 1.0
                    else:
                        featureVal = 0.0
                if featureVal is None:
                    featureVal = 0.0
                polygonLayer.changeAttributeValue(feature.id(), attributeId, featureVal, False)
                x = x + 1
            polygonLayer.endEditCommand()
        except Exception, err:
            message = "An error occured while adding measure:\n%s" % str(err)
            if not wasEditing:
                polygonLayer.rollBack()
                return (False, message)

        # stop blocking layerModified signals and make sure that one layerModified signal is emitted
        polygonLayer.blockSignals(False)
        polygonLayer.setModified(True, False)

        if not wasEditing:
            polygonLayer.commitChanges()
        return (True, message)
