# -*- coding: utf-8 -*-
"""
/***************************************************************************
 wcps_client
                                 A QGIS plugin
 Prototype of new version of WCPS client
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-06-27
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Nikita Ivlev
        email                : viphwydon@outlook.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import qVersion
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .wcps_client_dialog import WCPSClientDialog
import os.path

class wcps_client:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'QgsWcpsClient1_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = WCPSClientDialog(iface)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&WcpsClient1')


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('wcps_client', message)


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        # NOTE: see https://doc.rasdaman.org/11_cheatsheets.html#plugin-development for details about debugging with Pycharm
        # import pydevd_pycharm
        # pydevd_pycharm.settrace('localhost', port=5678, stdoutToServer=True, stderrToServer=True)

        icon_path = f'{self.plugin_dir}/icon.png'
        self.action = QAction(QIcon(icon_path), 'WCPS 1.1 Client', self.iface.mainWindow())
        self.action.triggered.connect(self.run)

        # Add icon to main QGIS toolbar
        self.iface.addToolBarIcon(self.action)

        # Add WCPSClient as an item of Plugins dropdown menu
        self.iface.addPluginToMenu(
            self.menu,
            self.action)

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&WCPS 1.1 Client'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
