# -*- coding: utf-8 -*-
"""
/***************************************************************************
                              -------------------
        begin                : 16.12.2021
        git sha              : :%H$
        copyright            : (C) 2021 by Dave Signer
        email                : david at opengis ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QCoreApplication

from QgisModelBaker.libs.modelbaker.iliwrapper.globals import DbIliMode

CRS_PATTERNS = {"LV95": 2056, "LV03": 21781}

DEFAULT_DATASETNAME = "Baseset"
CATALOGUE_DATASETNAME = "Catalogueset"

displayDbIliMode = {
    DbIliMode.pg: QCoreApplication.translate("QgisModelBaker", "PostGIS"),
    DbIliMode.gpkg: QCoreApplication.translate("QgisModelBaker", "GeoPackage"),
    DbIliMode.mssql: QCoreApplication.translate("QgisModelBaker", "SQL Server"),
    DbIliMode.ili: QCoreApplication.translate("QgisModelBaker", "Interlis"),
    DbIliMode.ili2pg: QCoreApplication.translate(
        "QgisModelBaker", "Interlis (use PostGIS)"
    ),
    DbIliMode.ili2gpkg: QCoreApplication.translate(
        "QgisModelBaker", "Interlis (use GeoPackage)"
    ),
    DbIliMode.ili2mssql: QCoreApplication.translate(
        "QgisModelBaker", "Interlis (use SQL Server)"
    ),
}
