// The Module object: Our interface to the outside world. We import
// and export values on it. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to check if Module already exists (e.g. case 3 above).
// Substitution will be replaced with actual code on later stage of the build,
// this way Closure Compiler will not mangle it (e.g. case 4. above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module = typeof Module !== 'undefined' ? Module : {};

// --pre-jses are emitted after the Module integration code, so that they can
// refer to Module (if they choose; they can also define Module)
// {{PRE_JSES}}

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
var key;
for (key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

Module['arguments'] = [];
Module['thisProgram'] = './this.program';
Module['quit'] = function(status, toThrow) {
  throw toThrow;
};
Module['preRun'] = [];
Module['postRun'] = [];

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_WEB = false;
var ENVIRONMENT_IS_WORKER = false;
var ENVIRONMENT_IS_NODE = false;
var ENVIRONMENT_IS_SHELL = false;

// Three configurations we can be running in:
// 1) We could be the application main() thread running in the main JS UI thread. (ENVIRONMENT_IS_WORKER == false and ENVIRONMENT_IS_PTHREAD == false)
// 2) We could be the application main() thread proxied to worker. (with Emscripten -s PROXY_TO_WORKER=1) (ENVIRONMENT_IS_WORKER == true, ENVIRONMENT_IS_PTHREAD == false)
// 3) We could be an application pthread running in a worker. (ENVIRONMENT_IS_WORKER == true and ENVIRONMENT_IS_PTHREAD == true)

if (Module['ENVIRONMENT']) {
  if (Module['ENVIRONMENT'] === 'WEB') {
    ENVIRONMENT_IS_WEB = true;
  } else if (Module['ENVIRONMENT'] === 'WORKER') {
    ENVIRONMENT_IS_WORKER = true;
  } else if (Module['ENVIRONMENT'] === 'NODE') {
    ENVIRONMENT_IS_NODE = true;
  } else if (Module['ENVIRONMENT'] === 'SHELL') {
    ENVIRONMENT_IS_SHELL = true;
  } else {
    throw new Error('Module[\'ENVIRONMENT\'] value is not valid. must be one of: WEB|WORKER|NODE|SHELL.');
  }
} else {
  ENVIRONMENT_IS_WEB = typeof window === 'object';
  ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
  ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function' && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER;
  ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
}


if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  var nodeFS;
  var nodePath;

  Module['read'] = function shell_read(filename, binary) {
    var ret;
    ret = tryParseAsDataURI(filename);
    if (!ret) {
      if (!nodeFS) nodeFS = require('fs');
      if (!nodePath) nodePath = require('path');
      filename = nodePath['normalize'](filename);
      ret = nodeFS['readFileSync'](filename);
    }
    return binary ? ret : ret.toString();
  };

  Module['readBinary'] = function readBinary(filename) {
    var ret = Module['read'](filename, true);
    if (!ret.buffer) {
      ret = new Uint8Array(ret);
    }
    assert(ret.buffer);
    return ret;
  };

  if (process['argv'].length > 1) {
    Module['thisProgram'] = process['argv'][1].replace(/\\/g, '/');
  }

  Module['arguments'] = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  process['on']('uncaughtException', function(ex) {
    // suppress ExitStatus exceptions from showing an error
    if (!(ex instanceof ExitStatus)) {
      throw ex;
    }
  });
  // Currently node will swallow unhandled rejections, but this behavior is
  // deprecated, and in the future it will exit with error status.
  process['on']('unhandledRejection', function(reason, p) {
    Module['printErr']('node.js exiting due to unhandled promise rejection');
    process['exit'](1);
  });

  Module['inspect'] = function () { return '[Emscripten Module object]'; };
} else
if (ENVIRONMENT_IS_SHELL) {
  if (typeof read != 'undefined') {
    Module['read'] = function shell_read(f) {
      var data = tryParseAsDataURI(f);
      if (data) {
        return intArrayToString(data);
      }
      return read(f);
    };
  }

  Module['readBinary'] = function readBinary(f) {
    var data;
    data = tryParseAsDataURI(f);
    if (data) {
      return data;
    }
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof quit === 'function') {
    Module['quit'] = function(status, toThrow) {
      quit(status);
    }
  }
} else
if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function shell_read(url) {
    try {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, false);
      xhr.send(null);
      return xhr.responseText;
    } catch (err) {
      var data = tryParseAsDataURI(url);
      if (data) {
        return intArrayToString(data);
      }
      throw err;
    }
  };

  if (ENVIRONMENT_IS_WORKER) {
    Module['readBinary'] = function readBinary(url) {
      try {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, false);
        xhr.responseType = 'arraybuffer';
        xhr.send(null);
        return new Uint8Array(xhr.response);
      } catch (err) {
        var data = tryParseAsDataURI(url);
        if (data) {
          return data;
        }
        throw err;
      }
    };
  }

  Module['readAsync'] = function readAsync(url, onload, onerror) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function xhr_onload() {
      if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
        onload(xhr.response);
        return;
      }
      var data = tryParseAsDataURI(url);
      if (data) {
        onload(data.buffer);
        return;
      }
      onerror();
    };
    xhr.onerror = onerror;
    xhr.send(null);
  };

  Module['setWindowTitle'] = function(title) { document.title = title };
} else
{
  throw new Error('not compiled for this environment (did you build to HTML and try to run it not on the web, or set ENVIRONMENT to something - like node - and run it someplace else - like on the web?)');
}

// console.log is checked first, as 'print' on the web will open a print dialogue
// printErr is preferable to console.warn (works better in shells)
// bind(console) is necessary to fix IE/Edge closed dev tools panel behavior.
Module['print'] = typeof console !== 'undefined' ? console.log.bind(console) : (typeof print !== 'undefined' ? print : null);
Module['printErr'] = typeof printErr !== 'undefined' ? printErr : ((typeof console !== 'undefined' && console.warn.bind(console)) || Module['print']);

// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Merge back in the overrides
for (key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// Free the object hierarchy contained in the overrides, this lets the GC
// reclaim data used e.g. in memoryInitializerRequest, which is a large typed array.
moduleOverrides = undefined;



// {{PREAMBLE_ADDITIONS}}

var STACK_ALIGN = 16;

// stack management, and other functionality that is provided by the compiled code,
// should not be used before it is ready
stackSave = stackRestore = stackAlloc = setTempRet0 = getTempRet0 = function() {
  abort('cannot use the stack before compiled code is ready to run, and has provided stack access');
};

function staticAlloc(size) {
  assert(!staticSealed);
  var ret = STATICTOP;
  STATICTOP = (STATICTOP + size + 15) & -16;
  return ret;
}

function dynamicAlloc(size) {
  assert(DYNAMICTOP_PTR);
  var ret = HEAP32[DYNAMICTOP_PTR>>2];
  var end = (ret + size + 15) & -16;
  HEAP32[DYNAMICTOP_PTR>>2] = end;
  if (end >= TOTAL_MEMORY) {
    var success = enlargeMemory();
    if (!success) {
      HEAP32[DYNAMICTOP_PTR>>2] = ret;
      return 0;
    }
  }
  return ret;
}

function alignMemory(size, factor) {
  if (!factor) factor = STACK_ALIGN; // stack alignment (16-byte) by default
  var ret = size = Math.ceil(size / factor) * factor;
  return ret;
}

function getNativeTypeSize(type) {
  switch (type) {
    case 'i1': case 'i8': return 1;
    case 'i16': return 2;
    case 'i32': return 4;
    case 'i64': return 8;
    case 'float': return 4;
    case 'double': return 8;
    default: {
      if (type[type.length-1] === '*') {
        return 4; // A pointer
      } else if (type[0] === 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 === 0);
        return bits / 8;
      } else {
        return 0;
      }
    }
  }
}

function warnOnce(text) {
  if (!warnOnce.shown) warnOnce.shown = {};
  if (!warnOnce.shown[text]) {
    warnOnce.shown[text] = 1;
    Module.printErr(text);
  }
}



var jsCallStartIndex = 1;
var functionPointers = new Array(0);

// 'sig' parameter is only used on LLVM wasm backend
function addFunction(func, sig) {
  if (typeof sig === 'undefined') {
    Module.printErr('warning: addFunction(): You should provide a wasm function signature string as a second argument. This is not necessary for asm.js and asm2wasm, but is required for the LLVM wasm backend, so it is recommended for full portability.');
  }
  var base = 0;
  for (var i = base; i < base + 0; i++) {
    if (!functionPointers[i]) {
      functionPointers[i] = func;
      return jsCallStartIndex + i;
    }
  }
  throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
}

function removeFunction(index) {
  functionPointers[index-jsCallStartIndex] = null;
}

var funcWrappers = {};

function getFuncWrapper(func, sig) {
  if (!func) return; // on null pointer, return undefined
  assert(sig);
  if (!funcWrappers[sig]) {
    funcWrappers[sig] = {};
  }
  var sigCache = funcWrappers[sig];
  if (!sigCache[func]) {
    // optimize away arguments usage in common cases
    if (sig.length === 1) {
      sigCache[func] = function dynCall_wrapper() {
        return dynCall(sig, func);
      };
    } else if (sig.length === 2) {
      sigCache[func] = function dynCall_wrapper(arg) {
        return dynCall(sig, func, [arg]);
      };
    } else {
      // general case
      sigCache[func] = function dynCall_wrapper() {
        return dynCall(sig, func, Array.prototype.slice.call(arguments));
      };
    }
  }
  return sigCache[func];
}


function makeBigInt(low, high, unsigned) {
  return unsigned ? ((+((low>>>0)))+((+((high>>>0)))*4294967296.0)) : ((+((low>>>0)))+((+((high|0)))*4294967296.0));
}

function dynCall(sig, ptr, args) {
  if (args && args.length) {
    assert(args.length == sig.length-1);
    assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
    return Module['dynCall_' + sig].apply(null, [ptr].concat(args));
  } else {
    assert(sig.length == 1);
    assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
    return Module['dynCall_' + sig].call(null, ptr);
  }
}


function getCompilerSetting(name) {
  throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for getCompilerSetting or emscripten_get_compiler_setting to work';
}

var Runtime = {
  // FIXME backwards compatibility layer for ports. Support some Runtime.*
  //       for now, fix it there, then remove it from here. That way we
  //       can minimize any period of breakage.
  dynCall: dynCall, // for SDL2 port
  // helpful errors
  getTempRet0: function() { abort('getTempRet0() is now a top-level function, after removing the Runtime object. Remove "Runtime."') },
  staticAlloc: function() { abort('staticAlloc() is now a top-level function, after removing the Runtime object. Remove "Runtime."') },
  stackAlloc: function() { abort('stackAlloc() is now a top-level function, after removing the Runtime object. Remove "Runtime."') },
};

// The address globals begin at. Very low in memory, for code size and optimization opportunities.
// Above 0 is static memory, starting with globals.
// Then the stack.
// Then 'dynamic' memory for sbrk.
var GLOBAL_BASE = 8;



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in:
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at:
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html



//========================================
// Runtime essentials
//========================================

var ABORT = 0; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

/** @type {function(*, string=)} */
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  assert(func, 'Cannot call unknown function ' + ident + ', make sure it is exported');
  return func;
}

var JSfuncs = {
  // Helpers for cwrap -- it can't refer to Runtime directly because it might
  // be renamed by closure, instead it calls JSfuncs['stackSave'].body to find
  // out what the minified function name is.
  'stackSave': function() {
    stackSave()
  },
  'stackRestore': function() {
    stackRestore()
  },
  // type conversion from js to c
  'arrayToC' : function(arr) {
    var ret = stackAlloc(arr.length);
    writeArrayToMemory(arr, ret);
    return ret;
  },
  'stringToC' : function(str) {
    var ret = 0;
    if (str !== null && str !== undefined && str !== 0) { // null string
      // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
      var len = (str.length << 2) + 1;
      ret = stackAlloc(len);
      stringToUTF8(str, ret, len);
    }
    return ret;
  }
};

// For fast lookup of conversion functions
var toC = {
  'string': JSfuncs['stringToC'], 'array': JSfuncs['arrayToC']
};

// C calling interface.
function ccall (ident, returnType, argTypes, args, opts) {
  var func = getCFunc(ident);
  var cArgs = [];
  var stack = 0;
  assert(returnType !== 'array', 'Return type should not be "array".');
  if (args) {
    for (var i = 0; i < args.length; i++) {
      var converter = toC[argTypes[i]];
      if (converter) {
        if (stack === 0) stack = stackSave();
        cArgs[i] = converter(args[i]);
      } else {
        cArgs[i] = args[i];
      }
    }
  }
  var ret = func.apply(null, cArgs);
  if (returnType === 'string') ret = Pointer_stringify(ret);
  else if (returnType === 'boolean') ret = Boolean(ret);
  if (stack !== 0) {
    stackRestore(stack);
  }
  return ret;
}

function cwrap (ident, returnType, argTypes) {
  argTypes = argTypes || [];
  var cfunc = getCFunc(ident);
  // When the function takes numbers and returns a number, we can just return
  // the original function
  var numericArgs = argTypes.every(function(type){ return type === 'number'});
  var numericRet = returnType !== 'string';
  if (numericRet && numericArgs) {
    return cfunc;
  }
  return function() {
    return ccall(ident, returnType, argTypes, arguments);
  }
}

/** @type {function(number, number, string, boolean=)} */
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[((ptr)>>0)]=value; break;
      case 'i8': HEAP8[((ptr)>>0)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}

/** @type {function(number, string, boolean=)} */
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for getValue: ' + type);
    }
  return null;
}

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
/** @type {function((TypedArray|Array<number>|number), string, number, number=)} */
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [typeof _malloc === 'function' ? _malloc : staticAlloc, stackAlloc, staticAlloc, dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var stop;
    ptr = ret;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(/** @type {!Uint8Array} */ (slab), ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    assert(type, 'Must know what type to store in allocate!');

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}

// Allocate memory during any stage of startup - static memory early on, dynamic memory later, malloc when ready
function getMemory(size) {
  if (!staticSealed) return staticAlloc(size);
  if (!runtimeInitialized) return dynamicAlloc(size);
  return _malloc(size);
}

/** @type {function(number, number=)} */
function Pointer_stringify(ptr, length) {
  if (length === 0 || !ptr) return '';
  // Find the length, and check for UTF while doing so
  var hasUtf = 0;
  var t;
  var i = 0;
  while (1) {
    assert(ptr + i < TOTAL_MEMORY);
    t = HEAPU8[(((ptr)+(i))>>0)];
    hasUtf |= t;
    if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (hasUtf < 128) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  return UTF8ToString(ptr);
}

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAP8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

var UTF8Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf8') : undefined;
function UTF8ArrayToString(u8Array, idx) {
  var endPtr = idx;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  while (u8Array[endPtr]) ++endPtr;

  if (endPtr - idx > 16 && u8Array.subarray && UTF8Decoder) {
    return UTF8Decoder.decode(u8Array.subarray(idx, endPtr));
  } else {
    var u0, u1, u2, u3, u4, u5;

    var str = '';
    while (1) {
      // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
      u0 = u8Array[idx++];
      if (!u0) return str;
      if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
      u1 = u8Array[idx++] & 63;
      if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
      u2 = u8Array[idx++] & 63;
      if ((u0 & 0xF0) == 0xE0) {
        u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
      } else {
        u3 = u8Array[idx++] & 63;
        if ((u0 & 0xF8) == 0xF0) {
          u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | u3;
        } else {
          u4 = u8Array[idx++] & 63;
          if ((u0 & 0xFC) == 0xF8) {
            u0 = ((u0 & 3) << 24) | (u1 << 18) | (u2 << 12) | (u3 << 6) | u4;
          } else {
            u5 = u8Array[idx++] & 63;
            u0 = ((u0 & 1) << 30) | (u1 << 24) | (u2 << 18) | (u3 << 12) | (u4 << 6) | u5;
          }
        }
      }
      if (u0 < 0x10000) {
        str += String.fromCharCode(u0);
      } else {
        var ch = u0 - 0x10000;
        str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
      }
    }
  }
}

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF8ToString(ptr) {
  return UTF8ArrayToString(HEAPU8,ptr);
}

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outU8Array: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      outU8Array[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      outU8Array[outIdx++] = 0xC0 | (u >> 6);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      outU8Array[outIdx++] = 0xE0 | (u >> 12);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x1FFFFF) {
      if (outIdx + 3 >= endIdx) break;
      outU8Array[outIdx++] = 0xF0 | (u >> 18);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x3FFFFFF) {
      if (outIdx + 4 >= endIdx) break;
      outU8Array[outIdx++] = 0xF8 | (u >> 24);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 5 >= endIdx) break;
      outU8Array[outIdx++] = 0xFC | (u >> 30);
      outU8Array[outIdx++] = 0x80 | ((u >> 24) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  outU8Array[outIdx] = 0;
  return outIdx - startIdx;
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      ++len;
    } else if (u <= 0x7FF) {
      len += 2;
    } else if (u <= 0xFFFF) {
      len += 3;
    } else if (u <= 0x1FFFFF) {
      len += 4;
    } else if (u <= 0x3FFFFFF) {
      len += 5;
    } else {
      len += 6;
    }
  }
  return len;
}

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

var UTF16Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf-16le') : undefined;
function UTF16ToString(ptr) {
  assert(ptr % 2 == 0, 'Pointer passed to UTF16ToString must be aligned to two bytes!');
  var endPtr = ptr;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  var idx = endPtr >> 1;
  while (HEAP16[idx]) ++idx;
  endPtr = idx << 1;

  if (endPtr - ptr > 32 && UTF16Decoder) {
    return UTF16Decoder.decode(HEAPU8.subarray(ptr, endPtr));
  } else {
    var i = 0;

    var str = '';
    while (1) {
      var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
      if (codeUnit == 0) return str;
      ++i;
      // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
      str += String.fromCharCode(codeUnit);
    }
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  assert(outPtr % 2 == 0, 'Pointer passed to stringToUTF16 must be aligned to two bytes!');
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF16(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)]=codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)]=0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}

function UTF32ToString(ptr) {
  assert(ptr % 4 == 0, 'Pointer passed to UTF32ToString must be aligned to four bytes!');
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  assert(outPtr % 4 == 0, 'Pointer passed to stringToUTF32 must be aligned to four bytes!');
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF32(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)]=codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)]=0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}

// Allocate heap space for a JS string, and write it there.
// It is the responsibility of the caller to free() that memory.
function allocateUTF8(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = _malloc(size);
  if (ret) stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

// Allocate stack space for a JS string, and write it there.
function allocateUTF8OnStack(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = stackAlloc(size);
  stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

function demangle(func) {
  warnOnce('warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling');
  return func;
}

function demangleAll(text) {
  var regex =
    /__Z[\w\d_]+/g;
  return text.replace(regex,
    function(x) {
      var y = demangle(x);
      return x === y ? x : (x + ' [' + y + ']');
    });
}

function jsStackTrace() {
  var err = new Error();
  if (!err.stack) {
    // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
    // so try that as a special-case.
    try {
      throw new Error(0);
    } catch(e) {
      err = e;
    }
    if (!err.stack) {
      return '(no stack trace available)';
    }
  }
  return err.stack.toString();
}

function stackTrace() {
  var js = jsStackTrace();
  if (Module['extraStackTrace']) js += '\n' + Module['extraStackTrace']();
  return demangleAll(js);
}

// Memory management

var PAGE_SIZE = 16384;
var WASM_PAGE_SIZE = 65536;
var ASMJS_PAGE_SIZE = 16777216;
var MIN_TOTAL_MEMORY = 16777216;

function alignUp(x, multiple) {
  if (x % multiple > 0) {
    x += multiple - (x % multiple);
  }
  return x;
}

var HEAP,
/** @type {ArrayBuffer} */
  buffer,
/** @type {Int8Array} */
  HEAP8,
/** @type {Uint8Array} */
  HEAPU8,
/** @type {Int16Array} */
  HEAP16,
/** @type {Uint16Array} */
  HEAPU16,
/** @type {Int32Array} */
  HEAP32,
/** @type {Uint32Array} */
  HEAPU32,
/** @type {Float32Array} */
  HEAPF32,
/** @type {Float64Array} */
  HEAPF64;

function updateGlobalBuffer(buf) {
  Module['buffer'] = buffer = buf;
}

function updateGlobalBufferViews() {
  Module['HEAP8'] = HEAP8 = new Int8Array(buffer);
  Module['HEAP16'] = HEAP16 = new Int16Array(buffer);
  Module['HEAP32'] = HEAP32 = new Int32Array(buffer);
  Module['HEAPU8'] = HEAPU8 = new Uint8Array(buffer);
  Module['HEAPU16'] = HEAPU16 = new Uint16Array(buffer);
  Module['HEAPU32'] = HEAPU32 = new Uint32Array(buffer);
  Module['HEAPF32'] = HEAPF32 = new Float32Array(buffer);
  Module['HEAPF64'] = HEAPF64 = new Float64Array(buffer);
}

var STATIC_BASE, STATICTOP, staticSealed; // static area
var STACK_BASE, STACKTOP, STACK_MAX; // stack area
var DYNAMIC_BASE, DYNAMICTOP_PTR; // dynamic area handled by sbrk

  STATIC_BASE = STATICTOP = STACK_BASE = STACKTOP = STACK_MAX = DYNAMIC_BASE = DYNAMICTOP_PTR = 0;
  staticSealed = false;


// Initializes the stack cookie. Called at the startup of main and at the startup of each thread in pthreads mode.
function writeStackCookie() {
  assert((STACK_MAX & 3) == 0);
  HEAPU32[(STACK_MAX >> 2)-1] = 0x02135467;
  HEAPU32[(STACK_MAX >> 2)-2] = 0x89BACDFE;
}

function checkStackCookie() {
  if (HEAPU32[(STACK_MAX >> 2)-1] != 0x02135467 || HEAPU32[(STACK_MAX >> 2)-2] != 0x89BACDFE) {
    abort('Stack overflow! Stack cookie has been overwritten, expected hex dwords 0x89BACDFE and 0x02135467, but received 0x' + HEAPU32[(STACK_MAX >> 2)-2].toString(16) + ' ' + HEAPU32[(STACK_MAX >> 2)-1].toString(16));
  }
  // Also test the global address 0 for integrity. This check is not compatible with SAFE_SPLIT_MEMORY though, since that mode already tests all address 0 accesses on its own.
  if (HEAP32[0] !== 0x63736d65 /* 'emsc' */) throw 'Runtime error: The application has corrupted its heap memory area (address zero)!';
}

function abortStackOverflow(allocSize) {
  abort('Stack overflow! Attempted to allocate ' + allocSize + ' bytes on the stack, but stack has only ' + (STACK_MAX - stackSave() + allocSize) + ' bytes available!');
}

function abortOnCannotGrowMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ');
}


function enlargeMemory() {
  abortOnCannotGrowMemory();
}


var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 167772160;
if (TOTAL_MEMORY < TOTAL_STACK) Module.printErr('TOTAL_MEMORY should be larger than TOTAL_STACK, was ' + TOTAL_MEMORY + '! (TOTAL_STACK=' + TOTAL_STACK + ')');

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && Int32Array.prototype.subarray !== undefined && Int32Array.prototype.set !== undefined,
       'JS engine does not provide full typed array support');



// Use a provided buffer, if there is one, or else allocate a new one
if (Module['buffer']) {
  buffer = Module['buffer'];
  assert(buffer.byteLength === TOTAL_MEMORY, 'provided buffer should be ' + TOTAL_MEMORY + ' bytes, but it is ' + buffer.byteLength);
} else {
  // Use a WebAssembly memory where available
  {
    buffer = new ArrayBuffer(TOTAL_MEMORY);
  }
  assert(buffer.byteLength === TOTAL_MEMORY);
  Module['buffer'] = buffer;
}
updateGlobalBufferViews();


function getTotalMemory() {
  return TOTAL_MEMORY;
}

// Endianness check (note: assumes compiler arch was little-endian)
  HEAP32[0] = 0x63736d65; /* 'emsc' */
HEAP16[1] = 0x6373;
if (HEAPU8[2] !== 0x73 || HEAPU8[3] !== 0x63) throw 'Runtime error: expected the system to be little-endian!';

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Module['dynCall_v'](func);
      } else {
        Module['dynCall_vi'](func, callback.arg);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the main() is called

var runtimeInitialized = false;
var runtimeExited = false;


function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  checkStackCookie();
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  checkStackCookie();
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  checkStackCookie();
  callRuntimeCallbacks(__ATEXIT__);
  runtimeExited = true;
}

function postRun() {
  checkStackCookie();
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}

// Deprecated: This function should not be called because it is unsafe and does not provide
// a maximum length limit of how many bytes it is allowed to write. Prefer calling the
// function stringToUTF8Array() instead, which takes in a maximum length that can be used
// to be secure from out of bounds writes.
/** @deprecated */
function writeStringToMemory(string, buffer, dontAddNull) {
  warnOnce('writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!');

  var /** @type {number} */ lastChar, /** @type {number} */ end;
  if (dontAddNull) {
    // stringToUTF8Array always appends null. If we don't want to do that, remember the
    // character that existed at the location where the null will be placed, and restore
    // that after the write (below).
    end = buffer + lengthBytesUTF8(string);
    lastChar = HEAP8[end];
  }
  stringToUTF8(string, buffer, Infinity);
  if (dontAddNull) HEAP8[end] = lastChar; // Restore the value under the null character.
}

function writeArrayToMemory(array, buffer) {
  assert(array.length >= 0, 'writeArrayToMemory array must have a length (should be an array or typed array)')
  HEAP8.set(array, buffer);
}

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    assert(str.charCodeAt(i) === str.charCodeAt(i)&0xff);
    HEAP8[((buffer++)>>0)]=str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)]=0;
}

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}

assert(Math['imul'] && Math['fround'] && Math['clz32'] && Math['trunc'], 'this is a legacy browser, build with LEGACY_VM_SUPPORT');

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_round = Math.round;
var Math_min = Math.min;
var Math_max = Math.max;
var Math_clz32 = Math.clz32;
var Math_trunc = Math.trunc;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
var runDependencyTracking = {};

function getUniqueRunDependency(id) {
  var orig = id;
  while (1) {
    if (!runDependencyTracking[id]) return id;
    id = orig + Math.random();
  }
  return id;
}

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        if (ABORT) {
          clearInterval(runDependencyWatcher);
          runDependencyWatcher = null;
          return;
        }
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            Module.printErr('still waiting on run dependencies:');
          }
          Module.printErr('dependency: ' + dep);
        }
        if (shown) {
          Module.printErr('(end of list)');
        }
      }, 10000);
    }
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}

function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data



var memoryInitializer = null;



var /* show errors on likely calls to FS when it was not included */ FS = {
  error: function() {
    abort('Filesystem support (FS) was not included. The problem is that you are using files from JS, but files were not used from C/C++, so filesystem support was not auto-included. You can force-include filesystem support with  -s FORCE_FILESYSTEM=1');
  },
  init: function() { FS.error() },
  createDataFile: function() { FS.error() },
  createPreloadedFile: function() { FS.error() },
  createLazyFile: function() { FS.error() },
  open: function() { FS.error() },
  mkdev: function() { FS.error() },
  registerDevice: function() { FS.error() },
  analyzePath: function() { FS.error() },
  loadFilesFromDB: function() { FS.error() },

  ErrnoError: function ErrnoError() { FS.error() },
};
Module['FS_createDataFile'] = FS.createDataFile;
Module['FS_createPreloadedFile'] = FS.createPreloadedFile;



// Prefix of data URIs emitted by SINGLE_FILE and related options.
var dataURIPrefix = 'data:application/octet-stream;base64,';

// Indicates whether filename is a base64 data URI.
function isDataURI(filename) {
  return String.prototype.startsWith ?
      filename.startsWith(dataURIPrefix) :
      filename.indexOf(dataURIPrefix) === 0;
}





// === Body ===

var ASM_CONSTS = [];





STATIC_BASE = GLOBAL_BASE;

STATICTOP = STATIC_BASE + 22928;
/* global initializers */  __ATINIT__.push({ func: function() { __GLOBAL__sub_I_laz_perf_cpp() } }, { func: function() { __GLOBAL__sub_I_bind_cpp() } });


memoryInitializer = "data:application/octet-stream;base64,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";





/* no memory initializer */
var tempDoublePtr = STATICTOP; STATICTOP += 16;

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}

// {{PRE_LIBRARY}}


  function ___assert_fail(condition, filename, line, func) {
      abort('Assertion failed: ' + Pointer_stringify(condition) + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function']);
    }

  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }


  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }

  var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:function (adjusted) {
        if (!adjusted || EXCEPTIONS.infos[adjusted]) return adjusted;
        for (var key in EXCEPTIONS.infos) {
          var ptr = +key; // the iteration key is a string, and if we throw this, it must be an integer as that is what we look for
          var info = EXCEPTIONS.infos[ptr];
          if (info.adjusted === adjusted) {
            return ptr;
          }
        }
        return adjusted;
      },addRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        info.refcount++;
      },decRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        assert(info.refcount > 0);
        info.refcount--;
        // A rethrown exception can reach refcount 0; it must not be discarded
        // Its next handler will clear the rethrown flag and addRef it, prior to
        // final decRef and destruction here
        if (info.refcount === 0 && !info.rethrown) {
          if (info.destructor) {
            Module['dynCall_vi'](info.destructor, ptr);
          }
          delete EXCEPTIONS.infos[ptr];
          ___cxa_free_exception(ptr);
        }
      },clearRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        info.refcount = 0;
      }};function ___cxa_begin_catch(ptr) {
      var info = EXCEPTIONS.infos[ptr];
      if (info && !info.caught) {
        info.caught = true;
        __ZSt18uncaught_exceptionv.uncaught_exception--;
      }
      if (info) info.rethrown = false;
      EXCEPTIONS.caught.push(ptr);
      EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));
      return ptr;
    }

  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }



  function ___resumeException(ptr) {
      if (!EXCEPTIONS.last) { EXCEPTIONS.last = ptr; }
      throw ptr;
    }function ___cxa_find_matching_catch() {
      var thrown = EXCEPTIONS.last;
      if (!thrown) {
        // just pass through the null ptr
        return ((setTempRet0(0),0)|0);
      }
      var info = EXCEPTIONS.infos[thrown];
      var throwntype = info.type;
      if (!throwntype) {
        // just pass through the thrown ptr
        return ((setTempRet0(0),thrown)|0);
      }
      var typeArray = Array.prototype.slice.call(arguments);

      var pointer = Module['___cxa_is_pointer_type'](throwntype);
      // can_catch receives a **, add indirection
      if (!___cxa_find_matching_catch.buffer) ___cxa_find_matching_catch.buffer = _malloc(4);
      HEAP32[((___cxa_find_matching_catch.buffer)>>2)]=thrown;
      thrown = ___cxa_find_matching_catch.buffer;
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (typeArray[i] && Module['___cxa_can_catch'](typeArray[i], throwntype, thrown)) {
          thrown = HEAP32[((thrown)>>2)]; // undo indirection
          info.adjusted = thrown;
          return ((setTempRet0(typeArray[i]),thrown)|0);
        }
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      thrown = HEAP32[((thrown)>>2)]; // undo indirection
      return ((setTempRet0(throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      EXCEPTIONS.infos[ptr] = {
        ptr: ptr,
        adjusted: ptr,
        type: type,
        destructor: destructor,
        refcount: 0,
        caught: false,
        rethrown: false
      };
      EXCEPTIONS.last = ptr;
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr;
    }

  function ___gxx_personality_v0() {
    }

  function ___lock() {}





  var SYSCALLS={varargs:0,get:function (varargs) {
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function () {
        var ret = Pointer_stringify(SYSCALLS.get());
        return ret;
      },get64:function () {
        var low = SYSCALLS.get(), high = SYSCALLS.get();
        if (low >= 0) assert(high === 0);
        else assert(high === -1);
        return low;
      },getZero:function () {
        assert(SYSCALLS.get() === 0);
      }};function ___syscall140(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // llseek
      var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(), result = SYSCALLS.get(), whence = SYSCALLS.get();
      // NOTE: offset_high is unused - Emscripten's off_t is 32-bit
      var offset = offset_low;
      FS.llseek(stream, offset, whence);
      HEAP32[((result)>>2)]=stream.position;
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }


  function flush_NO_FILESYSTEM() {
      // flush anything remaining in the buffers during shutdown
      var fflush = Module["_fflush"];
      if (fflush) fflush(0);
      var printChar = ___syscall146.printChar;
      if (!printChar) return;
      var buffers = ___syscall146.buffers;
      if (buffers[1].length) printChar(1, 10);
      if (buffers[2].length) printChar(2, 10);
    }function ___syscall146(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // writev
      // hack to support printf in NO_FILESYSTEM
      var stream = SYSCALLS.get(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      var ret = 0;
      if (!___syscall146.buffers) {
        ___syscall146.buffers = [null, [], []]; // 1 => stdout, 2 => stderr
        ___syscall146.printChar = function(stream, curr) {
          var buffer = ___syscall146.buffers[stream];
          assert(buffer);
          if (curr === 0 || curr === 10) {
            (stream === 1 ? Module['print'] : Module['printErr'])(UTF8ArrayToString(buffer, 0));
            buffer.length = 0;
          } else {
            buffer.push(curr);
          }
        };
      }
      for (var i = 0; i < iovcnt; i++) {
        var ptr = HEAP32[(((iov)+(i*8))>>2)];
        var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
        for (var j = 0; j < len; j++) {
          ___syscall146.printChar(stream, HEAPU8[ptr+j]);
        }
        ret += len;
      }
      return ret;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall54(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ioctl
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall6(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // close
      var stream = SYSCALLS.getStreamFromFD();
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }









  function ___unlock() {}


  function getShiftFromSize(size) {
      switch (size) {
          case 1: return 0;
          case 2: return 1;
          case 4: return 2;
          case 8: return 3;
          default:
              throw new TypeError('Unknown type size: ' + size);
      }
    }



  function embind_init_charCodes() {
      var codes = new Array(256);
      for (var i = 0; i < 256; ++i) {
          codes[i] = String.fromCharCode(i);
      }
      embind_charCodes = codes;
    }var embind_charCodes=undefined;function readLatin1String(ptr) {
      var ret = "";
      var c = ptr;
      while (HEAPU8[c]) {
          ret += embind_charCodes[HEAPU8[c++]];
      }
      return ret;
    }


  var awaitingDependencies={};

  var registeredTypes={};

  var typeDependencies={};






  var char_0=48;

  var char_9=57;function makeLegalFunctionName(name) {
      if (undefined === name) {
          return '_unknown';
      }
      name = name.replace(/[^a-zA-Z0-9_]/g, '$');
      var f = name.charCodeAt(0);
      if (f >= char_0 && f <= char_9) {
          return '_' + name;
      } else {
          return name;
      }
    }function createNamedFunction(name, body) {
      name = makeLegalFunctionName(name);
      /*jshint evil:true*/
      return new Function(
          "body",
          "return function " + name + "() {\n" +
          "    \"use strict\";" +
          "    return body.apply(this, arguments);\n" +
          "};\n"
      )(body);
    }function extendError(baseErrorType, errorName) {
      var errorClass = createNamedFunction(errorName, function(message) {
          this.name = errorName;
          this.message = message;

          var stack = (new Error(message)).stack;
          if (stack !== undefined) {
              this.stack = this.toString() + '\n' +
                  stack.replace(/^Error(:[^\n]*)?\n/, '');
          }
      });
      errorClass.prototype = Object.create(baseErrorType.prototype);
      errorClass.prototype.constructor = errorClass;
      errorClass.prototype.toString = function() {
          if (this.message === undefined) {
              return this.name;
          } else {
              return this.name + ': ' + this.message;
          }
      };

      return errorClass;
    }var BindingError=undefined;function throwBindingError(message) {
      throw new BindingError(message);
    }



  var InternalError=undefined;function throwInternalError(message) {
      throw new InternalError(message);
    }function whenDependentTypesAreResolved(myTypes, dependentTypes, getTypeConverters) {
      myTypes.forEach(function(type) {
          typeDependencies[type] = dependentTypes;
      });

      function onComplete(typeConverters) {
          var myTypeConverters = getTypeConverters(typeConverters);
          if (myTypeConverters.length !== myTypes.length) {
              throwInternalError('Mismatched type converter count');
          }
          for (var i = 0; i < myTypes.length; ++i) {
              registerType(myTypes[i], myTypeConverters[i]);
          }
      }

      var typeConverters = new Array(dependentTypes.length);
      var unregisteredTypes = [];
      var registered = 0;
      dependentTypes.forEach(function(dt, i) {
          if (registeredTypes.hasOwnProperty(dt)) {
              typeConverters[i] = registeredTypes[dt];
          } else {
              unregisteredTypes.push(dt);
              if (!awaitingDependencies.hasOwnProperty(dt)) {
                  awaitingDependencies[dt] = [];
              }
              awaitingDependencies[dt].push(function() {
                  typeConverters[i] = registeredTypes[dt];
                  ++registered;
                  if (registered === unregisteredTypes.length) {
                      onComplete(typeConverters);
                  }
              });
          }
      });
      if (0 === unregisteredTypes.length) {
          onComplete(typeConverters);
      }
    }function registerType(rawType, registeredInstance, options) {
      options = options || {};

      if (!('argPackAdvance' in registeredInstance)) {
          throw new TypeError('registerType registeredInstance requires argPackAdvance');
      }

      var name = registeredInstance.name;
      if (!rawType) {
          throwBindingError('type "' + name + '" must have a positive integer typeid pointer');
      }
      if (registeredTypes.hasOwnProperty(rawType)) {
          if (options.ignoreDuplicateRegistrations) {
              return;
          } else {
              throwBindingError("Cannot register type '" + name + "' twice");
          }
      }

      registeredTypes[rawType] = registeredInstance;
      delete typeDependencies[rawType];

      if (awaitingDependencies.hasOwnProperty(rawType)) {
          var callbacks = awaitingDependencies[rawType];
          delete awaitingDependencies[rawType];
          callbacks.forEach(function(cb) {
              cb();
          });
      }
    }function __embind_register_bool(rawType, name, size, trueValue, falseValue) {
      var shift = getShiftFromSize(size);

      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(wt) {
              // ambiguous emscripten ABI: sometimes return values are
              // true or false, and sometimes integers (0 or 1)
              return !!wt;
          },
          'toWireType': function(destructors, o) {
              return o ? trueValue : falseValue;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': function(pointer) {
              // TODO: if heap is fixed (like in asm.js) this could be executed outside
              var heap;
              if (size === 1) {
                  heap = HEAP8;
              } else if (size === 2) {
                  heap = HEAP16;
              } else if (size === 4) {
                  heap = HEAP32;
              } else {
                  throw new TypeError("Unknown boolean type size: " + name);
              }
              return this['fromWireType'](heap[pointer >> shift]);
          },
          destructorFunction: null, // This type does not need a destructor
      });
    }




  function ClassHandle_isAliasOf(other) {
      if (!(this instanceof ClassHandle)) {
          return false;
      }
      if (!(other instanceof ClassHandle)) {
          return false;
      }

      var leftClass = this.$$.ptrType.registeredClass;
      var left = this.$$.ptr;
      var rightClass = other.$$.ptrType.registeredClass;
      var right = other.$$.ptr;

      while (leftClass.baseClass) {
          left = leftClass.upcast(left);
          leftClass = leftClass.baseClass;
      }

      while (rightClass.baseClass) {
          right = rightClass.upcast(right);
          rightClass = rightClass.baseClass;
      }

      return leftClass === rightClass && left === right;
    }


  function shallowCopyInternalPointer(o) {
      return {
          count: o.count,
          deleteScheduled: o.deleteScheduled,
          preservePointerOnDelete: o.preservePointerOnDelete,
          ptr: o.ptr,
          ptrType: o.ptrType,
          smartPtr: o.smartPtr,
          smartPtrType: o.smartPtrType,
      };
    }

  function throwInstanceAlreadyDeleted(obj) {
      function getInstanceTypeName(handle) {
        return handle.$$.ptrType.registeredClass.name;
      }
      throwBindingError(getInstanceTypeName(obj) + ' instance already deleted');
    }function ClassHandle_clone() {
      if (!this.$$.ptr) {
          throwInstanceAlreadyDeleted(this);
      }

      if (this.$$.preservePointerOnDelete) {
          this.$$.count.value += 1;
          return this;
      } else {
          var clone = Object.create(Object.getPrototypeOf(this), {
              $$: {
                  value: shallowCopyInternalPointer(this.$$),
              }
          });

          clone.$$.count.value += 1;
          clone.$$.deleteScheduled = false;
          return clone;
      }
    }


  function runDestructor(handle) {
      var $$ = handle.$$;
      if ($$.smartPtr) {
          $$.smartPtrType.rawDestructor($$.smartPtr);
      } else {
          $$.ptrType.registeredClass.rawDestructor($$.ptr);
      }
    }function ClassHandle_delete() {
      if (!this.$$.ptr) {
          throwInstanceAlreadyDeleted(this);
      }

      if (this.$$.deleteScheduled && !this.$$.preservePointerOnDelete) {
          throwBindingError('Object already scheduled for deletion');
      }

      this.$$.count.value -= 1;
      var toDelete = 0 === this.$$.count.value;
      if (toDelete) {
          runDestructor(this);
      }
      if (!this.$$.preservePointerOnDelete) {
          this.$$.smartPtr = undefined;
          this.$$.ptr = undefined;
      }
    }

  function ClassHandle_isDeleted() {
      return !this.$$.ptr;
    }


  var delayFunction=undefined;

  var deletionQueue=[];

  function flushPendingDeletes() {
      while (deletionQueue.length) {
          var obj = deletionQueue.pop();
          obj.$$.deleteScheduled = false;
          obj['delete']();
      }
    }function ClassHandle_deleteLater() {
      if (!this.$$.ptr) {
          throwInstanceAlreadyDeleted(this);
      }
      if (this.$$.deleteScheduled && !this.$$.preservePointerOnDelete) {
          throwBindingError('Object already scheduled for deletion');
      }
      deletionQueue.push(this);
      if (deletionQueue.length === 1 && delayFunction) {
          delayFunction(flushPendingDeletes);
      }
      this.$$.deleteScheduled = true;
      return this;
    }function init_ClassHandle() {
      ClassHandle.prototype['isAliasOf'] = ClassHandle_isAliasOf;
      ClassHandle.prototype['clone'] = ClassHandle_clone;
      ClassHandle.prototype['delete'] = ClassHandle_delete;
      ClassHandle.prototype['isDeleted'] = ClassHandle_isDeleted;
      ClassHandle.prototype['deleteLater'] = ClassHandle_deleteLater;
    }function ClassHandle() {
    }

  var registeredPointers={};


  function ensureOverloadTable(proto, methodName, humanName) {
      if (undefined === proto[methodName].overloadTable) {
          var prevFunc = proto[methodName];
          // Inject an overload resolver function that routes to the appropriate overload based on the number of arguments.
          proto[methodName] = function() {
              // TODO This check can be removed in -O3 level "unsafe" optimizations.
              if (!proto[methodName].overloadTable.hasOwnProperty(arguments.length)) {
                  throwBindingError("Function '" + humanName + "' called with an invalid number of arguments (" + arguments.length + ") - expects one of (" + proto[methodName].overloadTable + ")!");
              }
              return proto[methodName].overloadTable[arguments.length].apply(this, arguments);
          };
          // Move the previous function into the overload table.
          proto[methodName].overloadTable = [];
          proto[methodName].overloadTable[prevFunc.argCount] = prevFunc;
      }
    }function exposePublicSymbol(name, value, numArguments) {
      if (Module.hasOwnProperty(name)) {
          if (undefined === numArguments || (undefined !== Module[name].overloadTable && undefined !== Module[name].overloadTable[numArguments])) {
              throwBindingError("Cannot register public name '" + name + "' twice");
          }

          // We are exposing a function with the same name as an existing function. Create an overload table and a function selector
          // that routes between the two.
          ensureOverloadTable(Module, name, name);
          if (Module.hasOwnProperty(numArguments)) {
              throwBindingError("Cannot register multiple overloads of a function with the same number of arguments (" + numArguments + ")!");
          }
          // Add the new function into the overload table.
          Module[name].overloadTable[numArguments] = value;
      }
      else {
          Module[name] = value;
          if (undefined !== numArguments) {
              Module[name].numArguments = numArguments;
          }
      }
    }

  function RegisteredClass(
      name,
      constructor,
      instancePrototype,
      rawDestructor,
      baseClass,
      getActualType,
      upcast,
      downcast
    ) {
      this.name = name;
      this.constructor = constructor;
      this.instancePrototype = instancePrototype;
      this.rawDestructor = rawDestructor;
      this.baseClass = baseClass;
      this.getActualType = getActualType;
      this.upcast = upcast;
      this.downcast = downcast;
      this.pureVirtualFunctions = [];
    }



  function upcastPointer(ptr, ptrClass, desiredClass) {
      while (ptrClass !== desiredClass) {
          if (!ptrClass.upcast) {
              throwBindingError("Expected null or instance of " + desiredClass.name + ", got an instance of " + ptrClass.name);
          }
          ptr = ptrClass.upcast(ptr);
          ptrClass = ptrClass.baseClass;
      }
      return ptr;
    }function constNoSmartPtrRawPointerToWireType(destructors, handle) {
      if (handle === null) {
          if (this.isReference) {
              throwBindingError('null is not a valid ' + this.name);
          }
          return 0;
      }

      if (!handle.$$) {
          throwBindingError('Cannot pass "' + _embind_repr(handle) + '" as a ' + this.name);
      }
      if (!handle.$$.ptr) {
          throwBindingError('Cannot pass deleted object as a pointer of type ' + this.name);
      }
      var handleClass = handle.$$.ptrType.registeredClass;
      var ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
      return ptr;
    }

  function genericPointerToWireType(destructors, handle) {
      var ptr;
      if (handle === null) {
          if (this.isReference) {
              throwBindingError('null is not a valid ' + this.name);
          }

          if (this.isSmartPointer) {
              ptr = this.rawConstructor();
              if (destructors !== null) {
                  destructors.push(this.rawDestructor, ptr);
              }
              return ptr;
          } else {
              return 0;
          }
      }

      if (!handle.$$) {
          throwBindingError('Cannot pass "' + _embind_repr(handle) + '" as a ' + this.name);
      }
      if (!handle.$$.ptr) {
          throwBindingError('Cannot pass deleted object as a pointer of type ' + this.name);
      }
      if (!this.isConst && handle.$$.ptrType.isConst) {
          throwBindingError('Cannot convert argument of type ' + (handle.$$.smartPtrType ? handle.$$.smartPtrType.name : handle.$$.ptrType.name) + ' to parameter type ' + this.name);
      }
      var handleClass = handle.$$.ptrType.registeredClass;
      ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);

      if (this.isSmartPointer) {
          // TODO: this is not strictly true
          // We could support BY_EMVAL conversions from raw pointers to smart pointers
          // because the smart pointer can hold a reference to the handle
          if (undefined === handle.$$.smartPtr) {
              throwBindingError('Passing raw pointer to smart pointer is illegal');
          }

          switch (this.sharingPolicy) {
              case 0: // NONE
                  // no upcasting
                  if (handle.$$.smartPtrType === this) {
                      ptr = handle.$$.smartPtr;
                  } else {
                      throwBindingError('Cannot convert argument of type ' + (handle.$$.smartPtrType ? handle.$$.smartPtrType.name : handle.$$.ptrType.name) + ' to parameter type ' + this.name);
                  }
                  break;

              case 1: // INTRUSIVE
                  ptr = handle.$$.smartPtr;
                  break;

              case 2: // BY_EMVAL
                  if (handle.$$.smartPtrType === this) {
                      ptr = handle.$$.smartPtr;
                  } else {
                      var clonedHandle = handle['clone']();
                      ptr = this.rawShare(
                          ptr,
                          __emval_register(function() {
                              clonedHandle['delete']();
                          })
                      );
                      if (destructors !== null) {
                          destructors.push(this.rawDestructor, ptr);
                      }
                  }
                  break;

              default:
                  throwBindingError('Unsupporting sharing policy');
          }
      }
      return ptr;
    }

  function nonConstNoSmartPtrRawPointerToWireType(destructors, handle) {
      if (handle === null) {
          if (this.isReference) {
              throwBindingError('null is not a valid ' + this.name);
          }
          return 0;
      }

      if (!handle.$$) {
          throwBindingError('Cannot pass "' + _embind_repr(handle) + '" as a ' + this.name);
      }
      if (!handle.$$.ptr) {
          throwBindingError('Cannot pass deleted object as a pointer of type ' + this.name);
      }
      if (handle.$$.ptrType.isConst) {
          throwBindingError('Cannot convert argument of type ' + handle.$$.ptrType.name + ' to parameter type ' + this.name);
      }
      var handleClass = handle.$$.ptrType.registeredClass;
      var ptr = upcastPointer(handle.$$.ptr, handleClass, this.registeredClass);
      return ptr;
    }


  function simpleReadValueFromPointer(pointer) {
      return this['fromWireType'](HEAPU32[pointer >> 2]);
    }

  function RegisteredPointer_getPointee(ptr) {
      if (this.rawGetPointee) {
          ptr = this.rawGetPointee(ptr);
      }
      return ptr;
    }

  function RegisteredPointer_destructor(ptr) {
      if (this.rawDestructor) {
          this.rawDestructor(ptr);
      }
    }

  function RegisteredPointer_deleteObject(handle) {
      if (handle !== null) {
          handle['delete']();
      }
    }


  function downcastPointer(ptr, ptrClass, desiredClass) {
      if (ptrClass === desiredClass) {
          return ptr;
      }
      if (undefined === desiredClass.baseClass) {
          return null; // no conversion
      }

      var rv = downcastPointer(ptr, ptrClass, desiredClass.baseClass);
      if (rv === null) {
          return null;
      }
      return desiredClass.downcast(rv);
    }




  function getInheritedInstanceCount() {
      return Object.keys(registeredInstances).length;
    }

  function getLiveInheritedInstances() {
      var rv = [];
      for (var k in registeredInstances) {
          if (registeredInstances.hasOwnProperty(k)) {
              rv.push(registeredInstances[k]);
          }
      }
      return rv;
    }

  function setDelayFunction(fn) {
      delayFunction = fn;
      if (deletionQueue.length && delayFunction) {
          delayFunction(flushPendingDeletes);
      }
    }function init_embind() {
      Module['getInheritedInstanceCount'] = getInheritedInstanceCount;
      Module['getLiveInheritedInstances'] = getLiveInheritedInstances;
      Module['flushPendingDeletes'] = flushPendingDeletes;
      Module['setDelayFunction'] = setDelayFunction;
    }var registeredInstances={};

  function getBasestPointer(class_, ptr) {
      if (ptr === undefined) {
          throwBindingError('ptr should not be undefined');
      }
      while (class_.baseClass) {
          ptr = class_.upcast(ptr);
          class_ = class_.baseClass;
      }
      return ptr;
    }function getInheritedInstance(class_, ptr) {
      ptr = getBasestPointer(class_, ptr);
      return registeredInstances[ptr];
    }

  function makeClassHandle(prototype, record) {
      if (!record.ptrType || !record.ptr) {
          throwInternalError('makeClassHandle requires ptr and ptrType');
      }
      var hasSmartPtrType = !!record.smartPtrType;
      var hasSmartPtr = !!record.smartPtr;
      if (hasSmartPtrType !== hasSmartPtr) {
          throwInternalError('Both smartPtrType and smartPtr must be specified');
      }
      record.count = { value: 1 };
      return Object.create(prototype, {
          $$: {
              value: record,
          },
      });
    }function RegisteredPointer_fromWireType(ptr) {
      // ptr is a raw pointer (or a raw smartpointer)

      // rawPointer is a maybe-null raw pointer
      var rawPointer = this.getPointee(ptr);
      if (!rawPointer) {
          this.destructor(ptr);
          return null;
      }

      var registeredInstance = getInheritedInstance(this.registeredClass, rawPointer);
      if (undefined !== registeredInstance) {
          // JS object has been neutered, time to repopulate it
          if (0 === registeredInstance.$$.count.value) {
              registeredInstance.$$.ptr = rawPointer;
              registeredInstance.$$.smartPtr = ptr;
              return registeredInstance['clone']();
          } else {
              // else, just increment reference count on existing object
              // it already has a reference to the smart pointer
              var rv = registeredInstance['clone']();
              this.destructor(ptr);
              return rv;
          }
      }

      function makeDefaultHandle() {
          if (this.isSmartPointer) {
              return makeClassHandle(this.registeredClass.instancePrototype, {
                  ptrType: this.pointeeType,
                  ptr: rawPointer,
                  smartPtrType: this,
                  smartPtr: ptr,
              });
          } else {
              return makeClassHandle(this.registeredClass.instancePrototype, {
                  ptrType: this,
                  ptr: ptr,
              });
          }
      }

      var actualType = this.registeredClass.getActualType(rawPointer);
      var registeredPointerRecord = registeredPointers[actualType];
      if (!registeredPointerRecord) {
          return makeDefaultHandle.call(this);
      }

      var toType;
      if (this.isConst) {
          toType = registeredPointerRecord.constPointerType;
      } else {
          toType = registeredPointerRecord.pointerType;
      }
      var dp = downcastPointer(
          rawPointer,
          this.registeredClass,
          toType.registeredClass);
      if (dp === null) {
          return makeDefaultHandle.call(this);
      }
      if (this.isSmartPointer) {
          return makeClassHandle(toType.registeredClass.instancePrototype, {
              ptrType: toType,
              ptr: dp,
              smartPtrType: this,
              smartPtr: ptr,
          });
      } else {
          return makeClassHandle(toType.registeredClass.instancePrototype, {
              ptrType: toType,
              ptr: dp,
          });
      }
    }function init_RegisteredPointer() {
      RegisteredPointer.prototype.getPointee = RegisteredPointer_getPointee;
      RegisteredPointer.prototype.destructor = RegisteredPointer_destructor;
      RegisteredPointer.prototype['argPackAdvance'] = 8;
      RegisteredPointer.prototype['readValueFromPointer'] = simpleReadValueFromPointer;
      RegisteredPointer.prototype['deleteObject'] = RegisteredPointer_deleteObject;
      RegisteredPointer.prototype['fromWireType'] = RegisteredPointer_fromWireType;
    }function RegisteredPointer(
      name,
      registeredClass,
      isReference,
      isConst,

      // smart pointer properties
      isSmartPointer,
      pointeeType,
      sharingPolicy,
      rawGetPointee,
      rawConstructor,
      rawShare,
      rawDestructor
    ) {
      this.name = name;
      this.registeredClass = registeredClass;
      this.isReference = isReference;
      this.isConst = isConst;

      // smart pointer properties
      this.isSmartPointer = isSmartPointer;
      this.pointeeType = pointeeType;
      this.sharingPolicy = sharingPolicy;
      this.rawGetPointee = rawGetPointee;
      this.rawConstructor = rawConstructor;
      this.rawShare = rawShare;
      this.rawDestructor = rawDestructor;

      if (!isSmartPointer && registeredClass.baseClass === undefined) {
          if (isConst) {
              this['toWireType'] = constNoSmartPtrRawPointerToWireType;
              this.destructorFunction = null;
          } else {
              this['toWireType'] = nonConstNoSmartPtrRawPointerToWireType;
              this.destructorFunction = null;
          }
      } else {
          this['toWireType'] = genericPointerToWireType;
          // Here we must leave this.destructorFunction undefined, since whether genericPointerToWireType returns
          // a pointer that needs to be freed up is runtime-dependent, and cannot be evaluated at registration time.
          // TODO: Create an alternative mechanism that allows removing the use of var destructors = []; array in
          //       craftInvokerFunction altogether.
      }
    }

  function replacePublicSymbol(name, value, numArguments) {
      if (!Module.hasOwnProperty(name)) {
          throwInternalError('Replacing nonexistant public symbol');
      }
      // If there's an overload table for this symbol, replace the symbol in the overload table instead.
      if (undefined !== Module[name].overloadTable && undefined !== numArguments) {
          Module[name].overloadTable[numArguments] = value;
      }
      else {
          Module[name] = value;
          Module[name].argCount = numArguments;
      }
    }

  function embind__requireFunction(signature, rawFunction) {
      signature = readLatin1String(signature);

      function makeDynCaller(dynCall) {
          var args = [];
          for (var i = 1; i < signature.length; ++i) {
              args.push('a' + i);
          }

          var name = 'dynCall_' + signature + '_' + rawFunction;
          var body = 'return function ' + name + '(' + args.join(', ') + ') {\n';
          body    += '    return dynCall(rawFunction' + (args.length ? ', ' : '') + args.join(', ') + ');\n';
          body    += '};\n';

          return (new Function('dynCall', 'rawFunction', body))(dynCall, rawFunction);
      }

      var fp;
      if (Module['FUNCTION_TABLE_' + signature] !== undefined) {
          fp = Module['FUNCTION_TABLE_' + signature][rawFunction];
      } else if (typeof FUNCTION_TABLE !== "undefined") {
          fp = FUNCTION_TABLE[rawFunction];
      } else {
          // asm.js does not give direct access to the function tables,
          // and thus we must go through the dynCall interface which allows
          // calling into a signature's function table by pointer value.
          //
          // https://github.com/dherman/asm.js/issues/83
          //
          // This has three main penalties:
          // - dynCall is another function call in the path from JavaScript to C++.
          // - JITs may not predict through the function table indirection at runtime.
          var dc = Module["asm"]['dynCall_' + signature];
          if (dc === undefined) {
              // We will always enter this branch if the signature
              // contains 'f' and PRECISE_F32 is not enabled.
              //
              // Try again, replacing 'f' with 'd'.
              dc = Module["asm"]['dynCall_' + signature.replace(/f/g, 'd')];
              if (dc === undefined) {
                  throwBindingError("No dynCall invoker for signature: " + signature);
              }
          }
          fp = makeDynCaller(dc);
      }

      if (typeof fp !== "function") {
          throwBindingError("unknown function pointer with signature " + signature + ": " + rawFunction);
      }
      return fp;
    }


  var UnboundTypeError=undefined;

  function getTypeName(type) {
      var ptr = ___getTypeName(type);
      var rv = readLatin1String(ptr);
      _free(ptr);
      return rv;
    }function throwUnboundTypeError(message, types) {
      var unboundTypes = [];
      var seen = {};
      function visit(type) {
          if (seen[type]) {
              return;
          }
          if (registeredTypes[type]) {
              return;
          }
          if (typeDependencies[type]) {
              typeDependencies[type].forEach(visit);
              return;
          }
          unboundTypes.push(type);
          seen[type] = true;
      }
      types.forEach(visit);

      throw new UnboundTypeError(message + ': ' + unboundTypes.map(getTypeName).join([', ']));
    }function __embind_register_class(
      rawType,
      rawPointerType,
      rawConstPointerType,
      baseClassRawType,
      getActualTypeSignature,
      getActualType,
      upcastSignature,
      upcast,
      downcastSignature,
      downcast,
      name,
      destructorSignature,
      rawDestructor
    ) {
      name = readLatin1String(name);
      getActualType = embind__requireFunction(getActualTypeSignature, getActualType);
      if (upcast) {
          upcast = embind__requireFunction(upcastSignature, upcast);
      }
      if (downcast) {
          downcast = embind__requireFunction(downcastSignature, downcast);
      }
      rawDestructor = embind__requireFunction(destructorSignature, rawDestructor);
      var legalFunctionName = makeLegalFunctionName(name);

      exposePublicSymbol(legalFunctionName, function() {
          // this code cannot run if baseClassRawType is zero
          throwUnboundTypeError('Cannot construct ' + name + ' due to unbound types', [baseClassRawType]);
      });

      whenDependentTypesAreResolved(
          [rawType, rawPointerType, rawConstPointerType],
          baseClassRawType ? [baseClassRawType] : [],
          function(base) {
              base = base[0];

              var baseClass;
              var basePrototype;
              if (baseClassRawType) {
                  baseClass = base.registeredClass;
                  basePrototype = baseClass.instancePrototype;
              } else {
                  basePrototype = ClassHandle.prototype;
              }

              var constructor = createNamedFunction(legalFunctionName, function() {
                  if (Object.getPrototypeOf(this) !== instancePrototype) {
                      throw new BindingError("Use 'new' to construct " + name);
                  }
                  if (undefined === registeredClass.constructor_body) {
                      throw new BindingError(name + " has no accessible constructor");
                  }
                  var body = registeredClass.constructor_body[arguments.length];
                  if (undefined === body) {
                      throw new BindingError("Tried to invoke ctor of " + name + " with invalid number of parameters (" + arguments.length + ") - expected (" + Object.keys(registeredClass.constructor_body).toString() + ") parameters instead!");
                  }
                  return body.apply(this, arguments);
              });

              var instancePrototype = Object.create(basePrototype, {
                  constructor: { value: constructor },
              });

              constructor.prototype = instancePrototype;

              var registeredClass = new RegisteredClass(
                  name,
                  constructor,
                  instancePrototype,
                  rawDestructor,
                  baseClass,
                  getActualType,
                  upcast,
                  downcast);

              var referenceConverter = new RegisteredPointer(
                  name,
                  registeredClass,
                  true,
                  false,
                  false);

              var pointerConverter = new RegisteredPointer(
                  name + '*',
                  registeredClass,
                  false,
                  false,
                  false);

              var constPointerConverter = new RegisteredPointer(
                  name + ' const*',
                  registeredClass,
                  false,
                  true,
                  false);

              registeredPointers[rawType] = {
                  pointerType: pointerConverter,
                  constPointerType: constPointerConverter
              };

              replacePublicSymbol(legalFunctionName, constructor);

              return [referenceConverter, pointerConverter, constPointerConverter];
          }
      );
    }


  function heap32VectorToArray(count, firstElement) {
      var array = [];
      for (var i = 0; i < count; i++) {
          array.push(HEAP32[(firstElement >> 2) + i]);
      }
      return array;
    }

  function runDestructors(destructors) {
      while (destructors.length) {
          var ptr = destructors.pop();
          var del = destructors.pop();
          del(ptr);
      }
    }function __embind_register_class_constructor(
      rawClassType,
      argCount,
      rawArgTypesAddr,
      invokerSignature,
      invoker,
      rawConstructor
    ) {
      var rawArgTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
      invoker = embind__requireFunction(invokerSignature, invoker);

      whenDependentTypesAreResolved([], [rawClassType], function(classType) {
          classType = classType[0];
          var humanName = 'constructor ' + classType.name;

          if (undefined === classType.registeredClass.constructor_body) {
              classType.registeredClass.constructor_body = [];
          }
          if (undefined !== classType.registeredClass.constructor_body[argCount - 1]) {
              throw new BindingError("Cannot register multiple constructors with identical number of parameters (" + (argCount-1) + ") for class '" + classType.name + "'! Overload resolution is currently only performed using the parameter count, not actual type info!");
          }
          classType.registeredClass.constructor_body[argCount - 1] = function unboundTypeHandler() {
              throwUnboundTypeError('Cannot construct ' + classType.name + ' due to unbound types', rawArgTypes);
          };

          whenDependentTypesAreResolved([], rawArgTypes, function(argTypes) {
              classType.registeredClass.constructor_body[argCount - 1] = function constructor_body() {
                  if (arguments.length !== argCount - 1) {
                      throwBindingError(humanName + ' called with ' + arguments.length + ' arguments, expected ' + (argCount-1));
                  }
                  var destructors = [];
                  var args = new Array(argCount);
                  args[0] = rawConstructor;
                  for (var i = 1; i < argCount; ++i) {
                      args[i] = argTypes[i]['toWireType'](destructors, arguments[i - 1]);
                  }

                  var ptr = invoker.apply(null, args);
                  runDestructors(destructors);

                  return argTypes[0]['fromWireType'](ptr);
              };
              return [];
          });
          return [];
      });
    }



  function new_(constructor, argumentList) {
      if (!(constructor instanceof Function)) {
          throw new TypeError('new_ called with constructor type ' + typeof(constructor) + " which is not a function");
      }

      /*
       * Previously, the following line was just:

       function dummy() {};

       * Unfortunately, Chrome was preserving 'dummy' as the object's name, even though at creation, the 'dummy' has the
       * correct constructor name.  Thus, objects created with IMVU.new would show up in the debugger as 'dummy', which
       * isn't very helpful.  Using IMVU.createNamedFunction addresses the issue.  Doublely-unfortunately, there's no way
       * to write a test for this behavior.  -NRD 2013.02.22
       */
      var dummy = createNamedFunction(constructor.name || 'unknownFunctionName', function(){});
      dummy.prototype = constructor.prototype;
      var obj = new dummy;

      var r = constructor.apply(obj, argumentList);
      return (r instanceof Object) ? r : obj;
    }function craftInvokerFunction(humanName, argTypes, classType, cppInvokerFunc, cppTargetFunc) {
      // humanName: a human-readable string name for the function to be generated.
      // argTypes: An array that contains the embind type objects for all types in the function signature.
      //    argTypes[0] is the type object for the function return value.
      //    argTypes[1] is the type object for function this object/class type, or null if not crafting an invoker for a class method.
      //    argTypes[2...] are the actual function parameters.
      // classType: The embind type object for the class to be bound, or null if this is not a method of a class.
      // cppInvokerFunc: JS Function object to the C++-side function that interops into C++ code.
      // cppTargetFunc: Function pointer (an integer to FUNCTION_TABLE) to the target C++ function the cppInvokerFunc will end up calling.
      var argCount = argTypes.length;

      if (argCount < 2) {
          throwBindingError("argTypes array size mismatch! Must at least get return value and 'this' types!");
      }

      var isClassMethodFunc = (argTypes[1] !== null && classType !== null);

      // Free functions with signature "void function()" do not need an invoker that marshalls between wire types.
  // TODO: This omits argument count check - enable only at -O3 or similar.
  //    if (ENABLE_UNSAFE_OPTS && argCount == 2 && argTypes[0].name == "void" && !isClassMethodFunc) {
  //       return FUNCTION_TABLE[fn];
  //    }


      // Determine if we need to use a dynamic stack to store the destructors for the function parameters.
      // TODO: Remove this completely once all function invokers are being dynamically generated.
      var needsDestructorStack = false;

      for(var i = 1; i < argTypes.length; ++i) { // Skip return value at index 0 - it's not deleted here.
          if (argTypes[i] !== null && argTypes[i].destructorFunction === undefined) { // The type does not define a destructor function - must use dynamic stack
              needsDestructorStack = true;
              break;
          }
      }

      var returns = (argTypes[0].name !== "void");

      var argsList = "";
      var argsListWired = "";
      for(var i = 0; i < argCount - 2; ++i) {
          argsList += (i!==0?", ":"")+"arg"+i;
          argsListWired += (i!==0?", ":"")+"arg"+i+"Wired";
      }

      var invokerFnBody =
          "return function "+makeLegalFunctionName(humanName)+"("+argsList+") {\n" +
          "if (arguments.length !== "+(argCount - 2)+") {\n" +
              "throwBindingError('function "+humanName+" called with ' + arguments.length + ' arguments, expected "+(argCount - 2)+" args!');\n" +
          "}\n";


      if (needsDestructorStack) {
          invokerFnBody +=
              "var destructors = [];\n";
      }

      var dtorStack = needsDestructorStack ? "destructors" : "null";
      var args1 = ["throwBindingError", "invoker", "fn", "runDestructors", "retType", "classParam"];
      var args2 = [throwBindingError, cppInvokerFunc, cppTargetFunc, runDestructors, argTypes[0], argTypes[1]];


      if (isClassMethodFunc) {
          invokerFnBody += "var thisWired = classParam.toWireType("+dtorStack+", this);\n";
      }

      for(var i = 0; i < argCount - 2; ++i) {
          invokerFnBody += "var arg"+i+"Wired = argType"+i+".toWireType("+dtorStack+", arg"+i+"); // "+argTypes[i+2].name+"\n";
          args1.push("argType"+i);
          args2.push(argTypes[i+2]);
      }

      if (isClassMethodFunc) {
          argsListWired = "thisWired" + (argsListWired.length > 0 ? ", " : "") + argsListWired;
      }

      invokerFnBody +=
          (returns?"var rv = ":"") + "invoker(fn"+(argsListWired.length>0?", ":"")+argsListWired+");\n";

      if (needsDestructorStack) {
          invokerFnBody += "runDestructors(destructors);\n";
      } else {
          for(var i = isClassMethodFunc?1:2; i < argTypes.length; ++i) { // Skip return value at index 0 - it's not deleted here. Also skip class type if not a method.
              var paramName = (i === 1 ? "thisWired" : ("arg"+(i - 2)+"Wired"));
              if (argTypes[i].destructorFunction !== null) {
                  invokerFnBody += paramName+"_dtor("+paramName+"); // "+argTypes[i].name+"\n";
                  args1.push(paramName+"_dtor");
                  args2.push(argTypes[i].destructorFunction);
              }
          }
      }

      if (returns) {
          invokerFnBody += "var ret = retType.fromWireType(rv);\n" +
                           "return ret;\n";
      } else {
      }
      invokerFnBody += "}\n";

      args1.push(invokerFnBody);

      var invokerFunction = new_(Function, args1).apply(null, args2);
      return invokerFunction;
    }function __embind_register_class_function(
      rawClassType,
      methodName,
      argCount,
      rawArgTypesAddr, // [ReturnType, ThisType, Args...]
      invokerSignature,
      rawInvoker,
      context,
      isPureVirtual
    ) {
      var rawArgTypes = heap32VectorToArray(argCount, rawArgTypesAddr);
      methodName = readLatin1String(methodName);
      rawInvoker = embind__requireFunction(invokerSignature, rawInvoker);

      whenDependentTypesAreResolved([], [rawClassType], function(classType) {
          classType = classType[0];
          var humanName = classType.name + '.' + methodName;

          if (isPureVirtual) {
              classType.registeredClass.pureVirtualFunctions.push(methodName);
          }

          function unboundTypesHandler() {
              throwUnboundTypeError('Cannot call ' + humanName + ' due to unbound types', rawArgTypes);
          }

          var proto = classType.registeredClass.instancePrototype;
          var method = proto[methodName];
          if (undefined === method || (undefined === method.overloadTable && method.className !== classType.name && method.argCount === argCount - 2)) {
              // This is the first overload to be registered, OR we are replacing a function in the base class with a function in the derived class.
              unboundTypesHandler.argCount = argCount - 2;
              unboundTypesHandler.className = classType.name;
              proto[methodName] = unboundTypesHandler;
          } else {
              // There was an existing function with the same name registered. Set up a function overload routing table.
              ensureOverloadTable(proto, methodName, humanName);
              proto[methodName].overloadTable[argCount - 2] = unboundTypesHandler;
          }

          whenDependentTypesAreResolved([], rawArgTypes, function(argTypes) {

              var memberFunction = craftInvokerFunction(humanName, argTypes, classType, rawInvoker, context);

              // Replace the initial unbound-handler-stub function with the appropriate member function, now that all types
              // are resolved. If multiple overloads are registered for this function, the function goes into an overload table.
              if (undefined === proto[methodName].overloadTable) {
                  // Set argCount in case an overload is registered later
                  memberFunction.argCount = argCount - 2;
                  proto[methodName] = memberFunction;
              } else {
                  proto[methodName].overloadTable[argCount - 2] = memberFunction;
              }

              return [];
          });
          return [];
      });
    }



  var emval_free_list=[];

  var emval_handle_array=[{},{value:undefined},{value:null},{value:true},{value:false}];function __emval_decref(handle) {
      if (handle > 4 && 0 === --emval_handle_array[handle].refcount) {
          emval_handle_array[handle] = undefined;
          emval_free_list.push(handle);
      }
    }



  function count_emval_handles() {
      var count = 0;
      for (var i = 5; i < emval_handle_array.length; ++i) {
          if (emval_handle_array[i] !== undefined) {
              ++count;
          }
      }
      return count;
    }

  function get_first_emval() {
      for (var i = 5; i < emval_handle_array.length; ++i) {
          if (emval_handle_array[i] !== undefined) {
              return emval_handle_array[i];
          }
      }
      return null;
    }function init_emval() {
      Module['count_emval_handles'] = count_emval_handles;
      Module['get_first_emval'] = get_first_emval;
    }function __emval_register(value) {

      switch(value){
        case undefined :{ return 1; }
        case null :{ return 2; }
        case true :{ return 3; }
        case false :{ return 4; }
        default:{
          var handle = emval_free_list.length ?
              emval_free_list.pop() :
              emval_handle_array.length;

          emval_handle_array[handle] = {refcount: 1, value: value};
          return handle;
          }
        }
    }function __embind_register_emval(rawType, name) {
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(handle) {
              var rv = emval_handle_array[handle].value;
              __emval_decref(handle);
              return rv;
          },
          'toWireType': function(destructors, value) {
              return __emval_register(value);
          },
          'argPackAdvance': 8,
          'readValueFromPointer': simpleReadValueFromPointer,
          destructorFunction: null, // This type does not need a destructor

          // TODO: do we need a deleteObject here?  write a test where
          // emval is passed into JS via an interface
      });
    }


  function _embind_repr(v) {
      if (v === null) {
          return 'null';
      }
      var t = typeof v;
      if (t === 'object' || t === 'array' || t === 'function') {
          return v.toString();
      } else {
          return '' + v;
      }
    }

  function floatReadValueFromPointer(name, shift) {
      switch (shift) {
          case 2: return function(pointer) {
              return this['fromWireType'](HEAPF32[pointer >> 2]);
          };
          case 3: return function(pointer) {
              return this['fromWireType'](HEAPF64[pointer >> 3]);
          };
          default:
              throw new TypeError("Unknown float type: " + name);
      }
    }function __embind_register_float(rawType, name, size) {
      var shift = getShiftFromSize(size);
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(value) {
              return value;
          },
          'toWireType': function(destructors, value) {
              // todo: Here we have an opportunity for -O3 level "unsafe" optimizations: we could
              // avoid the following if() and assume value is of proper type.
              if (typeof value !== "number" && typeof value !== "boolean") {
                  throw new TypeError('Cannot convert "' + _embind_repr(value) + '" to ' + this.name);
              }
              return value;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': floatReadValueFromPointer(name, shift),
          destructorFunction: null, // This type does not need a destructor
      });
    }


  function integerReadValueFromPointer(name, shift, signed) {
      // integers are quite common, so generate very specialized functions
      switch (shift) {
          case 0: return signed ?
              function readS8FromPointer(pointer) { return HEAP8[pointer]; } :
              function readU8FromPointer(pointer) { return HEAPU8[pointer]; };
          case 1: return signed ?
              function readS16FromPointer(pointer) { return HEAP16[pointer >> 1]; } :
              function readU16FromPointer(pointer) { return HEAPU16[pointer >> 1]; };
          case 2: return signed ?
              function readS32FromPointer(pointer) { return HEAP32[pointer >> 2]; } :
              function readU32FromPointer(pointer) { return HEAPU32[pointer >> 2]; };
          default:
              throw new TypeError("Unknown integer type: " + name);
      }
    }function __embind_register_integer(primitiveType, name, size, minRange, maxRange) {
      name = readLatin1String(name);
      if (maxRange === -1) { // LLVM doesn't have signed and unsigned 32-bit types, so u32 literals come out as 'i32 -1'. Always treat those as max u32.
          maxRange = 4294967295;
      }

      var shift = getShiftFromSize(size);

      var fromWireType = function(value) {
          return value;
      };

      if (minRange === 0) {
          var bitshift = 32 - 8*size;
          fromWireType = function(value) {
              return (value << bitshift) >>> bitshift;
          };
      }

      var isUnsignedType = (name.indexOf('unsigned') != -1);

      registerType(primitiveType, {
          name: name,
          'fromWireType': fromWireType,
          'toWireType': function(destructors, value) {
              // todo: Here we have an opportunity for -O3 level "unsafe" optimizations: we could
              // avoid the following two if()s and assume value is of proper type.
              if (typeof value !== "number" && typeof value !== "boolean") {
                  throw new TypeError('Cannot convert "' + _embind_repr(value) + '" to ' + this.name);
              }
              if (value < minRange || value > maxRange) {
                  throw new TypeError('Passing a number "' + _embind_repr(value) + '" from JS side to C/C++ side to an argument of type "' + name + '", which is outside the valid range [' + minRange + ', ' + maxRange + ']!');
              }
              return isUnsignedType ? (value >>> 0) : (value | 0);
          },
          'argPackAdvance': 8,
          'readValueFromPointer': integerReadValueFromPointer(name, shift, minRange !== 0),
          destructorFunction: null, // This type does not need a destructor
      });
    }

  function __embind_register_memory_view(rawType, dataTypeIndex, name) {
      var typeMapping = [
          Int8Array,
          Uint8Array,
          Int16Array,
          Uint16Array,
          Int32Array,
          Uint32Array,
          Float32Array,
          Float64Array,
      ];

      var TA = typeMapping[dataTypeIndex];

      function decodeMemoryView(handle) {
          handle = handle >> 2;
          var heap = HEAPU32;
          var size = heap[handle]; // in elements
          var data = heap[handle + 1]; // byte offset into emscripten heap
          return new TA(heap['buffer'], data, size);
      }

      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': decodeMemoryView,
          'argPackAdvance': 8,
          'readValueFromPointer': decodeMemoryView,
      }, {
          ignoreDuplicateRegistrations: true,
      });
    }

  function __embind_register_std_string(rawType, name) {
      name = readLatin1String(name);
      registerType(rawType, {
          name: name,
          'fromWireType': function(value) {
              var length = HEAPU32[value >> 2];
              var a = new Array(length);
              for (var i = 0; i < length; ++i) {
                  a[i] = String.fromCharCode(HEAPU8[value + 4 + i]);
              }
              _free(value);
              return a.join('');
          },
          'toWireType': function(destructors, value) {
              if (value instanceof ArrayBuffer) {
                  value = new Uint8Array(value);
              }

              function getTAElement(ta, index) {
                  return ta[index];
              }
              function getStringElement(string, index) {
                  return string.charCodeAt(index);
              }
              var getElement;
              if (value instanceof Uint8Array) {
                  getElement = getTAElement;
              } else if (value instanceof Uint8ClampedArray) {
                  getElement = getTAElement;
              } else if (value instanceof Int8Array) {
                  getElement = getTAElement;
              } else if (typeof value === 'string') {
                  getElement = getStringElement;
              } else {
                  throwBindingError('Cannot pass non-string to std::string');
              }

              // assumes 4-byte alignment
              var length = value.length;
              var ptr = _malloc(4 + length);
              HEAPU32[ptr >> 2] = length;
              for (var i = 0; i < length; ++i) {
                  var charCode = getElement(value, i);
                  if (charCode > 255) {
                      _free(ptr);
                      throwBindingError('String has UTF-16 code units that do not fit in 8 bits');
                  }
                  HEAPU8[ptr + 4 + i] = charCode;
              }
              if (destructors !== null) {
                  destructors.push(_free, ptr);
              }
              return ptr;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': simpleReadValueFromPointer,
          destructorFunction: function(ptr) { _free(ptr); },
      });
    }

  function __embind_register_std_wstring(rawType, charSize, name) {
      // nb. do not cache HEAPU16 and HEAPU32, they may be destroyed by enlargeMemory().
      name = readLatin1String(name);
      var getHeap, shift;
      if (charSize === 2) {
          getHeap = function() { return HEAPU16; };
          shift = 1;
      } else if (charSize === 4) {
          getHeap = function() { return HEAPU32; };
          shift = 2;
      }
      registerType(rawType, {
          name: name,
          'fromWireType': function(value) {
              var HEAP = getHeap();
              var length = HEAPU32[value >> 2];
              var a = new Array(length);
              var start = (value + 4) >> shift;
              for (var i = 0; i < length; ++i) {
                  a[i] = String.fromCharCode(HEAP[start + i]);
              }
              _free(value);
              return a.join('');
          },
          'toWireType': function(destructors, value) {
              // assumes 4-byte alignment
              var HEAP = getHeap();
              var length = value.length;
              var ptr = _malloc(4 + length * charSize);
              HEAPU32[ptr >> 2] = length;
              var start = (ptr + 4) >> shift;
              for (var i = 0; i < length; ++i) {
                  HEAP[start + i] = value.charCodeAt(i);
              }
              if (destructors !== null) {
                  destructors.push(_free, ptr);
              }
              return ptr;
          },
          'argPackAdvance': 8,
          'readValueFromPointer': simpleReadValueFromPointer,
          destructorFunction: function(ptr) { _free(ptr); },
      });
    }

  function __embind_register_void(rawType, name) {
      name = readLatin1String(name);
      registerType(rawType, {
          isVoid: true, // void return values can be optimized out sometimes
          name: name,
          'argPackAdvance': 0,
          'fromWireType': function() {
              return undefined;
          },
          'toWireType': function(destructors, o) {
              // TODO: assert if anything else is given?
              return undefined;
          },
      });
    }

  function _abort() {
      Module['abort']();
    }











  function _llvm_trap() {
      abort('trap!');
    }


  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    }






  var PTHREAD_SPECIFIC={};function _pthread_getspecific(key) {
      return PTHREAD_SPECIFIC[key] || 0;
    }


  var PTHREAD_SPECIFIC_NEXT_KEY=1;

  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _pthread_key_create(key, destructor) {
      if (key == 0) {
        return ERRNO_CODES.EINVAL;
      }
      HEAP32[((key)>>2)]=PTHREAD_SPECIFIC_NEXT_KEY;
      // values start at 0
      PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY] = 0;
      PTHREAD_SPECIFIC_NEXT_KEY++;
      return 0;
    }





  function _pthread_once(ptr, func) {
      if (!_pthread_once.seen) _pthread_once.seen = {};
      if (ptr in _pthread_once.seen) return;
      Module['dynCall_v'](func);
      _pthread_once.seen[ptr] = 1;
    }

  function _pthread_setspecific(key, value) {
      if (!(key in PTHREAD_SPECIFIC)) {
        return ERRNO_CODES.EINVAL;
      }
      PTHREAD_SPECIFIC[key] = value;
      return 0;
    }


  function ___setErrNo(value) {
      if (Module['___errno_location']) HEAP32[((Module['___errno_location']())>>2)]=value;
      else Module.printErr('failed to set errno from JS');
      return value;
    }
embind_init_charCodes();
BindingError = Module['BindingError'] = extendError(Error, 'BindingError');;
InternalError = Module['InternalError'] = extendError(Error, 'InternalError');;
init_ClassHandle();
init_RegisteredPointer();
init_embind();;
UnboundTypeError = Module['UnboundTypeError'] = extendError(Error, 'UnboundTypeError');;
init_emval();;
DYNAMICTOP_PTR = staticAlloc(4);

STACK_BASE = STACKTOP = alignMemory(STATICTOP);

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = alignMemory(STACK_MAX);

HEAP32[DYNAMICTOP_PTR>>2] = DYNAMIC_BASE;

staticSealed = true; // seal the static portion of memory

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

var ASSERTIONS = true;

/** @type {function(string, boolean=, number=)} */
function intArrayFromString(stringy, dontAddNull, length) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      if (ASSERTIONS) {
        assert(false, 'Character code ' + chr + ' (' + String.fromCharCode(chr) + ')  at offset ' + i + ' not in 0x00-0xFF.');
      }
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}


// Copied from https://github.com/strophe/strophejs/blob/e06d027/src/polyfills.js#L149

// This code was written by Tyler Akins and has been placed in the
// public domain.  It would be nice if you left this header intact.
// Base64 code from Tyler Akins -- http://rumkin.com

/**
 * Decodes a base64 string.
 * @param {String} input The string to decode.
 */
var decodeBase64 = typeof atob === 'function' ? atob : function (input) {
  var keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

  var output = '';
  var chr1, chr2, chr3;
  var enc1, enc2, enc3, enc4;
  var i = 0;
  // remove all characters that are not A-Z, a-z, 0-9, +, /, or =
  input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');
  do {
    enc1 = keyStr.indexOf(input.charAt(i++));
    enc2 = keyStr.indexOf(input.charAt(i++));
    enc3 = keyStr.indexOf(input.charAt(i++));
    enc4 = keyStr.indexOf(input.charAt(i++));

    chr1 = (enc1 << 2) | (enc2 >> 4);
    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
    chr3 = ((enc3 & 3) << 6) | enc4;

    output = output + String.fromCharCode(chr1);

    if (enc3 !== 64) {
      output = output + String.fromCharCode(chr2);
    }
    if (enc4 !== 64) {
      output = output + String.fromCharCode(chr3);
    }
  } while (i < input.length);
  return output;
};

// Converts a string of base64 into a byte array.
// Throws error on invalid input.
function intArrayFromBase64(s) {
  if (typeof ENVIRONMENT_IS_NODE === 'boolean' && ENVIRONMENT_IS_NODE) {
    var buf;
    try {
      buf = Buffer.from(s, 'base64');
    } catch (_) {
      buf = new Buffer(s, 'base64');
    }
    return new Uint8Array(buf.buffer, buf.byteOffset, buf.byteLength);
  }

  try {
    var decoded = decodeBase64(s);
    var bytes = new Uint8Array(decoded.length);
    for (var i = 0 ; i < decoded.length ; ++i) {
      bytes[i] = decoded.charCodeAt(i);
    }
    return bytes;
  } catch (_) {
    throw new Error('Converting base64 string to bytes failed.');
  }
}

// If filename is a base64 data URI, parses and returns data (Buffer on node,
// Uint8Array otherwise). If filename is not a base64 data URI, returns undefined.
function tryParseAsDataURI(filename) {
  if (!isDataURI(filename)) {
    return;
  }

  return intArrayFromBase64(filename.slice(dataURIPrefix.length));
}



function nullFunc_i(x) { Module["printErr"]("Invalid function pointer called with signature 'i'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_ii(x) { Module["printErr"]("Invalid function pointer called with signature 'ii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_iii(x) { Module["printErr"]("Invalid function pointer called with signature 'iii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_iiii(x) { Module["printErr"]("Invalid function pointer called with signature 'iiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_v(x) { Module["printErr"]("Invalid function pointer called with signature 'v'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_vi(x) { Module["printErr"]("Invalid function pointer called with signature 'vi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_vii(x) { Module["printErr"]("Invalid function pointer called with signature 'vii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viii(x) { Module["printErr"]("Invalid function pointer called with signature 'viii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viiii(x) { Module["printErr"]("Invalid function pointer called with signature 'viiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viiiii(x) { Module["printErr"]("Invalid function pointer called with signature 'viiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function nullFunc_viiiiii(x) { Module["printErr"]("Invalid function pointer called with signature 'viiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("Build with ASSERTIONS=2 for more info.");abort(x) }

function invoke_i(index) {
  try {
    return Module["dynCall_i"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity };

Module.asmLibraryArg = { "abort": abort, "assert": assert, "enlargeMemory": enlargeMemory, "getTotalMemory": getTotalMemory, "abortOnCannotGrowMemory": abortOnCannotGrowMemory, "abortStackOverflow": abortStackOverflow, "nullFunc_i": nullFunc_i, "nullFunc_ii": nullFunc_ii, "nullFunc_iii": nullFunc_iii, "nullFunc_iiii": nullFunc_iiii, "nullFunc_v": nullFunc_v, "nullFunc_vi": nullFunc_vi, "nullFunc_vii": nullFunc_vii, "nullFunc_viii": nullFunc_viii, "nullFunc_viiii": nullFunc_viiii, "nullFunc_viiiii": nullFunc_viiiii, "nullFunc_viiiiii": nullFunc_viiiiii, "invoke_i": invoke_i, "invoke_ii": invoke_ii, "invoke_iii": invoke_iii, "invoke_iiii": invoke_iiii, "invoke_v": invoke_v, "invoke_vi": invoke_vi, "invoke_vii": invoke_vii, "invoke_viii": invoke_viii, "invoke_viiii": invoke_viiii, "invoke_viiiii": invoke_viiiii, "invoke_viiiiii": invoke_viiiiii, "ClassHandle": ClassHandle, "ClassHandle_clone": ClassHandle_clone, "ClassHandle_delete": ClassHandle_delete, "ClassHandle_deleteLater": ClassHandle_deleteLater, "ClassHandle_isAliasOf": ClassHandle_isAliasOf, "ClassHandle_isDeleted": ClassHandle_isDeleted, "RegisteredClass": RegisteredClass, "RegisteredPointer": RegisteredPointer, "RegisteredPointer_deleteObject": RegisteredPointer_deleteObject, "RegisteredPointer_destructor": RegisteredPointer_destructor, "RegisteredPointer_fromWireType": RegisteredPointer_fromWireType, "RegisteredPointer_getPointee": RegisteredPointer_getPointee, "__ZSt18uncaught_exceptionv": __ZSt18uncaught_exceptionv, "___assert_fail": ___assert_fail, "___cxa_allocate_exception": ___cxa_allocate_exception, "___cxa_begin_catch": ___cxa_begin_catch, "___cxa_find_matching_catch": ___cxa_find_matching_catch, "___cxa_pure_virtual": ___cxa_pure_virtual, "___cxa_throw": ___cxa_throw, "___gxx_personality_v0": ___gxx_personality_v0, "___lock": ___lock, "___resumeException": ___resumeException, "___setErrNo": ___setErrNo, "___syscall140": ___syscall140, "___syscall146": ___syscall146, "___syscall54": ___syscall54, "___syscall6": ___syscall6, "___unlock": ___unlock, "__embind_register_bool": __embind_register_bool, "__embind_register_class": __embind_register_class, "__embind_register_class_constructor": __embind_register_class_constructor, "__embind_register_class_function": __embind_register_class_function, "__embind_register_emval": __embind_register_emval, "__embind_register_float": __embind_register_float, "__embind_register_integer": __embind_register_integer, "__embind_register_memory_view": __embind_register_memory_view, "__embind_register_std_string": __embind_register_std_string, "__embind_register_std_wstring": __embind_register_std_wstring, "__embind_register_void": __embind_register_void, "__emval_decref": __emval_decref, "__emval_register": __emval_register, "_abort": _abort, "_embind_repr": _embind_repr, "_emscripten_memcpy_big": _emscripten_memcpy_big, "_llvm_trap": _llvm_trap, "_pthread_getspecific": _pthread_getspecific, "_pthread_key_create": _pthread_key_create, "_pthread_once": _pthread_once, "_pthread_setspecific": _pthread_setspecific, "constNoSmartPtrRawPointerToWireType": constNoSmartPtrRawPointerToWireType, "count_emval_handles": count_emval_handles, "craftInvokerFunction": craftInvokerFunction, "createNamedFunction": createNamedFunction, "downcastPointer": downcastPointer, "embind__requireFunction": embind__requireFunction, "embind_init_charCodes": embind_init_charCodes, "ensureOverloadTable": ensureOverloadTable, "exposePublicSymbol": exposePublicSymbol, "extendError": extendError, "floatReadValueFromPointer": floatReadValueFromPointer, "flushPendingDeletes": flushPendingDeletes, "flush_NO_FILESYSTEM": flush_NO_FILESYSTEM, "genericPointerToWireType": genericPointerToWireType, "getBasestPointer": getBasestPointer, "getInheritedInstance": getInheritedInstance, "getInheritedInstanceCount": getInheritedInstanceCount, "getLiveInheritedInstances": getLiveInheritedInstances, "getShiftFromSize": getShiftFromSize, "getTypeName": getTypeName, "get_first_emval": get_first_emval, "heap32VectorToArray": heap32VectorToArray, "init_ClassHandle": init_ClassHandle, "init_RegisteredPointer": init_RegisteredPointer, "init_embind": init_embind, "init_emval": init_emval, "integerReadValueFromPointer": integerReadValueFromPointer, "makeClassHandle": makeClassHandle, "makeLegalFunctionName": makeLegalFunctionName, "new_": new_, "nonConstNoSmartPtrRawPointerToWireType": nonConstNoSmartPtrRawPointerToWireType, "readLatin1String": readLatin1String, "registerType": registerType, "replacePublicSymbol": replacePublicSymbol, "runDestructor": runDestructor, "runDestructors": runDestructors, "setDelayFunction": setDelayFunction, "shallowCopyInternalPointer": shallowCopyInternalPointer, "simpleReadValueFromPointer": simpleReadValueFromPointer, "throwBindingError": throwBindingError, "throwInstanceAlreadyDeleted": throwInstanceAlreadyDeleted, "throwInternalError": throwInternalError, "throwUnboundTypeError": throwUnboundTypeError, "upcastPointer": upcastPointer, "whenDependentTypesAreResolved": whenDependentTypesAreResolved, "DYNAMICTOP_PTR": DYNAMICTOP_PTR, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX };
// EMSCRIPTEN_START_ASM
var asm = (/** @suppress {uselessCode} */ function(global, env, buffer) {
'almost asm';


  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);

  var DYNAMICTOP_PTR=env.DYNAMICTOP_PTR|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntS = 0, tempValue = 0, tempDouble = 0.0;
  var tempRet0 = 0;

  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_max=global.Math.max;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  var enlargeMemory=env.enlargeMemory;
  var getTotalMemory=env.getTotalMemory;
  var abortOnCannotGrowMemory=env.abortOnCannotGrowMemory;
  var abortStackOverflow=env.abortStackOverflow;
  var nullFunc_i=env.nullFunc_i;
  var nullFunc_ii=env.nullFunc_ii;
  var nullFunc_iii=env.nullFunc_iii;
  var nullFunc_iiii=env.nullFunc_iiii;
  var nullFunc_v=env.nullFunc_v;
  var nullFunc_vi=env.nullFunc_vi;
  var nullFunc_vii=env.nullFunc_vii;
  var nullFunc_viii=env.nullFunc_viii;
  var nullFunc_viiii=env.nullFunc_viiii;
  var nullFunc_viiiii=env.nullFunc_viiiii;
  var nullFunc_viiiiii=env.nullFunc_viiiiii;
  var invoke_i=env.invoke_i;
  var invoke_ii=env.invoke_ii;
  var invoke_iii=env.invoke_iii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_v=env.invoke_v;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_viii=env.invoke_viii;
  var invoke_viiii=env.invoke_viiii;
  var invoke_viiiii=env.invoke_viiiii;
  var invoke_viiiiii=env.invoke_viiiiii;
  var ClassHandle=env.ClassHandle;
  var ClassHandle_clone=env.ClassHandle_clone;
  var ClassHandle_delete=env.ClassHandle_delete;
  var ClassHandle_deleteLater=env.ClassHandle_deleteLater;
  var ClassHandle_isAliasOf=env.ClassHandle_isAliasOf;
  var ClassHandle_isDeleted=env.ClassHandle_isDeleted;
  var RegisteredClass=env.RegisteredClass;
  var RegisteredPointer=env.RegisteredPointer;
  var RegisteredPointer_deleteObject=env.RegisteredPointer_deleteObject;
  var RegisteredPointer_destructor=env.RegisteredPointer_destructor;
  var RegisteredPointer_fromWireType=env.RegisteredPointer_fromWireType;
  var RegisteredPointer_getPointee=env.RegisteredPointer_getPointee;
  var __ZSt18uncaught_exceptionv=env.__ZSt18uncaught_exceptionv;
  var ___assert_fail=env.___assert_fail;
  var ___cxa_allocate_exception=env.___cxa_allocate_exception;
  var ___cxa_begin_catch=env.___cxa_begin_catch;
  var ___cxa_find_matching_catch=env.___cxa_find_matching_catch;
  var ___cxa_pure_virtual=env.___cxa_pure_virtual;
  var ___cxa_throw=env.___cxa_throw;
  var ___gxx_personality_v0=env.___gxx_personality_v0;
  var ___lock=env.___lock;
  var ___resumeException=env.___resumeException;
  var ___setErrNo=env.___setErrNo;
  var ___syscall140=env.___syscall140;
  var ___syscall146=env.___syscall146;
  var ___syscall54=env.___syscall54;
  var ___syscall6=env.___syscall6;
  var ___unlock=env.___unlock;
  var __embind_register_bool=env.__embind_register_bool;
  var __embind_register_class=env.__embind_register_class;
  var __embind_register_class_constructor=env.__embind_register_class_constructor;
  var __embind_register_class_function=env.__embind_register_class_function;
  var __embind_register_emval=env.__embind_register_emval;
  var __embind_register_float=env.__embind_register_float;
  var __embind_register_integer=env.__embind_register_integer;
  var __embind_register_memory_view=env.__embind_register_memory_view;
  var __embind_register_std_string=env.__embind_register_std_string;
  var __embind_register_std_wstring=env.__embind_register_std_wstring;
  var __embind_register_void=env.__embind_register_void;
  var __emval_decref=env.__emval_decref;
  var __emval_register=env.__emval_register;
  var _abort=env._abort;
  var _embind_repr=env._embind_repr;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var _llvm_trap=env._llvm_trap;
  var _pthread_getspecific=env._pthread_getspecific;
  var _pthread_key_create=env._pthread_key_create;
  var _pthread_once=env._pthread_once;
  var _pthread_setspecific=env._pthread_setspecific;
  var constNoSmartPtrRawPointerToWireType=env.constNoSmartPtrRawPointerToWireType;
  var count_emval_handles=env.count_emval_handles;
  var craftInvokerFunction=env.craftInvokerFunction;
  var createNamedFunction=env.createNamedFunction;
  var downcastPointer=env.downcastPointer;
  var embind__requireFunction=env.embind__requireFunction;
  var embind_init_charCodes=env.embind_init_charCodes;
  var ensureOverloadTable=env.ensureOverloadTable;
  var exposePublicSymbol=env.exposePublicSymbol;
  var extendError=env.extendError;
  var floatReadValueFromPointer=env.floatReadValueFromPointer;
  var flushPendingDeletes=env.flushPendingDeletes;
  var flush_NO_FILESYSTEM=env.flush_NO_FILESYSTEM;
  var genericPointerToWireType=env.genericPointerToWireType;
  var getBasestPointer=env.getBasestPointer;
  var getInheritedInstance=env.getInheritedInstance;
  var getInheritedInstanceCount=env.getInheritedInstanceCount;
  var getLiveInheritedInstances=env.getLiveInheritedInstances;
  var getShiftFromSize=env.getShiftFromSize;
  var getTypeName=env.getTypeName;
  var get_first_emval=env.get_first_emval;
  var heap32VectorToArray=env.heap32VectorToArray;
  var init_ClassHandle=env.init_ClassHandle;
  var init_RegisteredPointer=env.init_RegisteredPointer;
  var init_embind=env.init_embind;
  var init_emval=env.init_emval;
  var integerReadValueFromPointer=env.integerReadValueFromPointer;
  var makeClassHandle=env.makeClassHandle;
  var makeLegalFunctionName=env.makeLegalFunctionName;
  var new_=env.new_;
  var nonConstNoSmartPtrRawPointerToWireType=env.nonConstNoSmartPtrRawPointerToWireType;
  var readLatin1String=env.readLatin1String;
  var registerType=env.registerType;
  var replacePublicSymbol=env.replacePublicSymbol;
  var runDestructor=env.runDestructor;
  var runDestructors=env.runDestructors;
  var setDelayFunction=env.setDelayFunction;
  var shallowCopyInternalPointer=env.shallowCopyInternalPointer;
  var simpleReadValueFromPointer=env.simpleReadValueFromPointer;
  var throwBindingError=env.throwBindingError;
  var throwInstanceAlreadyDeleted=env.throwInstanceAlreadyDeleted;
  var throwInternalError=env.throwInternalError;
  var throwUnboundTypeError=env.throwUnboundTypeError;
  var upcastPointer=env.upcastPointer;
  var whenDependentTypesAreResolved=env.whenDependentTypesAreResolved;
  var tempFloat = 0.0;

// EMSCRIPTEN_START_FUNCS

function stackAlloc(size) {
  size = size|0;
  var ret = 0;
  ret = STACKTOP;
  STACKTOP = (STACKTOP + size)|0;
  STACKTOP = (STACKTOP + 15)&-16;
  if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(size|0);

  return ret|0;
}
function stackSave() {
  return STACKTOP|0;
}
function stackRestore(top) {
  top = top|0;
  STACKTOP = top;
}
function establishStackSpace(stackBase, stackMax) {
  stackBase = stackBase|0;
  stackMax = stackMax|0;
  STACKTOP = stackBase;
  STACK_MAX = stackMax;
}

function setThrew(threw, value) {
  threw = threw|0;
  value = value|0;
  if ((__THREW__|0) == 0) {
    __THREW__ = threw;
    threwValue = value;
  }
}

function setTempRet0(value) {
  value = value|0;
  tempRet0 = value;
}
function getTempRet0() {
  return tempRet0|0;
}

function ___cxx_global_var_init() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 __ZN38EmscriptenBindingInitializer_my_moduleC2Ev(21880);
 return;
}
function __ZN38EmscriptenBindingInitializer_my_moduleC2Ev($0) {
 $0 = $0|0;
 var $$field = 0, $$field11 = 0, $$field14 = 0, $$field21 = 0, $$field24 = 0, $$field31 = 0, $$field34 = 0, $$field4 = 0, $$field41 = 0, $$field44 = 0, $$field51 = 0, $$field54 = 0, $$field61 = 0, $$field64 = 0, $$field71 = 0, $$field74 = 0, $$index1 = 0, $$index13 = 0, $$index17 = 0, $$index19 = 0;
 var $$index23 = 0, $$index27 = 0, $$index29 = 0, $$index3 = 0, $$index33 = 0, $$index37 = 0, $$index39 = 0, $$index43 = 0, $$index47 = 0, $$index49 = 0, $$index53 = 0, $$index57 = 0, $$index59 = 0, $$index63 = 0, $$index67 = 0, $$index69 = 0, $$index7 = 0, $$index73 = 0, $$index77 = 0, $$index9 = 0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0;
 var $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0;
 var $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0;
 var $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0;
 var $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0;
 var $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0;
 var $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 496|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(496|0);
 $4 = sp + 448|0;
 $6 = sp + 481|0;
 $7 = sp + 72|0;
 $11 = sp + 424|0;
 $13 = sp + 480|0;
 $14 = sp + 64|0;
 $18 = sp + 400|0;
 $20 = sp + 479|0;
 $21 = sp + 56|0;
 $25 = sp + 376|0;
 $27 = sp + 478|0;
 $28 = sp + 48|0;
 $32 = sp + 352|0;
 $34 = sp + 477|0;
 $35 = sp + 40|0;
 $36 = sp + 32|0;
 $40 = sp + 476|0;
 $56 = sp + 264|0;
 $58 = sp + 475|0;
 $59 = sp + 24|0;
 $63 = sp + 240|0;
 $65 = sp + 474|0;
 $66 = sp + 16|0;
 $70 = sp + 216|0;
 $72 = sp + 473|0;
 $73 = sp + 8|0;
 $74 = sp;
 $78 = sp + 472|0;
 $92 = sp + 471|0;
 $93 = sp + 470|0;
 $94 = sp + 136|0;
 $95 = sp + 128|0;
 $96 = sp + 120|0;
 $97 = sp + 469|0;
 $98 = sp + 468|0;
 $99 = sp + 112|0;
 $100 = sp + 104|0;
 $101 = sp + 96|0;
 $102 = sp + 88|0;
 $103 = sp + 80|0;
 $91 = $0;
 $85 = $92;
 $86 = 3768;
 __ZN10emscripten8internal11NoBaseClass6verifyI6LASZipEEvv();
 $87 = 234;
 $104 = (__ZN10emscripten8internal11NoBaseClass11getUpcasterI6LASZipEEPFvvEv()|0);
 $88 = $104;
 $105 = (__ZN10emscripten8internal11NoBaseClass13getDowncasterI6LASZipEEPFvvEv()|0);
 $89 = $105;
 $90 = 235;
 $106 = (__ZN10emscripten8internal6TypeIDI6LASZipE3getEv()|0);
 $107 = (__ZN10emscripten8internal6TypeIDINS0_17AllowedRawPointerI6LASZipEEE3getEv()|0);
 $108 = (__ZN10emscripten8internal6TypeIDINS0_17AllowedRawPointerIK6LASZipEEE3getEv()|0);
 $109 = (__ZN10emscripten8internal11NoBaseClass3getEv()|0);
 $110 = $87;
 $84 = $110;
 $111 = (__ZN10emscripten8internal19getGenericSignatureIJiiEEEPKcv()|0);
 $112 = $87;
 $113 = $88;
 $83 = $113;
 $114 = (__ZN10emscripten8internal19getGenericSignatureIJvEEEPKcv()|0);
 $115 = $88;
 $116 = $89;
 $82 = $116;
 $117 = (__ZN10emscripten8internal19getGenericSignatureIJvEEEPKcv()|0);
 $118 = $89;
 $119 = $86;
 $120 = $90;
 $81 = $120;
 $121 = (__ZN10emscripten8internal19getGenericSignatureIJviEEEPKcv()|0);
 $122 = $90;
 __embind_register_class(($106|0),($107|0),($108|0),($109|0),($111|0),($112|0),($114|0),($115|0),($117|0),($118|0),($119|0),($121|0),($122|0));
 $80 = $92;
 $123 = $80;
 $76 = $123;
 $77 = 236;
 $124 = $76;
 $79 = 237;
 $125 = (__ZN10emscripten8internal6TypeIDI6LASZipE3getEv()|0);
 $126 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJP6LASZipEE8getCountEv($78)|0);
 $127 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJP6LASZipEE8getTypesEv($78)|0);
 $128 = $79;
 $75 = $128;
 $129 = (__ZN10emscripten8internal19getGenericSignatureIJiiEEEPKcv()|0);
 $130 = $79;
 $131 = $77;
 __embind_register_class_constructor(($125|0),($126|0),($127|0),($129|0),($130|0),($131|0));
 HEAP32[$94>>2] = (238);
 $$index1 = ((($94)) + 4|0);
 HEAP32[$$index1>>2] = 0;
 ;HEAP8[$73>>0]=HEAP8[$93>>0]|0;
 ;HEAP8[$74>>0]=HEAP8[$94>>0]|0;HEAP8[$74+1>>0]=HEAP8[$94+1>>0]|0;HEAP8[$74+2>>0]=HEAP8[$94+2>>0]|0;HEAP8[$74+3>>0]=HEAP8[$94+3>>0]|0;HEAP8[$74+4>>0]=HEAP8[$94+4>>0]|0;HEAP8[$74+5>>0]=HEAP8[$94+5>>0]|0;HEAP8[$74+6>>0]=HEAP8[$94+6>>0]|0;HEAP8[$74+7>>0]=HEAP8[$94+7>>0]|0;
 $$field = HEAP32[$74>>2]|0;
 $$index3 = ((($74)) + 4|0);
 $$field4 = HEAP32[$$index3>>2]|0;
 $68 = $124;
 $69 = 3775;
 HEAP32[$70>>2] = $$field;
 $$index7 = ((($70)) + 4|0);
 HEAP32[$$index7>>2] = $$field4;
 $132 = $68;
 $71 = 239;
 $133 = (__ZN10emscripten8internal6TypeIDI6LASZipE3getEv()|0);
 $134 = $69;
 $135 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJvNS0_17AllowedRawPointerI6LASZipEEjjEE8getCountEv($72)|0);
 $136 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJvNS0_17AllowedRawPointerI6LASZipEEjjEE8getTypesEv($72)|0);
 $137 = $71;
 $67 = $137;
 $138 = (__ZN10emscripten8internal19getGenericSignatureIJviiiiEEEPKcv()|0);
 $139 = $71;
 $140 = (__ZN10emscripten8internal10getContextIM6LASZipFvjjEEEPT_RKS5_($70)|0);
 __embind_register_class_function(($133|0),($134|0),($135|0),($136|0),($138|0),($139|0),($140|0),0);
 HEAP32[$95>>2] = (240);
 $$index9 = ((($95)) + 4|0);
 HEAP32[$$index9>>2] = 0;
 ;HEAP8[$66>>0]=HEAP8[$95>>0]|0;HEAP8[$66+1>>0]=HEAP8[$95+1>>0]|0;HEAP8[$66+2>>0]=HEAP8[$95+2>>0]|0;HEAP8[$66+3>>0]=HEAP8[$95+3>>0]|0;HEAP8[$66+4>>0]=HEAP8[$95+4>>0]|0;HEAP8[$66+5>>0]=HEAP8[$95+5>>0]|0;HEAP8[$66+6>>0]=HEAP8[$95+6>>0]|0;HEAP8[$66+7>>0]=HEAP8[$95+7>>0]|0;
 $$field11 = HEAP32[$66>>2]|0;
 $$index13 = ((($66)) + 4|0);
 $$field14 = HEAP32[$$index13>>2]|0;
 $61 = $132;
 $62 = 3780;
 HEAP32[$63>>2] = $$field11;
 $$index17 = ((($63)) + 4|0);
 HEAP32[$$index17>>2] = $$field14;
 $141 = $61;
 $64 = 241;
 $142 = (__ZN10emscripten8internal6TypeIDI6LASZipE3getEv()|0);
 $143 = $62;
 $144 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI6LASZipEEiEE8getCountEv($65)|0);
 $145 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI6LASZipEEiEE8getTypesEv($65)|0);
 $146 = $64;
 $60 = $146;
 $147 = (__ZN10emscripten8internal19getGenericSignatureIJviiiEEEPKcv()|0);
 $148 = $64;
 $149 = (__ZN10emscripten8internal10getContextIM6LASZipFviEEEPT_RKS5_($63)|0);
 __embind_register_class_function(($142|0),($143|0),($144|0),($145|0),($147|0),($148|0),($149|0),0);
 HEAP32[$96>>2] = (242);
 $$index19 = ((($96)) + 4|0);
 HEAP32[$$index19>>2] = 0;
 ;HEAP8[$59>>0]=HEAP8[$96>>0]|0;HEAP8[$59+1>>0]=HEAP8[$96+1>>0]|0;HEAP8[$59+2>>0]=HEAP8[$96+2>>0]|0;HEAP8[$59+3>>0]=HEAP8[$96+3>>0]|0;HEAP8[$59+4>>0]=HEAP8[$96+4>>0]|0;HEAP8[$59+5>>0]=HEAP8[$96+5>>0]|0;HEAP8[$59+6>>0]=HEAP8[$96+6>>0]|0;HEAP8[$59+7>>0]=HEAP8[$96+7>>0]|0;
 $$field21 = HEAP32[$59>>2]|0;
 $$index23 = ((($59)) + 4|0);
 $$field24 = HEAP32[$$index23>>2]|0;
 $54 = $141;
 $55 = 3789;
 HEAP32[$56>>2] = $$field21;
 $$index27 = ((($56)) + 4|0);
 HEAP32[$$index27>>2] = $$field24;
 $57 = 243;
 $150 = (__ZN10emscripten8internal6TypeIDI6LASZipE3getEv()|0);
 $151 = $55;
 $152 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJjNS0_17AllowedRawPointerI6LASZipEEEE8getCountEv($58)|0);
 $153 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJjNS0_17AllowedRawPointerI6LASZipEEEE8getTypesEv($58)|0);
 $154 = $57;
 $53 = $154;
 $155 = (__ZN10emscripten8internal19getGenericSignatureIJiiiEEEPKcv()|0);
 $156 = $57;
 $157 = (__ZN10emscripten8internal10getContextIM6LASZipFjvEEEPT_RKS5_($56)|0);
 __embind_register_class_function(($150|0),($151|0),($152|0),($153|0),($155|0),($156|0),($157|0),0);
 $47 = $97;
 $48 = 3798;
 __ZN10emscripten8internal11NoBaseClass6verifyI13DynamicLASZipEEvv();
 $49 = 244;
 $158 = (__ZN10emscripten8internal11NoBaseClass11getUpcasterI13DynamicLASZipEEPFvvEv()|0);
 $50 = $158;
 $159 = (__ZN10emscripten8internal11NoBaseClass13getDowncasterI13DynamicLASZipEEPFvvEv()|0);
 $51 = $159;
 $52 = 245;
 $160 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $161 = (__ZN10emscripten8internal6TypeIDINS0_17AllowedRawPointerI13DynamicLASZipEEE3getEv()|0);
 $162 = (__ZN10emscripten8internal6TypeIDINS0_17AllowedRawPointerIK13DynamicLASZipEEE3getEv()|0);
 $163 = (__ZN10emscripten8internal11NoBaseClass3getEv()|0);
 $164 = $49;
 $46 = $164;
 $165 = (__ZN10emscripten8internal19getGenericSignatureIJiiEEEPKcv()|0);
 $166 = $49;
 $167 = $50;
 $45 = $167;
 $168 = (__ZN10emscripten8internal19getGenericSignatureIJvEEEPKcv()|0);
 $169 = $50;
 $170 = $51;
 $44 = $170;
 $171 = (__ZN10emscripten8internal19getGenericSignatureIJvEEEPKcv()|0);
 $172 = $51;
 $173 = $48;
 $174 = $52;
 $43 = $174;
 $175 = (__ZN10emscripten8internal19getGenericSignatureIJviEEEPKcv()|0);
 $176 = $52;
 __embind_register_class(($160|0),($161|0),($162|0),($163|0),($165|0),($166|0),($168|0),($169|0),($171|0),($172|0),($173|0),($175|0),($176|0));
 $42 = $97;
 $177 = $42;
 $38 = $177;
 $39 = 246;
 $178 = $38;
 $41 = 247;
 $179 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $180 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJP13DynamicLASZipEE8getCountEv($40)|0);
 $181 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJP13DynamicLASZipEE8getTypesEv($40)|0);
 $182 = $41;
 $37 = $182;
 $183 = (__ZN10emscripten8internal19getGenericSignatureIJiiEEEPKcv()|0);
 $184 = $41;
 $185 = $39;
 __embind_register_class_constructor(($179|0),($180|0),($181|0),($183|0),($184|0),($185|0));
 HEAP32[$99>>2] = (248);
 $$index29 = ((($99)) + 4|0);
 HEAP32[$$index29>>2] = 0;
 ;HEAP8[$35>>0]=HEAP8[$98>>0]|0;
 ;HEAP8[$36>>0]=HEAP8[$99>>0]|0;HEAP8[$36+1>>0]=HEAP8[$99+1>>0]|0;HEAP8[$36+2>>0]=HEAP8[$99+2>>0]|0;HEAP8[$36+3>>0]=HEAP8[$99+3>>0]|0;HEAP8[$36+4>>0]=HEAP8[$99+4>>0]|0;HEAP8[$36+5>>0]=HEAP8[$99+5>>0]|0;HEAP8[$36+6>>0]=HEAP8[$99+6>>0]|0;HEAP8[$36+7>>0]=HEAP8[$99+7>>0]|0;
 $$field31 = HEAP32[$36>>2]|0;
 $$index33 = ((($36)) + 4|0);
 $$field34 = HEAP32[$$index33>>2]|0;
 $30 = $178;
 $31 = 3775;
 HEAP32[$32>>2] = $$field31;
 $$index37 = ((($32)) + 4|0);
 HEAP32[$$index37>>2] = $$field34;
 $186 = $30;
 $33 = 249;
 $187 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $188 = $31;
 $189 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjjEE8getCountEv($34)|0);
 $190 = (__ZNK10emscripten8internal12WithPoliciesIJNS_18allow_raw_pointersEEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjjEE8getTypesEv($34)|0);
 $191 = $33;
 $29 = $191;
 $192 = (__ZN10emscripten8internal19getGenericSignatureIJviiiiEEEPKcv()|0);
 $193 = $33;
 $194 = (__ZN10emscripten8internal10getContextIM13DynamicLASZipFvjjEEEPT_RKS5_($32)|0);
 __embind_register_class_function(($187|0),($188|0),($189|0),($190|0),($192|0),($193|0),($194|0),0);
 HEAP32[$100>>2] = (250);
 $$index39 = ((($100)) + 4|0);
 HEAP32[$$index39>>2] = 0;
 ;HEAP8[$28>>0]=HEAP8[$100>>0]|0;HEAP8[$28+1>>0]=HEAP8[$100+1>>0]|0;HEAP8[$28+2>>0]=HEAP8[$100+2>>0]|0;HEAP8[$28+3>>0]=HEAP8[$100+3>>0]|0;HEAP8[$28+4>>0]=HEAP8[$100+4>>0]|0;HEAP8[$28+5>>0]=HEAP8[$100+5>>0]|0;HEAP8[$28+6>>0]=HEAP8[$100+6>>0]|0;HEAP8[$28+7>>0]=HEAP8[$100+7>>0]|0;
 $$field41 = HEAP32[$28>>2]|0;
 $$index43 = ((($28)) + 4|0);
 $$field44 = HEAP32[$$index43>>2]|0;
 $23 = $186;
 $24 = 3812;
 HEAP32[$25>>2] = $$field41;
 $$index47 = ((($25)) + 4|0);
 HEAP32[$$index47>>2] = $$field44;
 $195 = $23;
 $26 = 251;
 $196 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $197 = $24;
 $198 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjEE8getCountEv($27)|0);
 $199 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjEE8getTypesEv($27)|0);
 $200 = $26;
 $22 = $200;
 $201 = (__ZN10emscripten8internal19getGenericSignatureIJviiiEEEPKcv()|0);
 $202 = $26;
 $203 = (__ZN10emscripten8internal10getContextIM13DynamicLASZipFvjEEEPT_RKS5_($25)|0);
 __embind_register_class_function(($196|0),($197|0),($198|0),($199|0),($201|0),($202|0),($203|0),0);
 HEAP32[$101>>2] = (252);
 $$index49 = ((($101)) + 4|0);
 HEAP32[$$index49>>2] = 0;
 ;HEAP8[$21>>0]=HEAP8[$101>>0]|0;HEAP8[$21+1>>0]=HEAP8[$101+1>>0]|0;HEAP8[$21+2>>0]=HEAP8[$101+2>>0]|0;HEAP8[$21+3>>0]=HEAP8[$101+3>>0]|0;HEAP8[$21+4>>0]=HEAP8[$101+4>>0]|0;HEAP8[$21+5>>0]=HEAP8[$101+5>>0]|0;HEAP8[$21+6>>0]=HEAP8[$101+6>>0]|0;HEAP8[$21+7>>0]=HEAP8[$101+7>>0]|0;
 $$field51 = HEAP32[$21>>2]|0;
 $$index53 = ((($21)) + 4|0);
 $$field54 = HEAP32[$$index53>>2]|0;
 $16 = $195;
 $17 = 3829;
 HEAP32[$18>>2] = $$field51;
 $$index57 = ((($18)) + 4|0);
 HEAP32[$$index57>>2] = $$field54;
 $204 = $16;
 $19 = 251;
 $205 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $206 = $17;
 $207 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjEE8getCountEv($20)|0);
 $208 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjEE8getTypesEv($20)|0);
 $209 = $19;
 $15 = $209;
 $210 = (__ZN10emscripten8internal19getGenericSignatureIJviiiEEEPKcv()|0);
 $211 = $19;
 $212 = (__ZN10emscripten8internal10getContextIM13DynamicLASZipFvjEEEPT_RKS5_($18)|0);
 __embind_register_class_function(($205|0),($206|0),($207|0),($208|0),($210|0),($211|0),($212|0),0);
 HEAP32[$102>>2] = (253);
 $$index59 = ((($102)) + 4|0);
 HEAP32[$$index59>>2] = 0;
 ;HEAP8[$14>>0]=HEAP8[$102>>0]|0;HEAP8[$14+1>>0]=HEAP8[$102+1>>0]|0;HEAP8[$14+2>>0]=HEAP8[$102+2>>0]|0;HEAP8[$14+3>>0]=HEAP8[$102+3>>0]|0;HEAP8[$14+4>>0]=HEAP8[$102+4>>0]|0;HEAP8[$14+5>>0]=HEAP8[$102+5>>0]|0;HEAP8[$14+6>>0]=HEAP8[$102+6>>0]|0;HEAP8[$14+7>>0]=HEAP8[$102+7>>0]|0;
 $$field61 = HEAP32[$14>>2]|0;
 $$index63 = ((($14)) + 4|0);
 $$field64 = HEAP32[$$index63>>2]|0;
 $9 = $204;
 $10 = 3844;
 HEAP32[$11>>2] = $$field61;
 $$index67 = ((($11)) + 4|0);
 HEAP32[$$index67>>2] = $$field64;
 $213 = $9;
 $12 = 251;
 $214 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $215 = $10;
 $216 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjEE8getCountEv($13)|0);
 $217 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEjEE8getTypesEv($13)|0);
 $218 = $12;
 $8 = $218;
 $219 = (__ZN10emscripten8internal19getGenericSignatureIJviiiEEEPKcv()|0);
 $220 = $12;
 $221 = (__ZN10emscripten8internal10getContextIM13DynamicLASZipFvjEEEPT_RKS5_($11)|0);
 __embind_register_class_function(($214|0),($215|0),($216|0),($217|0),($219|0),($220|0),($221|0),0);
 HEAP32[$103>>2] = (254);
 $$index69 = ((($103)) + 4|0);
 HEAP32[$$index69>>2] = 0;
 ;HEAP8[$7>>0]=HEAP8[$103>>0]|0;HEAP8[$7+1>>0]=HEAP8[$103+1>>0]|0;HEAP8[$7+2>>0]=HEAP8[$103+2>>0]|0;HEAP8[$7+3>>0]=HEAP8[$103+3>>0]|0;HEAP8[$7+4>>0]=HEAP8[$103+4>>0]|0;HEAP8[$7+5>>0]=HEAP8[$103+5>>0]|0;HEAP8[$7+6>>0]=HEAP8[$103+6>>0]|0;HEAP8[$7+7>>0]=HEAP8[$103+7>>0]|0;
 $$field71 = HEAP32[$7>>2]|0;
 $$index73 = ((($7)) + 4|0);
 $$field74 = HEAP32[$$index73>>2]|0;
 $2 = $213;
 $3 = 3780;
 HEAP32[$4>>2] = $$field71;
 $$index77 = ((($4)) + 4|0);
 HEAP32[$$index77>>2] = $$field74;
 $5 = 255;
 $222 = (__ZN10emscripten8internal6TypeIDI13DynamicLASZipE3getEv()|0);
 $223 = $3;
 $224 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEiEE8getCountEv($6)|0);
 $225 = (__ZNK10emscripten8internal12WithPoliciesIJEE11ArgTypeListIJvNS0_17AllowedRawPointerI13DynamicLASZipEEiEE8getTypesEv($6)|0);
 $226 = $5;
 $1 = $226;
 $227 = (__ZN10emscripten8internal19getGenericSignatureIJviiiEEEPKcv()|0);
 $228 = $5;
 $229 = (__ZN10emscripten8internal10getContextIM13DynamicLASZipFviEEEPT_RKS5_($4)|0);
 __embind_register_class_function(($222|0),($223|0),($224|0),($225|0),($227|0),($228|0),($229|0),0);
 STACKTOP = sp;return;
}
function __ZN6LASZip4openEjj($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 192|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(192|0);
 $$byval_copy1 = sp + 180|0;
 $$byval_copy = sp + 176|0;
 $8 = sp + 152|0;
 $14 = sp + 128|0;
 $19 = sp + 104|0;
 $20 = sp + 100|0;
 $27 = sp + 72|0;
 $33 = sp + 48|0;
 $38 = sp + 24|0;
 $39 = sp + 16|0;
 $40 = $0;
 $41 = $1;
 $42 = $2;
 $44 = $40;
 $45 = $41;
 $46 = $45;
 $43 = $46;
 $47 = (__Znwj(20)|0);
 $48 = $43;
 $49 = $42;
 __ZN6laszip7streams13memory_streamC2EPKci($47,$48,$49);
 $36 = $44;
 $37 = $47;
 $50 = $36;
 $51 = $37;
 ;HEAP32[$39>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$39>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7streams13memory_streamEEC2IS3_EEPT_NS_9enable_ifIXsr14is_convertibleIS7_PS3_EE5valueENS4_5__natEE4typeE($38,$51,$$byval_copy);
 $34 = $38;
 $35 = $50;
 $52 = $34;
 $53 = $35;
 $31 = $52;
 $32 = $53;
 $54 = $31;
 $30 = $54;
 $55 = $30;
 $56 = HEAP32[$55>>2]|0;
 HEAP32[$33>>2] = $56;
 $57 = $32;
 $28 = $57;
 $58 = $28;
 $59 = HEAP32[$58>>2]|0;
 $60 = $31;
 HEAP32[$60>>2] = $59;
 $29 = $33;
 $61 = $29;
 $62 = HEAP32[$61>>2]|0;
 $63 = $32;
 HEAP32[$63>>2] = $62;
 $64 = ((($52)) + 4|0);
 $65 = $35;
 $66 = ((($65)) + 4|0);
 $25 = $64;
 $26 = $66;
 $67 = $25;
 $24 = $67;
 $68 = $24;
 $69 = HEAP32[$68>>2]|0;
 HEAP32[$27>>2] = $69;
 $70 = $26;
 $22 = $70;
 $71 = $22;
 $72 = HEAP32[$71>>2]|0;
 $73 = $25;
 HEAP32[$73>>2] = $72;
 $23 = $27;
 $74 = $23;
 $75 = HEAP32[$74>>2]|0;
 $76 = $26;
 HEAP32[$76>>2] = $75;
 __ZNSt3__210shared_ptrIN6laszip7streams13memory_streamEED2Ev($38);
 $77 = ((($44)) + 8|0);
 $78 = (__Znwj(352)|0);
 $21 = $44;
 $79 = $21;
 $80 = HEAP32[$79>>2]|0;
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEEC2ERS4_($78,$80);
 $17 = $77;
 $18 = $78;
 $81 = $17;
 $82 = $18;
 ;HEAP32[$20>>2]=0|0;
 ;HEAP32[$$byval_copy1>>2]=HEAP32[$20>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEEEC2IS7_EEPT_NS_9enable_ifIXsr14is_convertibleISB_PS7_EE5valueENS8_5__natEE4typeE($19,$82,$$byval_copy1);
 $15 = $19;
 $16 = $81;
 $83 = $15;
 $84 = $16;
 $12 = $83;
 $13 = $84;
 $85 = $12;
 $11 = $85;
 $86 = $11;
 $87 = HEAP32[$86>>2]|0;
 HEAP32[$14>>2] = $87;
 $88 = $13;
 $9 = $88;
 $89 = $9;
 $90 = HEAP32[$89>>2]|0;
 $91 = $12;
 HEAP32[$91>>2] = $90;
 $10 = $14;
 $92 = $10;
 $93 = HEAP32[$92>>2]|0;
 $94 = $13;
 HEAP32[$94>>2] = $93;
 $95 = ((($83)) + 4|0);
 $96 = $16;
 $97 = ((($96)) + 4|0);
 $6 = $95;
 $7 = $97;
 $98 = $6;
 $5 = $98;
 $99 = $5;
 $100 = HEAP32[$99>>2]|0;
 HEAP32[$8>>2] = $100;
 $101 = $7;
 $3 = $101;
 $102 = $3;
 $103 = HEAP32[$102>>2]|0;
 $104 = $6;
 HEAP32[$104>>2] = $103;
 $4 = $8;
 $105 = $4;
 $106 = HEAP32[$105>>2]|0;
 $107 = $7;
 HEAP32[$107>>2] = $106;
 __ZNSt3__210shared_ptrIN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEEED2Ev($19);
 STACKTOP = sp;return;
}
function __ZN6LASZip8getPointEi($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $6 = $3;
 $7 = $4;
 $8 = $7;
 $5 = $8;
 $9 = ((($6)) + 8|0);
 $2 = $9;
 $10 = $2;
 $11 = HEAP32[$10>>2]|0;
 $12 = $5;
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE9readPointEPc($11,$12);
 STACKTOP = sp;return;
}
function __ZN6LASZip8getCountEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $2;
 $4 = ((($3)) + 8|0);
 $1 = $4;
 $5 = $1;
 $6 = HEAP32[$5>>2]|0;
 $7 = (__ZNK6laszip2io6reader10basic_fileINS_7streams13memory_streamEE10get_headerEv($6)|0);
 $8 = ((($7)) + 107|0);
 $9 = HEAPU8[$8>>0]|(HEAPU8[$8+1>>0]<<8)|(HEAPU8[$8+2>>0]<<16)|(HEAPU8[$8+3>>0]<<24);
 STACKTOP = sp;return ($9|0);
}
function __ZN13DynamicLASZip4openEjj($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 288|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(288|0);
 $$byval_copy1 = sp + 280|0;
 $$byval_copy = sp + 276|0;
 $8 = sp + 252|0;
 $14 = sp + 228|0;
 $22 = sp + 192|0;
 $29 = sp + 160|0;
 $35 = sp + 136|0;
 $40 = sp + 112|0;
 $41 = sp + 108|0;
 $48 = sp + 80|0;
 $54 = sp + 56|0;
 $59 = sp + 32|0;
 $60 = sp + 24|0;
 $65 = sp;
 $61 = $0;
 $62 = $1;
 $63 = $2;
 $66 = $61;
 $67 = $62;
 $68 = $67;
 $64 = $68;
 $69 = (__Znwj(12)|0);
 $70 = $64;
 $71 = $63;
 __ZN10buf_streamC2EPhj($69,$70,$71);
 $57 = $66;
 $58 = $69;
 $72 = $57;
 $73 = $58;
 ;HEAP32[$60>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$60>>2]|0;
 __ZNSt3__210shared_ptrI10buf_streamEC2IS1_EEPT_NS_9enable_ifIXsr14is_convertibleIS5_PS1_EE5valueENS2_5__natEE4typeE($59,$73,$$byval_copy);
 $55 = $59;
 $56 = $72;
 $74 = $55;
 $75 = $56;
 $52 = $74;
 $53 = $75;
 $76 = $52;
 $51 = $76;
 $77 = $51;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$54>>2] = $78;
 $79 = $53;
 $49 = $79;
 $80 = $49;
 $81 = HEAP32[$80>>2]|0;
 $82 = $52;
 HEAP32[$82>>2] = $81;
 $50 = $54;
 $83 = $50;
 $84 = HEAP32[$83>>2]|0;
 $85 = $53;
 HEAP32[$85>>2] = $84;
 $86 = ((($74)) + 4|0);
 $87 = $56;
 $88 = ((($87)) + 4|0);
 $46 = $86;
 $47 = $88;
 $89 = $46;
 $45 = $89;
 $90 = $45;
 $91 = HEAP32[$90>>2]|0;
 HEAP32[$48>>2] = $91;
 $92 = $47;
 $43 = $92;
 $93 = $43;
 $94 = HEAP32[$93>>2]|0;
 $95 = $46;
 HEAP32[$95>>2] = $94;
 $44 = $48;
 $96 = $44;
 $97 = HEAP32[$96>>2]|0;
 $98 = $47;
 HEAP32[$98>>2] = $97;
 __ZNSt3__210shared_ptrI10buf_streamED2Ev($59);
 $99 = ((($66)) + 8|0);
 $100 = (__Znwj(12)|0);
 $42 = $66;
 $101 = $42;
 $102 = HEAP32[$101>>2]|0;
 __ZN6laszip8decoders10arithmeticI10buf_streamEC2ERS2_($100,$102);
 $38 = $99;
 $39 = $100;
 $103 = $38;
 $104 = $39;
 ;HEAP32[$41>>2]=0|0;
 ;HEAP32[$$byval_copy1>>2]=HEAP32[$41>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticI10buf_streamEEEC2IS5_EEPT_NS_9enable_ifIXsr14is_convertibleIS9_PS5_EE5valueENS6_5__natEE4typeE($40,$104,$$byval_copy1);
 $36 = $40;
 $37 = $103;
 $105 = $36;
 $106 = $37;
 $33 = $105;
 $34 = $106;
 $107 = $33;
 $32 = $107;
 $108 = $32;
 $109 = HEAP32[$108>>2]|0;
 HEAP32[$35>>2] = $109;
 $110 = $34;
 $30 = $110;
 $111 = $30;
 $112 = HEAP32[$111>>2]|0;
 $113 = $33;
 HEAP32[$113>>2] = $112;
 $31 = $35;
 $114 = $31;
 $115 = HEAP32[$114>>2]|0;
 $116 = $34;
 HEAP32[$116>>2] = $115;
 $117 = ((($105)) + 4|0);
 $118 = $37;
 $119 = ((($118)) + 4|0);
 $27 = $117;
 $28 = $119;
 $120 = $27;
 $26 = $120;
 $121 = $26;
 $122 = HEAP32[$121>>2]|0;
 HEAP32[$29>>2] = $122;
 $123 = $28;
 $24 = $123;
 $124 = $24;
 $125 = HEAP32[$124>>2]|0;
 $126 = $27;
 HEAP32[$126>>2] = $125;
 $25 = $29;
 $127 = $25;
 $128 = HEAP32[$127>>2]|0;
 $129 = $28;
 HEAP32[$129>>2] = $128;
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticI10buf_streamEEED2Ev($40);
 $130 = ((($66)) + 8|0);
 $23 = $130;
 $131 = $23;
 $132 = HEAP32[$131>>2]|0;
 __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticI10buf_streamEEEENS0_26dynamic_field_decompressorIT_E3ptrERS7_($65,$132);
 $133 = ((($66)) + 16|0);
 $20 = $133;
 $21 = $65;
 $134 = $20;
 $135 = $21;
 $19 = $135;
 $136 = $19;
 $17 = $22;
 $18 = $136;
 $137 = $17;
 $138 = $18;
 $139 = HEAP32[$138>>2]|0;
 HEAP32[$137>>2] = $139;
 $140 = ((($137)) + 4|0);
 $141 = $18;
 $142 = ((($141)) + 4|0);
 $143 = HEAP32[$142>>2]|0;
 HEAP32[$140>>2] = $143;
 $144 = $18;
 HEAP32[$144>>2] = 0;
 $145 = $18;
 $146 = ((($145)) + 4|0);
 HEAP32[$146>>2] = 0;
 $15 = $22;
 $16 = $134;
 $147 = $15;
 $148 = $16;
 $12 = $147;
 $13 = $148;
 $149 = $12;
 $11 = $149;
 $150 = $11;
 $151 = HEAP32[$150>>2]|0;
 HEAP32[$14>>2] = $151;
 $152 = $13;
 $9 = $152;
 $153 = $9;
 $154 = HEAP32[$153>>2]|0;
 $155 = $12;
 HEAP32[$155>>2] = $154;
 $10 = $14;
 $156 = $10;
 $157 = HEAP32[$156>>2]|0;
 $158 = $13;
 HEAP32[$158>>2] = $157;
 $159 = ((($147)) + 4|0);
 $160 = $16;
 $161 = ((($160)) + 4|0);
 $6 = $159;
 $7 = $161;
 $162 = $6;
 $5 = $162;
 $163 = $5;
 $164 = HEAP32[$163>>2]|0;
 HEAP32[$8>>2] = $164;
 $165 = $7;
 $3 = $165;
 $166 = $3;
 $167 = HEAP32[$166>>2]|0;
 $168 = $6;
 HEAP32[$168>>2] = $167;
 $4 = $8;
 $169 = $4;
 $170 = HEAP32[$169>>2]|0;
 $171 = $7;
 HEAP32[$171>>2] = $170;
 __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticI10buf_streamEEEEED2Ev($22);
 __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticI10buf_streamEEEEED2Ev($65);
 STACKTOP = sp;return;
}
function __ZN13DynamicLASZip16addFieldFloatingEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $7 = $0;
 $8 = $1;
 $9 = $7;
 $10 = ((($9)) + 16|0);
 $6 = $10;
 $11 = $6;
 $5 = $11;
 $12 = $5;
 $13 = HEAP32[$12>>2]|0;
 $14 = ($13|0)!=(0|0);
 if (!($14)) {
  STACKTOP = sp;return;
 }
 $15 = $8;
 switch ($15|0) {
 case 4:  {
  $16 = ((($9)) + 16|0);
  $4 = $16;
  $17 = $4;
  $18 = HEAP32[$17>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIiEEvv($18);
  STACKTOP = sp;return;
  break;
 }
 case 8:  {
  $19 = ((($9)) + 16|0);
  $2 = $19;
  $20 = $2;
  $21 = HEAP32[$20>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIjEEvv($21);
  $22 = ((($9)) + 16|0);
  $3 = $22;
  $23 = $3;
  $24 = HEAP32[$23>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIjEEvv($24);
  STACKTOP = sp;return;
  break;
 }
 default: {
  STACKTOP = sp;return;
 }
 }
}
function __ZN13DynamicLASZip14addFieldSignedEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $8 = $0;
 $9 = $1;
 $10 = $8;
 $11 = ((($10)) + 16|0);
 $7 = $11;
 $12 = $7;
 $6 = $12;
 $13 = $6;
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)!=(0|0);
 if (!($15)) {
  STACKTOP = sp;return;
 }
 $16 = $9;
 switch ($16|0) {
 case 1:  {
  $17 = ((($10)) + 16|0);
  $5 = $17;
  $18 = $5;
  $19 = HEAP32[$18>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIaEEvv($19);
  STACKTOP = sp;return;
  break;
 }
 case 2:  {
  $20 = ((($10)) + 16|0);
  $3 = $20;
  $21 = $3;
  $22 = HEAP32[$21>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIsEEvv($22);
  STACKTOP = sp;return;
  break;
 }
 case 8:  {
  $23 = ((($10)) + 16|0);
  $2 = $23;
  $24 = $2;
  $25 = HEAP32[$24>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIiEEvv($25);
  break;
 }
 case 4:  {
  break;
 }
 default: {
  STACKTOP = sp;return;
 }
 }
 $26 = ((($10)) + 16|0);
 $4 = $26;
 $27 = $4;
 $28 = HEAP32[$27>>2]|0;
 __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIiEEvv($28);
 STACKTOP = sp;return;
}
function __ZN13DynamicLASZip16addFieldUnsignedEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $8 = $0;
 $9 = $1;
 $10 = $8;
 $11 = ((($10)) + 16|0);
 $7 = $11;
 $12 = $7;
 $6 = $12;
 $13 = $6;
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)!=(0|0);
 if (!($15)) {
  STACKTOP = sp;return;
 }
 $16 = $9;
 switch ($16|0) {
 case 1:  {
  $17 = ((($10)) + 16|0);
  $5 = $17;
  $18 = $5;
  $19 = HEAP32[$18>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIhEEvv($19);
  STACKTOP = sp;return;
  break;
 }
 case 2:  {
  $20 = ((($10)) + 16|0);
  $3 = $20;
  $21 = $3;
  $22 = HEAP32[$21>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldItEEvv($22);
  STACKTOP = sp;return;
  break;
 }
 case 8:  {
  $23 = ((($10)) + 16|0);
  $2 = $23;
  $24 = $2;
  $25 = HEAP32[$24>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIjEEvv($25);
  break;
 }
 case 4:  {
  break;
 }
 default: {
  STACKTOP = sp;return;
 }
 }
 $26 = ((($10)) + 16|0);
 $4 = $26;
 $27 = $4;
 $28 = HEAP32[$27>>2]|0;
 __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEE9add_fieldIjEEvv($28);
 STACKTOP = sp;return;
}
function __ZN13DynamicLASZip8getPointEi($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = $0;
 $6 = $1;
 $8 = $5;
 $9 = $6;
 $10 = $9;
 $7 = $10;
 $11 = ((($8)) + 16|0);
 $4 = $11;
 $12 = $4;
 $3 = $12;
 $13 = $3;
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)!=(0|0);
 if (!($15)) {
  STACKTOP = sp;return;
 }
 $16 = ((($8)) + 16|0);
 $2 = $16;
 $17 = $2;
 $18 = HEAP32[$17>>2]|0;
 $19 = HEAP32[$18>>2]|0;
 $20 = HEAP32[$19>>2]|0;
 $21 = $7;
 (FUNCTION_TABLE_iii[$20 & 255]($18,$21)|0);
 STACKTOP = sp;return;
}
function __ZN6laszip7streams13memory_streamC2EPKci($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 HEAP32[$6>>2] = $7;
 $8 = ((($6)) + 4|0);
 $9 = $5;
 HEAP32[$8>>2] = $9;
 $10 = ((($6)) + 8|0);
 HEAP32[$10>>2] = 0;
 $11 = ((($6)) + 12|0);
 HEAP8[$11>>0] = 0;
 $12 = ((($6)) + 13|0);
 HEAP8[$12>>0] = 0;
 $13 = ((($6)) + 16|0);
 HEAP32[$13>>2] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEEC2ERS4_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 12|0;
 $16 = $0;
 $17 = $1;
 $18 = $16;
 $19 = $17;
 HEAP32[$18>>2] = $19;
 $20 = ((($18)) + 4|0);
 $21 = HEAP32[$18>>2]|0;
 __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEEC2ERS3_($20,$21);
 $22 = ((($18)) + 247|0);
 __ZN6laszip2io7laz_vlrC2Ev($22);
 $23 = ((($18)) + 288|0);
 $15 = $23;
 $24 = $15;
 $13 = $24;
 $25 = $13;
 $12 = $25;
 HEAP32[$25>>2] = 0;
 $26 = ((($25)) + 4|0);
 HEAP32[$26>>2] = 0;
 $27 = ((($25)) + 8|0);
 HEAP32[$14>>2] = 0;
 $10 = $27;
 $11 = $14;
 $28 = $10;
 $29 = $11;
 $9 = $29;
 $30 = $9;
 $5 = $28;
 $6 = $30;
 $31 = $5;
 $32 = $6;
 $4 = $32;
 HEAP32[$31>>2] = 0;
 $8 = $28;
 $33 = $8;
 $7 = $33;
 $34 = ((($18)) + 300|0);
 __ZN6laszip7factory13record_schemaC2Ev($34);
 $35 = ((($18)) + 312|0);
 $3 = $35;
 $36 = $3;
 HEAP32[$36>>2] = 0;
 $37 = ((($36)) + 4|0);
 HEAP32[$37>>2] = 0;
 $38 = ((($18)) + 320|0);
 $2 = $38;
 $39 = $2;
 HEAP32[$39>>2] = 0;
 $40 = ((($39)) + 4|0);
 HEAP32[$40>>2] = 0;
 $41 = ((($18)) + 328|0);
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE13__chunk_stateC2Ev($41);
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE5_openEv($18);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7streams13memory_streamEEC2IS3_EEPT_NS_9enable_ifIXsr14is_convertibleIS7_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0;
 var $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0;
 var $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0;
 var $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0;
 var $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (1584);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7streams13memory_streamEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 __ZdlPv($133);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7streams13memory_streamEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7streams13memory_streamEE18__enable_weak_thisEz($0,$varargs) {
 $0 = $0|0;
 $varargs = $varargs|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function ___clang_call_terminate($0) {
 $0 = $0|0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 (___cxa_begin_catch(($0|0))|0);
 __ZSt9terminatev();
 // unreachable;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7streams13memory_streamENS_14default_deleteIS3_EENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7streams13memory_streamENS_14default_deleteIS3_EENS_9allocatorIS3_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7streams13memory_streamENS_14default_deleteIS3_EENS_9allocatorIS3_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7streams13memory_streamENS_14default_deleteIS3_EENS_9allocatorIS3_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  __ZdlPv($28);
 }
 $30 = ((($16)) + 12|0);
 $10 = $30;
 $31 = $10;
 $9 = $31;
 $32 = $9;
 $12 = $32;
 $33 = $12;
 $11 = $33;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7streams13memory_streamENS_14default_deleteIS3_EENS_9allocatorIS3_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 24;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7streams13memory_streamENS_14default_deleteIS3_EENS_9allocatorIS3_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEEEC2IS7_EEPT_NS_9enable_ifIXsr14is_convertibleISB_PS7_EE5valueENS8_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0;
 var $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0;
 var $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0;
 var $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0;
 var $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $50 = sp + 76|0;
 $51 = sp + 72|0;
 $52 = sp + 8|0;
 $53 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$52>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$53>>0]=HEAP8[$66>>0]|0;
 $49 = $79;
 HEAP32[$50>>2] = $80;
 $81 = $49;
 $47 = $81;
 $48 = 0;
 $82 = $47;
 $83 = $48;
 $45 = $82;
 $46 = $83;
 $84 = $45;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $46;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $48;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (1612);
 $89 = ((($81)) + 12|0);
 $21 = $53;
 $90 = $21;
 $30 = $51;
 $31 = $50;
 $32 = $90;
 $91 = $30;
 $92 = $31;
 $29 = $92;
 $93 = $29;
 $23 = $91;
 $24 = $93;
 $94 = $23;
 $95 = $24;
 $22 = $95;
 $96 = $22;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $32;
 $25 = $98;
 $99 = $25;
 $27 = $91;
 $28 = $99;
 $100 = $28;
 $26 = $100;
 $33 = $52;
 $101 = $33;
 $42 = $89;
 $43 = $51;
 $44 = $101;
 $102 = $42;
 $103 = $43;
 $41 = $103;
 $104 = $41;
 $35 = $102;
 $36 = $104;
 $105 = $35;
 $106 = $36;
 $34 = $106;
 $107 = $34;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $44;
 $37 = $108;
 $109 = $37;
 $39 = $102;
 $40 = $109;
 $110 = $40;
 $38 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEEE18__enable_weak_thisEz($68,$vararg_buffer);
 $20 = $65;
 $120 = $20;
 $17 = $120;
 $18 = 0;
 $121 = $17;
 $16 = $121;
 $122 = $16;
 $15 = $122;
 $123 = $15;
 $124 = HEAP32[$123>>2]|0;
 $19 = $124;
 $125 = $18;
 $12 = $121;
 $126 = $12;
 $11 = $126;
 $127 = $11;
 HEAP32[$127>>2] = $125;
 $128 = $19;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $10 = $121;
 $130 = $10;
 $9 = $130;
 $131 = $9;
 $132 = $19;
 $13 = $131;
 $14 = $132;
 $133 = $14;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEED2Ev($133);
 __ZdlPv($133);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEEE18__enable_weak_thisEz($0,$varargs) {
 $0 = $0|0;
 $varargs = $varargs|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEENS_14default_deleteIS7_EENS_9allocatorIS7_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEENS_14default_deleteIS7_EENS_9allocatorIS7_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEENS_14default_deleteIS7_EENS_9allocatorIS7_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEENS_14default_deleteIS7_EENS_9allocatorIS7_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $4 = $22;
 $23 = $4;
 $3 = $23;
 $24 = $3;
 $2 = $24;
 $25 = $2;
 $1 = $25;
 $26 = $1;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEED2Ev($28);
  __ZdlPv($28);
 }
 $30 = ((($16)) + 12|0);
 $10 = $30;
 $31 = $10;
 $9 = $31;
 $32 = $9;
 $12 = $32;
 $33 = $12;
 $11 = $33;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEENS_14default_deleteIS7_EENS_9allocatorIS7_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 48;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip2io6reader10basic_fileINS1_7streams13memory_streamEEENS_14default_deleteIS7_EENS_9allocatorIS7_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 320|0);
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEED2Ev($3);
 $4 = ((($2)) + 312|0);
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEED2Ev($4);
 $5 = ((($2)) + 300|0);
 __ZN6laszip7factory13record_schemaD2Ev($5);
 $6 = ((($2)) + 288|0);
 __ZNSt3__26vectorIyNS_9allocatorIyEEED2Ev($6);
 $7 = ((($2)) + 247|0);
 __ZN6laszip2io7laz_vlrD2Ev($7);
 $8 = ((($2)) + 4|0);
 __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEED2Ev($8);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZN6laszip7factory13record_schemaD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIyNS_9allocatorIyEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__213__vector_baseIyNS_9allocatorIyEEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip2io7laz_vlrD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 34|0);
 $4 = HEAPU8[$3>>0]|(HEAPU8[$3+1>>0]<<8)|(HEAPU8[$3+2>>0]<<16)|(HEAPU8[$3+3>>0]<<24);
 $5 = ($4|0)==(0|0);
 if ($5) {
  STACKTOP = sp;return;
 }
 __ZdaPv($4);
 STACKTOP = sp;return;
}
function __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 12|0);
 $4 = HEAP32[$3>>2]|0;
 __ZN6laszip5utilsL12aligned_freeEPv($4);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__213__vector_baseIN6laszip7factory11record_itemENS_9allocatorIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__213__vector_baseIN6laszip7factory11record_itemENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $19 = sp;
 $22 = sp + 120|0;
 $31 = $0;
 $32 = $31;
 $33 = HEAP32[$32>>2]|0;
 $34 = ($33|0)!=(0|0);
 if (!($34)) {
  STACKTOP = sp;return;
 }
 $30 = $32;
 $35 = $30;
 $36 = HEAP32[$35>>2]|0;
 $27 = $35;
 $28 = $36;
 $37 = $27;
 $38 = ((($37)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $29 = $39;
 while(1) {
  $40 = $28;
  $41 = $29;
  $42 = ($40|0)!=($41|0);
  if (!($42)) {
   break;
  }
  $26 = $37;
  $43 = $26;
  $44 = ((($43)) + 8|0);
  $25 = $44;
  $45 = $25;
  $24 = $45;
  $46 = $24;
  $47 = $29;
  $48 = ((($47)) + -12|0);
  $29 = $48;
  $23 = $48;
  $49 = $23;
  $20 = $46;
  $21 = $49;
  $50 = $20;
  $51 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $50;
  $18 = $51;
  $52 = $17;
  $53 = $18;
  $15 = $52;
  $16 = $53;
 }
 $54 = $28;
 $55 = ((($37)) + 4|0);
 HEAP32[$55>>2] = $54;
 $7 = $32;
 $56 = $7;
 $57 = ((($56)) + 8|0);
 $6 = $57;
 $58 = $6;
 $5 = $58;
 $59 = $5;
 $60 = HEAP32[$32>>2]|0;
 $4 = $32;
 $61 = $4;
 $3 = $61;
 $62 = $3;
 $63 = ((($62)) + 8|0);
 $2 = $63;
 $64 = $2;
 $1 = $64;
 $65 = $1;
 $66 = HEAP32[$65>>2]|0;
 $67 = HEAP32[$61>>2]|0;
 $68 = $66;
 $69 = $67;
 $70 = (($68) - ($69))|0;
 $71 = (($70|0) / 12)&-1;
 $12 = $59;
 $13 = $60;
 $14 = $71;
 $72 = $12;
 $73 = $13;
 $74 = $14;
 $9 = $72;
 $10 = $73;
 $11 = $74;
 $75 = $10;
 $8 = $75;
 $76 = $8;
 __ZdlPv($76);
 STACKTOP = sp;return;
}
function __ZNSt3__213__vector_baseIyNS_9allocatorIyEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $19 = sp;
 $22 = sp + 120|0;
 $31 = $0;
 $32 = $31;
 $33 = HEAP32[$32>>2]|0;
 $34 = ($33|0)!=(0|0);
 if (!($34)) {
  STACKTOP = sp;return;
 }
 $30 = $32;
 $35 = $30;
 $36 = HEAP32[$35>>2]|0;
 $27 = $35;
 $28 = $36;
 $37 = $27;
 $38 = ((($37)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $29 = $39;
 while(1) {
  $40 = $28;
  $41 = $29;
  $42 = ($40|0)!=($41|0);
  if (!($42)) {
   break;
  }
  $26 = $37;
  $43 = $26;
  $44 = ((($43)) + 8|0);
  $25 = $44;
  $45 = $25;
  $24 = $45;
  $46 = $24;
  $47 = $29;
  $48 = ((($47)) + -8|0);
  $29 = $48;
  $23 = $48;
  $49 = $23;
  $20 = $46;
  $21 = $49;
  $50 = $20;
  $51 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $50;
  $18 = $51;
  $52 = $17;
  $53 = $18;
  $15 = $52;
  $16 = $53;
 }
 $54 = $28;
 $55 = ((($37)) + 4|0);
 HEAP32[$55>>2] = $54;
 $7 = $32;
 $56 = $7;
 $57 = ((($56)) + 8|0);
 $6 = $57;
 $58 = $6;
 $5 = $58;
 $59 = $5;
 $60 = HEAP32[$32>>2]|0;
 $4 = $32;
 $61 = $4;
 $3 = $61;
 $62 = $3;
 $63 = ((($62)) + 8|0);
 $2 = $63;
 $64 = $2;
 $1 = $64;
 $65 = $1;
 $66 = HEAP32[$65>>2]|0;
 $67 = HEAP32[$61>>2]|0;
 $68 = $66;
 $69 = $67;
 $70 = (($68) - ($69))|0;
 $71 = (($70|0) / 8)&-1;
 $12 = $59;
 $13 = $60;
 $14 = $71;
 $72 = $12;
 $73 = $13;
 $74 = $14;
 $9 = $72;
 $10 = $73;
 $11 = $74;
 $75 = $10;
 $8 = $75;
 $76 = $8;
 __ZdlPv($76);
 STACKTOP = sp;return;
}
function __ZN6laszip5utilsL12aligned_freeEPv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + -4|0);
 $4 = HEAP32[$3>>2]|0;
 _free($4);
 STACKTOP = sp;return;
}
function __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEEC2ERS3_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 HEAP32[$4>>2] = $5;
 $6 = ((($4)) + 4|0);
 HEAP32[$6>>2] = 0;
 $7 = ((($4)) + 8|0);
 HEAP32[$7>>2] = 0;
 $8 = ((($4)) + 12|0);
 $9 = (__ZN6laszip5utilsL14aligned_mallocEi(1048576)|0);
 HEAP32[$8>>2] = $9;
 STACKTOP = sp;return;
}
function __ZN6laszip2io7laz_vlrC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 32|0);
 HEAP8[$3>>0]=0&255;HEAP8[$3+1>>0]=0>>8;
 $4 = ((($2)) + 34|0);
 HEAP8[$4>>0]=0&255;HEAP8[$4+1>>0]=(0>>8)&255;HEAP8[$4+2>>0]=(0>>16)&255;HEAP8[$4+3>>0]=0>>24;
 STACKTOP = sp;return;
}
function __ZN6laszip7factory13record_schemaC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $11 = sp + 8|0;
 $13 = $0;
 $14 = $13;
 $12 = $14;
 $15 = $12;
 $10 = $15;
 $16 = $10;
 $9 = $16;
 HEAP32[$16>>2] = 0;
 $17 = ((($16)) + 4|0);
 HEAP32[$17>>2] = 0;
 $18 = ((($16)) + 8|0);
 HEAP32[$11>>2] = 0;
 $7 = $18;
 $8 = $11;
 $19 = $7;
 $20 = $8;
 $6 = $20;
 $21 = $6;
 $2 = $19;
 $3 = $21;
 $22 = $2;
 $23 = $3;
 $1 = $23;
 HEAP32[$22>>2] = 0;
 $5 = $19;
 $24 = $5;
 $4 = $24;
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE13__chunk_stateC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = $2;
 $4 = $3;
 HEAP32[$4>>2] = 0;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP32[$6>>2] = 0;
 $7 = ((($2)) + 8|0);
 $8 = $7;
 $9 = $8;
 HEAP32[$9>>2] = 0;
 $10 = (($8) + 4)|0;
 $11 = $10;
 HEAP32[$11>>2] = 0;
 $12 = ((($2)) + 16|0);
 $13 = $12;
 $14 = $13;
 HEAP32[$14>>2] = -1;
 $15 = (($13) + 4)|0;
 $16 = $15;
 HEAP32[$16>>2] = -1;
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE5_openEv($0) {
 $0 = $0|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $$expand_i1_val = 0, $$expand_i1_val3 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0;
 var $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0;
 var $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0;
 var $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0;
 var $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0;
 var $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0;
 var $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0;
 var $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 336|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(336|0);
 $$byval_copy1 = sp + 88|0;
 $$byval_copy = sp + 72|0;
 $3 = sp + 64|0;
 $13 = sp + 268|0;
 $16 = sp + 256|0;
 $20 = sp + 240|0;
 $23 = sp + 228|0;
 $26 = sp + 56|0;
 $37 = sp + 320|0;
 $51 = sp + 316|0;
 $52 = sp + 116|0;
 $53 = sp + 40|0;
 $55 = sp + 108|0;
 $56 = sp + 104|0;
 $57 = sp + 16|0;
 $58 = sp;
 $50 = $0;
 $59 = $50;
 $60 = HEAP32[$59>>2]|0;
 __ZN6laszip7streams13memory_stream4readEPci($60,$51,4);
 $61 = ((($51)) + 4|0);
 $47 = $52;
 $48 = $51;
 $49 = $61;
 $62 = $47;
 $46 = $62;
 $63 = $46;
 $45 = $63;
 $64 = $45;
 ;HEAP32[$64>>2]=0|0;HEAP32[$64+4>>2]=0|0;HEAP32[$64+8>>2]=0|0;
 $44 = $63;
 $65 = $44;
 $43 = $65;
 $66 = $48;
 $67 = $49;
 __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE6__initIPcEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeES9_S9_($62,$66,$67);
 $41 = $52;
 $42 = 4257;
 $68 = $41;
 $69 = $42;
 $38 = $68;
 $39 = $69;
 $70 = $39;
 $71 = (__ZNSt3__211char_traitsIcE6lengthEPKc($70)|0);
 $40 = $71;
 $72 = $40;
 $73 = $38;
 $36 = $73;
 $74 = $36;
 $35 = $74;
 $75 = $35;
 $34 = $75;
 $76 = $34;
 $33 = $76;
 $77 = $33;
 $78 = ((($77)) + 11|0);
 $79 = HEAP8[$78>>0]|0;
 $80 = $79&255;
 $81 = $80 & 128;
 $82 = ($81|0)!=(0);
 if ($82) {
  $29 = $74;
  $83 = $29;
  $28 = $83;
  $84 = $28;
  $27 = $84;
  $85 = $27;
  $86 = ((($85)) + 4|0);
  $87 = HEAP32[$86>>2]|0;
  $95 = $87;
 } else {
  $32 = $74;
  $88 = $32;
  $31 = $88;
  $89 = $31;
  $30 = $89;
  $90 = $30;
  $91 = ((($90)) + 11|0);
  $92 = HEAP8[$91>>0]|0;
  $93 = $92&255;
  $95 = $93;
 }
 $94 = ($72|0)!=($95|0);
 if ($94) {
  $$expand_i1_val = 0;
  HEAP8[$37>>0] = $$expand_i1_val;
 } else {
  $96 = $38;
  $97 = $39;
  $98 = $40;
  $99 = (__ZNKSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE7compareEjjPKcj($96,0,-1,$97,$98)|0);
  $100 = ($99|0)==(0);
  $$expand_i1_val3 = $100&1;
  HEAP8[$37>>0] = $$expand_i1_val3;
 }
 $$pre_trunc = HEAP8[$37>>0]|0;
 $101 = $$pre_trunc&1;
 $102 = $101 ^ 1;
 __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEED2Ev($52);
 if ($102) {
  $103 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip13invalid_magicC2Ev($103);
  ___cxa_throw(($103|0),(56|0),(11|0));
  // unreachable;
 }
 $104 = HEAP32[$59>>2]|0;
 $25 = $53;
 $105 = $26;
 $106 = $105;
 HEAP32[$106>>2] = 0;
 $107 = (($105) + 4)|0;
 $108 = $107;
 HEAP32[$108>>2] = 0;
 $109 = $25;
 ;HEAP32[$109>>2]=0|0;HEAP32[$109+4>>2]=0|0;
 $110 = ((($109)) + 8|0);
 $111 = $26;
 $112 = $111;
 $113 = HEAP32[$112>>2]|0;
 $114 = (($111) + 4)|0;
 $115 = $114;
 $116 = HEAP32[$115>>2]|0;
 $117 = $110;
 $118 = $117;
 HEAP32[$118>>2] = $113;
 $119 = (($117) + 4)|0;
 $120 = $119;
 HEAP32[$120>>2] = $116;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$53>>2]|0;HEAP32[$$byval_copy+4>>2]=HEAP32[$53+4>>2]|0;HEAP32[$$byval_copy+8>>2]=HEAP32[$53+8>>2]|0;HEAP32[$$byval_copy+12>>2]=HEAP32[$53+12>>2]|0;
 __ZN6laszip7streams13memory_stream5seekgENSt3__24fposI11__mbstate_tEE($104,$$byval_copy);
 $121 = HEAP32[$59>>2]|0;
 $122 = ((($59)) + 20|0);
 __ZN6laszip7streams13memory_stream4readEPci($121,$122,227);
 $123 = ((($59)) + 20|0);
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE10_fixMinMaxERNS0_6headerE($59,$123);
 $124 = (__ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE11_validatorsEv()|0);
 $54 = $124;
 $125 = $54;
 $24 = $125;
 $126 = $24;
 $127 = HEAP32[$126>>2]|0;
 $21 = $126;
 $22 = $127;
 $128 = $22;
 $18 = $20;
 $19 = $128;
 $129 = $18;
 $130 = $19;
 HEAP32[$129>>2] = $130;
 $131 = HEAP32[$20>>2]|0;
 HEAP32[$23>>2] = $131;
 $132 = HEAP32[$23>>2]|0;
 HEAP32[$55>>2] = $132;
 $133 = $54;
 $17 = $133;
 $134 = $17;
 $135 = ((($134)) + 4|0);
 $136 = HEAP32[$135>>2]|0;
 $14 = $134;
 $15 = $136;
 $137 = $15;
 $11 = $13;
 $12 = $137;
 $138 = $11;
 $139 = $12;
 HEAP32[$138>>2] = $139;
 $140 = HEAP32[$13>>2]|0;
 HEAP32[$16>>2] = $140;
 $141 = HEAP32[$16>>2]|0;
 HEAP32[$56>>2] = $141;
 while(1) {
  $9 = $55;
  $10 = $56;
  $142 = $9;
  $143 = $10;
  $7 = $142;
  $8 = $143;
  $144 = $7;
  $6 = $144;
  $145 = $6;
  $146 = HEAP32[$145>>2]|0;
  $147 = $8;
  $5 = $147;
  $148 = $5;
  $149 = HEAP32[$148>>2]|0;
  $150 = ($146|0)==($149|0);
  $151 = $150 ^ 1;
  if (!($151)) {
   break;
  }
  $4 = $55;
  $152 = $4;
  $153 = HEAP32[$152>>2]|0;
  __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2ERKS6_($57,$153);
  $154 = ((($59)) + 20|0);
  __ZNKSt3__28functionIFvRN6laszip2io6headerEEEclES4_($57,$154);
  __ZNSt3__28functionIFvRN6laszip2io6headerEEED2Ev($57);
  $1 = $55;
  $155 = $1;
  $156 = HEAP32[$155>>2]|0;
  $157 = ((($156)) + 24|0);
  HEAP32[$155>>2] = $157;
 }
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE12_parseLASZIPEv($59);
 __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE16_parseChunkTableEv($59);
 $158 = HEAP32[$59>>2]|0;
 __ZN6laszip7streams13memory_stream5clearEv($158);
 $159 = HEAP32[$59>>2]|0;
 $160 = ((($59)) + 20|0);
 $161 = ((($160)) + 96|0);
 $162 = HEAP32[$161>>2]|0;
 $163 = (($162) + 8)|0;
 $2 = $58;
 $164 = $3;
 $165 = $164;
 HEAP32[$165>>2] = $163;
 $166 = (($164) + 4)|0;
 $167 = $166;
 HEAP32[$167>>2] = 0;
 $168 = $2;
 ;HEAP32[$168>>2]=0|0;HEAP32[$168+4>>2]=0|0;
 $169 = ((($168)) + 8|0);
 $170 = $3;
 $171 = $170;
 $172 = HEAP32[$171>>2]|0;
 $173 = (($170) + 4)|0;
 $174 = $173;
 $175 = HEAP32[$174>>2]|0;
 $176 = $169;
 $177 = $176;
 HEAP32[$177>>2] = $172;
 $178 = (($176) + 4)|0;
 $179 = $178;
 HEAP32[$179>>2] = $175;
 ;HEAP32[$$byval_copy1>>2]=HEAP32[$58>>2]|0;HEAP32[$$byval_copy1+4>>2]=HEAP32[$58+4>>2]|0;HEAP32[$$byval_copy1+8>>2]=HEAP32[$58+8>>2]|0;HEAP32[$$byval_copy1+12>>2]=HEAP32[$58+12>>2]|0;
 __ZN6laszip7streams13memory_stream5seekgENSt3__24fposI11__mbstate_tEE($159,$$byval_copy1);
 $180 = ((($59)) + 4|0);
 __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE5resetEv($180);
 STACKTOP = sp;return;
}
function __ZN6laszip5utilsL14aligned_mallocEi($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $4 = $1;
 $5 = (($4) + 64)|0;
 $6 = (($5) + 4)|0;
 $7 = (_malloc($6)|0);
 $2 = $7;
 $8 = $2;
 $9 = $8;
 $10 = (($9) + 64)|0;
 $11 = (($10) + 4)|0;
 $12 = $11 & -64;
 $13 = $12;
 $3 = $13;
 $14 = $2;
 $15 = $3;
 $16 = ((($15)) + -4|0);
 HEAP32[$16>>2] = $14;
 $17 = $3;
 STACKTOP = sp;return ($17|0);
}
function __ZN6laszip7streams13memory_stream4readEPci($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 96|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(96|0);
 $18 = sp;
 $21 = sp + 92|0;
 $24 = sp + 12|0;
 $26 = sp + 4|0;
 $22 = $0;
 $23 = $1;
 HEAP32[$24>>2] = $2;
 $27 = $22;
 $28 = ((($27)) + 13|0);
 $29 = HEAP8[$28>>0]|0;
 $30 = $29&1;
 if ($30) {
  $31 = ((($27)) + 12|0);
  HEAP8[$31>>0] = 1;
  STACKTOP = sp;return;
 }
 $32 = ((($27)) + 4|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = ((($27)) + 8|0);
 $35 = HEAP32[$34>>2]|0;
 $36 = (($33) - ($35))|0;
 HEAP32[$26>>2] = $36;
 $19 = $24;
 $20 = $26;
 $37 = $19;
 $38 = $20;
 ;HEAP8[$18>>0]=HEAP8[$21>>0]|0;
 $16 = $37;
 $17 = $38;
 $39 = $17;
 $40 = $16;
 $13 = $18;
 $14 = $39;
 $15 = $40;
 $41 = $14;
 $42 = HEAP32[$41>>2]|0;
 $43 = $15;
 $44 = HEAP32[$43>>2]|0;
 $45 = ($42|0)<($44|0);
 $46 = $17;
 $47 = $16;
 $48 = $45 ? $46 : $47;
 $49 = HEAP32[$48>>2]|0;
 $25 = $49;
 $50 = HEAP32[$27>>2]|0;
 $51 = ((($27)) + 8|0);
 $52 = HEAP32[$51>>2]|0;
 $53 = (($50) + ($52)|0);
 $54 = HEAP32[$27>>2]|0;
 $55 = ((($27)) + 8|0);
 $56 = HEAP32[$55>>2]|0;
 $57 = (($54) + ($56)|0);
 $58 = $25;
 $59 = (($57) + ($58)|0);
 $60 = $23;
 $10 = $53;
 $11 = $59;
 $12 = $60;
 $61 = $10;
 $9 = $61;
 $62 = $9;
 $63 = $11;
 $3 = $63;
 $64 = $3;
 $65 = $12;
 $4 = $65;
 $66 = $4;
 $5 = $62;
 $6 = $64;
 $7 = $66;
 $67 = $6;
 $68 = $5;
 $69 = $67;
 $70 = $68;
 $71 = (($69) - ($70))|0;
 $8 = $71;
 $72 = $8;
 $73 = ($72>>>0)>(0);
 if ($73) {
  $74 = $7;
  $75 = $5;
  $76 = $8;
  _memmove(($74|0),($75|0),($76|0))|0;
 }
 $77 = $25;
 $78 = ((($27)) + 8|0);
 $79 = HEAP32[$78>>2]|0;
 $80 = (($79) + ($77))|0;
 HEAP32[$78>>2] = $80;
 $81 = $25;
 $82 = ((($27)) + 16|0);
 HEAP32[$82>>2] = $81;
 $83 = ((($27)) + 8|0);
 $84 = HEAP32[$83>>2]|0;
 $85 = ((($27)) + 4|0);
 $86 = HEAP32[$85>>2]|0;
 $87 = ($84|0)>=($86|0);
 if (!($87)) {
  STACKTOP = sp;return;
 }
 $88 = ((($27)) + 13|0);
 HEAP8[$88>>0] = 1;
 STACKTOP = sp;return;
}
function __ZN6laszip13invalid_magicC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,4355);
 HEAP32[$2>>2] = (1640);
 STACKTOP = sp;return;
}
function __ZN6laszip13invalid_magicD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7streams13memory_stream5seekgENSt3__24fposI11__mbstate_tEE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $4 = $0;
 $5 = $4;
 $3 = $1;
 $6 = $3;
 $7 = ((($6)) + 8|0);
 $8 = $7;
 $9 = $8;
 $10 = HEAP32[$9>>2]|0;
 $11 = (($8) + 4)|0;
 $12 = $11;
 $13 = HEAP32[$12>>2]|0;
 $14 = ((($5)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = ($15|0)<(0);
 $17 = $16 << 31 >> 31;
 $18 = ($13|0)>($17|0);
 $19 = ($10>>>0)>=($15>>>0);
 $20 = ($13|0)==($17|0);
 $21 = $20 & $19;
 $22 = $18 | $21;
 if ($22) {
  $23 = ((($5)) + 12|0);
  HEAP8[$23>>0] = 1;
  STACKTOP = sp;return;
 } else {
  $2 = $1;
  $24 = $2;
  $25 = ((($24)) + 8|0);
  $26 = $25;
  $27 = $26;
  $28 = HEAP32[$27>>2]|0;
  $29 = (($26) + 4)|0;
  $30 = $29;
  $31 = HEAP32[$30>>2]|0;
  $32 = ((($5)) + 8|0);
  HEAP32[$32>>2] = $28;
  STACKTOP = sp;return;
 }
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE10_fixMinMaxERNS0_6headerE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0.0, $13 = 0, $14 = 0, $15 = 0, $16 = 0.0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0.0, $21 = 0, $22 = 0, $23 = 0.0, $24 = 0, $25 = 0, $26 = 0, $27 = 0.0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0.0, $32 = 0.0, $33 = 0, $34 = 0, $35 = 0.0, $36 = 0, $37 = 0, $38 = 0.0, $39 = 0, $4 = 0.0, $40 = 0, $41 = 0, $42 = 0.0, $43 = 0, $44 = 0, $45 = 0, $46 = 0.0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0.0, $50 = 0.0, $51 = 0, $52 = 0, $53 = 0, $6 = 0.0, $7 = 0.0, $8 = 0.0, $9 = 0.0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $2 = $0;
 $3 = $1;
 $10 = $3;
 $11 = ((($10)) + 179|0);
 HEAP8[tempDoublePtr>>0]=HEAP8[$11>>0];HEAP8[tempDoublePtr+1>>0]=HEAP8[$11+1>>0];HEAP8[tempDoublePtr+2>>0]=HEAP8[$11+2>>0];HEAP8[tempDoublePtr+3>>0]=HEAP8[$11+3>>0];HEAP8[tempDoublePtr+4>>0]=HEAP8[$11+4>>0];HEAP8[tempDoublePtr+5>>0]=HEAP8[$11+5>>0];HEAP8[tempDoublePtr+6>>0]=HEAP8[$11+6>>0];HEAP8[tempDoublePtr+7>>0]=HEAP8[$11+7>>0];$12 = +HEAPF64[tempDoublePtr>>3];
 $4 = $12;
 $13 = $3;
 $14 = ((($13)) + 179|0);
 $15 = ((($14)) + 8|0);
 HEAP8[tempDoublePtr>>0]=HEAP8[$15>>0];HEAP8[tempDoublePtr+1>>0]=HEAP8[$15+1>>0];HEAP8[tempDoublePtr+2>>0]=HEAP8[$15+2>>0];HEAP8[tempDoublePtr+3>>0]=HEAP8[$15+3>>0];HEAP8[tempDoublePtr+4>>0]=HEAP8[$15+4>>0];HEAP8[tempDoublePtr+5>>0]=HEAP8[$15+5>>0];HEAP8[tempDoublePtr+6>>0]=HEAP8[$15+6>>0];HEAP8[tempDoublePtr+7>>0]=HEAP8[$15+7>>0];$16 = +HEAPF64[tempDoublePtr>>3];
 $7 = $16;
 $17 = $3;
 $18 = ((($17)) + 179|0);
 $19 = ((($18)) + 16|0);
 HEAP8[tempDoublePtr>>0]=HEAP8[$19>>0];HEAP8[tempDoublePtr+1>>0]=HEAP8[$19+1>>0];HEAP8[tempDoublePtr+2>>0]=HEAP8[$19+2>>0];HEAP8[tempDoublePtr+3>>0]=HEAP8[$19+3>>0];HEAP8[tempDoublePtr+4>>0]=HEAP8[$19+4>>0];HEAP8[tempDoublePtr+5>>0]=HEAP8[$19+5>>0];HEAP8[tempDoublePtr+6>>0]=HEAP8[$19+6>>0];HEAP8[tempDoublePtr+7>>0]=HEAP8[$19+7>>0];$20 = +HEAPF64[tempDoublePtr>>3];
 $5 = $20;
 $21 = $3;
 $22 = ((($21)) + 203|0);
 HEAP8[tempDoublePtr>>0]=HEAP8[$22>>0];HEAP8[tempDoublePtr+1>>0]=HEAP8[$22+1>>0];HEAP8[tempDoublePtr+2>>0]=HEAP8[$22+2>>0];HEAP8[tempDoublePtr+3>>0]=HEAP8[$22+3>>0];HEAP8[tempDoublePtr+4>>0]=HEAP8[$22+4>>0];HEAP8[tempDoublePtr+5>>0]=HEAP8[$22+5>>0];HEAP8[tempDoublePtr+6>>0]=HEAP8[$22+6>>0];HEAP8[tempDoublePtr+7>>0]=HEAP8[$22+7>>0];$23 = +HEAPF64[tempDoublePtr>>3];
 $8 = $23;
 $24 = $3;
 $25 = ((($24)) + 203|0);
 $26 = ((($25)) + 8|0);
 HEAP8[tempDoublePtr>>0]=HEAP8[$26>>0];HEAP8[tempDoublePtr+1>>0]=HEAP8[$26+1>>0];HEAP8[tempDoublePtr+2>>0]=HEAP8[$26+2>>0];HEAP8[tempDoublePtr+3>>0]=HEAP8[$26+3>>0];HEAP8[tempDoublePtr+4>>0]=HEAP8[$26+4>>0];HEAP8[tempDoublePtr+5>>0]=HEAP8[$26+5>>0];HEAP8[tempDoublePtr+6>>0]=HEAP8[$26+6>>0];HEAP8[tempDoublePtr+7>>0]=HEAP8[$26+7>>0];$27 = +HEAPF64[tempDoublePtr>>3];
 $6 = $27;
 $28 = $3;
 $29 = ((($28)) + 203|0);
 $30 = ((($29)) + 16|0);
 HEAP8[tempDoublePtr>>0]=HEAP8[$30>>0];HEAP8[tempDoublePtr+1>>0]=HEAP8[$30+1>>0];HEAP8[tempDoublePtr+2>>0]=HEAP8[$30+2>>0];HEAP8[tempDoublePtr+3>>0]=HEAP8[$30+3>>0];HEAP8[tempDoublePtr+4>>0]=HEAP8[$30+4>>0];HEAP8[tempDoublePtr+5>>0]=HEAP8[$30+5>>0];HEAP8[tempDoublePtr+6>>0]=HEAP8[$30+6>>0];HEAP8[tempDoublePtr+7>>0]=HEAP8[$30+7>>0];$31 = +HEAPF64[tempDoublePtr>>3];
 $9 = $31;
 $32 = $7;
 $33 = $3;
 $34 = ((($33)) + 179|0);
 HEAPF64[tempDoublePtr>>3]=$32;HEAP8[$34>>0]=HEAP8[tempDoublePtr>>0];HEAP8[$34+1>>0]=HEAP8[tempDoublePtr+1>>0];HEAP8[$34+2>>0]=HEAP8[tempDoublePtr+2>>0];HEAP8[$34+3>>0]=HEAP8[tempDoublePtr+3>>0];HEAP8[$34+4>>0]=HEAP8[tempDoublePtr+4>>0];HEAP8[$34+5>>0]=HEAP8[tempDoublePtr+5>>0];HEAP8[$34+6>>0]=HEAP8[tempDoublePtr+6>>0];HEAP8[$34+7>>0]=HEAP8[tempDoublePtr+7>>0];
 $35 = $4;
 $36 = $3;
 $37 = ((($36)) + 203|0);
 HEAPF64[tempDoublePtr>>3]=$35;HEAP8[$37>>0]=HEAP8[tempDoublePtr>>0];HEAP8[$37+1>>0]=HEAP8[tempDoublePtr+1>>0];HEAP8[$37+2>>0]=HEAP8[tempDoublePtr+2>>0];HEAP8[$37+3>>0]=HEAP8[tempDoublePtr+3>>0];HEAP8[$37+4>>0]=HEAP8[tempDoublePtr+4>>0];HEAP8[$37+5>>0]=HEAP8[tempDoublePtr+5>>0];HEAP8[$37+6>>0]=HEAP8[tempDoublePtr+6>>0];HEAP8[$37+7>>0]=HEAP8[tempDoublePtr+7>>0];
 $38 = $8;
 $39 = $3;
 $40 = ((($39)) + 179|0);
 $41 = ((($40)) + 8|0);
 HEAPF64[tempDoublePtr>>3]=$38;HEAP8[$41>>0]=HEAP8[tempDoublePtr>>0];HEAP8[$41+1>>0]=HEAP8[tempDoublePtr+1>>0];HEAP8[$41+2>>0]=HEAP8[tempDoublePtr+2>>0];HEAP8[$41+3>>0]=HEAP8[tempDoublePtr+3>>0];HEAP8[$41+4>>0]=HEAP8[tempDoublePtr+4>>0];HEAP8[$41+5>>0]=HEAP8[tempDoublePtr+5>>0];HEAP8[$41+6>>0]=HEAP8[tempDoublePtr+6>>0];HEAP8[$41+7>>0]=HEAP8[tempDoublePtr+7>>0];
 $42 = $5;
 $43 = $3;
 $44 = ((($43)) + 203|0);
 $45 = ((($44)) + 8|0);
 HEAPF64[tempDoublePtr>>3]=$42;HEAP8[$45>>0]=HEAP8[tempDoublePtr>>0];HEAP8[$45+1>>0]=HEAP8[tempDoublePtr+1>>0];HEAP8[$45+2>>0]=HEAP8[tempDoublePtr+2>>0];HEAP8[$45+3>>0]=HEAP8[tempDoublePtr+3>>0];HEAP8[$45+4>>0]=HEAP8[tempDoublePtr+4>>0];HEAP8[$45+5>>0]=HEAP8[tempDoublePtr+5>>0];HEAP8[$45+6>>0]=HEAP8[tempDoublePtr+6>>0];HEAP8[$45+7>>0]=HEAP8[tempDoublePtr+7>>0];
 $46 = $9;
 $47 = $3;
 $48 = ((($47)) + 179|0);
 $49 = ((($48)) + 16|0);
 HEAPF64[tempDoublePtr>>3]=$46;HEAP8[$49>>0]=HEAP8[tempDoublePtr>>0];HEAP8[$49+1>>0]=HEAP8[tempDoublePtr+1>>0];HEAP8[$49+2>>0]=HEAP8[tempDoublePtr+2>>0];HEAP8[$49+3>>0]=HEAP8[tempDoublePtr+3>>0];HEAP8[$49+4>>0]=HEAP8[tempDoublePtr+4>>0];HEAP8[$49+5>>0]=HEAP8[tempDoublePtr+5>>0];HEAP8[$49+6>>0]=HEAP8[tempDoublePtr+6>>0];HEAP8[$49+7>>0]=HEAP8[tempDoublePtr+7>>0];
 $50 = $6;
 $51 = $3;
 $52 = ((($51)) + 203|0);
 $53 = ((($52)) + 16|0);
 HEAPF64[tempDoublePtr>>3]=$50;HEAP8[$53>>0]=HEAP8[tempDoublePtr>>0];HEAP8[$53+1>>0]=HEAP8[tempDoublePtr+1>>0];HEAP8[$53+2>>0]=HEAP8[tempDoublePtr+2>>0];HEAP8[$53+3>>0]=HEAP8[tempDoublePtr+3>>0];HEAP8[$53+4>>0]=HEAP8[tempDoublePtr+4>>0];HEAP8[$53+5>>0]=HEAP8[tempDoublePtr+5>>0];HEAP8[$53+6>>0]=HEAP8[tempDoublePtr+6>>0];HEAP8[$53+7>>0]=HEAP8[tempDoublePtr+7>>0];
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE11_validatorsEv() {
 var $$byval_copy = 0, $0 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 208|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(208|0);
 $$byval_copy = sp + 195|0;
 $13 = sp + 24|0;
 $18 = sp + 194|0;
 $29 = sp + 193|0;
 $42 = sp + 32|0;
 $44 = sp;
 $45 = sp + 192|0;
 $46 = HEAP8[21176]|0;
 $47 = ($46<<24>>24)==(0);
 if ($47) {
  $48 = (___cxa_guard_acquire(21176)|0);
  $49 = ($48|0)!=(0);
  if ($49) {
   $43 = 21216;
   $50 = $43;
   $41 = $50;
   $51 = $41;
   $40 = $51;
   HEAP32[$51>>2] = 0;
   $52 = ((($51)) + 4|0);
   HEAP32[$52>>2] = 0;
   $53 = ((($51)) + 8|0);
   HEAP32[$42>>2] = 0;
   $38 = $53;
   $39 = $42;
   $54 = $38;
   $55 = $39;
   $37 = $55;
   $56 = $37;
   $33 = $54;
   $34 = $56;
   $57 = $33;
   $58 = $34;
   $32 = $58;
   HEAP32[$57>>2] = 0;
   $36 = $54;
   $59 = $36;
   $35 = $59;
  }
 }
 $60 = HEAP8[21184]|0;
 $61 = ($60<<24>>24)==(0);
 if ($61) {
  $62 = (___cxa_guard_acquire(21184)|0);
  $63 = ($62|0)!=(0);
  if ($63) {
  }
 }
 $31 = 21216;
 $64 = $31;
 $65 = HEAP32[$64>>2]|0;
 $66 = ((($64)) + 4|0);
 $67 = HEAP32[$66>>2]|0;
 $68 = ($65|0)==($67|0);
 if (!($68)) {
  STACKTOP = sp;return (21216|0);
 }
 __ZNSt3__25mutex4lockEv(21228);
 $30 = 21216;
 $69 = $30;
 $70 = HEAP32[$69>>2]|0;
 $71 = ((($69)) + 4|0);
 $72 = HEAP32[$71>>2]|0;
 $73 = ($70|0)==($72|0);
 if ($73) {
  ;HEAP8[$$byval_copy>>0]=HEAP8[$45>>0]|0;
  __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2IZNS2_6reader10basic_fileINS1_7streams13memory_streamEE11_validatorsEvEUlS4_E_vEET_($44,$$byval_copy);
  $27 = 21216;
  $28 = $44;
  $74 = $27;
  $75 = ((($74)) + 4|0);
  $76 = HEAP32[$75>>2]|0;
  $26 = $74;
  $77 = $26;
  $78 = ((($77)) + 8|0);
  $25 = $78;
  $79 = $25;
  $24 = $79;
  $80 = $24;
  $81 = HEAP32[$80>>2]|0;
  $82 = ($76>>>0)<($81>>>0);
  if ($82) {
   $21 = $29;
   $22 = $74;
   $23 = 1;
   $4 = $74;
   $83 = $4;
   $84 = ((($83)) + 8|0);
   $3 = $84;
   $85 = $3;
   $2 = $85;
   $86 = $2;
   $87 = ((($74)) + 4|0);
   $88 = HEAP32[$87>>2]|0;
   $0 = $88;
   $89 = $0;
   $90 = $28;
   $1 = $90;
   $91 = $1;
   $15 = $86;
   $16 = $89;
   $17 = $91;
   $92 = $15;
   $93 = $16;
   $94 = $17;
   $14 = $94;
   $95 = $14;
   ;HEAP8[$13>>0]=HEAP8[$18>>0]|0;
   $10 = $92;
   $11 = $93;
   $12 = $95;
   $96 = $10;
   $97 = $11;
   $98 = $12;
   $9 = $98;
   $99 = $9;
   $6 = $96;
   $7 = $97;
   $8 = $99;
   $100 = $7;
   $101 = $8;
   $5 = $101;
   $102 = $5;
   __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2EOS6_($100,$102);
   $19 = $29;
   $103 = ((($74)) + 4|0);
   $104 = HEAP32[$103>>2]|0;
   $105 = ((($104)) + 24|0);
   HEAP32[$103>>2] = $105;
  } else {
   $106 = $28;
   $20 = $106;
   $107 = $20;
   __ZNSt3__26vectorINS_8functionIFvRN6laszip2io6headerEEEENS_9allocatorIS7_EEE21__push_back_slow_pathIS7_EEvOT_($74,$107);
  }
  __ZNSt3__28functionIFvRN6laszip2io6headerEEED2Ev($44);
 }
 __ZNSt3__25mutex6unlockEv(21228);
 STACKTOP = sp;return (21216|0);
}
function __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2ERKS6_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 $6 = ((($5)) + 16|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if ($8) {
  $9 = ((($4)) + 16|0);
  HEAP32[$9>>2] = 0;
  STACKTOP = sp;return;
 }
 $10 = $3;
 $11 = ((($10)) + 16|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = $3;
 $14 = ($12|0)==($13|0);
 if ($14) {
  $15 = (__ZNSt3__28functionIFvRN6laszip2io6headerEEE9__as_baseEPv($4)|0);
  $16 = ((($4)) + 16|0);
  HEAP32[$16>>2] = $15;
  $17 = $3;
  $18 = ((($17)) + 16|0);
  $19 = HEAP32[$18>>2]|0;
  $20 = HEAP32[$19>>2]|0;
  $21 = ((($20)) + 12|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = ((($4)) + 16|0);
  $24 = HEAP32[$23>>2]|0;
  FUNCTION_TABLE_vii[$22 & 255]($19,$24);
  STACKTOP = sp;return;
 } else {
  $25 = $3;
  $26 = ((($25)) + 16|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = HEAP32[$27>>2]|0;
  $29 = ((($28)) + 8|0);
  $30 = HEAP32[$29>>2]|0;
  $31 = (FUNCTION_TABLE_ii[$30 & 255]($27)|0);
  $32 = ((($4)) + 16|0);
  HEAP32[$32>>2] = $31;
  STACKTOP = sp;return;
 }
}
function __ZNKSt3__28functionIFvRN6laszip2io6headerEEEclES4_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $3;
 $6 = ((($5)) + 16|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if ($8) {
  $9 = (___cxa_allocate_exception(4)|0);
  ;HEAP32[$9>>2]=0|0;
  __ZNSt3__217bad_function_callC2Ev($9);
  ___cxa_throw(($9|0),(1240|0),(197|0));
  // unreachable;
 } else {
  $10 = ((($5)) + 16|0);
  $11 = HEAP32[$10>>2]|0;
  $12 = HEAP32[$11>>2]|0;
  $13 = ((($12)) + 24|0);
  $14 = HEAP32[$13>>2]|0;
  $15 = $4;
  $2 = $15;
  $16 = $2;
  FUNCTION_TABLE_vii[$14 & 255]($11,$16);
  STACKTOP = sp;return;
 }
}
function __ZNSt3__28functionIFvRN6laszip2io6headerEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 16|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)==($2|0);
 $6 = ((($2)) + 16|0);
 $7 = HEAP32[$6>>2]|0;
 if ($5) {
  $8 = HEAP32[$7>>2]|0;
  $9 = ((($8)) + 16|0);
  $10 = HEAP32[$9>>2]|0;
  FUNCTION_TABLE_vi[$10 & 511]($7);
  STACKTOP = sp;return;
 }
 $11 = ($7|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($2)) + 16|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = HEAP32[$13>>2]|0;
 $15 = ((($14)) + 20|0);
 $16 = HEAP32[$15>>2]|0;
 FUNCTION_TABLE_vi[$16 & 511]($13);
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE12_parseLASZIPEv($0) {
 $0 = $0|0;
 var $$byval_copy = 0, $$expand_i1_val = 0, $$expand_i1_val3 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0;
 var $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0;
 var $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0;
 var $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 288|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(288|0);
 $$byval_copy = sp + 32|0;
 $26 = sp + 116|0;
 $30 = sp + 277|0;
 $34 = sp + 24|0;
 $38 = sp + 276|0;
 $40 = sp + 16|0;
 $42 = sp;
 $43 = sp + 222|0;
 $47 = sp + 60|0;
 $48 = sp + 48|0;
 $41 = $0;
 $49 = $41;
 $50 = HEAP32[$49>>2]|0;
 $51 = ((($49)) + 20|0);
 $52 = ((($51)) + 94|0);
 $53 = HEAP16[$52>>1]|0;
 $54 = $53&65535;
 $39 = $42;
 $55 = $40;
 $56 = $55;
 HEAP32[$56>>2] = $54;
 $57 = (($55) + 4)|0;
 $58 = $57;
 HEAP32[$58>>2] = 0;
 $59 = $39;
 ;HEAP32[$59>>2]=0|0;HEAP32[$59+4>>2]=0|0;
 $60 = ((($59)) + 8|0);
 $61 = $40;
 $62 = $61;
 $63 = HEAP32[$62>>2]|0;
 $64 = (($61) + 4)|0;
 $65 = $64;
 $66 = HEAP32[$65>>2]|0;
 $67 = $60;
 $68 = $67;
 HEAP32[$68>>2] = $63;
 $69 = (($67) + 4)|0;
 $70 = $69;
 HEAP32[$70>>2] = $66;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$42>>2]|0;HEAP32[$$byval_copy+4>>2]=HEAP32[$42+4>>2]|0;HEAP32[$$byval_copy+8>>2]=HEAP32[$42+8>>2]|0;HEAP32[$$byval_copy+12>>2]=HEAP32[$42+12>>2]|0;
 __ZN6laszip7streams13memory_stream5seekgENSt3__24fposI11__mbstate_tEE($50,$$byval_copy);
 $44 = 0;
 $45 = 0;
 while(1) {
  $71 = $44;
  $72 = ((($49)) + 20|0);
  $73 = ((($72)) + 100|0);
  $74 = HEAP32[$73>>2]|0;
  $75 = ($71>>>0)<($74>>>0);
  if (!($75)) {
   break;
  }
  $76 = HEAP32[$49>>2]|0;
  $77 = (__ZN6laszip7streams13memory_stream4goodEv($76)|0);
  if (!($77)) {
   break;
  }
  $78 = HEAP32[$49>>2]|0;
  $79 = (__ZN6laszip7streams13memory_stream3eofEv($78)|0);
  $80 = $79 ^ 1;
  if (!($80)) {
   break;
  }
  $81 = HEAP32[$49>>2]|0;
  __ZN6laszip7streams13memory_stream4readEPci($81,$43,54);
  $46 = 4841;
  $82 = ((($43)) + 2|0);
  $83 = ((($43)) + 2|0);
  $84 = ((($83)) + 14|0);
  $85 = $46;
  $35 = $82;
  $36 = $84;
  $37 = $85;
  $86 = $35;
  $87 = $36;
  $88 = $37;
  ;HEAP8[$34>>0]=HEAP8[$38>>0]|0;
  $31 = $86;
  $32 = $87;
  $33 = $88;
  while(1) {
   $89 = $31;
   $90 = $32;
   $91 = ($89|0)!=($90|0);
   if (!($91)) {
    label = 10;
    break;
   }
   $92 = $31;
   $93 = $33;
   $27 = $34;
   $28 = $92;
   $29 = $93;
   $94 = $28;
   $95 = HEAP8[$94>>0]|0;
   $96 = $95 << 24 >> 24;
   $97 = $29;
   $98 = HEAP8[$97>>0]|0;
   $99 = $98 << 24 >> 24;
   $100 = ($96|0)==($99|0);
   if (!($100)) {
    label = 8;
    break;
   }
   $101 = $31;
   $102 = ((($101)) + 1|0);
   $31 = $102;
   $103 = $33;
   $104 = ((($103)) + 1|0);
   $33 = $104;
  }
  if ((label|0) == 8) {
   label = 0;
   $$expand_i1_val = 0;
   HEAP8[$30>>0] = $$expand_i1_val;
  }
  else if ((label|0) == 10) {
   label = 0;
   $$expand_i1_val3 = 1;
   HEAP8[$30>>0] = $$expand_i1_val3;
  }
  $$pre_trunc = HEAP8[$30>>0]|0;
  $105 = $$pre_trunc&1;
  if ($105) {
   $106 = ((($43)) + 18|0);
   $107 = HEAPU8[$106>>0]|(HEAPU8[$106+1>>0]<<8);
   $108 = $107&65535;
   $109 = ($108|0)==(22204);
   if ($109) {
    label = 13;
    break;
   }
  }
  $149 = HEAP32[$49>>2]|0;
  $150 = ((($43)) + 20|0);
  $151 = HEAPU8[$150>>0]|(HEAPU8[$150+1>>0]<<8);
  $152 = $151&65535;
  __ZN6laszip7streams13memory_stream5seekgExNSt3__28ios_base7seekdirE($149,$152,0,1);
  $153 = $44;
  $154 = (($153) + 1)|0;
  $44 = $154;
 }
 if ((label|0) == 13) {
  $45 = 1;
  $110 = ((($43)) + 20|0);
  $111 = HEAPU8[$110>>0]|(HEAPU8[$110+1>>0]<<8);
  $112 = $111&65535;
  $113 = (__Znaj($112)|0);
  $25 = $47;
  HEAP32[$26>>2] = $113;
  $114 = $25;
  $23 = $114;
  $24 = $26;
  $115 = $23;
  $116 = $24;
  $22 = $116;
  $117 = $22;
  $20 = $115;
  $21 = $117;
  $118 = $20;
  $119 = $21;
  $19 = $119;
  $120 = $19;
  $121 = HEAP32[$120>>2]|0;
  HEAP32[$118>>2] = $121;
  $122 = HEAP32[$49>>2]|0;
  $18 = $47;
  $123 = $18;
  $17 = $123;
  $124 = $17;
  $16 = $124;
  $125 = $16;
  $126 = HEAP32[$125>>2]|0;
  $127 = ((($43)) + 20|0);
  $128 = HEAPU8[$127>>0]|(HEAPU8[$127+1>>0]<<8);
  $129 = $128&65535;
  __ZN6laszip7streams13memory_stream4readEPci($122,$126,$129);
  $15 = $47;
  $130 = $15;
  $14 = $130;
  $131 = $14;
  $13 = $131;
  $132 = $13;
  $133 = HEAP32[$132>>2]|0;
  __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE15_parseLASZIPVLREPKc($49,$133);
  $12 = $47;
  $134 = $12;
  $9 = $134;
  $10 = 0;
  $135 = $9;
  $8 = $135;
  $136 = $8;
  $7 = $136;
  $137 = $7;
  $138 = HEAP32[$137>>2]|0;
  $11 = $138;
  $139 = $10;
  $4 = $135;
  $140 = $4;
  $3 = $140;
  $141 = $3;
  HEAP32[$141>>2] = $139;
  $142 = $11;
  $143 = ($142|0)!=(0|0);
  if ($143) {
   $2 = $135;
   $144 = $2;
   $1 = $144;
   $145 = $1;
   $146 = $11;
   $5 = $145;
   $6 = $146;
   $147 = $6;
   $148 = ($147|0)==(0|0);
   if (!($148)) {
    __ZdlPv($147);
   }
  }
 }
 $155 = $45;
 $156 = $155&1;
 if ($156) {
  $158 = ((($49)) + 247|0);
  $159 = ((($49)) + 20|0);
  $160 = ((($159)) + 105|0);
  $161 = HEAPU8[$160>>0]|(HEAPU8[$160+1>>0]<<8);
  $162 = $161&65535;
  __ZN6laszip2io7laz_vlr9to_schemaERKS1_i($48,$158,$162);
  $163 = ((($49)) + 300|0);
  (__ZN6laszip7factory13record_schemaaSEOS1_($163,$48)|0);
  __ZN6laszip7factory13record_schemaD2Ev($48);
  STACKTOP = sp;return;
 } else {
  $157 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip13no_laszip_vlrC2Ev($157);
  ___cxa_throw(($157|0),(136|0),(32|0));
  // unreachable;
 }
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE16_parseChunkTableEv($0) {
 $0 = $0|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0;
 var $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0;
 var $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0;
 var $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0;
 var $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0;
 var $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0;
 var $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0;
 var $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0;
 var $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0;
 var $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0;
 var $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0;
 var $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0;
 var $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0;
 var $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0;
 var $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0;
 var $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 448|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(448|0);
 $$byval_copy1 = sp + 80|0;
 $$byval_copy = sp + 64|0;
 $38 = sp + 56|0;
 $41 = sp + 436|0;
 $54 = sp + 48|0;
 $56 = sp + 40|0;
 $58 = sp + 24|0;
 $59 = sp + 16|0;
 $60 = sp;
 $61 = sp + 216|0;
 $62 = sp + 200|0;
 $63 = sp + 184|0;
 $64 = sp + 104|0;
 $57 = $0;
 $67 = $57;
 $68 = HEAP32[$67>>2]|0;
 $69 = ((($67)) + 20|0);
 $70 = ((($69)) + 96|0);
 $71 = HEAP32[$70>>2]|0;
 $55 = $58;
 $72 = $56;
 $73 = $72;
 HEAP32[$73>>2] = $71;
 $74 = (($72) + 4)|0;
 $75 = $74;
 HEAP32[$75>>2] = 0;
 $76 = $55;
 ;HEAP32[$76>>2]=0|0;HEAP32[$76+4>>2]=0|0;
 $77 = ((($76)) + 8|0);
 $78 = $56;
 $79 = $78;
 $80 = HEAP32[$79>>2]|0;
 $81 = (($78) + 4)|0;
 $82 = $81;
 $83 = HEAP32[$82>>2]|0;
 $84 = $77;
 $85 = $84;
 HEAP32[$85>>2] = $80;
 $86 = (($84) + 4)|0;
 $87 = $86;
 HEAP32[$87>>2] = $83;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$58>>2]|0;HEAP32[$$byval_copy+4>>2]=HEAP32[$58+4>>2]|0;HEAP32[$$byval_copy+8>>2]=HEAP32[$58+8>>2]|0;HEAP32[$$byval_copy+12>>2]=HEAP32[$58+12>>2]|0;
 __ZN6laszip7streams13memory_stream5seekgENSt3__24fposI11__mbstate_tEE($68,$$byval_copy);
 $88 = $59;
 $89 = $88;
 HEAP32[$89>>2] = 0;
 $90 = (($88) + 4)|0;
 $91 = $90;
 HEAP32[$91>>2] = 0;
 $92 = HEAP32[$67>>2]|0;
 __ZN6laszip7streams13memory_stream4readEPci($92,$59,8);
 $93 = HEAP32[$67>>2]|0;
 $94 = (__ZN6laszip7streams13memory_stream4goodEv($93)|0);
 if (!($94)) {
  $95 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip22chunk_table_read_errorC2Ev($95);
  ___cxa_throw(($95|0),(168|0),(34|0));
  // unreachable;
 }
 $96 = $59;
 $97 = $96;
 $98 = HEAP32[$97>>2]|0;
 $99 = (($96) + 4)|0;
 $100 = $99;
 $101 = HEAP32[$100>>2]|0;
 $102 = ($98|0)==(-1);
 $103 = ($101|0)==(-1);
 $104 = $102 & $103;
 if ($104) {
  $105 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip13not_supportedC2EPKc($105,5052);
  ___cxa_throw(($105|0),(184|0),(36|0));
  // unreachable;
 }
 $106 = HEAP32[$67>>2]|0;
 $107 = $59;
 $108 = $107;
 $109 = HEAP32[$108>>2]|0;
 $110 = (($107) + 4)|0;
 $111 = $110;
 $112 = HEAP32[$111>>2]|0;
 $53 = $60;
 $113 = $54;
 $114 = $113;
 HEAP32[$114>>2] = $109;
 $115 = (($113) + 4)|0;
 $116 = $115;
 HEAP32[$116>>2] = $112;
 $117 = $53;
 ;HEAP32[$117>>2]=0|0;HEAP32[$117+4>>2]=0|0;
 $118 = ((($117)) + 8|0);
 $119 = $54;
 $120 = $119;
 $121 = HEAP32[$120>>2]|0;
 $122 = (($119) + 4)|0;
 $123 = $122;
 $124 = HEAP32[$123>>2]|0;
 $125 = $118;
 $126 = $125;
 HEAP32[$126>>2] = $121;
 $127 = (($125) + 4)|0;
 $128 = $127;
 HEAP32[$128>>2] = $124;
 ;HEAP32[$$byval_copy1>>2]=HEAP32[$60>>2]|0;HEAP32[$$byval_copy1+4>>2]=HEAP32[$60+4>>2]|0;HEAP32[$$byval_copy1+8>>2]=HEAP32[$60+8>>2]|0;HEAP32[$$byval_copy1+12>>2]=HEAP32[$60+12>>2]|0;
 __ZN6laszip7streams13memory_stream5seekgENSt3__24fposI11__mbstate_tEE($106,$$byval_copy1);
 $129 = HEAP32[$67>>2]|0;
 $130 = (__ZN6laszip7streams13memory_stream4goodEv($129)|0);
 if (!($130)) {
  $131 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip22chunk_table_read_errorC2Ev($131);
  ___cxa_throw(($131|0),(168|0),(34|0));
  // unreachable;
 }
 $132 = HEAP32[$67>>2]|0;
 __ZN6laszip7streams13memory_stream4readEPci($132,$61,8);
 $133 = HEAP32[$67>>2]|0;
 $134 = (__ZN6laszip7streams13memory_stream4goodEv($133)|0);
 if (!($134)) {
  $135 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip22chunk_table_read_errorC2Ev($135);
  ___cxa_throw(($135|0),(168|0),(34|0));
  // unreachable;
 }
 $136 = HEAP32[$61>>2]|0;
 $137 = ($136|0)!=(0);
 if ($137) {
  $138 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip26unknown_chunk_table_formatC2Ev($138);
  ___cxa_throw(($138|0),(200|0),(38|0));
  // unreachable;
 }
 $139 = ((($67)) + 288|0);
 $51 = $139;
 $140 = $51;
 $50 = $140;
 $141 = $50;
 $142 = ((($141)) + 4|0);
 $143 = HEAP32[$142>>2]|0;
 $144 = HEAP32[$141>>2]|0;
 $145 = $143;
 $146 = $144;
 $147 = (($145) - ($146))|0;
 $148 = (($147|0) / 8)&-1;
 $52 = $148;
 $49 = $140;
 $149 = $49;
 $150 = HEAP32[$149>>2]|0;
 $46 = $149;
 $47 = $150;
 $151 = $46;
 $152 = ((($151)) + 4|0);
 $153 = HEAP32[$152>>2]|0;
 $48 = $153;
 while(1) {
  $154 = $47;
  $155 = $48;
  $156 = ($154|0)!=($155|0);
  if (!($156)) {
   break;
  }
  $45 = $151;
  $157 = $45;
  $158 = ((($157)) + 8|0);
  $44 = $158;
  $159 = $44;
  $43 = $159;
  $160 = $43;
  $161 = $48;
  $162 = ((($161)) + -8|0);
  $48 = $162;
  $42 = $162;
  $163 = $42;
  $39 = $160;
  $40 = $163;
  $164 = $39;
  $165 = $40;
  ;HEAP8[$38>>0]=HEAP8[$41>>0]|0;
  $36 = $164;
  $37 = $165;
  $166 = $36;
  $167 = $37;
  $34 = $166;
  $35 = $167;
 }
 $168 = $47;
 $169 = ((($151)) + 4|0);
 HEAP32[$169>>2] = $168;
 $170 = $52;
 $31 = $140;
 $32 = $170;
 $171 = $31;
 $30 = $171;
 $172 = $30;
 $173 = HEAP32[$172>>2]|0;
 $29 = $173;
 $174 = $29;
 $13 = $171;
 $175 = $13;
 $176 = HEAP32[$175>>2]|0;
 $12 = $176;
 $177 = $12;
 $18 = $171;
 $178 = $18;
 $17 = $178;
 $179 = $17;
 $16 = $179;
 $180 = $16;
 $181 = ((($180)) + 8|0);
 $15 = $181;
 $182 = $15;
 $14 = $182;
 $183 = $14;
 $184 = HEAP32[$183>>2]|0;
 $185 = HEAP32[$179>>2]|0;
 $186 = $184;
 $187 = $185;
 $188 = (($186) - ($187))|0;
 $189 = (($188|0) / 8)&-1;
 $190 = (($177) + ($189<<3)|0);
 $20 = $171;
 $191 = $20;
 $192 = HEAP32[$191>>2]|0;
 $19 = $192;
 $193 = $19;
 $194 = $32;
 $195 = (($193) + ($194<<3)|0);
 $22 = $171;
 $196 = $22;
 $197 = HEAP32[$196>>2]|0;
 $21 = $197;
 $198 = $21;
 $23 = $171;
 $199 = $23;
 $200 = ((($199)) + 4|0);
 $201 = HEAP32[$200>>2]|0;
 $202 = HEAP32[$199>>2]|0;
 $203 = $201;
 $204 = $202;
 $205 = (($203) - ($204))|0;
 $206 = (($205|0) / 8)&-1;
 $207 = (($198) + ($206<<3)|0);
 $24 = $171;
 $25 = $174;
 $26 = $190;
 $27 = $195;
 $28 = $207;
 $33 = $140;
 $208 = ((($67)) + 247|0);
 $209 = ((($208)) + 12|0);
 $210 = HEAPU8[$209>>0]|(HEAPU8[$209+1>>0]<<8)|(HEAPU8[$209+2>>0]<<16)|(HEAPU8[$209+3>>0]<<24);
 $211 = ($210|0)==(-1);
 if ($211) {
  $212 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip13not_supportedC2EPKc($212,5170);
  ___cxa_throw(($212|0),(184|0),(36|0));
  // unreachable;
 }
 $213 = ((($67)) + 288|0);
 $214 = ((($61)) + 4|0);
 $215 = HEAP32[$214>>2]|0;
 $216 = (($215) + 1)|0;
 __ZNSt3__26vectorIyNS_9allocatorIyEEE6resizeEj($213,$216);
 $217 = ((($67)) + 20|0);
 $218 = ((($217)) + 96|0);
 $219 = HEAP32[$218>>2]|0;
 $220 = (($219) + 8)|0;
 $221 = ((($67)) + 288|0);
 $10 = $221;
 $11 = 0;
 $222 = $10;
 $223 = HEAP32[$222>>2]|0;
 $224 = $11;
 $225 = (($223) + ($224<<3)|0);
 $226 = $225;
 $227 = $226;
 HEAP32[$227>>2] = $220;
 $228 = (($226) + 4)|0;
 $229 = $228;
 HEAP32[$229>>2] = 0;
 $230 = ((($61)) + 4|0);
 $231 = HEAP32[$230>>2]|0;
 $232 = ($231>>>0)>(1);
 if (!($232)) {
  STACKTOP = sp;return;
 }
 $233 = HEAP32[$67>>2]|0;
 __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEEC2ERS3_($62,$233);
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEC2ERS6_($63,$62);
 __ZN6laszip13decompressors7integerC2Ejjjj($64,32,2,8,0);
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE13readInitBytesEv($63);
 __ZN6laszip13decompressors7integer4initEv($64);
 $65 = 1;
 while(1) {
  $234 = $65;
  $235 = ((($61)) + 4|0);
  $236 = HEAP32[$235>>2]|0;
  $237 = ($234>>>0)<=($236>>>0);
  if (!($237)) {
   break;
  }
  $238 = $65;
  $239 = ($238>>>0)>(1);
  if ($239) {
   $240 = ((($67)) + 288|0);
   $241 = $65;
   $242 = (($241) - 1)|0;
   $8 = $240;
   $9 = $242;
   $243 = $8;
   $244 = HEAP32[$243>>2]|0;
   $245 = $9;
   $246 = (($244) + ($245<<3)|0);
   $247 = $246;
   $248 = $247;
   $249 = HEAP32[$248>>2]|0;
   $250 = (($247) + 4)|0;
   $251 = $250;
   $252 = HEAP32[$251>>2]|0;
   $253 = $249;
  } else {
   $253 = 0;
  }
  $254 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($64,$63,$253,1)|0);
  $255 = ($254|0)<(0);
  $256 = $255 << 31 >> 31;
  $257 = ((($67)) + 288|0);
  $258 = $65;
  $1 = $257;
  $2 = $258;
  $259 = $1;
  $260 = HEAP32[$259>>2]|0;
  $261 = $2;
  $262 = (($260) + ($261<<3)|0);
  $263 = $262;
  $264 = $263;
  HEAP32[$264>>2] = $254;
  $265 = (($263) + 4)|0;
  $266 = $265;
  HEAP32[$266>>2] = $256;
  $267 = $65;
  $268 = (($267) + 1)|0;
  $65 = $268;
 }
 $66 = 1;
 while(1) {
  $269 = $66;
  $270 = ((($67)) + 288|0);
  $3 = $270;
  $271 = $3;
  $272 = ((($271)) + 4|0);
  $273 = HEAP32[$272>>2]|0;
  $274 = HEAP32[$271>>2]|0;
  $275 = $273;
  $276 = $274;
  $277 = (($275) - ($276))|0;
  $278 = (($277|0) / 8)&-1;
  $279 = ($269>>>0)<($278>>>0);
  if (!($279)) {
   break;
  }
  $280 = ((($67)) + 288|0);
  $281 = $66;
  $282 = (($281) - 1)|0;
  $4 = $280;
  $5 = $282;
  $283 = $4;
  $284 = HEAP32[$283>>2]|0;
  $285 = $5;
  $286 = (($284) + ($285<<3)|0);
  $287 = $286;
  $288 = $287;
  $289 = HEAP32[$288>>2]|0;
  $290 = (($287) + 4)|0;
  $291 = $290;
  $292 = HEAP32[$291>>2]|0;
  $293 = ((($67)) + 288|0);
  $294 = $66;
  $6 = $293;
  $7 = $294;
  $295 = $6;
  $296 = HEAP32[$295>>2]|0;
  $297 = $7;
  $298 = (($296) + ($297<<3)|0);
  $299 = $298;
  $300 = $299;
  $301 = HEAP32[$300>>2]|0;
  $302 = (($299) + 4)|0;
  $303 = $302;
  $304 = HEAP32[$303>>2]|0;
  $305 = (_i64Add(($301|0),($304|0),($289|0),($292|0))|0);
  $306 = tempRet0;
  $307 = $298;
  $308 = $307;
  HEAP32[$308>>2] = $305;
  $309 = (($307) + 4)|0;
  $310 = $309;
  HEAP32[$310>>2] = $306;
  $311 = $66;
  $312 = (($311) + 1)|0;
  $66 = $312;
 }
 __ZN6laszip13decompressors7integerD2Ev($64);
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEED2Ev($63);
 __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEED2Ev($62);
 STACKTOP = sp;return;
}
function __ZN6laszip7streams13memory_stream5clearEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 12|0);
 HEAP8[$3>>0] = 0;
 $4 = ((($2)) + 13|0);
 HEAP8[$4>>0] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE5resetEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 8|0);
 HEAP32[$3>>2] = 0;
 $4 = ((($2)) + 4|0);
 HEAP32[$4>>2] = 0;
 STACKTOP = sp;return;
}
function __ZNSt3__211char_traitsIcE6lengthEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = (_strlen($2)|0);
 STACKTOP = sp;return ($3|0);
}
function __ZNSt3__212basic_stringIcNS_11char_traitsIcEENS_9allocatorIcEEE6__initIPcEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeES9_S9_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0;
 var $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 224|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(224|0);
 $38 = sp + 8|0;
 $40 = sp + 218|0;
 $48 = sp;
 $51 = sp + 217|0;
 $58 = sp + 216|0;
 $52 = $0;
 $53 = $1;
 $54 = $2;
 $59 = $52;
 $60 = $53;
 $61 = $54;
 $49 = $60;
 $50 = $61;
 $62 = $49;
 $63 = $50;
 ;HEAP8[$48>>0]=HEAP8[$51>>0]|0;
 $46 = $62;
 $47 = $63;
 $64 = $47;
 $65 = $46;
 $66 = $64;
 $67 = $65;
 $68 = (($66) - ($67))|0;
 $55 = $68;
 $69 = $55;
 $44 = $59;
 $70 = $44;
 $43 = $70;
 $71 = $43;
 $42 = $71;
 $72 = $42;
 $41 = $72;
 $73 = $41;
 $39 = $73;
 $74 = $39;
 ;HEAP8[$38>>0]=HEAP8[$40>>0]|0;
 $37 = $74;
 $75 = $37;
 $36 = $75;
 $45 = -1;
 $76 = $45;
 $77 = (($76) - 16)|0;
 $78 = ($69>>>0)>($77>>>0);
 if ($78) {
  __ZNKSt3__221__basic_string_commonILb1EE20__throw_length_errorEv($59);
  // unreachable;
 }
 $79 = $55;
 $80 = ($79>>>0)<(11);
 $81 = $55;
 if ($80) {
  $34 = $59;
  $35 = $81;
  $82 = $34;
  $83 = $35;
  $84 = $83&255;
  $33 = $82;
  $85 = $33;
  $32 = $85;
  $86 = $32;
  $87 = ((($86)) + 11|0);
  HEAP8[$87>>0] = $84;
  $12 = $59;
  $88 = $12;
  $11 = $88;
  $89 = $11;
  $10 = $89;
  $90 = $10;
  $9 = $90;
  $91 = $9;
  $8 = $91;
  $92 = $8;
  $56 = $92;
 } else {
  $4 = $81;
  $93 = $4;
  $94 = ($93>>>0)<(11);
  if ($94) {
   $101 = 11;
  } else {
   $95 = $4;
   $96 = (($95) + 1)|0;
   $3 = $96;
   $97 = $3;
   $98 = (($97) + 15)|0;
   $99 = $98 & -16;
   $101 = $99;
  }
  $100 = (($101) - 1)|0;
  $57 = $100;
  $7 = $59;
  $102 = $7;
  $6 = $102;
  $103 = $6;
  $5 = $103;
  $104 = $5;
  $105 = $57;
  $106 = (($105) + 1)|0;
  $18 = $104;
  $19 = $106;
  $107 = $18;
  $108 = $19;
  $15 = $107;
  $16 = $108;
  $17 = 0;
  $109 = $15;
  $14 = $109;
  $110 = $16;
  $13 = $110;
  $111 = $13;
  $112 = (__Znwj($111)|0);
  $56 = $112;
  $113 = $56;
  $22 = $59;
  $23 = $113;
  $114 = $22;
  $115 = $23;
  $21 = $114;
  $116 = $21;
  $20 = $116;
  $117 = $20;
  HEAP32[$117>>2] = $115;
  $118 = $57;
  $119 = (($118) + 1)|0;
  $26 = $59;
  $27 = $119;
  $120 = $26;
  $121 = $27;
  $122 = -2147483648 | $121;
  $25 = $120;
  $123 = $25;
  $24 = $123;
  $124 = $24;
  $125 = ((($124)) + 8|0);
  HEAP32[$125>>2] = $122;
  $126 = $55;
  $30 = $59;
  $31 = $126;
  $127 = $30;
  $128 = $31;
  $29 = $127;
  $129 = $29;
  $28 = $129;
  $130 = $28;
  $131 = ((($130)) + 4|0);
  HEAP32[$131>>2] = $128;
 }
 while(1) {
  $132 = $53;
  $133 = $54;
  $134 = ($132|0)!=($133|0);
  $135 = $56;
  if (!($134)) {
   break;
  }
  $136 = $53;
  __ZNSt3__211char_traitsIcE6assignERcRKc($135,$136);
  $137 = $53;
  $138 = ((($137)) + 1|0);
  $53 = $138;
  $139 = $56;
  $140 = ((($139)) + 1|0);
  $56 = $140;
 }
 HEAP8[$58>>0] = 0;
 __ZNSt3__211char_traitsIcE6assignERcRKc($135,$58);
 STACKTOP = sp;return;
}
function __ZNSt3__211char_traitsIcE6assignERcRKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $3;
 $5 = HEAP8[$4>>0]|0;
 $6 = $2;
 HEAP8[$6>>0] = $5;
 STACKTOP = sp;return;
}
function __ZN6laszip13invalid_magicD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13invalid_magicD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2IZNS2_6reader10basic_fileINS1_7streams13memory_streamEE11_validatorsEvEUlS4_E_vEET_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0;
 var $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 240|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(240|0);
 $10 = sp + 96|0;
 $11 = sp + 88|0;
 $12 = sp + 80|0;
 $13 = sp + 72|0;
 $17 = sp + 235|0;
 $18 = sp + 234|0;
 $19 = sp + 233|0;
 $20 = sp + 232|0;
 $22 = sp + 172|0;
 $25 = sp + 231|0;
 $30 = sp + 64|0;
 $31 = sp + 56|0;
 $32 = sp + 48|0;
 $36 = sp + 40|0;
 $37 = sp + 32|0;
 $38 = sp + 24|0;
 $41 = sp + 230|0;
 $42 = sp + 124|0;
 $43 = sp + 229|0;
 $44 = sp + 228|0;
 $45 = sp + 227|0;
 $46 = sp + 226|0;
 $47 = sp + 16|0;
 $48 = sp + 8|0;
 $49 = sp;
 $53 = sp + 225|0;
 $54 = sp + 108|0;
 $55 = sp + 224|0;
 $57 = $0;
 $58 = $57;
 $59 = ((($58)) + 16|0);
 HEAP32[$59>>2] = 0;
 $56 = $1;
 $2 = $1;
 $60 = $2;
 $51 = $58;
 $52 = $60;
 $61 = $51;
 $50 = $61;
 $62 = $50;
 HEAP32[$62>>2] = (1704);
 HEAP32[$61>>2] = (1660);
 $63 = ((($61)) + 4|0);
 $64 = $52;
 $3 = $64;
 $65 = $3;
 $23 = $65;
 $66 = $23;
 $21 = $66;
 $67 = $21;
 $15 = $22;
 $16 = $67;
 $68 = $15;
 $69 = $16;
 $14 = $69;
 $70 = $14;
 ;HEAP8[$10>>0]=HEAP8[$20>>0]|0;
 ;HEAP8[$11>>0]=HEAP8[$19>>0]|0;
 ;HEAP8[$12>>0]=HEAP8[$18>>0]|0;
 ;HEAP8[$13>>0]=HEAP8[$17>>0]|0;
 $8 = $68;
 $9 = $70;
 $71 = $8;
 $72 = $9;
 $7 = $72;
 $73 = $7;
 $5 = $71;
 $6 = $73;
 $74 = $5;
 $75 = $6;
 $4 = $75;
 $76 = $4;
 HEAP32[$74>>2] = $76;
 $77 = HEAP32[$22>>2]|0;
 HEAP32[$54>>2] = $77;
 $24 = $25;
 ;HEAP8[$47>>0]=HEAP8[$55>>0]|0;
 ;HEAP8[$48>>0]=HEAP8[$54>>0]|0;HEAP8[$48+1>>0]=HEAP8[$54+1>>0]|0;HEAP8[$48+2>>0]=HEAP8[$54+2>>0]|0;HEAP8[$48+3>>0]=HEAP8[$54+3>>0]|0;
 ;HEAP8[$49>>0]=HEAP8[$53>>0]|0;
 $40 = $63;
 $78 = $40;
 $39 = $48;
 $79 = $39;
 ;HEAP32[$42>>2]=HEAP32[$79>>2]|0;
 ;HEAP8[$30>>0]=HEAP8[$43>>0]|0;
 ;HEAP8[$31>>0]=HEAP8[$42>>0]|0;HEAP8[$31+1>>0]=HEAP8[$42+1>>0]|0;HEAP8[$31+2>>0]=HEAP8[$42+2>>0]|0;HEAP8[$31+3>>0]=HEAP8[$42+3>>0]|0;
 ;HEAP8[$32>>0]=HEAP8[$41>>0]|0;
 $29 = $78;
 $28 = $31;
 $80 = $28;
 $27 = $80;
 $81 = $27;
 $82 = HEAP32[$81>>2]|0;
 $26 = $82;
 $33 = $47;
 ;HEAP8[$36>>0]=HEAP8[$46>>0]|0;
 ;HEAP8[$37>>0]=HEAP8[$45>>0]|0;
 ;HEAP8[$38>>0]=HEAP8[$44>>0]|0;
 $35 = $78;
 $83 = $35;
 $34 = $83;
 $84 = ((($58)) + 16|0);
 HEAP32[$84>>2] = $58;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorINS_8functionIFvRN6laszip2io6headerEEEENS_9allocatorIS7_EEE21__push_back_slow_pathIS7_EEvOT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 208|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(208|0);
 $10 = sp + 8|0;
 $15 = sp + 193|0;
 $24 = sp;
 $27 = sp + 192|0;
 $35 = sp + 72|0;
 $38 = sp + 60|0;
 $46 = sp + 12|0;
 $43 = $0;
 $44 = $1;
 $47 = $43;
 $42 = $47;
 $48 = $42;
 $49 = ((($48)) + 8|0);
 $41 = $49;
 $50 = $41;
 $40 = $50;
 $51 = $40;
 $45 = $51;
 $39 = $47;
 $52 = $39;
 $53 = ((($52)) + 4|0);
 $54 = HEAP32[$53>>2]|0;
 $55 = HEAP32[$52>>2]|0;
 $56 = $54;
 $57 = $55;
 $58 = (($56) - ($57))|0;
 $59 = (($58|0) / 24)&-1;
 $60 = (($59) + 1)|0;
 $34 = $47;
 HEAP32[$35>>2] = $60;
 $61 = $34;
 $62 = (__ZNKSt3__26vectorINS_8functionIFvRN6laszip2io6headerEEEENS_9allocatorIS7_EEE8max_sizeEv($61)|0);
 $36 = $62;
 $63 = HEAP32[$35>>2]|0;
 $64 = $36;
 $65 = ($63>>>0)>($64>>>0);
 if ($65) {
  __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv($61);
  // unreachable;
 }
 $32 = $61;
 $66 = $32;
 $31 = $66;
 $67 = $31;
 $30 = $67;
 $68 = $30;
 $69 = ((($68)) + 8|0);
 $29 = $69;
 $70 = $29;
 $28 = $70;
 $71 = $28;
 $72 = HEAP32[$71>>2]|0;
 $73 = HEAP32[$67>>2]|0;
 $74 = $72;
 $75 = $73;
 $76 = (($74) - ($75))|0;
 $77 = (($76|0) / 24)&-1;
 $37 = $77;
 $78 = $37;
 $79 = $36;
 $80 = (($79>>>0) / 2)&-1;
 $81 = ($78>>>0)>=($80>>>0);
 if ($81) {
  $82 = $36;
  $33 = $82;
 } else {
  $83 = $37;
  $84 = $83<<1;
  HEAP32[$38>>2] = $84;
  $25 = $38;
  $26 = $35;
  $85 = $25;
  $86 = $26;
  ;HEAP8[$24>>0]=HEAP8[$27>>0]|0;
  $22 = $85;
  $23 = $86;
  $87 = $22;
  $88 = $23;
  $19 = $24;
  $20 = $87;
  $21 = $88;
  $89 = $20;
  $90 = HEAP32[$89>>2]|0;
  $91 = $21;
  $92 = HEAP32[$91>>2]|0;
  $93 = ($90>>>0)<($92>>>0);
  $94 = $23;
  $95 = $22;
  $96 = $93 ? $94 : $95;
  $97 = HEAP32[$96>>2]|0;
  $33 = $97;
 }
 $98 = $33;
 $18 = $47;
 $99 = $18;
 $100 = ((($99)) + 4|0);
 $101 = HEAP32[$100>>2]|0;
 $102 = HEAP32[$99>>2]|0;
 $103 = $101;
 $104 = $102;
 $105 = (($103) - ($104))|0;
 $106 = (($105|0) / 24)&-1;
 $107 = $45;
 __ZNSt3__214__split_bufferINS_8functionIFvRN6laszip2io6headerEEEERNS_9allocatorIS7_EEEC2EjjSA_($46,$98,$106,$107);
 $108 = $45;
 $109 = ((($46)) + 8|0);
 $110 = HEAP32[$109>>2]|0;
 $17 = $110;
 $111 = $17;
 $112 = $44;
 $16 = $112;
 $113 = $16;
 $12 = $108;
 $13 = $111;
 $14 = $113;
 $114 = $12;
 $115 = $13;
 $116 = $14;
 $11 = $116;
 $117 = $11;
 ;HEAP8[$10>>0]=HEAP8[$15>>0]|0;
 $7 = $114;
 $8 = $115;
 $9 = $117;
 $118 = $7;
 $119 = $8;
 $120 = $9;
 $6 = $120;
 $121 = $6;
 $3 = $118;
 $4 = $119;
 $5 = $121;
 $122 = $4;
 $123 = $5;
 $2 = $123;
 $124 = $2;
 __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2EOS6_($122,$124);
 $125 = ((($46)) + 8|0);
 $126 = HEAP32[$125>>2]|0;
 $127 = ((($126)) + 24|0);
 HEAP32[$125>>2] = $127;
 __ZNSt3__26vectorINS_8functionIFvRN6laszip2io6headerEEEENS_9allocatorIS7_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS7_RS9_EE($47,$46);
 __ZNSt3__214__split_bufferINS_8functionIFvRN6laszip2io6headerEEEERNS_9allocatorIS7_EEED2Ev($46);
 STACKTOP = sp;return;
}
function __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2EOS6_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 $6 = ((($5)) + 16|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = ($7|0)==(0|0);
 if ($8) {
  $9 = ((($4)) + 16|0);
  HEAP32[$9>>2] = 0;
  STACKTOP = sp;return;
 }
 $10 = $3;
 $11 = ((($10)) + 16|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = $3;
 $14 = ($12|0)==($13|0);
 if ($14) {
  $15 = (__ZNSt3__28functionIFvRN6laszip2io6headerEEE9__as_baseEPv($4)|0);
  $16 = ((($4)) + 16|0);
  HEAP32[$16>>2] = $15;
  $17 = $3;
  $18 = ((($17)) + 16|0);
  $19 = HEAP32[$18>>2]|0;
  $20 = HEAP32[$19>>2]|0;
  $21 = ((($20)) + 12|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = ((($4)) + 16|0);
  $24 = HEAP32[$23>>2]|0;
  FUNCTION_TABLE_vii[$22 & 255]($19,$24);
  STACKTOP = sp;return;
 } else {
  $25 = $3;
  $26 = ((($25)) + 16|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = ((($4)) + 16|0);
  HEAP32[$28>>2] = $27;
  $29 = $3;
  $30 = ((($29)) + 16|0);
  HEAP32[$30>>2] = 0;
  STACKTOP = sp;return;
 }
}
function __ZNSt3__28functionIFvRN6laszip2io6headerEEE9__as_baseEPv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 STACKTOP = sp;return ($2|0);
}
function __ZNSt3__214__split_bufferINS_8functionIFvRN6laszip2io6headerEEEERNS_9allocatorIS7_EEEC2EjjSA_($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $35 = sp;
 $31 = $0;
 $32 = $1;
 $33 = $2;
 $34 = $3;
 $36 = $31;
 $37 = ((($36)) + 12|0);
 HEAP32[$35>>2] = 0;
 $38 = $34;
 $28 = $37;
 $29 = $35;
 $30 = $38;
 $39 = $28;
 $40 = $29;
 $27 = $40;
 $41 = $27;
 $21 = $39;
 $22 = $41;
 $42 = $21;
 $43 = $22;
 $20 = $43;
 HEAP32[$42>>2] = 0;
 $44 = ((($39)) + 4|0);
 $45 = $30;
 $23 = $45;
 $46 = $23;
 $25 = $44;
 $26 = $46;
 $47 = $25;
 $48 = $26;
 $24 = $48;
 $49 = $24;
 HEAP32[$47>>2] = $49;
 $50 = $32;
 $51 = ($50|0)!=(0);
 do {
  if ($51) {
   $6 = $36;
   $52 = $6;
   $53 = ((($52)) + 12|0);
   $5 = $53;
   $54 = $5;
   $55 = ((($54)) + 4|0);
   $4 = $55;
   $56 = $4;
   $57 = HEAP32[$56>>2]|0;
   $58 = $32;
   $15 = $57;
   $16 = $58;
   $59 = $15;
   $60 = $16;
   $12 = $59;
   $13 = $60;
   $14 = 0;
   $61 = $12;
   $62 = $13;
   $11 = $61;
   $63 = ($62>>>0)>(178956970);
   if ($63) {
    $9 = 4287;
    $64 = (___cxa_allocate_exception(8)|0);
    $65 = $9;
    $7 = $64;
    $8 = $65;
    $66 = $7;
    $67 = $8;
    __ZNSt11logic_errorC2EPKc($66,$67);
    HEAP32[$66>>2] = (3660);
    ___cxa_throw(($64|0),(1384|0),(220|0));
    // unreachable;
   } else {
    $68 = $13;
    $69 = ($68*24)|0;
    $10 = $69;
    $70 = $10;
    $71 = (__Znwj($70)|0);
    $72 = $71;
    break;
   }
  } else {
   $72 = 0;
  }
 } while(0);
 HEAP32[$36>>2] = $72;
 $73 = HEAP32[$36>>2]|0;
 $74 = $33;
 $75 = (($73) + (($74*24)|0)|0);
 $76 = ((($36)) + 8|0);
 HEAP32[$76>>2] = $75;
 $77 = ((($36)) + 4|0);
 HEAP32[$77>>2] = $75;
 $78 = HEAP32[$36>>2]|0;
 $79 = $32;
 $80 = (($78) + (($79*24)|0)|0);
 $19 = $36;
 $81 = $19;
 $82 = ((($81)) + 12|0);
 $18 = $82;
 $83 = $18;
 $17 = $83;
 $84 = $17;
 HEAP32[$84>>2] = $80;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorINS_8functionIFvRN6laszip2io6headerEEEENS_9allocatorIS7_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS7_RS9_EE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0;
 var $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0;
 var $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0;
 var $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0;
 var $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0;
 var $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 416|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(416|0);
 $15 = sp;
 $20 = sp + 404|0;
 $31 = sp + 292|0;
 $37 = sp + 268|0;
 $49 = sp + 220|0;
 $102 = $0;
 $103 = $1;
 $104 = $102;
 $101 = $104;
 $105 = $101;
 $100 = $105;
 $106 = $100;
 $107 = HEAP32[$106>>2]|0;
 $99 = $107;
 $108 = $99;
 $78 = $105;
 $109 = $78;
 $110 = HEAP32[$109>>2]|0;
 $77 = $110;
 $111 = $77;
 $83 = $105;
 $112 = $83;
 $82 = $112;
 $113 = $82;
 $81 = $113;
 $114 = $81;
 $115 = ((($114)) + 8|0);
 $80 = $115;
 $116 = $80;
 $79 = $116;
 $117 = $79;
 $118 = HEAP32[$117>>2]|0;
 $119 = HEAP32[$113>>2]|0;
 $120 = $118;
 $121 = $119;
 $122 = (($120) - ($121))|0;
 $123 = (($122|0) / 24)&-1;
 $124 = (($111) + (($123*24)|0)|0);
 $85 = $105;
 $125 = $85;
 $126 = HEAP32[$125>>2]|0;
 $84 = $126;
 $127 = $84;
 $86 = $105;
 $128 = $86;
 $129 = ((($128)) + 4|0);
 $130 = HEAP32[$129>>2]|0;
 $131 = HEAP32[$128>>2]|0;
 $132 = $130;
 $133 = $131;
 $134 = (($132) - ($133))|0;
 $135 = (($134|0) / 24)&-1;
 $136 = (($127) + (($135*24)|0)|0);
 $88 = $105;
 $137 = $88;
 $138 = HEAP32[$137>>2]|0;
 $87 = $138;
 $139 = $87;
 $93 = $105;
 $140 = $93;
 $92 = $140;
 $141 = $92;
 $91 = $141;
 $142 = $91;
 $143 = ((($142)) + 8|0);
 $90 = $143;
 $144 = $90;
 $89 = $144;
 $145 = $89;
 $146 = HEAP32[$145>>2]|0;
 $147 = HEAP32[$141>>2]|0;
 $148 = $146;
 $149 = $147;
 $150 = (($148) - ($149))|0;
 $151 = (($150|0) / 24)&-1;
 $152 = (($139) + (($151*24)|0)|0);
 $94 = $105;
 $95 = $108;
 $96 = $124;
 $97 = $136;
 $98 = $152;
 $4 = $104;
 $153 = $4;
 $154 = ((($153)) + 8|0);
 $3 = $154;
 $155 = $3;
 $2 = $155;
 $156 = $2;
 $157 = HEAP32[$104>>2]|0;
 $158 = ((($104)) + 4|0);
 $159 = HEAP32[$158>>2]|0;
 $160 = $103;
 $161 = ((($160)) + 4|0);
 $22 = $156;
 $23 = $157;
 $24 = $159;
 $25 = $161;
 while(1) {
  $162 = $24;
  $163 = $23;
  $164 = ($162|0)!=($163|0);
  if (!($164)) {
   break;
  }
  $165 = $22;
  $166 = $25;
  $167 = HEAP32[$166>>2]|0;
  $168 = ((($167)) + -24|0);
  $21 = $168;
  $169 = $21;
  $170 = $24;
  $171 = ((($170)) + -24|0);
  $24 = $171;
  $6 = $171;
  $172 = $6;
  $5 = $172;
  $173 = $5;
  $17 = $165;
  $18 = $169;
  $19 = $173;
  $174 = $17;
  $175 = $18;
  $176 = $19;
  $16 = $176;
  $177 = $16;
  ;HEAP8[$15>>0]=HEAP8[$20>>0]|0;
  $12 = $174;
  $13 = $175;
  $14 = $177;
  $178 = $12;
  $179 = $13;
  $180 = $14;
  $11 = $180;
  $181 = $11;
  $8 = $178;
  $9 = $179;
  $10 = $181;
  $182 = $9;
  $183 = $10;
  $7 = $183;
  $184 = $7;
  __ZNSt3__28functionIFvRN6laszip2io6headerEEEC2EOS6_($182,$184);
  $185 = $25;
  $186 = HEAP32[$185>>2]|0;
  $187 = ((($186)) + -24|0);
  HEAP32[$185>>2] = $187;
 }
 $188 = $103;
 $189 = ((($188)) + 4|0);
 $29 = $104;
 $30 = $189;
 $190 = $29;
 $28 = $190;
 $191 = $28;
 $192 = HEAP32[$191>>2]|0;
 HEAP32[$31>>2] = $192;
 $193 = $30;
 $26 = $193;
 $194 = $26;
 $195 = HEAP32[$194>>2]|0;
 $196 = $29;
 HEAP32[$196>>2] = $195;
 $27 = $31;
 $197 = $27;
 $198 = HEAP32[$197>>2]|0;
 $199 = $30;
 HEAP32[$199>>2] = $198;
 $200 = ((($104)) + 4|0);
 $201 = $103;
 $202 = ((($201)) + 8|0);
 $35 = $200;
 $36 = $202;
 $203 = $35;
 $34 = $203;
 $204 = $34;
 $205 = HEAP32[$204>>2]|0;
 HEAP32[$37>>2] = $205;
 $206 = $36;
 $32 = $206;
 $207 = $32;
 $208 = HEAP32[$207>>2]|0;
 $209 = $35;
 HEAP32[$209>>2] = $208;
 $33 = $37;
 $210 = $33;
 $211 = HEAP32[$210>>2]|0;
 $212 = $36;
 HEAP32[$212>>2] = $211;
 $40 = $104;
 $213 = $40;
 $214 = ((($213)) + 8|0);
 $39 = $214;
 $215 = $39;
 $38 = $215;
 $216 = $38;
 $217 = $103;
 $43 = $217;
 $218 = $43;
 $219 = ((($218)) + 12|0);
 $42 = $219;
 $220 = $42;
 $41 = $220;
 $221 = $41;
 $47 = $216;
 $48 = $221;
 $222 = $47;
 $46 = $222;
 $223 = $46;
 $224 = HEAP32[$223>>2]|0;
 HEAP32[$49>>2] = $224;
 $225 = $48;
 $44 = $225;
 $226 = $44;
 $227 = HEAP32[$226>>2]|0;
 $228 = $47;
 HEAP32[$228>>2] = $227;
 $45 = $49;
 $229 = $45;
 $230 = HEAP32[$229>>2]|0;
 $231 = $48;
 HEAP32[$231>>2] = $230;
 $232 = $103;
 $233 = ((($232)) + 4|0);
 $234 = HEAP32[$233>>2]|0;
 $235 = $103;
 HEAP32[$235>>2] = $234;
 $50 = $104;
 $236 = $50;
 $237 = ((($236)) + 4|0);
 $238 = HEAP32[$237>>2]|0;
 $239 = HEAP32[$236>>2]|0;
 $240 = $238;
 $241 = $239;
 $242 = (($240) - ($241))|0;
 $243 = (($242|0) / 24)&-1;
 $74 = $104;
 $75 = $243;
 $244 = $74;
 $73 = $244;
 $245 = $73;
 $246 = HEAP32[$245>>2]|0;
 $72 = $246;
 $247 = $72;
 $52 = $244;
 $248 = $52;
 $249 = HEAP32[$248>>2]|0;
 $51 = $249;
 $250 = $51;
 $57 = $244;
 $251 = $57;
 $56 = $251;
 $252 = $56;
 $55 = $252;
 $253 = $55;
 $254 = ((($253)) + 8|0);
 $54 = $254;
 $255 = $54;
 $53 = $255;
 $256 = $53;
 $257 = HEAP32[$256>>2]|0;
 $258 = HEAP32[$252>>2]|0;
 $259 = $257;
 $260 = $258;
 $261 = (($259) - ($260))|0;
 $262 = (($261|0) / 24)&-1;
 $263 = (($250) + (($262*24)|0)|0);
 $59 = $244;
 $264 = $59;
 $265 = HEAP32[$264>>2]|0;
 $58 = $265;
 $266 = $58;
 $64 = $244;
 $267 = $64;
 $63 = $267;
 $268 = $63;
 $62 = $268;
 $269 = $62;
 $270 = ((($269)) + 8|0);
 $61 = $270;
 $271 = $61;
 $60 = $271;
 $272 = $60;
 $273 = HEAP32[$272>>2]|0;
 $274 = HEAP32[$268>>2]|0;
 $275 = $273;
 $276 = $274;
 $277 = (($275) - ($276))|0;
 $278 = (($277|0) / 24)&-1;
 $279 = (($266) + (($278*24)|0)|0);
 $66 = $244;
 $280 = $66;
 $281 = HEAP32[$280>>2]|0;
 $65 = $281;
 $282 = $65;
 $283 = $75;
 $284 = (($282) + (($283*24)|0)|0);
 $67 = $244;
 $68 = $247;
 $69 = $263;
 $70 = $279;
 $71 = $284;
 $76 = $104;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferINS_8functionIFvRN6laszip2io6headerEEEERNS_9allocatorIS7_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $49 = ((($48)) + 4|0);
  $24 = $49;
  $50 = $24;
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($41)) + 8|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ((($53)) + -24|0);
  HEAP32[$52>>2] = $54;
  $23 = $54;
  $55 = $23;
  $20 = $51;
  $21 = $55;
  $56 = $20;
  $57 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $56;
  $18 = $57;
  $58 = $17;
  $59 = $18;
  $15 = $58;
  $16 = $59;
  $60 = $16;
  __ZNSt3__28functionIFvRN6laszip2io6headerEEED2Ev($60);
 }
 $61 = HEAP32[$35>>2]|0;
 $62 = ($61|0)!=(0|0);
 if (!($62)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $63 = $14;
 $64 = ((($63)) + 12|0);
 $13 = $64;
 $65 = $13;
 $66 = ((($65)) + 4|0);
 $12 = $66;
 $67 = $12;
 $68 = HEAP32[$67>>2]|0;
 $69 = HEAP32[$35>>2]|0;
 $11 = $35;
 $70 = $11;
 $10 = $70;
 $71 = $10;
 $72 = ((($71)) + 12|0);
 $9 = $72;
 $73 = $9;
 $8 = $73;
 $74 = $8;
 $75 = HEAP32[$74>>2]|0;
 $76 = HEAP32[$70>>2]|0;
 $77 = $75;
 $78 = $76;
 $79 = (($77) - ($78))|0;
 $80 = (($79|0) / 24)&-1;
 $5 = $68;
 $6 = $69;
 $7 = $80;
 $81 = $5;
 $82 = $6;
 $83 = $7;
 $2 = $81;
 $3 = $82;
 $4 = $83;
 $84 = $3;
 $1 = $84;
 $85 = $1;
 __ZdlPv($85);
 STACKTOP = sp;return;
}
function __ZNKSt3__26vectorINS_8functionIFvRN6laszip2io6headerEEEENS_9allocatorIS7_EEE8max_sizeEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $6 = sp + 8|0;
 $9 = sp + 77|0;
 $12 = sp;
 $14 = sp + 76|0;
 $19 = sp + 16|0;
 $20 = sp + 12|0;
 $18 = $0;
 $21 = $18;
 $17 = $21;
 $22 = $17;
 $23 = ((($22)) + 8|0);
 $16 = $23;
 $24 = $16;
 $15 = $24;
 $25 = $15;
 $13 = $25;
 $26 = $13;
 ;HEAP8[$12>>0]=HEAP8[$14>>0]|0;
 $11 = $26;
 $27 = $11;
 $10 = $27;
 HEAP32[$19>>2] = 178956970;
 HEAP32[$20>>2] = 2147483647;
 $7 = $19;
 $8 = $20;
 $28 = $7;
 $29 = $8;
 ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
 $4 = $28;
 $5 = $29;
 $30 = $5;
 $31 = $4;
 $1 = $6;
 $2 = $30;
 $3 = $31;
 $32 = $2;
 $33 = HEAP32[$32>>2]|0;
 $34 = $3;
 $35 = HEAP32[$34>>2]|0;
 $36 = ($33>>>0)<($35>>>0);
 $37 = $5;
 $38 = $4;
 $39 = $36 ? $37 : $38;
 $40 = HEAP32[$39>>2]|0;
 STACKTOP = sp;return ($40|0);
}
function __ZNSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $2;
 $1 = $3;
 STACKTOP = sp;return;
}
function __ZNSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNKSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EE7__cloneEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0;
 var $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0;
 var $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0;
 var $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0;
 var $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0;
 var $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0;
 var $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0;
 var $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 608|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(608|0);
 $7 = sp + 128|0;
 $8 = sp + 120|0;
 $9 = sp + 112|0;
 $10 = sp + 104|0;
 $13 = sp + 594|0;
 $14 = sp + 593|0;
 $15 = sp + 592|0;
 $16 = sp + 591|0;
 $18 = sp + 540|0;
 $27 = sp + 96|0;
 $28 = sp + 88|0;
 $29 = sp + 80|0;
 $30 = sp + 72|0;
 $34 = sp + 590|0;
 $35 = sp + 589|0;
 $36 = sp + 588|0;
 $37 = sp + 587|0;
 $39 = sp + 488|0;
 $45 = sp + 64|0;
 $46 = sp + 56|0;
 $47 = sp + 48|0;
 $53 = sp + 40|0;
 $54 = sp + 32|0;
 $55 = sp + 24|0;
 $58 = sp + 586|0;
 $59 = sp + 436|0;
 $60 = sp + 585|0;
 $61 = sp + 584|0;
 $62 = sp + 432|0;
 $63 = sp + 583|0;
 $64 = sp + 16|0;
 $65 = sp + 8|0;
 $66 = sp;
 $71 = sp + 582|0;
 $72 = sp + 412|0;
 $73 = sp + 408|0;
 $100 = sp + 300|0;
 $137 = sp + 581|0;
 $138 = sp + 144|0;
 $139 = sp + 136|0;
 $140 = sp + 580|0;
 $136 = $0;
 $141 = $136;
 $142 = ((($141)) + 4|0);
 $135 = $142;
 $143 = $135;
 $134 = $143;
 $144 = $134;
 $132 = $137;
 $133 = $144;
 $110 = $137;
 $111 = 1;
 $112 = 0;
 $145 = $110;
 $146 = $111;
 $109 = $145;
 $147 = ($146>>>0)>(536870911);
 if ($147) {
  $107 = 4287;
  $148 = (___cxa_allocate_exception(8)|0);
  $149 = $107;
  $105 = $148;
  $106 = $149;
  $150 = $105;
  $151 = $106;
  __ZNSt11logic_errorC2EPKc($150,$151);
  HEAP32[$150>>2] = (3660);
  ___cxa_throw(($148|0),(1384|0),(220|0));
  // unreachable;
 }
 $152 = $111;
 $153 = $152<<3;
 $108 = $153;
 $154 = $108;
 $155 = (__Znwj($154)|0);
 $102 = $139;
 $103 = $137;
 $104 = 1;
 $156 = $102;
 $157 = $103;
 HEAP32[$156>>2] = $157;
 $158 = ((($156)) + 4|0);
 $159 = $104;
 HEAP32[$158>>2] = $159;
 $99 = $138;
 HEAP32[$100>>2] = $155;
 $101 = $139;
 $160 = $99;
 $161 = $101;
 $98 = $161;
 $162 = $98;
 $95 = $160;
 $96 = $100;
 $97 = $162;
 $163 = $95;
 $164 = $96;
 $94 = $164;
 $165 = $94;
 $88 = $163;
 $89 = $165;
 $166 = $88;
 $167 = $89;
 $87 = $167;
 $168 = $87;
 $169 = HEAP32[$168>>2]|0;
 HEAP32[$166>>2] = $169;
 $170 = ((($163)) + 4|0);
 $171 = $97;
 $90 = $171;
 $172 = $90;
 $92 = $170;
 $93 = $172;
 $173 = $92;
 $174 = $93;
 $91 = $174;
 $175 = $91;
 ;HEAP32[$173>>2]=HEAP32[$175>>2]|0;HEAP32[$173+4>>2]=HEAP32[$175+4>>2]|0;
 $86 = $138;
 $176 = $86;
 $85 = $176;
 $177 = $85;
 $84 = $177;
 $178 = $84;
 $179 = HEAP32[$178>>2]|0;
 $180 = ((($141)) + 4|0);
 $83 = $180;
 $181 = $83;
 $82 = $181;
 $182 = $82;
 $80 = $140;
 $81 = $137;
 $68 = $179;
 $69 = $182;
 $70 = $140;
 $183 = $68;
 $67 = $183;
 $184 = $67;
 HEAP32[$184>>2] = (1704);
 HEAP32[$183>>2] = (1660);
 $185 = ((($183)) + 4|0);
 $186 = $69;
 $19 = $186;
 $187 = $19;
 $17 = $187;
 $188 = $17;
 $11 = $18;
 $12 = $188;
 $189 = $11;
 $190 = $12;
 ;HEAP8[$7>>0]=HEAP8[$16>>0]|0;
 ;HEAP8[$8>>0]=HEAP8[$15>>0]|0;
 ;HEAP8[$9>>0]=HEAP8[$14>>0]|0;
 ;HEAP8[$10>>0]=HEAP8[$13>>0]|0;
 $5 = $189;
 $6 = $190;
 $191 = $5;
 $192 = $6;
 $4 = $192;
 $193 = $4;
 $2 = $191;
 $3 = $193;
 $194 = $2;
 $195 = $3;
 $1 = $195;
 $196 = $1;
 HEAP32[$194>>2] = $196;
 $197 = HEAP32[$18>>2]|0;
 HEAP32[$72>>2] = $197;
 $198 = $70;
 $20 = $198;
 $199 = $20;
 $40 = $199;
 $200 = $40;
 $38 = $200;
 $201 = $38;
 $32 = $39;
 $33 = $201;
 $202 = $32;
 $203 = $33;
 $31 = $203;
 $204 = $31;
 ;HEAP8[$27>>0]=HEAP8[$37>>0]|0;
 ;HEAP8[$28>>0]=HEAP8[$36>>0]|0;
 ;HEAP8[$29>>0]=HEAP8[$35>>0]|0;
 ;HEAP8[$30>>0]=HEAP8[$34>>0]|0;
 $25 = $202;
 $26 = $204;
 $205 = $25;
 $206 = $26;
 $24 = $206;
 $207 = $24;
 $22 = $205;
 $23 = $207;
 $208 = $22;
 $209 = $23;
 $21 = $209;
 $210 = $21;
 HEAP32[$208>>2] = $210;
 $211 = HEAP32[$39>>2]|0;
 HEAP32[$73>>2] = $211;
 ;HEAP8[$64>>0]=HEAP8[$73>>0]|0;HEAP8[$64+1>>0]=HEAP8[$73+1>>0]|0;HEAP8[$64+2>>0]=HEAP8[$73+2>>0]|0;HEAP8[$64+3>>0]=HEAP8[$73+3>>0]|0;
 ;HEAP8[$65>>0]=HEAP8[$72>>0]|0;HEAP8[$65+1>>0]=HEAP8[$72+1>>0]|0;HEAP8[$65+2>>0]=HEAP8[$72+2>>0]|0;HEAP8[$65+3>>0]=HEAP8[$72+3>>0]|0;
 ;HEAP8[$66>>0]=HEAP8[$71>>0]|0;
 $57 = $185;
 $212 = $57;
 $56 = $65;
 $213 = $56;
 ;HEAP32[$59>>2]=HEAP32[$213>>2]|0;
 ;HEAP8[$45>>0]=HEAP8[$60>>0]|0;
 ;HEAP8[$46>>0]=HEAP8[$59>>0]|0;HEAP8[$46+1>>0]=HEAP8[$59+1>>0]|0;HEAP8[$46+2>>0]=HEAP8[$59+2>>0]|0;HEAP8[$46+3>>0]=HEAP8[$59+3>>0]|0;
 ;HEAP8[$47>>0]=HEAP8[$58>>0]|0;
 $44 = $212;
 $43 = $46;
 $214 = $43;
 $42 = $214;
 $215 = $42;
 $216 = HEAP32[$215>>2]|0;
 $41 = $216;
 $48 = $64;
 $217 = $48;
 ;HEAP32[$62>>2]=HEAP32[$217>>2]|0;
 ;HEAP8[$53>>0]=HEAP8[$63>>0]|0;
 ;HEAP8[$54>>0]=HEAP8[$62>>0]|0;HEAP8[$54+1>>0]=HEAP8[$62+1>>0]|0;HEAP8[$54+2>>0]=HEAP8[$62+2>>0]|0;HEAP8[$54+3>>0]=HEAP8[$62+3>>0]|0;
 ;HEAP8[$55>>0]=HEAP8[$61>>0]|0;
 $52 = $212;
 $51 = $54;
 $218 = $51;
 $50 = $218;
 $219 = $50;
 $220 = HEAP32[$219>>2]|0;
 $49 = $220;
 $78 = $138;
 $221 = $78;
 $77 = $221;
 $222 = $77;
 $76 = $222;
 $223 = $76;
 $224 = HEAP32[$223>>2]|0;
 $79 = $224;
 $75 = $221;
 $225 = $75;
 $74 = $225;
 $226 = $74;
 HEAP32[$226>>2] = 0;
 $227 = $79;
 $131 = $138;
 $228 = $131;
 $128 = $228;
 $129 = 0;
 $229 = $128;
 $127 = $229;
 $230 = $127;
 $126 = $230;
 $231 = $126;
 $232 = HEAP32[$231>>2]|0;
 $130 = $232;
 $233 = $129;
 $116 = $229;
 $234 = $116;
 $115 = $234;
 $235 = $115;
 HEAP32[$235>>2] = $233;
 $236 = $130;
 $237 = ($236|0)!=(0|0);
 if (!($237)) {
  STACKTOP = sp;return ($227|0);
 }
 $114 = $229;
 $238 = $114;
 $239 = ((($238)) + 4|0);
 $113 = $239;
 $240 = $113;
 $241 = $130;
 $124 = $240;
 $125 = $241;
 $242 = $124;
 $243 = HEAP32[$242>>2]|0;
 $244 = $125;
 $245 = ((($242)) + 4|0);
 $246 = HEAP32[$245>>2]|0;
 $121 = $243;
 $122 = $244;
 $123 = $246;
 $247 = $121;
 $248 = $122;
 $249 = $123;
 $118 = $247;
 $119 = $248;
 $120 = $249;
 $250 = $119;
 $117 = $250;
 $251 = $117;
 __ZdlPv($251);
 STACKTOP = sp;return ($227|0);
}
function __ZNKSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EE7__cloneEPNS0_6__baseISE_EE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0;
 var $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0;
 var $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 336|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(336|0);
 $10 = sp + 128|0;
 $11 = sp + 120|0;
 $12 = sp + 112|0;
 $13 = sp + 104|0;
 $16 = sp + 332|0;
 $17 = sp + 331|0;
 $18 = sp + 330|0;
 $19 = sp + 329|0;
 $21 = sp + 272|0;
 $29 = sp + 96|0;
 $30 = sp + 88|0;
 $31 = sp + 80|0;
 $32 = sp + 72|0;
 $35 = sp + 328|0;
 $36 = sp + 327|0;
 $37 = sp + 326|0;
 $38 = sp + 325|0;
 $40 = sp + 228|0;
 $46 = sp + 64|0;
 $47 = sp + 56|0;
 $48 = sp + 48|0;
 $54 = sp + 40|0;
 $55 = sp + 32|0;
 $56 = sp + 24|0;
 $59 = sp + 324|0;
 $60 = sp + 176|0;
 $61 = sp + 323|0;
 $62 = sp + 322|0;
 $63 = sp + 172|0;
 $64 = sp + 321|0;
 $65 = sp + 16|0;
 $66 = sp + 8|0;
 $67 = sp;
 $72 = sp + 320|0;
 $73 = sp + 152|0;
 $74 = sp + 148|0;
 $77 = $0;
 $78 = $1;
 $79 = $77;
 $80 = $78;
 $81 = ((($79)) + 4|0);
 $76 = $81;
 $82 = $76;
 $75 = $82;
 $83 = $75;
 $84 = ((($79)) + 4|0);
 $3 = $84;
 $85 = $3;
 $2 = $85;
 $86 = $2;
 $69 = $80;
 $70 = $83;
 $71 = $86;
 $87 = $69;
 $68 = $87;
 $88 = $68;
 HEAP32[$88>>2] = (1704);
 HEAP32[$87>>2] = (1660);
 $89 = ((($87)) + 4|0);
 $90 = $70;
 $22 = $90;
 $91 = $22;
 $20 = $91;
 $92 = $20;
 $14 = $21;
 $15 = $92;
 $93 = $14;
 $94 = $15;
 ;HEAP8[$10>>0]=HEAP8[$19>>0]|0;
 ;HEAP8[$11>>0]=HEAP8[$18>>0]|0;
 ;HEAP8[$12>>0]=HEAP8[$17>>0]|0;
 ;HEAP8[$13>>0]=HEAP8[$16>>0]|0;
 $8 = $93;
 $9 = $94;
 $95 = $8;
 $96 = $9;
 $7 = $96;
 $97 = $7;
 $5 = $95;
 $6 = $97;
 $98 = $5;
 $99 = $6;
 $4 = $99;
 $100 = $4;
 HEAP32[$98>>2] = $100;
 $101 = HEAP32[$21>>2]|0;
 HEAP32[$73>>2] = $101;
 $102 = $71;
 $41 = $102;
 $103 = $41;
 $39 = $103;
 $104 = $39;
 $33 = $40;
 $34 = $104;
 $105 = $33;
 $106 = $34;
 ;HEAP8[$29>>0]=HEAP8[$38>>0]|0;
 ;HEAP8[$30>>0]=HEAP8[$37>>0]|0;
 ;HEAP8[$31>>0]=HEAP8[$36>>0]|0;
 ;HEAP8[$32>>0]=HEAP8[$35>>0]|0;
 $27 = $105;
 $28 = $106;
 $107 = $27;
 $108 = $28;
 $26 = $108;
 $109 = $26;
 $24 = $107;
 $25 = $109;
 $110 = $24;
 $111 = $25;
 $23 = $111;
 $112 = $23;
 HEAP32[$110>>2] = $112;
 $113 = HEAP32[$40>>2]|0;
 HEAP32[$74>>2] = $113;
 ;HEAP8[$65>>0]=HEAP8[$74>>0]|0;HEAP8[$65+1>>0]=HEAP8[$74+1>>0]|0;HEAP8[$65+2>>0]=HEAP8[$74+2>>0]|0;HEAP8[$65+3>>0]=HEAP8[$74+3>>0]|0;
 ;HEAP8[$66>>0]=HEAP8[$73>>0]|0;HEAP8[$66+1>>0]=HEAP8[$73+1>>0]|0;HEAP8[$66+2>>0]=HEAP8[$73+2>>0]|0;HEAP8[$66+3>>0]=HEAP8[$73+3>>0]|0;
 ;HEAP8[$67>>0]=HEAP8[$72>>0]|0;
 $58 = $89;
 $114 = $58;
 $57 = $66;
 $115 = $57;
 ;HEAP32[$60>>2]=HEAP32[$115>>2]|0;
 ;HEAP8[$46>>0]=HEAP8[$61>>0]|0;
 ;HEAP8[$47>>0]=HEAP8[$60>>0]|0;HEAP8[$47+1>>0]=HEAP8[$60+1>>0]|0;HEAP8[$47+2>>0]=HEAP8[$60+2>>0]|0;HEAP8[$47+3>>0]=HEAP8[$60+3>>0]|0;
 ;HEAP8[$48>>0]=HEAP8[$59>>0]|0;
 $45 = $114;
 $44 = $47;
 $116 = $44;
 $43 = $116;
 $117 = $43;
 $118 = HEAP32[$117>>2]|0;
 $42 = $118;
 $49 = $65;
 $119 = $49;
 ;HEAP32[$63>>2]=HEAP32[$119>>2]|0;
 ;HEAP8[$54>>0]=HEAP8[$64>>0]|0;
 ;HEAP8[$55>>0]=HEAP8[$63>>0]|0;HEAP8[$55+1>>0]=HEAP8[$63+1>>0]|0;HEAP8[$55+2>>0]=HEAP8[$63+2>>0]|0;HEAP8[$55+3>>0]=HEAP8[$63+3>>0]|0;
 ;HEAP8[$56>>0]=HEAP8[$62>>0]|0;
 $53 = $114;
 $52 = $55;
 $120 = $52;
 $51 = $120;
 $121 = $51;
 $122 = HEAP32[$121>>2]|0;
 $50 = $122;
 STACKTOP = sp;return;
}
function __ZNSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EE7destroyEv($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EE18destroy_deallocateEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = sp + 36|0;
 $9 = $0;
 $11 = $9;
 $12 = ((($11)) + 4|0);
 $8 = $12;
 $13 = $8;
 $7 = $13;
 $14 = $7;
 $1 = $10;
 $2 = $14;
 $4 = $10;
 $5 = $11;
 $6 = 1;
 $15 = $5;
 $3 = $15;
 $16 = $3;
 __ZdlPv($16);
 STACKTOP = sp;return;
}
function __ZNSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EEclESA_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = $0;
 $6 = $1;
 $7 = $5;
 $8 = ((($7)) + 4|0);
 $4 = $8;
 $9 = $4;
 $3 = $9;
 $10 = $3;
 $11 = $6;
 $2 = $11;
 $12 = $2;
 __ZNSt3__228__invoke_void_return_wrapperIvE6__callIJRZN6laszip2io6reader10basic_fileINS3_7streams13memory_streamEE11_validatorsEvEUlRNS4_6headerEE_SB_EEEvDpOT_($10,$12);
 STACKTOP = sp;return;
}
function __ZNKSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EE6targetERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $7 = $0;
 $8 = $1;
 $9 = $7;
 $10 = $8;
 $4 = $10;
 $5 = 128;
 $11 = $4;
 $12 = ((($11)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = $5;
 $15 = ((($14)) + 4|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = ($13|0)==($16|0);
 if ($17) {
  $18 = ((($9)) + 4|0);
  $3 = $18;
  $19 = $3;
  $2 = $19;
  $20 = $2;
  $6 = $20;
  $21 = $6;
  STACKTOP = sp;return ($21|0);
 } else {
  $6 = 0;
  $21 = $6;
  STACKTOP = sp;return ($21|0);
 }
 return (0)|0;
}
function __ZNKSt3__210__function6__funcIZN6laszip2io6reader10basic_fileINS2_7streams13memory_streamEE11_validatorsEvEUlRNS3_6headerEE_NS_9allocatorISB_EEFvSA_EE11target_typeEv($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return (128|0);
}
function __ZNSt3__210__function6__baseIFvRN6laszip2io6headerEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__210__function6__baseIFvRN6laszip2io6headerEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 _llvm_trap();
 // unreachable;
}
function __ZNSt3__228__invoke_void_return_wrapperIvE6__callIJRZN6laszip2io6reader10basic_fileINS3_7streams13memory_streamEE11_validatorsEvEUlRNS4_6headerEE_SB_EEEvDpOT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $8 = $0;
 $9 = $1;
 $10 = $8;
 $7 = $10;
 $11 = $7;
 $12 = $9;
 $2 = $12;
 $13 = $2;
 $5 = $11;
 $6 = $13;
 $14 = $5;
 $4 = $14;
 $15 = $4;
 $16 = $6;
 $3 = $16;
 $17 = $3;
 __ZZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE11_validatorsEvENKUlRNS0_6headerEE_clES7_($15,$17);
 STACKTOP = sp;return;
}
function __ZZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE11_validatorsEvENKUlRNS0_6headerEE_clES7_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $6 = $3;
 $7 = ((($6)) + 104|0);
 $8 = HEAP8[$7>>0]|0;
 $9 = $8&255;
 $10 = $9 >> 7;
 $11 = $10 & 1;
 $4 = $11;
 $12 = $3;
 $13 = ((($12)) + 104|0);
 $14 = HEAP8[$13>>0]|0;
 $15 = $14&255;
 $16 = $15 >> 6;
 $17 = $16 & 1;
 $5 = $17;
 $18 = $4;
 $19 = ($18|0)==(1);
 $20 = $5;
 $21 = ($20|0)==(1);
 $or$cond = $19 & $21;
 if ($or$cond) {
  $22 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip21old_style_compressionC2Ev($22);
  ___cxa_throw(($22|0),(96|0),(26|0));
  // unreachable;
 }
 $23 = $4;
 $24 = $5;
 $25 = $23 ^ $24;
 $26 = ($25|0)==(0);
 if ($26) {
  $27 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip14not_compressedC2Ev($27);
  ___cxa_throw(($27|0),(112|0),(28|0));
  // unreachable;
 } else {
  $28 = $3;
  $29 = ((($28)) + 104|0);
  $30 = HEAP8[$29>>0]|0;
  $31 = $30&255;
  $32 = $31 & 63;
  $33 = $32&255;
  HEAP8[$29>>0] = $33;
  STACKTOP = sp;return;
 }
}
function __ZN6laszip21old_style_compressionC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,4640);
 HEAP32[$2>>2] = (1748);
 STACKTOP = sp;return;
}
function __ZN6laszip21old_style_compressionD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip14not_compressedC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,4708);
 HEAP32[$2>>2] = (1768);
 STACKTOP = sp;return;
}
function __ZN6laszip14not_compressedD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip21old_style_compressionD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip21old_style_compressionD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip14not_compressedD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip14not_compressedD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__217bad_function_callC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $2;
 $1 = $3;
 $4 = $1;
 HEAP32[$4>>2] = (3600);
 HEAP32[$3>>2] = (3448);
 STACKTOP = sp;return;
}
function __ZN6laszip7streams13memory_stream4goodEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $3 = $1;
 $4 = ((($3)) + 12|0);
 $5 = HEAP8[$4>>0]|0;
 $6 = $5&1;
 $7 = $6&1;
 $2 = $7;
 $8 = ((($3)) + 12|0);
 HEAP8[$8>>0] = 0;
 $9 = $2;
 $10 = $9&1;
 $11 = $10 ^ 1;
 STACKTOP = sp;return ($11|0);
}
function __ZN6laszip7streams13memory_stream3eofEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 13|0);
 $4 = HEAP8[$3>>0]|0;
 $5 = $4&1;
 STACKTOP = sp;return ($5|0);
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE15_parseLASZIPVLREPKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = ((($4)) + 247|0);
 $6 = $3;
 __ZN6laszip2io7laz_vlr4fillEPKc($5,$6);
 $7 = ((($4)) + 247|0);
 $8 = HEAPU8[$7>>0]|(HEAPU8[$7+1>>0]<<8);
 $9 = $8&65535;
 $10 = ($9|0)!=(2);
 if ($10) {
  $11 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip25laszip_format_unsupportedC2Ev($11);
  ___cxa_throw(($11|0),(152|0),(30|0));
  // unreachable;
 } else {
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7streams13memory_stream5seekgExNSt3__28ios_base7seekdirE($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = sp + 8|0;
 $7 = sp;
 $4 = $0;
 $8 = $5;
 $9 = $8;
 HEAP32[$9>>2] = $1;
 $10 = (($8) + 4)|0;
 $11 = $10;
 HEAP32[$11>>2] = $2;
 $6 = $3;
 $12 = $4;
 $13 = $7;
 $14 = $13;
 HEAP32[$14>>2] = 0;
 $15 = (($13) + 4)|0;
 $16 = $15;
 HEAP32[$16>>2] = 0;
 $17 = $6;
 switch ($17|0) {
 case 0:  {
  $18 = $5;
  $19 = $18;
  $20 = HEAP32[$19>>2]|0;
  $21 = (($18) + 4)|0;
  $22 = $21;
  $23 = HEAP32[$22>>2]|0;
  $24 = $7;
  $25 = $24;
  HEAP32[$25>>2] = $20;
  $26 = (($24) + 4)|0;
  $27 = $26;
  HEAP32[$27>>2] = $23;
  break;
 }
 case 2:  {
  $28 = ((($12)) + 4|0);
  $29 = HEAP32[$28>>2]|0;
  $30 = ($29|0)<(0);
  $31 = $30 << 31 >> 31;
  $32 = $5;
  $33 = $32;
  $34 = HEAP32[$33>>2]|0;
  $35 = (($32) + 4)|0;
  $36 = $35;
  $37 = HEAP32[$36>>2]|0;
  $38 = (_i64Add(($29|0),($31|0),($34|0),($37|0))|0);
  $39 = tempRet0;
  $40 = (_i64Subtract(($38|0),($39|0),1,0)|0);
  $41 = tempRet0;
  $42 = $7;
  $43 = $42;
  HEAP32[$43>>2] = $40;
  $44 = (($42) + 4)|0;
  $45 = $44;
  HEAP32[$45>>2] = $41;
  break;
 }
 case 1:  {
  $46 = ((($12)) + 8|0);
  $47 = HEAP32[$46>>2]|0;
  $48 = ($47|0)<(0);
  $49 = $48 << 31 >> 31;
  $50 = $5;
  $51 = $50;
  $52 = HEAP32[$51>>2]|0;
  $53 = (($50) + 4)|0;
  $54 = $53;
  $55 = HEAP32[$54>>2]|0;
  $56 = (_i64Add(($47|0),($49|0),($52|0),($55|0))|0);
  $57 = tempRet0;
  $58 = $7;
  $59 = $58;
  HEAP32[$59>>2] = $56;
  $60 = (($58) + 4)|0;
  $61 = $60;
  HEAP32[$61>>2] = $57;
  break;
 }
 default: {
 }
 }
 $62 = $7;
 $63 = $62;
 $64 = HEAP32[$63>>2]|0;
 $65 = (($62) + 4)|0;
 $66 = $65;
 $67 = HEAP32[$66>>2]|0;
 $68 = ((($12)) + 4|0);
 $69 = HEAP32[$68>>2]|0;
 $70 = ($69|0)<(0);
 $71 = $70 << 31 >> 31;
 $72 = ($67|0)>($71|0);
 $73 = ($64>>>0)>=($69>>>0);
 $74 = ($67|0)==($71|0);
 $75 = $74 & $73;
 $76 = $72 | $75;
 $77 = $7;
 $78 = $77;
 $79 = HEAP32[$78>>2]|0;
 $80 = (($77) + 4)|0;
 $81 = $80;
 $82 = HEAP32[$81>>2]|0;
 $83 = ($82|0)<(0);
 $or$cond = $76 | $83;
 $84 = ((($12)) + 12|0);
 if ($or$cond) {
  HEAP8[$84>>0] = 1;
  STACKTOP = sp;return;
 } else {
  HEAP8[$84>>0] = 0;
  $85 = $7;
  $86 = $85;
  $87 = HEAP32[$86>>2]|0;
  $88 = (($85) + 4)|0;
  $89 = $88;
  $90 = HEAP32[$89>>2]|0;
  $91 = ((($12)) + 8|0);
  HEAP32[$91>>2] = $87;
  STACKTOP = sp;return;
 }
}
function __ZN6laszip13no_laszip_vlrC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,4974);
 HEAP32[$2>>2] = (1808);
 STACKTOP = sp;return;
}
function __ZN6laszip13no_laszip_vlrD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip2io7laz_vlr9to_schemaERKS1_i($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $5 = sp + 40|0;
 $8 = sp + 12|0;
 $9 = sp;
 $3 = $1;
 $4 = $2;
 $$expand_i1_val = 0;
 HEAP8[$5>>0] = $$expand_i1_val;
 __ZN6laszip7factory13record_schemaC2Ev($0);
 $6 = 0;
 while(1) {
  $10 = $6;
  $11 = $3;
  $12 = ((($11)) + 32|0);
  $13 = HEAPU8[$12>>0]|(HEAPU8[$12+1>>0]<<8);
  $14 = $13&65535;
  $15 = ($10|0)<($14|0);
  if (!($15)) {
   break;
  }
  $16 = $3;
  $17 = ((($16)) + 34|0);
  $18 = HEAPU8[$17>>0]|(HEAPU8[$17+1>>0]<<8)|(HEAPU8[$17+2>>0]<<16)|(HEAPU8[$17+3>>0]<<24);
  $19 = $6;
  $20 = (($18) + (($19*6)|0)|0);
  $7 = $20;
  $21 = $7;
  $22 = HEAPU8[$21>>0]|(HEAPU8[$21+1>>0]<<8);
  $23 = $22&65535;
  $24 = $7;
  $25 = ((($24)) + 2|0);
  $26 = HEAPU8[$25>>0]|(HEAPU8[$25+1>>0]<<8);
  $27 = $26&65535;
  $28 = $7;
  $29 = ((($28)) + 4|0);
  $30 = HEAPU8[$29>>0]|(HEAPU8[$29+1>>0]<<8);
  $31 = $30&65535;
  __ZN6laszip7factory11record_itemC2Eiii($8,$23,$27,$31);
  __ZN6laszip7factory13record_schema4pushERKNS0_11record_itemE($0,$8);
  $32 = $7;
  $33 = ((($32)) + 2|0);
  $34 = HEAPU8[$33>>0]|(HEAPU8[$33+1>>0]<<8);
  $35 = $34&65535;
  $36 = $4;
  $37 = (($36) - ($35))|0;
  $4 = $37;
  $38 = $6;
  $39 = (($38) + 1)|0;
  $6 = $39;
 }
 $40 = $4;
 $41 = ($40|0)<(0);
 if ($41) {
  $42 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip25laszip_format_unsupportedC2Ev($42);
  ___cxa_throw(($42|0),(152|0),(30|0));
  // unreachable;
 }
 $43 = $4;
 $44 = ($43|0)!=(0);
 if ($44) {
  $45 = $4;
  __ZN6laszip7factory11record_itemC2Eiii($9,0,$45,2);
  __ZN6laszip7factory13record_schema4pushERKNS0_11record_itemE($0,$9);
 }
 $$expand_i1_val2 = 1;
 HEAP8[$5>>0] = $$expand_i1_val2;
 $$pre_trunc = HEAP8[$5>>0]|0;
 $46 = $$pre_trunc&1;
 if ($46) {
  STACKTOP = sp;return;
 }
 __ZN6laszip7factory13record_schemaD2Ev($0);
 STACKTOP = sp;return;
}
function __ZN6laszip7factory13record_schemaaSEOS1_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $$byval_copy = sp + 17|0;
 $4 = sp + 16|0;
 $5 = $0;
 $6 = $1;
 $7 = $5;
 $8 = $6;
 $2 = $7;
 $3 = $8;
 $9 = $2;
 $10 = $3;
 ;HEAP8[$$byval_copy>>0]=HEAP8[$4>>0]|0;
 __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE13__move_assignERS6_NS_17integral_constantIbLb1EEE($9,$10,$$byval_copy);
 STACKTOP = sp;return ($7|0);
}
function __ZN6laszip2io7laz_vlr4fillEPKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$arith = 0, $$overflow = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0;
 var $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0;
 var $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0;
 var $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0;
 var $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0;
 var $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0;
 var $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0;
 var $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0;
 var $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0;
 var $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0;
 var $440 = 0, $441 = 0, $442 = 0, $443 = 0, $444 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0;
 var $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0;
 var $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0;
 var $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 464|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(464|0);
 $112 = $0;
 $113 = $1;
 $116 = $112;
 $117 = $113;
 $118 = $113;
 $119 = ((($118)) + 2|0);
 $109 = $117;
 $110 = $119;
 $111 = $116;
 $120 = $109;
 $108 = $120;
 $121 = $108;
 $122 = $110;
 $102 = $122;
 $123 = $102;
 $124 = $111;
 $103 = $124;
 $125 = $103;
 $104 = $121;
 $105 = $123;
 $106 = $125;
 $126 = $105;
 $127 = $104;
 $128 = $126;
 $129 = $127;
 $130 = (($128) - ($129))|0;
 $107 = $130;
 $131 = $107;
 $132 = ($131>>>0)>(0);
 if ($132) {
  $133 = $106;
  $134 = $104;
  $135 = $107;
  _memmove(($133|0),($134|0),($135|0))|0;
 }
 $136 = HEAPU8[$116>>0]|(HEAPU8[$116+1>>0]<<8);
 HEAP8[$116>>0]=$136&255;HEAP8[$116+1>>0]=$136>>8;
 $137 = $113;
 $138 = ((($137)) + 2|0);
 $113 = $138;
 $139 = $113;
 $140 = $113;
 $141 = ((($140)) + 2|0);
 $142 = ((($116)) + 2|0);
 $9 = $139;
 $10 = $141;
 $11 = $142;
 $143 = $9;
 $8 = $143;
 $144 = $8;
 $145 = $10;
 $2 = $145;
 $146 = $2;
 $147 = $11;
 $3 = $147;
 $148 = $3;
 $4 = $144;
 $5 = $146;
 $6 = $148;
 $149 = $5;
 $150 = $4;
 $151 = $149;
 $152 = $150;
 $153 = (($151) - ($152))|0;
 $7 = $153;
 $154 = $7;
 $155 = ($154>>>0)>(0);
 if ($155) {
  $156 = $6;
  $157 = $4;
  $158 = $7;
  _memmove(($156|0),($157|0),($158|0))|0;
 }
 $159 = ((($116)) + 2|0);
 $160 = HEAPU8[$159>>0]|(HEAPU8[$159+1>>0]<<8);
 $161 = ((($116)) + 2|0);
 HEAP8[$161>>0]=$160&255;HEAP8[$161+1>>0]=$160>>8;
 $162 = $113;
 $163 = ((($162)) + 2|0);
 $113 = $163;
 $164 = $113;
 $165 = ((($164)) + 1|0);
 $113 = $165;
 $166 = HEAP8[$164>>0]|0;
 $167 = ((($116)) + 4|0);
 HEAP8[$167>>0] = $166;
 $168 = $113;
 $169 = ((($168)) + 1|0);
 $113 = $169;
 $170 = HEAP8[$168>>0]|0;
 $171 = ((($116)) + 4|0);
 $172 = ((($171)) + 1|0);
 HEAP8[$172>>0] = $170;
 $173 = $113;
 $174 = $113;
 $175 = ((($174)) + 2|0);
 $176 = ((($116)) + 4|0);
 $177 = ((($176)) + 2|0);
 $19 = $173;
 $20 = $175;
 $21 = $177;
 $178 = $19;
 $18 = $178;
 $179 = $18;
 $180 = $20;
 $12 = $180;
 $181 = $12;
 $182 = $21;
 $13 = $182;
 $183 = $13;
 $14 = $179;
 $15 = $181;
 $16 = $183;
 $184 = $15;
 $185 = $14;
 $186 = $184;
 $187 = $185;
 $188 = (($186) - ($187))|0;
 $17 = $188;
 $189 = $17;
 $190 = ($189>>>0)>(0);
 if ($190) {
  $191 = $16;
  $192 = $14;
  $193 = $17;
  _memmove(($191|0),($192|0),($193|0))|0;
 }
 $194 = ((($116)) + 4|0);
 $195 = ((($194)) + 2|0);
 $196 = HEAPU8[$195>>0]|(HEAPU8[$195+1>>0]<<8);
 $197 = ((($116)) + 4|0);
 $198 = ((($197)) + 2|0);
 HEAP8[$198>>0]=$196&255;HEAP8[$198+1>>0]=$196>>8;
 $199 = $113;
 $200 = ((($199)) + 2|0);
 $113 = $200;
 $201 = $113;
 $202 = $113;
 $203 = ((($202)) + 4|0);
 $204 = ((($116)) + 8|0);
 $29 = $201;
 $30 = $203;
 $31 = $204;
 $205 = $29;
 $28 = $205;
 $206 = $28;
 $207 = $30;
 $22 = $207;
 $208 = $22;
 $209 = $31;
 $23 = $209;
 $210 = $23;
 $24 = $206;
 $25 = $208;
 $26 = $210;
 $211 = $25;
 $212 = $24;
 $213 = $211;
 $214 = $212;
 $215 = (($213) - ($214))|0;
 $27 = $215;
 $216 = $27;
 $217 = ($216>>>0)>(0);
 if ($217) {
  $218 = $26;
  $219 = $24;
  $220 = $27;
  _memmove(($218|0),($219|0),($220|0))|0;
 }
 $221 = ((($116)) + 8|0);
 $222 = HEAPU8[$221>>0]|(HEAPU8[$221+1>>0]<<8)|(HEAPU8[$221+2>>0]<<16)|(HEAPU8[$221+3>>0]<<24);
 $223 = ((($116)) + 8|0);
 HEAP8[$223>>0]=$222&255;HEAP8[$223+1>>0]=($222>>8)&255;HEAP8[$223+2>>0]=($222>>16)&255;HEAP8[$223+3>>0]=$222>>24;
 $224 = $113;
 $225 = ((($224)) + 4|0);
 $113 = $225;
 $226 = $113;
 $227 = $113;
 $228 = ((($227)) + 4|0);
 $229 = ((($116)) + 12|0);
 $39 = $226;
 $40 = $228;
 $41 = $229;
 $230 = $39;
 $38 = $230;
 $231 = $38;
 $232 = $40;
 $32 = $232;
 $233 = $32;
 $234 = $41;
 $33 = $234;
 $235 = $33;
 $34 = $231;
 $35 = $233;
 $36 = $235;
 $236 = $35;
 $237 = $34;
 $238 = $236;
 $239 = $237;
 $240 = (($238) - ($239))|0;
 $37 = $240;
 $241 = $37;
 $242 = ($241>>>0)>(0);
 if ($242) {
  $243 = $36;
  $244 = $34;
  $245 = $37;
  _memmove(($243|0),($244|0),($245|0))|0;
 }
 $246 = ((($116)) + 12|0);
 $247 = HEAPU8[$246>>0]|(HEAPU8[$246+1>>0]<<8)|(HEAPU8[$246+2>>0]<<16)|(HEAPU8[$246+3>>0]<<24);
 $248 = ((($116)) + 12|0);
 HEAP8[$248>>0]=$247&255;HEAP8[$248+1>>0]=($247>>8)&255;HEAP8[$248+2>>0]=($247>>16)&255;HEAP8[$248+3>>0]=$247>>24;
 $249 = $113;
 $250 = ((($249)) + 4|0);
 $113 = $250;
 $251 = $113;
 $252 = $113;
 $253 = ((($252)) + 8|0);
 $254 = ((($116)) + 16|0);
 $49 = $251;
 $50 = $253;
 $51 = $254;
 $255 = $49;
 $48 = $255;
 $256 = $48;
 $257 = $50;
 $42 = $257;
 $258 = $42;
 $259 = $51;
 $43 = $259;
 $260 = $43;
 $44 = $256;
 $45 = $258;
 $46 = $260;
 $261 = $45;
 $262 = $44;
 $263 = $261;
 $264 = $262;
 $265 = (($263) - ($264))|0;
 $47 = $265;
 $266 = $47;
 $267 = ($266>>>0)>(0);
 if ($267) {
  $268 = $46;
  $269 = $44;
  $270 = $47;
  _memmove(($268|0),($269|0),($270|0))|0;
 }
 $271 = ((($116)) + 16|0);
 $272 = $271;
 $273 = $272;
 $274 = HEAPU8[$273>>0]|(HEAPU8[$273+1>>0]<<8)|(HEAPU8[$273+2>>0]<<16)|(HEAPU8[$273+3>>0]<<24);
 $275 = (($272) + 4)|0;
 $276 = $275;
 $277 = HEAPU8[$276>>0]|(HEAPU8[$276+1>>0]<<8)|(HEAPU8[$276+2>>0]<<16)|(HEAPU8[$276+3>>0]<<24);
 $278 = ((($116)) + 16|0);
 $279 = $278;
 $280 = $279;
 HEAP8[$280>>0]=$274&255;HEAP8[$280+1>>0]=($274>>8)&255;HEAP8[$280+2>>0]=($274>>16)&255;HEAP8[$280+3>>0]=$274>>24;
 $281 = (($279) + 4)|0;
 $282 = $281;
 HEAP8[$282>>0]=$277&255;HEAP8[$282+1>>0]=($277>>8)&255;HEAP8[$282+2>>0]=($277>>16)&255;HEAP8[$282+3>>0]=$277>>24;
 $283 = $113;
 $284 = ((($283)) + 8|0);
 $113 = $284;
 $285 = $113;
 $286 = $113;
 $287 = ((($286)) + 8|0);
 $288 = ((($116)) + 24|0);
 $59 = $285;
 $60 = $287;
 $61 = $288;
 $289 = $59;
 $58 = $289;
 $290 = $58;
 $291 = $60;
 $52 = $291;
 $292 = $52;
 $293 = $61;
 $53 = $293;
 $294 = $53;
 $54 = $290;
 $55 = $292;
 $56 = $294;
 $295 = $55;
 $296 = $54;
 $297 = $295;
 $298 = $296;
 $299 = (($297) - ($298))|0;
 $57 = $299;
 $300 = $57;
 $301 = ($300>>>0)>(0);
 if ($301) {
  $302 = $56;
  $303 = $54;
  $304 = $57;
  _memmove(($302|0),($303|0),($304|0))|0;
 }
 $305 = ((($116)) + 24|0);
 $306 = $305;
 $307 = $306;
 $308 = HEAPU8[$307>>0]|(HEAPU8[$307+1>>0]<<8)|(HEAPU8[$307+2>>0]<<16)|(HEAPU8[$307+3>>0]<<24);
 $309 = (($306) + 4)|0;
 $310 = $309;
 $311 = HEAPU8[$310>>0]|(HEAPU8[$310+1>>0]<<8)|(HEAPU8[$310+2>>0]<<16)|(HEAPU8[$310+3>>0]<<24);
 $312 = ((($116)) + 24|0);
 $313 = $312;
 $314 = $313;
 HEAP8[$314>>0]=$308&255;HEAP8[$314+1>>0]=($308>>8)&255;HEAP8[$314+2>>0]=($308>>16)&255;HEAP8[$314+3>>0]=$308>>24;
 $315 = (($313) + 4)|0;
 $316 = $315;
 HEAP8[$316>>0]=$311&255;HEAP8[$316+1>>0]=($311>>8)&255;HEAP8[$316+2>>0]=($311>>16)&255;HEAP8[$316+3>>0]=$311>>24;
 $317 = $113;
 $318 = ((($317)) + 8|0);
 $113 = $318;
 $319 = $113;
 $320 = $113;
 $321 = ((($320)) + 2|0);
 $322 = ((($116)) + 32|0);
 $69 = $319;
 $70 = $321;
 $71 = $322;
 $323 = $69;
 $68 = $323;
 $324 = $68;
 $325 = $70;
 $62 = $325;
 $326 = $62;
 $327 = $71;
 $63 = $327;
 $328 = $63;
 $64 = $324;
 $65 = $326;
 $66 = $328;
 $329 = $65;
 $330 = $64;
 $331 = $329;
 $332 = $330;
 $333 = (($331) - ($332))|0;
 $67 = $333;
 $334 = $67;
 $335 = ($334>>>0)>(0);
 if ($335) {
  $336 = $66;
  $337 = $64;
  $338 = $67;
  _memmove(($336|0),($337|0),($338|0))|0;
 }
 $339 = ((($116)) + 32|0);
 $340 = HEAPU8[$339>>0]|(HEAPU8[$339+1>>0]<<8);
 $341 = ((($116)) + 32|0);
 HEAP8[$341>>0]=$340&255;HEAP8[$341+1>>0]=$340>>8;
 $342 = $113;
 $343 = ((($342)) + 2|0);
 $113 = $343;
 $344 = ((($116)) + 34|0);
 $345 = HEAPU8[$344>>0]|(HEAPU8[$344+1>>0]<<8)|(HEAPU8[$344+2>>0]<<16)|(HEAPU8[$344+3>>0]<<24);
 $346 = ($345|0)==(0|0);
 if (!($346)) {
  __ZdaPv($345);
 }
 $347 = ((($116)) + 32|0);
 $348 = HEAPU8[$347>>0]|(HEAPU8[$347+1>>0]<<8);
 $349 = $348&65535;
 $$arith = ($349*6)|0;
 $$overflow = ($349>>>0)>(715827882);
 $350 = $$overflow ? -1 : $$arith;
 $351 = (__Znaj($350)|0);
 $352 = ((($116)) + 34|0);
 HEAP8[$352>>0]=$351&255;HEAP8[$352+1>>0]=($351>>8)&255;HEAP8[$352+2>>0]=($351>>16)&255;HEAP8[$352+3>>0]=$351>>24;
 $114 = 0;
 while(1) {
  $353 = $114;
  $354 = ((($116)) + 32|0);
  $355 = HEAPU8[$354>>0]|(HEAPU8[$354+1>>0]<<8);
  $356 = $355&65535;
  $357 = ($353|0)<($356|0);
  if (!($357)) {
   break;
  }
  $358 = ((($116)) + 34|0);
  $359 = HEAPU8[$358>>0]|(HEAPU8[$358+1>>0]<<8)|(HEAPU8[$358+2>>0]<<16)|(HEAPU8[$358+3>>0]<<24);
  $360 = $114;
  $361 = (($359) + (($360*6)|0)|0);
  $115 = $361;
  $362 = $113;
  $363 = $113;
  $364 = ((($363)) + 2|0);
  $365 = $115;
  $79 = $362;
  $80 = $364;
  $81 = $365;
  $366 = $79;
  $78 = $366;
  $367 = $78;
  $368 = $80;
  $72 = $368;
  $369 = $72;
  $370 = $81;
  $73 = $370;
  $371 = $73;
  $74 = $367;
  $75 = $369;
  $76 = $371;
  $372 = $75;
  $373 = $74;
  $374 = $372;
  $375 = $373;
  $376 = (($374) - ($375))|0;
  $77 = $376;
  $377 = $77;
  $378 = ($377>>>0)>(0);
  if ($378) {
   $379 = $76;
   $380 = $74;
   $381 = $77;
   _memmove(($379|0),($380|0),($381|0))|0;
  }
  $382 = $115;
  $383 = HEAPU8[$382>>0]|(HEAPU8[$382+1>>0]<<8);
  $384 = $115;
  HEAP8[$384>>0]=$383&255;HEAP8[$384+1>>0]=$383>>8;
  $385 = $113;
  $386 = ((($385)) + 2|0);
  $113 = $386;
  $387 = $113;
  $388 = $113;
  $389 = ((($388)) + 2|0);
  $390 = $115;
  $391 = ((($390)) + 2|0);
  $89 = $387;
  $90 = $389;
  $91 = $391;
  $392 = $89;
  $88 = $392;
  $393 = $88;
  $394 = $90;
  $82 = $394;
  $395 = $82;
  $396 = $91;
  $83 = $396;
  $397 = $83;
  $84 = $393;
  $85 = $395;
  $86 = $397;
  $398 = $85;
  $399 = $84;
  $400 = $398;
  $401 = $399;
  $402 = (($400) - ($401))|0;
  $87 = $402;
  $403 = $87;
  $404 = ($403>>>0)>(0);
  if ($404) {
   $405 = $86;
   $406 = $84;
   $407 = $87;
   _memmove(($405|0),($406|0),($407|0))|0;
  }
  $408 = $115;
  $409 = ((($408)) + 2|0);
  $410 = HEAPU8[$409>>0]|(HEAPU8[$409+1>>0]<<8);
  $411 = $115;
  $412 = ((($411)) + 2|0);
  HEAP8[$412>>0]=$410&255;HEAP8[$412+1>>0]=$410>>8;
  $413 = $113;
  $414 = ((($413)) + 2|0);
  $113 = $414;
  $415 = $113;
  $416 = $113;
  $417 = ((($416)) + 2|0);
  $418 = $115;
  $419 = ((($418)) + 4|0);
  $99 = $415;
  $100 = $417;
  $101 = $419;
  $420 = $99;
  $98 = $420;
  $421 = $98;
  $422 = $100;
  $92 = $422;
  $423 = $92;
  $424 = $101;
  $93 = $424;
  $425 = $93;
  $94 = $421;
  $95 = $423;
  $96 = $425;
  $426 = $95;
  $427 = $94;
  $428 = $426;
  $429 = $427;
  $430 = (($428) - ($429))|0;
  $97 = $430;
  $431 = $97;
  $432 = ($431>>>0)>(0);
  if ($432) {
   $433 = $96;
   $434 = $94;
   $435 = $97;
   _memmove(($433|0),($434|0),($435|0))|0;
  }
  $436 = $115;
  $437 = ((($436)) + 4|0);
  $438 = HEAPU8[$437>>0]|(HEAPU8[$437+1>>0]<<8);
  $439 = $115;
  $440 = ((($439)) + 4|0);
  HEAP8[$440>>0]=$438&255;HEAP8[$440+1>>0]=$438>>8;
  $441 = $113;
  $442 = ((($441)) + 2|0);
  $113 = $442;
  $443 = $114;
  $444 = (($443) + 1)|0;
  $114 = $444;
 }
 STACKTOP = sp;return;
}
function __ZN6laszip25laszip_format_unsupportedC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,4918);
 HEAP32[$2>>2] = (1788);
 STACKTOP = sp;return;
}
function __ZN6laszip25laszip_format_unsupportedD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip25laszip_format_unsupportedD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip25laszip_format_unsupportedD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip13no_laszip_vlrD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13no_laszip_vlrD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7factory13record_schema4pushERKNS0_11record_itemE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $65 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $14 = sp;
 $19 = sp + 113|0;
 $29 = sp + 112|0;
 $30 = $0;
 $31 = $1;
 $32 = $30;
 $33 = $31;
 $27 = $32;
 $28 = $33;
 $34 = $27;
 $35 = ((($34)) + 4|0);
 $36 = HEAP32[$35>>2]|0;
 $26 = $34;
 $37 = $26;
 $38 = ((($37)) + 8|0);
 $25 = $38;
 $39 = $25;
 $24 = $39;
 $40 = $24;
 $41 = HEAP32[$40>>2]|0;
 $42 = ($36|0)!=($41|0);
 if ($42) {
  $21 = $29;
  $22 = $34;
  $23 = 1;
  $4 = $34;
  $43 = $4;
  $44 = ((($43)) + 8|0);
  $3 = $44;
  $45 = $3;
  $2 = $45;
  $46 = $2;
  $47 = ((($34)) + 4|0);
  $48 = HEAP32[$47>>2]|0;
  $5 = $48;
  $49 = $5;
  $50 = $28;
  $16 = $46;
  $17 = $49;
  $18 = $50;
  $51 = $16;
  $52 = $17;
  $53 = $18;
  $15 = $53;
  $54 = $15;
  ;HEAP8[$14>>0]=HEAP8[$19>>0]|0;
  $11 = $51;
  $12 = $52;
  $13 = $54;
  $55 = $11;
  $56 = $12;
  $57 = $13;
  $10 = $57;
  $58 = $10;
  $7 = $55;
  $8 = $56;
  $9 = $58;
  $59 = $8;
  $60 = $9;
  $6 = $60;
  $61 = $6;
  ;HEAP32[$59>>2]=HEAP32[$61>>2]|0;HEAP32[$59+4>>2]=HEAP32[$61+4>>2]|0;HEAP32[$59+8>>2]=HEAP32[$61+8>>2]|0;
  $20 = $29;
  $62 = ((($34)) + 4|0);
  $63 = HEAP32[$62>>2]|0;
  $64 = ((($63)) + 12|0);
  HEAP32[$62>>2] = $64;
  STACKTOP = sp;return;
 } else {
  $65 = $28;
  __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE21__push_back_slow_pathIRKS3_EEvOT_($34,$65);
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7factory11record_itemC2Eiii($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $4 = $0;
 $5 = $1;
 $6 = $2;
 $7 = $3;
 $8 = $4;
 $9 = $5;
 HEAP32[$8>>2] = $9;
 $10 = ((($8)) + 4|0);
 $11 = $6;
 HEAP32[$10>>2] = $11;
 $12 = ((($8)) + 8|0);
 $13 = $7;
 HEAP32[$12>>2] = $13;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE21__push_back_slow_pathIRKS3_EEvOT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 208|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(208|0);
 $10 = sp + 8|0;
 $15 = sp + 193|0;
 $24 = sp;
 $27 = sp + 192|0;
 $35 = sp + 72|0;
 $38 = sp + 60|0;
 $46 = sp + 12|0;
 $43 = $0;
 $44 = $1;
 $47 = $43;
 $42 = $47;
 $48 = $42;
 $49 = ((($48)) + 8|0);
 $41 = $49;
 $50 = $41;
 $40 = $50;
 $51 = $40;
 $45 = $51;
 $39 = $47;
 $52 = $39;
 $53 = ((($52)) + 4|0);
 $54 = HEAP32[$53>>2]|0;
 $55 = HEAP32[$52>>2]|0;
 $56 = $54;
 $57 = $55;
 $58 = (($56) - ($57))|0;
 $59 = (($58|0) / 12)&-1;
 $60 = (($59) + 1)|0;
 $34 = $47;
 HEAP32[$35>>2] = $60;
 $61 = $34;
 $62 = (__ZNKSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE8max_sizeEv($61)|0);
 $36 = $62;
 $63 = HEAP32[$35>>2]|0;
 $64 = $36;
 $65 = ($63>>>0)>($64>>>0);
 if ($65) {
  __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv($61);
  // unreachable;
 }
 $32 = $61;
 $66 = $32;
 $31 = $66;
 $67 = $31;
 $30 = $67;
 $68 = $30;
 $69 = ((($68)) + 8|0);
 $29 = $69;
 $70 = $29;
 $28 = $70;
 $71 = $28;
 $72 = HEAP32[$71>>2]|0;
 $73 = HEAP32[$67>>2]|0;
 $74 = $72;
 $75 = $73;
 $76 = (($74) - ($75))|0;
 $77 = (($76|0) / 12)&-1;
 $37 = $77;
 $78 = $37;
 $79 = $36;
 $80 = (($79>>>0) / 2)&-1;
 $81 = ($78>>>0)>=($80>>>0);
 if ($81) {
  $82 = $36;
  $33 = $82;
 } else {
  $83 = $37;
  $84 = $83<<1;
  HEAP32[$38>>2] = $84;
  $25 = $38;
  $26 = $35;
  $85 = $25;
  $86 = $26;
  ;HEAP8[$24>>0]=HEAP8[$27>>0]|0;
  $22 = $85;
  $23 = $86;
  $87 = $22;
  $88 = $23;
  $19 = $24;
  $20 = $87;
  $21 = $88;
  $89 = $20;
  $90 = HEAP32[$89>>2]|0;
  $91 = $21;
  $92 = HEAP32[$91>>2]|0;
  $93 = ($90>>>0)<($92>>>0);
  $94 = $23;
  $95 = $22;
  $96 = $93 ? $94 : $95;
  $97 = HEAP32[$96>>2]|0;
  $33 = $97;
 }
 $98 = $33;
 $18 = $47;
 $99 = $18;
 $100 = ((($99)) + 4|0);
 $101 = HEAP32[$100>>2]|0;
 $102 = HEAP32[$99>>2]|0;
 $103 = $101;
 $104 = $102;
 $105 = (($103) - ($104))|0;
 $106 = (($105|0) / 12)&-1;
 $107 = $45;
 __ZNSt3__214__split_bufferIN6laszip7factory11record_itemERNS_9allocatorIS3_EEEC2EjjS6_($46,$98,$106,$107);
 $108 = $45;
 $109 = ((($46)) + 8|0);
 $110 = HEAP32[$109>>2]|0;
 $17 = $110;
 $111 = $17;
 $112 = $44;
 $16 = $112;
 $113 = $16;
 $12 = $108;
 $13 = $111;
 $14 = $113;
 $114 = $12;
 $115 = $13;
 $116 = $14;
 $11 = $116;
 $117 = $11;
 ;HEAP8[$10>>0]=HEAP8[$15>>0]|0;
 $7 = $114;
 $8 = $115;
 $9 = $117;
 $118 = $7;
 $119 = $8;
 $120 = $9;
 $6 = $120;
 $121 = $6;
 $3 = $118;
 $4 = $119;
 $5 = $121;
 $122 = $4;
 $123 = $5;
 $2 = $123;
 $124 = $2;
 ;HEAP32[$122>>2]=HEAP32[$124>>2]|0;HEAP32[$122+4>>2]=HEAP32[$124+4>>2]|0;HEAP32[$122+8>>2]=HEAP32[$124+8>>2]|0;
 $125 = ((($46)) + 8|0);
 $126 = HEAP32[$125>>2]|0;
 $127 = ((($126)) + 12|0);
 HEAP32[$125>>2] = $127;
 __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($47,$46);
 __ZNSt3__214__split_bufferIN6laszip7factory11record_itemERNS_9allocatorIS3_EEED2Ev($46);
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIN6laszip7factory11record_itemERNS_9allocatorIS3_EEEC2EjjS6_($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $35 = sp;
 $31 = $0;
 $32 = $1;
 $33 = $2;
 $34 = $3;
 $36 = $31;
 $37 = ((($36)) + 12|0);
 HEAP32[$35>>2] = 0;
 $38 = $34;
 $28 = $37;
 $29 = $35;
 $30 = $38;
 $39 = $28;
 $40 = $29;
 $27 = $40;
 $41 = $27;
 $21 = $39;
 $22 = $41;
 $42 = $21;
 $43 = $22;
 $20 = $43;
 HEAP32[$42>>2] = 0;
 $44 = ((($39)) + 4|0);
 $45 = $30;
 $23 = $45;
 $46 = $23;
 $25 = $44;
 $26 = $46;
 $47 = $25;
 $48 = $26;
 $24 = $48;
 $49 = $24;
 HEAP32[$47>>2] = $49;
 $50 = $32;
 $51 = ($50|0)!=(0);
 do {
  if ($51) {
   $6 = $36;
   $52 = $6;
   $53 = ((($52)) + 12|0);
   $5 = $53;
   $54 = $5;
   $55 = ((($54)) + 4|0);
   $4 = $55;
   $56 = $4;
   $57 = HEAP32[$56>>2]|0;
   $58 = $32;
   $15 = $57;
   $16 = $58;
   $59 = $15;
   $60 = $16;
   $12 = $59;
   $13 = $60;
   $14 = 0;
   $61 = $12;
   $62 = $13;
   $11 = $61;
   $63 = ($62>>>0)>(357913941);
   if ($63) {
    $9 = 4287;
    $64 = (___cxa_allocate_exception(8)|0);
    $65 = $9;
    $7 = $64;
    $8 = $65;
    $66 = $7;
    $67 = $8;
    __ZNSt11logic_errorC2EPKc($66,$67);
    HEAP32[$66>>2] = (3660);
    ___cxa_throw(($64|0),(1384|0),(220|0));
    // unreachable;
   } else {
    $68 = $13;
    $69 = ($68*12)|0;
    $10 = $69;
    $70 = $10;
    $71 = (__Znwj($70)|0);
    $72 = $71;
    break;
   }
  } else {
   $72 = 0;
  }
 } while(0);
 HEAP32[$36>>2] = $72;
 $73 = HEAP32[$36>>2]|0;
 $74 = $33;
 $75 = (($73) + (($74*12)|0)|0);
 $76 = ((($36)) + 8|0);
 HEAP32[$76>>2] = $75;
 $77 = ((($36)) + 4|0);
 HEAP32[$77>>2] = $75;
 $78 = HEAP32[$36>>2]|0;
 $79 = $32;
 $80 = (($78) + (($79*12)|0)|0);
 $19 = $36;
 $81 = $19;
 $82 = ((($81)) + 12|0);
 $18 = $82;
 $83 = $18;
 $17 = $83;
 $84 = $17;
 HEAP32[$84>>2] = $80;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 352|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(352|0);
 $15 = sp + 288|0;
 $21 = sp + 264|0;
 $33 = sp + 216|0;
 $86 = $0;
 $87 = $1;
 $88 = $86;
 $85 = $88;
 $89 = $85;
 $84 = $89;
 $90 = $84;
 $91 = HEAP32[$90>>2]|0;
 $83 = $91;
 $92 = $83;
 $62 = $89;
 $93 = $62;
 $94 = HEAP32[$93>>2]|0;
 $61 = $94;
 $95 = $61;
 $67 = $89;
 $96 = $67;
 $66 = $96;
 $97 = $66;
 $65 = $97;
 $98 = $65;
 $99 = ((($98)) + 8|0);
 $64 = $99;
 $100 = $64;
 $63 = $100;
 $101 = $63;
 $102 = HEAP32[$101>>2]|0;
 $103 = HEAP32[$97>>2]|0;
 $104 = $102;
 $105 = $103;
 $106 = (($104) - ($105))|0;
 $107 = (($106|0) / 12)&-1;
 $108 = (($95) + (($107*12)|0)|0);
 $69 = $89;
 $109 = $69;
 $110 = HEAP32[$109>>2]|0;
 $68 = $110;
 $111 = $68;
 $70 = $89;
 $112 = $70;
 $113 = ((($112)) + 4|0);
 $114 = HEAP32[$113>>2]|0;
 $115 = HEAP32[$112>>2]|0;
 $116 = $114;
 $117 = $115;
 $118 = (($116) - ($117))|0;
 $119 = (($118|0) / 12)&-1;
 $120 = (($111) + (($119*12)|0)|0);
 $72 = $89;
 $121 = $72;
 $122 = HEAP32[$121>>2]|0;
 $71 = $122;
 $123 = $71;
 $77 = $89;
 $124 = $77;
 $76 = $124;
 $125 = $76;
 $75 = $125;
 $126 = $75;
 $127 = ((($126)) + 8|0);
 $74 = $127;
 $128 = $74;
 $73 = $128;
 $129 = $73;
 $130 = HEAP32[$129>>2]|0;
 $131 = HEAP32[$125>>2]|0;
 $132 = $130;
 $133 = $131;
 $134 = (($132) - ($133))|0;
 $135 = (($134|0) / 12)&-1;
 $136 = (($123) + (($135*12)|0)|0);
 $78 = $89;
 $79 = $92;
 $80 = $108;
 $81 = $120;
 $82 = $136;
 $4 = $88;
 $137 = $4;
 $138 = ((($137)) + 8|0);
 $3 = $138;
 $139 = $3;
 $2 = $139;
 $140 = $2;
 $141 = HEAP32[$88>>2]|0;
 $142 = ((($88)) + 4|0);
 $143 = HEAP32[$142>>2]|0;
 $144 = $87;
 $145 = ((($144)) + 4|0);
 $5 = $140;
 $6 = $141;
 $7 = $143;
 $8 = $145;
 $146 = $7;
 $147 = $6;
 $148 = $146;
 $149 = $147;
 $150 = (($148) - ($149))|0;
 $151 = (($150|0) / 12)&-1;
 $9 = $151;
 $152 = $9;
 $153 = $8;
 $154 = HEAP32[$153>>2]|0;
 $155 = (0 - ($152))|0;
 $156 = (($154) + (($155*12)|0)|0);
 HEAP32[$153>>2] = $156;
 $157 = $9;
 $158 = ($157|0)>(0);
 if ($158) {
  $159 = $8;
  $160 = HEAP32[$159>>2]|0;
  $161 = $6;
  $162 = $9;
  $163 = ($162*12)|0;
  _memcpy(($160|0),($161|0),($163|0))|0;
 }
 $164 = $87;
 $165 = ((($164)) + 4|0);
 $13 = $88;
 $14 = $165;
 $166 = $13;
 $12 = $166;
 $167 = $12;
 $168 = HEAP32[$167>>2]|0;
 HEAP32[$15>>2] = $168;
 $169 = $14;
 $10 = $169;
 $170 = $10;
 $171 = HEAP32[$170>>2]|0;
 $172 = $13;
 HEAP32[$172>>2] = $171;
 $11 = $15;
 $173 = $11;
 $174 = HEAP32[$173>>2]|0;
 $175 = $14;
 HEAP32[$175>>2] = $174;
 $176 = ((($88)) + 4|0);
 $177 = $87;
 $178 = ((($177)) + 8|0);
 $19 = $176;
 $20 = $178;
 $179 = $19;
 $18 = $179;
 $180 = $18;
 $181 = HEAP32[$180>>2]|0;
 HEAP32[$21>>2] = $181;
 $182 = $20;
 $16 = $182;
 $183 = $16;
 $184 = HEAP32[$183>>2]|0;
 $185 = $19;
 HEAP32[$185>>2] = $184;
 $17 = $21;
 $186 = $17;
 $187 = HEAP32[$186>>2]|0;
 $188 = $20;
 HEAP32[$188>>2] = $187;
 $24 = $88;
 $189 = $24;
 $190 = ((($189)) + 8|0);
 $23 = $190;
 $191 = $23;
 $22 = $191;
 $192 = $22;
 $193 = $87;
 $27 = $193;
 $194 = $27;
 $195 = ((($194)) + 12|0);
 $26 = $195;
 $196 = $26;
 $25 = $196;
 $197 = $25;
 $31 = $192;
 $32 = $197;
 $198 = $31;
 $30 = $198;
 $199 = $30;
 $200 = HEAP32[$199>>2]|0;
 HEAP32[$33>>2] = $200;
 $201 = $32;
 $28 = $201;
 $202 = $28;
 $203 = HEAP32[$202>>2]|0;
 $204 = $31;
 HEAP32[$204>>2] = $203;
 $29 = $33;
 $205 = $29;
 $206 = HEAP32[$205>>2]|0;
 $207 = $32;
 HEAP32[$207>>2] = $206;
 $208 = $87;
 $209 = ((($208)) + 4|0);
 $210 = HEAP32[$209>>2]|0;
 $211 = $87;
 HEAP32[$211>>2] = $210;
 $34 = $88;
 $212 = $34;
 $213 = ((($212)) + 4|0);
 $214 = HEAP32[$213>>2]|0;
 $215 = HEAP32[$212>>2]|0;
 $216 = $214;
 $217 = $215;
 $218 = (($216) - ($217))|0;
 $219 = (($218|0) / 12)&-1;
 $58 = $88;
 $59 = $219;
 $220 = $58;
 $57 = $220;
 $221 = $57;
 $222 = HEAP32[$221>>2]|0;
 $56 = $222;
 $223 = $56;
 $36 = $220;
 $224 = $36;
 $225 = HEAP32[$224>>2]|0;
 $35 = $225;
 $226 = $35;
 $41 = $220;
 $227 = $41;
 $40 = $227;
 $228 = $40;
 $39 = $228;
 $229 = $39;
 $230 = ((($229)) + 8|0);
 $38 = $230;
 $231 = $38;
 $37 = $231;
 $232 = $37;
 $233 = HEAP32[$232>>2]|0;
 $234 = HEAP32[$228>>2]|0;
 $235 = $233;
 $236 = $234;
 $237 = (($235) - ($236))|0;
 $238 = (($237|0) / 12)&-1;
 $239 = (($226) + (($238*12)|0)|0);
 $43 = $220;
 $240 = $43;
 $241 = HEAP32[$240>>2]|0;
 $42 = $241;
 $242 = $42;
 $48 = $220;
 $243 = $48;
 $47 = $243;
 $244 = $47;
 $46 = $244;
 $245 = $46;
 $246 = ((($245)) + 8|0);
 $45 = $246;
 $247 = $45;
 $44 = $247;
 $248 = $44;
 $249 = HEAP32[$248>>2]|0;
 $250 = HEAP32[$244>>2]|0;
 $251 = $249;
 $252 = $250;
 $253 = (($251) - ($252))|0;
 $254 = (($253|0) / 12)&-1;
 $255 = (($242) + (($254*12)|0)|0);
 $50 = $220;
 $256 = $50;
 $257 = HEAP32[$256>>2]|0;
 $49 = $257;
 $258 = $49;
 $259 = $59;
 $260 = (($258) + (($259*12)|0)|0);
 $51 = $220;
 $52 = $223;
 $53 = $239;
 $54 = $255;
 $55 = $260;
 $60 = $88;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIN6laszip7factory11record_itemERNS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $49 = ((($48)) + 4|0);
  $24 = $49;
  $50 = $24;
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($41)) + 8|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ((($53)) + -12|0);
  HEAP32[$52>>2] = $54;
  $23 = $54;
  $55 = $23;
  $20 = $51;
  $21 = $55;
  $56 = $20;
  $57 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $56;
  $18 = $57;
  $58 = $17;
  $59 = $18;
  $15 = $58;
  $16 = $59;
 }
 $60 = HEAP32[$35>>2]|0;
 $61 = ($60|0)!=(0|0);
 if (!($61)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $62 = $14;
 $63 = ((($62)) + 12|0);
 $13 = $63;
 $64 = $13;
 $65 = ((($64)) + 4|0);
 $12 = $65;
 $66 = $12;
 $67 = HEAP32[$66>>2]|0;
 $68 = HEAP32[$35>>2]|0;
 $4 = $35;
 $69 = $4;
 $3 = $69;
 $70 = $3;
 $71 = ((($70)) + 12|0);
 $2 = $71;
 $72 = $2;
 $1 = $72;
 $73 = $1;
 $74 = HEAP32[$73>>2]|0;
 $75 = HEAP32[$69>>2]|0;
 $76 = $74;
 $77 = $75;
 $78 = (($76) - ($77))|0;
 $79 = (($78|0) / 12)&-1;
 $9 = $67;
 $10 = $68;
 $11 = $79;
 $80 = $9;
 $81 = $10;
 $82 = $11;
 $6 = $80;
 $7 = $81;
 $8 = $82;
 $83 = $7;
 $5 = $83;
 $84 = $5;
 __ZdlPv($84);
 STACKTOP = sp;return;
}
function __ZNKSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE8max_sizeEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $6 = sp + 8|0;
 $9 = sp + 77|0;
 $12 = sp;
 $14 = sp + 76|0;
 $19 = sp + 16|0;
 $20 = sp + 12|0;
 $18 = $0;
 $21 = $18;
 $17 = $21;
 $22 = $17;
 $23 = ((($22)) + 8|0);
 $16 = $23;
 $24 = $16;
 $15 = $24;
 $25 = $15;
 $13 = $25;
 $26 = $13;
 ;HEAP8[$12>>0]=HEAP8[$14>>0]|0;
 $11 = $26;
 $27 = $11;
 $10 = $27;
 HEAP32[$19>>2] = 357913941;
 HEAP32[$20>>2] = 2147483647;
 $7 = $19;
 $8 = $20;
 $28 = $7;
 $29 = $8;
 ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
 $4 = $28;
 $5 = $29;
 $30 = $5;
 $31 = $4;
 $1 = $6;
 $2 = $30;
 $3 = $31;
 $32 = $2;
 $33 = HEAP32[$32>>2]|0;
 $34 = $3;
 $35 = HEAP32[$34>>2]|0;
 $36 = ($33>>>0)<($35>>>0);
 $37 = $5;
 $38 = $4;
 $39 = $36 ? $37 : $38;
 $40 = HEAP32[$39>>2]|0;
 STACKTOP = sp;return ($40|0);
}
function __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE13__move_assignERS6_NS_17integral_constantIbLb1EEE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 96|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(96|0);
 $21 = sp;
 $24 = sp + 92|0;
 $25 = $0;
 $26 = $1;
 $27 = $25;
 __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE10deallocateEv($27);
 $28 = $26;
 $22 = $27;
 $23 = $28;
 $29 = $22;
 $30 = $23;
 ;HEAP8[$21>>0]=HEAP8[$24>>0]|0;
 $19 = $29;
 $20 = $30;
 $31 = $19;
 $32 = $20;
 $18 = $32;
 $33 = $18;
 $34 = ((($33)) + 8|0);
 $17 = $34;
 $35 = $17;
 $16 = $35;
 $36 = $16;
 $12 = $36;
 $15 = $31;
 $37 = $15;
 $38 = ((($37)) + 8|0);
 $14 = $38;
 $39 = $14;
 $13 = $39;
 $40 = $26;
 $41 = HEAP32[$40>>2]|0;
 HEAP32[$27>>2] = $41;
 $42 = $26;
 $43 = ((($42)) + 4|0);
 $44 = HEAP32[$43>>2]|0;
 $45 = ((($27)) + 4|0);
 HEAP32[$45>>2] = $44;
 $46 = $26;
 $5 = $46;
 $47 = $5;
 $48 = ((($47)) + 8|0);
 $4 = $48;
 $49 = $4;
 $3 = $49;
 $50 = $3;
 $51 = HEAP32[$50>>2]|0;
 $8 = $27;
 $52 = $8;
 $53 = ((($52)) + 8|0);
 $7 = $53;
 $54 = $7;
 $6 = $54;
 $55 = $6;
 HEAP32[$55>>2] = $51;
 $56 = $26;
 $11 = $56;
 $57 = $11;
 $58 = ((($57)) + 8|0);
 $10 = $58;
 $59 = $10;
 $9 = $59;
 $60 = $9;
 HEAP32[$60>>2] = 0;
 $61 = $26;
 $62 = ((($61)) + 4|0);
 HEAP32[$62>>2] = 0;
 $63 = $26;
 HEAP32[$63>>2] = 0;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIN6laszip7factory11record_itemENS_9allocatorIS3_EEE10deallocateEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0;
 var $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0;
 var $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0;
 var $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 240|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(240|0);
 $45 = sp;
 $48 = sp + 236|0;
 $60 = $0;
 $61 = $60;
 $62 = HEAP32[$61>>2]|0;
 $63 = ($62|0)!=(0|0);
 if (!($63)) {
  STACKTOP = sp;return;
 }
 $58 = $61;
 $64 = $58;
 $57 = $64;
 $65 = $57;
 $66 = ((($65)) + 4|0);
 $67 = HEAP32[$66>>2]|0;
 $68 = HEAP32[$65>>2]|0;
 $69 = $67;
 $70 = $68;
 $71 = (($69) - ($70))|0;
 $72 = (($71|0) / 12)&-1;
 $59 = $72;
 $56 = $64;
 $73 = $56;
 $74 = HEAP32[$73>>2]|0;
 $53 = $73;
 $54 = $74;
 $75 = $53;
 $76 = ((($75)) + 4|0);
 $77 = HEAP32[$76>>2]|0;
 $55 = $77;
 while(1) {
  $78 = $54;
  $79 = $55;
  $80 = ($78|0)!=($79|0);
  if (!($80)) {
   break;
  }
  $52 = $75;
  $81 = $52;
  $82 = ((($81)) + 8|0);
  $51 = $82;
  $83 = $51;
  $50 = $83;
  $84 = $50;
  $85 = $55;
  $86 = ((($85)) + -12|0);
  $55 = $86;
  $49 = $86;
  $87 = $49;
  $46 = $84;
  $47 = $87;
  $88 = $46;
  $89 = $47;
  ;HEAP8[$45>>0]=HEAP8[$48>>0]|0;
  $43 = $88;
  $44 = $89;
  $90 = $43;
  $91 = $44;
  $41 = $90;
  $42 = $91;
 }
 $92 = $54;
 $93 = ((($75)) + 4|0);
 HEAP32[$93>>2] = $92;
 $94 = $59;
 $38 = $64;
 $39 = $94;
 $95 = $38;
 $37 = $95;
 $96 = $37;
 $97 = HEAP32[$96>>2]|0;
 $36 = $97;
 $98 = $36;
 $20 = $95;
 $99 = $20;
 $100 = HEAP32[$99>>2]|0;
 $19 = $100;
 $101 = $19;
 $25 = $95;
 $102 = $25;
 $24 = $102;
 $103 = $24;
 $23 = $103;
 $104 = $23;
 $105 = ((($104)) + 8|0);
 $22 = $105;
 $106 = $22;
 $21 = $106;
 $107 = $21;
 $108 = HEAP32[$107>>2]|0;
 $109 = HEAP32[$103>>2]|0;
 $110 = $108;
 $111 = $109;
 $112 = (($110) - ($111))|0;
 $113 = (($112|0) / 12)&-1;
 $114 = (($101) + (($113*12)|0)|0);
 $27 = $95;
 $115 = $27;
 $116 = HEAP32[$115>>2]|0;
 $26 = $116;
 $117 = $26;
 $118 = $39;
 $119 = (($117) + (($118*12)|0)|0);
 $29 = $95;
 $120 = $29;
 $121 = HEAP32[$120>>2]|0;
 $28 = $121;
 $122 = $28;
 $30 = $95;
 $123 = $30;
 $124 = ((($123)) + 4|0);
 $125 = HEAP32[$124>>2]|0;
 $126 = HEAP32[$123>>2]|0;
 $127 = $125;
 $128 = $126;
 $129 = (($127) - ($128))|0;
 $130 = (($129|0) / 12)&-1;
 $131 = (($122) + (($130*12)|0)|0);
 $31 = $95;
 $32 = $98;
 $33 = $114;
 $34 = $119;
 $35 = $131;
 $40 = $64;
 $8 = $61;
 $132 = $8;
 $133 = ((($132)) + 8|0);
 $7 = $133;
 $134 = $7;
 $6 = $134;
 $135 = $6;
 $136 = HEAP32[$61>>2]|0;
 $5 = $61;
 $137 = $5;
 $4 = $137;
 $138 = $4;
 $3 = $138;
 $139 = $3;
 $140 = ((($139)) + 8|0);
 $2 = $140;
 $141 = $2;
 $1 = $141;
 $142 = $1;
 $143 = HEAP32[$142>>2]|0;
 $144 = HEAP32[$138>>2]|0;
 $145 = $143;
 $146 = $144;
 $147 = (($145) - ($146))|0;
 $148 = (($147|0) / 12)&-1;
 $13 = $135;
 $14 = $136;
 $15 = $148;
 $149 = $13;
 $150 = $14;
 $151 = $15;
 $10 = $149;
 $11 = $150;
 $12 = $151;
 $152 = $11;
 $9 = $152;
 $153 = $9;
 __ZdlPv($153);
 $18 = $61;
 $154 = $18;
 $155 = ((($154)) + 8|0);
 $17 = $155;
 $156 = $17;
 $16 = $156;
 $157 = $16;
 HEAP32[$157>>2] = 0;
 $158 = ((($61)) + 4|0);
 HEAP32[$158>>2] = 0;
 HEAP32[$61>>2] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip22chunk_table_read_errorC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,5254);
 HEAP32[$2>>2] = (1828);
 STACKTOP = sp;return;
}
function __ZN6laszip22chunk_table_read_errorD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip13not_supportedC2EPKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 __ZNSt13runtime_errorC2EPKc($4,$5);
 HEAP32[$4>>2] = (1848);
 STACKTOP = sp;return;
}
function __ZN6laszip13not_supportedD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip26unknown_chunk_table_formatC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,5298);
 HEAP32[$2>>2] = (1868);
 STACKTOP = sp;return;
}
function __ZN6laszip26unknown_chunk_table_formatD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIyNS_9allocatorIyEEE6resizeEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 192|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(192|0);
 $6 = sp;
 $9 = sp + 180|0;
 $45 = $0;
 $46 = $1;
 $48 = $45;
 $44 = $48;
 $49 = $44;
 $50 = ((($49)) + 4|0);
 $51 = HEAP32[$50>>2]|0;
 $52 = HEAP32[$49>>2]|0;
 $53 = $51;
 $54 = $52;
 $55 = (($53) - ($54))|0;
 $56 = (($55|0) / 8)&-1;
 $47 = $56;
 $57 = $47;
 $58 = $46;
 $59 = ($57>>>0)<($58>>>0);
 if ($59) {
  $60 = $46;
  $61 = $47;
  $62 = (($60) - ($61))|0;
  __ZNSt3__26vectorIyNS_9allocatorIyEEE8__appendEj($48,$62);
  STACKTOP = sp;return;
 }
 $63 = $47;
 $64 = $46;
 $65 = ($63>>>0)>($64>>>0);
 if (!($65)) {
  STACKTOP = sp;return;
 }
 $66 = HEAP32[$48>>2]|0;
 $67 = $46;
 $68 = (($66) + ($67<<3)|0);
 $41 = $48;
 $42 = $68;
 $69 = $41;
 $70 = $42;
 $39 = $69;
 $40 = $70;
 $38 = $69;
 $71 = $38;
 $72 = ((($71)) + 4|0);
 $73 = HEAP32[$72>>2]|0;
 $74 = HEAP32[$71>>2]|0;
 $75 = $73;
 $76 = $74;
 $77 = (($75) - ($76))|0;
 $78 = (($77|0) / 8)&-1;
 $43 = $78;
 $79 = $42;
 $14 = $69;
 $15 = $79;
 $80 = $14;
 $81 = ((($80)) + 4|0);
 $82 = HEAP32[$81>>2]|0;
 $16 = $82;
 while(1) {
  $83 = $15;
  $84 = $16;
  $85 = ($83|0)!=($84|0);
  if (!($85)) {
   break;
  }
  $13 = $80;
  $86 = $13;
  $87 = ((($86)) + 8|0);
  $12 = $87;
  $88 = $12;
  $11 = $88;
  $89 = $11;
  $90 = $16;
  $91 = ((($90)) + -8|0);
  $16 = $91;
  $10 = $91;
  $92 = $10;
  $7 = $89;
  $8 = $92;
  $93 = $7;
  $94 = $8;
  ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
  $4 = $93;
  $5 = $94;
  $95 = $4;
  $96 = $5;
  $2 = $95;
  $3 = $96;
 }
 $97 = $15;
 $98 = ((($80)) + 4|0);
 HEAP32[$98>>2] = $97;
 $99 = $43;
 $36 = $69;
 $37 = $99;
 $100 = $36;
 $35 = $100;
 $101 = $35;
 $102 = HEAP32[$101>>2]|0;
 $34 = $102;
 $103 = $34;
 $18 = $100;
 $104 = $18;
 $105 = HEAP32[$104>>2]|0;
 $17 = $105;
 $106 = $17;
 $23 = $100;
 $107 = $23;
 $22 = $107;
 $108 = $22;
 $21 = $108;
 $109 = $21;
 $110 = ((($109)) + 8|0);
 $20 = $110;
 $111 = $20;
 $19 = $111;
 $112 = $19;
 $113 = HEAP32[$112>>2]|0;
 $114 = HEAP32[$108>>2]|0;
 $115 = $113;
 $116 = $114;
 $117 = (($115) - ($116))|0;
 $118 = (($117|0) / 8)&-1;
 $119 = (($106) + ($118<<3)|0);
 $25 = $100;
 $120 = $25;
 $121 = HEAP32[$120>>2]|0;
 $24 = $121;
 $122 = $24;
 $123 = $37;
 $124 = (($122) + ($123<<3)|0);
 $27 = $100;
 $125 = $27;
 $126 = HEAP32[$125>>2]|0;
 $26 = $126;
 $127 = $26;
 $28 = $100;
 $128 = $28;
 $129 = ((($128)) + 4|0);
 $130 = HEAP32[$129>>2]|0;
 $131 = HEAP32[$128>>2]|0;
 $132 = $130;
 $133 = $131;
 $134 = (($132) - ($133))|0;
 $135 = (($134|0) / 8)&-1;
 $136 = (($127) + ($135<<3)|0);
 $29 = $100;
 $30 = $103;
 $31 = $119;
 $32 = $124;
 $33 = $136;
 STACKTOP = sp;return;
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEC2ERS6_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 HEAP32[$4>>2] = $5;
 $6 = ((($4)) + 4|0);
 HEAP32[$6>>2] = 0;
 $7 = ((($4)) + 8|0);
 HEAP32[$7>>2] = -1;
 STACKTOP = sp;return;
}
function __ZN6laszip13decompressors7integerC2Ejjjj($0,$1,$2,$3,$4) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 $4 = $4|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $15 = sp + 72|0;
 $27 = sp + 24|0;
 $29 = $0;
 $30 = $1;
 $31 = $2;
 $32 = $3;
 $33 = $4;
 $34 = $29;
 $35 = ((($34)) + 4|0);
 $36 = $30;
 HEAP32[$35>>2] = $36;
 $37 = ((($34)) + 8|0);
 $38 = $31;
 HEAP32[$37>>2] = $38;
 $39 = ((($34)) + 12|0);
 $40 = $32;
 HEAP32[$39>>2] = $40;
 $41 = ((($34)) + 16|0);
 $42 = $33;
 HEAP32[$41>>2] = $42;
 $43 = ((($34)) + 36|0);
 $28 = $43;
 $44 = $28;
 $26 = $44;
 $45 = $26;
 $25 = $45;
 HEAP32[$45>>2] = 0;
 $46 = ((($45)) + 4|0);
 HEAP32[$46>>2] = 0;
 $47 = ((($45)) + 8|0);
 HEAP32[$27>>2] = 0;
 $23 = $47;
 $24 = $27;
 $48 = $23;
 $49 = $24;
 $22 = $49;
 $50 = $22;
 $18 = $48;
 $19 = $50;
 $51 = $18;
 $52 = $19;
 $17 = $52;
 HEAP32[$51>>2] = 0;
 $21 = $48;
 $53 = $21;
 $20 = $53;
 $54 = ((($34)) + 48|0);
 __ZN6laszip6models14arithmetic_bitC2Ev($54);
 $55 = ((($34)) + 68|0);
 $16 = $55;
 $56 = $16;
 $14 = $56;
 $57 = $14;
 $13 = $57;
 HEAP32[$57>>2] = 0;
 $58 = ((($57)) + 4|0);
 HEAP32[$58>>2] = 0;
 $59 = ((($57)) + 8|0);
 HEAP32[$15>>2] = 0;
 $11 = $59;
 $12 = $15;
 $60 = $11;
 $61 = $12;
 $10 = $61;
 $62 = $10;
 $6 = $60;
 $7 = $62;
 $63 = $6;
 $64 = $7;
 $5 = $64;
 HEAP32[$63>>2] = 0;
 $9 = $60;
 $65 = $9;
 $8 = $65;
 $66 = $33;
 $67 = ($66|0)!=(0);
 if (!($67)) {
  $100 = $30;
  $101 = ($100|0)!=(0);
  $102 = $30;
  $103 = ($102>>>0)<(32);
  $or$cond = $101 & $103;
  if ($or$cond) {
   $104 = $30;
   $105 = ((($34)) + 20|0);
   HEAP32[$105>>2] = $104;
   $106 = $30;
   $107 = 1 << $106;
   $108 = ((($34)) + 24|0);
   HEAP32[$108>>2] = $107;
   $109 = ((($34)) + 24|0);
   $110 = HEAP32[$109>>2]|0;
   $111 = (($110>>>0) / 2)&-1;
   $112 = (0 - ($111))|0;
   $113 = ((($34)) + 28|0);
   HEAP32[$113>>2] = $112;
   $114 = ((($34)) + 28|0);
   $115 = HEAP32[$114>>2]|0;
   $116 = ((($34)) + 24|0);
   $117 = HEAP32[$116>>2]|0;
   $118 = (($115) + ($117))|0;
   $119 = (($118) - 1)|0;
   $120 = ((($34)) + 32|0);
   HEAP32[$120>>2] = $119;
   HEAP32[$34>>2] = 0;
   STACKTOP = sp;return;
  } else {
   $121 = ((($34)) + 20|0);
   HEAP32[$121>>2] = 32;
   $122 = ((($34)) + 24|0);
   HEAP32[$122>>2] = 0;
   $123 = ((($34)) + 28|0);
   HEAP32[$123>>2] = -2147483648;
   $124 = ((($34)) + 32|0);
   HEAP32[$124>>2] = 2147483647;
   HEAP32[$34>>2] = 0;
   STACKTOP = sp;return;
  }
 }
 $68 = ((($34)) + 20|0);
 HEAP32[$68>>2] = 0;
 $69 = $33;
 $70 = ((($34)) + 24|0);
 HEAP32[$70>>2] = $69;
 while(1) {
  $71 = $33;
  $72 = ($71|0)!=(0);
  if (!($72)) {
   break;
  }
  $73 = $33;
  $74 = $73 >>> 1;
  $33 = $74;
  $75 = ((($34)) + 20|0);
  $76 = HEAP32[$75>>2]|0;
  $77 = (($76) + 1)|0;
  HEAP32[$75>>2] = $77;
 }
 $78 = ((($34)) + 24|0);
 $79 = HEAP32[$78>>2]|0;
 $80 = ((($34)) + 20|0);
 $81 = HEAP32[$80>>2]|0;
 $82 = (($81) - 1)|0;
 $83 = 1 << $82;
 $84 = ($79|0)==($83|0);
 if ($84) {
  $85 = ((($34)) + 20|0);
  $86 = HEAP32[$85>>2]|0;
  $87 = (($86) + -1)|0;
  HEAP32[$85>>2] = $87;
 }
 $88 = ((($34)) + 24|0);
 $89 = HEAP32[$88>>2]|0;
 $90 = (($89>>>0) / 2)&-1;
 $91 = (0 - ($90))|0;
 $92 = ((($34)) + 28|0);
 HEAP32[$92>>2] = $91;
 $93 = ((($34)) + 28|0);
 $94 = HEAP32[$93>>2]|0;
 $95 = ((($34)) + 24|0);
 $96 = HEAP32[$95>>2]|0;
 $97 = (($94) + ($96))|0;
 $98 = (($97) - 1)|0;
 $99 = ((($34)) + 32|0);
 HEAP32[$99>>2] = $98;
 HEAP32[$34>>2] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE13readInitBytesEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 $4 = (__ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7getByteEv($3)|0);
 $5 = $4&255;
 $6 = $5 << 24;
 $7 = HEAP32[$2>>2]|0;
 $8 = (__ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7getByteEv($7)|0);
 $9 = $8&255;
 $10 = $9 << 16;
 $11 = $6 | $10;
 $12 = HEAP32[$2>>2]|0;
 $13 = (__ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7getByteEv($12)|0);
 $14 = $13&255;
 $15 = $14 << 8;
 $16 = $11 | $15;
 $17 = HEAP32[$2>>2]|0;
 $18 = (__ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7getByteEv($17)|0);
 $19 = $18&255;
 $20 = $16 | $19;
 $21 = ((($2)) + 4|0);
 HEAP32[$21>>2] = $20;
 STACKTOP = sp;return;
}
function __ZN6laszip13decompressors7integer4initEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0;
 var $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0;
 var $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 336|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(336|0);
 $14 = sp + 8|0;
 $19 = sp + 335|0;
 $30 = sp + 334|0;
 $44 = sp;
 $49 = sp + 333|0;
 $60 = sp + 332|0;
 $64 = sp + 60|0;
 $66 = sp + 12|0;
 $62 = $0;
 $67 = $62;
 $68 = ((($67)) + 36|0);
 $61 = $68;
 $69 = $61;
 $70 = HEAP32[$69>>2]|0;
 $71 = ((($69)) + 4|0);
 $72 = HEAP32[$71>>2]|0;
 $73 = ($70|0)==($72|0);
 if (!($73)) {
  STACKTOP = sp;return;
 }
 $63 = 0;
 while(1) {
  $74 = $63;
  $75 = ((($67)) + 8|0);
  $76 = HEAP32[$75>>2]|0;
  $77 = ($74>>>0)<($76>>>0);
  if (!($77)) {
   break;
  }
  $78 = ((($67)) + 36|0);
  $79 = ((($67)) + 20|0);
  $80 = HEAP32[$79>>2]|0;
  $81 = (($80) + 1)|0;
  __ZN6laszip6models10arithmeticC2EjbPj($64,$81,0,0);
  $58 = $78;
  $59 = $64;
  $82 = $58;
  $83 = ((($82)) + 4|0);
  $84 = HEAP32[$83>>2]|0;
  $57 = $82;
  $85 = $57;
  $86 = ((($85)) + 8|0);
  $56 = $86;
  $87 = $56;
  $55 = $87;
  $88 = $55;
  $89 = HEAP32[$88>>2]|0;
  $90 = ($84>>>0)<($89>>>0);
  if ($90) {
   $52 = $60;
   $53 = $82;
   $54 = 1;
   $35 = $82;
   $91 = $35;
   $92 = ((($91)) + 8|0);
   $34 = $92;
   $93 = $34;
   $33 = $93;
   $94 = $33;
   $95 = ((($82)) + 4|0);
   $96 = HEAP32[$95>>2]|0;
   $31 = $96;
   $97 = $31;
   $98 = $59;
   $32 = $98;
   $99 = $32;
   $46 = $94;
   $47 = $97;
   $48 = $99;
   $100 = $46;
   $101 = $47;
   $102 = $48;
   $45 = $102;
   $103 = $45;
   ;HEAP8[$44>>0]=HEAP8[$49>>0]|0;
   $41 = $100;
   $42 = $101;
   $43 = $103;
   $104 = $41;
   $105 = $42;
   $106 = $43;
   $40 = $106;
   $107 = $40;
   $37 = $104;
   $38 = $105;
   $39 = $107;
   $108 = $38;
   $109 = $39;
   $36 = $109;
   $110 = $36;
   __ZN6laszip6models10arithmeticC2EOS1_($108,$110);
   $50 = $60;
   $111 = ((($82)) + 4|0);
   $112 = HEAP32[$111>>2]|0;
   $113 = ((($112)) + 44|0);
   HEAP32[$111>>2] = $113;
  } else {
   $114 = $59;
   $51 = $114;
   $115 = $51;
   __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE21__push_back_slow_pathIS3_EEvOT_($82,$115);
  }
  __ZN6laszip6models10arithmeticD2Ev($64);
  $116 = $63;
  $117 = (($116) + 1)|0;
  $63 = $117;
 }
 $63 = 1;
 while(1) {
  $118 = $63;
  $119 = ((($67)) + 20|0);
  $120 = HEAP32[$119>>2]|0;
  $121 = ($118>>>0)<=($120>>>0);
  if (!($121)) {
   break;
  }
  $122 = $63;
  $123 = ((($67)) + 12|0);
  $124 = HEAP32[$123>>2]|0;
  $125 = ($122>>>0)<=($124>>>0);
  if ($125) {
   $126 = $63;
   $127 = 1 << $126;
   $131 = $127;
  } else {
   $128 = ((($67)) + 12|0);
   $129 = HEAP32[$128>>2]|0;
   $130 = 1 << $129;
   $131 = $130;
  }
  $65 = $131;
  $132 = ((($67)) + 68|0);
  $133 = $65;
  __ZN6laszip6models10arithmeticC2EjbPj($66,$133,0,0);
  $28 = $132;
  $29 = $66;
  $134 = $28;
  $135 = ((($134)) + 4|0);
  $136 = HEAP32[$135>>2]|0;
  $27 = $134;
  $137 = $27;
  $138 = ((($137)) + 8|0);
  $26 = $138;
  $139 = $26;
  $25 = $139;
  $140 = $25;
  $141 = HEAP32[$140>>2]|0;
  $142 = ($136>>>0)<($141>>>0);
  if ($142) {
   $22 = $30;
   $23 = $134;
   $24 = 1;
   $5 = $134;
   $143 = $5;
   $144 = ((($143)) + 8|0);
   $4 = $144;
   $145 = $4;
   $3 = $145;
   $146 = $3;
   $147 = ((($134)) + 4|0);
   $148 = HEAP32[$147>>2]|0;
   $1 = $148;
   $149 = $1;
   $150 = $29;
   $2 = $150;
   $151 = $2;
   $16 = $146;
   $17 = $149;
   $18 = $151;
   $152 = $16;
   $153 = $17;
   $154 = $18;
   $15 = $154;
   $155 = $15;
   ;HEAP8[$14>>0]=HEAP8[$19>>0]|0;
   $11 = $152;
   $12 = $153;
   $13 = $155;
   $156 = $11;
   $157 = $12;
   $158 = $13;
   $10 = $158;
   $159 = $10;
   $7 = $156;
   $8 = $157;
   $9 = $159;
   $160 = $8;
   $161 = $9;
   $6 = $161;
   $162 = $6;
   __ZN6laszip6models10arithmeticC2EOS1_($160,$162);
   $20 = $30;
   $163 = ((($134)) + 4|0);
   $164 = HEAP32[$163>>2]|0;
   $165 = ((($164)) + 44|0);
   HEAP32[$163>>2] = $165;
  } else {
   $166 = $29;
   $21 = $166;
   $167 = $21;
   __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE21__push_back_slow_pathIS3_EEvOT_($134,$167);
  }
  __ZN6laszip6models10arithmeticD2Ev($66);
  $168 = $63;
  $169 = (($168) + 1)|0;
  $63 = $169;
 }
 STACKTOP = sp;return;
}
function __ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $6 = $0;
 $7 = $1;
 $8 = $2;
 $9 = $3;
 $11 = $6;
 $12 = $8;
 $13 = $7;
 $14 = ((($11)) + 36|0);
 $15 = $9;
 $4 = $14;
 $5 = $15;
 $16 = $4;
 $17 = HEAP32[$16>>2]|0;
 $18 = $5;
 $19 = (($17) + (($18*44)|0)|0);
 $20 = (__ZN6laszip13decompressors7integer13readCorrectorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS_6models10arithmeticEEEiRT_RT0_($11,$13,$19)|0);
 $21 = (($12) + ($20))|0;
 $10 = $21;
 $22 = $10;
 $23 = ($22|0)<(0);
 if ($23) {
  $24 = ((($11)) + 24|0);
  $25 = HEAP32[$24>>2]|0;
  $26 = $10;
  $27 = (($26) + ($25))|0;
  $10 = $27;
  $36 = $10;
  STACKTOP = sp;return ($36|0);
 }
 $28 = $10;
 $29 = ((($11)) + 24|0);
 $30 = HEAP32[$29>>2]|0;
 $31 = ($28>>>0)>=($30>>>0);
 if (!($31)) {
  $36 = $10;
  STACKTOP = sp;return ($36|0);
 }
 $32 = ((($11)) + 24|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = $10;
 $35 = (($34) - ($33))|0;
 $10 = $35;
 $36 = $10;
 STACKTOP = sp;return ($36|0);
}
function __ZN6laszip13decompressors7integerD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 68|0);
 __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($3);
 $4 = ((($2)) + 36|0);
 __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($4);
 STACKTOP = sp;return;
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZN6laszip22chunk_table_read_errorD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip22chunk_table_read_errorD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip13not_supportedD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13not_supportedD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip26unknown_chunk_table_formatD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip26unknown_chunk_table_formatD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIyNS_9allocatorIyEEE8__appendEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $8 = sp;
 $11 = sp + 140|0;
 $19 = sp + 76|0;
 $22 = sp + 64|0;
 $33 = sp + 4|0;
 $30 = $0;
 $31 = $1;
 $34 = $30;
 $29 = $34;
 $35 = $29;
 $36 = ((($35)) + 8|0);
 $28 = $36;
 $37 = $28;
 $27 = $37;
 $38 = $27;
 $39 = HEAP32[$38>>2]|0;
 $40 = ((($34)) + 4|0);
 $41 = HEAP32[$40>>2]|0;
 $42 = $39;
 $43 = $41;
 $44 = (($42) - ($43))|0;
 $45 = (($44|0) / 8)&-1;
 $46 = $31;
 $47 = ($45>>>0)>=($46>>>0);
 if ($47) {
  $48 = $31;
  __ZNSt3__26vectorIyNS_9allocatorIyEEE18__construct_at_endEj($34,$48);
  STACKTOP = sp;return;
 }
 $26 = $34;
 $49 = $26;
 $50 = ((($49)) + 8|0);
 $25 = $50;
 $51 = $25;
 $24 = $51;
 $52 = $24;
 $32 = $52;
 $23 = $34;
 $53 = $23;
 $54 = ((($53)) + 4|0);
 $55 = HEAP32[$54>>2]|0;
 $56 = HEAP32[$53>>2]|0;
 $57 = $55;
 $58 = $56;
 $59 = (($57) - ($58))|0;
 $60 = (($59|0) / 8)&-1;
 $61 = $31;
 $62 = (($60) + ($61))|0;
 $18 = $34;
 HEAP32[$19>>2] = $62;
 $63 = $18;
 $64 = (__ZNKSt3__26vectorIyNS_9allocatorIyEEE8max_sizeEv($63)|0);
 $20 = $64;
 $65 = HEAP32[$19>>2]|0;
 $66 = $20;
 $67 = ($65>>>0)>($66>>>0);
 if ($67) {
  __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv($63);
  // unreachable;
 }
 $16 = $63;
 $68 = $16;
 $15 = $68;
 $69 = $15;
 $14 = $69;
 $70 = $14;
 $71 = ((($70)) + 8|0);
 $13 = $71;
 $72 = $13;
 $12 = $72;
 $73 = $12;
 $74 = HEAP32[$73>>2]|0;
 $75 = HEAP32[$69>>2]|0;
 $76 = $74;
 $77 = $75;
 $78 = (($76) - ($77))|0;
 $79 = (($78|0) / 8)&-1;
 $21 = $79;
 $80 = $21;
 $81 = $20;
 $82 = (($81>>>0) / 2)&-1;
 $83 = ($80>>>0)>=($82>>>0);
 if ($83) {
  $84 = $20;
  $17 = $84;
 } else {
  $85 = $21;
  $86 = $85<<1;
  HEAP32[$22>>2] = $86;
  $9 = $22;
  $10 = $19;
  $87 = $9;
  $88 = $10;
  ;HEAP8[$8>>0]=HEAP8[$11>>0]|0;
  $6 = $87;
  $7 = $88;
  $89 = $6;
  $90 = $7;
  $3 = $8;
  $4 = $89;
  $5 = $90;
  $91 = $4;
  $92 = HEAP32[$91>>2]|0;
  $93 = $5;
  $94 = HEAP32[$93>>2]|0;
  $95 = ($92>>>0)<($94>>>0);
  $96 = $7;
  $97 = $6;
  $98 = $95 ? $96 : $97;
  $99 = HEAP32[$98>>2]|0;
  $17 = $99;
 }
 $100 = $17;
 $2 = $34;
 $101 = $2;
 $102 = ((($101)) + 4|0);
 $103 = HEAP32[$102>>2]|0;
 $104 = HEAP32[$101>>2]|0;
 $105 = $103;
 $106 = $104;
 $107 = (($105) - ($106))|0;
 $108 = (($107|0) / 8)&-1;
 $109 = $32;
 __ZNSt3__214__split_bufferIyRNS_9allocatorIyEEEC2EjjS3_($33,$100,$108,$109);
 $110 = $31;
 __ZNSt3__214__split_bufferIyRNS_9allocatorIyEEE18__construct_at_endEj($33,$110);
 __ZNSt3__26vectorIyNS_9allocatorIyEEE26__swap_out_circular_bufferERNS_14__split_bufferIyRS2_EE($34,$33);
 __ZNSt3__214__split_bufferIyRNS_9allocatorIyEEED2Ev($33);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIyNS_9allocatorIyEEE18__construct_at_endEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $10 = sp;
 $13 = sp + 73|0;
 $21 = sp + 72|0;
 $18 = $0;
 $19 = $1;
 $22 = $18;
 $17 = $22;
 $23 = $17;
 $24 = ((($23)) + 8|0);
 $16 = $24;
 $25 = $16;
 $15 = $25;
 $26 = $15;
 $20 = $26;
 while(1) {
  $2 = $21;
  $3 = $22;
  $4 = 1;
  $27 = $20;
  $28 = ((($22)) + 4|0);
  $29 = HEAP32[$28>>2]|0;
  $5 = $29;
  $30 = $5;
  $11 = $27;
  $12 = $30;
  $31 = $11;
  $32 = $12;
  ;HEAP8[$10>>0]=HEAP8[$13>>0]|0;
  $8 = $31;
  $9 = $32;
  $33 = $8;
  $34 = $9;
  $6 = $33;
  $7 = $34;
  $35 = $7;
  $36 = $35;
  $37 = $36;
  HEAP32[$37>>2] = 0;
  $38 = (($36) + 4)|0;
  $39 = $38;
  HEAP32[$39>>2] = 0;
  $40 = ((($22)) + 4|0);
  $41 = HEAP32[$40>>2]|0;
  $42 = ((($41)) + 8|0);
  HEAP32[$40>>2] = $42;
  $43 = $19;
  $44 = (($43) + -1)|0;
  $19 = $44;
  $14 = $21;
  $45 = $19;
  $46 = ($45>>>0)>(0);
  if (!($46)) {
   break;
  }
 }
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIyRNS_9allocatorIyEEEC2EjjS3_($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $35 = sp;
 $31 = $0;
 $32 = $1;
 $33 = $2;
 $34 = $3;
 $36 = $31;
 $37 = ((($36)) + 12|0);
 HEAP32[$35>>2] = 0;
 $38 = $34;
 $28 = $37;
 $29 = $35;
 $30 = $38;
 $39 = $28;
 $40 = $29;
 $27 = $40;
 $41 = $27;
 $21 = $39;
 $22 = $41;
 $42 = $21;
 $43 = $22;
 $20 = $43;
 HEAP32[$42>>2] = 0;
 $44 = ((($39)) + 4|0);
 $45 = $30;
 $23 = $45;
 $46 = $23;
 $25 = $44;
 $26 = $46;
 $47 = $25;
 $48 = $26;
 $24 = $48;
 $49 = $24;
 HEAP32[$47>>2] = $49;
 $50 = $32;
 $51 = ($50|0)!=(0);
 do {
  if ($51) {
   $6 = $36;
   $52 = $6;
   $53 = ((($52)) + 12|0);
   $5 = $53;
   $54 = $5;
   $55 = ((($54)) + 4|0);
   $4 = $55;
   $56 = $4;
   $57 = HEAP32[$56>>2]|0;
   $58 = $32;
   $15 = $57;
   $16 = $58;
   $59 = $15;
   $60 = $16;
   $12 = $59;
   $13 = $60;
   $14 = 0;
   $61 = $12;
   $62 = $13;
   $11 = $61;
   $63 = ($62>>>0)>(536870911);
   if ($63) {
    $9 = 4287;
    $64 = (___cxa_allocate_exception(8)|0);
    $65 = $9;
    $7 = $64;
    $8 = $65;
    $66 = $7;
    $67 = $8;
    __ZNSt11logic_errorC2EPKc($66,$67);
    HEAP32[$66>>2] = (3660);
    ___cxa_throw(($64|0),(1384|0),(220|0));
    // unreachable;
   } else {
    $68 = $13;
    $69 = $68<<3;
    $10 = $69;
    $70 = $10;
    $71 = (__Znwj($70)|0);
    $72 = $71;
    break;
   }
  } else {
   $72 = 0;
  }
 } while(0);
 HEAP32[$36>>2] = $72;
 $73 = HEAP32[$36>>2]|0;
 $74 = $33;
 $75 = (($73) + ($74<<3)|0);
 $76 = ((($36)) + 8|0);
 HEAP32[$76>>2] = $75;
 $77 = ((($36)) + 4|0);
 HEAP32[$77>>2] = $75;
 $78 = HEAP32[$36>>2]|0;
 $79 = $32;
 $80 = (($78) + ($79<<3)|0);
 $19 = $36;
 $81 = $19;
 $82 = ((($81)) + 12|0);
 $18 = $82;
 $83 = $18;
 $17 = $83;
 $84 = $17;
 HEAP32[$84>>2] = $80;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIyRNS_9allocatorIyEEE18__construct_at_endEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $7 = sp;
 $10 = sp + 56|0;
 $14 = $0;
 $15 = $1;
 $17 = $14;
 $13 = $17;
 $18 = $13;
 $19 = ((($18)) + 12|0);
 $12 = $19;
 $20 = $12;
 $21 = ((($20)) + 4|0);
 $11 = $21;
 $22 = $11;
 $23 = HEAP32[$22>>2]|0;
 $16 = $23;
 while(1) {
  $24 = $16;
  $25 = ((($17)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  $2 = $26;
  $27 = $2;
  $8 = $24;
  $9 = $27;
  $28 = $8;
  $29 = $9;
  ;HEAP8[$7>>0]=HEAP8[$10>>0]|0;
  $5 = $28;
  $6 = $29;
  $30 = $5;
  $31 = $6;
  $3 = $30;
  $4 = $31;
  $32 = $4;
  $33 = $32;
  $34 = $33;
  HEAP32[$34>>2] = 0;
  $35 = (($33) + 4)|0;
  $36 = $35;
  HEAP32[$36>>2] = 0;
  $37 = ((($17)) + 8|0);
  $38 = HEAP32[$37>>2]|0;
  $39 = ((($38)) + 8|0);
  HEAP32[$37>>2] = $39;
  $40 = $15;
  $41 = (($40) + -1)|0;
  $15 = $41;
  $42 = $15;
  $43 = ($42>>>0)>(0);
  if (!($43)) {
   break;
  }
 }
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIyNS_9allocatorIyEEE26__swap_out_circular_bufferERNS_14__split_bufferIyRS2_EE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 352|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(352|0);
 $15 = sp + 288|0;
 $21 = sp + 264|0;
 $33 = sp + 216|0;
 $86 = $0;
 $87 = $1;
 $88 = $86;
 $85 = $88;
 $89 = $85;
 $84 = $89;
 $90 = $84;
 $91 = HEAP32[$90>>2]|0;
 $83 = $91;
 $92 = $83;
 $62 = $89;
 $93 = $62;
 $94 = HEAP32[$93>>2]|0;
 $61 = $94;
 $95 = $61;
 $67 = $89;
 $96 = $67;
 $66 = $96;
 $97 = $66;
 $65 = $97;
 $98 = $65;
 $99 = ((($98)) + 8|0);
 $64 = $99;
 $100 = $64;
 $63 = $100;
 $101 = $63;
 $102 = HEAP32[$101>>2]|0;
 $103 = HEAP32[$97>>2]|0;
 $104 = $102;
 $105 = $103;
 $106 = (($104) - ($105))|0;
 $107 = (($106|0) / 8)&-1;
 $108 = (($95) + ($107<<3)|0);
 $69 = $89;
 $109 = $69;
 $110 = HEAP32[$109>>2]|0;
 $68 = $110;
 $111 = $68;
 $70 = $89;
 $112 = $70;
 $113 = ((($112)) + 4|0);
 $114 = HEAP32[$113>>2]|0;
 $115 = HEAP32[$112>>2]|0;
 $116 = $114;
 $117 = $115;
 $118 = (($116) - ($117))|0;
 $119 = (($118|0) / 8)&-1;
 $120 = (($111) + ($119<<3)|0);
 $72 = $89;
 $121 = $72;
 $122 = HEAP32[$121>>2]|0;
 $71 = $122;
 $123 = $71;
 $77 = $89;
 $124 = $77;
 $76 = $124;
 $125 = $76;
 $75 = $125;
 $126 = $75;
 $127 = ((($126)) + 8|0);
 $74 = $127;
 $128 = $74;
 $73 = $128;
 $129 = $73;
 $130 = HEAP32[$129>>2]|0;
 $131 = HEAP32[$125>>2]|0;
 $132 = $130;
 $133 = $131;
 $134 = (($132) - ($133))|0;
 $135 = (($134|0) / 8)&-1;
 $136 = (($123) + ($135<<3)|0);
 $78 = $89;
 $79 = $92;
 $80 = $108;
 $81 = $120;
 $82 = $136;
 $4 = $88;
 $137 = $4;
 $138 = ((($137)) + 8|0);
 $3 = $138;
 $139 = $3;
 $2 = $139;
 $140 = $2;
 $141 = HEAP32[$88>>2]|0;
 $142 = ((($88)) + 4|0);
 $143 = HEAP32[$142>>2]|0;
 $144 = $87;
 $145 = ((($144)) + 4|0);
 $5 = $140;
 $6 = $141;
 $7 = $143;
 $8 = $145;
 $146 = $7;
 $147 = $6;
 $148 = $146;
 $149 = $147;
 $150 = (($148) - ($149))|0;
 $151 = (($150|0) / 8)&-1;
 $9 = $151;
 $152 = $9;
 $153 = $8;
 $154 = HEAP32[$153>>2]|0;
 $155 = (0 - ($152))|0;
 $156 = (($154) + ($155<<3)|0);
 HEAP32[$153>>2] = $156;
 $157 = $9;
 $158 = ($157|0)>(0);
 if ($158) {
  $159 = $8;
  $160 = HEAP32[$159>>2]|0;
  $161 = $6;
  $162 = $9;
  $163 = $162<<3;
  _memcpy(($160|0),($161|0),($163|0))|0;
 }
 $164 = $87;
 $165 = ((($164)) + 4|0);
 $13 = $88;
 $14 = $165;
 $166 = $13;
 $12 = $166;
 $167 = $12;
 $168 = HEAP32[$167>>2]|0;
 HEAP32[$15>>2] = $168;
 $169 = $14;
 $10 = $169;
 $170 = $10;
 $171 = HEAP32[$170>>2]|0;
 $172 = $13;
 HEAP32[$172>>2] = $171;
 $11 = $15;
 $173 = $11;
 $174 = HEAP32[$173>>2]|0;
 $175 = $14;
 HEAP32[$175>>2] = $174;
 $176 = ((($88)) + 4|0);
 $177 = $87;
 $178 = ((($177)) + 8|0);
 $19 = $176;
 $20 = $178;
 $179 = $19;
 $18 = $179;
 $180 = $18;
 $181 = HEAP32[$180>>2]|0;
 HEAP32[$21>>2] = $181;
 $182 = $20;
 $16 = $182;
 $183 = $16;
 $184 = HEAP32[$183>>2]|0;
 $185 = $19;
 HEAP32[$185>>2] = $184;
 $17 = $21;
 $186 = $17;
 $187 = HEAP32[$186>>2]|0;
 $188 = $20;
 HEAP32[$188>>2] = $187;
 $24 = $88;
 $189 = $24;
 $190 = ((($189)) + 8|0);
 $23 = $190;
 $191 = $23;
 $22 = $191;
 $192 = $22;
 $193 = $87;
 $27 = $193;
 $194 = $27;
 $195 = ((($194)) + 12|0);
 $26 = $195;
 $196 = $26;
 $25 = $196;
 $197 = $25;
 $31 = $192;
 $32 = $197;
 $198 = $31;
 $30 = $198;
 $199 = $30;
 $200 = HEAP32[$199>>2]|0;
 HEAP32[$33>>2] = $200;
 $201 = $32;
 $28 = $201;
 $202 = $28;
 $203 = HEAP32[$202>>2]|0;
 $204 = $31;
 HEAP32[$204>>2] = $203;
 $29 = $33;
 $205 = $29;
 $206 = HEAP32[$205>>2]|0;
 $207 = $32;
 HEAP32[$207>>2] = $206;
 $208 = $87;
 $209 = ((($208)) + 4|0);
 $210 = HEAP32[$209>>2]|0;
 $211 = $87;
 HEAP32[$211>>2] = $210;
 $34 = $88;
 $212 = $34;
 $213 = ((($212)) + 4|0);
 $214 = HEAP32[$213>>2]|0;
 $215 = HEAP32[$212>>2]|0;
 $216 = $214;
 $217 = $215;
 $218 = (($216) - ($217))|0;
 $219 = (($218|0) / 8)&-1;
 $58 = $88;
 $59 = $219;
 $220 = $58;
 $57 = $220;
 $221 = $57;
 $222 = HEAP32[$221>>2]|0;
 $56 = $222;
 $223 = $56;
 $36 = $220;
 $224 = $36;
 $225 = HEAP32[$224>>2]|0;
 $35 = $225;
 $226 = $35;
 $41 = $220;
 $227 = $41;
 $40 = $227;
 $228 = $40;
 $39 = $228;
 $229 = $39;
 $230 = ((($229)) + 8|0);
 $38 = $230;
 $231 = $38;
 $37 = $231;
 $232 = $37;
 $233 = HEAP32[$232>>2]|0;
 $234 = HEAP32[$228>>2]|0;
 $235 = $233;
 $236 = $234;
 $237 = (($235) - ($236))|0;
 $238 = (($237|0) / 8)&-1;
 $239 = (($226) + ($238<<3)|0);
 $43 = $220;
 $240 = $43;
 $241 = HEAP32[$240>>2]|0;
 $42 = $241;
 $242 = $42;
 $48 = $220;
 $243 = $48;
 $47 = $243;
 $244 = $47;
 $46 = $244;
 $245 = $46;
 $246 = ((($245)) + 8|0);
 $45 = $246;
 $247 = $45;
 $44 = $247;
 $248 = $44;
 $249 = HEAP32[$248>>2]|0;
 $250 = HEAP32[$244>>2]|0;
 $251 = $249;
 $252 = $250;
 $253 = (($251) - ($252))|0;
 $254 = (($253|0) / 8)&-1;
 $255 = (($242) + ($254<<3)|0);
 $50 = $220;
 $256 = $50;
 $257 = HEAP32[$256>>2]|0;
 $49 = $257;
 $258 = $49;
 $259 = $59;
 $260 = (($258) + ($259<<3)|0);
 $51 = $220;
 $52 = $223;
 $53 = $239;
 $54 = $255;
 $55 = $260;
 $60 = $88;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIyRNS_9allocatorIyEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $49 = ((($48)) + 4|0);
  $24 = $49;
  $50 = $24;
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($41)) + 8|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ((($53)) + -8|0);
  HEAP32[$52>>2] = $54;
  $23 = $54;
  $55 = $23;
  $20 = $51;
  $21 = $55;
  $56 = $20;
  $57 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $56;
  $18 = $57;
  $58 = $17;
  $59 = $18;
  $15 = $58;
  $16 = $59;
 }
 $60 = HEAP32[$35>>2]|0;
 $61 = ($60|0)!=(0|0);
 if (!($61)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $62 = $14;
 $63 = ((($62)) + 12|0);
 $13 = $63;
 $64 = $13;
 $65 = ((($64)) + 4|0);
 $12 = $65;
 $66 = $12;
 $67 = HEAP32[$66>>2]|0;
 $68 = HEAP32[$35>>2]|0;
 $4 = $35;
 $69 = $4;
 $3 = $69;
 $70 = $3;
 $71 = ((($70)) + 12|0);
 $2 = $71;
 $72 = $2;
 $1 = $72;
 $73 = $1;
 $74 = HEAP32[$73>>2]|0;
 $75 = HEAP32[$69>>2]|0;
 $76 = $74;
 $77 = $75;
 $78 = (($76) - ($77))|0;
 $79 = (($78|0) / 8)&-1;
 $9 = $67;
 $10 = $68;
 $11 = $79;
 $80 = $9;
 $81 = $10;
 $82 = $11;
 $6 = $80;
 $7 = $81;
 $8 = $82;
 $83 = $7;
 $5 = $83;
 $84 = $5;
 __ZdlPv($84);
 STACKTOP = sp;return;
}
function __ZNKSt3__26vectorIyNS_9allocatorIyEEE8max_sizeEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $6 = sp + 8|0;
 $9 = sp + 77|0;
 $12 = sp;
 $14 = sp + 76|0;
 $19 = sp + 16|0;
 $20 = sp + 12|0;
 $18 = $0;
 $21 = $18;
 $17 = $21;
 $22 = $17;
 $23 = ((($22)) + 8|0);
 $16 = $23;
 $24 = $16;
 $15 = $24;
 $25 = $15;
 $13 = $25;
 $26 = $13;
 ;HEAP8[$12>>0]=HEAP8[$14>>0]|0;
 $11 = $26;
 $27 = $11;
 $10 = $27;
 HEAP32[$19>>2] = 536870911;
 HEAP32[$20>>2] = 2147483647;
 $7 = $19;
 $8 = $20;
 $28 = $7;
 $29 = $8;
 ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
 $4 = $28;
 $5 = $29;
 $30 = $5;
 $31 = $4;
 $1 = $6;
 $2 = $30;
 $3 = $31;
 $32 = $2;
 $33 = HEAP32[$32>>2]|0;
 $34 = $3;
 $35 = HEAP32[$34>>2]|0;
 $36 = ($33>>>0)<($35>>>0);
 $37 = $5;
 $38 = $4;
 $39 = $36 ? $37 : $38;
 $40 = HEAP32[$39>>2]|0;
 STACKTOP = sp;return ($40|0);
}
function __ZN6laszip6models14arithmetic_bitC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 12|0);
 HEAP32[$3>>2] = 1;
 $4 = ((($2)) + 16|0);
 HEAP32[$4>>2] = 2;
 $5 = ((($2)) + 8|0);
 HEAP32[$5>>2] = 4096;
 $6 = ((($2)) + 4|0);
 HEAP32[$6>>2] = 4;
 HEAP32[$2>>2] = 4;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__213__vector_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__213__vector_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $19 = sp;
 $22 = sp + 120|0;
 $31 = $0;
 $32 = $31;
 $33 = HEAP32[$32>>2]|0;
 $34 = ($33|0)!=(0|0);
 if (!($34)) {
  STACKTOP = sp;return;
 }
 $30 = $32;
 $35 = $30;
 $36 = HEAP32[$35>>2]|0;
 $27 = $35;
 $28 = $36;
 $37 = $27;
 $38 = ((($37)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $29 = $39;
 while(1) {
  $40 = $28;
  $41 = $29;
  $42 = ($40|0)!=($41|0);
  if (!($42)) {
   break;
  }
  $26 = $37;
  $43 = $26;
  $44 = ((($43)) + 8|0);
  $25 = $44;
  $45 = $25;
  $24 = $45;
  $46 = $24;
  $47 = $29;
  $48 = ((($47)) + -44|0);
  $29 = $48;
  $23 = $48;
  $49 = $23;
  $20 = $46;
  $21 = $49;
  $50 = $20;
  $51 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $50;
  $18 = $51;
  $52 = $17;
  $53 = $18;
  $15 = $52;
  $16 = $53;
  $54 = $16;
  __ZN6laszip6models10arithmeticD2Ev($54);
 }
 $55 = $28;
 $56 = ((($37)) + 4|0);
 HEAP32[$56>>2] = $55;
 $14 = $32;
 $57 = $14;
 $58 = ((($57)) + 8|0);
 $13 = $58;
 $59 = $13;
 $12 = $59;
 $60 = $12;
 $61 = HEAP32[$32>>2]|0;
 $4 = $32;
 $62 = $4;
 $3 = $62;
 $63 = $3;
 $64 = ((($63)) + 8|0);
 $2 = $64;
 $65 = $2;
 $1 = $65;
 $66 = $1;
 $67 = HEAP32[$66>>2]|0;
 $68 = HEAP32[$62>>2]|0;
 $69 = $67;
 $70 = $68;
 $71 = (($69) - ($70))|0;
 $72 = (($71|0) / 44)&-1;
 $9 = $60;
 $10 = $61;
 $11 = $72;
 $73 = $9;
 $74 = $10;
 $75 = $11;
 $6 = $73;
 $7 = $74;
 $8 = $75;
 $76 = $7;
 $5 = $76;
 $77 = $5;
 __ZdlPv($77);
 STACKTOP = sp;return;
}
function __ZN6laszip6models10arithmeticD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 8|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ($4|0)!=(0|0);
 if ($5) {
  $6 = ((($2)) + 8|0);
  $7 = HEAP32[$6>>2]|0;
  __ZN6laszip5utilsL12aligned_freeEPv($7);
 }
 $8 = ((($2)) + 12|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ($9|0)!=(0|0);
 if ($10) {
  $11 = ((($2)) + 12|0);
  $12 = HEAP32[$11>>2]|0;
  __ZN6laszip5utilsL12aligned_freeEPv($12);
 }
 $13 = ((($2)) + 16|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = ($14|0)!=(0|0);
 if (!($15)) {
  STACKTOP = sp;return;
 }
 $16 = ((($2)) + 16|0);
 $17 = HEAP32[$16>>2]|0;
 __ZN6laszip5utilsL12aligned_freeEPv($17);
 STACKTOP = sp;return;
}
function __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7getByteEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 4|0);
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($2)) + 8|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = ($4|0)>=($6|0);
 if ($7) {
  __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7fillit_Ev($2);
 }
 $8 = ((($2)) + 12|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($2)) + 4|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = (($11) + 1)|0;
 HEAP32[$10>>2] = $12;
 $13 = (($9) + ($11)|0);
 $14 = HEAP8[$13>>0]|0;
 STACKTOP = sp;return ($14|0);
}
function __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7fillit_Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 4|0);
 HEAP32[$3>>2] = 0;
 $4 = HEAP32[$2>>2]|0;
 $5 = ((($2)) + 12|0);
 $6 = HEAP32[$5>>2]|0;
 __ZN6laszip7streams13memory_stream4readEPci($4,$6,1048576);
 $7 = HEAP32[$2>>2]|0;
 $8 = (__ZN6laszip7streams13memory_stream6gcountEv($7)|0);
 $9 = ((($2)) + 8|0);
 HEAP32[$9>>2] = $8;
 $10 = ((($2)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ($11|0)==(0);
 if ($12) {
  $13 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip11end_of_fileC2Ev($13);
  ___cxa_throw(($13|0),(216|0),(40|0));
  // unreachable;
 } else {
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7streams13memory_stream6gcountEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 16|0);
 $4 = HEAP32[$3>>2]|0;
 STACKTOP = sp;return ($4|0);
}
function __ZN6laszip11end_of_fileC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,5363);
 HEAP32[$2>>2] = (1888);
 STACKTOP = sp;return;
}
function __ZN6laszip11end_of_fileD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip11end_of_fileD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip11end_of_fileD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip6models10arithmeticC2EjbPj($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = $0;
 $5 = $1;
 $11 = $2&1;
 $6 = $11;
 $7 = $3;
 $12 = $4;
 $13 = $5;
 HEAP32[$12>>2] = $13;
 $14 = ((($12)) + 4|0);
 $15 = $6;
 $16 = $15&1;
 $17 = $16&1;
 HEAP8[$14>>0] = $17;
 $18 = ((($12)) + 8|0);
 HEAP32[$18>>2] = 0;
 $19 = ((($12)) + 12|0);
 HEAP32[$19>>2] = 0;
 $20 = ((($12)) + 16|0);
 HEAP32[$20>>2] = 0;
 $21 = HEAP32[$12>>2]|0;
 $22 = ($21>>>0)<(2);
 if ($22) {
  $25 = (___cxa_allocate_exception(8)|0);
  __ZNSt13runtime_errorC2EPKc($25,5383);
  ___cxa_throw(($25|0),(1368|0),(223|0));
  // unreachable;
 }
 $23 = HEAP32[$12>>2]|0;
 $24 = ($23>>>0)>(2048);
 if ($24) {
  $25 = (___cxa_allocate_exception(8)|0);
  __ZNSt13runtime_errorC2EPKc($25,5383);
  ___cxa_throw(($25|0),(1368|0),(223|0));
  // unreachable;
 }
 $26 = HEAP32[$12>>2]|0;
 $27 = (($26) - 1)|0;
 $28 = ((($12)) + 32|0);
 HEAP32[$28>>2] = $27;
 $29 = ((($12)) + 4|0);
 $30 = HEAP8[$29>>0]|0;
 $31 = $30&1;
 if ($31) {
  label = 10;
 } else {
  $32 = HEAP32[$12>>2]|0;
  $33 = ($32>>>0)>(16);
  if ($33) {
   $8 = 3;
   while(1) {
    $34 = HEAP32[$12>>2]|0;
    $35 = $8;
    $36 = (($35) + 2)|0;
    $37 = 1 << $36;
    $38 = ($34>>>0)>($37>>>0);
    $39 = $8;
    if (!($38)) {
     break;
    }
    $40 = (($39) + 1)|0;
    $8 = $40;
   }
   $41 = 1 << $39;
   $42 = ((($12)) + 36|0);
   HEAP32[$42>>2] = $41;
   $43 = $8;
   $44 = (15 - ($43))|0;
   $45 = ((($12)) + 40|0);
   HEAP32[$45>>2] = $44;
   $46 = ((($12)) + 36|0);
   $47 = HEAP32[$46>>2]|0;
   $48 = (($47) + 2)|0;
   $49 = $48<<2;
   $50 = (__ZN6laszip5utilsL14aligned_mallocEi($49)|0);
   $51 = ((($12)) + 16|0);
   HEAP32[$51>>2] = $50;
  } else {
   label = 10;
  }
 }
 if ((label|0) == 10) {
  $52 = ((($12)) + 16|0);
  HEAP32[$52>>2] = 0;
  $53 = ((($12)) + 40|0);
  HEAP32[$53>>2] = 0;
  $54 = ((($12)) + 36|0);
  HEAP32[$54>>2] = 0;
 }
 $55 = HEAP32[$12>>2]|0;
 $56 = $55<<2;
 $57 = (__ZN6laszip5utilsL14aligned_mallocEi($56)|0);
 $58 = ((($12)) + 8|0);
 HEAP32[$58>>2] = $57;
 $59 = HEAP32[$12>>2]|0;
 $60 = $59<<2;
 $61 = (__ZN6laszip5utilsL14aligned_mallocEi($60)|0);
 $62 = ((($12)) + 12|0);
 HEAP32[$62>>2] = $61;
 $63 = ((($12)) + 20|0);
 HEAP32[$63>>2] = 0;
 $64 = HEAP32[$12>>2]|0;
 $65 = ((($12)) + 24|0);
 HEAP32[$65>>2] = $64;
 $66 = $7;
 $67 = ($66|0)!=(0|0);
 if ($67) {
  $9 = 0;
  while(1) {
   $68 = $9;
   $69 = HEAP32[$12>>2]|0;
   $70 = ($68>>>0)<($69>>>0);
   if (!($70)) {
    break;
   }
   $71 = $7;
   $72 = $9;
   $73 = (($71) + ($72<<2)|0);
   $74 = HEAP32[$73>>2]|0;
   $75 = ((($12)) + 12|0);
   $76 = HEAP32[$75>>2]|0;
   $77 = $9;
   $78 = (($76) + ($77<<2)|0);
   HEAP32[$78>>2] = $74;
   $79 = $9;
   $80 = (($79) + 1)|0;
   $9 = $80;
  }
  __ZN6laszip6models10arithmetic6updateEv($12);
  $90 = HEAP32[$12>>2]|0;
  $91 = (($90) + 6)|0;
  $92 = $91 >>> 1;
  $93 = ((($12)) + 24|0);
  HEAP32[$93>>2] = $92;
  $94 = ((($12)) + 28|0);
  HEAP32[$94>>2] = $92;
  STACKTOP = sp;return;
 } else {
  $10 = 0;
  while(1) {
   $81 = $10;
   $82 = HEAP32[$12>>2]|0;
   $83 = ($81>>>0)<($82>>>0);
   if (!($83)) {
    break;
   }
   $84 = ((($12)) + 12|0);
   $85 = HEAP32[$84>>2]|0;
   $86 = $10;
   $87 = (($85) + ($86<<2)|0);
   HEAP32[$87>>2] = 1;
   $88 = $10;
   $89 = (($88) + 1)|0;
   $10 = $89;
  }
  __ZN6laszip6models10arithmetic6updateEv($12);
  $90 = HEAP32[$12>>2]|0;
  $91 = (($90) + 6)|0;
  $92 = $91 >>> 1;
  $93 = ((($12)) + 24|0);
  HEAP32[$93>>2] = $92;
  $94 = ((($12)) + 28|0);
  HEAP32[$94>>2] = $92;
  STACKTOP = sp;return;
 }
}
function __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE21__push_back_slow_pathIS3_EEvOT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0;
 var $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 208|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(208|0);
 $10 = sp + 8|0;
 $15 = sp + 193|0;
 $24 = sp;
 $27 = sp + 192|0;
 $35 = sp + 72|0;
 $38 = sp + 60|0;
 $46 = sp + 12|0;
 $43 = $0;
 $44 = $1;
 $47 = $43;
 $42 = $47;
 $48 = $42;
 $49 = ((($48)) + 8|0);
 $41 = $49;
 $50 = $41;
 $40 = $50;
 $51 = $40;
 $45 = $51;
 $39 = $47;
 $52 = $39;
 $53 = ((($52)) + 4|0);
 $54 = HEAP32[$53>>2]|0;
 $55 = HEAP32[$52>>2]|0;
 $56 = $54;
 $57 = $55;
 $58 = (($56) - ($57))|0;
 $59 = (($58|0) / 44)&-1;
 $60 = (($59) + 1)|0;
 $34 = $47;
 HEAP32[$35>>2] = $60;
 $61 = $34;
 $62 = (__ZNKSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE8max_sizeEv($61)|0);
 $36 = $62;
 $63 = HEAP32[$35>>2]|0;
 $64 = $36;
 $65 = ($63>>>0)>($64>>>0);
 if ($65) {
  __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv($61);
  // unreachable;
 }
 $32 = $61;
 $66 = $32;
 $31 = $66;
 $67 = $31;
 $30 = $67;
 $68 = $30;
 $69 = ((($68)) + 8|0);
 $29 = $69;
 $70 = $29;
 $28 = $70;
 $71 = $28;
 $72 = HEAP32[$71>>2]|0;
 $73 = HEAP32[$67>>2]|0;
 $74 = $72;
 $75 = $73;
 $76 = (($74) - ($75))|0;
 $77 = (($76|0) / 44)&-1;
 $37 = $77;
 $78 = $37;
 $79 = $36;
 $80 = (($79>>>0) / 2)&-1;
 $81 = ($78>>>0)>=($80>>>0);
 if ($81) {
  $82 = $36;
  $33 = $82;
 } else {
  $83 = $37;
  $84 = $83<<1;
  HEAP32[$38>>2] = $84;
  $25 = $38;
  $26 = $35;
  $85 = $25;
  $86 = $26;
  ;HEAP8[$24>>0]=HEAP8[$27>>0]|0;
  $22 = $85;
  $23 = $86;
  $87 = $22;
  $88 = $23;
  $19 = $24;
  $20 = $87;
  $21 = $88;
  $89 = $20;
  $90 = HEAP32[$89>>2]|0;
  $91 = $21;
  $92 = HEAP32[$91>>2]|0;
  $93 = ($90>>>0)<($92>>>0);
  $94 = $23;
  $95 = $22;
  $96 = $93 ? $94 : $95;
  $97 = HEAP32[$96>>2]|0;
  $33 = $97;
 }
 $98 = $33;
 $18 = $47;
 $99 = $18;
 $100 = ((($99)) + 4|0);
 $101 = HEAP32[$100>>2]|0;
 $102 = HEAP32[$99>>2]|0;
 $103 = $101;
 $104 = $102;
 $105 = (($103) - ($104))|0;
 $106 = (($105|0) / 44)&-1;
 $107 = $45;
 __ZNSt3__214__split_bufferIN6laszip6models10arithmeticERNS_9allocatorIS3_EEEC2EjjS6_($46,$98,$106,$107);
 $108 = $45;
 $109 = ((($46)) + 8|0);
 $110 = HEAP32[$109>>2]|0;
 $17 = $110;
 $111 = $17;
 $112 = $44;
 $16 = $112;
 $113 = $16;
 $12 = $108;
 $13 = $111;
 $14 = $113;
 $114 = $12;
 $115 = $13;
 $116 = $14;
 $11 = $116;
 $117 = $11;
 ;HEAP8[$10>>0]=HEAP8[$15>>0]|0;
 $7 = $114;
 $8 = $115;
 $9 = $117;
 $118 = $7;
 $119 = $8;
 $120 = $9;
 $6 = $120;
 $121 = $6;
 $3 = $118;
 $4 = $119;
 $5 = $121;
 $122 = $4;
 $123 = $5;
 $2 = $123;
 $124 = $2;
 __ZN6laszip6models10arithmeticC2EOS1_($122,$124);
 $125 = ((($46)) + 8|0);
 $126 = HEAP32[$125>>2]|0;
 $127 = ((($126)) + 44|0);
 HEAP32[$125>>2] = $127;
 __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($47,$46);
 __ZNSt3__214__split_bufferIN6laszip6models10arithmeticERNS_9allocatorIS3_EEED2Ev($46);
 STACKTOP = sp;return;
}
function __ZN6laszip6models10arithmeticC2EOS1_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 $6 = HEAP32[$5>>2]|0;
 HEAP32[$4>>2] = $6;
 $7 = ((($4)) + 4|0);
 $8 = $3;
 $9 = ((($8)) + 4|0);
 $10 = HEAP8[$9>>0]|0;
 $11 = $10&1;
 $12 = $11&1;
 HEAP8[$7>>0] = $12;
 $13 = ((($4)) + 8|0);
 $14 = $3;
 $15 = ((($14)) + 8|0);
 $16 = HEAP32[$15>>2]|0;
 HEAP32[$13>>2] = $16;
 $17 = ((($4)) + 12|0);
 $18 = $3;
 $19 = ((($18)) + 12|0);
 $20 = HEAP32[$19>>2]|0;
 HEAP32[$17>>2] = $20;
 $21 = ((($4)) + 16|0);
 $22 = $3;
 $23 = ((($22)) + 16|0);
 $24 = HEAP32[$23>>2]|0;
 HEAP32[$21>>2] = $24;
 $25 = ((($4)) + 20|0);
 $26 = $3;
 $27 = ((($26)) + 20|0);
 $28 = HEAP32[$27>>2]|0;
 HEAP32[$25>>2] = $28;
 $29 = ((($4)) + 24|0);
 $30 = $3;
 $31 = ((($30)) + 24|0);
 $32 = HEAP32[$31>>2]|0;
 HEAP32[$29>>2] = $32;
 $33 = ((($4)) + 28|0);
 $34 = $3;
 $35 = ((($34)) + 28|0);
 $36 = HEAP32[$35>>2]|0;
 HEAP32[$33>>2] = $36;
 $37 = ((($4)) + 32|0);
 $38 = $3;
 $39 = ((($38)) + 32|0);
 $40 = HEAP32[$39>>2]|0;
 HEAP32[$37>>2] = $40;
 $41 = ((($4)) + 36|0);
 $42 = $3;
 $43 = ((($42)) + 36|0);
 $44 = HEAP32[$43>>2]|0;
 HEAP32[$41>>2] = $44;
 $45 = ((($4)) + 40|0);
 $46 = $3;
 $47 = ((($46)) + 40|0);
 $48 = HEAP32[$47>>2]|0;
 HEAP32[$45>>2] = $48;
 $49 = $3;
 $50 = ((($49)) + 12|0);
 HEAP32[$50>>2] = 0;
 $51 = $3;
 $52 = ((($51)) + 16|0);
 HEAP32[$52>>2] = 0;
 $53 = $3;
 $54 = ((($53)) + 8|0);
 HEAP32[$54>>2] = 0;
 $55 = $3;
 $56 = ((($55)) + 12|0);
 HEAP32[$56>>2] = 0;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIN6laszip6models10arithmeticERNS_9allocatorIS3_EEEC2EjjS6_($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $35 = sp;
 $31 = $0;
 $32 = $1;
 $33 = $2;
 $34 = $3;
 $36 = $31;
 $37 = ((($36)) + 12|0);
 HEAP32[$35>>2] = 0;
 $38 = $34;
 $28 = $37;
 $29 = $35;
 $30 = $38;
 $39 = $28;
 $40 = $29;
 $27 = $40;
 $41 = $27;
 $21 = $39;
 $22 = $41;
 $42 = $21;
 $43 = $22;
 $20 = $43;
 HEAP32[$42>>2] = 0;
 $44 = ((($39)) + 4|0);
 $45 = $30;
 $23 = $45;
 $46 = $23;
 $25 = $44;
 $26 = $46;
 $47 = $25;
 $48 = $26;
 $24 = $48;
 $49 = $24;
 HEAP32[$47>>2] = $49;
 $50 = $32;
 $51 = ($50|0)!=(0);
 do {
  if ($51) {
   $6 = $36;
   $52 = $6;
   $53 = ((($52)) + 12|0);
   $5 = $53;
   $54 = $5;
   $55 = ((($54)) + 4|0);
   $4 = $55;
   $56 = $4;
   $57 = HEAP32[$56>>2]|0;
   $58 = $32;
   $15 = $57;
   $16 = $58;
   $59 = $15;
   $60 = $16;
   $12 = $59;
   $13 = $60;
   $14 = 0;
   $61 = $12;
   $62 = $13;
   $11 = $61;
   $63 = ($62>>>0)>(97612893);
   if ($63) {
    $9 = 4287;
    $64 = (___cxa_allocate_exception(8)|0);
    $65 = $9;
    $7 = $64;
    $8 = $65;
    $66 = $7;
    $67 = $8;
    __ZNSt11logic_errorC2EPKc($66,$67);
    HEAP32[$66>>2] = (3660);
    ___cxa_throw(($64|0),(1384|0),(220|0));
    // unreachable;
   } else {
    $68 = $13;
    $69 = ($68*44)|0;
    $10 = $69;
    $70 = $10;
    $71 = (__Znwj($70)|0);
    $72 = $71;
    break;
   }
  } else {
   $72 = 0;
  }
 } while(0);
 HEAP32[$36>>2] = $72;
 $73 = HEAP32[$36>>2]|0;
 $74 = $33;
 $75 = (($73) + (($74*44)|0)|0);
 $76 = ((($36)) + 8|0);
 HEAP32[$76>>2] = $75;
 $77 = ((($36)) + 4|0);
 HEAP32[$77>>2] = $75;
 $78 = HEAP32[$36>>2]|0;
 $79 = $32;
 $80 = (($78) + (($79*44)|0)|0);
 $19 = $36;
 $81 = $19;
 $82 = ((($81)) + 12|0);
 $18 = $82;
 $83 = $18;
 $17 = $83;
 $84 = $17;
 HEAP32[$84>>2] = $80;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS3_RS5_EE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0;
 var $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0;
 var $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0;
 var $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0;
 var $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0;
 var $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 416|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(416|0);
 $15 = sp;
 $20 = sp + 404|0;
 $31 = sp + 292|0;
 $37 = sp + 268|0;
 $49 = sp + 220|0;
 $102 = $0;
 $103 = $1;
 $104 = $102;
 $101 = $104;
 $105 = $101;
 $100 = $105;
 $106 = $100;
 $107 = HEAP32[$106>>2]|0;
 $99 = $107;
 $108 = $99;
 $78 = $105;
 $109 = $78;
 $110 = HEAP32[$109>>2]|0;
 $77 = $110;
 $111 = $77;
 $83 = $105;
 $112 = $83;
 $82 = $112;
 $113 = $82;
 $81 = $113;
 $114 = $81;
 $115 = ((($114)) + 8|0);
 $80 = $115;
 $116 = $80;
 $79 = $116;
 $117 = $79;
 $118 = HEAP32[$117>>2]|0;
 $119 = HEAP32[$113>>2]|0;
 $120 = $118;
 $121 = $119;
 $122 = (($120) - ($121))|0;
 $123 = (($122|0) / 44)&-1;
 $124 = (($111) + (($123*44)|0)|0);
 $85 = $105;
 $125 = $85;
 $126 = HEAP32[$125>>2]|0;
 $84 = $126;
 $127 = $84;
 $86 = $105;
 $128 = $86;
 $129 = ((($128)) + 4|0);
 $130 = HEAP32[$129>>2]|0;
 $131 = HEAP32[$128>>2]|0;
 $132 = $130;
 $133 = $131;
 $134 = (($132) - ($133))|0;
 $135 = (($134|0) / 44)&-1;
 $136 = (($127) + (($135*44)|0)|0);
 $88 = $105;
 $137 = $88;
 $138 = HEAP32[$137>>2]|0;
 $87 = $138;
 $139 = $87;
 $93 = $105;
 $140 = $93;
 $92 = $140;
 $141 = $92;
 $91 = $141;
 $142 = $91;
 $143 = ((($142)) + 8|0);
 $90 = $143;
 $144 = $90;
 $89 = $144;
 $145 = $89;
 $146 = HEAP32[$145>>2]|0;
 $147 = HEAP32[$141>>2]|0;
 $148 = $146;
 $149 = $147;
 $150 = (($148) - ($149))|0;
 $151 = (($150|0) / 44)&-1;
 $152 = (($139) + (($151*44)|0)|0);
 $94 = $105;
 $95 = $108;
 $96 = $124;
 $97 = $136;
 $98 = $152;
 $4 = $104;
 $153 = $4;
 $154 = ((($153)) + 8|0);
 $3 = $154;
 $155 = $3;
 $2 = $155;
 $156 = $2;
 $157 = HEAP32[$104>>2]|0;
 $158 = ((($104)) + 4|0);
 $159 = HEAP32[$158>>2]|0;
 $160 = $103;
 $161 = ((($160)) + 4|0);
 $22 = $156;
 $23 = $157;
 $24 = $159;
 $25 = $161;
 while(1) {
  $162 = $24;
  $163 = $23;
  $164 = ($162|0)!=($163|0);
  if (!($164)) {
   break;
  }
  $165 = $22;
  $166 = $25;
  $167 = HEAP32[$166>>2]|0;
  $168 = ((($167)) + -44|0);
  $21 = $168;
  $169 = $21;
  $170 = $24;
  $171 = ((($170)) + -44|0);
  $24 = $171;
  $6 = $171;
  $172 = $6;
  $5 = $172;
  $173 = $5;
  $17 = $165;
  $18 = $169;
  $19 = $173;
  $174 = $17;
  $175 = $18;
  $176 = $19;
  $16 = $176;
  $177 = $16;
  ;HEAP8[$15>>0]=HEAP8[$20>>0]|0;
  $12 = $174;
  $13 = $175;
  $14 = $177;
  $178 = $12;
  $179 = $13;
  $180 = $14;
  $11 = $180;
  $181 = $11;
  $8 = $178;
  $9 = $179;
  $10 = $181;
  $182 = $9;
  $183 = $10;
  $7 = $183;
  $184 = $7;
  __ZN6laszip6models10arithmeticC2ERKS1_($182,$184);
  $185 = $25;
  $186 = HEAP32[$185>>2]|0;
  $187 = ((($186)) + -44|0);
  HEAP32[$185>>2] = $187;
 }
 $188 = $103;
 $189 = ((($188)) + 4|0);
 $29 = $104;
 $30 = $189;
 $190 = $29;
 $28 = $190;
 $191 = $28;
 $192 = HEAP32[$191>>2]|0;
 HEAP32[$31>>2] = $192;
 $193 = $30;
 $26 = $193;
 $194 = $26;
 $195 = HEAP32[$194>>2]|0;
 $196 = $29;
 HEAP32[$196>>2] = $195;
 $27 = $31;
 $197 = $27;
 $198 = HEAP32[$197>>2]|0;
 $199 = $30;
 HEAP32[$199>>2] = $198;
 $200 = ((($104)) + 4|0);
 $201 = $103;
 $202 = ((($201)) + 8|0);
 $35 = $200;
 $36 = $202;
 $203 = $35;
 $34 = $203;
 $204 = $34;
 $205 = HEAP32[$204>>2]|0;
 HEAP32[$37>>2] = $205;
 $206 = $36;
 $32 = $206;
 $207 = $32;
 $208 = HEAP32[$207>>2]|0;
 $209 = $35;
 HEAP32[$209>>2] = $208;
 $33 = $37;
 $210 = $33;
 $211 = HEAP32[$210>>2]|0;
 $212 = $36;
 HEAP32[$212>>2] = $211;
 $40 = $104;
 $213 = $40;
 $214 = ((($213)) + 8|0);
 $39 = $214;
 $215 = $39;
 $38 = $215;
 $216 = $38;
 $217 = $103;
 $43 = $217;
 $218 = $43;
 $219 = ((($218)) + 12|0);
 $42 = $219;
 $220 = $42;
 $41 = $220;
 $221 = $41;
 $47 = $216;
 $48 = $221;
 $222 = $47;
 $46 = $222;
 $223 = $46;
 $224 = HEAP32[$223>>2]|0;
 HEAP32[$49>>2] = $224;
 $225 = $48;
 $44 = $225;
 $226 = $44;
 $227 = HEAP32[$226>>2]|0;
 $228 = $47;
 HEAP32[$228>>2] = $227;
 $45 = $49;
 $229 = $45;
 $230 = HEAP32[$229>>2]|0;
 $231 = $48;
 HEAP32[$231>>2] = $230;
 $232 = $103;
 $233 = ((($232)) + 4|0);
 $234 = HEAP32[$233>>2]|0;
 $235 = $103;
 HEAP32[$235>>2] = $234;
 $50 = $104;
 $236 = $50;
 $237 = ((($236)) + 4|0);
 $238 = HEAP32[$237>>2]|0;
 $239 = HEAP32[$236>>2]|0;
 $240 = $238;
 $241 = $239;
 $242 = (($240) - ($241))|0;
 $243 = (($242|0) / 44)&-1;
 $74 = $104;
 $75 = $243;
 $244 = $74;
 $73 = $244;
 $245 = $73;
 $246 = HEAP32[$245>>2]|0;
 $72 = $246;
 $247 = $72;
 $52 = $244;
 $248 = $52;
 $249 = HEAP32[$248>>2]|0;
 $51 = $249;
 $250 = $51;
 $57 = $244;
 $251 = $57;
 $56 = $251;
 $252 = $56;
 $55 = $252;
 $253 = $55;
 $254 = ((($253)) + 8|0);
 $54 = $254;
 $255 = $54;
 $53 = $255;
 $256 = $53;
 $257 = HEAP32[$256>>2]|0;
 $258 = HEAP32[$252>>2]|0;
 $259 = $257;
 $260 = $258;
 $261 = (($259) - ($260))|0;
 $262 = (($261|0) / 44)&-1;
 $263 = (($250) + (($262*44)|0)|0);
 $59 = $244;
 $264 = $59;
 $265 = HEAP32[$264>>2]|0;
 $58 = $265;
 $266 = $58;
 $64 = $244;
 $267 = $64;
 $63 = $267;
 $268 = $63;
 $62 = $268;
 $269 = $62;
 $270 = ((($269)) + 8|0);
 $61 = $270;
 $271 = $61;
 $60 = $271;
 $272 = $60;
 $273 = HEAP32[$272>>2]|0;
 $274 = HEAP32[$268>>2]|0;
 $275 = $273;
 $276 = $274;
 $277 = (($275) - ($276))|0;
 $278 = (($277|0) / 44)&-1;
 $279 = (($266) + (($278*44)|0)|0);
 $66 = $244;
 $280 = $66;
 $281 = HEAP32[$280>>2]|0;
 $65 = $281;
 $282 = $65;
 $283 = $75;
 $284 = (($282) + (($283*44)|0)|0);
 $67 = $244;
 $68 = $247;
 $69 = $263;
 $70 = $279;
 $71 = $284;
 $76 = $104;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIN6laszip6models10arithmeticERNS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $49 = ((($48)) + 4|0);
  $24 = $49;
  $50 = $24;
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($41)) + 8|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ((($53)) + -44|0);
  HEAP32[$52>>2] = $54;
  $23 = $54;
  $55 = $23;
  $20 = $51;
  $21 = $55;
  $56 = $20;
  $57 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $56;
  $18 = $57;
  $58 = $17;
  $59 = $18;
  $15 = $58;
  $16 = $59;
  $60 = $16;
  __ZN6laszip6models10arithmeticD2Ev($60);
 }
 $61 = HEAP32[$35>>2]|0;
 $62 = ($61|0)!=(0|0);
 if (!($62)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $63 = $14;
 $64 = ((($63)) + 12|0);
 $13 = $64;
 $65 = $13;
 $66 = ((($65)) + 4|0);
 $12 = $66;
 $67 = $12;
 $68 = HEAP32[$67>>2]|0;
 $69 = HEAP32[$35>>2]|0;
 $11 = $35;
 $70 = $11;
 $10 = $70;
 $71 = $10;
 $72 = ((($71)) + 12|0);
 $9 = $72;
 $73 = $9;
 $8 = $73;
 $74 = $8;
 $75 = HEAP32[$74>>2]|0;
 $76 = HEAP32[$70>>2]|0;
 $77 = $75;
 $78 = $76;
 $79 = (($77) - ($78))|0;
 $80 = (($79|0) / 44)&-1;
 $5 = $68;
 $6 = $69;
 $7 = $80;
 $81 = $5;
 $82 = $6;
 $83 = $7;
 $2 = $81;
 $3 = $82;
 $4 = $83;
 $84 = $3;
 $1 = $84;
 $85 = $1;
 __ZdlPv($85);
 STACKTOP = sp;return;
}
function __ZNKSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEE8max_sizeEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $6 = sp + 8|0;
 $9 = sp + 77|0;
 $12 = sp;
 $14 = sp + 76|0;
 $19 = sp + 16|0;
 $20 = sp + 12|0;
 $18 = $0;
 $21 = $18;
 $17 = $21;
 $22 = $17;
 $23 = ((($22)) + 8|0);
 $16 = $23;
 $24 = $16;
 $15 = $24;
 $25 = $15;
 $13 = $25;
 $26 = $13;
 ;HEAP8[$12>>0]=HEAP8[$14>>0]|0;
 $11 = $26;
 $27 = $11;
 $10 = $27;
 HEAP32[$19>>2] = 97612893;
 HEAP32[$20>>2] = 2147483647;
 $7 = $19;
 $8 = $20;
 $28 = $7;
 $29 = $8;
 ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
 $4 = $28;
 $5 = $29;
 $30 = $5;
 $31 = $4;
 $1 = $6;
 $2 = $30;
 $3 = $31;
 $32 = $2;
 $33 = HEAP32[$32>>2]|0;
 $34 = $3;
 $35 = HEAP32[$34>>2]|0;
 $36 = ($33>>>0)<($35>>>0);
 $37 = $5;
 $38 = $4;
 $39 = $36 ? $37 : $38;
 $40 = HEAP32[$39>>2]|0;
 STACKTOP = sp;return ($40|0);
}
function __ZN6laszip6models10arithmeticC2ERKS1_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $32 = $0;
 $33 = $1;
 $35 = $32;
 $36 = $33;
 $37 = HEAP32[$36>>2]|0;
 HEAP32[$35>>2] = $37;
 $38 = ((($35)) + 4|0);
 $39 = $33;
 $40 = ((($39)) + 4|0);
 $41 = HEAP8[$40>>0]|0;
 $42 = $41&1;
 $43 = $42&1;
 HEAP8[$38>>0] = $43;
 $44 = ((($35)) + 20|0);
 $45 = $33;
 $46 = ((($45)) + 20|0);
 $47 = HEAP32[$46>>2]|0;
 HEAP32[$44>>2] = $47;
 $48 = ((($35)) + 24|0);
 $49 = $33;
 $50 = ((($49)) + 24|0);
 $51 = HEAP32[$50>>2]|0;
 HEAP32[$48>>2] = $51;
 $52 = ((($35)) + 28|0);
 $53 = $33;
 $54 = ((($53)) + 28|0);
 $55 = HEAP32[$54>>2]|0;
 HEAP32[$52>>2] = $55;
 $56 = ((($35)) + 32|0);
 $57 = $33;
 $58 = ((($57)) + 32|0);
 $59 = HEAP32[$58>>2]|0;
 HEAP32[$56>>2] = $59;
 $60 = ((($35)) + 36|0);
 $61 = $33;
 $62 = ((($61)) + 36|0);
 $63 = HEAP32[$62>>2]|0;
 HEAP32[$60>>2] = $63;
 $64 = ((($35)) + 40|0);
 $65 = $33;
 $66 = ((($65)) + 40|0);
 $67 = HEAP32[$66>>2]|0;
 HEAP32[$64>>2] = $67;
 $68 = HEAP32[$35>>2]|0;
 $69 = $68<<2;
 $34 = $69;
 $70 = $34;
 $71 = (__ZN6laszip5utilsL14aligned_mallocEi($70)|0);
 $72 = ((($35)) + 8|0);
 HEAP32[$72>>2] = $71;
 $73 = $33;
 $74 = ((($73)) + 8|0);
 $75 = HEAP32[$74>>2]|0;
 $76 = $33;
 $77 = ((($76)) + 8|0);
 $78 = HEAP32[$77>>2]|0;
 $79 = HEAP32[$35>>2]|0;
 $80 = (($78) + ($79<<2)|0);
 $81 = ((($35)) + 8|0);
 $82 = HEAP32[$81>>2]|0;
 $29 = $75;
 $30 = $80;
 $31 = $82;
 $83 = $29;
 $28 = $83;
 $84 = $28;
 $85 = $30;
 $22 = $85;
 $86 = $22;
 $87 = $31;
 $23 = $87;
 $88 = $23;
 $24 = $84;
 $25 = $86;
 $26 = $88;
 $89 = $25;
 $90 = $24;
 $91 = $89;
 $92 = $90;
 $93 = (($91) - ($92))|0;
 $94 = (($93|0) / 4)&-1;
 $27 = $94;
 $95 = $27;
 $96 = ($95>>>0)>(0);
 if ($96) {
  $97 = $26;
  $98 = $24;
  $99 = $27;
  $100 = $99<<2;
  _memmove(($97|0),($98|0),($100|0))|0;
 }
 $101 = $34;
 $102 = (__ZN6laszip5utilsL14aligned_mallocEi($101)|0);
 $103 = ((($35)) + 12|0);
 HEAP32[$103>>2] = $102;
 $104 = $33;
 $105 = ((($104)) + 12|0);
 $106 = HEAP32[$105>>2]|0;
 $107 = $33;
 $108 = ((($107)) + 12|0);
 $109 = HEAP32[$108>>2]|0;
 $110 = HEAP32[$35>>2]|0;
 $111 = (($109) + ($110<<2)|0);
 $112 = ((($35)) + 12|0);
 $113 = HEAP32[$112>>2]|0;
 $9 = $106;
 $10 = $111;
 $11 = $113;
 $114 = $9;
 $8 = $114;
 $115 = $8;
 $116 = $10;
 $2 = $116;
 $117 = $2;
 $118 = $11;
 $3 = $118;
 $119 = $3;
 $4 = $115;
 $5 = $117;
 $6 = $119;
 $120 = $5;
 $121 = $4;
 $122 = $120;
 $123 = $121;
 $124 = (($122) - ($123))|0;
 $125 = (($124|0) / 4)&-1;
 $7 = $125;
 $126 = $7;
 $127 = ($126>>>0)>(0);
 if ($127) {
  $128 = $6;
  $129 = $4;
  $130 = $7;
  $131 = $130<<2;
  _memmove(($128|0),($129|0),($131|0))|0;
 }
 $132 = ((($35)) + 36|0);
 $133 = HEAP32[$132>>2]|0;
 $134 = ($133|0)!=(0);
 if (!($134)) {
  $172 = ((($35)) + 16|0);
  HEAP32[$172>>2] = 0;
  STACKTOP = sp;return;
 }
 $135 = ((($35)) + 36|0);
 $136 = HEAP32[$135>>2]|0;
 $137 = (($136) + 2)|0;
 $138 = $137<<2;
 $34 = $138;
 $139 = $34;
 $140 = (__ZN6laszip5utilsL14aligned_mallocEi($139)|0);
 $141 = ((($35)) + 16|0);
 HEAP32[$141>>2] = $140;
 $142 = $33;
 $143 = ((($142)) + 16|0);
 $144 = HEAP32[$143>>2]|0;
 $145 = $33;
 $146 = ((($145)) + 16|0);
 $147 = HEAP32[$146>>2]|0;
 $148 = ((($35)) + 36|0);
 $149 = HEAP32[$148>>2]|0;
 $150 = (($149) + 2)|0;
 $151 = (($147) + ($150<<2)|0);
 $152 = ((($35)) + 16|0);
 $153 = HEAP32[$152>>2]|0;
 $19 = $144;
 $20 = $151;
 $21 = $153;
 $154 = $19;
 $18 = $154;
 $155 = $18;
 $156 = $20;
 $12 = $156;
 $157 = $12;
 $158 = $21;
 $13 = $158;
 $159 = $13;
 $14 = $155;
 $15 = $157;
 $16 = $159;
 $160 = $15;
 $161 = $14;
 $162 = $160;
 $163 = $161;
 $164 = (($162) - ($163))|0;
 $165 = (($164|0) / 4)&-1;
 $17 = $165;
 $166 = $17;
 $167 = ($166>>>0)>(0);
 if ($167) {
  $168 = $16;
  $169 = $14;
  $170 = $17;
  $171 = $170<<2;
  _memmove(($168|0),($169|0),($171|0))|0;
 }
 STACKTOP = sp;return;
}
function __ZN6laszip6models10arithmetic6updateEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $14 = 0, $15 = 0, $16 = 0;
 var $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $1 = $0;
 $9 = $1;
 $10 = ((($9)) + 24|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = ((($9)) + 20|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = (($13) + ($11))|0;
 HEAP32[$12>>2] = $14;
 $15 = ($14>>>0)>(32768);
 L1: do {
  if ($15) {
   $16 = ((($9)) + 20|0);
   HEAP32[$16>>2] = 0;
   $2 = 0;
   while(1) {
    $17 = $2;
    $18 = HEAP32[$9>>2]|0;
    $19 = ($17>>>0)<($18>>>0);
    if (!($19)) {
     break L1;
    }
    $20 = ((($9)) + 12|0);
    $21 = HEAP32[$20>>2]|0;
    $22 = $2;
    $23 = (($21) + ($22<<2)|0);
    $24 = HEAP32[$23>>2]|0;
    $25 = (($24) + 1)|0;
    $26 = $25 >>> 1;
    $27 = ((($9)) + 12|0);
    $28 = HEAP32[$27>>2]|0;
    $29 = $2;
    $30 = (($28) + ($29<<2)|0);
    HEAP32[$30>>2] = $26;
    $31 = ((($9)) + 20|0);
    $32 = HEAP32[$31>>2]|0;
    $33 = (($32) + ($26))|0;
    HEAP32[$31>>2] = $33;
    $34 = $2;
    $35 = (($34) + 1)|0;
    $2 = $35;
   }
  }
 } while(0);
 $4 = 0;
 $5 = 0;
 $36 = ((($9)) + 20|0);
 $37 = HEAP32[$36>>2]|0;
 $38 = (2147483648 / ($37>>>0))&-1;
 $6 = $38;
 $39 = ((($9)) + 4|0);
 $40 = HEAP8[$39>>0]|0;
 $41 = $40&1;
 L7: do {
  if ($41) {
   label = 7;
  } else {
   $42 = ((($9)) + 36|0);
   $43 = HEAP32[$42>>2]|0;
   $44 = ($43|0)==(0);
   if ($44) {
    label = 7;
   } else {
    $3 = 0;
    while(1) {
     $65 = $3;
     $66 = HEAP32[$9>>2]|0;
     $67 = ($65>>>0)<($66>>>0);
     if (!($67)) {
      break;
     }
     $68 = $6;
     $69 = $4;
     $70 = Math_imul($68, $69)|0;
     $71 = $70 >>> 16;
     $72 = ((($9)) + 8|0);
     $73 = HEAP32[$72>>2]|0;
     $74 = $3;
     $75 = (($73) + ($74<<2)|0);
     HEAP32[$75>>2] = $71;
     $76 = ((($9)) + 12|0);
     $77 = HEAP32[$76>>2]|0;
     $78 = $3;
     $79 = (($77) + ($78<<2)|0);
     $80 = HEAP32[$79>>2]|0;
     $81 = $4;
     $82 = (($81) + ($80))|0;
     $4 = $82;
     $83 = ((($9)) + 8|0);
     $84 = HEAP32[$83>>2]|0;
     $85 = $3;
     $86 = (($84) + ($85<<2)|0);
     $87 = HEAP32[$86>>2]|0;
     $88 = ((($9)) + 40|0);
     $89 = HEAP32[$88>>2]|0;
     $90 = $87 >>> $89;
     $7 = $90;
     while(1) {
      $91 = $5;
      $92 = $7;
      $93 = ($91>>>0)<($92>>>0);
      $94 = $3;
      if (!($93)) {
       break;
      }
      $95 = (($94) - 1)|0;
      $96 = ((($9)) + 16|0);
      $97 = HEAP32[$96>>2]|0;
      $98 = $5;
      $99 = (($98) + 1)|0;
      $5 = $99;
      $100 = (($97) + ($99<<2)|0);
      HEAP32[$100>>2] = $95;
     }
     $101 = (($94) + 1)|0;
     $3 = $101;
    }
    $102 = ((($9)) + 16|0);
    $103 = HEAP32[$102>>2]|0;
    HEAP32[$103>>2] = 0;
    while(1) {
     $104 = $5;
     $105 = ((($9)) + 36|0);
     $106 = HEAP32[$105>>2]|0;
     $107 = ($104>>>0)<=($106>>>0);
     if (!($107)) {
      break L7;
     }
     $108 = HEAP32[$9>>2]|0;
     $109 = (($108) - 1)|0;
     $110 = ((($9)) + 16|0);
     $111 = HEAP32[$110>>2]|0;
     $112 = $5;
     $113 = (($112) + 1)|0;
     $5 = $113;
     $114 = (($111) + ($113<<2)|0);
     HEAP32[$114>>2] = $109;
    }
   }
  }
 } while(0);
 L21: do {
  if ((label|0) == 7) {
   $3 = 0;
   while(1) {
    $45 = $3;
    $46 = HEAP32[$9>>2]|0;
    $47 = ($45>>>0)<($46>>>0);
    if (!($47)) {
     break L21;
    }
    $48 = $6;
    $49 = $4;
    $50 = Math_imul($48, $49)|0;
    $51 = $50 >>> 16;
    $52 = ((($9)) + 8|0);
    $53 = HEAP32[$52>>2]|0;
    $54 = $3;
    $55 = (($53) + ($54<<2)|0);
    HEAP32[$55>>2] = $51;
    $56 = ((($9)) + 12|0);
    $57 = HEAP32[$56>>2]|0;
    $58 = $3;
    $59 = (($57) + ($58<<2)|0);
    $60 = HEAP32[$59>>2]|0;
    $61 = $4;
    $62 = (($61) + ($60))|0;
    $4 = $62;
    $63 = $3;
    $64 = (($63) + 1)|0;
    $3 = $64;
   }
  }
 } while(0);
 $115 = ((($9)) + 24|0);
 $116 = HEAP32[$115>>2]|0;
 $117 = ($116*5)|0;
 $118 = $117 >>> 2;
 $119 = ((($9)) + 24|0);
 HEAP32[$119>>2] = $118;
 $120 = HEAP32[$9>>2]|0;
 $121 = (($120) + 6)|0;
 $122 = $121 << 3;
 $8 = $122;
 $123 = ((($9)) + 24|0);
 $124 = HEAP32[$123>>2]|0;
 $125 = $8;
 $126 = ($124>>>0)>($125>>>0);
 if (!($126)) {
  $129 = ((($9)) + 24|0);
  $130 = HEAP32[$129>>2]|0;
  $131 = ((($9)) + 28|0);
  HEAP32[$131>>2] = $130;
  STACKTOP = sp;return;
 }
 $127 = $8;
 $128 = ((($9)) + 24|0);
 HEAP32[$128>>2] = $127;
 $129 = ((($9)) + 24|0);
 $130 = HEAP32[$129>>2]|0;
 $131 = ((($9)) + 28|0);
 HEAP32[$131>>2] = $130;
 STACKTOP = sp;return;
}
function __ZN6laszip13decompressors7integer13readCorrectorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS_6models10arithmeticEEEiRT_RT0_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $7 = $0;
 $8 = $1;
 $9 = $2;
 $13 = $7;
 $14 = $8;
 $15 = $9;
 $16 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($14,$15)|0);
 HEAP32[$13>>2] = $16;
 $17 = HEAP32[$13>>2]|0;
 $18 = ($17|0)!=(0);
 if (!($18)) {
  $69 = $8;
  $70 = ((($13)) + 48|0);
  $71 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE9decodeBitINS_6models14arithmetic_bitEEEjRT_($69,$70)|0);
  $10 = $71;
  $72 = $10;
  STACKTOP = sp;return ($72|0);
 }
 $19 = HEAP32[$13>>2]|0;
 $20 = ($19>>>0)<(32);
 if (!($20)) {
  $67 = ((($13)) + 28|0);
  $68 = HEAP32[$67>>2]|0;
  $10 = $68;
  $72 = $10;
  STACKTOP = sp;return ($72|0);
 }
 $21 = HEAP32[$13>>2]|0;
 $22 = ((($13)) + 12|0);
 $23 = HEAP32[$22>>2]|0;
 $24 = ($21>>>0)<=($23>>>0);
 if ($24) {
  $25 = $8;
  $26 = ((($13)) + 68|0);
  $27 = HEAP32[$13>>2]|0;
  $28 = (($27) - 1)|0;
  $5 = $26;
  $6 = $28;
  $29 = $5;
  $30 = HEAP32[$29>>2]|0;
  $31 = $6;
  $32 = (($30) + (($31*44)|0)|0);
  $33 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($25,$32)|0);
  $10 = $33;
 } else {
  $34 = HEAP32[$13>>2]|0;
  $35 = ((($13)) + 12|0);
  $36 = HEAP32[$35>>2]|0;
  $37 = (($34) - ($36))|0;
  $11 = $37;
  $38 = $8;
  $39 = ((($13)) + 68|0);
  $40 = HEAP32[$13>>2]|0;
  $41 = (($40) - 1)|0;
  $3 = $39;
  $4 = $41;
  $42 = $3;
  $43 = HEAP32[$42>>2]|0;
  $44 = $4;
  $45 = (($43) + (($44*44)|0)|0);
  $46 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($38,$45)|0);
  $10 = $46;
  $47 = $8;
  $48 = $11;
  $49 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE8readBitsEj($47,$48)|0);
  $12 = $49;
  $50 = $10;
  $51 = $11;
  $52 = $50 << $51;
  $53 = $12;
  $54 = $52 | $53;
  $10 = $54;
 }
 $55 = $10;
 $56 = HEAP32[$13>>2]|0;
 $57 = (($56) - 1)|0;
 $58 = 1 << $57;
 $59 = ($55|0)>=($58|0);
 if ($59) {
  $60 = $10;
  $61 = (($60) + 1)|0;
  $10 = $61;
  $72 = $10;
  STACKTOP = sp;return ($72|0);
 } else {
  $62 = HEAP32[$13>>2]|0;
  $63 = 1 << $62;
  $64 = (($63) - 1)|0;
  $65 = $10;
  $66 = (($65) - ($64))|0;
  $10 = $66;
  $72 = $10;
  STACKTOP = sp;return ($72|0);
 }
 return (0)|0;
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $2 = $0;
 $3 = $1;
 $13 = $2;
 $14 = ((($13)) + 8|0);
 $15 = HEAP32[$14>>2]|0;
 $7 = $15;
 $16 = $3;
 $17 = ((($16)) + 16|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18|0)!=(0|0);
 if ($19) {
  $20 = ((($13)) + 4|0);
  $21 = HEAP32[$20>>2]|0;
  $22 = ((($13)) + 8|0);
  $23 = HEAP32[$22>>2]|0;
  $24 = $23 >>> 15;
  HEAP32[$22>>2] = $24;
  $25 = (($21>>>0) / ($24>>>0))&-1;
  $8 = $25;
  $26 = $8;
  $27 = $3;
  $28 = ((($27)) + 40|0);
  $29 = HEAP32[$28>>2]|0;
  $30 = $26 >>> $29;
  $9 = $30;
  $31 = $3;
  $32 = ((($31)) + 16|0);
  $33 = HEAP32[$32>>2]|0;
  $34 = $9;
  $35 = (($33) + ($34<<2)|0);
  $36 = HEAP32[$35>>2]|0;
  $5 = $36;
  $37 = $3;
  $38 = ((($37)) + 16|0);
  $39 = HEAP32[$38>>2]|0;
  $40 = $9;
  $41 = (($40) + 1)|0;
  $42 = (($39) + ($41<<2)|0);
  $43 = HEAP32[$42>>2]|0;
  $44 = (($43) + 1)|0;
  $4 = $44;
  while(1) {
   $45 = $4;
   $46 = $5;
   $47 = (($46) + 1)|0;
   $48 = ($45>>>0)>($47>>>0);
   if (!($48)) {
    break;
   }
   $49 = $5;
   $50 = $4;
   $51 = (($49) + ($50))|0;
   $52 = $51 >>> 1;
   $10 = $52;
   $53 = $3;
   $54 = ((($53)) + 8|0);
   $55 = HEAP32[$54>>2]|0;
   $56 = $10;
   $57 = (($55) + ($56<<2)|0);
   $58 = HEAP32[$57>>2]|0;
   $59 = $8;
   $60 = ($58>>>0)>($59>>>0);
   $61 = $10;
   if ($60) {
    $4 = $61;
   } else {
    $5 = $61;
   }
  }
  $62 = $3;
  $63 = ((($62)) + 8|0);
  $64 = HEAP32[$63>>2]|0;
  $65 = $5;
  $66 = (($64) + ($65<<2)|0);
  $67 = HEAP32[$66>>2]|0;
  $68 = ((($13)) + 8|0);
  $69 = HEAP32[$68>>2]|0;
  $70 = Math_imul($67, $69)|0;
  $6 = $70;
  $71 = $5;
  $72 = $3;
  $73 = ((($72)) + 32|0);
  $74 = HEAP32[$73>>2]|0;
  $75 = ($71|0)!=($74|0);
  if ($75) {
   $76 = $3;
   $77 = ((($76)) + 8|0);
   $78 = HEAP32[$77>>2]|0;
   $79 = $5;
   $80 = (($79) + 1)|0;
   $81 = (($78) + ($80<<2)|0);
   $82 = HEAP32[$81>>2]|0;
   $83 = ((($13)) + 8|0);
   $84 = HEAP32[$83>>2]|0;
   $85 = Math_imul($82, $84)|0;
   $7 = $85;
  }
 } else {
  $5 = 0;
  $6 = 0;
  $86 = ((($13)) + 8|0);
  $87 = HEAP32[$86>>2]|0;
  $88 = $87 >>> 15;
  HEAP32[$86>>2] = $88;
  $89 = $3;
  $90 = HEAP32[$89>>2]|0;
  $4 = $90;
  $91 = $90 >>> 1;
  $11 = $91;
  while(1) {
   $92 = ((($13)) + 8|0);
   $93 = HEAP32[$92>>2]|0;
   $94 = $3;
   $95 = ((($94)) + 8|0);
   $96 = HEAP32[$95>>2]|0;
   $97 = $11;
   $98 = (($96) + ($97<<2)|0);
   $99 = HEAP32[$98>>2]|0;
   $100 = Math_imul($93, $99)|0;
   $12 = $100;
   $101 = $12;
   $102 = ((($13)) + 4|0);
   $103 = HEAP32[$102>>2]|0;
   $104 = ($101>>>0)>($103>>>0);
   $105 = $11;
   if ($104) {
    $4 = $105;
    $106 = $12;
    $7 = $106;
   } else {
    $5 = $105;
    $107 = $12;
    $6 = $107;
   }
   $108 = $5;
   $109 = $4;
   $110 = (($108) + ($109))|0;
   $111 = $110 >>> 1;
   $11 = $111;
   $112 = $5;
   $113 = ($111|0)!=($112|0);
   if (!($113)) {
    break;
   }
  }
 }
 $114 = $6;
 $115 = ((($13)) + 4|0);
 $116 = HEAP32[$115>>2]|0;
 $117 = (($116) - ($114))|0;
 HEAP32[$115>>2] = $117;
 $118 = $7;
 $119 = $6;
 $120 = (($118) - ($119))|0;
 $121 = ((($13)) + 8|0);
 HEAP32[$121>>2] = $120;
 $122 = ((($13)) + 8|0);
 $123 = HEAP32[$122>>2]|0;
 $124 = ($123>>>0)<(16777216);
 if ($124) {
  __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE19renorm_dec_intervalEv($13);
 }
 $125 = $3;
 $126 = ((($125)) + 12|0);
 $127 = HEAP32[$126>>2]|0;
 $128 = $5;
 $129 = (($127) + ($128<<2)|0);
 $130 = HEAP32[$129>>2]|0;
 $131 = (($130) + 1)|0;
 HEAP32[$129>>2] = $131;
 $132 = $3;
 $133 = ((($132)) + 28|0);
 $134 = HEAP32[$133>>2]|0;
 $135 = (($134) + -1)|0;
 HEAP32[$133>>2] = $135;
 $136 = ($135|0)==(0);
 if (!($136)) {
  $138 = $5;
  STACKTOP = sp;return ($138|0);
 }
 $137 = $3;
 __ZN6laszip6models10arithmetic6updateEv($137);
 $138 = $5;
 STACKTOP = sp;return ($138|0);
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE8readBitsEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $3 = $0;
 $4 = $1;
 $8 = $3;
 $9 = $4;
 $10 = ($9|0)!=(0);
 $11 = $4;
 $12 = ($11>>>0)<=(32);
 $or$cond = $10 & $12;
 if (!($or$cond)) {
  ___assert_fail((5409|0),(5430|0),139,(5499|0));
  // unreachable;
 }
 $13 = $4;
 $14 = ($13>>>0)>(19);
 if ($14) {
  $15 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE9readShortEv($8)|0);
  $16 = $15&65535;
  $5 = $16;
  $17 = $4;
  $18 = (($17) - 16)|0;
  $4 = $18;
  $19 = $4;
  $20 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE8readBitsEj($8,$19)|0);
  $21 = $20 << 16;
  $6 = $21;
  $22 = $6;
  $23 = $5;
  $24 = $22 | $23;
  $2 = $24;
  $43 = $2;
  STACKTOP = sp;return ($43|0);
 }
 $25 = ((($8)) + 4|0);
 $26 = HEAP32[$25>>2]|0;
 $27 = $4;
 $28 = ((($8)) + 8|0);
 $29 = HEAP32[$28>>2]|0;
 $30 = $29 >>> $27;
 HEAP32[$28>>2] = $30;
 $31 = (($26>>>0) / ($30>>>0))&-1;
 $7 = $31;
 $32 = ((($8)) + 8|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = $7;
 $35 = Math_imul($33, $34)|0;
 $36 = ((($8)) + 4|0);
 $37 = HEAP32[$36>>2]|0;
 $38 = (($37) - ($35))|0;
 HEAP32[$36>>2] = $38;
 $39 = ((($8)) + 8|0);
 $40 = HEAP32[$39>>2]|0;
 $41 = ($40>>>0)<(16777216);
 if ($41) {
  __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE19renorm_dec_intervalEv($8);
 }
 $42 = $7;
 $2 = $42;
 $43 = $2;
 STACKTOP = sp;return ($43|0);
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE9decodeBitINS_6models14arithmetic_bitEEEjRT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $6 = $2;
 $7 = $3;
 $8 = ((($7)) + 8|0);
 $9 = HEAP32[$8>>2]|0;
 $10 = ((($6)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = $11 >>> 13;
 $13 = Math_imul($9, $12)|0;
 $4 = $13;
 $14 = ((($6)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $4;
 $17 = ($15>>>0)>=($16>>>0);
 $18 = $17&1;
 $5 = $18;
 $19 = $5;
 $20 = ($19|0)==(0);
 $21 = $4;
 if ($20) {
  $22 = ((($6)) + 8|0);
  HEAP32[$22>>2] = $21;
  $23 = $3;
  $24 = ((($23)) + 12|0);
  $25 = HEAP32[$24>>2]|0;
  $26 = (($25) + 1)|0;
  HEAP32[$24>>2] = $26;
 } else {
  $27 = ((($6)) + 4|0);
  $28 = HEAP32[$27>>2]|0;
  $29 = (($28) - ($21))|0;
  HEAP32[$27>>2] = $29;
  $30 = $4;
  $31 = ((($6)) + 8|0);
  $32 = HEAP32[$31>>2]|0;
  $33 = (($32) - ($30))|0;
  HEAP32[$31>>2] = $33;
 }
 $34 = ((($6)) + 8|0);
 $35 = HEAP32[$34>>2]|0;
 $36 = ($35>>>0)<(16777216);
 if ($36) {
  __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE19renorm_dec_intervalEv($6);
 }
 $37 = $3;
 $38 = ((($37)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $40 = (($39) + -1)|0;
 HEAP32[$38>>2] = $40;
 $41 = ($40|0)==(0);
 if (!($41)) {
  $43 = $5;
  STACKTOP = sp;return ($43|0);
 }
 $42 = $3;
 __ZN6laszip6models14arithmetic_bit6updateEv($42);
 $43 = $5;
 STACKTOP = sp;return ($43|0);
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE19renorm_dec_intervalEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 while(1) {
  $3 = ((($2)) + 4|0);
  $4 = HEAP32[$3>>2]|0;
  $5 = $4 << 8;
  $6 = HEAP32[$2>>2]|0;
  $7 = (__ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7getByteEv($6)|0);
  $8 = $7&255;
  $9 = $5 | $8;
  $10 = ((($2)) + 4|0);
  HEAP32[$10>>2] = $9;
  $11 = ((($2)) + 8|0);
  $12 = HEAP32[$11>>2]|0;
  $13 = $12 << 8;
  HEAP32[$11>>2] = $13;
  $14 = ($13>>>0)<(16777216);
  if (!($14)) {
   break;
  }
 }
 STACKTOP = sp;return;
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE9readShortEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $3 = $1;
 $4 = ((($3)) + 4|0);
 $5 = HEAP32[$4>>2]|0;
 $6 = ((($3)) + 8|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $7 >>> 16;
 HEAP32[$6>>2] = $8;
 $9 = (($5>>>0) / ($8>>>0))&-1;
 $2 = $9;
 $10 = ((($3)) + 8|0);
 $11 = HEAP32[$10>>2]|0;
 $12 = $2;
 $13 = Math_imul($11, $12)|0;
 $14 = ((($3)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = (($15) - ($13))|0;
 HEAP32[$14>>2] = $16;
 $17 = ((($3)) + 8|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18>>>0)<(16777216);
 if ($19) {
  __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE19renorm_dec_intervalEv($3);
 }
 $20 = $2;
 $21 = ($20>>>0)<(65536);
 if ($21) {
  $22 = $2;
  $23 = $22&65535;
  STACKTOP = sp;return ($23|0);
 } else {
  ___assert_fail((5508|0),(5430|0),172,(5522|0));
  // unreachable;
 }
 return (0)|0;
}
function __ZN6laszip6models14arithmetic_bit6updateEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $3 = $1;
 $4 = HEAP32[$3>>2]|0;
 $5 = ((($3)) + 16|0);
 $6 = HEAP32[$5>>2]|0;
 $7 = (($6) + ($4))|0;
 HEAP32[$5>>2] = $7;
 $8 = ($7>>>0)>(8192);
 if ($8) {
  $9 = ((($3)) + 16|0);
  $10 = HEAP32[$9>>2]|0;
  $11 = (($10) + 1)|0;
  $12 = $11 >>> 1;
  $13 = ((($3)) + 16|0);
  HEAP32[$13>>2] = $12;
  $14 = ((($3)) + 12|0);
  $15 = HEAP32[$14>>2]|0;
  $16 = (($15) + 1)|0;
  $17 = $16 >>> 1;
  $18 = ((($3)) + 12|0);
  HEAP32[$18>>2] = $17;
  $19 = ((($3)) + 12|0);
  $20 = HEAP32[$19>>2]|0;
  $21 = ((($3)) + 16|0);
  $22 = HEAP32[$21>>2]|0;
  $23 = ($20|0)==($22|0);
  if ($23) {
   $24 = ((($3)) + 16|0);
   $25 = HEAP32[$24>>2]|0;
   $26 = (($25) + 1)|0;
   HEAP32[$24>>2] = $26;
  }
 }
 $27 = ((($3)) + 16|0);
 $28 = HEAP32[$27>>2]|0;
 $29 = (2147483648 / ($28>>>0))&-1;
 $2 = $29;
 $30 = ((($3)) + 12|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = $2;
 $33 = Math_imul($31, $32)|0;
 $34 = $33 >>> 18;
 $35 = ((($3)) + 8|0);
 HEAP32[$35>>2] = $34;
 $36 = HEAP32[$3>>2]|0;
 $37 = ($36*5)|0;
 $38 = $37 >>> 2;
 HEAP32[$3>>2] = $38;
 $39 = HEAP32[$3>>2]|0;
 $40 = ($39>>>0)>(64);
 if (!($40)) {
  $41 = HEAP32[$3>>2]|0;
  $42 = ((($3)) + 4|0);
  HEAP32[$42>>2] = $41;
  STACKTOP = sp;return;
 }
 HEAP32[$3>>2] = 64;
 $41 = HEAP32[$3>>2]|0;
 $42 = ((($3)) + 4|0);
 HEAP32[$42>>2] = $41;
 STACKTOP = sp;return;
}
function __ZN6laszip2io6reader10basic_fileINS_7streams13memory_streamEE9readPointEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0;
 var $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0;
 var $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0;
 var $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0;
 var $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0;
 var $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0;
 var $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0;
 var $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0;
 var $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 368|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(368|0);
 $$byval_copy = sp + 356|0;
 $7 = sp + 332|0;
 $13 = sp + 308|0;
 $21 = sp + 272|0;
 $28 = sp + 240|0;
 $34 = sp + 216|0;
 $39 = sp + 192|0;
 $40 = sp + 184|0;
 $46 = sp + 160|0;
 $52 = sp + 136|0;
 $57 = sp + 112|0;
 $63 = sp + 88|0;
 $69 = sp + 64|0;
 $74 = sp + 40|0;
 $82 = sp;
 $80 = $0;
 $81 = $1;
 $83 = $80;
 $84 = ((($83)) + 328|0);
 $85 = ((($84)) + 8|0);
 $86 = $85;
 $87 = $86;
 $88 = HEAP32[$87>>2]|0;
 $89 = (($86) + 4)|0;
 $90 = $89;
 $91 = HEAP32[$90>>2]|0;
 $92 = ((($83)) + 247|0);
 $93 = ((($92)) + 12|0);
 $94 = HEAPU8[$93>>0]|(HEAPU8[$93+1>>0]<<8)|(HEAPU8[$93+2>>0]<<16)|(HEAPU8[$93+3>>0]<<24);
 $95 = ($88|0)==($94|0);
 $96 = ($91|0)==(0);
 $97 = $95 & $96;
 if (!($97)) {
  $98 = ((($83)) + 320|0);
  $79 = $98;
  $99 = $79;
  $78 = $99;
  $100 = $78;
  $101 = HEAP32[$100>>2]|0;
  $102 = ($101|0)!=(0|0);
  if ($102) {
   $103 = ((($83)) + 312|0);
   $77 = $103;
   $104 = $77;
   $76 = $104;
   $105 = $76;
   $106 = HEAP32[$105>>2]|0;
   $107 = ($106|0)!=(0|0);
   if ($107) {
    $258 = ((($83)) + 320|0);
    $75 = $258;
    $259 = $75;
    $260 = HEAP32[$259>>2]|0;
    $261 = HEAP32[$260>>2]|0;
    $262 = HEAP32[$261>>2]|0;
    $263 = $81;
    (FUNCTION_TABLE_iii[$262 & 255]($260,$263)|0);
    $264 = ((($83)) + 328|0);
    $265 = ((($264)) + 8|0);
    $266 = $265;
    $267 = $266;
    $268 = HEAP32[$267>>2]|0;
    $269 = (($266) + 4)|0;
    $270 = $269;
    $271 = HEAP32[$270>>2]|0;
    $272 = (_i64Add(($268|0),($271|0),1,0)|0);
    $273 = tempRet0;
    $274 = $265;
    $275 = $274;
    HEAP32[$275>>2] = $272;
    $276 = (($274) + 4)|0;
    $277 = $276;
    HEAP32[$277>>2] = $273;
    STACKTOP = sp;return;
   }
  }
 }
 $108 = ((($83)) + 320|0);
 $73 = $108;
 $109 = $73;
 $72 = $74;
 $110 = $72;
 HEAP32[$110>>2] = 0;
 $111 = ((($110)) + 4|0);
 HEAP32[$111>>2] = 0;
 $70 = $74;
 $71 = $109;
 $112 = $70;
 $113 = $71;
 $67 = $112;
 $68 = $113;
 $114 = $67;
 $66 = $114;
 $115 = $66;
 $116 = HEAP32[$115>>2]|0;
 HEAP32[$69>>2] = $116;
 $117 = $68;
 $64 = $117;
 $118 = $64;
 $119 = HEAP32[$118>>2]|0;
 $120 = $67;
 HEAP32[$120>>2] = $119;
 $65 = $69;
 $121 = $65;
 $122 = HEAP32[$121>>2]|0;
 $123 = $68;
 HEAP32[$123>>2] = $122;
 $124 = ((($112)) + 4|0);
 $125 = $71;
 $126 = ((($125)) + 4|0);
 $61 = $124;
 $62 = $126;
 $127 = $61;
 $60 = $127;
 $128 = $60;
 $129 = HEAP32[$128>>2]|0;
 HEAP32[$63>>2] = $129;
 $130 = $62;
 $58 = $130;
 $131 = $58;
 $132 = HEAP32[$131>>2]|0;
 $133 = $61;
 HEAP32[$133>>2] = $132;
 $59 = $63;
 $134 = $59;
 $135 = HEAP32[$134>>2]|0;
 $136 = $62;
 HEAP32[$136>>2] = $135;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEED2Ev($74);
 $137 = ((($83)) + 312|0);
 $56 = $137;
 $138 = $56;
 $55 = $57;
 $139 = $55;
 HEAP32[$139>>2] = 0;
 $140 = ((($139)) + 4|0);
 HEAP32[$140>>2] = 0;
 $53 = $57;
 $54 = $138;
 $141 = $53;
 $142 = $54;
 $50 = $141;
 $51 = $142;
 $143 = $50;
 $49 = $143;
 $144 = $49;
 $145 = HEAP32[$144>>2]|0;
 HEAP32[$52>>2] = $145;
 $146 = $51;
 $47 = $146;
 $147 = $47;
 $148 = HEAP32[$147>>2]|0;
 $149 = $50;
 HEAP32[$149>>2] = $148;
 $48 = $52;
 $150 = $48;
 $151 = HEAP32[$150>>2]|0;
 $152 = $51;
 HEAP32[$152>>2] = $151;
 $153 = ((($141)) + 4|0);
 $154 = $54;
 $155 = ((($154)) + 4|0);
 $44 = $153;
 $45 = $155;
 $156 = $44;
 $43 = $156;
 $157 = $43;
 $158 = HEAP32[$157>>2]|0;
 HEAP32[$46>>2] = $158;
 $159 = $45;
 $41 = $159;
 $160 = $41;
 $161 = HEAP32[$160>>2]|0;
 $162 = $44;
 HEAP32[$162>>2] = $161;
 $42 = $46;
 $163 = $42;
 $164 = HEAP32[$163>>2]|0;
 $165 = $45;
 HEAP32[$165>>2] = $164;
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEED2Ev($57);
 $166 = ((($83)) + 312|0);
 $167 = (__Znwj(12)|0);
 $168 = ((($83)) + 4|0);
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEC2ERS6_($167,$168);
 $37 = $166;
 $38 = $167;
 $169 = $37;
 $170 = $38;
 ;HEAP32[$40>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$40>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEC2IS9_EEPT_NS_9enable_ifIXsr14is_convertibleISD_PS9_EE5valueENSA_5__natEE4typeE($39,$170,$$byval_copy);
 $35 = $39;
 $36 = $169;
 $171 = $35;
 $172 = $36;
 $32 = $171;
 $33 = $172;
 $173 = $32;
 $31 = $173;
 $174 = $31;
 $175 = HEAP32[$174>>2]|0;
 HEAP32[$34>>2] = $175;
 $176 = $33;
 $29 = $176;
 $177 = $29;
 $178 = HEAP32[$177>>2]|0;
 $179 = $32;
 HEAP32[$179>>2] = $178;
 $30 = $34;
 $180 = $30;
 $181 = HEAP32[$180>>2]|0;
 $182 = $33;
 HEAP32[$182>>2] = $181;
 $183 = ((($171)) + 4|0);
 $184 = $36;
 $185 = ((($184)) + 4|0);
 $26 = $183;
 $27 = $185;
 $186 = $26;
 $25 = $186;
 $187 = $25;
 $188 = HEAP32[$187>>2]|0;
 HEAP32[$28>>2] = $188;
 $189 = $27;
 $23 = $189;
 $190 = $23;
 $191 = HEAP32[$190>>2]|0;
 $192 = $26;
 HEAP32[$192>>2] = $191;
 $24 = $28;
 $193 = $24;
 $194 = HEAP32[$193>>2]|0;
 $195 = $27;
 HEAP32[$195>>2] = $194;
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEED2Ev($39);
 $196 = ((($83)) + 312|0);
 $22 = $196;
 $197 = $22;
 $198 = HEAP32[$197>>2]|0;
 $199 = ((($83)) + 300|0);
 __ZN6laszip7factory18build_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEENSt3__210shared_ptrINS_7formats20dynamic_decompressorEEERT_RKNS0_13record_schemaE($82,$198,$199);
 $200 = ((($83)) + 320|0);
 $19 = $200;
 $20 = $82;
 $201 = $19;
 $202 = $20;
 $18 = $202;
 $203 = $18;
 $16 = $21;
 $17 = $203;
 $204 = $16;
 $205 = $17;
 $206 = HEAP32[$205>>2]|0;
 HEAP32[$204>>2] = $206;
 $207 = ((($204)) + 4|0);
 $208 = $17;
 $209 = ((($208)) + 4|0);
 $210 = HEAP32[$209>>2]|0;
 HEAP32[$207>>2] = $210;
 $211 = $17;
 HEAP32[$211>>2] = 0;
 $212 = $17;
 $213 = ((($212)) + 4|0);
 HEAP32[$213>>2] = 0;
 $14 = $21;
 $15 = $201;
 $214 = $14;
 $215 = $15;
 $11 = $214;
 $12 = $215;
 $216 = $11;
 $10 = $216;
 $217 = $10;
 $218 = HEAP32[$217>>2]|0;
 HEAP32[$13>>2] = $218;
 $219 = $12;
 $8 = $219;
 $220 = $8;
 $221 = HEAP32[$220>>2]|0;
 $222 = $11;
 HEAP32[$222>>2] = $221;
 $9 = $13;
 $223 = $9;
 $224 = HEAP32[$223>>2]|0;
 $225 = $12;
 HEAP32[$225>>2] = $224;
 $226 = ((($214)) + 4|0);
 $227 = $15;
 $228 = ((($227)) + 4|0);
 $5 = $226;
 $6 = $228;
 $229 = $5;
 $4 = $229;
 $230 = $4;
 $231 = HEAP32[$230>>2]|0;
 HEAP32[$7>>2] = $231;
 $232 = $6;
 $2 = $232;
 $233 = $2;
 $234 = HEAP32[$233>>2]|0;
 $235 = $5;
 HEAP32[$235>>2] = $234;
 $3 = $7;
 $236 = $3;
 $237 = HEAP32[$236>>2]|0;
 $238 = $6;
 HEAP32[$238>>2] = $237;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEED2Ev($21);
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEED2Ev($82);
 $239 = ((($83)) + 328|0);
 $240 = $239;
 $241 = $240;
 $242 = HEAP32[$241>>2]|0;
 $243 = (($240) + 4)|0;
 $244 = $243;
 $245 = HEAP32[$244>>2]|0;
 $246 = (_i64Add(($242|0),($245|0),1,0)|0);
 $247 = tempRet0;
 $248 = $239;
 $249 = $248;
 HEAP32[$249>>2] = $246;
 $250 = (($248) + 4)|0;
 $251 = $250;
 HEAP32[$251>>2] = $247;
 $252 = ((($83)) + 328|0);
 $253 = ((($252)) + 8|0);
 $254 = $253;
 $255 = $254;
 HEAP32[$255>>2] = 0;
 $256 = (($254) + 4)|0;
 $257 = $256;
 HEAP32[$257>>2] = 0;
 $258 = ((($83)) + 320|0);
 $75 = $258;
 $259 = $75;
 $260 = HEAP32[$259>>2]|0;
 $261 = HEAP32[$260>>2]|0;
 $262 = HEAP32[$261>>2]|0;
 $263 = $81;
 (FUNCTION_TABLE_iii[$262 & 255]($260,$263)|0);
 $264 = ((($83)) + 328|0);
 $265 = ((($264)) + 8|0);
 $266 = $265;
 $267 = $266;
 $268 = HEAP32[$267>>2]|0;
 $269 = (($266) + 4)|0;
 $270 = $269;
 $271 = HEAP32[$270>>2]|0;
 $272 = (_i64Add(($268|0),($271|0),1,0)|0);
 $273 = tempRet0;
 $274 = $265;
 $275 = $274;
 HEAP32[$275>>2] = $272;
 $276 = (($274) + 4)|0;
 $277 = $276;
 HEAP32[$277>>2] = $273;
 STACKTOP = sp;return;
}
function __ZN6laszip7factory18build_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEENSt3__210shared_ptrINS_7formats20dynamic_decompressorEEERT_RKNS0_13record_schemaE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $7 = 0, $8 = 0, $9 = 0, $or$cond = 0, $or$cond3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $5 = sp;
 $15 = sp + 64|0;
 $16 = sp + 8|0;
 $17 = sp + 4|0;
 $11 = $1;
 $12 = $2;
 $18 = $12;
 $19 = (__ZNK6laszip7factory13record_schema6formatEv($18)|0);
 $13 = $19;
 $20 = $13;
 $21 = ($20|0)==(-1);
 if ($21) {
  $22 = (___cxa_allocate_exception(8)|0);
  __ZN6laszip19unknown_schema_typeC2Ev($22);
  ___cxa_throw(($22|0),(256|0),(47|0));
  // unreachable;
 }
 $23 = $12;
 $24 = (__ZNK6laszip7factory13record_schema10extrabytesEv($23)|0);
 $14 = $24;
 $25 = $14;
 $26 = ($25|0)!=(0);
 if ($26) {
  $27 = $11;
  __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEENS0_26dynamic_field_decompressorIT_E3ptrERSB_($15,$27);
  $10 = $15;
  $28 = $10;
  $29 = HEAP32[$28>>2]|0;
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_3las7point10EEEvv($29);
  $30 = $13;
  $31 = ($30|0)==(1);
  $32 = $13;
  $33 = ($32|0)==(3);
  $or$cond = $31 | $33;
  if ($or$cond) {
   $8 = $15;
   $34 = $8;
   $35 = HEAP32[$34>>2]|0;
   __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_3las7gpstimeEEEvv($35);
  }
  $36 = $13;
  $37 = ($36|0)==(2);
  $38 = $13;
  $39 = ($38|0)==(3);
  $or$cond3 = $37 | $39;
  if ($or$cond3) {
   $7 = $15;
   $40 = $7;
   $41 = HEAP32[$40>>2]|0;
   __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_3las3rgbEEEvv($41);
  }
  $6 = $15;
  $42 = $6;
  $43 = HEAP32[$42>>2]|0;
  $44 = $14;
  __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEEC2Ej($16,$44);
  __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISE_EEEEEEvRKT_($43,$16);
  __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEED2Ev($16);
  ;HEAP32[$17>>2]=0|0;
  ;HEAP8[$5>>0]=HEAP8[$17>>0]|0;HEAP8[$5+1>>0]=HEAP8[$17+1>>0]|0;HEAP8[$5+2>>0]=HEAP8[$17+2>>0]|0;HEAP8[$5+3>>0]=HEAP8[$17+3>>0]|0;
  $3 = $0;
  $4 = $15;
  $45 = $3;
  $46 = $4;
  $47 = HEAP32[$46>>2]|0;
  HEAP32[$45>>2] = $47;
  $48 = ((($45)) + 4|0);
  $49 = $4;
  $50 = ((($49)) + 4|0);
  $51 = HEAP32[$50>>2]|0;
  HEAP32[$48>>2] = $51;
  $52 = $4;
  HEAP32[$52>>2] = 0;
  $53 = $4;
  $54 = ((($53)) + 4|0);
  HEAP32[$54>>2] = 0;
  __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEEED2Ev($15);
  STACKTOP = sp;return;
 }
 $55 = $13;
 switch ($55|0) {
 case 0:  {
  $56 = $11;
  $57 = (__Znwj(4788)|0);
  __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEEEEC2Ev($57);
  __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$56,$57);
  STACKTOP = sp;return;
  break;
 }
 case 1:  {
  $58 = $11;
  $59 = (__Znwj(5116)|0);
  __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEEEEC2Ev($59);
  __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$58,$59);
  STACKTOP = sp;return;
  break;
 }
 case 2:  {
  $60 = $11;
  $61 = (__Znwj(5104)|0);
  __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEEC2Ev($61);
  __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$60,$61);
  STACKTOP = sp;return;
  break;
 }
 case 3:  {
  $62 = $11;
  $63 = (__Znwj(5432)|0);
  __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEENS2_INS3_3rgbENS5_ISB_EEEEEEC2Ev($63);
  __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$62,$63);
  STACKTOP = sp;return;
  break;
 }
 default: {
  $9 = $0;
  $64 = $9;
  HEAP32[$64>>2] = 0;
  $65 = ((($64)) + 4|0);
  HEAP32[$65>>2] = 0;
  STACKTOP = sp;return;
 }
 }
}
function __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEC2IS9_EEPT_NS_9enable_ifIXsr14is_convertibleISD_PS9_EE5valueENSA_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0;
 var $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0;
 var $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0;
 var $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0;
 var $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $50 = sp + 76|0;
 $51 = sp + 72|0;
 $52 = sp + 8|0;
 $53 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$52>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$53>>0]=HEAP8[$66>>0]|0;
 $49 = $79;
 HEAP32[$50>>2] = $80;
 $81 = $49;
 $47 = $81;
 $48 = 0;
 $82 = $47;
 $83 = $48;
 $45 = $82;
 $46 = $83;
 $84 = $45;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $46;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $48;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (1908);
 $89 = ((($81)) + 12|0);
 $21 = $53;
 $90 = $21;
 $30 = $51;
 $31 = $50;
 $32 = $90;
 $91 = $30;
 $92 = $31;
 $29 = $92;
 $93 = $29;
 $23 = $91;
 $24 = $93;
 $94 = $23;
 $95 = $24;
 $22 = $95;
 $96 = $22;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $32;
 $25 = $98;
 $99 = $25;
 $27 = $91;
 $28 = $99;
 $100 = $28;
 $26 = $100;
 $33 = $52;
 $101 = $33;
 $42 = $89;
 $43 = $51;
 $44 = $101;
 $102 = $42;
 $103 = $43;
 $41 = $103;
 $104 = $41;
 $35 = $102;
 $36 = $104;
 $105 = $35;
 $106 = $36;
 $34 = $106;
 $107 = $34;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $44;
 $37 = $108;
 $109 = $37;
 $39 = $102;
 $40 = $109;
 $110 = $40;
 $38 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEE18__enable_weak_thisEz($68,$vararg_buffer);
 $20 = $65;
 $120 = $20;
 $17 = $120;
 $18 = 0;
 $121 = $17;
 $16 = $121;
 $122 = $16;
 $15 = $122;
 $123 = $15;
 $124 = HEAP32[$123>>2]|0;
 $19 = $124;
 $125 = $18;
 $12 = $121;
 $126 = $12;
 $11 = $126;
 $127 = $11;
 HEAP32[$127>>2] = $125;
 $128 = $19;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $10 = $121;
 $130 = $10;
 $9 = $130;
 $131 = $9;
 $132 = $19;
 $13 = $131;
 $14 = $132;
 $133 = $14;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEED2Ev($133);
 __ZdlPv($133);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEE18__enable_weak_thisEz($0,$varargs) {
 $0 = $0|0;
 $varargs = $varargs|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS_14default_deleteIS9_EENS_9allocatorIS9_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS_14default_deleteIS9_EENS_9allocatorIS9_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS_14default_deleteIS9_EENS_9allocatorIS9_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS_14default_deleteIS9_EENS_9allocatorIS9_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $4 = $22;
 $23 = $4;
 $3 = $23;
 $24 = $3;
 $2 = $24;
 $25 = $2;
 $1 = $25;
 $26 = $1;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEED2Ev($28);
  __ZdlPv($28);
 }
 $30 = ((($16)) + 12|0);
 $10 = $30;
 $31 = $10;
 $9 = $31;
 $32 = $9;
 $12 = $32;
 $33 = $12;
 $11 = $33;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS_14default_deleteIS9_EENS_9allocatorIS9_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 248;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS_14default_deleteIS9_EENS_9allocatorIS9_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZNK6laszip7factory13record_schema6formatEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $13 = $0;
 $15 = $13;
 $11 = $15;
 $16 = $11;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = HEAP32[$16>>2]|0;
 $20 = $18;
 $21 = $19;
 $22 = (($20) - ($21))|0;
 $23 = (($22|0) / 12)&-1;
 $14 = $23;
 $24 = $14;
 $25 = ($24|0)==(0);
 if ($25) {
  $12 = -1;
  $68 = $12;
  STACKTOP = sp;return ($68|0);
 }
 $26 = (__ZNK6laszip7factory13record_schema10extrabytesEv($15)|0);
 $27 = ($26|0)!=(0);
 if ($27) {
  $28 = $14;
  $29 = (($28) + -1)|0;
  $14 = $29;
 }
 $30 = $14;
 $31 = ($30|0)==(0);
 if (!($31)) {
  $9 = $15;
  $10 = 0;
  $32 = $9;
  $33 = HEAP32[$32>>2]|0;
  $34 = $10;
  $35 = (($33) + (($34*12)|0)|0);
  $36 = (__ZN6laszip7factory11record_item5pointEv()|0);
  $37 = (__ZNK6laszip7factory11record_itemneERKS1_($35,$36)|0);
  if (!($37)) {
   $38 = $14;
   $39 = ($38|0)==(1);
   if ($39) {
    $12 = 0;
    $68 = $12;
    STACKTOP = sp;return ($68|0);
   }
   $40 = $14;
   $41 = ($40|0)==(2);
   if ($41) {
    $7 = $15;
    $8 = 1;
    $42 = $7;
    $43 = HEAP32[$42>>2]|0;
    $44 = $8;
    $45 = (($43) + (($44*12)|0)|0);
    $46 = (__ZN6laszip7factory11record_item7gpstimeEv()|0);
    $47 = (__ZNK6laszip7factory11record_itemeqERKS1_($45,$46)|0);
    if ($47) {
     $12 = 1;
     $68 = $12;
     STACKTOP = sp;return ($68|0);
    }
    $3 = $15;
    $4 = 1;
    $48 = $3;
    $49 = HEAP32[$48>>2]|0;
    $50 = $4;
    $51 = (($49) + (($50*12)|0)|0);
    $52 = (__ZN6laszip7factory11record_item3rgbEv()|0);
    $53 = (__ZNK6laszip7factory11record_itemeqERKS1_($51,$52)|0);
    if ($53) {
     $12 = 2;
     $68 = $12;
     STACKTOP = sp;return ($68|0);
    }
   }
   $54 = $14;
   $55 = ($54|0)==(3);
   if ($55) {
    $1 = $15;
    $2 = 1;
    $56 = $1;
    $57 = HEAP32[$56>>2]|0;
    $58 = $2;
    $59 = (($57) + (($58*12)|0)|0);
    $60 = (__ZN6laszip7factory11record_item7gpstimeEv()|0);
    $61 = (__ZNK6laszip7factory11record_itemeqERKS1_($59,$60)|0);
    if ($61) {
     $5 = $15;
     $6 = 2;
     $62 = $5;
     $63 = HEAP32[$62>>2]|0;
     $64 = $6;
     $65 = (($63) + (($64*12)|0)|0);
     $66 = (__ZN6laszip7factory11record_item3rgbEv()|0);
     $67 = (__ZNK6laszip7factory11record_itemeqERKS1_($65,$66)|0);
     if ($67) {
      $12 = 3;
      $68 = $12;
      STACKTOP = sp;return ($68|0);
     }
    }
   }
   $12 = -1;
   $68 = $12;
   STACKTOP = sp;return ($68|0);
  }
 }
 $12 = -1;
 $68 = $12;
 STACKTOP = sp;return ($68|0);
}
function __ZN6laszip19unknown_schema_typeC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorC2EPKc($2,5848);
 HEAP32[$2>>2] = (1936);
 STACKTOP = sp;return;
}
function __ZN6laszip19unknown_schema_typeD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt13runtime_errorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNK6laszip7factory13record_schema10extrabytesEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $2 = sp;
 $5 = sp + 124|0;
 $8 = sp + 112|0;
 $11 = sp + 100|0;
 $16 = sp + 80|0;
 $22 = sp + 56|0;
 $28 = sp + 32|0;
 $33 = sp + 8|0;
 $32 = $0;
 $34 = $32;
 $30 = $34;
 $35 = $30;
 $36 = ((($35)) + 4|0);
 $37 = HEAP32[$36>>2]|0;
 $38 = HEAP32[$35>>2]|0;
 $39 = $37;
 $40 = $38;
 $41 = (($39) - ($40))|0;
 $42 = (($41|0) / 12)&-1;
 $43 = ($42|0)!=(0);
 if ($43) {
  $10 = $34;
  $44 = $10;
  $9 = $44;
  $45 = $9;
  $46 = ((($45)) + 4|0);
  $47 = HEAP32[$46>>2]|0;
  $6 = $45;
  $7 = $47;
  $48 = $7;
  $3 = $5;
  $4 = $48;
  $49 = $3;
  $50 = $4;
  HEAP32[$49>>2] = $50;
  $51 = HEAP32[$5>>2]|0;
  HEAP32[$8>>2] = $51;
  $52 = HEAP32[$8>>2]|0;
  HEAP32[$11>>2] = $52;
  ;HEAP8[$2>>0]=HEAP8[$11>>0]|0;HEAP8[$2+1>>0]=HEAP8[$11+1>>0]|0;HEAP8[$2+2>>0]=HEAP8[$11+2>>0]|0;HEAP8[$2+3>>0]=HEAP8[$11+3>>0]|0;
  $1 = $33;
  $53 = $1;
  ;HEAP32[$53>>2]=HEAP32[$2>>2]|0;
  $54 = ((($53)) + 4|0);
  ;HEAP32[$54>>2]=HEAP32[$2>>2]|0;
  $17 = $33;
  $55 = $17;
  $15 = $55;
  $56 = $15;
  $57 = ((($56)) + 4|0);
  ;HEAP32[$16>>2]=HEAP32[$57>>2]|0;
  $14 = $16;
  $58 = $14;
  $59 = HEAP32[$58>>2]|0;
  $60 = ((($59)) + -12|0);
  HEAP32[$58>>2] = $60;
  $13 = $58;
  $61 = $13;
  $62 = HEAP32[$61>>2]|0;
  $12 = $62;
  $63 = $12;
  $64 = HEAP32[$63>>2]|0;
  $65 = ($64|0)==(0);
  if ($65) {
   $23 = $33;
   $66 = $23;
   $21 = $66;
   $67 = $21;
   $68 = ((($67)) + 4|0);
   ;HEAP32[$22>>2]=HEAP32[$68>>2]|0;
   $20 = $22;
   $69 = $20;
   $70 = HEAP32[$69>>2]|0;
   $71 = ((($70)) + -12|0);
   HEAP32[$69>>2] = $71;
   $19 = $69;
   $72 = $19;
   $73 = HEAP32[$72>>2]|0;
   $18 = $73;
   $74 = $18;
   $75 = ((($74)) + 8|0);
   $76 = HEAP32[$75>>2]|0;
   $77 = ($76|0)==(2);
   if ($77) {
    $29 = $33;
    $78 = $29;
    $27 = $78;
    $79 = $27;
    $80 = ((($79)) + 4|0);
    ;HEAP32[$28>>2]=HEAP32[$80>>2]|0;
    $26 = $28;
    $81 = $26;
    $82 = HEAP32[$81>>2]|0;
    $83 = ((($82)) + -12|0);
    HEAP32[$81>>2] = $83;
    $25 = $81;
    $84 = $25;
    $85 = HEAP32[$84>>2]|0;
    $24 = $85;
    $86 = $24;
    $87 = ((($86)) + 4|0);
    $88 = HEAP32[$87>>2]|0;
    $31 = $88;
    $89 = $31;
    STACKTOP = sp;return ($89|0);
   }
  }
 }
 $31 = 0;
 $89 = $31;
 STACKTOP = sp;return ($89|0);
}
function __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEENS0_26dynamic_field_decompressorIT_E3ptrERSB_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $$byval_copy = sp + 8|0;
 $3 = sp;
 $2 = $1;
 $4 = (__Znwj(24)|0);
 $5 = $2;
 __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEC2ERS9_($4,$5);
 ;HEAP32[$3>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$3>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEEEC2ISC_EEPT_NS_9enable_ifIXsr14is_convertibleISG_PSC_EE5valueENSD_5__natEE4typeE($0,$4,$$byval_copy);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_3las7point10EEEvv($0) {
 $0 = $0|0;
 var $$byval_copy = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $$byval_copy = sp + 136|0;
 $16 = sp;
 $21 = sp + 141|0;
 $32 = sp + 140|0;
 $34 = sp + 8|0;
 $35 = sp + 4|0;
 $33 = $0;
 $36 = $33;
 $37 = ((($36)) + 8|0);
 $38 = (__Znwj(4792)|0);
 $39 = ((($36)) + 4|0);
 $40 = HEAP32[$39>>2]|0;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISC_EEEEEC2ERS9_($38,$40);
 ;HEAP32[$35>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$35>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($34,$38,$$byval_copy);
 $30 = $37;
 $31 = $34;
 $41 = $30;
 $42 = ((($41)) + 4|0);
 $43 = HEAP32[$42>>2]|0;
 $29 = $41;
 $44 = $29;
 $45 = ((($44)) + 8|0);
 $28 = $45;
 $46 = $28;
 $27 = $46;
 $47 = $27;
 $48 = HEAP32[$47>>2]|0;
 $49 = ($43>>>0)<($48>>>0);
 if ($49) {
  $24 = $32;
  $25 = $41;
  $26 = 1;
  $3 = $41;
  $50 = $3;
  $51 = ((($50)) + 8|0);
  $2 = $51;
  $52 = $2;
  $1 = $52;
  $53 = $1;
  $54 = ((($41)) + 4|0);
  $55 = HEAP32[$54>>2]|0;
  $4 = $55;
  $56 = $4;
  $57 = $31;
  $5 = $57;
  $58 = $5;
  $18 = $53;
  $19 = $56;
  $20 = $58;
  $59 = $18;
  $60 = $19;
  $61 = $20;
  $17 = $61;
  $62 = $17;
  ;HEAP8[$16>>0]=HEAP8[$21>>0]|0;
  $13 = $59;
  $14 = $60;
  $15 = $62;
  $63 = $13;
  $64 = $14;
  $65 = $15;
  $12 = $65;
  $66 = $12;
  $9 = $63;
  $10 = $64;
  $11 = $66;
  $67 = $10;
  $68 = $11;
  $8 = $68;
  $69 = $8;
  $6 = $67;
  $7 = $69;
  $70 = $6;
  $71 = $7;
  $72 = HEAP32[$71>>2]|0;
  HEAP32[$70>>2] = $72;
  $73 = ((($70)) + 4|0);
  $74 = $7;
  $75 = ((($74)) + 4|0);
  $76 = HEAP32[$75>>2]|0;
  HEAP32[$73>>2] = $76;
  $77 = $7;
  HEAP32[$77>>2] = 0;
  $78 = $7;
  $79 = ((($78)) + 4|0);
  HEAP32[$79>>2] = 0;
  $22 = $32;
  $80 = ((($41)) + 4|0);
  $81 = HEAP32[$80>>2]|0;
  $82 = ((($81)) + 8|0);
  HEAP32[$80>>2] = $82;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($34);
  STACKTOP = sp;return;
 } else {
  $83 = $31;
  $23 = $83;
  $84 = $23;
  __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE21__push_back_slow_pathIS5_EEvOT_($41,$84);
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($34);
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_3las7gpstimeEEEvv($0) {
 $0 = $0|0;
 var $$byval_copy = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $$byval_copy = sp + 136|0;
 $16 = sp;
 $21 = sp + 141|0;
 $32 = sp + 140|0;
 $34 = sp + 8|0;
 $35 = sp + 4|0;
 $33 = $0;
 $36 = $33;
 $37 = ((($36)) + 8|0);
 $38 = (__Znwj(336)|0);
 $39 = ((($36)) + 4|0);
 $40 = HEAP32[$39>>2]|0;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodISC_EEEEEC2ERS9_($38,$40);
 ;HEAP32[$35>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$35>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($34,$38,$$byval_copy);
 $30 = $37;
 $31 = $34;
 $41 = $30;
 $42 = ((($41)) + 4|0);
 $43 = HEAP32[$42>>2]|0;
 $29 = $41;
 $44 = $29;
 $45 = ((($44)) + 8|0);
 $28 = $45;
 $46 = $28;
 $27 = $46;
 $47 = $27;
 $48 = HEAP32[$47>>2]|0;
 $49 = ($43>>>0)<($48>>>0);
 if ($49) {
  $24 = $32;
  $25 = $41;
  $26 = 1;
  $3 = $41;
  $50 = $3;
  $51 = ((($50)) + 8|0);
  $2 = $51;
  $52 = $2;
  $1 = $52;
  $53 = $1;
  $54 = ((($41)) + 4|0);
  $55 = HEAP32[$54>>2]|0;
  $4 = $55;
  $56 = $4;
  $57 = $31;
  $5 = $57;
  $58 = $5;
  $18 = $53;
  $19 = $56;
  $20 = $58;
  $59 = $18;
  $60 = $19;
  $61 = $20;
  $17 = $61;
  $62 = $17;
  ;HEAP8[$16>>0]=HEAP8[$21>>0]|0;
  $13 = $59;
  $14 = $60;
  $15 = $62;
  $63 = $13;
  $64 = $14;
  $65 = $15;
  $12 = $65;
  $66 = $12;
  $9 = $63;
  $10 = $64;
  $11 = $66;
  $67 = $10;
  $68 = $11;
  $8 = $68;
  $69 = $8;
  $6 = $67;
  $7 = $69;
  $70 = $6;
  $71 = $7;
  $72 = HEAP32[$71>>2]|0;
  HEAP32[$70>>2] = $72;
  $73 = ((($70)) + 4|0);
  $74 = $7;
  $75 = ((($74)) + 4|0);
  $76 = HEAP32[$75>>2]|0;
  HEAP32[$73>>2] = $76;
  $77 = $7;
  HEAP32[$77>>2] = 0;
  $78 = $7;
  $79 = ((($78)) + 4|0);
  HEAP32[$79>>2] = 0;
  $22 = $32;
  $80 = ((($41)) + 4|0);
  $81 = HEAP32[$80>>2]|0;
  $82 = ((($81)) + 8|0);
  HEAP32[$80>>2] = $82;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($34);
  STACKTOP = sp;return;
 } else {
  $83 = $31;
  $23 = $83;
  $84 = $23;
  __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE21__push_back_slow_pathIS5_EEvOT_($41,$84);
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($34);
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_3las3rgbEEEvv($0) {
 $0 = $0|0;
 var $$byval_copy = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $$byval_copy = sp + 136|0;
 $16 = sp;
 $21 = sp + 141|0;
 $32 = sp + 140|0;
 $34 = sp + 8|0;
 $35 = sp + 4|0;
 $33 = $0;
 $36 = $33;
 $37 = ((($36)) + 8|0);
 $38 = (__Znwj(324)|0);
 $39 = ((($36)) + 4|0);
 $40 = HEAP32[$39>>2]|0;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodISC_EEEEEC2ERS9_($38,$40);
 ;HEAP32[$35>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$35>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($34,$38,$$byval_copy);
 $30 = $37;
 $31 = $34;
 $41 = $30;
 $42 = ((($41)) + 4|0);
 $43 = HEAP32[$42>>2]|0;
 $29 = $41;
 $44 = $29;
 $45 = ((($44)) + 8|0);
 $28 = $45;
 $46 = $28;
 $27 = $46;
 $47 = $27;
 $48 = HEAP32[$47>>2]|0;
 $49 = ($43>>>0)<($48>>>0);
 if ($49) {
  $24 = $32;
  $25 = $41;
  $26 = 1;
  $3 = $41;
  $50 = $3;
  $51 = ((($50)) + 8|0);
  $2 = $51;
  $52 = $2;
  $1 = $52;
  $53 = $1;
  $54 = ((($41)) + 4|0);
  $55 = HEAP32[$54>>2]|0;
  $4 = $55;
  $56 = $4;
  $57 = $31;
  $5 = $57;
  $58 = $5;
  $18 = $53;
  $19 = $56;
  $20 = $58;
  $59 = $18;
  $60 = $19;
  $61 = $20;
  $17 = $61;
  $62 = $17;
  ;HEAP8[$16>>0]=HEAP8[$21>>0]|0;
  $13 = $59;
  $14 = $60;
  $15 = $62;
  $63 = $13;
  $64 = $14;
  $65 = $15;
  $12 = $65;
  $66 = $12;
  $9 = $63;
  $10 = $64;
  $11 = $66;
  $67 = $10;
  $68 = $11;
  $8 = $68;
  $69 = $8;
  $6 = $67;
  $7 = $69;
  $70 = $6;
  $71 = $7;
  $72 = HEAP32[$71>>2]|0;
  HEAP32[$70>>2] = $72;
  $73 = ((($70)) + 4|0);
  $74 = $7;
  $75 = ((($74)) + 4|0);
  $76 = HEAP32[$75>>2]|0;
  HEAP32[$73>>2] = $76;
  $77 = $7;
  HEAP32[$77>>2] = 0;
  $78 = $7;
  $79 = ((($78)) + 4|0);
  HEAP32[$79>>2] = 0;
  $22 = $32;
  $80 = ((($41)) + 4|0);
  $81 = HEAP32[$80>>2]|0;
  $82 = ((($81)) + 8|0);
  HEAP32[$80>>2] = $82;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($34);
  STACKTOP = sp;return;
 } else {
  $83 = $31;
  $23 = $83;
  $84 = $23;
  __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE21__push_back_slow_pathIS5_EEvOT_($41,$84);
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($34);
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE9add_fieldINS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISE_EEEEEEvRKT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 160|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(160|0);
 $$byval_copy = sp + 140|0;
 $17 = sp;
 $22 = sp + 145|0;
 $33 = sp + 144|0;
 $36 = sp + 8|0;
 $37 = sp + 4|0;
 $34 = $0;
 $35 = $1;
 $38 = $34;
 $39 = ((($38)) + 8|0);
 $40 = (__Znwj(64)|0);
 $41 = ((($38)) + 4|0);
 $42 = HEAP32[$41>>2]|0;
 $43 = $35;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISC_EEEEEC2ERS9_RKSF_($40,$42,$43);
 ;HEAP32[$37>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$37>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($36,$40,$$byval_copy);
 $31 = $39;
 $32 = $36;
 $44 = $31;
 $45 = ((($44)) + 4|0);
 $46 = HEAP32[$45>>2]|0;
 $30 = $44;
 $47 = $30;
 $48 = ((($47)) + 8|0);
 $29 = $48;
 $49 = $29;
 $28 = $49;
 $50 = $28;
 $51 = HEAP32[$50>>2]|0;
 $52 = ($46>>>0)<($51>>>0);
 if ($52) {
  $25 = $33;
  $26 = $44;
  $27 = 1;
  $4 = $44;
  $53 = $4;
  $54 = ((($53)) + 8|0);
  $3 = $54;
  $55 = $3;
  $2 = $55;
  $56 = $2;
  $57 = ((($44)) + 4|0);
  $58 = HEAP32[$57>>2]|0;
  $5 = $58;
  $59 = $5;
  $60 = $32;
  $6 = $60;
  $61 = $6;
  $19 = $56;
  $20 = $59;
  $21 = $61;
  $62 = $19;
  $63 = $20;
  $64 = $21;
  $18 = $64;
  $65 = $18;
  ;HEAP8[$17>>0]=HEAP8[$22>>0]|0;
  $14 = $62;
  $15 = $63;
  $16 = $65;
  $66 = $14;
  $67 = $15;
  $68 = $16;
  $13 = $68;
  $69 = $13;
  $10 = $66;
  $11 = $67;
  $12 = $69;
  $70 = $11;
  $71 = $12;
  $9 = $71;
  $72 = $9;
  $7 = $70;
  $8 = $72;
  $73 = $7;
  $74 = $8;
  $75 = HEAP32[$74>>2]|0;
  HEAP32[$73>>2] = $75;
  $76 = ((($73)) + 4|0);
  $77 = $8;
  $78 = ((($77)) + 4|0);
  $79 = HEAP32[$78>>2]|0;
  HEAP32[$76>>2] = $79;
  $80 = $8;
  HEAP32[$80>>2] = 0;
  $81 = $8;
  $82 = ((($81)) + 4|0);
  HEAP32[$82>>2] = 0;
  $23 = $33;
  $83 = ((($44)) + 4|0);
  $84 = HEAP32[$83>>2]|0;
  $85 = ((($84)) + 8|0);
  HEAP32[$83>>2] = $85;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($36);
  STACKTOP = sp;return;
 } else {
  $86 = $32;
  $24 = $86;
  $87 = $24;
  __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE21__push_back_slow_pathIS5_EEvOT_($44,$87);
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($36);
  STACKTOP = sp;return;
 }
}
function __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEEC2Ej($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $4 = sp;
 $2 = $0;
 $3 = $1;
 $5 = $2;
 $6 = $3;
 HEAP32[$5>>2] = $6;
 $7 = ((($5)) + 4|0);
 HEAP8[$7>>0] = 0;
 $8 = ((($5)) + 8|0);
 $9 = $3;
 __ZNSt3__26vectorIhNS_9allocatorIhEEEC2Ej($8,$9);
 $10 = ((($5)) + 20|0);
 $11 = $3;
 __ZNSt3__26vectorIhNS_9allocatorIhEEEC2Ej($10,$11);
 $12 = ((($5)) + 32|0);
 $13 = $3;
 __ZN6laszip6models10arithmeticC2EjbPj($4,256,0,0);
 __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEEC2EjRKS3_($12,$13,$4);
 __ZN6laszip6models10arithmeticD2Ev($4);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 32|0);
 __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($3);
 $4 = ((($2)) + 20|0);
 __ZNSt3__26vectorIhNS_9allocatorIhEEED2Ev($4);
 $5 = ((($2)) + 8|0);
 __ZNSt3__26vectorIhNS_9allocatorIhEEED2Ev($5);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$byval_copy = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $$byval_copy = sp + 12|0;
 $5 = sp;
 $3 = $1;
 $4 = $2;
 $6 = (__Znwj(12)|0);
 $7 = $3;
 $8 = $4;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEEC2ERS9_PSH_($6,$7,$8);
 ;HEAP32[$5>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$5>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISP_PS3_EE5valueENS4_5__natEE4typeE($0,$6,$$byval_copy);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$byval_copy = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $$byval_copy = sp + 12|0;
 $5 = sp;
 $3 = $1;
 $4 = $2;
 $6 = (__Znwj(12)|0);
 $7 = $3;
 $8 = $4;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEEC2ERS9_PSK_($6,$7,$8);
 ;HEAP32[$5>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$5>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEENSG_INSH_7gpstimeENSJ_ISM_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISS_PS3_EE5valueENS4_5__natEE4typeE($0,$6,$$byval_copy);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEEEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$byval_copy = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $$byval_copy = sp + 12|0;
 $5 = sp;
 $3 = $1;
 $4 = $2;
 $6 = (__Znwj(12)|0);
 $7 = $3;
 $8 = $4;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEEC2ERS9_PSK_($6,$7,$8);
 ;HEAP32[$5>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$5>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEENSG_INSH_3rgbENSJ_ISM_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISS_PS3_EE5valueENS4_5__natEE4typeE($0,$6,$$byval_copy);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEEENSt3__210shared_ptrINS0_20dynamic_decompressorEEERT_PT0_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$byval_copy = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $$byval_copy = sp + 12|0;
 $5 = sp;
 $3 = $1;
 $4 = $2;
 $6 = (__Znwj(12)|0);
 $7 = $3;
 $8 = $4;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEEC2ERS9_PSN_($6,$7,$8);
 ;HEAP32[$5>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$5>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEENSG_INSH_7gpstimeENSJ_ISM_EEEENSG_INSH_3rgbENSJ_ISP_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISV_PS3_EE5valueENS4_5__natEE4typeE($0,$6,$$byval_copy);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEENS2_INS3_3rgbENS5_ISB_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZNK6laszip7factory11record_itemneERKS1_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 $6 = (__ZNK6laszip7factory11record_itemeqERKS1_($4,$5)|0);
 $7 = $6 ^ 1;
 STACKTOP = sp;return ($7|0);
}
function __ZN6laszip7factory11record_item5pointEv() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP8[21192]|0;
 $1 = ($0<<24>>24)==(0);
 if ($1) {
  $2 = (___cxa_guard_acquire(21192)|0);
  $3 = ($2|0)!=(0);
  if ($3) {
   __ZN6laszip7factory11record_itemC2Eiii(21256,6,20,2);
  }
 }
 return (21256|0);
}
function __ZNK6laszip7factory11record_itemeqERKS1_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = HEAP32[$4>>2]|0;
 $6 = $3;
 $7 = HEAP32[$6>>2]|0;
 $8 = ($5|0)==($7|0);
 if (!($8)) {
  $21 = 0;
  STACKTOP = sp;return ($21|0);
 }
 $9 = ((($4)) + 8|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = $3;
 $12 = ((($11)) + 8|0);
 $13 = HEAP32[$12>>2]|0;
 $14 = ($10|0)==($13|0);
 if (!($14)) {
  $21 = 0;
  STACKTOP = sp;return ($21|0);
 }
 $15 = ((($4)) + 4|0);
 $16 = HEAP32[$15>>2]|0;
 $17 = $3;
 $18 = ((($17)) + 4|0);
 $19 = HEAP32[$18>>2]|0;
 $20 = ($16|0)==($19|0);
 $21 = $20;
 STACKTOP = sp;return ($21|0);
}
function __ZN6laszip7factory11record_item7gpstimeEv() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP8[21200]|0;
 $1 = ($0<<24>>24)==(0);
 if ($1) {
  $2 = (___cxa_guard_acquire(21200)|0);
  $3 = ($2|0)!=(0);
  if ($3) {
   __ZN6laszip7factory11record_itemC2Eiii(21268,7,8,2);
  }
 }
 return (21268|0);
}
function __ZN6laszip7factory11record_item3rgbEv() {
 var $0 = 0, $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP8[21208]|0;
 $1 = ($0<<24>>24)==(0);
 if ($1) {
  $2 = (___cxa_guard_acquire(21208)|0);
  $3 = ($2|0)!=(0);
  if ($3) {
   __ZN6laszip7factory11record_itemC2Eiii(21280,8,6,2);
  }
 }
 return (21280|0);
}
function __ZN6laszip19unknown_schema_typeD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip19unknown_schema_typeD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEC2ERS9_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $12 = sp + 12|0;
 $14 = $0;
 $15 = $1;
 $16 = $14;
 __ZN6laszip7formats20dynamic_decompressorC2Ev($16);
 HEAP32[$16>>2] = (1956);
 $17 = ((($16)) + 4|0);
 $18 = $15;
 HEAP32[$17>>2] = $18;
 $19 = ((($16)) + 8|0);
 $13 = $19;
 $20 = $13;
 $11 = $20;
 $21 = $11;
 $10 = $21;
 HEAP32[$21>>2] = 0;
 $22 = ((($21)) + 4|0);
 HEAP32[$22>>2] = 0;
 $23 = ((($21)) + 8|0);
 HEAP32[$12>>2] = 0;
 $8 = $23;
 $9 = $12;
 $24 = $8;
 $25 = $9;
 $7 = $25;
 $26 = $7;
 $3 = $24;
 $4 = $26;
 $27 = $3;
 $28 = $4;
 $2 = $28;
 HEAP32[$27>>2] = 0;
 $6 = $24;
 $29 = $6;
 $5 = $29;
 $30 = ((($16)) + 20|0);
 HEAP8[$30>>0] = 1;
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEEEC2ISC_EEPT_NS_9enable_ifIXsr14is_convertibleISG_PSC_EE5valueENSD_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (1996);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 8|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats20dynamic_decompressorC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (1976);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEE10decompressEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0;
 var $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 160|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(160|0);
 $20 = sp + 72|0;
 $23 = sp + 60|0;
 $27 = sp + 44|0;
 $30 = sp + 32|0;
 $35 = sp + 12|0;
 $36 = sp + 8|0;
 $37 = sp;
 $32 = $0;
 $33 = $1;
 $38 = $32;
 $39 = ((($38)) + 8|0);
 $34 = $39;
 $40 = $34;
 $31 = $40;
 $41 = $31;
 $42 = HEAP32[$41>>2]|0;
 $28 = $41;
 $29 = $42;
 $43 = $29;
 $25 = $27;
 $26 = $43;
 $44 = $25;
 $45 = $26;
 HEAP32[$44>>2] = $45;
 $46 = HEAP32[$27>>2]|0;
 HEAP32[$30>>2] = $46;
 $47 = HEAP32[$30>>2]|0;
 HEAP32[$35>>2] = $47;
 $48 = $34;
 $24 = $48;
 $49 = $24;
 $50 = ((($49)) + 4|0);
 $51 = HEAP32[$50>>2]|0;
 $21 = $49;
 $22 = $51;
 $52 = $22;
 $18 = $20;
 $19 = $52;
 $53 = $18;
 $54 = $19;
 HEAP32[$53>>2] = $54;
 $55 = HEAP32[$20>>2]|0;
 HEAP32[$23>>2] = $55;
 $56 = HEAP32[$23>>2]|0;
 HEAP32[$36>>2] = $56;
 while(1) {
  $16 = $35;
  $17 = $36;
  $57 = $16;
  $58 = $17;
  $14 = $57;
  $15 = $58;
  $59 = $14;
  $13 = $59;
  $60 = $13;
  $61 = HEAP32[$60>>2]|0;
  $62 = $15;
  $12 = $62;
  $63 = $12;
  $64 = HEAP32[$63>>2]|0;
  $65 = ($61|0)==($64|0);
  $66 = $65 ^ 1;
  if (!($66)) {
   break;
  }
  $10 = $35;
  $67 = $10;
  $68 = HEAP32[$67>>2]|0;
  $8 = $37;
  $9 = $68;
  $69 = $8;
  $70 = $9;
  $71 = HEAP32[$70>>2]|0;
  HEAP32[$69>>2] = $71;
  $72 = ((($69)) + 4|0);
  $73 = $9;
  $74 = ((($73)) + 4|0);
  $75 = HEAP32[$74>>2]|0;
  HEAP32[$72>>2] = $75;
  $76 = ((($69)) + 4|0);
  $77 = HEAP32[$76>>2]|0;
  $78 = ($77|0)!=(0|0);
  if ($78) {
   $79 = ((($69)) + 4|0);
   $80 = HEAP32[$79>>2]|0;
   $7 = $80;
   $81 = $7;
   $6 = $81;
   $82 = $6;
   $83 = ((($82)) + 4|0);
   $3 = $83;
   $84 = $3;
   $4 = 1;
   $85 = $4;
   $86 = HEAP32[$84>>2]|0;
   $87 = (($86) + ($85))|0;
   HEAP32[$84>>2] = $87;
   $88 = (($86) + ($85))|0;
   $5 = $88;
  }
  $2 = $37;
  $89 = $2;
  $90 = HEAP32[$89>>2]|0;
  $91 = HEAP32[$90>>2]|0;
  $92 = ((($91)) + 12|0);
  $93 = HEAP32[$92>>2]|0;
  $94 = $33;
  $95 = (FUNCTION_TABLE_iii[$93 & 255]($90,$94)|0);
  $33 = $95;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($37);
  $11 = $35;
  $96 = $11;
  $97 = HEAP32[$96>>2]|0;
  $98 = ((($97)) + 8|0);
  HEAP32[$96>>2] = $98;
 }
 $99 = ((($38)) + 20|0);
 $100 = HEAP8[$99>>0]|0;
 $101 = $100&1;
 if (!($101)) {
  $105 = $33;
  STACKTOP = sp;return ($105|0);
 }
 $102 = ((($38)) + 20|0);
 HEAP8[$102>>0] = 0;
 $103 = ((($38)) + 4|0);
 $104 = HEAP32[$103>>2]|0;
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE13readInitBytesEv($104);
 $105 = $33;
 STACKTOP = sp;return ($105|0);
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (1956);
 $3 = ((($2)) + 8|0);
 __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEED2Ev($3);
 __ZN6laszip7formats20dynamic_decompressorD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats20dynamic_decompressorD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats20dynamic_decompressorD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 _llvm_trap();
 // unreachable;
}
function __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__213__vector_baseINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__213__vector_baseINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $19 = sp;
 $22 = sp + 120|0;
 $31 = $0;
 $32 = $31;
 $33 = HEAP32[$32>>2]|0;
 $34 = ($33|0)!=(0|0);
 if (!($34)) {
  STACKTOP = sp;return;
 }
 $30 = $32;
 $35 = $30;
 $36 = HEAP32[$35>>2]|0;
 $27 = $35;
 $28 = $36;
 $37 = $27;
 $38 = ((($37)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $29 = $39;
 while(1) {
  $40 = $28;
  $41 = $29;
  $42 = ($40|0)!=($41|0);
  if (!($42)) {
   break;
  }
  $26 = $37;
  $43 = $26;
  $44 = ((($43)) + 8|0);
  $25 = $44;
  $45 = $25;
  $24 = $45;
  $46 = $24;
  $47 = $29;
  $48 = ((($47)) + -8|0);
  $29 = $48;
  $23 = $48;
  $49 = $23;
  $20 = $46;
  $21 = $49;
  $50 = $20;
  $51 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $50;
  $18 = $51;
  $52 = $17;
  $53 = $18;
  $15 = $52;
  $16 = $53;
  $54 = $16;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($54);
 }
 $55 = $28;
 $56 = ((($37)) + 4|0);
 HEAP32[$56>>2] = $55;
 $14 = $32;
 $57 = $14;
 $58 = ((($57)) + 8|0);
 $13 = $58;
 $59 = $13;
 $12 = $59;
 $60 = $12;
 $61 = HEAP32[$32>>2]|0;
 $4 = $32;
 $62 = $4;
 $3 = $62;
 $63 = $3;
 $64 = ((($63)) + 8|0);
 $2 = $64;
 $65 = $2;
 $1 = $65;
 $66 = $1;
 $67 = HEAP32[$66>>2]|0;
 $68 = HEAP32[$62>>2]|0;
 $69 = $67;
 $70 = $68;
 $71 = (($69) - ($70))|0;
 $72 = (($71|0) / 8)&-1;
 $9 = $60;
 $10 = $61;
 $11 = $72;
 $73 = $9;
 $74 = $10;
 $75 = $11;
 $6 = $73;
 $7 = $74;
 $8 = $75;
 $76 = $7;
 $5 = $76;
 $77 = $5;
 __ZdlPv($77);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEEE18__enable_weak_thisEz($0,$varargs) {
 $0 = $0|0;
 $varargs = $varargs|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEENS_14default_deleteISC_EENS_9allocatorISC_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEENS_14default_deleteISC_EENS_9allocatorISC_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEENS_14default_deleteISC_EENS_9allocatorISC_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEENS_14default_deleteISC_EENS_9allocatorISC_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 8|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEENS_14default_deleteISC_EENS_9allocatorISC_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 312;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEEEENS_14default_deleteISC_EENS_9allocatorISC_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISC_EEEEEC2ERS9_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 __ZN6laszip7formats10base_fieldC2Ev($4);
 HEAP32[$4>>2] = (2024);
 $5 = ((($4)) + 4|0);
 $6 = $3;
 HEAP32[$5>>2] = $6;
 $7 = ((($4)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEEC2Ev($7);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2072);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 4|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE21__push_back_slow_pathIS5_EEvOT_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0;
 var $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 208|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(208|0);
 $12 = sp + 8|0;
 $17 = sp + 201|0;
 $26 = sp;
 $29 = sp + 200|0;
 $37 = sp + 72|0;
 $40 = sp + 60|0;
 $48 = sp + 12|0;
 $45 = $0;
 $46 = $1;
 $49 = $45;
 $44 = $49;
 $50 = $44;
 $51 = ((($50)) + 8|0);
 $43 = $51;
 $52 = $43;
 $42 = $52;
 $53 = $42;
 $47 = $53;
 $41 = $49;
 $54 = $41;
 $55 = ((($54)) + 4|0);
 $56 = HEAP32[$55>>2]|0;
 $57 = HEAP32[$54>>2]|0;
 $58 = $56;
 $59 = $57;
 $60 = (($58) - ($59))|0;
 $61 = (($60|0) / 8)&-1;
 $62 = (($61) + 1)|0;
 $36 = $49;
 HEAP32[$37>>2] = $62;
 $63 = $36;
 $64 = (__ZNKSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE8max_sizeEv($63)|0);
 $38 = $64;
 $65 = HEAP32[$37>>2]|0;
 $66 = $38;
 $67 = ($65>>>0)>($66>>>0);
 if ($67) {
  __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv($63);
  // unreachable;
 }
 $34 = $63;
 $68 = $34;
 $33 = $68;
 $69 = $33;
 $32 = $69;
 $70 = $32;
 $71 = ((($70)) + 8|0);
 $31 = $71;
 $72 = $31;
 $30 = $72;
 $73 = $30;
 $74 = HEAP32[$73>>2]|0;
 $75 = HEAP32[$69>>2]|0;
 $76 = $74;
 $77 = $75;
 $78 = (($76) - ($77))|0;
 $79 = (($78|0) / 8)&-1;
 $39 = $79;
 $80 = $39;
 $81 = $38;
 $82 = (($81>>>0) / 2)&-1;
 $83 = ($80>>>0)>=($82>>>0);
 if ($83) {
  $84 = $38;
  $35 = $84;
 } else {
  $85 = $39;
  $86 = $85<<1;
  HEAP32[$40>>2] = $86;
  $27 = $40;
  $28 = $37;
  $87 = $27;
  $88 = $28;
  ;HEAP8[$26>>0]=HEAP8[$29>>0]|0;
  $24 = $87;
  $25 = $88;
  $89 = $24;
  $90 = $25;
  $21 = $26;
  $22 = $89;
  $23 = $90;
  $91 = $22;
  $92 = HEAP32[$91>>2]|0;
  $93 = $23;
  $94 = HEAP32[$93>>2]|0;
  $95 = ($92>>>0)<($94>>>0);
  $96 = $25;
  $97 = $24;
  $98 = $95 ? $96 : $97;
  $99 = HEAP32[$98>>2]|0;
  $35 = $99;
 }
 $100 = $35;
 $20 = $49;
 $101 = $20;
 $102 = ((($101)) + 4|0);
 $103 = HEAP32[$102>>2]|0;
 $104 = HEAP32[$101>>2]|0;
 $105 = $103;
 $106 = $104;
 $107 = (($105) - ($106))|0;
 $108 = (($107|0) / 8)&-1;
 $109 = $47;
 __ZNSt3__214__split_bufferINS_10shared_ptrIN6laszip7formats10base_fieldEEERNS_9allocatorIS5_EEEC2EjjS8_($48,$100,$108,$109);
 $110 = $47;
 $111 = ((($48)) + 8|0);
 $112 = HEAP32[$111>>2]|0;
 $19 = $112;
 $113 = $19;
 $114 = $46;
 $18 = $114;
 $115 = $18;
 $14 = $110;
 $15 = $113;
 $16 = $115;
 $116 = $14;
 $117 = $15;
 $118 = $16;
 $13 = $118;
 $119 = $13;
 ;HEAP8[$12>>0]=HEAP8[$17>>0]|0;
 $9 = $116;
 $10 = $117;
 $11 = $119;
 $120 = $9;
 $121 = $10;
 $122 = $11;
 $8 = $122;
 $123 = $8;
 $5 = $120;
 $6 = $121;
 $7 = $123;
 $124 = $6;
 $125 = $7;
 $4 = $125;
 $126 = $4;
 $2 = $124;
 $3 = $126;
 $127 = $2;
 $128 = $3;
 $129 = HEAP32[$128>>2]|0;
 HEAP32[$127>>2] = $129;
 $130 = ((($127)) + 4|0);
 $131 = $3;
 $132 = ((($131)) + 4|0);
 $133 = HEAP32[$132>>2]|0;
 HEAP32[$130>>2] = $133;
 $134 = $3;
 HEAP32[$134>>2] = 0;
 $135 = $3;
 $136 = ((($135)) + 4|0);
 HEAP32[$136>>2] = 0;
 $137 = ((($48)) + 8|0);
 $138 = HEAP32[$137>>2]|0;
 $139 = ((($138)) + 8|0);
 HEAP32[$137>>2] = $139;
 __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS5_RS7_EE($49,$48);
 __ZNSt3__214__split_bufferINS_10shared_ptrIN6laszip7formats10base_fieldEEERNS_9allocatorIS5_EEED2Ev($48);
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferINS_10shared_ptrIN6laszip7formats10base_fieldEEERNS_9allocatorIS5_EEEC2EjjS8_($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $35 = sp;
 $31 = $0;
 $32 = $1;
 $33 = $2;
 $34 = $3;
 $36 = $31;
 $37 = ((($36)) + 12|0);
 HEAP32[$35>>2] = 0;
 $38 = $34;
 $28 = $37;
 $29 = $35;
 $30 = $38;
 $39 = $28;
 $40 = $29;
 $27 = $40;
 $41 = $27;
 $21 = $39;
 $22 = $41;
 $42 = $21;
 $43 = $22;
 $20 = $43;
 HEAP32[$42>>2] = 0;
 $44 = ((($39)) + 4|0);
 $45 = $30;
 $23 = $45;
 $46 = $23;
 $25 = $44;
 $26 = $46;
 $47 = $25;
 $48 = $26;
 $24 = $48;
 $49 = $24;
 HEAP32[$47>>2] = $49;
 $50 = $32;
 $51 = ($50|0)!=(0);
 do {
  if ($51) {
   $6 = $36;
   $52 = $6;
   $53 = ((($52)) + 12|0);
   $5 = $53;
   $54 = $5;
   $55 = ((($54)) + 4|0);
   $4 = $55;
   $56 = $4;
   $57 = HEAP32[$56>>2]|0;
   $58 = $32;
   $15 = $57;
   $16 = $58;
   $59 = $15;
   $60 = $16;
   $12 = $59;
   $13 = $60;
   $14 = 0;
   $61 = $12;
   $62 = $13;
   $11 = $61;
   $63 = ($62>>>0)>(536870911);
   if ($63) {
    $9 = 4287;
    $64 = (___cxa_allocate_exception(8)|0);
    $65 = $9;
    $7 = $64;
    $8 = $65;
    $66 = $7;
    $67 = $8;
    __ZNSt11logic_errorC2EPKc($66,$67);
    HEAP32[$66>>2] = (3660);
    ___cxa_throw(($64|0),(1384|0),(220|0));
    // unreachable;
   } else {
    $68 = $13;
    $69 = $68<<3;
    $10 = $69;
    $70 = $10;
    $71 = (__Znwj($70)|0);
    $72 = $71;
    break;
   }
  } else {
   $72 = 0;
  }
 } while(0);
 HEAP32[$36>>2] = $72;
 $73 = HEAP32[$36>>2]|0;
 $74 = $33;
 $75 = (($73) + ($74<<3)|0);
 $76 = ((($36)) + 8|0);
 HEAP32[$76>>2] = $75;
 $77 = ((($36)) + 4|0);
 HEAP32[$77>>2] = $75;
 $78 = HEAP32[$36>>2]|0;
 $79 = $32;
 $80 = (($78) + ($79<<3)|0);
 $19 = $36;
 $81 = $19;
 $82 = ((($81)) + 12|0);
 $18 = $82;
 $83 = $18;
 $17 = $83;
 $84 = $17;
 HEAP32[$84>>2] = $80;
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE26__swap_out_circular_bufferERNS_14__split_bufferIS5_RS7_EE($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0;
 var $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0;
 var $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 416|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(416|0);
 $17 = sp;
 $22 = sp + 412|0;
 $33 = sp + 292|0;
 $39 = sp + 268|0;
 $51 = sp + 220|0;
 $104 = $0;
 $105 = $1;
 $106 = $104;
 $103 = $106;
 $107 = $103;
 $102 = $107;
 $108 = $102;
 $109 = HEAP32[$108>>2]|0;
 $101 = $109;
 $110 = $101;
 $80 = $107;
 $111 = $80;
 $112 = HEAP32[$111>>2]|0;
 $79 = $112;
 $113 = $79;
 $85 = $107;
 $114 = $85;
 $84 = $114;
 $115 = $84;
 $83 = $115;
 $116 = $83;
 $117 = ((($116)) + 8|0);
 $82 = $117;
 $118 = $82;
 $81 = $118;
 $119 = $81;
 $120 = HEAP32[$119>>2]|0;
 $121 = HEAP32[$115>>2]|0;
 $122 = $120;
 $123 = $121;
 $124 = (($122) - ($123))|0;
 $125 = (($124|0) / 8)&-1;
 $126 = (($113) + ($125<<3)|0);
 $87 = $107;
 $127 = $87;
 $128 = HEAP32[$127>>2]|0;
 $86 = $128;
 $129 = $86;
 $88 = $107;
 $130 = $88;
 $131 = ((($130)) + 4|0);
 $132 = HEAP32[$131>>2]|0;
 $133 = HEAP32[$130>>2]|0;
 $134 = $132;
 $135 = $133;
 $136 = (($134) - ($135))|0;
 $137 = (($136|0) / 8)&-1;
 $138 = (($129) + ($137<<3)|0);
 $90 = $107;
 $139 = $90;
 $140 = HEAP32[$139>>2]|0;
 $89 = $140;
 $141 = $89;
 $95 = $107;
 $142 = $95;
 $94 = $142;
 $143 = $94;
 $93 = $143;
 $144 = $93;
 $145 = ((($144)) + 8|0);
 $92 = $145;
 $146 = $92;
 $91 = $146;
 $147 = $91;
 $148 = HEAP32[$147>>2]|0;
 $149 = HEAP32[$143>>2]|0;
 $150 = $148;
 $151 = $149;
 $152 = (($150) - ($151))|0;
 $153 = (($152|0) / 8)&-1;
 $154 = (($141) + ($153<<3)|0);
 $96 = $107;
 $97 = $110;
 $98 = $126;
 $99 = $138;
 $100 = $154;
 $4 = $106;
 $155 = $4;
 $156 = ((($155)) + 8|0);
 $3 = $156;
 $157 = $3;
 $2 = $157;
 $158 = $2;
 $159 = HEAP32[$106>>2]|0;
 $160 = ((($106)) + 4|0);
 $161 = HEAP32[$160>>2]|0;
 $162 = $105;
 $163 = ((($162)) + 4|0);
 $24 = $158;
 $25 = $159;
 $26 = $161;
 $27 = $163;
 while(1) {
  $164 = $26;
  $165 = $25;
  $166 = ($164|0)!=($165|0);
  if (!($166)) {
   break;
  }
  $167 = $24;
  $168 = $27;
  $169 = HEAP32[$168>>2]|0;
  $170 = ((($169)) + -8|0);
  $23 = $170;
  $171 = $23;
  $172 = $26;
  $173 = ((($172)) + -8|0);
  $26 = $173;
  $6 = $173;
  $174 = $6;
  $5 = $174;
  $175 = $5;
  $19 = $167;
  $20 = $171;
  $21 = $175;
  $176 = $19;
  $177 = $20;
  $178 = $21;
  $18 = $178;
  $179 = $18;
  ;HEAP8[$17>>0]=HEAP8[$22>>0]|0;
  $14 = $176;
  $15 = $177;
  $16 = $179;
  $180 = $14;
  $181 = $15;
  $182 = $16;
  $13 = $182;
  $183 = $13;
  $10 = $180;
  $11 = $181;
  $12 = $183;
  $184 = $11;
  $185 = $12;
  $9 = $185;
  $186 = $9;
  $7 = $184;
  $8 = $186;
  $187 = $7;
  $188 = $8;
  $189 = HEAP32[$188>>2]|0;
  HEAP32[$187>>2] = $189;
  $190 = ((($187)) + 4|0);
  $191 = $8;
  $192 = ((($191)) + 4|0);
  $193 = HEAP32[$192>>2]|0;
  HEAP32[$190>>2] = $193;
  $194 = $8;
  HEAP32[$194>>2] = 0;
  $195 = $8;
  $196 = ((($195)) + 4|0);
  HEAP32[$196>>2] = 0;
  $197 = $27;
  $198 = HEAP32[$197>>2]|0;
  $199 = ((($198)) + -8|0);
  HEAP32[$197>>2] = $199;
 }
 $200 = $105;
 $201 = ((($200)) + 4|0);
 $31 = $106;
 $32 = $201;
 $202 = $31;
 $30 = $202;
 $203 = $30;
 $204 = HEAP32[$203>>2]|0;
 HEAP32[$33>>2] = $204;
 $205 = $32;
 $28 = $205;
 $206 = $28;
 $207 = HEAP32[$206>>2]|0;
 $208 = $31;
 HEAP32[$208>>2] = $207;
 $29 = $33;
 $209 = $29;
 $210 = HEAP32[$209>>2]|0;
 $211 = $32;
 HEAP32[$211>>2] = $210;
 $212 = ((($106)) + 4|0);
 $213 = $105;
 $214 = ((($213)) + 8|0);
 $37 = $212;
 $38 = $214;
 $215 = $37;
 $36 = $215;
 $216 = $36;
 $217 = HEAP32[$216>>2]|0;
 HEAP32[$39>>2] = $217;
 $218 = $38;
 $34 = $218;
 $219 = $34;
 $220 = HEAP32[$219>>2]|0;
 $221 = $37;
 HEAP32[$221>>2] = $220;
 $35 = $39;
 $222 = $35;
 $223 = HEAP32[$222>>2]|0;
 $224 = $38;
 HEAP32[$224>>2] = $223;
 $42 = $106;
 $225 = $42;
 $226 = ((($225)) + 8|0);
 $41 = $226;
 $227 = $41;
 $40 = $227;
 $228 = $40;
 $229 = $105;
 $45 = $229;
 $230 = $45;
 $231 = ((($230)) + 12|0);
 $44 = $231;
 $232 = $44;
 $43 = $232;
 $233 = $43;
 $49 = $228;
 $50 = $233;
 $234 = $49;
 $48 = $234;
 $235 = $48;
 $236 = HEAP32[$235>>2]|0;
 HEAP32[$51>>2] = $236;
 $237 = $50;
 $46 = $237;
 $238 = $46;
 $239 = HEAP32[$238>>2]|0;
 $240 = $49;
 HEAP32[$240>>2] = $239;
 $47 = $51;
 $241 = $47;
 $242 = HEAP32[$241>>2]|0;
 $243 = $50;
 HEAP32[$243>>2] = $242;
 $244 = $105;
 $245 = ((($244)) + 4|0);
 $246 = HEAP32[$245>>2]|0;
 $247 = $105;
 HEAP32[$247>>2] = $246;
 $52 = $106;
 $248 = $52;
 $249 = ((($248)) + 4|0);
 $250 = HEAP32[$249>>2]|0;
 $251 = HEAP32[$248>>2]|0;
 $252 = $250;
 $253 = $251;
 $254 = (($252) - ($253))|0;
 $255 = (($254|0) / 8)&-1;
 $76 = $106;
 $77 = $255;
 $256 = $76;
 $75 = $256;
 $257 = $75;
 $258 = HEAP32[$257>>2]|0;
 $74 = $258;
 $259 = $74;
 $54 = $256;
 $260 = $54;
 $261 = HEAP32[$260>>2]|0;
 $53 = $261;
 $262 = $53;
 $59 = $256;
 $263 = $59;
 $58 = $263;
 $264 = $58;
 $57 = $264;
 $265 = $57;
 $266 = ((($265)) + 8|0);
 $56 = $266;
 $267 = $56;
 $55 = $267;
 $268 = $55;
 $269 = HEAP32[$268>>2]|0;
 $270 = HEAP32[$264>>2]|0;
 $271 = $269;
 $272 = $270;
 $273 = (($271) - ($272))|0;
 $274 = (($273|0) / 8)&-1;
 $275 = (($262) + ($274<<3)|0);
 $61 = $256;
 $276 = $61;
 $277 = HEAP32[$276>>2]|0;
 $60 = $277;
 $278 = $60;
 $66 = $256;
 $279 = $66;
 $65 = $279;
 $280 = $65;
 $64 = $280;
 $281 = $64;
 $282 = ((($281)) + 8|0);
 $63 = $282;
 $283 = $63;
 $62 = $283;
 $284 = $62;
 $285 = HEAP32[$284>>2]|0;
 $286 = HEAP32[$280>>2]|0;
 $287 = $285;
 $288 = $286;
 $289 = (($287) - ($288))|0;
 $290 = (($289|0) / 8)&-1;
 $291 = (($278) + ($290<<3)|0);
 $68 = $256;
 $292 = $68;
 $293 = HEAP32[$292>>2]|0;
 $67 = $293;
 $294 = $67;
 $295 = $77;
 $296 = (($294) + ($295<<3)|0);
 $69 = $256;
 $70 = $259;
 $71 = $275;
 $72 = $291;
 $73 = $296;
 $78 = $106;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferINS_10shared_ptrIN6laszip7formats10base_fieldEEERNS_9allocatorIS5_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $49 = ((($48)) + 4|0);
  $24 = $49;
  $50 = $24;
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($41)) + 8|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ((($53)) + -8|0);
  HEAP32[$52>>2] = $54;
  $23 = $54;
  $55 = $23;
  $20 = $51;
  $21 = $55;
  $56 = $20;
  $57 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $56;
  $18 = $57;
  $58 = $17;
  $59 = $18;
  $15 = $58;
  $16 = $59;
  $60 = $16;
  __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEED2Ev($60);
 }
 $61 = HEAP32[$35>>2]|0;
 $62 = ($61|0)!=(0|0);
 if (!($62)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $63 = $14;
 $64 = ((($63)) + 12|0);
 $13 = $64;
 $65 = $13;
 $66 = ((($65)) + 4|0);
 $12 = $66;
 $67 = $12;
 $68 = HEAP32[$67>>2]|0;
 $69 = HEAP32[$35>>2]|0;
 $11 = $35;
 $70 = $11;
 $10 = $70;
 $71 = $10;
 $72 = ((($71)) + 12|0);
 $9 = $72;
 $73 = $9;
 $8 = $73;
 $74 = $8;
 $75 = HEAP32[$74>>2]|0;
 $76 = HEAP32[$70>>2]|0;
 $77 = $75;
 $78 = $76;
 $79 = (($77) - ($78))|0;
 $80 = (($79|0) / 8)&-1;
 $5 = $68;
 $6 = $69;
 $7 = $80;
 $81 = $5;
 $82 = $6;
 $83 = $7;
 $2 = $81;
 $3 = $82;
 $4 = $83;
 $84 = $3;
 $1 = $84;
 $85 = $1;
 __ZdlPv($85);
 STACKTOP = sp;return;
}
function __ZNKSt3__26vectorINS_10shared_ptrIN6laszip7formats10base_fieldEEENS_9allocatorIS5_EEE8max_sizeEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $6 = sp + 8|0;
 $9 = sp + 77|0;
 $12 = sp;
 $14 = sp + 76|0;
 $19 = sp + 16|0;
 $20 = sp + 12|0;
 $18 = $0;
 $21 = $18;
 $17 = $21;
 $22 = $17;
 $23 = ((($22)) + 8|0);
 $16 = $23;
 $24 = $16;
 $15 = $24;
 $25 = $15;
 $13 = $25;
 $26 = $13;
 ;HEAP8[$12>>0]=HEAP8[$14>>0]|0;
 $11 = $26;
 $27 = $11;
 $10 = $27;
 HEAP32[$19>>2] = 536870911;
 HEAP32[$20>>2] = 2147483647;
 $7 = $19;
 $8 = $20;
 $28 = $7;
 $29 = $8;
 ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
 $4 = $28;
 $5 = $29;
 $30 = $5;
 $31 = $4;
 $1 = $6;
 $2 = $30;
 $3 = $31;
 $32 = $2;
 $33 = HEAP32[$32>>2]|0;
 $34 = $3;
 $35 = HEAP32[$34>>2]|0;
 $36 = ($33>>>0)<($35>>>0);
 $37 = $5;
 $38 = $4;
 $39 = $36 ? $37 : $38;
 $40 = HEAP32[$39>>2]|0;
 STACKTOP = sp;return ($40|0);
}
function __ZN6laszip7formats10base_fieldC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (2048);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE8__commonC2Ev($2);
 $3 = ((($2)) + 3980|0);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE13__compressorsC2Ev($3);
 $4 = ((($2)) + 4380|0);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE15__decompressorsC2Ev($4);
 $5 = ((($2)) + 4780|0);
 HEAP8[$5>>0] = 0;
 $6 = ((($2)) + 4781|0);
 HEAP8[$6>>0] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISC_EEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (2024);
 $3 = ((($2)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEED2Ev($3);
 __ZN6laszip7formats10base_fieldD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISC_EEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISC_EEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats10base_field11compressRawEPKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $3;
 STACKTOP = sp;return ($4|0);
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISC_EEEEE13decompressRawEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = ((($4)) + 8|0);
 $6 = ((($4)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $3;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($5,$7,$8)|0);
 STACKTOP = sp;return ($9|0);
}
function __ZN6laszip7formats10base_fieldD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats10base_fieldD0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats10base_fieldD2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats10base_field13decompressRawEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $3;
 STACKTOP = sp;return ($4|0);
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE8__commonC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0;
 var $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0;
 var $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0;
 var $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0;
 var $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0;
 var $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $30 = sp + 124|0;
 $31 = sp + 4|0;
 $29 = $0;
 $33 = $29;
 __ZN6laszip7formats3las7point10C2Ev($33);
 $34 = ((($33)) + 52|0);
 __ZNSt3__25arrayIN6laszip5utils16streaming_medianIiEELj16EEC2Ev($34);
 $35 = ((($33)) + 436|0);
 __ZNSt3__25arrayIN6laszip5utils16streaming_medianIiEELj16EEC2Ev($35);
 $36 = ((($33)) + 852|0);
 __ZN6laszip6models10arithmeticC2EjbPj($36,64,0,0);
 $37 = ((($33)) + 3976|0);
 HEAP8[$37>>0] = 0;
 $38 = ((($33)) + 20|0);
 HEAP16[$30>>1] = 0;
 $27 = $38;
 $28 = $30;
 $39 = $27;
 $40 = $28;
 $24 = $39;
 $25 = 16;
 $26 = $40;
 $41 = $24;
 $42 = $25;
 $23 = $42;
 $43 = $23;
 $44 = $26;
 $20 = $41;
 $21 = $43;
 $22 = $44;
 while(1) {
  $45 = $21;
  $46 = ($45>>>0)>(0);
  if (!($46)) {
   break;
  }
  $47 = $22;
  $48 = HEAP16[$47>>1]|0;
  $49 = $20;
  HEAP16[$49>>1] = $48;
  $50 = $20;
  $51 = ((($50)) + 2|0);
  $20 = $51;
  $52 = $21;
  $53 = (($52) + -1)|0;
  $21 = $53;
 }
 $54 = (__Znwj(44)|0);
 __ZN6laszip6models10arithmeticC2EjbPj($54,256,0,0);
 $55 = ((($33)) + 896|0);
 $18 = $55;
 $19 = 0;
 $56 = $18;
 $57 = $19;
 $58 = (($56) + ($57<<2)|0);
 HEAP32[$58>>2] = $54;
 $59 = (__Znwj(44)|0);
 __ZN6laszip6models10arithmeticC2EjbPj($59,256,0,0);
 $60 = ((($33)) + 896|0);
 $14 = $60;
 $15 = 1;
 $61 = $14;
 $62 = $15;
 $63 = (($61) + ($62<<2)|0);
 HEAP32[$63>>2] = $59;
 $64 = ((($33)) + 820|0);
 HEAP32[$31>>2] = 0;
 $10 = $64;
 $11 = $31;
 $65 = $10;
 $66 = $11;
 $7 = $65;
 $8 = 8;
 $9 = $66;
 $67 = $7;
 $68 = $8;
 $6 = $68;
 $69 = $6;
 $70 = $9;
 $3 = $67;
 $4 = $69;
 $5 = $70;
 while(1) {
  $71 = $4;
  $72 = ($71>>>0)>(0);
  if (!($72)) {
   break;
  }
  $73 = $5;
  $74 = HEAP32[$73>>2]|0;
  $75 = $3;
  HEAP32[$75>>2] = $74;
  $76 = $3;
  $77 = ((($76)) + 4|0);
  $3 = $77;
  $78 = $4;
  $79 = (($78) + -1)|0;
  $4 = $79;
 }
 $32 = 0;
 while(1) {
  $80 = $32;
  $81 = ($80|0)<(256);
  if (!($81)) {
   break;
  }
  $82 = (__Znwj(44)|0);
  __ZN6laszip6models10arithmeticC2EjbPj($82,256,0,0);
  $83 = ((($33)) + 904|0);
  $84 = $32;
  $1 = $83;
  $2 = $84;
  $85 = $1;
  $86 = $2;
  $87 = (($85) + ($86<<2)|0);
  HEAP32[$87>>2] = $82;
  $88 = (__Znwj(44)|0);
  __ZN6laszip6models10arithmeticC2EjbPj($88,256,0,0);
  $89 = ((($33)) + 1928|0);
  $90 = $32;
  $12 = $89;
  $13 = $90;
  $91 = $12;
  $92 = $13;
  $93 = (($91) + ($92<<2)|0);
  HEAP32[$93>>2] = $88;
  $94 = (__Znwj(44)|0);
  __ZN6laszip6models10arithmeticC2EjbPj($94,256,0,0);
  $95 = ((($33)) + 2952|0);
  $96 = $32;
  $16 = $95;
  $17 = $96;
  $97 = $16;
  $98 = $17;
  $99 = (($97) + ($98<<2)|0);
  HEAP32[$99>>2] = $94;
  $100 = $32;
  $101 = (($100) + 1)|0;
  $32 = $101;
 }
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE13__compressorsC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip11compressors7integerC2Ejjjj($2,16,4,8,0);
 $3 = ((($2)) + 80|0);
 __ZN6laszip11compressors7integerC2Ejjjj($3,16,1,8,0);
 $4 = ((($2)) + 160|0);
 __ZN6laszip11compressors7integerC2Ejjjj($4,32,2,8,0);
 $5 = ((($2)) + 240|0);
 __ZN6laszip11compressors7integerC2Ejjjj($5,32,22,8,0);
 $6 = ((($2)) + 320|0);
 __ZN6laszip11compressors7integerC2Ejjjj($6,32,20,8,0);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE15__decompressorsC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13decompressors7integerC2Ejjjj($2,16,4,8,0);
 $3 = ((($2)) + 80|0);
 __ZN6laszip13decompressors7integerC2Ejjjj($3,16,1,8,0);
 $4 = ((($2)) + 160|0);
 __ZN6laszip13decompressors7integerC2Ejjjj($4,32,2,8,0);
 $5 = ((($2)) + 240|0);
 __ZN6laszip13decompressors7integerC2Ejjjj($5,32,22,8,0);
 $6 = ((($2)) + 320|0);
 __ZN6laszip13decompressors7integerC2Ejjjj($6,32,20,8,0);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE13__compressorsD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 320|0);
 __ZN6laszip11compressors7integerD2Ev($3);
 $4 = ((($2)) + 240|0);
 __ZN6laszip11compressors7integerD2Ev($4);
 $5 = ((($2)) + 160|0);
 __ZN6laszip11compressors7integerD2Ev($5);
 $6 = ((($2)) + 80|0);
 __ZN6laszip11compressors7integerD2Ev($6);
 __ZN6laszip11compressors7integerD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE8__commonD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $11 = $0;
 $13 = $11;
 $14 = ((($13)) + 896|0);
 $9 = $14;
 $10 = 0;
 $15 = $9;
 $16 = $10;
 $17 = (($15) + ($16<<2)|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($18|0)==(0|0);
 if (!($19)) {
  __ZN6laszip6models10arithmeticD2Ev($18);
  __ZdlPv($18);
 }
 $20 = ((($13)) + 896|0);
 $7 = $20;
 $8 = 1;
 $21 = $7;
 $22 = $8;
 $23 = (($21) + ($22<<2)|0);
 $24 = HEAP32[$23>>2]|0;
 $25 = ($24|0)==(0|0);
 if (!($25)) {
  __ZN6laszip6models10arithmeticD2Ev($24);
  __ZdlPv($24);
 }
 $12 = 0;
 while(1) {
  $26 = $12;
  $27 = ($26|0)<(256);
  if (!($27)) {
   break;
  }
  $28 = ((($13)) + 904|0);
  $29 = $12;
  $5 = $28;
  $6 = $29;
  $30 = $5;
  $31 = $6;
  $32 = (($30) + ($31<<2)|0);
  $33 = HEAP32[$32>>2]|0;
  $34 = ($33|0)==(0|0);
  if (!($34)) {
   __ZN6laszip6models10arithmeticD2Ev($33);
   __ZdlPv($33);
  }
  $35 = ((($13)) + 1928|0);
  $36 = $12;
  $3 = $35;
  $4 = $36;
  $37 = $3;
  $38 = $4;
  $39 = (($37) + ($38<<2)|0);
  $40 = HEAP32[$39>>2]|0;
  $41 = ($40|0)==(0|0);
  if (!($41)) {
   __ZN6laszip6models10arithmeticD2Ev($40);
   __ZdlPv($40);
  }
  $42 = ((($13)) + 2952|0);
  $43 = $12;
  $1 = $42;
  $2 = $43;
  $44 = $1;
  $45 = $2;
  $46 = (($44) + ($45<<2)|0);
  $47 = HEAP32[$46>>2]|0;
  $48 = ($47|0)==(0|0);
  if (!($48)) {
   __ZN6laszip6models10arithmeticD2Ev($47);
   __ZdlPv($47);
  }
  $49 = $12;
  $50 = (($49) + 1)|0;
  $12 = $50;
 }
 $51 = ((($13)) + 852|0);
 __ZN6laszip6models10arithmeticD2Ev($51);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats3las7point10C2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP8[$2>>0]=0&255;HEAP8[$2+1>>0]=(0>>8)&255;HEAP8[$2+2>>0]=(0>>16)&255;HEAP8[$2+3>>0]=0>>24;
 $3 = ((($2)) + 4|0);
 HEAP8[$3>>0]=0&255;HEAP8[$3+1>>0]=(0>>8)&255;HEAP8[$3+2>>0]=(0>>16)&255;HEAP8[$3+3>>0]=0>>24;
 $4 = ((($2)) + 12|0);
 HEAP8[$4>>0]=0&255;HEAP8[$4+1>>0]=0>>8;
 $5 = ((($2)) + 14|0);
 $6 = HEAP8[$5>>0]|0;
 $7 = $6 & -8;
 HEAP8[$5>>0] = $7;
 $8 = ((($2)) + 14|0);
 $9 = HEAP8[$8>>0]|0;
 $10 = $9 & -57;
 HEAP8[$8>>0] = $10;
 $11 = ((($2)) + 14|0);
 $12 = HEAP8[$11>>0]|0;
 $13 = $12 & -65;
 HEAP8[$11>>0] = $13;
 $14 = ((($2)) + 14|0);
 $15 = HEAP8[$14>>0]|0;
 $16 = $15 & 127;
 HEAP8[$14>>0] = $16;
 $17 = ((($2)) + 15|0);
 HEAP8[$17>>0] = 0;
 $18 = ((($2)) + 16|0);
 HEAP8[$18>>0] = 0;
 $19 = ((($2)) + 17|0);
 HEAP8[$19>>0] = 0;
 $20 = ((($2)) + 18|0);
 HEAP8[$20>>0]=0&255;HEAP8[$20+1>>0]=0>>8;
 STACKTOP = sp;return;
}
function __ZNSt3__25arrayIN6laszip5utils16streaming_medianIiEELj16EEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 384|0);
 $4 = $2;
 while(1) {
  __ZN6laszip5utils16streaming_medianIiEC2Ev($4);
  $5 = ((($4)) + 24|0);
  $6 = ($5|0)==($3|0);
  if ($6) {
   break;
  } else {
   $4 = $5;
  }
 }
 STACKTOP = sp;return;
}
function __ZN6laszip5utils16streaming_medianIiEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip5utils16streaming_medianIiE4initEv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip5utils16streaming_medianIiE4initEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $11 = sp;
 $10 = $0;
 $12 = $10;
 HEAP32[$11>>2] = 0;
 $8 = $12;
 $9 = $11;
 $13 = $8;
 $14 = $9;
 $5 = $13;
 $6 = 5;
 $7 = $14;
 $15 = $5;
 $16 = $6;
 $4 = $16;
 $17 = $4;
 $18 = $7;
 $1 = $15;
 $2 = $17;
 $3 = $18;
 while(1) {
  $19 = $2;
  $20 = ($19>>>0)>(0);
  if (!($20)) {
   break;
  }
  $21 = $3;
  $22 = HEAP32[$21>>2]|0;
  $23 = $1;
  HEAP32[$23>>2] = $22;
  $24 = $1;
  $25 = ((($24)) + 4|0);
  $1 = $25;
  $26 = $2;
  $27 = (($26) + -1)|0;
  $2 = $27;
 }
 $28 = ((($12)) + 20|0);
 HEAP8[$28>>0] = 1;
 STACKTOP = sp;return;
}
function __ZN6laszip11compressors7integerC2Ejjjj($0,$1,$2,$3,$4) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 $4 = $4|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0;
 var $or$cond = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $15 = sp + 72|0;
 $27 = sp + 24|0;
 $29 = $0;
 $30 = $1;
 $31 = $2;
 $32 = $3;
 $33 = $4;
 $34 = $29;
 $35 = ((($34)) + 4|0);
 $36 = $30;
 HEAP32[$35>>2] = $36;
 $37 = ((($34)) + 8|0);
 $38 = $31;
 HEAP32[$37>>2] = $38;
 $39 = ((($34)) + 12|0);
 $40 = $32;
 HEAP32[$39>>2] = $40;
 $41 = ((($34)) + 16|0);
 $42 = $33;
 HEAP32[$41>>2] = $42;
 $43 = ((($34)) + 36|0);
 $28 = $43;
 $44 = $28;
 $26 = $44;
 $45 = $26;
 $25 = $45;
 HEAP32[$45>>2] = 0;
 $46 = ((($45)) + 4|0);
 HEAP32[$46>>2] = 0;
 $47 = ((($45)) + 8|0);
 HEAP32[$27>>2] = 0;
 $23 = $47;
 $24 = $27;
 $48 = $23;
 $49 = $24;
 $22 = $49;
 $50 = $22;
 $18 = $48;
 $19 = $50;
 $51 = $18;
 $52 = $19;
 $17 = $52;
 HEAP32[$51>>2] = 0;
 $21 = $48;
 $53 = $21;
 $20 = $53;
 $54 = ((($34)) + 48|0);
 __ZN6laszip6models14arithmetic_bitC2Ev($54);
 $55 = ((($34)) + 68|0);
 $16 = $55;
 $56 = $16;
 $14 = $56;
 $57 = $14;
 $13 = $57;
 HEAP32[$57>>2] = 0;
 $58 = ((($57)) + 4|0);
 HEAP32[$58>>2] = 0;
 $59 = ((($57)) + 8|0);
 HEAP32[$15>>2] = 0;
 $11 = $59;
 $12 = $15;
 $60 = $11;
 $61 = $12;
 $10 = $61;
 $62 = $10;
 $6 = $60;
 $7 = $62;
 $63 = $6;
 $64 = $7;
 $5 = $64;
 HEAP32[$63>>2] = 0;
 $9 = $60;
 $65 = $9;
 $8 = $65;
 $66 = $33;
 $67 = ($66|0)!=(0);
 if (!($67)) {
  $100 = $30;
  $101 = ($100|0)!=(0);
  $102 = $30;
  $103 = ($102>>>0)<(32);
  $or$cond = $101 & $103;
  if ($or$cond) {
   $104 = $30;
   $105 = ((($34)) + 20|0);
   HEAP32[$105>>2] = $104;
   $106 = $30;
   $107 = 1 << $106;
   $108 = ((($34)) + 24|0);
   HEAP32[$108>>2] = $107;
   $109 = ((($34)) + 24|0);
   $110 = HEAP32[$109>>2]|0;
   $111 = (($110>>>0) / 2)&-1;
   $112 = (0 - ($111))|0;
   $113 = ((($34)) + 28|0);
   HEAP32[$113>>2] = $112;
   $114 = ((($34)) + 28|0);
   $115 = HEAP32[$114>>2]|0;
   $116 = ((($34)) + 24|0);
   $117 = HEAP32[$116>>2]|0;
   $118 = (($115) + ($117))|0;
   $119 = (($118) - 1)|0;
   $120 = ((($34)) + 32|0);
   HEAP32[$120>>2] = $119;
   HEAP32[$34>>2] = 0;
   STACKTOP = sp;return;
  } else {
   $121 = ((($34)) + 20|0);
   HEAP32[$121>>2] = 32;
   $122 = ((($34)) + 24|0);
   HEAP32[$122>>2] = 0;
   $123 = ((($34)) + 28|0);
   HEAP32[$123>>2] = -2147483648;
   $124 = ((($34)) + 32|0);
   HEAP32[$124>>2] = 2147483647;
   HEAP32[$34>>2] = 0;
   STACKTOP = sp;return;
  }
 }
 $68 = ((($34)) + 20|0);
 HEAP32[$68>>2] = 0;
 $69 = $33;
 $70 = ((($34)) + 24|0);
 HEAP32[$70>>2] = $69;
 while(1) {
  $71 = $33;
  $72 = ($71|0)!=(0);
  if (!($72)) {
   break;
  }
  $73 = $33;
  $74 = $73 >>> 1;
  $33 = $74;
  $75 = ((($34)) + 20|0);
  $76 = HEAP32[$75>>2]|0;
  $77 = (($76) + 1)|0;
  HEAP32[$75>>2] = $77;
 }
 $78 = ((($34)) + 24|0);
 $79 = HEAP32[$78>>2]|0;
 $80 = ((($34)) + 20|0);
 $81 = HEAP32[$80>>2]|0;
 $82 = (($81) - 1)|0;
 $83 = 1 << $82;
 $84 = ($79|0)==($83|0);
 if ($84) {
  $85 = ((($34)) + 20|0);
  $86 = HEAP32[$85>>2]|0;
  $87 = (($86) + -1)|0;
  HEAP32[$85>>2] = $87;
 }
 $88 = ((($34)) + 24|0);
 $89 = HEAP32[$88>>2]|0;
 $90 = (($89>>>0) / 2)&-1;
 $91 = (0 - ($90))|0;
 $92 = ((($34)) + 28|0);
 HEAP32[$92>>2] = $91;
 $93 = ((($34)) + 28|0);
 $94 = HEAP32[$93>>2]|0;
 $95 = ((($34)) + 24|0);
 $96 = HEAP32[$95>>2]|0;
 $97 = (($94) + ($96))|0;
 $98 = (($97) - 1)|0;
 $99 = ((($34)) + 32|0);
 HEAP32[$99>>2] = $98;
 HEAP32[$34>>2] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip11compressors7integerD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0;
 var $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0;
 var $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0;
 var $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0;
 var $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0;
 var $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0;
 var $225 = 0, $226 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 336|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(336|0);
 $27 = sp + 8|0;
 $30 = sp + 329|0;
 $68 = sp;
 $71 = sp + 328|0;
 $83 = $0;
 $84 = $83;
 $85 = ((($84)) + 36|0);
 $81 = $85;
 $86 = $81;
 $80 = $86;
 $87 = $80;
 $88 = ((($87)) + 4|0);
 $89 = HEAP32[$88>>2]|0;
 $90 = HEAP32[$87>>2]|0;
 $91 = $89;
 $92 = $90;
 $93 = (($91) - ($92))|0;
 $94 = (($93|0) / 44)&-1;
 $82 = $94;
 $79 = $86;
 $95 = $79;
 $96 = HEAP32[$95>>2]|0;
 $76 = $95;
 $77 = $96;
 $97 = $76;
 $98 = ((($97)) + 4|0);
 $99 = HEAP32[$98>>2]|0;
 $78 = $99;
 while(1) {
  $100 = $77;
  $101 = $78;
  $102 = ($100|0)!=($101|0);
  if (!($102)) {
   break;
  }
  $75 = $97;
  $103 = $75;
  $104 = ((($103)) + 8|0);
  $74 = $104;
  $105 = $74;
  $73 = $105;
  $106 = $73;
  $107 = $78;
  $108 = ((($107)) + -44|0);
  $78 = $108;
  $72 = $108;
  $109 = $72;
  $69 = $106;
  $70 = $109;
  $110 = $69;
  $111 = $70;
  ;HEAP8[$68>>0]=HEAP8[$71>>0]|0;
  $66 = $110;
  $67 = $111;
  $112 = $66;
  $113 = $67;
  $64 = $112;
  $65 = $113;
  $114 = $65;
  __ZN6laszip6models10arithmeticD2Ev($114);
 }
 $115 = $77;
 $116 = ((($97)) + 4|0);
 HEAP32[$116>>2] = $115;
 $117 = $82;
 $62 = $86;
 $63 = $117;
 $118 = $62;
 $61 = $118;
 $119 = $61;
 $120 = HEAP32[$119>>2]|0;
 $60 = $120;
 $121 = $60;
 $44 = $118;
 $122 = $44;
 $123 = HEAP32[$122>>2]|0;
 $43 = $123;
 $124 = $43;
 $49 = $118;
 $125 = $49;
 $48 = $125;
 $126 = $48;
 $47 = $126;
 $127 = $47;
 $128 = ((($127)) + 8|0);
 $46 = $128;
 $129 = $46;
 $45 = $129;
 $130 = $45;
 $131 = HEAP32[$130>>2]|0;
 $132 = HEAP32[$126>>2]|0;
 $133 = $131;
 $134 = $132;
 $135 = (($133) - ($134))|0;
 $136 = (($135|0) / 44)&-1;
 $137 = (($124) + (($136*44)|0)|0);
 $51 = $118;
 $138 = $51;
 $139 = HEAP32[$138>>2]|0;
 $50 = $139;
 $140 = $50;
 $141 = $63;
 $142 = (($140) + (($141*44)|0)|0);
 $53 = $118;
 $143 = $53;
 $144 = HEAP32[$143>>2]|0;
 $52 = $144;
 $145 = $52;
 $54 = $118;
 $146 = $54;
 $147 = ((($146)) + 4|0);
 $148 = HEAP32[$147>>2]|0;
 $149 = HEAP32[$146>>2]|0;
 $150 = $148;
 $151 = $149;
 $152 = (($150) - ($151))|0;
 $153 = (($152|0) / 44)&-1;
 $154 = (($145) + (($153*44)|0)|0);
 $55 = $118;
 $56 = $121;
 $57 = $137;
 $58 = $142;
 $59 = $154;
 $42 = $86;
 $155 = ((($84)) + 68|0);
 $40 = $155;
 $156 = $40;
 $39 = $156;
 $157 = $39;
 $158 = ((($157)) + 4|0);
 $159 = HEAP32[$158>>2]|0;
 $160 = HEAP32[$157>>2]|0;
 $161 = $159;
 $162 = $160;
 $163 = (($161) - ($162))|0;
 $164 = (($163|0) / 44)&-1;
 $41 = $164;
 $38 = $156;
 $165 = $38;
 $166 = HEAP32[$165>>2]|0;
 $35 = $165;
 $36 = $166;
 $167 = $35;
 $168 = ((($167)) + 4|0);
 $169 = HEAP32[$168>>2]|0;
 $37 = $169;
 while(1) {
  $170 = $36;
  $171 = $37;
  $172 = ($170|0)!=($171|0);
  if (!($172)) {
   break;
  }
  $34 = $167;
  $173 = $34;
  $174 = ((($173)) + 8|0);
  $33 = $174;
  $175 = $33;
  $32 = $175;
  $176 = $32;
  $177 = $37;
  $178 = ((($177)) + -44|0);
  $37 = $178;
  $31 = $178;
  $179 = $31;
  $28 = $176;
  $29 = $179;
  $180 = $28;
  $181 = $29;
  ;HEAP8[$27>>0]=HEAP8[$30>>0]|0;
  $25 = $180;
  $26 = $181;
  $182 = $25;
  $183 = $26;
  $23 = $182;
  $24 = $183;
  $184 = $24;
  __ZN6laszip6models10arithmeticD2Ev($184);
 }
 $185 = $36;
 $186 = ((($167)) + 4|0);
 HEAP32[$186>>2] = $185;
 $187 = $41;
 $21 = $156;
 $22 = $187;
 $188 = $21;
 $20 = $188;
 $189 = $20;
 $190 = HEAP32[$189>>2]|0;
 $19 = $190;
 $191 = $19;
 $3 = $188;
 $192 = $3;
 $193 = HEAP32[$192>>2]|0;
 $2 = $193;
 $194 = $2;
 $8 = $188;
 $195 = $8;
 $7 = $195;
 $196 = $7;
 $6 = $196;
 $197 = $6;
 $198 = ((($197)) + 8|0);
 $5 = $198;
 $199 = $5;
 $4 = $199;
 $200 = $4;
 $201 = HEAP32[$200>>2]|0;
 $202 = HEAP32[$196>>2]|0;
 $203 = $201;
 $204 = $202;
 $205 = (($203) - ($204))|0;
 $206 = (($205|0) / 44)&-1;
 $207 = (($194) + (($206*44)|0)|0);
 $10 = $188;
 $208 = $10;
 $209 = HEAP32[$208>>2]|0;
 $9 = $209;
 $210 = $9;
 $211 = $22;
 $212 = (($210) + (($211*44)|0)|0);
 $12 = $188;
 $213 = $12;
 $214 = HEAP32[$213>>2]|0;
 $11 = $214;
 $215 = $11;
 $13 = $188;
 $216 = $13;
 $217 = ((($216)) + 4|0);
 $218 = HEAP32[$217>>2]|0;
 $219 = HEAP32[$216>>2]|0;
 $220 = $218;
 $221 = $219;
 $222 = (($220) - ($221))|0;
 $223 = (($222|0) / 44)&-1;
 $224 = (($215) + (($223*44)|0)|0);
 $14 = $188;
 $15 = $191;
 $16 = $207;
 $17 = $212;
 $18 = $224;
 $1 = $156;
 $225 = ((($84)) + 68|0);
 __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($225);
 $226 = ((($84)) + 36|0);
 __ZNSt3__26vectorIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($226);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 4380|0);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE15__decompressorsD2Ev($3);
 $4 = ((($2)) + 3980|0);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE13__compressorsD2Ev($4);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE8__commonD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE15__decompressorsD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 320|0);
 __ZN6laszip13decompressors7integerD2Ev($3);
 $4 = ((($2)) + 240|0);
 __ZN6laszip13decompressors7integerD2Ev($4);
 $5 = ((($2)) + 160|0);
 __ZN6laszip13decompressors7integerD2Ev($5);
 $6 = ((($2)) + 80|0);
 __ZN6laszip13decompressors7integerD2Ev($6);
 __ZN6laszip13decompressors7integerD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0;
 var $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0;
 var $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0;
 var $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0;
 var $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0;
 var $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0;
 var $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, dest = 0, label = 0, sp = 0, src = 0, stop = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 192|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(192|0);
 $33 = sp + 160|0;
 $40 = sp + 8|0;
 $30 = $0;
 $31 = $1;
 $32 = $2;
 $44 = $30;
 $45 = ((($44)) + 4781|0);
 $46 = HEAP8[$45>>0]|0;
 $47 = $46&1;
 if (!($47)) {
  $48 = ((($44)) + 4380|0);
  __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE15__decompressors4initEv($48);
  $49 = ((($44)) + 4781|0);
  HEAP8[$49>>0] = 1;
 }
 $50 = ((($44)) + 3976|0);
 $51 = HEAP8[$50>>0]|0;
 $52 = $51&1;
 if (!($52)) {
  $53 = ((($44)) + 3976|0);
  HEAP8[$53>>0] = 1;
  $54 = $31;
  $55 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE11getInStreamEv($54)|0);
  $56 = $32;
  __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE8getBytesEPhj($55,$56,20);
  $57 = $32;
  __ZN6laszip7formats7packersINS0_3las7point10EE6unpackEPKc($33,$57);
  dest=$44; src=$33; stop=dest+20|0; do { HEAP8[dest>>0]=HEAP8[src>>0]|0; dest=dest+1|0; src=src+1|0; } while ((dest|0) < (stop|0));
  $58 = $32;
  $59 = ((($58)) + 20|0);
  $29 = $59;
  $311 = $29;
  STACKTOP = sp;return ($311|0);
 }
 $60 = $31;
 $61 = ((($44)) + 852|0);
 $62 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($60,$61)|0);
 $41 = $62;
 $63 = $41;
 $64 = ($63|0)!=(0);
 if ($64) {
  $65 = $41;
  $66 = $65 & 32;
  $67 = ($66|0)!=(0);
  if ($67) {
   $68 = (__ZN6laszip7formats6detail17bitfields_to_charERKNS0_3las7point10E($44)|0);
   $42 = $68;
   $69 = $31;
   $70 = ((($44)) + 904|0);
   $71 = $42;
   $72 = $71&255;
   $27 = $70;
   $28 = $72;
   $73 = $27;
   $74 = $28;
   $75 = (($73) + ($74<<2)|0);
   $76 = HEAP32[$75>>2]|0;
   $77 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($69,$76)|0);
   $78 = $77&255;
   $42 = $78;
   $79 = $42;
   __ZN6laszip7formats6detail17char_to_bitfieldsEhRNS0_3las7point10E($79,$44);
  }
  $80 = ((($44)) + 14|0);
  $81 = HEAP8[$80>>0]|0;
  $82 = $81 & 7;
  $83 = $82&255;
  $34 = $83;
  $84 = ((($44)) + 14|0);
  $85 = HEAP8[$84>>0]|0;
  $86 = ($85&255) >>> 3;
  $87 = $86 & 7;
  $88 = $87&255;
  $35 = $88;
  $89 = $35;
  $90 = (6646 + ($89<<3)|0);
  $91 = $34;
  $92 = (($90) + ($91)|0);
  $93 = HEAP8[$92>>0]|0;
  $94 = $93&255;
  $36 = $94;
  $95 = $35;
  $96 = (6710 + ($95<<3)|0);
  $97 = $34;
  $98 = (($96) + ($97)|0);
  $99 = HEAP8[$98>>0]|0;
  $100 = $99&255;
  $37 = $100;
  $101 = $41;
  $102 = $101 & 16;
  $103 = ($102|0)!=(0);
  if ($103) {
   $104 = ((($44)) + 4380|0);
   $105 = $31;
   $106 = ((($44)) + 20|0);
   $107 = $36;
   $25 = $106;
   $26 = $107;
   $108 = $25;
   $109 = $26;
   $110 = (($108) + ($109<<1)|0);
   $111 = HEAP16[$110>>1]|0;
   $112 = $111&65535;
   $113 = $36;
   $114 = ($113>>>0)<(3);
   $115 = $36;
   $116 = $114 ? $115 : 3;
   $117 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($104,$105,$112,$116)|0);
   $118 = $117&65535;
   $119 = ((($44)) + 12|0);
   HEAP16[$119>>1] = $118;
   $120 = ((($44)) + 12|0);
   $121 = HEAP16[$120>>1]|0;
   $122 = ((($44)) + 20|0);
   $123 = $36;
   $21 = $122;
   $22 = $123;
   $124 = $21;
   $125 = $22;
   $126 = (($124) + ($125<<1)|0);
   HEAP16[$126>>1] = $121;
  } else {
   $127 = ((($44)) + 20|0);
   $128 = $36;
   $17 = $127;
   $18 = $128;
   $129 = $17;
   $130 = $18;
   $131 = (($129) + ($130<<1)|0);
   $132 = HEAP16[$131>>1]|0;
   $133 = ((($44)) + 12|0);
   HEAP16[$133>>1] = $132;
  }
  $134 = $41;
  $135 = $134 & 8;
  $136 = ($135|0)!=(0);
  if ($136) {
   $137 = $31;
   $138 = ((($44)) + 1928|0);
   $139 = ((($44)) + 15|0);
   $140 = HEAP8[$139>>0]|0;
   $141 = $140&255;
   $15 = $138;
   $16 = $141;
   $142 = $15;
   $143 = $16;
   $144 = (($142) + ($143<<2)|0);
   $145 = HEAP32[$144>>2]|0;
   $146 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($137,$145)|0);
   $147 = $146&255;
   $148 = ((($44)) + 15|0);
   HEAP8[$148>>0] = $147;
  }
  $149 = $41;
  $150 = $149 & 4;
  $151 = ($150|0)!=(0);
  if ($151) {
   $152 = $31;
   $153 = ((($44)) + 896|0);
   $154 = ((($44)) + 14|0);
   $155 = HEAP8[$154>>0]|0;
   $156 = ($155&255) >>> 6;
   $157 = $156 & 1;
   $158 = $157&255;
   $13 = $153;
   $14 = $158;
   $159 = $13;
   $160 = $14;
   $161 = (($159) + ($160<<2)|0);
   $162 = HEAP32[$161>>2]|0;
   $163 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($152,$162)|0);
   $43 = $163;
   $164 = $43;
   $165 = ((($44)) + 16|0);
   $166 = HEAP8[$165>>0]|0;
   $167 = $166 << 24 >> 24;
   $168 = (($164) + ($167))|0;
   $169 = (__Z7U8_FOLDi($168)|0);
   $170 = ((($44)) + 16|0);
   HEAP8[$170>>0] = $169;
  }
  $171 = $41;
  $172 = $171 & 2;
  $173 = ($172|0)!=(0);
  if ($173) {
   $174 = $31;
   $175 = ((($44)) + 2952|0);
   $176 = ((($44)) + 17|0);
   $177 = HEAP8[$176>>0]|0;
   $178 = $177&255;
   $9 = $175;
   $10 = $178;
   $179 = $9;
   $180 = $10;
   $181 = (($179) + ($180<<2)|0);
   $182 = HEAP32[$181>>2]|0;
   $183 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($174,$182)|0);
   $184 = $183&255;
   $185 = ((($44)) + 17|0);
   HEAP8[$185>>0] = $184;
  }
  $186 = $41;
  $187 = $186 & 1;
  $188 = ($187|0)!=(0);
  if ($188) {
   $189 = ((($44)) + 4380|0);
   $190 = ((($189)) + 80|0);
   $191 = $31;
   $192 = ((($44)) + 18|0);
   $193 = HEAP16[$192>>1]|0;
   $194 = $193&65535;
   $195 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($190,$191,$194,0)|0);
   $196 = $195&65535;
   $197 = ((($44)) + 18|0);
   HEAP16[$197>>1] = $196;
  }
 } else {
  $198 = ((($44)) + 14|0);
  $199 = HEAP8[$198>>0]|0;
  $200 = $199 & 7;
  $201 = $200&255;
  $34 = $201;
  $202 = ((($44)) + 14|0);
  $203 = HEAP8[$202>>0]|0;
  $204 = ($203&255) >>> 3;
  $205 = $204 & 7;
  $206 = $205&255;
  $35 = $206;
  $207 = $35;
  $208 = (6646 + ($207<<3)|0);
  $209 = $34;
  $210 = (($208) + ($209)|0);
  $211 = HEAP8[$210>>0]|0;
  $212 = $211&255;
  $36 = $212;
  $213 = $35;
  $214 = (6710 + ($213<<3)|0);
  $215 = $34;
  $216 = (($214) + ($215)|0);
  $217 = HEAP8[$216>>0]|0;
  $218 = $217&255;
  $37 = $218;
 }
 $219 = ((($44)) + 52|0);
 $220 = $36;
 $7 = $219;
 $8 = $220;
 $221 = $7;
 $222 = $8;
 $223 = (($221) + (($222*24)|0)|0);
 $224 = (__ZNK6laszip5utils16streaming_medianIiE3getEv($223)|0);
 $39 = $224;
 $225 = ((($44)) + 4380|0);
 $226 = ((($225)) + 160|0);
 $227 = $31;
 $228 = $39;
 $229 = $35;
 $230 = ($229|0)==(1);
 $231 = $230&1;
 $232 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($226,$227,$228,$231)|0);
 HEAP32[$40>>2] = $232;
 $233 = HEAP32[$40>>2]|0;
 $234 = HEAP32[$44>>2]|0;
 $235 = (($234) + ($233))|0;
 HEAP32[$44>>2] = $235;
 $236 = ((($44)) + 52|0);
 $237 = $36;
 $5 = $236;
 $6 = $237;
 $238 = $5;
 $239 = $6;
 $240 = (($238) + (($239*24)|0)|0);
 __ZN6laszip5utils16streaming_medianIiE3addERKi($240,$40);
 $241 = ((($44)) + 436|0);
 $242 = $36;
 $3 = $241;
 $4 = $242;
 $243 = $3;
 $244 = $4;
 $245 = (($243) + (($244*24)|0)|0);
 $246 = (__ZNK6laszip5utils16streaming_medianIiE3getEv($245)|0);
 $39 = $246;
 $247 = ((($44)) + 4380|0);
 $248 = ((($247)) + 160|0);
 $249 = (__ZNK6laszip13decompressors7integer4getKEv($248)|0);
 $38 = $249;
 $250 = ((($44)) + 4380|0);
 $251 = ((($250)) + 240|0);
 $252 = $31;
 $253 = $39;
 $254 = $35;
 $255 = ($254|0)==(1);
 $256 = $255&1;
 $257 = $38;
 $258 = ($257>>>0)<(20);
 $259 = $38;
 $260 = $259 & -2;
 $261 = $258 ? $260 : 20;
 $262 = (($256) + ($261))|0;
 $263 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($251,$252,$253,$262)|0);
 HEAP32[$40>>2] = $263;
 $264 = HEAP32[$40>>2]|0;
 $265 = ((($44)) + 4|0);
 $266 = HEAP32[$265>>2]|0;
 $267 = (($266) + ($264))|0;
 HEAP32[$265>>2] = $267;
 $268 = ((($44)) + 436|0);
 $269 = $36;
 $11 = $268;
 $12 = $269;
 $270 = $11;
 $271 = $12;
 $272 = (($270) + (($271*24)|0)|0);
 __ZN6laszip5utils16streaming_medianIiE3addERKi($272,$40);
 $273 = ((($44)) + 4380|0);
 $274 = ((($273)) + 160|0);
 $275 = (__ZNK6laszip13decompressors7integer4getKEv($274)|0);
 $276 = ((($44)) + 4380|0);
 $277 = ((($276)) + 240|0);
 $278 = (__ZNK6laszip13decompressors7integer4getKEv($277)|0);
 $279 = (($275) + ($278))|0;
 $280 = (($279>>>0) / 2)&-1;
 $38 = $280;
 $281 = ((($44)) + 4380|0);
 $282 = ((($281)) + 320|0);
 $283 = $31;
 $284 = ((($44)) + 820|0);
 $285 = $37;
 $19 = $284;
 $20 = $285;
 $286 = $19;
 $287 = $20;
 $288 = (($286) + ($287<<2)|0);
 $289 = HEAP32[$288>>2]|0;
 $290 = $35;
 $291 = ($290|0)==(1);
 $292 = $291&1;
 $293 = $38;
 $294 = ($293>>>0)<(18);
 $295 = $38;
 $296 = $295 & -2;
 $297 = $294 ? $296 : 18;
 $298 = (($292) + ($297))|0;
 $299 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($282,$283,$289,$298)|0);
 $300 = ((($44)) + 8|0);
 HEAP32[$300>>2] = $299;
 $301 = ((($44)) + 8|0);
 $302 = HEAP32[$301>>2]|0;
 $303 = ((($44)) + 820|0);
 $304 = $37;
 $23 = $303;
 $24 = $304;
 $305 = $23;
 $306 = $24;
 $307 = (($305) + ($306<<2)|0);
 HEAP32[$307>>2] = $302;
 $308 = $32;
 __ZN6laszip7formats7packersINS0_3las7point10EE4packERKS3_Pc($44,$308);
 $309 = $32;
 $310 = ((($309)) + 20|0);
 $29 = $310;
 $311 = $29;
 STACKTOP = sp;return ($311|0);
}
function __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE15__decompressors4initEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13decompressors7integer4initEv($2);
 $3 = ((($2)) + 80|0);
 __ZN6laszip13decompressors7integer4initEv($3);
 $4 = ((($2)) + 160|0);
 __ZN6laszip13decompressors7integer4initEv($4);
 $5 = ((($2)) + 240|0);
 __ZN6laszip13decompressors7integer4initEv($5);
 $6 = ((($2)) + 320|0);
 __ZN6laszip13decompressors7integer4initEv($6);
 STACKTOP = sp;return;
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE11getInStreamEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($3|0);
}
function __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE8getBytesEPhj($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0;
 var $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0;
 var $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $26 = sp;
 $29 = sp + 124|0;
 $32 = sp + 12|0;
 $34 = sp + 4|0;
 $30 = $0;
 $31 = $1;
 HEAP32[$32>>2] = $2;
 $35 = $30;
 $36 = ((($35)) + 8|0);
 $37 = HEAP32[$36>>2]|0;
 $38 = ((($35)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $40 = (($37) - ($39))|0;
 HEAP32[$34>>2] = $40;
 $27 = $34;
 $28 = $32;
 $41 = $27;
 $42 = $28;
 ;HEAP8[$26>>0]=HEAP8[$29>>0]|0;
 $24 = $41;
 $25 = $42;
 $43 = $25;
 $44 = $24;
 $21 = $26;
 $22 = $43;
 $23 = $44;
 $45 = $22;
 $46 = HEAP32[$45>>2]|0;
 $47 = $23;
 $48 = HEAP32[$47>>2]|0;
 $49 = ($46>>>0)<($48>>>0);
 $50 = $25;
 $51 = $24;
 $52 = $49 ? $50 : $51;
 $53 = HEAP32[$52>>2]|0;
 $33 = $53;
 $54 = ((($35)) + 12|0);
 $55 = HEAP32[$54>>2]|0;
 $56 = ((($35)) + 4|0);
 $57 = HEAP32[$56>>2]|0;
 $58 = (($55) + ($57)|0);
 $59 = ((($35)) + 12|0);
 $60 = HEAP32[$59>>2]|0;
 $61 = ((($35)) + 4|0);
 $62 = HEAP32[$61>>2]|0;
 $63 = (($60) + ($62)|0);
 $64 = $33;
 $65 = (($63) + ($64)|0);
 $66 = $31;
 $9 = $58;
 $10 = $65;
 $11 = $66;
 $67 = $9;
 $8 = $67;
 $68 = $8;
 $69 = $10;
 $3 = $69;
 $70 = $3;
 $71 = $11;
 $4 = $71;
 $72 = $4;
 $5 = $68;
 $6 = $70;
 $7 = $72;
 while(1) {
  $73 = $5;
  $74 = $6;
  $75 = ($73|0)!=($74|0);
  if (!($75)) {
   break;
  }
  $76 = $5;
  $77 = HEAP8[$76>>0]|0;
  $78 = $7;
  HEAP8[$78>>0] = $77;
  $79 = $5;
  $80 = ((($79)) + 1|0);
  $5 = $80;
  $81 = $7;
  $82 = ((($81)) + 1|0);
  $7 = $82;
 }
 $83 = $33;
 $84 = ((($35)) + 4|0);
 $85 = HEAP32[$84>>2]|0;
 $86 = (($85) + ($83))|0;
 HEAP32[$84>>2] = $86;
 $87 = $33;
 $88 = HEAP32[$32>>2]|0;
 $89 = (($88) - ($87))|0;
 HEAP32[$32>>2] = $89;
 $90 = HEAP32[$32>>2]|0;
 $91 = ($90|0)!=(0);
 if (!($91)) {
  STACKTOP = sp;return;
 }
 __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE7fillit_Ev($35);
 $92 = ((($35)) + 12|0);
 $93 = HEAP32[$92>>2]|0;
 $94 = ((($35)) + 4|0);
 $95 = HEAP32[$94>>2]|0;
 $96 = (($93) + ($95)|0);
 $97 = ((($35)) + 12|0);
 $98 = HEAP32[$97>>2]|0;
 $99 = ((($35)) + 4|0);
 $100 = HEAP32[$99>>2]|0;
 $101 = (($98) + ($100)|0);
 $102 = HEAP32[$32>>2]|0;
 $103 = (($101) + ($102)|0);
 $104 = $31;
 $105 = $33;
 $106 = (($104) + ($105)|0);
 $18 = $96;
 $19 = $103;
 $20 = $106;
 $107 = $18;
 $17 = $107;
 $108 = $17;
 $109 = $19;
 $12 = $109;
 $110 = $12;
 $111 = $20;
 $13 = $111;
 $112 = $13;
 $14 = $108;
 $15 = $110;
 $16 = $112;
 while(1) {
  $113 = $14;
  $114 = $15;
  $115 = ($113|0)!=($114|0);
  if (!($115)) {
   break;
  }
  $116 = $14;
  $117 = HEAP8[$116>>0]|0;
  $118 = $16;
  HEAP8[$118>>0] = $117;
  $119 = $14;
  $120 = ((($119)) + 1|0);
  $14 = $120;
  $121 = $16;
  $122 = ((($121)) + 1|0);
  $16 = $122;
 }
 $123 = HEAP32[$32>>2]|0;
 $124 = ((($35)) + 4|0);
 $125 = HEAP32[$124>>2]|0;
 $126 = (($125) + ($123))|0;
 HEAP32[$124>>2] = $126;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersINS0_3las7point10EE6unpackEPKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $1;
 __ZN6laszip7formats3las7point10C2Ev($0);
 $4 = $2;
 $5 = (__ZN6laszip7formats7packersIiE6unpackEPKc($4)|0);
 HEAP8[$0>>0]=$5&255;HEAP8[$0+1>>0]=($5>>8)&255;HEAP8[$0+2>>0]=($5>>16)&255;HEAP8[$0+3>>0]=$5>>24;
 $6 = $2;
 $7 = ((($6)) + 4|0);
 $2 = $7;
 $8 = $2;
 $9 = (__ZN6laszip7formats7packersIiE6unpackEPKc($8)|0);
 $10 = ((($0)) + 4|0);
 HEAP8[$10>>0]=$9&255;HEAP8[$10+1>>0]=($9>>8)&255;HEAP8[$10+2>>0]=($9>>16)&255;HEAP8[$10+3>>0]=$9>>24;
 $11 = $2;
 $12 = ((($11)) + 4|0);
 $2 = $12;
 $13 = $2;
 $14 = (__ZN6laszip7formats7packersIiE6unpackEPKc($13)|0);
 $15 = ((($0)) + 8|0);
 HEAP8[$15>>0]=$14&255;HEAP8[$15+1>>0]=($14>>8)&255;HEAP8[$15+2>>0]=($14>>16)&255;HEAP8[$15+3>>0]=$14>>24;
 $16 = $2;
 $17 = ((($16)) + 4|0);
 $2 = $17;
 $18 = $2;
 $19 = (__ZN6laszip7formats7packersItE6unpackEPKc($18)|0);
 $20 = ((($0)) + 12|0);
 HEAP8[$20>>0]=$19&255;HEAP8[$20+1>>0]=$19>>8;
 $21 = $2;
 $22 = ((($21)) + 2|0);
 $2 = $22;
 $23 = $2;
 $24 = (__ZN6laszip7formats7packersIhE6unpackEPKc($23)|0);
 $3 = $24;
 $25 = $2;
 $26 = ((($25)) + 1|0);
 $2 = $26;
 $27 = $3;
 __ZN6laszip7formats6detail17char_to_bitfieldsEhRNS0_3las7point10E($27,$0);
 $28 = $2;
 $29 = (__ZN6laszip7formats7packersIhE6unpackEPKc($28)|0);
 $30 = ((($0)) + 15|0);
 HEAP8[$30>>0] = $29;
 $31 = $2;
 $32 = ((($31)) + 1|0);
 $2 = $32;
 $33 = $2;
 $34 = (__ZN6laszip7formats7packersIcE6unpackEPKc($33)|0);
 $35 = ((($0)) + 16|0);
 HEAP8[$35>>0] = $34;
 $36 = $2;
 $37 = ((($36)) + 1|0);
 $2 = $37;
 $38 = $2;
 $39 = (__ZN6laszip7formats7packersIcE6unpackEPKc($38)|0);
 $40 = ((($0)) + 17|0);
 HEAP8[$40>>0] = $39;
 $41 = $2;
 $42 = ((($41)) + 1|0);
 $2 = $42;
 $43 = $2;
 $44 = (__ZN6laszip7formats7packersItE6unpackEPKc($43)|0);
 $45 = ((($0)) + 18|0);
 HEAP8[$45>>0]=$44&255;HEAP8[$45+1>>0]=$44>>8;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats6detail17bitfields_to_charERKNS0_3las7point10E($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0, $7 = 0;
 var $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $6 = $1;
 $7 = ((($6)) + 14|0);
 $8 = HEAP8[$7>>0]|0;
 $9 = $8 & 7;
 $2 = $9;
 $10 = $1;
 $11 = ((($10)) + 14|0);
 $12 = HEAP8[$11>>0]|0;
 $13 = ($12&255) >>> 3;
 $14 = $13 & 7;
 $3 = $14;
 $15 = $1;
 $16 = ((($15)) + 14|0);
 $17 = HEAP8[$16>>0]|0;
 $18 = ($17&255) >>> 6;
 $19 = $18 & 1;
 $4 = $19;
 $20 = $1;
 $21 = ((($20)) + 14|0);
 $22 = HEAP8[$21>>0]|0;
 $23 = ($22&255) >>> 7;
 $5 = $23;
 $24 = $5;
 $25 = $24&255;
 $26 = $25 & 1;
 $27 = $26 << 7;
 $28 = $4;
 $29 = $28&255;
 $30 = $29 & 1;
 $31 = $30 << 6;
 $32 = $27 | $31;
 $33 = $3;
 $34 = $33&255;
 $35 = $34 & 7;
 $36 = $35 << 3;
 $37 = $32 | $36;
 $38 = $2;
 $39 = $38&255;
 $40 = $39 & 7;
 $41 = $37 | $40;
 $42 = $41&255;
 STACKTOP = sp;return ($42|0);
}
function __ZN6laszip7formats6detail17char_to_bitfieldsEhRNS0_3las7point10E($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $4&255;
 $6 = $5 & 7;
 $7 = $6&255;
 $8 = $3;
 $9 = ((($8)) + 14|0);
 $10 = HEAP8[$9>>0]|0;
 $11 = $7 & 7;
 $12 = $10 & -8;
 $13 = $12 | $11;
 HEAP8[$9>>0] = $13;
 $14 = $2;
 $15 = $14&255;
 $16 = $15 >> 3;
 $17 = $16 & 7;
 $18 = $17&255;
 $19 = $3;
 $20 = ((($19)) + 14|0);
 $21 = HEAP8[$20>>0]|0;
 $22 = $18 & 7;
 $23 = ($22 << 3)&255;
 $24 = $21 & -57;
 $25 = $24 | $23;
 HEAP8[$20>>0] = $25;
 $26 = $2;
 $27 = $26&255;
 $28 = $27 >> 6;
 $29 = $28 & 1;
 $30 = $29&255;
 $31 = $3;
 $32 = ((($31)) + 14|0);
 $33 = HEAP8[$32>>0]|0;
 $34 = $30 & 1;
 $35 = ($34 << 6)&255;
 $36 = $33 & -65;
 $37 = $36 | $35;
 HEAP8[$32>>0] = $37;
 $38 = $2;
 $39 = $38&255;
 $40 = $39 >> 7;
 $41 = $40 & 1;
 $42 = $41&255;
 $43 = $3;
 $44 = ((($43)) + 14|0);
 $45 = HEAP8[$44>>0]|0;
 $46 = $42 & 1;
 $47 = ($46 << 7)&255;
 $48 = $45 & 127;
 $49 = $48 | $47;
 HEAP8[$44>>0] = $49;
 STACKTOP = sp;return;
}
function __Z7U8_FOLDi($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = $2&255;
 STACKTOP = sp;return ($3|0);
}
function __ZNK6laszip5utils16streaming_medianIiE3getEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $3;
 $1 = $4;
 $2 = 2;
 $5 = $1;
 $6 = $2;
 $7 = (($5) + ($6<<2)|0);
 $8 = HEAP32[$7>>2]|0;
 STACKTOP = sp;return ($8|0);
}
function __ZN6laszip5utils16streaming_medianIiE3addERKi($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0;
 var $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0;
 var $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0;
 var $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0;
 var $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0;
 var $280 = 0, $281 = 0, $282 = 0, $283 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 352|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(352|0);
 $86 = $0;
 $87 = $1;
 $88 = $86;
 $89 = ((($88)) + 20|0);
 $90 = HEAP8[$89>>0]|0;
 $91 = $90&1;
 if ($91) {
  $92 = $87;
  $93 = HEAP32[$92>>2]|0;
  $84 = $88;
  $85 = 2;
  $94 = $84;
  $95 = $85;
  $96 = (($94) + ($95<<2)|0);
  $97 = HEAP32[$96>>2]|0;
  $98 = ($93|0)<($97|0);
  if (!($98)) {
   $163 = $87;
   $164 = HEAP32[$163>>2]|0;
   $32 = $88;
   $33 = 3;
   $165 = $32;
   $166 = $33;
   $167 = (($165) + ($166<<2)|0);
   $168 = HEAP32[$167>>2]|0;
   $169 = ($164|0)<($168|0);
   if ($169) {
    $34 = $88;
    $35 = 3;
    $170 = $34;
    $171 = $35;
    $172 = (($170) + ($171<<2)|0);
    $173 = HEAP32[$172>>2]|0;
    $36 = $88;
    $37 = 4;
    $174 = $36;
    $175 = $37;
    $176 = (($174) + ($175<<2)|0);
    HEAP32[$176>>2] = $173;
    $177 = $87;
    $178 = HEAP32[$177>>2]|0;
    $38 = $88;
    $39 = 3;
    $179 = $38;
    $180 = $39;
    $181 = (($179) + ($180<<2)|0);
    HEAP32[$181>>2] = $178;
   } else {
    $182 = $87;
    $183 = HEAP32[$182>>2]|0;
    $40 = $88;
    $41 = 4;
    $184 = $40;
    $185 = $41;
    $186 = (($184) + ($185<<2)|0);
    HEAP32[$186>>2] = $183;
   }
   $187 = ((($88)) + 20|0);
   HEAP8[$187>>0] = 0;
   STACKTOP = sp;return;
  }
  $2 = $88;
  $3 = 3;
  $99 = $2;
  $100 = $3;
  $101 = (($99) + ($100<<2)|0);
  $102 = HEAP32[$101>>2]|0;
  $4 = $88;
  $5 = 4;
  $103 = $4;
  $104 = $5;
  $105 = (($103) + ($104<<2)|0);
  HEAP32[$105>>2] = $102;
  $6 = $88;
  $7 = 2;
  $106 = $6;
  $107 = $7;
  $108 = (($106) + ($107<<2)|0);
  $109 = HEAP32[$108>>2]|0;
  $8 = $88;
  $9 = 3;
  $110 = $8;
  $111 = $9;
  $112 = (($110) + ($111<<2)|0);
  HEAP32[$112>>2] = $109;
  $113 = $87;
  $114 = HEAP32[$113>>2]|0;
  $10 = $88;
  $11 = 0;
  $115 = $10;
  $116 = $11;
  $117 = (($115) + ($116<<2)|0);
  $118 = HEAP32[$117>>2]|0;
  $119 = ($114|0)<($118|0);
  if ($119) {
   $12 = $88;
   $13 = 1;
   $120 = $12;
   $121 = $13;
   $122 = (($120) + ($121<<2)|0);
   $123 = HEAP32[$122>>2]|0;
   $14 = $88;
   $15 = 2;
   $124 = $14;
   $125 = $15;
   $126 = (($124) + ($125<<2)|0);
   HEAP32[$126>>2] = $123;
   $16 = $88;
   $17 = 0;
   $127 = $16;
   $128 = $17;
   $129 = (($127) + ($128<<2)|0);
   $130 = HEAP32[$129>>2]|0;
   $18 = $88;
   $19 = 1;
   $131 = $18;
   $132 = $19;
   $133 = (($131) + ($132<<2)|0);
   HEAP32[$133>>2] = $130;
   $134 = $87;
   $135 = HEAP32[$134>>2]|0;
   $20 = $88;
   $21 = 0;
   $136 = $20;
   $137 = $21;
   $138 = (($136) + ($137<<2)|0);
   HEAP32[$138>>2] = $135;
   STACKTOP = sp;return;
  }
  $139 = $87;
  $140 = HEAP32[$139>>2]|0;
  $22 = $88;
  $23 = 1;
  $141 = $22;
  $142 = $23;
  $143 = (($141) + ($142<<2)|0);
  $144 = HEAP32[$143>>2]|0;
  $145 = ($140|0)<($144|0);
  if ($145) {
   $24 = $88;
   $25 = 1;
   $146 = $24;
   $147 = $25;
   $148 = (($146) + ($147<<2)|0);
   $149 = HEAP32[$148>>2]|0;
   $26 = $88;
   $27 = 2;
   $150 = $26;
   $151 = $27;
   $152 = (($150) + ($151<<2)|0);
   HEAP32[$152>>2] = $149;
   $153 = $87;
   $154 = HEAP32[$153>>2]|0;
   $28 = $88;
   $29 = 1;
   $155 = $28;
   $156 = $29;
   $157 = (($155) + ($156<<2)|0);
   HEAP32[$157>>2] = $154;
   STACKTOP = sp;return;
  } else {
   $158 = $87;
   $159 = HEAP32[$158>>2]|0;
   $30 = $88;
   $31 = 2;
   $160 = $30;
   $161 = $31;
   $162 = (($160) + ($161<<2)|0);
   HEAP32[$162>>2] = $159;
   STACKTOP = sp;return;
  }
 } else {
  $42 = $88;
  $43 = 2;
  $188 = $42;
  $189 = $43;
  $190 = (($188) + ($189<<2)|0);
  $191 = HEAP32[$190>>2]|0;
  $192 = $87;
  $193 = HEAP32[$192>>2]|0;
  $194 = ($191|0)<($193|0);
  if (!($194)) {
   $74 = $88;
   $75 = 1;
   $259 = $74;
   $260 = $75;
   $261 = (($259) + ($260<<2)|0);
   $262 = HEAP32[$261>>2]|0;
   $263 = $87;
   $264 = HEAP32[$263>>2]|0;
   $265 = ($262|0)<($264|0);
   if ($265) {
    $76 = $88;
    $77 = 1;
    $266 = $76;
    $267 = $77;
    $268 = (($266) + ($267<<2)|0);
    $269 = HEAP32[$268>>2]|0;
    $78 = $88;
    $79 = 0;
    $270 = $78;
    $271 = $79;
    $272 = (($270) + ($271<<2)|0);
    HEAP32[$272>>2] = $269;
    $273 = $87;
    $274 = HEAP32[$273>>2]|0;
    $80 = $88;
    $81 = 1;
    $275 = $80;
    $276 = $81;
    $277 = (($275) + ($276<<2)|0);
    HEAP32[$277>>2] = $274;
   } else {
    $278 = $87;
    $279 = HEAP32[$278>>2]|0;
    $82 = $88;
    $83 = 0;
    $280 = $82;
    $281 = $83;
    $282 = (($280) + ($281<<2)|0);
    HEAP32[$282>>2] = $279;
   }
   $283 = ((($88)) + 20|0);
   HEAP8[$283>>0] = 1;
   STACKTOP = sp;return;
  }
  $44 = $88;
  $45 = 1;
  $195 = $44;
  $196 = $45;
  $197 = (($195) + ($196<<2)|0);
  $198 = HEAP32[$197>>2]|0;
  $46 = $88;
  $47 = 0;
  $199 = $46;
  $200 = $47;
  $201 = (($199) + ($200<<2)|0);
  HEAP32[$201>>2] = $198;
  $48 = $88;
  $49 = 2;
  $202 = $48;
  $203 = $49;
  $204 = (($202) + ($203<<2)|0);
  $205 = HEAP32[$204>>2]|0;
  $50 = $88;
  $51 = 1;
  $206 = $50;
  $207 = $51;
  $208 = (($206) + ($207<<2)|0);
  HEAP32[$208>>2] = $205;
  $52 = $88;
  $53 = 4;
  $209 = $52;
  $210 = $53;
  $211 = (($209) + ($210<<2)|0);
  $212 = HEAP32[$211>>2]|0;
  $213 = $87;
  $214 = HEAP32[$213>>2]|0;
  $215 = ($212|0)<($214|0);
  if ($215) {
   $54 = $88;
   $55 = 3;
   $216 = $54;
   $217 = $55;
   $218 = (($216) + ($217<<2)|0);
   $219 = HEAP32[$218>>2]|0;
   $56 = $88;
   $57 = 2;
   $220 = $56;
   $221 = $57;
   $222 = (($220) + ($221<<2)|0);
   HEAP32[$222>>2] = $219;
   $58 = $88;
   $59 = 4;
   $223 = $58;
   $224 = $59;
   $225 = (($223) + ($224<<2)|0);
   $226 = HEAP32[$225>>2]|0;
   $60 = $88;
   $61 = 3;
   $227 = $60;
   $228 = $61;
   $229 = (($227) + ($228<<2)|0);
   HEAP32[$229>>2] = $226;
   $230 = $87;
   $231 = HEAP32[$230>>2]|0;
   $62 = $88;
   $63 = 4;
   $232 = $62;
   $233 = $63;
   $234 = (($232) + ($233<<2)|0);
   HEAP32[$234>>2] = $231;
   STACKTOP = sp;return;
  }
  $64 = $88;
  $65 = 3;
  $235 = $64;
  $236 = $65;
  $237 = (($235) + ($236<<2)|0);
  $238 = HEAP32[$237>>2]|0;
  $239 = $87;
  $240 = HEAP32[$239>>2]|0;
  $241 = ($238|0)<($240|0);
  if ($241) {
   $66 = $88;
   $67 = 3;
   $242 = $66;
   $243 = $67;
   $244 = (($242) + ($243<<2)|0);
   $245 = HEAP32[$244>>2]|0;
   $68 = $88;
   $69 = 2;
   $246 = $68;
   $247 = $69;
   $248 = (($246) + ($247<<2)|0);
   HEAP32[$248>>2] = $245;
   $249 = $87;
   $250 = HEAP32[$249>>2]|0;
   $70 = $88;
   $71 = 3;
   $251 = $70;
   $252 = $71;
   $253 = (($251) + ($252<<2)|0);
   HEAP32[$253>>2] = $250;
   STACKTOP = sp;return;
  } else {
   $254 = $87;
   $255 = HEAP32[$254>>2]|0;
   $72 = $88;
   $73 = 2;
   $256 = $72;
   $257 = $73;
   $258 = (($256) + ($257<<2)|0);
   HEAP32[$258>>2] = $255;
   STACKTOP = sp;return;
  }
 }
}
function __ZNK6laszip13decompressors7integer4getKEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = HEAP32[$2>>2]|0;
 STACKTOP = sp;return ($3|0);
}
function __ZN6laszip7formats7packersINS0_3las7point10EE4packERKS3_Pc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $5 = $2;
 $6 = HEAPU8[$5>>0]|(HEAPU8[$5+1>>0]<<8)|(HEAPU8[$5+2>>0]<<16)|(HEAPU8[$5+3>>0]<<24);
 $7 = $3;
 __ZN6laszip7formats7packersIiE4packEiPc($6,$7);
 $8 = $3;
 $9 = ((($8)) + 4|0);
 $3 = $9;
 $10 = $2;
 $11 = ((($10)) + 4|0);
 $12 = HEAPU8[$11>>0]|(HEAPU8[$11+1>>0]<<8)|(HEAPU8[$11+2>>0]<<16)|(HEAPU8[$11+3>>0]<<24);
 $13 = $3;
 __ZN6laszip7formats7packersIiE4packEiPc($12,$13);
 $14 = $3;
 $15 = ((($14)) + 4|0);
 $3 = $15;
 $16 = $2;
 $17 = ((($16)) + 8|0);
 $18 = HEAPU8[$17>>0]|(HEAPU8[$17+1>>0]<<8)|(HEAPU8[$17+2>>0]<<16)|(HEAPU8[$17+3>>0]<<24);
 $19 = $3;
 __ZN6laszip7formats7packersIiE4packEiPc($18,$19);
 $20 = $3;
 $21 = ((($20)) + 4|0);
 $3 = $21;
 $22 = $2;
 $23 = ((($22)) + 12|0);
 $24 = HEAPU8[$23>>0]|(HEAPU8[$23+1>>0]<<8);
 $25 = $3;
 __ZN6laszip7formats7packersItE4packEtPc($24,$25);
 $26 = $3;
 $27 = ((($26)) + 2|0);
 $3 = $27;
 $28 = $2;
 $29 = (__ZN6laszip7formats6detail17bitfields_to_charERKNS0_3las7point10E($28)|0);
 $4 = $29;
 $30 = $4;
 $31 = $3;
 __ZN6laszip7formats7packersIhE4packEhPc($30,$31);
 $32 = $3;
 $33 = ((($32)) + 1|0);
 $3 = $33;
 $34 = $2;
 $35 = ((($34)) + 15|0);
 $36 = HEAP8[$35>>0]|0;
 $37 = $3;
 __ZN6laszip7formats7packersIhE4packEhPc($36,$37);
 $38 = $3;
 $39 = ((($38)) + 1|0);
 $3 = $39;
 $40 = $2;
 $41 = ((($40)) + 16|0);
 $42 = HEAP8[$41>>0]|0;
 $43 = $3;
 __ZN6laszip7formats7packersIcE4packEcPc($42,$43);
 $44 = $3;
 $45 = ((($44)) + 1|0);
 $3 = $45;
 $46 = $2;
 $47 = ((($46)) + 17|0);
 $48 = HEAP8[$47>>0]|0;
 $49 = $3;
 __ZN6laszip7formats7packersIcE4packEcPc($48,$49);
 $50 = $3;
 $51 = ((($50)) + 1|0);
 $3 = $51;
 $52 = $2;
 $53 = ((($52)) + 18|0);
 $54 = HEAPU8[$53>>0]|(HEAPU8[$53+1>>0]<<8);
 $55 = $3;
 __ZN6laszip7formats7packersItE4packEtPc($54,$55);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersIiE6unpackEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = (__ZN6laszip7formats7packersIjE6unpackEPKc($2)|0);
 STACKTOP = sp;return ($3|0);
}
function __ZN6laszip7formats7packersItE6unpackEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $4 = $1;
 $5 = HEAP8[$4>>0]|0;
 $6 = $5 << 24 >> 24;
 $2 = $6;
 $7 = $1;
 $8 = ((($7)) + 1|0);
 $9 = HEAP8[$8>>0]|0;
 $10 = $9 << 24 >> 24;
 $3 = $10;
 $11 = $3;
 $12 = $11&65535;
 $13 = $12 & 255;
 $14 = $13 << 8;
 $15 = $2;
 $16 = $15&65535;
 $17 = $16 & 255;
 $18 = $14 | $17;
 $19 = $18&65535;
 STACKTOP = sp;return ($19|0);
}
function __ZN6laszip7formats7packersIhE6unpackEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = HEAP8[$2>>0]|0;
 STACKTOP = sp;return ($3|0);
}
function __ZN6laszip7formats7packersIcE6unpackEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = HEAP8[$2>>0]|0;
 STACKTOP = sp;return ($3|0);
}
function __ZN6laszip7formats7packersIjE6unpackEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $1 = $0;
 $6 = $1;
 $7 = HEAP8[$6>>0]|0;
 $8 = $7 << 24 >> 24;
 $2 = $8;
 $9 = $1;
 $10 = ((($9)) + 1|0);
 $11 = HEAP8[$10>>0]|0;
 $12 = $11 << 24 >> 24;
 $3 = $12;
 $13 = $1;
 $14 = ((($13)) + 2|0);
 $15 = HEAP8[$14>>0]|0;
 $16 = $15 << 24 >> 24;
 $4 = $16;
 $17 = $1;
 $18 = ((($17)) + 3|0);
 $19 = HEAP8[$18>>0]|0;
 $20 = $19 << 24 >> 24;
 $5 = $20;
 $21 = $5;
 $22 = $21 << 24;
 $23 = $4;
 $24 = $23 & 255;
 $25 = $24 << 16;
 $26 = $22 | $25;
 $27 = $3;
 $28 = $27 & 255;
 $29 = $28 << 8;
 $30 = $26 | $29;
 $31 = $2;
 $32 = $31 & 255;
 $33 = $30 | $32;
 STACKTOP = sp;return ($33|0);
}
function __ZN6laszip7formats7packersIiE4packEiPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 __ZN6laszip7formats7packersIjE4packEjPc($4,$5);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersItE4packEtPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $4&65535;
 $6 = $5 >> 8;
 $7 = $6 & 255;
 $8 = $7&255;
 $9 = $3;
 $10 = ((($9)) + 1|0);
 HEAP8[$10>>0] = $8;
 $11 = $2;
 $12 = $11&65535;
 $13 = $12 & 255;
 $14 = $13&255;
 $15 = $3;
 HEAP8[$15>>0] = $14;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersIhE4packEhPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 HEAP8[$5>>0] = $4;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersIcE4packEcPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 HEAP8[$5>>0] = $4;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersIjE4packEjPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $4 >>> 24;
 $6 = $5 & 255;
 $7 = $6&255;
 $8 = $3;
 $9 = ((($8)) + 3|0);
 HEAP8[$9>>0] = $7;
 $10 = $2;
 $11 = $10 >>> 16;
 $12 = $11 & 255;
 $13 = $12&255;
 $14 = $3;
 $15 = ((($14)) + 2|0);
 HEAP8[$15>>0] = $13;
 $16 = $2;
 $17 = $16 >>> 8;
 $18 = $17 & 255;
 $19 = $18&255;
 $20 = $3;
 $21 = ((($20)) + 1|0);
 HEAP8[$21>>0] = $19;
 $22 = $2;
 $23 = $22 & 255;
 $24 = $23&255;
 $25 = $3;
 HEAP8[$25>>0] = $24;
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEE18__enable_weak_thisEz($0,$varargs) {
 $0 = $0|0;
 $varargs = $varargs|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 4|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 360;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodISC_EEEEEC2ERS9_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 __ZN6laszip7formats10base_fieldC2Ev($4);
 HEAP32[$4>>2] = (2100);
 $5 = ((($4)) + 4|0);
 $6 = $3;
 HEAP32[$5>>2] = $6;
 $7 = ((($4)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEEC2Ev($7);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2124);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 4|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE8__commonC2Ev($2);
 $3 = ((($2)) + 164|0);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE13__compressorsC2Ev($3);
 $4 = ((($2)) + 244|0);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE15__decompressorsC2Ev($4);
 $5 = ((($2)) + 324|0);
 HEAP8[$5>>0] = 0;
 $6 = ((($2)) + 325|0);
 HEAP8[$6>>0] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodISC_EEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (2100);
 $3 = ((($2)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEED2Ev($3);
 __ZN6laszip7formats10base_fieldD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodISC_EEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodISC_EEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodISC_EEEEE13decompressRawEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = ((($4)) + 8|0);
 $6 = ((($4)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $3;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($5,$7,$8)|0);
 STACKTOP = sp;return ($9|0);
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE8__commonC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $29 = sp + 120|0;
 $30 = sp + 4|0;
 $31 = sp;
 $28 = $0;
 $32 = $28;
 HEAP8[$32>>0] = 0;
 $33 = ((($32)) + 4|0);
 __ZN6laszip6models10arithmeticC2EjbPj($33,516,0,0);
 $34 = ((($32)) + 48|0);
 __ZN6laszip6models10arithmeticC2EjbPj($34,6,0,0);
 $35 = ((($32)) + 92|0);
 HEAP32[$35>>2] = 0;
 $36 = ((($32)) + 96|0);
 HEAP32[$36>>2] = 0;
 $37 = ((($32)) + 100|0);
 __ZNSt3__25arrayIN6laszip7formats3las7gpstimeELj4EEC2Ev($37);
 $38 = ((($32)) + 100|0);
 __ZN6laszip7formats3las7gpstimeC2Ev($29);
 $26 = $38;
 $27 = $29;
 $39 = $26;
 $40 = $27;
 $23 = $39;
 $24 = 4;
 $25 = $40;
 $41 = $23;
 $42 = $24;
 $22 = $42;
 $43 = $22;
 $44 = $25;
 $19 = $41;
 $20 = $43;
 $21 = $44;
 while(1) {
  $45 = $20;
  $46 = ($45>>>0)>(0);
  if (!($46)) {
   break;
  }
  $47 = $21;
  $48 = $19;
  ;HEAP8[$48>>0]=HEAP8[$47>>0]|0;HEAP8[$48+1>>0]=HEAP8[$47+1>>0]|0;HEAP8[$48+2>>0]=HEAP8[$47+2>>0]|0;HEAP8[$48+3>>0]=HEAP8[$47+3>>0]|0;HEAP8[$48+4>>0]=HEAP8[$47+4>>0]|0;HEAP8[$48+5>>0]=HEAP8[$47+5>>0]|0;HEAP8[$48+6>>0]=HEAP8[$47+6>>0]|0;HEAP8[$48+7>>0]=HEAP8[$47+7>>0]|0;
  $49 = $19;
  $50 = ((($49)) + 8|0);
  $19 = $50;
  $51 = $20;
  $52 = (($51) + -1)|0;
  $20 = $52;
 }
 $53 = ((($32)) + 132|0);
 HEAP32[$30>>2] = 0;
 $17 = $53;
 $18 = $30;
 $54 = $17;
 $55 = $18;
 $14 = $54;
 $15 = 4;
 $16 = $55;
 $56 = $14;
 $57 = $15;
 $13 = $57;
 $58 = $13;
 $59 = $16;
 $10 = $56;
 $11 = $58;
 $12 = $59;
 while(1) {
  $60 = $11;
  $61 = ($60>>>0)>(0);
  if (!($61)) {
   break;
  }
  $62 = $12;
  $63 = HEAP32[$62>>2]|0;
  $64 = $10;
  HEAP32[$64>>2] = $63;
  $65 = $10;
  $66 = ((($65)) + 4|0);
  $10 = $66;
  $67 = $11;
  $68 = (($67) + -1)|0;
  $11 = $68;
 }
 $69 = ((($32)) + 148|0);
 HEAP32[$31>>2] = 0;
 $8 = $69;
 $9 = $31;
 $70 = $8;
 $71 = $9;
 $5 = $70;
 $6 = 4;
 $7 = $71;
 $72 = $5;
 $73 = $6;
 $4 = $73;
 $74 = $4;
 $75 = $7;
 $1 = $72;
 $2 = $74;
 $3 = $75;
 while(1) {
  $76 = $2;
  $77 = ($76>>>0)>(0);
  if (!($77)) {
   break;
  }
  $78 = $3;
  $79 = HEAP32[$78>>2]|0;
  $80 = $1;
  HEAP32[$80>>2] = $79;
  $81 = $1;
  $82 = ((($81)) + 4|0);
  $1 = $82;
  $83 = $2;
  $84 = (($83) + -1)|0;
  $2 = $84;
 }
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE13__compressorsC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip11compressors7integerC2Ejjjj($2,32,9,8,0);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE15__decompressorsC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13decompressors7integerC2Ejjjj($2,32,9,8,0);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE13__compressorsD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip11compressors7integerD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE8__commonD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 48|0);
 __ZN6laszip6models10arithmeticD2Ev($3);
 $4 = ((($2)) + 4|0);
 __ZN6laszip6models10arithmeticD2Ev($4);
 STACKTOP = sp;return;
}
function __ZNSt3__25arrayIN6laszip7formats3las7gpstimeELj4EEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 32|0);
 $4 = $2;
 while(1) {
  __ZN6laszip7formats3las7gpstimeC2Ev($4);
  $5 = ((($4)) + 8|0);
  $6 = ($5|0)==($3|0);
  if ($6) {
   break;
  } else {
   $4 = $5;
  }
 }
 STACKTOP = sp;return;
}
function __ZN6laszip7formats3las7gpstimeC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = $2;
 $4 = $3;
 HEAP8[$4>>0]=0&255;HEAP8[$4+1>>0]=(0>>8)&255;HEAP8[$4+2>>0]=(0>>16)&255;HEAP8[$4+3>>0]=0>>24;
 $5 = (($3) + 4)|0;
 $6 = $5;
 HEAP8[$6>>0]=0&255;HEAP8[$6+1>>0]=(0>>8)&255;HEAP8[$6+2>>0]=(0>>16)&255;HEAP8[$6+3>>0]=0>>24;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 244|0);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE15__decompressorsD2Ev($3);
 $4 = ((($2)) + 164|0);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE13__compressorsD2Ev($4);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE8__commonD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE15__decompressorsD2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13decompressors7integerD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0;
 var $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0;
 var $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0;
 var $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0;
 var $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0;
 var $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0;
 var $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0;
 var $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0;
 var $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0, $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0;
 var $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0, $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0;
 var $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0, $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0;
 var $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0, $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0;
 var $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0, $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0;
 var $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0, $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0, $442 = 0;
 var $443 = 0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $45 = 0, $450 = 0, $451 = 0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0;
 var $461 = 0, $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0, $467 = 0, $468 = 0, $469 = 0, $47 = 0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0;
 var $48 = 0, $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $485 = 0, $486 = 0, $487 = 0, $488 = 0, $489 = 0, $49 = 0, $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0;
 var $498 = 0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0, $502 = 0, $503 = 0, $504 = 0, $505 = 0, $506 = 0, $507 = 0, $508 = 0, $509 = 0, $51 = 0, $510 = 0, $511 = 0, $512 = 0, $513 = 0, $514 = 0;
 var $515 = 0, $516 = 0, $517 = 0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0, $522 = 0, $523 = 0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0, $530 = 0, $531 = 0, $532 = 0;
 var $533 = 0, $534 = 0, $535 = 0, $536 = 0, $537 = 0, $538 = 0, $539 = 0, $54 = 0, $540 = 0, $541 = 0, $542 = 0, $543 = 0, $544 = 0, $545 = 0, $546 = 0, $547 = 0, $548 = 0, $549 = 0, $55 = 0, $550 = 0;
 var $551 = 0, $552 = 0, $553 = 0, $554 = 0, $555 = 0, $556 = 0, $557 = 0, $558 = 0, $559 = 0, $56 = 0, $560 = 0, $561 = 0, $562 = 0, $563 = 0, $564 = 0, $565 = 0, $566 = 0, $567 = 0, $568 = 0, $569 = 0;
 var $57 = 0, $570 = 0, $571 = 0, $572 = 0, $573 = 0, $574 = 0, $575 = 0, $576 = 0, $577 = 0, $578 = 0, $579 = 0, $58 = 0, $580 = 0, $581 = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0;
 var $588 = 0, $589 = 0, $59 = 0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0, $595 = 0, $596 = 0, $597 = 0, $598 = 0, $599 = 0, $6 = 0, $60 = 0, $600 = 0, $601 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 368|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(368|0);
 $91 = sp + 360|0;
 $88 = $0;
 $89 = $1;
 $90 = $2;
 $94 = $88;
 $95 = ((($94)) + 325|0);
 $96 = HEAP8[$95>>0]|0;
 $97 = $96&1;
 if (!($97)) {
  $98 = ((($94)) + 244|0);
  __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE15__decompressors4initEv($98);
  $99 = ((($94)) + 325|0);
  HEAP8[$99>>0] = 1;
 }
 $100 = HEAP8[$94>>0]|0;
 $101 = $100&1;
 if (!($101)) {
  HEAP8[$94>>0] = 1;
  $102 = $89;
  $103 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE11getInStreamEv($102)|0);
  $104 = $90;
  __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE8getBytesEPhj($103,$104,8);
  $105 = $90;
  $106 = (__ZN6laszip7formats7packersINS0_3las7gpstimeEE6unpackEPKc($105)|0);
  $107 = tempRet0;
  $108 = $91;
  $109 = $108;
  HEAP8[$109>>0]=$106&255;HEAP8[$109+1>>0]=($106>>8)&255;HEAP8[$109+2>>0]=($106>>16)&255;HEAP8[$109+3>>0]=$106>>24;
  $110 = (($108) + 4)|0;
  $111 = $110;
  HEAP8[$111>>0]=$107&255;HEAP8[$111+1>>0]=($107>>8)&255;HEAP8[$111+2>>0]=($107>>16)&255;HEAP8[$111+3>>0]=$107>>24;
  $112 = ((($94)) + 100|0);
  $85 = $112;
  $86 = 0;
  $113 = $85;
  $114 = $86;
  $115 = (($113) + ($114<<3)|0);
  ;HEAP8[$115>>0]=HEAP8[$91>>0]|0;HEAP8[$115+1>>0]=HEAP8[$91+1>>0]|0;HEAP8[$115+2>>0]=HEAP8[$91+2>>0]|0;HEAP8[$115+3>>0]=HEAP8[$91+3>>0]|0;HEAP8[$115+4>>0]=HEAP8[$91+4>>0]|0;HEAP8[$115+5>>0]=HEAP8[$91+5>>0]|0;HEAP8[$115+6>>0]=HEAP8[$91+6>>0]|0;HEAP8[$115+7>>0]=HEAP8[$91+7>>0]|0;
  $116 = $90;
  $117 = ((($116)) + 8|0);
  $87 = $117;
  $601 = $87;
  STACKTOP = sp;return ($601|0);
 }
 $118 = ((($94)) + 132|0);
 $119 = ((($94)) + 92|0);
 $120 = HEAP32[$119>>2]|0;
 $83 = $118;
 $84 = $120;
 $121 = $83;
 $122 = $84;
 $123 = (($121) + ($122<<2)|0);
 $124 = HEAP32[$123>>2]|0;
 $125 = ($124|0)==(0);
 $126 = $89;
 do {
  if ($125) {
   $127 = ((($94)) + 48|0);
   $128 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($126,$127)|0);
   $92 = $128;
   $129 = $92;
   $130 = ($129|0)==(1);
   if ($130) {
    $131 = ((($94)) + 244|0);
    $132 = $89;
    $133 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($131,$132,0,0)|0);
    $134 = ((($94)) + 132|0);
    $135 = ((($94)) + 92|0);
    $136 = HEAP32[$135>>2]|0;
    $81 = $134;
    $82 = $136;
    $137 = $81;
    $138 = $82;
    $139 = (($137) + ($138<<2)|0);
    HEAP32[$139>>2] = $133;
    $140 = ((($94)) + 132|0);
    $141 = ((($94)) + 92|0);
    $142 = HEAP32[$141>>2]|0;
    $71 = $140;
    $72 = $142;
    $143 = $71;
    $144 = $72;
    $145 = (($143) + ($144<<2)|0);
    $146 = HEAP32[$145>>2]|0;
    $147 = ($146|0)<(0);
    $148 = $147 << 31 >> 31;
    $149 = ((($94)) + 100|0);
    $150 = ((($94)) + 92|0);
    $151 = HEAP32[$150>>2]|0;
    $63 = $149;
    $64 = $151;
    $152 = $63;
    $153 = $64;
    $154 = (($152) + ($153<<3)|0);
    $155 = $154;
    $156 = $155;
    $157 = HEAPU8[$156>>0]|(HEAPU8[$156+1>>0]<<8)|(HEAPU8[$156+2>>0]<<16)|(HEAPU8[$156+3>>0]<<24);
    $158 = (($155) + 4)|0;
    $159 = $158;
    $160 = HEAPU8[$159>>0]|(HEAPU8[$159+1>>0]<<8)|(HEAPU8[$159+2>>0]<<16)|(HEAPU8[$159+3>>0]<<24);
    $161 = (_i64Add(($157|0),($160|0),($146|0),($148|0))|0);
    $162 = tempRet0;
    $163 = $154;
    $164 = $163;
    HEAP8[$164>>0]=$161&255;HEAP8[$164+1>>0]=($161>>8)&255;HEAP8[$164+2>>0]=($161>>16)&255;HEAP8[$164+3>>0]=$161>>24;
    $165 = (($163) + 4)|0;
    $166 = $165;
    HEAP8[$166>>0]=$162&255;HEAP8[$166+1>>0]=($162>>8)&255;HEAP8[$166+2>>0]=($162>>16)&255;HEAP8[$166+3>>0]=$162>>24;
    $167 = ((($94)) + 148|0);
    $168 = ((($94)) + 92|0);
    $169 = HEAP32[$168>>2]|0;
    $49 = $167;
    $50 = $169;
    $170 = $49;
    $171 = $50;
    $172 = (($170) + ($171<<2)|0);
    HEAP32[$172>>2] = 0;
    break;
   }
   $173 = $92;
   $174 = ($173|0)==(2);
   if ($174) {
    $175 = ((($94)) + 96|0);
    $176 = HEAP32[$175>>2]|0;
    $177 = (($176) + 1)|0;
    $178 = $177 & 3;
    $179 = ((($94)) + 96|0);
    HEAP32[$179>>2] = $178;
    $180 = ((($94)) + 244|0);
    $181 = $89;
    $182 = ((($94)) + 100|0);
    $183 = ((($94)) + 92|0);
    $184 = HEAP32[$183>>2]|0;
    $45 = $182;
    $46 = $184;
    $185 = $45;
    $186 = $46;
    $187 = (($185) + ($186<<3)|0);
    $188 = $187;
    $189 = $188;
    $190 = HEAPU8[$189>>0]|(HEAPU8[$189+1>>0]<<8)|(HEAPU8[$189+2>>0]<<16)|(HEAPU8[$189+3>>0]<<24);
    $191 = (($188) + 4)|0;
    $192 = $191;
    $193 = HEAPU8[$192>>0]|(HEAPU8[$192+1>>0]<<8)|(HEAPU8[$192+2>>0]<<16)|(HEAPU8[$192+3>>0]<<24);
    $194 = (_bitshift64Ashr(($190|0),($193|0),32)|0);
    $195 = tempRet0;
    $196 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($180,$181,$194,8)|0);
    $197 = ($196|0)<(0);
    $198 = $197 << 31 >> 31;
    $199 = ((($94)) + 100|0);
    $200 = ((($94)) + 96|0);
    $201 = HEAP32[$200>>2]|0;
    $33 = $199;
    $34 = $201;
    $202 = $33;
    $203 = $34;
    $204 = (($202) + ($203<<3)|0);
    $205 = $204;
    $206 = $205;
    HEAP8[$206>>0]=$196&255;HEAP8[$206+1>>0]=($196>>8)&255;HEAP8[$206+2>>0]=($196>>16)&255;HEAP8[$206+3>>0]=$196>>24;
    $207 = (($205) + 4)|0;
    $208 = $207;
    HEAP8[$208>>0]=$198&255;HEAP8[$208+1>>0]=($198>>8)&255;HEAP8[$208+2>>0]=($198>>16)&255;HEAP8[$208+3>>0]=$198>>24;
    $209 = ((($94)) + 100|0);
    $210 = ((($94)) + 96|0);
    $211 = HEAP32[$210>>2]|0;
    $29 = $209;
    $30 = $211;
    $212 = $29;
    $213 = $30;
    $214 = (($212) + ($213<<3)|0);
    $215 = $214;
    $216 = $215;
    $217 = HEAPU8[$216>>0]|(HEAPU8[$216+1>>0]<<8)|(HEAPU8[$216+2>>0]<<16)|(HEAPU8[$216+3>>0]<<24);
    $218 = (($215) + 4)|0;
    $219 = $218;
    $220 = HEAPU8[$219>>0]|(HEAPU8[$219+1>>0]<<8)|(HEAPU8[$219+2>>0]<<16)|(HEAPU8[$219+3>>0]<<24);
    $221 = ((($94)) + 100|0);
    $222 = ((($94)) + 96|0);
    $223 = HEAP32[$222>>2]|0;
    $25 = $221;
    $26 = $223;
    $224 = $25;
    $225 = $26;
    $226 = (($224) + ($225<<3)|0);
    $227 = $226;
    $228 = $227;
    HEAP8[$228>>0]=0&255;HEAP8[$228+1>>0]=(0>>8)&255;HEAP8[$228+2>>0]=(0>>16)&255;HEAP8[$228+3>>0]=0>>24;
    $229 = (($227) + 4)|0;
    $230 = $229;
    HEAP8[$230>>0]=$217&255;HEAP8[$230+1>>0]=($217>>8)&255;HEAP8[$230+2>>0]=($217>>16)&255;HEAP8[$230+3>>0]=$217>>24;
    $231 = $89;
    $232 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE7readIntEv($231)|0);
    $233 = ((($94)) + 100|0);
    $234 = ((($94)) + 96|0);
    $235 = HEAP32[$234>>2]|0;
    $13 = $233;
    $14 = $235;
    $236 = $13;
    $237 = $14;
    $238 = (($236) + ($237<<3)|0);
    $239 = $238;
    $240 = $239;
    $241 = HEAPU8[$240>>0]|(HEAPU8[$240+1>>0]<<8)|(HEAPU8[$240+2>>0]<<16)|(HEAPU8[$240+3>>0]<<24);
    $242 = (($239) + 4)|0;
    $243 = $242;
    $244 = HEAPU8[$243>>0]|(HEAPU8[$243+1>>0]<<8)|(HEAPU8[$243+2>>0]<<16)|(HEAPU8[$243+3>>0]<<24);
    $245 = $241 | $232;
    $246 = $238;
    $247 = $246;
    HEAP8[$247>>0]=$245&255;HEAP8[$247+1>>0]=($245>>8)&255;HEAP8[$247+2>>0]=($245>>16)&255;HEAP8[$247+3>>0]=$245>>24;
    $248 = (($246) + 4)|0;
    $249 = $248;
    HEAP8[$249>>0]=$244&255;HEAP8[$249+1>>0]=($244>>8)&255;HEAP8[$249+2>>0]=($244>>16)&255;HEAP8[$249+3>>0]=$244>>24;
    $250 = ((($94)) + 96|0);
    $251 = HEAP32[$250>>2]|0;
    $252 = ((($94)) + 92|0);
    HEAP32[$252>>2] = $251;
    $253 = ((($94)) + 132|0);
    $254 = ((($94)) + 92|0);
    $255 = HEAP32[$254>>2]|0;
    $7 = $253;
    $8 = $255;
    $256 = $7;
    $257 = $8;
    $258 = (($256) + ($257<<2)|0);
    HEAP32[$258>>2] = 0;
    $259 = ((($94)) + 148|0);
    $260 = ((($94)) + 92|0);
    $261 = HEAP32[$260>>2]|0;
    $3 = $259;
    $4 = $261;
    $262 = $3;
    $263 = $4;
    $264 = (($262) + ($263<<2)|0);
    HEAP32[$264>>2] = 0;
    break;
   }
   $265 = $92;
   $266 = ($265|0)>(2);
   if ($266) {
    $267 = ((($94)) + 92|0);
    $268 = HEAP32[$267>>2]|0;
    $269 = $92;
    $270 = (($268) + ($269))|0;
    $271 = (($270) - 2)|0;
    $272 = $271 & 3;
    $273 = ((($94)) + 92|0);
    HEAP32[$273>>2] = $272;
    $274 = $89;
    $275 = $90;
    (__ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($94,$274,$275)|0);
   }
  } else {
   $276 = ((($94)) + 4|0);
   $277 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($126,$276)|0);
   $92 = $277;
   $278 = $92;
   $279 = ($278|0)==(1);
   if ($279) {
    $280 = ((($94)) + 244|0);
    $281 = $89;
    $282 = ((($94)) + 132|0);
    $283 = ((($94)) + 92|0);
    $284 = HEAP32[$283>>2]|0;
    $5 = $282;
    $6 = $284;
    $285 = $5;
    $286 = $6;
    $287 = (($285) + ($286<<2)|0);
    $288 = HEAP32[$287>>2]|0;
    $289 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($280,$281,$288,1)|0);
    $290 = ($289|0)<(0);
    $291 = $290 << 31 >> 31;
    $292 = ((($94)) + 100|0);
    $293 = ((($94)) + 92|0);
    $294 = HEAP32[$293>>2]|0;
    $9 = $292;
    $10 = $294;
    $295 = $9;
    $296 = $10;
    $297 = (($295) + ($296<<3)|0);
    $298 = $297;
    $299 = $298;
    $300 = HEAPU8[$299>>0]|(HEAPU8[$299+1>>0]<<8)|(HEAPU8[$299+2>>0]<<16)|(HEAPU8[$299+3>>0]<<24);
    $301 = (($298) + 4)|0;
    $302 = $301;
    $303 = HEAPU8[$302>>0]|(HEAPU8[$302+1>>0]<<8)|(HEAPU8[$302+2>>0]<<16)|(HEAPU8[$302+3>>0]<<24);
    $304 = (_i64Add(($300|0),($303|0),($289|0),($291|0))|0);
    $305 = tempRet0;
    $306 = $297;
    $307 = $306;
    HEAP8[$307>>0]=$304&255;HEAP8[$307+1>>0]=($304>>8)&255;HEAP8[$307+2>>0]=($304>>16)&255;HEAP8[$307+3>>0]=$304>>24;
    $308 = (($306) + 4)|0;
    $309 = $308;
    HEAP8[$309>>0]=$305&255;HEAP8[$309+1>>0]=($305>>8)&255;HEAP8[$309+2>>0]=($305>>16)&255;HEAP8[$309+3>>0]=$305>>24;
    $310 = ((($94)) + 148|0);
    $311 = ((($94)) + 92|0);
    $312 = HEAP32[$311>>2]|0;
    $11 = $310;
    $12 = $312;
    $313 = $11;
    $314 = $12;
    $315 = (($313) + ($314<<2)|0);
    HEAP32[$315>>2] = 0;
    break;
   }
   $316 = $92;
   $317 = ($316|0)<(511);
   $318 = $92;
   if (!($317)) {
    $490 = ($318|0)==(512);
    if ($490) {
     $491 = ((($94)) + 96|0);
     $492 = HEAP32[$491>>2]|0;
     $493 = (($492) + 1)|0;
     $494 = $493 & 3;
     $495 = ((($94)) + 96|0);
     HEAP32[$495>>2] = $494;
     $496 = ((($94)) + 244|0);
     $497 = $89;
     $498 = ((($94)) + 100|0);
     $499 = ((($94)) + 92|0);
     $500 = HEAP32[$499>>2]|0;
     $61 = $498;
     $62 = $500;
     $501 = $61;
     $502 = $62;
     $503 = (($501) + ($502<<3)|0);
     $504 = $503;
     $505 = $504;
     $506 = HEAPU8[$505>>0]|(HEAPU8[$505+1>>0]<<8)|(HEAPU8[$505+2>>0]<<16)|(HEAPU8[$505+3>>0]<<24);
     $507 = (($504) + 4)|0;
     $508 = $507;
     $509 = HEAPU8[$508>>0]|(HEAPU8[$508+1>>0]<<8)|(HEAPU8[$508+2>>0]<<16)|(HEAPU8[$508+3>>0]<<24);
     $510 = (_bitshift64Ashr(($506|0),($509|0),32)|0);
     $511 = tempRet0;
     $512 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($496,$497,$510,8)|0);
     $513 = ($512|0)<(0);
     $514 = $513 << 31 >> 31;
     $515 = ((($94)) + 100|0);
     $516 = ((($94)) + 96|0);
     $517 = HEAP32[$516>>2]|0;
     $65 = $515;
     $66 = $517;
     $518 = $65;
     $519 = $66;
     $520 = (($518) + ($519<<3)|0);
     $521 = $520;
     $522 = $521;
     HEAP8[$522>>0]=$512&255;HEAP8[$522+1>>0]=($512>>8)&255;HEAP8[$522+2>>0]=($512>>16)&255;HEAP8[$522+3>>0]=$512>>24;
     $523 = (($521) + 4)|0;
     $524 = $523;
     HEAP8[$524>>0]=$514&255;HEAP8[$524+1>>0]=($514>>8)&255;HEAP8[$524+2>>0]=($514>>16)&255;HEAP8[$524+3>>0]=$514>>24;
     $525 = ((($94)) + 100|0);
     $526 = ((($94)) + 96|0);
     $527 = HEAP32[$526>>2]|0;
     $67 = $525;
     $68 = $527;
     $528 = $67;
     $529 = $68;
     $530 = (($528) + ($529<<3)|0);
     $531 = $530;
     $532 = $531;
     $533 = HEAPU8[$532>>0]|(HEAPU8[$532+1>>0]<<8)|(HEAPU8[$532+2>>0]<<16)|(HEAPU8[$532+3>>0]<<24);
     $534 = (($531) + 4)|0;
     $535 = $534;
     $536 = HEAPU8[$535>>0]|(HEAPU8[$535+1>>0]<<8)|(HEAPU8[$535+2>>0]<<16)|(HEAPU8[$535+3>>0]<<24);
     $537 = ((($94)) + 100|0);
     $538 = ((($94)) + 96|0);
     $539 = HEAP32[$538>>2]|0;
     $69 = $537;
     $70 = $539;
     $540 = $69;
     $541 = $70;
     $542 = (($540) + ($541<<3)|0);
     $543 = $542;
     $544 = $543;
     HEAP8[$544>>0]=0&255;HEAP8[$544+1>>0]=(0>>8)&255;HEAP8[$544+2>>0]=(0>>16)&255;HEAP8[$544+3>>0]=0>>24;
     $545 = (($543) + 4)|0;
     $546 = $545;
     HEAP8[$546>>0]=$533&255;HEAP8[$546+1>>0]=($533>>8)&255;HEAP8[$546+2>>0]=($533>>16)&255;HEAP8[$546+3>>0]=$533>>24;
     $547 = $89;
     $548 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE7readIntEv($547)|0);
     $549 = ((($94)) + 100|0);
     $550 = ((($94)) + 96|0);
     $551 = HEAP32[$550>>2]|0;
     $73 = $549;
     $74 = $551;
     $552 = $73;
     $553 = $74;
     $554 = (($552) + ($553<<3)|0);
     $555 = $554;
     $556 = $555;
     $557 = HEAPU8[$556>>0]|(HEAPU8[$556+1>>0]<<8)|(HEAPU8[$556+2>>0]<<16)|(HEAPU8[$556+3>>0]<<24);
     $558 = (($555) + 4)|0;
     $559 = $558;
     $560 = HEAPU8[$559>>0]|(HEAPU8[$559+1>>0]<<8)|(HEAPU8[$559+2>>0]<<16)|(HEAPU8[$559+3>>0]<<24);
     $561 = $557 | $548;
     $562 = $554;
     $563 = $562;
     HEAP8[$563>>0]=$561&255;HEAP8[$563+1>>0]=($561>>8)&255;HEAP8[$563+2>>0]=($561>>16)&255;HEAP8[$563+3>>0]=$561>>24;
     $564 = (($562) + 4)|0;
     $565 = $564;
     HEAP8[$565>>0]=$560&255;HEAP8[$565+1>>0]=($560>>8)&255;HEAP8[$565+2>>0]=($560>>16)&255;HEAP8[$565+3>>0]=$560>>24;
     $566 = ((($94)) + 96|0);
     $567 = HEAP32[$566>>2]|0;
     $568 = ((($94)) + 92|0);
     HEAP32[$568>>2] = $567;
     $569 = ((($94)) + 132|0);
     $570 = ((($94)) + 92|0);
     $571 = HEAP32[$570>>2]|0;
     $75 = $569;
     $76 = $571;
     $572 = $75;
     $573 = $76;
     $574 = (($572) + ($573<<2)|0);
     HEAP32[$574>>2] = 0;
     $575 = ((($94)) + 148|0);
     $576 = ((($94)) + 92|0);
     $577 = HEAP32[$576>>2]|0;
     $77 = $575;
     $78 = $577;
     $578 = $77;
     $579 = $78;
     $580 = (($578) + ($579<<2)|0);
     HEAP32[$580>>2] = 0;
     break;
    }
    $581 = $92;
    $582 = ($581|0)>=(512);
    if (!($582)) {
     break;
    }
    $583 = ((($94)) + 92|0);
    $584 = HEAP32[$583>>2]|0;
    $585 = $92;
    $586 = (($584) + ($585))|0;
    $587 = (($586) - 512)|0;
    $588 = $587 & 3;
    $589 = ((($94)) + 92|0);
    HEAP32[$589>>2] = $588;
    $590 = $89;
    $591 = $90;
    (__ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($94,$590,$591)|0);
    break;
   }
   $319 = ($318|0)==(0);
   do {
    if ($319) {
     $320 = ((($94)) + 244|0);
     $321 = $89;
     $322 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($320,$321,0,7)|0);
     $93 = $322;
     $323 = ((($94)) + 148|0);
     $324 = ((($94)) + 92|0);
     $325 = HEAP32[$324>>2]|0;
     $15 = $323;
     $16 = $325;
     $326 = $15;
     $327 = $16;
     $328 = (($326) + ($327<<2)|0);
     $329 = HEAP32[$328>>2]|0;
     $330 = (($329) + 1)|0;
     HEAP32[$328>>2] = $330;
     $331 = ((($94)) + 148|0);
     $332 = ((($94)) + 92|0);
     $333 = HEAP32[$332>>2]|0;
     $17 = $331;
     $18 = $333;
     $334 = $17;
     $335 = $18;
     $336 = (($334) + ($335<<2)|0);
     $337 = HEAP32[$336>>2]|0;
     $338 = ($337|0)>(3);
     if ($338) {
      $339 = $93;
      $340 = ((($94)) + 132|0);
      $341 = ((($94)) + 92|0);
      $342 = HEAP32[$341>>2]|0;
      $19 = $340;
      $20 = $342;
      $343 = $19;
      $344 = $20;
      $345 = (($343) + ($344<<2)|0);
      HEAP32[$345>>2] = $339;
      $346 = ((($94)) + 148|0);
      $347 = ((($94)) + 92|0);
      $348 = HEAP32[$347>>2]|0;
      $21 = $346;
      $22 = $348;
      $349 = $21;
      $350 = $22;
      $351 = (($349) + ($350<<2)|0);
      HEAP32[$351>>2] = 0;
     }
    } else {
     $352 = $92;
     $353 = ($352|0)<(500);
     $354 = $92;
     if ($353) {
      $355 = ($354|0)<(10);
      $356 = ((($94)) + 244|0);
      $357 = $89;
      $358 = $92;
      $359 = ((($94)) + 132|0);
      $360 = ((($94)) + 92|0);
      $361 = HEAP32[$360>>2]|0;
      if ($355) {
       $23 = $359;
       $24 = $361;
       $362 = $23;
       $363 = $24;
       $364 = (($362) + ($363<<2)|0);
       $365 = HEAP32[$364>>2]|0;
       $366 = Math_imul($358, $365)|0;
       $367 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($356,$357,$366,2)|0);
       $93 = $367;
       break;
      } else {
       $27 = $359;
       $28 = $361;
       $368 = $27;
       $369 = $28;
       $370 = (($368) + ($369<<2)|0);
       $371 = HEAP32[$370>>2]|0;
       $372 = Math_imul($358, $371)|0;
       $373 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($356,$357,$372,3)|0);
       $93 = $373;
       break;
      }
     }
     $374 = ($354|0)==(500);
     if ($374) {
      $375 = ((($94)) + 244|0);
      $376 = $89;
      $377 = ((($94)) + 132|0);
      $378 = ((($94)) + 92|0);
      $379 = HEAP32[$378>>2]|0;
      $31 = $377;
      $32 = $379;
      $380 = $31;
      $381 = $32;
      $382 = (($380) + ($381<<2)|0);
      $383 = HEAP32[$382>>2]|0;
      $384 = ($383*500)|0;
      $385 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($375,$376,$384,4)|0);
      $93 = $385;
      $386 = ((($94)) + 148|0);
      $387 = ((($94)) + 92|0);
      $388 = HEAP32[$387>>2]|0;
      $35 = $386;
      $36 = $388;
      $389 = $35;
      $390 = $36;
      $391 = (($389) + ($390<<2)|0);
      $392 = HEAP32[$391>>2]|0;
      $393 = (($392) + 1)|0;
      HEAP32[$391>>2] = $393;
      $394 = ((($94)) + 148|0);
      $395 = ((($94)) + 92|0);
      $396 = HEAP32[$395>>2]|0;
      $37 = $394;
      $38 = $396;
      $397 = $37;
      $398 = $38;
      $399 = (($397) + ($398<<2)|0);
      $400 = HEAP32[$399>>2]|0;
      $401 = ($400|0)>(3);
      if (!($401)) {
       break;
      }
      $402 = $93;
      $403 = ((($94)) + 132|0);
      $404 = ((($94)) + 92|0);
      $405 = HEAP32[$404>>2]|0;
      $39 = $403;
      $40 = $405;
      $406 = $39;
      $407 = $40;
      $408 = (($406) + ($407<<2)|0);
      HEAP32[$408>>2] = $402;
      $409 = ((($94)) + 148|0);
      $410 = ((($94)) + 92|0);
      $411 = HEAP32[$410>>2]|0;
      $41 = $409;
      $42 = $411;
      $412 = $41;
      $413 = $42;
      $414 = (($412) + ($413<<2)|0);
      HEAP32[$414>>2] = 0;
      break;
     }
     $415 = $92;
     $416 = (500 - ($415))|0;
     $92 = $416;
     $417 = $92;
     $418 = ($417|0)>(-10);
     $419 = ((($94)) + 244|0);
     $420 = $89;
     if ($418) {
      $421 = $92;
      $422 = ((($94)) + 132|0);
      $423 = ((($94)) + 92|0);
      $424 = HEAP32[$423>>2]|0;
      $43 = $422;
      $44 = $424;
      $425 = $43;
      $426 = $44;
      $427 = (($425) + ($426<<2)|0);
      $428 = HEAP32[$427>>2]|0;
      $429 = Math_imul($421, $428)|0;
      $430 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($419,$420,$429,5)|0);
      $93 = $430;
      break;
     }
     $431 = ((($94)) + 132|0);
     $432 = ((($94)) + 92|0);
     $433 = HEAP32[$432>>2]|0;
     $47 = $431;
     $48 = $433;
     $434 = $47;
     $435 = $48;
     $436 = (($434) + ($435<<2)|0);
     $437 = HEAP32[$436>>2]|0;
     $438 = Math_imul(-10, $437)|0;
     $439 = (__ZN6laszip13decompressors7integer10decompressINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEiRT_ij($419,$420,$438,6)|0);
     $93 = $439;
     $440 = ((($94)) + 148|0);
     $441 = ((($94)) + 92|0);
     $442 = HEAP32[$441>>2]|0;
     $51 = $440;
     $52 = $442;
     $443 = $51;
     $444 = $52;
     $445 = (($443) + ($444<<2)|0);
     $446 = HEAP32[$445>>2]|0;
     $447 = (($446) + 1)|0;
     HEAP32[$445>>2] = $447;
     $448 = ((($94)) + 148|0);
     $449 = ((($94)) + 92|0);
     $450 = HEAP32[$449>>2]|0;
     $53 = $448;
     $54 = $450;
     $451 = $53;
     $452 = $54;
     $453 = (($451) + ($452<<2)|0);
     $454 = HEAP32[$453>>2]|0;
     $455 = ($454|0)>(3);
     if ($455) {
      $456 = $93;
      $457 = ((($94)) + 132|0);
      $458 = ((($94)) + 92|0);
      $459 = HEAP32[$458>>2]|0;
      $55 = $457;
      $56 = $459;
      $460 = $55;
      $461 = $56;
      $462 = (($460) + ($461<<2)|0);
      HEAP32[$462>>2] = $456;
      $463 = ((($94)) + 148|0);
      $464 = ((($94)) + 92|0);
      $465 = HEAP32[$464>>2]|0;
      $57 = $463;
      $58 = $465;
      $466 = $57;
      $467 = $58;
      $468 = (($466) + ($467<<2)|0);
      HEAP32[$468>>2] = 0;
     }
    }
   } while(0);
   $469 = $93;
   $470 = ($469|0)<(0);
   $471 = $470 << 31 >> 31;
   $472 = ((($94)) + 100|0);
   $473 = ((($94)) + 92|0);
   $474 = HEAP32[$473>>2]|0;
   $59 = $472;
   $60 = $474;
   $475 = $59;
   $476 = $60;
   $477 = (($475) + ($476<<3)|0);
   $478 = $477;
   $479 = $478;
   $480 = HEAPU8[$479>>0]|(HEAPU8[$479+1>>0]<<8)|(HEAPU8[$479+2>>0]<<16)|(HEAPU8[$479+3>>0]<<24);
   $481 = (($478) + 4)|0;
   $482 = $481;
   $483 = HEAPU8[$482>>0]|(HEAPU8[$482+1>>0]<<8)|(HEAPU8[$482+2>>0]<<16)|(HEAPU8[$482+3>>0]<<24);
   $484 = (_i64Add(($480|0),($483|0),($469|0),($471|0))|0);
   $485 = tempRet0;
   $486 = $477;
   $487 = $486;
   HEAP8[$487>>0]=$484&255;HEAP8[$487+1>>0]=($484>>8)&255;HEAP8[$487+2>>0]=($484>>16)&255;HEAP8[$487+3>>0]=$484>>24;
   $488 = (($486) + 4)|0;
   $489 = $488;
   HEAP8[$489>>0]=$485&255;HEAP8[$489+1>>0]=($485>>8)&255;HEAP8[$489+2>>0]=($485>>16)&255;HEAP8[$489+3>>0]=$485>>24;
  }
 } while(0);
 $592 = ((($94)) + 100|0);
 $593 = ((($94)) + 92|0);
 $594 = HEAP32[$593>>2]|0;
 $79 = $592;
 $80 = $594;
 $595 = $79;
 $596 = $80;
 $597 = (($595) + ($596<<3)|0);
 $598 = $90;
 __ZN6laszip7formats7packersINS0_3las7gpstimeEE4packERKS3_Pc($597,$598);
 $599 = $90;
 $600 = ((($599)) + 8|0);
 $87 = $600;
 $601 = $87;
 STACKTOP = sp;return ($601|0);
}
function __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE15__decompressors4initEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip13decompressors7integer4initEv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersINS0_3las7gpstimeEE6unpackEPKc($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $1 = sp + 24|0;
 $3 = sp + 8|0;
 $4 = sp;
 $2 = $0;
 $5 = $2;
 $6 = (__ZN6laszip7formats7packersIjE6unpackEPKc($5)|0);
 $7 = $3;
 $8 = $7;
 HEAP32[$8>>2] = $6;
 $9 = (($7) + 4)|0;
 $10 = $9;
 HEAP32[$10>>2] = 0;
 $11 = $2;
 $12 = ((($11)) + 4|0);
 $13 = (__ZN6laszip7formats7packersIjE6unpackEPKc($12)|0);
 $14 = $4;
 $15 = $14;
 HEAP32[$15>>2] = $13;
 $16 = (($14) + 4)|0;
 $17 = $16;
 HEAP32[$17>>2] = 0;
 $18 = $4;
 $19 = $18;
 $20 = HEAP32[$19>>2]|0;
 $21 = (($18) + 4)|0;
 $22 = $21;
 $23 = HEAP32[$22>>2]|0;
 $24 = $3;
 $25 = $24;
 $26 = HEAP32[$25>>2]|0;
 $27 = (($24) + 4)|0;
 $28 = $27;
 $29 = HEAP32[$28>>2]|0;
 $30 = $20 | $29;
 __ZN6laszip7formats3las7gpstimeC2Ex($1,$26,$30);
 $31 = $1;
 $32 = $31;
 $33 = HEAPU8[$32>>0]|(HEAPU8[$32+1>>0]<<8)|(HEAPU8[$32+2>>0]<<16)|(HEAPU8[$32+3>>0]<<24);
 $34 = (($31) + 4)|0;
 $35 = $34;
 $36 = HEAPU8[$35>>0]|(HEAPU8[$35+1>>0]<<8)|(HEAPU8[$35+2>>0]<<16)|(HEAPU8[$35+3>>0]<<24);
 tempRet0 = ($36);
 STACKTOP = sp;return ($33|0);
}
function __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE7readIntEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $4 = $1;
 $5 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE9readShortEv($4)|0);
 $6 = $5&65535;
 $2 = $6;
 $7 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE9readShortEv($4)|0);
 $8 = $7&65535;
 $3 = $8;
 $9 = $3;
 $10 = $9 << 16;
 $11 = $2;
 $12 = $10 | $11;
 STACKTOP = sp;return ($12|0);
}
function __ZN6laszip7formats7packersINS0_3las7gpstimeEE4packERKS3_Pc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $4;
 $6 = $5;
 $7 = HEAPU8[$6>>0]|(HEAPU8[$6+1>>0]<<8)|(HEAPU8[$6+2>>0]<<16)|(HEAPU8[$6+3>>0]<<24);
 $8 = (($5) + 4)|0;
 $9 = $8;
 $10 = HEAPU8[$9>>0]|(HEAPU8[$9+1>>0]<<8)|(HEAPU8[$9+2>>0]<<16)|(HEAPU8[$9+3>>0]<<24);
 $11 = $3;
 __ZN6laszip7formats7packersIjE4packEjPc($7,$11);
 $12 = $2;
 $13 = $12;
 $14 = $13;
 $15 = HEAPU8[$14>>0]|(HEAPU8[$14+1>>0]<<8)|(HEAPU8[$14+2>>0]<<16)|(HEAPU8[$14+3>>0]<<24);
 $16 = (($13) + 4)|0;
 $17 = $16;
 $18 = HEAPU8[$17>>0]|(HEAPU8[$17+1>>0]<<8)|(HEAPU8[$17+2>>0]<<16)|(HEAPU8[$17+3>>0]<<24);
 $19 = (_bitshift64Ashr(($15|0),($18|0),32)|0);
 $20 = tempRet0;
 $21 = $3;
 $22 = ((($21)) + 4|0);
 __ZN6laszip7formats7packersIjE4packEjPc($19,$22);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats3las7gpstimeC2Ex($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $4 = sp;
 $3 = $0;
 $5 = $4;
 $6 = $5;
 HEAP32[$6>>2] = $1;
 $7 = (($5) + 4)|0;
 $8 = $7;
 HEAP32[$8>>2] = $2;
 $9 = $3;
 $10 = $4;
 $11 = $10;
 $12 = HEAP32[$11>>2]|0;
 $13 = (($10) + 4)|0;
 $14 = $13;
 $15 = HEAP32[$14>>2]|0;
 $16 = $9;
 $17 = $16;
 HEAP8[$17>>0]=$12&255;HEAP8[$17+1>>0]=($12>>8)&255;HEAP8[$17+2>>0]=($12>>16)&255;HEAP8[$17+3>>0]=$12>>24;
 $18 = (($16) + 4)|0;
 $19 = $18;
 HEAP8[$19>>0]=$15&255;HEAP8[$19+1>>0]=($15>>8)&255;HEAP8[$19+2>>0]=($15>>16)&255;HEAP8[$19+3>>0]=$15>>24;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 4|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 400;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las7gpstimeENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodISC_EEEEEC2ERS9_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 __ZN6laszip7formats10base_fieldC2Ev($4);
 HEAP32[$4>>2] = (2152);
 $5 = ((($4)) + 4|0);
 $6 = $3;
 HEAP32[$5>>2] = $6;
 $7 = ((($4)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEEC2Ev($7);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2176);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 4|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP8[$2>>0] = 0;
 $3 = ((($2)) + 1|0);
 __ZN6laszip7formats3las3rgbC2Ev($3);
 $4 = ((($2)) + 8|0);
 __ZN6laszip6models10arithmeticC2EjbPj($4,128,0,0);
 $5 = ((($2)) + 52|0);
 __ZN6laszip6models10arithmeticC2EjbPj($5,256,0,0);
 $6 = ((($2)) + 96|0);
 __ZN6laszip6models10arithmeticC2EjbPj($6,256,0,0);
 $7 = ((($2)) + 140|0);
 __ZN6laszip6models10arithmeticC2EjbPj($7,256,0,0);
 $8 = ((($2)) + 184|0);
 __ZN6laszip6models10arithmeticC2EjbPj($8,256,0,0);
 $9 = ((($2)) + 228|0);
 __ZN6laszip6models10arithmeticC2EjbPj($9,256,0,0);
 $10 = ((($2)) + 272|0);
 __ZN6laszip6models10arithmeticC2EjbPj($10,256,0,0);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodISC_EEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (2152);
 $3 = ((($2)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEED2Ev($3);
 __ZN6laszip7formats10base_fieldD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodISC_EEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodISC_EEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodISC_EEEEE13decompressRawEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = ((($4)) + 8|0);
 $6 = ((($4)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $3;
 $9 = (__ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($5,$7,$8)|0);
 STACKTOP = sp;return ($9|0);
}
function __ZN6laszip7formats3las3rgbC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP8[$2>>0]=0&255;HEAP8[$2+1>>0]=0>>8;
 $3 = ((($2)) + 2|0);
 HEAP8[$3>>0]=0&255;HEAP8[$3+1>>0]=0>>8;
 $4 = ((($2)) + 4|0);
 HEAP8[$4>>0]=0&255;HEAP8[$4+1>>0]=0>>8;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 272|0);
 __ZN6laszip6models10arithmeticD2Ev($3);
 $4 = ((($2)) + 228|0);
 __ZN6laszip6models10arithmeticD2Ev($4);
 $5 = ((($2)) + 184|0);
 __ZN6laszip6models10arithmeticD2Ev($5);
 $6 = ((($2)) + 140|0);
 __ZN6laszip6models10arithmeticD2Ev($6);
 $7 = ((($2)) + 96|0);
 __ZN6laszip6models10arithmeticD2Ev($7);
 $8 = ((($2)) + 52|0);
 __ZN6laszip6models10arithmeticD2Ev($8);
 $9 = ((($2)) + 8|0);
 __ZN6laszip6models10arithmeticD2Ev($9);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0;
 var $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0;
 var $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0;
 var $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0;
 var $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0;
 var $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0, $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0;
 var $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0, $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0;
 var $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0, $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $34 = 0, $35 = 0, $36 = 0;
 var $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0;
 var $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0;
 var $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0;
 var $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $7 = sp + 32|0;
 $11 = sp + 24|0;
 $4 = $0;
 $5 = $1;
 $6 = $2;
 $12 = $4;
 $13 = HEAP8[$12>>0]|0;
 $14 = $13&1;
 if (!($14)) {
  HEAP8[$12>>0] = 1;
  $15 = $5;
  $16 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE11getInStreamEv($15)|0);
  $17 = $6;
  __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE8getBytesEPhj($16,$17,6);
  $18 = $6;
  __ZN6laszip7formats7packersINS0_3las3rgbEE6unpackEPKc($7,$18);
  $19 = ((($12)) + 1|0);
  ;HEAP8[$19>>0]=HEAP8[$7>>0]|0;HEAP8[$19+1>>0]=HEAP8[$7+1>>0]|0;HEAP8[$19+2>>0]=HEAP8[$7+2>>0]|0;HEAP8[$19+3>>0]=HEAP8[$7+3>>0]|0;HEAP8[$19+4>>0]=HEAP8[$7+4>>0]|0;HEAP8[$19+5>>0]=HEAP8[$7+5>>0]|0;
  $20 = $6;
  $21 = ((($20)) + 6|0);
  $3 = $21;
  $331 = $3;
  STACKTOP = sp;return ($331|0);
 }
 $9 = 0;
 $22 = $5;
 $23 = ((($12)) + 8|0);
 $24 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($22,$23)|0);
 $10 = $24;
 __ZN6laszip7formats3las3rgbC2Ev($11);
 $25 = $10;
 $26 = $25 & 1;
 $27 = ($26|0)!=(0);
 if ($27) {
  $28 = $5;
  $29 = ((($12)) + 52|0);
  $30 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($28,$29)|0);
  $31 = $30&255;
  $8 = $31;
  $32 = $8;
  $33 = $32&255;
  $34 = ((($12)) + 1|0);
  $35 = HEAPU8[$34>>0]|(HEAPU8[$34+1>>0]<<8);
  $36 = $35&65535;
  $37 = $36 & 255;
  $38 = (($33) + ($37))|0;
  $39 = (__Z7U8_FOLDi($38)|0);
  $40 = $39&255;
  HEAP8[$11>>0]=$40&255;HEAP8[$11+1>>0]=$40>>8;
 } else {
  $41 = ((($12)) + 1|0);
  $42 = HEAPU8[$41>>0]|(HEAPU8[$41+1>>0]<<8);
  $43 = $42&65535;
  $44 = $43 & 255;
  $45 = $44&65535;
  HEAP8[$11>>0]=$45&255;HEAP8[$11+1>>0]=$45>>8;
 }
 $46 = $10;
 $47 = $46 & 2;
 $48 = ($47|0)!=(0);
 if ($48) {
  $49 = $5;
  $50 = ((($12)) + 96|0);
  $51 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($49,$50)|0);
  $52 = $51&255;
  $8 = $52;
  $53 = $8;
  $54 = $53&255;
  $55 = ((($12)) + 1|0);
  $56 = HEAPU8[$55>>0]|(HEAPU8[$55+1>>0]<<8);
  $57 = $56&65535;
  $58 = $57 >> 8;
  $59 = (($54) + ($58))|0;
  $60 = (__Z7U8_FOLDi($59)|0);
  $61 = $60&255;
  $62 = $61&65535;
  $63 = $62 << 8;
  $64 = HEAPU8[$11>>0]|(HEAPU8[$11+1>>0]<<8);
  $65 = $64&65535;
  $66 = $65 | $63;
  $67 = $66&65535;
  HEAP8[$11>>0]=$67&255;HEAP8[$11+1>>0]=$67>>8;
 } else {
  $68 = ((($12)) + 1|0);
  $69 = HEAPU8[$68>>0]|(HEAPU8[$68+1>>0]<<8);
  $70 = $69&65535;
  $71 = $70 & 65280;
  $72 = HEAPU8[$11>>0]|(HEAPU8[$11+1>>0]<<8);
  $73 = $72&65535;
  $74 = $73 | $71;
  $75 = $74&65535;
  HEAP8[$11>>0]=$75&255;HEAP8[$11+1>>0]=$75>>8;
 }
 $76 = $10;
 $77 = $76 & 64;
 $78 = ($77|0)!=(0);
 $79 = HEAPU8[$11>>0]|(HEAPU8[$11+1>>0]<<8);
 do {
  if ($78) {
   $80 = $79&65535;
   $81 = $80 & 255;
   $82 = ((($12)) + 1|0);
   $83 = HEAPU8[$82>>0]|(HEAPU8[$82+1>>0]<<8);
   $84 = $83&65535;
   $85 = $84 & 255;
   $86 = (($81) - ($85))|0;
   $9 = $86;
   $87 = $10;
   $88 = $87 & 4;
   $89 = ($88|0)!=(0);
   if ($89) {
    $90 = $5;
    $91 = ((($12)) + 140|0);
    $92 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($90,$91)|0);
    $93 = $92&255;
    $8 = $93;
    $94 = $8;
    $95 = $94&255;
    $96 = $9;
    $97 = ((($12)) + 1|0);
    $98 = ((($97)) + 2|0);
    $99 = HEAPU8[$98>>0]|(HEAPU8[$98+1>>0]<<8);
    $100 = $99&65535;
    $101 = $100 & 255;
    $102 = (($96) + ($101))|0;
    $103 = ($102|0)<=(0);
    if ($103) {
     $121 = 0;
    } else {
     $104 = $9;
     $105 = ((($12)) + 1|0);
     $106 = ((($105)) + 2|0);
     $107 = HEAPU8[$106>>0]|(HEAPU8[$106+1>>0]<<8);
     $108 = $107&65535;
     $109 = $108 & 255;
     $110 = (($104) + ($109))|0;
     $111 = ($110|0)>=(255);
     if ($111) {
      $121 = -1;
     } else {
      $112 = $9;
      $113 = ((($12)) + 1|0);
      $114 = ((($113)) + 2|0);
      $115 = HEAPU8[$114>>0]|(HEAPU8[$114+1>>0]<<8);
      $116 = $115&65535;
      $117 = $116 & 255;
      $118 = (($112) + ($117))|0;
      $119 = $118&255;
      $121 = $119;
     }
    }
    $120 = $121&255;
    $122 = (($95) + ($120))|0;
    $123 = (__Z7U8_FOLDi($122)|0);
    $124 = $123&255;
    $125 = ((($11)) + 2|0);
    HEAP8[$125>>0]=$124&255;HEAP8[$125+1>>0]=$124>>8;
   } else {
    $126 = ((($12)) + 1|0);
    $127 = ((($126)) + 2|0);
    $128 = HEAPU8[$127>>0]|(HEAPU8[$127+1>>0]<<8);
    $129 = $128&65535;
    $130 = $129 & 255;
    $131 = $130&65535;
    $132 = ((($11)) + 2|0);
    HEAP8[$132>>0]=$131&255;HEAP8[$132+1>>0]=$131>>8;
   }
   $133 = $10;
   $134 = $133 & 16;
   $135 = ($134|0)!=(0);
   if ($135) {
    $136 = $5;
    $137 = ((($12)) + 228|0);
    $138 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($136,$137)|0);
    $139 = $138&255;
    $8 = $139;
    $140 = $9;
    $141 = ((($11)) + 2|0);
    $142 = HEAPU8[$141>>0]|(HEAPU8[$141+1>>0]<<8);
    $143 = $142&65535;
    $144 = $143 & 255;
    $145 = (($140) + ($144))|0;
    $146 = ((($12)) + 1|0);
    $147 = ((($146)) + 2|0);
    $148 = HEAPU8[$147>>0]|(HEAPU8[$147+1>>0]<<8);
    $149 = $148&65535;
    $150 = $149 & 255;
    $151 = (($145) - ($150))|0;
    $152 = (($151|0) / 2)&-1;
    $9 = $152;
    $153 = $8;
    $154 = $153&255;
    $155 = $9;
    $156 = ((($12)) + 1|0);
    $157 = ((($156)) + 4|0);
    $158 = HEAPU8[$157>>0]|(HEAPU8[$157+1>>0]<<8);
    $159 = $158&65535;
    $160 = $159 & 255;
    $161 = (($155) + ($160))|0;
    $162 = ($161|0)<=(0);
    if ($162) {
     $180 = 0;
    } else {
     $163 = $9;
     $164 = ((($12)) + 1|0);
     $165 = ((($164)) + 4|0);
     $166 = HEAPU8[$165>>0]|(HEAPU8[$165+1>>0]<<8);
     $167 = $166&65535;
     $168 = $167 & 255;
     $169 = (($163) + ($168))|0;
     $170 = ($169|0)>=(255);
     if ($170) {
      $180 = -1;
     } else {
      $171 = $9;
      $172 = ((($12)) + 1|0);
      $173 = ((($172)) + 4|0);
      $174 = HEAPU8[$173>>0]|(HEAPU8[$173+1>>0]<<8);
      $175 = $174&65535;
      $176 = $175 & 255;
      $177 = (($171) + ($176))|0;
      $178 = $177&255;
      $180 = $178;
     }
    }
    $179 = $180&255;
    $181 = (($154) + ($179))|0;
    $182 = (__Z7U8_FOLDi($181)|0);
    $183 = $182&255;
    $184 = ((($11)) + 4|0);
    HEAP8[$184>>0]=$183&255;HEAP8[$184+1>>0]=$183>>8;
   } else {
    $185 = ((($12)) + 1|0);
    $186 = ((($185)) + 4|0);
    $187 = HEAPU8[$186>>0]|(HEAPU8[$186+1>>0]<<8);
    $188 = $187&65535;
    $189 = $188 & 255;
    $190 = $189&65535;
    $191 = ((($11)) + 4|0);
    HEAP8[$191>>0]=$190&255;HEAP8[$191+1>>0]=$190>>8;
   }
   $192 = HEAPU8[$11>>0]|(HEAPU8[$11+1>>0]<<8);
   $193 = $192&65535;
   $194 = $193 >> 8;
   $195 = ((($12)) + 1|0);
   $196 = HEAPU8[$195>>0]|(HEAPU8[$195+1>>0]<<8);
   $197 = $196&65535;
   $198 = $197 >> 8;
   $199 = (($194) - ($198))|0;
   $9 = $199;
   $200 = $10;
   $201 = $200 & 8;
   $202 = ($201|0)!=(0);
   if ($202) {
    $203 = $5;
    $204 = ((($12)) + 184|0);
    $205 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($203,$204)|0);
    $206 = $205&255;
    $8 = $206;
    $207 = $8;
    $208 = $207&255;
    $209 = $9;
    $210 = ((($12)) + 1|0);
    $211 = ((($210)) + 2|0);
    $212 = HEAPU8[$211>>0]|(HEAPU8[$211+1>>0]<<8);
    $213 = $212&65535;
    $214 = $213 >> 8;
    $215 = (($209) + ($214))|0;
    $216 = ($215|0)<=(0);
    if ($216) {
     $234 = 0;
    } else {
     $217 = $9;
     $218 = ((($12)) + 1|0);
     $219 = ((($218)) + 2|0);
     $220 = HEAPU8[$219>>0]|(HEAPU8[$219+1>>0]<<8);
     $221 = $220&65535;
     $222 = $221 >> 8;
     $223 = (($217) + ($222))|0;
     $224 = ($223|0)>=(255);
     if ($224) {
      $234 = -1;
     } else {
      $225 = $9;
      $226 = ((($12)) + 1|0);
      $227 = ((($226)) + 2|0);
      $228 = HEAPU8[$227>>0]|(HEAPU8[$227+1>>0]<<8);
      $229 = $228&65535;
      $230 = $229 >> 8;
      $231 = (($225) + ($230))|0;
      $232 = $231&255;
      $234 = $232;
     }
    }
    $233 = $234&255;
    $235 = (($208) + ($233))|0;
    $236 = (__Z7U8_FOLDi($235)|0);
    $237 = $236&255;
    $238 = $237&65535;
    $239 = $238 << 8;
    $240 = ((($11)) + 2|0);
    $241 = HEAPU8[$240>>0]|(HEAPU8[$240+1>>0]<<8);
    $242 = $241&65535;
    $243 = $242 | $239;
    $244 = $243&65535;
    HEAP8[$240>>0]=$244&255;HEAP8[$240+1>>0]=$244>>8;
   } else {
    $245 = ((($12)) + 1|0);
    $246 = ((($245)) + 2|0);
    $247 = HEAPU8[$246>>0]|(HEAPU8[$246+1>>0]<<8);
    $248 = $247&65535;
    $249 = $248 & 65280;
    $250 = ((($11)) + 2|0);
    $251 = HEAPU8[$250>>0]|(HEAPU8[$250+1>>0]<<8);
    $252 = $251&65535;
    $253 = $252 | $249;
    $254 = $253&65535;
    HEAP8[$250>>0]=$254&255;HEAP8[$250+1>>0]=$254>>8;
   }
   $255 = $10;
   $256 = $255 & 32;
   $257 = ($256|0)!=(0);
   if (!($257)) {
    $313 = ((($12)) + 1|0);
    $314 = ((($313)) + 4|0);
    $315 = HEAPU8[$314>>0]|(HEAPU8[$314+1>>0]<<8);
    $316 = $315&65535;
    $317 = $316 & 65280;
    $318 = ((($11)) + 4|0);
    $319 = HEAPU8[$318>>0]|(HEAPU8[$318+1>>0]<<8);
    $320 = $319&65535;
    $321 = $320 | $317;
    $322 = $321&65535;
    HEAP8[$318>>0]=$322&255;HEAP8[$318+1>>0]=$322>>8;
    break;
   }
   $258 = $5;
   $259 = ((($12)) + 272|0);
   $260 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($258,$259)|0);
   $261 = $260&255;
   $8 = $261;
   $262 = $9;
   $263 = ((($11)) + 2|0);
   $264 = HEAPU8[$263>>0]|(HEAPU8[$263+1>>0]<<8);
   $265 = $264&65535;
   $266 = $265 >> 8;
   $267 = (($262) + ($266))|0;
   $268 = ((($12)) + 1|0);
   $269 = ((($268)) + 2|0);
   $270 = HEAPU8[$269>>0]|(HEAPU8[$269+1>>0]<<8);
   $271 = $270&65535;
   $272 = $271 >> 8;
   $273 = (($267) - ($272))|0;
   $274 = (($273|0) / 2)&-1;
   $9 = $274;
   $275 = $8;
   $276 = $275&255;
   $277 = $9;
   $278 = ((($12)) + 1|0);
   $279 = ((($278)) + 4|0);
   $280 = HEAPU8[$279>>0]|(HEAPU8[$279+1>>0]<<8);
   $281 = $280&65535;
   $282 = $281 >> 8;
   $283 = (($277) + ($282))|0;
   $284 = ($283|0)<=(0);
   if ($284) {
    $302 = 0;
   } else {
    $285 = $9;
    $286 = ((($12)) + 1|0);
    $287 = ((($286)) + 4|0);
    $288 = HEAPU8[$287>>0]|(HEAPU8[$287+1>>0]<<8);
    $289 = $288&65535;
    $290 = $289 >> 8;
    $291 = (($285) + ($290))|0;
    $292 = ($291|0)>=(255);
    if ($292) {
     $302 = -1;
    } else {
     $293 = $9;
     $294 = ((($12)) + 1|0);
     $295 = ((($294)) + 4|0);
     $296 = HEAPU8[$295>>0]|(HEAPU8[$295+1>>0]<<8);
     $297 = $296&65535;
     $298 = $297 >> 8;
     $299 = (($293) + ($298))|0;
     $300 = $299&255;
     $302 = $300;
    }
   }
   $301 = $302&255;
   $303 = (($276) + ($301))|0;
   $304 = (__Z7U8_FOLDi($303)|0);
   $305 = $304&255;
   $306 = $305&65535;
   $307 = $306 << 8;
   $308 = ((($11)) + 4|0);
   $309 = HEAPU8[$308>>0]|(HEAPU8[$308+1>>0]<<8);
   $310 = $309&65535;
   $311 = $310 | $307;
   $312 = $311&65535;
   HEAP8[$308>>0]=$312&255;HEAP8[$308+1>>0]=$312>>8;
  } else {
   $323 = ((($11)) + 2|0);
   HEAP8[$323>>0]=$79&255;HEAP8[$323+1>>0]=$79>>8;
   $324 = HEAPU8[$11>>0]|(HEAPU8[$11+1>>0]<<8);
   $325 = ((($11)) + 4|0);
   HEAP8[$325>>0]=$324&255;HEAP8[$325+1>>0]=$324>>8;
  }
 } while(0);
 $326 = ((($12)) + 1|0);
 ;HEAP8[$326>>0]=HEAP8[$11>>0]|0;HEAP8[$326+1>>0]=HEAP8[$11+1>>0]|0;HEAP8[$326+2>>0]=HEAP8[$11+2>>0]|0;HEAP8[$326+3>>0]=HEAP8[$11+3>>0]|0;HEAP8[$326+4>>0]=HEAP8[$11+4>>0]|0;HEAP8[$326+5>>0]=HEAP8[$11+5>>0]|0;
 $327 = ((($12)) + 1|0);
 $328 = $6;
 __ZN6laszip7formats7packersINS0_3las3rgbEE4packERKS3_Pc($327,$328);
 $329 = $6;
 $330 = ((($329)) + 6|0);
 $3 = $330;
 $331 = $3;
 STACKTOP = sp;return ($331|0);
}
function __ZN6laszip7formats7packersINS0_3las3rgbEE6unpackEPKc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $1;
 $3 = $2;
 $4 = (__ZN6laszip7formats7packersItE6unpackEPKc($3)|0);
 $5 = $2;
 $6 = ((($5)) + 2|0);
 $7 = (__ZN6laszip7formats7packersItE6unpackEPKc($6)|0);
 $8 = $2;
 $9 = ((($8)) + 4|0);
 $10 = (__ZN6laszip7formats7packersItE6unpackEPKc($9)|0);
 __ZN6laszip7formats3las3rgbC2Ettt($0,$4,$7,$10);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats7packersINS0_3las3rgbEE4packERKS3_Pc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = HEAPU8[$4>>0]|(HEAPU8[$4+1>>0]<<8);
 $6 = $3;
 __ZN6laszip7formats7packersItE4packEtPc($5,$6);
 $7 = $2;
 $8 = ((($7)) + 2|0);
 $9 = HEAPU8[$8>>0]|(HEAPU8[$8+1>>0]<<8);
 $10 = $3;
 $11 = ((($10)) + 2|0);
 __ZN6laszip7formats7packersItE4packEtPc($9,$11);
 $12 = $2;
 $13 = ((($12)) + 4|0);
 $14 = HEAPU8[$13>>0]|(HEAPU8[$13+1>>0]<<8);
 $15 = $3;
 $16 = ((($15)) + 4|0);
 __ZN6laszip7formats7packersItE4packEtPc($14,$16);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats3las3rgbC2Ettt($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $4 = $0;
 $5 = $1;
 $6 = $2;
 $7 = $3;
 $8 = $4;
 $9 = $5;
 HEAP8[$8>>0]=$9&255;HEAP8[$8+1>>0]=$9>>8;
 $10 = ((($8)) + 2|0);
 $11 = $6;
 HEAP8[$10>>0]=$11&255;HEAP8[$10+1>>0]=$11>>8;
 $12 = ((($8)) + 4|0);
 $13 = $7;
 HEAP8[$12>>0]=$13&255;HEAP8[$12+1>>0]=$13>>8;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 4|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 440;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las3rgbENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISC_EEEEEC2ERS9_RKSF_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 __ZN6laszip7formats10base_fieldC2Ev($6);
 HEAP32[$6>>2] = (2204);
 $7 = ((($6)) + 4|0);
 $8 = $4;
 HEAP32[$7>>2] = $8;
 $9 = ((($6)) + 8|0);
 $10 = $5;
 __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEEC2ERKS6_($9,$10);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEEC2INS2_26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISH_EEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISN_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2228);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats10base_fieldEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 4|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEEC2ERKS6_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 ;HEAP32[$4>>2]=HEAP32[$5>>2]|0;HEAP8[$4+4>>0]=HEAP8[$5+4>>0]|0;
 $6 = ((($4)) + 8|0);
 $7 = $3;
 $8 = ((($7)) + 8|0);
 __ZNSt3__26vectorIhNS_9allocatorIhEEEC2ERKS3_($6,$8);
 $9 = ((($4)) + 20|0);
 $10 = $3;
 $11 = ((($10)) + 20|0);
 __ZNSt3__26vectorIhNS_9allocatorIhEEEC2ERKS3_($9,$11);
 $12 = ((($4)) + 32|0);
 $13 = $3;
 $14 = ((($13)) + 32|0);
 __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEEC2ERKS6_($12,$14);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISC_EEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP32[$2>>2] = (2204);
 $3 = ((($2)) + 8|0);
 __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEED2Ev($3);
 __ZN6laszip7formats10base_fieldD2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISC_EEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISC_EEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats26dynamic_decompressor_fieldINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_5fieldINS0_3las10extrabytesENS0_20standard_diff_methodISC_EEEEE13decompressRawEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = ((($4)) + 8|0);
 $6 = ((($4)) + 4|0);
 $7 = HEAP32[$6>>2]|0;
 $8 = $3;
 $9 = (__ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($5,$7,$8)|0);
 STACKTOP = sp;return ($9|0);
}
function __ZNSt3__26vectorIhNS_9allocatorIhEEEC2ERKS3_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0;
 var $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 112|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(112|0);
 $17 = sp + 36|0;
 $19 = sp;
 $21 = sp + 101|0;
 $27 = sp + 100|0;
 $25 = $0;
 $26 = $1;
 $29 = $25;
 $30 = $26;
 $24 = $30;
 $31 = $24;
 $32 = ((($31)) + 8|0);
 $23 = $32;
 $33 = $23;
 $22 = $33;
 $34 = $22;
 $20 = $34;
 $35 = $20;
 ;HEAP8[$19>>0]=HEAP8[$21>>0]|0;
 $18 = $35;
 $15 = $29;
 $16 = $27;
 $36 = $15;
 $14 = $36;
 HEAP32[$36>>2] = 0;
 $37 = ((($36)) + 4|0);
 HEAP32[$37>>2] = 0;
 $38 = ((($36)) + 8|0);
 HEAP32[$17>>2] = 0;
 $39 = $16;
 $11 = $38;
 $12 = $17;
 $13 = $39;
 $40 = $11;
 $41 = $12;
 $10 = $41;
 $42 = $10;
 $4 = $40;
 $5 = $42;
 $43 = $4;
 $44 = $5;
 $3 = $44;
 HEAP32[$43>>2] = 0;
 $45 = $13;
 $6 = $45;
 $46 = $6;
 $8 = $40;
 $9 = $46;
 $47 = $9;
 $7 = $47;
 $48 = $26;
 $2 = $48;
 $49 = $2;
 $50 = ((($49)) + 4|0);
 $51 = HEAP32[$50>>2]|0;
 $52 = HEAP32[$49>>2]|0;
 $53 = $51;
 $54 = $52;
 $55 = (($53) - ($54))|0;
 $28 = $55;
 $56 = $28;
 $57 = ($56>>>0)>(0);
 if (!($57)) {
  STACKTOP = sp;return;
 }
 $58 = $28;
 __ZNSt3__26vectorIhNS_9allocatorIhEEE8allocateEj($29,$58);
 $59 = $26;
 $60 = HEAP32[$59>>2]|0;
 $61 = $26;
 $62 = ((($61)) + 4|0);
 $63 = HEAP32[$62>>2]|0;
 $64 = $28;
 __ZNSt3__26vectorIhNS_9allocatorIhEEE18__construct_at_endIPhEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeES7_S7_j($29,$60,$63,$64);
 STACKTOP = sp;return;
}
function __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEEC2ERKS6_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0;
 var $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0;
 var $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0;
 var $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0;
 var $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 208|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(208|0);
 $$byval_copy1 = sp + 192|0;
 $$byval_copy = sp + 184|0;
 $28 = sp + 72|0;
 $33 = sp + 202|0;
 $34 = sp + 52|0;
 $36 = sp;
 $38 = sp + 201|0;
 $44 = sp + 200|0;
 $45 = sp + 16|0;
 $46 = sp + 8|0;
 $42 = $0;
 $43 = $1;
 $47 = $42;
 $48 = $43;
 $41 = $48;
 $49 = $41;
 $50 = ((($49)) + 20|0);
 $40 = $50;
 $51 = $40;
 $39 = $51;
 $52 = $39;
 $37 = $52;
 $53 = $37;
 ;HEAP8[$36>>0]=HEAP8[$38>>0]|0;
 $35 = $53;
 $31 = $47;
 $32 = $44;
 $54 = $31;
 $55 = $32;
 $29 = $33;
 $30 = $55;
 $26 = $54;
 $27 = $33;
 $56 = $26;
 HEAP32[$56>>2] = 0;
 $57 = ((($56)) + 4|0);
 HEAP32[$57>>2] = 0;
 $58 = ((($56)) + 8|0);
 HEAP32[$58>>2] = 0;
 $59 = ((($56)) + 12|0);
 HEAP32[$28>>2] = 0;
 $60 = $27;
 $23 = $59;
 $24 = $28;
 $25 = $60;
 $61 = $23;
 $62 = $24;
 $22 = $62;
 $63 = $22;
 $16 = $61;
 $17 = $63;
 $64 = $16;
 $65 = $17;
 $15 = $65;
 HEAP32[$64>>2] = 0;
 $66 = $25;
 $18 = $66;
 $67 = $18;
 $20 = $61;
 $21 = $67;
 $68 = $21;
 $19 = $68;
 $69 = ((($54)) + 16|0);
 HEAP32[$69>>2] = 0;
 $70 = ((($54)) + 20|0);
 HEAP32[$34>>2] = 0;
 $71 = $32;
 $12 = $70;
 $13 = $34;
 $14 = $71;
 $72 = $12;
 $73 = $13;
 $11 = $73;
 $74 = $11;
 $5 = $72;
 $6 = $74;
 $75 = $5;
 $76 = $6;
 $4 = $76;
 $77 = $4;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = $14;
 $7 = $79;
 $80 = $7;
 $9 = $72;
 $10 = $80;
 $81 = $10;
 $8 = $81;
 $82 = $43;
 $2 = $82;
 $83 = $2;
 __ZNKSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5beginEv($45,$83);
 $84 = $43;
 $3 = $84;
 $85 = $3;
 __ZNKSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE3endEv($46,$85);
 ;HEAP32[$$byval_copy>>2]=HEAP32[$45>>2]|0;HEAP32[$$byval_copy+4>>2]=HEAP32[$45+4>>2]|0;
 ;HEAP32[$$byval_copy1>>2]=HEAP32[$46>>2]|0;HEAP32[$$byval_copy1+4>>2]=HEAP32[$46+4>>2]|0;
 __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE8__appendINS_16__deque_iteratorIS3_PKS3_RS9_PKSA_iLi0EEEEEvT_SF_PNS_9enable_ifIXsr21__is_forward_iteratorISF_EE5valueEvE4typeE($47,$$byval_copy,$$byval_copy1,0);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIhNS_9allocatorIhEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__213__vector_baseIhNS_9allocatorIhEEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIhNS_9allocatorIhEEE8allocateEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0;
 var $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0;
 var $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0;
 var $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0;
 var $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 160|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(160|0);
 $40 = $0;
 $41 = $1;
 $42 = $40;
 $43 = $41;
 $44 = (__ZNKSt3__26vectorIhNS_9allocatorIhEEE8max_sizeEv($42)|0);
 $45 = ($43>>>0)>($44>>>0);
 if ($45) {
  __ZNKSt3__220__vector_base_commonILb1EE20__throw_length_errorEv($42);
  // unreachable;
 } else {
  $39 = $42;
  $46 = $39;
  $47 = ((($46)) + 8|0);
  $38 = $47;
  $48 = $38;
  $37 = $48;
  $49 = $37;
  $50 = $41;
  $7 = $49;
  $8 = $50;
  $51 = $7;
  $52 = $8;
  $4 = $51;
  $5 = $52;
  $6 = 0;
  $53 = $4;
  $3 = $53;
  $54 = $5;
  $2 = $54;
  $55 = $2;
  $56 = (__Znwj($55)|0);
  $57 = ((($42)) + 4|0);
  HEAP32[$57>>2] = $56;
  HEAP32[$42>>2] = $56;
  $58 = HEAP32[$42>>2]|0;
  $59 = $41;
  $60 = (($58) + ($59)|0);
  $11 = $42;
  $61 = $11;
  $62 = ((($61)) + 8|0);
  $10 = $62;
  $63 = $10;
  $9 = $63;
  $64 = $9;
  HEAP32[$64>>2] = $60;
  $35 = $42;
  $36 = 0;
  $65 = $35;
  $34 = $65;
  $66 = $34;
  $67 = HEAP32[$66>>2]|0;
  $33 = $67;
  $68 = $33;
  $13 = $65;
  $69 = $13;
  $70 = HEAP32[$69>>2]|0;
  $12 = $70;
  $71 = $12;
  $18 = $65;
  $72 = $18;
  $17 = $72;
  $73 = $17;
  $16 = $73;
  $74 = $16;
  $75 = ((($74)) + 8|0);
  $15 = $75;
  $76 = $15;
  $14 = $76;
  $77 = $14;
  $78 = HEAP32[$77>>2]|0;
  $79 = HEAP32[$73>>2]|0;
  $80 = $78;
  $81 = $79;
  $82 = (($80) - ($81))|0;
  $83 = (($71) + ($82)|0);
  $20 = $65;
  $84 = $20;
  $85 = HEAP32[$84>>2]|0;
  $19 = $85;
  $86 = $19;
  $25 = $65;
  $87 = $25;
  $24 = $87;
  $88 = $24;
  $23 = $88;
  $89 = $23;
  $90 = ((($89)) + 8|0);
  $22 = $90;
  $91 = $22;
  $21 = $91;
  $92 = $21;
  $93 = HEAP32[$92>>2]|0;
  $94 = HEAP32[$88>>2]|0;
  $95 = $93;
  $96 = $94;
  $97 = (($95) - ($96))|0;
  $98 = (($86) + ($97)|0);
  $27 = $65;
  $99 = $27;
  $100 = HEAP32[$99>>2]|0;
  $26 = $100;
  $101 = $26;
  $102 = $36;
  $103 = (($101) + ($102)|0);
  $28 = $65;
  $29 = $68;
  $30 = $83;
  $31 = $98;
  $32 = $103;
  STACKTOP = sp;return;
 }
}
function __ZNSt3__26vectorIhNS_9allocatorIhEEE18__construct_at_endIPhEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeES7_S7_j($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $21 = sp + 68|0;
 $16 = $0;
 $17 = $1;
 $18 = $2;
 $19 = $3;
 $22 = $16;
 $15 = $22;
 $23 = $15;
 $24 = ((($23)) + 8|0);
 $14 = $24;
 $25 = $14;
 $13 = $25;
 $26 = $13;
 $20 = $26;
 $27 = $19;
 $4 = $21;
 $5 = $22;
 $6 = $27;
 $28 = $20;
 $29 = $17;
 $30 = $18;
 $31 = ((($22)) + 4|0);
 $7 = $28;
 $8 = $29;
 $9 = $30;
 $10 = $31;
 $32 = $9;
 $33 = $8;
 $34 = $32;
 $35 = $33;
 $36 = (($34) - ($35))|0;
 $11 = $36;
 $37 = $11;
 $38 = ($37|0)>(0);
 if (!($38)) {
  $12 = $21;
  STACKTOP = sp;return;
 }
 $39 = $10;
 $40 = HEAP32[$39>>2]|0;
 $41 = $8;
 $42 = $11;
 _memcpy(($40|0),($41|0),($42|0))|0;
 $43 = $11;
 $44 = $10;
 $45 = HEAP32[$44>>2]|0;
 $46 = (($45) + ($43)|0);
 HEAP32[$44>>2] = $46;
 $12 = $21;
 STACKTOP = sp;return;
}
function __ZNSt3__213__vector_baseIhNS_9allocatorIhEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $19 = sp;
 $22 = sp + 120|0;
 $31 = $0;
 $32 = $31;
 $33 = HEAP32[$32>>2]|0;
 $34 = ($33|0)!=(0|0);
 if (!($34)) {
  STACKTOP = sp;return;
 }
 $30 = $32;
 $35 = $30;
 $36 = HEAP32[$35>>2]|0;
 $27 = $35;
 $28 = $36;
 $37 = $27;
 $38 = ((($37)) + 4|0);
 $39 = HEAP32[$38>>2]|0;
 $29 = $39;
 while(1) {
  $40 = $28;
  $41 = $29;
  $42 = ($40|0)!=($41|0);
  if (!($42)) {
   break;
  }
  $26 = $37;
  $43 = $26;
  $44 = ((($43)) + 8|0);
  $25 = $44;
  $45 = $25;
  $24 = $45;
  $46 = $24;
  $47 = $29;
  $48 = ((($47)) + -1|0);
  $29 = $48;
  $23 = $48;
  $49 = $23;
  $20 = $46;
  $21 = $49;
  $50 = $20;
  $51 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $50;
  $18 = $51;
  $52 = $17;
  $53 = $18;
  $15 = $52;
  $16 = $53;
 }
 $54 = $28;
 $55 = ((($37)) + 4|0);
 HEAP32[$55>>2] = $54;
 $7 = $32;
 $56 = $7;
 $57 = ((($56)) + 8|0);
 $6 = $57;
 $58 = $6;
 $5 = $58;
 $59 = $5;
 $60 = HEAP32[$32>>2]|0;
 $4 = $32;
 $61 = $4;
 $3 = $61;
 $62 = $3;
 $63 = ((($62)) + 8|0);
 $2 = $63;
 $64 = $2;
 $1 = $64;
 $65 = $1;
 $66 = HEAP32[$65>>2]|0;
 $67 = HEAP32[$61>>2]|0;
 $68 = $66;
 $69 = $67;
 $70 = (($68) - ($69))|0;
 $12 = $59;
 $13 = $60;
 $14 = $70;
 $71 = $12;
 $72 = $13;
 $73 = $14;
 $9 = $71;
 $10 = $72;
 $11 = $73;
 $74 = $10;
 $8 = $74;
 $75 = $8;
 __ZdlPv($75);
 STACKTOP = sp;return;
}
function __ZNKSt3__26vectorIhNS_9allocatorIhEEE8max_sizeEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $6 = sp + 8|0;
 $9 = sp + 77|0;
 $12 = sp;
 $14 = sp + 76|0;
 $19 = sp + 16|0;
 $20 = sp + 12|0;
 $18 = $0;
 $21 = $18;
 $17 = $21;
 $22 = $17;
 $23 = ((($22)) + 8|0);
 $16 = $23;
 $24 = $16;
 $15 = $24;
 $25 = $15;
 $13 = $25;
 $26 = $13;
 ;HEAP8[$12>>0]=HEAP8[$14>>0]|0;
 $11 = $26;
 $27 = $11;
 $10 = $27;
 HEAP32[$19>>2] = -1;
 HEAP32[$20>>2] = 2147483647;
 $7 = $19;
 $8 = $20;
 $28 = $7;
 $29 = $8;
 ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
 $4 = $28;
 $5 = $29;
 $30 = $5;
 $31 = $4;
 $1 = $6;
 $2 = $30;
 $3 = $31;
 $32 = $2;
 $33 = HEAP32[$32>>2]|0;
 $34 = $3;
 $35 = HEAP32[$34>>2]|0;
 $36 = ($33>>>0)<($35>>>0);
 $37 = $5;
 $38 = $4;
 $39 = $36 ? $37 : $38;
 $40 = HEAP32[$39>>2]|0;
 STACKTOP = sp;return ($40|0);
}
function __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE8__appendINS_16__deque_iteratorIS3_PKS3_RS9_PKSA_iLi0EEEEEvT_SF_PNS_9enable_ifIXsr21__is_forward_iteratorISF_EE5valueEvE4typeE($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0;
 var $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $30 = 0, $31 = 0;
 var $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0;
 var $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0;
 var $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0;
 var $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 288|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(288|0);
 $29 = sp + 40|0;
 $34 = sp + 277|0;
 $47 = sp + 32|0;
 $48 = sp + 24|0;
 $49 = sp + 16|0;
 $50 = sp + 104|0;
 $51 = sp + 96|0;
 $52 = sp + 276|0;
 $53 = sp + 8|0;
 $54 = sp;
 $58 = sp + 72|0;
 $59 = sp + 64|0;
 $62 = sp + 48|0;
 $55 = $0;
 $56 = $3;
 $63 = $55;
 ;HEAP32[$58>>2]=HEAP32[$1>>2]|0;HEAP32[$58+4>>2]=HEAP32[$1+4>>2]|0;
 ;HEAP32[$59>>2]=HEAP32[$2>>2]|0;HEAP32[$59+4>>2]=HEAP32[$2+4>>2]|0;
 ;HEAP8[$53>>0]=HEAP8[$59>>0]|0;HEAP8[$53+1>>0]=HEAP8[$59+1>>0]|0;HEAP8[$53+2>>0]=HEAP8[$59+2>>0]|0;HEAP8[$53+3>>0]=HEAP8[$59+3>>0]|0;HEAP8[$53+4>>0]=HEAP8[$59+4>>0]|0;HEAP8[$53+5>>0]=HEAP8[$59+5>>0]|0;HEAP8[$53+6>>0]=HEAP8[$59+6>>0]|0;HEAP8[$53+7>>0]=HEAP8[$59+7>>0]|0;
 ;HEAP8[$54>>0]=HEAP8[$58>>0]|0;HEAP8[$54+1>>0]=HEAP8[$58+1>>0]|0;HEAP8[$54+2>>0]=HEAP8[$58+2>>0]|0;HEAP8[$54+3>>0]=HEAP8[$58+3>>0]|0;HEAP8[$54+4>>0]=HEAP8[$58+4>>0]|0;HEAP8[$54+5>>0]=HEAP8[$58+5>>0]|0;HEAP8[$54+6>>0]=HEAP8[$58+6>>0]|0;HEAP8[$54+7>>0]=HEAP8[$58+7>>0]|0;
 ;HEAP32[$50>>2]=HEAP32[$54>>2]|0;HEAP32[$50+4>>2]=HEAP32[$54+4>>2]|0;
 ;HEAP32[$51>>2]=HEAP32[$53>>2]|0;HEAP32[$51+4>>2]=HEAP32[$53+4>>2]|0;
 ;HEAP8[$47>>0]=HEAP8[$52>>0]|0;
 ;HEAP8[$48>>0]=HEAP8[$51>>0]|0;HEAP8[$48+1>>0]=HEAP8[$51+1>>0]|0;HEAP8[$48+2>>0]=HEAP8[$51+2>>0]|0;HEAP8[$48+3>>0]=HEAP8[$51+3>>0]|0;HEAP8[$48+4>>0]=HEAP8[$51+4>>0]|0;HEAP8[$48+5>>0]=HEAP8[$51+5>>0]|0;HEAP8[$48+6>>0]=HEAP8[$51+6>>0]|0;HEAP8[$48+7>>0]=HEAP8[$51+7>>0]|0;
 ;HEAP8[$49>>0]=HEAP8[$50>>0]|0;HEAP8[$49+1>>0]=HEAP8[$50+1>>0]|0;HEAP8[$49+2>>0]=HEAP8[$50+2>>0]|0;HEAP8[$49+3>>0]=HEAP8[$50+3>>0]|0;HEAP8[$49+4>>0]=HEAP8[$50+4>>0]|0;HEAP8[$49+5>>0]=HEAP8[$50+5>>0]|0;HEAP8[$49+6>>0]=HEAP8[$50+6>>0]|0;HEAP8[$49+7>>0]=HEAP8[$50+7>>0]|0;
 $45 = $48;
 $46 = $49;
 $64 = $45;
 $65 = $46;
 $42 = $64;
 $43 = $65;
 $66 = $42;
 $67 = $43;
 $40 = $66;
 $41 = $67;
 $68 = $40;
 $69 = ((($68)) + 4|0);
 $70 = HEAP32[$69>>2]|0;
 $71 = $41;
 $72 = ((($71)) + 4|0);
 $73 = HEAP32[$72>>2]|0;
 $74 = ($70|0)==($73|0);
 $75 = $74 ^ 1;
 if ($75) {
  $76 = $45;
  $77 = HEAP32[$76>>2]|0;
  $78 = $46;
  $79 = HEAP32[$78>>2]|0;
  $80 = $77;
  $81 = $79;
  $82 = (($80) - ($81))|0;
  $83 = (($82|0) / 4)&-1;
  $84 = ($83*93)|0;
  $85 = $45;
  $86 = ((($85)) + 4|0);
  $87 = HEAP32[$86>>2]|0;
  $88 = $45;
  $89 = HEAP32[$88>>2]|0;
  $90 = HEAP32[$89>>2]|0;
  $91 = $87;
  $92 = $90;
  $93 = (($91) - ($92))|0;
  $94 = (($93|0) / 44)&-1;
  $95 = (($84) + ($94))|0;
  $96 = $46;
  $97 = ((($96)) + 4|0);
  $98 = HEAP32[$97>>2]|0;
  $99 = $46;
  $100 = HEAP32[$99>>2]|0;
  $101 = HEAP32[$100>>2]|0;
  $102 = $98;
  $103 = $101;
  $104 = (($102) - ($103))|0;
  $105 = (($104|0) / 44)&-1;
  $106 = (($95) - ($105))|0;
  $44 = $106;
 } else {
  $44 = 0;
 }
 $107 = $44;
 $57 = $107;
 $20 = $63;
 $108 = $20;
 $109 = ((($108)) + 20|0);
 $19 = $109;
 $110 = $19;
 $18 = $110;
 $111 = $18;
 $60 = $111;
 $10 = $63;
 $112 = $10;
 $9 = $112;
 $113 = $9;
 $8 = $113;
 $114 = $8;
 $115 = ((($114)) + 8|0);
 $116 = HEAP32[$115>>2]|0;
 $117 = ((($114)) + 4|0);
 $118 = HEAP32[$117>>2]|0;
 $119 = $116;
 $120 = $118;
 $121 = (($119) - ($120))|0;
 $122 = (($121|0) / 4)&-1;
 $123 = ($122|0)==(0);
 if ($123) {
  $144 = 0;
 } else {
  $7 = $113;
  $124 = $7;
  $125 = ((($124)) + 8|0);
  $126 = HEAP32[$125>>2]|0;
  $127 = ((($124)) + 4|0);
  $128 = HEAP32[$127>>2]|0;
  $129 = $126;
  $130 = $128;
  $131 = (($129) - ($130))|0;
  $132 = (($131|0) / 4)&-1;
  $133 = ($132*93)|0;
  $134 = (($133) - 1)|0;
  $144 = $134;
 }
 $135 = ((($112)) + 16|0);
 $136 = HEAP32[$135>>2]|0;
 $6 = $112;
 $137 = $6;
 $138 = ((($137)) + 20|0);
 $5 = $138;
 $139 = $5;
 $4 = $139;
 $140 = $4;
 $141 = HEAP32[$140>>2]|0;
 $142 = (($136) + ($141))|0;
 $143 = (($144) - ($142))|0;
 $61 = $143;
 $145 = $57;
 $146 = $61;
 $147 = ($145>>>0)>($146>>>0);
 if ($147) {
  $148 = $57;
  $149 = $61;
  $150 = (($148) - ($149))|0;
  __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE19__add_back_capacityEj($63,$150);
 }
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE3endEv($62,$63);
 while(1) {
  $13 = $1;
  $14 = $2;
  $151 = $13;
  $152 = $14;
  $11 = $151;
  $12 = $152;
  $153 = $11;
  $154 = ((($153)) + 4|0);
  $155 = HEAP32[$154>>2]|0;
  $156 = $12;
  $157 = ((($156)) + 4|0);
  $158 = HEAP32[$157>>2]|0;
  $159 = ($155|0)==($158|0);
  $160 = $159 ^ 1;
  if (!($160)) {
   break;
  }
  $161 = $60;
  $15 = $62;
  $162 = $15;
  $163 = ((($162)) + 4|0);
  $164 = HEAP32[$163>>2]|0;
  $16 = $164;
  $165 = $16;
  $17 = $1;
  $166 = $17;
  $167 = ((($166)) + 4|0);
  $168 = HEAP32[$167>>2]|0;
  $31 = $161;
  $32 = $165;
  $33 = $168;
  $169 = $31;
  $170 = $32;
  $171 = $33;
  $30 = $171;
  $172 = $30;
  ;HEAP8[$29>>0]=HEAP8[$34>>0]|0;
  $26 = $169;
  $27 = $170;
  $28 = $172;
  $173 = $26;
  $174 = $27;
  $175 = $28;
  $25 = $175;
  $176 = $25;
  $22 = $173;
  $23 = $174;
  $24 = $176;
  $177 = $23;
  $178 = $24;
  $21 = $178;
  $179 = $21;
  __ZN6laszip6models10arithmeticC2ERKS1_($177,$179);
  $35 = $62;
  $180 = $35;
  $181 = ((($180)) + 4|0);
  $182 = HEAP32[$181>>2]|0;
  $183 = ((($182)) + 44|0);
  HEAP32[$181>>2] = $183;
  $184 = HEAP32[$180>>2]|0;
  $185 = HEAP32[$184>>2]|0;
  $186 = $183;
  $187 = $185;
  $188 = (($186) - ($187))|0;
  $189 = (($188|0) / 44)&-1;
  $190 = ($189|0)==(93);
  if ($190) {
   $191 = HEAP32[$180>>2]|0;
   $192 = ((($191)) + 4|0);
   HEAP32[$180>>2] = $192;
   $193 = HEAP32[$180>>2]|0;
   $194 = HEAP32[$193>>2]|0;
   $195 = ((($180)) + 4|0);
   HEAP32[$195>>2] = $194;
  }
  $36 = $1;
  $196 = $36;
  $197 = ((($196)) + 4|0);
  $198 = HEAP32[$197>>2]|0;
  $199 = ((($198)) + 44|0);
  HEAP32[$197>>2] = $199;
  $200 = HEAP32[$196>>2]|0;
  $201 = HEAP32[$200>>2]|0;
  $202 = $199;
  $203 = $201;
  $204 = (($202) - ($203))|0;
  $205 = (($204|0) / 44)&-1;
  $206 = ($205|0)==(93);
  if ($206) {
   $207 = HEAP32[$196>>2]|0;
   $208 = ((($207)) + 4|0);
   HEAP32[$196>>2] = $208;
   $209 = HEAP32[$196>>2]|0;
   $210 = HEAP32[$209>>2]|0;
   $211 = ((($196)) + 4|0);
   HEAP32[$211>>2] = $210;
  }
  $39 = $63;
  $212 = $39;
  $213 = ((($212)) + 20|0);
  $38 = $213;
  $214 = $38;
  $37 = $214;
  $215 = $37;
  $216 = HEAP32[$215>>2]|0;
  $217 = (($216) + 1)|0;
  HEAP32[$215>>2] = $217;
 }
 STACKTOP = sp;return;
}
function __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $13 = $0;
 $16 = $13;
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5clearEv($16);
 $12 = $16;
 $17 = $12;
 $18 = ((($17)) + 4|0);
 $19 = HEAP32[$18>>2]|0;
 $14 = $19;
 $11 = $16;
 $20 = $11;
 $21 = ((($20)) + 8|0);
 $22 = HEAP32[$21>>2]|0;
 $15 = $22;
 while(1) {
  $23 = $14;
  $24 = $15;
  $25 = ($23|0)!=($24|0);
  if (!($25)) {
   break;
  }
  $10 = $16;
  $26 = $10;
  $27 = ((($26)) + 20|0);
  $9 = $27;
  $28 = $9;
  $8 = $28;
  $29 = $8;
  $30 = $14;
  $31 = HEAP32[$30>>2]|0;
  $5 = $29;
  $6 = $31;
  $7 = 93;
  $32 = $5;
  $33 = $6;
  $34 = $7;
  $2 = $32;
  $3 = $33;
  $4 = $34;
  $35 = $3;
  $1 = $35;
  $36 = $1;
  __ZdlPv($36);
  $37 = $14;
  $38 = ((($37)) + 4|0);
  $14 = $38;
 }
 __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticENS_9allocatorIS4_EEED2Ev($16);
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticENS_9allocatorIS4_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $9 = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $24 = $48;
  $49 = $24;
  $50 = ((($41)) + 8|0);
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($51)) + -4|0);
  HEAP32[$50>>2] = $52;
  $23 = $52;
  $53 = $23;
  $20 = $49;
  $21 = $53;
  $54 = $20;
  $55 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $54;
  $18 = $55;
  $56 = $17;
  $57 = $18;
  $15 = $56;
  $16 = $57;
 }
 $58 = HEAP32[$35>>2]|0;
 $59 = ($58|0)!=(0|0);
 if (!($59)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $60 = $14;
 $61 = ((($60)) + 12|0);
 $13 = $61;
 $62 = $13;
 $12 = $62;
 $63 = $12;
 $64 = HEAP32[$35>>2]|0;
 $4 = $35;
 $65 = $4;
 $3 = $65;
 $66 = $3;
 $67 = ((($66)) + 12|0);
 $2 = $67;
 $68 = $2;
 $1 = $68;
 $69 = $1;
 $70 = HEAP32[$69>>2]|0;
 $71 = HEAP32[$65>>2]|0;
 $72 = $70;
 $73 = $71;
 $74 = (($72) - ($73))|0;
 $75 = (($74|0) / 4)&-1;
 $9 = $63;
 $10 = $64;
 $11 = $75;
 $76 = $9;
 $77 = $10;
 $78 = $11;
 $6 = $76;
 $7 = $77;
 $8 = $78;
 $79 = $7;
 $5 = $79;
 $80 = $5;
 __ZdlPv($80);
 STACKTOP = sp;return;
}
function __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE19__add_back_capacityEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $$byval_copy2 = 0, $$byval_copy3 = 0, $$byval_copy4 = 0, $$byval_copy5 = 0, $10 = 0, $100 = 0, $1000 = 0, $1001 = 0, $1002 = 0, $1003 = 0, $1004 = 0, $1005 = 0, $1006 = 0, $1007 = 0, $1008 = 0, $1009 = 0, $101 = 0, $1010 = 0;
 var $1011 = 0, $1012 = 0, $1013 = 0, $1014 = 0, $1015 = 0, $1016 = 0, $1017 = 0, $1018 = 0, $1019 = 0, $102 = 0, $1020 = 0, $1021 = 0, $1022 = 0, $1023 = 0, $1024 = 0, $1025 = 0, $1026 = 0, $1027 = 0, $1028 = 0, $1029 = 0;
 var $103 = 0, $1030 = 0, $1031 = 0, $1032 = 0, $1033 = 0, $1034 = 0, $1035 = 0, $1036 = 0, $1037 = 0, $1038 = 0, $1039 = 0, $104 = 0, $1040 = 0, $1041 = 0, $1042 = 0, $1043 = 0, $1044 = 0, $1045 = 0, $1046 = 0, $1047 = 0;
 var $1048 = 0, $1049 = 0, $105 = 0, $1050 = 0, $1051 = 0, $1052 = 0, $1053 = 0, $1054 = 0, $1055 = 0, $1056 = 0, $1057 = 0, $1058 = 0, $1059 = 0, $106 = 0, $1060 = 0, $1061 = 0, $1062 = 0, $1063 = 0, $1064 = 0, $1065 = 0;
 var $1066 = 0, $1067 = 0, $1068 = 0, $1069 = 0, $107 = 0, $1070 = 0, $1071 = 0, $1072 = 0, $1073 = 0, $1074 = 0, $1075 = 0, $1076 = 0, $1077 = 0, $1078 = 0, $1079 = 0, $108 = 0, $1080 = 0, $1081 = 0, $1082 = 0, $1083 = 0;
 var $1084 = 0, $1085 = 0, $1086 = 0, $1087 = 0, $1088 = 0, $1089 = 0, $109 = 0, $1090 = 0, $1091 = 0, $1092 = 0, $1093 = 0, $1094 = 0, $1095 = 0, $1096 = 0, $1097 = 0, $1098 = 0, $1099 = 0, $11 = 0, $110 = 0, $1100 = 0;
 var $1101 = 0, $1102 = 0, $1103 = 0, $1104 = 0, $1105 = 0, $1106 = 0, $1107 = 0, $1108 = 0, $1109 = 0, $111 = 0, $1110 = 0, $1111 = 0, $1112 = 0, $1113 = 0, $1114 = 0, $1115 = 0, $1116 = 0, $1117 = 0, $1118 = 0, $1119 = 0;
 var $112 = 0, $1120 = 0, $1121 = 0, $1122 = 0, $1123 = 0, $1124 = 0, $1125 = 0, $1126 = 0, $1127 = 0, $1128 = 0, $1129 = 0, $113 = 0, $1130 = 0, $1131 = 0, $1132 = 0, $1133 = 0, $1134 = 0, $1135 = 0, $1136 = 0, $1137 = 0;
 var $1138 = 0, $1139 = 0, $114 = 0, $1140 = 0, $1141 = 0, $1142 = 0, $1143 = 0, $1144 = 0, $1145 = 0, $1146 = 0, $1147 = 0, $1148 = 0, $1149 = 0, $115 = 0, $1150 = 0, $1151 = 0, $1152 = 0, $1153 = 0, $1154 = 0, $1155 = 0;
 var $1156 = 0, $1157 = 0, $1158 = 0, $1159 = 0, $116 = 0, $1160 = 0, $1161 = 0, $1162 = 0, $1163 = 0, $1164 = 0, $1165 = 0, $1166 = 0, $1167 = 0, $1168 = 0, $1169 = 0, $117 = 0, $1170 = 0, $1171 = 0, $1172 = 0, $1173 = 0;
 var $1174 = 0, $1175 = 0, $1176 = 0, $1177 = 0, $1178 = 0, $1179 = 0, $118 = 0, $1180 = 0, $1181 = 0, $1182 = 0, $1183 = 0, $1184 = 0, $1185 = 0, $1186 = 0, $1187 = 0, $1188 = 0, $1189 = 0, $119 = 0, $1190 = 0, $1191 = 0;
 var $1192 = 0, $1193 = 0, $1194 = 0, $1195 = 0, $1196 = 0, $1197 = 0, $1198 = 0, $1199 = 0, $12 = 0, $120 = 0, $1200 = 0, $1201 = 0, $1202 = 0, $1203 = 0, $1204 = 0, $1205 = 0, $1206 = 0, $1207 = 0, $1208 = 0, $1209 = 0;
 var $121 = 0, $1210 = 0, $1211 = 0, $1212 = 0, $1213 = 0, $1214 = 0, $1215 = 0, $1216 = 0, $1217 = 0, $1218 = 0, $1219 = 0, $122 = 0, $1220 = 0, $1221 = 0, $1222 = 0, $1223 = 0, $1224 = 0, $1225 = 0, $1226 = 0, $1227 = 0;
 var $1228 = 0, $1229 = 0, $123 = 0, $1230 = 0, $1231 = 0, $1232 = 0, $1233 = 0, $1234 = 0, $1235 = 0, $1236 = 0, $1237 = 0, $1238 = 0, $1239 = 0, $124 = 0, $1240 = 0, $1241 = 0, $1242 = 0, $1243 = 0, $1244 = 0, $1245 = 0;
 var $1246 = 0, $1247 = 0, $1248 = 0, $1249 = 0, $125 = 0, $1250 = 0, $1251 = 0, $1252 = 0, $1253 = 0, $1254 = 0, $1255 = 0, $1256 = 0, $1257 = 0, $1258 = 0, $1259 = 0, $126 = 0, $1260 = 0, $1261 = 0, $1262 = 0, $1263 = 0;
 var $1264 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0;
 var $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0;
 var $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0;
 var $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0;
 var $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0, $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0;
 var $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0, $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0;
 var $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0, $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0;
 var $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0, $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0;
 var $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $277 = 0, $278 = 0, $279 = 0, $28 = 0, $280 = 0, $281 = 0, $282 = 0, $283 = 0, $284 = 0, $285 = 0, $286 = 0, $287 = 0, $288 = 0;
 var $289 = 0, $29 = 0, $290 = 0, $291 = 0, $292 = 0, $293 = 0, $294 = 0, $295 = 0, $296 = 0, $297 = 0, $298 = 0, $299 = 0, $3 = 0, $30 = 0, $300 = 0, $301 = 0, $302 = 0, $303 = 0, $304 = 0, $305 = 0;
 var $306 = 0, $307 = 0, $308 = 0, $309 = 0, $31 = 0, $310 = 0, $311 = 0, $312 = 0, $313 = 0, $314 = 0, $315 = 0, $316 = 0, $317 = 0, $318 = 0, $319 = 0, $32 = 0, $320 = 0, $321 = 0, $322 = 0, $323 = 0;
 var $324 = 0, $325 = 0, $326 = 0, $327 = 0, $328 = 0, $329 = 0, $33 = 0, $330 = 0, $331 = 0, $332 = 0, $333 = 0, $334 = 0, $335 = 0, $336 = 0, $337 = 0, $338 = 0, $339 = 0, $34 = 0, $340 = 0, $341 = 0;
 var $342 = 0, $343 = 0, $344 = 0, $345 = 0, $346 = 0, $347 = 0, $348 = 0, $349 = 0, $35 = 0, $350 = 0, $351 = 0, $352 = 0, $353 = 0, $354 = 0, $355 = 0, $356 = 0, $357 = 0, $358 = 0, $359 = 0, $36 = 0;
 var $360 = 0, $361 = 0, $362 = 0, $363 = 0, $364 = 0, $365 = 0, $366 = 0, $367 = 0, $368 = 0, $369 = 0, $37 = 0, $370 = 0, $371 = 0, $372 = 0, $373 = 0, $374 = 0, $375 = 0, $376 = 0, $377 = 0, $378 = 0;
 var $379 = 0, $38 = 0, $380 = 0, $381 = 0, $382 = 0, $383 = 0, $384 = 0, $385 = 0, $386 = 0, $387 = 0, $388 = 0, $389 = 0, $39 = 0, $390 = 0, $391 = 0, $392 = 0, $393 = 0, $394 = 0, $395 = 0, $396 = 0;
 var $397 = 0, $398 = 0, $399 = 0, $4 = 0, $40 = 0, $400 = 0, $401 = 0, $402 = 0, $403 = 0, $404 = 0, $405 = 0, $406 = 0, $407 = 0, $408 = 0, $409 = 0, $41 = 0, $410 = 0, $411 = 0, $412 = 0, $413 = 0;
 var $414 = 0, $415 = 0, $416 = 0, $417 = 0, $418 = 0, $419 = 0, $42 = 0, $420 = 0, $421 = 0, $422 = 0, $423 = 0, $424 = 0, $425 = 0, $426 = 0, $427 = 0, $428 = 0, $429 = 0, $43 = 0, $430 = 0, $431 = 0;
 var $432 = 0, $433 = 0, $434 = 0, $435 = 0, $436 = 0, $437 = 0, $438 = 0, $439 = 0, $44 = 0, $440 = 0, $441 = 0, $442 = 0, $443 = 0, $444 = 0, $445 = 0, $446 = 0, $447 = 0, $448 = 0, $449 = 0, $45 = 0;
 var $450 = 0, $451 = 0, $452 = 0, $453 = 0, $454 = 0, $455 = 0, $456 = 0, $457 = 0, $458 = 0, $459 = 0, $46 = 0, $460 = 0, $461 = 0, $462 = 0, $463 = 0, $464 = 0, $465 = 0, $466 = 0, $467 = 0, $468 = 0;
 var $469 = 0, $47 = 0, $470 = 0, $471 = 0, $472 = 0, $473 = 0, $474 = 0, $475 = 0, $476 = 0, $477 = 0, $478 = 0, $479 = 0, $48 = 0, $480 = 0, $481 = 0, $482 = 0, $483 = 0, $484 = 0, $485 = 0, $486 = 0;
 var $487 = 0, $488 = 0, $489 = 0, $49 = 0, $490 = 0, $491 = 0, $492 = 0, $493 = 0, $494 = 0, $495 = 0, $496 = 0, $497 = 0, $498 = 0, $499 = 0, $5 = 0, $50 = 0, $500 = 0, $501 = 0, $502 = 0, $503 = 0;
 var $504 = 0, $505 = 0, $506 = 0, $507 = 0, $508 = 0, $509 = 0, $51 = 0, $510 = 0, $511 = 0, $512 = 0, $513 = 0, $514 = 0, $515 = 0, $516 = 0, $517 = 0, $518 = 0, $519 = 0, $52 = 0, $520 = 0, $521 = 0;
 var $522 = 0, $523 = 0, $524 = 0, $525 = 0, $526 = 0, $527 = 0, $528 = 0, $529 = 0, $53 = 0, $530 = 0, $531 = 0, $532 = 0, $533 = 0, $534 = 0, $535 = 0, $536 = 0, $537 = 0, $538 = 0, $539 = 0, $54 = 0;
 var $540 = 0, $541 = 0, $542 = 0, $543 = 0, $544 = 0, $545 = 0, $546 = 0, $547 = 0, $548 = 0, $549 = 0, $55 = 0, $550 = 0, $551 = 0, $552 = 0, $553 = 0, $554 = 0, $555 = 0, $556 = 0, $557 = 0, $558 = 0;
 var $559 = 0, $56 = 0, $560 = 0, $561 = 0, $562 = 0, $563 = 0, $564 = 0, $565 = 0, $566 = 0, $567 = 0, $568 = 0, $569 = 0, $57 = 0, $570 = 0, $571 = 0, $572 = 0, $573 = 0, $574 = 0, $575 = 0, $576 = 0;
 var $577 = 0, $578 = 0, $579 = 0, $58 = 0, $580 = 0, $581 = 0, $582 = 0, $583 = 0, $584 = 0, $585 = 0, $586 = 0, $587 = 0, $588 = 0, $589 = 0, $59 = 0, $590 = 0, $591 = 0, $592 = 0, $593 = 0, $594 = 0;
 var $595 = 0, $596 = 0, $597 = 0, $598 = 0, $599 = 0, $6 = 0, $60 = 0, $600 = 0, $601 = 0, $602 = 0, $603 = 0, $604 = 0, $605 = 0, $606 = 0, $607 = 0, $608 = 0, $609 = 0, $61 = 0, $610 = 0, $611 = 0;
 var $612 = 0, $613 = 0, $614 = 0, $615 = 0, $616 = 0, $617 = 0, $618 = 0, $619 = 0, $62 = 0, $620 = 0, $621 = 0, $622 = 0, $623 = 0, $624 = 0, $625 = 0, $626 = 0, $627 = 0, $628 = 0, $629 = 0, $63 = 0;
 var $630 = 0, $631 = 0, $632 = 0, $633 = 0, $634 = 0, $635 = 0, $636 = 0, $637 = 0, $638 = 0, $639 = 0, $64 = 0, $640 = 0, $641 = 0, $642 = 0, $643 = 0, $644 = 0, $645 = 0, $646 = 0, $647 = 0, $648 = 0;
 var $649 = 0, $65 = 0, $650 = 0, $651 = 0, $652 = 0, $653 = 0, $654 = 0, $655 = 0, $656 = 0, $657 = 0, $658 = 0, $659 = 0, $66 = 0, $660 = 0, $661 = 0, $662 = 0, $663 = 0, $664 = 0, $665 = 0, $666 = 0;
 var $667 = 0, $668 = 0, $669 = 0, $67 = 0, $670 = 0, $671 = 0, $672 = 0, $673 = 0, $674 = 0, $675 = 0, $676 = 0, $677 = 0, $678 = 0, $679 = 0, $68 = 0, $680 = 0, $681 = 0, $682 = 0, $683 = 0, $684 = 0;
 var $685 = 0, $686 = 0, $687 = 0, $688 = 0, $689 = 0, $69 = 0, $690 = 0, $691 = 0, $692 = 0, $693 = 0, $694 = 0, $695 = 0, $696 = 0, $697 = 0, $698 = 0, $699 = 0, $7 = 0, $70 = 0, $700 = 0, $701 = 0;
 var $702 = 0, $703 = 0, $704 = 0, $705 = 0, $706 = 0, $707 = 0, $708 = 0, $709 = 0, $71 = 0, $710 = 0, $711 = 0, $712 = 0, $713 = 0, $714 = 0, $715 = 0, $716 = 0, $717 = 0, $718 = 0, $719 = 0, $72 = 0;
 var $720 = 0, $721 = 0, $722 = 0, $723 = 0, $724 = 0, $725 = 0, $726 = 0, $727 = 0, $728 = 0, $729 = 0, $73 = 0, $730 = 0, $731 = 0, $732 = 0, $733 = 0, $734 = 0, $735 = 0, $736 = 0, $737 = 0, $738 = 0;
 var $739 = 0, $74 = 0, $740 = 0, $741 = 0, $742 = 0, $743 = 0, $744 = 0, $745 = 0, $746 = 0, $747 = 0, $748 = 0, $749 = 0, $75 = 0, $750 = 0, $751 = 0, $752 = 0, $753 = 0, $754 = 0, $755 = 0, $756 = 0;
 var $757 = 0, $758 = 0, $759 = 0, $76 = 0, $760 = 0, $761 = 0, $762 = 0, $763 = 0, $764 = 0, $765 = 0, $766 = 0, $767 = 0, $768 = 0, $769 = 0, $77 = 0, $770 = 0, $771 = 0, $772 = 0, $773 = 0, $774 = 0;
 var $775 = 0, $776 = 0, $777 = 0, $778 = 0, $779 = 0, $78 = 0, $780 = 0, $781 = 0, $782 = 0, $783 = 0, $784 = 0, $785 = 0, $786 = 0, $787 = 0, $788 = 0, $789 = 0, $79 = 0, $790 = 0, $791 = 0, $792 = 0;
 var $793 = 0, $794 = 0, $795 = 0, $796 = 0, $797 = 0, $798 = 0, $799 = 0, $8 = 0, $80 = 0, $800 = 0, $801 = 0, $802 = 0, $803 = 0, $804 = 0, $805 = 0, $806 = 0, $807 = 0, $808 = 0, $809 = 0, $81 = 0;
 var $810 = 0, $811 = 0, $812 = 0, $813 = 0, $814 = 0, $815 = 0, $816 = 0, $817 = 0, $818 = 0, $819 = 0, $82 = 0, $820 = 0, $821 = 0, $822 = 0, $823 = 0, $824 = 0, $825 = 0, $826 = 0, $827 = 0, $828 = 0;
 var $829 = 0, $83 = 0, $830 = 0, $831 = 0, $832 = 0, $833 = 0, $834 = 0, $835 = 0, $836 = 0, $837 = 0, $838 = 0, $839 = 0, $84 = 0, $840 = 0, $841 = 0, $842 = 0, $843 = 0, $844 = 0, $845 = 0, $846 = 0;
 var $847 = 0, $848 = 0, $849 = 0, $85 = 0, $850 = 0, $851 = 0, $852 = 0, $853 = 0, $854 = 0, $855 = 0, $856 = 0, $857 = 0, $858 = 0, $859 = 0, $86 = 0, $860 = 0, $861 = 0, $862 = 0, $863 = 0, $864 = 0;
 var $865 = 0, $866 = 0, $867 = 0, $868 = 0, $869 = 0, $87 = 0, $870 = 0, $871 = 0, $872 = 0, $873 = 0, $874 = 0, $875 = 0, $876 = 0, $877 = 0, $878 = 0, $879 = 0, $88 = 0, $880 = 0, $881 = 0, $882 = 0;
 var $883 = 0, $884 = 0, $885 = 0, $886 = 0, $887 = 0, $888 = 0, $889 = 0, $89 = 0, $890 = 0, $891 = 0, $892 = 0, $893 = 0, $894 = 0, $895 = 0, $896 = 0, $897 = 0, $898 = 0, $899 = 0, $9 = 0, $90 = 0;
 var $900 = 0, $901 = 0, $902 = 0, $903 = 0, $904 = 0, $905 = 0, $906 = 0, $907 = 0, $908 = 0, $909 = 0, $91 = 0, $910 = 0, $911 = 0, $912 = 0, $913 = 0, $914 = 0, $915 = 0, $916 = 0, $917 = 0, $918 = 0;
 var $919 = 0, $92 = 0, $920 = 0, $921 = 0, $922 = 0, $923 = 0, $924 = 0, $925 = 0, $926 = 0, $927 = 0, $928 = 0, $929 = 0, $93 = 0, $930 = 0, $931 = 0, $932 = 0, $933 = 0, $934 = 0, $935 = 0, $936 = 0;
 var $937 = 0, $938 = 0, $939 = 0, $94 = 0, $940 = 0, $941 = 0, $942 = 0, $943 = 0, $944 = 0, $945 = 0, $946 = 0, $947 = 0, $948 = 0, $949 = 0, $95 = 0, $950 = 0, $951 = 0, $952 = 0, $953 = 0, $954 = 0;
 var $955 = 0, $956 = 0, $957 = 0, $958 = 0, $959 = 0, $96 = 0, $960 = 0, $961 = 0, $962 = 0, $963 = 0, $964 = 0, $965 = 0, $966 = 0, $967 = 0, $968 = 0, $969 = 0, $97 = 0, $970 = 0, $971 = 0, $972 = 0;
 var $973 = 0, $974 = 0, $975 = 0, $976 = 0, $977 = 0, $978 = 0, $979 = 0, $98 = 0, $980 = 0, $981 = 0, $982 = 0, $983 = 0, $984 = 0, $985 = 0, $986 = 0, $987 = 0, $988 = 0, $989 = 0, $99 = 0, $990 = 0;
 var $991 = 0, $992 = 0, $993 = 0, $994 = 0, $995 = 0, $996 = 0, $997 = 0, $998 = 0, $999 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 1744|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(1744|0);
 $$byval_copy5 = sp + 1724|0;
 $$byval_copy4 = sp + 1720|0;
 $$byval_copy3 = sp + 1716|0;
 $$byval_copy2 = sp + 1712|0;
 $$byval_copy1 = sp + 1708|0;
 $$byval_copy = sp + 1704|0;
 $22 = sp + 80|0;
 $25 = sp + 1738|0;
 $43 = sp + 72|0;
 $46 = sp + 1737|0;
 $52 = sp + 1516|0;
 $58 = sp + 1492|0;
 $64 = sp + 1468|0;
 $76 = sp + 1420|0;
 $102 = sp + 64|0;
 $107 = sp + 1736|0;
 $115 = sp + 1272|0;
 $116 = sp + 1268|0;
 $117 = sp + 1248|0;
 $118 = sp + 1244|0;
 $119 = sp + 1240|0;
 $122 = sp + 56|0;
 $125 = sp + 1735|0;
 $170 = sp + 48|0;
 $173 = sp + 1734|0;
 $179 = sp + 1016|0;
 $185 = sp + 992|0;
 $191 = sp + 968|0;
 $203 = sp + 920|0;
 $229 = sp + 40|0;
 $234 = sp + 1733|0;
 $242 = sp + 772|0;
 $243 = sp + 768|0;
 $244 = sp + 748|0;
 $245 = sp + 744|0;
 $246 = sp + 740|0;
 $249 = sp + 32|0;
 $252 = sp + 1732|0;
 $267 = sp + 24|0;
 $270 = sp + 1731|0;
 $276 = sp + 636|0;
 $282 = sp + 612|0;
 $288 = sp + 588|0;
 $300 = sp + 540|0;
 $326 = sp + 16|0;
 $331 = sp + 1730|0;
 $339 = sp + 392|0;
 $340 = sp + 388|0;
 $341 = sp + 368|0;
 $342 = sp + 364|0;
 $343 = sp + 360|0;
 $346 = sp + 8|0;
 $349 = sp + 1729|0;
 $358 = sp;
 $361 = sp + 1728|0;
 $367 = sp + 280|0;
 $373 = sp + 256|0;
 $379 = sp + 232|0;
 $391 = sp + 184|0;
 $401 = sp + 144|0;
 $402 = sp + 140|0;
 $403 = sp + 136|0;
 $404 = sp + 132|0;
 $405 = sp + 128|0;
 $406 = sp + 124|0;
 $408 = sp + 100|0;
 $409 = sp + 96|0;
 $410 = sp + 92|0;
 $411 = sp + 88|0;
 $398 = $0;
 $399 = $1;
 $413 = $398;
 $397 = $413;
 $414 = $397;
 $415 = ((($414)) + 20|0);
 $396 = $415;
 $416 = $396;
 $395 = $416;
 $417 = $395;
 $400 = $417;
 $418 = $399;
 $394 = $413;
 $419 = $394;
 $420 = ((($419)) + 8|0);
 $421 = HEAP32[$420>>2]|0;
 $422 = ((($419)) + 4|0);
 $423 = HEAP32[$422>>2]|0;
 $424 = ($421|0)==($423|0);
 $425 = $424&1;
 $426 = (($418) + ($425))|0;
 $393 = $426;
 $427 = $393;
 $428 = (($427>>>0) / 93)&-1;
 $429 = $393;
 $430 = (($429>>>0) % 93)&-1;
 $431 = ($430|0)!=(0);
 $432 = $431&1;
 $433 = (($428) + ($432))|0;
 HEAP32[$401>>2] = $433;
 $392 = $413;
 $434 = $392;
 $435 = ((($434)) + 16|0);
 $436 = HEAP32[$435>>2]|0;
 $437 = (($436>>>0) / 93)&-1;
 HEAP32[$402>>2] = $437;
 $359 = $402;
 $360 = $401;
 $438 = $359;
 $439 = $360;
 ;HEAP8[$358>>0]=HEAP8[$361>>0]|0;
 $356 = $438;
 $357 = $439;
 $440 = $357;
 $441 = $356;
 $353 = $358;
 $354 = $440;
 $355 = $441;
 $442 = $354;
 $443 = HEAP32[$442>>2]|0;
 $444 = $355;
 $445 = HEAP32[$444>>2]|0;
 $446 = ($443>>>0)<($445>>>0);
 $447 = $357;
 $448 = $356;
 $449 = $446 ? $447 : $448;
 $450 = HEAP32[$449>>2]|0;
 HEAP32[$402>>2] = $450;
 $451 = HEAP32[$402>>2]|0;
 $452 = HEAP32[$401>>2]|0;
 $453 = (($452) - ($451))|0;
 HEAP32[$401>>2] = $453;
 $454 = HEAP32[$401>>2]|0;
 $455 = ($454|0)==(0);
 if ($455) {
  $456 = HEAP32[$402>>2]|0;
  $457 = ($456*93)|0;
  $458 = ((($413)) + 16|0);
  $459 = HEAP32[$458>>2]|0;
  $460 = (($459) - ($457))|0;
  HEAP32[$458>>2] = $460;
  while(1) {
   $461 = HEAP32[$402>>2]|0;
   $462 = ($461>>>0)>(0);
   if (!($462)) {
    break;
   }
   $254 = $413;
   $463 = $254;
   $464 = ((($463)) + 4|0);
   $465 = HEAP32[$464>>2]|0;
   $466 = HEAP32[$465>>2]|0;
   HEAP32[$403>>2] = $466;
   $253 = $413;
   $467 = $253;
   $468 = ((($467)) + 4|0);
   $469 = HEAP32[$468>>2]|0;
   $470 = ((($469)) + 4|0);
   $250 = $467;
   $251 = $470;
   $471 = $250;
   $472 = $251;
   ;HEAP8[$249>>0]=HEAP8[$252>>0]|0;
   $247 = $471;
   $248 = $472;
   $473 = $247;
   $474 = $248;
   $475 = ((($473)) + 4|0);
   HEAP32[$475>>2] = $474;
   $238 = $413;
   $239 = $403;
   $476 = $238;
   $477 = ((($476)) + 8|0);
   $478 = HEAP32[$477>>2]|0;
   $237 = $476;
   $479 = $237;
   $480 = ((($479)) + 12|0);
   $236 = $480;
   $481 = $236;
   $235 = $481;
   $482 = $235;
   $483 = HEAP32[$482>>2]|0;
   $484 = ($478|0)==($483|0);
   do {
    if ($484) {
     $485 = ((($476)) + 4|0);
     $486 = HEAP32[$485>>2]|0;
     $487 = HEAP32[$476>>2]|0;
     $488 = ($486>>>0)>($487>>>0);
     if (!($488)) {
      $206 = $476;
      $535 = $206;
      $536 = ((($535)) + 12|0);
      $205 = $536;
      $537 = $205;
      $204 = $537;
      $538 = $204;
      $539 = HEAP32[$538>>2]|0;
      $540 = HEAP32[$476>>2]|0;
      $541 = $539;
      $542 = $540;
      $543 = (($541) - ($542))|0;
      $544 = (($543|0) / 4)&-1;
      $545 = $544<<1;
      HEAP32[$242>>2] = $545;
      HEAP32[$243>>2] = 1;
      $171 = $242;
      $172 = $243;
      $546 = $171;
      $547 = $172;
      ;HEAP8[$170>>0]=HEAP8[$173>>0]|0;
      $168 = $546;
      $169 = $547;
      $548 = $168;
      $549 = $169;
      $165 = $170;
      $166 = $548;
      $167 = $549;
      $550 = $166;
      $551 = HEAP32[$550>>2]|0;
      $552 = $167;
      $553 = HEAP32[$552>>2]|0;
      $554 = ($551>>>0)<($553>>>0);
      $555 = $169;
      $556 = $168;
      $557 = $554 ? $555 : $556;
      $558 = HEAP32[$557>>2]|0;
      $241 = $558;
      $559 = $241;
      $560 = $241;
      $561 = (($560>>>0) / 4)&-1;
      $160 = $476;
      $562 = $160;
      $563 = ((($562)) + 12|0);
      $159 = $563;
      $564 = $159;
      $158 = $564;
      $565 = $158;
      __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($244,$559,$561,$565);
      $566 = ((($476)) + 4|0);
      $567 = HEAP32[$566>>2]|0;
      $161 = $245;
      $162 = $567;
      $568 = $161;
      $569 = $162;
      HEAP32[$568>>2] = $569;
      $570 = ((($476)) + 8|0);
      $571 = HEAP32[$570>>2]|0;
      $163 = $246;
      $164 = $571;
      $572 = $163;
      $573 = $164;
      HEAP32[$572>>2] = $573;
      ;HEAP32[$$byval_copy>>2]=HEAP32[$245>>2]|0;
      ;HEAP32[$$byval_copy1>>2]=HEAP32[$246>>2]|0;
      __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($244,$$byval_copy,$$byval_copy1);
      $177 = $476;
      $178 = $244;
      $574 = $177;
      $176 = $574;
      $575 = $176;
      $576 = HEAP32[$575>>2]|0;
      HEAP32[$179>>2] = $576;
      $577 = $178;
      $174 = $577;
      $578 = $174;
      $579 = HEAP32[$578>>2]|0;
      $580 = $177;
      HEAP32[$580>>2] = $579;
      $175 = $179;
      $581 = $175;
      $582 = HEAP32[$581>>2]|0;
      $583 = $178;
      HEAP32[$583>>2] = $582;
      $584 = ((($476)) + 4|0);
      $585 = ((($244)) + 4|0);
      $183 = $584;
      $184 = $585;
      $586 = $183;
      $182 = $586;
      $587 = $182;
      $588 = HEAP32[$587>>2]|0;
      HEAP32[$185>>2] = $588;
      $589 = $184;
      $180 = $589;
      $590 = $180;
      $591 = HEAP32[$590>>2]|0;
      $592 = $183;
      HEAP32[$592>>2] = $591;
      $181 = $185;
      $593 = $181;
      $594 = HEAP32[$593>>2]|0;
      $595 = $184;
      HEAP32[$595>>2] = $594;
      $596 = ((($476)) + 8|0);
      $597 = ((($244)) + 8|0);
      $189 = $596;
      $190 = $597;
      $598 = $189;
      $188 = $598;
      $599 = $188;
      $600 = HEAP32[$599>>2]|0;
      HEAP32[$191>>2] = $600;
      $601 = $190;
      $186 = $601;
      $602 = $186;
      $603 = HEAP32[$602>>2]|0;
      $604 = $189;
      HEAP32[$604>>2] = $603;
      $187 = $191;
      $605 = $187;
      $606 = HEAP32[$605>>2]|0;
      $607 = $190;
      HEAP32[$607>>2] = $606;
      $194 = $476;
      $608 = $194;
      $609 = ((($608)) + 12|0);
      $193 = $609;
      $610 = $193;
      $192 = $610;
      $611 = $192;
      $197 = $244;
      $612 = $197;
      $613 = ((($612)) + 12|0);
      $196 = $613;
      $614 = $196;
      $195 = $614;
      $615 = $195;
      $201 = $611;
      $202 = $615;
      $616 = $201;
      $200 = $616;
      $617 = $200;
      $618 = HEAP32[$617>>2]|0;
      HEAP32[$203>>2] = $618;
      $619 = $202;
      $198 = $619;
      $620 = $198;
      $621 = HEAP32[$620>>2]|0;
      $622 = $201;
      HEAP32[$622>>2] = $621;
      $199 = $203;
      $623 = $199;
      $624 = HEAP32[$623>>2]|0;
      $625 = $202;
      HEAP32[$625>>2] = $624;
      __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($244);
      break;
     }
     $489 = ((($476)) + 4|0);
     $490 = HEAP32[$489>>2]|0;
     $491 = HEAP32[$476>>2]|0;
     $492 = $490;
     $493 = $491;
     $494 = (($492) - ($493))|0;
     $495 = (($494|0) / 4)&-1;
     $240 = $495;
     $496 = $240;
     $497 = (($496) + 1)|0;
     $498 = (($497|0) / 2)&-1;
     $240 = $498;
     $499 = ((($476)) + 4|0);
     $500 = HEAP32[$499>>2]|0;
     $501 = ((($476)) + 8|0);
     $502 = HEAP32[$501>>2]|0;
     $503 = ((($476)) + 4|0);
     $504 = HEAP32[$503>>2]|0;
     $505 = $240;
     $506 = (0 - ($505))|0;
     $507 = (($504) + ($506<<2)|0);
     $214 = $500;
     $215 = $502;
     $216 = $507;
     $508 = $214;
     $213 = $508;
     $509 = $213;
     $510 = $215;
     $207 = $510;
     $511 = $207;
     $512 = $216;
     $208 = $512;
     $513 = $208;
     $209 = $509;
     $210 = $511;
     $211 = $513;
     $514 = $210;
     $515 = $209;
     $516 = $514;
     $517 = $515;
     $518 = (($516) - ($517))|0;
     $519 = (($518|0) / 4)&-1;
     $212 = $519;
     $520 = $212;
     $521 = ($520>>>0)>(0);
     if ($521) {
      $522 = $211;
      $523 = $209;
      $524 = $212;
      $525 = $524<<2;
      _memmove(($522|0),($523|0),($525|0))|0;
     }
     $526 = $211;
     $527 = $212;
     $528 = (($526) + ($527<<2)|0);
     $529 = ((($476)) + 8|0);
     HEAP32[$529>>2] = $528;
     $530 = $240;
     $531 = ((($476)) + 4|0);
     $532 = HEAP32[$531>>2]|0;
     $533 = (0 - ($530))|0;
     $534 = (($532) + ($533<<2)|0);
     HEAP32[$531>>2] = $534;
    }
   } while(0);
   $219 = $476;
   $626 = $219;
   $627 = ((($626)) + 12|0);
   $218 = $627;
   $628 = $218;
   $217 = $628;
   $629 = $217;
   $630 = ((($476)) + 8|0);
   $631 = HEAP32[$630>>2]|0;
   $220 = $631;
   $632 = $220;
   $633 = $239;
   $231 = $629;
   $232 = $632;
   $233 = $633;
   $634 = $231;
   $635 = $232;
   $636 = $233;
   $230 = $636;
   $637 = $230;
   ;HEAP8[$229>>0]=HEAP8[$234>>0]|0;
   $226 = $634;
   $227 = $635;
   $228 = $637;
   $638 = $226;
   $639 = $227;
   $640 = $228;
   $225 = $640;
   $641 = $225;
   $222 = $638;
   $223 = $639;
   $224 = $641;
   $642 = $223;
   $643 = $224;
   $221 = $643;
   $644 = $221;
   $645 = HEAP32[$644>>2]|0;
   HEAP32[$642>>2] = $645;
   $646 = ((($476)) + 8|0);
   $647 = HEAP32[$646>>2]|0;
   $648 = ((($647)) + 4|0);
   HEAP32[$646>>2] = $648;
   $649 = HEAP32[$402>>2]|0;
   $650 = (($649) + -1)|0;
   HEAP32[$402>>2] = $650;
  }
  STACKTOP = sp;return;
 }
 $651 = HEAP32[$401>>2]|0;
 $157 = $413;
 $652 = $157;
 $156 = $652;
 $653 = $156;
 $654 = ((($653)) + 12|0);
 $155 = $654;
 $655 = $155;
 $154 = $655;
 $656 = $154;
 $657 = HEAP32[$656>>2]|0;
 $658 = HEAP32[$652>>2]|0;
 $659 = $657;
 $660 = $658;
 $661 = (($659) - ($660))|0;
 $662 = (($661|0) / 4)&-1;
 $153 = $413;
 $663 = $153;
 $664 = ((($663)) + 8|0);
 $665 = HEAP32[$664>>2]|0;
 $666 = ((($663)) + 4|0);
 $667 = HEAP32[$666>>2]|0;
 $668 = $665;
 $669 = $667;
 $670 = (($668) - ($669))|0;
 $671 = (($670|0) / 4)&-1;
 $672 = (($662) - ($671))|0;
 $673 = ($651>>>0)<=($672>>>0);
 if (!($673)) {
  $935 = HEAP32[$402>>2]|0;
  $936 = ($935*93)|0;
  $407 = $936;
  $30 = $413;
  $937 = $30;
  $29 = $937;
  $938 = $29;
  $939 = ((($938)) + 12|0);
  $28 = $939;
  $940 = $28;
  $27 = $940;
  $941 = $27;
  $942 = HEAP32[$941>>2]|0;
  $943 = HEAP32[$937>>2]|0;
  $944 = $942;
  $945 = $943;
  $946 = (($944) - ($945))|0;
  $947 = (($946|0) / 4)&-1;
  $948 = $947<<1;
  HEAP32[$409>>2] = $948;
  $949 = HEAP32[$401>>2]|0;
  $26 = $413;
  $950 = $26;
  $951 = ((($950)) + 8|0);
  $952 = HEAP32[$951>>2]|0;
  $953 = ((($950)) + 4|0);
  $954 = HEAP32[$953>>2]|0;
  $955 = $952;
  $956 = $954;
  $957 = (($955) - ($956))|0;
  $958 = (($957|0) / 4)&-1;
  $959 = (($949) + ($958))|0;
  HEAP32[$410>>2] = $959;
  $23 = $409;
  $24 = $410;
  $960 = $23;
  $961 = $24;
  ;HEAP8[$22>>0]=HEAP8[$25>>0]|0;
  $20 = $960;
  $21 = $961;
  $962 = $20;
  $963 = $21;
  $17 = $22;
  $18 = $962;
  $19 = $963;
  $964 = $18;
  $965 = HEAP32[$964>>2]|0;
  $966 = $19;
  $967 = HEAP32[$966>>2]|0;
  $968 = ($965>>>0)<($967>>>0);
  $969 = $21;
  $970 = $20;
  $971 = $968 ? $969 : $970;
  $972 = HEAP32[$971>>2]|0;
  $16 = $413;
  $973 = $16;
  $974 = ((($973)) + 8|0);
  $975 = HEAP32[$974>>2]|0;
  $976 = ((($973)) + 4|0);
  $977 = HEAP32[$976>>2]|0;
  $978 = $975;
  $979 = $977;
  $980 = (($978) - ($979))|0;
  $981 = (($980|0) / 4)&-1;
  $982 = HEAP32[$402>>2]|0;
  $983 = (($981) - ($982))|0;
  $15 = $413;
  $984 = $15;
  $985 = ((($984)) + 12|0);
  $14 = $985;
  $986 = $14;
  $13 = $986;
  $987 = $13;
  __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($408,$972,$983,$987);
  while(1) {
   $988 = HEAP32[$401>>2]|0;
   $989 = ($988>>>0)>(0);
   if (!($989)) {
    break;
   }
   $990 = $400;
   $11 = $990;
   $12 = 93;
   $991 = $11;
   $992 = $12;
   $8 = $991;
   $9 = $992;
   $10 = 0;
   $993 = $8;
   $994 = $9;
   $7 = $993;
   $995 = ($994>>>0)>(97612893);
   if ($995) {
    label = 35;
    break;
   }
   $1000 = $9;
   $1001 = ($1000*44)|0;
   $6 = $1001;
   $1002 = $6;
   $1003 = (__Znwj($1002)|0);
   HEAP32[$411>>2] = $1003;
   __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE9push_backEOS4_($408,$411);
   $1004 = HEAP32[$401>>2]|0;
   $1005 = (($1004) + -1)|0;
   HEAP32[$401>>2] = $1005;
  }
  if ((label|0) == 35) {
   $5 = 4287;
   $996 = (___cxa_allocate_exception(8)|0);
   $997 = $5;
   $3 = $996;
   $4 = $997;
   $998 = $3;
   $999 = $4;
   __ZNSt11logic_errorC2EPKc($998,$999);
   HEAP32[$998>>2] = (3660);
   ___cxa_throw(($996|0),(1384|0),(220|0));
   // unreachable;
  }
  while(1) {
   $1006 = HEAP32[$402>>2]|0;
   $1007 = ($1006>>>0)>(0);
   if (!($1007)) {
    break;
   }
   $2 = $413;
   $1008 = $2;
   $1009 = ((($1008)) + 4|0);
   $1010 = HEAP32[$1009>>2]|0;
   $335 = $408;
   $336 = $1010;
   $1011 = $335;
   $1012 = ((($1011)) + 8|0);
   $1013 = HEAP32[$1012>>2]|0;
   $334 = $1011;
   $1014 = $334;
   $1015 = ((($1014)) + 12|0);
   $333 = $1015;
   $1016 = $333;
   $332 = $1016;
   $1017 = $332;
   $1018 = HEAP32[$1017>>2]|0;
   $1019 = ($1013|0)==($1018|0);
   do {
    if ($1019) {
     $1020 = ((($1011)) + 4|0);
     $1021 = HEAP32[$1020>>2]|0;
     $1022 = HEAP32[$1011>>2]|0;
     $1023 = ($1021>>>0)>($1022>>>0);
     if (!($1023)) {
      $303 = $1011;
      $1070 = $303;
      $1071 = ((($1070)) + 12|0);
      $302 = $1071;
      $1072 = $302;
      $301 = $1072;
      $1073 = $301;
      $1074 = HEAP32[$1073>>2]|0;
      $1075 = HEAP32[$1011>>2]|0;
      $1076 = $1074;
      $1077 = $1075;
      $1078 = (($1076) - ($1077))|0;
      $1079 = (($1078|0) / 4)&-1;
      $1080 = $1079<<1;
      HEAP32[$339>>2] = $1080;
      HEAP32[$340>>2] = 1;
      $268 = $339;
      $269 = $340;
      $1081 = $268;
      $1082 = $269;
      ;HEAP8[$267>>0]=HEAP8[$270>>0]|0;
      $265 = $1081;
      $266 = $1082;
      $1083 = $265;
      $1084 = $266;
      $262 = $267;
      $263 = $1083;
      $264 = $1084;
      $1085 = $263;
      $1086 = HEAP32[$1085>>2]|0;
      $1087 = $264;
      $1088 = HEAP32[$1087>>2]|0;
      $1089 = ($1086>>>0)<($1088>>>0);
      $1090 = $266;
      $1091 = $265;
      $1092 = $1089 ? $1090 : $1091;
      $1093 = HEAP32[$1092>>2]|0;
      $338 = $1093;
      $1094 = $338;
      $1095 = $338;
      $1096 = (($1095>>>0) / 4)&-1;
      $257 = $1011;
      $1097 = $257;
      $1098 = ((($1097)) + 12|0);
      $256 = $1098;
      $1099 = $256;
      $1100 = ((($1099)) + 4|0);
      $255 = $1100;
      $1101 = $255;
      $1102 = HEAP32[$1101>>2]|0;
      __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($341,$1094,$1096,$1102);
      $1103 = ((($1011)) + 4|0);
      $1104 = HEAP32[$1103>>2]|0;
      $258 = $342;
      $259 = $1104;
      $1105 = $258;
      $1106 = $259;
      HEAP32[$1105>>2] = $1106;
      $1107 = ((($1011)) + 8|0);
      $1108 = HEAP32[$1107>>2]|0;
      $260 = $343;
      $261 = $1108;
      $1109 = $260;
      $1110 = $261;
      HEAP32[$1109>>2] = $1110;
      ;HEAP32[$$byval_copy4>>2]=HEAP32[$342>>2]|0;
      ;HEAP32[$$byval_copy5>>2]=HEAP32[$343>>2]|0;
      __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($341,$$byval_copy4,$$byval_copy5);
      $274 = $1011;
      $275 = $341;
      $1111 = $274;
      $273 = $1111;
      $1112 = $273;
      $1113 = HEAP32[$1112>>2]|0;
      HEAP32[$276>>2] = $1113;
      $1114 = $275;
      $271 = $1114;
      $1115 = $271;
      $1116 = HEAP32[$1115>>2]|0;
      $1117 = $274;
      HEAP32[$1117>>2] = $1116;
      $272 = $276;
      $1118 = $272;
      $1119 = HEAP32[$1118>>2]|0;
      $1120 = $275;
      HEAP32[$1120>>2] = $1119;
      $1121 = ((($1011)) + 4|0);
      $1122 = ((($341)) + 4|0);
      $280 = $1121;
      $281 = $1122;
      $1123 = $280;
      $279 = $1123;
      $1124 = $279;
      $1125 = HEAP32[$1124>>2]|0;
      HEAP32[$282>>2] = $1125;
      $1126 = $281;
      $277 = $1126;
      $1127 = $277;
      $1128 = HEAP32[$1127>>2]|0;
      $1129 = $280;
      HEAP32[$1129>>2] = $1128;
      $278 = $282;
      $1130 = $278;
      $1131 = HEAP32[$1130>>2]|0;
      $1132 = $281;
      HEAP32[$1132>>2] = $1131;
      $1133 = ((($1011)) + 8|0);
      $1134 = ((($341)) + 8|0);
      $286 = $1133;
      $287 = $1134;
      $1135 = $286;
      $285 = $1135;
      $1136 = $285;
      $1137 = HEAP32[$1136>>2]|0;
      HEAP32[$288>>2] = $1137;
      $1138 = $287;
      $283 = $1138;
      $1139 = $283;
      $1140 = HEAP32[$1139>>2]|0;
      $1141 = $286;
      HEAP32[$1141>>2] = $1140;
      $284 = $288;
      $1142 = $284;
      $1143 = HEAP32[$1142>>2]|0;
      $1144 = $287;
      HEAP32[$1144>>2] = $1143;
      $291 = $1011;
      $1145 = $291;
      $1146 = ((($1145)) + 12|0);
      $290 = $1146;
      $1147 = $290;
      $289 = $1147;
      $1148 = $289;
      $294 = $341;
      $1149 = $294;
      $1150 = ((($1149)) + 12|0);
      $293 = $1150;
      $1151 = $293;
      $292 = $1151;
      $1152 = $292;
      $298 = $1148;
      $299 = $1152;
      $1153 = $298;
      $297 = $1153;
      $1154 = $297;
      $1155 = HEAP32[$1154>>2]|0;
      HEAP32[$300>>2] = $1155;
      $1156 = $299;
      $295 = $1156;
      $1157 = $295;
      $1158 = HEAP32[$1157>>2]|0;
      $1159 = $298;
      HEAP32[$1159>>2] = $1158;
      $296 = $300;
      $1160 = $296;
      $1161 = HEAP32[$1160>>2]|0;
      $1162 = $299;
      HEAP32[$1162>>2] = $1161;
      __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($341);
      break;
     }
     $1024 = ((($1011)) + 4|0);
     $1025 = HEAP32[$1024>>2]|0;
     $1026 = HEAP32[$1011>>2]|0;
     $1027 = $1025;
     $1028 = $1026;
     $1029 = (($1027) - ($1028))|0;
     $1030 = (($1029|0) / 4)&-1;
     $337 = $1030;
     $1031 = $337;
     $1032 = (($1031) + 1)|0;
     $1033 = (($1032|0) / 2)&-1;
     $337 = $1033;
     $1034 = ((($1011)) + 4|0);
     $1035 = HEAP32[$1034>>2]|0;
     $1036 = ((($1011)) + 8|0);
     $1037 = HEAP32[$1036>>2]|0;
     $1038 = ((($1011)) + 4|0);
     $1039 = HEAP32[$1038>>2]|0;
     $1040 = $337;
     $1041 = (0 - ($1040))|0;
     $1042 = (($1039) + ($1041<<2)|0);
     $311 = $1035;
     $312 = $1037;
     $313 = $1042;
     $1043 = $311;
     $310 = $1043;
     $1044 = $310;
     $1045 = $312;
     $304 = $1045;
     $1046 = $304;
     $1047 = $313;
     $305 = $1047;
     $1048 = $305;
     $306 = $1044;
     $307 = $1046;
     $308 = $1048;
     $1049 = $307;
     $1050 = $306;
     $1051 = $1049;
     $1052 = $1050;
     $1053 = (($1051) - ($1052))|0;
     $1054 = (($1053|0) / 4)&-1;
     $309 = $1054;
     $1055 = $309;
     $1056 = ($1055>>>0)>(0);
     if ($1056) {
      $1057 = $308;
      $1058 = $306;
      $1059 = $309;
      $1060 = $1059<<2;
      _memmove(($1057|0),($1058|0),($1060|0))|0;
     }
     $1061 = $308;
     $1062 = $309;
     $1063 = (($1061) + ($1062<<2)|0);
     $1064 = ((($1011)) + 8|0);
     HEAP32[$1064>>2] = $1063;
     $1065 = $337;
     $1066 = ((($1011)) + 4|0);
     $1067 = HEAP32[$1066>>2]|0;
     $1068 = (0 - ($1065))|0;
     $1069 = (($1067) + ($1068<<2)|0);
     HEAP32[$1066>>2] = $1069;
    }
   } while(0);
   $316 = $1011;
   $1163 = $316;
   $1164 = ((($1163)) + 12|0);
   $315 = $1164;
   $1165 = $315;
   $1166 = ((($1165)) + 4|0);
   $314 = $1166;
   $1167 = $314;
   $1168 = HEAP32[$1167>>2]|0;
   $1169 = ((($1011)) + 8|0);
   $1170 = HEAP32[$1169>>2]|0;
   $317 = $1170;
   $1171 = $317;
   $1172 = $336;
   $328 = $1168;
   $329 = $1171;
   $330 = $1172;
   $1173 = $328;
   $1174 = $329;
   $1175 = $330;
   $327 = $1175;
   $1176 = $327;
   ;HEAP8[$326>>0]=HEAP8[$331>>0]|0;
   $323 = $1173;
   $324 = $1174;
   $325 = $1176;
   $1177 = $323;
   $1178 = $324;
   $1179 = $325;
   $322 = $1179;
   $1180 = $322;
   $319 = $1177;
   $320 = $1178;
   $321 = $1180;
   $1181 = $320;
   $1182 = $321;
   $318 = $1182;
   $1183 = $318;
   $1184 = HEAP32[$1183>>2]|0;
   HEAP32[$1181>>2] = $1184;
   $1185 = ((($1011)) + 8|0);
   $1186 = HEAP32[$1185>>2]|0;
   $1187 = ((($1186)) + 4|0);
   HEAP32[$1185>>2] = $1187;
   $350 = $413;
   $1188 = $350;
   $1189 = ((($1188)) + 4|0);
   $1190 = HEAP32[$1189>>2]|0;
   $1191 = ((($1190)) + 4|0);
   $347 = $1188;
   $348 = $1191;
   $1192 = $347;
   $1193 = $348;
   ;HEAP8[$346>>0]=HEAP8[$349>>0]|0;
   $344 = $1192;
   $345 = $1193;
   $1194 = $344;
   $1195 = $345;
   $1196 = ((($1194)) + 4|0);
   HEAP32[$1196>>2] = $1195;
   $1197 = HEAP32[$402>>2]|0;
   $1198 = (($1197) + -1)|0;
   HEAP32[$402>>2] = $1198;
  }
  $351 = $413;
  $1199 = $351;
  $1200 = ((($1199)) + 8|0);
  $1201 = HEAP32[$1200>>2]|0;
  $412 = $1201;
  while(1) {
   $1202 = $412;
   $352 = $413;
   $1203 = $352;
   $1204 = ((($1203)) + 4|0);
   $1205 = HEAP32[$1204>>2]|0;
   $1206 = ($1202|0)!=($1205|0);
   if (!($1206)) {
    break;
   }
   $1207 = $412;
   $1208 = ((($1207)) + -4|0);
   $412 = $1208;
   __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE10push_frontERKS4_($408,$1208);
  }
  $365 = $413;
  $366 = $408;
  $1209 = $365;
  $364 = $1209;
  $1210 = $364;
  $1211 = HEAP32[$1210>>2]|0;
  HEAP32[$367>>2] = $1211;
  $1212 = $366;
  $362 = $1212;
  $1213 = $362;
  $1214 = HEAP32[$1213>>2]|0;
  $1215 = $365;
  HEAP32[$1215>>2] = $1214;
  $363 = $367;
  $1216 = $363;
  $1217 = HEAP32[$1216>>2]|0;
  $1218 = $366;
  HEAP32[$1218>>2] = $1217;
  $1219 = ((($413)) + 4|0);
  $1220 = ((($408)) + 4|0);
  $371 = $1219;
  $372 = $1220;
  $1221 = $371;
  $370 = $1221;
  $1222 = $370;
  $1223 = HEAP32[$1222>>2]|0;
  HEAP32[$373>>2] = $1223;
  $1224 = $372;
  $368 = $1224;
  $1225 = $368;
  $1226 = HEAP32[$1225>>2]|0;
  $1227 = $371;
  HEAP32[$1227>>2] = $1226;
  $369 = $373;
  $1228 = $369;
  $1229 = HEAP32[$1228>>2]|0;
  $1230 = $372;
  HEAP32[$1230>>2] = $1229;
  $1231 = ((($413)) + 8|0);
  $1232 = ((($408)) + 8|0);
  $377 = $1231;
  $378 = $1232;
  $1233 = $377;
  $376 = $1233;
  $1234 = $376;
  $1235 = HEAP32[$1234>>2]|0;
  HEAP32[$379>>2] = $1235;
  $1236 = $378;
  $374 = $1236;
  $1237 = $374;
  $1238 = HEAP32[$1237>>2]|0;
  $1239 = $377;
  HEAP32[$1239>>2] = $1238;
  $375 = $379;
  $1240 = $375;
  $1241 = HEAP32[$1240>>2]|0;
  $1242 = $378;
  HEAP32[$1242>>2] = $1241;
  $382 = $413;
  $1243 = $382;
  $1244 = ((($1243)) + 12|0);
  $381 = $1244;
  $1245 = $381;
  $380 = $1245;
  $1246 = $380;
  $385 = $408;
  $1247 = $385;
  $1248 = ((($1247)) + 12|0);
  $384 = $1248;
  $1249 = $384;
  $383 = $1249;
  $1250 = $383;
  $389 = $1246;
  $390 = $1250;
  $1251 = $389;
  $388 = $1251;
  $1252 = $388;
  $1253 = HEAP32[$1252>>2]|0;
  HEAP32[$391>>2] = $1253;
  $1254 = $390;
  $386 = $1254;
  $1255 = $386;
  $1256 = HEAP32[$1255>>2]|0;
  $1257 = $389;
  HEAP32[$1257>>2] = $1256;
  $387 = $391;
  $1258 = $387;
  $1259 = HEAP32[$1258>>2]|0;
  $1260 = $390;
  HEAP32[$1260>>2] = $1259;
  $1261 = $407;
  $1262 = ((($413)) + 16|0);
  $1263 = HEAP32[$1262>>2]|0;
  $1264 = (($1263) - ($1261))|0;
  HEAP32[$1262>>2] = $1264;
  __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($408);
  STACKTOP = sp;return;
 }
 while(1) {
  $674 = HEAP32[$401>>2]|0;
  $675 = ($674>>>0)>(0);
  if (!($675)) {
   break;
  }
  $152 = $413;
  $676 = $152;
  $151 = $676;
  $677 = $151;
  $678 = ((($677)) + 12|0);
  $150 = $678;
  $679 = $150;
  $149 = $679;
  $680 = $149;
  $681 = HEAP32[$680>>2]|0;
  $682 = ((($676)) + 8|0);
  $683 = HEAP32[$682>>2]|0;
  $684 = $681;
  $685 = $683;
  $686 = (($684) - ($685))|0;
  $687 = (($686|0) / 4)&-1;
  $688 = ($687|0)==(0);
  if ($688) {
   break;
  }
  $689 = $400;
  $147 = $689;
  $148 = 93;
  $690 = $147;
  $691 = $148;
  $144 = $690;
  $145 = $691;
  $146 = 0;
  $692 = $144;
  $693 = $145;
  $143 = $692;
  $694 = ($693>>>0)>(97612893);
  if ($694) {
   label = 16;
   break;
  }
  $699 = $145;
  $700 = ($699*44)|0;
  $142 = $700;
  $701 = $142;
  $702 = (__Znwj($701)|0);
  HEAP32[$404>>2] = $702;
  __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticENS_9allocatorIS4_EEE9push_backEOS4_($413,$404);
  $703 = HEAP32[$401>>2]|0;
  $704 = (($703) + -1)|0;
  HEAP32[$401>>2] = $704;
 }
 if ((label|0) == 16) {
  $141 = 4287;
  $695 = (___cxa_allocate_exception(8)|0);
  $696 = $141;
  $139 = $695;
  $140 = $696;
  $697 = $139;
  $698 = $140;
  __ZNSt11logic_errorC2EPKc($697,$698);
  HEAP32[$697>>2] = (3660);
  ___cxa_throw(($695|0),(1384|0),(220|0));
  // unreachable;
 }
 while(1) {
  $705 = HEAP32[$401>>2]|0;
  $706 = ($705>>>0)>(0);
  if (!($706)) {
   break;
  }
  $707 = $400;
  $137 = $707;
  $138 = 93;
  $708 = $137;
  $709 = $138;
  $134 = $708;
  $135 = $709;
  $136 = 0;
  $710 = $134;
  $711 = $135;
  $133 = $710;
  $712 = ($711>>>0)>(97612893);
  if ($712) {
   label = 21;
   break;
  }
  $717 = $135;
  $718 = ($717*44)|0;
  $132 = $718;
  $719 = $132;
  $720 = (__Znwj($719)|0);
  HEAP32[$405>>2] = $720;
  __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticENS_9allocatorIS4_EEE10push_frontEOS4_($413,$405);
  $721 = HEAP32[$401>>2]|0;
  $722 = (($721) + -1)|0;
  HEAP32[$401>>2] = $722;
  $723 = HEAP32[$402>>2]|0;
  $724 = (($723) + 1)|0;
  HEAP32[$402>>2] = $724;
  $128 = $413;
  $725 = $128;
  $726 = ((($725)) + 8|0);
  $727 = HEAP32[$726>>2]|0;
  $728 = ((($725)) + 4|0);
  $729 = HEAP32[$728>>2]|0;
  $730 = $727;
  $731 = $729;
  $732 = (($730) - ($731))|0;
  $733 = (($732|0) / 4)&-1;
  $734 = ($733|0)==(1);
  $735 = $734&1;
  $736 = (93 - ($735))|0;
  $737 = ((($413)) + 16|0);
  $738 = HEAP32[$737>>2]|0;
  $739 = (($738) + ($736))|0;
  HEAP32[$737>>2] = $739;
 }
 if ((label|0) == 21) {
  $131 = 4287;
  $713 = (___cxa_allocate_exception(8)|0);
  $714 = $131;
  $129 = $713;
  $130 = $714;
  $715 = $129;
  $716 = $130;
  __ZNSt11logic_errorC2EPKc($715,$716);
  HEAP32[$715>>2] = (3660);
  ___cxa_throw(($713|0),(1384|0),(220|0));
  // unreachable;
 }
 $740 = HEAP32[$402>>2]|0;
 $741 = ($740*93)|0;
 $742 = ((($413)) + 16|0);
 $743 = HEAP32[$742>>2]|0;
 $744 = (($743) - ($741))|0;
 HEAP32[$742>>2] = $744;
 while(1) {
  $745 = HEAP32[$402>>2]|0;
  $746 = ($745>>>0)>(0);
  if (!($746)) {
   break;
  }
  $127 = $413;
  $747 = $127;
  $748 = ((($747)) + 4|0);
  $749 = HEAP32[$748>>2]|0;
  $750 = HEAP32[$749>>2]|0;
  HEAP32[$406>>2] = $750;
  $126 = $413;
  $751 = $126;
  $752 = ((($751)) + 4|0);
  $753 = HEAP32[$752>>2]|0;
  $754 = ((($753)) + 4|0);
  $123 = $751;
  $124 = $754;
  $755 = $123;
  $756 = $124;
  ;HEAP8[$122>>0]=HEAP8[$125>>0]|0;
  $120 = $755;
  $121 = $756;
  $757 = $120;
  $758 = $121;
  $759 = ((($757)) + 4|0);
  HEAP32[$759>>2] = $758;
  $111 = $413;
  $112 = $406;
  $760 = $111;
  $761 = ((($760)) + 8|0);
  $762 = HEAP32[$761>>2]|0;
  $110 = $760;
  $763 = $110;
  $764 = ((($763)) + 12|0);
  $109 = $764;
  $765 = $109;
  $108 = $765;
  $766 = $108;
  $767 = HEAP32[$766>>2]|0;
  $768 = ($762|0)==($767|0);
  do {
   if ($768) {
    $769 = ((($760)) + 4|0);
    $770 = HEAP32[$769>>2]|0;
    $771 = HEAP32[$760>>2]|0;
    $772 = ($770>>>0)>($771>>>0);
    if (!($772)) {
     $79 = $760;
     $819 = $79;
     $820 = ((($819)) + 12|0);
     $78 = $820;
     $821 = $78;
     $77 = $821;
     $822 = $77;
     $823 = HEAP32[$822>>2]|0;
     $824 = HEAP32[$760>>2]|0;
     $825 = $823;
     $826 = $824;
     $827 = (($825) - ($826))|0;
     $828 = (($827|0) / 4)&-1;
     $829 = $828<<1;
     HEAP32[$115>>2] = $829;
     HEAP32[$116>>2] = 1;
     $44 = $115;
     $45 = $116;
     $830 = $44;
     $831 = $45;
     ;HEAP8[$43>>0]=HEAP8[$46>>0]|0;
     $41 = $830;
     $42 = $831;
     $832 = $41;
     $833 = $42;
     $38 = $43;
     $39 = $832;
     $40 = $833;
     $834 = $39;
     $835 = HEAP32[$834>>2]|0;
     $836 = $40;
     $837 = HEAP32[$836>>2]|0;
     $838 = ($835>>>0)<($837>>>0);
     $839 = $42;
     $840 = $41;
     $841 = $838 ? $839 : $840;
     $842 = HEAP32[$841>>2]|0;
     $114 = $842;
     $843 = $114;
     $844 = $114;
     $845 = (($844>>>0) / 4)&-1;
     $33 = $760;
     $846 = $33;
     $847 = ((($846)) + 12|0);
     $32 = $847;
     $848 = $32;
     $31 = $848;
     $849 = $31;
     __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($117,$843,$845,$849);
     $850 = ((($760)) + 4|0);
     $851 = HEAP32[$850>>2]|0;
     $34 = $118;
     $35 = $851;
     $852 = $34;
     $853 = $35;
     HEAP32[$852>>2] = $853;
     $854 = ((($760)) + 8|0);
     $855 = HEAP32[$854>>2]|0;
     $36 = $119;
     $37 = $855;
     $856 = $36;
     $857 = $37;
     HEAP32[$856>>2] = $857;
     ;HEAP32[$$byval_copy2>>2]=HEAP32[$118>>2]|0;
     ;HEAP32[$$byval_copy3>>2]=HEAP32[$119>>2]|0;
     __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($117,$$byval_copy2,$$byval_copy3);
     $50 = $760;
     $51 = $117;
     $858 = $50;
     $49 = $858;
     $859 = $49;
     $860 = HEAP32[$859>>2]|0;
     HEAP32[$52>>2] = $860;
     $861 = $51;
     $47 = $861;
     $862 = $47;
     $863 = HEAP32[$862>>2]|0;
     $864 = $50;
     HEAP32[$864>>2] = $863;
     $48 = $52;
     $865 = $48;
     $866 = HEAP32[$865>>2]|0;
     $867 = $51;
     HEAP32[$867>>2] = $866;
     $868 = ((($760)) + 4|0);
     $869 = ((($117)) + 4|0);
     $56 = $868;
     $57 = $869;
     $870 = $56;
     $55 = $870;
     $871 = $55;
     $872 = HEAP32[$871>>2]|0;
     HEAP32[$58>>2] = $872;
     $873 = $57;
     $53 = $873;
     $874 = $53;
     $875 = HEAP32[$874>>2]|0;
     $876 = $56;
     HEAP32[$876>>2] = $875;
     $54 = $58;
     $877 = $54;
     $878 = HEAP32[$877>>2]|0;
     $879 = $57;
     HEAP32[$879>>2] = $878;
     $880 = ((($760)) + 8|0);
     $881 = ((($117)) + 8|0);
     $62 = $880;
     $63 = $881;
     $882 = $62;
     $61 = $882;
     $883 = $61;
     $884 = HEAP32[$883>>2]|0;
     HEAP32[$64>>2] = $884;
     $885 = $63;
     $59 = $885;
     $886 = $59;
     $887 = HEAP32[$886>>2]|0;
     $888 = $62;
     HEAP32[$888>>2] = $887;
     $60 = $64;
     $889 = $60;
     $890 = HEAP32[$889>>2]|0;
     $891 = $63;
     HEAP32[$891>>2] = $890;
     $67 = $760;
     $892 = $67;
     $893 = ((($892)) + 12|0);
     $66 = $893;
     $894 = $66;
     $65 = $894;
     $895 = $65;
     $70 = $117;
     $896 = $70;
     $897 = ((($896)) + 12|0);
     $69 = $897;
     $898 = $69;
     $68 = $898;
     $899 = $68;
     $74 = $895;
     $75 = $899;
     $900 = $74;
     $73 = $900;
     $901 = $73;
     $902 = HEAP32[$901>>2]|0;
     HEAP32[$76>>2] = $902;
     $903 = $75;
     $71 = $903;
     $904 = $71;
     $905 = HEAP32[$904>>2]|0;
     $906 = $74;
     HEAP32[$906>>2] = $905;
     $72 = $76;
     $907 = $72;
     $908 = HEAP32[$907>>2]|0;
     $909 = $75;
     HEAP32[$909>>2] = $908;
     __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($117);
     break;
    }
    $773 = ((($760)) + 4|0);
    $774 = HEAP32[$773>>2]|0;
    $775 = HEAP32[$760>>2]|0;
    $776 = $774;
    $777 = $775;
    $778 = (($776) - ($777))|0;
    $779 = (($778|0) / 4)&-1;
    $113 = $779;
    $780 = $113;
    $781 = (($780) + 1)|0;
    $782 = (($781|0) / 2)&-1;
    $113 = $782;
    $783 = ((($760)) + 4|0);
    $784 = HEAP32[$783>>2]|0;
    $785 = ((($760)) + 8|0);
    $786 = HEAP32[$785>>2]|0;
    $787 = ((($760)) + 4|0);
    $788 = HEAP32[$787>>2]|0;
    $789 = $113;
    $790 = (0 - ($789))|0;
    $791 = (($788) + ($790<<2)|0);
    $87 = $784;
    $88 = $786;
    $89 = $791;
    $792 = $87;
    $86 = $792;
    $793 = $86;
    $794 = $88;
    $80 = $794;
    $795 = $80;
    $796 = $89;
    $81 = $796;
    $797 = $81;
    $82 = $793;
    $83 = $795;
    $84 = $797;
    $798 = $83;
    $799 = $82;
    $800 = $798;
    $801 = $799;
    $802 = (($800) - ($801))|0;
    $803 = (($802|0) / 4)&-1;
    $85 = $803;
    $804 = $85;
    $805 = ($804>>>0)>(0);
    if ($805) {
     $806 = $84;
     $807 = $82;
     $808 = $85;
     $809 = $808<<2;
     _memmove(($806|0),($807|0),($809|0))|0;
    }
    $810 = $84;
    $811 = $85;
    $812 = (($810) + ($811<<2)|0);
    $813 = ((($760)) + 8|0);
    HEAP32[$813>>2] = $812;
    $814 = $113;
    $815 = ((($760)) + 4|0);
    $816 = HEAP32[$815>>2]|0;
    $817 = (0 - ($814))|0;
    $818 = (($816) + ($817<<2)|0);
    HEAP32[$815>>2] = $818;
   }
  } while(0);
  $92 = $760;
  $910 = $92;
  $911 = ((($910)) + 12|0);
  $91 = $911;
  $912 = $91;
  $90 = $912;
  $913 = $90;
  $914 = ((($760)) + 8|0);
  $915 = HEAP32[$914>>2]|0;
  $93 = $915;
  $916 = $93;
  $917 = $112;
  $104 = $913;
  $105 = $916;
  $106 = $917;
  $918 = $104;
  $919 = $105;
  $920 = $106;
  $103 = $920;
  $921 = $103;
  ;HEAP8[$102>>0]=HEAP8[$107>>0]|0;
  $99 = $918;
  $100 = $919;
  $101 = $921;
  $922 = $99;
  $923 = $100;
  $924 = $101;
  $98 = $924;
  $925 = $98;
  $95 = $922;
  $96 = $923;
  $97 = $925;
  $926 = $96;
  $927 = $97;
  $94 = $927;
  $928 = $94;
  $929 = HEAP32[$928>>2]|0;
  HEAP32[$926>>2] = $929;
  $930 = ((($760)) + 8|0);
  $931 = HEAP32[$930>>2]|0;
  $932 = ((($931)) + 4|0);
  HEAP32[$930>>2] = $932;
  $933 = HEAP32[$402>>2]|0;
  $934 = (($933) + -1)|0;
  HEAP32[$402>>2] = $934;
 }
 STACKTOP = sp;return;
}
function __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE3endEv($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = $1;
 $13 = $10;
 $9 = $13;
 $14 = $9;
 $15 = ((($14)) + 20|0);
 $8 = $15;
 $16 = $8;
 $7 = $16;
 $17 = $7;
 $18 = HEAP32[$17>>2]|0;
 $19 = ((($13)) + 16|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = (($18) + ($20))|0;
 $11 = $21;
 $6 = $13;
 $22 = $6;
 $23 = ((($22)) + 4|0);
 $24 = HEAP32[$23>>2]|0;
 $25 = $11;
 $26 = (($25>>>0) / 93)&-1;
 $27 = (($24) + ($26<<2)|0);
 $12 = $27;
 $28 = $12;
 $2 = $13;
 $29 = $2;
 $30 = ((($29)) + 8|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = ((($29)) + 4|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = ($31|0)==($33|0);
 if ($34) {
  $40 = 0;
  $3 = $0;
  $4 = $28;
  $5 = $40;
  $41 = $3;
  $42 = $4;
  HEAP32[$41>>2] = $42;
  $43 = ((($41)) + 4|0);
  $44 = $5;
  HEAP32[$43>>2] = $44;
  STACKTOP = sp;return;
 }
 $35 = $12;
 $36 = HEAP32[$35>>2]|0;
 $37 = $11;
 $38 = (($37>>>0) % 93)&-1;
 $39 = (($36) + (($38*44)|0)|0);
 $40 = $39;
 $3 = $0;
 $4 = $28;
 $5 = $40;
 $41 = $3;
 $42 = $4;
 HEAP32[$41>>2] = $42;
 $43 = ((($41)) + 4|0);
 $44 = $5;
 HEAP32[$43>>2] = $44;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticENS_9allocatorIS4_EEE9push_backEOS4_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0;
 var $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0;
 var $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0;
 var $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0;
 var $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 384|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(384|0);
 $$byval_copy1 = sp + 376|0;
 $$byval_copy = sp + 372|0;
 $14 = sp + 8|0;
 $17 = sp + 381|0;
 $23 = sp + 292|0;
 $29 = sp + 268|0;
 $35 = sp + 244|0;
 $47 = sp + 196|0;
 $74 = sp;
 $79 = sp + 380|0;
 $87 = sp + 44|0;
 $88 = sp + 40|0;
 $89 = sp + 20|0;
 $90 = sp + 16|0;
 $91 = sp + 12|0;
 $83 = $0;
 $84 = $1;
 $92 = $83;
 $93 = ((($92)) + 8|0);
 $94 = HEAP32[$93>>2]|0;
 $82 = $92;
 $95 = $82;
 $96 = ((($95)) + 12|0);
 $81 = $96;
 $97 = $81;
 $80 = $97;
 $98 = $80;
 $99 = HEAP32[$98>>2]|0;
 $100 = ($94|0)==($99|0);
 do {
  if ($100) {
   $101 = ((($92)) + 4|0);
   $102 = HEAP32[$101>>2]|0;
   $103 = HEAP32[$92>>2]|0;
   $104 = ($102>>>0)>($103>>>0);
   if (!($104)) {
    $50 = $92;
    $151 = $50;
    $152 = ((($151)) + 12|0);
    $49 = $152;
    $153 = $49;
    $48 = $153;
    $154 = $48;
    $155 = HEAP32[$154>>2]|0;
    $156 = HEAP32[$92>>2]|0;
    $157 = $155;
    $158 = $156;
    $159 = (($157) - ($158))|0;
    $160 = (($159|0) / 4)&-1;
    $161 = $160<<1;
    HEAP32[$87>>2] = $161;
    HEAP32[$88>>2] = 1;
    $15 = $87;
    $16 = $88;
    $162 = $15;
    $163 = $16;
    ;HEAP8[$14>>0]=HEAP8[$17>>0]|0;
    $12 = $162;
    $13 = $163;
    $164 = $12;
    $165 = $13;
    $9 = $14;
    $10 = $164;
    $11 = $165;
    $166 = $10;
    $167 = HEAP32[$166>>2]|0;
    $168 = $11;
    $169 = HEAP32[$168>>2]|0;
    $170 = ($167>>>0)<($169>>>0);
    $171 = $13;
    $172 = $12;
    $173 = $170 ? $171 : $172;
    $174 = HEAP32[$173>>2]|0;
    $86 = $174;
    $175 = $86;
    $176 = $86;
    $177 = (($176>>>0) / 4)&-1;
    $4 = $92;
    $178 = $4;
    $179 = ((($178)) + 12|0);
    $3 = $179;
    $180 = $3;
    $2 = $180;
    $181 = $2;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($89,$175,$177,$181);
    $182 = ((($92)) + 4|0);
    $183 = HEAP32[$182>>2]|0;
    $5 = $90;
    $6 = $183;
    $184 = $5;
    $185 = $6;
    HEAP32[$184>>2] = $185;
    $186 = ((($92)) + 8|0);
    $187 = HEAP32[$186>>2]|0;
    $7 = $91;
    $8 = $187;
    $188 = $7;
    $189 = $8;
    HEAP32[$188>>2] = $189;
    ;HEAP32[$$byval_copy>>2]=HEAP32[$90>>2]|0;
    ;HEAP32[$$byval_copy1>>2]=HEAP32[$91>>2]|0;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($89,$$byval_copy,$$byval_copy1);
    $21 = $92;
    $22 = $89;
    $190 = $21;
    $20 = $190;
    $191 = $20;
    $192 = HEAP32[$191>>2]|0;
    HEAP32[$23>>2] = $192;
    $193 = $22;
    $18 = $193;
    $194 = $18;
    $195 = HEAP32[$194>>2]|0;
    $196 = $21;
    HEAP32[$196>>2] = $195;
    $19 = $23;
    $197 = $19;
    $198 = HEAP32[$197>>2]|0;
    $199 = $22;
    HEAP32[$199>>2] = $198;
    $200 = ((($92)) + 4|0);
    $201 = ((($89)) + 4|0);
    $27 = $200;
    $28 = $201;
    $202 = $27;
    $26 = $202;
    $203 = $26;
    $204 = HEAP32[$203>>2]|0;
    HEAP32[$29>>2] = $204;
    $205 = $28;
    $24 = $205;
    $206 = $24;
    $207 = HEAP32[$206>>2]|0;
    $208 = $27;
    HEAP32[$208>>2] = $207;
    $25 = $29;
    $209 = $25;
    $210 = HEAP32[$209>>2]|0;
    $211 = $28;
    HEAP32[$211>>2] = $210;
    $212 = ((($92)) + 8|0);
    $213 = ((($89)) + 8|0);
    $33 = $212;
    $34 = $213;
    $214 = $33;
    $32 = $214;
    $215 = $32;
    $216 = HEAP32[$215>>2]|0;
    HEAP32[$35>>2] = $216;
    $217 = $34;
    $30 = $217;
    $218 = $30;
    $219 = HEAP32[$218>>2]|0;
    $220 = $33;
    HEAP32[$220>>2] = $219;
    $31 = $35;
    $221 = $31;
    $222 = HEAP32[$221>>2]|0;
    $223 = $34;
    HEAP32[$223>>2] = $222;
    $38 = $92;
    $224 = $38;
    $225 = ((($224)) + 12|0);
    $37 = $225;
    $226 = $37;
    $36 = $226;
    $227 = $36;
    $41 = $89;
    $228 = $41;
    $229 = ((($228)) + 12|0);
    $40 = $229;
    $230 = $40;
    $39 = $230;
    $231 = $39;
    $45 = $227;
    $46 = $231;
    $232 = $45;
    $44 = $232;
    $233 = $44;
    $234 = HEAP32[$233>>2]|0;
    HEAP32[$47>>2] = $234;
    $235 = $46;
    $42 = $235;
    $236 = $42;
    $237 = HEAP32[$236>>2]|0;
    $238 = $45;
    HEAP32[$238>>2] = $237;
    $43 = $47;
    $239 = $43;
    $240 = HEAP32[$239>>2]|0;
    $241 = $46;
    HEAP32[$241>>2] = $240;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($89);
    break;
   }
   $105 = ((($92)) + 4|0);
   $106 = HEAP32[$105>>2]|0;
   $107 = HEAP32[$92>>2]|0;
   $108 = $106;
   $109 = $107;
   $110 = (($108) - ($109))|0;
   $111 = (($110|0) / 4)&-1;
   $85 = $111;
   $112 = $85;
   $113 = (($112) + 1)|0;
   $114 = (($113|0) / 2)&-1;
   $85 = $114;
   $115 = ((($92)) + 4|0);
   $116 = HEAP32[$115>>2]|0;
   $117 = ((($92)) + 8|0);
   $118 = HEAP32[$117>>2]|0;
   $119 = ((($92)) + 4|0);
   $120 = HEAP32[$119>>2]|0;
   $121 = $85;
   $122 = (0 - ($121))|0;
   $123 = (($120) + ($122<<2)|0);
   $58 = $116;
   $59 = $118;
   $60 = $123;
   $124 = $58;
   $57 = $124;
   $125 = $57;
   $126 = $59;
   $51 = $126;
   $127 = $51;
   $128 = $60;
   $52 = $128;
   $129 = $52;
   $53 = $125;
   $54 = $127;
   $55 = $129;
   $130 = $54;
   $131 = $53;
   $132 = $130;
   $133 = $131;
   $134 = (($132) - ($133))|0;
   $135 = (($134|0) / 4)&-1;
   $56 = $135;
   $136 = $56;
   $137 = ($136>>>0)>(0);
   if ($137) {
    $138 = $55;
    $139 = $53;
    $140 = $56;
    $141 = $140<<2;
    _memmove(($138|0),($139|0),($141|0))|0;
   }
   $142 = $55;
   $143 = $56;
   $144 = (($142) + ($143<<2)|0);
   $145 = ((($92)) + 8|0);
   HEAP32[$145>>2] = $144;
   $146 = $85;
   $147 = ((($92)) + 4|0);
   $148 = HEAP32[$147>>2]|0;
   $149 = (0 - ($146))|0;
   $150 = (($148) + ($149<<2)|0);
   HEAP32[$147>>2] = $150;
  }
 } while(0);
 $63 = $92;
 $242 = $63;
 $243 = ((($242)) + 12|0);
 $62 = $243;
 $244 = $62;
 $61 = $244;
 $245 = $61;
 $246 = ((($92)) + 8|0);
 $247 = HEAP32[$246>>2]|0;
 $64 = $247;
 $248 = $64;
 $249 = $84;
 $65 = $249;
 $250 = $65;
 $76 = $245;
 $77 = $248;
 $78 = $250;
 $251 = $76;
 $252 = $77;
 $253 = $78;
 $75 = $253;
 $254 = $75;
 ;HEAP8[$74>>0]=HEAP8[$79>>0]|0;
 $71 = $251;
 $72 = $252;
 $73 = $254;
 $255 = $71;
 $256 = $72;
 $257 = $73;
 $70 = $257;
 $258 = $70;
 $67 = $255;
 $68 = $256;
 $69 = $258;
 $259 = $68;
 $260 = $69;
 $66 = $260;
 $261 = $66;
 $262 = HEAP32[$261>>2]|0;
 HEAP32[$259>>2] = $262;
 $263 = ((($92)) + 8|0);
 $264 = HEAP32[$263>>2]|0;
 $265 = ((($264)) + 4|0);
 HEAP32[$263>>2] = $265;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticENS_9allocatorIS4_EEE10push_frontEOS4_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 400|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(400|0);
 $$byval_copy1 = sp + 388|0;
 $$byval_copy = sp + 384|0;
 $10 = sp + 8|0;
 $13 = sp + 393|0;
 $26 = sp + 292|0;
 $32 = sp + 268|0;
 $38 = sp + 244|0;
 $50 = sp + 196|0;
 $77 = sp;
 $82 = sp + 392|0;
 $90 = sp + 44|0;
 $91 = sp + 40|0;
 $92 = sp + 20|0;
 $93 = sp + 16|0;
 $94 = sp + 12|0;
 $86 = $0;
 $87 = $1;
 $95 = $86;
 $96 = ((($95)) + 4|0);
 $97 = HEAP32[$96>>2]|0;
 $98 = HEAP32[$95>>2]|0;
 $99 = ($97|0)==($98|0);
 do {
  if ($99) {
   $100 = ((($95)) + 8|0);
   $101 = HEAP32[$100>>2]|0;
   $85 = $95;
   $102 = $85;
   $103 = ((($102)) + 12|0);
   $84 = $103;
   $104 = $84;
   $83 = $104;
   $105 = $83;
   $106 = HEAP32[$105>>2]|0;
   $107 = ($101>>>0)<($106>>>0);
   if (!($107)) {
    $20 = $95;
    $158 = $20;
    $159 = ((($158)) + 12|0);
    $19 = $159;
    $160 = $19;
    $18 = $160;
    $161 = $18;
    $162 = HEAP32[$161>>2]|0;
    $163 = HEAP32[$95>>2]|0;
    $164 = $162;
    $165 = $163;
    $166 = (($164) - ($165))|0;
    $167 = (($166|0) / 4)&-1;
    $168 = $167<<1;
    HEAP32[$90>>2] = $168;
    HEAP32[$91>>2] = 1;
    $11 = $90;
    $12 = $91;
    $169 = $11;
    $170 = $12;
    ;HEAP8[$10>>0]=HEAP8[$13>>0]|0;
    $8 = $169;
    $9 = $170;
    $171 = $8;
    $172 = $9;
    $5 = $10;
    $6 = $171;
    $7 = $172;
    $173 = $6;
    $174 = HEAP32[$173>>2]|0;
    $175 = $7;
    $176 = HEAP32[$175>>2]|0;
    $177 = ($174>>>0)<($176>>>0);
    $178 = $9;
    $179 = $8;
    $180 = $177 ? $178 : $179;
    $181 = HEAP32[$180>>2]|0;
    $89 = $181;
    $182 = $89;
    $183 = $89;
    $184 = (($183) + 3)|0;
    $185 = (($184>>>0) / 4)&-1;
    $4 = $95;
    $186 = $4;
    $187 = ((($186)) + 12|0);
    $3 = $187;
    $188 = $3;
    $2 = $188;
    $189 = $2;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($92,$182,$185,$189);
    $190 = ((($95)) + 4|0);
    $191 = HEAP32[$190>>2]|0;
    $14 = $93;
    $15 = $191;
    $192 = $14;
    $193 = $15;
    HEAP32[$192>>2] = $193;
    $194 = ((($95)) + 8|0);
    $195 = HEAP32[$194>>2]|0;
    $16 = $94;
    $17 = $195;
    $196 = $16;
    $197 = $17;
    HEAP32[$196>>2] = $197;
    ;HEAP32[$$byval_copy>>2]=HEAP32[$93>>2]|0;
    ;HEAP32[$$byval_copy1>>2]=HEAP32[$94>>2]|0;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($92,$$byval_copy,$$byval_copy1);
    $24 = $95;
    $25 = $92;
    $198 = $24;
    $23 = $198;
    $199 = $23;
    $200 = HEAP32[$199>>2]|0;
    HEAP32[$26>>2] = $200;
    $201 = $25;
    $21 = $201;
    $202 = $21;
    $203 = HEAP32[$202>>2]|0;
    $204 = $24;
    HEAP32[$204>>2] = $203;
    $22 = $26;
    $205 = $22;
    $206 = HEAP32[$205>>2]|0;
    $207 = $25;
    HEAP32[$207>>2] = $206;
    $208 = ((($95)) + 4|0);
    $209 = ((($92)) + 4|0);
    $30 = $208;
    $31 = $209;
    $210 = $30;
    $29 = $210;
    $211 = $29;
    $212 = HEAP32[$211>>2]|0;
    HEAP32[$32>>2] = $212;
    $213 = $31;
    $27 = $213;
    $214 = $27;
    $215 = HEAP32[$214>>2]|0;
    $216 = $30;
    HEAP32[$216>>2] = $215;
    $28 = $32;
    $217 = $28;
    $218 = HEAP32[$217>>2]|0;
    $219 = $31;
    HEAP32[$219>>2] = $218;
    $220 = ((($95)) + 8|0);
    $221 = ((($92)) + 8|0);
    $36 = $220;
    $37 = $221;
    $222 = $36;
    $35 = $222;
    $223 = $35;
    $224 = HEAP32[$223>>2]|0;
    HEAP32[$38>>2] = $224;
    $225 = $37;
    $33 = $225;
    $226 = $33;
    $227 = HEAP32[$226>>2]|0;
    $228 = $36;
    HEAP32[$228>>2] = $227;
    $34 = $38;
    $229 = $34;
    $230 = HEAP32[$229>>2]|0;
    $231 = $37;
    HEAP32[$231>>2] = $230;
    $41 = $95;
    $232 = $41;
    $233 = ((($232)) + 12|0);
    $40 = $233;
    $234 = $40;
    $39 = $234;
    $235 = $39;
    $44 = $92;
    $236 = $44;
    $237 = ((($236)) + 12|0);
    $43 = $237;
    $238 = $43;
    $42 = $238;
    $239 = $42;
    $48 = $235;
    $49 = $239;
    $240 = $48;
    $47 = $240;
    $241 = $47;
    $242 = HEAP32[$241>>2]|0;
    HEAP32[$50>>2] = $242;
    $243 = $49;
    $45 = $243;
    $244 = $45;
    $245 = HEAP32[$244>>2]|0;
    $246 = $48;
    HEAP32[$246>>2] = $245;
    $46 = $50;
    $247 = $46;
    $248 = HEAP32[$247>>2]|0;
    $249 = $49;
    HEAP32[$249>>2] = $248;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($92);
    break;
   }
   $63 = $95;
   $108 = $63;
   $109 = ((($108)) + 12|0);
   $62 = $109;
   $110 = $62;
   $61 = $110;
   $111 = $61;
   $112 = HEAP32[$111>>2]|0;
   $113 = ((($95)) + 8|0);
   $114 = HEAP32[$113>>2]|0;
   $115 = $112;
   $116 = $114;
   $117 = (($115) - ($116))|0;
   $118 = (($117|0) / 4)&-1;
   $88 = $118;
   $119 = $88;
   $120 = (($119) + 1)|0;
   $121 = (($120|0) / 2)&-1;
   $88 = $121;
   $122 = ((($95)) + 4|0);
   $123 = HEAP32[$122>>2]|0;
   $124 = ((($95)) + 8|0);
   $125 = HEAP32[$124>>2]|0;
   $126 = ((($95)) + 8|0);
   $127 = HEAP32[$126>>2]|0;
   $128 = $88;
   $129 = (($127) + ($128<<2)|0);
   $58 = $123;
   $59 = $125;
   $60 = $129;
   $130 = $58;
   $57 = $130;
   $131 = $57;
   $132 = $59;
   $51 = $132;
   $133 = $51;
   $134 = $60;
   $52 = $134;
   $135 = $52;
   $53 = $131;
   $54 = $133;
   $55 = $135;
   $136 = $54;
   $137 = $53;
   $138 = $136;
   $139 = $137;
   $140 = (($138) - ($139))|0;
   $141 = (($140|0) / 4)&-1;
   $56 = $141;
   $142 = $56;
   $143 = ($142>>>0)>(0);
   if ($143) {
    $144 = $56;
    $145 = $55;
    $146 = (0 - ($144))|0;
    $147 = (($145) + ($146<<2)|0);
    $55 = $147;
    $148 = $55;
    $149 = $53;
    $150 = $56;
    $151 = $150<<2;
    _memmove(($148|0),($149|0),($151|0))|0;
   }
   $152 = $55;
   $153 = ((($95)) + 4|0);
   HEAP32[$153>>2] = $152;
   $154 = $88;
   $155 = ((($95)) + 8|0);
   $156 = HEAP32[$155>>2]|0;
   $157 = (($156) + ($154<<2)|0);
   HEAP32[$155>>2] = $157;
  }
 } while(0);
 $66 = $95;
 $250 = $66;
 $251 = ((($250)) + 12|0);
 $65 = $251;
 $252 = $65;
 $64 = $252;
 $253 = $64;
 $254 = ((($95)) + 4|0);
 $255 = HEAP32[$254>>2]|0;
 $256 = ((($255)) + -4|0);
 $67 = $256;
 $257 = $67;
 $258 = $87;
 $68 = $258;
 $259 = $68;
 $79 = $253;
 $80 = $257;
 $81 = $259;
 $260 = $79;
 $261 = $80;
 $262 = $81;
 $78 = $262;
 $263 = $78;
 ;HEAP8[$77>>0]=HEAP8[$82>>0]|0;
 $74 = $260;
 $75 = $261;
 $76 = $263;
 $264 = $74;
 $265 = $75;
 $266 = $76;
 $73 = $266;
 $267 = $73;
 $70 = $264;
 $71 = $265;
 $72 = $267;
 $268 = $71;
 $269 = $72;
 $69 = $269;
 $270 = $69;
 $271 = HEAP32[$270>>2]|0;
 HEAP32[$268>>2] = $271;
 $272 = ((($95)) + 4|0);
 $273 = HEAP32[$272>>2]|0;
 $274 = ((($273)) + -4|0);
 HEAP32[$272>>2] = $274;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($0,$1,$2,$3) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 $3 = $3|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0;
 var $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0;
 var $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 128|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(128|0);
 $35 = sp;
 $31 = $0;
 $32 = $1;
 $33 = $2;
 $34 = $3;
 $36 = $31;
 $37 = ((($36)) + 12|0);
 HEAP32[$35>>2] = 0;
 $38 = $34;
 $28 = $37;
 $29 = $35;
 $30 = $38;
 $39 = $28;
 $40 = $29;
 $27 = $40;
 $41 = $27;
 $21 = $39;
 $22 = $41;
 $42 = $21;
 $43 = $22;
 $20 = $43;
 HEAP32[$42>>2] = 0;
 $44 = ((($39)) + 4|0);
 $45 = $30;
 $23 = $45;
 $46 = $23;
 $25 = $44;
 $26 = $46;
 $47 = $25;
 $48 = $26;
 $24 = $48;
 $49 = $24;
 HEAP32[$47>>2] = $49;
 $50 = $32;
 $51 = ($50|0)!=(0);
 do {
  if ($51) {
   $6 = $36;
   $52 = $6;
   $53 = ((($52)) + 12|0);
   $5 = $53;
   $54 = $5;
   $55 = ((($54)) + 4|0);
   $4 = $55;
   $56 = $4;
   $57 = HEAP32[$56>>2]|0;
   $58 = $32;
   $15 = $57;
   $16 = $58;
   $59 = $15;
   $60 = $16;
   $12 = $59;
   $13 = $60;
   $14 = 0;
   $61 = $12;
   $62 = $13;
   $11 = $61;
   $63 = ($62>>>0)>(1073741823);
   if ($63) {
    $9 = 4287;
    $64 = (___cxa_allocate_exception(8)|0);
    $65 = $9;
    $7 = $64;
    $8 = $65;
    $66 = $7;
    $67 = $8;
    __ZNSt11logic_errorC2EPKc($66,$67);
    HEAP32[$66>>2] = (3660);
    ___cxa_throw(($64|0),(1384|0),(220|0));
    // unreachable;
   } else {
    $68 = $13;
    $69 = $68<<2;
    $10 = $69;
    $70 = $10;
    $71 = (__Znwj($70)|0);
    $72 = $71;
    break;
   }
  } else {
   $72 = 0;
  }
 } while(0);
 HEAP32[$36>>2] = $72;
 $73 = HEAP32[$36>>2]|0;
 $74 = $33;
 $75 = (($73) + ($74<<2)|0);
 $76 = ((($36)) + 8|0);
 HEAP32[$76>>2] = $75;
 $77 = ((($36)) + 4|0);
 HEAP32[$77>>2] = $75;
 $78 = HEAP32[$36>>2]|0;
 $79 = $32;
 $80 = (($78) + ($79<<2)|0);
 $19 = $36;
 $81 = $19;
 $82 = ((($81)) + 12|0);
 $18 = $82;
 $83 = $18;
 $17 = $83;
 $84 = $17;
 HEAP32[$84>>2] = $80;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE9push_backEOS4_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0;
 var $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0;
 var $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0;
 var $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0;
 var $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 384|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(384|0);
 $$byval_copy1 = sp + 376|0;
 $$byval_copy = sp + 372|0;
 $14 = sp + 8|0;
 $17 = sp + 381|0;
 $23 = sp + 292|0;
 $29 = sp + 268|0;
 $35 = sp + 244|0;
 $47 = sp + 196|0;
 $74 = sp;
 $79 = sp + 380|0;
 $87 = sp + 44|0;
 $88 = sp + 40|0;
 $89 = sp + 20|0;
 $90 = sp + 16|0;
 $91 = sp + 12|0;
 $83 = $0;
 $84 = $1;
 $92 = $83;
 $93 = ((($92)) + 8|0);
 $94 = HEAP32[$93>>2]|0;
 $82 = $92;
 $95 = $82;
 $96 = ((($95)) + 12|0);
 $81 = $96;
 $97 = $81;
 $80 = $97;
 $98 = $80;
 $99 = HEAP32[$98>>2]|0;
 $100 = ($94|0)==($99|0);
 do {
  if ($100) {
   $101 = ((($92)) + 4|0);
   $102 = HEAP32[$101>>2]|0;
   $103 = HEAP32[$92>>2]|0;
   $104 = ($102>>>0)>($103>>>0);
   if (!($104)) {
    $50 = $92;
    $151 = $50;
    $152 = ((($151)) + 12|0);
    $49 = $152;
    $153 = $49;
    $48 = $153;
    $154 = $48;
    $155 = HEAP32[$154>>2]|0;
    $156 = HEAP32[$92>>2]|0;
    $157 = $155;
    $158 = $156;
    $159 = (($157) - ($158))|0;
    $160 = (($159|0) / 4)&-1;
    $161 = $160<<1;
    HEAP32[$87>>2] = $161;
    HEAP32[$88>>2] = 1;
    $15 = $87;
    $16 = $88;
    $162 = $15;
    $163 = $16;
    ;HEAP8[$14>>0]=HEAP8[$17>>0]|0;
    $12 = $162;
    $13 = $163;
    $164 = $12;
    $165 = $13;
    $9 = $14;
    $10 = $164;
    $11 = $165;
    $166 = $10;
    $167 = HEAP32[$166>>2]|0;
    $168 = $11;
    $169 = HEAP32[$168>>2]|0;
    $170 = ($167>>>0)<($169>>>0);
    $171 = $13;
    $172 = $12;
    $173 = $170 ? $171 : $172;
    $174 = HEAP32[$173>>2]|0;
    $86 = $174;
    $175 = $86;
    $176 = $86;
    $177 = (($176>>>0) / 4)&-1;
    $4 = $92;
    $178 = $4;
    $179 = ((($178)) + 12|0);
    $3 = $179;
    $180 = $3;
    $181 = ((($180)) + 4|0);
    $2 = $181;
    $182 = $2;
    $183 = HEAP32[$182>>2]|0;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($89,$175,$177,$183);
    $184 = ((($92)) + 4|0);
    $185 = HEAP32[$184>>2]|0;
    $5 = $90;
    $6 = $185;
    $186 = $5;
    $187 = $6;
    HEAP32[$186>>2] = $187;
    $188 = ((($92)) + 8|0);
    $189 = HEAP32[$188>>2]|0;
    $7 = $91;
    $8 = $189;
    $190 = $7;
    $191 = $8;
    HEAP32[$190>>2] = $191;
    ;HEAP32[$$byval_copy>>2]=HEAP32[$90>>2]|0;
    ;HEAP32[$$byval_copy1>>2]=HEAP32[$91>>2]|0;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($89,$$byval_copy,$$byval_copy1);
    $21 = $92;
    $22 = $89;
    $192 = $21;
    $20 = $192;
    $193 = $20;
    $194 = HEAP32[$193>>2]|0;
    HEAP32[$23>>2] = $194;
    $195 = $22;
    $18 = $195;
    $196 = $18;
    $197 = HEAP32[$196>>2]|0;
    $198 = $21;
    HEAP32[$198>>2] = $197;
    $19 = $23;
    $199 = $19;
    $200 = HEAP32[$199>>2]|0;
    $201 = $22;
    HEAP32[$201>>2] = $200;
    $202 = ((($92)) + 4|0);
    $203 = ((($89)) + 4|0);
    $27 = $202;
    $28 = $203;
    $204 = $27;
    $26 = $204;
    $205 = $26;
    $206 = HEAP32[$205>>2]|0;
    HEAP32[$29>>2] = $206;
    $207 = $28;
    $24 = $207;
    $208 = $24;
    $209 = HEAP32[$208>>2]|0;
    $210 = $27;
    HEAP32[$210>>2] = $209;
    $25 = $29;
    $211 = $25;
    $212 = HEAP32[$211>>2]|0;
    $213 = $28;
    HEAP32[$213>>2] = $212;
    $214 = ((($92)) + 8|0);
    $215 = ((($89)) + 8|0);
    $33 = $214;
    $34 = $215;
    $216 = $33;
    $32 = $216;
    $217 = $32;
    $218 = HEAP32[$217>>2]|0;
    HEAP32[$35>>2] = $218;
    $219 = $34;
    $30 = $219;
    $220 = $30;
    $221 = HEAP32[$220>>2]|0;
    $222 = $33;
    HEAP32[$222>>2] = $221;
    $31 = $35;
    $223 = $31;
    $224 = HEAP32[$223>>2]|0;
    $225 = $34;
    HEAP32[$225>>2] = $224;
    $38 = $92;
    $226 = $38;
    $227 = ((($226)) + 12|0);
    $37 = $227;
    $228 = $37;
    $36 = $228;
    $229 = $36;
    $41 = $89;
    $230 = $41;
    $231 = ((($230)) + 12|0);
    $40 = $231;
    $232 = $40;
    $39 = $232;
    $233 = $39;
    $45 = $229;
    $46 = $233;
    $234 = $45;
    $44 = $234;
    $235 = $44;
    $236 = HEAP32[$235>>2]|0;
    HEAP32[$47>>2] = $236;
    $237 = $46;
    $42 = $237;
    $238 = $42;
    $239 = HEAP32[$238>>2]|0;
    $240 = $45;
    HEAP32[$240>>2] = $239;
    $43 = $47;
    $241 = $43;
    $242 = HEAP32[$241>>2]|0;
    $243 = $46;
    HEAP32[$243>>2] = $242;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($89);
    break;
   }
   $105 = ((($92)) + 4|0);
   $106 = HEAP32[$105>>2]|0;
   $107 = HEAP32[$92>>2]|0;
   $108 = $106;
   $109 = $107;
   $110 = (($108) - ($109))|0;
   $111 = (($110|0) / 4)&-1;
   $85 = $111;
   $112 = $85;
   $113 = (($112) + 1)|0;
   $114 = (($113|0) / 2)&-1;
   $85 = $114;
   $115 = ((($92)) + 4|0);
   $116 = HEAP32[$115>>2]|0;
   $117 = ((($92)) + 8|0);
   $118 = HEAP32[$117>>2]|0;
   $119 = ((($92)) + 4|0);
   $120 = HEAP32[$119>>2]|0;
   $121 = $85;
   $122 = (0 - ($121))|0;
   $123 = (($120) + ($122<<2)|0);
   $58 = $116;
   $59 = $118;
   $60 = $123;
   $124 = $58;
   $57 = $124;
   $125 = $57;
   $126 = $59;
   $51 = $126;
   $127 = $51;
   $128 = $60;
   $52 = $128;
   $129 = $52;
   $53 = $125;
   $54 = $127;
   $55 = $129;
   $130 = $54;
   $131 = $53;
   $132 = $130;
   $133 = $131;
   $134 = (($132) - ($133))|0;
   $135 = (($134|0) / 4)&-1;
   $56 = $135;
   $136 = $56;
   $137 = ($136>>>0)>(0);
   if ($137) {
    $138 = $55;
    $139 = $53;
    $140 = $56;
    $141 = $140<<2;
    _memmove(($138|0),($139|0),($141|0))|0;
   }
   $142 = $55;
   $143 = $56;
   $144 = (($142) + ($143<<2)|0);
   $145 = ((($92)) + 8|0);
   HEAP32[$145>>2] = $144;
   $146 = $85;
   $147 = ((($92)) + 4|0);
   $148 = HEAP32[$147>>2]|0;
   $149 = (0 - ($146))|0;
   $150 = (($148) + ($149<<2)|0);
   HEAP32[$147>>2] = $150;
  }
 } while(0);
 $63 = $92;
 $244 = $63;
 $245 = ((($244)) + 12|0);
 $62 = $245;
 $246 = $62;
 $247 = ((($246)) + 4|0);
 $61 = $247;
 $248 = $61;
 $249 = HEAP32[$248>>2]|0;
 $250 = ((($92)) + 8|0);
 $251 = HEAP32[$250>>2]|0;
 $64 = $251;
 $252 = $64;
 $253 = $84;
 $65 = $253;
 $254 = $65;
 $76 = $249;
 $77 = $252;
 $78 = $254;
 $255 = $76;
 $256 = $77;
 $257 = $78;
 $75 = $257;
 $258 = $75;
 ;HEAP8[$74>>0]=HEAP8[$79>>0]|0;
 $71 = $255;
 $72 = $256;
 $73 = $258;
 $259 = $71;
 $260 = $72;
 $261 = $73;
 $70 = $261;
 $262 = $70;
 $67 = $259;
 $68 = $260;
 $69 = $262;
 $263 = $68;
 $264 = $69;
 $66 = $264;
 $265 = $66;
 $266 = HEAP32[$265>>2]|0;
 HEAP32[$263>>2] = $266;
 $267 = ((($92)) + 8|0);
 $268 = HEAP32[$267>>2]|0;
 $269 = ((($268)) + 4|0);
 HEAP32[$267>>2] = $269;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE10push_frontERKS4_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $$byval_copy1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0;
 var $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0;
 var $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0;
 var $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0;
 var $170 = 0, $171 = 0, $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0;
 var $189 = 0, $19 = 0, $190 = 0, $191 = 0, $192 = 0, $193 = 0, $194 = 0, $195 = 0, $196 = 0, $197 = 0, $198 = 0, $199 = 0, $2 = 0, $20 = 0, $200 = 0, $201 = 0, $202 = 0, $203 = 0, $204 = 0, $205 = 0;
 var $206 = 0, $207 = 0, $208 = 0, $209 = 0, $21 = 0, $210 = 0, $211 = 0, $212 = 0, $213 = 0, $214 = 0, $215 = 0, $216 = 0, $217 = 0, $218 = 0, $219 = 0, $22 = 0, $220 = 0, $221 = 0, $222 = 0, $223 = 0;
 var $224 = 0, $225 = 0, $226 = 0, $227 = 0, $228 = 0, $229 = 0, $23 = 0, $230 = 0, $231 = 0, $232 = 0, $233 = 0, $234 = 0, $235 = 0, $236 = 0, $237 = 0, $238 = 0, $239 = 0, $24 = 0, $240 = 0, $241 = 0;
 var $242 = 0, $243 = 0, $244 = 0, $245 = 0, $246 = 0, $247 = 0, $248 = 0, $249 = 0, $25 = 0, $250 = 0, $251 = 0, $252 = 0, $253 = 0, $254 = 0, $255 = 0, $256 = 0, $257 = 0, $258 = 0, $259 = 0, $26 = 0;
 var $260 = 0, $261 = 0, $262 = 0, $263 = 0, $264 = 0, $265 = 0, $266 = 0, $267 = 0, $268 = 0, $269 = 0, $27 = 0, $270 = 0, $271 = 0, $272 = 0, $273 = 0, $274 = 0, $275 = 0, $276 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0;
 var $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 400|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(400|0);
 $$byval_copy1 = sp + 384|0;
 $$byval_copy = sp + 380|0;
 $10 = sp + 8|0;
 $13 = sp + 389|0;
 $26 = sp + 288|0;
 $32 = sp + 264|0;
 $38 = sp + 240|0;
 $50 = sp + 192|0;
 $76 = sp;
 $81 = sp + 388|0;
 $89 = sp + 44|0;
 $90 = sp + 40|0;
 $91 = sp + 20|0;
 $92 = sp + 16|0;
 $93 = sp + 12|0;
 $85 = $0;
 $86 = $1;
 $94 = $85;
 $95 = ((($94)) + 4|0);
 $96 = HEAP32[$95>>2]|0;
 $97 = HEAP32[$94>>2]|0;
 $98 = ($96|0)==($97|0);
 do {
  if ($98) {
   $99 = ((($94)) + 8|0);
   $100 = HEAP32[$99>>2]|0;
   $84 = $94;
   $101 = $84;
   $102 = ((($101)) + 12|0);
   $83 = $102;
   $103 = $83;
   $82 = $103;
   $104 = $82;
   $105 = HEAP32[$104>>2]|0;
   $106 = ($100>>>0)<($105>>>0);
   if (!($106)) {
    $20 = $94;
    $157 = $20;
    $158 = ((($157)) + 12|0);
    $19 = $158;
    $159 = $19;
    $18 = $159;
    $160 = $18;
    $161 = HEAP32[$160>>2]|0;
    $162 = HEAP32[$94>>2]|0;
    $163 = $161;
    $164 = $162;
    $165 = (($163) - ($164))|0;
    $166 = (($165|0) / 4)&-1;
    $167 = $166<<1;
    HEAP32[$89>>2] = $167;
    HEAP32[$90>>2] = 1;
    $11 = $89;
    $12 = $90;
    $168 = $11;
    $169 = $12;
    ;HEAP8[$10>>0]=HEAP8[$13>>0]|0;
    $8 = $168;
    $9 = $169;
    $170 = $8;
    $171 = $9;
    $5 = $10;
    $6 = $170;
    $7 = $171;
    $172 = $6;
    $173 = HEAP32[$172>>2]|0;
    $174 = $7;
    $175 = HEAP32[$174>>2]|0;
    $176 = ($173>>>0)<($175>>>0);
    $177 = $9;
    $178 = $8;
    $179 = $176 ? $177 : $178;
    $180 = HEAP32[$179>>2]|0;
    $88 = $180;
    $181 = $88;
    $182 = $88;
    $183 = (($182) + 3)|0;
    $184 = (($183>>>0) / 4)&-1;
    $4 = $94;
    $185 = $4;
    $186 = ((($185)) + 12|0);
    $3 = $186;
    $187 = $3;
    $188 = ((($187)) + 4|0);
    $2 = $188;
    $189 = $2;
    $190 = HEAP32[$189>>2]|0;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEEC2EjjS7_($91,$181,$184,$190);
    $191 = ((($94)) + 4|0);
    $192 = HEAP32[$191>>2]|0;
    $14 = $92;
    $15 = $192;
    $193 = $14;
    $194 = $15;
    HEAP32[$193>>2] = $194;
    $195 = ((($94)) + 8|0);
    $196 = HEAP32[$195>>2]|0;
    $16 = $93;
    $17 = $196;
    $197 = $16;
    $198 = $17;
    HEAP32[$197>>2] = $198;
    ;HEAP32[$$byval_copy>>2]=HEAP32[$92>>2]|0;
    ;HEAP32[$$byval_copy1>>2]=HEAP32[$93>>2]|0;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($91,$$byval_copy,$$byval_copy1);
    $24 = $94;
    $25 = $91;
    $199 = $24;
    $23 = $199;
    $200 = $23;
    $201 = HEAP32[$200>>2]|0;
    HEAP32[$26>>2] = $201;
    $202 = $25;
    $21 = $202;
    $203 = $21;
    $204 = HEAP32[$203>>2]|0;
    $205 = $24;
    HEAP32[$205>>2] = $204;
    $22 = $26;
    $206 = $22;
    $207 = HEAP32[$206>>2]|0;
    $208 = $25;
    HEAP32[$208>>2] = $207;
    $209 = ((($94)) + 4|0);
    $210 = ((($91)) + 4|0);
    $30 = $209;
    $31 = $210;
    $211 = $30;
    $29 = $211;
    $212 = $29;
    $213 = HEAP32[$212>>2]|0;
    HEAP32[$32>>2] = $213;
    $214 = $31;
    $27 = $214;
    $215 = $27;
    $216 = HEAP32[$215>>2]|0;
    $217 = $30;
    HEAP32[$217>>2] = $216;
    $28 = $32;
    $218 = $28;
    $219 = HEAP32[$218>>2]|0;
    $220 = $31;
    HEAP32[$220>>2] = $219;
    $221 = ((($94)) + 8|0);
    $222 = ((($91)) + 8|0);
    $36 = $221;
    $37 = $222;
    $223 = $36;
    $35 = $223;
    $224 = $35;
    $225 = HEAP32[$224>>2]|0;
    HEAP32[$38>>2] = $225;
    $226 = $37;
    $33 = $226;
    $227 = $33;
    $228 = HEAP32[$227>>2]|0;
    $229 = $36;
    HEAP32[$229>>2] = $228;
    $34 = $38;
    $230 = $34;
    $231 = HEAP32[$230>>2]|0;
    $232 = $37;
    HEAP32[$232>>2] = $231;
    $41 = $94;
    $233 = $41;
    $234 = ((($233)) + 12|0);
    $40 = $234;
    $235 = $40;
    $39 = $235;
    $236 = $39;
    $44 = $91;
    $237 = $44;
    $238 = ((($237)) + 12|0);
    $43 = $238;
    $239 = $43;
    $42 = $239;
    $240 = $42;
    $48 = $236;
    $49 = $240;
    $241 = $48;
    $47 = $241;
    $242 = $47;
    $243 = HEAP32[$242>>2]|0;
    HEAP32[$50>>2] = $243;
    $244 = $49;
    $45 = $244;
    $245 = $45;
    $246 = HEAP32[$245>>2]|0;
    $247 = $48;
    HEAP32[$247>>2] = $246;
    $46 = $50;
    $248 = $46;
    $249 = HEAP32[$248>>2]|0;
    $250 = $49;
    HEAP32[$250>>2] = $249;
    __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($91);
    break;
   }
   $63 = $94;
   $107 = $63;
   $108 = ((($107)) + 12|0);
   $62 = $108;
   $109 = $62;
   $61 = $109;
   $110 = $61;
   $111 = HEAP32[$110>>2]|0;
   $112 = ((($94)) + 8|0);
   $113 = HEAP32[$112>>2]|0;
   $114 = $111;
   $115 = $113;
   $116 = (($114) - ($115))|0;
   $117 = (($116|0) / 4)&-1;
   $87 = $117;
   $118 = $87;
   $119 = (($118) + 1)|0;
   $120 = (($119|0) / 2)&-1;
   $87 = $120;
   $121 = ((($94)) + 4|0);
   $122 = HEAP32[$121>>2]|0;
   $123 = ((($94)) + 8|0);
   $124 = HEAP32[$123>>2]|0;
   $125 = ((($94)) + 8|0);
   $126 = HEAP32[$125>>2]|0;
   $127 = $87;
   $128 = (($126) + ($127<<2)|0);
   $58 = $122;
   $59 = $124;
   $60 = $128;
   $129 = $58;
   $57 = $129;
   $130 = $57;
   $131 = $59;
   $51 = $131;
   $132 = $51;
   $133 = $60;
   $52 = $133;
   $134 = $52;
   $53 = $130;
   $54 = $132;
   $55 = $134;
   $135 = $54;
   $136 = $53;
   $137 = $135;
   $138 = $136;
   $139 = (($137) - ($138))|0;
   $140 = (($139|0) / 4)&-1;
   $56 = $140;
   $141 = $56;
   $142 = ($141>>>0)>(0);
   if ($142) {
    $143 = $56;
    $144 = $55;
    $145 = (0 - ($143))|0;
    $146 = (($144) + ($145<<2)|0);
    $55 = $146;
    $147 = $55;
    $148 = $53;
    $149 = $56;
    $150 = $149<<2;
    _memmove(($147|0),($148|0),($150|0))|0;
   }
   $151 = $55;
   $152 = ((($94)) + 4|0);
   HEAP32[$152>>2] = $151;
   $153 = $87;
   $154 = ((($94)) + 8|0);
   $155 = HEAP32[$154>>2]|0;
   $156 = (($155) + ($153<<2)|0);
   HEAP32[$154>>2] = $156;
  }
 } while(0);
 $66 = $94;
 $251 = $66;
 $252 = ((($251)) + 12|0);
 $65 = $252;
 $253 = $65;
 $254 = ((($253)) + 4|0);
 $64 = $254;
 $255 = $64;
 $256 = HEAP32[$255>>2]|0;
 $257 = ((($94)) + 4|0);
 $258 = HEAP32[$257>>2]|0;
 $259 = ((($258)) + -4|0);
 $67 = $259;
 $260 = $67;
 $261 = $86;
 $78 = $256;
 $79 = $260;
 $80 = $261;
 $262 = $78;
 $263 = $79;
 $264 = $80;
 $77 = $264;
 $265 = $77;
 ;HEAP8[$76>>0]=HEAP8[$81>>0]|0;
 $73 = $262;
 $74 = $263;
 $75 = $265;
 $266 = $73;
 $267 = $74;
 $268 = $75;
 $72 = $268;
 $269 = $72;
 $69 = $266;
 $70 = $267;
 $71 = $269;
 $270 = $70;
 $271 = $71;
 $68 = $271;
 $272 = $68;
 $273 = HEAP32[$272>>2]|0;
 HEAP32[$270>>2] = $273;
 $274 = ((($94)) + 4|0);
 $275 = HEAP32[$274>>2]|0;
 $276 = ((($275)) + -4|0);
 HEAP32[$274>>2] = $276;
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0;
 var $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0;
 var $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0;
 var $82 = 0, $83 = 0, $84 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 144|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(144|0);
 $19 = sp + 8|0;
 $22 = sp + 133|0;
 $29 = sp;
 $32 = sp + 132|0;
 $34 = $0;
 $35 = $34;
 $33 = $35;
 $36 = $33;
 $37 = ((($36)) + 4|0);
 $38 = HEAP32[$37>>2]|0;
 $30 = $36;
 $31 = $38;
 $39 = $30;
 $40 = $31;
 ;HEAP8[$29>>0]=HEAP8[$32>>0]|0;
 $27 = $39;
 $28 = $40;
 $41 = $27;
 while(1) {
  $42 = $28;
  $43 = ((($41)) + 8|0);
  $44 = HEAP32[$43>>2]|0;
  $45 = ($42|0)!=($44|0);
  if (!($45)) {
   break;
  }
  $26 = $41;
  $46 = $26;
  $47 = ((($46)) + 12|0);
  $25 = $47;
  $48 = $25;
  $49 = ((($48)) + 4|0);
  $24 = $49;
  $50 = $24;
  $51 = HEAP32[$50>>2]|0;
  $52 = ((($41)) + 8|0);
  $53 = HEAP32[$52>>2]|0;
  $54 = ((($53)) + -4|0);
  HEAP32[$52>>2] = $54;
  $23 = $54;
  $55 = $23;
  $20 = $51;
  $21 = $55;
  $56 = $20;
  $57 = $21;
  ;HEAP8[$19>>0]=HEAP8[$22>>0]|0;
  $17 = $56;
  $18 = $57;
  $58 = $17;
  $59 = $18;
  $15 = $58;
  $16 = $59;
 }
 $60 = HEAP32[$35>>2]|0;
 $61 = ($60|0)!=(0|0);
 if (!($61)) {
  STACKTOP = sp;return;
 }
 $14 = $35;
 $62 = $14;
 $63 = ((($62)) + 12|0);
 $13 = $63;
 $64 = $13;
 $65 = ((($64)) + 4|0);
 $12 = $65;
 $66 = $12;
 $67 = HEAP32[$66>>2]|0;
 $68 = HEAP32[$35>>2]|0;
 $4 = $35;
 $69 = $4;
 $3 = $69;
 $70 = $3;
 $71 = ((($70)) + 12|0);
 $2 = $71;
 $72 = $2;
 $1 = $72;
 $73 = $1;
 $74 = HEAP32[$73>>2]|0;
 $75 = HEAP32[$69>>2]|0;
 $76 = $74;
 $77 = $75;
 $78 = (($76) - ($77))|0;
 $79 = (($78|0) / 4)&-1;
 $9 = $67;
 $10 = $68;
 $11 = $79;
 $80 = $9;
 $81 = $10;
 $82 = $11;
 $6 = $80;
 $7 = $81;
 $8 = $82;
 $83 = $7;
 $5 = $83;
 $84 = $5;
 __ZdlPv($84);
 STACKTOP = sp;return;
}
function __ZNSt3__214__split_bufferIPN6laszip6models10arithmeticERNS_9allocatorIS4_EEE18__construct_at_endINS_13move_iteratorIPS4_EEEENS_9enable_ifIXsr21__is_forward_iteratorIT_EE5valueEvE4typeESE_SE_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0;
 var $66 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 112|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(112|0);
 $17 = sp;
 $22 = sp + 100|0;
 $27 = $0;
 $29 = $27;
 $26 = $29;
 $30 = $26;
 $31 = ((($30)) + 12|0);
 $25 = $31;
 $32 = $25;
 $33 = ((($32)) + 4|0);
 $24 = $33;
 $34 = $24;
 $35 = HEAP32[$34>>2]|0;
 $28 = $35;
 while(1) {
  $5 = $1;
  $6 = $2;
  $36 = $5;
  $4 = $36;
  $37 = $4;
  $38 = HEAP32[$37>>2]|0;
  $39 = $6;
  $3 = $39;
  $40 = $3;
  $41 = HEAP32[$40>>2]|0;
  $42 = ($38|0)!=($41|0);
  if (!($42)) {
   break;
  }
  $43 = $28;
  $44 = ((($29)) + 8|0);
  $45 = HEAP32[$44>>2]|0;
  $7 = $45;
  $46 = $7;
  $8 = $1;
  $47 = $8;
  $48 = HEAP32[$47>>2]|0;
  $19 = $43;
  $20 = $46;
  $21 = $48;
  $49 = $19;
  $50 = $20;
  $51 = $21;
  $18 = $51;
  $52 = $18;
  ;HEAP8[$17>>0]=HEAP8[$22>>0]|0;
  $14 = $49;
  $15 = $50;
  $16 = $52;
  $53 = $14;
  $54 = $15;
  $55 = $16;
  $13 = $55;
  $56 = $13;
  $10 = $53;
  $11 = $54;
  $12 = $56;
  $57 = $11;
  $58 = $12;
  $9 = $58;
  $59 = $9;
  $60 = HEAP32[$59>>2]|0;
  HEAP32[$57>>2] = $60;
  $61 = ((($29)) + 8|0);
  $62 = HEAP32[$61>>2]|0;
  $63 = ((($62)) + 4|0);
  HEAP32[$61>>2] = $63;
  $23 = $1;
  $64 = $23;
  $65 = HEAP32[$64>>2]|0;
  $66 = ((($65)) + 4|0);
  HEAP32[$64>>2] = $66;
 }
 STACKTOP = sp;return;
}
function __ZNKSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5beginEv($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $7 = $1;
 $9 = $7;
 $6 = $9;
 $10 = $6;
 $11 = ((($10)) + 4|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($9)) + 16|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = (($14>>>0) / 93)&-1;
 $16 = (($12) + ($15<<2)|0);
 $8 = $16;
 $17 = $8;
 $5 = $9;
 $18 = $5;
 $19 = ((($18)) + 8|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = ((($18)) + 4|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = ($20|0)==($22|0);
 if ($23) {
  $30 = 0;
 } else {
  $24 = $8;
  $25 = HEAP32[$24>>2]|0;
  $26 = ((($9)) + 16|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = (($27>>>0) % 93)&-1;
  $29 = (($25) + (($28*44)|0)|0);
  $30 = $29;
 }
 $2 = $0;
 $3 = $17;
 $4 = $30;
 $31 = $2;
 $32 = $3;
 HEAP32[$31>>2] = $32;
 $33 = ((($31)) + 4|0);
 $34 = $4;
 HEAP32[$33>>2] = $34;
 STACKTOP = sp;return;
}
function __ZNKSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE3endEv($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $5 = 0, $6 = 0;
 var $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = $1;
 $13 = $10;
 $9 = $13;
 $14 = $9;
 $15 = ((($14)) + 20|0);
 $8 = $15;
 $16 = $8;
 $7 = $16;
 $17 = $7;
 $18 = HEAP32[$17>>2]|0;
 $19 = ((($13)) + 16|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = (($18) + ($20))|0;
 $11 = $21;
 $6 = $13;
 $22 = $6;
 $23 = ((($22)) + 4|0);
 $24 = HEAP32[$23>>2]|0;
 $25 = $11;
 $26 = (($25>>>0) / 93)&-1;
 $27 = (($24) + ($26<<2)|0);
 $12 = $27;
 $28 = $12;
 $2 = $13;
 $29 = $2;
 $30 = ((($29)) + 8|0);
 $31 = HEAP32[$30>>2]|0;
 $32 = ((($29)) + 4|0);
 $33 = HEAP32[$32>>2]|0;
 $34 = ($31|0)==($33|0);
 if ($34) {
  $40 = 0;
  $3 = $0;
  $4 = $28;
  $5 = $40;
  $41 = $3;
  $42 = $4;
  HEAP32[$41>>2] = $42;
  $43 = ((($41)) + 4|0);
  $44 = $5;
  HEAP32[$43>>2] = $44;
  STACKTOP = sp;return;
 }
 $35 = $12;
 $36 = HEAP32[$35>>2]|0;
 $37 = $11;
 $38 = (($37>>>0) % 93)&-1;
 $39 = (($36) + (($38*44)|0)|0);
 $40 = $39;
 $3 = $0;
 $4 = $28;
 $5 = $40;
 $41 = $3;
 $42 = $4;
 HEAP32[$41>>2] = $42;
 $43 = ((($41)) + 4|0);
 $44 = $5;
 HEAP32[$43>>2] = $44;
 STACKTOP = sp;return;
}
function __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5clearEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0;
 var $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0;
 var $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0;
 var $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0;
 var $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 192|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(192|0);
 $6 = sp + 8|0;
 $9 = sp + 177|0;
 $26 = sp;
 $29 = sp + 176|0;
 $41 = sp + 24|0;
 $42 = sp + 16|0;
 $39 = $0;
 $43 = $39;
 $38 = $43;
 $44 = $38;
 $45 = ((($44)) + 20|0);
 $37 = $45;
 $46 = $37;
 $36 = $46;
 $47 = $36;
 $40 = $47;
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5beginEv($41,$43);
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE3endEv($42,$43);
 while(1) {
  $34 = $41;
  $35 = $42;
  $48 = $34;
  $49 = $35;
  $32 = $48;
  $33 = $49;
  $50 = $32;
  $51 = ((($50)) + 4|0);
  $52 = HEAP32[$51>>2]|0;
  $53 = $33;
  $54 = ((($53)) + 4|0);
  $55 = HEAP32[$54>>2]|0;
  $56 = ($52|0)==($55|0);
  $57 = $56 ^ 1;
  if (!($57)) {
   break;
  }
  $58 = $40;
  $16 = $41;
  $59 = $16;
  $60 = ((($59)) + 4|0);
  $61 = HEAP32[$60>>2]|0;
  $1 = $61;
  $62 = $1;
  $7 = $58;
  $8 = $62;
  $63 = $7;
  $64 = $8;
  ;HEAP8[$6>>0]=HEAP8[$9>>0]|0;
  $4 = $63;
  $5 = $64;
  $65 = $4;
  $66 = $5;
  $2 = $65;
  $3 = $66;
  $67 = $3;
  __ZN6laszip6models10arithmeticD2Ev($67);
  $10 = $41;
  $68 = $10;
  $69 = ((($68)) + 4|0);
  $70 = HEAP32[$69>>2]|0;
  $71 = ((($70)) + 44|0);
  HEAP32[$69>>2] = $71;
  $72 = HEAP32[$68>>2]|0;
  $73 = HEAP32[$72>>2]|0;
  $74 = $71;
  $75 = $73;
  $76 = (($74) - ($75))|0;
  $77 = (($76|0) / 44)&-1;
  $78 = ($77|0)==(93);
  if ($78) {
   $79 = HEAP32[$68>>2]|0;
   $80 = ((($79)) + 4|0);
   HEAP32[$68>>2] = $80;
   $81 = HEAP32[$68>>2]|0;
   $82 = HEAP32[$81>>2]|0;
   $83 = ((($68)) + 4|0);
   HEAP32[$83>>2] = $82;
  }
 }
 $13 = $43;
 $84 = $13;
 $85 = ((($84)) + 20|0);
 $12 = $85;
 $86 = $12;
 $11 = $86;
 $87 = $11;
 HEAP32[$87>>2] = 0;
 while(1) {
  $14 = $43;
  $88 = $14;
  $89 = ((($88)) + 8|0);
  $90 = HEAP32[$89>>2]|0;
  $91 = ((($88)) + 4|0);
  $92 = HEAP32[$91>>2]|0;
  $93 = $90;
  $94 = $92;
  $95 = (($93) - ($94))|0;
  $96 = (($95|0) / 4)&-1;
  $97 = ($96>>>0)>(2);
  if (!($97)) {
   break;
  }
  $98 = $40;
  $15 = $43;
  $99 = $15;
  $100 = ((($99)) + 4|0);
  $101 = HEAP32[$100>>2]|0;
  $102 = HEAP32[$101>>2]|0;
  $21 = $98;
  $22 = $102;
  $23 = 93;
  $103 = $21;
  $104 = $22;
  $105 = $23;
  $18 = $103;
  $19 = $104;
  $20 = $105;
  $106 = $19;
  $17 = $106;
  $107 = $17;
  __ZdlPv($107);
  $30 = $43;
  $108 = $30;
  $109 = ((($108)) + 4|0);
  $110 = HEAP32[$109>>2]|0;
  $111 = ((($110)) + 4|0);
  $27 = $108;
  $28 = $111;
  $112 = $27;
  $113 = $28;
  ;HEAP8[$26>>0]=HEAP8[$29>>0]|0;
  $24 = $112;
  $25 = $113;
  $114 = $24;
  $115 = $25;
  $116 = ((($114)) + 4|0);
  HEAP32[$116>>2] = $115;
 }
 $31 = $43;
 $117 = $31;
 $118 = ((($117)) + 8|0);
 $119 = HEAP32[$118>>2]|0;
 $120 = ((($117)) + 4|0);
 $121 = HEAP32[$120>>2]|0;
 $122 = $119;
 $123 = $121;
 $124 = (($122) - ($123))|0;
 $125 = (($124|0) / 4)&-1;
 switch ($125|0) {
 case 1:  {
  $126 = ((($43)) + 16|0);
  HEAP32[$126>>2] = 46;
  STACKTOP = sp;return;
  break;
 }
 case 2:  {
  $127 = ((($43)) + 16|0);
  HEAP32[$127>>2] = 93;
  STACKTOP = sp;return;
  break;
 }
 default: {
  STACKTOP = sp;return;
 }
 }
}
function __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5beginEv($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $7 = $1;
 $9 = $7;
 $6 = $9;
 $10 = $6;
 $11 = ((($10)) + 4|0);
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($9)) + 16|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = (($14>>>0) / 93)&-1;
 $16 = (($12) + ($15<<2)|0);
 $8 = $16;
 $17 = $8;
 $5 = $9;
 $18 = $5;
 $19 = ((($18)) + 8|0);
 $20 = HEAP32[$19>>2]|0;
 $21 = ((($18)) + 4|0);
 $22 = HEAP32[$21>>2]|0;
 $23 = ($20|0)==($22|0);
 if ($23) {
  $30 = 0;
 } else {
  $24 = $8;
  $25 = HEAP32[$24>>2]|0;
  $26 = ((($9)) + 16|0);
  $27 = HEAP32[$26>>2]|0;
  $28 = (($27>>>0) % 93)&-1;
  $29 = (($25) + (($28*44)|0)|0);
  $30 = $29;
 }
 $2 = $0;
 $3 = $17;
 $4 = $30;
 $31 = $2;
 $32 = $3;
 HEAP32[$31>>2] = $32;
 $33 = ((($31)) + 4|0);
 $34 = $4;
 HEAP32[$33>>2] = $34;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats5fieldINS0_3las10extrabytesENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0, $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0;
 var $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $165 = 0, $166 = 0, $167 = 0, $168 = 0, $169 = 0, $17 = 0, $170 = 0, $171 = 0;
 var $172 = 0, $173 = 0, $174 = 0, $175 = 0, $176 = 0, $177 = 0, $178 = 0, $179 = 0, $18 = 0, $180 = 0, $181 = 0, $182 = 0, $183 = 0, $184 = 0, $185 = 0, $186 = 0, $187 = 0, $188 = 0, $189 = 0, $19 = 0;
 var $190 = 0, $191 = 0, $192 = 0, $193 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0;
 var $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0;
 var $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0;
 var $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0;
 var $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 288|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(288|0);
 $5 = sp + 268|0;
 $8 = sp + 256|0;
 $13 = sp + 236|0;
 $16 = sp + 224|0;
 $28 = sp + 176|0;
 $31 = sp + 164|0;
 $46 = sp + 104|0;
 $50 = sp + 88|0;
 $63 = sp + 36|0;
 $64 = sp + 32|0;
 $65 = sp + 24|0;
 $66 = sp + 16|0;
 $67 = sp + 12|0;
 $68 = sp + 8|0;
 $69 = sp;
 $59 = $0;
 $60 = $1;
 $61 = $2;
 $70 = $59;
 $71 = ((($70)) + 4|0);
 $72 = HEAP8[$71>>0]|0;
 $73 = $72&1;
 if (!($73)) {
  $74 = $60;
  $75 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE11getInStreamEv($74)|0);
  $76 = $61;
  $77 = HEAP32[$70>>2]|0;
  __ZN6laszip2io18__ifstream_wrapperINS_7streams13memory_streamEE8getBytesEPhj($75,$76,$77);
  $78 = $61;
  $79 = $61;
  $80 = HEAP32[$70>>2]|0;
  $81 = (($79) + ($80)|0);
  $82 = ((($70)) + 8|0);
  $57 = $82;
  $83 = $57;
  $84 = HEAP32[$83>>2]|0;
  $56 = $84;
  $85 = $56;
  $39 = $78;
  $40 = $81;
  $41 = $85;
  $86 = $39;
  $38 = $86;
  $87 = $38;
  $88 = $40;
  $33 = $88;
  $89 = $33;
  $90 = $41;
  $34 = $90;
  $91 = $34;
  $35 = $87;
  $36 = $89;
  $37 = $91;
  while(1) {
   $92 = $35;
   $93 = $36;
   $94 = ($92|0)!=($93|0);
   if (!($94)) {
    break;
   }
   $95 = $35;
   $96 = HEAP8[$95>>0]|0;
   $97 = $37;
   HEAP8[$97>>0] = $96;
   $98 = $35;
   $99 = ((($98)) + 1|0);
   $35 = $99;
   $100 = $37;
   $101 = ((($100)) + 1|0);
   $37 = $101;
  }
  $102 = ((($70)) + 4|0);
  HEAP8[$102>>0] = 1;
  $103 = $61;
  $104 = HEAP32[$70>>2]|0;
  $105 = (($103) + ($104)|0);
  $58 = $105;
  $193 = $58;
  STACKTOP = sp;return ($193|0);
 }
 $106 = ((($70)) + 20|0);
 $62 = $106;
 $107 = $62;
 $32 = $107;
 $108 = $32;
 $109 = HEAP32[$108>>2]|0;
 $29 = $108;
 $30 = $109;
 $110 = $30;
 $26 = $28;
 $27 = $110;
 $111 = $26;
 $112 = $27;
 HEAP32[$111>>2] = $112;
 $113 = HEAP32[$28>>2]|0;
 HEAP32[$31>>2] = $113;
 $114 = HEAP32[$31>>2]|0;
 HEAP32[$63>>2] = $114;
 $115 = ((($70)) + 8|0);
 $9 = $115;
 $116 = $9;
 $117 = HEAP32[$116>>2]|0;
 $6 = $116;
 $7 = $117;
 $118 = $7;
 $3 = $5;
 $4 = $118;
 $119 = $3;
 $120 = $4;
 HEAP32[$119>>2] = $120;
 $121 = HEAP32[$5>>2]|0;
 HEAP32[$8>>2] = $121;
 $122 = HEAP32[$8>>2]|0;
 HEAP32[$64>>2] = $122;
 $123 = ((($70)) + 32|0);
 $10 = $123;
 $124 = $10;
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE5beginEv($65,$124);
 while(1) {
  $125 = ((($70)) + 8|0);
  $17 = $125;
  $126 = $17;
  $127 = ((($126)) + 4|0);
  $128 = HEAP32[$127>>2]|0;
  $14 = $126;
  $15 = $128;
  $129 = $15;
  $11 = $13;
  $12 = $129;
  $130 = $11;
  $131 = $12;
  HEAP32[$130>>2] = $131;
  $132 = HEAP32[$13>>2]|0;
  HEAP32[$16>>2] = $132;
  $133 = HEAP32[$16>>2]|0;
  HEAP32[$66>>2] = $133;
  $22 = $64;
  $23 = $66;
  $134 = $22;
  $135 = $23;
  $20 = $134;
  $21 = $135;
  $136 = $20;
  $19 = $136;
  $137 = $19;
  $138 = HEAP32[$137>>2]|0;
  $139 = $21;
  $18 = $139;
  $140 = $18;
  $141 = HEAP32[$140>>2]|0;
  $142 = ($138|0)==($141|0);
  $143 = $142 ^ 1;
  if (!($143)) {
   break;
  }
  $24 = $64;
  $144 = $24;
  $145 = HEAP32[$144>>2]|0;
  $146 = HEAP8[$145>>0]|0;
  $147 = $146&255;
  $148 = $60;
  $25 = $65;
  $149 = $25;
  $150 = ((($149)) + 4|0);
  $151 = HEAP32[$150>>2]|0;
  $152 = (__ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE12decodeSymbolINS_6models10arithmeticEEEjRT_($148,$151)|0);
  $153 = (($147) + ($152))|0;
  $154 = (__Z7u8_foldi($153)|0);
  $42 = $63;
  $155 = $42;
  $156 = HEAP32[$155>>2]|0;
  HEAP8[$156>>0] = $154;
  $43 = $63;
  $157 = $43;
  $158 = HEAP32[$157>>2]|0;
  $159 = HEAP8[$158>>0]|0;
  $160 = $61;
  HEAP8[$160>>0] = $159;
  $44 = $64;
  $161 = $44;
  $162 = HEAP32[$161>>2]|0;
  HEAP8[$162>>0] = $159;
  $47 = $64;
  $48 = 0;
  $163 = $47;
  ;HEAP32[$46>>2]=HEAP32[$163>>2]|0;
  $45 = $163;
  $164 = $45;
  $165 = HEAP32[$164>>2]|0;
  $166 = ((($165)) + 1|0);
  HEAP32[$164>>2] = $166;
  $167 = HEAP32[$46>>2]|0;
  HEAP32[$67>>2] = $167;
  $168 = $61;
  $169 = ((($168)) + 1|0);
  $61 = $169;
  $51 = $63;
  $52 = 0;
  $170 = $51;
  ;HEAP32[$50>>2]=HEAP32[$170>>2]|0;
  $49 = $170;
  $171 = $49;
  $172 = HEAP32[$171>>2]|0;
  $173 = ((($172)) + 1|0);
  HEAP32[$171>>2] = $173;
  $174 = HEAP32[$50>>2]|0;
  HEAP32[$68>>2] = $174;
  $54 = $65;
  $55 = 0;
  $175 = $54;
  ;HEAP32[$69>>2]=HEAP32[$175>>2]|0;HEAP32[$69+4>>2]=HEAP32[$175+4>>2]|0;
  $53 = $175;
  $176 = $53;
  $177 = ((($176)) + 4|0);
  $178 = HEAP32[$177>>2]|0;
  $179 = ((($178)) + 44|0);
  HEAP32[$177>>2] = $179;
  $180 = HEAP32[$176>>2]|0;
  $181 = HEAP32[$180>>2]|0;
  $182 = $179;
  $183 = $181;
  $184 = (($182) - ($183))|0;
  $185 = (($184|0) / 44)&-1;
  $186 = ($185|0)==(93);
  if ($186) {
   $187 = HEAP32[$176>>2]|0;
   $188 = ((($187)) + 4|0);
   HEAP32[$176>>2] = $188;
   $189 = HEAP32[$176>>2]|0;
   $190 = HEAP32[$189>>2]|0;
   $191 = ((($176)) + 4|0);
   HEAP32[$191>>2] = $190;
  }
 }
 $192 = $61;
 $58 = $192;
 $193 = $58;
 STACKTOP = sp;return ($193|0);
}
function __Z7u8_foldi($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = $2&255;
 STACKTOP = sp;return ($3|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 4|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 480;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats26dynamic_decompressor_fieldINS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_5fieldINS2_3las10extrabytesENS2_20standard_diff_methodISE_EEEEEENS_14default_deleteISI_EENS_9allocatorISI_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIhNS_9allocatorIhEEEC2Ej($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $12 = sp + 8|0;
 $13 = $0;
 $14 = $1;
 $15 = $13;
 $11 = $15;
 $16 = $11;
 $10 = $16;
 HEAP32[$16>>2] = 0;
 $17 = ((($16)) + 4|0);
 HEAP32[$17>>2] = 0;
 $18 = ((($16)) + 8|0);
 HEAP32[$12>>2] = 0;
 $8 = $18;
 $9 = $12;
 $19 = $8;
 $20 = $9;
 $7 = $20;
 $21 = $7;
 $3 = $19;
 $4 = $21;
 $22 = $3;
 $23 = $4;
 $2 = $23;
 HEAP32[$22>>2] = 0;
 $6 = $19;
 $24 = $6;
 $5 = $24;
 $25 = $14;
 $26 = ($25>>>0)>(0);
 if (!($26)) {
  STACKTOP = sp;return;
 }
 $27 = $14;
 __ZNSt3__26vectorIhNS_9allocatorIhEEE8allocateEj($15,$27);
 $28 = $14;
 __ZNSt3__26vectorIhNS_9allocatorIhEEE18__construct_at_endEj($15,$28);
 STACKTOP = sp;return;
}
function __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEEC2EjRKS3_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 96|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(96|0);
 $20 = sp + 20|0;
 $22 = sp + 12|0;
 $23 = $0;
 $24 = $1;
 $25 = $2;
 $26 = $23;
 $21 = $26;
 $27 = $21;
 $19 = $27;
 $28 = $19;
 HEAP32[$28>>2] = 0;
 $29 = ((($28)) + 4|0);
 HEAP32[$29>>2] = 0;
 $30 = ((($28)) + 8|0);
 HEAP32[$30>>2] = 0;
 $31 = ((($28)) + 12|0);
 HEAP32[$20>>2] = 0;
 $17 = $31;
 $18 = $20;
 $32 = $17;
 $33 = $18;
 $16 = $33;
 $34 = $16;
 $12 = $32;
 $13 = $34;
 $35 = $12;
 $36 = $13;
 $11 = $36;
 HEAP32[$35>>2] = 0;
 $15 = $32;
 $37 = $15;
 $14 = $37;
 $38 = ((($27)) + 16|0);
 HEAP32[$38>>2] = 0;
 $39 = ((($27)) + 20|0);
 HEAP32[$22>>2] = 0;
 $9 = $39;
 $10 = $22;
 $40 = $9;
 $41 = $10;
 $8 = $41;
 $42 = $8;
 $4 = $40;
 $5 = $42;
 $43 = $4;
 $44 = $5;
 $3 = $44;
 $45 = $3;
 $46 = HEAP32[$45>>2]|0;
 HEAP32[$43>>2] = $46;
 $7 = $40;
 $47 = $7;
 $6 = $47;
 $48 = $24;
 $49 = ($48>>>0)>(0);
 if (!($49)) {
  STACKTOP = sp;return;
 }
 $50 = $24;
 $51 = $25;
 __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE8__appendEjRKS3_($26,$50,$51);
 STACKTOP = sp;return;
}
function __ZNSt3__26vectorIhNS_9allocatorIhEEE18__construct_at_endEj($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0;
 var $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0;
 var $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 80|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(80|0);
 $10 = sp;
 $13 = sp + 73|0;
 $21 = sp + 72|0;
 $18 = $0;
 $19 = $1;
 $22 = $18;
 $17 = $22;
 $23 = $17;
 $24 = ((($23)) + 8|0);
 $16 = $24;
 $25 = $16;
 $15 = $25;
 $26 = $15;
 $20 = $26;
 while(1) {
  $2 = $21;
  $3 = $22;
  $4 = 1;
  $27 = $20;
  $28 = ((($22)) + 4|0);
  $29 = HEAP32[$28>>2]|0;
  $5 = $29;
  $30 = $5;
  $11 = $27;
  $12 = $30;
  $31 = $11;
  $32 = $12;
  ;HEAP8[$10>>0]=HEAP8[$13>>0]|0;
  $8 = $31;
  $9 = $32;
  $33 = $8;
  $34 = $9;
  $6 = $33;
  $7 = $34;
  $35 = $7;
  HEAP8[$35>>0] = 0;
  $36 = ((($22)) + 4|0);
  $37 = HEAP32[$36>>2]|0;
  $38 = ((($37)) + 1|0);
  HEAP32[$36>>2] = $38;
  $39 = $19;
  $40 = (($39) + -1)|0;
  $19 = $40;
  $14 = $21;
  $41 = $19;
  $42 = ($41>>>0)>(0);
  if (!($42)) {
   break;
  }
 }
 STACKTOP = sp;return;
}
function __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE8__appendEjRKS3_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0;
 var $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0;
 var $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0;
 var $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0;
 var $97 = 0, $98 = 0, $99 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 160|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(160|0);
 $20 = sp;
 $25 = sp + 148|0;
 $38 = sp + 8|0;
 $33 = $0;
 $34 = $1;
 $35 = $2;
 $39 = $33;
 $32 = $39;
 $40 = $32;
 $41 = ((($40)) + 20|0);
 $31 = $41;
 $42 = $31;
 $30 = $42;
 $43 = $30;
 $36 = $43;
 $11 = $39;
 $44 = $11;
 $10 = $44;
 $45 = $10;
 $9 = $45;
 $46 = $9;
 $47 = ((($46)) + 8|0);
 $48 = HEAP32[$47>>2]|0;
 $49 = ((($46)) + 4|0);
 $50 = HEAP32[$49>>2]|0;
 $51 = $48;
 $52 = $50;
 $53 = (($51) - ($52))|0;
 $54 = (($53|0) / 4)&-1;
 $55 = ($54|0)==(0);
 if ($55) {
  $76 = 0;
 } else {
  $8 = $45;
  $56 = $8;
  $57 = ((($56)) + 8|0);
  $58 = HEAP32[$57>>2]|0;
  $59 = ((($56)) + 4|0);
  $60 = HEAP32[$59>>2]|0;
  $61 = $58;
  $62 = $60;
  $63 = (($61) - ($62))|0;
  $64 = (($63|0) / 4)&-1;
  $65 = ($64*93)|0;
  $66 = (($65) - 1)|0;
  $76 = $66;
 }
 $67 = ((($44)) + 16|0);
 $68 = HEAP32[$67>>2]|0;
 $7 = $44;
 $69 = $7;
 $70 = ((($69)) + 20|0);
 $6 = $70;
 $71 = $6;
 $5 = $71;
 $72 = $5;
 $73 = HEAP32[$72>>2]|0;
 $74 = (($68) + ($73))|0;
 $75 = (($76) - ($74))|0;
 $37 = $75;
 $77 = $34;
 $78 = $37;
 $79 = ($77>>>0)>($78>>>0);
 if ($79) {
  $80 = $34;
  $81 = $37;
  $82 = (($80) - ($81))|0;
  __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEE19__add_back_capacityEj($39,$82);
 }
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEE3endEv($38,$39);
 while(1) {
  $83 = $34;
  $84 = ($83|0)!=(0);
  if (!($84)) {
   break;
  }
  $85 = $36;
  $3 = $38;
  $86 = $3;
  $87 = ((($86)) + 4|0);
  $88 = HEAP32[$87>>2]|0;
  $4 = $88;
  $89 = $4;
  $90 = $35;
  $22 = $85;
  $23 = $89;
  $24 = $90;
  $91 = $22;
  $92 = $23;
  $93 = $24;
  $21 = $93;
  $94 = $21;
  ;HEAP8[$20>>0]=HEAP8[$25>>0]|0;
  $17 = $91;
  $18 = $92;
  $19 = $94;
  $95 = $17;
  $96 = $18;
  $97 = $19;
  $16 = $97;
  $98 = $16;
  $13 = $95;
  $14 = $96;
  $15 = $98;
  $99 = $14;
  $100 = $15;
  $12 = $100;
  $101 = $12;
  __ZN6laszip6models10arithmeticC2ERKS1_($99,$101);
  $102 = $34;
  $103 = (($102) + -1)|0;
  $34 = $103;
  $26 = $38;
  $104 = $26;
  $105 = ((($104)) + 4|0);
  $106 = HEAP32[$105>>2]|0;
  $107 = ((($106)) + 44|0);
  HEAP32[$105>>2] = $107;
  $108 = HEAP32[$104>>2]|0;
  $109 = HEAP32[$108>>2]|0;
  $110 = $107;
  $111 = $109;
  $112 = (($110) - ($111))|0;
  $113 = (($112|0) / 44)&-1;
  $114 = ($113|0)==(93);
  if ($114) {
   $115 = HEAP32[$104>>2]|0;
   $116 = ((($115)) + 4|0);
   HEAP32[$104>>2] = $116;
   $117 = HEAP32[$104>>2]|0;
   $118 = HEAP32[$117>>2]|0;
   $119 = ((($104)) + 4|0);
   HEAP32[$119>>2] = $118;
  }
  $29 = $39;
  $120 = $29;
  $121 = ((($120)) + 20|0);
  $28 = $121;
  $122 = $28;
  $27 = $122;
  $123 = $27;
  $124 = HEAP32[$123>>2]|0;
  $125 = (($124) + 1)|0;
  HEAP32[$123>>2] = $125;
 }
 STACKTOP = sp;return;
}
function __ZNSt3__25dequeIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__212__deque_baseIN6laszip6models10arithmeticENS_9allocatorIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEEC2ERS9_PSH_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = sp + 12|0;
 $11 = $0;
 $12 = $1;
 $13 = $2;
 $14 = $11;
 __ZN6laszip7formats20dynamic_decompressorC2Ev($14);
 HEAP32[$14>>2] = (2256);
 $15 = ((($14)) + 4|0);
 $16 = $12;
 HEAP32[$15>>2] = $16;
 $17 = ((($14)) + 8|0);
 $18 = $13;
 $9 = $17;
 HEAP32[$10>>2] = $18;
 $19 = $9;
 $7 = $19;
 $8 = $10;
 $20 = $7;
 $21 = $8;
 $6 = $21;
 $22 = $6;
 $4 = $20;
 $5 = $22;
 $23 = $4;
 $24 = $5;
 $3 = $24;
 $25 = $3;
 $26 = HEAP32[$25>>2]|0;
 HEAP32[$23>>2] = $26;
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISP_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2276);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 8|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEE10decompressEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = $0;
 $6 = $1;
 $7 = $5;
 $8 = ((($7)) + 8|0);
 $4 = $8;
 $9 = $4;
 $3 = $9;
 $10 = $3;
 $2 = $10;
 $11 = $2;
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($7)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $6;
 $16 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($12,$14,$15)|0);
 STACKTOP = sp;return ($16|0);
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $13 = $0;
 $14 = $13;
 HEAP32[$14>>2] = (2256);
 $15 = ((($14)) + 8|0);
 $12 = $15;
 $16 = $12;
 $9 = $16;
 $10 = 0;
 $17 = $9;
 $8 = $17;
 $18 = $8;
 $7 = $18;
 $19 = $7;
 $20 = HEAP32[$19>>2]|0;
 $11 = $20;
 $21 = $10;
 $4 = $17;
 $22 = $4;
 $3 = $22;
 $23 = $3;
 HEAP32[$23>>2] = $21;
 $24 = $11;
 $25 = ($24|0)!=(0|0);
 if ($25) {
  $2 = $17;
  $26 = $2;
  $1 = $26;
  $27 = $1;
  $28 = $11;
  $5 = $27;
  $6 = $28;
  $29 = $6;
  $30 = ($29|0)==(0|0);
  if (!($30)) {
   __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEEEED2Ev($29);
   __ZdlPv($29);
  }
 }
 __ZN6laszip7formats20dynamic_decompressorD2Ev($14);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEEEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 4784|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SC_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SC_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = HEAP8[$6>>0]|0;
 $8 = $7&1;
 if (!($8)) {
  $10 = $5;
  STACKTOP = sp;return ($10|0);
 }
 $9 = $4;
 __ZN6laszip8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEE13readInitBytesEv($9);
 HEAP8[$6>>0] = 0;
 $10 = $5;
 STACKTOP = sp;return ($10|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEE18__enable_weak_thisEz($0,$varargs) {
 $0 = $0|0;
 $varargs = $varargs|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEEEEEEENS_14default_deleteISK_EENS_9allocatorISK_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEEEEEEENS_14default_deleteISK_EENS_9allocatorISK_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEEEEEEENS_14default_deleteISK_EENS_9allocatorISK_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEEEEEEENS_14default_deleteISK_EENS_9allocatorISK_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 8|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEEEEEEENS_14default_deleteISK_EENS_9allocatorISK_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 520;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEEEEEEENS_14default_deleteISK_EENS_9allocatorISK_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 HEAP8[$2>>0] = 1;
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEEC2ERS9_PSK_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = sp + 12|0;
 $11 = $0;
 $12 = $1;
 $13 = $2;
 $14 = $11;
 __ZN6laszip7formats20dynamic_decompressorC2Ev($14);
 HEAP32[$14>>2] = (2304);
 $15 = ((($14)) + 4|0);
 $16 = $12;
 HEAP32[$15>>2] = $16;
 $17 = ((($14)) + 8|0);
 $18 = $13;
 $9 = $17;
 HEAP32[$10>>2] = $18;
 $19 = $9;
 $7 = $19;
 $8 = $10;
 $20 = $7;
 $21 = $8;
 $6 = $21;
 $22 = $6;
 $4 = $20;
 $5 = $22;
 $23 = $4;
 $24 = $5;
 $3 = $24;
 $25 = $3;
 $26 = HEAP32[$25>>2]|0;
 HEAP32[$23>>2] = $26;
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEENSG_INSH_7gpstimeENSJ_ISM_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISS_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2324);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 8|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEE10decompressEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = $0;
 $6 = $1;
 $7 = $5;
 $8 = ((($7)) + 8|0);
 $4 = $8;
 $9 = $4;
 $3 = $9;
 $10 = $3;
 $2 = $10;
 $11 = $2;
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($7)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $6;
 $16 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SL_($12,$14,$15)|0);
 STACKTOP = sp;return ($16|0);
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $13 = $0;
 $14 = $13;
 HEAP32[$14>>2] = (2304);
 $15 = ((($14)) + 8|0);
 $12 = $15;
 $16 = $12;
 $9 = $16;
 $10 = 0;
 $17 = $9;
 $8 = $17;
 $18 = $8;
 $7 = $18;
 $19 = $7;
 $20 = HEAP32[$19>>2]|0;
 $11 = $20;
 $21 = $10;
 $4 = $17;
 $22 = $4;
 $3 = $22;
 $23 = $3;
 HEAP32[$23>>2] = $21;
 $24 = $11;
 $25 = ($24|0)!=(0|0);
 if ($25) {
  $2 = $17;
  $26 = $2;
  $1 = $26;
  $27 = $1;
  $28 = $11;
  $5 = $27;
  $6 = $28;
  $29 = $6;
  $30 = ($29|0)==(0|0);
  if (!($30)) {
   __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEEEED2Ev($29);
   __ZdlPv($29);
  }
 }
 __ZN6laszip7formats20dynamic_decompressorD2Ev($14);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEEEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SL_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 4784|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 328|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SC_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEEEED2Ev($3);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 8|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 560;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 328|0);
 __ZN6laszip7formats19record_decompressorIJEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEEC2ERS9_PSK_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = sp + 12|0;
 $11 = $0;
 $12 = $1;
 $13 = $2;
 $14 = $11;
 __ZN6laszip7formats20dynamic_decompressorC2Ev($14);
 HEAP32[$14>>2] = (2352);
 $15 = ((($14)) + 4|0);
 $16 = $12;
 HEAP32[$15>>2] = $16;
 $17 = ((($14)) + 8|0);
 $18 = $13;
 $9 = $17;
 HEAP32[$10>>2] = $18;
 $19 = $9;
 $7 = $19;
 $8 = $10;
 $20 = $7;
 $21 = $8;
 $6 = $21;
 $22 = $6;
 $4 = $20;
 $5 = $22;
 $23 = $4;
 $24 = $5;
 $3 = $24;
 $25 = $3;
 $26 = HEAP32[$25>>2]|0;
 HEAP32[$23>>2] = $26;
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEENSG_INSH_3rgbENSJ_ISM_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISS_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2372);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 8|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEE10decompressEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = $0;
 $6 = $1;
 $7 = $5;
 $8 = ((($7)) + 8|0);
 $4 = $8;
 $9 = $4;
 $3 = $9;
 $10 = $3;
 $2 = $10;
 $11 = $2;
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($7)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $6;
 $16 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SL_($12,$14,$15)|0);
 STACKTOP = sp;return ($16|0);
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $13 = $0;
 $14 = $13;
 HEAP32[$14>>2] = (2352);
 $15 = ((($14)) + 8|0);
 $12 = $15;
 $16 = $12;
 $9 = $16;
 $10 = 0;
 $17 = $9;
 $8 = $17;
 $18 = $8;
 $7 = $18;
 $19 = $7;
 $20 = HEAP32[$19>>2]|0;
 $11 = $20;
 $21 = $10;
 $4 = $17;
 $22 = $4;
 $3 = $22;
 $23 = $3;
 HEAP32[$23>>2] = $21;
 $24 = $11;
 $25 = ($24|0)!=(0|0);
 if ($25) {
  $2 = $17;
  $26 = $2;
  $1 = $26;
  $27 = $1;
  $28 = $11;
  $5 = $27;
  $6 = $28;
  $29 = $6;
  $30 = ($29|0)==(0|0);
  if (!($30)) {
   __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEED2Ev($29);
   __ZdlPv($29);
  }
 }
 __ZN6laszip7formats20dynamic_decompressorD2Ev($14);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_3rgbENSE_ISH_EEEEEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SL_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 4784|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 316|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SC_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEED2Ev($3);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_3rgbENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_3rgbENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_3rgbENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_3rgbENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 8|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_3rgbENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 600;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_3rgbENSG_ISJ_EEEEEEEEENS_14default_deleteISN_EENS_9allocatorISN_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las3rgbENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 316|0);
 __ZN6laszip7formats19record_decompressorIJEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEEC2ERS9_PSN_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $10 = sp + 12|0;
 $11 = $0;
 $12 = $1;
 $13 = $2;
 $14 = $11;
 __ZN6laszip7formats20dynamic_decompressorC2Ev($14);
 HEAP32[$14>>2] = (2400);
 $15 = ((($14)) + 4|0);
 $16 = $12;
 HEAP32[$15>>2] = $16;
 $17 = ((($14)) + 8|0);
 $18 = $13;
 $9 = $17;
 HEAP32[$10>>2] = $18;
 $19 = $9;
 $7 = $19;
 $8 = $10;
 $20 = $7;
 $21 = $8;
 $6 = $21;
 $22 = $6;
 $4 = $20;
 $5 = $22;
 $23 = $4;
 $24 = $5;
 $3 = $24;
 $25 = $3;
 $26 = HEAP32[$25>>2]|0;
 HEAP32[$23>>2] = $26;
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEEC2INS2_21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISI_EEEENSG_INSH_7gpstimeENSJ_ISM_EEEENSG_INSH_3rgbENSJ_ISP_EEEEEEEEEEEPT_NS_9enable_ifIXsr14is_convertibleISV_PS3_EE5valueENS4_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0;
 var $136 = 0, $137 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0;
 var $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0;
 var $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2420);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrIN6laszip7formats20dynamic_decompressorEE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 $135 = HEAP32[$133>>2]|0;
 $136 = ((($135)) + 8|0);
 $137 = HEAP32[$136>>2]|0;
 FUNCTION_TABLE_vi[$137 & 511]($133);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEE10decompressEPc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $5 = $0;
 $6 = $1;
 $7 = $5;
 $8 = ((($7)) + 8|0);
 $4 = $8;
 $9 = $4;
 $3 = $9;
 $10 = $3;
 $2 = $10;
 $11 = $2;
 $12 = HEAP32[$11>>2]|0;
 $13 = ((($7)) + 4|0);
 $14 = HEAP32[$13>>2]|0;
 $15 = $6;
 $16 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEENS2_INS3_3rgbENS5_ISB_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SO_($12,$14,$15)|0);
 STACKTOP = sp;return ($16|0);
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $13 = $0;
 $14 = $13;
 HEAP32[$14>>2] = (2400);
 $15 = ((($14)) + 8|0);
 $12 = $15;
 $16 = $12;
 $9 = $16;
 $10 = 0;
 $17 = $9;
 $8 = $17;
 $18 = $8;
 $7 = $18;
 $19 = $7;
 $20 = HEAP32[$19>>2]|0;
 $11 = $20;
 $21 = $10;
 $4 = $17;
 $22 = $4;
 $3 = $22;
 $23 = $3;
 HEAP32[$23>>2] = $21;
 $24 = $11;
 $25 = ($24|0)!=(0|0);
 if ($25) {
  $2 = $17;
  $26 = $2;
  $1 = $26;
  $27 = $1;
  $28 = $11;
  $5 = $27;
  $6 = $28;
  $29 = $6;
  $30 = ($29|0)==(0|0);
  if (!($30)) {
   __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEENS2_INS3_3rgbENS5_ISB_EEEEEED2Ev($29);
   __ZdlPv($29);
  }
 }
 __ZN6laszip7formats20dynamic_decompressorD2Ev($14);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats21dynamic_decompressor1INS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEENS0_19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodISD_EEEENSB_INSC_7gpstimeENSE_ISH_EEEENSB_INSC_3rgbENSE_ISK_EEEEEEEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEENS2_INS3_3rgbENS5_ISB_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SO_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 4784|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SL_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SL_($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 $8 = $5;
 $9 = (__ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SG_($6,$7,$8)|0);
 $5 = $9;
 $10 = ((($6)) + 328|0);
 $11 = $4;
 $12 = $5;
 $13 = (__ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEE14decompressWithINS_8decoders10arithmeticINS_2io18__ifstream_wrapperINS_7streams13memory_streamEEEEEEEPcRT_SI_($10,$11,$12)|0);
 STACKTOP = sp;return ($13|0);
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7point10ENS0_20standard_diff_methodIS4_EEEENS2_INS3_7gpstimeENS5_IS8_EEEENS2_INS3_3rgbENS5_ISB_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 4784|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEED2Ev($3);
 __ZN6laszip7formats5fieldINS0_3las7point10ENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 328|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEED2Ev($3);
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEED2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEENSD_INSE_3rgbENSG_ISM_EEEEEEEEENS_14default_deleteISQ_EENS_9allocatorISQ_EEED2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__214__shared_countD2Ev($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEENSD_INSE_3rgbENSG_ISM_EEEEEEEEENS_14default_deleteISQ_EENS_9allocatorISQ_EEED0Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEENSD_INSE_3rgbENSG_ISM_EEEEEEEEENS_14default_deleteISQ_EENS_9allocatorISQ_EEED2Ev($2);
 __ZdlPv($2);
 STACKTOP = sp;return;
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEENSD_INSE_3rgbENSG_ISM_EEEEEEEEENS_14default_deleteISQ_EENS_9allocatorISQ_EEE16__on_zero_sharedEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0;
 var $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $15 = $0;
 $16 = $15;
 $17 = ((($16)) + 12|0);
 $14 = $17;
 $18 = $14;
 $13 = $18;
 $19 = $13;
 $6 = $19;
 $20 = $6;
 $5 = $20;
 $21 = $5;
 $22 = ((($16)) + 12|0);
 $2 = $22;
 $23 = $2;
 $1 = $23;
 $24 = $1;
 $4 = $24;
 $25 = $4;
 $3 = $25;
 $26 = $3;
 $27 = HEAP32[$26>>2]|0;
 $7 = $21;
 $8 = $27;
 $28 = $8;
 $29 = ($28|0)==(0|0);
 if (!($29)) {
  $30 = HEAP32[$28>>2]|0;
  $31 = ((($30)) + 8|0);
  $32 = HEAP32[$31>>2]|0;
  FUNCTION_TABLE_vi[$32 & 511]($28);
 }
 $33 = ((($16)) + 12|0);
 $10 = $33;
 $34 = $10;
 $9 = $34;
 $35 = $9;
 $12 = $35;
 $36 = $12;
 $11 = $36;
 STACKTOP = sp;return;
}
function __ZNKSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEENSD_INSE_3rgbENSG_ISM_EEEEEEEEENS_14default_deleteISQ_EENS_9allocatorISQ_EEE13__get_deleterERKSt9type_info($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $3 = 0, $4 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 48|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(48|0);
 $9 = $0;
 $10 = $1;
 $11 = $9;
 $12 = $10;
 $7 = $12;
 $8 = 640;
 $13 = $7;
 $14 = ((($13)) + 4|0);
 $15 = HEAP32[$14>>2]|0;
 $16 = $8;
 $17 = ((($16)) + 4|0);
 $18 = HEAP32[$17>>2]|0;
 $19 = ($15|0)==($18|0);
 if (!($19)) {
  $26 = 0;
  STACKTOP = sp;return ($26|0);
 }
 $20 = ((($11)) + 12|0);
 $3 = $20;
 $21 = $3;
 $2 = $21;
 $22 = $2;
 $5 = $22;
 $23 = $5;
 $4 = $23;
 $24 = $4;
 $6 = $24;
 $25 = $6;
 $26 = $25;
 STACKTOP = sp;return ($26|0);
}
function __ZNSt3__220__shared_ptr_pointerIPN6laszip7formats21dynamic_decompressor1INS1_8decoders10arithmeticINS1_2io18__ifstream_wrapperINS1_7streams13memory_streamEEEEENS2_19record_decompressorIJNS2_5fieldINS2_3las7point10ENS2_20standard_diff_methodISF_EEEENSD_INSE_7gpstimeENSG_ISJ_EEEENSD_INSE_3rgbENSG_ISM_EEEEEEEEENS_14default_deleteISQ_EENS_9allocatorISQ_EEE21__on_zero_shared_weakEv($0) {
 $0 = $0|0;
 var $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $3 = 0, $4 = 0, $5 = 0;
 var $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $14 = sp + 52|0;
 $13 = $0;
 $15 = $13;
 $16 = ((($15)) + 12|0);
 $12 = $16;
 $17 = $12;
 $11 = $17;
 $18 = $11;
 $5 = $14;
 $6 = $18;
 $19 = ((($15)) + 12|0);
 $2 = $19;
 $20 = $2;
 $1 = $20;
 $4 = $15;
 $21 = $4;
 $3 = $21;
 $22 = $3;
 $8 = $14;
 $9 = $22;
 $10 = 1;
 $23 = $9;
 $7 = $23;
 $24 = $7;
 __ZdlPv($24);
 STACKTOP = sp;return;
}
function __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS4_EEEENS2_INS3_3rgbENS5_IS8_EEEEEEC2Ev($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 __ZN6laszip7formats5fieldINS0_3las7gpstimeENS0_20standard_diff_methodIS3_EEEC2Ev($2);
 $3 = ((($2)) + 328|0);
 __ZN6laszip7formats19record_decompressorIJNS0_5fieldINS0_3las3rgbENS0_20standard_diff_methodIS4_EEEEEEC2Ev($3);
 STACKTOP = sp;return;
}
function __ZNK6laszip2io6reader10basic_fileINS_7streams13memory_streamEE10get_headerEv($0) {
 $0 = $0|0;
 var $1 = 0, $2 = 0, $3 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $1 = $0;
 $2 = $1;
 $3 = ((($2)) + 20|0);
 STACKTOP = sp;return ($3|0);
}
function __ZN10buf_streamC2EPhj($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $3 = $0;
 $4 = $1;
 $5 = $2;
 $6 = $3;
 $7 = $4;
 HEAP32[$6>>2] = $7;
 $8 = ((($6)) + 4|0);
 $9 = $5;
 HEAP32[$8>>2] = $9;
 $10 = ((($6)) + 8|0);
 HEAP32[$10>>2] = 0;
 STACKTOP = sp;return;
}
function __ZN6laszip8decoders10arithmeticI10buf_streamEC2ERS2_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $2 = $0;
 $3 = $1;
 $4 = $2;
 $5 = $3;
 HEAP32[$4>>2] = $5;
 $6 = ((($4)) + 4|0);
 HEAP32[$6>>2] = 0;
 $7 = ((($4)) + 8|0);
 HEAP32[$7>>2] = -1;
 STACKTOP = sp;return;
}
function __ZN6laszip7formatsL25make_dynamic_decompressorINS_8decoders10arithmeticI10buf_streamEEEENS0_26dynamic_field_decompressorIT_E3ptrERS7_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$byval_copy = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $$byval_copy = sp + 8|0;
 $3 = sp;
 $2 = $1;
 $4 = (__Znwj(24)|0);
 $5 = $2;
 __ZN6laszip7formats26dynamic_field_decompressorINS_8decoders10arithmeticI10buf_streamEEEC2ERS5_($4,$5);
 ;HEAP32[$3>>2]=0|0;
 ;HEAP32[$$byval_copy>>2]=HEAP32[$3>>2]|0;
 __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticI10buf_streamEEEEEC2IS8_EEPT_NS_9enable_ifIXsr14is_convertibleISC_PS8_EE5valueENS9_5__natEE4typeE($0,$4,$$byval_copy);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrIN6laszip7formats26dynamic_field_decompressorINS1_8decoders10arithmeticI10buf_streamEEEEED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0;
 var $25 = 0, $26 = 0, $27 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $4 = sp + 24|0;
 $7 = $0;
 $8 = $7;
 $9 = ((($8)) + 4|0);
 $10 = HEAP32[$9>>2]|0;
 $11 = ($10|0)!=(0|0);
 if (!($11)) {
  STACKTOP = sp;return;
 }
 $12 = ((($8)) + 4|0);
 $13 = HEAP32[$12>>2]|0;
 $6 = $13;
 $14 = $6;
 $5 = $14;
 $15 = $5;
 $16 = ((($15)) + 4|0);
 $1 = $16;
 $17 = $1;
 $2 = -1;
 $18 = $2;
 $19 = HEAP32[$17>>2]|0;
 $20 = (($19) + ($18))|0;
 HEAP32[$17>>2] = $20;
 $21 = (($19) + ($18))|0;
 $3 = $21;
 $22 = $3;
 $23 = ($22|0)==(-1);
 if ($23) {
  $24 = HEAP32[$15>>2]|0;
  $25 = ((($24)) + 8|0);
  $26 = HEAP32[$25>>2]|0;
  FUNCTION_TABLE_vi[$26 & 511]($15);
  $$expand_i1_val = 1;
  HEAP8[$4>>0] = $$expand_i1_val;
 } else {
  $$expand_i1_val2 = 0;
  HEAP8[$4>>0] = $$expand_i1_val2;
 }
 $$pre_trunc = HEAP8[$4>>0]|0;
 $27 = $$pre_trunc&1;
 if (!($27)) {
  STACKTOP = sp;return;
 }
 __ZNSt3__219__shared_weak_count14__release_weakEv($14);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrI10buf_streamEC2IS1_EEPT_NS_9enable_ifIXsr14is_convertibleIS5_PS1_EE5valueENS2_5__natEE4typeE($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0, $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0;
 var $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0, $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0;
 var $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0;
 var $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0;
 var $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0;
 var $89 = 0, $9 = 0, $90 = 0, $91 = 0, $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_ptr1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp + 16|0;
 $38 = sp + 124|0;
 $39 = sp + 120|0;
 $40 = sp + 8|0;
 $41 = sp;
 $62 = sp + 36|0;
 $65 = sp + 24|0;
 $66 = sp + 269|0;
 $67 = sp + 268|0;
 $63 = $0;
 $64 = $1;
 $68 = $63;
 $69 = $64;
 HEAP32[$68>>2] = $69;
 $70 = $64;
 $61 = $65;
 HEAP32[$62>>2] = $70;
 $71 = $61;
 $59 = $71;
 $60 = $62;
 $72 = $59;
 $73 = $60;
 $58 = $73;
 $74 = $58;
 $56 = $72;
 $57 = $74;
 $75 = $56;
 $76 = $57;
 $55 = $76;
 $77 = $55;
 $78 = HEAP32[$77>>2]|0;
 HEAP32[$75>>2] = $78;
 $79 = (__Znwj(16)|0);
 $80 = $64;
 $54 = $67;
 ;HEAP8[$40>>0]=HEAP8[$67>>0]|0;
 ;HEAP8[$41>>0]=HEAP8[$66>>0]|0;
 $37 = $79;
 HEAP32[$38>>2] = $80;
 $81 = $37;
 $35 = $81;
 $36 = 0;
 $82 = $35;
 $83 = $36;
 $33 = $82;
 $34 = $83;
 $84 = $33;
 HEAP32[$84>>2] = (3468);
 $85 = ((($84)) + 4|0);
 $86 = $34;
 HEAP32[$85>>2] = $86;
 HEAP32[$82>>2] = (3488);
 $87 = ((($82)) + 8|0);
 $88 = $36;
 HEAP32[$87>>2] = $88;
 HEAP32[$81>>2] = (2448);
 $89 = ((($81)) + 12|0);
 $9 = $41;
 $90 = $9;
 $18 = $39;
 $19 = $38;
 $20 = $90;
 $91 = $18;
 $92 = $19;
 $17 = $92;
 $93 = $17;
 $11 = $91;
 $12 = $93;
 $94 = $11;
 $95 = $12;
 $10 = $95;
 $96 = $10;
 $97 = HEAP32[$96>>2]|0;
 HEAP32[$94>>2] = $97;
 $98 = $20;
 $13 = $98;
 $99 = $13;
 $15 = $91;
 $16 = $99;
 $100 = $16;
 $14 = $100;
 $21 = $40;
 $101 = $21;
 $30 = $89;
 $31 = $39;
 $32 = $101;
 $102 = $30;
 $103 = $31;
 $29 = $103;
 $104 = $29;
 $23 = $102;
 $24 = $104;
 $105 = $23;
 $106 = $24;
 $22 = $106;
 $107 = $22;
 ;HEAP32[$105>>2]=HEAP32[$107>>2]|0;
 $108 = $32;
 $25 = $108;
 $109 = $25;
 $27 = $102;
 $28 = $109;
 $110 = $28;
 $26 = $110;
 $111 = ((($68)) + 4|0);
 HEAP32[$111>>2] = $79;
 $7 = $65;
 $112 = $7;
 $6 = $112;
 $113 = $6;
 $5 = $113;
 $114 = $5;
 $115 = HEAP32[$114>>2]|0;
 $8 = $115;
 $4 = $112;
 $116 = $4;
 $3 = $116;
 $117 = $3;
 HEAP32[$117>>2] = 0;
 $118 = $64;
 $119 = $64;
 HEAP32[$vararg_buffer>>2] = $118;
 $vararg_ptr1 = ((($vararg_buffer)) + 4|0);
 HEAP32[$vararg_ptr1>>2] = $119;
 __ZNSt3__210shared_ptrI10buf_streamE18__enable_weak_thisEz($68,$vararg_buffer);
 $53 = $65;
 $120 = $53;
 $50 = $120;
 $51 = 0;
 $121 = $50;
 $49 = $121;
 $122 = $49;
 $48 = $122;
 $123 = $48;
 $124 = HEAP32[$123>>2]|0;
 $52 = $124;
 $125 = $51;
 $45 = $121;
 $126 = $45;
 $44 = $126;
 $127 = $44;
 HEAP32[$127>>2] = $125;
 $128 = $52;
 $129 = ($128|0)!=(0|0);
 if (!($129)) {
  STACKTOP = sp;return;
 }
 $43 = $121;
 $130 = $43;
 $42 = $130;
 $131 = $42;
 $132 = $52;
 $46 = $131;
 $47 = $132;
 $133 = $47;
 $134 = ($133|0)==(0|0);
 if ($134) {
  STACKTOP = sp;return;
 }
 __ZdlPv($133);
 STACKTOP = sp;return;
}
function __ZNSt3__210shared_ptrI10buf_streamED2Ev($0) {
 $0 = $0|0;
 var $$expand_i1_val = 0, $$expand_i1_val2 = 0, $$pre_trunc = 0, $1 = 0, $10 = 0,