# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QText+ Core Module
 
 Module principal logique métier
 - ImporterCore: Source de vérité unique
 - EnhancedTextImporter: Orchestration import simple
 - BatchImporter: Import multiple fichiers
 - CoordinateConverter: Conversions coordonnées
 - Validator: Validation passive
 - MetadataManager: Gestion métadonnées
 
                              -------------------
        begin                : 2026-01-13
        copyright            : (C) 2024 by Aziz TRAORE
        email                : aziz.explorer@gmail.com
 ***************************************************************************/
"""

from .importer_core import ImporterCore
from .importer import EnhancedTextImporter
from .batch_importer import BatchImporter, FileStructureAnalyzer
from .coordinate_converter import CoordinateConverter
from .validator import CoordinateValidator
from .metadata_manager import MetadataManager

__all__ = [
    'ImporterCore',
    'EnhancedTextImporter',
    'BatchImporter',
    'FileStructureAnalyzer',
    'CoordinateConverter',
    'CoordinateValidator',
    'MetadataManager'
]
