# 🌍 QText+ – Enhanced Text Import for QGIS

**Version 1.0.0** | **QGIS 3.x** | **Python 3.6+**

[![QGIS](https://img.shields.io/badge/QGIS-3.0%2B-green.svg)](https://qgis.org)
[![Python](https://img.shields.io/badge/Python-3.6%2B-blue.svg)](https://python.org)
[![License](https://img.shields.io/badge/License-GPL%20v2-orange.svg)](LICENSE)

**🇬🇧 English** | [🇫🇷 Français](#french-version)

---

## 🇬🇧 English Version

### Advanced QGIS plugin for importing delimited text files (CSV/TXT) with robust coordinate handling, CRS/UTM management, DMS support, and batch import workflows.

---

## ✨ Features

### 🎯 Single File Import

* **Supported formats**: CSV, TSV, TXT (custom delimiters)
* **Encodings**: UTF-8, ISO-8859-1, Windows-1252
* **Geometry types**:

  * Point (X/Y fields)
  * WKT geometry
  * No geometry (attribute-only table)
* **Coordinate formats**:

  * **DD** (Decimal Degrees): `48.8566, 2.3522`
  * **DMS** (Degrees Minutes Seconds): `48°51'24"N, 2°21'08"E`
  * **UTM**: `448251, 5411920`
* **CRS management**:

  * Explicit source CRS selection
  * On-the-fly reprojection using QGIS native API
* **Field detection**:

  * Manual or assisted selection of X/Y or WKT fields

### 📦 Batch Import

* Import multiple files in a single operation
* Designed for **homogeneous file structures**
* Import modes:

  * **Merge**: single output layer with `source_file` attribute
  * **Individual**: one layer per input file
* Suitable for repetitive production workflows

### ✓ Passive Validation

* Coordinate range consistency checks
* CRS compatibility verification
* Non-blocking warnings
* No automatic data correction (user remains in control)

---

## 📥 Installation

### Via QGIS Plugin Manager (Recommended)

1. QGIS → **Plugins** → **Manage and Install Plugins**
2. Search for **"QText+"**
3. Click **Install Plugin**

### Manual Installation

```bash
# Linux / macOS
cd ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
git clone https://github.com/AzizT-dev/QTextplus.git QTextplus

# Windows
cd %APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\
git clone https://github.com/AzizT-dev/QTextplus.git QTextplus
```

Restart QGIS and enable the plugin.

---

## 🚀 Quick Start

### Single File Import

1. Click the **QText+** button in the QGIS toolbar
2. Select a **CSV/TXT** file
3. Configure:

   * Delimiter and encoding
   * Geometry definition (X/Y or WKT)
   * Source CRS
4. Click **Import**
5. A new layer is created in the project

### Batch Import

1. Open **QText+** main dialog
2. Choose **Batch Import**
3. Add multiple files with identical structure
4. Select **Merge** or **Individual layers**
5. Start the import process

---

## 🌐 Supported Coordinate Formats

| Format | Example                 | Supported |
| ------ | ----------------------- | --------- |
| DD     | `48.8566, 2.3522`       | ✅         |
| DMS    | `48°51'24"N, 2°21'08"E` | ✅         |
| UTM    | `448251, 5411920`       | ✅         |
| WKT    | `POINT(2.35 48.86)`     | ✅         |

---

## 📚 Documentation

* **Issues / Bug reports**: [https://github.com/AzizT-dev/QTextplus/issues](https://github.com/AzizT-dev/QTextplus/issues)
* **Source code**: [https://github.com/AzizT-dev/QTextplus](https://github.com/AzizT-dev/QTextplus)

---

## 👨‍💻 Author

**Aziz TRAORE**

* Email: [aziz.explorer@gmail.com](mailto:aziz.explorer@gmail.com)
* GitHub: [@AzizT-dev](https://github.com/AzizT-dev)

---

## 📄 License

GNU General Public License v2.0

---

## ⭐ Support the Project

* ⭐ Star the repository on GitHub
* 📢 Share with the QGIS community
* 💬 Report issues or suggest improvements

---

**Made with ❤️ for the QGIS community**

---

<a name="french-version"></a>

## 🇫🇷 Version Française

### Plugin QGIS pour l'importation de fichiers texte délimités (CSV/TXT) avec gestion fiable des coordonnées, des systèmes de référence spatiale et des imports en lot.

---

## ✨ Fonctionnalités

### 🎯 Import Simple

* **Formats supportés** : CSV, TSV, TXT (délimiteurs personnalisés)
* **Encodages** : UTF-8, ISO-8859-1, Windows-1252
* **Types de géométrie** :

  * Points (champs X/Y)
  * Géométrie WKT
  * Table attributaire seule
* **Formats de coordonnées** :

  * **DD** (Degrés Décimaux)
  * **DMS** (Degrés Minutes Secondes)
  * **UTM**
* **Gestion CRS** : définition explicite et reprojection à la volée

### 📦 Import en Lot

* Import de plusieurs fichiers en une seule opération
* Structures homogènes
* Modes : fusion en une couche ou couches séparées

### ✓ Validation Passive

* Vérification des plages de coordonnées
* Contrôle de cohérence CRS
* Alertes non bloquantes

---

## 📥 Installation

### Via le gestionnaire d’extensions QGIS (recommandé)

1. QGIS → **Extensions** → **Installer/Gérer les extensions**
2. Rechercher **"QText+"**
3. Cliquer sur **Installer**

### Installation Manuelle

```bash
# Linux / macOS
cd ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
git clone https://github.com/AzizT-dev/QTextplus.git QTextplus

# Windows
cd %APPDATA%\QGIS\QGIS3\profiles\default\python\plugins\
git clone https://github.com/AzizT-dev/QTextplus.git QTextplus
```

Redémarrer QGIS et activer l’extension.

---

## 👨‍💻 Auteur

**Aziz TRAORE**

* Email : [aziz.explorer@gmail.com](mailto:aziz.explorer@gmail.com)
* GitHub : [@AzizT-dev](https://github.com/AzizT-dev)

---

## 📄 Licence

GNU General Public License v2.0

---

**QText+ – Reliable text import workflows for QGIS**
