
# -*- coding: utf-8 -*-

"""
/***************************************************************************
Name			 	 : QSpatialReport
Description          : detailed spatial report from selected feature
Date                 : 12/Apr/13 
copyright            : (C) 2013 by GfosServices SA
email                : pierluigi.derosa@gfosservices.it 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import * 
from PyQt4.QtGui import *
from PyQt4 import uic
from qgis.core import *
from qgis.gui import *
from Ui_selectVincoli import Ui_selectVincoli
from Ui_QSpatialReport import Ui_QSpatialReport


class selectVincoli(QDockWidget,Ui_selectVincoli):
    def __init__(self,iface):
        QDockWidget.__init__(self)
        """initialize the GUI control"""
        QObject.__init__(self)
        self.iface = iface
        self.ui = Ui_selectVincoli ()
        self.ui.setupUi(self) 
        #~ self.iface.addDockWidget( Qt.RightDockWidgetArea, self )
        self.vectorLayers=[]
        self.setup_gui() 
        
        #~ connessioni degli oggetti
        QObject.connect(self.ui.regenButton,SIGNAL("clicked()"),self.setup_gui)
        QObject.connect(self.ui.runButton,SIGNAL("clicked()"),self.processaRun)
        

         
    def creaCombo (self,vettore):
        campi=vettore.dataProvider().fieldNameMap()
        comboCampi=QComboBox()
        comboCampi.addItems(campi.keys())
        return comboCampi
    
    def setup_gui( self ):
		if len(self.iface.mapCanvas().layers()) == 0:
			QMessageBox.critical(self.iface.mainWindow(),"QSpatialReport - Error", "Plugin requires you select at least one layer")
		else:
			try:
				LayerAct = self.iface.activeLayer()
			except AttributeError:
				QMessageBox.critical(self.iface.mainWindow(),"QSpatialReport - Error", "Plugin requires you select at least one layer")
			else:
				if LayerAct.type() != QgsMapLayer.VectorLayer:
					QMessageBox.critical(self.iface.mainWindow(),"QSpatialReport - Error", "Plugin requires you select a vector layer.")
				else:
					self.ui.labelLayerSelected.setText('selected Layer: %s' %( LayerAct.name() ))
					curr_map_layers = QgsMapLayerRegistry.instance().mapLayers()
					vectorLayers = filter( lambda layer: layer.type() == QgsMapLayer.VectorLayer, curr_map_layers.values() )
					vectorLayersNoAct = filter( lambda layer: layer.name() != LayerAct.name(), vectorLayers )
					self.vectorLayers=vectorLayersNoAct
						
					self.ui.treeWidget.clear()
					for idvlayer in range(len(vectorLayersNoAct)):
						item=QTreeWidgetItem()            
						item.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled) 
						item.setCheckState(0,Qt.Checked)
						item.setText(0,vectorLayersNoAct[idvlayer].name())
						self.ui.treeWidget.addTopLevelItem(item)
						
						fields = vectorLayersNoAct[idvlayer].dataProvider().fieldNameMap().keys()
						for field in range(len(fields)):
							vincItem=QTreeWidgetItem(item)
							vincItem.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled) 
							vincItem.setCheckState(0,Qt.Checked)
							vincItem.setText(0,str(fields[field]))
						self.ui.treeWidget.expandItem(item)


    def processaRun(self):
        dialog = QDialog()
        dialog.ui = Ui_QSpatialReport ()
        dialog.ui.setupUi(dialog)
        dialog.ui.textBrowser.append('Final report of QSpacialReport Plugin')
        LayerAct = self.iface.activeLayer()
        if len(LayerAct.selectedFeatures()) == 0:
			QMessageBox.warning(self.iface.mainWindow(),"QSpatialReport - Warning", "You haven't selected any feature from layer %s" % (LayerAct.name()) )
        else: 
	        for selElements in LayerAct.selectedFeatures():
	            dialog.ui.textBrowser.append('id Feature '+LayerAct.name()+' selected: '+str(selElements.id()))
	            for idItem in range(self.ui.treeWidget.topLevelItemCount() ):
	                item=self.ui.treeWidget.topLevelItem(idItem)
	                if item.checkState(0) == Qt.Checked:
	                    #~ prendo il layer selezionato
	                    vLayer = filter( lambda layer: layer.name() == item.text(0), self.vectorLayers ) [0]
	                    #~ devo vedere i figli items e ciclo su ogni figlio
	                    provider = vLayer.dataProvider()
	                    dialog.ui.textBrowser.append('********************************************* \n ---------------------- \n Layer: '+str(vLayer.name())+':\n---------------------- ')
	                    attrIndexes=[]
	                    for counterChild in range(item.childCount() ):
	                        itemField=item.child(counterChild)
	                        if itemField.checkState(0) == Qt.Checked:
	                            attrIndexes.append(provider.fieldNameIndex(itemField.text(0)))
	
	                    #~ trovo gli id di tutte le fature che toccano il mio elemento selElements
	                    provider.select(attrIndexes)
	                    feat = QgsFeature()
	                    ind=[]
	                    while provider.nextFeature(feat):
	                        if selElements.geometry().intersects(feat.geometry()):
	                            ind.append(feat.id())
	                    if len(ind) == 0: dialog.ui.textBrowser.append('None elements overlaps')
	                    feat = QgsFeature()
	                    for indx in ind:
	                        vLayer.featureAtId(indx,feat)
	                        dialog.ui.textBrowser.append('\t element id: ' + str(feat.id()))
	                        dialog.ui.textBrowser.append('\t \t area: ' + str(feat.geometry().area()))
	                        dialog.ui.textBrowser.append('\t \t percentage overlapping area: ' +str(round(feat.geometry().intersection(selElements.geometry()).area()/selElements.geometry().area()*100,2))+'% \n \t \t ATTRIBUTE DATA FROM OVERLAPPED GEOMETRY') #area di intersezione
	                        #~ scrivo i dati della tabella attributi
	                        attrs = feat.attributeMap()
	                        for attrIndex in attrIndexes:
	                            value = attrs.get(attrIndex).toString()
	                            nome_campo=''
	                            for campo, indice in provider.fieldNameMap().iteritems():
	                                if indice == attrIndex:
	                                    nome_campo=campo
	                            dialog.ui.textBrowser.append("\t \t %s: %s" % (nome_campo, value) )
	                            
	            dialog.ui.textBrowser.append("\n \n")
	         
	        #~ QMessageBox.information( self.iface.mainWindow(), "testing...", QString('numero di top level flaggati %s' %(conta) ))
	        
	        dialog.exec_()
	
