"""
/***************************************************************************
Name			 	 : QSpatialReport
Description          : detailed spatial report from selected feature
Date                 : 12/Apr/13 
copyright            : (C) 2013 by GfosServices SA
email                : pierluigi.derosa@gfosservices.it 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import * 
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from QSpatialReportDialog import QSpatialReportDialog
from selectVincoli import selectVincoli

class QSpatialReport: 

  def __init__(self, iface):
    # Save reference to the QGIS interface
    self.iface = iface

  def initGui(self):  
  
  
    self.dockWidget=None
    #~ self.dockWidget=selectVincoli(self.iface)

    # Create action that will start plugin configuration
    self.DefAction = QAction(QIcon(":/plugins/QSpatialReport/icons/report.png"), \
        "QSpatialReport", self.iface.mainWindow())
    self.DefAction.setWhatsThis("Create reports for feature selected")
    # connect the action to the run method
    QObject.connect(self.DefAction, SIGNAL("triggered()"), self.DefActionRun)
    
    self.aboutAction = QAction("About", self.iface.mainWindow())
    QObject.connect(self.aboutAction, SIGNAL("triggered()"), self.about)

    # Add toolbar button and menu item
    self.iface.addToolBarIcon(self.DefAction)
    self.iface.addPluginToMenu("&QSpatialReport", self.DefAction)
    self.iface.addPluginToMenu("&QSpatialReport", self.aboutAction)

  def unload(self):
    # Remove the plugin menu item and icon
    self.iface.removePluginMenu("&QSpatialReport",self.DefAction)
    self.iface.removeToolBarIcon(self.DefAction)
    self.iface.removePluginMenu("&QSpatialReport", self.aboutAction)

  # run method that performs all the real work

  
  def DefActionRun(self):
      
      if len(self.iface.mapCanvas().layers()) > 0 and self.iface.activeLayer() == None:
         QMessageBox.critical(self.iface.mainWindow(),"QSpatialReport - Error", "Plugin requires you select at least one layer")
      elif len(self.iface.mapCanvas().layers()) == 0:
		 QMessageBox.critical(self.iface.mainWindow(),"QSpatialReport - Error", "Plugin requires load at least one layer")
      else:
		  self.dockWidget=selectVincoli(self.iface)
		  if self.dockWidget.isVisible():
			  self.dockWidget.hide()
		  else:
			  self.dockWidget.show()
			  self.iface.addDockWidget( Qt.RightDockWidgetArea, self.dockWidget )

  def about(self):
      from about import AboutDialog
      dlg=AboutDialog()
      dlg.exec_()
