# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QRestart
                                 A QGIS plugin
 A plugin that allows users to restart the QGIS.


 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-02-26
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Marios S. Kyriakou, KIOS Research and Innovation Center of Excellence (KIOS CoE)
        email                : mariosmsk@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QProcess
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QMessageBox

from qgis.core import QgsApplication, QgsProject

import os.path

try:
    from . import resources  # noqa: F401
except Exception:
    resources = None


class QRestart:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        locale = (QSettings().value("locale/userLocale") or "en")[0:2]
        locale_path = os.path.join(self.plugin_dir, "i18n", f"QRestart_{locale}.qm")

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr("&QRestart")

        self.toolbar = self.iface.addToolBar("QRestart")
        self.toolbar.setObjectName("QRestart")

        self.first_start = None

    def tr(self, message):
        return QCoreApplication.translate("QRestart", message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None,
    ):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = ":/plugins/qrestart/icon.png"
        self.add_action(
            icon_path,
            text=self.tr("Restart QGIS"),
            callback=self.run,
            parent=self.iface.mainWindow(),
        )
        self.first_start = True

    def unload(self):
        for action in self.actions:
            try:
                self.iface.removePluginMenu(self.menu, action)
            except Exception:
                pass
            try:
                self.toolbar.removeAction(action)
            except Exception:
                pass

    def _ask_to_save_if_dirty(self):
        if not QgsProject.instance().isDirty():
            return True

        msg_box = QMessageBox(self.iface.mainWindow())
        msg_box.setWindowTitle(self.tr("Save project"))
        msg_box.setText(self.tr("Do you want to save the changes to the project?"))

        # Qt6 uses QMessageBox.StandardButton enum (Save/Discard/Cancel are not attributes on QMessageBox)
        buttons = (
            QMessageBox.StandardButton.Save
            | QMessageBox.StandardButton.Discard
            | QMessageBox.StandardButton.Cancel
        )
        msg_box.setStandardButtons(buttons)
        msg_box.setDefaultButton(QMessageBox.StandardButton.Save)
        msg_box.setIcon(QMessageBox.Icon.Information)

        exec_fn = getattr(msg_box, "exec", None) or getattr(msg_box, "exec_", None)
        clicked = exec_fn()

        # clicked can be int (Qt5) or StandardButton (Qt6). Normalize.
        if int(clicked) == int(QMessageBox.StandardButton.Save):
            self.iface.actionSaveProject().trigger()
            return True

        if int(clicked) == int(QMessageBox.StandardButton.Discard):
            QgsProject.instance().clear()
            return True

        return False

    def run(self):
        if not self._ask_to_save_if_dirty():
            return

        qgis_exe = QgsApplication.applicationFilePath()
        if not qgis_exe:
            QMessageBox.warning(
                self.iface.mainWindow(),
                self.tr("Restart QGIS"),
                self.tr("Could not determine the QGIS executable path."),
            )
            return

        QProcess.startDetached(qgis_exe, [])
        self.iface.actionExit().trigger()
