/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);

    public static String initializeProperty(String propName, String defaultValue) {
        List<String> propVal = PropertyManager.__().getProperty(propName);
        if (propVal == null || propVal.size() == 0) {
            propVal = new ArrayList<String>(1);
            propVal.add(defaultValue);
            PropertyManager.__().setProperty(propName, propVal);
            logger.info("No default value for [{}]; setting to [{}]", (Object)propName, (Object)defaultValue);
            return defaultValue;
        }
        return propVal.get(0);
    }

    public static String genUUID() {
        return PropertyUtils.randHex(8) + "-" + PropertyUtils.randHex(4) + "-4" + PropertyUtils.randHex(3) + "-" + Integer.toString(8 + MathUtils.getRand().nextInt(4), 16) + PropertyUtils.randHex(3) + "-" + PropertyUtils.randHex(12);
    }

    public static String genGUID(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(Integer.toString(MathUtils.getRand().nextInt(36), 36));
        }
        return b.toString().toUpperCase();
    }

    public static String randHex(int len) {
        StringBuilder b = new StringBuilder();
        Random r = MathUtils.getRand();
        for (int i = 0; i < len; ++i) {
            b.append(Integer.toString(r.nextInt(16), 16));
        }
        return b.toString();
    }

    public static String trim(String guid, int len) {
        return guid.substring(0, Math.min(len, guid.length()));
    }
}

