/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.transport.payload;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.MultiInputStream;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class MultiMessagePayload
implements IDataPayload {
    List<IDataPayload> payloads = new ArrayList<IDataPayload>(1);

    public void addPayload(IDataPayload payload) {
        this.payloads.add(payload);
    }

    public List<IDataPayload> getPayloads() {
        return this.payloads;
    }

    @Override
    public InputStream getPayloadStream() throws IOException {
        MultiInputStream bigStream = new MultiInputStream();
        for (IDataPayload payload : this.payloads) {
            bigStream.addStream(payload.getPayloadStream());
        }
        bigStream.prepare();
        return bigStream;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.payloads = (List)ExtUtil.read(in, new ExtWrapListPoly(), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapListPoly(this.payloads));
    }

    @Override
    public <T> T accept(IDataPayloadVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getPayloadId() {
        return null;
    }

    @Override
    public int getPayloadType() {
        return 4;
    }

    @Override
    public int getTransportId() {
        return -1;
    }

    @Override
    public long getLength() {
        int len = 0;
        for (IDataPayload payload : this.payloads) {
            len = (int)((long)len + payload.getLength());
        }
        return len;
    }
}

