/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.utils;

import java.util.Date;
import java.util.List;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.model.utils.IPreloadHandler;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.util.Map;
import org.javarosa.core.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionPreloader {
    private static final Logger logger = LoggerFactory.getLogger(QuestionPreloader.class);
    private Map<String, IPreloadHandler> preloadHandlers = new Map();

    public QuestionPreloader() {
        this.initPreloadHandlers();
    }

    private void initPreloadHandlers() {
        IPreloadHandler date = new IPreloadHandler(){

            @Override
            public String preloadHandled() {
                return "date";
            }

            @Override
            public IAnswerData handlePreload(String preloadParams) {
                return QuestionPreloader.this.preloadDate(preloadParams);
            }

            @Override
            public boolean handlePostProcess(TreeElement node, String params) {
                return false;
            }
        };
        IPreloadHandler property = new IPreloadHandler(){

            @Override
            public String preloadHandled() {
                return "property";
            }

            @Override
            public IAnswerData handlePreload(String preloadParams) {
                return QuestionPreloader.this.preloadProperty(preloadParams);
            }

            @Override
            public boolean handlePostProcess(TreeElement node, String params) {
                QuestionPreloader.this.saveProperty(params, node);
                return false;
            }
        };
        IPreloadHandler timestamp = new IPreloadHandler(){

            @Override
            public String preloadHandled() {
                return "timestamp";
            }

            @Override
            public IAnswerData handlePreload(String preloadParams) {
                return "start".equals(preloadParams) ? QuestionPreloader.this.getTimestamp() : null;
            }

            @Override
            public boolean handlePostProcess(TreeElement node, String params) {
                if ("end".equals(params)) {
                    node.setAnswer(QuestionPreloader.this.getTimestamp());
                    return true;
                }
                return false;
            }
        };
        IPreloadHandler uid = new IPreloadHandler(){

            @Override
            public String preloadHandled() {
                return "uid";
            }

            @Override
            public IAnswerData handlePreload(String preloadParams) {
                return new StringData(PropertyUtils.genGUID(25));
            }

            @Override
            public boolean handlePostProcess(TreeElement node, String params) {
                return false;
            }
        };
        this.addPreloadHandler(date);
        this.addPreloadHandler(property);
        this.addPreloadHandler(timestamp);
        this.addPreloadHandler(uid);
    }

    public void addPreloadHandler(IPreloadHandler handler) {
        this.preloadHandlers.put(handler.preloadHandled(), handler);
    }

    public IAnswerData getQuestionPreload(String preloadType, String preloadParams) {
        IPreloadHandler handler = this.preloadHandlers.get(preloadType);
        if (handler != null) {
            return handler.handlePreload(preloadParams);
        }
        logger.error("Do not know how to handle preloader [{}]", (Object)preloadType);
        return null;
    }

    public boolean questionPostProcess(TreeElement node, String preloadType, String params) {
        IPreloadHandler handler = this.preloadHandlers.get(preloadType);
        if (handler != null) {
            return handler.handlePostProcess(node, params);
        }
        logger.error("Do not know how to handle preloader [{}]", (Object)preloadType);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAnswerData preloadDate(String preloadParams) {
        Date d = null;
        if (preloadParams.equals("today")) {
            d = new Date();
            return new DateData(d);
        }
        if (!preloadParams.substring(0, 11).equals("prevperiod-")) return new DateData(d);
        List<String> v = DateUtils.split(preloadParams.substring(11), "-", false);
        String[] params = new String[v.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = v.get(i);
        }
        try {
            boolean includeToday;
            boolean beginning;
            String type = params[0];
            String start = params[1];
            if (params[2].equals("head")) {
                beginning = true;
            } else {
                if (!params[2].equals("tail")) throw new RuntimeException();
                beginning = false;
            }
            if (params.length >= 4) {
                if (params[3].equals("x")) {
                    includeToday = true;
                } else {
                    if (!params[3].equals("")) throw new RuntimeException();
                    includeToday = false;
                }
            } else {
                includeToday = false;
            }
            int nAgo = params.length >= 5 ? Integer.parseInt(params[4]) : 1;
            d = DateUtils.getPastPeriodDate(new Date(), type, start, beginning, includeToday, nAgo);
            return new DateData(d);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid preload params for preload mode 'date'");
        }
    }

    private IAnswerData preloadProperty(String preloadParams) {
        String propname = preloadParams;
        String propval = PropertyManager.__().getSingularProperty(propname);
        StringData data = null;
        if (propval != null && propval.length() > 0) {
            data = new StringData(propval);
        }
        return data;
    }

    private void saveProperty(String propName, TreeElement node) {
        String value;
        IAnswerData answer = node.getValue();
        String string = value = answer == null ? null : answer.getDisplayText();
        if (propName != null && propName.length() > 0 && value != null && value.length() > 0) {
            PropertyManager.__().setProperty(propName, value);
        }
    }

    private DateTimeData getTimestamp() {
        return new DateTimeData(new Date());
    }
}

