/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class Condition
extends Triggerable {
    public static final int ACTION_NULL = 0;
    public static final int ACTION_SHOW = 1;
    public static final int ACTION_HIDE = 2;
    public static final int ACTION_ENABLE = 3;
    public static final int ACTION_DISABLE = 4;
    public static final int ACTION_LOCK = 5;
    public static final int ACTION_UNLOCK = 6;
    public static final int ACTION_REQUIRE = 7;
    public static final int ACTION_DONT_REQUIRE = 8;
    public int trueAction;
    public int falseAction;

    public Condition() {
    }

    public Condition(IConditionExpr expr, int trueAction, int falseAction, TreeReference contextRef) {
        this(expr, trueAction, falseAction, contextRef, new ArrayList<TreeReference>(0));
    }

    public Condition(IConditionExpr expr, int trueAction, int falseAction, TreeReference contextRef, ArrayList<TreeReference> targets) {
        super(expr, contextRef, targets);
        this.trueAction = trueAction;
        this.falseAction = falseAction;
    }

    @Override
    public Object eval(FormInstance model, EvaluationContext evalContext) {
        return this.evalPredicate(model, evalContext);
    }

    public boolean evalBool(FormInstance model, EvaluationContext evalContext) {
        return (Boolean)this.eval(model, evalContext);
    }

    @Override
    public void apply(TreeReference ref, Object rawResult, FormInstance mainInstance) {
        boolean result = (Boolean)rawResult;
        this.performAction((TreeElement)mainInstance.resolveReference(ref), result ? this.trueAction : this.falseAction);
    }

    @Override
    public boolean canCascade() {
        return this.trueAction == 1 || this.trueAction == 2;
    }

    @Override
    public boolean isCascadingToChildren() {
        return this.trueAction == 1 || this.trueAction == 2;
    }

    private void performAction(TreeElement node, int action) {
        switch (action) {
            case 0: {
                break;
            }
            case 1: {
                node.setRelevant(true);
                break;
            }
            case 2: {
                node.setRelevant(false);
                break;
            }
            case 3: {
                node.setEnabled(true);
                break;
            }
            case 4: {
                node.setEnabled(false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                node.setRequired(true);
                break;
            }
            case 8: {
                node.setRequired(false);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Condition) {
            Condition c = (Condition)o;
            if (this == c) {
                return true;
            }
            return this.trueAction == c.trueAction && this.falseAction == c.falseAction && super.equals(c);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        super.readExternal(in, pf);
        this.trueAction = ExtUtil.readInt(in);
        this.falseAction = ExtUtil.readInt(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        super.writeExternal(out);
        ExtUtil.writeNumeric(out, this.trueAction);
        ExtUtil.writeNumeric(out, this.falseAction);
    }
}

