/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.XFormParseException;

public class SelectChoice
implements Externalizable,
Localizable {
    private String labelInnerText;
    private String textID;
    private boolean isLocalizable;
    private String value;
    private int index = -1;
    public TreeElement copyNode;

    public SelectChoice() {
    }

    public SelectChoice(String labelID, String value) {
        this(labelID, null, value, true);
    }

    public SelectChoice(String labelID, String labelInnerText, String value, boolean isLocalizable) {
        this.isLocalizable = isLocalizable;
        this.textID = labelID;
        this.labelInnerText = labelInnerText;
        if (value == null) {
            throw new XFormParseException("SelectChoice{id,innerText}:{" + labelID + "," + labelInnerText + "}, has null Value!");
        }
        this.value = value;
    }

    public SelectChoice(String labelOrID, String Value, boolean isLocalizable) {
        this(isLocalizable ? labelOrID : null, isLocalizable ? null : labelOrID, Value, isLocalizable);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    public String getValue() {
        return this.value;
    }

    public int getIndex() {
        if (this.index == -1) {
            throw new RuntimeException("trying to access choice index before it has been set!");
        }
        return this.index;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.isLocalizable = ExtUtil.readBool(in);
        this.setLabelInnerText(ExtUtil.nullIfEmpty(ExtUtil.readString(in)));
        this.setTextID(ExtUtil.nullIfEmpty(ExtUtil.readString(in)));
        this.value = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeBool(out, this.isLocalizable);
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.labelInnerText));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.textID));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.value));
    }

    private void setLabelInnerText(String labelInnerText) {
        this.labelInnerText = labelInnerText;
    }

    public Selection selection() {
        return new Selection(this);
    }

    public boolean isLocalizable() {
        return this.isLocalizable;
    }

    public void setLocalizable(boolean localizable) {
        this.isLocalizable = localizable;
    }

    public String toString() {
        return (this.textID != null && this.textID.length() > 0 ? "{" + this.textID + "}" : "") + (this.labelInnerText != null ? this.labelInnerText : "") + " => " + this.value;
    }

    public String getTextID() {
        return this.textID;
    }

    public void setTextID(String textID) {
        this.textID = textID;
    }
}

