/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class SortedIntSet
implements Externalizable {
    List<Integer> v = new ArrayList<Integer>(0);

    public int add(int n) {
        int i = this.indexOf(n, false);
        if (i != -1 && this.get(i) == n) {
            return -1;
        }
        this.v.add(i + 1, n);
        return i + 1;
    }

    public int remove(int n) {
        int i = this.indexOf(n, true);
        if (i != -1) {
            this.v.remove(i);
        }
        return i;
    }

    public int get(int i) {
        return this.v.get(i);
    }

    public boolean contains(int n) {
        return this.indexOf(n, true) != -1;
    }

    public int indexOf(int n, boolean exact) {
        int lo = 0;
        int hi = this.v.size() - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            int val = this.get(mid);
            if (val < n) {
                lo = mid + 1;
                continue;
            }
            if (val > n) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return exact ? -1 : lo - 1;
    }

    public int size() {
        return this.v.size();
    }

    public List<Integer> getList() {
        return this.v;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.v = (List)ExtUtil.read(in, new ExtWrapList(Integer.class));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapList(this.v));
    }
}

