/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.Reference;
import org.javarosa.core.reference.ReferenceFactory;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class RootTranslator
implements ReferenceFactory,
Externalizable {
    public String prefix;
    public String translatedPrefix;

    public RootTranslator() {
    }

    public RootTranslator(String prefix, String translatedPrefix) {
        this.prefix = prefix;
        this.translatedPrefix = translatedPrefix;
    }

    @Override
    public Reference derive(String URI2) throws InvalidReferenceException {
        return ReferenceManager.instance().DeriveReference(this.translatedPrefix + URI2.substring(this.prefix.length()));
    }

    @Override
    public Reference derive(String URI2, String context) throws InvalidReferenceException {
        return ReferenceManager.instance().DeriveReference(URI2, this.translatedPrefix + context.substring(this.prefix.length()));
    }

    @Override
    public boolean derives(String URI2) {
        return URI2.startsWith(this.prefix);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.prefix = ExtUtil.readString(in);
        this.translatedPrefix = ExtUtil.readString(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.writeString(out, this.prefix);
        ExtUtil.writeString(out, this.translatedPrefix);
    }
}

