/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.javarosa.core.model.DataType;
import org.javarosa.core.model.DataTypeClasses;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.InstanceTemplateManager;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.StorageManager;
import org.javarosa.core.services.storage.WrappingStorageUtility;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class CompactInstanceWrapper
implements WrappingStorageUtility.SerializationWrapper {
    public static final int CHOICE_VALUE = 0;
    public static final int CHOICE_INDEX = 1;
    public static final int CHOICE_MODE = 1;
    private InstanceTemplateManager templateMgr;
    private FormInstance instance;

    public CompactInstanceWrapper() {
        this(null);
    }

    public CompactInstanceWrapper(InstanceTemplateManager templateMgr) {
        this.templateMgr = templateMgr;
    }

    @Override
    public Class baseType() {
        return FormInstance.class;
    }

    @Override
    public void setData(Externalizable e) {
        this.instance = (FormInstance)e;
    }

    @Override
    public Externalizable getData() {
        return this.instance;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        int formID = ExtUtil.readInt(in);
        this.instance = this.getTemplateInstance(formID).clone();
        this.instance.setID(ExtUtil.readInt(in));
        this.instance.setDateSaved((Date)ExtUtil.read(in, new ExtWrapNullable(Date.class)));
        TreeElement root = this.instance.getRoot();
        this.readTreeElement(root, in, pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        if (this.instance == null) {
            throw new RuntimeException("instance has not yet been set via setData()");
        }
        ExtUtil.writeNumeric(out, this.instance.getFormId());
        ExtUtil.writeNumeric(out, this.instance.getID());
        ExtUtil.write(out, new ExtWrapNullable(this.instance.getDateSaved()));
        this.writeTreeElement(out, this.instance.getRoot());
    }

    private FormInstance getTemplateInstance(int formID) {
        if (this.templateMgr != null) {
            return this.templateMgr.getTemplateInstance(formID);
        }
        FormInstance template = CompactInstanceWrapper.loadTemplateInstance(formID);
        if (template == null) {
            throw new RuntimeException("no formdef found for form id [" + formID + "]");
        }
        return template;
    }

    public static FormInstance loadTemplateInstance(int formID) {
        IStorageUtility<? extends Externalizable> forms = StorageManager.getStorage("FORMDEF");
        FormDef f = (FormDef)forms.read(formID);
        return f != null ? f.getMainInstance() : null;
    }

    private void readTreeElement(TreeElement e, DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        boolean isGroup;
        TreeElement templ = (TreeElement)this.instance.getTemplatePath(e.getRef());
        boolean bl = isGroup = !templ.isLeaf();
        if (isGroup) {
            String childName;
            int i;
            ArrayList<String> childTypes = new ArrayList<String>(templ.getNumChildren());
            for (i = 0; i < templ.getNumChildren(); ++i) {
                childName = templ.getChildAt(i).getName();
                if (childTypes.contains(childName)) continue;
                childTypes.add(childName);
            }
            for (i = 0; i < childTypes.size(); ++i) {
                boolean relevant;
                childName = (String)childTypes.get(i);
                TreeReference childTemplRef = e.getRef().extendRef(childName, 0);
                TreeElement childTempl = (TreeElement)this.instance.getTemplatePath(childTemplRef);
                boolean repeatable = childTempl.isRepeatable();
                int n = ExtUtil.readInt(in);
                boolean bl2 = relevant = n > 0;
                if (!repeatable && n > 1) {
                    throw new DeserializationException("Detected repeated instances of a non-repeatable node");
                }
                if (repeatable) {
                    int j;
                    int mult = e.getChildMultiplicity(childName);
                    for (j = mult - 1; j >= 0; --j) {
                        e.removeChild(childName, j);
                    }
                    for (j = 0; j < n; ++j) {
                        TreeReference dstRef = e.getRef().extendRef(childName, j);
                        try {
                            this.instance.copyNode(childTempl, dstRef);
                        }
                        catch (InvalidReferenceException ire) {
                            TreeReference r = ire.getInvalidReference();
                            if (r == null) {
                                throw new DeserializationException("Null Reference while attempting to deserialize! " + ire.getMessage());
                            }
                            throw new DeserializationException("Invalid Reference while attemtping to deserialize! Reference: " + r.toString(true) + " | " + ire.getMessage());
                        }
                        TreeElement child = e.getChild(childName, j);
                        child.setRelevant(true);
                        this.readTreeElement(child, in, pf);
                    }
                    continue;
                }
                TreeElement child = e.getChild(childName, 0);
                child.setRelevant(relevant);
                if (!relevant) continue;
                this.readTreeElement(child, in, pf);
            }
        } else {
            e.setValue((IAnswerData)ExtUtil.read(in, new ExtWrapAnswerData(e.getDataType())));
        }
    }

    private void writeTreeElement(DataOutputStream out, TreeElement e) throws IOException {
        boolean isGroup;
        TreeElement templ = (TreeElement)this.instance.getTemplatePath(e.getRef());
        boolean bl = isGroup = !templ.isLeaf();
        if (isGroup) {
            ArrayList<String> childTypesHandled = new ArrayList<String>(templ.getNumChildren());
            for (int i = 0; i < templ.getNumChildren(); ++i) {
                String childName = templ.getChildAt(i).getName();
                if (childTypesHandled.contains(childName)) continue;
                childTypesHandled.add(childName);
                int mult = e.getChildMultiplicity(childName);
                if (mult > 0 && !e.getChild(childName, 0).isRelevant()) {
                    mult = 0;
                }
                ExtUtil.writeNumeric(out, mult);
                for (int j = 0; j < mult; ++j) {
                    this.writeTreeElement(out, e.getChild(childName, j));
                }
            }
        } else {
            ExtUtil.write(out, new ExtWrapAnswerData(e.getDataType(), e.getValue()));
        }
    }

    private Object compactSelectOne(SelectOneData data) {
        Selection val = (Selection)data.getValue();
        return this.extractSelection(val);
    }

    private List<Object> compactSelectMulti(MultipleItemsData data) {
        List val = (List)data.getValue();
        ArrayList<Object> choices = new ArrayList<Object>(val.size());
        for (int i = 0; i < val.size(); ++i) {
            choices.add(this.extractSelection((Selection)val.get(i)));
        }
        return choices;
    }

    private SelectOneData getSelectOne(Object o) {
        return new SelectOneData(this.makeSelection(o));
    }

    private MultipleItemsData getSelectMulti(List<Object> v) {
        ArrayList<Selection> choices = new ArrayList<Selection>(v.size());
        for (int i = 0; i < v.size(); ++i) {
            choices.add(this.makeSelection(v.get(i)));
        }
        return new MultipleItemsData(choices);
    }

    private Object extractSelection(Selection s) {
        switch (1) {
            case 0: {
                return s.getValue();
            }
            case 1: {
                if (s.index == -1) {
                    throw new RuntimeException("trying to serialize in choice-index mode but selections do not have indexes set!");
                }
                return s.index;
            }
        }
        throw new IllegalArgumentException();
    }

    private Selection makeSelection(Object o) {
        if (o instanceof String) {
            return new Selection((String)o);
        }
        if (o instanceof Integer) {
            return new Selection((Integer)o);
        }
        throw new RuntimeException();
    }

    @Override
    public void clean() {
    }

    public static Class classForDataType(int dataType) {
        return DataTypeClasses.classForType(DataType.from(dataType));
    }

    private class ExtWrapAnswerData
    extends ExternalizableWrapper {
        int dataType;

        public ExtWrapAnswerData(int dataType, IAnswerData val) {
            this.val = val;
            this.dataType = dataType;
        }

        public ExtWrapAnswerData(int dataType) {
            this.dataType = dataType;
        }

        @Override
        public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
            byte flag = in.readByte();
            if (flag == 0) {
                this.val = null;
            } else {
                Class answerType = CompactInstanceWrapper.classForDataType(this.dataType);
                if (answerType == null) {
                    this.val = ExtUtil.read(in, new ExtWrapTagged(), pf);
                } else if (answerType == SelectOneData.class) {
                    this.val = CompactInstanceWrapper.this.getSelectOne(ExtUtil.read(in, Integer.class));
                } else if (answerType == MultipleItemsData.class) {
                    this.val = CompactInstanceWrapper.this.getSelectMulti((List)ExtUtil.read(in, new ExtWrapList(Integer.class)));
                } else {
                    switch (flag) {
                        case 64: {
                            answerType = StringData.class;
                            break;
                        }
                        case 65: {
                            answerType = IntegerData.class;
                            break;
                        }
                        case 66: {
                            answerType = DecimalData.class;
                            break;
                        }
                        case 67: {
                            answerType = DateData.class;
                            break;
                        }
                        case 68: {
                            answerType = BooleanData.class;
                        }
                    }
                    this.val = (IAnswerData)ExtUtil.read(in, answerType);
                }
            }
        }

        @Override
        public void writeExternal(DataOutputStream out) throws IOException {
            if (this.val == null) {
                out.writeByte(0);
            } else {
                Externalizable serEntity;
                int prefix = 1;
                if (this.dataType < 0 || this.dataType >= 100) {
                    serEntity = new ExtWrapTagged(this.val);
                } else if (this.val instanceof SelectOneData) {
                    serEntity = new ExtWrapBase(CompactInstanceWrapper.this.compactSelectOne((SelectOneData)this.val));
                } else if (this.val instanceof MultipleItemsData) {
                    serEntity = new ExtWrapList(CompactInstanceWrapper.this.compactSelectMulti((MultipleItemsData)this.val));
                } else {
                    serEntity = (IAnswerData)this.val;
                    if (this.val.getClass() != CompactInstanceWrapper.classForDataType(this.dataType)) {
                        if (this.val instanceof StringData) {
                            prefix = 64;
                        } else if (this.val instanceof IntegerData) {
                            prefix = 65;
                        } else if (this.val instanceof DecimalData) {
                            prefix = 66;
                        } else if (this.val instanceof DateData) {
                            prefix = 67;
                        } else if (this.val instanceof BooleanData) {
                            prefix = 68;
                        } else {
                            throw new RuntimeException("divergent data type not allowed");
                        }
                    }
                }
                out.writeByte(prefix);
                ExtUtil.write(out, serEntity);
            }
        }

        @Override
        public ExternalizableWrapper clone(Object val) {
            throw new RuntimeException("not supported");
        }

        @Override
        public void metaReadExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
            throw new RuntimeException("not supported");
        }

        @Override
        public void metaWriteExternal(DataOutputStream out) throws IOException {
            throw new RuntimeException("not supported");
        }
    }
}

