/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class XPathQName
implements Externalizable {
    public String namespace;
    public String name;

    public XPathQName() {
    }

    public XPathQName(String qname) {
        int sep;
        int n = sep = qname == null ? -1 : qname.indexOf(":");
        if (sep == -1) {
            this.init(null, qname);
        } else {
            this.init(qname.substring(0, sep), qname.substring(sep + 1));
        }
    }

    public XPathQName(String namespace, String name) {
        this.init(namespace, name);
    }

    public int hashCode() {
        return this.name.hashCode() | (this.namespace == null ? 0 : this.namespace.hashCode());
    }

    private void init(String namespace, String name) {
        if (name == null || name != null && name.length() == 0 || namespace != null && namespace.length() == 0) {
            throw new IllegalArgumentException("Invalid QName");
        }
        this.namespace = namespace;
        this.name = name;
    }

    public String toString() {
        return this.namespace == null ? this.name : this.namespace + ":" + this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof XPathQName) {
            XPathQName x = (XPathQName)o;
            return ExtUtil.equals(this.namespace, x.namespace) && this.name.equals(x.name);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.namespace = (String)ExtUtil.read(in, new ExtWrapNullable(String.class));
        this.name = ExtUtil.readString(in);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapNullable(this.namespace));
        ExtUtil.writeString(out, this.name);
    }
}

