/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.GeoUtils;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.XPathUnhandledException;
import org.javarosa.xpath.expr.XPathFuncExpr;

class XPathFuncExprGeo {
    XPathFuncExprGeo() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<GeoUtils.LatLong> getGpsCoordinatesFromNodeset(String name, Object argVal) {
        if (!(argVal instanceof XPathNodeset)) {
            throw new XPathUnhandledException("function '" + name + "' requires a field as the parameter.");
        }
        Object[] argList = ((XPathNodeset)argVal).toArgList();
        int repeatSize = argList.length;
        ArrayList<GeoUtils.LatLong> latLongs = new ArrayList<GeoUtils.LatLong>();
        if (repeatSize == 1) {
            try {
                GeoShapeData geoShapeData = new GeoShapeData().cast(new UncastData(XPathFuncExpr.toString(argList[0])));
                if (geoShapeData.points.size() <= 2) return latLongs;
                for (GeoPointData point : geoShapeData.points) {
                    latLongs.add(new GeoUtils.LatLong(point.getPart(0), point.getPart(1)));
                }
                return latLongs;
            }
            catch (Exception e) {
                throw new XPathTypeMismatchException("The function '" + name + "' received a value that does not represent GPS coordinates: " + argList[0]);
            }
        } else {
            if (repeatSize < 2) return latLongs;
            for (Object arg : argList) {
                try {
                    GeoPointData geoPointData = new GeoPointData().cast(new UncastData(XPathFuncExpr.toString(arg)));
                    latLongs.add(new GeoUtils.LatLong(geoPointData.getPart(0), geoPointData.getPart(1)));
                }
                catch (Exception e) {
                    throw new XPathTypeMismatchException("The function '" + name + "' received a value that does not represent GPS coordinates: " + arg);
                }
            }
        }
        return latLongs;
    }
}

