/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xml;

import java.io.IOException;
import java.util.HashMap;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.xml.ElementParser;
import org.javarosa.xml.util.InvalidStructureException;
import org.javarosa.xml.util.UnfullfilledRequirementsException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TreeElementParser
extends ElementParser<TreeElement> {
    private final int multiplicity;
    private final String instanceId;

    public TreeElementParser(KXmlParser parser, int multiplicity, String instanceId) {
        super(parser);
        this.multiplicity = multiplicity;
        this.instanceId = instanceId;
    }

    @Override
    public TreeElement parse() throws InvalidStructureException, IOException, XmlPullParserException, UnfullfilledRequirementsException {
        int depth = this.parser.getDepth();
        TreeElement element = new TreeElement(this.parser.getName(), this.multiplicity);
        element.setInstanceName(this.instanceId);
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            element.setAttribute(this.parser.getAttributeNamespace(i), this.parser.getAttributeName(i), this.parser.getAttributeValue(i));
        }
        HashMap<String, Integer> multiplicitiesByName = new HashMap<String, Integer>();
        block6: while (this.parser.getDepth() >= depth) {
            switch (this.nextNonWhitespace()) {
                case 2: {
                    String name = this.parser.getName();
                    Integer multiplicity = (Integer)multiplicitiesByName.get(name);
                    int newMultiplicity = multiplicity != null ? multiplicity + 1 : 0;
                    multiplicitiesByName.put(name, newMultiplicity);
                    TreeElement childTreeElement = new TreeElementParser(this.parser, newMultiplicity, this.instanceId).parse();
                    element.addChild(childTreeElement);
                    continue block6;
                }
                case 3: {
                    return element;
                }
                case 4: {
                    element.setValue(new UncastData(this.parser.getText().trim()));
                    continue block6;
                }
            }
            throw new InvalidStructureException("Exception while trying to parse an XML Tree, got something other than tags and text", this.parser);
        }
        return element;
    }
}

