/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapMapPoly
extends ExternalizableWrapper {
    public ExternalizableWrapper keyType;
    public boolean ordered;

    public ExtWrapMapPoly(HashMap val) {
        this(val, null);
    }

    public ExtWrapMapPoly(HashMap val, ExternalizableWrapper keyType) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.val = val;
        this.keyType = keyType;
        this.ordered = val instanceof OrderedMap;
    }

    public ExtWrapMapPoly() {
    }

    public ExtWrapMapPoly(Class keyType) {
        this(keyType, false);
    }

    public ExtWrapMapPoly(ExternalizableWrapper keyType) {
        this(keyType, false);
    }

    public ExtWrapMapPoly(Class keyType, boolean ordered) {
        this(new ExtWrapBase(keyType), ordered);
    }

    public ExtWrapMapPoly(ExternalizableWrapper keyType, boolean ordered) {
        if (keyType == null) {
            throw new NullPointerException();
        }
        this.keyType = keyType;
        this.ordered = ordered;
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapMapPoly((HashMap)val, this.keyType);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        HashMap h = this.ordered ? new OrderedMap() : new HashMap();
        long size = ExtUtil.readNumeric(in);
        int i = 0;
        while ((long)i < size) {
            Object key = ExtUtil.read(in, this.keyType, pf);
            Object elem = ExtUtil.read(in, new ExtWrapTagged(), pf);
            h.put(key, elem);
            ++i;
        }
        this.val = h;
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        HashMap h = (HashMap)this.val;
        ExtUtil.writeNumeric(out, h.size());
        for (Object key : h.keySet()) {
            Object elem = h.get(key);
            ExtUtil.write(out, this.keyType == null ? key : this.keyType.clone(key));
            ExtUtil.write(out, new ExtWrapTagged(elem));
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.ordered = ExtUtil.readBool(in);
        this.keyType = ExtWrapTagged.readTag(in, pf);
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) throws IOException {
        HashMap h = (HashMap)this.val;
        ExtUtil.writeBool(out, this.ordered);
        ExternalizableWrapper keyTagObj = this.keyType == null ? (h.size() == 0 ? new Object() : h.keySet().iterator().next()) : this.keyType;
        ExtWrapTagged.writeTag(out, keyTagObj);
    }
}

