/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapList
extends ExternalizableWrapper {
    public ExternalizableWrapper type;
    private boolean sealed;

    public ExtWrapList(List val) {
        this(val, null);
    }

    public ExtWrapList(List val, ExternalizableWrapper type) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.val = val;
        this.type = type;
        this.sealed = false;
    }

    public ExtWrapList() {
        this.sealed = false;
    }

    public ExtWrapList(Class type) {
        this(type, false);
    }

    public ExtWrapList(Class type, boolean sealed) {
        this.type = new ExtWrapBase(type);
        this.sealed = sealed;
    }

    public ExtWrapList(ExternalizableWrapper type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.sealed = false;
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapList((List)val, this.type);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        if (!this.sealed) {
            long size = ExtUtil.readNumeric(in);
            ArrayList<Object> v = new ArrayList<Object>((int)size);
            int i = 0;
            while ((long)i < size) {
                v.add(ExtUtil.read(in, this.type, pf));
                ++i;
            }
            this.val = v;
        } else {
            int size = (int)ExtUtil.readNumeric(in);
            Object[] theval = new Object[size];
            for (int i = 0; i < size; ++i) {
                theval[i] = ExtUtil.read(in, this.type, pf);
            }
            this.val = theval;
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        List v = (List)this.val;
        ExtUtil.writeNumeric(out, v.size());
        for (int i = 0; i < v.size(); ++i) {
            ExtUtil.write(out, this.type == null ? v.get(i) : this.type.clone(v.get(i)));
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.type = ExtWrapTagged.readTag(in, pf);
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) throws IOException {
        List v = (List)this.val;
        Object tagObj = this.type == null ? (v.size() == 0 ? new Object() : v.get(0)) : this.type;
        ExtWrapTagged.writeTag(out, tagObj);
    }
}

