/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.services.locale.Localization;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.properties.IPropertyRules;

public class JavaRosaPropertyRules
implements IPropertyRules {
    HashMap<String, ArrayList<String>> rules = new HashMap();
    ArrayList<String> readOnlyProperties = new ArrayList(2);
    public static final String DEVICE_ID_PROPERTY = "DeviceID";
    public static final String CURRENT_LOCALE = "cur_locale";
    public static final String LOGS_ENABLED = "logenabled";
    public static final String LOGS_ENABLED_YES = "Enabled";
    public static final String LOGS_ENABLED_NO = "Disabled";
    public static final String OPENROSA_API_LEVEL = "jr_openrosa_api";

    public JavaRosaPropertyRules() {
        this.rules.put(DEVICE_ID_PROPERTY, new ArrayList(1));
        ArrayList<String> logs = new ArrayList<String>(2);
        logs.add(LOGS_ENABLED_NO);
        logs.add(LOGS_ENABLED_YES);
        this.rules.put(LOGS_ENABLED, logs);
        this.rules.put(CURRENT_LOCALE, new ArrayList(1));
        this.rules.put(OPENROSA_API_LEVEL, new ArrayList(1));
        this.readOnlyProperties.add(DEVICE_ID_PROPERTY);
        this.readOnlyProperties.add(OPENROSA_API_LEVEL);
    }

    public ArrayList<String> allowableValues(String propertyName) {
        if (CURRENT_LOCALE.equals(propertyName)) {
            Localizer l = Localization.getGlobalLocalizerAdvanced();
            String[] locales = l.getAvailableLocales();
            ArrayList<String> v = new ArrayList<String>(locales.length);
            for (String locale : locales) {
                v.add(locale);
            }
            return v;
        }
        return this.rules.get(propertyName);
    }

    @Override
    public boolean checkValueAllowed(String propertyName, String potentialValue) {
        if (CURRENT_LOCALE.equals(propertyName)) {
            return Localization.getGlobalLocalizerAdvanced().hasLocale(potentialValue);
        }
        ArrayList<String> prop = this.rules.get(propertyName);
        if (prop.size() != 0) {
            if (prop.size() == 1 && this.checkPropertyAllowed(prop.get(0))) {
                return PropertyManager.__().getProperty(prop.get(0)).contains(potentialValue);
            }
            return this.rules.get(propertyName).contains(potentialValue);
        }
        return true;
    }

    public ArrayList<String> allowableProperties() {
        Set<String> keys = this.rules.keySet();
        ArrayList<String> propList = new ArrayList<String>(keys);
        return propList;
    }

    @Override
    public boolean checkPropertyAllowed(String propertyName) {
        return this.rules.containsKey(propertyName);
    }

    @Override
    public boolean checkPropertyUserReadOnly(String propertyName) {
        return this.readOnlyProperties.contains(propertyName);
    }

    @Override
    public String getHumanReadableDescription(String propertyName) {
        if (DEVICE_ID_PROPERTY.equals(propertyName)) {
            return "Unique Device ID";
        }
        if (LOGS_ENABLED.equals(propertyName)) {
            return "Device Logging";
        }
        if (CURRENT_LOCALE.equals(propertyName)) {
            return Localization.get("settings.language");
        }
        if (OPENROSA_API_LEVEL.equals(propertyName)) {
            return "OpenRosa API Level";
        }
        return propertyName;
    }

    @Override
    public String getHumanReadableValue(String propertyName, String value) {
        String name;
        if (CURRENT_LOCALE.equals(propertyName) && (name = Localization.getGlobalLocalizerAdvanced().getText(value)) != null) {
            return name;
        }
        return value;
    }

    @Override
    public void handlePropertyChanges(String propertyName) {
        if (CURRENT_LOCALE.equals(propertyName)) {
            String locale = PropertyManager.__().getSingularProperty(propertyName);
            Localization.setLocale(locale);
        }
    }
}

