/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.util.ArrayList;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.PrefixedRootFactory;
import org.javarosa.core.reference.Reference;
import org.javarosa.core.reference.ReferenceFactory;
import org.javarosa.core.reference.RootTranslator;

public class ReferenceManager {
    private static ReferenceManager instance;
    private ArrayList<RootTranslator> translators = new ArrayList(0);
    private ArrayList<ReferenceFactory> factories = new ArrayList(0);
    private ArrayList<RootTranslator> sessionTranslators = new ArrayList(0);

    private ReferenceManager() {
    }

    public static ReferenceManager instance() {
        if (instance == null) {
            instance = new ReferenceManager();
        }
        return instance;
    }

    @Deprecated
    public static ReferenceManager __() {
        return ReferenceManager.instance();
    }

    public ReferenceFactory[] getFactories() {
        return this.translators.toArray(new ReferenceFactory[this.translators.size()]);
    }

    public void addRootTranslator(RootTranslator translator) {
        if (!this.translators.contains(translator)) {
            this.translators.add(translator);
        }
    }

    public void addReferenceFactory(ReferenceFactory factory) {
        if (!this.factories.contains(factory)) {
            this.factories.add(factory);
        }
    }

    public boolean removeReferenceFactory(ReferenceFactory factory) {
        return this.factories.remove(factory);
    }

    public Reference DeriveReference(String uri) throws InvalidReferenceException {
        return this.DeriveReference(uri, (String)null);
    }

    public Reference DeriveReference(String uri, Reference context) throws InvalidReferenceException {
        return this.DeriveReference(uri, context.getURI());
    }

    public Reference DeriveReference(String uri, String context) throws InvalidReferenceException {
        if (uri == null) {
            throw new InvalidReferenceException("Null references aren't valid", uri);
        }
        if (ReferenceManager.isRelative(uri)) {
            if (uri.startsWith("./")) {
                uri = uri.substring(2);
            }
            if (context == null) {
                throw new RuntimeException("Attempted to retrieve local reference with no context");
            }
            return this.derivingRoot(context).derive(uri, context);
        }
        return this.derivingRoot(uri).derive(uri);
    }

    public void addSessionRootTranslator(RootTranslator translator) {
        this.sessionTranslators.add(translator);
    }

    public void clearSession() {
        this.sessionTranslators.clear();
    }

    private ReferenceFactory derivingRoot(String uri) throws InvalidReferenceException {
        for (RootTranslator rootTranslator : this.sessionTranslators) {
            if (!rootTranslator.derives(uri)) continue;
            return rootTranslator;
        }
        for (RootTranslator rootTranslator : this.translators) {
            if (!rootTranslator.derives(uri)) continue;
            return rootTranslator;
        }
        for (ReferenceFactory referenceFactory : this.factories) {
            if (!referenceFactory.derives(uri)) continue;
            return referenceFactory;
        }
        throw new InvalidReferenceException(this.getPrettyPrintException(uri), uri);
    }

    private String getPrettyPrintException(String uri) {
        if (uri == null || uri.length() == 0) {
            return "Attempt to derive a blank reference";
        }
        try {
            int endOfRoot;
            String uriRoot = uri;
            String jrRefMessagePortion = "reference type";
            if (uri.indexOf("jr://") != -1) {
                uriRoot = uri.substring("jr://".length());
                jrRefMessagePortion = "javarosa jr:// reference root";
            }
            if ((endOfRoot = uriRoot.indexOf("://") + "://".length()) == "://".length() - 1) {
                endOfRoot = uriRoot.indexOf("/");
            }
            if (endOfRoot != -1) {
                uriRoot = uriRoot.substring(0, endOfRoot);
            }
            String message = "The reference \"" + uri + "\" was invalid and couldn't be understood. The " + jrRefMessagePortion + " \"" + uriRoot + "\" is not available on this system and may have been mis-typed. Some available roots: ";
            for (RootTranslator rootTranslator : this.sessionTranslators) {
                message = message + "\n" + rootTranslator.prefix;
            }
            for (RootTranslator rootTranslator : this.translators) {
                message = message + "\n" + rootTranslator.prefix;
            }
            for (ReferenceFactory referenceFactory : this.factories) {
                try {
                    if (referenceFactory instanceof PrefixedRootFactory) {
                        for (String rootName : ((PrefixedRootFactory)referenceFactory).roots) {
                            message = message + "\n" + rootName;
                        }
                        continue;
                    }
                    message = message + "\n" + referenceFactory.derive("").getURI();
                }
                catch (Exception exception) {}
            }
            return message;
        }
        catch (Exception e) {
            return "Couldn't process the reference " + uri + " . It may have been entered incorrectly. Note that this doesn't mean that this doesn't mean the file or location referenced couldn't be found, the reference itself was not understood.";
        }
    }

    public static boolean isRelative(String URI2) {
        return URI2.startsWith("./");
    }
}

