/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapNullable
extends ExternalizableWrapper {
    public ExternalizableWrapper type;

    public ExtWrapNullable(Object val) {
        this.val = val;
    }

    public ExtWrapNullable() {
    }

    public ExtWrapNullable(Class type) {
        this.type = new ExtWrapBase(type);
    }

    public ExtWrapNullable(ExternalizableWrapper type) {
        if (type instanceof ExtWrapNullable) {
            throw new IllegalArgumentException("Wrapping nullable with nullable is redundant");
        }
        if (type != null && type.isEmpty()) {
            this.type = type;
        } else {
            this.val = type;
        }
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapNullable(val);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.val = in.readBoolean() ? ExtUtil.read(in, this.type, pf) : null;
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        if (this.val != null) {
            out.writeBoolean(true);
            ExtUtil.write(out, this.val);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.type = ExtWrapTagged.readTag(in, pf);
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) throws IOException {
        ExtWrapTagged.writeTag(out, this.val == null ? new Object() : this.val);
    }
}

