/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.util.restorable;

import java.util.Date;
import java.util.List;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.IRecordFilter;
import org.javarosa.core.model.util.restorable.IXFormyFactory;
import org.javarosa.core.model.util.restorable.Restorable;
import org.javarosa.core.services.storage.IStorageIterator;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class RestoreUtils {
    public static final String RECORD_ID_TAG = "rec-id";
    public static IXFormyFactory xfFact;

    public static TreeReference ref(String refStr) {
        return xfFact.ref(refStr);
    }

    public static TreeReference absRef(String refStr, FormInstance dm) {
        TreeReference ref = RestoreUtils.ref(refStr);
        if (!ref.isAbsolute()) {
            ref = ref.parent(RestoreUtils.topRef(dm));
        }
        return ref;
    }

    public static TreeReference topRef(FormInstance dm) {
        return RestoreUtils.ref("/" + dm.getRoot().getName());
    }

    public static TreeReference childRef(String childPath, TreeReference parentRef) {
        return RestoreUtils.ref(childPath).parent(parentRef);
    }

    private static FormInstance newDataModel(String topTag) {
        FormInstance dm = new FormInstance();
        dm.addNode(RestoreUtils.ref("/" + topTag));
        return dm;
    }

    public static FormInstance createDataModel(Restorable r) {
        FormInstance dm = RestoreUtils.newDataModel(r.getRestorableType());
        if (r instanceof Persistable) {
            RestoreUtils.addData(dm, RECORD_ID_TAG, ((Persistable)((Object)r)).getID());
        }
        return dm;
    }

    public static FormInstance createRootDataModel(Restorable r) {
        FormInstance inst = RestoreUtils.createDataModel(r);
        inst.schema = "http://openrosa.org/backup";
        RestoreUtils.addData(inst, "timestamp", new Date(), 6);
        return inst;
    }

    public static void addData(FormInstance dm, String xpath, Object data) {
        RestoreUtils.addData(dm, xpath, data, RestoreUtils.getDataType(data));
    }

    public static void addData(FormInstance dm, String xpath, Object data, int dataType) {
        IAnswerData val;
        if (data == null) {
            dataType = -1;
        }
        switch (dataType) {
            case -1: {
                val = null;
                break;
            }
            case 1: {
                val = new StringData((String)data);
                break;
            }
            case 2: {
                val = new IntegerData((Integer)data);
                break;
            }
            case 13: {
                val = new LongData((Long)data);
                break;
            }
            case 3: {
                val = new DecimalData((Double)data);
                break;
            }
            case 9: {
                val = new StringData((Boolean)data != false ? "t" : "f");
                break;
            }
            case 4: {
                val = new DateData((Date)data);
                break;
            }
            case 6: {
                val = new DateTimeData((Date)data);
                break;
            }
            case 5: {
                val = new TimeData((Date)data);
                break;
            }
            case 8: {
                val = (MultipleItemsData)data;
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to handle data type [" + dataType + "]");
            }
        }
        TreeReference ref = RestoreUtils.absRef(xpath, dm);
        if (dm.addNode(ref, val, dataType) == null) {
            throw new RuntimeException("error setting value during object backup [" + xpath + "]");
        }
    }

    public static int getDataType(Object o) {
        int dataType = -1;
        if (o instanceof String) {
            dataType = 1;
        } else if (o instanceof Integer) {
            dataType = 2;
        } else if (o instanceof Long) {
            dataType = 13;
        } else if (o instanceof Float || o instanceof Double) {
            dataType = 3;
        } else if (o instanceof Date) {
            dataType = 4;
        } else if (o instanceof Boolean) {
            dataType = 9;
        } else if (o instanceof MultipleItemsData) {
            dataType = 8;
        }
        return dataType;
    }

    public static int getDataType(Class c) {
        int dataType;
        if (c == String.class) {
            dataType = 1;
        } else if (c == Integer.class) {
            dataType = 2;
        } else if (c == Long.class) {
            dataType = 13;
        } else if (c == Float.class || c == Double.class) {
            dataType = 3;
        } else if (c == Date.class) {
            dataType = 4;
        } else if (c == Boolean.class) {
            dataType = 1;
        } else {
            throw new RuntimeException("Can't handle data type " + c.getName());
        }
        return dataType;
    }

    public static Object getValue(String xpath, FormInstance tree) {
        return RestoreUtils.getValue(xpath, RestoreUtils.topRef(tree), tree);
    }

    public static Object getValue(String xpath, TreeReference context, FormInstance tree) {
        TreeElement node = (TreeElement)tree.resolveReference(RestoreUtils.ref(xpath).contextualize(context));
        if (node == null) {
            throw new RuntimeException("Could not find node [" + xpath + "] when parsing saved instance!");
        }
        if (node.isRelevant()) {
            IAnswerData val = node.getValue();
            return val == null ? null : val.getValue();
        }
        return null;
    }

    public static void applyDataType(FormInstance dm, String path, TreeReference parent, Class type) {
        RestoreUtils.applyDataType(dm, path, parent, RestoreUtils.getDataType(type));
    }

    public static void applyDataType(FormInstance dm, String path, TreeReference parent, int dataType) {
        TreeReference ref = RestoreUtils.childRef(path, parent);
        List<TreeReference> v = new EvaluationContext(dm).expandReference(ref);
        for (int i = 0; i < v.size(); ++i) {
            TreeElement e = (TreeElement)dm.resolveReference(v.get(i));
            e.setDataType(dataType);
        }
    }

    public static void templateChild(FormInstance dm, String prefixPath, TreeReference parent, Restorable r) {
        TreeReference childRef = prefixPath == null ? parent : RestoreUtils.childRef(prefixPath, parent);
        childRef = RestoreUtils.childRef(r.getRestorableType(), childRef);
        RestoreUtils.templateData(r, dm, childRef);
    }

    public static void templateData(Restorable r, FormInstance dm, TreeReference parent) {
        if (parent == null) {
            parent = RestoreUtils.topRef(dm);
            RestoreUtils.applyDataType(dm, "timestamp", parent, Date.class);
        }
        if (r instanceof Persistable) {
            RestoreUtils.applyDataType(dm, RECORD_ID_TAG, parent, Integer.class);
        }
        r.templateData(dm, parent);
    }

    public static void mergeDataModel(FormInstance parent, FormInstance child, String xpathParent) {
        RestoreUtils.mergeDataModel(parent, child, RestoreUtils.absRef(xpathParent, parent));
    }

    public static void mergeDataModel(FormInstance parent, FormInstance child, TreeReference parentRef) {
        TreeElement parentNode = (TreeElement)parent.resolveReference(parentRef);
        if (parentNode == null) {
            parentRef = parent.addNode(parentRef);
            parentNode = (TreeElement)parent.resolveReference(parentRef);
        }
        TreeElement childNode = child.getRoot();
        int mult = parentNode.getChildMultiplicity(childNode.getName());
        childNode.setMult(mult);
        parentNode.addChild(childNode);
    }

    public static FormInstance exportRMS(IStorageUtility storage, Class type, String parentTag, IRecordFilter filter) {
        if (!Externalizable.class.isAssignableFrom(type) || !Restorable.class.isAssignableFrom(type)) {
            return null;
        }
        FormInstance dm = RestoreUtils.newDataModel(parentTag);
        IStorageIterator ri = storage.iterate();
        while (ri.hasMore()) {
            Object obj = ri.nextRecord();
            if (filter != null && !filter.filter(obj)) continue;
            FormInstance objModel = ((Restorable)obj).exportData();
            RestoreUtils.mergeDataModel(dm, objModel, RestoreUtils.topRef(dm));
        }
        return dm;
    }

    public static FormInstance subDataModel(TreeElement top) {
        TreeElement newTop = top.shallowCopy();
        newTop.setMult(0);
        return new FormInstance(newTop);
    }

    public static void exportRMS(FormInstance parent, Class type, String grouperName, IStorageUtility storage, IRecordFilter filter) {
        FormInstance entities = RestoreUtils.exportRMS(storage, type, grouperName, filter);
        RestoreUtils.mergeDataModel(parent, entities, ".");
    }

    public static void importRMS(FormInstance dm, IStorageUtility storage, Class type, String path) {
        if (!Externalizable.class.isAssignableFrom(type) || !Restorable.class.isAssignableFrom(type)) {
            return;
        }
        boolean idMatters = Persistable.class.isAssignableFrom(type);
        String childName = ((Restorable)PrototypeFactory.getInstance(type)).getRestorableType();
        TreeElement e = (TreeElement)dm.resolveReference(RestoreUtils.absRef(path, dm));
        List<TreeElement> children = e.getChildrenWithName(childName);
        for (int i = 0; i < children.size(); ++i) {
            FormInstance child = RestoreUtils.subDataModel(children.get(i));
            Restorable inst = (Restorable)PrototypeFactory.getInstance(type);
            int recID = -1;
            if (idMatters) {
                recID = (Integer)RestoreUtils.getValue(RECORD_ID_TAG, child);
                ((Persistable)((Object)inst)).setID(recID);
            }
            inst.importData(child);
            try {
                if (idMatters) {
                    storage.write((Persistable)((Object)inst));
                    continue;
                }
                storage.add((Externalizable)((Object)inst));
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error importing RMS during restore! [" + type.getName() + ":" + recID + "]; " + ex.getMessage());
            }
        }
    }

    public static ByteArrayPayload dispatch(FormInstance dm) {
        return (ByteArrayPayload)xfFact.serializeInstance(dm);
    }

    public static FormInstance receive(byte[] payload, Class restorableType) {
        return xfFact.parseRestore(payload, restorableType);
    }

    public static boolean getBoolean(Object o) {
        if (o instanceof String) {
            String bool = (String)o;
            if ("t".equals(bool)) {
                return true;
            }
            if ("f".equals(bool)) {
                return false;
            }
            throw new RuntimeException("boolean string must be t or f");
        }
        throw new RuntimeException("booleans are encoded as strings");
    }
}

