/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.actions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.Action;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.Recalculate;
import org.javarosa.core.model.data.AnswerDataFactory;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class SetValueAction
extends Action {
    private TreeReference target;
    private XPathExpression value;
    private String explicitValue;

    public SetValueAction() {
    }

    public SetValueAction(TreeReference target, XPathExpression value) {
        super("setvalue");
        this.target = target;
        this.value = value;
    }

    public SetValueAction(TreeReference target, String explicitValue) {
        super("setvalue");
        this.target = target;
        this.explicitValue = explicitValue;
    }

    @Override
    public void processAction(FormDef model, TreeReference contextRef) {
        TreeReference qualifiedReference;
        TreeReference treeReference = qualifiedReference = contextRef == null ? this.target : this.target.contextualize(contextRef);
        if (contextRef != null && !contextRef.isParentOf(qualifiedReference, false)) {
            return;
        }
        EvaluationContext context = new EvaluationContext(model.getEvaluationContext(), qualifiedReference);
        Object result = this.explicitValue != null ? this.explicitValue : XPathFuncExpr.unpack(this.value.eval(model.getMainInstance(), context));
        AbstractTreeElement node = context.resolveReference(qualifiedReference);
        if (node == null) {
            throw new NullPointerException("Target of TreeReference " + qualifiedReference.toString(true) + " could not be resolved!");
        }
        int dataType = node.getDataType();
        IAnswerData val = Recalculate.wrapData(result, dataType);
        model.setValue(val == null ? null : AnswerDataFactory.templateByDataType(dataType).cast(val.uncast()), qualifiedReference, true);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.target = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.explicitValue = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        if (this.explicitValue == null) {
            this.value = (XPathExpression)ExtUtil.read(in, new ExtWrapTagged(), pf);
        }
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, this.target);
        ExtUtil.write(out, ExtUtil.emptyIfNull(this.explicitValue));
        if (this.explicitValue == null) {
            ExtUtil.write(out, new ExtWrapTagged(this.value));
        }
    }
}

