/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.util.Collection;
import org.kxml2.kdom.Element;

class ElementChildDeleter {
    private static final int NUM_DELETIONS_PERFORMANCE_THRESHOLD = 100;
    private static final int NUM_CHILDREN_PERFORMANCE_THRESHOLD = 100;

    ElementChildDeleter() {
    }

    static void delete(Element parent, Collection<Integer> removeIndexes) {
        if (ElementChildDeleter.highVolumeApproachNeeded(removeIndexes.size(), parent.getChildCount())) {
            ElementChildDeleter.rebuildChildrenAndAttributes(parent, removeIndexes);
        } else {
            ElementChildDeleter.removeDeletedChildren(parent, removeIndexes);
        }
    }

    private static boolean highVolumeApproachNeeded(int numDeletions, int numChildren) {
        return numDeletions > 100 || numChildren > 100;
    }

    private static void rebuildChildrenAndAttributes(Element parent, Collection<Integer> removeIndexes) {
        int i;
        int saveChildCount = 0;
        Object[] savedChildren = new Object[parent.getChildCount()];
        int[] savedChildTypes = new int[parent.getChildCount()];
        for (int i2 = 0; i2 < parent.getChildCount(); ++i2) {
            if (removeIndexes.contains(i2)) continue;
            savedChildren[saveChildCount] = parent.getChild(i2);
            savedChildTypes[saveChildCount++] = parent.getType(i2);
        }
        int attributeCount = parent.getAttributeCount();
        String[] attribNameSpaces = new String[attributeCount];
        String[] attribNames = new String[attributeCount];
        String[] attribValues = new String[attributeCount];
        for (i = 0; i < attributeCount; ++i) {
            attribNameSpaces[i] = parent.getAttributeNamespace(i);
            attribNames[i] = parent.getAttributeName(i);
            attribValues[i] = parent.getAttributeValue(i);
        }
        parent.clear();
        for (i = 0; i < saveChildCount; ++i) {
            parent.addChild(savedChildTypes[i], savedChildren[i]);
        }
        for (i = 0; i < attributeCount; ++i) {
            parent.setAttribute(attribNameSpaces[i], attribNames[i], attribValues[i]);
        }
    }

    private static void removeDeletedChildren(Element parent, Collection<Integer> removeIndexes) {
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            if (!removeIndexes.contains(i)) continue;
            parent.removeChild(i);
        }
    }
}

