/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.properties;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Property
implements Persistable,
IMetaData {
    private static final Logger logger = LoggerFactory.getLogger(Property.class);
    public String name;
    public List<String> value;
    public int recordId = -1;

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        StringBuilder b = new StringBuilder();
        byte[] inputarray = new byte[in.available()];
        in.readFully(inputarray);
        for (int i = 0; i < inputarray.length; ++i) {
            char c = (char)inputarray[i];
            b.append(c);
        }
        String fullString = b.toString();
        int nameindex = fullString.indexOf(",");
        this.value = new ArrayList<String>();
        if (nameindex == -1) {
            logger.warn("Property in RMS with no value: {}", (Object)fullString);
            this.name = fullString.substring(0, fullString.length());
        } else {
            this.name = fullString.substring(0, nameindex);
            String packedvalue = fullString.substring(fullString.indexOf(",") + 1, fullString.length());
            while (packedvalue.length() != 0) {
                int index = packedvalue.indexOf(",");
                if (index == -1) {
                    this.value.add(packedvalue);
                    packedvalue = "";
                    continue;
                }
                this.value.add(packedvalue.substring(0, index));
                packedvalue = packedvalue.substring(index + 1, packedvalue.length());
            }
        }
        in.close();
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        String outputString = this.name;
        for (String v : this.value) {
            outputString = outputString + "," + v;
        }
        for (int i = 0; i < outputString.length(); ++i) {
            out.writeByte((byte)outputString.charAt(i));
        }
        out.close();
    }

    @Override
    public void setID(int recordId) {
        this.recordId = recordId;
    }

    @Override
    public int getID() {
        return this.recordId;
    }

    @Override
    public HashMap<String, Object> getMetaData() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        String[] fields = this.getMetaDataFields();
        for (int i = 0; i < fields.length; ++i) {
            metadata.put(fields[i], this.getMetaData(fields[i]));
        }
        return metadata;
    }

    @Override
    public Object getMetaData(String fieldName) {
        if (fieldName.equals("NAME")) {
            return this.name;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String[] getMetaDataFields() {
        return new String[]{"NAME"};
    }
}

