/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.GeoTraceData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.MultiPointerAnswerData;
import org.javarosa.core.model.data.MultipleItemsData;
import org.javarosa.core.model.data.PointerAnswerData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.utils.DateUtils;
import org.kxml2.kdom.Element;

public class XFormAnswerDataSerializer
implements IAnswerDataSerializer {
    public static final String DELIMITER = " ";
    List<IAnswerDataSerializer> additionalSerializers = new ArrayList<IAnswerDataSerializer>(1);

    @Override
    public void registerAnswerSerializer(IAnswerDataSerializer ads) {
        this.additionalSerializers.add(ads);
    }

    @Override
    public boolean canSerialize(IAnswerData data) {
        return data instanceof StringData || data instanceof DateData || data instanceof TimeData || data instanceof MultipleItemsData || data instanceof SelectOneData || data instanceof IntegerData || data instanceof DecimalData || data instanceof PointerAnswerData || data instanceof MultiPointerAnswerData || data instanceof GeoPointData || data instanceof GeoTraceData || data instanceof GeoShapeData || data instanceof LongData || data instanceof DateTimeData || data instanceof UncastData;
    }

    public Object serializeAnswerData(UncastData data) {
        return data.getString();
    }

    public Object serializeAnswerData(StringData data) {
        return (String)data.getValue();
    }

    public Object serializeAnswerData(DateData data) {
        return DateUtils.formatDate((Date)data.getValue(), 1);
    }

    public Object serializeAnswerData(DateTimeData data) {
        return DateUtils.formatDateTime((Date)data.getValue(), 1);
    }

    public Object serializeAnswerData(TimeData data) {
        return DateUtils.formatTime((Date)data.getValue(), 1);
    }

    public Object serializeAnswerData(PointerAnswerData data) {
        IDataPointer pointer = (IDataPointer)data.getValue();
        return pointer.getDisplayText();
    }

    public Object serializeAnswerData(MultiPointerAnswerData data) {
        IDataPointer[] pointers = (IDataPointer[])data.getValue();
        if (pointers.length == 1) {
            return pointers[0].getDisplayText();
        }
        Element parent = new Element();
        for (int i = 0; i < pointers.length; ++i) {
            Element datael = new Element();
            datael.setName("data");
            datael.addChild(4, pointers[i].getDisplayText());
            parent.addChild(2, datael);
        }
        return parent;
    }

    public Object serializeAnswerData(MultipleItemsData data) {
        List selections = (List)data.getValue();
        StringBuilder selectString = new StringBuilder();
        for (Selection selection : selections) {
            if (selectString.length() > 0) {
                selectString.append(DELIMITER);
            }
            selectString.append(selection.getValue());
        }
        return selectString.toString();
    }

    public Object serializeAnswerData(SelectOneData data) {
        return ((Selection)data.getValue()).getValue();
    }

    public Object serializeAnswerData(IntegerData data) {
        return ((Integer)data.getValue()).toString();
    }

    public Object serializeAnswerData(LongData data) {
        return ((Long)data.getValue()).toString();
    }

    public Object serializeAnswerData(DecimalData data) {
        return ((Double)data.getValue()).toString();
    }

    public Object serializeAnswerData(GeoPointData data) {
        return data.getDisplayText();
    }

    public Object serializeAnswerData(GeoTraceData data) {
        return data.getDisplayText();
    }

    public Object serializeAnswerData(GeoShapeData data) {
        return data.getDisplayText();
    }

    public Object serializeAnswerData(BooleanData data) {
        if (((Boolean)data.getValue()).booleanValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public Object serializeAnswerData(IAnswerData data, int dataType) {
        for (IAnswerDataSerializer serializer : this.additionalSerializers) {
            if (!serializer.canSerialize(data)) continue;
            return serializer.serializeAnswerData(data, dataType);
        }
        Object result = this.serializeAnswerData(data);
        return result;
    }

    @Override
    public Object serializeAnswerData(IAnswerData data) {
        if (data instanceof StringData) {
            return this.serializeAnswerData((StringData)data);
        }
        if (data instanceof MultipleItemsData) {
            return this.serializeAnswerData((MultipleItemsData)data);
        }
        if (data instanceof SelectOneData) {
            return this.serializeAnswerData((SelectOneData)data);
        }
        if (data instanceof IntegerData) {
            return this.serializeAnswerData((IntegerData)data);
        }
        if (data instanceof LongData) {
            return this.serializeAnswerData((LongData)data);
        }
        if (data instanceof DecimalData) {
            return this.serializeAnswerData((DecimalData)data);
        }
        if (data instanceof DateData) {
            return this.serializeAnswerData((DateData)data);
        }
        if (data instanceof TimeData) {
            return this.serializeAnswerData((TimeData)data);
        }
        if (data instanceof PointerAnswerData) {
            return this.serializeAnswerData((PointerAnswerData)data);
        }
        if (data instanceof MultiPointerAnswerData) {
            return this.serializeAnswerData((MultiPointerAnswerData)data);
        }
        if (data instanceof GeoShapeData) {
            return this.serializeAnswerData((GeoShapeData)data);
        }
        if (data instanceof GeoTraceData) {
            return this.serializeAnswerData((GeoTraceData)data);
        }
        if (data instanceof GeoPointData) {
            return this.serializeAnswerData((GeoPointData)data);
        }
        if (data instanceof DateTimeData) {
            return this.serializeAnswerData((DateTimeData)data);
        }
        if (data instanceof BooleanData) {
            return this.serializeAnswerData((BooleanData)data);
        }
        if (data instanceof UncastData) {
            return this.serializeAnswerData((UncastData)data);
        }
        return null;
    }

    @Override
    public Boolean containsExternalData(IAnswerData data) {
        for (IAnswerDataSerializer serializer : this.additionalSerializers) {
            Boolean contains = serializer.containsExternalData(data);
            if (contains == null) continue;
            return contains;
        }
        if (data instanceof PointerAnswerData || data instanceof MultiPointerAnswerData) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public IDataPointer[] retrieveExternalDataPointer(IAnswerData data) {
        for (IAnswerDataSerializer serializer : this.additionalSerializers) {
            Boolean contains = serializer.containsExternalData(data);
            if (contains == null) continue;
            return serializer.retrieveExternalDataPointer(data);
        }
        if (data instanceof PointerAnswerData) {
            IDataPointer[] pointer = new IDataPointer[]{(IDataPointer)((PointerAnswerData)data).getValue()};
            return pointer;
        }
        if (data instanceof MultiPointerAnswerData) {
            return (IDataPointer[])((MultiPointerAnswerData)data).getValue();
        }
        return null;
    }
}

