/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class MultipleItemsData
implements IAnswerData {
    List<Selection> vs;

    public MultipleItemsData() {
    }

    public MultipleItemsData(List<Selection> vs) {
        this.setValue(vs);
    }

    @Override
    public IAnswerData clone() {
        ArrayList<Selection> v = new ArrayList<Selection>(this.vs.size());
        for (int i = 0; i < this.vs.size(); ++i) {
            v.add(this.vs.get(i).clone());
        }
        return new MultipleItemsData(v);
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        ArrayList<Selection> selections = new ArrayList<Selection>(((List)o).size());
        for (Object obj : (List)o) {
            selections.add((Selection)obj);
        }
        this.vs = selections;
    }

    @Override
    public Object getValue() {
        return new ArrayList<Selection>(this.vs);
    }

    @Override
    public String getDisplayText() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.vs.size(); ++i) {
            Selection s = this.vs.get(i);
            b.append(s.getValue());
            if (i >= this.vs.size() - 1) continue;
            b.append(", ");
        }
        return b.toString();
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.vs = (List)ExtUtil.read(in, new ExtWrapList(Selection.class), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapList(this.vs));
    }

    @Override
    public UncastData uncast() {
        StringBuilder selectString = new StringBuilder();
        for (Selection selection : this.vs) {
            if (selectString.length() > 0) {
                selectString.append(" ");
            }
            selectString.append(selection.getValue());
        }
        return new UncastData(selectString.toString());
    }

    @Override
    public MultipleItemsData cast(UncastData data) throws IllegalArgumentException {
        List<String> choices = DateUtils.split(data.value, " ", true);
        ArrayList<Selection> v = new ArrayList<Selection>(choices.size());
        for (String s : choices) {
            v.add(new Selection(s));
        }
        return new MultipleItemsData(v);
    }
}

